<?php
/**
* @file $id: index.php (17-12-2009)
* @pack Integral-Education
* @copyright Copyright (C) 2009 Integral-Group. All rights reserved.
* This package can be modified by the licencee, but the license is non-transferrable.
*/
if($_REQUEST['staticpath'])
{
	unset($_REQUEST['staticpath']);
	unset($staticpath);
}

if(!$staticpath)
	$staticpath=dirname(__FILE__) . '/';

$IgnoreFiles=Array(".DS_Store","CVS",'.svn');

// Start Session.
if($_REQUEST['servicefunction']=='SendChartData' && isset($_SERVER['HTTP_USER_AGENT']) && (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== false)) // since IE 6 & 7 have a bug which prevent the graphs from working under SSL
	session_cache_limiter('public');
session_start();

if(!$_SESSION['staticpath'])
	$_SESSION['staticpath'] = $staticpath;

require_once($staticpath."config.php");
require_once($staticpath."database.php");

// Load functions.
if($handle = opendir($staticpath."functions/"))
{
	while (false !== ($file = readdir($handle)))
	{
		// if filename isn't '.' '..' or in the Ignore list... load it.
		if(preg_match("/.*\.php$/i",$file))
		{
			$file = str_replace(".#","",$file);
			require_once($staticpath."functions/$file");
		}
	}
}

$language = Preferences('LANGUAGE');
$lang = substr($language,0,2);

if($lang=='ar' || $lang=='ur' || $lang=='fa' || $lang=='il' || $lang=='ku')
{
	$_SYSTEM['direction'] = 'RTL';
	define('ALIGN_RIGHT','left');
	define('ALIGN_LEFT','right');
}
else
{
	$_SYSTEM['direction'] = '';
	define('ALIGN_RIGHT','right');
	define('ALIGN_LEFT','left');
}
if($language=='en_US' && !function_exists('_'))
{
	function _($text)
	{
		return $text;
	}
}
elseif(function_exists('gettext'))
{
	$character_set  = 'utf-8';
	putenv("LANG=$language".'.UTF-8');
	putenv("LANGUAGE=$language".'.UTF-8');
	setlocale(LC_ALL, $language.'.UTF-8');

	$domain = 'messages';
	bindtextdomain($domain,$staticpath.'languages/');
	textdomain($domain);
	bind_textdomain_codeset($domain,$character_set);
}
else
{
	require_once($staticpath.'php-gettext/streams.php');
	require_once($staticpath.'php-gettext/gettext.php');

	$file = $staticpath.'languages/'.$language.'/LC_MESSAGES/messages.mo';

	if(file_exists($file))
	{
		$input = new FileReader($file);

		$PhpGettext = new gettext_reader($input);

		if(!function_exists('_'))
		{
			function _($text)
			{	global $PhpGettext;
				return $PhpGettext->translate($text);

			}
		}
	}
	elseif(!function_exists('_'))
	{
		function _($text)
		{
			return $text;
		}
	}
}

if(!$dont_header_for_logout && !$_SESSION['USER_NAME'] && !$_SESSION['STUDENT_ID'] && strpos($_SERVER['PHP_SELF'],'index.php')===false)
{
	if($_REQUEST['servicemod'])
	{
		$_SESSION['login_REQUEST'] = $_REQUEST;
		$_SESSION['login_POST'] = $_POST;
		if($_REQUEST['login_get_school_year'])
			$_SESSION['login_get_school_year'] = $_REQUEST['login_get_school_year'];
		if($_REQUEST['login_get_school_id'])
			$_SESSION['login_get_school_id'] = $_REQUEST['login_get_school_id'];
		if($_REQUEST['current_used_coursesection'])
			$_SESSION['current_used_coursesection'] = $_REQUEST['current_used_coursesection'];
	}

	header('Location: index.php');
	exit;
}

// TAKEN FROM MOODLE
// Just say no to link prefetching (Moz prefetching, Google Web Accelerator, others)
// http://www.google.com/webmasters/faq.html#prefetchblock
if(!empty($_SERVER['HTTP_X_moz']) && $_SERVER['HTTP_X_moz'] === 'prefetch')
{
	header($_SERVER['SERVER_PROTOCOL'] . ' 404 Prefetch Forbidden');
	trigger_error('Prefetch request forbidden.');
	exit;
}

function Basic($mode)
{	global $__SHOW_FOOTER,$_SYSTEM,$menu_divs,$spec_divs,$language,$staticpath,$DBEncoding;

	switch($mode)
	{
		case 'header_simple':
			if($language=='en_US')
				echo "<HTML>";
			else
				echo '<HTML lang="'.substr($language,3).'" xml:lang="'.substr($language,3).'">';
			echo "<HEAD><TITLE>"._('AJU Information System')."</TITLE>";			
			if($language!='en_US' || $DBEncoding=='UNICODE')
				echo '<meta http-equiv="Content-Type" content="text/html" charset="UTF-8" /><meta http-equiv="Content-Language" content="'.strtolower(str_replace('_','-',$language)).'" />';
//				echo '<meta http-equiv="X-UA-Compatible" content="IE=EmulateIE7" />';

		break;

		case 'header':
			Basic('header_simple');
//09.10.2009 mark for fix encode
			if(basename($_SERVER['PHP_SELF'])!='index.php')
				echo "<noscript><META http-equiv=REFRESH content='0';url=index.php?servicefunction=QUIT&reason=javascript' /></noscript>";
			if(!$_SESSION['jsmod_sess_id'])
	                {
		                $param = md5(rand());
		                $_SESSION['jsmod_sess_id'] = $param;
	                }
	                else
	                {
		                $param = $_SESSION['jsmod_sess_id'];
	                }
	                echo "<script language='JavaScript'>
	                function check_rb_state()
	                {
	                        if (rb_changed&&!rb_submit)
	                                return '"._('Your changes are not saved!')."';
			}                                                    
	                </script>";
	                if(!$_REQUEST['CREATEPDF'])
	                {
		                echo "<script language='JavaScript' src='js/modules_basic.js?js_sessid={$param}'></script>";
				echo "<script language='JavaScript' src='js/ajax.js'></script>";
	    	    	        echo "<script language='JavaScript'> runPutFocus=".($_SYSTEM['set_js_onchange']?'true':'false').";</script>";
            
			// avoid get_user() if not logged in
			if(Preferences('MENU')=='Top')
			{
				echo '<script language="javascript" src="js/menu_func.js"></script>';
			}
			else
				echo '<script language="javascript">function positionMenus() { return; }</script>';

				echo "<script language=\"JavaScript\" type=\"text/javascript\">";
				echo 'var highlightColor = "#'.Preferences('HIGHLIGHT').'";';
				echo "var checkbox_selected=\"\";";
	    			echo 'var currentMod=false;var openedMenu=false;var spec_oldmenu="text"';
			}
			if(basename($_SERVER['PHP_SELF'])=='index.php')
			{
				echo "
						if(parent.frames.length > 0)
						{
							parent.location.href = 'index.php?servicefunction=QUIT';
						}";
			}
			echo "</script>";

			echo "<link rel=stylesheet type=text/css href='style.css'>";
                        echo "
                            <!--[if IE]>
                                <style type=\"text/css\">
                                .GridOutput_fieldstyle {
                                    border-bottom: 1px solid #FBBE84;
                                }
                                </style>
                            <![endif]-->
                        ";
                        

                               if(Preferences('HIGHLIGHT')=='eaeae7' ||Preferences('HIGHLIGHT')=='cfc925'||Preferences('HIGHLIGHT')=='ee9fad'||Preferences('HIGHLIGHT')=='fbbe84')      
				   {
				echo "<style>.tdbg, .thbgtable th {color:black;}</style>";
			           }else{
				echo "<style>.tdbg, .thbgtable th {color:white;}</style>";
		        	   }




				echo "<style>";
				echo ".SelectedTopTab {";
				echo "background-image:url(themes/".Preferences('HIGHLIGHT_MENU')."/bg.png);";
				echo "background-position:top;";
				echo "}";
			/*	echo ".SelectedTopTab {";
					echo "background-image:url(images/themes/bg_top.jpg);";
				echo "}";*/
				echo ".StandartBGStyle {";
					echo "background-image:url(themes/".Preferences('HIGHLIGHT_MENU')."/bg_dark.png);";
				echo "}";
				echo ".Gridtable_header, #GridScalex_layer {";
				echo "background-image:url(themes/".Preferences('HIGHLIGHT_MENU')."/bg_dark2.png);";
                                echo "background-color:white;";
				echo "background-repeat:repeat-x;";
				echo "}";
				echo ".select-free";
				echo "{";
				echo "position:absolute;";
				echo "z-index:10;";
                                echo "overflow:hidden;/*must have*/";
					if(get_user('PROFILE')=='parent' || get_user('PROFILE')=='student')
							echo "/*must have for any value*/;";
						  else
							echo "/*width:209px;/*must have for any value*/;";
					echo "
				}
				.hilite{background-color:".Preferences('ROLLOVER_HIGHLIGHT')." !important;}
                .hilite1{background-color:".Preferences('HIGHLIGHT_WINDOW')." !important;}

				</style>
				<link rel=stylesheet type=text/css href='images/themes/stylesheet.css'>";
			if($_SYSTEM['direction']=='RTL')
				echo '<link rel="stylesheet" type="text/css" media="all" href="js/rtl.css" />';
			if(strpos($_REQUEST['servicemod'],'Food_Service')!==false)
				echo '<link rel="stylesheet" type="text/css" media="all" href="modules/Food_Service/management/theme/default/css/main.css" />';
	
			if(Preferences('LANGUAGE')=='ru_RU')
			{
			        echo '  <link rel="stylesheet" type="text/css" media="all" href="js/jscalendar/calendar-blue2.css" />
	    			<script type="text/javascript" src="js/jscalendar/calendar.js"></script>
				<script type="text/javascript" src="js/jscalendar/lang/calendar-ru-utf8.js"></script>
				<script type="text/javascript" src="js/jscalendar/calendar-setup.js"></script>
				<script type="text/javascript" src="js/tipmessage/main15.js"></script>';
			}else{
			        echo '  <link rel="stylesheet" type="text/css" media="all" href="js/jscalendar/calendar-blue2.css" />
	    			<script type="text/javascript" src="js/jscalendar/calendar.js"></script>
				<script type="text/javascript" src="js/jscalendar/lang/calendar-en.js"></script>
				<script type="text/javascript" src="js/jscalendar/calendar-setup.js"></script>
				<script type="text/javascript" src="js/tipmessage/main15.js"></script>';
			}
    			echo '</HEAD>';
//			echo '<DIV name="maincontent" id="maincontent">';
		break;
		case "footer":
			echo $menu_divs;
			echo $spec_divs;
			
			for($i=0;$i<count($_SYSTEM['PrepareDate']);$i++)
			{
				echo '<script type="text/javascript">
			Calendar.setup({
				monthField     :    "monthSelect'.$i.'",
				dayField       :    "daySelect'.$i.'",
				yearField      :    "yearSelect'.$i.'",
				ifFormat       :    "%d-%b-%y",
				button         :    "trigger'.$i.'",
				align          :    "Tl",
	    		        format         :    "'.$_SYSTEM['PrepareDate'][$i].'",
				singleClick    :    true
			});
		</script>';
			}
			echo "</DIV>";
			echo '</BODY>';
			echo '</HTML>';
		break;
	}
}
?>
