<?php
    $state_fields_prefixes = array(
        "COURSE_SECTIONS" => array(
            "CP_CHECKBOX_SETTING_{X}",
            "COURSES_CFIELD_{X}",
            "CFIELD_{X}",
            "CO_TEACHER{X}_CUSTOM1",
            "CO_TEACHER{X}_CUSTOM2",
            "CO_TEACHER{X}_CHECKBOX1",
            "CO_TEACHER{X}_PERMISSIONS",
            "CO_TEACHER{X}_REPORT_DOE"),
        "STUDENT_SCHEDULE" => array("CFIELD_{X}", "CFIELD_1{X}", "CFIELD_2{X}"),
        "COURSES" => array("CFIELD_{X}"),
        "STUDENT_REGISTRATION" => array("CFIELD_{X}"),
        "STUDENT_GRADES_CARD" => array("CFIELD_{X}")
    );
    $state_fields_max_vars = 45;

    function MakeStateFieldName($prefix, $i)
    {
        return str_replace("{X}",$i,$prefix);
    }

    function StateFieldsSet($program = "COURSE_SECTIONS")
    {
        global $_SYSTEM, $state_fields_prefixes, $state_fields_max_vars;

        $result = false;

        foreach($state_fields_prefixes[$program] as $prefix)
        {
            for($i=0;$i<=$state_fields_max_vars;$i++)
            {
                $result = $result || isset($_SYSTEM['config'][$program][MakeStateFieldName($prefix,$i)]);
            }
        }

        return $result;
    }

    function StateFieldsArray($program = "COURSE_SECTIONS", $visibility=false)
    {
        global $_SYSTEM, $state_fields_prefixes, $state_fields_max_vars;

        $result = array();

        if($visibility===false)
        {
    	    if(!$_SYSTEM['config'][$program]) $_SYSTEM['config'][$program] = array();
            foreach($_SYSTEM['config'][$program] as $column=>$name)
            {
            	// only show the field if it is in group1 and show_state_fields==true or it is in group2 and show_group2_fields===true
				if($program!='STUDENT_SCHEDULE' || ($_REQUEST['btn_show_adv_fields'] && !in_array($column,$_SYSTEM['config']['group2_fields'][$program])) 
						|| ($_SYSTEM['config']['group2'][$program] && $_REQUEST['btn_show_group2_fields'] && in_array($column,$_SYSTEM['config']['group2_fields'][$program])))
               		$result[$column] = $name;
            }
        }
        elseif($visibility=='always')
        {
            foreach($_SYSTEM['config'][$program] as $column=>$name)
            {
                if($_SYSTEM['config']['visible'][$program][$column]=='always')
                    $result[$column] = $name;
            }
        }

        return $result;
    }

    function StateFieldsFunctions($program = "COURSE_SECTIONS", $checkbox = "_make_state_field_checkbox", $select = "_make_state_field_select", $text = "_make_state_field_text", $date = "")
    {
        global $_SYSTEM, $state_fields_prefixes, $state_fields_max_vars;

        $result = array();

        foreach($state_fields_prefixes[$program] as $prefix)
        {
            for($i=0;$i<=$state_fields_max_vars;$i++)
            {
                if(isset($_SYSTEM['config'][$program][MakeStateFieldName($prefix,$i)]))
                {
                    $function = $text;

                    if(isset($_SYSTEM['config']['function'][$program][MakeStateFieldName($prefix,$i)]))
                        $function = $_SYSTEM['config']['function'][$program][MakeStateFieldName($prefix,$i)];
                    elseif(isset($_SYSTEM['config']['checkbox'][$program][MakeStateFieldName($prefix,$i)]) || strpos($prefix, "CHECKBOX")!==false)
                        $function = $checkbox;
                    elseif(isset($_SYSTEM['config']['select_options'][$program][MakeStateFieldName($prefix,$i)])||isset($_SYSTEM['config']['custom_select_options'][$program][MakeStateFieldName($prefix,$i)]))
                        $function = $select;
                    elseif(isset($_SYSTEM['config']['date'][$program][MakeStateFieldName($prefix,$i)]))
                        $function = $date;
                    $result[MakeStateFieldName($prefix,$i)] = $function;
                }
            }
        }

        return $result;
    }

    function StateFieldsSQL($program = "COURSE_SECTIONS", $alias="", $table="COURSE_SECTIONS")
    {
        global $_SYSTEM, $state_fields_prefixes, $state_fields_max_vars;

        if($alias) $alias .= ".";

        $SQL = "";
        
        if($table)
            $FIELDS = db_request(db_execute(db_limit("SELECT * FROM $table", 1)));
        else
            $FIELDS = null;

        foreach($state_fields_prefixes[$program] as $prefix)
        {
            for($i=0;$i<=$state_fields_max_vars;$i++)
            {
                if(isset($_SYSTEM['config'][$program][MakeStateFieldName($prefix,$i)]) && (!$FIELDS || array_key_exists(MakeStateFieldName($prefix,$i), $FIELDS[1])))
                {
                    $SQL .= $alias.MakeStateFieldName($prefix,$i).",";
                }
            }
        }

        return substr($SQL,0,-1);
    }

    function _make_state_field_text($value,$column)
    {
        global $THIS_array;

        return TextInput($value, $column);
    }

    function _make_state_field_checkbox($value,$column)
    {
        global $THIS_array;

        return CheckboxInput($value, $column);
    }

    function _make_state_field_select($value,$column)
    {
        global $THIS_array, $_SYSTEM;

        return SelectInput($value, $column, '', $_SYSTEM['config']['select_options'][$column], false, '', true, null, false);
    }
?>