<?php

/*
	show the existing referrals on the Add/Info Discipline Incident screen
*/

function _showIncidentReferrals($newIncident, $addNewReferral=false)
{
	if($_REQUEST['search_servicefunction']!='search')
		$_REQUEST['search_servicefunction'] = 'list';
	
	if($newIncident==true && !UserIncidentID())
		$delCheckBoxes = ',dr.student_id AS CHECKBOX';
	else 
	{
		$referrals_List = _getRefList(UserIncidentID());
		
		if($referrals_List)
		{
			foreach ($referrals_List as $ref_item)
			{
				$referrals .= $ref_item['REFERRAL_ID'].',';
			}
			
			$referrals = substr($referrals,0,-1); 				
		}
		else 
			$referrals = 0;
			
		$delCheckBoxes = '';
	}
		
	/*
		we need this on the Add Referrals Screen, when we want to add the students in the 
		existing incident
	*/	
	if($newIncident==true && $addNewReferral==true)
		$delCheckBoxes = ',dr.student_id AS CHECKBOX';
	
	$categories_array = db_request(db_execute("SELECT df.ID,du.TITLE FROM DISCIPLINE_REPORT_FIELDS df,DISCIPLINE_CUSTOM_FIELDS_ASG du WHERE df.DATA_TYPE!='textarea' AND du.SCHOOL_YEAR='".get_school_year()."' AND du.SCHOOL_ID='".get_school_id()."' AND du.DISCIPLINE_FIELD_ID=df.ID ORDER BY du.SORT_ORDER"));
	Widgets('all');
	
	$addition['SELECT'] = ',dr.*'.$delCheckBoxes;
	
	if(strpos($addition['FROM'],'STUDENT_DISCIPLINE_REPORTS')===false)
	{
		$addition['FROM'] .= ',STUDENT_DISCIPLINE_REPORTS dr ';
		$addition['WHERE'] .= ' AND dr.STUDENT_ID=ssm.STUDENT_ID AND dr.SCHOOL_YEAR=ssm.SCHOOL_YEAR AND dr.SCHOOL_ID=ssm.SCHOOL_ID ';
	}

	if(UserIncidentID() && !$addNewReferral)
		$addition['WHERE'] .= 'AND dr.ID IN ('.$referrals.')';

	/*
		we need this on the Add Referrals Screen, when we want to add the students in the 
		existing incident
	*/	
	if(UserIncidentID() && $addNewReferral && $newIncident)	
		$addition['WHERE'] .= 'AND dr.ID NOT IN ('.$referrals.')';
	
	$addition['ORDER_BY'] = 'dr.ENTRY_DATE DESC,s.LAST_NAME,s.FIRST_NAME,s.MIDDLE_NAME';

	$addition['columns_after'] = array('USER_ID'=>_('Reporter'),'ENTRY_DATE'=>_('Incident Date'));
	$addition['functions'] = array('USER_ID'=>'GetTeacher','ENTRY_DATE'=>'ProperDate');
	$i = 0;
	foreach($categories_array as $category)
	{
		$addition['columns_after']['CATEGORY_'.$category['ID']] = $category['TITLE'];
		$addition['functions']['CATEGORY_'.$category['ID']] = '_make';
		$i++;
		if($i<6)
			break;
	}
		
	$addition['new'] = true;
	//$addition['force_search'] = true;
	$addition['singular'] = _('Discipline Incidents');
	$addition['plural'] = _('Amount of Discipline Incidents');

	//if(!$newIncident)
		$addition['tabs_header'] = false;
	$_REQUEST['include_inactive'] = 'Y';
	
	if(UserIncidentID() && !$addNewReferral)
	{	
		$addition['link']['FULL_NAME']['link'] = 'modloader.php?servicemod=mod_discipline/DisListSubmittedReports.php';//#"modloader.php?servicemod=$_REQUEST[servicemod]";
		$addition['link']['FULL_NAME']['variables'] = array('discipline_ir_id'=>'ID');
		$addition['link']['remove']['link'] = "modloader.php?servicemod=mod_discipline/DisIncidentList.php&servicefunction=removeRef&incident_id=$_REQUEST[incident_id]";
		$addition['link']['remove']['variables'] = array('ref_id'=>'ID');
	}
	else 
	{ 
		$addition['functions']['CHECKBOX'] = '_makeChooseCheckbox';
	//	$addition['columns_before'] = array('CHECKBOX'=>'</A><INPUT type=checkbox value=Y name=controller onclick="checkAll(this.form,this.form.controller.checked,\'student\');CheckAll_hilite(this.form,this.form.controller.checked,\'student\')"><A>');
		$addition['columns_before'] = array('CHECKBOX'=>'</A><INPUT type=checkbox value=Y name=controller"><A>');

		$addition['options']['onclick']="check_clicked(this);";
		$addition['link']['FULL_NAME'] = false;
	}
	
	$addition['options']['filter'] = true;
	
	if((!$_REQUEST['discipline_ir_id'] && !$_REQUEST['servicefunction']) || $_REQUEST['servicefunction'] == 'add_incident_ref')
		Search('student_id',$addition); 
	
}

function _makeChooseCheckbox($value,$title)
{	global $THIS_array;

	return "<INPUT onchange='hl_cb(this)' type=checkbox name=student[".$THIS_array['ID']."] value=Y>";
}


function _make($value,$column)
{
	if(substr_count($value,'-')==2 && VerifyDate($value))
		$value = ProperDate($value);
	elseif(is_numeric($value))
		$value = ((strpos($value,'.')===false)?$value:rtrim(rtrim($value,'0'),'.'));
	return str_replace('||',',<BR>',trim($value,'|'));
}

function _getRefList($incId)
{
	if($incId)
		return $ref_array = db_request(db_execute("SELECT REFERRAL_ID FROM DISCIPLINE_INCIDENTS_ASG_REPORTS WHERE INCIDENT_ID = '".$incId."'"));
	else 
		return 0;
}


?>