<?php

/*
 +-----------------------------------------------------------------------+
 | Configuration file for database access                                |
 |                                                                       |
 | This file is part of the RoundCube Webmail client                     |
 | Copyright (C) 2005-2008, RoundCube Dev. - Switzerland                 |
 | Licensed under the GNU GPL                                            |
 |                                                                       |
 +-----------------------------------------------------------------------+

*/

$rcmail_config = array();

// PEAR database DSN for read/write operations
// format is db_provider://user:password@host/databse
// currently supported db_providers: mysql, mysqli, pgsql, sqlite, mssql

if($DBPassword)
	$DBPassword = ':'.$DBPassword;
//$rcmail_config['db_dsnw'] = 'pgsql://'.$DBUsername.$DBPassword.'@'.$DBServer.'/'.$DBName;
$rcmail_config['db_dsnw'] = 'mssql://'.$DBUsername.$DBPassword.'@'.$DBServer.'/'.$DBName;

// postgres example: 'pgsql://roundcube:pass@localhost/roundcubemail';
// sqlite example: 'sqlite://./sqlite.db?mode=0646';

// PEAR database DSN for read only operations (if empty write database will be used)
// useful for database replication
$rcmail_config['db_dsnr'] = '';

// database backend to use (only db or mdb2 are supported)
$rcmail_config['db_backend'] = 'db';

// maximum length of a query in bytes
$rcmail_config['db_max_length'] = 512000;  // 500K

// use persistent db-connections
// beware this will not "always" work as expected
// see: http://www.php.net/manual/en/features.persistent-connections.php
$rcmail_config['db_persistent'] = FALSE;


// you can define specific table names used to store webmail data
$rcmail_config['db_table_users'] = 'roundcube_users';

$rcmail_config['db_table_identities'] = 'roundcube_identities';

$rcmail_config['db_table_contacts'] = 'roundcube_contacts';

$rcmail_config['db_table_session'] = 'roundcube_session';

$rcmail_config['db_table_cache'] = 'roundcube_cache';

$rcmail_config['db_table_messages'] = 'roundcube_messages';


// you can define specific sequence names used in PostgreSQL
$rcmail_config['db_sequence_users'] = 'roundcube_user_ids';

$rcmail_config['db_sequence_identities'] = 'roundcube_identity_ids';

$rcmail_config['db_sequence_contacts'] = 'roundcube_contact_ids';

$rcmail_config['db_sequence_cache'] = 'roundcube_cache_ids';

$rcmail_config['db_sequence_messages'] = 'roundcube_message_ids';


// end db config file
?>
