<?php

/**
* Display an error message or multiple messages.
*
* example:
* <code>if(!$sch)
*	$error[]="School not provided.";
* if($count == 0)
* 	$error[]="Number of students is zero.";
* ErrorMessage($error);</code>
*
* @param array $errors An array of error messages to be displayed
* @param string $code The type of error message (default: error)
* 	If the code is "fatal," the error message will be displayed, and PHP execution of the program will be halted.  If the error code is anything other than "error," "warning," or "fatal," the errors will be treated as notices. 
*/
function ErrorMessage($errors,$code='error')
{
	if($errors) 
	{
		$return .= "<TABLE border=0><TR><TD align=".ALIGN_LEFT.">";
		if(count($errors)==1)
		{
			if($code=='error' || $code=='fatal')
				$return .= '<b><font color=#CC0000>'._('Error').':</font></b> ';
			elseif($code=='warning')
				$return .= '<b><font color=#CC0000>'._('Warning').':</font></b> ';
			elseif($code=='attention')
				$return .= '<b><font color=#00CC00>'._('Attention').':</font></b>';
			else
				$return .= '<b><font color=#00CC00>'._('Note ').':</font></b> ';
			$return .= '&nbsp;<span id=\"note\">'.(($errors[0])?$errors[0]:$errors[1]).'</span>';

		}
		else
		{
			if($code=='error' || $code=='fatal')
				$return .= "<b><font color=#CC0000>"._('Errors').":</font></b>";
			elseif($code=='warning')
				$return .= '<b><font color=#CC0000>'._('Warnings').':</font></b>';
			elseif($code=='attention')
				$return .= '<b><font color=#00CC00>'._('Attention').':</font></b>';
			else
				$return .= '<b><font color=#00CC00>'._('Note ').':</font></b>';
			$return .= '<BR>';
			foreach($errors as $value)
//					$return .= "<LI><font size=-1>$value</font></LI>";
					$return .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<font size=-1><span id=\"note\">$value</span></font><BR>";
			$return .= '';
		}
		$return .= "</TD></TR></TABLE><br>";
		
		if($code=='fatal')
		{
			echo $return;
			if(!$_REQUEST['CREATEPDF'])
				Basic('footer');
			exit;
		}
		
		return $return;
	}
}
?>
