<?php

function _localmakeGrade($value,$column)
{	global $_makeGrade,$THIS_array,$user_id,$course_section_id,$_SYSTEM,$grade_scale_id;

    if($THIS_array['STU_POINTS'] && $THIS_array['STU_POINTS']!='-1' && $THIS_array['POINTS'])
        $percent = $THIS_array['STU_POINTS'] / $THIS_array['POINTS'];
    elseif($THIS_array['STU_POINTS']=='-1')
        return _('Excluded');
    elseif(!$THIS_array['STU_POINTS'] && $THIS_array['STU_POINTS']!='0')
        return _('Not Graded');
    elseif($THIS_array['POINTS']==0)
        return _('Extra Credit');
    else
        $percent = '0';
    if($_makeGrade[$user_id]['ROUNDING']=='UP')
        $percent = ceil($percent*100);
    elseif($_makeGrade[$user_id]['ROUNDING']=='DOWN')
        $percent = floor($percent*100);
    else
        $percent = round($percent*100,0);

    //$grades = array('A+','A','A-','B+','B','B-','C+','C','C-','D+','D','D-','F');
    foreach($_SYSTEM['_makeGrade']['grades'] as $grade)
    {
        if($percent >= $_makeGrade[$user_id][$course_section_id.'-'.$grade['ID']] && is_numeric($_makeGrade[$user_id][$course_section_id.'-'.$grade['ID']]))
            return $percent.'% '.$grade['TITLE'];
    }
    // we'll only reach here if the student's percent doesn't apply to any grade
    return $percent.'%';
}

function GetCurrentGrade($CoursePeriodId)
{
	unset ($GLOBALS[THIS_array]);
	unset ($GLOBALS[total_points]);
	unset ($GLOBALS[student_points]);
	unset ($GLOBALS[current_array]);
	unset ($GLOBALS[_makeGrade]);
	unset ($GLOBALS[user_id]);
	unset ($GLOBALS[nonweighted_student_points]);
	unset ($GLOBALS[nonweighted_total_points]);
	unset ($GLOBALS[grade_scale_id]);
	unset ($GLOBALS[course_section_id]);

	global $THIS_array,$total_points,$student_points,$current_array,$_makeGrade,$user_id,$nonweighted_student_points,$nonweighted_total_points,$grade_scale_id,$course_section_id,$_SYSTEM;

    $CoursePeriodId += 0;

	$course_array = db_request(db_execute("SELECT c.COURSE_ID,c.TITLE,cp.TEACHER_ID,cp.GRADE_TYPE_ID FROM COURSES c,COURSE_SECTIONS cp WHERE cp.COURSE_ID=c.COURSE_ID AND cp.COURSE_SECTION_ID='".$CoursePeriodId."'"));

	$course_section_id = $CoursePeriodId;
	$course_id = $course_array[1]['COURSE_ID'];
	$course = $course_array[1]['TITLE'];
	$user_id = $course_array[1]['TEACHER_ID'];
	$grade_scale_id = $course_array[1]['GRADE_TYPE_ID'];

	if(!$_makeGrade[$user_id])
	{
		$username = db_request(db_execute("SELECT USERNAME FROM USERS WHERE USER_ID='$user_id'"));
		$config_array = db_request(db_execute("SELECT TITLE,VALUE FROM SYSTEM_USER_SETTINGS WHERE USERNAME='".$username[1]['USERNAME']."' AND PROGRAM='Gradebook'"),array(),array('TITLE'));
		if(count($config_array))
		{
			foreach($config_array as $title=>$value)
				$_makeGrade[$user_id][$title] = $value[1]['VALUE'];
		}
	}


	// ASSIGNMENT TYPES
	$sql = "SELECT ASSIGNMENT_TYPE_ID,TITLE,FINAL_GRADE_PERCENT FROM MARKBOOK_ASSIGNMENT_TYPES WHERE USER_ID='".$user_id."' AND COURSE_ID='".$course_id."' ORDER BY TITLE";
	$types_array = db_request(db_execute($sql));

	// TEACHER PREFS
	unset ($_SYSTEM['_makeGrade']['grades']);
	if(!$_SYSTEM['_makeGrade']['grades'])
		$_SYSTEM['_makeGrade']['grades'] = db_request(db_execute("SELECT TITLE,ID,DEFAULT_BREAKOFF FROM GRADES_CARD_SETTINGS WHERE SCALE_ID='".$grade_scale_id."' AND SCHOOL_YEAR='".get_school_year()."' AND SCHOOL_ID='".get_school_id()."' ORDER BY SORT_ORDER"));

	$custom = false;
	foreach($_SYSTEM['_makeGrade']['grades'] as $grade)
	{
		if($_makeGrade[$user_id][$course_section_id.'-'.$grade['ID']])
		{
			$custom = true;
			break;
		}
	}

	if(!$custom)
	{
		foreach($_SYSTEM['_makeGrade']['grades'] as $grade)
			$_makeGrade[$user_id][$course_section_id.'-'.$grade['ID']] = $grade['DEFAULT_BREAKOFF'];
	}

	$benchmarks_array = db_request(db_execute("SELECT ID,TITLE FROM GRADES_CARD_EVALUATION WHERE COURSE_ID='".$course_id."' AND COURSE_CREDIT_TITLE='".$course_credits."'"));
	if(count($benchmarks_array))
		$GO_column['BENCHMARKS'] = _('Benchmarks');

	$functions = array('STU_POINTS'=>'_makePoints','GRADE'=>'_makeGrade','ASSIGNED_DATE'=>'ProperDate','DUE_DATE'=>'ProperDate','TITLE'=>'_makeTitle','COMMENT'=>'_makeComment','BENCHMARKS'=>'_makeBenchmarks','CATEGORY_ID'=>'_makeCategory');
	//if($_REQUEST['servicemod']=='mod_grades/Grades.php' || $_REQUEST['servicemod']=='Users/TeacherWorkspace.php?include=mod_grades/Grades.php')
		$functions['STU_POINTS'] = '_makeGBGradesPoints';

//****************************************
//* Had to add a filter for the assignment_type because some assignment have categories from the wrong section
//****************************************
	$assignments_array = db_request(db_execute("SELECT gt.ASSIGNMENT_TYPE_ID,gt.FINAL_GRADE_PERCENT,ga.ASSIGNMENT_ID,
			ga.ASSIGNMENT_TYPE_ID AS CATEGORY_ID,ga.TITLE,ga.POINTS,ga.BENCHMARKS,ga.DUE_DATE,ga.ASSIGNED_DATE,
			gg.COMMENT,gg.HIGHLIGHT,gg.POINTS as STU_POINTS,NULL AS GRADE,ga.DESCRIPTION
		FROM MARKBOOK_ASSIGNMENT_TYPES gt,MARKBOOK_ASSIGNMENTS ga
		LEFT OUTER JOIN STUDENT_MARKBOOK_GRADES gg
			ON (gg.ASSIGNMENT_ID=ga.ASSIGNMENT_ID
				AND gg.STUDENT_ID='".get_student_id()."'
				AND gg.COURSE_SECTION_ID='".$course_section_id."')
		WHERE gt.ASSIGNMENT_TYPE_ID=ga.ASSIGNMENT_TYPE_ID
			AND ga.USER_ID='".$course_array[1]['TEACHER_ID']."'
			AND gt.COURSE_ID ='$course_id'
			AND (ga.COURSE_ID='$course_id'
				OR ga.COURSE_SECTION_ID='$course_section_id')
			AND ga.SCHOOL_TERM_ID='".get_user_school_term()."'
			AND ga.ASSIGNED_DATE<='".get_db_date('postgres')."'
			and (gt.assignment_type_id = ga.assignment_type_id )
			ORDER BY ga.DUE_DATE DESC,ga.ASSIGNED_DATE DESC,ga.ASSIGNMENT_ID DESC"),$functions);

	//return ($assignments_array[3]['POINTS']." ".$assignments_array[3]['STU_POINTS']);

	$grid_columns = array('TITLE'=>_('Assignment'),'STU_POINTS'=>_('Points'),'GRADE'=>_('Grade'),'COMMENT'=>_('Comments'),'ASSIGNED_DATE'=>_('Assigned Date'),'DUE_DATE'=>_('Expiring Date'),'CATEGORY_ID'=>_('Category'),'BENCHMARKS'=>_('Benchmarks'));
	if(count($types_array)<2)
	{
		unset($grid_columns['CATEGORY_ID']);
	}
	$benchmarks_array = db_request(db_execute("SELECT ID,TITLE FROM GRADES_CARD_EVALUATION WHERE COURSE_ID='".$course_id."' AND COURSE_CREDIT_TITLE='".$course_credits."' ORDER BY STANDARD_ID,SORT_ORDER"));
	if(!count($benchmarks_array))
		unset($grid_columns['BENCHMARKS']);

	if($_makeGrade[$user_id]['LETTER_GRADES_NOT_POINTS']=='Y')
	{
		unset($grid_columns['STU_POINTS']);
		unset($grid_columns['GRADE']);
		$grid_columns['COMMENT'] = _('Grade');
	}
	else
	{
		$sum_points = 0;
		if(!$student_points) $student_points = array();
		foreach($student_points as $assignment_type_id=>$points)
			$sum_points += $points / $total_points[$assignment_type_id];
//return $sum_points;
		if(count($types_array)>1 && $_makeGrade[$user_id]['WEIGHT']=='Y')
		{
			//$content = '<TABLE border=0 cellpadding=4 cellspacing=0>';
			//$content .= '<TR>';
			$content = '';
			$empty_type_adjustment_divisor = 1;
			foreach($types_array as $type)
			{
				if($total_points[$type['ASSIGNMENT_TYPE_ID']])
					$percent = $student_points[$type['ASSIGNMENT_TYPE_ID']] / $type['FINAL_GRADE_PERCENT'] / $total_points[$type['ASSIGNMENT_TYPE_ID']];
				else
					$percent = $student_points[$type['ASSIGNMENT_TYPE_ID']] / $type['FINAL_GRADE_PERCENT'];
				$THIS_array['STU_POINTS'] = $percent*100;
				$THIS_array['POINTS'] = 100;
				if(!$total_points[$type['ASSIGNMENT_TYPE_ID']])
				{
					$total_points[$type['ASSIGNMENT_TYPE_ID']] = '0';
					$empty_type_adjustment_divisor -= $type['FINAL_GRADE_PERCENT'];
				}
			}
			//$content .='<td>';
			if($_makeGrade[$user_id]['WEIGHT']!='Y')
			{
				$percent = $nonweighted_student_points / $nonweighted_total_points;
				$THIS_array['STU_POINTS'] = $percent*100;
				$THIS_array['POINTS'] = 100;
				$content .= ' &nbsp;'._localmakeGrade($percent,'');
			}
			else
			{
				if($empty_type_adjustment_divisor!=1 && $empty_type_adjustment_divisor)
					$sum_points /= $empty_type_adjustment_divisor;

				$THIS_array['STU_POINTS'] = $sum_points*100;
				$THIS_array['POINTS'] = 100;
				// echo _makeGrade($sum_points,'');
				$content .= _localmakeGrade($sum_points,'');
			}
			//$content .= '</TD>';
			//$content .= '</TR>';
			//$content .= '</TABLE>';
			return $content;
		}
		elseif(count($assignments_array)!=0)
		{
			$THIS_array = array('STU_POINTS'=>($sum_points*100),'POINTS'=>'100');
			return (_localmakeGrade($sum_points,''));
		}
	}
}

?>