(function ($) {
    $.fn.selectChain = function (options) {
        
        var defaults = {
            key: "id",
            value: "label",
            selected: "selected",
            NA: "Н/Д"
        };
        var SEL_NA = options.data.NA;
        var settings = $.extend({}, defaults, options);
        if (!(settings.target instanceof $)) settings.target = $(settings.target);
        return this.each(function () {
            var $$ = $(this);
            $$.change(function () {
                var data = null;
                if (typeof settings.data == 'string') {
                    data = settings.data + '&' + this.name + '=' + $$.val();
                } else if (typeof settings.data == 'object') {
                    data = settings.data;
                    data[this.name] = $$.val();
                }
                
                settings.target.empty();
                if($$.val() !== '')
                {
                        $.ajax({
                            url: settings.url,
                            data: data,
                            type: (settings.type || 'get'),
                            dataType: 'json',
                            success: function (j) {
                                var options = [], i = 0, o = null;
                                var sel;
                                for (i = 0; i < j.length; i++) {
                                    // required to get around IE bug (http://support.microsoft.com/?scid=kb%3Ben-us%3B276228)
                                    o = document.createElement("OPTION");
                                    o.value = typeof j[i] == 'object' ? j[i][settings.key] : j[i];
                                    o.selected = (j[i][settings.selected]=='true') ? 'selected' : '';
                                    o.text = (typeof j[i] == 'object')?j[i][settings.value] : j[i];
                                    settings.target.get(0).options[i] = o;
                                }
                                // hand control back to browser for a moment
                                settings.target.trigger('change');
                                //alert(settings.functions);
                                setTimeout(function () {
                                    settings.target
                                        .find("option:selected")
                                        //$('select[name='article_category'] > option[value='$category']').attr('selected','selected');
                                        .attr('selected', 'selected')
                                        .trigger('change')
                                        .parent('select');
                                }, 0);
                            },
                            error: function (xhr, desc, er) {
                                // add whatever debug you want here.
                                //alert(xhr + " " + desc + " " + er);
                            }
                        });
                    }
                    else
                    {
                        var options = [], i = 0, o = null;
                        o = document.createElement("OPTION");
                        o.value = '';
                        o.selected =  'selected';
                        o.text = SEL_NA;
                        
                        settings.target.get(0).options[0] = o;
                        setTimeout(function () {
                                    settings.target
                                        .find("option:selected")
                                        //$('select[name='article_category'] > option[value='$category']').attr('selected','selected');
                                        .attr('selected', 'selected')
                                        .trigger('change')
                                        .parent('select');
                                }, 0);
                    }
            });
        });
    };
})(jQuery);

function fnShowProps(obj, objName){
    var result = "";
    for (var i in obj) // обращение к свойствам объекта по индексу
        result += objName + "." + i + " = " + obj[i] + "<br />\n";
    return result;
}