--
-- PostgreSQL database dump
--

-- Dumped from database version 10.14 (Ubuntu 10.14-1.pgdg16.04+1)
-- Dumped by pg_dump version 10.14 (Ubuntu 10.14-1.pgdg16.04+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: activity_courses; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.activity_courses (
    id numeric NOT NULL,
    school_year numeric,
    school_id numeric,
    title character varying(100),
    start_date date,
    end_date date
);


ALTER TABLE public.activity_courses OWNER TO postgres;

--
-- Name: activity_courses_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.activity_courses_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.activity_courses_seq OWNER TO postgres;

--
-- Name: addons_log; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.addons_log (
    addon_title character varying(100),
    error_date date
);


ALTER TABLE public.addons_log OWNER TO postgres;

--
-- Name: address; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.address (
    address_id numeric NOT NULL,
    zipcode character varying(15),
    plus4 character varying(4),
    city character varying(60),
    state character varying(15),
    mail_city character varying(60),
    mail_state character varying(10),
    mail_zipcode character varying(10),
    address character varying(255),
    mail_address character varying(255),
    phone character varying(30),
    latitude numeric,
    longitude numeric,
    username character varying(50),
    password character varying(50),
    last_login timestamp without time zone,
    failed_login numeric,
    last_note_seen numeric,
    profile_id numeric,
    force_password_change character varying(1) DEFAULT 'N'::character varying,
    fed_region character varying(100),
    mail_fed_region character varying(100),
    settlement character varying(100),
    mail_settlement character varying(100)
);


ALTER TABLE public.address OWNER TO postgres;

--
-- Name: address_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.address_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.address_seq OWNER TO postgres;

--
-- Name: adodb_logsql_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.adodb_logsql_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.adodb_logsql_id_seq OWNER TO postgres;

--
-- Name: adodb_logsql; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.adodb_logsql (
    id bigint DEFAULT nextval('public.adodb_logsql_id_seq'::regclass) NOT NULL,
    created timestamp without time zone NOT NULL,
    sql0 character varying(250) DEFAULT ''::character varying NOT NULL,
    sql1 text,
    params text,
    tracer text,
    timer numeric(16,6) DEFAULT 0 NOT NULL
);


ALTER TABLE public.adodb_logsql OWNER TO postgres;

--
-- Name: assignment_config; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.assignment_config (
    assignment_id numeric NOT NULL,
    assignment_type_id numeric NOT NULL,
    title character varying(100) NOT NULL,
    assigned_date date NOT NULL,
    due_date date NOT NULL,
    points numeric,
    description character varying(1000),
    benchmarks character varying(100),
    school_term_id numeric
);


ALTER TABLE public.assignment_config OWNER TO postgres;

--
-- Name: assignment_config_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.assignment_config_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.assignment_config_seq OWNER TO postgres;

--
-- Name: assignment_type_config; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.assignment_type_config (
    assignment_type_id numeric NOT NULL,
    title character varying(100) NOT NULL,
    final_grade_percent numeric,
    school_id numeric,
    hcolor character varying(6)
);


ALTER TABLE public.assignment_type_config OWNER TO postgres;

--
-- Name: assignment_type_config_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.assignment_type_config_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.assignment_type_config_seq OWNER TO postgres;

--
-- Name: attendance_code_cats_settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.attendance_code_cats_settings (
    id numeric,
    school_year numeric,
    school_id numeric,
    title character varying(255),
    rollover_id numeric
);


ALTER TABLE public.attendance_code_cats_settings OWNER TO postgres;

--
-- Name: attendance_code_cats_settings_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.attendance_code_cats_settings_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.attendance_code_cats_settings_seq OWNER TO postgres;

--
-- Name: attendance_codes_settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.attendance_codes_settings (
    id numeric NOT NULL,
    school_year numeric,
    school_id numeric,
    title character varying(100),
    short_name character varying(10),
    type character varying(10),
    state_code character varying(1),
    default_code character varying(1),
    table_name numeric,
    sort_order numeric,
    is_daily_code character varying(1)
);


ALTER TABLE public.attendance_codes_settings OWNER TO postgres;

--
-- Name: attendance_codes_settings_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.attendance_codes_settings_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.attendance_codes_settings_seq OWNER TO postgres;

--
-- Name: attendance_teacher_filled; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.attendance_teacher_filled (
    user_id numeric NOT NULL,
    school_date date NOT NULL,
    school_period_id numeric NOT NULL
);


ALTER TABLE public.attendance_teacher_filled OWNER TO postgres;

--
-- Name: available_modprog; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.available_modprog (
    modname character varying(255),
    user_id numeric,
    profile_id numeric
);


ALTER TABLE public.available_modprog OWNER TO postgres;

--
-- Name: billing_student_fees; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.billing_student_fees (
    student_id numeric NOT NULL,
    assigned_date date,
    due_date date,
    comments character varying(255),
    id numeric,
    title character varying(255),
    amount numeric,
    school_id numeric,
    school_year numeric,
    waived_fee_id numeric,
    old_id numeric,
    paip character varying(1),
    debt double precision,
    categories numeric,
    balance_debt double precision,
    cancellation double precision,
    payment_category_id numeric
);


ALTER TABLE public.billing_student_fees OWNER TO postgres;

--
-- Name: billing_student_fees_categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.billing_student_fees_categories (
    id numeric NOT NULL,
    school_year numeric NOT NULL,
    school_id numeric NOT NULL,
    title character varying(255),
    system_name character varying(50)
);


ALTER TABLE public.billing_student_fees_categories OWNER TO postgres;

--
-- Name: billing_student_fees_categories_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.billing_student_fees_categories_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.billing_student_fees_categories_seq OWNER TO postgres;

--
-- Name: billing_student_fees_old; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.billing_student_fees_old (
    id numeric NOT NULL,
    category_id numeric NOT NULL,
    school_year numeric NOT NULL,
    school_id numeric NOT NULL,
    title character varying(255),
    amount numeric,
    apply_all bpchar,
    classlevel_id numeric,
    course_id numeric,
    course_credit_title character varying(10),
    activity_id numeric,
    student_field_id numeric,
    student_field_value character varying(255),
    student_id numeric,
    waived_fee_id numeric
);


ALTER TABLE public.billing_student_fees_old OWNER TO postgres;

--
-- Name: billing_student_fees_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.billing_student_fees_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.billing_student_fees_seq OWNER TO postgres;

--
-- Name: billing_student_payments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.billing_student_payments (
    id numeric NOT NULL,
    school_year numeric NOT NULL,
    school_id numeric NOT NULL,
    student_id numeric NOT NULL,
    amount numeric NOT NULL,
    payment_date date,
    comments character varying(255),
    refunded_payment_id numeric,
    lunch_payment character varying(1),
    transaction_id numeric,
    cancellation double precision
);


ALTER TABLE public.billing_student_payments OWNER TO postgres;

--
-- Name: billing_student_payments_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.billing_student_payments_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.billing_student_payments_seq OWNER TO postgres;

--
-- Name: block_ip_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.block_ip_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.block_ip_seq OWNER TO postgres;

--
-- Name: block_ip; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.block_ip (
    id numeric DEFAULT nextval('public.block_ip_seq'::regclass) NOT NULL,
    faled_login numeric,
    time_unlock timestamp without time zone,
    ip character varying(15) NOT NULL,
    date date NOT NULL,
    failed_login numeric
);


ALTER TABLE public.block_ip OWNER TO postgres;

--
-- Name: calendars_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.calendars_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.calendars_seq OWNER TO postgres;

--
-- Name: config; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.config (
    title character varying(100),
    school_year numeric,
    login character varying(3),
    version character varying(10)
);


ALTER TABLE public.config OWNER TO postgres;

--
-- Name: course_credits; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.course_credits (
    school_year numeric,
    school_id numeric,
    course_id numeric NOT NULL,
    course_credit_title character varying(10) NOT NULL,
    gpa_multiplier numeric,
    rollover_id numeric,
    year_fraction numeric,
    credits numeric,
    student_requestable character varying(1) DEFAULT 'Y'::character varying,
    student_scheduleable character varying(1) DEFAULT 'Y'::character varying,
    cw_checkbox_setting_1 character varying(1) DEFAULT 'Y'::character varying,
    cw_checkbox_setting_2 character varying(1) DEFAULT 'Y'::character varying,
    cw_checkbox_setting_3 character varying(1) DEFAULT 'Y'::character varying,
    cw_checkbox_setting_4 character varying(1) DEFAULT 'Y'::character varying,
    cw_checkbox_setting_5 character varying(1) DEFAULT 'Y'::character varying,
    does_gpa_1 character varying(1) DEFAULT 'Y'::character varying,
    does_gpa_2 character varying(1) DEFAULT 'Y'::character varying,
    does_gpa_3 character varying(1) DEFAULT 'Y'::character varying,
    does_gpa_4 character varying(1) DEFAULT 'Y'::character varying,
    does_gpa_5 character varying(1) DEFAULT 'Y'::character varying
);


ALTER TABLE public.course_credits OWNER TO postgres;

--
-- Name: course_sections; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.course_sections (
    school_year numeric NOT NULL,
    school_id numeric NOT NULL,
    course_section_id numeric NOT NULL,
    course_id numeric NOT NULL,
    course_credit_title character varying(10) NOT NULL,
    title character varying(100),
    short_name character varying(25),
    school_period_id numeric,
    mp character varying(3),
    school_term_id numeric,
    teacher_id numeric,
    room character varying(10),
    total_seats numeric,
    filled_seats numeric,
    does_attendance character varying(1),
    does_grades character varying(1),
    does_gpa character varying(1),
    gender_restriction character varying(1),
    house_restriction character varying(1),
    credits character varying(4),
    availability numeric,
    rollover_id numeric,
    parent_id numeric,
    days character varying(20),
    calendar_id numeric,
    grade_type_id numeric,
    does_gpa_1 character varying(1),
    does_gpa_2 character varying(1),
    does_gpa_3 character varying(1),
    does_gpa_4 character varying(1),
    does_gpa_5 character varying(1),
    cp_checkbox_setting_1 character varying(1),
    cp_checkbox_setting_2 character varying(1),
    cp_checkbox_setting_3 character varying(1),
    cp_checkbox_setting_4 character varying(1),
    cfield_1 character varying(255),
    cfield_2 character varying(255),
    cfield_3 character varying(255),
    cfield_4 character varying(255),
    cfield_5 character varying(255),
    cfield_6 character varying(255),
    cfield_25 character varying(255),
    co_teacher_id1 numeric,
    co_teacher_id2 numeric,
    co_teacher_id3 numeric,
    co_teacher_id4 numeric,
    co_teacher_id5 numeric,
    co_teacher_id6 numeric,
    co_teacher_id7 numeric,
    co_teacher_id8 numeric,
    co_teacher_id9 numeric,
    co_teacher_id10 numeric,
    co_teacher1_custom1 character varying(255),
    co_teacher2_custom1 character varying(255),
    co_teacher3_custom1 character varying(255),
    co_teacher4_custom1 character varying(255),
    co_teacher5_custom1 character varying(255),
    co_teacher6_custom1 character varying(255),
    co_teacher7_custom1 character varying(255),
    co_teacher8_custom1 character varying(255),
    co_teacher9_custom1 character varying(255),
    co_teacher10_custom1 character varying(255),
    co_teacher1_custom2 character varying(255),
    co_teacher2_custom2 character varying(255),
    co_teacher3_custom2 character varying(255),
    co_teacher4_custom2 character varying(255),
    co_teacher5_custom2 character varying(255),
    co_teacher6_custom2 character varying(255),
    co_teacher7_custom2 character varying(255),
    co_teacher8_custom2 character varying(255),
    co_teacher9_custom2 character varying(255),
    co_teacher10_custom2 character varying(255),
    co_teacher1_checkbox1 character varying(1),
    co_teacher2_checkbox1 character varying(1),
    co_teacher3_checkbox1 character varying(1),
    co_teacher4_checkbox1 character varying(1),
    co_teacher5_checkbox1 character varying(1),
    co_teacher6_checkbox1 character varying(1),
    co_teacher7_checkbox1 character varying(1),
    co_teacher8_checkbox1 character varying(1),
    co_teacher9_checkbox1 character varying(1),
    co_teacher10_checkbox1 character varying(1),
    cp_checkbox_setting_6 character varying(1),
    cp_checkbox_setting_7 character varying(1),
    cp_checkbox_setting_8 character varying(1),
    co_teacher1_permissions character varying(1),
    co_teacher2_permissions character varying(1),
    co_teacher3_permissions character varying(1),
    co_teacher4_permissions character varying(1),
    co_teacher5_permissions character varying(1),
    co_teacher6_permissions character varying(1),
    co_teacher7_permissions character varying(1),
    co_teacher8_permissions character varying(1),
    co_teacher9_permissions character varying(1),
    co_teacher10_permissions character varying(1),
    co_teacher1_report_doe character varying(1),
    co_teacher2_report_doe character varying(1),
    co_teacher3_report_doe character varying(1),
    co_teacher4_report_doe character varying(1),
    co_teacher5_report_doe character varying(1),
    co_teacher6_report_doe character varying(1),
    co_teacher7_report_doe character varying(1),
    co_teacher8_report_doe character varying(1),
    co_teacher9_report_doe character varying(1),
    co_teacher10_report_doe character varying(1),
    merge_id character varying(1000),
    week character varying(1)
);


ALTER TABLE public.course_sections OWNER TO postgres;

--
-- Name: course_sections_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.course_sections_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.course_sections_seq OWNER TO postgres;

--
-- Name: course_subjects; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.course_subjects (
    school_year numeric,
    school_id numeric,
    subject_id numeric NOT NULL,
    title character varying(100),
    short_name character varying(25),
    rollover_id numeric
);


ALTER TABLE public.course_subjects OWNER TO postgres;

--
-- Name: course_subjects_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.course_subjects_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.course_subjects_seq OWNER TO postgres;

--
-- Name: courses; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.courses (
    school_year numeric NOT NULL,
    course_id numeric NOT NULL,
    subject_id numeric NOT NULL,
    school_id numeric NOT NULL,
    grade_level numeric,
    title character varying(100),
    short_name character varying(25),
    rollover_id numeric,
    grad_subject_id numeric,
    prerequisites character varying(255),
    cfield_1 character varying(255),
    cfield_2 character varying(255),
    mp character varying(10),
    comments character varying(255)
);


ALTER TABLE public.courses OWNER TO postgres;

--
-- Name: courses_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.courses_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.courses_seq OWNER TO postgres;

--
-- Name: delivery_group_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.delivery_group_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.delivery_group_seq OWNER TO postgres;

--
-- Name: delivery_group; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.delivery_group (
    id numeric DEFAULT nextval('public.delivery_group_seq'::regclass) NOT NULL,
    title character varying(255),
    short_name character varying(20),
    sort_order numeric,
    user_id numeric,
    shared character varying(1)
);


ALTER TABLE public.delivery_group OWNER TO postgres;

--
-- Name: discipline_custom_fields_asg; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.discipline_custom_fields_asg (
    id numeric NOT NULL,
    discipline_field_id numeric NOT NULL,
    school_year numeric NOT NULL,
    school_id numeric NOT NULL,
    title character varying(255),
    select_options character varying(10000),
    sort_order numeric,
    select_codes character varying(10000),
    user_type character varying(10)
);


ALTER TABLE public.discipline_custom_fields_asg OWNER TO postgres;

--
-- Name: discipline_custom_fields_asg_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.discipline_custom_fields_asg_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.discipline_custom_fields_asg_seq OWNER TO postgres;

--
-- Name: discipline_incident_categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.discipline_incident_categories (
    id numeric NOT NULL,
    title character varying(100),
    allow_teacher_modify character varying(1),
    sort_order numeric,
    columns numeric
);


ALTER TABLE public.discipline_incident_categories OWNER TO postgres;

--
-- Name: discipline_incident_categories_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.discipline_incident_categories_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.discipline_incident_categories_seq OWNER TO postgres;

--
-- Name: discipline_incident_fields; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.discipline_incident_fields (
    id numeric NOT NULL,
    type character varying(10),
    search character varying(1),
    select_options character varying(10000),
    category_id numeric,
    system_field character(1),
    default_selection character varying(255),
    required character(1),
    max_length numeric,
    sort_order numeric,
    select_option_codes character varying(10000),
    select_option_default_code character varying(255),
    application character varying(1),
    title character varying(100),
    field_edits text,
    size numeric
);


ALTER TABLE public.discipline_incident_fields OWNER TO postgres;

--
-- Name: discipline_incidents_asg_reports; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.discipline_incidents_asg_reports (
    incident_id numeric,
    referral_id numeric
);


ALTER TABLE public.discipline_incidents_asg_reports OWNER TO postgres;

--
-- Name: discipline_incidents_fields_in_cats; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.discipline_incidents_fields_in_cats (
    field_id integer NOT NULL,
    category_id integer NOT NULL,
    sort_order integer NOT NULL
);


ALTER TABLE public.discipline_incidents_fields_in_cats OWNER TO postgres;

--
-- Name: discipline_report_fields; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.discipline_report_fields (
    id numeric NOT NULL,
    title character varying(255) NOT NULL,
    short_name character varying(20),
    data_type character varying(30) NOT NULL,
    column_name character varying(255) NOT NULL,
    user_type character varying(10)
);


ALTER TABLE public.discipline_report_fields OWNER TO postgres;

--
-- Name: discipline_report_fields_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.discipline_report_fields_seq
    START WITH 10
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.discipline_report_fields_seq OWNER TO postgres;

--
-- Name: docs_template_cells; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.docs_template_cells (
    id numeric,
    template_id numeric,
    type character varying(6),
    style character varying(10),
    border character varying(1),
    sort_order numeric,
    user_id numeric,
    servicemod character varying(255),
    left_cell character varying(10000),
    middle_cell character varying(10000),
    right_cell character varying(10000)
);


ALTER TABLE public.docs_template_cells OWNER TO postgres;

--
-- Name: docs_template_cells_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.docs_template_cells_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.docs_template_cells_seq OWNER TO postgres;

--
-- Name: docs_templates; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.docs_templates (
    id numeric NOT NULL,
    title character varying(255),
    sort_order numeric,
    school_id numeric,
    header character varying(20000),
    footer character varying(20000),
    default_sm character varying(255),
    default_users_sm character varying(255),
    orientation character varying(10),
    short_name character varying(100),
    user_id numeric,
    document_category_id numeric,
    doc_type character varying(15),
    use_inquiry character varying(1),
    servicemod character varying(255),
    page_breaks character varying(10),
    schools character varying(255),
    use_students character varying(1),
    school_dep character varying(1),
    school_year_dep character varying(1)
);


ALTER TABLE public.docs_templates OWNER TO postgres;

--
-- Name: docs_templates_categories_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.docs_templates_categories_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.docs_templates_categories_seq OWNER TO postgres;

--
-- Name: docs_templates_categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.docs_templates_categories (
    id numeric DEFAULT nextval('public.docs_templates_categories_seq'::regclass) NOT NULL,
    school_id numeric,
    title character varying(100),
    servicemod character varying(255),
    user_id numeric,
    short_name character varying(20),
    sort_order numeric,
    schools character varying(255)
);


ALTER TABLE public.docs_templates_categories OWNER TO postgres;

--
-- Name: docs_templates_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.docs_templates_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.docs_templates_seq OWNER TO postgres;

--
-- Name: evaluation_markpoints; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.evaluation_markpoints (
    school_year numeric(4,0),
    student_id numeric,
    score_id numeric,
    type character varying(9),
    score numeric
);


ALTER TABLE public.evaluation_markpoints OWNER TO postgres;

--
-- Name: evaluation_testparts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.evaluation_testparts (
    id numeric,
    school_year numeric(4,0),
    exam_id numeric,
    title character varying(100),
    short_name character varying(25),
    max_score numeric
);


ALTER TABLE public.evaluation_testparts OWNER TO postgres;

--
-- Name: evaluation_testparts_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.evaluation_testparts_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.evaluation_testparts_seq OWNER TO postgres;

--
-- Name: evaluation_tests; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.evaluation_tests (
    id numeric,
    school_year numeric(4,0),
    title character varying(100),
    short_name character varying(25),
    max_score numeric
);


ALTER TABLE public.evaluation_tests OWNER TO postgres;

--
-- Name: evaluation_tests_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.evaluation_tests_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.evaluation_tests_seq OWNER TO postgres;

--
-- Name: grades_card_comments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.grades_card_comments (
    id numeric NOT NULL,
    school_year numeric,
    school_id numeric,
    title character varying(100),
    sort_order numeric
);


ALTER TABLE public.grades_card_comments OWNER TO postgres;

--
-- Name: grades_card_comments_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.grades_card_comments_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.grades_card_comments_seq OWNER TO postgres;

--
-- Name: grades_card_evaluation; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.grades_card_evaluation (
    id numeric NOT NULL,
    school_year numeric NOT NULL,
    school_id numeric,
    subject_id numeric,
    course_id numeric,
    course_credit_title character varying(10),
    sort_order numeric,
    standard_id numeric,
    subtitle character varying(255),
    title character varying(255)
);


ALTER TABLE public.grades_card_evaluation OWNER TO postgres;

--
-- Name: grades_card_evaluation_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.grades_card_evaluation_seq
    START WITH 4
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.grades_card_evaluation_seq OWNER TO postgres;

--
-- Name: grades_card_settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.grades_card_settings (
    id numeric NOT NULL,
    school_year numeric,
    school_id numeric,
    title character varying(3),
    sort_order numeric,
    gpa_value numeric,
    default_breakoff numeric,
    scale_id numeric,
    credits character varying(1),
    weighted_gpa_value numeric,
    description character varying(100)
);


ALTER TABLE public.grades_card_settings OWNER TO postgres;

--
-- Name: grades_card_settings_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.grades_card_settings_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.grades_card_settings_seq OWNER TO postgres;

--
-- Name: grades_card_tests; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.grades_card_tests (
    id numeric,
    school_year numeric NOT NULL,
    school_id numeric,
    subject_id numeric,
    course_id numeric,
    course_credit_title character varying(10),
    title character varying(100),
    sort_order numeric,
    grading_scale_id numeric,
    rollover_id numeric,
    subtitle character varying(255)
);


ALTER TABLE public.grades_card_tests OWNER TO postgres;

--
-- Name: grades_card_tests_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.grades_card_tests_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.grades_card_tests_seq OWNER TO postgres;

--
-- Name: grades_card_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.grades_card_types (
    id numeric NOT NULL,
    school_year numeric,
    school_id numeric,
    title character varying(30),
    default_scale character varying(1),
    rollover_id numeric
);


ALTER TABLE public.grades_card_types OWNER TO postgres;

--
-- Name: grades_card_types_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.grades_card_types_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.grades_card_types_seq OWNER TO postgres;

--
-- Name: graduation_req_subjects; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.graduation_req_subjects (
    id numeric NOT NULL,
    school_id numeric,
    title character varying(100),
    sort_order numeric,
    credits numeric,
    short_name character varying(10)
);


ALTER TABLE public.graduation_req_subjects OWNER TO postgres;

--
-- Name: graduation_req_subjects_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.graduation_req_subjects_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.graduation_req_subjects_seq OWNER TO postgres;

--
-- Name: graduation_requirements; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.graduation_requirements (
    id numeric,
    title character varying(100),
    short_name character varying(25)
);


ALTER TABLE public.graduation_requirements OWNER TO postgres;

--
-- Name: graduation_rp_in_course_req; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.graduation_rp_in_course_req (
    program_id numeric,
    recomended_gradelevel character varying(2),
    title character varying(100),
    number_required numeric,
    courses text
);


ALTER TABLE public.graduation_rp_in_course_req OWNER TO postgres;

--
-- Name: graduation_rp_in_subjects; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.graduation_rp_in_subjects (
    program_id numeric,
    subject_id numeric,
    credits numeric
);


ALTER TABLE public.graduation_rp_in_subjects OWNER TO postgres;

--
-- Name: in_outbox_message_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.in_outbox_message_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.in_outbox_message_seq OWNER TO postgres;

--
-- Name: in_inbox_message; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.in_inbox_message (
    id numeric DEFAULT nextval('public.in_outbox_message_seq'::regclass) NOT NULL,
    from_user numeric NOT NULL,
    to_user numeric NOT NULL,
    title character varying(200) NOT NULL,
    msg text NOT NULL,
    date date NOT NULL,
    status numeric NOT NULL,
    to_user_profile character varying(50),
    from_user_profile character varying(50)
);


ALTER TABLE public.in_inbox_message OWNER TO postgres;

--
-- Name: in_inbox_message_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.in_inbox_message_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.in_inbox_message_seq OWNER TO postgres;

--
-- Name: in_outbox_message; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.in_outbox_message (
    id numeric DEFAULT nextval('public.in_outbox_message_seq'::regclass) NOT NULL,
    from_user numeric NOT NULL,
    to_users character varying(1000) NOT NULL,
    title character varying(200) NOT NULL,
    msg text NOT NULL,
    date date NOT NULL,
    to_user_profile character varying(50),
    from_user_profile character varying(50)
);


ALTER TABLE public.in_outbox_message OWNER TO postgres;

--
-- Name: info_saves; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.info_saves (
    id numeric,
    title character varying(100),
    url character varying(5000)
);


ALTER TABLE public.info_saves OWNER TO postgres;

--
-- Name: info_saves_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.info_saves_seq
    START WITH 5
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.info_saves_seq OWNER TO postgres;

--
-- Name: intermediate_report; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.intermediate_report (
    id numeric NOT NULL,
    title character varying(255),
    short_name character varying(40),
    gpavalue double precision,
    school_id numeric
);


ALTER TABLE public.intermediate_report OWNER TO postgres;

--
-- Name: lh_template_cells; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.lh_template_cells (
    id numeric,
    template_id numeric,
    type character varying(6),
    style character varying(10),
    border character varying(1),
    sort_order numeric,
    left_cell character varying(10000),
    middle_cell character varying(10000),
    right_cell character varying(10000)
);


ALTER TABLE public.lh_template_cells OWNER TO postgres;

--
-- Name: lh_template_cells_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.lh_template_cells_seq
    START WITH 13
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.lh_template_cells_seq OWNER TO postgres;

--
-- Name: lh_templates; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.lh_templates (
    id numeric NOT NULL,
    title character varying(255),
    sort_order numeric,
    school_id numeric,
    header character varying(20000),
    footer character varying(20000),
    default_program character varying(255),
    default_program_for_teachers character varying(255),
    orientation character varying(10),
    page_breaks character varying(10)
);


ALTER TABLE public.lh_templates OWNER TO postgres;

--
-- Name: lh_templates_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.lh_templates_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.lh_templates_seq OWNER TO postgres;

--
-- Name: listing_fields_settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.listing_fields_settings (
    student_id numeric NOT NULL,
    html_field_title character varying(15),
    field_name character varying(15),
    select_options text,
    select_codes text
);


ALTER TABLE public.listing_fields_settings OWNER TO postgres;

--
-- Name: login_history_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.login_history_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.login_history_seq OWNER TO postgres;

--
-- Name: login_history; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.login_history (
    id numeric DEFAULT nextval('public.login_history_seq'::regclass) NOT NULL,
    log_text character varying(1000),
    ip character varying(15),
    sucsess character varying(30),
    ldata timestamp without time zone NOT NULL,
    user_id numeric,
    request_method character varying(100),
    http_user_agent character varying(500),
    query_string character varying(1000),
    login character varying(100),
    profile character varying(30)
);


ALTER TABLE public.login_history OWNER TO postgres;

--
-- Name: lunch_period; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.lunch_period (
    student_id numeric,
    school_date date,
    school_period_id numeric,
    attendance_code numeric,
    attendance_teacher_code numeric,
    attendance_reason character varying(100),
    admin character varying(1),
    course_section_id numeric,
    school_term_id numeric,
    table_name numeric
);


ALTER TABLE public.lunch_period OWNER TO postgres;

--
-- Name: mailing_of_group_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mailing_of_group_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mailing_of_group_seq OWNER TO postgres;

--
-- Name: mailing_of_group; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mailing_of_group (
    id numeric DEFAULT nextval('public.mailing_of_group_seq'::regclass) NOT NULL,
    title character varying(200) NOT NULL,
    sort numeric,
    user_id numeric NOT NULL
);


ALTER TABLE public.mailing_of_group OWNER TO postgres;

--
-- Name: markbook_assignment_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.markbook_assignment_types (
    assignment_type_id numeric NOT NULL,
    user_id numeric,
    course_id numeric,
    title character varying(100),
    final_grade_percent numeric,
    hcolor character varying(6)
);


ALTER TABLE public.markbook_assignment_types OWNER TO postgres;

--
-- Name: markbook_assignment_types_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.markbook_assignment_types_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.markbook_assignment_types_seq OWNER TO postgres;

--
-- Name: markbook_assignments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.markbook_assignments (
    assignment_id numeric NOT NULL,
    user_id numeric,
    school_term_id numeric,
    course_section_id numeric,
    course_id numeric,
    assignment_type_id numeric,
    title character varying(100),
    assigned_date date,
    due_date date,
    points numeric,
    description character varying(1000),
    benchmarks character varying(100)
);


ALTER TABLE public.markbook_assignments OWNER TO postgres;

--
-- Name: markbook_assignments_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.markbook_assignments_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.markbook_assignments_seq OWNER TO postgres;

--
-- Name: markbook_teachers_filled; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.markbook_teachers_filled (
    user_id numeric NOT NULL,
    school_period_id numeric,
    school_term_id character varying(10),
    course_section_id numeric
);


ALTER TABLE public.markbook_teachers_filled OWNER TO postgres;

--
-- Name: mdl_analytics_models1; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_analytics_models1 (
    id bigint NOT NULL,
    enabled smallint DEFAULT 0 NOT NULL,
    trained smallint DEFAULT 0 NOT NULL,
    name character varying(1333),
    target character varying(255) DEFAULT ''::character varying NOT NULL,
    indicators text NOT NULL,
    timesplitting character varying(255),
    predictionsprocessor character varying(255),
    version bigint NOT NULL,
    contextids text,
    timecreated bigint,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL
);


ALTER TABLE public.mdl_analytics_models1 OWNER TO postgres;

--
-- Name: mdl_assignment_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assignment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assignment_id_seq OWNER TO postgres;

--
-- Name: mdl_assignment_submissions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assignment_submissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assignment_submissions_id_seq OWNER TO postgres;

--
-- Name: mdl_backup_config_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_backup_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_backup_config_id_seq OWNER TO postgres;

--
-- Name: mdl_backup_courses_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_backup_courses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_backup_courses_id_seq OWNER TO postgres;

--
-- Name: mdl_backup_files_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_backup_files_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_backup_files_id_seq OWNER TO postgres;

--
-- Name: mdl_backup_ids_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_backup_ids_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_backup_ids_id_seq OWNER TO postgres;

--
-- Name: mdl_backup_log_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_backup_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_backup_log_id_seq OWNER TO postgres;

--
-- Name: mdl_block_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_block_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_block_id_seq OWNER TO postgres;

--
-- Name: mdl_block_instance_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_block_instance_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_block_instance_id_seq OWNER TO postgres;

--
-- Name: mdl_block_pinned_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_block_pinned_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_block_pinned_id_seq OWNER TO postgres;

--
-- Name: mdl_block_rss_client_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_block_rss_client_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_block_rss_client_id_seq OWNER TO postgres;

--
-- Name: mdl_block_search_documents_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_block_search_documents_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_block_search_documents_id_seq OWNER TO postgres;

--
-- Name: mdl_cache_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_cache_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_cache_filters_id_seq OWNER TO postgres;

--
-- Name: mdl_cache_flags_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_cache_flags_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_cache_flags_id_seq OWNER TO postgres;

--
-- Name: mdl_cache_text_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_cache_text_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_cache_text_id_seq OWNER TO postgres;

--
-- Name: mdl_capabilities_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_capabilities_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_capabilities_id_seq OWNER TO postgres;

--
-- Name: mdl_chat_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_chat_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_chat_id_seq OWNER TO postgres;

--
-- Name: mdl_chat_messages_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_chat_messages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_chat_messages_id_seq OWNER TO postgres;

--
-- Name: mdl_chat_users_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_chat_users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_chat_users_id_seq OWNER TO postgres;

--
-- Name: mdl_choice_answers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_choice_answers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_choice_answers_id_seq OWNER TO postgres;

--
-- Name: mdl_choice_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_choice_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_choice_id_seq OWNER TO postgres;

--
-- Name: mdl_choice_options_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_choice_options_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_choice_options_id_seq OWNER TO postgres;

--
-- Name: mdl_config_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_config_id_seq OWNER TO postgres;

--
-- Name: mdl_config_plugins_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_config_plugins_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_config_plugins_id_seq OWNER TO postgres;

--
-- Name: mdl_context_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_context_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_context_id_seq OWNER TO postgres;

--
-- Name: mdl_course_allowed_modules_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_allowed_modules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_allowed_modules_id_seq OWNER TO postgres;

--
-- Name: mdl_course_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_categories_id_seq OWNER TO postgres;

--
-- Name: mdl_course_display_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_display_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_display_id_seq OWNER TO postgres;

--
-- Name: mdl_course_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_id_seq OWNER TO postgres;

--
-- Name: mdl_course_meta_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_meta_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_meta_id_seq OWNER TO postgres;

--
-- Name: mdl_course_modules_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_modules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_modules_id_seq OWNER TO postgres;

--
-- Name: mdl_course_request_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_request_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_request_id_seq OWNER TO postgres;

--
-- Name: mdl_course_sections_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_sections_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_sections_id_seq OWNER TO postgres;

--
-- Name: mdl_data_comments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_data_comments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_data_comments_id_seq OWNER TO postgres;

--
-- Name: mdl_data_content_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_data_content_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_data_content_id_seq OWNER TO postgres;

--
-- Name: mdl_data_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_data_fields_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_data_fields_id_seq OWNER TO postgres;

--
-- Name: mdl_data_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_data_id_seq OWNER TO postgres;

--
-- Name: mdl_data_ratings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_data_ratings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_data_ratings_id_seq OWNER TO postgres;

--
-- Name: mdl_data_records_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_data_records_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_data_records_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_authorize_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_authorize_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_authorize_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_authorize_refunds_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_authorize_refunds_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_authorize_refunds_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_paypal_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_paypal_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_paypal_id_seq OWNER TO postgres;

--
-- Name: mdl_event_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_event_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_event_id_seq OWNER TO postgres;

--
-- Name: mdl_events_handlers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_events_handlers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_events_handlers_id_seq OWNER TO postgres;

--
-- Name: mdl_events_queue_handlers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_events_queue_handlers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_events_queue_handlers_id_seq OWNER TO postgres;

--
-- Name: mdl_events_queue_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_events_queue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_events_queue_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_discussions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_discussions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_discussions_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_posts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_posts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_posts_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_queue_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_queue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_queue_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_ratings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_ratings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_ratings_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_read_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_read_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_read_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_subscriptions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_subscriptions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_subscriptions_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_track_prefs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_track_prefs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_track_prefs_id_seq OWNER TO postgres;

--
-- Name: mdl_glossary_alias_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_glossary_alias_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_glossary_alias_id_seq OWNER TO postgres;

--
-- Name: mdl_glossary_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_glossary_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_glossary_categories_id_seq OWNER TO postgres;

--
-- Name: mdl_glossary_comments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_glossary_comments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_glossary_comments_id_seq OWNER TO postgres;

--
-- Name: mdl_glossary_entries_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_glossary_entries_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_glossary_entries_categories_id_seq OWNER TO postgres;

--
-- Name: mdl_glossary_entries_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_glossary_entries_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_glossary_entries_id_seq OWNER TO postgres;

--
-- Name: mdl_glossary_formats_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_glossary_formats_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_glossary_formats_id_seq OWNER TO postgres;

--
-- Name: mdl_glossary_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_glossary_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_glossary_id_seq OWNER TO postgres;

--
-- Name: mdl_glossary_ratings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_glossary_ratings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_glossary_ratings_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_categories_history_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_categories_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_categories_history_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_categories_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_grades_history_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_grades_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_grades_history_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_grades_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_grades_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_grades_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_import_newitem_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_import_newitem_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_import_newitem_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_import_values_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_import_values_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_import_values_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_items_history_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_items_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_items_history_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_items_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_items_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_items_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_letters_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_letters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_letters_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_outcomes_courses_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_outcomes_courses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_outcomes_courses_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_outcomes_history_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_outcomes_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_outcomes_history_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_outcomes_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_outcomes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_outcomes_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_settings_id_seq OWNER TO postgres;

--
-- Name: mdl_groupings_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_groupings_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_groupings_groups_id_seq OWNER TO postgres;

--
-- Name: mdl_groupings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_groupings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_groupings_id_seq OWNER TO postgres;

--
-- Name: mdl_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_groups_id_seq OWNER TO postgres;

--
-- Name: mdl_groups_members_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_groups_members_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_groups_members_id_seq OWNER TO postgres;

--
-- Name: mdl_hotpot_attempts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_hotpot_attempts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_hotpot_attempts_id_seq OWNER TO postgres;

--
-- Name: mdl_hotpot_details_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_hotpot_details_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_hotpot_details_id_seq OWNER TO postgres;

--
-- Name: mdl_hotpot_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_hotpot_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_hotpot_id_seq OWNER TO postgres;

--
-- Name: mdl_hotpot_questions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_hotpot_questions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_hotpot_questions_id_seq OWNER TO postgres;

--
-- Name: mdl_hotpot_responses_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_hotpot_responses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_hotpot_responses_id_seq OWNER TO postgres;

--
-- Name: mdl_hotpot_strings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_hotpot_strings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_hotpot_strings_id_seq OWNER TO postgres;

--
-- Name: mdl_journal_entries_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_journal_entries_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_journal_entries_id_seq OWNER TO postgres;

--
-- Name: mdl_journal_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_journal_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_journal_id_seq OWNER TO postgres;

--
-- Name: mdl_label_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_label_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_label_id_seq OWNER TO postgres;

--
-- Name: mdl_lams_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lams_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lams_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_answers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_answers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_answers_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_attempts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_attempts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_attempts_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_branch_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_branch_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_branch_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_default_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_default_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_default_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_grades_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_grades_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_grades_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_high_scores_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_high_scores_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_high_scores_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_pages_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_pages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_pages_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_timer_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_timer_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_timer_id_seq OWNER TO postgres;

--
-- Name: mdl_log_display_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_log_display_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_log_display_id_seq OWNER TO postgres;

--
-- Name: mdl_log_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_log_id_seq OWNER TO postgres;

--
-- Name: mdl_message_contacts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_contacts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_contacts_id_seq OWNER TO postgres;

--
-- Name: mdl_message_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_id_seq OWNER TO postgres;

--
-- Name: mdl_message_read_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_read_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_read_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_application_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_application_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_application_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_enrol_assignments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_enrol_assignments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_enrol_assignments_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_enrol_course_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_enrol_course_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_enrol_course_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_host2service_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_host2service_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_host2service_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_host_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_host_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_host_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_log_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_log_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_rpc_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_rpc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_rpc_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_service2rpc_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_service2rpc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_service2rpc_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_service_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_service_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_service_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_session_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_session_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_session_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_sso_access_control_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_sso_access_control_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_sso_access_control_id_seq OWNER TO postgres;

--
-- Name: mdl_modules_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_modules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_modules_id_seq OWNER TO postgres;

--
-- Name: mdl_post_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_post_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_post_id_seq OWNER TO postgres;

--
-- Name: mdl_question_answers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_answers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_answers_id_seq OWNER TO postgres;

--
-- Name: mdl_question_attempts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_attempts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_attempts_id_seq OWNER TO postgres;

--
-- Name: mdl_question_calculated_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_calculated_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_calculated_id_seq OWNER TO postgres;

--
-- Name: mdl_question_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_categories_id_seq OWNER TO postgres;

--
-- Name: mdl_question_dataset_definitions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_dataset_definitions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_dataset_definitions_id_seq OWNER TO postgres;

--
-- Name: mdl_question_dataset_items_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_dataset_items_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_dataset_items_id_seq OWNER TO postgres;

--
-- Name: mdl_question_datasets_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_datasets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_datasets_id_seq OWNER TO postgres;

--
-- Name: mdl_question_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_id_seq OWNER TO postgres;

--
-- Name: mdl_question_match_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_match_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_match_id_seq OWNER TO postgres;

--
-- Name: mdl_question_match_sub_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_match_sub_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_match_sub_id_seq OWNER TO postgres;

--
-- Name: mdl_question_multianswer_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_multianswer_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_multianswer_id_seq OWNER TO postgres;

--
-- Name: mdl_question_multichoice_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_multichoice_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_multichoice_id_seq OWNER TO postgres;

--
-- Name: mdl_question_numerical_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_numerical_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_numerical_id_seq OWNER TO postgres;

--
-- Name: mdl_question_numerical_units_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_numerical_units_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_numerical_units_id_seq OWNER TO postgres;

--
-- Name: mdl_question_randomsamatch_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_randomsamatch_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_randomsamatch_id_seq OWNER TO postgres;

--
-- Name: mdl_question_sessions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_sessions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_sessions_id_seq OWNER TO postgres;

--
-- Name: mdl_question_shortanswer_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_shortanswer_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_shortanswer_id_seq OWNER TO postgres;

--
-- Name: mdl_question_states_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_states_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_states_id_seq OWNER TO postgres;

--
-- Name: mdl_question_truefalse_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_truefalse_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_truefalse_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_attempts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_attempts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_attempts_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_feedback_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_feedback_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_feedback_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_grades_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_grades_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_grades_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_question_instances_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_question_instances_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_question_instances_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_question_versions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_question_versions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_question_versions_id_seq OWNER TO postgres;

--
-- Name: mdl_resource_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_resource_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_resource_id_seq OWNER TO postgres;

--
-- Name: mdl_role_allow_assign_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_allow_assign_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_allow_assign_id_seq OWNER TO postgres;

--
-- Name: mdl_role_allow_override_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_allow_override_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_allow_override_id_seq OWNER TO postgres;

--
-- Name: mdl_role_assignments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_assignments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_assignments_id_seq OWNER TO postgres;

--
-- Name: mdl_role_capabilities_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_capabilities_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_capabilities_id_seq OWNER TO postgres;

--
-- Name: mdl_role_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_id_seq OWNER TO postgres;

--
-- Name: mdl_role_names_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_names_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_names_id_seq OWNER TO postgres;

--
-- Name: mdl_role_sortorder_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_sortorder_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_sortorder_id_seq OWNER TO postgres;

--
-- Name: mdl_scale_history_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scale_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scale_history_id_seq OWNER TO postgres;

--
-- Name: mdl_scale_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scale_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scale_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_scoes_data_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_scoes_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_scoes_data_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_scoes_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_scoes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_scoes_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_scoes_track_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_scoes_track_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_scoes_track_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_seq_mapinfo_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_seq_mapinfo_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_seq_mapinfo_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_seq_objective_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_seq_objective_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_seq_objective_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_seq_rolluprule_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_seq_rolluprule_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_seq_rolluprule_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_seq_rolluprulecond_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_seq_rolluprulecond_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_seq_rolluprulecond_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_seq_rulecond_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_seq_rulecond_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_seq_rulecond_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_seq_ruleconds_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_seq_ruleconds_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_seq_ruleconds_id_seq OWNER TO postgres;

--
-- Name: mdl_stats_daily_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_stats_daily_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_stats_daily_id_seq OWNER TO postgres;

--
-- Name: mdl_stats_monthly_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_stats_monthly_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_stats_monthly_id_seq OWNER TO postgres;

--
-- Name: mdl_stats_user_daily_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_stats_user_daily_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_stats_user_daily_id_seq OWNER TO postgres;

--
-- Name: mdl_stats_user_monthly_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_stats_user_monthly_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_stats_user_monthly_id_seq OWNER TO postgres;

--
-- Name: mdl_stats_user_weekly_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_stats_user_weekly_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_stats_user_weekly_id_seq OWNER TO postgres;

--
-- Name: mdl_stats_weekly_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_stats_weekly_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_stats_weekly_id_seq OWNER TO postgres;

--
-- Name: mdl_survey_analysis_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_survey_analysis_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_survey_analysis_id_seq OWNER TO postgres;

--
-- Name: mdl_survey_answers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_survey_answers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_survey_answers_id_seq OWNER TO postgres;

--
-- Name: mdl_survey_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_survey_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_survey_id_seq OWNER TO postgres;

--
-- Name: mdl_survey_questions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_survey_questions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_survey_questions_id_seq OWNER TO postgres;

--
-- Name: mdl_tag_correlation_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tag_correlation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tag_correlation_id_seq OWNER TO postgres;

--
-- Name: mdl_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tag_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tag_id_seq OWNER TO postgres;

--
-- Name: mdl_tag_instance_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tag_instance_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tag_instance_id_seq OWNER TO postgres;

--
-- Name: mdl_timezone_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_timezone_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_timezone_id_seq OWNER TO postgres;

--
-- Name: mdl_user_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_id_seq OWNER TO postgres;

--
-- Name: mdl_user_info_category_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_info_category_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_info_category_id_seq OWNER TO postgres;

--
-- Name: mdl_user_info_data_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_info_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_info_data_id_seq OWNER TO postgres;

--
-- Name: mdl_user_info_field_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_info_field_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_info_field_id_seq OWNER TO postgres;

--
-- Name: mdl_user_lastaccess_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_lastaccess_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_lastaccess_id_seq OWNER TO postgres;

--
-- Name: mdl_user_preferences_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_preferences_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_preferences_id_seq OWNER TO postgres;

--
-- Name: mdl_user_private_key_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_private_key_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_private_key_id_seq OWNER TO postgres;

--
-- Name: mdl_webdav_locks_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_webdav_locks_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_webdav_locks_id_seq OWNER TO postgres;

--
-- Name: mdl_wiki_entries_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_wiki_entries_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_wiki_entries_id_seq OWNER TO postgres;

--
-- Name: mdl_wiki_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_wiki_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_wiki_id_seq OWNER TO postgres;

--
-- Name: mdl_wiki_locks_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_wiki_locks_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_wiki_locks_id_seq OWNER TO postgres;

--
-- Name: mdl_wiki_pages_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_wiki_pages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_wiki_pages_id_seq OWNER TO postgres;

--
-- Name: mdl_workshop_assessments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshop_assessments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshop_assessments_id_seq OWNER TO postgres;

--
-- Name: mdl_workshop_comments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshop_comments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshop_comments_id_seq OWNER TO postgres;

--
-- Name: mdl_workshop_elements_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshop_elements_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshop_elements_id_seq OWNER TO postgres;

--
-- Name: mdl_workshop_grades_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshop_grades_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshop_grades_id_seq OWNER TO postgres;

--
-- Name: mdl_workshop_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshop_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshop_id_seq OWNER TO postgres;

--
-- Name: mdl_workshop_rubrics_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshop_rubrics_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshop_rubrics_id_seq OWNER TO postgres;

--
-- Name: mdl_workshop_stockcomments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshop_stockcomments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshop_stockcomments_id_seq OWNER TO postgres;

--
-- Name: mdl_workshop_submissions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshop_submissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshop_submissions_id_seq OWNER TO postgres;

--
-- Name: orders; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.orders (
    id numeric,
    type character varying(50),
    external_id numeric,
    student_id character varying(20)
);


ALTER TABLE public.orders OWNER TO postgres;

--
-- Name: orders_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.orders_seq
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.orders_seq OWNER TO postgres;

--
-- Name: people_in_group_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.people_in_group_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.people_in_group_seq OWNER TO postgres;

--
-- Name: people_in_group; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.people_in_group (
    id numeric DEFAULT nextval('public.people_in_group_seq'::regclass) NOT NULL,
    id_group numeric NOT NULL,
    id_people numeric NOT NULL,
    fio_people character varying(200) NOT NULL,
    profile character varying(50) NOT NULL
);


ALTER TABLE public.people_in_group OWNER TO postgres;

--
-- Name: people_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.people_seq
    START WITH 1706
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.people_seq OWNER TO postgres;

--
-- Name: personal_in_mailgroup_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.personal_in_mailgroup_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.personal_in_mailgroup_seq OWNER TO postgres;

--
-- Name: personal_in_mailgroup; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.personal_in_mailgroup (
    id numeric DEFAULT nextval('public.personal_in_mailgroup_seq'::regclass) NOT NULL,
    group_id numeric NOT NULL,
    person_id numeric NOT NULL,
    person_fullname character varying(200) NOT NULL,
    profile character varying(50) NOT NULL,
    profile2 character varying(50) NOT NULL
);


ALTER TABLE public.personal_in_mailgroup OWNER TO postgres;

--
-- Name: portal_messages; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.portal_messages (
    id numeric,
    title character varying(255),
    content character varying(5000),
    sort_order numeric,
    published_user numeric,
    published_date date,
    start_date date,
    end_date date,
    published_profiles character varying(255),
    school_id numeric
);


ALTER TABLE public.portal_messages OWNER TO postgres;

--
-- Name: portal_messages_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.portal_messages_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.portal_messages_seq OWNER TO postgres;

--
-- Name: profile_settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.profile_settings (
    profile_id numeric,
    modname character varying(255),
    viewer character varying(1),
    editor character varying(1)
);


ALTER TABLE public.profile_settings OWNER TO postgres;

--
-- Name: program_uploaded_files; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.program_uploaded_files (
    id numeric,
    tablename character varying(255),
    table_id numeric,
    title character varying(255),
    location character varying(255),
    uploaded_date date,
    filesize character varying(10)
);


ALTER TABLE public.program_uploaded_files OWNER TO postgres;

--
-- Name: program_uploaded_files_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.program_uploaded_files_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.program_uploaded_files_seq OWNER TO postgres;

--
-- Name: resbase; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resbase (
    id numeric,
    school_id numeric,
    category_id numeric,
    title character varying(255),
    short_name character varying(20),
    type character varying(20),
    comments text,
    seats numeric
);


ALTER TABLE public.resbase OWNER TO postgres;

--
-- Name: resbase_categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resbase_categories (
    id numeric,
    school_id numeric,
    title character varying(100),
    sort_order numeric,
    profiles character varying(255)
);


ALTER TABLE public.resbase_categories OWNER TO postgres;

--
-- Name: resbase_categories_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resbase_categories_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resbase_categories_seq OWNER TO postgres;

--
-- Name: resbase_events; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resbase_events (
    id numeric,
    title character varying(100),
    description text,
    school_date date,
    start_time time without time zone,
    end_time time without time zone,
    user_id character varying(15),
    color character varying(7)
);


ALTER TABLE public.resbase_events OWNER TO postgres;

--
-- Name: resbase_events_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resbase_events_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resbase_events_seq OWNER TO postgres;

--
-- Name: resbase_in_events; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resbase_in_events (
    resource_id character varying(25),
    event_id numeric
);


ALTER TABLE public.resbase_in_events OWNER TO postgres;

--
-- Name: resbase_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resbase_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resbase_seq OWNER TO postgres;

--
-- Name: roundcube_cache_ids; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.roundcube_cache_ids
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.roundcube_cache_ids OWNER TO postgres;

--
-- Name: roundcube_contact_ids; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.roundcube_contact_ids
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.roundcube_contact_ids OWNER TO postgres;

--
-- Name: roundcube_identity_ids; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.roundcube_identity_ids
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.roundcube_identity_ids OWNER TO postgres;

--
-- Name: roundcube_message_ids; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.roundcube_message_ids
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.roundcube_message_ids OWNER TO postgres;

--
-- Name: roundcube_user_ids; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.roundcube_user_ids
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.roundcube_user_ids OWNER TO postgres;

--
-- Name: rss_conf_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.rss_conf_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rss_conf_seq OWNER TO postgres;

--
-- Name: rss_conf; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.rss_conf (
    id numeric DEFAULT nextval('public.rss_conf_seq'::regclass),
    title character varying(150),
    rss_url character varying(500),
    user_id character varying(500),
    used character varying(1)
);


ALTER TABLE public.rss_conf OWNER TO postgres;

--
-- Name: saved_info; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.saved_info (
    id numeric NOT NULL,
    title character varying(100),
    user_id numeric,
    php_self character varying(5000),
    search_php_self character varying(5000),
    search_vars character varying(5000),
    school_id numeric
);


ALTER TABLE public.saved_info OWNER TO postgres;

--
-- Name: saved_info_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.saved_info_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.saved_info_seq OWNER TO postgres;

--
-- Name: school_calendar_days; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_calendar_days (
    school_year numeric NOT NULL,
    school_id numeric NOT NULL,
    school_date date NOT NULL,
    minutes numeric,
    block character varying(10),
    calendar_id numeric NOT NULL
);


ALTER TABLE public.school_calendar_days OWNER TO postgres;

--
-- Name: school_calendar_events; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_calendar_events (
    id numeric NOT NULL,
    school_year numeric,
    school_id numeric,
    school_date date,
    title character varying(50),
    description text
);


ALTER TABLE public.school_calendar_events OWNER TO postgres;

--
-- Name: school_calendar_events_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.school_calendar_events_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.school_calendar_events_seq OWNER TO postgres;

--
-- Name: school_calendars; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_calendars (
    school_id numeric,
    title character varying(100),
    school_year numeric,
    calendar_id numeric NOT NULL,
    default_calendar character varying(1),
    rollover_id numeric
);


ALTER TABLE public.school_calendars OWNER TO postgres;

--
-- Name: school_classlevels; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_classlevels (
    id numeric NOT NULL,
    school_id numeric,
    title character varying(50),
    next_classlevel_id numeric,
    sort_order numeric,
    short_name character varying(4)
);


ALTER TABLE public.school_classlevels OWNER TO postgres;

--
-- Name: school_classlevels_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.school_classlevels_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.school_classlevels_seq OWNER TO postgres;

--
-- Name: school_field_categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_field_categories (
    id numeric NOT NULL,
    title character varying(100),
    allow_teacher_modify character varying(1),
    sort_order numeric,
    columns numeric
);


ALTER TABLE public.school_field_categories OWNER TO postgres;

--
-- Name: school_field_categories_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.school_field_categories_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.school_field_categories_seq OWNER TO postgres;

--
-- Name: school_fields; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_fields (
    id numeric NOT NULL,
    type character varying(10),
    search character varying(1),
    select_options character varying(10000),
    category_id numeric,
    system_field character(1),
    default_selection character varying(255),
    log_field1_title character varying(100),
    log_field2_title character varying(100),
    log_field3_title character varying(100),
    log_field4_title character varying(100),
    log_field5_title character varying(100),
    log_field6_title character varying(100),
    log_field7_title character varying(100),
    log_field8_title character varying(100),
    log_field9_title character varying(100),
    required character(1),
    max_length numeric,
    sort_order numeric,
    select_option_codes character varying(10000),
    select_option_default_code character varying(255),
    application character varying(1),
    log_field10_title character varying(100),
    log_field11_title character varying(100),
    title character varying(100),
    field_edits text,
    log_field1 character varying(10),
    log_field2 character varying(10),
    log_field3 character varying(10),
    log_field4 character varying(10),
    log_field5 character varying(10),
    log_field6 character varying(10),
    log_field7 character varying(10),
    log_field8 character varying(10),
    log_field9 character varying(10),
    log_field10 character varying(10),
    log_field11 character varying(10),
    log_field12 character varying(10),
    log_field13 character varying(10),
    log_field14 character varying(10),
    log_field15 character varying(10),
    log_field16 character varying(10),
    log_field17 character varying(10),
    log_field18 character varying(10),
    log_field19 character varying(10),
    log_field20 character varying(10),
    log_field12_title character varying(100),
    log_field13_title character varying(100),
    log_field14_title character varying(100),
    log_field15_title character varying(100),
    log_field16_title character varying(100),
    log_field17_title character varying(100),
    log_field18_title character varying(100),
    log_field19_title character varying(100),
    log_field20_title character varying(100),
    log_field1_sort_order numeric DEFAULT 1,
    log_field2_sort_order numeric DEFAULT 2,
    log_field3_sort_order numeric DEFAULT 3,
    log_field4_sort_order numeric DEFAULT 4,
    log_field5_sort_order numeric DEFAULT 5,
    log_field6_sort_order numeric DEFAULT 6,
    log_field7_sort_order numeric DEFAULT 7,
    log_field8_sort_order numeric DEFAULT 8,
    log_field9_sort_order numeric DEFAULT 9,
    log_field10_sort_order numeric DEFAULT 10,
    log_field11_sort_order numeric DEFAULT 11,
    log_field12_sort_order numeric DEFAULT 12,
    log_field13_sort_order numeric DEFAULT 13,
    log_field14_sort_order numeric DEFAULT 14,
    log_field15_sort_order numeric DEFAULT 15,
    log_field16_sort_order numeric DEFAULT 16,
    log_field17_sort_order numeric DEFAULT 17,
    log_field18_sort_order numeric DEFAULT 18,
    log_field19_sort_order numeric DEFAULT 19,
    log_field20_sort_order numeric DEFAULT 20,
    size numeric
);


ALTER TABLE public.school_fields OWNER TO postgres;

--
-- Name: school_fields_in_cats; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_fields_in_cats (
    field_id integer NOT NULL,
    category_id integer NOT NULL,
    sort_order integer NOT NULL
);


ALTER TABLE public.school_fields_in_cats OWNER TO postgres;

--
-- Name: school_group_titles_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.school_group_titles_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.school_group_titles_seq OWNER TO postgres;

--
-- Name: school_group_titles; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_group_titles (
    id numeric DEFAULT nextval('public.school_group_titles_seq'::regclass) NOT NULL,
    school_id numeric,
    title character varying(100),
    short_name character varying(20),
    sort_order numeric
);


ALTER TABLE public.school_group_titles OWNER TO postgres;

--
-- Name: school_groups_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.school_groups_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.school_groups_seq OWNER TO postgres;

--
-- Name: school_groups; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_groups (
    id numeric DEFAULT nextval('public.school_groups_seq'::regclass) NOT NULL,
    school_id numeric,
    title character varying(50),
    short_name character varying(10),
    sort_order numeric,
    next_group_id numeric,
    group_title_id numeric NOT NULL
);


ALTER TABLE public.school_groups OWNER TO postgres;

--
-- Name: school_lf_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_lf_data (
    id numeric,
    school_field_id numeric,
    student_id numeric,
    school_id numeric,
    user_id numeric,
    modified_date date,
    log_field1 text,
    log_field2 text,
    log_field3 text,
    log_field4 text,
    log_field5 text,
    log_field6 text,
    log_field7 text,
    log_field8 text,
    log_field9 text,
    log_field10 text,
    log_field11 text,
    log_field12 text,
    log_field13 text,
    log_field14 text,
    log_field15 text,
    log_field16 text,
    log_field17 text,
    log_field18 text,
    log_field19 text,
    log_field20 text
);


ALTER TABLE public.school_lf_data OWNER TO postgres;

--
-- Name: school_lf_data_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.school_lf_data_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.school_lf_data_seq OWNER TO postgres;

--
-- Name: school_periods; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_periods (
    school_period_id numeric NOT NULL,
    school_year numeric,
    school_id numeric,
    sort_order numeric,
    title character varying(100),
    short_name character varying(10),
    length numeric,
    rollover_id numeric,
    block character varying(10),
    attendance character varying(1),
    length_sun numeric,
    length_mon numeric,
    length_tue numeric,
    length_wed numeric,
    length_thu numeric,
    length_fri numeric,
    length_sat numeric,
    start_time time without time zone,
    end_time time without time zone,
    start_time_sun time without time zone,
    end_time_sun time without time zone,
    start_time_mon time without time zone,
    end_time_mon time without time zone,
    start_time_tue time without time zone,
    end_time_tue time without time zone,
    start_time_wed time without time zone,
    end_time_wed time without time zone,
    start_time_thu time without time zone,
    end_time_thu time without time zone,
    start_time_fri time without time zone,
    end_time_fri time without time zone,
    start_time_sat time without time zone,
    end_time_sat time without time zone
);


ALTER TABLE public.school_periods OWNER TO postgres;

--
-- Name: school_periods_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.school_periods_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.school_periods_seq OWNER TO postgres;

--
-- Name: school_quarters; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_quarters (
    school_term_id numeric NOT NULL,
    school_year numeric,
    school_id numeric,
    semester_id numeric,
    title character varying(50),
    short_name character varying(10),
    sort_order numeric,
    start_date date,
    end_date date,
    post_start_date date,
    post_end_date date,
    rollover_id numeric,
    registration_start_date date,
    registration_end_date date,
    year_fraction numeric
);


ALTER TABLE public.school_quarters OWNER TO postgres;

--
-- Name: school_semesters; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_semesters (
    school_term_id numeric NOT NULL,
    school_year numeric,
    school_id numeric,
    title character varying(50),
    short_name character varying(10),
    sort_order numeric,
    start_date date,
    end_date date,
    post_start_date date,
    post_end_date date,
    rollover_id numeric,
    registration_start_date date,
    registration_end_date date,
    year_fraction numeric,
    year_id numeric
);


ALTER TABLE public.school_semesters OWNER TO postgres;

--
-- Name: school_term_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.school_term_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.school_term_seq OWNER TO postgres;

--
-- Name: school_weeks; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_weeks (
    school_term_id numeric NOT NULL,
    school_year numeric,
    school_id numeric,
    quarter_id numeric,
    title character varying(50),
    short_name character varying(10),
    sort_order numeric,
    start_date date,
    end_date date,
    post_start_date date,
    post_end_date date,
    rollover_id numeric,
    year_fraction numeric
);


ALTER TABLE public.school_weeks OWNER TO postgres;

--
-- Name: school_years; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_years (
    school_term_id numeric NOT NULL,
    school_year numeric,
    school_id numeric,
    title character varying(50),
    short_name character varying(10),
    sort_order numeric,
    start_date date,
    end_date date,
    post_start_date date,
    post_end_date date,
    registration_start_date date,
    registration_end_date date,
    year_fraction numeric,
    rollover_id numeric
);


ALTER TABLE public.school_years OWNER TO postgres;

--
-- Name: schools; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.schools (
    school_year numeric,
    id numeric NOT NULL,
    title character varying(100),
    address character varying(100),
    city character varying(100),
    state character varying(2),
    zipcode character varying(10),
    area_code numeric,
    phone numeric,
    principal character varying(100),
    latitude numeric,
    longitude numeric,
    state_school_id numeric,
    cfield_1 numeric,
    cfield_2 numeric,
    cfield_3 numeric,
    cfield_60319 character varying(255),
    cfield_60320 character varying(255),
    cfield_60322 character varying(10),
    cfield_60323 character varying(20),
    cfield_60324 character varying(100),
    cfield_60325 character varying(1000),
    cfield_54 character varying(255),
    cfield_58 character varying(5000),
    cfield_59 character varying(255),
    cfield_60 character varying(255),
    cfield_61 character varying(255),
    cfield_62 character varying(255),
    cfield_63 character varying(255),
    cfield_64 character varying(255),
    cfield_65 character varying(255),
    cfield_66 character varying(255),
    cfield_67 character varying(5000),
    cfield_68 numeric,
    cfield_69 character varying(255),
    cfield_70 character varying(255),
    cfield_71 character varying(255),
    cfield_72 character varying(255)
);


ALTER TABLE public.schools OWNER TO postgres;

--
-- Name: schools_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.schools_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.schools_seq OWNER TO postgres;

--
-- Name: sms_notification_list_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sms_notification_list_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sms_notification_list_seq OWNER TO postgres;

--
-- Name: sms_notification_list; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sms_notification_list (
    id numeric DEFAULT nextval('public.sms_notification_list_seq'::regclass) NOT NULL,
    person_id numeric NOT NULL,
    profile character varying(50) NOT NULL,
    type character varying(50) NOT NULL,
    checkboxes character varying(200),
    day_notify character varying(100),
    total_grades character varying(15)
);


ALTER TABLE public.sms_notification_list OWNER TO postgres;

--
-- Name: sms_profiles_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sms_profiles_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sms_profiles_seq OWNER TO postgres;

--
-- Name: sms_profiles; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sms_profiles (
    id numeric DEFAULT nextval('public.sms_profiles_seq'::regclass) NOT NULL,
    title character varying(50) NOT NULL,
    login character varying(50) NOT NULL,
    pass character varying(50) NOT NULL
);


ALTER TABLE public.sms_profiles OWNER TO postgres;

--
-- Name: statistics_of_visitings_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.statistics_of_visitings_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.statistics_of_visitings_seq OWNER TO postgres;

--
-- Name: statistics_of_visitings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.statistics_of_visitings (
    id numeric DEFAULT nextval('public.statistics_of_visitings_seq'::regclass) NOT NULL,
    user_id numeric NOT NULL,
    profile character varying(50) NOT NULL,
    module character varying(50) NOT NULL,
    servicemod character varying(200) NOT NULL,
    s_count numeric NOT NULL
);


ALTER TABLE public.statistics_of_visitings OWNER TO postgres;

--
-- Name: std_counter_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.std_counter_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.std_counter_seq OWNER TO postgres;

--
-- Name: std_counter; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.std_counter (
    id numeric DEFAULT nextval('public.std_counter_seq'::regclass) NOT NULL,
    school_id numeric,
    school_year numeric,
    doc_id numeric NOT NULL,
    advanced character varying(1),
    counter_id numeric,
    value numeric
);


ALTER TABLE public.std_counter OWNER TO postgres;

--
-- Name: student_activities_history; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_activities_history (
    school_year numeric,
    student_id numeric,
    activity_id numeric
);


ALTER TABLE public.student_activities_history OWNER TO postgres;

--
-- Name: student_attendance_days; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_attendance_days (
    student_id numeric NOT NULL,
    school_date date NOT NULL,
    minutes_present numeric,
    state_value numeric,
    school_year numeric,
    school_term_id numeric,
    comment character varying(255),
    daily_code character varying(10),
    last_updated_date date,
    last_updated_user numeric
);


ALTER TABLE public.student_attendance_days OWNER TO postgres;

--
-- Name: student_attendance_periods; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_attendance_periods (
    student_id numeric NOT NULL,
    school_date date NOT NULL,
    school_period_id numeric NOT NULL,
    attendance_code numeric,
    attendance_teacher_code numeric,
    attendance_reason character varying(100),
    admin character varying(1),
    course_section_id numeric,
    school_term_id numeric,
    last_updated_date date,
    last_updated_user numeric
);


ALTER TABLE public.student_attendance_periods OWNER TO postgres;

--
-- Name: student_discipline_incidents; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_discipline_incidents (
    school_year numeric,
    id numeric NOT NULL,
    title character varying(100),
    cfield_214 character varying(255),
    cfield_215 date,
    cfield_216 character varying(255),
    cfield_217 character varying(255),
    cfield_218 date,
    cfield_219 character varying(255),
    cfield_220 character varying(5000),
    cfield_221 character varying(5000),
    cfield_90 character varying(5000),
    cfield_91 character varying(5000),
    cfield_92 character varying(5000),
    cfield_93 character varying(5000)
);


ALTER TABLE public.student_discipline_incidents OWNER TO postgres;

--
-- Name: student_discipline_incidents_asg_reports; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_discipline_incidents_asg_reports (
    incident_id numeric,
    referral_id numeric
);


ALTER TABLE public.student_discipline_incidents_asg_reports OWNER TO postgres;

--
-- Name: student_discipline_incidents_fields_in_cats; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_discipline_incidents_fields_in_cats (
    field_id integer NOT NULL,
    category_id integer NOT NULL,
    sort_order integer NOT NULL
);


ALTER TABLE public.student_discipline_incidents_fields_in_cats OWNER TO postgres;

--
-- Name: student_discipline_incidents_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_discipline_incidents_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_discipline_incidents_seq OWNER TO postgres;

--
-- Name: student_discipline_reports; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_discipline_reports (
    id numeric NOT NULL,
    school_year numeric NOT NULL,
    student_id numeric NOT NULL,
    school_id numeric NOT NULL,
    user_id numeric,
    entry_date date,
    referral_date date,
    category_1 character varying(1000),
    category_2 character varying(1000),
    category_3 character varying(1),
    category_4 character varying(1000),
    category_6 character varying(5000),
    category_10 character varying(1000),
    category_11 character varying(5000),
    category_12 character varying(5000),
    category_13 character varying(5000),
    category_14 character varying(5000)
);


ALTER TABLE public.student_discipline_reports OWNER TO postgres;

--
-- Name: student_discipline_reports_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_discipline_reports_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_discipline_reports_seq OWNER TO postgres;

--
-- Name: student_emails; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_emails (
    id numeric NOT NULL,
    title character varying(255),
    default_template_id numeric,
    body text,
    school_id numeric,
    profile character varying(25),
    user_id numeric
);


ALTER TABLE public.student_emails OWNER TO postgres;

--
-- Name: student_emails_order; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_emails_order (
    letter_id integer NOT NULL,
    sid integer NOT NULL,
    stype integer NOT NULL,
    template_id integer NOT NULL,
    dt_added date,
    user_added integer,
    dt_printed date,
    user_printed integer
);


ALTER TABLE public.student_emails_order OWNER TO postgres;

--
-- Name: student_emails_order_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_emails_order_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_emails_order_seq OWNER TO postgres;

--
-- Name: student_emails_processing; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_emails_processing (
    trigger_id numeric NOT NULL,
    trigger_event smallint NOT NULL,
    trigger_action smallint NOT NULL,
    template_id numeric NOT NULL
);


ALTER TABLE public.student_emails_processing OWNER TO postgres;

--
-- Name: student_emails_processing_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_emails_processing_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_emails_processing_seq OWNER TO postgres;

--
-- Name: student_emails_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_emails_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_emails_seq OWNER TO postgres;

--
-- Name: student_field_categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_field_categories (
    id numeric NOT NULL,
    title character varying(100),
    allow_teacher_modify character varying(1),
    sort_order numeric,
    columns numeric,
    allow_student_modify character varying(1),
    alternative_name character varying(255),
    used_applicants character varying(1)
);


ALTER TABLE public.student_field_categories OWNER TO postgres;

--
-- Name: student_field_categories_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_field_categories_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_field_categories_seq OWNER TO postgres;

--
-- Name: student_fields; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_fields (
    id numeric NOT NULL,
    type character varying(10),
    search character varying(1),
    select_options character varying(10000),
    category_id numeric,
    system_field bpchar,
    default_selection character varying(255),
    log_field1_title character varying(100),
    log_field2_title character varying(100),
    log_field3_title character varying(100),
    log_field4_title character varying(100),
    log_field5_title character varying(100),
    log_field6_title character varying(100),
    log_field7_title character varying(100),
    log_field8_title character varying(100),
    log_field9_title character varying(100),
    required bpchar,
    max_length numeric,
    sort_order numeric,
    select_option_codes character varying(10000),
    select_option_default_code character varying(255),
    application character varying(1),
    log_field10_title character varying(100),
    log_field11_title character varying(100),
    title character varying(100),
    field_edits text,
    log_field1 character varying(10),
    log_field2 character varying(10),
    log_field3 character varying(10),
    log_field4 character varying(10),
    log_field5 character varying(10),
    log_field6 character varying(10),
    log_field7 character varying(10),
    log_field8 character varying(10),
    log_field9 character varying(10),
    log_field10 character varying(10),
    log_field11 character varying(10),
    log_field12 character varying(10),
    log_field13 character varying(10),
    log_field14 character varying(10),
    log_field15 character varying(10),
    log_field16 character varying(10),
    log_field17 character varying(10),
    log_field18 character varying(10),
    log_field19 character varying(10),
    log_field20 character varying(10),
    log_field12_title character varying(100),
    log_field13_title character varying(100),
    log_field14_title character varying(100),
    log_field15_title character varying(100),
    log_field16_title character varying(100),
    log_field17_title character varying(100),
    log_field18_title character varying(100),
    log_field19_title character varying(100),
    log_field20_title character varying(100),
    log_field1_sort_order numeric DEFAULT 1,
    log_field2_sort_order numeric DEFAULT 2,
    log_field3_sort_order numeric DEFAULT 3,
    log_field4_sort_order numeric DEFAULT 4,
    log_field5_sort_order numeric DEFAULT 5,
    log_field6_sort_order numeric DEFAULT 6,
    log_field7_sort_order numeric DEFAULT 7,
    log_field8_sort_order numeric DEFAULT 8,
    log_field9_sort_order numeric DEFAULT 9,
    log_field10_sort_order numeric DEFAULT 10,
    log_field11_sort_order numeric DEFAULT 11,
    log_field12_sort_order numeric DEFAULT 12,
    log_field13_sort_order numeric DEFAULT 13,
    log_field14_sort_order numeric DEFAULT 14,
    log_field15_sort_order numeric DEFAULT 15,
    log_field16_sort_order numeric DEFAULT 16,
    log_field17_sort_order numeric DEFAULT 17,
    log_field18_sort_order numeric DEFAULT 18,
    log_field19_sort_order numeric DEFAULT 19,
    log_field20_sort_order numeric DEFAULT 20,
    max_record numeric,
    use_applicants character varying(1),
    use_students character varying(1),
    use_source character varying(1),
    for_applicants character varying(1),
    values_field character varying(30),
    codes_field character varying(30),
    source_table character varying(30),
    size numeric,
    log_field1_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field2_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field3_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field4_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field5_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field6_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field7_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field8_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field9_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field10_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field11_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field12_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field13_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field14_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field15_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field16_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field17_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field18_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field19_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field20_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field1_size numeric,
    log_field2_size numeric,
    log_field3_size numeric,
    log_field4_size numeric,
    log_field5_size numeric,
    log_field6_size numeric,
    log_field7_size numeric,
    log_field8_size numeric,
    log_field9_size numeric,
    log_field10_size numeric,
    log_field11_size numeric,
    log_field12_size numeric,
    log_field13_size numeric,
    log_field14_size numeric,
    log_field15_size numeric,
    log_field16_size numeric,
    log_field17_size numeric,
    log_field18_size numeric,
    log_field19_size numeric,
    log_field20_size numeric
);


ALTER TABLE public.student_fields OWNER TO postgres;

--
-- Name: student_fields_in_cats; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_fields_in_cats (
    field_id integer NOT NULL,
    category_id integer NOT NULL,
    sort_order integer NOT NULL
);


ALTER TABLE public.student_fields_in_cats OWNER TO postgres;

--
-- Name: student_fields_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_fields_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_fields_seq OWNER TO postgres;

--
-- Name: student_gpa_progress; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_gpa_progress (
    student_id numeric,
    school_term_id numeric,
    gpa_points numeric,
    gpa_points_weighted numeric,
    divisor numeric
);


ALTER TABLE public.student_gpa_progress OWNER TO postgres;

--
-- Name: student_gpa_totals; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_gpa_totals (
    student_id numeric,
    school_term_id numeric,
    mp character varying(4),
    gpa numeric,
    weighted_gpa numeric,
    class_rank numeric,
    cumulative_gpa numeric,
    cumulative_weighted_gpa numeric,
    grade_total numeric,
    cumulative_credits numeric,
    classlevel_id numeric,
    percent_average numeric,
    credits_attempted numeric,
    credits_earned numeric,
    classgroup_rank numeric
);


ALTER TABLE public.student_gpa_totals OWNER TO postgres;

--
-- Name: student_grades_card; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_grades_card (
    school_year numeric NOT NULL,
    school_id numeric,
    student_id numeric NOT NULL,
    course_section_id numeric,
    grades_card_id numeric,
    grade_card_comment_id numeric,
    comment character varying(255),
    school_term_id character varying(10) NOT NULL,
    id numeric NOT NULL,
    course_title character varying(100),
    teacher character varying(100),
    gradelevel_title character varying(100),
    grad_subject_id numeric,
    location_title character varying(100),
    percent_grade numeric,
    credits numeric,
    modified_date date,
    modified_user_id numeric,
    gpa_points numeric,
    grade_title character varying(10),
    weighted_gpa_points numeric,
    course_num character varying(30),
    affects_gpa character varying(1),
    carries_credits character varying(1),
    grade_type_id numeric,
    course_id numeric,
    course_credit_title character varying(10),
    last_updated_date date,
    last_updated_user numeric,
    conduct character varying(5),
    cfield_1 character varying(255),
    cfield_2 character varying(255),
    cfield_3 character varying(255),
    cfield_4 character varying(255)
);


ALTER TABLE public.student_grades_card OWNER TO postgres;

--
-- Name: student_grades_card_evaluations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_grades_card_evaluations (
    id numeric NOT NULL,
    school_year numeric NOT NULL,
    school_id numeric,
    student_id numeric NOT NULL,
    course_section_id numeric NOT NULL,
    school_term_id numeric NOT NULL,
    benchmark_id numeric NOT NULL,
    title character varying(10),
    grades_card_id numeric,
    grade_title character varying(10),
    comment character varying(255),
    longer_course_comments text
);


ALTER TABLE public.student_grades_card_evaluations OWNER TO postgres;

--
-- Name: student_grades_card_evaluations_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_grades_card_evaluations_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_grades_card_evaluations_seq OWNER TO postgres;

--
-- Name: student_grades_card_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_grades_card_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_grades_card_seq OWNER TO postgres;

--
-- Name: student_in_delivery_group; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_in_delivery_group (
    delivery_group_id numeric,
    student_id numeric
);


ALTER TABLE public.student_in_delivery_group OWNER TO postgres;

--
-- Name: student_lf_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_lf_data (
    id numeric,
    student_field_id numeric,
    student_id numeric,
    school_id numeric,
    user_id numeric,
    modified_date date,
    log_field1 text,
    log_field2 text,
    log_field3 text,
    log_field4 text,
    log_field5 text,
    log_field6 text,
    log_field7 text,
    log_field8 text,
    log_field9 text,
    log_field10 text,
    log_field11 text,
    log_field12 text,
    log_field13 text,
    log_field14 text,
    log_field15 text,
    log_field16 text,
    log_field17 text,
    log_field18 text,
    log_field19 text,
    log_field20 text
);


ALTER TABLE public.student_lf_data OWNER TO postgres;

--
-- Name: student_lf_data_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_lf_data_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_lf_data_seq OWNER TO postgres;

--
-- Name: student_markbook_grades; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_markbook_grades (
    student_id numeric NOT NULL,
    school_period_id numeric,
    course_section_id numeric NOT NULL,
    assignment_id numeric NOT NULL,
    points numeric,
    comment character varying(100),
    highlight character varying(1)
);


ALTER TABLE public.student_markbook_grades OWNER TO postgres;

--
-- Name: student_medical; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_medical (
    id numeric NOT NULL,
    student_id numeric,
    type character varying(25),
    medical_date date,
    comments character varying(100)
);


ALTER TABLE public.student_medical OWNER TO postgres;

--
-- Name: student_medical_alerts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_medical_alerts (
    id numeric NOT NULL,
    student_id numeric,
    title character varying(100)
);


ALTER TABLE public.student_medical_alerts OWNER TO postgres;

--
-- Name: student_medical_alerts_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_medical_alerts_seq
    START WITH 5
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_medical_alerts_seq OWNER TO postgres;

--
-- Name: student_medical_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_medical_seq
    START WITH 5
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_medical_seq OWNER TO postgres;

--
-- Name: student_medical_visits; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_medical_visits (
    id numeric NOT NULL,
    student_id numeric,
    school_date date,
    time_in character varying(20),
    time_out character varying(20),
    reason character varying(100),
    result character varying(100),
    comments character varying(255)
);


ALTER TABLE public.student_medical_visits OWNER TO postgres;

--
-- Name: student_medical_visits_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_medical_visits_seq
    START WITH 5
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_medical_visits_seq OWNER TO postgres;

--
-- Name: student_registration; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_registration (
    id numeric NOT NULL,
    school_year numeric,
    school_id numeric,
    student_id numeric,
    classlevel_id numeric,
    start_date date,
    end_date date,
    enrollment_code numeric,
    drop_code numeric,
    next_school numeric,
    calendar_id numeric,
    include_in_class_rank character varying(1),
    distance_from_school numeric,
    cfield_1 character varying(50),
    cfield_2 character varying(50),
    cfield_3 character varying(50),
    cfield_4 character varying(50),
    cfield_5 character varying(50),
    cfield_6 character varying(50),
    cfield_7 character varying(50),
    cfield_8 character varying(50),
    cfield_9 character varying(50),
    cfield_10 character varying(50),
    cfield_11 character varying(50),
    cfield_12 character varying(50),
    group_id numeric,
    include_in_group_rank character varying(1),
    cfield_15 character varying(255)
);


ALTER TABLE public.student_registration OWNER TO postgres;

--
-- Name: student_registration_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_registration_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_registration_seq OWNER TO postgres;

--
-- Name: student_registration_settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_registration_settings (
    id numeric NOT NULL,
    school_year numeric,
    title character varying(100),
    short_name character varying(10),
    type character varying(4)
);


ALTER TABLE public.student_registration_settings OWNER TO postgres;

--
-- Name: student_registration_settings_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_registration_settings_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_registration_settings_seq OWNER TO postgres;

--
-- Name: student_relations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_relations (
    person_id numeric NOT NULL,
    last_name character varying(25) NOT NULL,
    first_name character varying(25) NOT NULL,
    middle_name character varying(25),
    title character varying(5),
    email character varying(255),
    notificate character varying(1) DEFAULT 'N'::character varying
);


ALTER TABLE public.student_relations OWNER TO postgres;

--
-- Name: student_relations_in_contacts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_relations_in_contacts (
    id numeric NOT NULL,
    person_id numeric,
    title character varying(100),
    value character varying(100)
);


ALTER TABLE public.student_relations_in_contacts OWNER TO postgres;

--
-- Name: student_relations_in_contacts_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_relations_in_contacts_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_relations_in_contacts_seq OWNER TO postgres;

--
-- Name: student_relations_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_relations_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_relations_seq OWNER TO postgres;

--
-- Name: student_schedule; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_schedule (
    school_year numeric NOT NULL,
    school_id numeric,
    student_id numeric NOT NULL,
    start_date date NOT NULL,
    end_date date,
    modified_date date,
    modified_by character varying(255),
    course_id numeric NOT NULL,
    course_credit_title character varying(10) NOT NULL,
    course_section_id numeric NOT NULL,
    mp character varying(3),
    school_term_id numeric,
    scheduler_lock character varying(1),
    id numeric,
    cfield_1 character varying(255),
    cfield_2 character varying(255),
    cfield_3 character varying(255),
    cfield_4 character varying(255),
    cfield_5 character varying(255),
    cfield_6 character varying(255),
    cfield_7 character varying(255),
    cfield_8 character varying(255),
    cfield_9 character varying(255),
    cfield_10 character varying(255),
    cfield_11 character varying(255),
    cfield_12 character varying(255),
    cfield_13 character varying(255),
    cfield_14 character varying(255),
    cfield_15 character varying(255),
    cfield_16 character varying(255),
    cfield_17 character varying(255),
    cfield_18 character varying(255),
    cfield_19 character varying(255),
    cfield_20 character varying(255),
    cfield_21 character varying(255),
    days character varying(255),
    checkbox_setting_1 character varying(1),
    checkbox_setting_2 character varying(1),
    checkbox_setting_3 character varying(1),
    cfield_22 character varying(255),
    cfield_23 character varying(255),
    cfield_24 character varying(255),
    cfield_25 character varying(255)
);


ALTER TABLE public.student_schedule OWNER TO postgres;

--
-- Name: student_schedule_requests; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_schedule_requests (
    school_year numeric,
    school_id numeric,
    request_id numeric NOT NULL,
    student_id numeric,
    subject_id numeric,
    course_id numeric,
    course_credit_title character varying(10),
    school_term_id numeric,
    priority numeric,
    with_teacher_id numeric,
    not_teacher_id numeric,
    with_school_period_id numeric,
    not_school_period_id numeric
);


ALTER TABLE public.student_schedule_requests OWNER TO postgres;

--
-- Name: student_schedule_requests_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_schedule_requests_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_schedule_requests_seq OWNER TO postgres;

--
-- Name: student_schedule_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_schedule_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_schedule_seq OWNER TO postgres;

--
-- Name: student_suitability_grades; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_suitability_grades (
    student_id numeric,
    school_year numeric,
    school_date date,
    school_period_id numeric,
    student_suitability_grades_code character varying(20),
    course_section_id numeric
);


ALTER TABLE public.student_suitability_grades OWNER TO postgres;

--
-- Name: student_term_comments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_term_comments (
    student_id numeric NOT NULL,
    school_year numeric NOT NULL,
    school_term_id numeric NOT NULL,
    comment text,
    editor_user_ids character varying(255)
);


ALTER TABLE public.student_term_comments OWNER TO postgres;

--
-- Name: students; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.students (
    student_id numeric NOT NULL,
    last_name character varying(50) NOT NULL,
    first_name character varying(50) NOT NULL,
    middle_name character varying(50),
    name_suffix character varying(30),
    username character varying(100),
    password character varying(100),
    cfield_50000 character varying(255),
    cfield_50001 character varying(255),
    cfield_50003 character varying(255),
    cfield_50004 date,
    cfield_50005 character varying(255),
    cfield_50006 character varying(255),
    cfield_50007 character varying(255),
    cfield_50008 character varying(255),
    cfield_50009 character varying(2052),
    cfield_50010 bpchar,
    last_login timestamp without time zone,
    failed_login numeric,
    profile_id numeric DEFAULT 8,
    last_note_seen numeric,
    cfield_50012 character varying(255),
    cfield_50013 character varying(255),
    force_password_change character varying(1) DEFAULT 'N'::character varying,
    last_updated_date date,
    last_updated_user numeric,
    cfield_196 character varying(255),
    cfield_197 character varying(255),
    cfield_198 character varying(255),
    cfield_199 character varying(1),
    cfield_200 character varying(255),
    cfield_201 character varying(255),
    cfield_202 character varying(255),
    cfield_203 character varying(255),
    cfield_204 character varying(255),
    cfield_205 character varying(255),
    cfield_206 character varying(255),
    cfield_207 character varying(255),
    cfield_208 character varying(255),
    cfield_209 character varying(255),
    cfield_211 character varying(255),
    cfield_212 character varying(255),
    cfield_50002 character varying(40),
    cfield_50016 character varying(255),
    profile character varying(10),
    cfield_2 character varying(255),
    cfield_7 date,
    cfield_8 character varying(255),
    cfield_11 character varying(255),
    cfield_14 character varying(255),
    cfield_15 character varying(255),
    cfield_24 date,
    cfield_25 character varying(255),
    cfield_31 character varying(255),
    cfield_32 character varying(255),
    cfield_35 character varying(255),
    cfield_36 character varying(255),
    cfield_38 character varying(255),
    cfield_39 character varying(255),
    cfield_40 character varying(255),
    cfield_41 character varying(255),
    cfield_42 character varying(255),
    cfield_43 character varying(255),
    cfield_44 character varying(255),
    cfield_45 character varying(5000),
    cfield_46 numeric,
    cfield_47 character varying(255),
    cfield_48 character varying(5000),
    cfield_49 numeric,
    cfield_50 character varying(255),
    cfield_51 character varying(255),
    cfield_52 character varying(255),
    cfield_53 character varying(255),
    cfield_54 character varying(1000),
    cfield_55 character varying(5000),
    cfield_56 date,
    cfield_57 character varying(1000),
    cfield_94 character varying(5000),
    cfield_95 character varying(255),
    cfield_96 character varying(255),
    cfield_97 character varying(255),
    cfield_100 character varying(255),
    cfield_101 character varying(5000),
    cfield_102 character varying(5000),
    cfield_104 numeric,
    cfield_105 numeric,
    cfield_106 numeric,
    cfield_107 numeric,
    cfield_108 numeric
);


ALTER TABLE public.students OWNER TO postgres;

--
-- Name: students_auditlog; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.students_auditlog (
    data_element character varying(50) NOT NULL,
    student_id numeric,
    user_id numeric,
    change_date timestamp without time zone,
    change_description text,
    flags character varying(1)
);


ALTER TABLE public.students_auditlog OWNER TO postgres;

--
-- Name: students_in_address; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.students_in_address (
    id numeric NOT NULL,
    student_id numeric NOT NULL,
    address_id numeric NOT NULL,
    mailing character varying(1),
    residence character varying(1),
    bus_pickup character varying(1),
    bus_dropoff character varying(1)
);


ALTER TABLE public.students_in_address OWNER TO postgres;

--
-- Name: students_in_address_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.students_in_address_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.students_in_address_seq OWNER TO postgres;

--
-- Name: students_in_sr; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.students_in_sr (
    id numeric NOT NULL,
    student_id numeric NOT NULL,
    person_id numeric NOT NULL,
    address_id numeric,
    custody character varying(1),
    emergency character varying(1),
    student_relation character varying(100)
);


ALTER TABLE public.students_in_sr OWNER TO postgres;

--
-- Name: students_in_sr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.students_in_sr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.students_in_sr_seq OWNER TO postgres;

--
-- Name: students_in_users; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.students_in_users (
    student_id numeric NOT NULL,
    user_id numeric NOT NULL
);


ALTER TABLE public.students_in_users OWNER TO postgres;

--
-- Name: students_scores_rating; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.students_scores_rating (
    id numeric NOT NULL,
    student_id numeric NOT NULL,
    low_score numeric,
    high_score numeric,
    course_rank numeric,
    school_term_id character varying NOT NULL,
    course_id numeric NOT NULL
);


ALTER TABLE public.students_scores_rating OWNER TO postgres;

--
-- Name: students_scores_rating_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.students_scores_rating_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.students_scores_rating_seq OWNER TO postgres;

--
-- Name: students_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.students_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.students_seq OWNER TO postgres;

--
-- Name: suitability_teachers_filled; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.suitability_teachers_filled (
    user_id numeric NOT NULL,
    school_date date NOT NULL,
    school_period_id numeric NOT NULL
);


ALTER TABLE public.suitability_teachers_filled OWNER TO postgres;

--
-- Name: system_config; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.system_config (
    school_year numeric,
    school_id numeric,
    program character varying(255),
    title character varying(100),
    value character varying(100)
);


ALTER TABLE public.system_config OWNER TO postgres;

--
-- Name: system_user_settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.system_user_settings (
    username character varying(100),
    program character varying(255),
    title character varying(100),
    value text,
    school_id numeric,
    school_year numeric(4,0)
);


ALTER TABLE public.system_user_settings OWNER TO postgres;

--
-- Name: type_of_study_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.type_of_study_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.type_of_study_seq OWNER TO postgres;

--
-- Name: type_of_study; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.type_of_study (
    id numeric DEFAULT nextval('public.type_of_study_seq'::regclass)
);


ALTER TABLE public.type_of_study OWNER TO postgres;

--
-- Name: user_field_categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_field_categories (
    id numeric NOT NULL,
    title character varying(100),
    sort_order numeric,
    admin character varying(1),
    teacher character varying(1),
    parent character varying(1),
    columns numeric,
    allow_teacher_modify character varying(1)
);


ALTER TABLE public.user_field_categories OWNER TO postgres;

--
-- Name: user_field_categories_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_field_categories_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_field_categories_seq OWNER TO postgres;

--
-- Name: user_fields; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_fields (
    id numeric NOT NULL,
    type character varying(10),
    search character varying(1),
    select_options character varying(10000),
    category_id numeric,
    system_field bpchar,
    default_selection character varying(255),
    log_field1_title character varying(100),
    log_field2_title character varying(100),
    log_field3_title character varying(100),
    log_field4_title character varying(100),
    log_field5_title character varying(100),
    log_field6_title character varying(100),
    log_field7_title character varying(100),
    log_field8_title character varying(100),
    log_field9_title character varying(100),
    sort_order numeric,
    required bpchar,
    max_length numeric,
    select_option_codes character varying(10000),
    select_option_default_code character varying(255),
    title character varying(100),
    application character varying(1),
    log_field10_title character varying(100),
    log_field11_title character varying(100),
    field_edits text,
    log_field1 character varying(10),
    log_field2 character varying(10),
    log_field3 character varying(10),
    log_field4 character varying(10),
    log_field5 character varying(10),
    log_field6 character varying(10),
    log_field7 character varying(10),
    log_field8 character varying(10),
    log_field9 character varying(10),
    log_field10 character varying(10),
    log_field11 character varying(10),
    log_field12 character varying(10),
    log_field13 character varying(10),
    log_field14 character varying(10),
    log_field15 character varying(10),
    log_field16 character varying(10),
    log_field17 character varying(10),
    log_field18 character varying(10),
    log_field19 character varying(10),
    log_field20 character varying(10),
    log_field12_title character varying(100),
    log_field13_title character varying(100),
    log_field14_title character varying(100),
    log_field15_title character varying(100),
    log_field16_title character varying(100),
    log_field17_title character varying(100),
    log_field18_title character varying(100),
    log_field19_title character varying(100),
    log_field20_title character varying(100),
    log_field1_sort_order numeric DEFAULT 1,
    log_field2_sort_order numeric DEFAULT 2,
    log_field3_sort_order numeric DEFAULT 3,
    log_field4_sort_order numeric DEFAULT 4,
    log_field5_sort_order numeric DEFAULT 5,
    log_field6_sort_order numeric DEFAULT 6,
    log_field7_sort_order numeric DEFAULT 7,
    log_field8_sort_order numeric DEFAULT 8,
    log_field9_sort_order numeric DEFAULT 9,
    log_field10_sort_order numeric DEFAULT 10,
    log_field11_sort_order numeric DEFAULT 11,
    log_field12_sort_order numeric DEFAULT 12,
    log_field13_sort_order numeric DEFAULT 13,
    log_field14_sort_order numeric DEFAULT 14,
    log_field15_sort_order numeric DEFAULT 15,
    log_field16_sort_order numeric DEFAULT 16,
    log_field17_sort_order numeric DEFAULT 17,
    log_field18_sort_order numeric DEFAULT 18,
    log_field19_sort_order numeric DEFAULT 19,
    log_field20_sort_order numeric DEFAULT 20,
    use_source character varying(1),
    values_field character varying(30),
    codes_field character varying(30),
    source_table character varying(30),
    size numeric
);


ALTER TABLE public.user_fields OWNER TO postgres;

--
-- Name: user_fields_in_cats; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_fields_in_cats (
    field_id integer NOT NULL,
    category_id integer NOT NULL,
    sort_order integer NOT NULL
);


ALTER TABLE public.user_fields_in_cats OWNER TO postgres;

--
-- Name: user_fields_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_fields_seq
    START WITH 6
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_fields_seq OWNER TO postgres;

--
-- Name: user_in_delivery_group; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_in_delivery_group (
    delivery_group_id numeric,
    user_id numeric
);


ALTER TABLE public.user_in_delivery_group OWNER TO postgres;

--
-- Name: user_in_messages_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_in_messages_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_in_messages_seq OWNER TO postgres;

--
-- Name: user_in_messages; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_in_messages (
    id numeric DEFAULT nextval('public.user_in_messages_seq'::regclass) NOT NULL,
    message_id numeric NOT NULL,
    incoming character varying(1) DEFAULT 'N'::character varying,
    outcoming character varying(1) DEFAULT 'N'::character varying,
    from_user numeric NOT NULL,
    to_user numeric NOT NULL
);


ALTER TABLE public.user_in_messages OWNER TO postgres;

--
-- Name: user_lf_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_lf_data (
    id numeric,
    user_field_id numeric,
    user_id numeric,
    school_id numeric,
    modified_date date,
    log_field1 text,
    log_field2 text,
    log_field3 text,
    log_field4 text,
    log_field5 text,
    log_field6 text,
    log_field7 text,
    log_field8 text,
    log_field9 text,
    log_field10 text,
    log_field11 text,
    log_field12 text,
    log_field13 text,
    log_field14 text,
    log_field15 text,
    log_field16 text,
    log_field17 text,
    log_field18 text,
    log_field19 text,
    log_field20 text,
    log_date date,
    log_select character varying(255),
    log_select2 character varying(255),
    log_text1 character varying(255)
);


ALTER TABLE public.user_lf_data OWNER TO postgres;

--
-- Name: user_lf_data_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_lf_data_seq
    START WITH 5
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_lf_data_seq OWNER TO postgres;

--
-- Name: user_messages_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_messages_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_messages_seq OWNER TO postgres;

--
-- Name: user_messages; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_messages (
    id numeric DEFAULT nextval('public.user_messages_seq'::regclass) NOT NULL,
    title text,
    content text,
    send_date timestamp without time zone,
    new_message character varying(1) DEFAULT 'Y'::character varying
);


ALTER TABLE public.user_messages OWNER TO postgres;

--
-- Name: user_profiles; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_profiles (
    id numeric NOT NULL,
    profile character varying(30),
    title character varying(100),
    type character varying(25)
);


ALTER TABLE public.user_profiles OWNER TO postgres;

--
-- Name: user_profiles_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_profiles_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_profiles_seq OWNER TO postgres;

--
-- Name: user_settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_settings (
    username character varying(100),
    modname character varying(255),
    viewer character varying(1),
    editor character varying(1)
);


ALTER TABLE public.user_settings OWNER TO postgres;

--
-- Name: users; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.users (
    school_year numeric,
    user_id numeric NOT NULL,
    current_school_id numeric,
    first_name character varying(100),
    last_name character varying(100),
    middle_name character varying(100),
    username character varying(100),
    password character varying(100),
    phone character varying(100),
    email character varying(100),
    profile character varying(30),
    homeroom character varying(5),
    rollover_id numeric,
    schools character varying(255),
    profile_id numeric,
    last_note_seen numeric,
    cfield_40001 character varying(255),
    cfield_40002 character varying(255),
    title character varying(30),
    cfield_40003 character varying(255),
    last_login timestamp without time zone,
    failed_login numeric,
    force_password_change character varying(1) DEFAULT 'N'::character varying,
    cfield_40004 date,
    cfield_188 character varying(255),
    cfield_189 date,
    cfield_190 character varying(255),
    cfield_191 character varying(255),
    cfield_192 character varying(255),
    cfield_194 character varying(255),
    cfield_195 character varying(255),
    last_updated_user numeric,
    last_updated_date date,
    cfield_40005 character varying(40),
    cfield_17 character varying(255),
    cfield_18 character varying(255),
    cfield_20 date,
    cfield_21 character varying(255),
    cfield_22 character varying(255),
    cfield_23 character varying(255),
    cfield_26 character varying(255),
    cfield_73 character varying(5000),
    cfield_74 character varying(255),
    cfield_75 character varying(255),
    cfield_76 date,
    cfield_77 date,
    cfield_78 character varying(255),
    cfield_79 character varying(255),
    cfield_80 date,
    cfield_81 character varying(5000),
    cfield_82 character varying(255),
    cfield_83 character varying(255),
    cfield_84 numeric,
    cfield_85 character varying(255),
    cfield_87 character varying(5000),
    cfield_88 date,
    cfield_89 character varying(5000),
    cfield_98 date,
    cfield_99 character varying(255),
    cfield_103 character varying(5000),
    cfield_109 character varying(255)
);


ALTER TABLE public.users OWNER TO postgres;

--
-- Name: users_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.users_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.users_seq OWNER TO postgres;

--
-- Name: year_grade_report; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.year_grade_report (
    grade_id character varying,
    value1 character varying,
    value2 character varying,
    value3 character varying,
    value4 character varying,
    value5 character varying
);


ALTER TABLE public.year_grade_report OWNER TO postgres;

--
-- Data for Name: activity_courses; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.activity_courses (id, school_year, school_id, title, start_date, end_date) FROM stdin;
\.


--
-- Data for Name: addons_log; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.addons_log (addon_title, error_date) FROM stdin;
\.


--
-- Data for Name: address; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.address (address_id, zipcode, plus4, city, state, mail_city, mail_state, mail_zipcode, address, mail_address, phone, latitude, longitude, username, password, last_login, failed_login, last_note_seen, profile_id, force_password_change, fed_region, mail_fed_region, settlement, mail_settlement) FROM stdin;
34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
45	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
46	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
47	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
49	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
51	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
52	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
53	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
54	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
55	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
56	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
57	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
58	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
60	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
62	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
63	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
64	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
65	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
66	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
67	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
68	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
69	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
70	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
71	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
72	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
73	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
74	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
75	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
76	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
77	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
78	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
79	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
80	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
81	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
82	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
83	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
84	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
85	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
86	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
87	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
88	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
89	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
90	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
91	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
92	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
93	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
94	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
95	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
96	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
97	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
98	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
99	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
100	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
101	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
102	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
103	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
104	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
105	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
106	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
107	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
108	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
109	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
110	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
111	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
112	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
113	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
114	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
115	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
116	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
117	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
118	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
119	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
120	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
121	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
122	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
123	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
124	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
125	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
126	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
127	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
128	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
129	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
130	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
131	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
132	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
133	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
134	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
135	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
136	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
137	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
138	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
139	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
140	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
141	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
142	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
143	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
144	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
145	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
146	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
147	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
148	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
149	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
150	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
151	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
153	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
154	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
155	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
156	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
157	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
158	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
159	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
160	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
161	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
162	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
163	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
164	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
165	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
166	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
167	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
168	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
169	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
170	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
171	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
172	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
173	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
174	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
175	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
176	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
177	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
178	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
179	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
180	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
181	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
182	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
183	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
184	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
185	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
186	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
187	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
188	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
189	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
190	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
191	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
192	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
193	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
194	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
195	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
196	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
197	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
198	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
199	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
200	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
201	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
202	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
203	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
204	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
207	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
208	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
209	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
210	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
211	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
212	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
213	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
214	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
215	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
216	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
217	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
218	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
219	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
220	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
221	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
222	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
224	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
225	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
226	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
227	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
228	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
229	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
230	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
231	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
232	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
233	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
234	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
235	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
236	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
237	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
238	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
239	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
240	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
241	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
242	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
243	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
244	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
245	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
246	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
247	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
248	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
249	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
250	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
251	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
252	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
253	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
254	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
255	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
256	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
257	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
258	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
259	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
260	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
261	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
262	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
263	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
264	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
265	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
266	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
267	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
268	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
269	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
270	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
271	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
272	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
273	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
274	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
275	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
276	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
277	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
278	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
279	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
280	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
281	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
282	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
283	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
284	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
285	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
286	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
287	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
288	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
289	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
290	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
291	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
292	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
293	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
294	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
295	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
296	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
297	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
298	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
299	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
300	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
301	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
302	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
303	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
304	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
305	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
306	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
307	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
308	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
309	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
310	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
311	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
312	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
313	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
314	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
315	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
316	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
317	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
318	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
319	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
320	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
321	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
322	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
323	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
324	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
325	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
326	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
327	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
328	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
329	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
330	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
331	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
332	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
333	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
334	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
335	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
336	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
337	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
338	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
339	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
340	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
341	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
342	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
343	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
344	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
345	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
346	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
347	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
348	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
349	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
350	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
351	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
352	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
353	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
354	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
355	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
356	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
357	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
358	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
359	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
360	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
361	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
362	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
363	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
364	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
365	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
366	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
367	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
368	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
369	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
370	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
371	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
372	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
373	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
374	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
375	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
376	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
377	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
378	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
379	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
380	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
381	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
382	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
383	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
384	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
385	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
386	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
387	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
388	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
389	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
390	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
391	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
392	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
393	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
394	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
395	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
396	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
397	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
398	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
399	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
400	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
401	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
402	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
403	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
404	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
405	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
406	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
407	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
408	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
409	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
410	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
411	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
412	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
413	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
414	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
415	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
416	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
417	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
418	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
419	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
420	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
421	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
422	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
423	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
424	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
425	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
426	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
\.


--
-- Data for Name: adodb_logsql; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.adodb_logsql (id, created, sql0, sql1, params, tracer, timer) FROM stdin;
\.


--
-- Data for Name: assignment_config; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.assignment_config (assignment_id, assignment_type_id, title, assigned_date, due_date, points, description, benchmarks, school_term_id) FROM stdin;
6	1	Attendance and Participation (5%)	2020-01-24	2020-01-25	100	Every lecturer must determine attendance and participation of students in all course activities	\N	201
4	1	Presentation (10%)	2020-01-24	2020-01-25	100	Usually individual or group presentation depending on the nature of the course.	\N	201
1	1	Paper1 (10%)	2020-01-24	2020-01-25	100	The first typed assignment, it could also mean short one page summaries grouped together to mean the first paper.	\N	201
2	1	Paper2 (10%)	2020-01-24	2020-01-25	100	This is usually a more demanding paper dealing with a major part of the course.	\N	201
5	1	Paper3 (15%)	2020-01-24	2020-01-25	100	This could be a term paper, or term project, but not final paper or project.	\N	201
3	2	EX (50%)	2020-01-24	2020-01-25	100	This is the final written examination, project or research paper that takes the place of an examination.	\N	201
\.


--
-- Data for Name: assignment_type_config; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.assignment_type_config (assignment_type_id, title, final_grade_percent, school_id, hcolor) FROM stdin;
1	Course Work	0.5	3	1111db
2	Exam	0.5	3	ff0088
\.


--
-- Data for Name: attendance_code_cats_settings; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.attendance_code_cats_settings (id, school_year, school_id, title, rollover_id) FROM stdin;
\.


--
-- Data for Name: attendance_codes_settings; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.attendance_codes_settings (id, school_year, school_id, title, short_name, type, state_code, default_code, table_name, sort_order, is_daily_code) FROM stdin;
1	2007	1	\N	\N	teacher	P	Y	0	\N	Y
2	2016	3	Present	PT	teacher	P	Y	0	1	Y
3	2016	3	Absent	AB	teacher	A	\N	0	2	Y
4	2016	3	Absent With Permission	AWP	teacher	H	\N	0	3	Y
5	2017	3	Present	PT	teacher	P	Y	0	1	Y
6	2017	3	Absent	AB	teacher	A	\N	0	2	Y
7	2017	3	Absent With Permission	AWP	teacher	H	\N	0	3	Y
8	2018	3	Present	PT	teacher	P	Y	0	1	Y
9	2018	3	Absent	AB	teacher	A	\N	0	2	Y
10	2018	3	Absent With Permission	AWP	teacher	H	\N	0	3	Y
11	2019	3	Present	PT	teacher	P	Y	0	1	Y
12	2019	3	Absent	AB	teacher	A	\N	0	2	Y
13	2019	3	Absent With Permission	AWP	teacher	H	\N	0	3	Y
\.


--
-- Data for Name: attendance_teacher_filled; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.attendance_teacher_filled (user_id, school_date, school_period_id) FROM stdin;
\.


--
-- Data for Name: available_modprog; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.available_modprog (modname, user_id, profile_id) FROM stdin;
\.


--
-- Data for Name: billing_student_fees; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.billing_student_fees (student_id, assigned_date, due_date, comments, id, title, amount, school_id, school_year, waived_fee_id, old_id, paip, debt, categories, balance_debt, cancellation, payment_category_id) FROM stdin;
181	2016-10-21	2016-12-31	All Paid	1	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
487	2016-10-21	2016-12-31	All Paid	2	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
460	2016-10-21	2016-12-31	All Paid	3	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
494	2016-10-21	2016-12-31	All Paid	4	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
461	2016-10-21	2016-12-31	All Paid	5	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
170	2016-10-21	2016-12-31	All Paid	6	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
488	2016-10-21	2016-12-31	All Paid	7	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
456	2016-10-21	2016-12-31	All Paid	8	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
439	2016-10-21	2016-12-31	All Paid	9	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
465	2016-10-21	2016-12-31	All Paid	10	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
466	2016-10-21	2016-12-31	All Paid	11	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
462	2016-10-21	2016-12-31	All Paid	12	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
97	2016-10-21	2016-12-31	All Paid	13	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
463	2016-10-21	2016-12-31	All Paid	14	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
464	2016-10-21	2016-12-31	All Paid	15	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
486	2016-10-21	2016-12-31	All Paid	16	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
171	2016-10-21	2016-12-31	All Paid	17	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
467	2016-10-21	2016-12-31	All Paid	18	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
413	2016-10-21	2016-12-31	All Paid	19	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
468	2016-10-21	2016-12-31	All Paid	20	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
469	2016-10-21	2016-12-31	All Paid	21	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
481	2016-10-21	2016-12-31	All Paid	22	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
480	2016-10-21	2016-12-31	All Paid	23	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
182	2016-10-21	2016-12-31	All Paid	24	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
455	2016-10-21	2016-12-31	All Paid	25	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
409	2016-10-21	2016-12-31	All Paid	26	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
172	2016-10-21	2016-12-31	All Paid	27	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
457	2016-10-21	2016-12-31	All Paid	28	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
414	2016-10-21	2016-12-31	All Paid	29	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
470	2016-10-21	2016-12-31	All Paid	30	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
183	2016-10-21	2016-12-31	All Paid	31	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
471	2016-10-21	2016-12-31	All Paid	32	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
472	2016-10-21	2016-12-31	All Paid	33	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
458	2016-10-21	2016-12-31	All Paid	34	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
173	2016-10-21	2016-12-31	All Paid	35	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
496	2016-10-21	2016-12-31	All Paid	36	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
491	2016-10-21	2016-12-31	All Paid	37	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
176	2016-10-21	2016-12-31	All Paid	38	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
415	2016-10-21	2016-12-31	All Paid	39	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
184	2016-10-21	2016-12-31	All Paid	40	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
416	2016-10-21	2016-12-31	All Paid	41	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
438	2016-10-21	2016-12-31	All Paid	42	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
429	2016-10-21	2016-12-31	All Paid	43	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
431	2016-10-21	2016-12-31	All Paid	44	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
432	2016-10-21	2016-12-31	All Paid	45	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
473	2016-10-21	2016-12-31	All Paid	46	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
433	2016-10-21	2016-12-31	All Paid	47	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
474	2016-10-21	2016-12-31	All Paid	48	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
434	2016-10-21	2016-12-31	All Paid	49	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
441	2016-10-21	2016-12-31	All Paid	50	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
185	2016-10-21	2016-12-31	All Paid	51	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
498	2016-10-21	2016-12-31	All Paid	52	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
435	2016-10-21	2016-12-31	All Paid	53	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
475	2016-10-21	2016-12-31	All Paid	54	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
476	2016-10-21	2016-12-31	All Paid	55	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
497	2016-10-21	2016-12-31	All Paid	56	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
444	2016-10-21	2016-12-31	All Paid	57	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
142	2016-10-21	2016-12-31	All Paid	58	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
440	2016-10-21	2016-12-31	All Paid	59	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
436	2016-10-21	2016-12-31	All Paid	60	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
445	2016-10-21	2016-12-31	All Paid	61	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
417	2016-10-21	2016-12-31	All Paid	62	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
437	2016-10-21	2016-12-31	All Paid	63	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
186	2016-10-21	2016-12-31	All Paid	64	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
454	2016-10-21	2016-12-31	All Paid	65	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
143	2016-10-21	2016-12-31	All Paid	66	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
477	2016-10-21	2016-12-31	All Paid	67	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
187	2016-10-21	2016-12-31	All Paid	68	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
484	2016-10-21	2016-12-31	All Paid	69	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
199	2016-10-21	2016-12-31	All Paid	70	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
489	2016-10-21	2016-12-31	All Paid	71	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
418	2016-10-21	2016-12-31	All Paid	72	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
446	2016-10-21	2016-12-31	All Paid	73	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
193	2016-10-21	2016-12-31	All Paid	74	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
198	2016-10-21	2016-12-31	All Paid	75	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
443	2016-10-21	2016-12-31	All Paid	76	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
448	2016-10-21	2016-12-31	All Paid	77	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
144	2016-10-21	2016-12-31	All Paid	78	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
493	2016-10-21	2016-12-31	All Paid	79	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
490	2016-10-21	2016-12-31	All Paid	80	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
178	2016-10-21	2016-12-31	All Paid	81	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
145	2016-10-21	2016-12-31	All Paid	82	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
450	2016-10-21	2016-12-31	All Paid	83	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
197	2016-10-21	2016-12-31	All Paid	84	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
453	2016-10-21	2016-12-31	All Paid	85	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
451	2016-10-21	2016-12-31	All Paid	86	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
419	2016-10-21	2016-12-31	All Paid	87	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
420	2016-10-21	2016-12-31	All Paid	88	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
421	2016-10-21	2016-12-31	All Paid	89	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
422	2016-10-21	2016-12-31	All Paid	90	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
194	2016-10-21	2016-12-31	All Paid	91	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
146	2016-10-21	2016-12-31	All Paid	92	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
190	2016-10-21	2016-12-31	All Paid	93	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
128	2016-10-21	2016-12-31	All Paid	94	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
483	2016-10-21	2016-12-31	All Paid	95	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
423	2016-10-21	2016-12-31	All Paid	96	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
424	2016-10-21	2016-12-31	All Paid	97	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
478	2016-10-21	2016-12-31	All Paid	98	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
425	2016-10-21	2016-12-31	All Paid	99	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
179	2016-10-21	2016-12-31	All Paid	100	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
485	2016-10-21	2016-12-31	All Paid	101	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
426	2016-10-21	2016-12-31	All Paid	102	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
495	2016-10-21	2016-12-31	All Paid	103	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
427	2016-10-21	2016-12-31	All Paid	104	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
188	2016-10-21	2016-12-31	All Paid	105	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
479	2016-10-21	2016-12-31	All Paid	106	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
492	2016-10-21	2016-12-31	All Paid	107	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
482	2016-10-21	2016-12-31	All Paid	108	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
147	2016-10-21	2016-12-31	All Paid	109	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
180	2016-10-21	2016-12-31	All Paid	110	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
148	2016-10-21	2016-12-31	All Paid	111	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
428	2016-10-21	2016-12-31	All Paid	112	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
447	2016-10-21	2016-12-31	All Paid	113	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
181	2016-10-21	2016-12-31	All Paid	114	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
487	2016-10-21	2016-12-31	All Paid	115	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
460	2016-10-21	2016-12-31	All Paid	116	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
494	2016-10-21	2016-12-31	All Paid	117	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
461	2016-10-21	2016-12-31	All Paid	118	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
170	2016-10-21	2016-12-31	All Paid	119	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
488	2016-10-21	2016-12-31	All Paid	120	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
456	2016-10-21	2016-12-31	All Paid	121	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
439	2016-10-21	2016-12-31	All Paid	122	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
465	2016-10-21	2016-12-31	All Paid	123	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
466	2016-10-21	2016-12-31	All Paid	124	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
462	2016-10-21	2016-12-31	All Paid	125	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
97	2016-10-21	2016-12-31	All Paid	126	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
463	2016-10-21	2016-12-31	All Paid	127	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
464	2016-10-21	2016-12-31	All Paid	128	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
486	2016-10-21	2016-12-31	All Paid	129	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
171	2016-10-21	2016-12-31	All Paid	130	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
467	2016-10-21	2016-12-31	All Paid	131	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
413	2016-10-21	2016-12-31	All Paid	132	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
468	2016-10-21	2016-12-31	All Paid	133	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
469	2016-10-21	2016-12-31	All Paid	134	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
481	2016-10-21	2016-12-31	All Paid	135	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
480	2016-10-21	2016-12-31	All Paid	136	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
182	2016-10-21	2016-12-31	All Paid	137	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
455	2016-10-21	2016-12-31	All Paid	138	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
409	2016-10-21	2016-12-31	All Paid	139	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
172	2016-10-21	2016-12-31	All Paid	140	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
457	2016-10-21	2016-12-31	All Paid	141	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
414	2016-10-21	2016-12-31	All Paid	142	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
470	2016-10-21	2016-12-31	All Paid	143	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
183	2016-10-21	2016-12-31	All Paid	144	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
471	2016-10-21	2016-12-31	All Paid	145	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
472	2016-10-21	2016-12-31	All Paid	146	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
458	2016-10-21	2016-12-31	All Paid	147	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
173	2016-10-21	2016-12-31	All Paid	148	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
496	2016-10-21	2016-12-31	All Paid	149	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
491	2016-10-21	2016-12-31	All Paid	150	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
176	2016-10-21	2016-12-31	All Paid	151	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
415	2016-10-21	2016-12-31	All Paid	152	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
184	2016-10-21	2016-12-31	All Paid	153	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
416	2016-10-21	2016-12-31	All Paid	154	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
438	2016-10-21	2016-12-31	All Paid	155	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
429	2016-10-21	2016-12-31	All Paid	156	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
431	2016-10-21	2016-12-31	All Paid	157	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
432	2016-10-21	2016-12-31	All Paid	158	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
473	2016-10-21	2016-12-31	All Paid	159	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
433	2016-10-21	2016-12-31	All Paid	160	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
474	2016-10-21	2016-12-31	All Paid	161	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
434	2016-10-21	2016-12-31	All Paid	162	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
441	2016-10-21	2016-12-31	All Paid	163	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
185	2016-10-21	2016-12-31	All Paid	164	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
498	2016-10-21	2016-12-31	All Paid	165	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
435	2016-10-21	2016-12-31	All Paid	166	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
475	2016-10-21	2016-12-31	All Paid	167	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
476	2016-10-21	2016-12-31	All Paid	168	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
497	2016-10-21	2016-12-31	All Paid	169	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
444	2016-10-21	2016-12-31	All Paid	170	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
142	2016-10-21	2016-12-31	All Paid	171	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
440	2016-10-21	2016-12-31	All Paid	172	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
436	2016-10-21	2016-12-31	All Paid	173	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
445	2016-10-21	2016-12-31	All Paid	174	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
417	2016-10-21	2016-12-31	All Paid	175	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
437	2016-10-21	2016-12-31	All Paid	176	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
186	2016-10-21	2016-12-31	All Paid	177	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
454	2016-10-21	2016-12-31	All Paid	178	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
143	2016-10-21	2016-12-31	All Paid	179	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
477	2016-10-21	2016-12-31	All Paid	180	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
187	2016-10-21	2016-12-31	All Paid	181	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
484	2016-10-21	2016-12-31	All Paid	182	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
199	2016-10-21	2016-12-31	All Paid	183	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
489	2016-10-21	2016-12-31	All Paid	184	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
418	2016-10-21	2016-12-31	All Paid	185	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
446	2016-10-21	2016-12-31	All Paid	186	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
193	2016-10-21	2016-12-31	All Paid	187	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
198	2016-10-21	2016-12-31	All Paid	188	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
443	2016-10-21	2016-12-31	All Paid	189	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
448	2016-10-21	2016-12-31	All Paid	190	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
144	2016-10-21	2016-12-31	All Paid	191	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
493	2016-10-21	2016-12-31	All Paid	192	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
490	2016-10-21	2016-12-31	All Paid	193	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
178	2016-10-21	2016-12-31	All Paid	194	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
145	2016-10-21	2016-12-31	All Paid	195	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
450	2016-10-21	2016-12-31	All Paid	196	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
197	2016-10-21	2016-12-31	All Paid	197	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
453	2016-10-21	2016-12-31	All Paid	198	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
451	2016-10-21	2016-12-31	All Paid	199	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
419	2016-10-21	2016-12-31	All Paid	200	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
420	2016-10-21	2016-12-31	All Paid	201	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
421	2016-10-21	2016-12-31	All Paid	202	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
422	2016-10-21	2016-12-31	All Paid	203	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
194	2016-10-21	2016-12-31	All Paid	204	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
146	2016-10-21	2016-12-31	All Paid	205	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
190	2016-10-21	2016-12-31	All Paid	206	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
128	2016-10-21	2016-12-31	All Paid	207	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
483	2016-10-21	2016-12-31	All Paid	208	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
423	2016-10-21	2016-12-31	All Paid	209	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
424	2016-10-21	2016-12-31	All Paid	210	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
478	2016-10-21	2016-12-31	All Paid	211	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
425	2016-10-21	2016-12-31	All Paid	212	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
179	2016-10-21	2016-12-31	All Paid	213	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
485	2016-10-21	2016-12-31	All Paid	214	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
426	2016-10-21	2016-12-31	All Paid	215	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
495	2016-10-21	2016-12-31	All Paid	216	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
427	2016-10-21	2016-12-31	All Paid	217	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
188	2016-10-21	2016-12-31	All Paid	218	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
479	2016-10-21	2016-12-31	All Paid	219	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
492	2016-10-21	2016-12-31	All Paid	220	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
482	2016-10-21	2016-12-31	All Paid	221	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
147	2016-10-21	2016-12-31	All Paid	222	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
180	2016-10-21	2016-12-31	All Paid	223	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
148	2016-10-21	2016-12-31	All Paid	224	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
428	2016-10-21	2016-12-31	All Paid	225	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
447	2016-10-21	2016-12-31	All Paid	226	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
460	2016-10-21	2016-10-21	Jesuit Rate	227	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
494	2016-10-21	2016-10-21	Jesuit Rate	228	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
488	2016-10-21	2016-10-21	Jesuit Rate	229	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
456	2016-10-21	2016-10-21	Jesuit Rate	230	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
481	2016-10-21	2016-10-21	Jesuit Rate	231	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
455	2016-10-21	2016-10-21	Jesuit Rate	232	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
457	2016-10-21	2016-10-21	Jesuit Rate	233	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
496	2016-10-21	2016-10-21	Jesuit Rate	234	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
438	2016-10-21	2016-10-21	Jesuit Rate	235	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
498	2016-10-21	2016-10-21	Jesuit Rate	236	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
497	2016-10-21	2016-10-21	Jesuit Rate	237	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
199	2016-10-21	2016-10-21	Jesuit Rate	238	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
198	2016-10-21	2016-10-21	Jesuit Rate	239	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
197	2016-10-21	2016-10-21	Jesuit Rate	240	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
453	2016-10-21	2016-10-21	Jesuit Rate	241	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
451	2016-10-21	2016-10-21	Jesuit Rate	242	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
485	2016-10-21	2016-10-21	Jesuit Rate	243	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
495	2016-10-21	2016-10-21	Jesuit Rate	244	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
439	2016-10-21	2016-12-31	Lay Zimbabwe Rate	245	Semester 1 Tuition	1300	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
409	2016-10-21	2016-12-31	Lay Zimbabwe Rate	246	Semester 1 Tuition	1300	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
458	2016-10-21	2016-12-31	Lay Zimbabwe Rate	247	Semester 1 Tuition	1300	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
475	2016-10-21	2016-12-31	Lay Zimbabwe Rate	248	Semester 1 Tuition	1300	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
443	2016-10-21	2016-12-31	Lay Zimbabwe Rate	249	Semester 1 Tuition	1300	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
441	2016-10-21	2016-12-31	Non SJ Religious Rate	250	Semester 1 Tuition	2310	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
476	2016-10-21	2016-12-31	Non SJ Religious Rate	251	Semester 1 Tuition	2310	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
440	2016-10-21	2016-12-31	Non SJ Religious Rate	252	Semester 1 Tuition	2310	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
454	2016-10-21	2016-12-31	Non SJ Religious Rate	253	Semester 1 Tuition	2310	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
461	2016-10-21	2016-12-31	Jesuit Rate	254	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
465	2016-10-21	2016-12-31	Jesuit Rate	255	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
463	2016-10-21	2016-12-31	Jesuit Rate	256	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
413	2016-10-21	2016-12-31	Jesuit Rate	257	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
468	2016-10-21	2016-12-31	Jesuit Rate	258	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
469	2016-10-21	2016-12-31	Jesuit Rate	259	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
480	2016-10-21	2016-12-31	Jesuit Rate	260	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
414	2016-10-21	2016-12-31	Jesuit Rate	261	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
470	2016-10-21	2016-12-31	Jesuit Rate	262	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
471	2016-10-21	2016-12-31	Jesuit Rate	263	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
491	2016-10-21	2016-12-31	Jesuit Rate	264	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
415	2016-10-21	2016-12-31	Jesuit Rate	265	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
416	2016-10-21	2016-12-31	Jesuit Rate	266	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
417	2016-10-21	2016-12-31	Jesuit Rate	267	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
484	2016-10-21	2016-12-31	Jesuit Rate	268	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
489	2016-10-21	2016-12-31	Jesuit Rate	269	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
418	2016-10-21	2016-12-31	Jesuit Rate	270	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
493	2016-10-21	2016-12-31	Jesuit Rate	271	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
490	2016-10-21	2016-12-31	Jesuit Rate	272	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
419	2016-10-21	2016-12-31	Jesuit Rate	273	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
420	2016-10-21	2016-12-31	Jesuit Rate	274	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
421	2016-10-21	2016-12-31	Jesuit Rate	275	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
422	2016-10-21	2016-12-31	Jesuit Rate	276	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
483	2016-10-21	2016-12-31	Jesuit Rate	277	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
423	2016-10-21	2016-12-31	Jesuit Rate	278	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
424	2016-10-21	2016-12-31	Jesuit Rate	279	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
425	2016-10-21	2016-12-31	Jesuit Rate	280	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
427	2016-10-21	2016-12-31	Jesuit Rate	281	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
479	2016-10-21	2016-12-31	Jesuit Rate	282	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
492	2016-10-21	2016-12-31	Jesuit Rate	283	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
482	2016-10-21	2016-12-31	Jesuit Rate	284	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
428	2016-10-21	2016-12-31	Jesuit Rate	285	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
462	2016-10-21	2016-12-31	Non SJ Religious Rate	286	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
486	2016-10-21	2016-12-31	Non SJ Religious Rate	287	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
472	2016-10-21	2016-12-31	Non SJ Religious Rate	288	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
429	2016-10-21	2016-12-31	Non SJ Religious Rate	289	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
473	2016-10-21	2016-12-31	Non SJ Religious Rate	290	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
474	2016-10-21	2016-12-31	Non SJ Religious Rate	291	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
426	2016-10-21	2016-12-31	Zimbabwe Student	292	Semester 1 Tuition	1000	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
170	2016-10-21	2016-12-31	Jesuit Rate	293	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
171	2016-10-21	2016-12-31	Jesuit Rate	294	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
172	2016-10-21	2016-12-31	Jesuit Rate	295	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
173	2016-10-21	2016-12-31	Jesuit Rate	296	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
176	2016-10-21	2016-12-31	Jesuit Rate	297	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
142	2016-10-21	2016-12-31	Jesuit Rate	298	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
445	2016-10-21	2016-12-31	Jesuit Rate	299	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
143	2016-10-21	2016-12-31	Jesuit Rate	300	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
446	2016-10-21	2016-12-31	Jesuit Rate	301	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
193	2016-10-21	2016-12-31	Jesuit Rate	302	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
144	2016-10-21	2016-12-31	Jesuit Rate	303	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
178	2016-10-21	2016-12-31	Jesuit Rate	304	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
145	2016-10-21	2016-12-31	Jesuit Rate	305	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
450	2016-10-21	2016-12-31	Jesuit Rate	306	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
194	2016-10-21	2016-12-31	Jesuit Rate	307	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
146	2016-10-21	2016-12-31	Jesuit Rate	308	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
128	2016-10-21	2016-12-31	Jesuit Rate	309	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
179	2016-10-21	2016-12-31	Jesuit Rate	310	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
147	2016-10-21	2016-12-31	Jesuit Rate	311	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
180	2016-10-21	2016-12-31	Jesuit Rate	312	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
148	2016-10-21	2016-12-31	Jesuit Rate	313	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
447	2016-10-21	2016-12-31	Non SJ Religious 	314	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
448	2016-10-21	2016-12-31	Zimbabwe Student	315	Semester 1 Tuition	1000	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
466	2016-10-21	2016-12-31	Non SJ Religious	316	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
464	2016-10-21	2016-12-31	Non SJ Religious	317	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
467	2016-10-21	2016-12-31	Non SJ Religious	318	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
182	2016-10-21	2016-12-31	Non SJ Religious	319	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
183	2016-10-21	2016-12-31	Non SJ Religious	320	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
431	2016-10-21	2016-12-31	Non SJ Religious	321	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
432	2016-10-21	2016-12-31	Non SJ Religious	322	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
433	2016-10-21	2016-12-31	Non SJ Religious	323	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
434	2016-10-21	2016-12-31	Non SJ Religious	324	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
185	2016-10-21	2016-12-31	Non SJ Religious	325	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
435	2016-10-21	2016-12-31	Non SJ Religious	326	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
436	2016-10-21	2016-12-31	Non SJ Religious	327	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
437	2016-10-21	2016-12-31	Non SJ Religious	328	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
186	2016-10-21	2016-12-31	Non SJ Religious	329	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
477	2016-10-21	2016-12-31	Non SJ Religious	330	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
187	2016-10-21	2016-12-31	Non SJ Religious	331	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
190	2016-10-21	2016-12-31	Non SJ Religious	332	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
188	2016-10-21	2016-12-31	Non SJ Religious	333	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
181	2016-10-21	2016-12-31	Jesuit Rate	334	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
487	2016-10-21	2016-12-31	Jesuit Rate	335	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
184	2016-10-21	2016-12-31	Jesuit Rate	336	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
478	2016-10-21	2016-12-31	Jesuit Rate	337	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
181	2016-10-21	2016-12-31	Lunch Flate Rate	338	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
487	2016-10-21	2016-12-31	Lunch Flate Rate	339	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
460	2016-10-21	2016-12-31	Lunch Flate Rate	340	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
494	2016-10-21	2016-12-31	Lunch Flate Rate	341	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
461	2016-10-21	2016-12-31	Lunch Flate Rate	342	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
170	2016-10-21	2016-12-31	Lunch Flate Rate	343	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
488	2016-10-21	2016-12-31	Lunch Flate Rate	344	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
456	2016-10-21	2016-12-31	Lunch Flate Rate	345	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
439	2016-10-21	2016-12-31	Lunch Flate Rate	346	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
465	2016-10-21	2016-12-31	Lunch Flate Rate	347	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
466	2016-10-21	2016-12-31	Lunch Flate Rate	348	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
462	2016-10-21	2016-12-31	Lunch Flate Rate	349	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
97	2016-10-21	2016-12-31	Lunch Flate Rate	350	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
463	2016-10-21	2016-12-31	Lunch Flate Rate	351	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
464	2016-10-21	2016-12-31	Lunch Flate Rate	352	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
486	2016-10-21	2016-12-31	Lunch Flate Rate	353	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
171	2016-10-21	2016-12-31	Lunch Flate Rate	354	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
467	2016-10-21	2016-12-31	Lunch Flate Rate	355	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
413	2016-10-21	2016-12-31	Lunch Flate Rate	356	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
468	2016-10-21	2016-12-31	Lunch Flate Rate	357	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
469	2016-10-21	2016-12-31	Lunch Flate Rate	358	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
481	2016-10-21	2016-12-31	Lunch Flate Rate	359	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
480	2016-10-21	2016-12-31	Lunch Flate Rate	360	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
182	2016-10-21	2016-12-31	Lunch Flate Rate	361	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
455	2016-10-21	2016-12-31	Lunch Flate Rate	362	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
409	2016-10-21	2016-12-31	Lunch Flate Rate	363	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
172	2016-10-21	2016-12-31	Lunch Flate Rate	364	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
457	2016-10-21	2016-12-31	Lunch Flate Rate	365	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
414	2016-10-21	2016-12-31	Lunch Flate Rate	366	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
470	2016-10-21	2016-12-31	Lunch Flate Rate	367	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
183	2016-10-21	2016-12-31	Lunch Flate Rate	368	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
471	2016-10-21	2016-12-31	Lunch Flate Rate	369	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
472	2016-10-21	2016-12-31	Lunch Flate Rate	370	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
458	2016-10-21	2016-12-31	Lunch Flate Rate	371	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
173	2016-10-21	2016-12-31	Lunch Flate Rate	372	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
496	2016-10-21	2016-12-31	Lunch Flate Rate	373	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
491	2016-10-21	2016-12-31	Lunch Flate Rate	374	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
176	2016-10-21	2016-12-31	Lunch Flate Rate	375	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
415	2016-10-21	2016-12-31	Lunch Flate Rate	376	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
184	2016-10-21	2016-12-31	Lunch Flate Rate	377	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
416	2016-10-21	2016-12-31	Lunch Flate Rate	378	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
438	2016-10-21	2016-12-31	Lunch Flate Rate	379	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
429	2016-10-21	2016-12-31	Lunch Flate Rate	380	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
431	2016-10-21	2016-12-31	Lunch Flate Rate	381	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
432	2016-10-21	2016-12-31	Lunch Flate Rate	382	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
473	2016-10-21	2016-12-31	Lunch Flate Rate	383	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
433	2016-10-21	2016-12-31	Lunch Flate Rate	384	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
474	2016-10-21	2016-12-31	Lunch Flate Rate	385	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
434	2016-10-21	2016-12-31	Lunch Flate Rate	386	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
441	2016-10-21	2016-12-31	Lunch Flate Rate	387	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
185	2016-10-21	2016-12-31	Lunch Flate Rate	388	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
498	2016-10-21	2016-12-31	Lunch Flate Rate	389	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
435	2016-10-21	2016-12-31	Lunch Flate Rate	390	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
475	2016-10-21	2016-12-31	Lunch Flate Rate	391	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
476	2016-10-21	2016-12-31	Lunch Flate Rate	392	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
497	2016-10-21	2016-12-31	Lunch Flate Rate	393	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
444	2016-10-21	2016-12-31	Lunch Flate Rate	394	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
142	2016-10-21	2016-12-31	Lunch Flate Rate	395	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
440	2016-10-21	2016-12-31	Lunch Flate Rate	396	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
436	2016-10-21	2016-12-31	Lunch Flate Rate	397	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
445	2016-10-21	2016-12-31	Lunch Flate Rate	398	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
417	2016-10-21	2016-12-31	Lunch Flate Rate	399	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
437	2016-10-21	2016-12-31	Lunch Flate Rate	400	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
186	2016-10-21	2016-12-31	Lunch Flate Rate	401	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
454	2016-10-21	2016-12-31	Lunch Flate Rate	402	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
143	2016-10-21	2016-12-31	Lunch Flate Rate	403	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
477	2016-10-21	2016-12-31	Lunch Flate Rate	404	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
187	2016-10-21	2016-12-31	Lunch Flate Rate	405	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
484	2016-10-21	2016-12-31	Lunch Flate Rate	406	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
199	2016-10-21	2016-12-31	Lunch Flate Rate	407	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
489	2016-10-21	2016-12-31	Lunch Flate Rate	408	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
418	2016-10-21	2016-12-31	Lunch Flate Rate	409	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
446	2016-10-21	2016-12-31	Lunch Flate Rate	410	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
193	2016-10-21	2016-12-31	Lunch Flate Rate	411	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
198	2016-10-21	2016-12-31	Lunch Flate Rate	412	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
443	2016-10-21	2016-12-31	Lunch Flate Rate	413	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
448	2016-10-21	2016-12-31	Lunch Flate Rate	414	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
144	2016-10-21	2016-12-31	Lunch Flate Rate	415	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
493	2016-10-21	2016-12-31	Lunch Flate Rate	416	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
490	2016-10-21	2016-12-31	Lunch Flate Rate	417	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
178	2016-10-21	2016-12-31	Lunch Flate Rate	418	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
145	2016-10-21	2016-12-31	Lunch Flate Rate	419	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
450	2016-10-21	2016-12-31	Lunch Flate Rate	420	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
197	2016-10-21	2016-12-31	Lunch Flate Rate	421	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
453	2016-10-21	2016-12-31	Lunch Flate Rate	422	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
451	2016-10-21	2016-12-31	Lunch Flate Rate	423	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
419	2016-10-21	2016-12-31	Lunch Flate Rate	424	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
420	2016-10-21	2016-12-31	Lunch Flate Rate	425	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
421	2016-10-21	2016-12-31	Lunch Flate Rate	426	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
422	2016-10-21	2016-12-31	Lunch Flate Rate	427	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
194	2016-10-21	2016-12-31	Lunch Flate Rate	428	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
146	2016-10-21	2016-12-31	Lunch Flate Rate	429	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
190	2016-10-21	2016-12-31	Lunch Flate Rate	430	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
128	2016-10-21	2016-12-31	Lunch Flate Rate	431	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
483	2016-10-21	2016-12-31	Lunch Flate Rate	432	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
423	2016-10-21	2016-12-31	Lunch Flate Rate	433	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
424	2016-10-21	2016-12-31	Lunch Flate Rate	434	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
478	2016-10-21	2016-12-31	Lunch Flate Rate	435	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
425	2016-10-21	2016-12-31	Lunch Flate Rate	436	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
179	2016-10-21	2016-12-31	Lunch Flate Rate	437	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
485	2016-10-21	2016-12-31	Lunch Flate Rate	438	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
426	2016-10-21	2016-12-31	Lunch Flate Rate	439	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
495	2016-10-21	2016-12-31	Lunch Flate Rate	440	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
427	2016-10-21	2016-12-31	Lunch Flate Rate	441	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
188	2016-10-21	2016-12-31	Lunch Flate Rate	442	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
479	2016-10-21	2016-12-31	Lunch Flate Rate	443	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
492	2016-10-21	2016-12-31	Lunch Flate Rate	444	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
482	2016-10-21	2016-12-31	Lunch Flate Rate	445	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
147	2016-10-21	2016-12-31	Lunch Flate Rate	446	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
180	2016-10-21	2016-12-31	Lunch Flate Rate	447	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
148	2016-10-21	2016-12-31	Lunch Flate Rate	448	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
428	2016-10-21	2016-12-31	Lunch Flate Rate	449	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
447	2016-10-21	2016-12-31	Lunch Flate Rate	450	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
460	2016-10-21	2016-12-31	Jesuit Rate	451	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
494	2016-10-21	2016-12-31	Jesuit Rate	452	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
488	2016-10-21	2016-12-31	Jesuit Rate	453	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
456	2016-10-21	2016-12-31	Jesuit Rate	454	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
481	2016-10-21	2016-12-31	Jesuit Rate	455	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
455	2016-10-21	2016-12-31	Jesuit Rate	456	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
457	2016-10-21	2016-12-31	Jesuit Rate	457	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
496	2016-10-21	2016-12-31	Jesuit Rate	458	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
438	2016-10-21	2016-12-31	Jesuit Rate	459	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
498	2016-10-21	2016-12-31	Jesuit Rate	460	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
497	2016-10-21	2016-12-31	Jesuit Rate	461	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
199	2016-10-21	2016-12-31	Jesuit Rate	462	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
198	2016-10-21	2016-12-31	Jesuit Rate	463	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
443	2016-10-21	2016-12-31	Jesuit Rate	464	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
197	2016-10-21	2016-12-31	Jesuit Rate	465	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
453	2016-10-21	2016-12-31	Jesuit Rate	466	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
451	2016-10-21	2016-12-31	Jesuit Rate	467	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
485	2016-10-21	2016-12-31	Jesuit Rate	468	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
495	2016-10-21	2016-12-31	Jesuit Rate	469	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
439	2016-10-21	2016-12-31	Non SJ R. Rate	470	MA Library Fee	180	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
409	2016-10-21	2016-12-31	Non SJ R. Rate	471	MA Library Fee	180	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
458	2016-10-21	2016-12-31	Non SJ R. Rate	472	MA Library Fee	180	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
441	2016-10-21	2016-12-31	Non SJ R. Rate	473	MA Library Fee	180	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
475	2016-10-21	2016-12-31	Non SJ R. Rate	474	MA Library Fee	180	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
476	2016-10-21	2016-12-31	Non SJ R. Rate	475	MA Library Fee	180	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
440	2016-10-21	2016-12-31	Non SJ R. Rate	476	MA Library Fee	180	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
454	2016-10-21	2016-12-31	Non SJ R. Rate	477	MA Library Fee	180	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
461	2016-10-21	2016-12-31	Jesuit Rate	478	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
170	2016-10-21	2016-12-31	Jesuit Rate	479	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
465	2016-10-21	2016-12-31	Jesuit Rate	480	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
463	2016-10-21	2016-12-31	Jesuit Rate	481	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
171	2016-10-21	2016-12-31	Jesuit Rate	482	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
413	2016-10-21	2016-12-31	Jesuit Rate	483	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
468	2016-10-21	2016-12-31	Jesuit Rate	484	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
469	2016-10-21	2016-12-31	Jesuit Rate	485	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
480	2016-10-21	2016-12-31	Jesuit Rate	486	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
172	2016-10-21	2016-12-31	Jesuit Rate	487	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
414	2016-10-21	2016-12-31	Jesuit Rate	488	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
470	2016-10-21	2016-12-31	Jesuit Rate	489	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
471	2016-10-21	2016-12-31	Jesuit Rate	490	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
173	2016-10-21	2016-12-31	Jesuit Rate	491	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
491	2016-10-21	2016-12-31	Jesuit Rate	492	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
176	2016-10-21	2016-12-31	Jesuit Rate	493	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
415	2016-10-21	2016-12-31	Jesuit Rate	494	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
416	2016-10-21	2016-12-31	Jesuit Rate	495	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
142	2016-10-21	2016-12-31	Jesuit Rate	496	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
445	2016-10-21	2016-12-31	Jesuit Rate	497	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
417	2016-10-21	2016-12-31	Jesuit Rate	498	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
143	2016-10-21	2016-12-31	Jesuit Rate	499	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
484	2016-10-21	2016-12-31	Jesuit Rate	500	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
489	2016-10-21	2016-12-31	Jesuit Rate	501	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
418	2016-10-21	2016-12-31	Jesuit Rate	502	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
446	2016-10-21	2016-12-31	Jesuit Rate	503	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
193	2016-10-21	2016-12-31	Jesuit Rate	504	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
448	2016-10-21	2016-12-31	Jesuit Rate	505	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
144	2016-10-21	2016-12-31	Jesuit Rate	506	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
493	2016-10-21	2016-12-31	Jesuit Rate	507	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
490	2016-10-21	2016-12-31	Jesuit Rate	508	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
178	2016-10-21	2016-12-31	Jesuit Rate	509	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
145	2016-10-21	2016-12-31	Jesuit Rate	510	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
450	2016-10-21	2016-12-31	Jesuit Rate	511	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
419	2016-10-21	2016-12-31	Jesuit Rate	512	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
420	2016-10-21	2016-12-31	Jesuit Rate	513	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
421	2016-10-21	2016-12-31	Jesuit Rate	514	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
422	2016-10-21	2016-12-31	Jesuit Rate	515	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
194	2016-10-21	2016-12-31	Jesuit Rate	516	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
146	2016-10-21	2016-12-31	Jesuit Rate	517	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
128	2016-10-21	2016-12-31	Jesuit Rate	518	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
483	2016-10-21	2016-12-31	Jesuit Rate	519	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
423	2016-10-21	2016-12-31	Jesuit Rate	520	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
424	2016-10-21	2016-12-31	Jesuit Rate	521	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
425	2016-10-21	2016-12-31	Jesuit Rate	522	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
179	2016-10-21	2016-12-31	Jesuit Rate	523	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
427	2016-10-21	2016-12-31	Jesuit Rate	524	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
479	2016-10-21	2016-12-31	Jesuit Rate	525	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
492	2016-10-21	2016-12-31	Jesuit Rate	526	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
482	2016-10-21	2016-12-31	Jesuit Rate	527	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
147	2016-10-21	2016-12-31	Jesuit Rate	528	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
180	2016-10-21	2016-12-31	Jesuit Rate	529	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
148	2016-10-21	2016-12-31	Jesuit Rate	530	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
428	2016-10-21	2016-12-31	Jesuit Rate	531	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
181	2016-10-21	2016-12-31	Jesuit Rate	532	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
487	2016-10-21	2016-12-31	Jesuit Rate	533	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
184	2016-10-21	2016-12-31	Jesuit Rate	534	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
478	2016-10-21	2016-12-31	Jesuit Rate	535	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
466	2016-10-21	2016-12-31	Non SJ Library	536	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
464	2016-10-21	2016-12-31	Non SJ Library	537	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
467	2016-10-21	2016-12-31	Non SJ Library	538	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
182	2016-10-21	2016-12-31	Non SJ Library	539	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
183	2016-10-21	2016-12-31	Non SJ Library	540	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
431	2016-10-21	2016-12-31	Non SJ Library	541	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
432	2016-10-21	2016-12-31	Non SJ Library	542	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
433	2016-10-21	2016-12-31	Non SJ Library	543	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
434	2016-10-21	2016-12-31	Non SJ Library	544	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
185	2016-10-21	2016-12-31	Non SJ Library	545	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
435	2016-10-21	2016-12-31	Non SJ Library	546	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
436	2016-10-21	2016-12-31	Non SJ Library	547	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
437	2016-10-21	2016-12-31	Non SJ Library	548	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
186	2016-10-21	2016-12-31	Non SJ Library	549	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
477	2016-10-21	2016-12-31	Non SJ Library	550	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
187	2016-10-21	2016-12-31	Non SJ Library	551	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
190	2016-10-21	2016-12-31	Non SJ Library	552	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
188	2016-10-21	2016-12-31	Non SJ Library	553	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
462	2016-10-21	2016-12-31	Non SJ Library Fee	554	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
486	2016-10-21	2016-12-31	Non SJ Library Fee	555	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
472	2016-10-21	2016-12-31	Non SJ Library Fee	556	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
429	2016-10-21	2016-12-31	Non SJ Library Fee	557	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
473	2016-10-21	2016-12-31	Non SJ Library Fee	558	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
474	2016-10-21	2016-12-31	Non SJ Library Fee	559	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
426	2016-10-21	2016-12-31	Non SJ Library Fee	560	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
447	2016-10-21	2016-12-31	Non SJ Library Fee	561	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
461	2016-10-21	2016-12-31	Jesuit Rate	562	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
170	2016-10-21	2016-12-31	Jesuit Rate	563	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
465	2016-10-21	2016-12-31	Jesuit Rate	564	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
463	2016-10-21	2016-12-31	Jesuit Rate	565	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
171	2016-10-21	2016-12-31	Jesuit Rate	566	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
413	2016-10-21	2016-12-31	Jesuit Rate	567	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
468	2016-10-21	2016-12-31	Jesuit Rate	568	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
469	2016-10-21	2016-12-31	Jesuit Rate	569	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
480	2016-10-21	2016-12-31	Jesuit Rate	570	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
172	2016-10-21	2016-12-31	Jesuit Rate	571	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
414	2016-10-21	2016-12-31	Jesuit Rate	572	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
470	2016-10-21	2016-12-31	Jesuit Rate	573	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
471	2016-10-21	2016-12-31	Jesuit Rate	574	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
173	2016-10-21	2016-12-31	Jesuit Rate	575	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
491	2016-10-21	2016-12-31	Jesuit Rate	576	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
176	2016-10-21	2016-12-31	Jesuit Rate	577	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
415	2016-10-21	2016-12-31	Jesuit Rate	578	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
416	2016-10-21	2016-12-31	Jesuit Rate	579	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
142	2016-10-21	2016-12-31	Jesuit Rate	580	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
445	2016-10-21	2016-12-31	Jesuit Rate	581	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
417	2016-10-21	2016-12-31	Jesuit Rate	582	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
143	2016-10-21	2016-12-31	Jesuit Rate	583	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
484	2016-10-21	2016-12-31	Jesuit Rate	584	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
489	2016-10-21	2016-12-31	Jesuit Rate	585	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
418	2016-10-21	2016-12-31	Jesuit Rate	586	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
446	2016-10-21	2016-12-31	Jesuit Rate	587	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
193	2016-10-21	2016-12-31	Jesuit Rate	588	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
448	2016-10-21	2016-12-31	Jesuit Rate	589	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
144	2016-10-21	2016-12-31	Jesuit Rate	590	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
493	2016-10-21	2016-12-31	Jesuit Rate	591	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
490	2016-10-21	2016-12-31	Jesuit Rate	592	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
178	2016-10-21	2016-12-31	Jesuit Rate	593	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
145	2016-10-21	2016-12-31	Jesuit Rate	594	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
450	2016-10-21	2016-12-31	Jesuit Rate	595	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
419	2016-10-21	2016-12-31	Jesuit Rate	596	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
420	2016-10-21	2016-12-31	Jesuit Rate	597	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
421	2016-10-21	2016-12-31	Jesuit Rate	598	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
422	2016-10-21	2016-12-31	Jesuit Rate	599	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
194	2016-10-21	2016-12-31	Jesuit Rate	600	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
146	2016-10-21	2016-12-31	Jesuit Rate	601	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
128	2016-10-21	2016-12-31	Jesuit Rate	602	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
483	2016-10-21	2016-12-31	Jesuit Rate	603	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
423	2016-10-21	2016-12-31	Jesuit Rate	604	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
424	2016-10-21	2016-12-31	Jesuit Rate	605	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
425	2016-10-21	2016-12-31	Jesuit Rate	606	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
179	2016-10-21	2016-12-31	Jesuit Rate	607	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
427	2016-10-21	2016-12-31	Jesuit Rate	608	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
479	2016-10-21	2016-12-31	Jesuit Rate	609	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
492	2016-10-21	2016-12-31	Jesuit Rate	610	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
482	2016-10-21	2016-12-31	Jesuit Rate	611	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
147	2016-10-21	2016-12-31	Jesuit Rate	612	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
180	2016-10-21	2016-12-31	Jesuit Rate	613	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
148	2016-10-21	2016-12-31	Jesuit Rate	614	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
428	2016-10-21	2016-12-31	Jesuit Rate	615	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
462	2016-10-21	2016-12-31	Student Association Non SJ	616	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
472	2016-10-21	2016-12-31	Student Association Non SJ	617	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
429	2016-10-21	2016-12-31	Student Association Non SJ	618	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
473	2016-10-21	2016-12-31	Student Association Non SJ	619	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
474	2016-10-21	2016-12-31	Student Association Non SJ	620	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
426	2016-10-21	2016-12-31	Student Association Non SJ	621	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
447	2016-10-21	2016-12-31	Student Association Non SJ	622	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
466	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	623	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
464	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	624	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
467	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	625	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
182	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	626	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
183	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	627	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
431	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	628	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
432	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	629	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
433	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	630	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
434	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	631	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
185	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	632	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
435	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	633	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
436	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	634	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
437	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	635	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
186	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	636	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
477	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	637	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
187	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	638	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
190	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	639	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
188	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	640	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
181	2016-10-21	2016-12-31	Student Association Jesuit Rate	641	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
487	2016-10-21	2016-12-31	Student Association Jesuit Rate	642	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
184	2016-10-21	2016-12-31	Student Association Jesuit Rate	643	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
478	2016-10-21	2016-12-31	Student Association Jesuit Rate	644	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
460	2016-10-21	2016-12-31	Jesuit Rate	645	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
494	2016-10-21	2016-12-31	Jesuit Rate	646	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
488	2016-10-21	2016-12-31	Jesuit Rate	647	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
456	2016-10-21	2016-12-31	Jesuit Rate	648	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
481	2016-10-21	2016-12-31	Jesuit Rate	649	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
455	2016-10-21	2016-12-31	Jesuit Rate	650	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
457	2016-10-21	2016-12-31	Jesuit Rate	651	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
496	2016-10-21	2016-12-31	Jesuit Rate	652	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
438	2016-10-21	2016-12-31	Jesuit Rate	653	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
498	2016-10-21	2016-12-31	Jesuit Rate	654	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
497	2016-10-21	2016-12-31	Jesuit Rate	655	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
199	2016-10-21	2016-12-31	Jesuit Rate	656	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
198	2016-10-21	2016-12-31	Jesuit Rate	657	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
443	2016-10-21	2016-12-31	Jesuit Rate	658	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
197	2016-10-21	2016-12-31	Jesuit Rate	659	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
453	2016-10-21	2016-12-31	Jesuit Rate	660	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
451	2016-10-21	2016-12-31	Jesuit Rate	661	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
485	2016-10-21	2016-12-31	Jesuit Rate	662	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
495	2016-10-21	2016-12-31	Jesuit Rate	663	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
494	2017-12-29	2019-12-31	Dec 2017	664	Late Fees	20.00	3	2017	\N	\N	N	20	\N	-3870	\N	5
492	2017-12-29	2020-12-31	Dec 2017	665	Late Fees	20.00	3	2017	\N	\N	N	20	\N	-3360	\N	5
473	2017-12-29	2019-12-31	Dec 2017	666	Over registration	20.00	3	2017	\N	\N	N	20	\N	-2525	\N	6
459	2018-01-03	2018-12-31	\N	667	Late Fees	20.00	3	2017	\N	\N	N	20	\N	0	\N	5
459	2018-01-14	2018-01-12	\N	668	Late Fees	20.00	3	2017	\N	\N	N	20	\N	-20	\N	5
455	2018-01-14	2018-01-12	\N	669	Late Fees	20.00	3	2017	\N	\N	N	20	\N	-3870	\N	5
417	2018-08-07	2019-06-01	Regalia Dues	670	Student Association	217	3	2018	\N	\N	N	217	\N	-3360	\N	3
\.


--
-- Data for Name: billing_student_fees_categories; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.billing_student_fees_categories (id, school_year, school_id, title, system_name) FROM stdin;
1	2016	3	Tuition	other
2	2016	3	Library Fees	other
3	2016	3	Student Association Fee	other
4	2016	3	Meals	sms
5	2017	3	Late Registration	other
6	2017	3	Over-registration	other
\.


--
-- Data for Name: billing_student_fees_old; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.billing_student_fees_old (id, category_id, school_year, school_id, title, amount, apply_all, classlevel_id, course_id, course_credit_title, activity_id, student_field_id, student_field_value, student_id, waived_fee_id) FROM stdin;
\.


--
-- Data for Name: billing_student_payments; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.billing_student_payments (id, school_year, school_id, student_id, amount, payment_date, comments, refunded_payment_id, lunch_payment, transaction_id, cancellation) FROM stdin;
\.


--
-- Data for Name: block_ip; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.block_ip (id, faled_login, time_unlock, ip, date, failed_login) FROM stdin;
888	\N	\N	41.175.82.97	2019-08-16	2
866	\N	\N	105.178.108.78	2019-08-13	5
838	\N	\N	41.175.65.78	2019-08-08	5
867	\N	\N	105.178.112.105	2019-08-13	2
815	\N	\N	197.221.254.226	2019-05-22	1
816	\N	\N	197.221.254.136	2019-05-26	2
817	\N	\N	107.167.107.140	2019-05-28	1
818	\N	\N	154.119.81.206	2019-05-30	2
819	\N	\N	41.63.14.10	2019-06-07	2
820	\N	\N	154.117.216.245	2019-06-11	2
821	\N	\N	102.128.76.22	2019-06-26	1
822	\N	\N	196.248.39.245	2019-07-02	1
868	\N	\N	105.178.112.139	2019-08-13	2
869	\N	\N	105.178.112.90	2019-08-13	1
870	\N	\N	41.175.139.105	2019-08-13	1
872	\N	\N	41.175.85.173	2019-08-14	1
839	\N	\N	196.27.120.18	2019-08-09	9
884	\N	\N	41.175.70.99	2019-08-16	2
823	\N	2019-07-13 21:53:16	107.167.116.94	2019-07-13	\N
824	\N	\N	154.119.81.206	2019-07-18	3
825	\N	\N	154.119.81.206	2019-07-21	1
826	\N	\N	77.246.53.162	2019-07-21	1
827	\N	\N	197.136.148.174	2019-07-24	1
828	\N	\N	41.190.30.203	2019-07-25	1
829	\N	\N	41.60.123.94	2019-08-06	1
841	\N	\N	196.2.14.137	2019-08-09	1
890	\N	\N	154.119.81.206	2019-08-17	1
842	\N	\N	41.60.102.194	2019-08-09	3
843	\N	\N	41.60.77.189	2019-08-09	1
844	\N	\N	196.27.120.18	2019-08-10	1
833	\N	\N	41.175.77.199	2019-08-07	1
845	\N	\N	196.27.120.18	2019-08-11	4
832	\N	\N	154.119.81.206	2019-08-07	3
834	\N	\N	41.60.100.57	2019-08-07	2
922	\N	\N	196.27.117.134	2019-09-20	1
891	\N	\N	41.175.130.151	2019-08-17	3
830	\N	\N	196.27.120.18	2019-08-07	\N
892	\N	\N	95.174.65.19	2019-08-18	2
835	\N	\N	41.175.78.253	2019-08-07	7
846	\N	\N	41.60.103.73	2019-08-11	7
836	\N	\N	196.27.120.18	2019-08-08	4
893	\N	\N	41.60.118.217	2019-08-18	1
847	\N	\N	41.60.85.225	2019-08-11	3
848	\N	\N	82.16.59.135	2019-08-11	1
894	\N	\N	41.175.74.87	2019-08-18	1
849	\N	\N	41.60.107.49	2019-08-12	4
850	\N	\N	197.218.83.27	2019-08-12	1
851	\N	\N	41.60.88.38	2019-08-12	4
898	\N	\N	107.167.109.168	2019-08-19	1
854	\N	\N	41.60.64.10	2019-08-13	3
855	\N	\N	107.181.177.141	2019-08-13	1
856	\N	\N	41.60.107.49	2019-08-13	1
873	\N	\N	196.27.120.18	2019-08-14	9
897	\N	\N	196.27.120.18	2019-08-19	4
874	\N	\N	41.191.239.112	2019-08-14	10
857	\N	\N	41.60.88.38	2019-08-13	7
853	\N	\N	41.60.111.252	2019-08-13	3
858	\N	\N	41.78.78.26	2019-08-13	1
859	\N	\N	41.60.64.156	2019-08-13	5
860	\N	\N	77.246.49.33	2019-08-13	1
862	\N	\N	41.175.95.152	2019-08-13	1
863	\N	\N	154.119.81.206	2019-08-13	3
865	\N	\N	105.178.108.219	2019-08-13	2
905	\N	\N	197.136.148.174	2019-08-21	4
906	\N	\N	196.27.120.18	2019-08-22	1
876	\N	\N	41.60.87.64	2019-08-14	6
877	\N	\N	41.60.126.194	2019-08-14	1
878	\N	\N	41.175.66.218	2019-08-14	1
879	\N	\N	196.27.120.18	2019-08-15	3
880	\N	\N	102.128.76.13	2019-08-15	1
915	\N	\N	196.27.120.7	2019-08-30	2
899	\N	\N	77.246.53.135	2019-08-19	7
900	\N	\N	45.92.32.4	2019-08-19	1
916	\N	\N	41.60.115.198	2019-09-01	1
882	\N	\N	41.175.77.49	2019-08-15	1
881	\N	\N	154.119.81.206	2019-08-15	8
886	\N	\N	154.119.81.206	2019-08-16	1
887	\N	\N	41.60.127.39	2019-08-16	1
908	\N	\N	196.27.120.7	2019-08-28	4
917	\N	\N	196.27.120.7	2019-09-02	1
902	\N	\N	41.60.119.177	2019-08-20	1
909	\N	\N	77.246.50.116	2019-08-29	3
903	\N	\N	41.175.87.102	2019-08-21	3
910	\N	\N	197.211.240.177	2019-08-29	3
911	\N	\N	196.27.120.7	2019-08-29	1
912	\N	\N	41.78.120.196	2019-08-30	1
913	\N	\N	41.78.120.197	2019-08-30	1
927	\N	\N	41.175.73.46	2019-10-02	1
923	\N	\N	84.11.86.194	2019-09-25	4
918	\N	\N	197.180.116.208	2019-09-05	3
919	\N	\N	196.27.120.7	2019-09-09	1
920	\N	\N	154.119.81.206	2019-09-17	2
921	\N	\N	41.175.75.124	2019-09-19	1
924	\N	\N	196.27.120.7	2019-09-26	1
929	\N	\N	196.27.120.7	2019-10-13	1
930	\N	\N	196.27.120.12	2019-10-21	1
982	\N	\N	196.27.120.12	2020-01-09	2
934	\N	\N	197.211.240.177	2019-10-30	3
935	\N	\N	41.60.98.91	2019-11-10	3
936	\N	\N	41.84.132.134	2019-11-14	3
938	\N	\N	138.197.133.117	2019-11-20	1
939	\N	\N	197.221.254.183	2019-11-23	3
983	\N	\N	154.119.81.206	2020-01-10	6
987	\N	\N	41.60.70.241	2020-01-11	1
941	\N	\N	41.60.111.127	2019-12-06	2
1082	\N	\N	41.60.125.77	2020-05-26	2
1085	\N	\N	102.177.195.86	2020-06-01	1
1088	\N	\N	41.174.174.194	2020-06-04	2
1091	\N	\N	102.128.79.53	2020-06-18	3
944	\N	\N	154.120.229.78	2019-12-10	1
945	\N	\N	197.221.254.235	2019-12-10	1
946	\N	\N	41.175.158.194	2019-12-10	1
995	\N	\N	154.119.81.206	2020-01-16	4
996	\N	\N	154.119.81.206	2020-01-17	1
947	\N	\N	41.60.90.27	2019-12-10	6
948	\N	\N	196.27.120.12	2019-12-11	2
949	\N	\N	154.119.81.81	2019-12-16	2
950	\N	\N	41.60.125.185	2019-12-19	4
952	\N	\N	41.60.127.66	2019-12-26	5
953	\N	\N	41.60.100.5	2020-01-01	1
980	\N	2020-01-08 12:51:45	41.175.64.47	2020-01-08	\N
955	\N	\N	41.60.106.197	2020-01-01	2
956	\N	\N	197.221.253.8	2020-01-02	2
957	\N	\N	197.155.239.142	2020-01-02	1
958	\N	\N	41.60.81.252	2020-01-02	2
959	\N	\N	41.60.68.179	2020-01-02	1
979	\N	2020-02-06 23:00:03	197.211.209.123	2020-01-08	\N
852	\N	2020-02-06 23:00:03	197.211.209.123	2019-08-12	\N
1094	\N	\N	82.145.208.93	2020-06-26	2
1097	\N	\N	209.88.92.222	2020-06-27	3
1100	\N	\N	102.177.195.86	2020-07-18	2
960	\N	\N	41.60.81.252	2020-01-03	3
961	\N	\N	41.60.68.179	2020-01-03	1
984	\N	\N	41.175.115.176	2020-01-10	4
985	\N	\N	41.175.115.176	2020-01-11	2
962	\N	\N	41.175.107.113	2020-01-03	4
964	\N	\N	41.60.68.179	2020-01-04	1
966	\N	\N	41.60.112.210	2020-01-04	1
965	\N	\N	41.60.113.189	2020-01-04	5
895	\N	2020-01-11 21:41:06	154.119.82.95	2019-08-18	\N
875	\N	2020-01-11 21:41:06	154.119.82.95	2019-08-14	\N
967	\N	\N	41.60.102.95	2020-01-04	9
963	\N	\N	196.27.120.12	2020-01-04	3
968	\N	\N	41.60.113.189	2020-01-05	1
864	\N	2020-01-11 21:41:06	154.119.82.95	2019-08-13	\N
969	\N	\N	41.175.79.205	2020-01-05	3
933	\N	2020-01-11 21:41:06	154.119.82.95	2019-10-24	\N
986	\N	2020-01-11 21:41:06	154.119.82.95	2020-01-11	\N
989	\N	\N	41.60.112.166	2020-01-13	1
991	\N	\N	196.27.120.12	2020-01-14	1
971	\N	\N	41.175.66.210	2020-01-05	5
972	\N	\N	196.27.120.12	2020-01-05	1
973	\N	\N	197.155.239.142	2020-01-05	1
993	\N	\N	196.27.120.12	2020-01-15	2
975	\N	\N	41.175.66.210	2020-01-06	5
976	\N	\N	41.175.78.92	2020-01-06	1
974	\N	\N	196.27.120.12	2020-01-06	6
1002	\N	\N	197.211.216.73	2020-01-23	10
1003	\N	\N	41.175.67.113	2020-01-24	1
998	\N	\N	41.90.25.102	2020-01-20	5
1005	\N	\N	41.60.126.155	2020-01-24	2
1004	\N	\N	197.211.216.73	2020-01-24	2
1006	\N	\N	197.211.216.73	2020-01-27	1
1001	\N	\N	77.246.52.148	2020-01-22	2
1007	\N	\N	197.211.216.73	2020-01-28	2
1092	\N	\N	41.60.115.157	2020-06-21	1
1083	\N	\N	197.221.251.26	2020-05-27	3
1016	\N	\N	41.175.65.210	2020-02-06	9
1015	\N	\N	41.60.77.148	2020-02-06	\N
837	\N	2020-01-22 16:25:54	197.211.216.73	2019-08-08	\N
997	\N	2020-01-22 16:25:54	197.211.216.73	2020-01-17	\N
813	\N	2020-01-22 16:25:54	197.211.216.73	2019-05-20	\N
814	\N	2020-01-22 16:25:54	197.211.216.73	2019-05-21	\N
889	\N	2020-01-22 16:25:54	197.211.216.73	2019-08-17	\N
840	\N	2020-01-22 16:25:54	197.211.216.73	2019-08-09	\N
831	\N	2020-01-22 16:25:54	197.211.216.73	2019-08-07	\N
981	\N	2020-01-22 16:25:54	197.211.216.73	2020-01-08	\N
904	\N	2020-01-22 16:25:54	197.211.216.73	2019-08-21	\N
871	\N	2020-01-22 16:25:54	197.211.216.73	2019-08-14	\N
861	\N	2020-01-22 16:25:54	197.211.216.73	2019-08-13	\N
914	\N	2020-01-22 16:25:54	197.211.216.73	2019-08-30	\N
988	\N	2020-01-22 16:25:54	197.211.216.73	2020-01-13	\N
896	\N	2020-01-22 16:25:54	197.211.216.73	2019-08-19	\N
907	\N	2020-01-22 16:25:54	197.211.216.73	2019-08-23	\N
885	\N	2020-01-22 16:25:54	197.211.216.73	2019-08-16	\N
901	\N	2020-01-22 16:25:54	197.211.216.73	2019-08-20	\N
925	\N	2020-01-22 16:25:54	197.211.216.73	2019-09-30	\N
926	\N	2020-01-22 16:25:54	197.211.216.73	2019-10-01	\N
932	\N	2020-01-22 16:25:54	197.211.216.73	2019-10-24	\N
937	\N	2020-01-22 16:25:54	197.211.216.73	2019-11-18	\N
940	\N	2020-01-22 16:25:54	197.211.216.73	2019-11-27	\N
990	\N	2020-01-22 16:25:54	197.211.216.73	2020-01-14	\N
942	\N	2020-01-22 16:25:54	197.211.216.73	2019-12-09	\N
943	\N	2020-01-22 16:25:54	197.211.216.73	2019-12-10	\N
951	\N	2020-01-22 16:25:54	197.211.216.73	2019-12-20	\N
992	\N	2020-01-22 16:25:54	197.211.216.73	2020-01-15	\N
977	\N	2020-01-22 16:25:54	197.211.216.73	2020-01-06	\N
994	\N	2020-01-22 16:25:54	197.211.216.73	2020-01-16	\N
999	\N	2020-01-22 16:25:54	197.211.216.73	2020-01-21	\N
1000	\N	2020-01-22 16:25:54	197.211.216.73	2020-01-22	\N
1024	\N	\N	41.60.88.58	2020-02-06	1
1025	\N	\N	41.60.104.172	2020-02-07	1
1031	\N	\N	41.60.67.130	2020-02-08	2
1027	\N	2020-03-23 16:08:31	102.177.195.86	2020-02-07	\N
1017	\N	\N	41.60.124.98	2020-02-06	1
1021	\N	\N	41.60.103.65	2020-02-06	2
1086	\N	\N	102.177.195.86	2020-06-02	4
1022	\N	\N	41.60.94.53	2020-02-06	1
1089	\N	\N	41.60.115.157	2020-06-05	1
1101	\N	\N	197.221.254.75	2020-07-22	1
1095	\N	\N	196.41.88.25	2020-06-26	4
1018	\N	\N	77.246.49.53	2020-02-06	1
1035	\N	\N	41.60.102.122	2020-02-10	1
883	\N	2020-02-06 23:00:03	197.211.209.123	2019-08-15	\N
928	\N	2020-02-06 23:00:03	197.211.209.123	2019-10-11	\N
931	\N	2020-02-06 23:00:03	197.211.209.123	2019-10-23	\N
954	\N	2020-02-06 23:00:03	197.211.209.123	2020-01-01	\N
970	\N	2020-02-06 23:00:03	197.211.209.123	2020-01-05	\N
1098	\N	\N	102.177.195.86	2020-06-27	5
1037	\N	\N	41.60.75.222	2020-02-11	3
1012	\N	\N	196.27.120.9	2020-02-06	10
1014	\N	\N	196.27.120.21	2020-02-06	9
978	\N	2020-02-06 23:00:03	197.211.209.123	2020-01-07	\N
1023	\N	2020-02-06 23:00:03	197.211.209.123	2020-02-06	\N
1020	\N	\N	41.60.104.172	2020-02-06	6
1029	\N	\N	41.60.74.56	2020-02-07	6
1019	\N	\N	154.119.81.206	2020-02-06	2
1028	\N	\N	197.211.209.123	2020-02-07	8
1032	\N	2020-02-09 21:24:37	41.174.87.72	2020-02-09	\N
1026	\N	\N	196.27.120.9	2020-02-07	4
1046	\N	\N	196.27.120.14	2020-02-19	2
1039	\N	\N	41.60.104.13	2020-02-13	7
1034	\N	\N	41.175.69.192	2020-02-10	4
1040	\N	\N	41.175.64.227	2020-02-14	1
1044	\N	\N	41.78.171.87	2020-02-18	7
1047	\N	\N	196.27.120.9	2020-02-19	1
1049	\N	\N	41.60.86.4	2020-02-21	1
1050	\N	\N	41.60.91.213	2020-02-24	1
1052	\N	\N	197.221.254.208	2020-03-05	1
1056	\N	\N	41.60.114.139	2020-03-10	1
1055	\N	\N	41.174.94.42	2020-03-10	3
1081	\N	\N	102.177.195.86	2020-05-20	7
1084	\N	\N	197.221.234.154	2020-06-01	2
1061	\N	\N	154.120.229.78	2020-03-16	6
1087	\N	\N	197.221.254.215	2020-06-02	3
1090	\N	\N	41.174.69.154	2020-06-11	1
1093	\N	\N	102.128.76.122	2020-06-24	1
1096	\N	\N	197.221.254.186	2020-06-26	3
1099	\N	\N	104.248.114.120	2020-07-03	1
1062	\N	\N	41.60.108.133	2020-03-16	4
1063	\N	\N	196.27.120.6	2020-03-17	3
1066	\N	\N	41.59.81.191	2020-03-19	1
1067	\N	\N	41.59.81.185	2020-03-19	1
1008	\N	2020-03-23 16:08:31	102.177.195.86	2020-01-29	\N
1009	\N	2020-03-23 16:08:31	102.177.195.86	2020-02-03	\N
1010	\N	2020-03-23 16:08:31	102.177.195.86	2020-02-04	\N
1011	\N	2020-03-23 16:08:31	102.177.195.86	2020-02-05	\N
1013	\N	2020-03-23 16:08:31	102.177.195.86	2020-02-06	\N
1043	\N	2020-03-23 16:08:31	102.177.195.86	2020-02-17	\N
1036	\N	2020-03-23 16:08:31	102.177.195.86	2020-02-11	\N
1030	\N	2020-03-23 16:08:31	102.177.195.86	2020-02-08	\N
1033	\N	2020-03-23 16:08:31	102.177.195.86	2020-02-10	\N
1042	\N	2020-03-23 16:08:31	102.177.195.86	2020-02-16	\N
1038	\N	2020-03-23 16:08:31	102.177.195.86	2020-02-13	\N
1041	\N	2020-03-23 16:08:31	102.177.195.86	2020-02-14	\N
1045	\N	2020-03-23 16:08:31	102.177.195.86	2020-02-18	\N
1048	\N	2020-03-23 16:08:31	102.177.195.86	2020-02-20	\N
1051	\N	2020-03-23 16:08:31	102.177.195.86	2020-03-02	\N
1053	\N	2020-03-23 16:08:31	102.177.195.86	2020-03-06	\N
1054	\N	2020-03-23 16:08:31	102.177.195.86	2020-03-09	\N
1057	\N	2020-03-23 16:08:31	102.177.195.86	2020-03-11	\N
1058	\N	2020-03-23 16:08:31	102.177.195.86	2020-03-12	\N
1059	\N	2020-03-23 16:08:31	102.177.195.86	2020-03-13	\N
1060	\N	2020-03-23 16:08:31	102.177.195.86	2020-03-16	\N
1064	\N	2020-03-23 16:08:31	102.177.195.86	2020-03-17	\N
1065	\N	2020-03-23 16:08:31	102.177.195.86	2020-03-18	\N
1068	\N	2020-03-23 16:08:31	102.177.195.86	2020-03-23	\N
1069	\N	\N	41.175.71.157	2020-03-24	1
1070	\N	\N	102.177.195.86	2020-03-26	2
1071	\N	\N	41.60.112.98	2020-04-01	1
1072	\N	\N	41.60.68.253	2020-04-08	6
1073	\N	\N	102.177.195.86	2020-04-24	3
1074	\N	\N	197.211.209.123	2020-04-27	2
1075	\N	\N	197.211.224.90	2020-05-12	1
1076	\N	\N	41.175.109.225	2020-05-13	2
1077	\N	\N	154.119.81.206	2020-05-14	2
1078	\N	\N	41.175.72.229	2020-05-17	4
1079	\N	\N	41.60.100.24	2020-05-18	1
1080	\N	\N	41.175.72.229	2020-05-18	2
\.


--
-- Data for Name: config; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.config (title, school_year, login, version) FROM stdin;
\.


--
-- Data for Name: course_credits; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.course_credits (school_year, school_id, course_id, course_credit_title, gpa_multiplier, rollover_id, year_fraction, credits, student_requestable, student_scheduleable, cw_checkbox_setting_1, cw_checkbox_setting_2, cw_checkbox_setting_3, cw_checkbox_setting_4, cw_checkbox_setting_5, does_gpa_1, does_gpa_2, does_gpa_3, does_gpa_4, does_gpa_5) FROM stdin;
2011	3	360	BAFL	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	362	ENYR1	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	366	HAYR1	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	370	MRYR1	\N	\N	\N	2	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	364	LAYR1	\N	\N	\N	2	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	368	VT2YR1	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	380	APYR2	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	382	PHAYR2	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	378	RWYR2	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	384	PTDYR2	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	372	ITYR1	\N	\N	\N	2	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	388	PLYR3	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	389	ESYR3	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	386	HMYR3	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	395	EHYR4	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	394	APYR4	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	397	NTYR4	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	396	PGYR4	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	402	CMYR1	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	404	IPYR1	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	414	IOTYR1	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	421	CHYR1	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	405	HAYR1	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	437	ATYR2	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	413	PRYR2	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	416	NTYR2	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	374	ALFYR2	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	376	WLYR2	\N	\N	\N	2	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	387	PSYR3	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	440	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	442	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	438	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	439	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	444	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	445	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	446	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1903	BAFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	451	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	449	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	447	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	448	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	421	CHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	411	RPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	416	NTYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	450	HRs	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	441	GAAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	363	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	369	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	361	FLYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	365	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	371	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	373	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	367	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	375	ALFYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	377	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	379	WHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	385	EYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	383	SSAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	390	CPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	391	PMEYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	392	MCPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	393	OTFYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	398	PPPYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	399	REYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	400	OCTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	401	OCYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	403	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	453	DHBAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	454	PSDRGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	455	PLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	456	GPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	457	PFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	458	ICSPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	459	RSFANEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	460	PCMEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	461	BEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	462	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	463	FAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	381	HMPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	409	EPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	418	HCTPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	415	INTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	464	APDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	465	IEDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	466	CTIDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	467	IDDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	417	ITDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	689	RMHDPTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	468	PCMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	469	ICSDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	470	HRDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	471	DHDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	692	TJRDPTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	694	HMPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2008	3	474	EWYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2008	3	475	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2008	3	476	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2008	3	477	SVCYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2008	3	478	MRSYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2008	3	479	IPYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	697	ESPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2008	3	480	FLYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2008	3	481	EWYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2008	3	482	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2008	3	483	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2008	3	484	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2008	3	485	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2008	3	486	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	700	HRAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	702	CPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	705	MCPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	708	TJRAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	711	KGAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	714	PSDAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	717	PFAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	720	AADAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	723	ASAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	726	JFAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2008	3	473	FLYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	522	EWYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	512	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	513	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	514	SVCYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	515	MRSYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	516	IPYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	525	FLYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	523	EWYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	517	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	518	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	519	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	520	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	521	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	524	FLYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	526	ALFYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	527	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	528	RWYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	529	HAPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	530	PAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	531	PTDYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	532	ALFYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	533	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	534	WHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	535	EYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	536	SSAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	537	HMPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	538	CMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	539	IPLDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	540	HAPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	541	HCTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	542	CHDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	543	CMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	544	IOTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	545	ITDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	546	APYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	548	HCTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	551	EMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	552	MMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	553	PPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	554	PRMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	555	SPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	556	EMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	557	IPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	558	APMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	559	PSMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	560	PEMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	690	APDPTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	693	HADPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	695	PSYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	698	KMAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	701	PRAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	703	PMEYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	706	RMHAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	709	PTAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	712	EFBAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	715	IJSAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	718	GPAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	721	ISRAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	724	GMAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	727	MHAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	729	HCTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	731	HMPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	733	CADPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	735	EDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	737	HCPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	739	KMDPTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	741	HRDPTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	743	DMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	745	CPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	746	PTDPTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	748	BAPRE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	749	RAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	750	APPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	752	HMPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	753	EPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	755	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	757	RWPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	759	PTDPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	761	HMPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	763	PLPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	765	CPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	767	MCPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	769	SAPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	771	PGPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	773	PPPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	775	OCTPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	777	DHPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	779	PSDPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	780	IPLPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	782	PFPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	783	HRPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	784	PCMPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	785	FAEPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	786	APPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	691	PCMDPTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	696	PLPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	651	EWYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	677	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	643	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	644	SVCYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	645	MRSYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	646	IPYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	654	FLYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	652	EWYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	678	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	647	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	648	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	649	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	650	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	653	FLYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	655	ALFYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	656	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	657	RWYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	658	HAPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	659	PAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	660	PTDYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	661	ALFYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	662	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	663	WHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	664	EYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	665	SSAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	666	HMPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	667	CMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	668	IPLDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	669	HAPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	670	HCTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	671	CHDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	672	CMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	673	IOTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	674	ITDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	675	APYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	676	HCTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	679	EMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	680	MMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	681	PPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	682	PRMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	683	SPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	684	EMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	685	IPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	686	APMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	687	PSMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	688	PEMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	699	GAAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	704	OTFYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	707	PFAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	710	HTAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	713	APAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	716	IAPAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	719	PCMAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	722	CTPWAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	725	TSPAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	728	PMAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	730	INTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	732	PADPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	734	HMPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	736	MDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	738	GADPTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	740	PRDPTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	742	TGMMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	744	ISRMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	751	LPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	754	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	756	IPPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	758	PAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	760	SSAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	762	PSPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	764	ESPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	766	PMEPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	768	OFPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	770	EHPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	772	NTFPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	774	REPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	776	OCEPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	778	ICSPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	781	BPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	787	BAFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	789	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	793	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	797	MRYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	792	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	795	VT2YR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	805	APYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	807	PHAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	803	RWYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	809	PTDYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	799	ITYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	813	PLYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	814	ESYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	811	HMYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	820	EHYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	819	APYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	822	NTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	821	PGYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	826	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	828	IPYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	838	IOTYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	845	CHYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	829	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	861	ATYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	837	PRYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	840	NTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	862	ALFYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	802	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	812	PSYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	875	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	867	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	866	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	864	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	869	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	870	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	871	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1901	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	876	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	874	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	872	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	873	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	845	CHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	835	RPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	840	NTYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	895	HRs	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	865	GAAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	790	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	796	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	788	FLYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	791	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	798	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	800	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	794	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	863	ALFYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	801	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	804	WHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	810	EYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	808	SSAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	815	CPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	816	PMEYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	817	MCPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	818	OTFYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	823	PPPYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	824	REYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	825	OCTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	936	OCYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	827	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	877	DHBAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	878	PSDRGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	879	PLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	880	GPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	881	PFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	882	ICSPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	883	RSFANEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	884	PCMEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	885	BEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	886	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	887	FAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	806	HMPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	833	EPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	842	HCTPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	839	INTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	888	APDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	889	IEDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	890	CTIDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	891	IDDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	841	ITDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	892	PCMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	896	ICSDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	893	HRDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	894	DHDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	913	BAPRE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	914	RAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	915	APPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	916	HMPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	917	EPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	918	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	919	RWPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	920	PTDPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	921	HMPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	922	PLPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	923	CPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	924	MCPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	925	SAPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	926	PGPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	927	PPPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	928	OCTPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	929	DHPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	930	PSDPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	931	IPLPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	932	PFPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	912	HRPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	933	PCMPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	935	FAEPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	934	APPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	897	LPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	898	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	899	IPPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	900	PAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	901	SSAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	902	PSPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	903	ESPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	904	PMEPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	905	OFPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	906	EHPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	907	NTFPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	908	REPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	909	OCEPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	910	ICSPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	911	BPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	937	AIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	943	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	939	PAEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	940	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	945	CTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	946	ELEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	944	FFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	941	JHEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	938	KEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	947	PAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	949	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	950	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	951	ISEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	952	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	953	SKEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	954	AIYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	955	PEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	956	SKEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	957	PAEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	958	STEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	959	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	960	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	961	JHEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	962	FFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	963	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	964	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	965	CTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	966	ELEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	967	PEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	968	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	969	PAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	970	PAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	971	GAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	972	ISEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	973	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	974	SKEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	976	PEDYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	977	BLYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	868	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	853	SPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	846	EPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	978	PEDMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	979	BLMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	948	GAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	980	HAPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	981	HAPPUGYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	982	PAPUGYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	836	EDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	843	HCT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	830	HMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	983	HIVA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	984	SPP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	985	POE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	986	PAE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	987	ST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	847	ETMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	855	LPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	988	POSMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	989	PCCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	990	ASCAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	991	DEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	992	PHILA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	993	OTS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	994	PSDRG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	995	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	996	FLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	997	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	998	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	999	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1000	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1001	ETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1002	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1003	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1004	PMOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1005	ASCA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1006	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1007	DEMC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1008	BIOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1009	PFR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1010	LAWA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1011	POLA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1012	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1013	APHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1014	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	408	CONP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	832	CONTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	834	MTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	1015	LIAQ	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1016	HRPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1017	POSPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1018	FRLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1902	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1907	MRYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1900	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1905	VT2YR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1921	APYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1919	RWYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1925	PTDYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1909	ITYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1929	PLYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1930	ESYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1927	HMYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1936	EHYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1935	APYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1938	NTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1937	PGYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1942	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1944	IPYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1954	IOTYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1961	CHYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1945	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1976	ATYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1953	PRYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1956	NTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1977	ALFYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1918	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1928	PSYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1982	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1913	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1979	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2032	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2033	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1983	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2036	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2034	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2035	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1961	CHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1951	RPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1956	NTYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2045	HRs	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1980	GAAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1910	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1906	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1899	FLYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1911	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1908	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1916	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1904	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1978	ALFYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1917	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1920	WHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1926	EYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1924	SSAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1931	CPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1932	PMEYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1933	MCPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1934	OTFYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1939	PPPYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1940	REYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1941	OCTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2022	OCYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1943	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1914	DHBAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1892	PSDRGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1915	PLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1986	GPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2030	PFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2028	ICSPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1987	RSFANEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2027	PCMEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2029	BEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1988	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2037	FAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1922	HMPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1949	EPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1958	HCTPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1955	INTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2038	APDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2039	IEDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2040	CTIDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2041	IDDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1957	ITDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2042	PCMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2046	ICSDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2043	HRDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2044	DHDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1868	BAPRE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2001	RAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2002	APPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2031	HMPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2003	EPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2004	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2005	RWPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2006	PTDPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2007	HMPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2008	PLPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2009	CPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2010	MCPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2011	SAPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2012	PGPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2013	PPPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2014	OCTPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2015	DHPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2016	PSDPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2017	IPLPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2018	PFPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2000	HRPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2019	PCMPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2021	FAEPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2020	APPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2047	LPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2048	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1984	IPPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1989	SSAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1991	ESPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1992	PMEPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1993	OFPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1994	EHPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1995	NTFPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1996	REPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1997	OCEPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1998	ICSPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1999	BPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1843	AIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1865	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1884	PAEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1897	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2024	CTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1844	ELEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1885	FFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2023	JHEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1864	KEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1866	PAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1990	PON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1863	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2025	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1845	ISEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1867	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1898	SKEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1981	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1968	SPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1846	EPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1869	PEDMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1888	BLMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1886	GAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1870	HAPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1889	PAPUGYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1952	EDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1959	HCT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1946	HMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1872	HIVA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1890	SPP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1847	POE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1873	PAE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1891	ST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1962	ETMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1970	LPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1874	POSMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1848	PCCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1861	ASCAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1893	DEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1894	OTS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1849	PSDRG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1876	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1895	FLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1850	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1887	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1862	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1851	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1877	ETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1896	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1852	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1878	PMOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1879	ASCA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1853	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1880	DEMC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1854	BIOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1881	PFR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1855	LAWA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1882	POLA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1856	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1883	APHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1857	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1948	CONTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1950	MTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1858	HRPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1859	POSPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1860	FRLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2049	POL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2050	TTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2051	HOAP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2053	FRLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2054	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2055	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2056	WLPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2057	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2058	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2059	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2060	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2061	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2062	ITBL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2063	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2064	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2065	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2066	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2026	IGSP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1973	APMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2067	AQLKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2068	LOM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2069	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1985	POM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1947	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1960	HOCTMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2070	DISSER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2071	ATPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2072	OSAD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1963	MAHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2073	MAISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2074	PHIH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2075	PHMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2078	DFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2079	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2080	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2081	AFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2082	AQKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2083	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2084	HPICK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2085	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2087	OIAF	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2089	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2091	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2093	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2095	MFAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2097	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2099	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2179	BAFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2177	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2178	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2183	MRYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2176	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2181	VT2YR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2196	APYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2194	RWYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2200	PTDYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2185	ITYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2204	PLYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2205	ESYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2202	HMYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2211	EHYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2210	APYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2213	NTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2212	PGYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2217	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2219	IPYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2229	IOTYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2236	CHYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2220	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2251	ATYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2228	PRYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2231	NTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2252	ALFYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2193	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2203	PSYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2257	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2189	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2254	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2320	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2305	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2258	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2308	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2306	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2307	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2236	CHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2226	RPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2231	NTYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2317	HRs	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2255	GAAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2186	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2182	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2175	FLYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2187	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2184	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2113	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2180	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2253	ALFYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2192	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2195	WHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2201	EYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2276	SSAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2206	CPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2207	PMEYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2208	MCPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2209	OTFYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2214	PPPYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2215	REYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2216	OCTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2296	OCYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2218	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2190	DHBAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2169	PSDRGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2191	PLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2260	GPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2303	PFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2301	ICSPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2261	RSFANEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2339	PCMEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2302	BEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2262	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2309	FAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2102	HMPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2224	EPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2233	HCTPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2230	INTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2310	APDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2311	IEDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2312	CTIDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2313	IDDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2232	ITDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2314	PCMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2318	ICSDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2315	HRDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2316	DHDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2147	BAPRE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2275	RAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2197	APPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2304	HMPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2277	EPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2278	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2279	RWPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2280	PTDPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2281	HMPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2282	PLPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2283	CPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2284	MCPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2285	SAPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2286	PGPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2287	PPPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2288	OCTPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2289	DHPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2290	PSDPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2291	IPLPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2292	PFPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2274	HRPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2293	PCMPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2295	FAEPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2294	APPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2322	LPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2323	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2259	IPPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2263	SSAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2264	ESPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2265	PMEPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2266	OFPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2267	EHPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2268	NTFPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2269	REPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2270	OCEPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2272	ICSPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2273	BPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2123	AIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2144	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2162	PAEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2173	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2298	CTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2101	ELEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2163	FFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2297	JHEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2143	KEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2145	PAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2119	PON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2142	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2299	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2124	ISEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2146	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2174	SKEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2256	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2243	SPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2125	EPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2148	PEDMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2166	BLMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2164	GAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2149	HAPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2199	PAPUGYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2227	EDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2234	HCT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2221	HMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2151	HIVA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2167	SPP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2127	POE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2152	PAE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2168	ST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2237	ETMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2245	LPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2153	POSMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2128	PCCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2140	ASCAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2170	DEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2171	OTS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2129	PSDRG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2154	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2100	FLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2130	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2165	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2141	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2131	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2155	ETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2172	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2132	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2156	PMOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2157	ASCA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2133	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2158	DEMC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2134	BIOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2159	PFR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2135	LAWA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2160	POLA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2136	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2161	APHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2137	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2223	CONTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2225	MTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2138	HRPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2198	POSPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2139	FRLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2103	POL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2104	TTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2105	HOAP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2112	FRLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2106	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2114	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2117	WLPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2107	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2110	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2115	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2118	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2120	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2121	ITBL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2122	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2126	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2319	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2321	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2300	IGSP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2248	APMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2108	AQLKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2111	LOM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2116	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2271	POM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2222	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2235	HOCTMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2109	DISSER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2324	ATPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2325	OSAD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2238	MAHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2326	MAISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2327	PHIH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2328	PHMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2329	DFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2330	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2331	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2332	AFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2333	AQKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2334	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2335	HPICK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2336	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2337	OIAF	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2338	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2340	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2341	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2342	MFAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2343	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2344	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2346	IGSPI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2348	PHOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2349	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2352	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2353	GREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2354	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2355	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2356	NIETZ	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2357	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2358	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2360	MARX	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2361	PHILAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2362	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2363	HIVAIDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2364	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2365	ARGWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2239	METAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2242	ECONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2246	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2366	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2367	NGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2250	CONTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2368	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2369	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2370	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2371	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2372	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2373	RETREAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2374	CONTLit	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2375	PEOPLES	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2253	ALFPUG	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2376	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2378	DISSERT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2379	DISSERT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2380	THNGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2381	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2382	THGARD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2383	PHMATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2384	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2385	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2386	HITFILM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2387	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2388	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2389	CONFMANG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2390	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2391	POLTHEO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2392	PHILMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2393	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2394	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2395	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2396	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2397	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2398	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2644	BAFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2399	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2541	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2594	MRYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2643	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2641	VT2YR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2657	APYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2655	RWYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2661	PTDYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2647	ITYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2665	PLYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2408	ESYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2663	HMYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2414	EHYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2413	APYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2416	NTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2415	PGYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2420	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2422	IPYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2432	IOTYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2439	CHYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2423	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2454	ATYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2431	PRYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2434	NTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2465	ALFYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2654	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2664	PSYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2458	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2650	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2455	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2530	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2515	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2459	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2518	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2516	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2517	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2439	CHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2429	RPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2434	NTYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2527	HRs	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2456	GAAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2648	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2642	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2646	FLYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2536	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2595	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2574	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2640	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2470	ALFYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2653	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2656	WHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2662	EYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2486	SSAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2409	CPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2410	PMEYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2411	MCPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2412	OTFYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2417	PPPYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2418	REYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2419	OCTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2506	OCYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2421	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2651	DHBAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2634	PSDRGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2652	PLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2461	GPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2513	PFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2511	ICSPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2462	RSFANEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2679	PCMEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2512	BEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2463	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2519	FAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2565	HMPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2427	EPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2436	HCTPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2433	INTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2520	APDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2521	IEDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2522	CTIDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2523	IDDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2435	ITDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2524	PCMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2528	ICSDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2525	HRDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2526	DHDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2612	BAPRE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2485	RAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2658	APPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2514	HMPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2487	EPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2488	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2489	RWPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2490	PTDPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2491	HMPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2492	PLPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2493	CPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2494	MCPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2495	SAPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2496	PGPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2497	PPPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2498	OCTPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2499	DHPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2500	PSDPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2501	IPLPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2502	PFPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2484	HRPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2503	PCMPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2505	FAEPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2504	APPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2532	LPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2533	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2460	IPPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2464	SSAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2596	ESPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2466	PMEPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2476	OFPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2477	EHPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2478	NTFPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2479	REPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2480	OCEPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2482	ICSPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2483	BPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2584	AIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2609	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2627	PAEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2638	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2508	CTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2564	ELEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2628	FFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2507	JHEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2608	KEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2610	PAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2580	PON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2607	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2509	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2585	ISEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2611	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2639	SKEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2457	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2446	SPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2586	EPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2613	PEDMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2631	BLMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2629	GAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2614	HAPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2660	PAPUGYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2430	EDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2437	HCT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2424	HMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2616	HIVA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2632	SPP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2588	POE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2617	PAE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2633	ST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2440	ETMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2448	LPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2618	POSMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2589	PCCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2605	ASCAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2635	DEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2636	OTS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2590	PSDRG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2619	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2563	FLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2591	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2630	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2606	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2592	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2620	ETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2637	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2597	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2621	PMOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2622	ASCA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2598	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2623	DEMC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2599	BIOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2624	PFR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2600	LAWA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2625	POLA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2601	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2626	APHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2602	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2426	CONTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2428	MTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2603	HRPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2659	POSPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2604	FRLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2566	POL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2567	TTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2593	HOAP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2573	FRLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2568	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2575	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2578	WLPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2569	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2571	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2576	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2579	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2581	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2582	ITBL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2583	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2587	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2529	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2531	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2510	IGSP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2451	APMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2570	AQLKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2572	LOM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2577	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2481	POM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2425	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2438	HOCTMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2645	DISSER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2534	ATPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2666	OSAD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2441	MAHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2667	MAISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2668	PHIH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2687	PHMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2669	DFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2670	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2671	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2672	AFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2673	AQKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2674	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2675	HPICK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2676	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2677	OIAF	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2678	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2680	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2681	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2682	MFAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2683	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2684	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2549	IGSPI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2551	PHOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2553	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2400	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2467	GREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2556	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2685	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2535	NIETZ	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2542	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2550	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2552	MARX	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2554	PHILAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2401	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2468	HIVAIDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2557	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2686	ARGWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2442	METAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2445	ECONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2449	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2543	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2555	NGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2453	CONTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2402	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2469	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2558	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2537	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2544	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2403	RETREAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2559	CONTLit	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2688	PEOPLES	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2470	ALFPUG	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2538	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2545	DISSERT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2404	DISSERT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2471	THNGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2560	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2689	THGARD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2539	PHMATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2546	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2405	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2472	HITFILM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2561	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2690	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2540	CONFMANG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2547	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2406	POLTHEO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2473	PHILMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2474	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2562	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2691	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2548	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2407	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2475	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3571	PHWRI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3574	HMPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3583	APOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3592	ARTL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3594	AFPSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3596	ARTL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3600	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3603	Dewey	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3605	PHMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3607	SPNEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3609	FREUD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3297	PolPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3293	PHREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3610	ARGW	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3611	AFTLIT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3612	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3614	PGDMETA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3616	HMPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3619	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3628	TAYLOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3637	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3641	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3647	MARCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3657	PHYSICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3659	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3661	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3662	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3664	GABRIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3663	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3666	AQUINASM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3671	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3673	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3674	PSYCHOED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3675	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3677	DISASTERC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3679	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3572	LTIN	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3576	PHWRI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3584	CHRTA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3593	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3597	AFCHRIST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3602	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3604	Laudatosi	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3606	PSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3608	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3613	ORALC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3615	PGDCON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3617	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3620	HEGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3629	GUIDANCE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3638	PHYSICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3642	HEGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3648	GUIDANCE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3658	MICROSOFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3660	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3665	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3667	CATOHSO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3672	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3676	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3678	DISASTERC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3680	LEADERSHIP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3578	IKANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3585	INTROPM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3598	IKANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3618	ART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3621	GENDER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3625	MDRSK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3630	IRELATIONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3639	MICROSOFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3643	GENDER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3649	IRELATIONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3668	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3579	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3586	APSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3599	INTROPM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3622	SOCPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3626	PHILANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3631	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3644	AQUINAS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3650	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3669	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3580	Dewey	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3587	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3623	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3627	HEPW	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3632	ANALYSISII	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3645	SOCPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3651	ANALYSISII	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3670	MORALITYA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3581	MLL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3624	CSTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3588	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3633	TIME	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3646	CATOHSO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3652	STUART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3582	SGFREUD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3589	SPNEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3634	STUART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3653	LITURGY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3590	PSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3655	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3635	LITURGY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3555	BAFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3490	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3479	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3432	MRYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3554	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3552	VT2YR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3568	APYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3566	RWYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3468	PTDYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3558	ITYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3472	PLYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3499	ESYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3470	HMYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3525	EHYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3524	APYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3527	NTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3526	PGYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3531	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3533	IPYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3281	IOTYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3289	CHYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3534	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3483	ATYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3280	PRYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3283	NTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3305	ALFYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3565	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3471	PSYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3487	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3561	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3484	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3369	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3355	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3488	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3358	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3356	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3357	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3289	CHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3278	RPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3283	NTYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3366	HRs	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3485	GAAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3559	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3553	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3557	FLYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3375	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3433	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3412	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3551	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3564	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3567	WHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3469	EYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3326	SSAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3500	CPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3501	PMEYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3502	MCPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3523	OTFYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3528	PPPYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3529	REYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3530	OCTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3346	OCYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3532	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3562	DHBAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3545	PSDRGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3563	PLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3301	GPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3353	PFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3351	ICSPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3302	RSFANEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3510	PCMEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3352	BEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3303	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3359	FAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3403	HMPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3538	EPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3285	HCTPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3282	INTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3360	APDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3286	IEDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3361	CTIDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3362	IDDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3284	ITDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3363	PCMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3367	ICSDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3364	HRDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3365	DHDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3450	BAPRE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3325	RAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3569	APPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3354	HMPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3327	EPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3328	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3329	RWPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3331	HMPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3332	PLPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3333	CPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3334	MCPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3335	SAPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3336	PGPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3337	PPPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3338	OCTPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3339	DHPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3340	PSDPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3341	IPLPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3342	PFPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3324	HRPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3343	PCMPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3345	FAEPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3344	APPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3371	LPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3372	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3489	IPPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3304	SSAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3434	ESPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3306	PMEPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3316	OFPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3317	EHPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3318	NTFPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3319	REPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3322	ICSPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3323	BPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3422	AIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3447	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3465	PAEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3549	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3348	CTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3402	ELEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3466	FFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3347	JHEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3446	KEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3448	PAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3418	PON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3445	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3349	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3423	ISEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3449	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3550	SKEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3320	OCEPUG3	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3486	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3296	SPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3424	EPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3451	PEDMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3542	BLMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3540	GAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3452	HAPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3467	PAPUGYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3279	EDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3287	HCT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3535	HMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3454	HIVA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3543	SPP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3426	POE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3455	PAE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3544	ST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3290	ETMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3298	LPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3456	POSMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3427	PCCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3443	ASCAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3546	DEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3547	OTS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3428	PSDRG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3457	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3401	FLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3429	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3541	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3444	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3430	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3458	ETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3548	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3435	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3459	PMOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3460	ASCA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3436	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3461	DEMC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3437	BIOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3462	PFR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3438	LAWA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3463	POLA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3439	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3464	APHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3537	CONTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3539	MTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3441	HRPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3570	POSPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3442	FRLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3404	POL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3405	TTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3406	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3413	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3416	WLPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3407	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3409	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3414	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3417	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3419	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3420	ITBL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3421	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3425	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3368	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3370	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3350	IGSP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3480	APMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3408	AQLKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3410	LOM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3415	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3321	POM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3536	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3288	HOCTMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3556	DISSER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3373	ATPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3473	OSAD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3291	MAHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3474	MAISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3475	PHIH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3518	PHMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3476	DFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3477	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3478	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3503	AFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3504	AQKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3505	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3506	HPICK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3507	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3508	OIAF	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3509	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3511	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3512	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3513	MFAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3514	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3515	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3387	IGSPI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3389	PHOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3391	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3491	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3307	GREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3394	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3516	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3374	NIETZ	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3380	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3388	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3390	MARX	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3392	PHILAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3492	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3308	HIVAIDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3395	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3517	ARGWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3292	METAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3295	ECONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3299	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3381	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3393	NGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3482	CONTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3493	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3309	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3396	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3376	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3382	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3494	RETREAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3397	CONTLit	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3519	PEOPLES	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3310	ALFPUG	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3377	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3311	THNGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3398	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3520	THGARD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3378	PHMATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3384	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3496	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3312	HITFILM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3399	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3521	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3379	CONFMANG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3385	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3497	POLTHEO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3313	PHILMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3314	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3400	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3522	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3386	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3498	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3315	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3591	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3636	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3383	DISSERT	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3495	DISSERT	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3656	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3682	ICTNET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3683	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3751	PHWRI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3782	HMPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3783	APOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4076	ARTL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3752	AFPSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3785	ARTL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3981	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3982	Dewey	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3983	PHMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3984	SPNEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3985	FREUD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3703	PolPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3699	PHREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4011	ARGW	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3988	AFTLIT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3989	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3990	PGDMETA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3991	HMPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3992	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3994	TAYLOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3997	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3998	MARCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3788	PHYSICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4000	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4002	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4003	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4022	GABRIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4033	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4035	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4036	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4037	PSYCHOED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4038	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4039	DISASTERC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4040	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3780	LTIN	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3978	PHWRI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3979	CHRTA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3784	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3786	AFCHRIST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4008	Laudatosi	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4009	PSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4012	ORALC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4013	PGDCON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4014	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4015	HEGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4017	GUIDANCE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4018	PHYSICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4020	GUIDANCE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3999	MICROSOFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4021	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4048	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4049	CATOHSO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4050	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4051	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4052	DISASTERC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4053	LEADERSHIP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4026	ART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4027	GENDER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3993	MDRSK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4044	IRELATIONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4030	MICROSOFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4031	GENDER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4032	IRELATIONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4060	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4023	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4024	APSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4043	SOCPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4016	PHILANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4057	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4047	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4068	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4041	Dewey	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4004	IKANT	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3980	IKANT	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4006	INTROPM	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4010	DIOP	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4019	HEGEL	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4046	AQUINAS	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4034	AQUINASM	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4042	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4056	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4028	HEPW	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4065	ANALYSISII	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4058	SOCPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4059	ANALYSISII	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4072	MORALITYA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4054	MLL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4064	CSTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4055	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4066	CATOHSO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4067	STUART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4062	SGFREUD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4063	SPNEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4074	STUART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4071	LITURGY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4069	PSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4075	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4077	LITURGY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3963	BAFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3900	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3890	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4079	MRYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3962	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3960	VT2YR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3974	APYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3972	RWYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3879	PTDYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3964	ITYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3883	PLYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3909	ESYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3881	HMYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3935	EHYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3934	APYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3936	NTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3977	PGYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3940	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3942	IPYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3688	IOTYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3696	CHYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3943	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3894	ATYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3687	PRYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3690	NTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3711	ALFYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3971	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3882	PSYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3897	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3967	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4029	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3777	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3898	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3766	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3764	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3765	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3696	CHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3685	RPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3690	NTYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3965	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3961	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3791	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3840	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3822	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3959	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3970	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3973	WHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3880	EYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3732	SSAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3910	CPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3928	MCPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3933	OTFYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3937	PPPYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3938	REYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3939	OCTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3750	OCYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3941	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3895	GAAPH	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3763	APEL	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3774	HRs	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4070	TIME	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3996	PSDRGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3969	PLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3761	PFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3708	RSFANEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3916	PCMEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3760	BEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3709	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3817	HMPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3947	EPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3692	HCTPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3689	INTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3768	APDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3693	IEDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3769	CTIDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3770	IDDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3691	ITDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3771	PCMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3775	ICSDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3772	HRDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3773	DHDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3863	BAPRE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3731	RAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3762	HMPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3987	EPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3733	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3734	RWPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3736	PLPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3737	CPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3738	MCPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3739	SAPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3740	PGPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3741	PPPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3742	OCTPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3744	PSDPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3745	IPLPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3746	PFPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3747	PCMPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3748	APPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3778	LPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3779	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3899	IPPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3710	SSAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3841	ESPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3753	PMEPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3722	OFPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3723	EHPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3724	NTFPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3725	REPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3877	PAEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3957	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3756	CTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3816	ELEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3878	FFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3755	JHEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3852	KEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3861	PAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3828	PON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3856	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3757	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3832	ISEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3862	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3726	OCEPUG3	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3896	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3702	SPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3833	EPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3831	AIEL	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3767	FAEL	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3707	GPEL	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3759	ICSPEL	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3860	LLEL	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3729	BPUGE	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3743	DHPUGE	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3749	FAEPUGE	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3728	ICSPUGE	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3958	SKEL	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3951	BLMA	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3864	PEDMA	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3949	GAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3865	HAPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3807	PAPUGYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3686	EDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3694	HCT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3944	HMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3867	HIVA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3952	SPP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3835	POE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3868	PAE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3953	ST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3754	ETMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3704	LPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3869	POSMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3836	PCCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3850	ASCAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3955	OTS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3837	PSDRG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3870	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3815	FLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3838	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3950	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3851	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3839	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3871	ETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3956	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3842	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3930	PMOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3872	ASCA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3843	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3844	BIOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3874	PFR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3845	LAWA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3846	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3876	APHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3946	CONTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3948	MTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3976	POSPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3849	FRLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3818	POL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3819	TTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3820	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3823	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3826	WLPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3854	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3855	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3824	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3827	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3829	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3830	ITBL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3858	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3834	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3776	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3713	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3758	IGSP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3891	APMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3821	LOM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3825	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3727	POM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3945	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3695	HOCTMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4001	DISSER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3789	ATPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3884	OSAD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3887	DFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3888	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3889	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3911	AFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3929	AQKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3914	OIAF	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3915	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3917	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3912	HPCIK	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3873	DEMC	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3913	HPCIK	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3848	HRPUG	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3857	AQLKB	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3697	MAHE	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3926	HPICK	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3885	MAISLAM	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3886	PHIH	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3875	POLA	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3922	PHMA	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3918	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3919	MFAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3920	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3921	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3801	IGSPI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3805	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3712	GREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3808	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3925	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3790	NIETZ	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3859	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3802	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3806	PHILAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3902	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3809	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3927	ARGWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3701	ECONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3705	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3853	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3893	CONTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3903	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3715	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3810	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3792	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3796	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3904	RETREAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3811	CONTLit	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3923	PEOPLES	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3716	ALFPUG	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3793	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3717	THNGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3924	THGARD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3794	PHMATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3798	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3718	HITFILM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3813	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3907	POLTHEO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3719	PHILMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3932	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3721	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4073	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3787	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3797	DISSERT	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3905	DISSERT	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4078	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4080	ICTNET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4086	ENVIRON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3986	FLYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4087	ICTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4088	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4083	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4091	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4089	SOCILPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4092	ENVIRON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4093	EDUC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3720	COMPS	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3795	CONFMANG	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3812	CURIDEV	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3968	DHBAEL	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3954	DEL	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3714	HIVAIDS	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3799	INTROHRIGH	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3931	INTROPEACE	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4005	INTROPM	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3906	SCIEREL	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3804	MARX	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3814	COMPS	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3908	INTROHRIGH	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3800	INTROPEACE	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3901	ARPH	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3698	METAPH	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3803	PHOG	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4081	DIOP	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3684	NGUGI	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4099	ECON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4101	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4098	ENVIRON	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4100	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4102	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4095	PHILREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4096	PHILSICEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4097	POLIPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4084	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4103	THEATRE2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4104	BLETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4105	EGYPTGREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4082	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4107	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4108	DEWEY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4109	SOCSPIR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4110	SOCSPIR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4111	ENVIRONETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4112	SPECIALED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3781	PMEYR3	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4085	SOCIALS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4113	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4114	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4115	MATHS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3975	APPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4116	ICTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4117	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4118	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4119	MATHS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3892	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4120	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4121	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4122	ARISETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4123	ARISETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4124	KANTEPIS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4126	KANTEPIS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3700	PHILANTH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4127	SHONA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4129	SHONA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4130	PHIOFLIFE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4131	PHIOFLIFE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4132	ISLAMAFRIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4133	ISLAMAFRIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4134	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4135	GENDER2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4136	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4137	GENDER2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4138	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4139	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4140	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4141	SIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4128	SIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4142	AFRIPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4143	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4144	CCNA1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4145	CCNA1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4204	PHWRI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4288	HMPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4240	APOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4521	ARTL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4205	AFPSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4245	ARTL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4431	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4432	Dewey	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4433	PHMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4434	SPNEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4435	FREUD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4168	PolPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4164	PHREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4461	ARGW	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4438	AFTLIT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4439	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4440	PGDMETA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4441	HMPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4442	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4444	TAYLOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4446	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4447	MARCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4247	PHYSICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4449	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4451	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4452	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4471	GABRIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4481	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4483	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4484	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4485	PSYCHOED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4486	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4487	DISASTERC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4488	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4286	LTIN	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4417	PHWRI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4418	CHRTA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4241	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4246	AFCHRIST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4457	Laudatosi	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4459	PSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4462	ORALC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4539	PGDCON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4463	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4464	HEGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4466	GUIDANCE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4467	PHYSICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4469	GUIDANCE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4448	MICROSOFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4470	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4496	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4497	CATOHSO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4498	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4499	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4500	DISASTERC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4501	LEADERSHIP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4474	ART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4475	GENDER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4443	MDRSK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4492	IRELATIONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4478	MICROSOFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4479	GENDER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4480	IRELATIONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4508	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4472	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4473	APSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4491	SOCPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4465	PHILANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4505	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4495	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4528	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4489	Dewey	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4453	IKANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4430	IKANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4455	INTROPM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4460	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4468	HEGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4494	AQUINAS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4482	AQUINASM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4490	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4504	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4476	HEPW	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4513	ANALYSISII	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4506	SOCPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4507	ANALYSISII	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4518	MORALITYA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4502	MLL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4512	CSTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4503	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4514	CATOHSO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4515	STUART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4510	SGFREUD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4511	SPNEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4520	STUART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4517	LITURGY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4147	PSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4588	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4522	LITURGY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4407	BAFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4527	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4355	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4530	MRYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4529	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4420	VT2YR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4424	APYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4421	RWYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4334	PTDYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4419	ITYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4148	PLYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4423	ESYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4336	HMYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4426	EHYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4425	APYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4535	NTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4416	PGYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4388	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4390	IPYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4153	IOTYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4161	CHYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4391	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4345	ATYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4152	PRYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4155	NTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4172	ALFYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4413	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4356	PSYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4348	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4410	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4477	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4236	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4349	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4226	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4223	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4224	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4161	CHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4150	RPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4155	NTYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4408	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4427	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4250	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4296	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4277	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4406	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4412	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4414	WHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4335	EYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4191	SSAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4428	CPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4380	MCPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4385	OTFYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4429	PPPYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4386	REYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4387	OCTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4212	OCYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4389	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4346	GAAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4222	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4233	HRs	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4516	TIME	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4445	PSDRGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4225	PLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4221	PFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4243	RSFANEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4369	PCMEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4220	BEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4209	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4287	HMPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4395	EPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4157	HCTPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4154	INTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4227	APDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4158	IEDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4228	CTIDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4229	IDDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4156	ITDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4230	PCMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4234	ICSDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4231	HRDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4232	DHDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4321	BAPRE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4190	RAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4244	HMPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4437	EPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4210	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4211	RWPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4216	PLPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4215	CPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4193	MCPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4194	SAPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4146	PGPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4195	PPPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4196	OCTPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4198	PSDPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4199	IPLPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4200	PFPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4201	PCMPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4202	APPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4237	LPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4238	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4357	IPPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4171	SSAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4359	ESPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4206	PMEPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4182	OFPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4183	EHPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4184	NTFPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4185	REPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4332	PAEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4555	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4208	CTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4273	ELEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4333	FFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4207	JHEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4306	KEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4319	PAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4283	PON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4556	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4217	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4290	ISEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4320	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4186	OCEPUG3	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4347	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4167	SPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4358	EPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4289	AIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4242	FAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4566	GPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4219	ICSPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4318	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4189	BPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4197	DHPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4203	FAEPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4188	ICSPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4405	SKEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4399	BLMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4322	PEDMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4397	GAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4192	HAPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4265	PAPUGYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4151	EDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4159	HCT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4392	HMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4323	HIVA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4400	SPP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4291	POE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4324	PAE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4401	ST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4213	ETMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4169	LPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4325	POSMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4292	PCCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4304	ASCAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4403	OTS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4293	PSDRG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4326	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4272	FLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4294	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4398	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4305	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4295	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4327	ETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4404	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4297	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4382	PMOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4328	ASCA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4298	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4299	BIOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4330	PFR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4300	LAWA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4301	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4565	APHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4394	CONTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4396	MTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4415	POSPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4313	FRLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4274	POL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4275	TTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4285	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4278	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4281	WLPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4308	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4309	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4279	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4282	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4284	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4315	ITBL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4311	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4317	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4235	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4173	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4218	IGSP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4540	APMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4276	LOM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4280	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4187	POM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4393	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4160	HOCTMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4450	DISSER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4248	ATPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4337	OSAD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4340	DFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4341	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4342	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4364	AFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4381	AQKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4367	OIAF	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4368	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4370	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4365	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4329	DEMC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4366	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4303	HRPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4310	AQLKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4162	MAHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4378	HPICK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4338	MAISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4339	PHIH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4331	POLA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4374	PHMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4371	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4372	MFAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4422	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4373	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4259	IGSPI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4263	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4531	GREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4536	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4377	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4249	NIETZ	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4312	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4260	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4264	PHILAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4351	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4266	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4379	ARGWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4166	ECONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4214	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4307	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4344	CONTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4352	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4175	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4267	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4251	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4254	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4353	RETREAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4268	CONTLit	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4375	PEOPLES	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4176	ALFPUG	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4252	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4177	THNGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4376	THGARD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4253	PHMATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4256	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4178	HITFILM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4270	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4362	POLTHEO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4179	PHILMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4384	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4181	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4519	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4314	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4255	DISSERT	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4354	DISSERT	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4523	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4524	ICTNET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4537	ENVIRON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4436	FLYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4538	ICTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4541	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4532	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4543	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4542	SOCILPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4544	ENVIRON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4545	EDUC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4180	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4316	CONFMANG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4269	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4411	DHBAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4402	DEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4174	HIVAIDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4257	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4383	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4454	INTROPM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4361	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4262	MARX	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4271	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4363	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4258	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4350	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4163	METAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4261	PHOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4525	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4149	NGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4550	ECON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4552	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4549	ENVIRON	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4551	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4553	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4546	PHILREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4547	PHILSICEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4548	POLIPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4533	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4554	THEATRE2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4557	BLETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4558	EGYPTGREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4526	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4559	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4560	DEWEY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4561	SOCSPIR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4562	SOCSPIR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4563	ENVIRONETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4564	SPECIALED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4239	PMEYR3	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4534	SOCIALS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4567	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4583	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4568	MATHS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4458	APPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4569	ICTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4570	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4586	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4571	MATHS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4343	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4590	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4572	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4573	ARISETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4574	ARISETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4575	KANTEPIS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4576	KANTEPIS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4165	PHILANTH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4577	SHONA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4578	SHONA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4579	PHIOFLIFE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4580	PHIOFLIFE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4581	ISLAMAFRIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4582	ISLAMAFRIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4584	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4585	GENDER2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4587	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4589	GENDER2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4591	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4592	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4593	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4594	SIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4595	SIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4596	AFRIPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4597	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4598	CCNA1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4599	CCNA1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4600	ARISTM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4601	ETHICSD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4602	PSYCHIN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4603	SOCEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4604	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4605	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4606	SOEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4607	CORPG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4608	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4609	ARISTM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4610	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4611	CORPG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4612	ETHICSD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4613	PSYCHIN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4614	PHILI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4615	SOCEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4616	SOEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4617	FANON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4620	FANON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4621	PHILI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4622	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4623	BIOET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4624	PHILED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4625	ECONO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4626	PHILPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4627	PHILDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4628	LITPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4629	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4630	HEGELN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4631	HEGELN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4632	AFLIT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4633	PERSON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4634	AFRICANH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4635	PHERM	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4636	CHILDP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4637	CHILDP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4638	PLATOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4639	PLATOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4640	NGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4641	Hebrew	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4642	CCNA2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4643	CCNA2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4646	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4649	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4651	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4644	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4652	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4648	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4650	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4656	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4645	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4654	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4655	BATFLYR1	\N	\N	\N	10	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4647	BATFLYR1	\N	\N	\N	24	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4653	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4658	BATFLYR1	\N	\N	\N	6	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4657	BATFLYR1	\N	\N	\N	10	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4670	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4662	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4664	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4666	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4665	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4668	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4659	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4663	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4669	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4660	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4661	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4732	PHWRI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4810	HMPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4764	APOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5042	ARTL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4733	AFPSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4769	ARTL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4952	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4953	Dewey	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4954	PHMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4955	SPNEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4956	FREUD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4698	PolPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4694	PHREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4982	ARGW	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4959	AFTLIT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4960	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4961	PGDMETA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4962	HMPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4963	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4965	TAYLOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4967	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4968	MARCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4771	PHYSICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4970	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4972	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4973	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4990	GABRIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5000	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5002	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5003	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5004	PSYCHOED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5005	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5006	DISASTERC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5007	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4809	LTIN	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4941	PHWRI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4942	CHRTA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4765	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4770	AFCHRIST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4978	Laudatosi	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4980	PSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4983	ORALC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5056	PGDCON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4984	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5018	HEGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4986	GUIDANCE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4987	PHYSICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4988	GUIDANCE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4969	MICROSOFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4989	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5020	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5015	CATOHSO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5016	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4677	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5021	DISASTERC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5022	LEADERSHIP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4993	ART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4994	GENDER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4964	MDRSK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5011	IRELATIONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4997	MICROSOFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4998	GENDER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4999	IRELATIONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5029	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4991	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4992	APSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5010	SOCPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4985	PHILANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5026	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5014	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5048	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5008	Dewey	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4974	IKANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4951	IKANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4976	INTROPM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4981	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5019	HEGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5013	AQUINAS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5001	AQUINASM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5009	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5025	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4995	HEPW	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5034	ANALYSISII	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5027	SOCPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5028	ANALYSISII	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5039	MORALITYA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5023	MLL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5033	CSTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5024	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5035	CATOHSO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5036	STUART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5031	SGFREUD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5032	SPNEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5041	STUART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5038	LITURGY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4678	PSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5108	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5043	LITURGY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4931	BAFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5120	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4879	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5092	MRYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5049	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4944	VT2YR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4947	APYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4676	RWYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4855	PTDYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4943	ITYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5146	PLYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4946	ESYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4857	HMYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5017	EHYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5147	APYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5053	NTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4940	PGYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4912	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4914	IPYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4683	IOTYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4691	CHYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4915	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4870	ATYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4682	PRYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4685	NTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4702	ALFYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4937	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4880	PSYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4872	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4934	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4996	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4761	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4873	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4751	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4749	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4750	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4691	CHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4680	RPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4685	NTYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4932	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4948	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4774	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4818	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4803	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4930	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4936	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4938	WHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4856	EYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4720	SSAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4949	CPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4904	MCPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4909	OTFYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4950	PPPYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4910	REYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4911	OCTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4740	OCYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4913	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4675	GAAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4748	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4758	HRs	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5037	TIME	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4966	PSDRGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4782	PLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4747	PFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4767	RSFANEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4893	PCMEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4781	BEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4737	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4861	HMPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4919	EPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4687	HCTPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4684	INTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4752	APDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4688	IEDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4753	CTIDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4754	IDDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4686	ITDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4755	PCMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4759	ICSDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4756	HRDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4757	DHDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4843	BAPRE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4719	RAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4768	HMPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4958	EPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4738	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4739	RWPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4743	PLPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4742	CPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5121	MCPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4722	SAPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4671	PGPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4723	PPPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4724	OCTPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4726	PSDPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4727	IPLPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4728	PFPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4729	PCMPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4730	APPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4673	LPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4762	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4881	IPPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4701	SSAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4883	ESPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4734	PMEPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4711	OFPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4712	EHPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4713	NTFPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4714	REPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4854	PAEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5069	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4736	CTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4799	ELEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4860	FFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4735	JHEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4828	KEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4841	PAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4807	PON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5070	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4744	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4812	ISEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4842	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4715	OCEPUG3	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4871	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4697	SPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4882	EPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4811	AIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4766	FAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5080	GPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4746	ICSPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4840	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4718	BPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4725	DHPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4731	FAEPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4717	ICSPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4929	SKEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4923	BLMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4844	PEDMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4921	GAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4721	HAPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4791	PAPUGYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4681	EDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4689	HCT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4916	HMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4845	HIVA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4924	SPP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4813	POE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4846	PAE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4925	ST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4783	ETMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4699	LPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4847	POSMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4814	PCCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4826	ASCAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4927	OTS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4815	PSDRG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4848	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4798	FLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4816	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4922	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4827	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4817	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4849	ETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4928	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4819	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4906	PMOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4850	ASCA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4820	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4821	BIOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4852	PFR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4822	LAWA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4823	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5079	APHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4918	CONTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4920	MTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4939	POSPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4835	FRLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4800	POL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4801	TTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4862	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4863	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4805	WLPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4830	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4831	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5122	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4806	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4808	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4837	ITBL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4833	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4839	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4760	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4703	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4745	IGSP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5057	APMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4802	LOM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4804	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4716	POM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4917	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4690	HOCTMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4971	DISSER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4772	ATPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4858	OSAD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4865	DFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4866	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4867	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4888	AFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4905	AQKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4891	OIAF	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4892	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4894	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4889	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4851	DEMC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4890	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4825	HRPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4832	AQLKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4692	MAHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4902	HPICK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4859	MAISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4864	PHIH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4853	POLA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4898	PHMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4895	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4896	MFAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4945	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4897	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4785	IGSPI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4789	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5050	GREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5054	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4901	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4773	NIETZ	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4834	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4786	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4790	PHILAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4875	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4792	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4903	ARGWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4696	ECONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4741	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4829	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4869	CONTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4876	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4672	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4793	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4780	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4777	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4877	RETREAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4794	CONTLit	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4899	PEOPLES	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4705	ALFPUG	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4775	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4706	THNGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4900	THGARD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4776	PHMATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4779	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4707	HITFILM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4796	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4886	POLTHEO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4708	PHILMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4908	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4710	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5040	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4836	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4778	DISSERT	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4878	DISSERT	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5044	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5045	ICTNET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5094	ENVIRON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4957	FLYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5055	ICTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5058	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5051	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5060	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5059	SOCILPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5061	ENVIRON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5062	EDUC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4709	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4838	CONFMANG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4795	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4935	DHBAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4926	DEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4704	HIVAIDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4674	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4907	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4975	INTROPM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4885	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4788	MARX	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4797	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4887	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4784	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4874	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4693	METAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4787	PHOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5046	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4679	NGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5064	ECON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5066	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5095	ENVIRON	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5065	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5067	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5063	PHILREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5097	PHILSICEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5096	POLIPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5093	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5068	THEATRE2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5071	BLETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5072	EGYPTGREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5047	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5073	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5074	DEWEY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5075	SOCSPIR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5076	SOCSPIR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5077	ENVIRONETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5078	SPECIALED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4763	PMEYR3	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5052	SOCIALS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5081	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5103	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5082	MATHS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4979	APPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5083	ICTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5084	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5106	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5085	MATHS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4868	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5110	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5086	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5087	ARISETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5088	ARISETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5089	KANTEPIS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5090	KANTEPIS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4695	PHILANTH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5091	SHONA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5098	SHONA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5099	PHIOFLIFE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5100	PHIOFLIFE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5101	ISLAMAFRIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5102	ISLAMAFRIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5104	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5105	GENDER2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5107	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5109	GENDER2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5111	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5112	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5113	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5114	SIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5115	SIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5116	AFRIPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5117	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5118	CCNA1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5119	CCNA1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5123	ARISTM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5124	ETHICSD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5125	PSYCHIN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5126	SOCEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5127	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5128	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5138	SOEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5129	CORPG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5130	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5131	ARISTM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5132	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5133	CORPG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5134	ETHICSD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5135	PSYCHIN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5136	PHILI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5137	SOCEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5139	SOEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5140	FANON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5141	FANON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5142	PHILI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5143	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5144	BIOET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5145	PHILED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5148	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5149	HEGELN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5150	HEGELN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5151	AFLIT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5152	PERSON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5153	AFRICANH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5154	PHERM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5155	CHILDP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5156	CHILDP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5157	PLATOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5158	PLATOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5159	NGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5160	Hebrew	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5161	CCNA2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5162	CCNA2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5165	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5167	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5170	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5163	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5171	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5168	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5169	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5175	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5164	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5173	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5174	BATFLYR1	\N	\N	\N	10	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5166	BATFLYR1	\N	\N	\N	24	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5172	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5177	BATFLYR1	\N	\N	\N	6	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5176	BATFLYR1	\N	\N	\N	10	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5188	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5181	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5183	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5185	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5184	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5186	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5178	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5182	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5187	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5179	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5180	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5189	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5190	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	5191	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	5192	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5193	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5195	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5194	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5196	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5197	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4933	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5198	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5199	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5200	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	5202	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5203	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5204	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5206	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5207	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5208	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5209	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5210	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5211	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5212	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5205	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5213	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5214	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5215	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5216	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5217	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5218	ASIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5219	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5220	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5221	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5222	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5223	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5224	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5227	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5228	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5229	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5230	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5231	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5232	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5233	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5234	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5242	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5241	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5243	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5245	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5240	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5248	TFTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5246	TFTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5247	TFTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5244	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5249	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5250	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5251	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
\.


--
-- Data for Name: course_sections; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.course_sections (school_year, school_id, course_section_id, course_id, course_credit_title, title, short_name, school_period_id, mp, school_term_id, teacher_id, room, total_seats, filled_seats, does_attendance, does_grades, does_gpa, gender_restriction, house_restriction, credits, availability, rollover_id, parent_id, days, calendar_id, grade_type_id, does_gpa_1, does_gpa_2, does_gpa_3, does_gpa_4, does_gpa_5, cp_checkbox_setting_1, cp_checkbox_setting_2, cp_checkbox_setting_3, cp_checkbox_setting_4, cfield_1, cfield_2, cfield_3, cfield_4, cfield_5, cfield_6, cfield_25, co_teacher_id1, co_teacher_id2, co_teacher_id3, co_teacher_id4, co_teacher_id5, co_teacher_id6, co_teacher_id7, co_teacher_id8, co_teacher_id9, co_teacher_id10, co_teacher1_custom1, co_teacher2_custom1, co_teacher3_custom1, co_teacher4_custom1, co_teacher5_custom1, co_teacher6_custom1, co_teacher7_custom1, co_teacher8_custom1, co_teacher9_custom1, co_teacher10_custom1, co_teacher1_custom2, co_teacher2_custom2, co_teacher3_custom2, co_teacher4_custom2, co_teacher5_custom2, co_teacher6_custom2, co_teacher7_custom2, co_teacher8_custom2, co_teacher9_custom2, co_teacher10_custom2, co_teacher1_checkbox1, co_teacher2_checkbox1, co_teacher3_checkbox1, co_teacher4_checkbox1, co_teacher5_checkbox1, co_teacher6_checkbox1, co_teacher7_checkbox1, co_teacher8_checkbox1, co_teacher9_checkbox1, co_teacher10_checkbox1, cp_checkbox_setting_6, cp_checkbox_setting_7, cp_checkbox_setting_8, co_teacher1_permissions, co_teacher2_permissions, co_teacher3_permissions, co_teacher4_permissions, co_teacher5_permissions, co_teacher6_permissions, co_teacher7_permissions, co_teacher8_permissions, co_teacher9_permissions, co_teacher10_permissions, co_teacher1_report_doe, co_teacher2_report_doe, co_teacher3_report_doe, co_teacher4_report_doe, co_teacher5_report_doe, co_teacher6_report_doe, co_teacher7_report_doe, co_teacher8_report_doe, co_teacher9_report_doe, co_teacher10_report_doe, merge_id, week) FROM stdin;
2012	3	470	809	PTDYR2	Period4 - SEM1 - MonWedFri - A  Manyere	\N	40	SEM	118	30	YR2	\N	24	Y	Y	Y	N	\N	\N	\N	470	470	MonWedFri	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	473	820	EHYR4	Period2 - SEM1 - MonWed - Simon  Makuru	\N	38	SEM	118	45	YR4	\N	21	Y	Y	Y	N	\N	\N	\N	473	473	MonWed	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	574	954	AIYR1	Period5 - T2 - MonWedFri - A  Chennells	\N	33	QTR	41	42	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	\N	574	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	587	967	PEEL	Period7 - SEM 2 - TueThu - A  Zvaiwa	\N	35	SEM	34	51	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	\N	587	TueThu	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	468	797	MRYR1	Period2 - SEM1 - TueThu - C  Nyandoro	\N	38	SEM	118	59	YR1	\N	11	Y	Y	Y	N	\N	\N	\N	468	468	TueThu	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	474	819	APYR4	Period3 - SEM1 - MonWedFri - Bienvenu  Mayemba	\N	39	SEM	118	80	YR3	\N	21	Y	Y	Y	N	\N	\N	\N	474	474	MonWedFri	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	472	821	PGYR4	Period4 - SEM1 - MonWedFri - T  Sherman	\N	40	SEM	118	21	YR4	\N	21	Y	Y	Y	N	\N	\N	\N	472	472	MonWedFri	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	465	812	PSYR3	Period4 - SEM1 - MonThu - Kizito  Kiyimba	\N	40	SEM	118	13	YR3	\N	19	Y	Y	Y	N	\N	\N	\N	465	465	MonThu	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	480	803	RWYR2	Period3 - SEM1 - MonWedFri - Francis  Zangairai	\N	39	SEM	118	78	YR2	\N	24	Y	Y	Y	N	\N	\N	\N	480	480	MonWedFri	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	408	755	FLPUG1	Period1 - SEM1 - MonWedFri - Dominique  Karani	\N	5	SEM	33	54	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	408	408	MonWedFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	454	807	PHAYR2	Period2 - SEM1 - MonWedFri - John  Stacer	\N	38	SEM	118	50	YR2	\N	24	Y	Y	Y	N	\N	\N	\N	454	454	MonWedFri	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	453	862	ALFYR2	Period3 - SEM1 - TueThu - Olivier  Sempiga	\N	39	SEM	118	38	YR2	\N	12	Y	Y	Y	N	\N	\N	\N	453	453	TueThu	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	467	793	HAYR1	Period2 - SEM1 - MonWedFri - P  Nyambara	\N	38	SEM	118	8	YR1	\N	11	Y	Y	Y	N	\N	\N	\N	467	467	MonWedFri	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	469	795	VT2YR1	Period3 - SEM1 - Mon - Joseph  Mahlahla	\N	39	SEM	118	79	YR1	\N	11	Y	Y	Y	N	\N	\N	\N	469	469	Mon	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	657	408	CONP	Period2 - SEM 2 - MonWedFri - John  Sanni	\N	6	SEM	34	82	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	\N	657	MonWedFri	18	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	459	888	APDPT	Period2 - SEM 2 - TueThuFri - Diddy  Brossala	\N	38	SEM	119	24	YR2	\N	1	Y	Y	Y	N	\N	\N	\N	459	459	TueThuFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	484	815	CPYR3	Period2 - SEM 2 - MonWed - Diddy  Brossala	\N	38	SEM	119	24	YR3	\N	19	Y	Y	Y	N	\N	\N	\N	484	484	MonWed	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	457	840	NTYR2	Period1 - SEM1 - TueThu - A  Mandeya	\N	37	SEM	118	20	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	457	457	TueThu	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	84	401	OCYR4	Period1 - SEM 2 - MonTueWedThuFri - John  Stacer	\N	5	SEM	34	50	YR4	\N	206	Y	Y	Y	N	\N	\N	\N	84	84	MonTueWedThuFri	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	339	689	RMHDPTE	Period1 - SEM 2 - TueThu - Kenneth  Makamure	\N	29	SEM	108	56	YR2	\N	1	Y	Y	Y	N	\N	\N	\N	\N	339	TueThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	575	955	PEEL	Period7 - T2 - TueThu - A  Zvaiwa	\N	35	QTR	41	51	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	\N	575	TueThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	588	968	STEL	Period6 - SEM 2 - MonWedFri - Costa  Virgilio	\N	34	SEM	34	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	\N	588	MonWedFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	537	901	SSAPUG1	Period1 - SEM 2 - MonWedThu - Ben  Sachikonye	\N	37	SEM	119	37	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	537	537	MonWedThu	24	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	545	910	ICSPUGE	Period1 - SEM 2 - MonWedFri - K  Esenther	\N	37	SEM	119	22	Computer	\N	0	Y	Y	Y	N	\N	\N	\N	545	545	MonWedFri	24	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	543	914	RAPUG1	Period1 - SEM 2 - MonThuFri - Francis  Zangairai	\N	37	SEM	119	78	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	543	543	MonThuFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	550	935	FAEPUGE	Period1 - SEM 2 - Mon - T  Sherman	\N	37	SEM	119	21	Offices	\N	0	Y	Y	Y	N	\N	\N	\N	550	550	Mon	24	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	557	806	HMPYR2	Period2 - SEM 2 - TueWedFri - T  Sherman	\N	38	SEM	119	21	YR2	\N	24	Y	Y	Y	N	\N	\N	\N	557	557	TueWedFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	458	865	GAAPH	Period1 - SEM1 - MonTueWedThuFri - Ujah  Ejembi	\N	37	SEM	118	26	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	458	458	MonTueWedThuFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	460	891	IDDPT	Period4 - SEM 2 - TueThuFri - C  Nyandoro	\N	40	SEM	119	59	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	460	460	TueThuFri	24	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	461	837	PRYR2	Period2 - SEM1 - MonFri - T  Sherman	\N	38	SEM	118	21	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	461	461	MonFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	463	838	IOTYR1	Period2 - SEM1 - Wed - Zvaiwa  Zvaiwa	\N	38	SEM	118	\N	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	463	463	Wed	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	360	709	PTAPH	Period1 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	29	SEM	108	13	YR4	\N	3	Y	Y	Y	N	\N	\N	\N	\N	360	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	464	861	ATYR2	Period1 - SEM1 - MonFri - J  Chitakure	\N	37	SEM	118	27	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	464	464	MonFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1663	2054	MRS	Period1 - SEM1 - TueThu - C  Nyandoro	\N	77	SEM	143	59	YR1	\N	12	Y	Y	Y	N	\N	\N	\N	1663	1663	TueThu	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2023	2386	HITFILM	Period7 - SEM 2 - MonThu - K  Esenther	\N	91	SEM	149	22	\N	\N	6	Y	Y	Y	N	\N	\N	\N	2023	2023	MonThu	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	638	996	FLS	Period1 - SEM 2 - WedThu - A  Ggita	\N	37	SEM	119	31	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	638	638	WedThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	462	828	IPYR1	Period1 - SEM1 - TueThu - A  Ggita	\N	37	SEM	118	31	YR1	\N	1	Y	Y	Y	N	\N	\N	\N	462	462	TueThu	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	487	873	DPTEL	Period2 - SEM1 - TueThu - A  Mandeya	\N	38	SEM	118	20	YR2	\N	3	Y	Y	Y	N	\N	\N	\N	487	487	TueThu	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	475	826	CMYR1	Period1 - SEM1 - MonWedFri - C  Nyandoro	\N	37	SEM	118	59	YR1	\N	1	Y	Y	Y	N	\N	\N	\N	475	475	MonWedFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	576	956	SKEL	Period8 - T2 - TueThu - Diddy  Brossala	\N	36	QTR	41	24	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	\N	576	TueThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	202	555	SPMA	Period2 - SEM 2 - TueWed -   Fekete	\N	22	SEM	58	72	Seminar	\N	4	Y	Y	Y	N	\N	\N	\N	202	202	TueWed	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	340	690	APDPTE	Period1 - SEM 2 - TueThu - A  Zvaiwa	\N	29	SEM	108	51	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	\N	340	TueThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	589	969	PAEL	Period7 - SEM 2 - TueThu - A  Ggita	\N	35	SEM	34	31	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	\N	589	TueThu	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	180	533	WLYR2	Period4 - SEM 2 - MonWed - A  Chennells	\N	24	SEM	58	42	YR2	\N	22	Y	Y	Y	N	\N	\N	\N	180	180	MonWed	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	189	542	CHDPT	Period2 - SEM1 - MonThuFri - J  Zimbudzana	\N	22	SEM	59	70	YR1	\N	8	Y	Y	Y	N	\N	\N	\N	189	189	MonThuFri	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	344	694	HMPYR3	Period2 - SEM1 - MonTueWedThuFri - Simon  Makuru	\N	30	SEM	109	45	YR3	\N	29	Y	Y	Y	N	\N	\N	\N	\N	344	MonTueWedThuFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	392	741	HRDPTE	Period1 - SEM1 - TueThu - Abel  Chikomo	\N	29	SEM	109	76	Seminar	\N	1	Y	Y	Y	N	\N	\N	\N	\N	392	TueThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	173	526	ALFYR2	Period2 - SEM1 - MonFri - G  Ncube	\N	22	SEM	59	58	YR2	\N	4	Y	Y	Y	N	\N	\N	\N	173	173	MonFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	183	536	SSAYR2	Period4 - SEM 2 - MonTueThu - C  Brand	\N	24	SEM	58	69	YR2	\N	26	Y	Y	Y	N	\N	\N	\N	183	183	MonTueThu	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	174	527	WLYR2	Period3 - SEM1 - MonWed - A  Chennells	\N	23	SEM	59	42	YR2	\N	22	Y	Y	Y	N	\N	\N	\N	174	174	MonWed	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	191	544	IOTDPT	Period3 - SEM 2 - TueWedThu - A  Mandeya	\N	23	SEM	58	20	YR2	\N	8	Y	Y	Y	N	\N	\N	\N	191	191	TueWedThu	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	186	539	IPLDPT	Period4 - SEM1 - MonThuFri - Simon  Makuru	\N	24	SEM	59	45	YR1	\N	8	Y	Y	Y	N	\N	\N	\N	186	186	MonThuFri	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	398	746	PTDPTE	Period1 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	29	SEM	108	13	DIP YR1	\N	2	Y	Y	Y	N	\N	\N	\N	\N	398	MonWedFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	384	733	CADPT	Period3 - SEM 2 - MonThuFri - C  Nyandoro	\N	31	SEM	108	59	DIP YR1	\N	12	Y	Y	Y	N	\N	\N	\N	\N	384	MonThuFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	376	725	TSPAPHE	Period1 - SEM1 - TueThu - A  Chennells	\N	29	SEM	109	42	Seminar	\N	4	Y	Y	Y	N	\N	\N	\N	\N	376	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	368	717	PFAPHE	Period1 - SEM 2 - TueThu - Diddy  Brossala	\N	29	SEM	108	24	YR1	\N	4	Y	Y	Y	N	\N	\N	\N	\N	368	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	126	484	APYR1	Period4 - SEM 2 - TueThu - Odomaro  Mubandizi	\N	12	SEM	43	49	YR1	\N	22	Y	Y	Y	N	\N	\N	\N	126	126	TueThu	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	123	481	EWYR1	Period1 - SEM 2 - TueThuFri - C  Nyandoro	\N	9	SEM	43	59	YR1	\N	22	Y	Y	Y	N	\N	\N	\N	123	123	TueThuFri	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	369	718	GPAPHE	Period1 - SEM 2 - MonWedFri - Ujah Gabriel Ejembi	\N	29	SEM	108	26	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	\N	369	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	385	734	HMPDPT	Period3 - SEM1 - MonTueThu - R  Ngaiza	\N	31	SEM	109	11	DIP YR2	\N	8	Y	Y	Y	N	\N	\N	\N	\N	385	MonTueThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	345	695	PSYR3	Period3 - SEM1 - MonWedFri - Kizito  Kiyimba	\N	31	SEM	109	13	YR3	\N	27	Y	Y	Y	N	\N	\N	\N	\N	345	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	377	726	JFAPHE	Period1 - SEM1 - MonWedFri - C  Matusse	\N	29	SEM	109	19	DIP YR1	\N	3	Y	Y	Y	N	\N	\N	\N	\N	377	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	341	691	PCMDPTE	Period1 - SEM 2 - MonWedFri - A  Mandeya	\N	29	SEM	108	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	\N	341	MonWedFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	184	537	HMPYR2	Period4 - SEM 2 - MonTueWed - T  Chimuka	\N	24	SEM	58	43	YR2	\N	26	Y	Y	Y	N	\N	\N	\N	184	184	MonTueWed	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	178	531	PTDYR2	Period2 - SEM1 - MonWedThu - A  Zvaiwa	\N	22	SEM	59	51	YR2	\N	26	Y	Y	Y	N	\N	\N	\N	178	178	MonWedThu	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	106	468	PCMDPT	Period1 - SEM 2 - MonWedFri - A  Mandeya	\N	5	SEM	34	20	YR3	\N	5	Y	Y	Y	N	\N	\N	\N	106	106	MonWedFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	476	838	IOTYR1	Period2 - SEM1 - WedFri - Zvaiwa  Zvaiwa	\N	38	SEM	118	\N	\N	\N	0	Y	Y	Y	N	\N	\N	\N	476	476	WedFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	477	829	HAYR1	Period3 - SEM1 - TueFri - C  Matusse	\N	39	SEM	118	19	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	477	477	TueFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	478	861	ATYR2	Period4 - SEM1 - Wed - J  Chitakure	\N	40	SEM	118	27	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	478	478	Wed	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	479	837	PRYR2	Period2 - SEM1 - MonFri - T  Sherman	\N	38	SEM	118	21	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	479	479	MonFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	175	528	RWYR2	Period2 - SEM1 - MonWedFri - Dr  Seelan	\N	22	SEM	59	68	YR2	\N	23	Y	Y	Y	N	\N	\N	\N	175	175	MonWedFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	181	534	WHYR2	Period4 - SEM 2 - MonWedThu - R  Roberts	\N	24	SEM	58	60	YR2	\N	22	Y	Y	Y	N	\N	\N	\N	181	181	MonWedThu	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	187	540	HAPDPT	Period4 - SEM1 - TueWedThu - T  Chimuka	\N	24	SEM	59	43	YR1	\N	8	Y	Y	Y	N	\N	\N	\N	187	187	TueWedThu	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1668	2059	PLS	Period6 - SEM1 - MonWed - Costa  Virgilio	\N	82	SEM	143	33	YR 3	\N	1	Y	Y	Y	N	\N	\N	\N	1668	1668	MonWed	47	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1757	2181	VT2YR1	Period3 - SEM1 - Mon - Joseph  Mahlahla	\N	87	SEM	148	79	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	1757	1757	Mon	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	192	545	ITDPT	Period4 - SEM 2 - MonThuFri - J  Chitakure	\N	24	SEM	58	27	YR2	\N	8	Y	Y	Y	N	\N	\N	\N	192	192	MonThuFri	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	203	556	EMA	Period1 - SEM1 - MonFri - Lawrence  Daka	\N	21	SEM	59	44	Seminar	\N	6	Y	Y	Y	N	\N	\N	\N	203	203	MonFri	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	200	553	PPMA	Period3 - SEM 2 - MonWedFri - Odomaro  Mubandizi	\N	23	SEM	58	49	Seminar	\N	4	Y	Y	Y	N	\N	\N	\N	200	200	MonWedFri	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	353	702	CPYR3	Period1 - SEM 2 - MonWedFri - Diddy  Brossala	\N	29	SEM	108	24	YR3	\N	29	Y	Y	Y	N	\N	\N	\N	\N	353	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	361	710	HTAPHE	Period1 - SEM 2 - TueThu - Simon  Makuru	\N	29	SEM	108	45	GYM Room	\N	0	Y	Y	Y	N	\N	\N	\N	\N	361	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	316	680	MMA	Period2 - SEM 2 - MonWedThu - T  Sherman	\N	30	SEM	108	21	Seminar	\N	1	Y	Y	Y	N	\N	\N	\N	199	316	MonWedThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	397	682	PRMA	Period3 - SEM 2 - MonThu - T  Sherman	\N	31	SEM	108	21	Seminar	\N	1	Y	Y	Y	N	\N	\N	\N	\N	397	MonThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	577	957	PAEEL	Period7 - T2 - TueThu - A  Ggita	\N	35	QTR	41	31	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	\N	577	TueThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	124	482	LAYR1	Period3 - SEM 2 - TueWed - Anthony  Chennells	\N	11	SEM	43	42	YR1	\N	22	Y	Y	Y	N	\N	\N	\N	124	124	TueWed	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	121	480	FLYR1	Period1 - SEM 2 - MonWedFri - Dominique  Karani	\N	9	SEM	43	54	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	121	121	MonWedFri	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	128	486	OCYR1	Period3 - SEM 2 - MonFri - A  Zvaiwa	\N	11	SEM	43	51	YR1	\N	22	Y	Y	Y	N	\N	\N	\N	128	128	MonFri	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	125	483	RAYR1	Period2 - SEM 2 - TueWedFri - M  Chirovamavi	\N	10	SEM	43	61	YR1	\N	22	Y	Y	Y	N	\N	\N	\N	125	125	TueWedFri	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	127	485	LYR1	Period3 - SEM 2 - MonWedFri - Simon  Makuru	\N	11	SEM	43	45	YR1	\N	22	Y	Y	Y	N	\N	\N	\N	127	127	MonWedFri	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	117	476	HAYR1	Period1 - SEM1 - MonFri - R  Roberts	\N	9	SEM	44	60	YR1	\N	22	Y	Y	Y	N	\N	\N	\N	117	117	MonFri	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	116	475	LAYR1	Period3 - SEM1 - WedFri - Anthony  Chennells	\N	11	SEM	44	42	YR1	\N	22	Y	Y	Y	N	\N	\N	\N	116	116	WedFri	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	120	479	IPYR1	Period3 - SEM1 - TueThu - Odomaro  Mubandizi	\N	11	SEM	44	49	YR1	\N	22	Y	Y	Y	N	\N	\N	\N	120	120	TueThu	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	118	477	SVCYR1	Period3 - SEM1 - MonFri - W  Cleary	\N	11	SEM	44	14	YR1	\N	44	Y	Y	Y	N	\N	\N	\N	118	118	MonFri	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	115	474	EWYR1	Period2 - SEM1 - WedThu - Joe  Arimoso	\N	10	SEM	44	52	YR1	\N	44	Y	Y	Y	N	\N	\N	\N	115	115	WedThu	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	113	473	FLYR1	Period1 - SEM1 - MonWedFri - Dominique  Karani	\N	9	SEM	44	54	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	113	113	MonWedFri	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	590	970	PAEL	Period7 - SEM 2 - TueThu - A  Ggita	\N	35	SEM	34	31	PUG	\N	0	Y	Y	Y	N	\N	\N	\N	\N	590	TueThu	7	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	119	478	MRSYR1	Period3 - SEM1 - TueThu - C  Nyandoro	\N	11	SEM	44	59	YR1	\N	21	Y	Y	Y	N	\N	\N	\N	119	119	TueThu	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	122	480	FLYR1	Period1 - SEM 2 - MonWedFri - G  Ncube	\N	9	SEM	43	58	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	122	122	MonWedFri	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	114	473	FLYR1	Period1 - SEM1 - MonWedFri - G  Ncube	\N	9	SEM	44	58	YR2	\N	9	Y	Y	Y	N	\N	\N	\N	114	114	MonWedFri	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	386	735	EDPT	Period4 - SEM1 - MonTueWed - K  Addy	\N	32	SEM	109	71	DIP YR2	\N	8	Y	Y	Y	N	\N	\N	\N	\N	386	MonTueWed	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	346	696	PLPYR3	Period4 - SEM1 - TueThuFri - R  Ngaiza	\N	32	SEM	109	11	YR3	\N	27	Y	Y	Y	N	\N	\N	\N	\N	346	TueThuFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	370	719	PCMAPHE	Period1 - SEM 2 - TueThu - A  Mandeya	\N	29	SEM	108	20	DIP YR1	\N	6	Y	Y	Y	N	\N	\N	\N	\N	370	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	362	711	KGAPHE	Period1 - SEM 2 - MonWedFri - Simon  Makuru	\N	29	SEM	108	45	Seminar	\N	3	Y	Y	Y	N	\N	\N	\N	\N	362	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	160	525	FLYR1	Period1 - SEM 2 - MonWedFri - Dominique  Karani	\N	21	SEM	58	54	YR1	\N	16	Y	Y	Y	N	\N	\N	\N	160	160	MonWedFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	481	840	NTYR3	Period2 - SEM1 - TueThu - A  Mandeya	\N	38	SEM	118	20	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	481	481	TueThu	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	482	895	HRs	Period1 - SEM1 - Mon - Costa  Virgilio	\N	37	SEM	118	33	Office	\N	0	Y	Y	Y	N	\N	\N	\N	482	482	Mon	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	354	703	PMEYR3	Period2 - SEM 2 - TueThu - A  Perumalil	\N	30	SEM	108	9	YR3	\N	26	Y	Y	Y	N	\N	\N	\N	\N	354	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	171	525	FLYR1	Period1 - SEM 2 - MonWedFri - G  Ncube	\N	21	SEM	58	58	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	171	171	MonWedFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	164	513	HAYR1	Period1 - SEM1 - MonFri - P  Nyambara	\N	21	SEM	59	8	YR1	\N	18	Y	Y	Y	N	\N	\N	\N	164	164	MonFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	197	546	APYR2	Period4 - SEM 2 - MonFri - K  Addy	\N	24	SEM	58	71	YR1	\N	8	Y	Y	Y	N	\N	\N	\N	197	197	MonFri	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	185	538	CMDPT	Period3 - SEM1 - WedThuFri - A  Zvaiwa	\N	23	SEM	59	51	YR1	\N	8	Y	Y	Y	N	\N	\N	\N	185	185	WedThuFri	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	190	543	CMDPT	Period3 - SEM 2 - MonWedThu - A  Zvaiwa	\N	23	SEM	58	51	YR2	\N	8	Y	Y	Y	N	\N	\N	\N	190	190	MonWedThu	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	188	541	HCTDPT	Period1 - SEM1 - TueWedFri - C  Nyandoro	\N	21	SEM	59	59	YR1	\N	8	Y	Y	Y	N	\N	\N	\N	188	188	TueWedFri	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	378	727	MHAPHE	Period1 - SEM1 - TueThu - Simon  Makuru	\N	29	SEM	109	45	GYM Room	\N	0	Y	Y	Y	N	\N	\N	\N	\N	378	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1993	2242	ECONS	Period8 - SEM 2 - MonFri - Costa  Virgilio	\N	92	SEM	149	33	\N	\N	9	Y	Y	Y	N	\N	\N	\N	1993	1993	MonFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	342	692	TJRDPTE	Period2 - SEM 2 - TueThu - R  Ngaiza	\N	30	SEM	108	11	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	\N	342	TueThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	393	742	TGMMA	Period1 - SEM1 - MonWedFri - John  Stacer	\N	29	SEM	109	50	Seminar	\N	2	Y	Y	Y	N	\N	\N	\N	\N	393	MonWedFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	578	958	STEEL	Period6 - T2 - MonWed - Costa  Virgilio	\N	34	QTR	41	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	\N	578	MonWed	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	591	971	GAEL	Period5 - SEM 2 - MonThu - A  Mandeya	\N	33	SEM	34	20	PUG	\N	0	Y	Y	Y	N	\N	\N	\N	\N	591	MonThu	7	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	343	693	HADPT	Period2 - SEM 2 - TueThuFri - A  Mandeya	\N	30	SEM	108	20	YR2	\N	13	Y	Y	Y	N	\N	\N	\N	\N	343	TueThuFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	387	736	MDPT	Period2 - SEM 2 - MonWedFri - A  Perumalil	\N	30	SEM	108	9	DIP YR2	\N	12	Y	Y	Y	N	\N	\N	\N	\N	387	MonWedFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	347	697	ESPYR3	Period2 - SEM1 - MonWed - Lawrence  Daka	\N	30	SEM	109	44	YR3	\N	29	Y	Y	Y	N	\N	\N	\N	\N	347	MonWed	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	355	704	OTFYR3	Period3 - SEM 2 - TueThuFri - Rev  Gusha	\N	31	SEM	108	77	YR3	\N	24	Y	Y	Y	N	\N	\N	\N	\N	355	TueThuFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	379	728	PMAPHE	Period2 - SEM1 - MonWedFri - Kizito  Kiyimba	\N	30	SEM	109	13	DIP YR1	\N	0	Y	Y	Y	N	\N	\N	\N	\N	379	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	363	712	EFBAPHE	Period1 - SEM 2 - MonWedFri - T  Sherman	\N	29	SEM	108	21	YR3	\N	2	Y	Y	Y	N	\N	\N	\N	\N	363	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	371	720	AADAPHE	Period1 - SEM 2 - MonWed - David  Kaulemu	\N	29	SEM	108	55	YR1	\N	4	Y	Y	Y	N	\N	\N	\N	\N	371	MonWed	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	394	743	DMA	Period4 - SEM1 - MonTueWedThuFri - teacher  teacher	\N	32	SEM	109	28	Offices	\N	6	Y	Y	Y	N	\N	\N	\N	\N	394	MonTueWedThuFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	161	521	OCYR1	Period3 - SEM 2 - MonFri - A  Zvaiwa	\N	23	SEM	58	51	YR1	\N	18	Y	Y	Y	N	\N	\N	\N	161	161	MonFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	177	530	PAYR2	Period4 - SEM1 - MonTueFri - John  Stacer	\N	24	SEM	59	50	YR2	\N	26	Y	Y	Y	N	\N	\N	\N	177	177	MonTueFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	199	552	MMA	Period2 - SEM 2 - MonWedThu - T  Sherman	\N	22	SEM	58	21	Seminar	\N	1	Y	Y	Y	N	\N	\N	\N	199	199	MonWedThu	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	206	559	PSMA	Period4 - SEM1 - MonWed - G  Zinyeka	\N	24	SEM	59	73	Seminar	\N	2	Y	Y	Y	N	\N	\N	\N	206	206	MonWed	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	372	721	ISRAPHE	Period1 - SEM 2 - TueThu - Kizito  Kiyimba	\N	29	SEM	108	13	Seminar	\N	1	Y	Y	Y	N	\N	\N	\N	\N	372	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	364	713	APAPHE	Period1 - SEM 2 - TueThu - A  Zvaiwa	\N	29	SEM	108	51	DIP YR1	\N	0	Y	Y	Y	N	\N	\N	\N	\N	364	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	380	729	HCTDPT	Period3 - SEM1 - MonWedFri - C  Nyandoro	\N	31	SEM	109	59	DIP YR1	\N	13	Y	Y	Y	N	\N	\N	\N	\N	380	MonWedFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	388	737	HCPDPT	Period2 - SEM 2 - TueThu - C  Matusse	\N	30	SEM	108	19	DIP YR2	\N	8	Y	Y	Y	N	\N	\N	\N	\N	388	TueThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	348	698	KMAPHE	Period1 - SEM1 - MonWedFri - R  Ngaiza	\N	29	SEM	109	11	YR2	\N	6	Y	Y	Y	N	\N	\N	\N	\N	348	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	356	705	MCPYR3	Period3 - SEM 2 - MonWedFri - T  Sherman	\N	31	SEM	108	21	YR3	\N	29	Y	Y	Y	N	\N	\N	\N	\N	356	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	554	905	OFPUG2	Period3 - SEM 2 - WedFri - I  Chidavaenzi	\N	39	SEM	119	18	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	554	554	WedFri	24	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	555	934	APPUGE	Period1 - SEM 2 - Mon - A  Perumalil	\N	37	SEM	119	9	Offices	\N	0	Y	Y	Y	N	\N	\N	\N	555	555	Mon	24	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	556	931	IPLPUGE	Period1 - SEM 2 - MonWedFri - T  Sherman	\N	37	SEM	119	21	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	556	556	MonWedFri	24	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	562	911	BPUGE	Period1 - SEM 2 - TueThu - Costa  Virgilio	\N	37	SEM	119	33	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	562	562	TueThu	24	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	395	744	ISRMA	Period3 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	31	SEM	108	13	Seminar	\N	1	Y	Y	Y	N	\N	\N	\N	\N	395	MonWedFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	579	959	BLEL	Period5 - SEM 2 - MonWedFri - John  Stacer	\N	33	SEM	34	50	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	\N	579	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	592	972	ISEL	Period5 - SEM 2 - MonWedFri - A  Manyere	\N	33	SEM	34	30	PUG	\N	0	Y	Y	Y	N	\N	\N	\N	\N	592	MonWedFri	7	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	365	714	PSDAPHE	Period1 - SEM 2 - TueWed - A  Manyere	\N	29	SEM	108	30	Aud Visual	\N	7	Y	Y	Y	N	\N	\N	\N	\N	365	TueWed	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	157	519	APYR1	Period4 - SEM 2 - TueThu - Odomaro  Mubandizi	\N	24	SEM	58	49	YR1	\N	22	Y	Y	Y	N	\N	\N	\N	157	157	TueThu	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	168	522	EWYR1	Period2 - SEM1 - WedThu - C  Nyandoro	\N	22	SEM	59	59	YR1	\N	18	Y	Y	Y	N	\N	\N	\N	168	168	WedThu	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	158	523	EWYR1	Period1 - SEM 2 - TueThuFri - C  Nyandoro	\N	21	SEM	58	59	YR1	\N	18	Y	Y	Y	N	\N	\N	\N	158	158	TueThuFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	169	524	FLYR1	Period1 - SEM1 - MonWedFri - Dominique  Karani	\N	21	SEM	59	54	YR1	\N	16	Y	Y	Y	N	\N	\N	\N	169	169	MonWedFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	172	524	FLYR1	Period1 - SEM1 - MonWedFri - G  Ncube	\N	21	SEM	59	58	YR2	\N	13	Y	Y	Y	N	\N	\N	\N	172	172	MonWedFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	166	516	IPYR1	Period3 - SEM1 - TueThu - Odomaro  Mubandizi	\N	23	SEM	59	49	YR1	\N	21	Y	Y	Y	N	\N	\N	\N	166	166	TueThu	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	165	512	LAYR1	Period3 - SEM1 - WedFri - A  Chennells	\N	23	SEM	59	42	YR1	\N	18	Y	Y	Y	N	\N	\N	\N	165	165	WedFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	159	517	LAYR1	Period3 - SEM 2 - TueWed - A  Chennells	\N	23	SEM	58	42	YR1	\N	18	Y	Y	Y	N	\N	\N	\N	159	159	TueWed	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1665	2056	WLPUG	Period1 - SEM1 - MonWed - A  Chennells	\N	77	SEM	143	42	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	1665	1665	MonWed	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1962	2179	BAFL	Period3 - SEM1 - MonThuFri - Dominique  Karani	\N	87	SEM	148	54	YR1	\N	8	Y	Y	Y	N	\N	\N	\N	1962	1962	MonThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	163	520	LYR1	Period3 - SEM 2 - MonWedFri - Simon  Makuru	\N	23	SEM	58	45	YR1	\N	23	Y	Y	Y	N	\N	\N	\N	163	163	MonWedFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	170	515	MRSYR1	Period3 - SEM1 - TueThu - C  Nyandoro	\N	23	SEM	59	59	YR1	\N	21	Y	Y	Y	N	\N	\N	\N	170	170	TueThu	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	162	518	RAYR1	Period2 - SEM 2 - TueWedFri - J  Chitakure	\N	22	SEM	58	27	YR1	\N	18	Y	Y	Y	N	\N	\N	\N	162	162	TueWedFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	167	514	SVCYR1	Period3 - SEM1 - MonFri - W  Cleary	\N	23	SEM	59	14	YR1	\N	18	Y	Y	Y	N	\N	\N	\N	167	167	MonFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	179	532	ALFYR2	Period2 - SEM 2 - MonThu - G  Ncube	\N	22	SEM	58	58	YR2	\N	4	Y	Y	Y	N	\N	\N	\N	179	179	MonThu	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	182	535	EYR2	Period2 - SEM 2 - MonTueWed - Lawrence  Daka	\N	22	SEM	58	44	YR2	\N	26	Y	Y	Y	N	\N	\N	\N	182	182	MonTueWed	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	176	529	HAPYR2	Period3 - SEM1 - TueThuFri - T  Chimuka	\N	23	SEM	59	43	YR2	\N	26	Y	Y	Y	N	\N	\N	\N	176	176	TueThuFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	193	548	HCTDPT	Period2 - SEM 2 - MonTueThu - C  Nyandoro	\N	22	SEM	58	59	YR2	\N	7	Y	Y	Y	N	\N	\N	\N	193	193	MonTueThu	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	205	558	APMA	Period4 - SEM1 - MonTueWed - David  Kaulemu	\N	24	SEM	59	55	Seminar	\N	4	Y	Y	Y	N	\N	\N	\N	205	205	MonTueWed	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	198	551	EMA	Period1 - SEM 2 - MonThuFri - Kizito  Kiyimba	\N	21	SEM	58	13	Seminar	\N	6	Y	Y	Y	N	\N	\N	\N	198	198	MonThuFri	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	204	557	IPMA	Period3 - SEM1 - MonWedFri - Dr  Seelan	\N	23	SEM	59	68	Seminar	\N	4	Y	Y	Y	N	\N	\N	\N	204	204	MonWedFri	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	207	560	PEMA	Period1 - SEM1 - MonThu - John  Stacer	\N	21	SEM	59	50	Seminar	\N	2	Y	Y	Y	N	\N	\N	\N	207	207	MonThu	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	201	554	PRMA	Period4 - SEM 2 - WedFri - T  Sherman	\N	24	SEM	58	21	Seminar	\N	3	Y	Y	Y	N	\N	\N	\N	201	201	WedFri	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	357	706	RMHAPH	Period1 - SEM 2 - MonWedFri - Kenneth  Makamure	\N	29	SEM	108	56	DIP YR2	\N	2	Y	Y	Y	N	\N	\N	\N	\N	357	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	381	730	INTDPT	Period4 - SEM1 - MonThuFri - A  Mandeya	\N	32	SEM	109	20	DIP YR1	\N	12	Y	Y	Y	N	\N	\N	\N	\N	381	MonThuFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	389	738	GADPTE	Period1 - SEM1 - MonWedFri - A  Mandeya	\N	29	SEM	109	20	DIP YR1	\N	0	Y	Y	Y	N	\N	\N	\N	\N	389	MonWedFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	349	699	GAAPHE	Period2 - SEM1 - TueThu - A  Mandeya	\N	30	SEM	109	20	YR3	\N	4	Y	Y	Y	N	\N	\N	\N	\N	349	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	396	745	CPMA	Period2 - SEM 2 - TueThu - Diddy  Brossala	\N	30	SEM	108	24	Seminar	\N	1	Y	Y	Y	N	\N	\N	\N	\N	396	TueThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	373	722	CTPWAPHE	Period1 - SEM1 - MonWedFri - Kizito  Kiyimba	\N	29	SEM	109	13	Seminar	\N	4	Y	Y	Y	N	\N	\N	\N	\N	373	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	351	700	HRAPHE	Period2 - SEM1 - MonFri - Abel  Chikomo	\N	30	SEM	109	76	YR2	\N	4	Y	Y	Y	N	\N	\N	\N	\N	351	MonFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	606	943	LLEL	Period1 - SEM1 - MonWedFri - K  Esenther	\N	37	SEM	118	22	\N	\N	1	Y	Y	Y	N	\N	\N	\N	606	606	MonWedFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	631	989	PCCEL	Period5 - SEM 2 - MonWedFri - A  Mandeya	\N	41	SEM	119	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	631	631	MonWedFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	645	1003	APHIL	Period4 - SEM 2 - TueWed - Diddy  Brossala	\N	40	SEM	119	24	YR1	\N	1	Y	Y	Y	N	\N	\N	\N	645	645	TueWed	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	605	913	BAPRE	Period4 - SEM1 - TueThu - A  Zvaiwa	\N	40	SEM	118	51	\N	\N	4	Y	Y	Y	N	\N	\N	\N	605	605	TueThu	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	358	707	PFAPHE	Period1 - SEM 2 - TueThu - T  Sherman	\N	29	SEM	108	21	DIP YR1	\N	1	Y	Y	Y	N	\N	\N	\N	\N	358	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	293	668	IPLDPT	Period4 - SEM1 - MonThuFri - Kizito  Kiyimba	\N	32	SEM	109	13	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	186	293	MonThuFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	366	715	IJSAPHE	Period1 - SEM 2 - MonThu - A  Manyere	\N	29	SEM	108	30	Aud Visual	\N	5	Y	Y	Y	N	\N	\N	\N	\N	366	MonThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	295	656	WLYR2	Period3 - SEM1 - MonWed - A  Chennells	\N	31	SEM	109	42	YR2	\N	18	Y	Y	Y	N	\N	\N	\N	174	295	MonWed	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	382	731	HMPDPT	Period3 - SEM 2 - TueThuFri - Ujah Gabriel Ejembi	\N	31	SEM	108	26	DIP YR1	\N	13	Y	Y	Y	N	\N	\N	\N	\N	382	TueThuFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	305	657	RWYR2	Period2 - SEM1 - MonWedFri - A  Perumalil	\N	30	SEM	109	9	YR2	\N	24	Y	Y	Y	N	\N	\N	\N	175	305	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	301	660	PTDYR2	Period2 - SEM1 - MonWedThu - A  Zvaiwa	\N	30	SEM	109	51	YR2	\N	24	Y	Y	Y	N	\N	\N	\N	178	301	MonWedThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	291	655	ALFYR2	Period2 - SEM1 - MonFri - G  Ncube	\N	30	SEM	109	58	YR2	\N	13	Y	Y	Y	N	\N	\N	\N	173	291	MonFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	297	662	WLYR2	Period4 - SEM 2 - MonWed - A  Chennells	\N	32	SEM	108	42	YR2	\N	18	Y	Y	Y	N	\N	\N	\N	180	297	MonWed	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	390	739	KMDPTE	Period2 - SEM1 - TueThu - R  Ngaiza	\N	30	SEM	109	11	Seminar	\N	1	Y	Y	Y	N	\N	\N	\N	\N	390	TueThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	294	671	CHDPT	Period2 - SEM1 - MonThuFri - J  Zimbudzana	\N	30	SEM	109	70	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	189	294	MonThuFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	292	673	IOTDPT	Period3 - SEM 2 - TueWedThu - A  Mandeya	\N	31	SEM	108	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	191	292	TueWedThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	299	674	ITDPT	Period4 - SEM 2 - MonThuFri - J  Chitakure	\N	32	SEM	108	27	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	192	299	MonThuFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	300	669	HAPDPT	Period4 - SEM1 - TueWedThu - C  Matusse	\N	32	SEM	109	19	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	187	300	TueWedThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	303	666	HMPYR2	Period4 - SEM 2 - MonTueWed - R  Ngaiza	\N	32	SEM	108	11	YR2	\N	24	Y	Y	Y	N	\N	\N	\N	184	303	MonTueWed	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	304	681	PPMA	Period3 - SEM 2 - MonWedFri - Odomaro  Mubandizi	\N	31	SEM	108	49	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	200	304	MonWedFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	298	683	SPMA	Period2 - SEM 2 - TueWed -   Fekete	\N	30	SEM	108	72	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	202	298	TueWed	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	374	723	ASAPHE	Period2 - SEM1 - TueThu - Lawrence  Daka	\N	30	SEM	109	44	YR3	\N	4	Y	Y	Y	N	\N	\N	\N	\N	374	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	296	665	SSAYR2	Period4 - SEM 2 - MonTueThu - C  Brand	\N	32	SEM	108	69	YR2	\N	19	Y	Y	Y	N	\N	\N	\N	183	296	MonTueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	580	960	BLEL	Period5 - SEM 2 - MonWedFri - John  Stacer	\N	33	SEM	34	50	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	\N	580	MonWedFri	7	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	302	684	EMA	Period1 - SEM1 - MonFri - Lawrence  Daka	\N	29	SEM	109	44	Seminar	\N	2	Y	Y	Y	N	\N	\N	\N	203	302	MonFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	593	973	STEL	Period5 - SEM 2 - MonWedFri - Costa  Virgilio	\N	33	SEM	34	33	PUG	\N	0	Y	Y	Y	N	\N	\N	\N	\N	593	MonWedFri	7	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	352	701	PRAPHE	Period1 - SEM1 - TueThu - Kenneth  Makamure	\N	29	SEM	109	56	DIP YR1	\N	1	Y	Y	Y	N	\N	\N	\N	\N	352	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	383	732	PADPT	Period2 - SEM 2 - MonWedFri - C  Matusse	\N	30	SEM	108	19	DIP YR1	\N	5	Y	Y	Y	N	\N	\N	\N	\N	383	MonWedFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	309	667	CMDPT	Period3 - SEM1 - WedThuFri - A  Zvaiwa	\N	31	SEM	109	51	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	185	309	WedThuFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	307	672	CMDPT	Period3 - SEM 2 - MonWedThu - A  Zvaiwa	\N	31	SEM	108	51	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	190	307	MonWedThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	313	654	FLYR1	Period1 - SEM 2 - MonWedFri - Dominique  Karani	\N	29	SEM	108	54	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	160	313	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	317	650	OCYR1	Period3 - SEM 2 - MonFri - A  Zvaiwa	\N	31	SEM	108	51	YR1	\N	16	Y	Y	Y	N	\N	\N	\N	161	317	MonFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	311	643	HAYR1	Period1 - SEM1 - MonFri - P  Nyambara	\N	29	SEM	109	8	YR1	\N	16	Y	Y	Y	N	\N	\N	\N	164	311	MonFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	322	678	LAYR1	Period3 - SEM 2 - TueWed - A  Chennells	\N	31	SEM	108	42	YR1	\N	16	Y	Y	Y	N	\N	\N	\N	159	322	TueWed	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	308	654	FLYR1	Period1 - SEM 2 - MonWedFri - G  Ncube	\N	29	SEM	108	58	YR1	\N	10	Y	Y	Y	N	\N	\N	\N	171	308	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	329	661	ALFYR2	Period2 - SEM 2 - MonThu - G  Ncube	\N	30	SEM	108	58	YR2	\N	14	Y	Y	Y	N	\N	\N	\N	179	329	MonThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	323	648	APYR1	Period4 - SEM 2 - TueThu - K  Addy	\N	32	SEM	108	71	YR1	\N	24	Y	Y	Y	N	\N	\N	\N	157	323	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	375	724	GMAPHE	Period2 - SEM1 - TueThu - John  Stacer	\N	30	SEM	109	50	YR3	\N	7	Y	Y	Y	N	\N	\N	\N	\N	375	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	324	653	FLYR1	Period1 - SEM1 - MonWedFri - Dominique  Karani	\N	29	SEM	109	54	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	169	324	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	328	677	LAYR1	Period3 - SEM1 - WedFri - A  Chennells	\N	31	SEM	109	42	YR1	\N	16	Y	Y	Y	N	\N	\N	\N	165	328	WedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	326	645	MRSYR1	Period3 - SEM1 - TueThu - A  Perumalil	\N	31	SEM	109	9	YR1	\N	16	Y	Y	Y	N	\N	\N	\N	170	326	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	625	985	POE	Period3 - SEM1 - TueThu - A  Zvaiwa	\N	39	SEM	118	51	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	625	625	TueThu	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	315	687	PSMA	Period4 - SEM1 - MonWed - G  Zinyeka	\N	32	SEM	109	73	Seminar	\N	1	Y	Y	Y	N	\N	\N	\N	206	315	MonWed	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	327	647	RAYR1	Period2 - SEM 2 - TueWedFri - J  Chitakure	\N	30	SEM	108	27	YR1	\N	24	Y	Y	Y	N	\N	\N	\N	162	327	TueWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	337	644	SVCYR1	Period3 - SEM1 - MonFri - W  Cleary	\N	31	SEM	109	14	YR1	\N	16	Y	Y	Y	N	\N	\N	\N	167	337	MonFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	318	664	EYR2	Period2 - SEM 2 - MonTueWed - Lawrence  Daka	\N	30	SEM	108	44	YR2	\N	26	Y	Y	Y	N	\N	\N	\N	182	318	MonTueWed	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	321	658	HAPYR2	Period3 - SEM1 - TueThuFri - K  Addy	\N	31	SEM	109	71	YR2	\N	26	Y	Y	Y	N	\N	\N	\N	176	321	TueThuFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	325	646	IPYR1	Period3 - SEM1 - TueThu - T  Sherman	\N	31	SEM	109	21	YR1	\N	24	Y	Y	Y	N	\N	\N	\N	166	325	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	306	663	WHYR2	Period4 - SEM 2 - MonWedThu - P  Nyambara	\N	32	SEM	108	8	YR2	\N	19	Y	Y	Y	N	\N	\N	\N	181	306	MonWedThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	314	659	PAYR2	Period4 - SEM1 - MonTueFri - John  Stacer	\N	32	SEM	109	50	YR2	\N	26	Y	Y	Y	N	\N	\N	\N	177	314	MonTueFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	391	740	PRDPTE	Period2 - SEM1 - TueThu - Kenneth  Makamure	\N	30	SEM	109	56	DIP YR1	\N	6	Y	Y	Y	N	\N	\N	\N	\N	391	TueThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	359	708	TJRAPH	Period2 - SEM 2 - MonWedFri - R  Ngaiza	\N	30	SEM	108	11	YR3	\N	4	Y	Y	Y	N	\N	\N	\N	\N	359	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	367	716	IAPAPHE	Period2 - SEM 2 - MonWedFri - A  Chennells	\N	30	SEM	108	42	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	\N	367	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	338	653	FLYR1	Period1 - SEM1 - MonWedFri - G  Ncube	\N	29	SEM	109	58	YR2	\N	10	Y	Y	Y	N	\N	\N	\N	172	338	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2314	2432	IOTYR1	Period2 - SEM1 - Wed - Zvaiwa  Zvaiwa	\N	102	SEM	159	\N	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2314	2314	Wed	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	319	649	LYR1	Period3 - SEM 2 - MonWedFri - Simon  Makuru	\N	31	SEM	108	45	YR1	\N	24	Y	Y	Y	N	\N	\N	\N	163	319	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	331	652	EWYR1	Period1 - SEM 2 - TueThuFri - K  Esenther	\N	29	SEM	108	22	YR1	\N	16	Y	Y	Y	N	\N	\N	\N	158	331	TueThuFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	312	675	APYR2	Period4 - SEM 2 - MonFri - K  Addy	\N	32	SEM	108	71	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	197	312	MonFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	330	676	HCTDPT	Period2 - SEM 2 - MonTueThu - C  Nyandoro	\N	30	SEM	108	59	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	193	330	MonTueThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	310	670	HCTDPT	Period1 - SEM1 - TueWedFri - C  Nyandoro	\N	29	SEM	109	59	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	188	310	TueWedFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	451	802	WLYR2	Period4 - SEM1 - TueThu - A  Chennells	\N	40	SEM	118	42	YR2	\N	19	Y	Y	Y	N	\N	\N	\N	451	451	TueThu	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	333	686	APMA	Period4 - SEM1 - MonTueWed - David  Kaulemu	\N	32	SEM	109	55	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	205	333	MonTueWed	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	335	679	EMA	Period1 - SEM 2 - MonThuFri - Kizito  Kiyimba	\N	29	SEM	108	13	Seminar	\N	2	Y	Y	Y	N	\N	\N	\N	198	335	MonThuFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	332	685	IPMA	Period3 - SEM1 - MonWedFri - Dr  Seelan	\N	31	SEM	109	68	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	204	332	MonWedFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	334	688	PEMA	Period1 - SEM1 - MonThu - John  Stacer	\N	29	SEM	109	50	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	207	334	MonThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	336	682	PRMA	Period4 - SEM1 - WedFri - T  Sherman	\N	32	SEM	109	21	Seminar	\N	1	Y	Y	Y	N	\N	\N	\N	201	336	WedFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	320	651	EWYR1	Period2 - SEM1 - WedThu - C  Nyandoro	\N	30	SEM	109	59	YR1	\N	16	Y	Y	Y	N	\N	\N	\N	168	320	WedThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	45	442	APEL	Period1 - SEM1 - MonTueWedThuFri - Kenneth  Makamure	\N	5	SEM	33	32	YR3	\N	4	Y	Y	Y	N	\N	\N	\N	45	45	MonTueWedThuFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	24	386	HMYR3	Period4 - SEM1 - TueThu - Ujah  Ejembi	\N	8	SEM	33	26	YR3	\N	29	Y	Y	Y	N	\N	\N	\N	24	24	TueThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	22	388	PLYR3	Period2 - SEM1 - MonWedFri - Diddy  Brossala	\N	6	SEM	33	24	YR3	\N	25	Y	Y	Y	N	\N	\N	\N	22	22	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	47	439	APEL	Period1 - SEM1 - MonTueWedThuFri - Johnny  Stacer	\N	5	SEM	33	10	YR3	\N	13	Y	Y	Y	N	\N	\N	\N	47	47	MonTueWedThuFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	46	438	APEL	Period1 - SEM1 - MonTueWedThuFri - T  Sherman	\N	5	SEM	33	21	YR3	\N	19	Y	Y	Y	N	\N	\N	\N	46	46	MonTueWedThuFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	15	372	ITYR1	Period3 - SEM1 - Tue - A  Ggita	\N	7	SEM	33	31	YR1	\N	26	Y	Y	Y	N	\N	\N	\N	15	15	Tue	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	48	444	APEL	Period1 - SEM1 - MonTueWedThuFri - A  Manyere	\N	5	SEM	33	30	YR3	\N	31	Y	Y	Y	N	\N	\N	\N	48	48	MonTueWedThuFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	17	380	APYR2	Period1 - SEM1 - TueThu - C  Matusse	\N	5	SEM	33	19	YR2	\N	26	Y	Y	Y	N	\N	\N	\N	17	17	TueThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	21	376	WLYR2	Period4 - SEM1 - TueThu - A  Chennells	\N	8	SEM	33	15	YR2	\N	18	Y	Y	Y	N	\N	\N	\N	21	21	TueThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	27	397	NTYR4	Period3 - SEM1 - TueThu - I  Chidavaenzi	\N	7	SEM	33	18	YR4	\N	29	Y	Y	Y	N	\N	\N	\N	27	27	TueThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	41	374	ALFYR2	Period3 - SEM1 - TueThu - G  Ncube	\N	7	SEM	33	16	YR2	\N	15	Y	Y	Y	N	\N	\N	\N	41	41	TueThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	18	382	PHAYR2	Period2 - SEM1 - MonWedFri - Johnny  Stacer	\N	6	SEM	33	10	YR2	\N	26	Y	Y	Y	N	\N	\N	\N	18	18	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	44	440	APEL	Period1 - SEM1 - MonThu - A  Mandeya	\N	5	SEM	33	20	YR3	\N	11	Y	Y	Y	N	\N	\N	\N	44	44	MonThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	581	961	JHEL	Period7 - SEM 2 - TueThu - Olivier  Sempiga	\N	35	SEM	34	38	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	\N	581	TueThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	9	360	BAFL	Period1 - SEM1 - MonWedFri - A  Ggita	\N	5	SEM	33	31	YR1	\N	23	Y	Y	Y	N	\N	\N	\N	9	9	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	23	389	ESYR3	Period3 - SEM1 - MonThuFri - Lawrence  Daka	\N	7	SEM	33	17	YR3	\N	26	Y	Y	Y	N	\N	\N	\N	23	23	MonThuFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	39	416	NTYR2	Period1 - SEM1 - TueThu - A  Mandeya	\N	5	SEM	33	20	YR3	\N	18	Y	Y	Y	N	\N	\N	\N	39	39	TueThu	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	43	441	GAAPH	Period1 - SEM1 - MonTueWedThuFri - Ujah  Ejembi	\N	5	SEM	33	26	YR3	\N	9	Y	Y	Y	N	\N	\N	\N	43	43	MonTueWedThuFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	100	464	APDPT	Period2 - SEM 2 - TueThuFri - Diddy  Brossala	\N	6	SEM	34	24	YR2	\N	12	Y	Y	Y	N	\N	\N	\N	100	100	TueThuFri	16	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	103	467	IDDPT	Period4 - SEM 2 - TueThuFri - C  Nyandoro	\N	8	SEM	34	59	YR3	\N	18	Y	Y	Y	N	\N	\N	\N	103	103	TueThuFri	16	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	37	413	PRYR2	Period2 - SEM1 - MonFri - T  Sherman	\N	6	SEM	33	21	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	37	37	MonFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	30	404	IPYR1	Period1 - TueThu - A  Ggita	\N	5	FY	0	31	YR1	\N	6	Y	Y	Y	N	\N	\N	\N	30	30	TueThu	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	36	414	IOTYR1	Period2 - SEM1 - Wed - Zvaiwa  Zvaiwa	\N	6	SEM	33	7	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	36	36	Wed	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	34	437	ATYR2	Period1 - SEM1 - MonFri - J  Chitakure	\N	5	SEM	33	27	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	34	34	MonFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	42	387	PSYR3	Period4 - SEM1 - MonThu - A  Perumalil	\N	8	SEM	33	9	YR3	\N	26	Y	Y	Y	N	\N	\N	\N	42	42	MonThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	10	362	ENYR1	Period1 - SEM1 - TueThu - K  Esenther	\N	5	SEM	33	22	YR1	\N	19	Y	Y	Y	N	\N	\N	\N	10	10	TueThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	11	366	HAYR1	Period2 - SEM1 - MonWedFri - Nyambara  Nyambara	\N	6	SEM	33	8	YR1	\N	19	Y	Y	Y	N	\N	\N	\N	11	11	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	12	370	MRYR1	Period2 - SEM1 - TueThu - Nyandoro  Nyandoro	\N	6	SEM	33	6	YR1	\N	19	Y	Y	Y	N	\N	\N	\N	12	12	TueThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	16	368	VT2YR1	Period3 - SEM1 - Mon - W  Cleary	\N	7	SEM	33	14	YR1	\N	19	Y	Y	Y	N	\N	\N	\N	16	16	Mon	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	20	384	PTDYR2	Period4 - SEM1 - MonWedFri - A  Manyere	\N	8	SEM	33	30	YR2	\N	25	Y	Y	Y	N	\N	\N	\N	20	20	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	14	364	LAYR1	Period3 - SEM1 - Wed - A  Chennells	\N	7	SEM	33	15	YR1	\N	19	Y	Y	Y	N	\N	\N	\N	14	14	Wed	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	25	395	EHYR4	Period2 - SEM1 - MonWed - John  Stacer	\N	6	SEM	33	50	YR4	\N	30	Y	Y	Y	N	\N	\N	\N	25	25	MonWed	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	28	396	PGYR4	Period4 - SEM1 - MonWedFri - T  Sherman	\N	8	SEM	33	21	YR4	\N	30	Y	Y	Y	N	\N	\N	\N	28	28	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	29	402	CMYR1	Period1 - SEM1 - MonWedFri - K  Esenther	\N	5	SEM	33	22	YR1	\N	6	Y	Y	Y	N	\N	\N	\N	29	29	MonWedFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	31	414	IOTYR1	Period2 - SEM1 - WedFri - Zvaiwa  Zvaiwa	\N	6	SEM	33	7	\N	\N	6	Y	Y	Y	N	\N	\N	\N	31	31	WedFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	33	405	HAYR1	Period3 - SEM1 - TueFri - C  Matusse	\N	7	SEM	33	19	YR1	\N	6	Y	Y	Y	N	\N	\N	\N	33	33	TueFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	40	437	ATYR2	Period4 - SEM1 - Wed - J  Chitakure	\N	8	SEM	33	27	YR3	\N	13	Y	Y	Y	N	\N	\N	\N	40	40	Wed	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	35	413	PRYR2	Period2 - SEM1 - MonFri - T  Sherman	\N	6	SEM	33	21	YR2	\N	8	Y	Y	Y	N	\N	\N	\N	35	35	MonFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	19	378	RWYR2	Period3 - SEM1 - MonWedFri - A  Perumalil	\N	7	SEM	33	9	YR2	\N	25	Y	Y	Y	N	\N	\N	\N	19	19	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	61	416	NTYR3	Period2 - SEM1 - TueThu - A  Mandeya	\N	6	SEM	33	20	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	61	61	TueThu	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	62	450	HRs	Period1 - SEM1 - Mon - Costa  Virgilio	\N	5	SEM	33	33	Office	\N	1	Y	Y	Y	N	\N	\N	\N	62	62	Mon	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	77	390	CPYR3	Period2 - SEM 2 - MonWed - Diddy  Brossala	\N	6	SEM	34	24	YR3	\N	72	Y	Y	Y	N	\N	\N	\N	77	77	MonWed	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	101	465	IEDPT	Period1 - SEM 2 - WedThuFri - A  Ggita	\N	5	SEM	34	31	YR3	\N	18	Y	Y	Y	N	\N	\N	\N	101	101	WedThuFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	53	451	DPTEL	Period2 - SEM1 - TueThu - T  Sherman	\N	6	SEM	33	21	DP	\N	0	Y	Y	Y	N	\N	\N	\N	53	53	TueThu	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	56	448	DPTEL	Period2 - SEM1 - TueThu - A  Mandeya	\N	6	SEM	33	20	DP	\N	10	Y	Y	Y	N	\N	\N	\N	56	56	TueThu	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	55	447	DPTEL	Period2 - SEM1 - TueThu - Kenneth  Makamure	\N	6	SEM	33	32	DP	\N	1	Y	Y	Y	N	\N	\N	\N	55	55	TueThu	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	54	449	DPTEL	Period2 - SEM1 - TueThu - Johnny  Stacer	\N	6	SEM	33	10	DP	\N	1	Y	Y	Y	N	\N	\N	\N	54	54	TueThu	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	89	458	ICSPEL	Period1 - SEM 2 - MonWedFri - K  Esenther	\N	5	SEM	34	22	YR1	\N	6	Y	Y	Y	N	\N	\N	\N	89	89	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	67	361	FLYR1	Period1 - SEM 2 - MonWedFri - Dominique  Karani	\N	5	SEM	34	54	YR1	\N	14	Y	Y	Y	N	\N	\N	\N	67	67	MonWedFri	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	49	445	APEL	Period1 - SEM1 - MonTueWedThuFri - A  Chennells	\N	5	SEM	33	15	YR3	\N	11	Y	Y	Y	N	\N	\N	\N	49	49	MonTueWedThuFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	50	446	APEL	Period1 - SEM1 - MonTueWedThuFri - Lawrence  Daka	\N	5	SEM	33	17	YR3	\N	8	Y	Y	Y	N	\N	\N	\N	50	50	MonTueWedThuFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	87	456	GPEL	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	5	SEM	34	26	YR2	\N	2	Y	Y	Y	N	\N	\N	\N	87	87	TueThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	82	400	OCTYR4	Period2 - SEM 2 - MonWed - W  Cleary	\N	6	SEM	34	14	YR4	\N	82	Y	Y	Y	N	\N	\N	\N	82	82	MonWed	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	71	367	RAYR1	Period2 - SEM 2 - TueFri - J  Chitakure	\N	6	SEM	34	27	YR1	\N	65	Y	Y	Y	N	\N	\N	\N	71	71	TueFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	85	453	DHBAEL	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	5	SEM	34	26	YR3	\N	7	Y	Y	Y	N	\N	\N	\N	85	85	TueThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	70	373	OCYR1	Period4 - SEM 2 - MonThu - A  Zvaiwa	\N	8	SEM	34	51	YR1	\N	76	Y	Y	Y	N	\N	\N	\N	70	70	MonThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	59	421	CHYR2	Period1 - SEM1 - MonThu - G  Makwasha	\N	5	SEM	33	29	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	59	59	MonThu	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	88	457	PFEL	Period1 - SEM 2 - MonWedFri - Diddy  Brossala	\N	5	SEM	34	24	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	88	88	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	58	421	CHYR1	Period1 - SEM1 - MonThu - G  Makwasha	\N	5	SEM	33	29	YR1	\N	6	Y	Y	Y	N	\N	\N	\N	58	58	MonThu	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	91	460	PCMEL	Period1 - SEM 2 - MonWedFri - A  Mandeya	\N	5	SEM	34	20	YR3	\N	7	Y	Y	Y	N	\N	\N	\N	91	91	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	60	411	RPYR3	Period1 - SEM1 - MonTueWedThuFri - K  Esenther	\N	5	SEM	33	22	YR3	\N	8	Y	Y	Y	N	\N	\N	\N	60	60	MonTueWedThuFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	72	375	ALFYR2	Period3 - SEM 2 - MonFri - A  Ggita	\N	7	SEM	34	31	YR2	\N	28	Y	Y	Y	N	\N	\N	\N	72	72	MonFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	80	393	OTFYR3	Period3 - SEM 2 - TueThu - I  Chidavaenzi	\N	7	SEM	34	18	YR3	\N	70	Y	Y	Y	N	\N	\N	\N	80	80	TueThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	64	363	ENYR1	Period1 - SEM 2 - WedThuFri - K  Esenther	\N	5	SEM	34	22	YR1	\N	76	Y	Y	Y	N	\N	\N	\N	64	64	WedThuFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	66	361	FLYR1	Period1 - SEM 2 - MonWedFri - A  Ggita	\N	5	SEM	34	31	YR1	\N	13	Y	Y	Y	N	\N	\N	\N	66	66	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	79	392	MCPYR3	Period3 - SEM 2 - MonTue - T  Sherman	\N	7	SEM	34	21	YR3	\N	72	Y	Y	Y	N	\N	\N	\N	79	79	MonTue	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	78	391	PMEYR3	Period3 - SEM 2 - MonFri - A  Perumalil	\N	7	SEM	34	9	YR3	\N	70	Y	Y	Y	N	\N	\N	\N	78	78	MonFri	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	83	398	PPPYR4	Period1 - SEM 2 - MonTueWedThuFri - John  Stacer	\N	5	SEM	34	50	YR4	\N	83	Y	Y	Y	N	\N	\N	\N	83	83	MonTueWedThuFri	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	81	399	REYR4	Period4 - SEM 2 - TueThu - C  Nyandoro	\N	8	SEM	34	59	YR4	\N	82	Y	Y	Y	N	\N	\N	\N	81	81	TueThu	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	69	371	LYR1	Period2 - SEM 2 - MonWed - Simon  Makuru	\N	6	SEM	34	45	YR1	\N	83	Y	Y	Y	N	\N	\N	\N	69	69	MonWed	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	68	365	LAYR1	Period2 - SEM 2 - TueThu - A  Chennells	\N	6	SEM	34	42	YR1	\N	76	Y	Y	Y	N	\N	\N	\N	68	68	TueThu	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	86	454	PSDRGEL	Period4 - SEM 2 - MonTueWedThu - A  Manyere	\N	8	SEM	34	30	YR1	\N	49	Y	Y	Y	N	\N	\N	\N	86	86	MonTueWedThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	73	377	WLYR2	Period4 - SEM 2 - TueFri - A  Chennells	\N	8	SEM	34	42	YR2	\N	66	Y	Y	Y	N	\N	\N	\N	73	73	TueFri	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	74	379	WHYR2	Period3 - SEM 2 - TueThu - P  Nyambara	\N	7	SEM	34	8	YR2	\N	34	Y	Y	Y	N	\N	\N	\N	74	74	TueThu	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	65	369	APYR1	Period4 - SEM 2 - TueFri - Ujah Gabriel Ejembi	\N	8	SEM	34	26	YR1	\N	64	Y	Y	Y	N	\N	\N	\N	65	65	TueFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	99	415	INTDPT	Period3 - SEM 2 - MonThuFri - A  Mandeya	\N	7	SEM	34	20	YR2	\N	12	Y	Y	Y	N	\N	\N	\N	99	99	MonThuFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	98	418	HCTPDPT	Period2 - SEM 2 - TueThu - Costa  Virgilio	\N	6	SEM	34	33	YR2	\N	6	Y	Y	Y	N	\N	\N	\N	98	98	TueThu	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	104	417	ITDPT	Period1 - SEM 2 - MonWedFri - A  Zvaiwa	\N	5	SEM	34	51	YR1	\N	18	Y	Y	Y	N	\N	\N	\N	104	104	MonWedFri	16	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	110	461	BEL	Period1 - SEM 2 - MonWedFri - Costa  Virgilio	\N	5	SEM	34	33	YR2	\N	3	Y	Y	Y	N	\N	\N	\N	110	110	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	428	775	OCTPUG3	Period3 - SEM 2 - WedFri - W  Cleary	\N	7	SEM	34	14	YR4	\N	6	Y	Y	Y	N	\N	\N	\N	428	428	WedFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	105	409	EPDPT	Period3 - SEM 2 - MonWedFri - Olivier  Sempiga	\N	7	SEM	34	38	YR3	\N	18	Y	Y	Y	N	\N	\N	\N	105	105	MonWedFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	96	383	SSAYR2	Period2 - SEM 2 - MonWedFri - Ben  Sachikonye	\N	6	SEM	34	37	YR2	\N	32	Y	Y	Y	N	\N	\N	\N	96	96	MonWedFri	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	111	450	HRs	Period3 - SEM 2 - MonWedFri - Costa  Virgilio	\N	7	SEM	34	33	Aud Visual	\N	5	Y	Y	Y	N	\N	\N	\N	111	111	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	109	471	DHDPT	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	5	SEM	34	26	YR3	\N	5	Y	Y	Y	N	\N	\N	\N	109	109	TueThu	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	108	470	HRDPT	Period1 - SEM 2 - TueThuFri - Costa  Virgilio	\N	5	SEM	34	33	YR3	\N	1	Y	Y	Y	N	\N	\N	\N	108	108	TueThuFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	92	462	APEL	Period1 - SEM 2 - Wed - A  Perumalil	\N	5	SEM	34	9	YR4	\N	11	Y	Y	Y	N	\N	\N	\N	92	92	Wed	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	97	403	CMYR1	Period3 - SEM 2 - MonWedFri - K  Esenther	\N	7	SEM	34	22	YR2	\N	12	Y	Y	Y	N	\N	\N	\N	97	97	MonWedFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	94	463	FAEL	Period1 - SEM 2 - Wed - T  Sherman	\N	5	SEM	34	21	Y4	\N	1	Y	Y	Y	N	\N	\N	\N	94	94	Wed	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	107	469	ICSDPT	Period2 - SEM 2 - TueThu - K  Esenther	\N	6	SEM	34	22	YR1	\N	3	Y	Y	Y	N	\N	\N	\N	107	107	TueThu	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	93	455	PLEL	Period1 - SEM 2 - MonWedFri - T  Sherman	\N	5	SEM	34	21	YR3	\N	14	Y	Y	Y	N	\N	\N	\N	93	93	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	90	459	RSFANEL	Period1 - SEM 2 - MonWedFri - A  Chennells	\N	5	SEM	34	42	YR2	\N	10	Y	Y	Y	N	\N	\N	\N	90	90	MonWedFri	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	75	385	EYR2	Period1 - SEM 2 - MonWed - Lawrence  Daka	\N	5	SEM	34	44	YR2	\N	67	Y	Y	Y	N	\N	\N	\N	75	75	MonWed	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	102	466	CTIDPT	Period3 - SEM 2 - MonWedFri - A  Perumalil	\N	7	SEM	34	9	YR3	\N	18	Y	Y	Y	N	\N	\N	\N	102	102	MonWedFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	412	759	PTDPUG1	Period3 - SEM1 - MonWedFri - A  Manyere	\N	7	SEM	33	30	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	412	412	MonWedFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	406	753	EPUG1	Period1 - SEM 2 - MonWed - Lawrence  Daka	\N	5	SEM	34	44	YR2	\N	13	Y	Y	Y	N	\N	\N	\N	406	406	MonWed	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	413	760	SSAPUG1	Period1 - SEM 2 - MonWedThu - Ben  Sachikonye	\N	5	SEM	34	37	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	413	413	MonWedThu	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	425	772	NTFPUG3	Period3 - SEM1 - MonTueFri - I  Chidavaenzi	\N	7	SEM	33	18	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	425	425	MonTueFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	403	750	APPUG1	Period2 - SEM 2 - MonThu - Ujah Gabriel Ejembi	\N	6	SEM	34	26	YR1	\N	12	Y	Y	Y	N	\N	\N	\N	403	403	MonThu	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	404	751	LPUG1	Period1 - SEM 2 - MonThu - Simon  Makuru	\N	5	SEM	34	45	YR1	\N	12	Y	Y	Y	N	\N	\N	\N	404	404	MonThu	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	419	766	PMEPUG2	Period3 - SEM 2 - TueWedThu - A  Perumalil	\N	7	SEM	34	9	YR3	\N	10	Y	Y	Y	N	\N	\N	\N	419	419	TueWedThu	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	437	784	PCMPUGE	Period1 - SEM 2 - TueThu - A  Mandeya	\N	5	SEM	34	20	DIP YR1	\N	4	Y	Y	Y	N	\N	\N	\N	437	437	TueThu	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	402	749	RAPUG1	Period1 - SEM 2 - MonThuFri - J  Chitakure	\N	5	SEM	34	27	YR1	\N	12	Y	Y	Y	N	\N	\N	\N	402	402	MonThuFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	405	752	HMPPUG1	Period2 - SEM 2 - TueThu - A  Ggita	\N	6	SEM	34	31	YR2	\N	13	Y	Y	Y	N	\N	\N	\N	405	405	TueThu	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	431	778	ICSPUGE	Period1 - SEM 2 - MonWedFri - K  Esenther	\N	5	SEM	34	22	Computer	\N	2	Y	Y	Y	N	\N	\N	\N	431	431	MonWedFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	426	773	PPPPUG3	Period2 - SEM 2 - MonTueWedThuFri - John  Stacer	\N	6	SEM	34	50	Offices	\N	10	Y	Y	Y	N	\N	\N	\N	426	426	MonTueWedThuFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	407	754	FLPUG1	Period1 - SEM 2 - MonWedFri - A  Ggita	\N	5	SEM	34	31	DIP YR1	\N	2	Y	Y	Y	N	\N	\N	\N	407	407	MonWedFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	420	767	MCPPUG2	Period4 - SEM 2 - MonWed - T  Sherman	\N	8	SEM	34	21	YR3	\N	12	Y	Y	Y	N	\N	\N	\N	420	420	MonWed	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	438	785	FAEPUGE	Period1 - SEM 2 - Mon - T  Sherman	\N	5	SEM	34	21	Offices	\N	2	Y	Y	Y	N	\N	\N	\N	438	438	Mon	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	432	779	PSDPUGE	Period4 - SEM 2 - MonTueWedThu - A  Manyere	\N	8	SEM	34	30	Aud Visual	\N	4	Y	Y	Y	N	\N	\N	\N	432	432	MonTueWedThu	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	415	762	PSPUG2	Period4 - SEM1 - MonFri - A  Perumalil	\N	8	SEM	33	9	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	415	415	MonFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	421	768	OFPUG2	Period3 - SEM 2 - WedFri - I  Chidavaenzi	\N	7	SEM	34	18	YR3	\N	1	Y	Y	Y	N	\N	\N	\N	421	421	WedFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	439	786	APPUGE	Period1 - SEM 2 - Mon - A  Perumalil	\N	5	SEM	34	9	Offices	\N	1	Y	Y	Y	N	\N	\N	\N	439	439	Mon	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	433	780	IPLPUGE	Period1 - SEM 2 - MonWedFri - T  Sherman	\N	5	SEM	34	21	Seminar	\N	2	Y	Y	Y	N	\N	\N	\N	433	433	MonWedFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	95	381	HMPYR2	Period2 - SEM 2 - TueWedFri - A  Ggita	\N	6	SEM	34	31	YR2	\N	79	Y	Y	Y	N	\N	\N	\N	95	95	TueWedFri	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	427	774	REPUG3	Period3 - SEM 2 - MonWedFri - C  Nyandoro	\N	7	SEM	34	59	YR4	\N	4	Y	Y	Y	N	\N	\N	\N	427	427	MonWedFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	409	756	IPPUG1	Period3 - SEM1 - TueThu - A  Ggita	\N	7	SEM	33	31	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	409	409	TueThu	7	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	416	763	PLPPUG2	Period4 - SEM1 - TueThuFri - Diddy  Brossala	\N	8	SEM	33	24	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	416	416	TueThuFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	422	769	SAPPUG3	Period2 - SEM1 - MonWedThu - Diddy  Brossala	\N	6	SEM	33	24	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	422	422	MonWedThu	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	434	781	BPUGE	Period1 - SEM 2 - TueThu - Costa  Virgilio	\N	5	SEM	34	33	Seminar	\N	5	Y	Y	Y	N	\N	\N	\N	434	434	TueThu	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	423	770	EHPUG3	Period3 - SEM1 - TueThu - Simon  Makuru	\N	7	SEM	33	45	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	423	423	TueThu	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	410	757	RWPUG1	Period4 - SEM1 - TueThuFri - A  Perumalil	\N	8	SEM	33	9	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	410	410	TueThuFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	417	764	ESPPUG2	Period4 - SEM1 - TueThu - Lawrence  Daka	\N	8	SEM	33	44	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	417	417	TueThu	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2313	2422	IPYR1	Period1 - SEM1 - TueThu - A  Ggita	\N	101	SEM	159	31	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2313	2313	TueThu	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	435	782	PFPUGE	Period1 - SEM 2 - MonWedFri - Diddy  Brossala	\N	5	SEM	34	24	Aud Visual	\N	4	Y	Y	Y	N	\N	\N	\N	435	435	MonWedFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	429	776	OCEPUG3	Period3 - SEM 2 - MonTueWedThuFri - John  Stacer	\N	7	SEM	34	50	Seminar	\N	10	Y	Y	Y	N	\N	\N	\N	429	429	MonTueWedThuFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	411	758	PAPUG1	Period2 - SEM1 - TueThu - John  Stacer	\N	6	SEM	33	50	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	411	411	TueThu	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	418	765	CPPUG2	Period2 - SEM 2 - MonWedFri - Diddy  Brossala	\N	6	SEM	34	24	YR3	\N	18	Y	Y	Y	N	\N	\N	\N	418	418	MonWedFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	436	783	HRPUGE	Period1 - SEM 2 - MonWedFri - Costa  Virgilio	\N	5	SEM	34	33	Seminar	\N	6	Y	Y	Y	N	\N	\N	\N	436	436	MonWedFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	424	771	PGPUG3	Period4 - SEM1 - MonWed - T  Sherman	\N	8	SEM	33	21	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	424	424	MonWed	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	430	777	DHPUGE	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	5	SEM	34	26	YR3	\N	12	Y	Y	Y	N	\N	\N	\N	430	430	TueThu	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	582	962	FFEL	Period1 - SEM 2 - MonTueWedThuFri - Diddy  Brossala	\N	5	SEM	34	24	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	\N	582	MonTueWedThuFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	594	974	SKEL	Period7 - SEM 2 - TueThu - Diddy  Brossala	\N	35	SEM	34	24	PUG	\N	0	Y	Y	Y	N	\N	\N	\N	\N	594	TueThu	7	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	490	882	ICSPEL	Period1 - SEM 2 - MonWedFri - K  Esenther	\N	37	SEM	119	22	YR1	\N	3	Y	Y	Y	N	\N	\N	\N	490	490	MonWedFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	485	889	IEDPT	Period1 - SEM 2 - WedThuFri - A  Ggita	\N	37	SEM	119	31	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	485	485	WedThuFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	486	876	DPTEL	Period2 - SEM1 - TueThu - T  Sherman	\N	38	SEM	118	21	DP	\N	0	Y	Y	Y	N	\N	\N	\N	486	486	TueThu	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	488	872	DPTEL	Period2 - SEM1 - TueThu - Kenneth  Makamure	\N	38	SEM	118	\N	DP	\N	0	Y	Y	Y	N	\N	\N	\N	488	488	TueThu	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	624	984	SPP	Period3 - SEM1 - TueFri - Diddy  Brossala	\N	39	SEM	118	24	YR2	\N	4	Y	Y	Y	N	\N	\N	\N	624	624	TueFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	644	1002	LOG	Period3 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	39	SEM	119	13	YR1	\N	2	Y	Y	Y	N	\N	\N	\N	644	644	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	535	920	PTDPUG1	Period3 - SEM1 - MonWedFri - A  Manyere	\N	39	SEM	118	30	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	535	535	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	604	944	FFEL	Period5 - SEM1 - MonWed - Diddy  Brossala	\N	41	SEM	118	24	\N	\N	2	Y	Y	Y	N	\N	\N	\N	604	604	MonWed	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	571	912	HRPUGE	Period1 - SEM 2 - MonWedFri - Costa  Virgilio	\N	37	SEM	119	33	Seminar	\N	2	Y	Y	Y	N	\N	\N	\N	571	571	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	489	874	DPTEL	Period2 - SEM1 - TueThu - Johnny  Stacer	\N	38	SEM	118	\N	DP	\N	0	Y	Y	Y	N	\N	\N	\N	489	489	TueThu	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	491	788	FLYR1	Period1 - SEM 2 - MonWedFri - Dominique  Karani	\N	37	SEM	119	54	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	491	491	MonWedFri	24	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	541	904	PMEPUG2	Period3 - SEM 2 - TueWedThu - A  Ggita	\N	39	SEM	119	31	YR3	\N	3	Y	Y	Y	N	\N	\N	\N	541	541	TueWedThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	558	908	REPUG3	Period3 - SEM 2 - MonWedFri - C  Nyandoro	\N	39	SEM	119	59	YR4	\N	6	Y	Y	Y	N	\N	\N	\N	558	558	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	542	933	PCMPUGE	Period1 - SEM 2 - TueThu - A  Mandeya	\N	37	SEM	119	20	DIP YR1	\N	3	Y	Y	Y	N	\N	\N	\N	542	542	TueThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	548	898	FLPUG1	Period1 - SEM 2 - MonWedFri - A  Ggita	\N	37	SEM	119	31	DIP YR1	\N	2	Y	Y	Y	N	\N	\N	\N	548	548	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1676	1973	APMA	Period4 - SEM1 - MonThu - A  Chennells	\N	80	SEM	143	42	YR3	\N	1	Y	Y	Y	N	\N	\N	\N	1676	1676	MonThu	47	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1994	2246	LOGIC	Period8 - SEM 2 - MonWedThu - Kizito  Kiyimba	\N	92	SEM	149	13	\N	\N	6	Y	Y	Y	N	\N	\N	\N	1994	1994	MonWedThu	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	549	924	MCPPUG2	Period4 - SEM 2 - MonWed - T  Sherman	\N	40	SEM	119	21	YR3	\N	3	Y	Y	Y	N	\N	\N	\N	549	549	MonWed	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	492	870	APEL	Period1 - SEM1 - MonTueWedThuFri - A  Chennells	\N	37	SEM	118	\N	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	492	492	MonTueWedThuFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	493	871	APEL	Period1 - SEM1 - MonTueWedThuFri - Lawrence  Daka	\N	37	SEM	118	\N	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	493	493	MonTueWedThuFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	500	881	PFEL	Period1 - SEM 2 - MonWedFri - Diddy  Brossala	\N	37	SEM	119	24	YR2	\N	4	Y	Y	Y	N	\N	\N	\N	500	500	MonWedFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	637	995	PCC	Period6 - SEM 2 - TueWedFri - A  Mandeya	\N	42	SEM	119	20	YR2	\N	3	Y	Y	Y	N	\N	\N	\N	637	637	TueWedFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	568	909	OCEPUG3	Period3 - SEM 2 - MonTueWedThuFri - John  Stacer	\N	39	SEM	119	50	Seminar	\N	5	Y	Y	Y	N	\N	\N	\N	568	568	MonTueWedThuFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	563	928	OCTPUG3	Period3 - SEM 2 - WedFri - Joseph  Mahlahla	\N	39	SEM	119	79	YR4	\N	5	Y	Y	Y	N	\N	\N	\N	563	563	WedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	519	842	HCTPDPT	Period2 - SEM 2 - TueThu - C  Nyandoro	\N	38	SEM	119	59	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	519	519	TueThu	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	530	896	ICSDPT	Period2 - SEM 2 - TueThu - K  Esenther	\N	38	SEM	119	22	YR1	\N	1	Y	Y	Y	N	\N	\N	\N	530	530	TueThu	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	520	841	ITDPT	Period1 - SEM1 - MonWedFri - K  Esenther	\N	37	SEM	118	22	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	520	520	MonWedFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	518	839	INTDPT	Period3 - SEM 2 - MonThuFri - A  Mandeya	\N	39	SEM	119	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	518	518	MonThuFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	522	833	EPDPT	Period3 - SEM 2 - MonWedFri - Olivier  Sempiga	\N	39	SEM	119	38	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	522	522	MonWedFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	570	923	CPPUG2	Period2 - SEM 2 - MonWedFri - Diddy  Brossala	\N	38	SEM	119	24	YR3	\N	3	Y	Y	Y	N	\N	\N	\N	570	570	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	583	963	LLEL	Period5 - SEM 2 - MonWedFri - K  Esenther	\N	33	SEM	34	22	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	\N	583	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	595	976	PEDYR1	Period8 - SEM1 - MonTueWedThuFri - C  Nyandoro	\N	36	SEM	33	59	\N	\N	0	Y	Y	Y	N	\N	\N	\N	\N	595	MonTueWedThuFri	18	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	567	932	PFPUGE	Period1 - SEM 2 - MonWedFri - Diddy  Brossala	\N	37	SEM	119	24	Aud Visual	\N	3	Y	Y	Y	N	\N	\N	\N	567	567	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	553	902	PSPUG2	Period4 - SEM1 - MonFri - Kizito  Kiyimba	\N	40	SEM	118	13	YR3	\N	4	Y	Y	Y	N	\N	\N	\N	553	553	MonFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	503	835	RPYR3	Period1 - SEM1 - MonWedFri - Diddy  Brossala	\N	37	SEM	118	24	YR3	\N	5	Y	Y	Y	N	\N	\N	\N	503	503	MonWedFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	524	895	HRs	Period3 - SEM 2 - MonWedFri - Costa  Virgilio	\N	39	SEM	119	33	Aud Visual	\N	0	Y	Y	Y	N	\N	\N	\N	524	524	MonWedFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	525	894	DHDPT	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	37	SEM	119	26	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	525	525	TueThu	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	526	893	HRDPT	Period1 - SEM 2 - TueThuFri - Costa  Virgilio	\N	37	SEM	119	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	526	526	TueThuFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	529	887	FAEL	Period1 - SEM 2 - Wed - T  Sherman	\N	37	SEM	119	21	Y4	\N	0	Y	Y	Y	N	\N	\N	\N	529	529	Wed	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	531	879	PLEL	Period1 - SEM 2 - MonWedFri - T  Sherman	\N	37	SEM	119	21	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	531	531	MonWedFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	532	883	RSFANEL	Period1 - SEM 2 - MonWedFri - A  Chennells	\N	37	SEM	119	42	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	532	532	MonWedFri	24	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	559	899	IPPUG1	Period3 - SEM1 - TueThu - A  Ggita	\N	39	SEM	118	31	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	559	559	TueThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	569	900	PAPUG1	Period2 - SEM1 - TueThu - John  Stacer	\N	38	SEM	118	50	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	569	569	TueThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	565	919	RWPUG1	Period4 - SEM1 - TueThuFri - Francis  Zangairai	\N	40	SEM	118	78	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	565	565	TueThuFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	551	930	PSDPUGE	Period4 - SEM 2 - MonTueWedThu - A  Manyere	\N	40	SEM	119	30	Aud Visual	\N	4	Y	Y	Y	N	\N	\N	\N	551	551	MonTueWedThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	630	988	POSMA	Period4 - SEM 2 - WedFri - Kizito  Kiyimba	\N	40	SEM	119	13	YR4	\N	4	Y	Y	Y	N	\N	\N	\N	630	630	WedFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	653	1011	POLA	Period4 - SEM 2 - TueFri - Kizito  Kiyimba	\N	40	SEM	119	13	YR2	\N	7	Y	Y	Y	N	\N	\N	\N	653	653	TueFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	655	1013	APHIL	Period4 - SEM 2 - TueWedFri - Diddy  Brossala	\N	40	SEM	119	24	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	655	655	TueWedFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	544	916	HMPPUG1	Period2 - SEM 2 - TueThu - T  Sherman	\N	38	SEM	119	21	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	544	544	TueThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	561	925	SAPPUG3	Period2 - SEM1 - MonWedThu - Bienvenu  Mayemba	\N	38	SEM	118	80	YR4	\N	5	Y	Y	Y	N	\N	\N	\N	561	561	MonWedThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	564	906	EHPUG3	Period3 - SEM1 - TueThu - Simon  Makuru	\N	39	SEM	118	45	YR4	\N	5	Y	Y	Y	N	\N	\N	\N	564	564	TueThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	572	926	PGPUG3	Period4 - SEM1 - MonWed - T  Sherman	\N	40	SEM	118	21	YR4	\N	5	Y	Y	Y	N	\N	\N	\N	572	572	MonWed	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	540	897	LPUG1	Period1 - SEM 2 - MonThu - Kizito  Kiyimba	\N	37	SEM	119	13	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	540	540	MonThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	552	918	FLPUG1	Period1 - SEM1 - TueThu - A  Ggita	\N	37	SEM	118	31	YR1	\N	10	Y	Y	Y	N	\N	\N	\N	552	552	TueThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1674	2065	SLS	Period6 - SEM1 - TueFri - Costa  Virgilio	\N	82	SEM	143	33	YR 3	\N	0	Y	Y	Y	N	\N	\N	\N	1674	1674	TueFri	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1964	2183	MRYR1	Period6 - SEM1 - TueWed - C  Nyandoro	\N	90	SEM	148	59	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	1964	1964	TueWed	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	566	903	ESPPUG2	Period4 - SEM1 - TueThu - Lawrence  Daka	\N	40	SEM	118	44	YR3	\N	4	Y	Y	Y	N	\N	\N	\N	566	566	TueThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	609	978	PEDMA	Period3 - SEM1 - WedFri - C  Nyandoro	\N	39	SEM	118	59	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	609	609	WedFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	599	938	KEL	Period5 - SEM1 - TueThu - Diddy  Brossala	\N	41	SEM	118	24	\N	\N	3	Y	Y	Y	N	\N	\N	\N	599	599	TueThu	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	584	964	LLEL	Period5 - SEM 2 - MonWedFri - K  Esenther	\N	33	SEM	34	22	PUG	\N	0	Y	Y	Y	N	\N	\N	\N	\N	584	MonWedFri	7	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	596	977	BLYR1	Period6 - SEM1 - MonTueWedThuFri - John  Stacer	\N	34	SEM	33	50	\N	\N	0	Y	Y	Y	N	\N	\N	\N	\N	596	MonTueWedThuFri	18	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	539	915	APPUG1	Period2 - SEM 2 - MonThu - Diddy  Brossala	\N	38	SEM	119	24	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	539	539	MonThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	546	921	HMPPUG2	Period3 - SEM1 - MonWedFri - T  Sherman	\N	39	SEM	118	21	YR3	\N	4	Y	Y	Y	N	\N	\N	\N	546	546	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	538	907	NTFPUG3	Period3 - SEM1 - MonTueFri - I  Chidavaenzi	\N	39	SEM	118	18	YR4	\N	1	Y	Y	Y	N	\N	\N	\N	538	538	MonTueFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	509	816	PMEYR3	Period3 - SEM 2 - MonFri - A  Ggita	\N	39	SEM	119	31	YR3	\N	19	Y	Y	Y	N	\N	\N	\N	509	509	MonFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	523	808	SSAYR2	Period2 - SEM 2 - MonWedFri - T  Chimbidzikai	\N	38	SEM	119	81	YR2	\N	19	Y	Y	Y	N	\N	\N	\N	523	523	MonWedFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	516	804	WHYR2	Period3 - SEM 2 - TueThu - P  Nyambara	\N	39	SEM	119	8	YR2	\N	19	Y	Y	Y	N	\N	\N	\N	516	516	TueThu	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	512	798	LYR1	Period2 - SEM 2 - MonWed - Kizito  Kiyimba	\N	38	SEM	119	13	YR1	\N	11	Y	Y	Y	N	\N	\N	\N	512	512	MonWed	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	506	790	ENYR1	Period1 - SEM 2 - WedThuFri - K  Esenther	\N	37	SEM	119	22	YR1	\N	11	Y	Y	Y	N	\N	\N	\N	506	506	WedThuFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	496	794	RAYR1	Period2 - SEM 2 - TueFri - Francis  Zangairai	\N	38	SEM	119	78	YR1	\N	11	Y	Y	Y	N	\N	\N	\N	496	496	TueFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	513	791	LAYR1	Period2 - SEM 2 - TueThu - A  Chennells	\N	38	SEM	119	42	YR1	\N	11	Y	Y	Y	N	\N	\N	\N	513	513	TueThu	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	497	877	DHBAEL	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	37	SEM	119	26	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	497	497	TueThu	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	499	845	CHYR2	Period1 - SEM1 - MonThu - G  Makwasha	\N	37	SEM	118	\N	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	499	499	MonThu	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	501	845	CHYR1	Period1 - SEM1 - MonThu - G  Makwasha	\N	37	SEM	118	\N	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	501	501	MonThu	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	619	952	STEL	Period7 - SEM1 - TueThu - Costa  Virgilio	\N	43	SEM	118	33	YR3	\N	2	Y	Y	Y	N	\N	\N	\N	619	619	TueThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	603	946	ELEL	Period5 - SEM1 - MonWedFri - Costa  Virgilio	\N	41	SEM	118	33	\N	\N	1	Y	Y	Y	N	\N	\N	\N	603	603	MonWedFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	628	847	ETMA	Period2 - SEM 2 - MonWed - Costa  Virgilio	\N	38	SEM	119	33	YR4	\N	8	Y	Y	Y	N	\N	\N	\N	628	628	MonWed	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	659	834	MTP	Period1 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	37	SEM	119	13	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	659	659	MonWedFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	652	1010	LAWA	Period2 - SEM 2 - MonThu - T  Sherman	\N	38	SEM	119	21	YR3	\N	5	Y	Y	Y	N	\N	\N	\N	652	652	MonThu	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	654	1012	ROA	Period1 - SEM 2 - MonThuFri - Francis  Zangairai	\N	37	SEM	119	78	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	654	654	MonThuFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	662	1018	FRLS	Period2 - SEM 2 - MonWed - A  Ggita	\N	38	SEM	119	31	YR2	\N	4	Y	Y	Y	N	\N	\N	\N	662	662	MonWed	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1581	1988	APEL	Period1 - SEM 2 - Wed - A  Perumalil	\N	77	SEM	144	9	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	1581	1581	Wed	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	646	1004	PMOE	Period2 - SEM 2 - MonFri - A  Ggita	\N	38	SEM	119	31	YR3	\N	1	Y	Y	Y	N	\N	\N	\N	646	646	MonFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	661	1017	POSPUG	Period3 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	39	SEM	119	13	YR3	\N	1	Y	Y	Y	N	\N	\N	\N	661	661	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	660	1016	HRPUG	Period3 - SEM 2 - TueThu - Costa  Virgilio	\N	39	SEM	119	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	660	660	TueThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	658	832	CONTP	Period2 - SEM 2 - MonWedFri - John  Sanni	\N	38	SEM	119	82	YR1	\N	10	Y	Y	Y	N	\N	\N	\N	658	658	MonWedFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	656	1014	LOGIC	Period1 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	37	SEM	119	13	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	656	656	MonWedFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	643	1001	ETH	Period2 - SEM 2 - MonWedFri - Olivier  Sempiga	\N	38	SEM	119	38	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	643	643	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	585	965	CTEL	Period1 - SEM 2 - MonTueWedThuFri - Diddy  Brossala	\N	5	SEM	34	24	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	\N	585	MonTueWedThuFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	527	886	APEL	Period1 - SEM 2 - Wed - A  Perumalil	\N	37	SEM	119	9	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	527	527	Wed	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	616	953	SKEL	Period6 - SEM1 - MonWedFri - Diddy  Brossala	\N	42	SEM	118	24	YR3	\N	2	Y	Y	Y	N	\N	\N	\N	616	616	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	614	982	PAPUGYR2	Period2 - SEM1 - TueThu - John  Stacer	\N	38	SEM	118	50	YR@	\N	1	Y	Y	Y	N	\N	\N	\N	614	614	TueThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	613	981	HAPPUGYR2	Period5 - SEM1 - MonWedFri - Costa  Virgilio	\N	41	SEM	118	33	YR2	\N	1	Y	Y	Y	N	\N	\N	\N	613	613	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	612	980	HAPPUG1	Period3 - SEM1 - MonWedFri - Costa  Virgilio	\N	39	SEM	118	33	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	612	612	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	560	922	PLPPUG2	Period4 - SEM1 - TueThuFri - Diddy  Brossala	\N	40	SEM	118	24	YR3	\N	3	Y	Y	Y	N	\N	\N	\N	560	560	TueThuFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	611	948	GAEL	Period5 - SEM1 - TueThu - A  Mandeya	\N	41	SEM	118	20	YR3	\N	4	Y	Y	Y	N	\N	\N	\N	611	611	TueThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	608	846	EPMA	Period2 - SEM1 - TueThu - Kizito  Kiyimba	\N	38	SEM	118	13	YR1	\N	7	Y	Y	Y	N	\N	\N	\N	608	608	TueThu	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	607	853	SPMA	Period1 - SEM1 - MonWed - Costa  Virgilio	\N	37	SEM	118	33	YR1	\N	4	Y	Y	Y	N	\N	\N	\N	607	607	MonWed	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	597	940	BLEL	Period6 - SEM1 - MonThu - John  Stacer	\N	42	SEM	118	50	\N	\N	11	Y	Y	Y	N	\N	\N	\N	597	597	MonThu	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	600	937	AIEL	Period1 - SEM1 - WedFri - A  Chennells	\N	37	SEM	118	42	\N	\N	7	Y	Y	Y	N	\N	\N	\N	600	600	WedFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	602	945	CTEL	Period5 - SEM1 - TueFri - Diddy  Brossala	\N	41	SEM	118	24	\N	\N	1	Y	Y	Y	N	\N	\N	\N	602	602	TueFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	598	941	JHEL	Period4 - SEM1 - TueFri - Olivier  Sempiga	\N	40	SEM	118	38	\N	\N	10	Y	Y	Y	N	\N	\N	\N	598	598	TueFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	601	939	PAEEL	Period5 - SEM1 - MonFri - A  Ggita	\N	41	SEM	118	31	\N	\N	7	Y	Y	Y	N	\N	\N	\N	601	601	MonFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	466	789	ENYR1	Period1 - SEM1 - TueThu - K  Esenther	\N	37	SEM	118	22	YR1	\N	11	Y	Y	Y	N	\N	\N	\N	466	466	TueThu	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	517	796	APYR1	Period4 - SEM 2 - TueFri - Diddy  Brossala	\N	40	SEM	119	24	YR1	\N	11	Y	Y	Y	N	\N	\N	\N	517	517	TueFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	440	892	PCMDPT	Period1 - SEM 2 - MonWedFri - A  Mandeya	\N	37	SEM	119	20	YR3	\N	2	Y	Y	Y	N	\N	\N	\N	440	440	MonWedFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	441	867	APEL	Period1 - SEM1 - MonTueWedThuFri - Kenneth  Makamure	\N	37	SEM	118	\N	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	441	441	MonTueWedThuFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	547	927	PPPPUG3	Period2 - SEM 2 - MonTueWedThuFri - John  Stacer	\N	38	SEM	119	50	Offices	\N	5	Y	Y	Y	N	\N	\N	\N	547	547	MonTueWedThuFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	633	991	DEL	Period7 - SEM 2 - WedFri - Olivier  Sempiga	\N	43	SEM	119	38	YR3	\N	2	Y	Y	Y	N	\N	\N	\N	633	633	WedFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	632	990	ASCAEL	Period6 - SEM 2 - MonWed - Lawrence  Daka	\N	42	SEM	119	44	YR3	\N	11	Y	Y	Y	N	\N	\N	\N	632	632	MonWed	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	507	788	FLYR1	Period1 - SEM 2 - MonWedFri - A  Ggita	\N	37	SEM	119	31	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	507	507	MonWedFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	651	1009	PFR	Period5 - SEM 2 - MonWed - Diddy  Brossala	\N	41	SEM	119	24	YR3	\N	5	Y	Y	Y	N	\N	\N	\N	651	651	MonWed	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	445	864	APEL	Period1 - SEM1 - MonTueWedThuFri - Johnny  Stacer	\N	37	SEM	118	\N	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	445	445	MonTueWedThuFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	446	866	APEL	Period1 - SEM1 - MonTueWedThuFri - T  Sherman	\N	37	SEM	118	21	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	446	446	MonTueWedThuFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	534	890	CTIDPT	Period3 - SEM 2 - MonWedFri - A  Perumalil	\N	39	SEM	119	9	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	534	534	MonWedFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	573	929	DHPUGE	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	37	SEM	119	26	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	573	573	TueThu	24	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	494	880	GPEL	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	37	SEM	119	26	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	494	494	TueThu	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	610	979	BLMA	Period4 - SEM1 - TueFri - John  Stacer	\N	40	SEM	118	50	YR1	\N	6	Y	Y	Y	N	\N	\N	\N	610	610	TueFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	650	1008	BIOE	Period5 - SEM 2 - MonWed - Costa  Virgilio	\N	41	SEM	119	33	YR1	\N	-1	Y	Y	Y	N	\N	\N	\N	650	650	MonWed	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	648	1006	PCC	Period5 - SEM 2 - MonWed - A  Mandeya	\N	41	SEM	119	20	YR2	\N	2	Y	Y	Y	N	\N	\N	\N	648	648	MonWed	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	647	1005	ASCA	Period5 - SEM 2 - MonWed - Lawrence  Daka	\N	41	SEM	119	44	YR1	\N	1	Y	Y	Y	N	\N	\N	\N	647	647	MonWed	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	642	1000	HOMP	Period3 - SEM 2 - TueThu - T  Sherman	\N	39	SEM	119	21	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	642	642	TueThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	641	999	LOG	Period3 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	39	SEM	119	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	641	641	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	640	998	APHIL	Period4 - SEM 2 - TueWed - Diddy  Brossala	\N	40	SEM	119	24	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	640	640	TueWed	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	636	994	PSDRG	Period5 - SEM 2 - TueFri - A  Manyere	\N	41	SEM	119	30	YR3	\N	1	Y	Y	Y	N	\N	\N	\N	636	636	TueFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	635	993	OTS	Period2 - SEM 2 - TueThu - K  Esenther	\N	38	SEM	119	22	YR2	\N	10	Y	Y	Y	N	\N	\N	\N	635	635	TueThu	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	634	992	PHILA	Period1 - SEM 2 - MonWed - Costa  Virgilio	\N	37	SEM	119	33	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	634	634	MonWed	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	629	855	LPMA	Period3 - SEM 2 - TueThu - T  Sherman	\N	39	SEM	119	21	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	629	629	TueThu	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	455	936	OCYR4	Period1 - SEM 2 - MonTueWedThuFri - John  Stacer	\N	37	SEM	119	50	YR4	\N	21	Y	Y	Y	N	\N	\N	\N	455	455	MonTueWedThuFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	617	951	ISEL	Period6 - SEM1 - TueThu - A  Manyere	\N	42	SEM	118	30	YR4	\N	1	Y	Y	Y	N	\N	\N	\N	617	617	TueThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	510	823	PPPYR4	Period1 - SEM 2 - MonTueWedThuFri - John  Stacer	\N	37	SEM	119	50	YR4	\N	21	Y	Y	Y	N	\N	\N	\N	510	510	MonTueWedThuFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	627	987	ST	Period6 - SEM1 - MonWed - Costa  Virgilio	\N	42	SEM	118	33	YR3	\N	1	Y	Y	Y	N	\N	\N	\N	627	627	MonWed	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	626	986	PAE	Period4 - SEM1 - MonWedFri - A  Ggita	\N	40	SEM	118	31	YR3	\N	2	Y	Y	Y	N	\N	\N	\N	626	626	MonWedFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	623	983	HIVA	Period1 - SEM1 - MonThu - A  Mandeya	\N	37	SEM	118	20	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	623	623	MonThu	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	622	830	HMP	Period4 - SEM1 - MonWed - A  Ggita	\N	40	SEM	118	31	YR2	\N	9	Y	Y	Y	N	\N	\N	\N	622	622	MonWed	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	621	843	HCT	Period2 - SEM1 - MonWedFri - C  Nyandoro	\N	38	SEM	118	59	YR1	\N	10	Y	Y	Y	N	\N	\N	\N	621	621	MonWedFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	620	836	EDPT	Period3 - SEM1 - TueThu - Olivier  Sempiga	\N	39	SEM	118	38	YR1	\N	10	Y	Y	Y	N	\N	\N	\N	620	620	TueThu	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	618	947	PAEL	Period8 - SEM1 - MonWedFri - A  Ggita	\N	44	SEM	118	31	YR4	\N	2	Y	Y	Y	N	\N	\N	\N	618	618	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	511	824	REYR4	Period4 - SEM 2 - TueThu - C  Nyandoro	\N	40	SEM	119	59	YR4	\N	21	Y	Y	Y	N	\N	\N	\N	511	511	TueThu	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	495	825	OCTYR4	Period2 - SEM 2 - MonWed - Joseph  Mahlahla	\N	38	SEM	119	79	YR4	\N	21	Y	Y	Y	N	\N	\N	\N	495	495	MonWed	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	505	818	OTFYR3	Period3 - SEM 2 - TueThu - I  Chidavaenzi	\N	39	SEM	119	18	YR3	\N	19	Y	Y	Y	N	\N	\N	\N	505	505	TueThu	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	533	810	EYR2	Period1 - SEM 2 - MonWed - Olivier  Sempiga	\N	37	SEM	119	38	YR2	\N	24	Y	Y	Y	N	\N	\N	\N	533	533	MonWed	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	515	801	WLYR2	Period4 - SEM 2 - TueFri - A  Chennells	\N	40	SEM	119	42	YR2	\N	19	Y	Y	Y	N	\N	\N	\N	515	515	TueFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	504	863	ALFYR2	Period3 - SEM 2 - MonFri - Olivier  Sempiga	\N	39	SEM	119	38	YR2	\N	12	Y	Y	Y	N	\N	\N	\N	504	504	MonFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	498	800	OCYR1	Period4 - SEM 2 - MonThu - A  Zvaiwa	\N	40	SEM	119	51	YR1	\N	11	Y	Y	Y	N	\N	\N	\N	498	498	MonThu	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	536	917	EPUG1	Period1 - SEM 2 - MonWed - Olivier  Sempiga	\N	37	SEM	119	38	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	536	536	MonWed	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	528	827	CMYR1	Period3 - SEM 2 - MonWedFri - A  Zvaiwa	\N	39	SEM	119	51	YR2	\N	1	Y	Y	Y	N	\N	\N	\N	528	528	MonWedFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	502	884	PCMEL	Period1 - SEM 2 - MonWedFri - A  Mandeya	\N	37	SEM	119	20	YR3	\N	3	Y	Y	Y	N	\N	\N	\N	502	502	MonWedFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	521	885	BEL	Period1 - SEM 2 - MonWedFri - Costa  Virgilio	\N	37	SEM	119	33	YR2	\N	6	Y	Y	Y	N	\N	\N	\N	521	521	MonWedFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	514	878	PSDRGEL	Period4 - SEM 2 - MonTueWedThu - A  Manyere	\N	40	SEM	119	30	YR1	\N	33	Y	Y	Y	N	\N	\N	\N	514	514	MonTueWedThu	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	586	966	ELEL	Period1 - SEM 2 - MonTueWedThuFri - Costa  Virgilio	\N	5	SEM	34	33	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	\N	586	MonTueWedThuFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	508	817	MCPYR3	Period3 - SEM 2 - MonTue - T  Sherman	\N	39	SEM	119	21	YR3	\N	19	Y	Y	Y	N	\N	\N	\N	508	508	MonTue	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	649	1007	DEMC	Period6 - SEM 2 - TueThu - Olivier  Sempiga	\N	42	SEM	119	38	YR3	\N	2	Y	Y	Y	N	\N	\N	\N	649	649	TueThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	639	997	ROA	Period1 - SEM 2 - MonThuFri - Francis  Zangairai	\N	37	SEM	119	78	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	639	639	MonThuFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	450	805	APYR2	Period1 - SEM1 - TueThu - Costa  Virgilio	\N	37	SEM	118	33	YR2	\N	24	Y	Y	Y	N	\N	\N	\N	450	450	TueThu	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	448	875	APEL	Period6 - SEM1 - MonTueWedThuFri - A  Mandeya	\N	42	SEM	118	20	YR3	\N	18	Y	Y	Y	N	\N	\N	\N	448	448	MonTueWedThuFri	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	452	822	NTYR4	Period3 - SEM1 - TueThu - I  Chidavaenzi	\N	39	SEM	118	18	YR4	\N	21	Y	Y	Y	N	\N	\N	\N	452	452	TueThu	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	444	813	PLYR3	Period2 - SEM1 - MonWedFri - Diddy  Brossala	\N	38	SEM	118	24	YR3	\N	19	Y	Y	Y	N	\N	\N	\N	444	444	MonWedFri	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	447	799	ITYR1	Period5 - SEM1 - Tue - A  Ggita	\N	41	SEM	118	31	YR1	\N	16	Y	Y	Y	N	\N	\N	\N	447	447	Tue	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	483	868	STEL	Period5 - SEM1 - MonThu - Costa  Virgilio	\N	41	SEM	118	33	YR4	\N	5	Y	Y	Y	N	\N	\N	\N	483	483	MonThu	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	449	869	APEL	Period1 - SEM1 - TueFri - A  Manyere	\N	37	SEM	118	30	YR3	\N	19	Y	Y	Y	N	\N	\N	\N	449	449	TueFri	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2039	2392	PHILMIND	Period7 - SEM 2 - MonThuFri - T  Sherman	\N	91	SEM	149	21	\N	\N	2	Y	Y	Y	N	\N	\N	\N	2039	2039	MonThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2024	2386	HITFILM	Period8 - SEM 2 - MonFri - K  Esenther	\N	92	SEM	149	22	\N	\N	1	Y	Y	Y	N	\N	\N	\N	2024	2024	MonFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2010	2379	DISSERT	Period4 - SEM 2 - MonFri - John  Stacer	\N	88	SEM	149	50	\N	\N	6	Y	Y	Y	N	\N	\N	\N	2010	2010	MonFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1995	2366	MLOGIC	Period8 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	92	SEM	149	13	\N	\N	2	Y	Y	Y	N	\N	\N	\N	1995	1995	MonWedFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1980	2358	ISLAM	Period5 - SEM1 - MonTueWed - Francis  Zangairai	\N	89	SEM	148	78	\N	\N	1	Y	Y	Y	N	\N	\N	\N	1980	1980	MonTueWed	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1834	2160	POLA	Period4 - SEM1 - TueFri - Kizito  Kiyimba	\N	88	SEM	148	13	MYA	\N	1	Y	Y	Y	N	\N	\N	\N	1834	1834	TueFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1866	2322	LPUG1	Period1 - SEM 2 - MonThu - Kizito  Kiyimba	\N	85	SEM	149	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1866	1866	MonThu	50	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1470	2038	APDPT	Period2 - SEM 2 - TueThuFri - Diddy  Brossala	\N	78	SEM	144	24	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1470	1470	TueThuFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1467	1977	ALFYR2	Period3 - SEM1 - TueFri - Dominique  Karani	\N	79	SEM	143	54	YR2	\N	6	Y	Y	Y	N	\N	\N	\N	1467	1467	TueFri	47	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	442	787	BAFL	Period1 - SEM1 - MonWedFri - A  Ggita	\N	37	SEM	118	31	YR1	\N	13	Y	Y	Y	N	\N	\N	\N	442	442	MonWedFri	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	443	811	HMYR3	Period4 - SEM1 - TueThu - T  Sherman	\N	40	SEM	118	21	YR3	\N	19	Y	Y	Y	N	\N	\N	\N	443	443	TueThu	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	615	950	LLEL	Period7 - SEM1 - MonFri - I  Chidavaenzi	\N	43	SEM	118	18	YR3	\N	8	Y	Y	Y	N	\N	\N	\N	615	615	MonFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	456	814	ESYR3	Period3 - SEM1 - MonThuFri - Lawrence  Daka	\N	39	SEM	118	44	YR3	\N	56	Y	Y	Y	N	\N	\N	\N	456	456	MonThuFri	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	471	792	LAYR1	Period3 - SEM1 - Wed - A  Chennells	\N	39	SEM	118	42	YR1	\N	11	Y	Y	Y	N	\N	\N	\N	471	471	Wed	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2042	2393	COMPS	Period1 - SEM 2 - WedThuFri - K  Esenther	\N	85	SEM	149	22	Elective	\N	5	Y	Y	Y	N	\N	\N	\N	2042	2042	WedThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2040	2110	POR	Period7 - SEM 2 - MonThuFri - Francis  Zangairai	\N	91	SEM	149	78	\N	\N	1	Y	Y	Y	N	\N	\N	\N	2040	2040	MonThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2025	2363	HIVAIDS	Period8 - SEM 2 - MonTueWedThuFri - A  Mandeya	\N	92	SEM	149	20	\N	\N	8	Y	Y	Y	N	\N	\N	\N	2025	2025	MonTueWedThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2009	2378	DISSERT	Period8 - SEM 2 - MonThuFri - John  Stacer	\N	92	SEM	149	50	\N	\N	25	Y	Y	Y	N	\N	\N	\N	2009	2009	MonThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1996	2367	NGUGI	Period8 - SEM 2 - MonThuFri - A  Chennells	\N	92	SEM	149	42	\N	\N	1	Y	Y	Y	N	\N	\N	\N	1996	1996	MonThuFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1981	2360	MARX	Period5 - SEM1 - MonTueWedThuFri - Francis  Zangairai	\N	89	SEM	148	78	\N	\N	1	Y	Y	Y	N	\N	\N	\N	1981	1981	MonTueWedThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1966	2348	PHOG	Period5 - SEM1 - WedFri - T  Sherman	\N	89	SEM	148	21	MAYR	\N	15	Y	Y	Y	N	\N	\N	\N	1966	1966	WedFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1867	2226	RPYR3	Period1 - SEM1 - MonWedFri - C  Nyandoro	\N	85	SEM	148	59	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1867	1867	MonWedFri	51	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1868	2237	ETMA	Period2 - SEM 2 - MonWed - Costa  Virgilio	\N	86	SEM	149	33	YR4	\N	19	Y	Y	Y	N	\N	\N	\N	1868	1868	MonWed	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1869	2135	LAWA	Period2 - SEM 2 - MonThu - T  Sherman	\N	86	SEM	149	21	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1869	1869	MonThu	50	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1870	2290	PSDPUGE	Period4 - SEM 2 - MonTueWedThu - A  Manyere	\N	88	SEM	149	30	Aud Visual	\N	2	Y	Y	Y	N	\N	\N	\N	1870	1870	MonTueWedThu	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1872	2298	CTEL	Period5 - SEM1 - TueFri - Diddy  Brossala	\N	89	SEM	148	24	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1872	1872	TueFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1601	1861	ASCAEL	Period6 - SEM 2 - MonWed - Lawrence  Daka	\N	82	SEM	144	44	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1601	1601	MonWed	45	30	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1476	2021	FAEPUGE	Period1 - SEM 2 - Mon - T  Sherman	\N	77	SEM	144	21	Offices	\N	0	Y	Y	Y	N	\N	\N	\N	1476	1476	Mon	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2043	2394	COMPS	Period8 - SEM 2 - MonWedThuFri - K  Esenther	\N	92	SEM	149	22	\N	\N	2	Y	Y	Y	N	\N	\N	\N	2043	2043	MonWedThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2041	2385	SCIEREL	Period8 - SEM 2 - MonThuFri - Costa  Virgilio	\N	92	SEM	149	33	\N	\N	3	Y	Y	Y	N	\N	\N	\N	2041	2041	MonThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2011	2380	THNGUGI	Period7 - SEM 2 - MonFri - A  Chennells	\N	91	SEM	149	42	\N	\N	1	Y	Y	Y	N	\N	\N	\N	2011	2011	MonFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2026	2363	HIVAIDS	Period8 - SEM 2 - WedFri - A  Mandeya	\N	92	SEM	149	20	\N	\N	3	Y	Y	Y	N	\N	\N	\N	2026	2026	WedFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1997	2250	CONTPHIL	Period8 - SEM 2 - MonThuFri - Costa  Virgilio	\N	92	SEM	149	33	\N	\N	4	Y	Y	Y	N	\N	\N	\N	1997	1997	MonThuFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1982	2361	PHILAN	Period8 - SEM1 - MonTueWedThu - Kizito  Kiyimba	\N	92	SEM	148	13	\N	\N	2	Y	Y	Y	N	\N	\N	\N	1982	1982	MonTueWedThu	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1967	2349	PHWR	Period4 - SEM1 - TueWed - C  Nyandoro	\N	88	SEM	148	59	MAYR	\N	16	Y	Y	Y	N	\N	\N	\N	1967	1967	TueWed	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1873	2297	JHEL	Period4 - SEM1 - TueFri - Olivier  Sempiga	\N	88	SEM	148	38	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1873	1873	TueFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1874	2162	PAEEL	Period5 - SEM1 - MonFri - A  Ggita	\N	89	SEM	148	31	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1874	1874	MonFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1875	2314	PCMDPT	Period1 - SEM 2 - MonWedFri - A  Mandeya	\N	85	SEM	149	20	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1875	1875	MonWedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1876	2189	APEL	Period1 - SEM1 - MonTueWedThuFri - Kenneth  Makamure	\N	85	SEM	148	\N	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1876	1876	MonTueWedThuFri	48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1877	2170	DEL	Period7 - SEM 2 - WedFri - Olivier  Sempiga	\N	91	SEM	149	38	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1877	1877	WedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1878	2159	PFR	Period5 - SEM 2 - MonWed - Diddy  Brossala	\N	89	SEM	149	24	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1878	1878	MonWed	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1879	2254	APEL	Period1 - SEM1 - MonTueWedThuFri - Johnny  Stacer	\N	85	SEM	148	\N	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1879	1879	MonTueWedThuFri	48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1880	2289	DHPUGE	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	85	SEM	149	26	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1880	1880	TueThu	49	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1881	2260	GPEL	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	85	SEM	149	26	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1881	1881	TueThu	48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1495	2017	IPLPUGE	Period1 - SEM 2 - MonWedFri - T  Sherman	\N	77	SEM	144	21	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	1495	1495	MonWedFri	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1496	1999	BPUGE	Period1 - SEM 2 - TueThu - Costa  Virgilio	\N	77	SEM	144	33	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	1496	1496	TueThu	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2044	2395	INTROPOL	Period8 - SEM 2 - ThuFri - Rachael   Rufu	\N	92	SEM	149	90	\N	\N	2	Y	Y	Y	N	\N	\N	\N	2044	2044	ThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2027	2301	ICSPEL	Period8 - SEM 2 - TueWedFri - K  Esenther	\N	92	SEM	149	22	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2027	2027	TueWedFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2012	2380	THNGUGI	Period8 - SEM 2 - MonFri - A  Chennells	\N	92	SEM	149	42	\N	\N	4	Y	Y	Y	N	\N	\N	\N	2012	2012	MonFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1998	2368	PHILTEK	Period8 - SEM 2 - TueThuFri - Kizito  Kiyimba	\N	92	SEM	149	13	\N	\N	4	Y	Y	Y	N	\N	\N	\N	1998	1998	TueThuFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1983	2356	NIETZ	Period8 - SEM1 - MonTueFri - Costa  Virgilio	\N	92	SEM	148	33	\N	\N	9	Y	Y	Y	N	\N	\N	\N	1983	1983	MonTueFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1865	2148	PEDMA	Period3 - SEM1 - WedFri - C  Nyandoro	\N	87	SEM	148	59	YR1	\N	8	Y	Y	Y	N	\N	\N	\N	1865	1865	WedFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1882	2166	BLMA	Period4 - SEM1 - TueFri - John  Stacer	\N	88	SEM	148	50	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1882	1882	TueFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1883	2134	BIOE	Period5 - SEM 2 - MonWed - Costa  Virgilio	\N	89	SEM	149	33	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1883	1883	MonWed	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1885	2157	ASCA	Period5 - SEM 2 - MonWed - Lawrence  Daka	\N	89	SEM	149	44	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1885	1885	MonWed	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1886	2129	PSDRG	Period5 - SEM 2 - TueFri - A  Manyere	\N	89	SEM	149	30	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1886	1886	TueFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1887	2171	OTS	Period2 - SEM 2 - TueThu - K  Esenther	\N	86	SEM	149	22	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1887	1887	TueThu	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1888	2168	ST	Period6 - SEM1 - MonWed - Costa  Virgilio	\N	90	SEM	148	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1888	1888	MonWed	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1889	2152	PAE	Period4 - SEM1 - MonWedFri - A  Ggita	\N	88	SEM	148	31	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1889	1889	MonWedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1890	2151	HIVA	Period1 - SEM1 - MonThu - A  Mandeya	\N	85	SEM	148	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1890	1890	MonThu	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1891	2175	FLYR1	Period1 - SEM 2 - MonWedFri - A  Ggita	\N	85	SEM	149	31	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1891	1891	MonWedFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1892	2214	PPPYR4	Period1 - SEM 2 - MonTueWedThuFri - John  Stacer	\N	85	SEM	149	50	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	1892	1892	MonTueWedThuFri	50	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1893	2165	APHIL	Period4 - SEM 2 - TueWed - Diddy  Brossala	\N	88	SEM	149	24	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1893	1893	TueWed	50	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1894	2131	HOMP	Period3 - SEM 2 - TueThu - T  Sherman	\N	87	SEM	149	21	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1894	1894	TueThu	50	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1895	2281	HMPPUG2	Period3 - SEM1 - MonWedFri - T  Sherman	\N	87	SEM	148	21	YR3	\N	12	Y	Y	Y	N	\N	\N	\N	1895	1895	MonWedFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1896	2141	LOG	Period3 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	87	SEM	149	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1896	1896	MonWedFri	50	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1897	2199	PAPUGYR2	Period2 - SEM1 - TueThu - John  Stacer	\N	86	SEM	148	50	YR@	\N	0	Y	Y	Y	N	\N	\N	\N	1897	1897	TueThu	50	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1898	2282	PLPPUG2	Period4 - SEM1 - TueThuFri - Diddy  Brossala	\N	88	SEM	148	24	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1898	1898	TueThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1543	1874	POSMA	Period4 - SEM 2 - WedFri - Kizito  Kiyimba	\N	80	SEM	144	13	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	1543	1543	WedFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2045	2396	INTROPEACE	Period8 - SEM 2 - MonWedFri - A  Mandeya	\N	92	SEM	149	20	\N	\N	11	Y	Y	Y	N	\N	\N	\N	2045	2045	MonWedFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2013	2381	CURIDEV	Period7 - SEM 2 - TueWedFri - C  Nyandoro	\N	91	SEM	149	59	\N	\N	2	Y	Y	Y	N	\N	\N	\N	2013	2013	TueWedFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1999	2369	SCIEREL	Period8 - SEM 2 - TueWedThuFri - Costa  Virgilio	\N	92	SEM	149	33	\N	\N	6	Y	Y	Y	N	\N	\N	\N	1999	1999	TueWedThuFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1977	2356	NIETZ	Period6 - SEM1 - MonThu - Costa  Virgilio	\N	90	SEM	148	33	\N	\N	13	Y	Y	Y	N	\N	\N	\N	1977	1977	MonThu	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1968	2352	ARPH	Period4 - SEM1 - MonFri - T  Sherman	\N	88	SEM	148	21	MAYR	\N	2	Y	Y	Y	N	\N	\N	\N	1968	1968	MonFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1899	2268	NTFPUG3	Period3 - SEM1 - MonTueFri - I  Chidavaenzi	\N	87	SEM	148	18	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	1899	1899	MonTueFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1900	2125	EPMA	Period2 - SEM1 - TueThu - Kizito  Kiyimba	\N	86	SEM	148	13	YR1	\N	16	Y	Y	Y	N	\N	\N	\N	1900	1900	TueThu	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1901	2243	SPMA	Period1 - SEM1 - MonWed - Costa  Virgilio	\N	85	SEM	148	33	MAYR	\N	8	Y	Y	Y	N	\N	\N	\N	1901	1901	MonWed	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1902	2312	CTIDPT	Period3 - SEM 2 - MonWedFri - A  Manyere	\N	87	SEM	149	30	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1902	1902	MonWedFri	51	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1903	2101	ELEL	Period5 - SEM1 - MonWedFri - Costa  Virgilio	\N	89	SEM	148	33	\N	\N	12	Y	Y	Y	N	\N	\N	\N	1903	1903	MonWedFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1904	2164	GAEL	Period5 - SEM1 - TueThu - A  Mandeya	\N	89	SEM	148	20	YR3	\N	9	Y	Y	Y	N	\N	\N	\N	1904	1904	TueThu	51	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1905	2156	PMOE	Period2 - SEM 2 - MonFri - C  Nyandoro	\N	86	SEM	149	59	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1905	1905	MonFri	51	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1906	2227	EDPT	Period3 - SEM1 - TueThu - Olivier  Sempiga	\N	87	SEM	148	38	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1906	1906	TueThu	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1907	2145	PAEL	Period8 - SEM1 - MonWedFri - A  Ggita	\N	92	SEM	148	31	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	1907	1907	MonWedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1908	2287	PPPPUG3	Period2 - SEM1 - MonTueWedThuFri - John  Stacer	\N	86	SEM	148	50	Offices	\N	0	Y	Y	Y	N	\N	\N	\N	1908	1908	MonTueWedThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1909	2245	LPMA	Period3 - SEM1 - TueThu - Diddy  Brossala	\N	87	SEM	148	24	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	1909	1909	TueThu	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1910	2218	CMYR1	Period3 - SEM 2 - MonWedFri - A  Zvaiwa	\N	87	SEM	149	51	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1910	1910	MonWedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1911	2302	BEL	Period1 - SEM1 - MonWedFri - Costa  Virgilio	\N	85	SEM	148	33	YR2	\N	3	Y	Y	Y	N	\N	\N	\N	1911	1911	MonWedFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1913	2177	ENYR1	Period1 - SEM1 - TueThu - K  Esenther	\N	85	SEM	148	22	YR1	\N	20	Y	Y	Y	N	\N	\N	\N	1913	1913	TueThu	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1915	2185	ITYR1	Period5 - SEM1 - MonWed - INTYR2 - John  Sanni	\N	89	SEM	148	83	YR1	\N	13	Y	Y	Y	N	\N	\N	\N	1915	1915	MonWed	51	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1916	2178	HAYR1	Period2 - SEM1 - MonWedFri - P  Nyambara	\N	86	SEM	148	8	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	1916	1916	MonWedFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1917	2176	LAYR1	Period3 - SEM1 - Wed - A  Chennells	\N	87	SEM	148	42	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	1917	1917	Wed	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1582	1898	SKEL	Period6 - SEM1 - MonWedFri - Diddy  Brossala	\N	82	SEM	143	24	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1582	1582	MonWedFri	45	32	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1590	1897	BLEL	Period6 - SEM1 - MonThu - John  Stacer	\N	82	SEM	143	50	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1590	1590	MonThu	45	30	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1591	1843	AIEL	Period1 - SEM1 - WedFri - A  Chennells	\N	77	SEM	143	42	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1591	1591	WedFri	45	30	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2046	2397	INTROHRIGH	Period8 - SEM 2 - MonThuFri - Kirenga  Kirenga	\N	92	SEM	149	93	\N	\N	3	Y	Y	Y	N	\N	\N	\N	2046	2046	MonThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2029	2387	INTROPOL	Period7 - SEM 2 - MonThuFri - Rachael   Rufu	\N	91	SEM	149	90	\N	\N	11	Y	Y	Y	N	\N	\N	\N	2029	2029	MonThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2014	2381	CURIDEV	Period8 - SEM 2 - MonFri - C  Nyandoro	\N	92	SEM	149	59	\N	\N	2	Y	Y	Y	N	\N	\N	\N	2014	2014	MonFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2000	2370	CURIDEV	Period8 - SEM 2 - MonTueWedThuFri - C  Nyandoro	\N	92	SEM	149	59	\N	\N	1	Y	Y	Y	N	\N	\N	\N	2000	2000	MonTueWedThuFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1984	2101	ELEL	Period8 - SEM1 - MonWed - Costa  Virgilio	\N	92	SEM	148	33	\N	\N	1	Y	Y	Y	N	\N	\N	\N	1984	1984	MonWed	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1965	2346	IGSPI	Period6 - SEM1 - MonThuFri - A  Manyere	\N	90	SEM	148	30	MAYR	\N	11	Y	Y	Y	N	\N	\N	\N	1965	1965	MonThuFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1919	2183	MRYR1	Period2 - SEM1 - TueThu - C  Nyandoro	\N	86	SEM	148	59	YR1	\N	10	Y	Y	Y	N	\N	\N	\N	1919	1919	TueThu	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1922	2175	FLYR1	Period1 - SEM 2 - MonTue - Dominique  Karani	\N	85	SEM	149	54	YR1	\N	8	Y	Y	Y	N	\N	\N	\N	1922	1922	MonTue	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3377	3609	FREUD	PUG16S1P4 - SEM1 - Tue - A  Zvaiwa	\N	256	SEM	184	51	\N	\N	7	Y	Y	Y	N	\N	\N	\N	3377	3377	Tue	94	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1923	2186	ENYR1	Period1 - SEM 2 - WedThuFri - K  Esenther	\N	85	SEM	149	22	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1923	1923	WedThuFri	50	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1924	2180	RAYR1	Period3 - SEM 2 - Fri - Francis  Zangairai	\N	87	SEM	149	78	YR1	\N	10	Y	Y	Y	N	\N	\N	\N	1924	1924	Fri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1925	2113	OCYR1	Period4 - SEM 2 - TueFri - A  Manyere	\N	88	SEM	149	30	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1925	1925	TueFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1928	2253	ALFYR2	Period3 - SEM 2 - MonFri - Dominique  Karani	\N	87	SEM	149	54	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	1928	1928	MonFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1930	2192	WLYR2	Period4 - SEM 2 - TueFri - A  Chennells	\N	88	SEM	149	42	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1930	1930	TueFri	51	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1931	2216	OCTYR4	Period2 - SEM 2 - MonWed - Joseph  Mahlahla	\N	86	SEM	149	79	YR4	\N	24	Y	Y	Y	N	\N	\N	\N	1931	1931	MonWed	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1932	2215	REYR4	Period4 - SEM 2 - TueThu - C  Nyandoro	\N	88	SEM	149	59	YR4	\N	24	Y	Y	Y	N	\N	\N	\N	1932	1932	TueThu	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1933	2339	PCMEL	Period1 - SEM1 - MonWedFri - A  Mandeya	\N	85	SEM	148	20	YR3	\N	5	Y	Y	Y	N	\N	\N	\N	1933	1933	MonWedFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1934	2124	ISEL	Period6 - SEM1 - TueThu - A  Manyere	\N	90	SEM	148	30	YR4	\N	1	Y	Y	Y	N	\N	\N	\N	1934	1934	TueThu	50	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1936	2238	MAHE	Period1 - SEM 2 - TueFri - John  Stacer	\N	85	SEM	149	50	MAYR	\N	0	Y	Y	Y	N	\N	\N	\N	1936	1936	TueFri	51	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1937	2325	OSAD	Period1 - SEM 2 - TueFri - Patrick  Ryan	\N	85	SEM	149	84	DYR1	\N	0	Y	Y	Y	N	\N	\N	\N	1937	1937	TueFri	51	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1938	2324	ATPUG	Period1 - SEM 2 - TueFri - Francis  Zangairai	\N	85	SEM	149	78	DYR1	\N	0	Y	Y	Y	N	\N	\N	\N	1938	1938	TueFri	51	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1626	1946	HMP	Period4 - SEM1 - MonWed - A  Ggita	\N	80	SEM	143	31	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1626	1626	MonWed	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1627	1959	HCT	Period2 - SEM1 - MonWedFri - C  Nyandoro	\N	78	SEM	143	59	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1627	1627	MonWedFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2047	2398	PHILTEK	Period7 - SEM 2 - MonThuFri - Francis  Zangairai	\N	91	SEM	149	78	\N	\N	3	Y	Y	Y	N	\N	\N	\N	2047	2047	MonThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2015	2382	THGARD	Period7 - SEM 2 - MonFri - C  Nyandoro	\N	91	SEM	149	59	\N	\N	1	Y	Y	Y	N	\N	\N	\N	2015	2015	MonFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2001	2371	PHILTEK	Period5 - SEM 2 - MonThuFri - Kizito  Kiyimba	\N	89	SEM	149	13	\N	\N	1	Y	Y	Y	N	\N	\N	\N	2001	2001	MonThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1985	2362	ARPH	Period6 - SEM1 - MonThuFri - T  Sherman	\N	90	SEM	148	21	\N	\N	5	Y	Y	Y	N	\N	\N	\N	1985	1985	MonThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1969	2353	GREEK	Period2 - SEM1 - TueWedThuFri - A  Chennells	\N	86	SEM	148	42	YR1	\N	6	Y	Y	Y	N	\N	\N	\N	1969	1969	TueWedThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1939	2169	PSDRGEL	Period4 - SEM 2 - MonTueWedThu - A  Manyere	\N	88	SEM	149	30	YR1	\N	16	Y	Y	Y	N	\N	\N	\N	1939	1939	MonTueWedThu	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1940	2209	OTFYR3	Period3 - SEM 2 - TueThu - I  Chidavaenzi	\N	87	SEM	149	18	YR3	\N	13	Y	Y	Y	N	\N	\N	\N	1940	1940	TueThu	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1941	2296	OCYR4	Period1 - SEM 2 - MonTueWedThuFri - John  Stacer	\N	85	SEM	149	50	YR4	\N	25	Y	Y	Y	N	\N	\N	\N	1941	1941	MonTueWedThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1666	2057	FL	Period7 - SEM1 - TueThu - Kizito  Kiyimba	\N	83	SEM	143	13	YR1	\N	7	Y	Y	Y	N	\N	\N	\N	1666	1666	TueThu	47	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1660	2051	HOAP	Period2 - SEM1 - TueThu - T  Sherman	\N	78	SEM	143	21	YR3	\N	2	Y	Y	Y	N	\N	\N	\N	1660	1660	TueThu	47	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1551	2004	FLPUG1	Period1 - SEM1 - MonWed - Dominique  Karani	\N	77	SEM	143	54	YR1	\N	12	Y	Y	Y	N	\N	\N	\N	1551	1551	MonWed	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1658	2049	POL	Period5 - SEM1 - MonWedFri - Francis  Zangairai	\N	81	SEM	143	78	YR 1	\N	2	Y	Y	Y	N	\N	\N	\N	1658	1658	MonWedFri	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1659	2050	TTEL	Period6 - SEM1 - TueThu - Costa  Virgilio	\N	82	SEM	143	33	YR 3	\N	2	Y	Y	Y	N	\N	\N	\N	1659	1659	TueThu	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1667	2058	POR	Period5 - SEM1 - MonWedFri - Francis  Zangairai	\N	81	SEM	143	78	YR2	\N	7	Y	Y	Y	N	\N	\N	\N	1667	1667	MonWedFri	47	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1662	2053	FRLS	Period1 - SEM1 - MonWed - Dominique  Karani	\N	77	SEM	143	54	YR 1	\N	1	Y	Y	Y	N	\N	\N	\N	1662	1662	MonWed	47	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1664	2055	MRS	Period1 - SEM1 - TueThu - C  Nyandoro	\N	77	SEM	143	59	YR 1	\N	5	Y	Y	Y	N	\N	\N	\N	1664	1664	TueThu	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1669	2060	SLS	Period6 - SEM1 - TueThu - teacher  teacher	\N	82	SEM	143	28	YR 1	\N	0	Y	Y	Y	N	\N	\N	\N	1669	1669	TueThu	47	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1671	2062	ITBL	Period5 - SEM1 - TueFri - A  Chennells	\N	81	SEM	143	42	YR 3	\N	1	Y	Y	Y	N	\N	\N	\N	1671	1671	TueFri	47	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1694	2073	MAISLAM	Period3 - SEM 2 - Mon - Patrick  Ryan	\N	79	SEM	144	84	MAYR	\N	2	Y	Y	Y	N	\N	\N	\N	1694	1694	Mon	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1695	2074	PHIH	Period4 - SEM 2 - Wed - C  Nyandoro	\N	80	SEM	144	59	MAYR	\N	5	Y	Y	Y	N	\N	\N	\N	1695	1695	Wed	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1696	2075	PHMA	Period5 - SEM 2 - MonThu - T  Sherman	\N	81	SEM	144	21	MAYR	\N	1	Y	Y	Y	N	\N	\N	\N	1696	1696	MonThu	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1670	2061	PTP	Period5 - SEM 2 - WedFri - Kizito  Kiyimba	\N	81	SEM	144	13	YR2	\N	4	Y	Y	Y	N	\N	\N	\N	1670	1670	WedFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1518	2032	APEL	Period1 - SEM1 - MonTueWedThuFri - A  Chennells	\N	77	SEM	143	42	YR3	\N	3	Y	Y	Y	N	\N	\N	\N	1518	1518	MonTueWedThuFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1672	2063	POR	Period5 - SEM1 - MonWedFri - Francis  Zangairai	\N	81	SEM	143	78	YR 1	\N	1	Y	Y	Y	N	\N	\N	\N	1672	1672	MonWedFri	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1673	2064	PLS	Period5 - SEM1 - TueThu - Costa  Virgilio	\N	81	SEM	143	33	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	1673	1673	TueThu	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1675	2066	FL	Period7 - SEM1 - TueThu - Kizito  Kiyimba	\N	83	SEM	143	13	YR1	\N	2	Y	Y	Y	N	\N	\N	\N	1675	1675	TueThu	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1683	2070	DISSER	Period5 - T1 - MonWedThu - Kizito  Kiyimba	\N	81	QTR	146	13	YR 1	\N	0	Y	Y	Y	N	\N	\N	\N	1683	1683	MonWedThu	47	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1677	2067	AQLKB	Period5 - SEM1 - MonWedFri - T  Sherman	\N	81	SEM	143	21	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	1677	1677	MonWedFri	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1678	2068	LOM	Period7 - SEM1 - TueThu - A  Chennells	\N	83	SEM	143	42	YR 3	\N	3	Y	Y	Y	N	\N	\N	\N	1678	1678	TueThu	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1679	2069	PTP	Period5 - SEM1 - MonWed - Kizito  Kiyimba	\N	81	SEM	143	13	YR2	\N	1	Y	Y	Y	N	\N	\N	\N	1679	1679	MonWed	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1516	2048	FLPUG1	Period1 - SEM 2 - MonWedFri - A  Ggita	\N	77	SEM	144	31	DIP YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1516	1516	MonWedFri	45	32	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1459	1925	PTDYR2	Period4 - SEM1 - MonWedFri - A  Manyere	\N	80	SEM	143	30	YR2	\N	13	Y	Y	Y	N	\N	\N	\N	1459	1459	MonWedFri	43	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1469	1905	VT2YR1	Period3 - SEM1 - Mon - Joseph  Mahlahla	\N	79	SEM	143	79	YR1	\N	7	Y	Y	Y	N	\N	\N	\N	1469	1469	Mon	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1465	1919	RWYR2	Period3 - SEM1 - MonWedFri - Francis  Zangairai	\N	79	SEM	143	78	YR2	\N	13	Y	Y	Y	N	\N	\N	\N	1465	1465	MonWedFri	43	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1464	1928	PSYR3	Period4 - SEM1 - MonThu - Kizito  Kiyimba	\N	80	SEM	143	13	YR3	\N	27	Y	Y	Y	N	\N	\N	\N	1464	1464	MonThu	43	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1462	1935	APYR4	Period3 - SEM1 - MonWedFri - John  Sanni	\N	79	SEM	143	83	YR3	\N	19	Y	Y	Y	N	\N	\N	\N	1462	1462	MonWedFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1460	1936	EHYR4	Period2 - SEM1 - MonWed - John  Stacer	\N	78	SEM	143	50	YR4	\N	19	Y	Y	Y	N	\N	\N	\N	1460	1460	MonWed	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1514	1996	REPUG3	Period3 - SEM 2 - MonWedFri - C  Nyandoro	\N	79	SEM	144	59	YR4	\N	5	Y	Y	Y	N	\N	\N	\N	1514	1514	MonWedFri	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1515	2019	PCMPUGE	Period1 - SEM 2 - TueThu - A  Mandeya	\N	77	SEM	144	20	DIP YR1	\N	7	Y	Y	Y	N	\N	\N	\N	1515	1515	TueThu	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1517	2010	MCPPUG2	Period4 - SEM 2 - MonWed - T  Sherman	\N	80	SEM	144	21	YR3	\N	5	Y	Y	Y	N	\N	\N	\N	1517	1517	MonWed	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1463	1937	PGYR4	Period4 - SEM1 - MonWedFri - T  Sherman	\N	80	SEM	143	21	YR4	\N	19	Y	Y	Y	N	\N	\N	\N	1463	1463	MonWedFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1643	1880	DEMC	Period6 - SEM 2 - TueThu - Olivier  Sempiga	\N	82	SEM	144	38	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1643	1643	TueThu	45	32	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1650	1981	STEL	Period5 - SEM1 - MonThu - Costa  Virgilio	\N	81	SEM	143	33	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	1650	1650	MonThu	43	30	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1473	1989	SSAPUG1	Period1 - SEM 2 - MonWedThu - Ben  Sachikonye	\N	77	SEM	144	37	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1473	1473	MonWedThu	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1475	2001	RAPUG1	Period1 - SEM 2 - MonThuFri - Francis  Zangairai	\N	77	SEM	144	78	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1475	1475	MonThuFri	45	32	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1478	1980	GAAPH	Period1 - SEM1 - MonTueWedThuFri - Ujah  Ejembi	\N	77	SEM	143	26	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1478	1478	MonTueWedThuFri	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1479	2041	IDDPT	Period4 - SEM 2 - TueThuFri - C  Nyandoro	\N	80	SEM	144	59	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1479	1479	TueThuFri	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1480	1953	PRYR2	Period2 - SEM1 - MonFri - T  Sherman	\N	78	SEM	143	21	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1480	1480	MonFri	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1481	1954	IOTYR1	Period2 - SEM1 - Wed - Zvaiwa  Zvaiwa	\N	78	SEM	143	\N	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1481	1481	Wed	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1484	1944	IPYR1	Period1 - SEM1 - TueThu - A  Ggita	\N	77	SEM	143	31	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1484	1484	TueThu	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1485	2035	DPTEL	Period2 - SEM1 - TueThu - A  Mandeya	\N	78	SEM	143	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1485	1485	TueThu	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1486	1942	CMYR1	Period1 - SEM1 - MonWedFri - C  Nyandoro	\N	77	SEM	143	59	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1486	1486	MonWedFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1487	1954	IOTYR1	Period2 - SEM1 - WedFri - Zvaiwa  Zvaiwa	\N	78	SEM	143	\N	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1487	1487	WedFri	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1488	1945	HAYR1	Period3 - SEM1 - TueFri - C  Matusse	\N	79	SEM	143	19	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1488	1488	TueFri	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1491	1956	NTYR3	Period2 - SEM1 - TueThu - A  Mandeya	\N	78	SEM	143	20	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1491	1491	TueThu	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1492	2045	HRs	Period1 - SEM1 - Mon - Costa  Virgilio	\N	77	SEM	143	33	Office	\N	0	Y	Y	Y	N	\N	\N	\N	1492	1492	Mon	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1494	2020	APPUGE	Period1 - SEM 2 - Mon - A  Perumalil	\N	77	SEM	144	9	Offices	\N	0	Y	Y	Y	N	\N	\N	\N	1494	1494	Mon	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1649	1909	ITYR1	Period5 - SEM1 - MonWed - John  Sanni	\N	81	SEM	143	83	YR1	\N	7	Y	Y	Y	N	\N	\N	\N	1649	1649	MonWed	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1645	1921	APYR2	Period1 - SEM1 - TueThu - Costa  Virgilio	\N	77	SEM	143	33	YR2	\N	13	Y	Y	Y	N	\N	\N	\N	1645	1645	TueThu	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1477	1922	HMPYR2	Period2 - SEM 2 - TueWedFri - T  Sherman	\N	78	SEM	144	21	YR2	\N	15	Y	Y	Y	N	\N	\N	\N	1477	1477	TueWedFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1652	1918	WLYR2	Period4 - SEM1 - TueThu - A  Chennells	\N	80	SEM	143	42	YR2	\N	12	Y	Y	Y	N	\N	\N	\N	1652	1652	TueThu	43	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1647	1938	NTYR4	Period3 - SEM1 - TueThu - I  Chidavaenzi	\N	79	SEM	143	18	YR4	\N	19	Y	Y	Y	N	\N	\N	\N	1647	1647	TueThu	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1656	1930	ESYR3	Period3 - SEM1 - MonThuFri - Lawrence  Daka	\N	79	SEM	143	44	YR3	\N	27	Y	Y	Y	N	\N	\N	\N	1656	1656	MonThuFri	43	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1654	1927	HMYR3	Period4 - SEM1 - TueThu - T  Sherman	\N	80	SEM	143	21	YR3	\N	27	Y	Y	Y	N	\N	\N	\N	1654	1654	TueThu	43	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1471	1931	CPYR3	Period2 - SEM 2 - MonWed - John  Sanni	\N	78	SEM	144	83	YR3	\N	27	Y	Y	Y	N	\N	\N	\N	1471	1471	MonWed	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1648	1929	PLYR3	Period2 - SEM1 - MonWedFri - Diddy  Brossala	\N	78	SEM	143	24	YR3	\N	25	Y	Y	Y	N	\N	\N	\N	1648	1648	MonWedFri	43	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1493	1993	OFPUG2	Period3 - SEM 2 - WedFri - I  Chidavaenzi	\N	79	SEM	144	18	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1493	1493	WedFri	44	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1644	1850	ROA	Period1 - SEM 2 - MonThuFri - Francis  Zangairai	\N	77	SEM	144	78	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1644	1644	MonThuFri	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1474	1998	ICSPUGE	Period1 - SEM 2 - MonWedFri - K  Esenther	\N	77	SEM	144	22	Computer	\N	6	Y	Y	Y	N	\N	\N	\N	1474	1474	MonWedFri	44	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1651	2026	IGSP	Period1 - SEM1 - TueFri - A  Manyere	\N	77	SEM	143	30	YR3	\N	16	Y	Y	Y	N	\N	\N	\N	1651	1651	TueFri	43	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1490	1953	PRYR2	Period2 - SEM 2 - MonFri - Francis  Zangairai	\N	78	SEM	144	78	YR2	\N	4	Y	Y	Y	N	\N	\N	\N	1490	1490	MonFri	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1646	1982	APEL	Period6 - SEM1 - MonTueWedThuFri - A  Mandeya	\N	82	SEM	143	20	YR3	\N	10	Y	Y	Y	N	\N	\N	\N	1646	1646	MonTueWedThuFri	43	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1642	1933	MCPYR3	Period3 - SEM 2 - MonTue - T  Sherman	\N	79	SEM	144	21	YR3	\N	27	Y	Y	Y	N	\N	\N	\N	1642	1642	MonTue	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1498	1848	PCCEL	Period5 - SEM 2 - MonWedFri - A  Mandeya	\N	81	SEM	144	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1498	1498	MonWedFri	45	30	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1504	1983	DPTEL	Period2 - SEM1 - TueThu - T  Sherman	\N	78	SEM	143	21	DP	\N	0	Y	Y	Y	N	\N	\N	\N	1504	1504	TueThu	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1505	2034	DPTEL	Period2 - SEM1 - TueThu - Kenneth  Makamure	\N	78	SEM	143	\N	DP	\N	0	Y	Y	Y	N	\N	\N	\N	1505	1505	TueThu	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1506	1890	SPP	Period3 - SEM1 - TueFri - Diddy  Brossala	\N	79	SEM	143	24	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1506	1506	TueFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1508	2006	PTDPUG1	Period3 - SEM1 - MonWedFri - A  Manyere	\N	79	SEM	143	30	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1508	1508	MonWedFri	45	32	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1509	1885	FFEL	Period5 - SEM1 - MonWed - Diddy  Brossala	\N	81	SEM	143	24	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1509	1509	MonWed	45	30	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1510	2000	HRPUGE	Period1 - SEM 2 - MonWedFri - Costa  Virgilio	\N	77	SEM	144	33	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	1510	1510	MonWedFri	45	32	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1483	1895	FLS	Period1 - SEM1 - MonWed - Dominique  Karani	\N	77	SEM	143	54	YR1	\N	1	Y	Y	Y	N	\N	\N	\N	1483	1483	MonWed	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1482	1976	ATYR2	Period1 - SEM1 - MonWedFri - A  Mandeya	\N	77	SEM	143	20	YR2	\N	4	Y	Y	Y	N	\N	\N	\N	1482	1482	MonWedFri	47	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1511	2036	DPTEL	Period2 - SEM1 - TueThu - Johnny  Stacer	\N	78	SEM	143	\N	DP	\N	0	Y	Y	Y	N	\N	\N	\N	1511	1511	TueThu	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1519	2033	APEL	Period1 - SEM1 - MonTueWedThuFri - Lawrence  Daka	\N	77	SEM	143	\N	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1519	1519	MonTueWedThuFri	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1520	2030	PFEL	Period1 - SEM 2 - MonWedFri - Diddy  Brossala	\N	77	SEM	144	24	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1520	1520	MonWedFri	45	30	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1521	1876	PCC	Period6 - SEM 2 - TueWedFri - A  Mandeya	\N	82	SEM	144	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1521	1521	TueWedFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1524	1958	HCTPDPT	Period2 - SEM 2 - TueThu - C  Nyandoro	\N	78	SEM	144	59	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1524	1524	TueThu	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1525	2046	ICSDPT	Period2 - SEM 2 - TueThu - K  Esenther	\N	78	SEM	144	22	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1525	1525	TueThu	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1526	1957	ITDPT	Period1 - SEM1 - MonWedFri - K  Esenther	\N	77	SEM	143	22	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1526	1526	MonWedFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1527	1955	INTDPT	Period3 - SEM 2 - MonThuFri - A  Mandeya	\N	79	SEM	144	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1527	1527	MonThuFri	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1530	2018	PFPUGE	Period1 - SEM 2 - MonWedFri - Diddy  Brossala	\N	77	SEM	144	24	Aud Visual	\N	0	Y	Y	Y	N	\N	\N	\N	1530	1530	MonWedFri	45	32	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1533	2045	HRs	Period3 - SEM 2 - MonWedFri - Costa  Virgilio	\N	79	SEM	144	33	Aud Visual	\N	0	Y	Y	Y	N	\N	\N	\N	1533	1533	MonWedFri	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1534	2044	DHDPT	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	77	SEM	144	26	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1534	1534	TueThu	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1535	2043	HRDPT	Period1 - SEM 2 - TueThuFri - Costa  Virgilio	\N	77	SEM	144	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1535	1535	TueThuFri	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1536	2037	FAEL	Period1 - SEM 2 - Wed - T  Sherman	\N	77	SEM	144	21	Y4	\N	0	Y	Y	Y	N	\N	\N	\N	1536	1536	Wed	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1537	1915	PLEL	Period1 - SEM 2 - MonWedFri - T  Sherman	\N	77	SEM	144	21	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1537	1537	MonWedFri	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1538	1987	RSFANEL	Period1 - SEM 2 - MonWedFri - A  Chennells	\N	77	SEM	144	42	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1538	1538	MonWedFri	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1499	1852	APHIL	Period4 - SEM1 - TueWed - Diddy  Brossala	\N	80	SEM	143	24	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1499	1499	TueWed	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1513	1992	PMEPUG2	Period3 - SEM 2 - TueWedThu - A  Ggita	\N	79	SEM	144	31	YR3	\N	5	Y	Y	Y	N	\N	\N	\N	1513	1513	TueWedThu	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1507	1896	LOG	Period3 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	79	SEM	144	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1507	1507	MonWedFri	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1523	2014	OCTPUG3	Period3 - SEM 2 - WedFri - Joseph  Mahlahla	\N	79	SEM	144	79	YR4	\N	2	Y	Y	Y	N	\N	\N	\N	1523	1523	WedFri	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1472	1956	NTYR2	Period1 - SEM1 - TueThu - K  Esenther	\N	77	SEM	143	22	YR3	\N	15	Y	Y	Y	N	\N	\N	\N	1472	1472	TueThu	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1501	1847	POE	Period3 - SEM 2 - TueThu - A  Zvaiwa	\N	79	SEM	144	51	YR2	\N	1	Y	Y	Y	N	\N	\N	\N	1501	1501	TueThu	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1528	1949	EPDPT	Period3 - SEM 2 - MonWedFri - Costa  Virgilio	\N	79	SEM	144	33	YR3	\N	4	Y	Y	Y	N	\N	\N	\N	1528	1528	MonWedFri	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1503	2039	IEDPT	Period1 - SEM 2 - WedThuFri - A  Mandeya	\N	77	SEM	144	20	YR3	\N	4	Y	Y	Y	N	\N	\N	\N	1503	1503	WedThuFri	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1497	1865	LLEL	Period2 - SEM 2 - MonWedFri - I  Chidavaenzi	\N	78	SEM	144	18	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1497	1497	MonWedFri	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1502	2028	ICSPEL	Period1 - SEM 2 - MonWedFri - K  Esenther	\N	77	SEM	144	22	YR1	\N	6	Y	Y	Y	N	\N	\N	\N	1502	1502	MonWedFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1529	2009	CPPUG2	Period2 - SEM 2 - MonWedFri - Diddy  Brossala	\N	78	SEM	144	24	YR3	\N	5	Y	Y	Y	N	\N	\N	\N	1529	1529	MonWedFri	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1500	1868	BAPRE	Period4 - SEM 2 - TueThu - A  Zvaiwa	\N	80	SEM	144	51	\N	\N	7	Y	Y	Y	N	\N	\N	\N	1500	1500	TueThu	45	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1544	1882	POLA	Period4 - SEM 2 - TueFri - Kizito  Kiyimba	\N	80	SEM	144	13	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1544	1544	TueFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1554	1864	KEL	Period5 - SEM1 - TueThu - Diddy  Brossala	\N	81	SEM	143	24	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1554	1554	TueThu	45	30	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1539	1984	IPPUG1	Period3 - SEM1 - MonThu - John  Sanni	\N	79	SEM	143	83	YR1	\N	12	Y	Y	Y	N	\N	\N	\N	1539	1539	MonThu	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1547	2011	SAPPUG3	Period2 - SEM1 - MonWedThu - John  Sanni	\N	78	SEM	143	83	YR4	\N	3	Y	Y	Y	N	\N	\N	\N	1547	1547	MonWedThu	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1548	1994	EHPUG3	Period2 - SEM1 - TueThu - John  Stacer	\N	78	SEM	143	50	YR4	\N	3	Y	Y	Y	N	\N	\N	\N	1548	1548	TueThu	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1540	1985	POM	Period2 - SEM1 - MonWedFri - Costa  Virgilio	\N	78	SEM	143	33	YR2	\N	13	Y	Y	Y	N	\N	\N	\N	1540	1540	MonWedFri	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1555	2002	APPUG1	Period2 - SEM 2 - MonThu - Diddy  Brossala	\N	78	SEM	144	24	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1555	1555	MonThu	45	32	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1565	1914	DHBAEL	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	77	SEM	144	26	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1565	1565	TueThu	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1566	1961	CHYR2	Period1 - SEM1 - MonThu - G  Makwasha	\N	77	SEM	143	\N	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1566	1566	MonThu	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1567	1961	CHYR1	Period1 - SEM1 - MonThu - G  Makwasha	\N	77	SEM	143	\N	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1567	1567	MonThu	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1568	1867	STEL	Period7 - SEM1 - TueThu - Costa  Virgilio	\N	83	SEM	143	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1568	1568	TueThu	45	32	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1571	1950	MTP	Period1 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	77	SEM	144	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1571	1571	MonWedFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1577	1858	HRPUG	Period3 - SEM 2 - TueThu - Costa  Virgilio	\N	79	SEM	144	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1577	1577	TueThu	45	32	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1578	1948	CONTP	Period2 - SEM 2 - MonWedFri - John  Sanni	\N	78	SEM	144	82	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1578	1578	MonWedFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1545	1883	APHIL	Period4 - SEM 2 - TueWedFri - Diddy  Brossala	\N	80	SEM	144	24	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1545	1545	TueWedFri	45	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1564	1911	LAYR1	Period2 - SEM 2 - TueThu - A  Chennells	\N	78	SEM	144	42	YR1	\N	7	Y	Y	Y	N	\N	\N	\N	1564	1564	TueThu	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1563	1904	RAYR1	Period2 - SEM 2 - TueFri - Francis  Zangairai	\N	78	SEM	144	78	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	1563	1563	TueFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1574	1860	FRLS	Period2 - SEM 2 - MonWed - A  Ggita	\N	78	SEM	144	31	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1574	1574	MonWed	45	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1579	1857	LOGIC	Period1 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	77	SEM	144	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1579	1579	MonWedFri	45	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1573	1856	ROA	Period1 - SEM 2 - MonThuFri - Francis  Zangairai	\N	77	SEM	144	78	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1573	1573	MonThuFri	45	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1559	1924	SSAYR2	Period2 - SEM 2 - MonWedFri - Tom  Tom	\N	78	SEM	144	87	YR2	\N	11	Y	Y	Y	N	\N	\N	\N	1559	1559	MonWedFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1560	1920	WHYR2	Period3 - SEM 2 - TueThu - P  Nyambara	\N	79	SEM	144	8	YR2	\N	11	Y	Y	Y	N	\N	\N	\N	1560	1560	TueThu	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1522	1997	OCEPUG3	Period3 - SEM1 - MonWed - John  Stacer	\N	79	SEM	143	50	Seminar	\N	1	Y	Y	Y	N	\N	\N	\N	1522	1522	MonWed	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1552	1991	ESPPUG2	Period4 - SEM1 - TueThu - Lawrence  Daka	\N	80	SEM	143	44	YR3	\N	5	Y	Y	Y	N	\N	\N	\N	1552	1552	TueThu	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1580	1877	ETH	Period2 - SEM 2 - MonWedFri - Olivier  Sempiga	\N	78	SEM	144	38	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1580	1580	MonWedFri	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1531	1990	PON	Period4 - SEM1 - MonFri - Kizito  Kiyimba	\N	80	SEM	143	13	YR3	\N	5	Y	Y	Y	N	\N	\N	\N	1531	1531	MonFri	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1549	2012	PGPUG3	Period4 - SEM1 - MonWed - T  Sherman	\N	80	SEM	143	21	YR4	\N	3	Y	Y	Y	N	\N	\N	\N	1549	1549	MonWed	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1576	1859	POSPUG	Period3 - SEM1 - MonWedFri - Kizito  Kiyimba	\N	79	SEM	143	13	YR3	\N	5	Y	Y	Y	N	\N	\N	\N	1576	1576	MonWedFri	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1546	2031	HMPPUG1	Period2 - SEM 2 - TueThu - T  Sherman	\N	78	SEM	144	21	YR2	\N	13	Y	Y	Y	N	\N	\N	\N	1546	1546	TueThu	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1541	2005	RWPUG1	Period4 - SEM1 - TueThuFri - Francis  Zangairai	\N	80	SEM	143	78	YR2	\N	13	Y	Y	Y	N	\N	\N	\N	1541	1541	TueThuFri	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1553	1869	PEDMA	Period3 - SEM1 - WedFri - C  Nyandoro	\N	79	SEM	143	59	YR1	\N	10	Y	Y	Y	N	\N	\N	\N	1553	1553	WedFri	45	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1550	2047	LPUG1	Period1 - SEM 2 - MonThu - Kizito  Kiyimba	\N	77	SEM	144	13	YR1	\N	13	Y	Y	Y	N	\N	\N	\N	1550	1550	MonThu	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1532	1951	RPYR3	Period1 - SEM1 - MonWedFri - C  Nyandoro	\N	77	SEM	143	59	YR3	\N	15	Y	Y	Y	N	\N	\N	\N	1532	1532	MonWedFri	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1570	1962	ETMA	Period2 - SEM 2 - MonWed - Costa  Virgilio	\N	78	SEM	144	33	YR4	\N	10	Y	Y	Y	N	\N	\N	\N	1570	1570	MonWed	45	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1572	1855	LAWA	Period2 - SEM 2 - MonThu - T  Sherman	\N	78	SEM	144	21	YR3	\N	4	Y	Y	Y	N	\N	\N	\N	1572	1572	MonThu	45	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1542	2016	PSDPUGE	Period4 - SEM 2 - MonTueWedThu - A  Manyere	\N	80	SEM	144	30	Aud Visual	\N	2	Y	Y	Y	N	\N	\N	\N	1542	1542	MonTueWedThu	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1558	1932	PMEYR3	Period3 - SEM 2 - MonFri - C  Nyandoro	\N	79	SEM	144	59	YR3	\N	26	Y	Y	Y	N	\N	\N	\N	1558	1558	MonFri	45	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1592	2024	CTEL	Period5 - SEM1 - TueFri - Diddy  Brossala	\N	81	SEM	143	24	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1592	1592	TueFri	45	30	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1593	2023	JHEL	Period4 - SEM1 - TueFri - Olivier  Sempiga	\N	80	SEM	143	38	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1593	1593	TueFri	45	30	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1594	1884	PAEEL	Period5 - SEM1 - MonFri - A  Ggita	\N	81	SEM	143	31	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1594	1594	MonFri	45	30	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1597	2042	PCMDPT	Period1 - SEM 2 - MonWedFri - A  Mandeya	\N	77	SEM	144	20	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1597	1597	MonWedFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1598	1913	APEL	Period1 - SEM1 - MonTueWedThuFri - Kenneth  Makamure	\N	77	SEM	143	\N	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1598	1598	MonTueWedThuFri	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1600	1893	DEL	Period7 - SEM 2 - WedFri - Olivier  Sempiga	\N	83	SEM	144	38	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1600	1600	WedFri	45	30	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1603	1881	PFR	Period5 - SEM 2 - MonWed - Diddy  Brossala	\N	81	SEM	144	24	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1603	1603	MonWed	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1604	1979	APEL	Period1 - SEM1 - MonTueWedThuFri - Johnny  Stacer	\N	77	SEM	143	\N	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1604	1604	MonTueWedThuFri	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1607	2015	DHPUGE	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	77	SEM	144	26	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1607	1607	TueThu	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1608	1986	GPEL	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	77	SEM	144	26	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1608	1608	TueThu	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1609	1888	BLMA	Period4 - SEM1 - TueFri - John  Stacer	\N	80	SEM	143	50	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1609	1609	TueFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1610	1854	BIOE	Period5 - SEM 2 - MonWed - Costa  Virgilio	\N	81	SEM	144	33	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1610	1610	MonWed	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1611	1853	PCC	Period5 - SEM 2 - MonWed - A  Mandeya	\N	81	SEM	144	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1611	1611	MonWed	45	32	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1612	1879	ASCA	Period5 - SEM 2 - MonWed - Lawrence  Daka	\N	81	SEM	144	44	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1612	1612	MonWed	45	32	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1616	1849	PSDRG	Period5 - SEM 2 - TueFri - A  Manyere	\N	81	SEM	144	30	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1616	1616	TueFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1617	1894	OTS	Period2 - SEM 2 - TueThu - K  Esenther	\N	78	SEM	144	22	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1617	1617	TueThu	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1623	1891	ST	Period6 - SEM1 - MonWed - Costa  Virgilio	\N	82	SEM	143	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1623	1623	MonWed	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1624	1873	PAE	Period4 - SEM1 - MonWedFri - A  Ggita	\N	80	SEM	143	31	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1624	1624	MonWedFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1625	1872	HIVA	Period1 - SEM1 - MonThu - A  Mandeya	\N	77	SEM	143	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1625	1625	MonThu	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1602	1899	FLYR1	Period1 - SEM 2 - MonWedFri - A  Ggita	\N	77	SEM	144	31	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1602	1602	MonWedFri	45	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1622	1939	PPPYR4	Period1 - SEM 2 - MonTueWedThuFri - John  Stacer	\N	77	SEM	144	50	YR4	\N	19	Y	Y	Y	N	\N	\N	\N	1622	1622	MonTueWedThuFri	45	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1615	1887	APHIL	Period4 - SEM 2 - TueWed - Diddy  Brossala	\N	80	SEM	144	24	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1615	1615	TueWed	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1613	1851	HOMP	Period3 - SEM 2 - TueThu - T  Sherman	\N	79	SEM	144	21	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1613	1613	TueThu	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1556	2007	HMPPUG2	Period3 - SEM1 - MonWedFri - T  Sherman	\N	79	SEM	143	21	YR3	\N	5	Y	Y	Y	N	\N	\N	\N	1556	1556	MonWedFri	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1614	1862	LOG	Period3 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	79	SEM	144	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1614	1614	MonWedFri	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1583	1889	PAPUGYR2	Period2 - SEM1 - TueThu - John  Stacer	\N	78	SEM	143	50	YR@	\N	0	Y	Y	Y	N	\N	\N	\N	1583	1583	TueThu	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1586	2008	PLPPUG2	Period4 - SEM1 - TueThuFri - Diddy  Brossala	\N	80	SEM	143	24	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1586	1586	TueThuFri	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1557	1995	NTFPUG3	Period3 - SEM1 - MonTueFri - I  Chidavaenzi	\N	79	SEM	143	18	YR4	\N	1	Y	Y	Y	N	\N	\N	\N	1557	1557	MonTueFri	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1588	1846	EPMA	Period2 - SEM1 - TueThu - Kizito  Kiyimba	\N	78	SEM	143	13	YR1	\N	11	Y	Y	Y	N	\N	\N	\N	1588	1588	TueThu	45	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1589	1968	SPMA	Period1 - SEM1 - MonWed - Costa  Virgilio	\N	77	SEM	143	33	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	1589	1589	MonWed	45	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1606	2040	CTIDPT	Period3 - SEM 2 - MonWedFri - A  Manyere	\N	79	SEM	144	30	YR3	\N	4	Y	Y	Y	N	\N	\N	\N	1606	1606	MonWedFri	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1569	1844	ELEL	Period5 - SEM1 - MonWedFri - Costa  Virgilio	\N	81	SEM	143	33	\N	\N	9	Y	Y	Y	N	\N	\N	\N	1569	1569	MonWedFri	45	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1587	1886	GAEL	Period5 - SEM1 - TueThu - A  Mandeya	\N	81	SEM	143	20	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1587	1587	TueThu	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1575	1878	PMOE	Period2 - SEM 2 - MonFri - C  Nyandoro	\N	78	SEM	144	59	YR3	\N	1	Y	Y	Y	N	\N	\N	\N	1575	1575	MonFri	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1628	1952	EDPT	Period3 - SEM1 - TueThu - Olivier  Sempiga	\N	79	SEM	143	38	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1628	1628	TueThu	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1629	1866	PAEL	Period8 - SEM1 - MonWedFri - A  Ggita	\N	84	SEM	143	31	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	1629	1629	MonWedFri	45	32	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1599	2013	PPPPUG3	Period2 - SEM1 - MonTueWedThuFri - John  Stacer	\N	78	SEM	143	50	Offices	\N	1	Y	Y	Y	N	\N	\N	\N	1599	1599	MonTueWedThuFri	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1619	1970	LPMA	Period3 - SEM1 - TueThu - Diddy  Brossala	\N	79	SEM	143	24	YR4	\N	6	Y	Y	Y	N	\N	\N	\N	1619	1619	TueThu	47	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1638	1943	CMYR1	Period3 - SEM 2 - MonWedFri - A  Zvaiwa	\N	79	SEM	144	51	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1638	1638	MonWedFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1640	2029	BEL	Period1 - SEM 2 - MonWedFri - Costa  Virgilio	\N	77	SEM	144	33	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1640	1640	MonWedFri	45	30	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1596	1906	APYR1	Period4 - SEM 2 - TueFri - Diddy  Brossala	\N	80	SEM	144	24	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1596	1596	TueFri	45	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1595	1901	ENYR1	Period1 - SEM1 - TueThu - K  Esenther	\N	77	SEM	143	22	YR1	\N	7	Y	Y	Y	N	\N	\N	\N	1595	1595	TueThu	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1653	1903	BAFL	Period1 - SEM1 - MonWed - Dominique  Karani	\N	77	SEM	143	54	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	1653	1653	MonWed	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1684	1909	ITYR1	Period5 - SEM1 - MonWed - INTYR2 - John  Sanni	\N	81	SEM	143	83	YR1	\N	3	Y	Y	Y	N	\N	\N	\N	1684	1684	MonWed	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1468	1902	HAYR1	Period2 - SEM1 - MonWedFri - P  Nyambara	\N	78	SEM	143	8	YR1	\N	7	Y	Y	Y	N	\N	\N	\N	1468	1468	MonWedFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1657	1900	LAYR1	Period3 - SEM1 - Wed - A  Chennells	\N	79	SEM	143	42	YR1	\N	7	Y	Y	Y	N	\N	\N	\N	1657	1657	Wed	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1561	1908	LYR1	Period2 - SEM 2 - MonWed - Kizito  Kiyimba	\N	78	SEM	144	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1561	1561	MonWed	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1461	1907	MRYR1	Period2 - SEM1 - TueThu - C  Nyandoro	\N	78	SEM	143	59	YR1	\N	7	Y	Y	Y	N	\N	\N	\N	1461	1461	TueThu	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1636	1916	OCYR1	Period4 - SEM 2 - MonThu - A  Zvaiwa	\N	80	SEM	144	51	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1636	1636	MonThu	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1686	1899	FLYR1	Period1 - SEM 2 - MonFri - Dominique  Karani	\N	77	SEM	144	54	YR1	\N	13	Y	Y	Y	N	\N	\N	\N	1686	1686	MonFri	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1685	1899	FLYR1	Period1 - SEM 2 - MonTue - Dominique  Karani	\N	77	SEM	144	54	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	1685	1685	MonTue	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1562	1910	ENYR1	Period1 - SEM 2 - WedThuFri - K  Esenther	\N	77	SEM	144	22	YR1	\N	7	Y	Y	Y	N	\N	\N	\N	1562	1562	WedThuFri	45	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1687	1904	RAYR1	Period3 - SEM 2 - Fri - Francis  Zangairai	\N	79	SEM	144	78	YR1	\N	14	Y	Y	Y	N	\N	\N	\N	1687	1687	Fri	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1690	1916	OCYR1	Period4 - SEM 2 - TueFri - A  Manyere	\N	80	SEM	144	30	YR1	\N	7	Y	Y	Y	N	\N	\N	\N	1690	1690	TueFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1688	1906	APYR1	Period4 - SEM 2 - TueFri - John  Sanni	\N	80	SEM	144	83	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	1688	1688	TueFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1689	1906	APYR1	Period5 - SEM 2 - MonFri - John  Sanni	\N	81	SEM	144	83	\N	\N	12	Y	Y	Y	N	\N	\N	\N	1689	1689	MonFri	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1635	1978	ALFYR2	Period3 - SEM 2 - MonFri - Dominique  Karani	\N	79	SEM	144	54	YR2	\N	6	Y	Y	Y	N	\N	\N	\N	1635	1635	MonFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1637	2003	EPUG1	Period1 - SEM 2 - MonWed - Costa  Virgilio	\N	77	SEM	144	33	YR2	\N	13	Y	Y	Y	N	\N	\N	\N	1637	1637	MonWed	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1634	1917	WLYR2	Period4 - SEM 2 - TueFri - A  Chennells	\N	80	SEM	144	42	YR2	\N	11	Y	Y	Y	N	\N	\N	\N	1634	1634	TueFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1631	1941	OCTYR4	Period2 - SEM 2 - MonWed - Joseph  Mahlahla	\N	78	SEM	144	79	YR4	\N	19	Y	Y	Y	N	\N	\N	\N	1631	1631	MonWed	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1630	1940	REYR4	Period4 - SEM 2 - TueThu - C  Nyandoro	\N	80	SEM	144	59	YR4	\N	19	Y	Y	Y	N	\N	\N	\N	1630	1630	TueThu	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1639	2027	PCMEL	Period1 - SEM 2 - MonWedFri - A  Mandeya	\N	77	SEM	144	20	YR3	\N	11	Y	Y	Y	N	\N	\N	\N	1639	1639	MonWedFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1621	1845	ISEL	Period6 - SEM1 - TueThu - A  Manyere	\N	82	SEM	143	30	YR4	\N	2	Y	Y	Y	N	\N	\N	\N	1621	1621	TueThu	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1633	1926	EYR2	Period1 - SEM 2 - MonWed - Costa  Virgilio	\N	77	SEM	144	33	YR2	\N	15	Y	Y	Y	N	\N	\N	\N	1633	1633	MonWed	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1693	1963	MAHE	Period1 - SEM 2 - TueFri - John  Stacer	\N	77	SEM	144	50	MAYR	\N	6	Y	Y	Y	N	\N	\N	\N	1693	1693	TueFri	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1692	2072	OSAD	Period1 - SEM 2 - TueFri - Patrick  Ryan	\N	77	SEM	144	84	DYR1	\N	2	Y	Y	Y	N	\N	\N	\N	1692	1692	TueFri	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1691	2071	ATPUG	Period1 - SEM 2 - TueFri - Francis  Zangairai	\N	77	SEM	144	78	DYR1	\N	8	Y	Y	Y	N	\N	\N	\N	1691	1691	TueFri	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1641	1892	PSDRGEL	Period4 - SEM 2 - MonTueWedThu - A  Manyere	\N	80	SEM	144	30	YR1	\N	13	Y	Y	Y	N	\N	\N	\N	1641	1641	MonTueWedThu	45	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1632	1934	OTFYR3	Period3 - SEM 2 - TueThu - I  Chidavaenzi	\N	79	SEM	144	18	YR3	\N	26	Y	Y	Y	N	\N	\N	\N	1632	1632	TueThu	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1620	2022	OCYR4	Period1 - SEM 2 - MonTueWedThuFri - John  Stacer	\N	77	SEM	144	50	YR4	\N	19	Y	Y	Y	N	\N	\N	\N	1620	1620	MonTueWedThuFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1682	1960	HOCTMT	Period4 - SEM1 - TueThu - C  Nyandoro	\N	80	SEM	143	59	YR 3	\N	15	Y	Y	Y	N	\N	\N	\N	1682	1682	TueThu	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1681	1947	HOMP	Period3 - SEM1 - TueThuFri - John  Sanni	\N	79	SEM	143	83	YR2	\N	15	Y	Y	Y	N	\N	\N	\N	1681	1681	TueThuFri	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1699	2078	DFL	Period3 - SEM 2 - TueFri - Kizito  Kiyimba	\N	79	SEM	144	13	DYR3	\N	4	Y	Y	Y	N	\N	\N	\N	1699	1699	TueFri	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1700	2079	COMPS	Period4 - SEM 2 - TueFri - K  Esenther	\N	80	SEM	144	22	DYR3	\N	1	Y	Y	Y	N	\N	\N	\N	1700	1700	TueFri	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1701	2080	MHBT	Period3 - SEM 2 - WedThuFri - John  Sanni	\N	79	SEM	144	83	\N	\N	1	Y	Y	Y	N	\N	\N	\N	1701	1701	WedThuFri	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1702	2081	AFT	Period1 - SEM 2 - MonFri - Francis  Zangairai	\N	77	SEM	144	78	\N	\N	1	Y	Y	Y	N	\N	\N	\N	1702	1702	MonFri	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1703	2082	AQKB	Period2 - SEM1 - MonFri - T  Sherman	\N	78	SEM	143	21	Elective	\N	14	Y	Y	Y	N	\N	\N	\N	1703	1703	MonFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1655	2025	LLEL	Period5 - SEM1 - MonFri - I  Chidavaenzi	\N	81	SEM	143	18	YR3	\N	123	Y	Y	Y	N	\N	\N	\N	1655	1655	MonFri	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1709	2091	PHOR	Period7 - SEM 2 - MonThuFri - Francis  Zangairai	\N	83	SEM	144	78	\N	\N	5	Y	Y	Y	N	\N	\N	\N	1709	1709	MonThuFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1705	2084	HPICK	Period4 - SEM 2 - MonThuFri - Philip  Rossi	\N	80	SEM	144	86	MAYR	\N	3	Y	Y	Y	N	\N	\N	\N	1705	1705	MonThuFri	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1704	2083	HPCIK	Period6 - SEM 2 - MonFri - Philip  Rossi	\N	82	SEM	144	86	Elective	\N	11	Y	Y	Y	N	\N	\N	\N	1704	1704	MonFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1706	2085	HPCIK	Period4 - SEM 2 - MonThu - Philip  Rossi	\N	80	SEM	144	86	PUG	\N	4	Y	Y	Y	N	\N	\N	\N	1706	1706	MonThu	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1707	2087	OIAF	Period5 - SEM 2 - MonFri - Patrick  Ryan	\N	81	SEM	144	84	Elective	\N	12	Y	Y	Y	N	\N	\N	\N	1707	1707	MonFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1708	2089	MHBT	Period6 - SEM 2 - MonThuFri - John  Sanni	\N	82	SEM	144	83	Elective	\N	6	Y	Y	Y	N	\N	\N	\N	1708	1708	MonThuFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1710	2093	PHOR	Period8 - SEM 2 - MonWedThu - Francis  Zangairai	\N	84	SEM	144	78	\N	\N	1	Y	Y	Y	N	\N	\N	\N	1710	1710	MonWedThu	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1711	2095	MFAN	Period5 - SEM 2 - MonTueFri - A  Chennells	\N	81	SEM	144	42	Elective	\N	4	Y	Y	Y	N	\N	\N	\N	1711	1711	MonTueFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1585	1870	HAPPUG1	Period3 - SEM1 - MonWedFri - Costa  Virgilio	\N	79	SEM	143	33	YR1	\N	13	Y	Y	Y	N	\N	\N	\N	1585	1585	MonWedFri	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1713	2097	PHATH	Period8 - SEM1 - TueFri - Costa  Virgilio	\N	84	SEM	143	33	Y2	\N	15	Y	Y	Y	N	\N	\N	\N	1713	1713	TueFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1714	2099	PHATH	Period7 - SEM1 - MonFri - Costa  Virgilio	\N	83	SEM	143	33	\N	\N	13	Y	Y	Y	N	\N	\N	\N	1714	1714	MonFri	43	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1715	1997	OCEPUG3	Period8 - SEM 2 - Mon - John  Stacer	\N	84	SEM	144	50	PUG	\N	2	Y	Y	Y	N	\N	\N	\N	1715	1715	Mon	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1986	2362	ARPH	Period8 - SEM1 - MonTueFri - T  Sherman	\N	92	SEM	148	21	\N	\N	9	Y	Y	Y	N	\N	\N	\N	1986	1986	MonTueFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2038	2391	POLTHEO	Period7 - SEM 2 - WedThuFri - Francis  Zangairai	\N	91	SEM	149	78	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2038	2038	WedThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2031	2339	PCMEL	Period7 - SEM 2 - MonThuFri - A  Mandeya	\N	91	SEM	149	20	\N	\N	4	Y	Y	Y	N	\N	\N	\N	2031	2031	MonThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2016	2382	THGARD	Period8 - SEM 2 - TueWedThuFri - C  Nyandoro	\N	92	SEM	149	59	\N	\N	2	Y	Y	Y	N	\N	\N	\N	2016	2016	TueWedThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1764	2284	MCPPUG2	Period4 - SEM 2 - MonWed - T  Sherman	\N	88	SEM	149	21	YR3	\N	11	Y	Y	Y	N	\N	\N	\N	1764	1764	MonWed	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1832	2283	CPPUG2	Period2 - SEM 2 - MonWedFri - Costa  Virgilio	\N	86	SEM	149	33	YR3	\N	10	Y	Y	Y	N	\N	\N	\N	1832	1832	MonWedFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1855	2276	SSAYR2	Period2 - SEM 2 - MonWedFri - Kenneth  Makamure	\N	86	SEM	149	56	YR2	\N	6	Y	Y	Y	N	\N	\N	\N	1855	1855	MonWedFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2002	2372	INTROPOL	Period4 - SEM 2 - MonTueWedThuFri - Rachael   Rufu	\N	88	SEM	149	90	\N	\N	1	Y	Y	Y	N	\N	\N	\N	2002	2002	MonTueWedThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1992	2239	METAPH	Period8 - SEM 2 - MonThuFri - T  Sherman	\N	92	SEM	149	21	\N	\N	7	Y	Y	Y	N	\N	\N	\N	1992	1992	MonThuFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1918	2184	LYR1	Period2 - SEM 2 - MonWed - Henry  Ibekwe	\N	86	SEM	149	89	YR1	\N	12	Y	Y	Y	N	\N	\N	\N	1918	1918	MonWed	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1927	2182	APYR1	Period5 - SEM 2 - MonFri - Amadeus  Shirima	\N	89	SEM	149	88	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1927	1927	MonFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1926	2182	APYR1	Period4 - SEM 2 - TueFri - Amadeus  Shirima	\N	88	SEM	149	88	YR1	\N	13	Y	Y	Y	N	\N	\N	\N	1926	1926	TueFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1912	2182	APYR1	Period4 - SEM 2 - TueFri - Amadeus  Shirima	\N	88	SEM	149	88	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1912	1912	TueFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1952	2334	HPCIK	Period6 - SEM1 - MonFri - Costa  Virgilio	\N	90	SEM	148	33	Elective	\N	1	Y	Y	Y	N	\N	\N	\N	1952	1952	MonFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1978	2357	ACHEBE	Period6 - SEM1 - MonTueThuFri - A  Chennells	\N	90	SEM	148	42	\N	\N	6	Y	Y	Y	N	\N	\N	\N	1978	1978	MonTueThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1975	2355	PFDS	Period5 - SEM1 - MonTueThu - John  Stacer	\N	89	SEM	148	50	\N	\N	6	Y	Y	Y	N	\N	\N	\N	1975	1975	MonTueThu	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1790	2204	PLYR3	Period2 - SEM1 - MonWedFri - Costa  Virgilio	\N	86	SEM	148	33	YR3	\N	15	Y	Y	Y	N	\N	\N	\N	1790	1790	MonWedFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1839	2271	POM	Period2 - SEM1 - MonWedFri - John  Stacer	\N	86	SEM	148	50	YR2	\N	10	Y	Y	Y	N	\N	\N	\N	1839	1839	MonWedFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1970	2252	ALFYR2	Period8 - SEM1 - MonThuFri - Dominique  Karani	\N	92	SEM	148	54	Y2	\N	3	Y	Y	Y	N	\N	\N	\N	1970	1970	MonThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1951	2335	HPICK	Period4 - SEM1 - MonThuFri - Costa  Virgilio	\N	88	SEM	148	33	MAYR	\N	2	Y	Y	Y	N	\N	\N	\N	1951	1951	MonThuFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1963	2181	VT2YR1	Period6 - SEM1 - MonThuFri - Joseph  Mahlahla	\N	90	SEM	148	79	YR1	\N	1	Y	Y	Y	N	\N	\N	\N	1963	1963	MonThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1782	2185	ITYR1	Period5 - SEM1 - MonWed - T  Sherman	\N	89	SEM	148	21	YR1	\N	10	Y	Y	Y	N	\N	\N	\N	1782	1782	MonWed	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1914	2179	BAFL	Period1 - SEM1 - MonWed - Dominique  Karani	\N	85	SEM	148	54	YR1	\N	8	Y	Y	Y	N	\N	\N	\N	1914	1914	MonWed	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2017	2337	OIAF	Period8 - SEM 2 - MonThuFri - Patrick  Ryan	\N	92	SEM	149	84	\N	\N	1	Y	Y	Y	N	\N	\N	\N	2017	2017	MonThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2003	2373	RETREAT	Period8 - SEM 2 - MonWedFri - A  Manyere	\N	92	SEM	149	30	\N	\N	13	Y	Y	Y	N	\N	\N	\N	2003	2003	MonWedFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1987	2357	ACHEBE	Period8 - SEM1 - MonThuFri - A  Chennells	\N	92	SEM	148	42	\N	\N	1	Y	Y	Y	N	\N	\N	\N	1987	1987	MonThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1971	2353	GREEK	Period7 - SEM1 - TueFri - A  Chennells	\N	91	SEM	148	42	Y2	\N	12	Y	Y	Y	N	\N	\N	\N	1971	1971	TueFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1717	2115	PLS	Period6 - SEM1 - MonWed - Costa  Virgilio	\N	90	SEM	148	33	YR 3	\N	0	Y	Y	Y	N	\N	\N	\N	1717	1717	MonWed	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1718	2117	WLPUG	Period1 - SEM1 - MonWed - A  Chennells	\N	85	SEM	148	42	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1718	1718	MonWed	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1719	2248	APMA	Period4 - SEM1 - MonThu - A  Chennells	\N	88	SEM	148	42	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1719	1719	MonThu	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1720	2319	SLS	Period6 - SEM1 - TueFri - Costa  Virgilio	\N	90	SEM	148	33	YR 3	\N	0	Y	Y	Y	N	\N	\N	\N	1720	1720	TueFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1721	2310	APDPT	Period2 - SEM 2 - TueThuFri - Diddy  Brossala	\N	86	SEM	149	24	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1721	1721	TueThuFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1722	2252	ALFYR2	Period3 - SEM1 - TueFri - Dominique  Karani	\N	87	SEM	148	54	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	1722	1722	TueFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1723	2140	ASCAEL	Period6 - SEM 2 - MonWed - Lawrence  Daka	\N	90	SEM	149	44	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1723	1723	MonWed	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1724	2295	FAEPUGE	Period1 - SEM 2 - Mon - T  Sherman	\N	85	SEM	149	21	Offices	\N	0	Y	Y	Y	N	\N	\N	\N	1724	1724	Mon	49	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1725	2291	IPLPUGE	Period1 - SEM 2 - MonWedFri - T  Sherman	\N	85	SEM	149	21	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	1725	1725	MonWedFri	49	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1726	2273	BPUGE	Period1 - SEM1 - TueThu - Costa  Virgilio	\N	85	SEM	148	33	Seminar	\N	6	Y	Y	Y	N	\N	\N	\N	1726	1726	TueThu	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1727	2153	POSMA	Period4 - SEM 2 - WedFri - Kizito  Kiyimba	\N	88	SEM	149	13	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	1727	1727	WedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1728	2174	SKEL	Period6 - SEM1 - MonWedFri - Diddy  Brossala	\N	90	SEM	148	24	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1728	1728	MonWedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1729	2173	BLEL	Period6 - SEM1 - MonThu - John  Stacer	\N	90	SEM	148	50	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1729	1729	MonThu	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1730	2123	AIEL	Period1 - SEM1 - WedFri - A  Chennells	\N	85	SEM	148	42	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1730	1730	WedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1731	2221	HMP	Period4 - SEM1 - MonWed - A  Ggita	\N	88	SEM	148	31	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1731	1731	MonWed	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1732	2234	HCT	Period2 - SEM1 - MonWedFri - C  Nyandoro	\N	86	SEM	148	59	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1732	1732	MonWedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1733	2107	FL	Period7 - SEM1 - TueThu - Kizito  Kiyimba	\N	91	SEM	148	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1733	1733	TueThu	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1734	2105	HOAP	Period2 - SEM1 - TueThu - T  Sherman	\N	86	SEM	148	21	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1734	1734	TueThu	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1735	2278	FLPUG1	Period1 - SEM1 - MonWed - Dominique  Karani	\N	85	SEM	148	54	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1735	1735	MonWed	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1736	2103	POL	Period5 - SEM1 - MonWedFri - Francis  Zangairai	\N	89	SEM	148	78	YR 1	\N	0	Y	Y	Y	N	\N	\N	\N	1736	1736	MonWedFri	51	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1737	2104	TTEL	Period6 - SEM1 - TueThu - Costa  Virgilio	\N	90	SEM	148	33	YR 3	\N	0	Y	Y	Y	N	\N	\N	\N	1737	1737	TueThu	51	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1738	2110	POR	Period5 - SEM1 - MonWedFri - Francis  Zangairai	\N	89	SEM	148	78	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1738	1738	MonWedFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1739	2112	FRLS	Period1 - SEM1 - MonWed - Dominique  Karani	\N	85	SEM	148	54	YR 1	\N	0	Y	Y	Y	N	\N	\N	\N	1739	1739	MonWed	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2033	2388	INTROPEACE	Period7 - SEM 2 - MonThuFri - A  Mandeya	\N	91	SEM	149	20	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2033	2033	MonThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2018	2358	ISLAM	Period8 - SEM 2 - WedThuFri - Francis  Zangairai	\N	92	SEM	149	78	\N	\N	1	Y	Y	Y	N	\N	\N	\N	2018	2018	WedThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2004	2374	CONTLit	Period6 - SEM 2 - MonFri - A  Chennells	\N	90	SEM	149	42	\N	\N	8	Y	Y	Y	N	\N	\N	\N	2004	2004	MonFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1988	2363	HIVAIDS	Period8 - SEM1 - MonThuFri - A  Mandeya	\N	92	SEM	148	20	\N	\N	1	Y	Y	Y	N	\N	\N	\N	1988	1988	MonThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1972	2194	RWYR2	Period7 - SEM1 - MonThuFri - Francis  Zangairai	\N	91	SEM	148	78	\N	\N	10	Y	Y	Y	N	\N	\N	\N	1972	1972	MonThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1740	2114	MRS	Period1 - SEM1 - TueThu - C  Nyandoro	\N	85	SEM	148	59	YR 1	\N	0	Y	Y	Y	N	\N	\N	\N	1740	1740	TueThu	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1741	2118	SLS	Period6 - SEM1 - TueThu - teacher  teacher	\N	90	SEM	148	28	YR 1	\N	0	Y	Y	Y	N	\N	\N	\N	1741	1741	TueThu	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1742	2121	ITBL	Period5 - SEM1 - TueFri - A  Chennells	\N	89	SEM	148	42	YR 3	\N	0	Y	Y	Y	N	\N	\N	\N	1742	1742	TueFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1743	2326	MAISLAM	Period3 - SEM 2 - Mon - Patrick  Ryan	\N	87	SEM	149	84	MAYR	\N	0	Y	Y	Y	N	\N	\N	\N	1743	1743	Mon	51	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1744	2327	PHIH	Period4 - SEM 2 - Wed - C  Nyandoro	\N	88	SEM	149	59	MAYR	\N	5	Y	Y	Y	N	\N	\N	\N	1744	1744	Wed	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1745	2328	PHMA	Period5 - SEM 2 - MonThu - T  Sherman	\N	89	SEM	149	21	MAYR	\N	6	Y	Y	Y	N	\N	\N	\N	1745	1745	MonThu	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1746	2120	PTP	Period5 - SEM 2 - WedFri - Kizito  Kiyimba	\N	89	SEM	149	13	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1746	1746	WedFri	51	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1747	2320	APEL	Period1 - SEM1 - MonTueWedThuFri - A  Chennells	\N	85	SEM	148	42	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1747	1747	MonTueWedThuFri	51	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1748	2122	POR	Period5 - SEM1 - MonWedFri - Francis  Zangairai	\N	89	SEM	148	78	YR 1	\N	0	Y	Y	Y	N	\N	\N	\N	1748	1748	MonWedFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1749	2126	PLS	Period5 - SEM1 - TueThu - Costa  Virgilio	\N	89	SEM	148	33	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1749	1749	TueThu	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1750	2321	FL	Period7 - SEM1 - TueThu - Kizito  Kiyimba	\N	91	SEM	148	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1750	1750	TueThu	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1752	2108	AQLKB	Period5 - SEM1 - MonWedFri - T  Sherman	\N	89	SEM	148	21	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1752	1752	MonWedFri	51	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1753	2111	LOM	Period7 - SEM1 - TueThu - A  Chennells	\N	91	SEM	148	42	YR 3	\N	0	Y	Y	Y	N	\N	\N	\N	1753	1753	TueThu	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1754	2116	PTP	Period5 - SEM1 - MonWed - Kizito  Kiyimba	\N	89	SEM	148	13	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1754	1754	MonWed	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1755	2323	FLPUG1	Period1 - SEM 2 - MonWedFri - A  Ggita	\N	85	SEM	149	31	DIP YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1755	1755	MonWedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1756	2200	PTDYR2	Period4 - SEM1 - MonWedFri - A  Manyere	\N	88	SEM	148	30	YR2	\N	11	Y	Y	Y	N	\N	\N	\N	1756	1756	MonWedFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1758	2194	RWYR2	Period3 - SEM1 - MonWedFri - Francis  Zangairai	\N	87	SEM	148	78	YR2	\N	11	Y	Y	Y	N	\N	\N	\N	1758	1758	MonWedFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1760	2210	APYR4	Period3 - SEM1 - MonWedFri - John  Sanni	\N	87	SEM	148	83	YR3	\N	26	Y	Y	Y	N	\N	\N	\N	1760	1760	MonWedFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1761	2211	EHYR4	Period2 - SEM1 - MonWed - John  Stacer	\N	86	SEM	148	50	YR4	\N	26	Y	Y	Y	N	\N	\N	\N	1761	1761	MonWed	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1762	2269	REPUG3	Period3 - SEM 2 - MonWedFri - C  Nyandoro	\N	87	SEM	149	59	YR4	\N	10	Y	Y	Y	N	\N	\N	\N	1762	1762	MonWedFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1763	2293	PCMPUGE	Period1 - SEM1 - TueThu - A  Mandeya	\N	85	SEM	148	20	DIP YR1	\N	3	Y	Y	Y	N	\N	\N	\N	1763	1763	TueThu	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1819	2309	FAEL	Period1 - SEM 2 - Wed - T  Sherman	\N	85	SEM	149	21	Y4	\N	0	Y	Y	Y	N	\N	\N	\N	1819	1819	Wed	48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2019	2383	PHMATH	Period7 - SEM 2 - MonTueWedThuFri - Henry  Ibekwe	\N	91	SEM	149	89	\N	\N	2	Y	Y	Y	N	\N	\N	\N	2019	2019	MonTueWedThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2005	2375	PEOPLES	Period6 - SEM 2 - MonTueFri - O  Kufakurinane	\N	90	SEM	149	91	\N	\N	7	Y	Y	Y	N	\N	\N	\N	2005	2005	MonTueFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1989	2364	PHWR	Period8 - SEM1 - MonTueFri - C  Nyandoro	\N	92	SEM	148	59	\N	\N	3	Y	Y	Y	N	\N	\N	\N	1989	1989	MonTueFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1973	2196	APYR2	Period7 - SEM1 - MonThuFri - Costa  Virgilio	\N	91	SEM	148	33	\N	\N	10	Y	Y	Y	N	\N	\N	\N	1973	1973	MonThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1765	2212	PGYR4	Period4 - SEM1 - MonWedFri - T  Sherman	\N	88	SEM	148	21	YR4	\N	26	Y	Y	Y	N	\N	\N	\N	1765	1765	MonWedFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1766	2158	DEMC	Period6 - SEM 2 - TueThu - Olivier  Sempiga	\N	90	SEM	149	38	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1766	1766	TueThu	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1767	2256	STEL	Period5 - SEM1 - MonThu - Costa  Virgilio	\N	89	SEM	148	33	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	1767	1767	MonThu	48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1768	2263	SSAPUG1	Period1 - SEM 2 - MonWedThu - Ben  Sachikonye	\N	85	SEM	149	37	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1768	1768	MonWedThu	49	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1769	2275	RAPUG1	Period1 - SEM 2 - MonThuFri - Francis  Zangairai	\N	85	SEM	149	78	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1769	1769	MonThuFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1770	2255	GAAPH	Period1 - SEM1 - MonTueWedThuFri - Ujah  Ejembi	\N	85	SEM	148	26	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1770	1770	MonTueWedThuFri	48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1771	2313	IDDPT	Period4 - SEM 2 - TueThuFri - C  Nyandoro	\N	88	SEM	149	59	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1771	1771	TueThuFri	49	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1772	2228	PRYR2	Period2 - SEM1 - MonFri - T  Sherman	\N	86	SEM	148	21	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1772	1772	MonFri	48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1773	2229	IOTYR1	Period2 - SEM1 - Wed - Zvaiwa  Zvaiwa	\N	86	SEM	148	\N	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1773	1773	Wed	48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1774	2219	IPYR1	Period1 - SEM1 - TueThu - A  Ggita	\N	85	SEM	148	31	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1774	1774	TueThu	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1775	2307	DPTEL	Period2 - SEM1 - TueThu - A  Mandeya	\N	86	SEM	148	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1775	1775	TueThu	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1776	2217	CMYR1	Period1 - SEM1 - MonWedFri - C  Nyandoro	\N	85	SEM	148	59	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1776	1776	MonWedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1777	2229	IOTYR1	Period2 - SEM1 - WedFri - Zvaiwa  Zvaiwa	\N	86	SEM	148	\N	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1777	1777	WedFri	48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1778	2220	HAYR1	Period3 - SEM1 - TueFri - C  Matusse	\N	87	SEM	148	19	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1778	1778	TueFri	48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1779	2231	NTYR3	Period2 - SEM1 - TueThu - A  Mandeya	\N	86	SEM	148	20	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1779	1779	TueThu	48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1780	2317	HRs	Period1 - SEM1 - Mon - Costa  Virgilio	\N	85	SEM	148	33	Office	\N	0	Y	Y	Y	N	\N	\N	\N	1780	1780	Mon	48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1781	2294	APPUGE	Period1 - SEM 2 - Mon - A  Perumalil	\N	85	SEM	149	9	Offices	\N	0	Y	Y	Y	N	\N	\N	\N	1781	1781	Mon	49	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1783	2196	APYR2	Period1 - SEM1 - TueThu - Costa  Virgilio	\N	85	SEM	148	33	YR2	\N	11	Y	Y	Y	N	\N	\N	\N	1783	1783	TueThu	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1784	2102	HMPYR2	Period2 - SEM 2 - TueWedFri - T  Sherman	\N	86	SEM	149	21	YR2	\N	11	Y	Y	Y	N	\N	\N	\N	1784	1784	TueWedFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1785	2193	WLYR2	Period4 - SEM1 - TueThu - A  Chennells	\N	88	SEM	148	42	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1785	1785	TueThu	48	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1786	2213	NTYR4	Period3 - SEM1 - TueThu - I  Chidavaenzi	\N	87	SEM	148	18	YR4	\N	26	Y	Y	Y	N	\N	\N	\N	1786	1786	TueThu	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1787	2205	ESYR3	Period3 - SEM1 - MonThuFri - Lawrence  Daka	\N	87	SEM	148	44	YR3	\N	15	Y	Y	Y	N	\N	\N	\N	1787	1787	MonThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	414	761	HMPPUG2	Period3 - SEM1 - MonWedFri - T  Sherman	\N	7	SEM	33	21	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	414	414	MonWedFri	53	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2035	2389	CONFMANG	Period7 - SEM 2 - MonTueFri - A  Mandeya	\N	91	SEM	149	20	\N	\N	1	Y	Y	Y	N	\N	\N	\N	2035	2035	MonTueFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2020	2384	MLOGIC	Period7 - SEM 2 - MonTueFri - Kizito  Kiyimba	\N	91	SEM	149	13	\N	\N	1	Y	Y	Y	N	\N	\N	\N	2020	2020	MonTueFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2006	2253	ALFPUG	Period7 - SEM 2 - MonThuFri - Dominique  Karani	\N	91	SEM	149	54	\N	\N	3	Y	Y	Y	N	\N	\N	\N	2006	2006	MonThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1990	2365	ARGWR	Period8 - SEM 2 - MonFri - K  Esenther	\N	92	SEM	149	22	\N	\N	9	Y	Y	Y	N	\N	\N	\N	1990	1990	MonFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1788	2202	HMYR3	Period4 - SEM1 - TueThu - T  Sherman	\N	88	SEM	148	21	YR3	\N	13	Y	Y	Y	N	\N	\N	\N	1788	1788	TueThu	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1791	2266	OFPUG2	Period3 - SEM 2 - WedFri - I  Chidavaenzi	\N	87	SEM	149	18	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1791	1791	WedFri	49	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1792	2130	ROA	Period1 - SEM 2 - MonThuFri - Francis  Zangairai	\N	85	SEM	149	78	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1792	1792	MonThuFri	50	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1793	2272	ICSPUGE	Period1 - SEM 2 - MonWedFri - K  Esenther	\N	85	SEM	149	22	Computer	\N	0	Y	Y	Y	N	\N	\N	\N	1793	1793	MonWedFri	49	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1794	2300	IGSP	Period1 - SEM1 - TueFri - A  Manyere	\N	85	SEM	148	30	YR3	\N	17	Y	Y	Y	N	\N	\N	\N	1794	1794	TueFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1795	2228	PRYR2	Period2 - SEM 2 - MonFri - Francis  Zangairai	\N	86	SEM	149	78	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1795	1795	MonFri	51	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1796	2257	APEL	Period6 - SEM1 - MonTueWedThuFri - A  Mandeya	\N	90	SEM	148	20	YR3	\N	10	Y	Y	Y	N	\N	\N	\N	1796	1796	MonTueWedThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1797	2208	MCPYR3	Period3 - SEM 2 - MonTue - T  Sherman	\N	87	SEM	149	21	YR3	\N	14	Y	Y	Y	N	\N	\N	\N	1797	1797	MonTue	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1798	2128	PCCEL	Period5 - SEM 2 - MonWedFri - A  Mandeya	\N	89	SEM	149	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1798	1798	MonWedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1799	2258	DPTEL	Period2 - SEM1 - TueThu - T  Sherman	\N	86	SEM	148	21	DP	\N	0	Y	Y	Y	N	\N	\N	\N	1799	1799	TueThu	48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1800	2306	DPTEL	Period2 - SEM1 - TueThu - Kenneth  Makamure	\N	86	SEM	148	\N	DP	\N	0	Y	Y	Y	N	\N	\N	\N	1800	1800	TueThu	48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1801	2167	SPP	Period3 - SEM1 - TueFri - Diddy  Brossala	\N	87	SEM	148	24	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1801	1801	TueFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1802	2280	PTDPUG1	Period3 - SEM1 - MonWedFri - A  Manyere	\N	87	SEM	148	30	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1802	1802	MonWedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1803	2163	FFEL	Period5 - SEM1 - MonWed - Diddy  Brossala	\N	89	SEM	148	24	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1803	1803	MonWed	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1804	2274	HRPUGE	Period1 - SEM 2 - MonWedFri - Costa  Virgilio	\N	85	SEM	149	33	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	1804	1804	MonWedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1805	2100	FLS	Period1 - SEM1 - MonWed - Dominique  Karani	\N	85	SEM	148	54	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1805	1805	MonWed	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1806	2251	ATYR2	Period1 - SEM1 - MonWedFri - A  Mandeya	\N	85	SEM	148	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1806	1806	MonWedFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1807	2308	DPTEL	Period2 - SEM1 - TueThu - Johnny  Stacer	\N	86	SEM	148	\N	DP	\N	0	Y	Y	Y	N	\N	\N	\N	1807	1807	TueThu	48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1808	2305	APEL	Period1 - SEM1 - MonTueWedThuFri - Lawrence  Daka	\N	85	SEM	148	\N	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1808	1808	MonTueWedThuFri	48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1809	2303	PFEL	Period1 - SEM 2 - MonWedFri - Diddy  Brossala	\N	85	SEM	149	24	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1809	1809	MonWedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1810	2154	PCC	Period6 - SEM 2 - TueWedFri - A  Mandeya	\N	90	SEM	149	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1810	1810	TueWedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1811	2233	HCTPDPT	Period2 - SEM 2 - TueThu - C  Nyandoro	\N	86	SEM	149	59	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1811	1811	TueThu	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1812	2318	ICSDPT	Period2 - SEM 2 - TueThu - K  Esenther	\N	86	SEM	149	22	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1812	1812	TueThu	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	26	394	APYR4	Period3 - SEM1 - MonWedFri - Diddy  Brossala	\N	7	SEM	33	24	YR3	\N	25	Y	Y	Y	N	\N	\N	\N	26	26	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2036	2390	INTROHRIGH	Period7 - SEM 2 - MonTueWedThuFri - Kirenga  Kirenga	\N	91	SEM	149	93	\N	\N	18	Y	Y	Y	N	\N	\N	\N	2036	2036	MonTueWedThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2021	2110	POR	Period8 - SEM 2 - MonTueWedThuFri - Francis  Zangairai	\N	92	SEM	149	78	\N	\N	4	Y	Y	Y	N	\N	\N	\N	2021	2021	MonTueWedThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2007	2376	METHEDU	Period7 - SEM 2 - MonTueFri - C  Nyandoro	\N	91	SEM	149	59	\N	\N	10	Y	Y	Y	N	\N	\N	\N	2007	2007	MonTueFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1991	2184	LYR1	Period8 - SEM 2 - WedThuFri - Henry  Ibekwe	\N	92	SEM	149	89	\N	\N	10	Y	Y	Y	N	\N	\N	\N	1991	1991	WedThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1813	2232	ITDPT	Period1 - SEM1 - MonWedFri - K  Esenther	\N	85	SEM	148	22	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1813	1813	MonWedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1814	2230	INTDPT	Period3 - SEM 2 - MonThuFri - A  Mandeya	\N	87	SEM	149	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1814	1814	MonThuFri	48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1815	2292	PFPUGE	Period1 - SEM 2 - MonWedFri - Diddy  Brossala	\N	85	SEM	149	24	Aud Visual	\N	0	Y	Y	Y	N	\N	\N	\N	1815	1815	MonWedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1816	2317	HRs	Period3 - SEM 2 - MonWedFri - Costa  Virgilio	\N	87	SEM	149	33	Aud Visual	\N	0	Y	Y	Y	N	\N	\N	\N	1816	1816	MonWedFri	48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1817	2316	DHDPT	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	85	SEM	149	26	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1817	1817	TueThu	48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1818	2315	HRDPT	Period1 - SEM 2 - TueThuFri - Costa  Virgilio	\N	85	SEM	149	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1818	1818	TueThuFri	48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1820	2191	PLEL	Period1 - SEM 2 - MonWedFri - T  Sherman	\N	85	SEM	149	21	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1820	1820	MonWedFri	48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1821	2261	RSFANEL	Period1 - SEM 2 - MonWedFri - A  Chennells	\N	85	SEM	149	42	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1821	1821	MonWedFri	49	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1822	2132	APHIL	Period4 - SEM1 - TueWed - Diddy  Brossala	\N	88	SEM	148	24	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1822	1822	TueWed	51	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1824	2172	LOG	Period3 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	87	SEM	149	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1824	1824	MonWedFri	50	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1825	2288	OCTPUG3	Period3 - SEM 2 - WedFri - Joseph  Mahlahla	\N	87	SEM	149	79	YR4	\N	10	Y	Y	Y	N	\N	\N	\N	1825	1825	WedFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1826	2231	NTYR2	Period1 - SEM1 - TueThu - K  Esenther	\N	85	SEM	148	22	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1826	1826	TueThu	51	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1827	2127	POE	Period3 - SEM 2 - TueThu - A  Zvaiwa	\N	87	SEM	149	51	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1827	1827	TueThu	51	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1828	2224	EPDPT	Period3 - SEM 2 - MonWedFri - Costa  Virgilio	\N	87	SEM	149	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1828	1828	MonWedFri	51	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1829	2311	IEDPT	Period1 - SEM 2 - WedThuFri - A  Mandeya	\N	85	SEM	149	20	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1829	1829	WedThuFri	51	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1830	2144	LLEL	Period2 - SEM1 - MonWedFri - I  Chidavaenzi	\N	86	SEM	148	18	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1830	1830	MonWedFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1831	2301	ICSPEL	Period1 - SEM 2 - MonWedFri - K  Esenther	\N	85	SEM	149	22	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1831	1831	MonWedFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1833	2147	BAPRE	Period4 - SEM 2 - TueThu - A  Zvaiwa	\N	88	SEM	149	51	\N	\N	4	Y	Y	Y	N	\N	\N	\N	1833	1833	TueThu	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1835	2143	KEL	Period5 - SEM1 - TueThu - Diddy  Brossala	\N	89	SEM	148	24	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1835	1835	TueThu	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1836	2259	IPPUG1	Period3 - SEM1 - MonThu - John  Sanni	\N	87	SEM	148	83	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1836	1836	MonThu	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1837	2285	SAPPUG3	Period2 - SEM1 - MonWedThu - John  Sanni	\N	86	SEM	148	83	YR4	\N	5	Y	Y	Y	N	\N	\N	\N	1837	1837	MonWedThu	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1838	2267	EHPUG3	Period2 - SEM1 - TueThu - John  Stacer	\N	86	SEM	148	50	YR4	\N	6	Y	Y	Y	N	\N	\N	\N	1838	1838	TueThu	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1929	2277	EPUG1	Period1 - SEM 2 - MonWed - Amadeus  Shirima	\N	85	SEM	149	88	YR2	\N	10	Y	Y	Y	N	\N	\N	\N	1929	1929	MonWed	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1935	2201	EYR2	Period1 - SEM 2 - MonWed - Amadeus  Shirima	\N	85	SEM	149	88	YR2	\N	11	Y	Y	Y	N	\N	\N	\N	1935	1935	MonWed	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1920	2113	OCYR1	Period4 - SEM 2 - MonThu - A  Manyere	\N	88	SEM	149	30	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	1920	1920	MonThu	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1884	2133	PCC	Period5 - SEM 2 - MonWed - A  Mandeya	\N	89	SEM	149	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1884	1884	MonWed	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1871	2207	PMEYR3	Period3 - SEM 2 - MonFri - Pacey  Pacey	\N	87	SEM	149	92	YR3	\N	24	Y	Y	Y	N	\N	\N	\N	1871	1871	MonFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1823	2265	PMEPUG2	Period3 - SEM 2 - TueWedThu - Pacey  Pacey	\N	87	SEM	149	92	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1823	1823	TueWedThu	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1789	2206	CPYR3	Period2 - SEM 2 - MonWed - T  Sherman	\N	86	SEM	149	21	YR3	\N	14	Y	Y	Y	N	\N	\N	\N	1789	1789	MonWed	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1759	2203	PSYR3	Period4 - SEM1 - MonThu - Kizito  Kiyimba	\N	88	SEM	148	13	YR3	\N	15	Y	Y	Y	N	\N	\N	\N	1759	1759	MonThu	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1751	2109	DISSER	Period5 - SEM1 - MonWedThu - Costa  Virgilio	\N	89	SEM	148	33	MYA	\N	12	Y	Y	Y	N	\N	\N	\N	1751	1751	MonWedThu	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2022	2385	SCIEREL	Period7 - SEM 2 - WedFri - Costa  Virgilio	\N	91	SEM	149	33	\N	\N	3	Y	Y	Y	N	\N	\N	\N	2022	2022	WedFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2008	2376	METHEDU	Period1 - SEM 2 - MonTueWedThu - C  Nyandoro	\N	85	SEM	149	59	\N	\N	16	Y	Y	Y	N	\N	\N	\N	2008	2008	MonTueWedThu	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1921	2175	FLYR1	Period1 - SEM 2 - MonFri - Dominique  Karani	\N	85	SEM	149	54	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	1921	1921	MonFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1974	2354	PFDS	Period7 - SEM1 - MonTueFri - John  Stacer	\N	91	SEM	148	50	\N	\N	26	Y	Y	Y	N	\N	\N	\N	1974	1974	MonTueFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1716	2106	MRS	Period1 - SEM1 - TueThu - C  Nyandoro	\N	85	SEM	148	59	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1716	1716	TueThu	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1840	2197	APPUG1	Period2 - SEM 2 - MonThu - Diddy  Brossala	\N	86	SEM	149	24	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1840	1840	MonThu	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1841	2190	DHBAEL	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	85	SEM	149	26	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1841	1841	TueThu	48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1842	2236	CHYR2	Period1 - SEM1 - MonThu - G  Makwasha	\N	85	SEM	148	\N	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1842	1842	MonThu	48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1843	2236	CHYR1	Period1 - SEM1 - MonThu - G  Makwasha	\N	85	SEM	148	\N	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1843	1843	MonThu	48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1844	2146	STEL	Period7 - SEM1 - TueThu - Costa  Virgilio	\N	91	SEM	148	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1844	1844	TueThu	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1845	2225	MTP	Period1 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	85	SEM	149	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1845	1845	MonWedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1846	2138	HRPUG	Period3 - SEM 2 - TueThu - Costa  Virgilio	\N	87	SEM	149	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1846	1846	TueThu	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1847	2223	CONTP	Period2 - SEM 2 - MonWedFri - John  Sanni	\N	86	SEM	149	\N	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1847	1847	MonWedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1848	2262	APEL	Period1 - SEM 2 - Wed - A  Perumalil	\N	85	SEM	149	9	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	1848	1848	Wed	48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1849	2161	APHIL	Period4 - SEM 2 - TueWedFri - Diddy  Brossala	\N	88	SEM	149	24	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1849	1849	TueWedFri	50	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1850	2187	LAYR1	Period2 - SEM 2 - TueThu - A  Chennells	\N	86	SEM	149	42	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	1850	1850	TueThu	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1851	2180	RAYR1	Period2 - SEM 2 - TueFri - Francis  Zangairai	\N	86	SEM	149	78	YR1	\N	14	Y	Y	Y	N	\N	\N	\N	1851	1851	TueFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1852	2139	FRLS	Period2 - SEM 2 - MonWed - A  Ggita	\N	86	SEM	149	31	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1852	1852	MonWed	50	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1856	2195	WHYR2	Period3 - SEM 2 - TueThu - P  Nyambara	\N	87	SEM	149	8	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1856	1856	TueThu	51	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1857	2270	OCEPUG3	Period3 - SEM 2 - MonWed - John  Stacer	\N	87	SEM	149	50	Seminar	\N	6	Y	Y	Y	N	\N	\N	\N	1857	1857	MonWed	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1858	2264	ESPPUG2	Period4 - SEM1 - TueThu - Lawrence  Daka	\N	88	SEM	148	44	YR3	\N	12	Y	Y	Y	N	\N	\N	\N	1858	1858	TueThu	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1859	2155	ETH	Period2 - SEM 2 - MonWedFri - Olivier  Sempiga	\N	86	SEM	149	38	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1859	1859	MonWedFri	50	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1860	2119	PON	Period4 - SEM1 - MonFri - Kizito  Kiyimba	\N	88	SEM	148	13	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1860	1860	MonFri	50	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1861	2286	PGPUG3	Period4 - SEM1 - MonWed - T  Sherman	\N	88	SEM	148	21	YR4	\N	5	Y	Y	Y	N	\N	\N	\N	1861	1861	MonWed	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1862	2198	POSPUG	Period3 - SEM1 - MonWedFri - Kizito  Kiyimba	\N	87	SEM	148	13	YR3	\N	13	Y	Y	Y	N	\N	\N	\N	1862	1862	MonWedFri	51	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1863	2304	HMPPUG1	Period2 - SEM 2 - TueThu - T  Sherman	\N	86	SEM	149	21	YR2	\N	10	Y	Y	Y	N	\N	\N	\N	1863	1863	TueThu	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1864	2279	RWPUG1	Period4 - SEM1 - TueThuFri - Francis  Zangairai	\N	88	SEM	148	78	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1864	1864	TueThuFri	50	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1942	2235	HOCTMT	Period4 - SEM1 - TueThu - C  Nyandoro	\N	88	SEM	148	59	YR 3	\N	0	Y	Y	Y	N	\N	\N	\N	1942	1942	TueThu	51	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1943	2222	HOMP	Period3 - SEM1 - TueThuFri - John  Sanni	\N	87	SEM	148	83	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1943	1943	TueThuFri	51	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1944	2329	DFL	Period3 - SEM 2 - TueFri - Kizito  Kiyimba	\N	87	SEM	149	13	DYR3	\N	0	Y	Y	Y	N	\N	\N	\N	1944	1944	TueFri	51	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1945	2330	COMPS	Period4 - SEM 2 - TueFri - K  Esenther	\N	88	SEM	149	22	DYR3	\N	0	Y	Y	Y	N	\N	\N	\N	1945	1945	TueFri	51	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1946	2331	MHBT	Period3 - SEM 2 - WedThuFri - John  Sanni	\N	87	SEM	149	83	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1946	1946	WedThuFri	51	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1947	2332	AFT	Period1 - SEM 2 - MonFri - Francis  Zangairai	\N	85	SEM	149	78	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1947	1947	MonFri	51	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1948	2333	AQKB	Period2 - SEM1 - MonFri - T  Sherman	\N	86	SEM	148	21	Elective	\N	0	Y	Y	Y	N	\N	\N	\N	1948	1948	MonFri	51	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1949	2299	LLEL	Period5 - SEM1 - MonFri - I  Chidavaenzi	\N	89	SEM	148	18	YR3	\N	13	Y	Y	Y	N	\N	\N	\N	1949	1949	MonFri	51	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1950	2340	PHOR	Period7 - SEM 2 - MonThuFri - Francis  Zangairai	\N	91	SEM	149	78	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1950	1950	MonThuFri	51	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1953	2336	HPCIK	Period4 - SEM 2 - MonThu - Philip  Rossi	\N	88	SEM	149	86	PUG	\N	0	Y	Y	Y	N	\N	\N	\N	1953	1953	MonThu	51	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1954	2337	OIAF	Period5 - SEM 2 - MonFri - Patrick  Ryan	\N	89	SEM	149	84	Elective	\N	8	Y	Y	Y	N	\N	\N	\N	1954	1954	MonFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1955	2338	MHBT	Period6 - SEM 2 - MonThuFri - John  Sanni	\N	90	SEM	149	83	Elective	\N	0	Y	Y	Y	N	\N	\N	\N	1955	1955	MonThuFri	51	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1956	2341	PHOR	Period8 - SEM 2 - MonWedThu - Francis  Zangairai	\N	92	SEM	149	78	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1956	1956	MonWedThu	51	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1957	2342	MFAN	Period5 - SEM 2 - MonTueFri - A  Chennells	\N	89	SEM	149	42	Elective	\N	0	Y	Y	Y	N	\N	\N	\N	1957	1957	MonTueFri	51	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1958	2149	HAPPUG1	Period3 - SEM1 - MonWedFri - Costa  Virgilio	\N	87	SEM	148	33	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1958	1958	MonWedFri	51	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1959	2343	PHATH	Period8 - SEM1 - TueFri - Costa  Virgilio	\N	92	SEM	148	33	Y2	\N	11	Y	Y	Y	N	\N	\N	\N	1959	1959	TueFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1960	2344	PHATH	Period7 - SEM1 - MonFri - Costa  Virgilio	\N	91	SEM	148	33	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1960	1960	MonFri	48	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1853	2137	LOGIC	Period1 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	85	SEM	149	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1853	1853	MonWedFri	50	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1854	2136	ROA	Period1 - SEM 2 - MonThuFri - Francis  Zangairai	\N	85	SEM	149	78	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1854	1854	MonThuFri	50	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3446	3678	DISASTERC	PUG16S1P1 - SEM 2 -  - A  Mandeya	\N	254	SEM	183	20	\N	\N	4	Y	Y	Y	N	\N	\N	\N	3446	3446	\N	94	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3133	3554	LAYR1	APH16S1P1 - SEM1 - Mon - A  Chennells	\N	241	SEM	184	42	YR1	\N	21	Y	Y	Y	N	\N	\N	\N	3133	3133	Mon	94	57	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3447	3675	THEATER	APH16S2P6 - SEM 2 -  - Davis  Guzha	\N	253	SEM	183	111	\N	12	6	Y	Y	Y	N	\N	\N	\N	3447	3447	\N	94	57	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3386	3616	HMPH	PGD16S2P3 - SEM 2 -  - Gilbert  Mardai	\N	273	SEM	183	99	\N	\N	10	Y	Y	Y	N	\N	\N	\N	3386	3386	\N	94	57	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3346	3574	HMPH	APH16S1P3 - SEM1 - Mon - T  Sherman	\N	243	SEM	184	21	YR2	\N	10	Y	Y	Y	N	\N	\N	\N	3346	3346	Mon	94	57	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3431	3583	APOL	APH16S1P4 - SEM1 - Mon - A  Chennells	\N	244	SEM	184	42	\N	\N	3	Y	Y	Y	N	\N	\N	\N	3431	3431	Mon	94	57	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3371	3603	Dewey	PUG16S1P4 - SEM1 - Tue - John  Stacer	\N	256	SEM	184	50	\N	\N	1	Y	Y	Y	N	\N	\N	\N	3371	3371	Tue	94	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3375	3607	SPNEDU	PUG16S1P6 - SEM1 - Mon - Tendai  Chikutuma	\N	258	SEM	184	94	\N	\N	2	Y	Y	Y	N	\N	\N	\N	3375	3375	Mon	94	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3373	3605	PHMIND	PUG16S1P6 - SEM1 - MonWed - Stephen  Buckland	\N	258	SEM	184	101	\N	\N	1	Y	Y	Y	N	\N	\N	\N	3373	3373	MonWed	94	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3432	3661	INTROPA	MPA16S1P1 - SEM1 - Fri - Rachael   Rufu	\N	277	SEM	184	90	\N	\N	1	Y	Y	Y	N	\N	\N	\N	3432	3432	Fri	94	58	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2318	2485	RAPUG1	Period1 - SEM 2 - MonThuFri - Francis  Zangairai	\N	101	SEM	158	78	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2318	2318	MonThuFri	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2159	2519	FAEL	Period1 - SEM 2 - Wed - T  Sherman	\N	101	SEM	158	21	Y4	\N	0	Y	Y	Y	N	\N	\N	\N	2159	2159	Wed	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2332	2570	AQLKB	Period5 - SEM1 - MonWedFri - T  Sherman	\N	105	SEM	159	21	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2332	2332	MonWedFri	62	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2331	2572	LOM	Period7 - SEM1 - TueThu - A  Chennells	\N	107	SEM	159	42	YR 3	\N	0	Y	Y	Y	N	\N	\N	\N	2331	2331	TueThu	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2330	2577	PTP	Period5 - SEM1 - MonWed - Kizito  Kiyimba	\N	105	SEM	159	13	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2330	2330	MonWed	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2329	2533	FLPUG1	Period1 - SEM 2 - MonWedFri - A  Ggita	\N	101	SEM	158	31	DIP YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2329	2329	MonWedFri	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2328	2661	PTDYR2	Period4 - SEM1 - MonWedFri - A  Manyere	\N	104	SEM	159	30	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2328	2328	MonWedFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2327	2655	RWYR2	Period3 - SEM1 - MonWedFri - Francis  Zangairai	\N	103	SEM	159	78	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2327	2327	MonWedFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2326	2413	APYR4	Period3 - SEM1 - MonWedFri - John  Sanni	\N	103	SEM	159	83	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2326	2326	MonWedFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2019	3	4522	4721	HAPPUG1	PUG16S1P4 - SEM1 - Mon - Simon  Makuru	\N	424	SEM	198	45	YR1	\N	6	Y	Y	Y	N	\N	\N	\N	4251	4522	Mon	112	68	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2325	2414	EHYR4	Period2 - SEM1 - MonWed - John  Stacer	\N	102	SEM	159	50	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	2325	2325	MonWed	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2324	2479	REPUG3	Period3 - SEM 2 - MonWedFri - C  Nyandoro	\N	103	SEM	158	59	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	2324	2324	MonWedFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2323	2503	PCMPUGE	Period1 - SEM1 - TueThu - A  Mandeya	\N	101	SEM	159	20	DIP YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2323	2323	TueThu	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2322	2415	PGYR4	Period4 - SEM1 - MonWedFri - T  Sherman	\N	104	SEM	159	21	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	2322	2322	MonWedFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2321	2623	DEMC	Period6 - SEM 2 - TueThu - Olivier  Sempiga	\N	106	SEM	158	38	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2321	2321	TueThu	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2320	2457	STEL	Period5 - SEM1 - MonThu - Costa  Virgilio	\N	105	SEM	159	33	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	2320	2320	MonThu	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3414	3644	AQUINAS	PUG16S2P6 - SEM 2 -  - T  Sherman	\N	264	SEM	183	21	\N	\N	13	Y	Y	Y	N	\N	\N	\N	3414	3414	\N	94	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3403	3631	ICT	APH16S2P6 - SEM 2 -  - Evaristus O Ekwueme	\N	253	SEM	183	85	\N	\N	12	Y	Y	Y	N	\N	\N	\N	3403	3403	\N	94	57	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3398	3626	PHILANT	PGD16S1P1 - SEM1 -  - Stephen  Buckland	\N	265	SEM	184	101	\N	\N	0	Y	Y	Y	N	\N	\N	\N	3398	3398	\N	94	57	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3420	3650	ICT	PUG16S2P5 - SEM 2 -  - Evaristus O Ekwueme	\N	263	SEM	183	85	\N	\N	5	Y	Y	Y	N	\N	\N	\N	3420	3420	\N	94	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3198	3329	RWPUG1	PUG16S1P2 - SEM1 - TueThuFri - Francis  Zangairai	\N	255	SEM	184	78	YR2	\N	6	Y	Y	Y	N	\N	\N	\N	3198	3198	TueThuFri	94	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2319	2464	SSAPUG1	Period1 - SEM 2 - MonWedThu - Ben  Sachikonye	\N	101	SEM	158	37	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2319	2319	MonWedThu	60	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2018	3	4114	4288	HMPH	PGD16S2P5 - SEM 2 - Mon - Stephen  Buckland	\N	339	SEM	194	101	YR2	\N	7	Y	Y	Y	N	\N	\N	\N	4114	4114	\N	106	63	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2018	3	4333	4614	PHILI	PUG16S1P3 - SEM1 -  - Stanislaus  Bigirimana	\N	375	SEM	193	131	\N	\N	2	Y	Y	Y	N	\N	\N	\N	4333	4333	\N	106	65	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2316	2523	IDDPT	Period4 - SEM 2 - TueThuFri - C  Nyandoro	\N	104	SEM	158	59	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2316	2316	TueThuFri	60	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2317	2456	GAAPH	Period1 - SEM1 - MonTueWedThuFri - Ujah  Ejembi	\N	101	SEM	159	26	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2317	2317	MonTueWedThuFri	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2315	2431	PRYR2	Period2 - SEM1 - MonFri - T  Sherman	\N	102	SEM	159	21	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2315	2315	MonFri	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2312	2517	DPTEL	Period2 - SEM1 - TueThu - A  Mandeya	\N	102	SEM	159	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2312	2312	TueThu	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2311	2420	CMYR1	Period1 - SEM1 - MonWedFri - C  Nyandoro	\N	101	SEM	159	59	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2311	2311	MonWedFri	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2117	2537	PHILTEK	Period5 - SEM 2 - MonThuFri - Kizito  Kiyimba	\N	105	SEM	158	13	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2117	2117	MonThuFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2116	2544	INTROPOL	Period4 - SEM 2 - MonTueWedThuFri - Rachael   Rufu	\N	104	SEM	158	90	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2116	2116	MonTueWedThuFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2115	2403	RETREAT	Period8 - SEM 2 - MonWedFri - A  Manyere	\N	108	SEM	158	30	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2115	2115	MonWedFri	63	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2114	2559	CONTLit	Period6 - SEM 2 - MonFri - A  Chennells	\N	106	SEM	158	42	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2114	2114	MonFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2113	2688	PEOPLES	Period6 - SEM 2 - MonTueFri - O  Kufakurinane	\N	106	SEM	158	91	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2113	2113	MonTueFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2112	2662	EYR2	Period1 - SEM 2 - MonWed - Amadeus  Shirima	\N	101	SEM	158	88	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2112	2112	MonWed	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2111	2470	ALFPUG	Period7 - SEM 2 - MonThuFri - Dominique  Karani	\N	107	SEM	158	54	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2111	2111	MonThuFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2110	2487	EPUG1	Period1 - SEM 2 - MonWed - Amadeus  Shirima	\N	101	SEM	158	88	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2110	2110	MonWed	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2109	2409	CPYR3	Period2 - SEM 2 - MonWed - T  Sherman	\N	102	SEM	158	21	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2109	2109	MonWed	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2108	2538	METHEDU	Period7 - SEM 2 - MonTueFri - C  Nyandoro	\N	107	SEM	158	59	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2108	2108	MonTueFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2107	2538	METHEDU	Period1 - SEM 2 - MonTueWedThu - C  Nyandoro	\N	101	SEM	158	59	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2107	2107	MonTueWedThu	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2106	2410	PMEYR3	Period3 - SEM 2 - MonFri - Pacey  Pacey	\N	103	SEM	158	92	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2106	2106	MonFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2105	2466	PMEPUG2	Period3 - SEM 2 - TueWedThu - Pacey  Pacey	\N	103	SEM	158	92	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2105	2105	TueWedThu	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2104	2404	DISSERT	Period4 - SEM 2 - MonFri - John  Stacer	\N	104	SEM	158	50	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2104	2104	MonFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2103	2545	DISSERT	Period8 - SEM 2 - MonThuFri - John  Stacer	\N	108	SEM	158	50	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2103	2103	MonThuFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2102	2471	THNGUGI	Period8 - SEM 2 - MonFri - A  Chennells	\N	108	SEM	158	42	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2102	2102	MonFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2101	2560	CURIDEV	Period7 - SEM 2 - TueWedFri - C  Nyandoro	\N	107	SEM	158	59	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2101	2101	TueWedFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2100	2560	CURIDEV	Period8 - SEM 2 - MonFri - C  Nyandoro	\N	108	SEM	158	59	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2100	2100	MonFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2099	2689	THGARD	Period7 - SEM 2 - MonFri - C  Nyandoro	\N	107	SEM	158	59	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2099	2099	MonFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2098	2689	THGARD	Period8 - SEM 2 - TueWedThuFri - C  Nyandoro	\N	108	SEM	158	59	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2098	2098	TueWedThuFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2097	2677	OIAF	Period8 - SEM 2 - MonThuFri - Patrick  Ryan	\N	108	SEM	158	84	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2097	2097	MonThuFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2096	2550	ISLAM	Period8 - SEM 2 - WedThuFri - Francis  Zangairai	\N	108	SEM	158	78	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2096	2096	WedThuFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2095	2539	PHMATH	Period7 - SEM 2 - MonTueWedThuFri - Henry  Ibekwe	\N	107	SEM	158	89	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2095	2095	MonTueWedThuFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2094	2546	MLOGIC	Period7 - SEM 2 - MonTueFri - Kizito  Kiyimba	\N	107	SEM	158	13	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2094	2094	MonTueFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2093	2571	POR	Period8 - SEM 2 - MonTueWedThuFri - Francis  Zangairai	\N	108	SEM	158	78	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2093	2093	MonTueWedThuFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2092	2405	SCIEREL	Period7 - SEM 2 - WedFri - Costa  Virgilio	\N	107	SEM	158	33	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2092	2092	WedFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2091	2472	HITFILM	Period7 - SEM 2 - MonThu - K  Esenther	\N	107	SEM	158	22	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2091	2091	MonThu	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2090	2472	HITFILM	Period8 - SEM 2 - MonFri - K  Esenther	\N	108	SEM	158	22	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2090	2090	MonFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2089	2468	HIVAIDS	Period8 - SEM 2 - MonTueWedThuFri - A  Mandeya	\N	108	SEM	158	20	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2089	2089	MonTueWedThuFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2088	2468	HIVAIDS	Period8 - SEM 2 - WedFri - A  Mandeya	\N	108	SEM	158	20	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2088	2088	WedFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2087	2511	ICSPEL	Period8 - SEM 2 - TueWedFri - K  Esenther	\N	108	SEM	158	22	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2087	2087	TueWedFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2086	2561	INTROPOL	Period7 - SEM 2 - MonThuFri - Rachael   Rufu	\N	107	SEM	158	90	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2086	2086	MonThuFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2085	2679	PCMEL	Period7 - SEM 2 - MonThuFri - A  Mandeya	\N	107	SEM	158	20	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2085	2085	MonThuFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2084	2690	INTROPEACE	Period7 - SEM 2 - MonThuFri - A  Mandeya	\N	107	SEM	158	20	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2084	2084	MonThuFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2083	2540	CONFMANG	Period7 - SEM 2 - MonTueFri - A  Mandeya	\N	107	SEM	158	20	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2083	2083	MonTueFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2082	2547	INTROHRIGH	Period7 - SEM 2 - MonTueWedThuFri - Kirenga  Kirenga	\N	107	SEM	158	93	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2082	2082	MonTueWedThuFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2081	2473	PHILMIND	Period7 - SEM 2 - MonThuFri - T  Sherman	\N	107	SEM	158	21	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2081	2081	MonThuFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2080	2471	THNGUGI	Period7 - SEM 2 - MonFri - A  Chennells	\N	107	SEM	158	42	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2080	2080	MonFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2079	2571	POR	Period7 - SEM 2 - MonThuFri - Francis  Zangairai	\N	107	SEM	158	78	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2079	2079	MonThuFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2078	2405	SCIEREL	Period8 - SEM 2 - MonThuFri - Costa  Virgilio	\N	108	SEM	158	33	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2078	2078	MonThuFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2077	2474	COMPS	Period1 - SEM 2 - WedThuFri - K  Esenther	\N	101	SEM	158	22	Elective	\N	0	Y	Y	Y	N	\N	\N	\N	2077	2077	WedThuFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2076	2562	COMPS	Period8 - SEM 2 - MonWedThuFri - K  Esenther	\N	108	SEM	158	22	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2076	2076	MonWedThuFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2075	2691	INTROPOL	Period8 - SEM 2 - ThuFri - Rachael   Rufu	\N	108	SEM	158	90	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2075	2075	ThuFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2074	2548	INTROPEACE	Period8 - SEM 2 - MonWedFri - A  Mandeya	\N	108	SEM	158	20	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2074	2074	MonWedFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2073	2407	INTROHRIGH	Period8 - SEM 2 - MonThuFri - Kirenga  Kirenga	\N	108	SEM	158	93	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2073	2073	MonThuFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2072	2475	PHILTEK	Period7 - SEM 2 - MonThuFri - Francis  Zangairai	\N	107	SEM	158	78	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2072	2072	MonThuFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2071	2406	POLTHEO	Period7 - SEM 2 - WedThuFri - Francis  Zangairai	\N	107	SEM	158	78	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2071	2071	WedThuFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2070	2494	MCPPUG2	Period4 - SEM 2 - MonWed - T  Sherman	\N	104	SEM	158	21	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2070	2070	MonWed	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2069	2493	CPPUG2	Period2 - SEM 2 - MonWedFri - Costa  Virgilio	\N	102	SEM	158	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2069	2069	MonWedFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2068	2486	SSAYR2	Period2 - SEM 2 - MonWedFri - Kenneth  Makamure	\N	102	SEM	158	56	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2068	2068	MonWedFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2067	2442	METAPH	Period8 - SEM 2 - MonThuFri - T  Sherman	\N	108	SEM	158	21	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2067	2067	MonThuFri	63	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2066	2595	LYR1	Period2 - SEM 2 - MonWed - Henry  Ibekwe	\N	102	SEM	158	89	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2066	2066	MonWed	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2065	2642	APYR1	Period5 - SEM 2 - MonFri - Amadeus  Shirima	\N	105	SEM	158	88	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2065	2065	MonFri	63	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2064	2642	APYR1	Period4 - SEM 2 - TueFri - Amadeus  Shirima	\N	104	SEM	158	88	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2064	2064	TueFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2063	2642	APYR1	Period4 - SEM 2 - TueFri - Amadeus  Shirima	\N	104	SEM	158	88	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2063	2063	TueFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2189	2399	ENYR1	APH1 - SEM1 - TueThu - K  Esenther	\N	101	SEM	159	22	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2189	2189	TueThu	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2371	2481	POM	Period2 - SEM1 - MonWedFri - John  Stacer	\N	102	SEM	159	50	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2371	2371	MonWedFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2370	2675	HPICK	Period4 - SEM1 - MonThuFri - Costa  Virgilio	\N	104	SEM	159	33	MAYR	\N	0	Y	Y	Y	N	\N	\N	\N	2370	2370	MonThuFri	63	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2369	2641	VT2YR1	Period6 - SEM1 - MonThuFri - Joseph  Mahlahla	\N	106	SEM	159	79	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2369	2369	MonThuFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2368	2647	ITYR1	Period5 - SEM1 - MonWed - T  Sherman	\N	105	SEM	159	21	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2368	2368	MonWed	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2367	2644	BAFL	Period1 - SEM1 - MonWed - Dominique  Karani	\N	101	SEM	159	54	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2367	2367	MonWed	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2366	2576	PLS	Period6 - SEM1 - MonWed - Costa  Virgilio	\N	106	SEM	159	33	YR 3	\N	0	Y	Y	Y	N	\N	\N	\N	2366	2366	MonWed	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2348	2488	FLPUG1	Period1 - SEM1 - MonWed - Dominique  Karani	\N	101	SEM	159	54	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2348	2348	MonWed	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2347	2566	POL	Period5 - SEM1 - MonWedFri - Francis  Zangairai	\N	105	SEM	159	78	YR 1	\N	0	Y	Y	Y	N	\N	\N	\N	2347	2347	MonWedFri	62	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2346	2567	TTEL	Period6 - SEM1 - TueThu - Costa  Virgilio	\N	106	SEM	159	33	YR 3	\N	0	Y	Y	Y	N	\N	\N	\N	2346	2346	TueThu	62	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2345	2571	POR	Period5 - SEM1 - MonWedFri - Francis  Zangairai	\N	105	SEM	159	78	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2345	2345	MonWedFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2344	2573	FRLS	Period1 - SEM1 - MonWed - Dominique  Karani	\N	101	SEM	159	54	YR 1	\N	0	Y	Y	Y	N	\N	\N	\N	2344	2344	MonWed	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2343	2575	MRS	Period1 - SEM1 - TueThu - C  Nyandoro	\N	101	SEM	159	59	YR 1	\N	0	Y	Y	Y	N	\N	\N	\N	2343	2343	TueThu	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2342	2579	SLS	Period6 - SEM1 - TueThu - teacher  teacher	\N	106	SEM	159	28	YR 1	\N	0	Y	Y	Y	N	\N	\N	\N	2342	2342	TueThu	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2341	2582	ITBL	Period5 - SEM1 - TueFri - A  Chennells	\N	105	SEM	159	42	YR 3	\N	0	Y	Y	Y	N	\N	\N	\N	2341	2341	TueFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2340	2667	MAISLAM	Period3 - SEM 2 - Mon - Patrick  Ryan	\N	103	SEM	158	84	MAYR	\N	0	Y	Y	Y	N	\N	\N	\N	2340	2340	Mon	62	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2339	2668	PHIH	Period4 - SEM 2 - Wed - C  Nyandoro	\N	104	SEM	158	59	MAYR	\N	0	Y	Y	Y	N	\N	\N	\N	2339	2339	Wed	63	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2338	2687	PHMA	Period5 - SEM 2 - MonThu - T  Sherman	\N	105	SEM	158	21	MAYR	\N	0	Y	Y	Y	N	\N	\N	\N	2338	2338	MonThu	63	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2337	2581	PTP	Period5 - SEM 2 - WedFri - Kizito  Kiyimba	\N	105	SEM	158	13	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2337	2337	WedFri	62	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2336	2530	APEL	Period1 - SEM1 - MonTueWedThuFri - A  Chennells	\N	101	SEM	159	42	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2336	2336	MonTueWedThuFri	62	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2335	2583	POR	Period5 - SEM1 - MonWedFri - Francis  Zangairai	\N	105	SEM	159	78	YR 1	\N	0	Y	Y	Y	N	\N	\N	\N	2335	2335	MonWedFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2334	2587	PLS	Period5 - SEM1 - TueThu - Costa  Virgilio	\N	105	SEM	159	33	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2334	2334	TueThu	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2333	2531	FL	Period7 - SEM1 - TueThu - Kizito  Kiyimba	\N	107	SEM	159	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2333	2333	TueThu	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2310	2432	IOTYR1	Period2 - SEM1 - WedFri - Zvaiwa  Zvaiwa	\N	102	SEM	159	\N	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2310	2310	WedFri	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2309	2423	HAYR1	Period3 - SEM1 - TueFri - C  Matusse	\N	103	SEM	159	19	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2309	2309	TueFri	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2308	2434	NTYR3	Period2 - SEM1 - TueThu - A  Mandeya	\N	102	SEM	159	20	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2308	2308	TueThu	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2307	2527	HRs	Period1 - SEM1 - Mon - Costa  Virgilio	\N	101	SEM	159	33	Office	\N	0	Y	Y	Y	N	\N	\N	\N	2307	2307	Mon	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2306	2504	APPUGE	Period1 - SEM 2 - Mon - A  Perumalil	\N	101	SEM	158	9	Offices	\N	0	Y	Y	Y	N	\N	\N	\N	2306	2306	Mon	60	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2305	2657	APYR2	Period1 - SEM1 - TueThu - Costa  Virgilio	\N	101	SEM	159	33	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2305	2305	TueThu	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2304	2565	HMPYR2	Period2 - SEM 2 - TueWedFri - T  Sherman	\N	102	SEM	158	21	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2304	2304	TueWedFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2303	2654	WLYR2	Period4 - SEM1 - TueThu - A  Chennells	\N	104	SEM	159	42	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2303	2303	TueThu	59	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2302	2416	NTYR4	Period3 - SEM1 - TueThu - I  Chidavaenzi	\N	103	SEM	159	18	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	2302	2302	TueThu	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2301	2408	ESYR3	Period3 - SEM1 - MonThuFri - Lawrence  Daka	\N	103	SEM	159	44	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2301	2301	MonThuFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2300	2663	HMYR3	Period4 - SEM1 - TueThu - T  Sherman	\N	104	SEM	159	21	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2300	2300	TueThu	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2299	2476	OFPUG2	Period3 - SEM 2 - WedFri - I  Chidavaenzi	\N	103	SEM	158	18	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2299	2299	WedFri	60	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2298	2591	ROA	Period1 - SEM 2 - MonThuFri - Francis  Zangairai	\N	101	SEM	158	78	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2298	2298	MonThuFri	61	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2297	2482	ICSPUGE	Period1 - SEM 2 - MonWedFri - K  Esenther	\N	101	SEM	158	22	Computer	\N	0	Y	Y	Y	N	\N	\N	\N	2297	2297	MonWedFri	60	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2296	2510	IGSP	Period1 - SEM1 - TueFri - A  Manyere	\N	101	SEM	159	30	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2296	2296	TueFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2295	2431	PRYR2	Period2 - SEM 2 - MonFri - Francis  Zangairai	\N	102	SEM	158	78	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2295	2295	MonFri	62	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2294	2458	APEL	Period6 - SEM1 - MonTueWedThuFri - A  Mandeya	\N	106	SEM	159	20	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2294	2294	MonTueWedThuFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2293	2411	MCPYR3	Period3 - SEM 2 - MonTue - T  Sherman	\N	103	SEM	158	21	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2293	2293	MonTue	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2292	2589	PCCEL	Period5 - SEM 2 - MonWedFri - A  Mandeya	\N	105	SEM	158	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2292	2292	MonWedFri	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2291	2459	DPTEL	Period2 - SEM1 - TueThu - T  Sherman	\N	102	SEM	159	21	DP	\N	0	Y	Y	Y	N	\N	\N	\N	2291	2291	TueThu	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2290	2516	DPTEL	Period2 - SEM1 - TueThu - Kenneth  Makamure	\N	102	SEM	159	\N	DP	\N	0	Y	Y	Y	N	\N	\N	\N	2290	2290	TueThu	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2289	2632	SPP	Period3 - SEM1 - TueFri - Diddy  Brossala	\N	103	SEM	159	24	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2289	2289	TueFri	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2288	2490	PTDPUG1	Period3 - SEM1 - MonWedFri - A  Manyere	\N	103	SEM	159	30	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2288	2288	MonWedFri	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2287	2628	FFEL	Period5 - SEM1 - MonWed - Diddy  Brossala	\N	105	SEM	159	24	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2287	2287	MonWed	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2286	2484	HRPUGE	Period1 - SEM 2 - MonWedFri - Costa  Virgilio	\N	101	SEM	158	33	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	2286	2286	MonWedFri	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2285	2563	FLS	Period1 - SEM1 - MonWed - Dominique  Karani	\N	101	SEM	159	54	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2285	2285	MonWed	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2284	2454	ATYR2	Period1 - SEM1 - MonWedFri - A  Mandeya	\N	101	SEM	159	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2284	2284	MonWedFri	63	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2283	2518	DPTEL	Period2 - SEM1 - TueThu - Johnny  Stacer	\N	102	SEM	159	\N	DP	\N	0	Y	Y	Y	N	\N	\N	\N	2283	2283	TueThu	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2282	2515	APEL	Period1 - SEM1 - MonTueWedThuFri - Lawrence  Daka	\N	101	SEM	159	\N	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2282	2282	MonTueWedThuFri	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2281	2513	PFEL	Period1 - SEM 2 - MonWedFri - Diddy  Brossala	\N	101	SEM	158	24	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2281	2281	MonWedFri	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2280	2619	PCC	Period6 - SEM 2 - TueWedFri - A  Mandeya	\N	106	SEM	158	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2280	2280	TueWedFri	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2279	2436	HCTPDPT	Period2 - SEM 2 - TueThu - C  Nyandoro	\N	102	SEM	158	59	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2279	2279	TueThu	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2278	2528	ICSDPT	Period2 - SEM 2 - TueThu - K  Esenther	\N	102	SEM	158	22	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2278	2278	TueThu	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2277	2435	ITDPT	Period1 - SEM1 - MonWedFri - K  Esenther	\N	101	SEM	159	22	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2277	2277	MonWedFri	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2276	2433	INTDPT	Period3 - SEM 2 - MonThuFri - A  Mandeya	\N	103	SEM	158	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2276	2276	MonThuFri	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2275	2502	PFPUGE	Period1 - SEM 2 - MonWedFri - Diddy  Brossala	\N	101	SEM	158	24	Aud Visual	\N	0	Y	Y	Y	N	\N	\N	\N	2275	2275	MonWedFri	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2274	2527	HRs	Period3 - SEM 2 - MonWedFri - Costa  Virgilio	\N	103	SEM	158	33	Aud Visual	\N	0	Y	Y	Y	N	\N	\N	\N	2274	2274	MonWedFri	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2273	2526	DHDPT	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	101	SEM	158	26	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2273	2273	TueThu	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2272	2525	HRDPT	Period1 - SEM 2 - TueThuFri - Costa  Virgilio	\N	101	SEM	158	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2272	2272	TueThuFri	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2271	2652	PLEL	Period1 - SEM 2 - MonWedFri - T  Sherman	\N	101	SEM	158	21	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2271	2271	MonWedFri	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2270	2462	RSFANEL	Period1 - SEM 2 - MonWedFri - A  Chennells	\N	101	SEM	158	42	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2270	2270	MonWedFri	60	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2269	2597	APHIL	Period4 - SEM1 - TueWed - Diddy  Brossala	\N	104	SEM	159	24	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2269	2269	TueWed	62	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2268	2637	LOG	Period3 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	103	SEM	158	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2268	2268	MonWedFri	61	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2267	2498	OCTPUG3	Period3 - SEM 2 - WedFri - Joseph  Mahlahla	\N	103	SEM	158	79	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	2267	2267	WedFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2266	2434	NTYR2	Period1 - SEM1 - TueThu - K  Esenther	\N	101	SEM	159	22	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2266	2266	TueThu	62	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2265	2588	POE	Period3 - SEM 2 - TueThu - A  Zvaiwa	\N	103	SEM	158	51	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2265	2265	TueThu	62	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2264	2427	EPDPT	Period3 - SEM 2 - MonWedFri - Costa  Virgilio	\N	103	SEM	158	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2264	2264	MonWedFri	62	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2263	2521	IEDPT	Period1 - SEM 2 - WedThuFri - A  Mandeya	\N	101	SEM	158	20	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2263	2263	WedThuFri	62	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2262	2609	LLEL	Period2 - SEM1 - MonWedFri - I  Chidavaenzi	\N	102	SEM	159	18	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2262	2262	MonWedFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2261	2511	ICSPEL	Period1 - SEM 2 - MonWedFri - K  Esenther	\N	101	SEM	158	22	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2261	2261	MonWedFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2260	2612	BAPRE	Period4 - SEM 2 - TueThu - A  Zvaiwa	\N	104	SEM	158	51	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2260	2260	TueThu	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2259	2608	KEL	Period5 - SEM1 - TueThu - Diddy  Brossala	\N	105	SEM	159	24	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2259	2259	TueThu	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2258	2460	IPPUG1	Period3 - SEM1 - MonThu - John  Sanni	\N	103	SEM	159	83	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2258	2258	MonThu	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2257	2495	SAPPUG3	Period2 - SEM1 - MonWedThu - John  Sanni	\N	102	SEM	159	83	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	2257	2257	MonWedThu	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2256	2477	EHPUG3	Period2 - SEM1 - TueThu - John  Stacer	\N	102	SEM	159	50	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	2256	2256	TueThu	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2255	2658	APPUG1	Period2 - SEM 2 - MonThu - Diddy  Brossala	\N	102	SEM	158	24	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2255	2255	MonThu	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2254	2651	DHBAEL	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	101	SEM	158	26	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2254	2254	TueThu	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2253	2439	CHYR2	Period1 - SEM1 - MonThu - G  Makwasha	\N	101	SEM	159	\N	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2253	2253	MonThu	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2252	2439	CHYR1	Period1 - SEM1 - MonThu - G  Makwasha	\N	101	SEM	159	\N	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2252	2252	MonThu	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2251	2611	STEL	Period7 - SEM1 - TueThu - Costa  Virgilio	\N	107	SEM	159	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2251	2251	TueThu	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2250	2428	MTP	Period1 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	101	SEM	158	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2250	2250	MonWedFri	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2249	2603	HRPUG	Period3 - SEM 2 - TueThu - Costa  Virgilio	\N	103	SEM	158	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2249	2249	TueThu	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2248	2426	CONTP	Period2 - SEM 2 - MonWedFri - John  Sanni	\N	102	SEM	158	\N	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2248	2248	MonWedFri	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2247	2463	APEL	Period1 - SEM 2 - Wed - A  Perumalil	\N	101	SEM	158	9	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	2247	2247	Wed	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2246	2626	APHIL	Period4 - SEM 2 - TueWedFri - Diddy  Brossala	\N	104	SEM	158	24	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2246	2246	TueWedFri	61	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2245	2536	LAYR1	Period2 - SEM 2 - TueThu - A  Chennells	\N	102	SEM	158	42	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2245	2245	TueThu	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2244	2640	RAYR1	Period2 - SEM 2 - TueFri - Francis  Zangairai	\N	102	SEM	158	78	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2244	2244	TueFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2243	2604	FRLS	Period2 - SEM 2 - MonWed - A  Ggita	\N	102	SEM	158	31	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2243	2243	MonWed	61	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2242	2656	WHYR2	Period3 - SEM 2 - TueThu - P  Nyambara	\N	103	SEM	158	8	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2242	2242	TueThu	62	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2241	2480	OCEPUG3	Period3 - SEM 2 - MonWed - John  Stacer	\N	103	SEM	158	50	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	2241	2241	MonWed	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2240	2596	ESPPUG2	Period4 - SEM1 - TueThu - Lawrence  Daka	\N	104	SEM	159	44	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2240	2240	TueThu	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2239	2620	ETH	Period2 - SEM 2 - MonWedFri - Olivier  Sempiga	\N	102	SEM	158	38	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2239	2239	MonWedFri	61	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2238	2580	PON	Period4 - SEM1 - MonFri - Kizito  Kiyimba	\N	104	SEM	159	13	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2238	2238	MonFri	61	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2237	2496	PGPUG3	Period4 - SEM1 - MonWed - T  Sherman	\N	104	SEM	159	21	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	2237	2237	MonWed	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2236	2659	POSPUG	Period3 - SEM1 - MonWedFri - Kizito  Kiyimba	\N	103	SEM	159	13	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2236	2236	MonWedFri	62	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2235	2514	HMPPUG1	Period2 - SEM 2 - TueThu - T  Sherman	\N	102	SEM	158	21	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2235	2235	TueThu	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2234	2489	RWPUG1	Period4 - SEM1 - TueThuFri - Francis  Zangairai	\N	104	SEM	159	78	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2234	2234	TueThuFri	61	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2233	2532	LPUG1	Period1 - SEM 2 - MonThu - Kizito  Kiyimba	\N	101	SEM	158	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2233	2233	MonThu	61	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2232	2429	RPYR3	Period1 - SEM1 - MonWedFri - C  Nyandoro	\N	101	SEM	159	59	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2232	2232	MonWedFri	62	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2231	2440	ETMA	Period2 - SEM 2 - MonWed - Costa  Virgilio	\N	102	SEM	158	33	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	2231	2231	MonWed	63	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2230	2600	LAWA	Period2 - SEM 2 - MonThu - T  Sherman	\N	102	SEM	158	21	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2230	2230	MonThu	61	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2229	2500	PSDPUGE	Period4 - SEM 2 - MonTueWedThu - A  Manyere	\N	104	SEM	158	30	Aud Visual	\N	0	Y	Y	Y	N	\N	\N	\N	2229	2229	MonTueWedThu	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2228	2508	CTEL	Period5 - SEM1 - TueFri - Diddy  Brossala	\N	105	SEM	159	24	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2228	2228	TueFri	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2227	2507	JHEL	Period4 - SEM1 - TueFri - Olivier  Sempiga	\N	104	SEM	159	38	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2227	2227	TueFri	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2226	2627	PAEEL	Period5 - SEM1 - MonFri - A  Ggita	\N	105	SEM	159	31	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2226	2226	MonFri	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2225	2524	PCMDPT	Period1 - SEM 2 - MonWedFri - A  Mandeya	\N	101	SEM	158	20	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2225	2225	MonWedFri	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2224	2650	APEL	Period1 - SEM1 - MonTueWedThuFri - Kenneth  Makamure	\N	101	SEM	159	\N	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2224	2224	MonTueWedThuFri	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2223	2635	DEL	Period7 - SEM 2 - WedFri - Olivier  Sempiga	\N	107	SEM	158	38	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2223	2223	WedFri	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2222	2624	PFR	Period5 - SEM 2 - MonWed - Diddy  Brossala	\N	105	SEM	158	24	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2222	2222	MonWed	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2221	2455	APEL	Period1 - SEM1 - MonTueWedThuFri - Johnny  Stacer	\N	101	SEM	159	\N	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2221	2221	MonTueWedThuFri	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2220	2499	DHPUGE	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	101	SEM	158	26	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2220	2220	TueThu	60	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2219	2461	GPEL	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	101	SEM	158	26	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2219	2219	TueThu	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2218	2631	BLMA	Period4 - SEM1 - TueFri - John  Stacer	\N	104	SEM	159	50	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2218	2218	TueFri	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2217	2599	BIOE	Period5 - SEM 2 - MonWed - Costa  Virgilio	\N	105	SEM	158	33	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2217	2217	MonWed	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2216	2622	ASCA	Period5 - SEM 2 - MonWed - Lawrence  Daka	\N	105	SEM	158	44	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2216	2216	MonWed	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2215	2590	PSDRG	Period5 - SEM 2 - TueFri - A  Manyere	\N	105	SEM	158	30	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2215	2215	TueFri	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2214	2636	OTS	Period2 - SEM 2 - TueThu - K  Esenther	\N	102	SEM	158	22	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2214	2214	TueThu	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2213	2633	ST	Period6 - SEM1 - MonWed - Costa  Virgilio	\N	106	SEM	159	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2213	2213	MonWed	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2212	2617	PAE	Period4 - SEM1 - MonWedFri - A  Ggita	\N	104	SEM	159	31	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2212	2212	MonWedFri	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2118	2558	CURIDEV	Period8 - SEM 2 - MonTueWedThuFri - C  Nyandoro	\N	108	SEM	158	59	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2118	2118	MonTueWedThuFri	63	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2349	2593	HOAP	Period2 - SEM1 - TueThu - T  Sherman	\N	102	SEM	159	21	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2349	2349	TueThu	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2350	2569	FL	Period7 - SEM1 - TueThu - Kizito  Kiyimba	\N	107	SEM	159	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2350	2350	TueThu	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2351	2437	HCT	Period2 - SEM1 - MonWedFri - C  Nyandoro	\N	102	SEM	159	59	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2351	2351	MonWedFri	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2352	2424	HMP	Period4 - SEM1 - MonWed - A  Ggita	\N	104	SEM	159	31	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2352	2352	MonWed	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2353	2584	AIEL	Period1 - SEM1 - WedFri - A  Chennells	\N	101	SEM	159	42	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2353	2353	WedFri	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2354	2638	BLEL	Period6 - SEM1 - MonThu - John  Stacer	\N	106	SEM	159	50	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2354	2354	MonThu	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2355	2639	SKEL	Period6 - SEM1 - MonWedFri - Diddy  Brossala	\N	106	SEM	159	24	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2355	2355	MonWedFri	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2356	2618	POSMA	Period4 - SEM 2 - WedFri - Kizito  Kiyimba	\N	104	SEM	158	13	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	2356	2356	WedFri	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2357	2483	BPUGE	Period1 - SEM1 - TueThu - Costa  Virgilio	\N	101	SEM	159	33	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	2357	2357	TueThu	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2358	2501	IPLPUGE	Period1 - SEM 2 - MonWedFri - T  Sherman	\N	101	SEM	158	21	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	2358	2358	MonWedFri	60	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2359	2505	FAEPUGE	Period1 - SEM 2 - Mon - T  Sherman	\N	101	SEM	158	21	Offices	\N	0	Y	Y	Y	N	\N	\N	\N	2359	2359	Mon	60	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2360	2605	ASCAEL	Period6 - SEM 2 - MonWed - Lawrence  Daka	\N	106	SEM	158	44	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2360	2360	MonWed	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2361	2465	ALFYR2	Period3 - SEM1 - TueFri - Dominique  Karani	\N	103	SEM	159	54	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2361	2361	TueFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2362	2520	APDPT	Period2 - SEM 2 - TueThuFri - Diddy  Brossala	\N	102	SEM	158	24	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2362	2362	TueThuFri	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2363	2529	SLS	Period6 - SEM1 - TueFri - Costa  Virgilio	\N	106	SEM	159	33	YR 3	\N	0	Y	Y	Y	N	\N	\N	\N	2363	2363	TueFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2364	2451	APMA	Period4 - SEM1 - MonThu - A  Chennells	\N	104	SEM	159	42	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2364	2364	MonThu	63	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2365	2578	WLPUG	Period1 - SEM1 - MonWed - A  Chennells	\N	101	SEM	159	42	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2365	2365	MonWed	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2211	2616	HIVA	Period1 - SEM1 - MonThu - A  Mandeya	\N	101	SEM	159	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2211	2211	MonThu	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2210	2646	FLYR1	Period1 - SEM 2 - MonWedFri - A  Ggita	\N	101	SEM	158	31	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2210	2210	MonWedFri	63	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2209	2417	PPPYR4	Period1 - SEM 2 - MonTueWedThuFri - John  Stacer	\N	101	SEM	158	50	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	2209	2209	MonTueWedThuFri	61	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2208	2630	APHIL	Period4 - SEM 2 - TueWed - Diddy  Brossala	\N	104	SEM	158	24	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2208	2208	TueWed	61	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2207	2592	HOMP	Period3 - SEM 2 - TueThu - T  Sherman	\N	103	SEM	158	21	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2207	2207	TueThu	61	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2206	2491	HMPPUG2	Period3 - SEM1 - MonWedFri - T  Sherman	\N	103	SEM	159	21	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2206	2206	MonWedFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2205	2606	LOG	Period3 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	103	SEM	158	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2205	2205	MonWedFri	61	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2204	2660	PAPUGYR2	Period2 - SEM1 - TueThu - John  Stacer	\N	102	SEM	159	50	YR@	\N	0	Y	Y	Y	N	\N	\N	\N	2204	2204	TueThu	61	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2203	2492	PLPPUG2	Period4 - SEM1 - TueThuFri - Diddy  Brossala	\N	104	SEM	159	24	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2203	2203	TueThuFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2202	2478	NTFPUG3	Period3 - SEM1 - MonTueFri - I  Chidavaenzi	\N	103	SEM	159	18	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	2202	2202	MonTueFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2201	2586	EPMA	Period2 - SEM1 - TueThu - Kizito  Kiyimba	\N	102	SEM	159	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2201	2201	TueThu	63	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2200	2446	SPMA	Period1 - SEM1 - MonWed - Costa  Virgilio	\N	101	SEM	159	33	MAYR	\N	0	Y	Y	Y	N	\N	\N	\N	2200	2200	MonWed	63	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2199	2522	CTIDPT	Period3 - SEM 2 - MonWedFri - A  Manyere	\N	103	SEM	158	30	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2199	2199	MonWedFri	62	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2198	2564	ELEL	Period5 - SEM1 - MonWedFri - Costa  Virgilio	\N	105	SEM	159	33	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2198	2198	MonWedFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2197	2629	GAEL	Period5 - SEM1 - TueThu - A  Mandeya	\N	105	SEM	159	20	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2197	2197	TueThu	62	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2196	2621	PMOE	Period2 - SEM 2 - MonFri - C  Nyandoro	\N	102	SEM	158	59	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2196	2196	MonFri	62	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2195	2430	EDPT	Period3 - SEM1 - TueThu - Olivier  Sempiga	\N	103	SEM	159	38	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2195	2195	TueThu	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2194	2610	PAEL	Period8 - SEM1 - MonWedFri - A  Ggita	\N	108	SEM	159	31	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	2194	2194	MonWedFri	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2193	2497	PPPPUG3	Period2 - SEM1 - MonTueWedThuFri - John  Stacer	\N	102	SEM	159	50	Offices	\N	0	Y	Y	Y	N	\N	\N	\N	2193	2193	MonTueWedThuFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2192	2448	LPMA	Period3 - SEM1 - TueThu - Diddy  Brossala	\N	103	SEM	159	24	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	2192	2192	TueThu	63	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2191	2421	CMYR1	Period3 - SEM 2 - MonWedFri - A  Zvaiwa	\N	103	SEM	158	51	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2191	2191	MonWedFri	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2190	2512	BEL	Period1 - SEM1 - MonWedFri - Costa  Virgilio	\N	101	SEM	159	33	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2190	2190	MonWedFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2188	2647	ITYR1	Period5 - SEM1 - MonWed - INTYR2 - John  Sanni	\N	105	SEM	159	83	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2188	2188	MonWed	62	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2187	2541	HAYR1	Period2 - SEM1 - MonWedFri - P  Nyambara	\N	102	SEM	159	8	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2187	2187	MonWedFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2186	2643	LAYR1	Period3 - SEM1 - Wed - A  Chennells	\N	103	SEM	159	42	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2186	2186	Wed	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2185	2594	MRYR1	Period2 - SEM1 - TueThu - C  Nyandoro	\N	102	SEM	159	59	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2185	2185	TueThu	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2184	2646	FLYR1	Period1 - SEM 2 - MonTue - Dominique  Karani	\N	101	SEM	158	54	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2184	2184	MonTue	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2183	2648	ENYR1	Period1 - SEM 2 - WedThuFri - K  Esenther	\N	101	SEM	158	22	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2183	2183	WedThuFri	61	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2182	2640	RAYR1	Period3 - SEM 2 - Fri - Francis  Zangairai	\N	103	SEM	158	78	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2182	2182	Fri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2181	2574	OCYR1	Period4 - SEM 2 - TueFri - A  Manyere	\N	104	SEM	158	30	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2181	2181	TueFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2180	2470	ALFYR2	Period3 - SEM 2 - MonFri - Dominique  Karani	\N	103	SEM	158	54	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2180	2180	MonFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2179	2653	WLYR2	Period4 - SEM 2 - TueFri - A  Chennells	\N	104	SEM	158	42	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2179	2179	TueFri	62	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2178	2419	OCTYR4	Period2 - SEM 2 - MonWed - Joseph  Mahlahla	\N	102	SEM	158	79	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	2178	2178	MonWed	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2177	2418	REYR4	Period4 - SEM 2 - TueThu - C  Nyandoro	\N	104	SEM	158	59	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	2177	2177	TueThu	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2176	2679	PCMEL	Period1 - SEM1 - MonWedFri - A  Mandeya	\N	101	SEM	159	20	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2176	2176	MonWedFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2175	2585	ISEL	Period6 - SEM1 - TueThu - A  Manyere	\N	106	SEM	159	30	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	2175	2175	TueThu	61	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2174	2441	MAHE	Period1 - SEM 2 - TueFri - John  Stacer	\N	101	SEM	158	50	MAYR	\N	0	Y	Y	Y	N	\N	\N	\N	2174	2174	TueFri	62	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2173	2666	OSAD	Period1 - SEM 2 - TueFri - Patrick  Ryan	\N	101	SEM	158	84	DYR1	\N	0	Y	Y	Y	N	\N	\N	\N	2173	2173	TueFri	62	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2172	2534	ATPUG	Period1 - SEM 2 - TueFri - Francis  Zangairai	\N	101	SEM	158	78	DYR1	\N	0	Y	Y	Y	N	\N	\N	\N	2172	2172	TueFri	62	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2171	2634	PSDRGEL	Period4 - SEM 2 - MonTueWedThu - A  Manyere	\N	104	SEM	158	30	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2171	2171	MonTueWedThu	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2170	2412	OTFYR3	Period3 - SEM 2 - TueThu - I  Chidavaenzi	\N	103	SEM	158	18	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2170	2170	TueThu	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2169	2506	OCYR4	Period1 - SEM 2 - MonTueWedThuFri - John  Stacer	\N	101	SEM	158	50	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	2169	2169	MonTueWedThuFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2168	2438	HOCTMT	Period4 - SEM1 - TueThu - C  Nyandoro	\N	104	SEM	159	59	YR 3	\N	0	Y	Y	Y	N	\N	\N	\N	2168	2168	TueThu	62	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2167	2425	HOMP	Period3 - SEM1 - TueThuFri - John  Sanni	\N	103	SEM	159	83	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2167	2167	TueThuFri	62	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2166	2669	DFL	Period3 - SEM 2 - TueFri - Kizito  Kiyimba	\N	103	SEM	158	13	DYR3	\N	0	Y	Y	Y	N	\N	\N	\N	2166	2166	TueFri	62	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2165	2670	COMPS	Period4 - SEM 2 - TueFri - K  Esenther	\N	104	SEM	158	22	DYR3	\N	0	Y	Y	Y	N	\N	\N	\N	2165	2165	TueFri	62	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2164	2671	MHBT	Period3 - SEM 2 - WedThuFri - John  Sanni	\N	103	SEM	158	83	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2164	2164	WedThuFri	62	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2163	2672	AFT	Period1 - SEM 2 - MonFri - Francis  Zangairai	\N	101	SEM	158	78	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2163	2163	MonFri	62	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2162	2673	AQKB	Period2 - SEM1 - MonFri - T  Sherman	\N	102	SEM	159	21	Elective	\N	0	Y	Y	Y	N	\N	\N	\N	2162	2162	MonFri	62	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2161	2509	LLEL	Period5 - SEM1 - MonFri - I  Chidavaenzi	\N	105	SEM	159	18	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2161	2161	MonFri	62	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2160	2598	PCC	Period5 - SEM 2 - MonWed - A  Mandeya	\N	105	SEM	158	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2160	2160	MonWed	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2158	2664	PSYR3	Period4 - SEM1 - MonThu - Kizito  Kiyimba	\N	104	SEM	159	13	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2158	2158	MonThu	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2157	2568	MRS	Period1 - SEM1 - TueThu - C  Nyandoro	\N	101	SEM	159	59	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2157	2157	TueThu	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2156	2641	VT2YR1	Period3 - SEM1 - Mon - Joseph  Mahlahla	\N	103	SEM	159	79	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2156	2156	Mon	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2155	2644	BAFL	Period3 - SEM1 - MonThuFri - Dominique  Karani	\N	103	SEM	159	54	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2155	2155	MonThuFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2154	2594	MRYR1	Period6 - SEM1 - TueWed - C  Nyandoro	\N	106	SEM	159	59	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2154	2154	TueWed	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2153	2625	POLA	Period4 - SEM1 - TueFri - Kizito  Kiyimba	\N	104	SEM	159	13	MYA	\N	0	Y	Y	Y	N	\N	\N	\N	2153	2153	TueFri	63	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2152	2645	DISSER	Period5 - SEM1 - MonWedThu - Costa  Virgilio	\N	105	SEM	159	33	MYA	\N	0	Y	Y	Y	N	\N	\N	\N	2152	2152	MonWedThu	63	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2151	2551	PHOG	Period5 - SEM1 - WedFri - T  Sherman	\N	105	SEM	159	21	MAYR	\N	0	Y	Y	Y	N	\N	\N	\N	2151	2151	WedFri	63	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2150	2553	PHWR	Period4 - SEM1 - TueWed - C  Nyandoro	\N	104	SEM	159	59	MAYR	\N	0	Y	Y	Y	N	\N	\N	\N	2150	2150	TueWed	63	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2149	2613	PEDMA	Period3 - SEM1 - WedFri - C  Nyandoro	\N	103	SEM	159	59	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2149	2149	WedFri	63	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2148	2400	ARPH	Period4 - SEM1 - MonFri - T  Sherman	\N	104	SEM	159	21	MAYR	\N	0	Y	Y	Y	N	\N	\N	\N	2148	2148	MonFri	63	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2147	2549	IGSPI	Period6 - SEM1 - MonThuFri - A  Manyere	\N	106	SEM	159	30	MAYR	\N	0	Y	Y	Y	N	\N	\N	\N	2147	2147	MonThuFri	63	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2146	2467	GREEK	Period2 - SEM1 - TueWedThuFri - A  Chennells	\N	102	SEM	159	42	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2146	2146	TueWedThuFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2145	2465	ALFYR2	Period8 - SEM1 - MonThuFri - Dominique  Karani	\N	108	SEM	159	54	Y2	\N	0	Y	Y	Y	N	\N	\N	\N	2145	2145	MonThuFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2144	2467	GREEK	Period7 - SEM1 - TueFri - A  Chennells	\N	107	SEM	159	42	Y2	\N	0	Y	Y	Y	N	\N	\N	\N	2144	2144	TueFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2143	2655	RWYR2	Period7 - SEM1 - MonThuFri - Francis  Zangairai	\N	107	SEM	159	78	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2143	2143	MonThuFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2142	2657	APYR2	Period7 - SEM1 - MonThuFri - Costa  Virgilio	\N	107	SEM	159	33	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2142	2142	MonThuFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2141	2556	PFDS	Period7 - SEM1 - MonTueFri - John  Stacer	\N	107	SEM	159	50	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2141	2141	MonTueFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2140	2554	PHILAN	Period8 - SEM1 - MonTueWedThu - Kizito  Kiyimba	\N	108	SEM	159	13	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2140	2140	MonTueWedThu	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2139	2535	NIETZ	Period8 - SEM1 - MonTueFri - Costa  Virgilio	\N	108	SEM	159	33	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2139	2139	MonTueFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2138	2535	NIETZ	Period6 - SEM1 - MonThu - Costa  Virgilio	\N	106	SEM	159	33	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2138	2138	MonThu	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2137	2564	ELEL	Period8 - SEM1 - MonWed - Costa  Virgilio	\N	108	SEM	159	33	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2137	2137	MonWed	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2136	2401	ARPH	Period6 - SEM1 - MonThuFri - T  Sherman	\N	106	SEM	159	21	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2136	2136	MonThuFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2135	2401	ARPH	Period8 - SEM1 - MonTueFri - T  Sherman	\N	108	SEM	159	21	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2135	2135	MonTueFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2134	2542	ACHEBE	Period8 - SEM1 - MonThuFri - A  Chennells	\N	108	SEM	159	42	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2134	2134	MonThuFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2133	2550	ISLAM	Period5 - SEM1 - MonTueWed - Francis  Zangairai	\N	105	SEM	159	78	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2133	2133	MonTueWed	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2132	2552	MARX	Period5 - SEM1 - MonTueWedThuFri - Francis  Zangairai	\N	105	SEM	159	78	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2132	2132	MonTueWedThuFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2131	2468	HIVAIDS	Period8 - SEM1 - MonThuFri - A  Mandeya	\N	108	SEM	159	20	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2131	2131	MonThuFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2130	2557	PHWR	Period8 - SEM1 - MonTueFri - C  Nyandoro	\N	108	SEM	159	59	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2130	2130	MonTueFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2129	2686	ARGWR	Period8 - SEM 2 - MonFri - K  Esenther	\N	108	SEM	158	22	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2129	2129	MonFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2128	2595	LYR1	Period8 - SEM 2 - WedThuFri - Henry  Ibekwe	\N	108	SEM	158	89	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2128	2128	WedThuFri	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2127	2574	OCYR1	Period4 - SEM 2 - MonThu - A  Manyere	\N	104	SEM	158	30	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2127	2127	MonThu	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2126	2646	FLYR1	Period1 - SEM 2 - MonFri - Dominique  Karani	\N	101	SEM	158	54	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2126	2126	MonFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2125	2445	ECONS	Period8 - SEM 2 - MonFri - Costa  Virgilio	\N	108	SEM	158	33	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2125	2125	MonFri	63	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2124	2449	LOGIC	Period8 - SEM 2 - MonWedThu - Kizito  Kiyimba	\N	108	SEM	158	13	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2124	2124	MonWedThu	63	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2123	2543	MLOGIC	Period8 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	108	SEM	158	13	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2123	2123	MonWedFri	63	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2122	2555	NGUGI	Period8 - SEM 2 - MonThuFri - A  Chennells	\N	108	SEM	158	42	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2122	2122	MonThuFri	63	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2121	2453	CONTPHIL	Period8 - SEM 2 - MonThuFri - Costa  Virgilio	\N	108	SEM	158	33	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2121	2121	MonThuFri	63	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2120	2402	PHILTEK	Period8 - SEM 2 - TueThuFri - Kizito  Kiyimba	\N	108	SEM	158	13	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2120	2120	TueThuFri	63	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2119	2469	SCIEREL	Period8 - SEM 2 - TueWedThuFri - Costa  Virgilio	\N	108	SEM	158	33	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2119	2119	TueWedThuFri	63	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2048	2601	ROA	Period1 - SEM 2 - MonThuFri - Francis  Zangairai	\N	101	SEM	158	78	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2048	2048	MonThuFri	61	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2049	2602	LOGIC	Period1 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	101	SEM	158	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2049	2049	MonWedFri	61	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2050	2684	PHATH	Period7 - SEM1 - MonFri - Costa  Virgilio	\N	107	SEM	159	33	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2050	2050	MonFri	59	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2051	2683	PHATH	Period8 - SEM1 - TueFri - Costa  Virgilio	\N	108	SEM	159	33	Y2	\N	0	Y	Y	Y	N	\N	\N	\N	2051	2051	TueFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2052	2614	HAPPUG1	Period3 - SEM1 - MonWedFri - Costa  Virgilio	\N	103	SEM	159	33	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2052	2052	MonWedFri	62	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2053	2682	MFAN	Period5 - SEM 2 - MonTueFri - A  Chennells	\N	105	SEM	158	42	Elective	\N	0	Y	Y	Y	N	\N	\N	\N	2053	2053	MonTueFri	62	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2054	2681	PHOR	Period8 - SEM 2 - MonWedThu - Francis  Zangairai	\N	108	SEM	158	78	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2054	2054	MonWedThu	62	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2055	2678	MHBT	Period6 - SEM 2 - MonThuFri - John  Sanni	\N	106	SEM	158	83	Elective	\N	0	Y	Y	Y	N	\N	\N	\N	2055	2055	MonThuFri	62	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2056	2677	OIAF	Period5 - SEM 2 - MonFri - Patrick  Ryan	\N	105	SEM	158	84	Elective	\N	0	Y	Y	Y	N	\N	\N	\N	2056	2056	MonFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2057	2676	HPCIK	Period4 - SEM 2 - MonThu - Philip  Rossi	\N	104	SEM	158	86	PUG	\N	0	Y	Y	Y	N	\N	\N	\N	2057	2057	MonThu	62	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2058	2680	PHOR	Period7 - SEM 2 - MonThuFri - Francis  Zangairai	\N	107	SEM	158	78	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2058	2058	MonThuFri	62	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2059	2665	PLYR3	Period2 - SEM1 - MonWedFri - Costa  Virgilio	\N	102	SEM	159	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	2059	2059	MonWedFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2060	2685	PFDS	Period5 - SEM1 - MonTueThu - John  Stacer	\N	105	SEM	159	50	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2060	2060	MonTueThu	63	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2061	2542	ACHEBE	Period6 - SEM1 - MonTueThuFri - A  Chennells	\N	106	SEM	159	42	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2061	2061	MonTueThuFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2062	2674	HPCIK	Period6 - SEM1 - MonFri - Costa  Virgilio	\N	106	SEM	159	33	Elective	\N	0	Y	Y	Y	N	\N	\N	\N	2062	2062	MonFri	63	42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3409	3638	PHYSICS	APH16S2P1 - SEM 2 -  - Mayamicho  Kachipapa	\N	248	SEM	183	107	\N	\N	2	Y	Y	Y	N	\N	\N	\N	3409	3409	\N	94	57	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3426	3657	PHYSICS	PUG16S2P6 - SEM 2 -  - Mayamicho  Kachipapa	\N	264	SEM	183	107	\N	\N	2	Y	Y	Y	N	\N	\N	\N	3426	3426	\N	94	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3323	3308	HIVAIDS	Period8 - SEM 2 - WedFri - A  Mandeya	\N	221	SEM	178	20	\N	\N	0	Y	Y	Y	N	\N	\N	\N	3323	3323	WedFri	87	56	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3298	3553	APYR1	APH16S2P1 - SEM 2 -  - Evaristus O Ekwueme	\N	248	SEM	183	85	YR1	\N	22	Y	Y	Y	N	\N	\N	\N	3298	3298	\N	94	57	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3296	3321	POM	PUG16S1P3 - SEM1 - Tue - Stephen  Buckland	\N	246	SEM	184	101	YR2	\N	6	Y	Y	Y	N	\N	\N	\N	3296	3296	Tue	94	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3292	3555	BAFL	APH16S1P1 - SEM1 - Tue - Dominique  Karani	\N	241	SEM	184	54	YR1	\N	22	Y	Y	Y	N	\N	\N	\N	3292	3292	Tue	94	57	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3290	3328	FLPUG1	PUG16S1P1 - SEM1 - Tue - Dominique  Karani	\N	254	SEM	184	54	YR1	\N	4	Y	Y	Y	N	\N	\N	\N	3290	3290	Tue	94	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3275	3370	FL	PUG16S2P4 - SEM 2 -  - Kizito  Kiyimba	\N	262	SEM	183	13	YR1	\N	1	Y	Y	Y	N	\N	\N	\N	3275	3275	\N	94	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3201	3336	PGPUG3	PUG16S1P5 - SEM1 - MonWed - T  Sherman	\N	257	SEM	184	21	YR4	\N	9	Y	Y	Y	N	\N	\N	\N	3201	3201	MonWed	94	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3193	3340	PSDPUGE	PUG16S2P4 - SEM 2 - MonTueWedThu - Roland  Von Nidda	\N	262	SEM	183	103	Aud Visual	\N	4	Y	Y	Y	N	\N	\N	\N	3193	3193	\N	94	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3059	3500	CPYR3	APH16S2P1 - SEM 2 -  - Francis  Koshoffa	\N	248	SEM	183	97	YR3	\N	12	Y	Y	Y	N	\N	\N	\N	3059	3059	\N	94	57	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3060	3327	EPUG1	PUG16S2P4 - SEM 2 -  - Theogene  Ngirinshuti	\N	262	SEM	183	108	YR2	\N	7	Y	Y	Y	N	\N	\N	\N	3060	3060	\N	94	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3075	3359	FAEL	Period1 - SEM 2 - Wed - T  Sherman	\N	213	SEM	178	21	Y4	\N	0	Y	Y	Y	N	\N	\N	\N	3075	3075	Wed	83	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3159	3480	APMA	MPA16S2P4 - SEM 2 - MonThu - Evaristus O Ekwueme	\N	286	SEM	183	85	YR3	\N	2	Y	Y	Y	N	\N	\N	\N	3159	3159	MonThu	94	58	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3062	3469	EYR2	APH16S2P6 - SEM 2 -  - Theogene  Ngirinshuti	\N	253	SEM	183	108	YR2	\N	20	Y	Y	Y	N	\N	\N	\N	3062	3062	\N	94	57	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3028	3412	OCYR1	APH16S2P5 - SEM 2 -  - T  Sherman	\N	252	SEM	183	21	YR1	\N	18	Y	Y	Y	N	\N	\N	\N	3028	3028	\N	94	57	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3030	3517	ARGWR	APH16S2P3 - SEM 2 -  - K  Esenther	\N	250	SEM	183	22	\N	\N	18	Y	Y	Y	N	\N	\N	\N	3030	3030	\N	94	57	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3390	3620	HEGEL	APH16S2P2 - SEM 2 -  - Francis  Koshoffa	\N	249	SEM	183	97	\N	\N	6	Y	Y	Y	N	\N	\N	\N	3390	3390	\N	94	57	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	