--
-- PostgreSQL database dump
--

-- Dumped from database version 10.14 (Ubuntu 10.14-1.pgdg16.04+1)
-- Dumped by pg_dump version 10.14 (Ubuntu 10.14-1.pgdg16.04+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: mdl_analytics_indicator_calc; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_analytics_indicator_calc (
    id bigint NOT NULL,
    starttime bigint NOT NULL,
    endtime bigint NOT NULL,
    contextid bigint NOT NULL,
    sampleorigin character varying(255) DEFAULT ''::character varying NOT NULL,
    sampleid bigint NOT NULL,
    indicator character varying(255) DEFAULT ''::character varying NOT NULL,
    value numeric(10,2),
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_analytics_indicator_calc OWNER TO postgres;

--
-- Name: TABLE mdl_analytics_indicator_calc; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_analytics_indicator_calc IS 'Stored indicator calculations';


--
-- Name: mdl_analytics_indicator_calc_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_analytics_indicator_calc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_analytics_indicator_calc_id_seq OWNER TO postgres;

--
-- Name: mdl_analytics_indicator_calc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_analytics_indicator_calc_id_seq OWNED BY public.mdl_analytics_indicator_calc.id;


--
-- Name: mdl_analytics_models; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_analytics_models (
    id bigint NOT NULL,
    enabled smallint DEFAULT 0 NOT NULL,
    trained smallint DEFAULT 0 NOT NULL,
    name character varying(1333),
    target character varying(255) DEFAULT ''::character varying NOT NULL,
    indicators text NOT NULL,
    timesplitting character varying(255),
    predictionsprocessor character varying(255),
    version bigint NOT NULL,
    contextids text,
    timecreated bigint,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL
);


ALTER TABLE public.mdl_analytics_models OWNER TO postgres;

--
-- Name: TABLE mdl_analytics_models; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_analytics_models IS 'Analytic models.';


--
-- Name: mdl_analytics_models_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_analytics_models_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_analytics_models_id_seq OWNER TO postgres;

--
-- Name: mdl_analytics_models_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_analytics_models_id_seq OWNED BY public.mdl_analytics_models.id;


--
-- Name: mdl_analytics_models_log; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_analytics_models_log (
    id bigint NOT NULL,
    modelid bigint NOT NULL,
    version bigint NOT NULL,
    evaluationmode character varying(50) DEFAULT ''::character varying NOT NULL,
    target character varying(255) DEFAULT ''::character varying NOT NULL,
    indicators text NOT NULL,
    timesplitting character varying(255),
    score numeric(10,5) DEFAULT 0 NOT NULL,
    info text,
    dir text NOT NULL,
    timecreated bigint NOT NULL,
    usermodified bigint NOT NULL
);


ALTER TABLE public.mdl_analytics_models_log OWNER TO postgres;

--
-- Name: TABLE mdl_analytics_models_log; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_analytics_models_log IS 'Analytic models changes during evaluation.';


--
-- Name: mdl_analytics_models_log_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_analytics_models_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_analytics_models_log_id_seq OWNER TO postgres;

--
-- Name: mdl_analytics_models_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_analytics_models_log_id_seq OWNED BY public.mdl_analytics_models_log.id;


--
-- Name: mdl_analytics_predict_samples; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_analytics_predict_samples (
    id bigint NOT NULL,
    modelid bigint NOT NULL,
    analysableid bigint NOT NULL,
    timesplitting character varying(255) DEFAULT ''::character varying NOT NULL,
    rangeindex bigint NOT NULL,
    sampleids text NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_analytics_predict_samples OWNER TO postgres;

--
-- Name: TABLE mdl_analytics_predict_samples; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_analytics_predict_samples IS 'Samples already used for predictions.';


--
-- Name: mdl_analytics_predict_samples_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_analytics_predict_samples_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_analytics_predict_samples_id_seq OWNER TO postgres;

--
-- Name: mdl_analytics_predict_samples_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_analytics_predict_samples_id_seq OWNED BY public.mdl_analytics_predict_samples.id;


--
-- Name: mdl_analytics_prediction_actions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_analytics_prediction_actions (
    id bigint NOT NULL,
    predictionid bigint NOT NULL,
    userid bigint NOT NULL,
    actionname character varying(255) DEFAULT ''::character varying NOT NULL,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_analytics_prediction_actions OWNER TO postgres;

--
-- Name: TABLE mdl_analytics_prediction_actions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_analytics_prediction_actions IS 'Register of user actions over predictions.';


--
-- Name: mdl_analytics_prediction_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_analytics_prediction_actions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_analytics_prediction_actions_id_seq OWNER TO postgres;

--
-- Name: mdl_analytics_prediction_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_analytics_prediction_actions_id_seq OWNED BY public.mdl_analytics_prediction_actions.id;


--
-- Name: mdl_analytics_predictions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_analytics_predictions (
    id bigint NOT NULL,
    modelid bigint NOT NULL,
    contextid bigint NOT NULL,
    sampleid bigint NOT NULL,
    rangeindex integer NOT NULL,
    prediction numeric(10,2) NOT NULL,
    predictionscore numeric(10,5) NOT NULL,
    calculations text NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timestart bigint,
    timeend bigint
);


ALTER TABLE public.mdl_analytics_predictions OWNER TO postgres;

--
-- Name: TABLE mdl_analytics_predictions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_analytics_predictions IS 'Predictions';


--
-- Name: mdl_analytics_predictions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_analytics_predictions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_analytics_predictions_id_seq OWNER TO postgres;

--
-- Name: mdl_analytics_predictions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_analytics_predictions_id_seq OWNED BY public.mdl_analytics_predictions.id;


--
-- Name: mdl_analytics_train_samples; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_analytics_train_samples (
    id bigint NOT NULL,
    modelid bigint NOT NULL,
    analysableid bigint NOT NULL,
    timesplitting character varying(255) DEFAULT ''::character varying NOT NULL,
    sampleids text NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_analytics_train_samples OWNER TO postgres;

--
-- Name: TABLE mdl_analytics_train_samples; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_analytics_train_samples IS 'Samples used for training';


--
-- Name: mdl_analytics_train_samples_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_analytics_train_samples_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_analytics_train_samples_id_seq OWNER TO postgres;

--
-- Name: mdl_analytics_train_samples_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_analytics_train_samples_id_seq OWNED BY public.mdl_analytics_train_samples.id;


--
-- Name: mdl_analytics_used_analysables; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_analytics_used_analysables (
    id bigint NOT NULL,
    modelid bigint NOT NULL,
    action character varying(50) DEFAULT ''::character varying NOT NULL,
    analysableid bigint NOT NULL,
    firstanalysis bigint NOT NULL,
    timeanalysed bigint NOT NULL
);


ALTER TABLE public.mdl_analytics_used_analysables OWNER TO postgres;

--
-- Name: TABLE mdl_analytics_used_analysables; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_analytics_used_analysables IS 'List of analysables used by each model';


--
-- Name: mdl_analytics_used_analysables_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_analytics_used_analysables_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_analytics_used_analysables_id_seq OWNER TO postgres;

--
-- Name: mdl_analytics_used_analysables_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_analytics_used_analysables_id_seq OWNED BY public.mdl_analytics_used_analysables.id;


--
-- Name: mdl_analytics_used_files; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_analytics_used_files (
    id bigint NOT NULL,
    modelid bigint DEFAULT 0 NOT NULL,
    fileid bigint DEFAULT 0 NOT NULL,
    action character varying(50) DEFAULT ''::character varying NOT NULL,
    "time" bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_analytics_used_files OWNER TO postgres;

--
-- Name: TABLE mdl_analytics_used_files; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_analytics_used_files IS 'Files that have already been used for training and prediction.';


--
-- Name: mdl_analytics_used_files_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_analytics_used_files_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_analytics_used_files_id_seq OWNER TO postgres;

--
-- Name: mdl_analytics_used_files_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_analytics_used_files_id_seq OWNED BY public.mdl_analytics_used_files.id;


--
-- Name: mdl_assign; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assign (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text NOT NULL,
    introformat smallint DEFAULT 0 NOT NULL,
    alwaysshowdescription smallint DEFAULT 0 NOT NULL,
    nosubmissions smallint DEFAULT 0 NOT NULL,
    submissiondrafts smallint DEFAULT 0 NOT NULL,
    sendnotifications smallint DEFAULT 0 NOT NULL,
    sendlatenotifications smallint DEFAULT 0 NOT NULL,
    duedate bigint DEFAULT 0 NOT NULL,
    allowsubmissionsfromdate bigint DEFAULT 0 NOT NULL,
    grade bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    requiresubmissionstatement smallint DEFAULT 0 NOT NULL,
    completionsubmit smallint DEFAULT 0 NOT NULL,
    cutoffdate bigint DEFAULT 0 NOT NULL,
    gradingduedate bigint DEFAULT 0 NOT NULL,
    teamsubmission smallint DEFAULT 0 NOT NULL,
    requireallteammemberssubmit smallint DEFAULT 0 NOT NULL,
    teamsubmissiongroupingid bigint DEFAULT 0 NOT NULL,
    blindmarking smallint DEFAULT 0 NOT NULL,
    hidegrader smallint DEFAULT 0 NOT NULL,
    revealidentities smallint DEFAULT 0 NOT NULL,
    attemptreopenmethod character varying(10) DEFAULT 'none'::character varying NOT NULL,
    maxattempts integer DEFAULT '-1'::integer NOT NULL,
    markingworkflow smallint DEFAULT 0 NOT NULL,
    markingallocation smallint DEFAULT 0 NOT NULL,
    sendstudentnotifications smallint DEFAULT 1 NOT NULL,
    preventsubmissionnotingroup smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_assign OWNER TO postgres;

--
-- Name: TABLE mdl_assign; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assign IS 'This table saves information about an instance of mod_assign in a course.';


--
-- Name: mdl_assign_grades; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assign_grades (
    id bigint NOT NULL,
    assignment bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    grader bigint DEFAULT 0 NOT NULL,
    grade numeric(10,5) DEFAULT 0,
    attemptnumber bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_assign_grades OWNER TO postgres;

--
-- Name: TABLE mdl_assign_grades; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assign_grades IS 'Grading information about a single assignment submission.';


--
-- Name: mdl_assign_grades_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assign_grades_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assign_grades_id_seq OWNER TO postgres;

--
-- Name: mdl_assign_grades_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assign_grades_id_seq OWNED BY public.mdl_assign_grades.id;


--
-- Name: mdl_assign_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assign_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assign_id_seq OWNER TO postgres;

--
-- Name: mdl_assign_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assign_id_seq OWNED BY public.mdl_assign.id;


--
-- Name: mdl_assign_overrides; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assign_overrides (
    id bigint NOT NULL,
    assignid bigint DEFAULT 0 NOT NULL,
    groupid bigint,
    userid bigint,
    sortorder bigint,
    allowsubmissionsfromdate bigint,
    duedate bigint,
    cutoffdate bigint
);


ALTER TABLE public.mdl_assign_overrides OWNER TO postgres;

--
-- Name: TABLE mdl_assign_overrides; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assign_overrides IS 'The overrides to assign settings.';


--
-- Name: mdl_assign_overrides_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assign_overrides_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assign_overrides_id_seq OWNER TO postgres;

--
-- Name: mdl_assign_overrides_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assign_overrides_id_seq OWNED BY public.mdl_assign_overrides.id;


--
-- Name: mdl_assign_plugin_config; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assign_plugin_config (
    id bigint NOT NULL,
    assignment bigint DEFAULT 0 NOT NULL,
    plugin character varying(28) DEFAULT ''::character varying NOT NULL,
    subtype character varying(28) DEFAULT ''::character varying NOT NULL,
    name character varying(28) DEFAULT ''::character varying NOT NULL,
    value text
);


ALTER TABLE public.mdl_assign_plugin_config OWNER TO postgres;

--
-- Name: TABLE mdl_assign_plugin_config; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assign_plugin_config IS 'Config data for an instance of a plugin in an assignment.';


--
-- Name: mdl_assign_plugin_config_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assign_plugin_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assign_plugin_config_id_seq OWNER TO postgres;

--
-- Name: mdl_assign_plugin_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assign_plugin_config_id_seq OWNED BY public.mdl_assign_plugin_config.id;


--
-- Name: mdl_assign_submission; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assign_submission (
    id bigint NOT NULL,
    assignment bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    status character varying(10),
    groupid bigint DEFAULT 0 NOT NULL,
    attemptnumber bigint DEFAULT 0 NOT NULL,
    latest smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_assign_submission OWNER TO postgres;

--
-- Name: TABLE mdl_assign_submission; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assign_submission IS 'This table keeps information about student interactions with the mod/assign. This is limited to metadata about a student submission but does not include the submission itself which is stored by plugins.';


--
-- Name: mdl_assign_submission_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assign_submission_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assign_submission_id_seq OWNER TO postgres;

--
-- Name: mdl_assign_submission_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assign_submission_id_seq OWNED BY public.mdl_assign_submission.id;


--
-- Name: mdl_assign_user_flags; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assign_user_flags (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    assignment bigint DEFAULT 0 NOT NULL,
    locked bigint DEFAULT 0 NOT NULL,
    mailed smallint DEFAULT 0 NOT NULL,
    extensionduedate bigint DEFAULT 0 NOT NULL,
    workflowstate character varying(20),
    allocatedmarker bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_assign_user_flags OWNER TO postgres;

--
-- Name: TABLE mdl_assign_user_flags; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assign_user_flags IS 'List of flags that can be set for a single user in a single assignment.';


--
-- Name: mdl_assign_user_flags_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assign_user_flags_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assign_user_flags_id_seq OWNER TO postgres;

--
-- Name: mdl_assign_user_flags_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assign_user_flags_id_seq OWNED BY public.mdl_assign_user_flags.id;


--
-- Name: mdl_assign_user_mapping; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assign_user_mapping (
    id bigint NOT NULL,
    assignment bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_assign_user_mapping OWNER TO postgres;

--
-- Name: TABLE mdl_assign_user_mapping; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assign_user_mapping IS 'Map an assignment specific id number to a user';


--
-- Name: mdl_assign_user_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assign_user_mapping_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assign_user_mapping_id_seq OWNER TO postgres;

--
-- Name: mdl_assign_user_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assign_user_mapping_id_seq OWNED BY public.mdl_assign_user_mapping.id;


--
-- Name: mdl_assignfeedback_comments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assignfeedback_comments (
    id bigint NOT NULL,
    assignment bigint DEFAULT 0 NOT NULL,
    grade bigint DEFAULT 0 NOT NULL,
    commenttext text,
    commentformat smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_assignfeedback_comments OWNER TO postgres;

--
-- Name: TABLE mdl_assignfeedback_comments; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assignfeedback_comments IS 'Text feedback for submitted assignments';


--
-- Name: mdl_assignfeedback_comments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assignfeedback_comments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assignfeedback_comments_id_seq OWNER TO postgres;

--
-- Name: mdl_assignfeedback_comments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assignfeedback_comments_id_seq OWNED BY public.mdl_assignfeedback_comments.id;


--
-- Name: mdl_assignfeedback_editpdf_annot; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assignfeedback_editpdf_annot (
    id bigint NOT NULL,
    gradeid bigint DEFAULT 0 NOT NULL,
    pageno bigint DEFAULT 0 NOT NULL,
    x bigint DEFAULT 0,
    y bigint DEFAULT 0,
    endx bigint DEFAULT 0,
    endy bigint DEFAULT 0,
    path text,
    type character varying(10) DEFAULT 'line'::character varying,
    colour character varying(10) DEFAULT 'black'::character varying,
    draft smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_assignfeedback_editpdf_annot OWNER TO postgres;

--
-- Name: TABLE mdl_assignfeedback_editpdf_annot; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assignfeedback_editpdf_annot IS 'stores annotations added to pdfs submitted by students';


--
-- Name: mdl_assignfeedback_editpdf_annot_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assignfeedback_editpdf_annot_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assignfeedback_editpdf_annot_id_seq OWNER TO postgres;

--
-- Name: mdl_assignfeedback_editpdf_annot_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assignfeedback_editpdf_annot_id_seq OWNED BY public.mdl_assignfeedback_editpdf_annot.id;


--
-- Name: mdl_assignfeedback_editpdf_cmnt; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assignfeedback_editpdf_cmnt (
    id bigint NOT NULL,
    gradeid bigint DEFAULT 0 NOT NULL,
    x bigint DEFAULT 0,
    y bigint DEFAULT 0,
    width bigint DEFAULT 120,
    rawtext text,
    pageno bigint DEFAULT 0 NOT NULL,
    colour character varying(10) DEFAULT 'black'::character varying,
    draft smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_assignfeedback_editpdf_cmnt OWNER TO postgres;

--
-- Name: TABLE mdl_assignfeedback_editpdf_cmnt; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assignfeedback_editpdf_cmnt IS 'Stores comments added to pdfs';


--
-- Name: mdl_assignfeedback_editpdf_cmnt_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assignfeedback_editpdf_cmnt_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assignfeedback_editpdf_cmnt_id_seq OWNER TO postgres;

--
-- Name: mdl_assignfeedback_editpdf_cmnt_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assignfeedback_editpdf_cmnt_id_seq OWNED BY public.mdl_assignfeedback_editpdf_cmnt.id;


--
-- Name: mdl_assignfeedback_editpdf_queue; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assignfeedback_editpdf_queue (
    id bigint NOT NULL,
    submissionid bigint NOT NULL,
    submissionattempt bigint NOT NULL,
    attemptedconversions bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_assignfeedback_editpdf_queue OWNER TO postgres;

--
-- Name: TABLE mdl_assignfeedback_editpdf_queue; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assignfeedback_editpdf_queue IS 'Queue for processing.';


--
-- Name: mdl_assignfeedback_editpdf_queue_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assignfeedback_editpdf_queue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assignfeedback_editpdf_queue_id_seq OWNER TO postgres;

--
-- Name: mdl_assignfeedback_editpdf_queue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assignfeedback_editpdf_queue_id_seq OWNED BY public.mdl_assignfeedback_editpdf_queue.id;


--
-- Name: mdl_assignfeedback_editpdf_quick; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assignfeedback_editpdf_quick (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    rawtext text NOT NULL,
    width bigint DEFAULT 120 NOT NULL,
    colour character varying(10) DEFAULT 'yellow'::character varying
);


ALTER TABLE public.mdl_assignfeedback_editpdf_quick OWNER TO postgres;

--
-- Name: TABLE mdl_assignfeedback_editpdf_quick; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assignfeedback_editpdf_quick IS 'Stores teacher specified quicklist comments';


--
-- Name: mdl_assignfeedback_editpdf_quick_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assignfeedback_editpdf_quick_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assignfeedback_editpdf_quick_id_seq OWNER TO postgres;

--
-- Name: mdl_assignfeedback_editpdf_quick_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assignfeedback_editpdf_quick_id_seq OWNED BY public.mdl_assignfeedback_editpdf_quick.id;


--
-- Name: mdl_assignfeedback_editpdf_rot; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assignfeedback_editpdf_rot (
    id bigint NOT NULL,
    gradeid bigint DEFAULT 0 NOT NULL,
    pageno bigint DEFAULT 0 NOT NULL,
    pathnamehash text NOT NULL,
    isrotated smallint DEFAULT 0 NOT NULL,
    degree bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_assignfeedback_editpdf_rot OWNER TO postgres;

--
-- Name: TABLE mdl_assignfeedback_editpdf_rot; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assignfeedback_editpdf_rot IS 'Stores rotation information of a page.';


--
-- Name: mdl_assignfeedback_editpdf_rot_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assignfeedback_editpdf_rot_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assignfeedback_editpdf_rot_id_seq OWNER TO postgres;

--
-- Name: mdl_assignfeedback_editpdf_rot_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assignfeedback_editpdf_rot_id_seq OWNED BY public.mdl_assignfeedback_editpdf_rot.id;


--
-- Name: mdl_assignfeedback_file; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assignfeedback_file (
    id bigint NOT NULL,
    assignment bigint DEFAULT 0 NOT NULL,
    grade bigint DEFAULT 0 NOT NULL,
    numfiles bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_assignfeedback_file OWNER TO postgres;

--
-- Name: TABLE mdl_assignfeedback_file; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assignfeedback_file IS 'Stores info about the number of files submitted by a student.';


--
-- Name: mdl_assignfeedback_file_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assignfeedback_file_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assignfeedback_file_id_seq OWNER TO postgres;

--
-- Name: mdl_assignfeedback_file_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assignfeedback_file_id_seq OWNED BY public.mdl_assignfeedback_file.id;


--
-- Name: mdl_assignment; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assignment (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text NOT NULL,
    introformat smallint DEFAULT 0 NOT NULL,
    assignmenttype character varying(50) DEFAULT ''::character varying NOT NULL,
    resubmit smallint DEFAULT 0 NOT NULL,
    preventlate smallint DEFAULT 0 NOT NULL,
    emailteachers smallint DEFAULT 0 NOT NULL,
    var1 bigint DEFAULT 0,
    var2 bigint DEFAULT 0,
    var3 bigint DEFAULT 0,
    var4 bigint DEFAULT 0,
    var5 bigint DEFAULT 0,
    maxbytes bigint DEFAULT 100000 NOT NULL,
    timedue bigint DEFAULT 0 NOT NULL,
    timeavailable bigint DEFAULT 0 NOT NULL,
    grade bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_assignment OWNER TO postgres;

--
-- Name: TABLE mdl_assignment; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assignment IS 'Defines assignments';


--
-- Name: mdl_assignment_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assignment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assignment_id_seq OWNER TO postgres;

--
-- Name: mdl_assignment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assignment_id_seq OWNED BY public.mdl_assignment.id;


--
-- Name: mdl_assignment_submissions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assignment_submissions (
    id bigint NOT NULL,
    assignment bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    numfiles bigint DEFAULT 0 NOT NULL,
    data1 text,
    data2 text,
    grade bigint DEFAULT 0 NOT NULL,
    submissioncomment text NOT NULL,
    format smallint DEFAULT 0 NOT NULL,
    teacher bigint DEFAULT 0 NOT NULL,
    timemarked bigint DEFAULT 0 NOT NULL,
    mailed smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_assignment_submissions OWNER TO postgres;

--
-- Name: TABLE mdl_assignment_submissions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assignment_submissions IS 'Info about submitted assignments';


--
-- Name: mdl_assignment_submissions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assignment_submissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assignment_submissions_id_seq OWNER TO postgres;

--
-- Name: mdl_assignment_submissions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assignment_submissions_id_seq OWNED BY public.mdl_assignment_submissions.id;


--
-- Name: mdl_assignment_upgrade; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assignment_upgrade (
    id bigint NOT NULL,
    oldcmid bigint DEFAULT 0 NOT NULL,
    oldinstance bigint DEFAULT 0 NOT NULL,
    newcmid bigint DEFAULT 0 NOT NULL,
    newinstance bigint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_assignment_upgrade OWNER TO postgres;

--
-- Name: TABLE mdl_assignment_upgrade; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assignment_upgrade IS 'Info about upgraded assignments';


--
-- Name: mdl_assignment_upgrade_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assignment_upgrade_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assignment_upgrade_id_seq OWNER TO postgres;

--
-- Name: mdl_assignment_upgrade_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assignment_upgrade_id_seq OWNED BY public.mdl_assignment_upgrade.id;


--
-- Name: mdl_assignsubmission_file; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assignsubmission_file (
    id bigint NOT NULL,
    assignment bigint DEFAULT 0 NOT NULL,
    submission bigint DEFAULT 0 NOT NULL,
    numfiles bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_assignsubmission_file OWNER TO postgres;

--
-- Name: TABLE mdl_assignsubmission_file; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assignsubmission_file IS 'Info about file submissions for assignments';


--
-- Name: mdl_assignsubmission_file_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assignsubmission_file_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assignsubmission_file_id_seq OWNER TO postgres;

--
-- Name: mdl_assignsubmission_file_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assignsubmission_file_id_seq OWNED BY public.mdl_assignsubmission_file.id;


--
-- Name: mdl_assignsubmission_onlinetext; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assignsubmission_onlinetext (
    id bigint NOT NULL,
    assignment bigint DEFAULT 0 NOT NULL,
    submission bigint DEFAULT 0 NOT NULL,
    onlinetext text,
    onlineformat smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_assignsubmission_onlinetext OWNER TO postgres;

--
-- Name: TABLE mdl_assignsubmission_onlinetext; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assignsubmission_onlinetext IS 'Info about onlinetext submission';


--
-- Name: mdl_assignsubmission_onlinetext_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assignsubmission_onlinetext_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assignsubmission_onlinetext_id_seq OWNER TO postgres;

--
-- Name: mdl_assignsubmission_onlinetext_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assignsubmission_onlinetext_id_seq OWNED BY public.mdl_assignsubmission_onlinetext.id;


--
-- Name: mdl_auth_iomadoidc_prevlogin; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_auth_iomadoidc_prevlogin (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    method character varying(255) DEFAULT ''::character varying NOT NULL,
    password character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_auth_iomadoidc_prevlogin OWNER TO postgres;

--
-- Name: TABLE mdl_auth_iomadoidc_prevlogin; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_auth_iomadoidc_prevlogin IS 'Stores previous login methods.';


--
-- Name: mdl_auth_iomadoidc_prevlogin_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_auth_iomadoidc_prevlogin_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_auth_iomadoidc_prevlogin_id_seq OWNER TO postgres;

--
-- Name: mdl_auth_iomadoidc_prevlogin_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_auth_iomadoidc_prevlogin_id_seq OWNED BY public.mdl_auth_iomadoidc_prevlogin.id;


--
-- Name: mdl_auth_iomadoidc_state; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_auth_iomadoidc_state (
    id bigint NOT NULL,
    sesskey character varying(10) DEFAULT ''::character varying NOT NULL,
    state character varying(15) DEFAULT ''::character varying NOT NULL,
    nonce character varying(15) DEFAULT ''::character varying NOT NULL,
    timecreated bigint NOT NULL,
    additionaldata text
);


ALTER TABLE public.mdl_auth_iomadoidc_state OWNER TO postgres;

--
-- Name: TABLE mdl_auth_iomadoidc_state; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_auth_iomadoidc_state IS 'Map of state to sesskey.';


--
-- Name: mdl_auth_iomadoidc_state_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_auth_iomadoidc_state_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_auth_iomadoidc_state_id_seq OWNER TO postgres;

--
-- Name: mdl_auth_iomadoidc_state_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_auth_iomadoidc_state_id_seq OWNED BY public.mdl_auth_iomadoidc_state.id;


--
-- Name: mdl_auth_iomadoidc_token; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_auth_iomadoidc_token (
    id bigint NOT NULL,
    iomadoidcuniqid character varying(255) DEFAULT ''::character varying NOT NULL,
    username character varying(100) DEFAULT ''::character varying NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    iomadoidcusername character varying(255) DEFAULT ''::character varying NOT NULL,
    scope text NOT NULL,
    resource character varying(127) DEFAULT ''::character varying NOT NULL,
    authcode text NOT NULL,
    token text NOT NULL,
    expiry bigint NOT NULL,
    refreshtoken text NOT NULL,
    idtoken text NOT NULL
);


ALTER TABLE public.mdl_auth_iomadoidc_token OWNER TO postgres;

--
-- Name: TABLE mdl_auth_iomadoidc_token; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_auth_iomadoidc_token IS 'Stores tokens.';


--
-- Name: mdl_auth_iomadoidc_token_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_auth_iomadoidc_token_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_auth_iomadoidc_token_id_seq OWNER TO postgres;

--
-- Name: mdl_auth_iomadoidc_token_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_auth_iomadoidc_token_id_seq OWNED BY public.mdl_auth_iomadoidc_token.id;


--
-- Name: mdl_auth_oauth2_linked_login; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_auth_oauth2_linked_login (
    id bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL,
    userid bigint NOT NULL,
    issuerid bigint NOT NULL,
    username character varying(255) DEFAULT ''::character varying NOT NULL,
    email text NOT NULL,
    confirmtoken character varying(64) DEFAULT ''::character varying NOT NULL,
    confirmtokenexpires bigint
);


ALTER TABLE public.mdl_auth_oauth2_linked_login OWNER TO postgres;

--
-- Name: TABLE mdl_auth_oauth2_linked_login; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_auth_oauth2_linked_login IS 'Accounts linked to a users Moodle account.';


--
-- Name: mdl_auth_oauth2_linked_login_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_auth_oauth2_linked_login_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_auth_oauth2_linked_login_id_seq OWNER TO postgres;

--
-- Name: mdl_auth_oauth2_linked_login_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_auth_oauth2_linked_login_id_seq OWNED BY public.mdl_auth_oauth2_linked_login.id;


--
-- Name: mdl_backup_controllers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_backup_controllers (
    id bigint NOT NULL,
    backupid character varying(32) DEFAULT ''::character varying NOT NULL,
    operation character varying(20) DEFAULT 'backup'::character varying NOT NULL,
    type character varying(10) DEFAULT ''::character varying NOT NULL,
    itemid bigint NOT NULL,
    format character varying(20) DEFAULT ''::character varying NOT NULL,
    interactive smallint NOT NULL,
    purpose smallint NOT NULL,
    userid bigint NOT NULL,
    status smallint NOT NULL,
    execution smallint NOT NULL,
    executiontime bigint NOT NULL,
    checksum character varying(32) DEFAULT ''::character varying NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    progress numeric(15,14) DEFAULT 0 NOT NULL,
    controller text NOT NULL
);


ALTER TABLE public.mdl_backup_controllers OWNER TO postgres;

--
-- Name: TABLE mdl_backup_controllers; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_backup_controllers IS 'To store the backup_controllers as they are used';


--
-- Name: mdl_backup_controllers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_backup_controllers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_backup_controllers_id_seq OWNER TO postgres;

--
-- Name: mdl_backup_controllers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_backup_controllers_id_seq OWNED BY public.mdl_backup_controllers.id;


--
-- Name: mdl_backup_courses; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_backup_courses (
    id bigint NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    laststarttime bigint DEFAULT 0 NOT NULL,
    lastendtime bigint DEFAULT 0 NOT NULL,
    laststatus character varying(1) DEFAULT '5'::character varying NOT NULL,
    nextstarttime bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_backup_courses OWNER TO postgres;

--
-- Name: TABLE mdl_backup_courses; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_backup_courses IS 'To store every course backup status';


--
-- Name: mdl_backup_courses_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_backup_courses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_backup_courses_id_seq OWNER TO postgres;

--
-- Name: mdl_backup_courses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_backup_courses_id_seq OWNED BY public.mdl_backup_courses.id;


--
-- Name: mdl_backup_logs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_backup_logs (
    id bigint NOT NULL,
    backupid character varying(32) DEFAULT ''::character varying NOT NULL,
    loglevel smallint NOT NULL,
    message text NOT NULL,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_backup_logs OWNER TO postgres;

--
-- Name: TABLE mdl_backup_logs; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_backup_logs IS 'To store all the logs from backup and restore operations (by db logger)';


--
-- Name: mdl_backup_logs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_backup_logs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_backup_logs_id_seq OWNER TO postgres;

--
-- Name: mdl_backup_logs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_backup_logs_id_seq OWNED BY public.mdl_backup_logs.id;


--
-- Name: mdl_badge; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_badge (
    id bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    description text,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    usercreated bigint NOT NULL,
    usermodified bigint NOT NULL,
    issuername character varying(255) DEFAULT ''::character varying NOT NULL,
    issuerurl character varying(255) DEFAULT ''::character varying NOT NULL,
    issuercontact character varying(255),
    expiredate bigint,
    expireperiod bigint,
    type smallint DEFAULT 1 NOT NULL,
    courseid bigint,
    message text NOT NULL,
    messagesubject text NOT NULL,
    attachment smallint DEFAULT 1 NOT NULL,
    notification smallint DEFAULT 1 NOT NULL,
    status smallint DEFAULT 0 NOT NULL,
    nextcron bigint,
    version character varying(255),
    language character varying(255),
    imageauthorname character varying(255),
    imageauthoremail character varying(255),
    imageauthorurl character varying(255),
    imagecaption text
);


ALTER TABLE public.mdl_badge OWNER TO postgres;

--
-- Name: TABLE mdl_badge; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_badge IS 'Defines badge';


--
-- Name: mdl_badge_alignment; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_badge_alignment (
    id bigint NOT NULL,
    badgeid bigint DEFAULT 0 NOT NULL,
    targetname character varying(255) DEFAULT ''::character varying NOT NULL,
    targeturl character varying(255) DEFAULT ''::character varying NOT NULL,
    targetdescription text,
    targetframework character varying(255),
    targetcode character varying(255)
);


ALTER TABLE public.mdl_badge_alignment OWNER TO postgres;

--
-- Name: TABLE mdl_badge_alignment; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_badge_alignment IS 'Defines alignment for badges';


--
-- Name: mdl_badge_alignment_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_badge_alignment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_badge_alignment_id_seq OWNER TO postgres;

--
-- Name: mdl_badge_alignment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_badge_alignment_id_seq OWNED BY public.mdl_badge_alignment.id;


--
-- Name: mdl_badge_backpack; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_badge_backpack (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    email character varying(100) DEFAULT ''::character varying NOT NULL,
    backpackuid bigint NOT NULL,
    autosync smallint DEFAULT 0 NOT NULL,
    password character varying(50),
    externalbackpackid bigint
);


ALTER TABLE public.mdl_badge_backpack OWNER TO postgres;

--
-- Name: TABLE mdl_badge_backpack; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_badge_backpack IS 'Defines settings for connecting external backpack';


--
-- Name: mdl_badge_backpack_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_badge_backpack_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_badge_backpack_id_seq OWNER TO postgres;

--
-- Name: mdl_badge_backpack_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_badge_backpack_id_seq OWNED BY public.mdl_badge_backpack.id;


--
-- Name: mdl_badge_criteria; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_badge_criteria (
    id bigint NOT NULL,
    badgeid bigint DEFAULT 0 NOT NULL,
    criteriatype bigint,
    method smallint DEFAULT 1 NOT NULL,
    description text,
    descriptionformat smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_badge_criteria OWNER TO postgres;

--
-- Name: TABLE mdl_badge_criteria; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_badge_criteria IS 'Defines criteria for issuing badges';


--
-- Name: mdl_badge_criteria_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_badge_criteria_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_badge_criteria_id_seq OWNER TO postgres;

--
-- Name: mdl_badge_criteria_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_badge_criteria_id_seq OWNED BY public.mdl_badge_criteria.id;


--
-- Name: mdl_badge_criteria_met; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_badge_criteria_met (
    id bigint NOT NULL,
    issuedid bigint,
    critid bigint NOT NULL,
    userid bigint NOT NULL,
    datemet bigint NOT NULL
);


ALTER TABLE public.mdl_badge_criteria_met OWNER TO postgres;

--
-- Name: TABLE mdl_badge_criteria_met; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_badge_criteria_met IS 'Defines criteria that were met for an issued badge';


--
-- Name: mdl_badge_criteria_met_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_badge_criteria_met_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_badge_criteria_met_id_seq OWNER TO postgres;

--
-- Name: mdl_badge_criteria_met_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_badge_criteria_met_id_seq OWNED BY public.mdl_badge_criteria_met.id;


--
-- Name: mdl_badge_criteria_param; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_badge_criteria_param (
    id bigint NOT NULL,
    critid bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    value character varying(255)
);


ALTER TABLE public.mdl_badge_criteria_param OWNER TO postgres;

--
-- Name: TABLE mdl_badge_criteria_param; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_badge_criteria_param IS 'Defines parameters for badges criteria';


--
-- Name: mdl_badge_criteria_param_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_badge_criteria_param_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_badge_criteria_param_id_seq OWNER TO postgres;

--
-- Name: mdl_badge_criteria_param_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_badge_criteria_param_id_seq OWNED BY public.mdl_badge_criteria_param.id;


--
-- Name: mdl_badge_endorsement; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_badge_endorsement (
    id bigint NOT NULL,
    badgeid bigint DEFAULT 0 NOT NULL,
    issuername character varying(255) DEFAULT ''::character varying NOT NULL,
    issuerurl character varying(255) DEFAULT ''::character varying NOT NULL,
    issueremail character varying(255) DEFAULT ''::character varying NOT NULL,
    claimid character varying(255),
    claimcomment text,
    dateissued bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_badge_endorsement OWNER TO postgres;

--
-- Name: TABLE mdl_badge_endorsement; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_badge_endorsement IS 'Defines endorsement for badge';


--
-- Name: mdl_badge_endorsement_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_badge_endorsement_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_badge_endorsement_id_seq OWNER TO postgres;

--
-- Name: mdl_badge_endorsement_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_badge_endorsement_id_seq OWNED BY public.mdl_badge_endorsement.id;


--
-- Name: mdl_badge_external; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_badge_external (
    id bigint NOT NULL,
    backpackid bigint NOT NULL,
    collectionid bigint NOT NULL,
    entityid character varying(255)
);


ALTER TABLE public.mdl_badge_external OWNER TO postgres;

--
-- Name: TABLE mdl_badge_external; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_badge_external IS 'Setting for external badges display';


--
-- Name: mdl_badge_external_backpack; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_badge_external_backpack (
    id bigint NOT NULL,
    backpackapiurl character varying(255) DEFAULT ''::character varying NOT NULL,
    backpackweburl character varying(255) DEFAULT ''::character varying NOT NULL,
    apiversion character varying(12) DEFAULT '1.0'::character varying NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL,
    password character varying(255)
);


ALTER TABLE public.mdl_badge_external_backpack OWNER TO postgres;

--
-- Name: TABLE mdl_badge_external_backpack; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_badge_external_backpack IS 'Defines settings for site level backpacks that a user can connect to.';


--
-- Name: mdl_badge_external_backpack_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_badge_external_backpack_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_badge_external_backpack_id_seq OWNER TO postgres;

--
-- Name: mdl_badge_external_backpack_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_badge_external_backpack_id_seq OWNED BY public.mdl_badge_external_backpack.id;


--
-- Name: mdl_badge_external_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_badge_external_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_badge_external_id_seq OWNER TO postgres;

--
-- Name: mdl_badge_external_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_badge_external_id_seq OWNED BY public.mdl_badge_external.id;


--
-- Name: mdl_badge_external_identifier; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_badge_external_identifier (
    id bigint NOT NULL,
    sitebackpackid bigint NOT NULL,
    internalid character varying(128) DEFAULT ''::character varying NOT NULL,
    externalid character varying(128) DEFAULT ''::character varying NOT NULL,
    type character varying(16) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_badge_external_identifier OWNER TO postgres;

--
-- Name: TABLE mdl_badge_external_identifier; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_badge_external_identifier IS 'Setting for external badges mappings';


--
-- Name: mdl_badge_external_identifier_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_badge_external_identifier_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_badge_external_identifier_id_seq OWNER TO postgres;

--
-- Name: mdl_badge_external_identifier_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_badge_external_identifier_id_seq OWNED BY public.mdl_badge_external_identifier.id;


--
-- Name: mdl_badge_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_badge_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_badge_id_seq OWNER TO postgres;

--
-- Name: mdl_badge_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_badge_id_seq OWNED BY public.mdl_badge.id;


--
-- Name: mdl_badge_issued; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_badge_issued (
    id bigint NOT NULL,
    badgeid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    uniquehash text NOT NULL,
    dateissued bigint DEFAULT 0 NOT NULL,
    dateexpire bigint,
    visible smallint DEFAULT 0 NOT NULL,
    issuernotified bigint
);


ALTER TABLE public.mdl_badge_issued OWNER TO postgres;

--
-- Name: TABLE mdl_badge_issued; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_badge_issued IS 'Defines issued badges';


--
-- Name: mdl_badge_issued_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_badge_issued_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_badge_issued_id_seq OWNER TO postgres;

--
-- Name: mdl_badge_issued_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_badge_issued_id_seq OWNED BY public.mdl_badge_issued.id;


--
-- Name: mdl_badge_manual_award; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_badge_manual_award (
    id bigint NOT NULL,
    badgeid bigint NOT NULL,
    recipientid bigint NOT NULL,
    issuerid bigint NOT NULL,
    issuerrole bigint NOT NULL,
    datemet bigint NOT NULL
);


ALTER TABLE public.mdl_badge_manual_award OWNER TO postgres;

--
-- Name: TABLE mdl_badge_manual_award; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_badge_manual_award IS 'Track manual award criteria for badges';


--
-- Name: mdl_badge_manual_award_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_badge_manual_award_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_badge_manual_award_id_seq OWNER TO postgres;

--
-- Name: mdl_badge_manual_award_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_badge_manual_award_id_seq OWNED BY public.mdl_badge_manual_award.id;


--
-- Name: mdl_badge_related; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_badge_related (
    id bigint NOT NULL,
    badgeid bigint DEFAULT 0 NOT NULL,
    relatedbadgeid bigint
);


ALTER TABLE public.mdl_badge_related OWNER TO postgres;

--
-- Name: TABLE mdl_badge_related; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_badge_related IS 'Defines badge related for badges';


--
-- Name: mdl_badge_related_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_badge_related_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_badge_related_id_seq OWNER TO postgres;

--
-- Name: mdl_badge_related_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_badge_related_id_seq OWNED BY public.mdl_badge_related.id;


--
-- Name: mdl_block; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_block (
    id bigint NOT NULL,
    name character varying(40) DEFAULT ''::character varying NOT NULL,
    cron bigint DEFAULT 0 NOT NULL,
    lastcron bigint DEFAULT 0 NOT NULL,
    visible smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_block OWNER TO postgres;

--
-- Name: TABLE mdl_block; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_block IS 'contains all installed blocks';


--
-- Name: mdl_block_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_block_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_block_id_seq OWNER TO postgres;

--
-- Name: mdl_block_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_block_id_seq OWNED BY public.mdl_block.id;


--
-- Name: mdl_block_instances; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_block_instances (
    id bigint NOT NULL,
    blockname character varying(40) DEFAULT ''::character varying NOT NULL,
    parentcontextid bigint NOT NULL,
    showinsubcontexts smallint NOT NULL,
    requiredbytheme smallint DEFAULT 0 NOT NULL,
    pagetypepattern character varying(64) DEFAULT ''::character varying NOT NULL,
    subpagepattern character varying(16),
    defaultregion character varying(16) DEFAULT ''::character varying NOT NULL,
    defaultweight bigint NOT NULL,
    configdata text,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_block_instances OWNER TO postgres;

--
-- Name: TABLE mdl_block_instances; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_block_instances IS 'This table stores block instances. The type of block this is is given by the blockname column. The places this block instance appears is controlled by the parentcontexid, showinsubcontexts, pagetypepattern and subpagepattern fields. Where the block a';


--
-- Name: mdl_block_instances_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_block_instances_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_block_instances_id_seq OWNER TO postgres;

--
-- Name: mdl_block_instances_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_block_instances_id_seq OWNED BY public.mdl_block_instances.id;


--
-- Name: mdl_block_iomad_approve_access; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_block_iomad_approve_access (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    companyid bigint NOT NULL,
    courseid bigint NOT NULL,
    activityid bigint DEFAULT 0 NOT NULL,
    tm_ok smallint NOT NULL,
    manager_ok smallint NOT NULL
);


ALTER TABLE public.mdl_block_iomad_approve_access OWNER TO postgres;

--
-- Name: TABLE mdl_block_iomad_approve_access; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_block_iomad_approve_access IS 'Default comment for block_iomad_approve_access, please edit me';


--
-- Name: mdl_block_iomad_approve_access_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_block_iomad_approve_access_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_block_iomad_approve_access_id_seq OWNER TO postgres;

--
-- Name: mdl_block_iomad_approve_access_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_block_iomad_approve_access_id_seq OWNED BY public.mdl_block_iomad_approve_access.id;


--
-- Name: mdl_block_iomad_microlearning; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_block_iomad_microlearning (
    id bigint NOT NULL
);


ALTER TABLE public.mdl_block_iomad_microlearning OWNER TO postgres;

--
-- Name: TABLE mdl_block_iomad_microlearning; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_block_iomad_microlearning IS 'Default comment for block_iomad_microlearning, please edit me';


--
-- Name: mdl_block_iomad_microlearning_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_block_iomad_microlearning_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_block_iomad_microlearning_id_seq OWNER TO postgres;

--
-- Name: mdl_block_iomad_microlearning_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_block_iomad_microlearning_id_seq OWNED BY public.mdl_block_iomad_microlearning.id;


--
-- Name: mdl_block_positions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_block_positions (
    id bigint NOT NULL,
    blockinstanceid bigint NOT NULL,
    contextid bigint NOT NULL,
    pagetype character varying(64) DEFAULT ''::character varying NOT NULL,
    subpage character varying(16) DEFAULT ''::character varying NOT NULL,
    visible smallint NOT NULL,
    region character varying(16) DEFAULT ''::character varying NOT NULL,
    weight bigint NOT NULL
);


ALTER TABLE public.mdl_block_positions OWNER TO postgres;

--
-- Name: TABLE mdl_block_positions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_block_positions IS 'Stores the position of a sticky block_instance on a another page than the one where it was added.';


--
-- Name: mdl_block_positions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_block_positions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_block_positions_id_seq OWNER TO postgres;

--
-- Name: mdl_block_positions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_block_positions_id_seq OWNED BY public.mdl_block_positions.id;


--
-- Name: mdl_block_recent_activity; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_block_recent_activity (
    id bigint NOT NULL,
    courseid bigint NOT NULL,
    cmid bigint NOT NULL,
    timecreated bigint NOT NULL,
    userid bigint NOT NULL,
    action smallint NOT NULL,
    modname character varying(20)
);


ALTER TABLE public.mdl_block_recent_activity OWNER TO postgres;

--
-- Name: TABLE mdl_block_recent_activity; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_block_recent_activity IS 'Recent activity block';


--
-- Name: mdl_block_recent_activity_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_block_recent_activity_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_block_recent_activity_id_seq OWNER TO postgres;

--
-- Name: mdl_block_recent_activity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_block_recent_activity_id_seq OWNED BY public.mdl_block_recent_activity.id;


--
-- Name: mdl_block_recentlyaccesseditems; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_block_recentlyaccesseditems (
    id bigint NOT NULL,
    courseid bigint NOT NULL,
    cmid bigint NOT NULL,
    userid bigint NOT NULL,
    timeaccess bigint NOT NULL
);


ALTER TABLE public.mdl_block_recentlyaccesseditems OWNER TO postgres;

--
-- Name: TABLE mdl_block_recentlyaccesseditems; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_block_recentlyaccesseditems IS 'Most recently accessed items accessed by a user';


--
-- Name: mdl_block_recentlyaccesseditems_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_block_recentlyaccesseditems_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_block_recentlyaccesseditems_id_seq OWNER TO postgres;

--
-- Name: mdl_block_recentlyaccesseditems_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_block_recentlyaccesseditems_id_seq OWNED BY public.mdl_block_recentlyaccesseditems.id;


--
-- Name: mdl_block_rss_client; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_block_rss_client (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    title text NOT NULL,
    preferredtitle character varying(64) DEFAULT ''::character varying NOT NULL,
    description text NOT NULL,
    shared smallint DEFAULT 0 NOT NULL,
    url character varying(255) DEFAULT ''::character varying NOT NULL,
    skiptime bigint DEFAULT 0 NOT NULL,
    skipuntil bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_block_rss_client OWNER TO postgres;

--
-- Name: TABLE mdl_block_rss_client; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_block_rss_client IS 'Remote news feed information. Contains the news feed id, the userid of the user who added the feed, the title of the feed itself and a description of the feed contents along with the url used to access the remote feed. Preferredtitle is a field for f';


--
-- Name: mdl_block_rss_client_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_block_rss_client_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_block_rss_client_id_seq OWNER TO postgres;

--
-- Name: mdl_block_rss_client_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_block_rss_client_id_seq OWNED BY public.mdl_block_rss_client.id;


--
-- Name: mdl_blog_association; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_blog_association (
    id bigint NOT NULL,
    contextid bigint NOT NULL,
    blogid bigint NOT NULL
);


ALTER TABLE public.mdl_blog_association OWNER TO postgres;

--
-- Name: TABLE mdl_blog_association; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_blog_association IS 'Associations of blog entries with courses and module instances';


--
-- Name: mdl_blog_association_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_blog_association_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_blog_association_id_seq OWNER TO postgres;

--
-- Name: mdl_blog_association_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_blog_association_id_seq OWNED BY public.mdl_blog_association.id;


--
-- Name: mdl_blog_external; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_blog_external (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    description text,
    url text NOT NULL,
    filtertags character varying(255),
    failedlastsync smallint DEFAULT 0 NOT NULL,
    timemodified bigint,
    timefetched bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_blog_external OWNER TO postgres;

--
-- Name: TABLE mdl_blog_external; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_blog_external IS 'External blog links used for RSS copying of blog entries to Moodle user blogs';


--
-- Name: mdl_blog_external_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_blog_external_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_blog_external_id_seq OWNER TO postgres;

--
-- Name: mdl_blog_external_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_blog_external_id_seq OWNED BY public.mdl_blog_external.id;


--
-- Name: mdl_book; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_book (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text,
    introformat smallint DEFAULT 0 NOT NULL,
    numbering smallint DEFAULT 0 NOT NULL,
    navstyle smallint DEFAULT 1 NOT NULL,
    customtitles smallint DEFAULT 0 NOT NULL,
    revision bigint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_book OWNER TO postgres;

--
-- Name: TABLE mdl_book; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_book IS 'Defines book';


--
-- Name: mdl_book_chapters; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_book_chapters (
    id bigint NOT NULL,
    bookid bigint DEFAULT 0 NOT NULL,
    pagenum bigint DEFAULT 0 NOT NULL,
    subchapter bigint DEFAULT 0 NOT NULL,
    title character varying(255) DEFAULT ''::character varying NOT NULL,
    content text NOT NULL,
    contentformat smallint DEFAULT 0 NOT NULL,
    hidden smallint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    importsrc character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_book_chapters OWNER TO postgres;

--
-- Name: TABLE mdl_book_chapters; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_book_chapters IS 'Defines book_chapters';


--
-- Name: mdl_book_chapters_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_book_chapters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_book_chapters_id_seq OWNER TO postgres;

--
-- Name: mdl_book_chapters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_book_chapters_id_seq OWNED BY public.mdl_book_chapters.id;


--
-- Name: mdl_book_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_book_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_book_id_seq OWNER TO postgres;

--
-- Name: mdl_book_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_book_id_seq OWNED BY public.mdl_book.id;


--
-- Name: mdl_cache_filters; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_cache_filters (
    id bigint NOT NULL,
    filter character varying(32) DEFAULT ''::character varying NOT NULL,
    version bigint DEFAULT 0 NOT NULL,
    md5key character varying(32) DEFAULT ''::character varying NOT NULL,
    rawtext text NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_cache_filters OWNER TO postgres;

--
-- Name: TABLE mdl_cache_filters; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_cache_filters IS 'For keeping information about cached data';


--
-- Name: mdl_cache_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_cache_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_cache_filters_id_seq OWNER TO postgres;

--
-- Name: mdl_cache_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_cache_filters_id_seq OWNED BY public.mdl_cache_filters.id;


--
-- Name: mdl_cache_flags; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_cache_flags (
    id bigint NOT NULL,
    flagtype character varying(255) DEFAULT ''::character varying NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    value text NOT NULL,
    expiry bigint NOT NULL
);


ALTER TABLE public.mdl_cache_flags OWNER TO postgres;

--
-- Name: TABLE mdl_cache_flags; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_cache_flags IS 'Cache of time-sensitive flags';


--
-- Name: mdl_cache_flags_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_cache_flags_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_cache_flags_id_seq OWNER TO postgres;

--
-- Name: mdl_cache_flags_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_cache_flags_id_seq OWNED BY public.mdl_cache_flags.id;


--
-- Name: mdl_capabilities; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_capabilities (
    id bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    captype character varying(50) DEFAULT ''::character varying NOT NULL,
    contextlevel bigint DEFAULT 0 NOT NULL,
    component character varying(100) DEFAULT ''::character varying NOT NULL,
    riskbitmask bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_capabilities OWNER TO postgres;

--
-- Name: TABLE mdl_capabilities; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_capabilities IS 'this defines all capabilities';


--
-- Name: mdl_capabilities_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_capabilities_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_capabilities_id_seq OWNER TO postgres;

--
-- Name: mdl_capabilities_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_capabilities_id_seq OWNED BY public.mdl_capabilities.id;


--
-- Name: mdl_certificate_serialnumber; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_certificate_serialnumber (
    id bigint NOT NULL,
    certificateid bigint DEFAULT 0 NOT NULL,
    issued_certificate bigint NOT NULL,
    prefix character varying(100) DEFAULT ''::character varying NOT NULL,
    sequenceno bigint NOT NULL,
    timecreated bigint,
    sequence bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_certificate_serialnumber OWNER TO postgres;

--
-- Name: TABLE mdl_certificate_serialnumber; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_certificate_serialnumber IS 'Serialnumbers for issued certificates';


--
-- Name: mdl_certificate_serialnumber_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_certificate_serialnumber_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_certificate_serialnumber_id_seq OWNER TO postgres;

--
-- Name: mdl_certificate_serialnumber_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_certificate_serialnumber_id_seq OWNED BY public.mdl_certificate_serialnumber.id;


--
-- Name: mdl_chat; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_chat (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text NOT NULL,
    introformat smallint DEFAULT 0 NOT NULL,
    keepdays bigint DEFAULT 0 NOT NULL,
    studentlogs smallint DEFAULT 0 NOT NULL,
    chattime bigint DEFAULT 0 NOT NULL,
    schedule smallint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_chat OWNER TO postgres;

--
-- Name: TABLE mdl_chat; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_chat IS 'Each of these is a chat room';


--
-- Name: mdl_chat_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_chat_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_chat_id_seq OWNER TO postgres;

--
-- Name: mdl_chat_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_chat_id_seq OWNED BY public.mdl_chat.id;


--
-- Name: mdl_chat_messages; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_chat_messages (
    id bigint NOT NULL,
    chatid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    groupid bigint DEFAULT 0 NOT NULL,
    issystem smallint DEFAULT 0 NOT NULL,
    message text NOT NULL,
    "timestamp" bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_chat_messages OWNER TO postgres;

--
-- Name: TABLE mdl_chat_messages; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_chat_messages IS 'Stores all the actual chat messages';


--
-- Name: mdl_chat_messages_current; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_chat_messages_current (
    id bigint NOT NULL,
    chatid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    groupid bigint DEFAULT 0 NOT NULL,
    issystem smallint DEFAULT 0 NOT NULL,
    message text NOT NULL,
    "timestamp" bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_chat_messages_current OWNER TO postgres;

--
-- Name: TABLE mdl_chat_messages_current; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_chat_messages_current IS 'Stores current session';


--
-- Name: mdl_chat_messages_current_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_chat_messages_current_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_chat_messages_current_id_seq OWNER TO postgres;

--
-- Name: mdl_chat_messages_current_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_chat_messages_current_id_seq OWNED BY public.mdl_chat_messages_current.id;


--
-- Name: mdl_chat_messages_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_chat_messages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_chat_messages_id_seq OWNER TO postgres;

--
-- Name: mdl_chat_messages_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_chat_messages_id_seq OWNED BY public.mdl_chat_messages.id;


--
-- Name: mdl_chat_users; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_chat_users (
    id bigint NOT NULL,
    chatid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    groupid bigint DEFAULT 0 NOT NULL,
    version character varying(16) DEFAULT ''::character varying NOT NULL,
    ip character varying(45) DEFAULT ''::character varying NOT NULL,
    firstping bigint DEFAULT 0 NOT NULL,
    lastping bigint DEFAULT 0 NOT NULL,
    lastmessageping bigint DEFAULT 0 NOT NULL,
    sid character varying(32) DEFAULT ''::character varying NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    lang character varying(30) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_chat_users OWNER TO postgres;

--
-- Name: TABLE mdl_chat_users; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_chat_users IS 'Keeps track of which users are in which chat rooms';


--
-- Name: mdl_chat_users_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_chat_users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_chat_users_id_seq OWNER TO postgres;

--
-- Name: mdl_chat_users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_chat_users_id_seq OWNED BY public.mdl_chat_users.id;


--
-- Name: mdl_choice; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_choice (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text NOT NULL,
    introformat smallint DEFAULT 0 NOT NULL,
    publish smallint DEFAULT 0 NOT NULL,
    showresults smallint DEFAULT 0 NOT NULL,
    display smallint DEFAULT 0 NOT NULL,
    allowupdate smallint DEFAULT 0 NOT NULL,
    allowmultiple smallint DEFAULT 0 NOT NULL,
    showunanswered smallint DEFAULT 0 NOT NULL,
    includeinactive smallint DEFAULT 1 NOT NULL,
    limitanswers smallint DEFAULT 0 NOT NULL,
    timeopen bigint DEFAULT 0 NOT NULL,
    timeclose bigint DEFAULT 0 NOT NULL,
    showpreview smallint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    completionsubmit smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_choice OWNER TO postgres;

--
-- Name: TABLE mdl_choice; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_choice IS 'Available choices are stored here';


--
-- Name: mdl_choice_answers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_choice_answers (
    id bigint NOT NULL,
    choiceid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    optionid bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_choice_answers OWNER TO postgres;

--
-- Name: TABLE mdl_choice_answers; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_choice_answers IS 'choices performed by users';


--
-- Name: mdl_choice_answers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_choice_answers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_choice_answers_id_seq OWNER TO postgres;

--
-- Name: mdl_choice_answers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_choice_answers_id_seq OWNED BY public.mdl_choice_answers.id;


--
-- Name: mdl_choice_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_choice_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_choice_id_seq OWNER TO postgres;

--
-- Name: mdl_choice_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_choice_id_seq OWNED BY public.mdl_choice.id;


--
-- Name: mdl_choice_options; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_choice_options (
    id bigint NOT NULL,
    choiceid bigint DEFAULT 0 NOT NULL,
    text text,
    maxanswers bigint DEFAULT 0,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_choice_options OWNER TO postgres;

--
-- Name: TABLE mdl_choice_options; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_choice_options IS 'available options to choice';


--
-- Name: mdl_choice_options_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_choice_options_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_choice_options_id_seq OWNER TO postgres;

--
-- Name: mdl_choice_options_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_choice_options_id_seq OWNED BY public.mdl_choice_options.id;


--
-- Name: mdl_classroom; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_classroom (
    id bigint NOT NULL,
    companyid bigint NOT NULL,
    name character varying(100) DEFAULT ''::character varying NOT NULL,
    address character varying(70),
    city character varying(120),
    country character varying(2),
    postcode character varying(20),
    capacity bigint NOT NULL
);


ALTER TABLE public.mdl_classroom OWNER TO postgres;

--
-- Name: TABLE mdl_classroom; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_classroom IS 'Default comment for the table, please edit me';


--
-- Name: mdl_classroom_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_classroom_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_classroom_id_seq OWNER TO postgres;

--
-- Name: mdl_classroom_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_classroom_id_seq OWNED BY public.mdl_classroom.id;


--
-- Name: mdl_cohort; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_cohort (
    id bigint NOT NULL,
    contextid bigint NOT NULL,
    name character varying(254) DEFAULT ''::character varying NOT NULL,
    idnumber character varying(100),
    description text,
    descriptionformat smallint NOT NULL,
    visible smallint DEFAULT 1 NOT NULL,
    component character varying(100) DEFAULT ''::character varying NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    theme character varying(50)
);


ALTER TABLE public.mdl_cohort OWNER TO postgres;

--
-- Name: TABLE mdl_cohort; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_cohort IS 'Each record represents one cohort (aka site-wide group).';


--
-- Name: mdl_cohort_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_cohort_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_cohort_id_seq OWNER TO postgres;

--
-- Name: mdl_cohort_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_cohort_id_seq OWNED BY public.mdl_cohort.id;


--
-- Name: mdl_cohort_members; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_cohort_members (
    id bigint NOT NULL,
    cohortid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    timeadded bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_cohort_members OWNER TO postgres;

--
-- Name: TABLE mdl_cohort_members; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_cohort_members IS 'Link a user to a cohort.';


--
-- Name: mdl_cohort_members_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_cohort_members_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_cohort_members_id_seq OWNER TO postgres;

--
-- Name: mdl_cohort_members_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_cohort_members_id_seq OWNED BY public.mdl_cohort_members.id;


--
-- Name: mdl_comments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_comments (
    id bigint NOT NULL,
    contextid bigint NOT NULL,
    component character varying(255),
    commentarea character varying(255) DEFAULT ''::character varying NOT NULL,
    itemid bigint NOT NULL,
    content text NOT NULL,
    format smallint DEFAULT 0 NOT NULL,
    userid bigint NOT NULL,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_comments OWNER TO postgres;

--
-- Name: TABLE mdl_comments; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_comments IS 'moodle comments module';


--
-- Name: mdl_comments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_comments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_comments_id_seq OWNER TO postgres;

--
-- Name: mdl_comments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_comments_id_seq OWNED BY public.mdl_comments.id;


--
-- Name: mdl_company; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_company (
    id bigint NOT NULL,
    name character varying(50) DEFAULT ''::character varying NOT NULL,
    shortname character varying(25) DEFAULT ''::character varying NOT NULL,
    code character varying(25),
    city character varying(50) DEFAULT ''::character varying NOT NULL,
    country character varying(2) DEFAULT ''::character varying NOT NULL,
    maildisplay smallint DEFAULT 2 NOT NULL,
    mailformat smallint DEFAULT 1 NOT NULL,
    maildigest smallint DEFAULT 0 NOT NULL,
    autosubscribe smallint DEFAULT 1 NOT NULL,
    trackforums smallint DEFAULT 0 NOT NULL,
    htmleditor smallint DEFAULT 1 NOT NULL,
    screenreader smallint DEFAULT 0 NOT NULL,
    timezone character varying(100) DEFAULT '99'::character varying NOT NULL,
    lang character varying(30) DEFAULT 'en'::character varying NOT NULL,
    bgcolor_header character varying(7),
    bgcolor_content character varying(7),
    theme character varying(50) DEFAULT ''::character varying NOT NULL,
    category bigint DEFAULT 0 NOT NULL,
    profileid bigint DEFAULT 0 NOT NULL,
    suspended smallint DEFAULT 0 NOT NULL,
    customcss text,
    maincolor character varying(20) DEFAULT 'null'::character varying,
    headingcolor character varying(20) DEFAULT 'null'::character varying,
    linkcolor character varying(20) DEFAULT 'null'::character varying,
    emailprofileid bigint,
    supervisorprofileid bigint DEFAULT 0 NOT NULL,
    managernotify bigint DEFAULT 0 NOT NULL,
    parentid bigint DEFAULT 0 NOT NULL,
    ecommerce smallint DEFAULT 0 NOT NULL,
    custommenuitems text,
    managerdigestday smallint DEFAULT 0 NOT NULL,
    previousroletemplateid bigint DEFAULT 0 NOT NULL,
    previousemailtemplateid bigint DEFAULT 0 NOT NULL,
    hostname character varying(200),
    maxusers bigint DEFAULT 0 NOT NULL,
    validto bigint,
    suspendafter bigint,
    companyterminated smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_company OWNER TO postgres;

--
-- Name: TABLE mdl_company; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_company IS 'company table retrofitted from MySQL';


--
-- Name: mdl_company_comp_frameworks; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_company_comp_frameworks (
    id bigint NOT NULL,
    companyid bigint NOT NULL,
    frameworkid bigint NOT NULL
);


ALTER TABLE public.mdl_company_comp_frameworks OWNER TO postgres;

--
-- Name: TABLE mdl_company_comp_frameworks; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_company_comp_frameworks IS 'Swing table for associating companies to frameworks';


--
-- Name: mdl_company_comp_frameworks_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_company_comp_frameworks_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_company_comp_frameworks_id_seq OWNER TO postgres;

--
-- Name: mdl_company_comp_frameworks_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_company_comp_frameworks_id_seq OWNED BY public.mdl_company_comp_frameworks.id;


--
-- Name: mdl_company_comp_templates; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_company_comp_templates (
    id bigint NOT NULL,
    companyid bigint NOT NULL,
    templateid bigint NOT NULL
);


ALTER TABLE public.mdl_company_comp_templates OWNER TO postgres;

--
-- Name: TABLE mdl_company_comp_templates; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_company_comp_templates IS 'Swing table to associate learning plan templates to companies';


--
-- Name: mdl_company_comp_templates_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_company_comp_templates_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_company_comp_templates_id_seq OWNER TO postgres;

--
-- Name: mdl_company_comp_templates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_company_comp_templates_id_seq OWNED BY public.mdl_company_comp_templates.id;


--
-- Name: mdl_company_course; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_company_course (
    id bigint NOT NULL,
    companyid bigint NOT NULL,
    courseid bigint NOT NULL,
    departmentid bigint NOT NULL,
    autoenrol smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_company_course OWNER TO postgres;

--
-- Name: TABLE mdl_company_course; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_company_course IS 'Links Companies to Courses for Perficio';


--
-- Name: mdl_company_course_groups; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_company_course_groups (
    id bigint NOT NULL,
    companyid bigint NOT NULL,
    groupid bigint NOT NULL,
    courseid bigint NOT NULL
);


ALTER TABLE public.mdl_company_course_groups OWNER TO postgres;

--
-- Name: TABLE mdl_company_course_groups; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_company_course_groups IS 'Pivot table to map the groups table to the company table;';


--
-- Name: mdl_company_course_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_company_course_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_company_course_groups_id_seq OWNER TO postgres;

--
-- Name: mdl_company_course_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_company_course_groups_id_seq OWNED BY public.mdl_company_course_groups.id;


--
-- Name: mdl_company_course_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_company_course_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_company_course_id_seq OWNER TO postgres;

--
-- Name: mdl_company_course_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_company_course_id_seq OWNED BY public.mdl_company_course.id;


--
-- Name: mdl_company_created_courses; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_company_created_courses (
    id bigint NOT NULL,
    companyid bigint NOT NULL,
    courseid bigint NOT NULL
);


ALTER TABLE public.mdl_company_created_courses OWNER TO postgres;

--
-- Name: TABLE mdl_company_created_courses; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_company_created_courses IS 'Table to hold all the courses which the company managers have created themselves';


--
-- Name: mdl_company_created_courses_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_company_created_courses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_company_created_courses_id_seq OWNER TO postgres;

--
-- Name: mdl_company_created_courses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_company_created_courses_id_seq OWNED BY public.mdl_company_created_courses.id;


--
-- Name: mdl_company_domains; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_company_domains (
    id bigint NOT NULL,
    companyid bigint NOT NULL,
    domain text NOT NULL
);


ALTER TABLE public.mdl_company_domains OWNER TO postgres;

--
-- Name: TABLE mdl_company_domains; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_company_domains IS 'swing table to hold domains and company ids';


--
-- Name: mdl_company_domains_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_company_domains_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_company_domains_id_seq OWNER TO postgres;

--
-- Name: mdl_company_domains_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_company_domains_id_seq OWNED BY public.mdl_company_domains.id;


--
-- Name: mdl_company_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_company_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_company_id_seq OWNER TO postgres;

--
-- Name: mdl_company_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_company_id_seq OWNED BY public.mdl_company.id;


--
-- Name: mdl_company_role_restriction; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_company_role_restriction (
    id bigint NOT NULL,
    companyid bigint NOT NULL,
    roleid bigint NOT NULL,
    capability character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_company_role_restriction OWNER TO postgres;

--
-- Name: TABLE mdl_company_role_restriction; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_company_role_restriction IS 'Records show which capabilities are blocked for company/role';


--
-- Name: mdl_company_role_restriction_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_company_role_restriction_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_company_role_restriction_id_seq OWNER TO postgres;

--
-- Name: mdl_company_role_restriction_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_company_role_restriction_id_seq OWNED BY public.mdl_company_role_restriction.id;


--
-- Name: mdl_company_role_templates; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_company_role_templates (
    id bigint NOT NULL,
    name character varying(50) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_company_role_templates OWNER TO postgres;

--
-- Name: TABLE mdl_company_role_templates; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_company_role_templates IS 'Table for holding information on company role templates.';


--
-- Name: mdl_company_role_templates_ass; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_company_role_templates_ass (
    id bigint NOT NULL,
    companyid bigint NOT NULL,
    templateid bigint NOT NULL
);


ALTER TABLE public.mdl_company_role_templates_ass OWNER TO postgres;

--
-- Name: TABLE mdl_company_role_templates_ass; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_company_role_templates_ass IS 'table to store which company templates are available to which companies';


--
-- Name: mdl_company_role_templates_ass_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_company_role_templates_ass_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_company_role_templates_ass_id_seq OWNER TO postgres;

--
-- Name: mdl_company_role_templates_ass_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_company_role_templates_ass_id_seq OWNED BY public.mdl_company_role_templates_ass.id;


--
-- Name: mdl_company_role_templates_caps; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_company_role_templates_caps (
    id bigint NOT NULL,
    templateid bigint NOT NULL,
    roleid bigint NOT NULL,
    capability character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_company_role_templates_caps OWNER TO postgres;

--
-- Name: TABLE mdl_company_role_templates_caps; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_company_role_templates_caps IS 'Table for holding the template capabilities.';


--
-- Name: mdl_company_role_templates_caps_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_company_role_templates_caps_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_company_role_templates_caps_id_seq OWNER TO postgres;

--
-- Name: mdl_company_role_templates_caps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_company_role_templates_caps_id_seq OWNED BY public.mdl_company_role_templates_caps.id;


--
-- Name: mdl_company_role_templates_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_company_role_templates_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_company_role_templates_id_seq OWNER TO postgres;

--
-- Name: mdl_company_role_templates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_company_role_templates_id_seq OWNED BY public.mdl_company_role_templates.id;


--
-- Name: mdl_company_shared_courses; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_company_shared_courses (
    id bigint NOT NULL,
    companyid bigint NOT NULL,
    courseid bigint NOT NULL
);


ALTER TABLE public.mdl_company_shared_courses OWNER TO postgres;

--
-- Name: TABLE mdl_company_shared_courses; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_company_shared_courses IS 'Pivot table to keep track of courses shared to other companies';


--
-- Name: mdl_company_shared_courses_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_company_shared_courses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_company_shared_courses_id_seq OWNER TO postgres;

--
-- Name: mdl_company_shared_courses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_company_shared_courses_id_seq OWNED BY public.mdl_company_shared_courses.id;


--
-- Name: mdl_company_shared_frameworks; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_company_shared_frameworks (
    id bigint NOT NULL,
    companyid bigint NOT NULL,
    frameworkid bigint NOT NULL
);


ALTER TABLE public.mdl_company_shared_frameworks OWNER TO postgres;

--
-- Name: TABLE mdl_company_shared_frameworks; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_company_shared_frameworks IS 'for holding info on templates which have been shared between companies';


--
-- Name: mdl_company_shared_frameworks_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_company_shared_frameworks_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_company_shared_frameworks_id_seq OWNER TO postgres;

--
-- Name: mdl_company_shared_frameworks_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_company_shared_frameworks_id_seq OWNED BY public.mdl_company_shared_frameworks.id;


--
-- Name: mdl_company_shared_templates; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_company_shared_templates (
    id bigint NOT NULL,
    companyid bigint NOT NULL,
    templateid bigint NOT NULL
);


ALTER TABLE public.mdl_company_shared_templates OWNER TO postgres;

--
-- Name: TABLE mdl_company_shared_templates; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_company_shared_templates IS 'for holding info on templates which have been shared between companies';


--
-- Name: mdl_company_shared_templates_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_company_shared_templates_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_company_shared_templates_id_seq OWNER TO postgres;

--
-- Name: mdl_company_shared_templates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_company_shared_templates_id_seq OWNED BY public.mdl_company_shared_templates.id;


--
-- Name: mdl_company_transient_tokens; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_company_transient_tokens (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    expires bigint NOT NULL,
    token text NOT NULL
);


ALTER TABLE public.mdl_company_transient_tokens OWNER TO postgres;

--
-- Name: TABLE mdl_company_transient_tokens; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_company_transient_tokens IS 'storing user tokens for SSO';


--
-- Name: mdl_company_transient_tokens_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_company_transient_tokens_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_company_transient_tokens_id_seq OWNER TO postgres;

--
-- Name: mdl_company_transient_tokens_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_company_transient_tokens_id_seq OWNED BY public.mdl_company_transient_tokens.id;


--
-- Name: mdl_company_users; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_company_users (
    id bigint NOT NULL,
    companyid bigint NOT NULL,
    userid bigint NOT NULL,
    managertype smallint DEFAULT 0 NOT NULL,
    departmentid bigint NOT NULL,
    suspended smallint DEFAULT 0 NOT NULL,
    educator smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_company_users OWNER TO postgres;

--
-- Name: TABLE mdl_company_users; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_company_users IS 'table to hold the users assigned to a company';


--
-- Name: mdl_company_users_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_company_users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_company_users_id_seq OWNER TO postgres;

--
-- Name: mdl_company_users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_company_users_id_seq OWNED BY public.mdl_company_users.id;


--
-- Name: mdl_companycertificate; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_companycertificate (
    id bigint NOT NULL,
    companyid bigint NOT NULL,
    uselogo smallint DEFAULT 1 NOT NULL,
    usewatermark smallint DEFAULT 1 NOT NULL,
    usesignature smallint DEFAULT 1 NOT NULL,
    useborder smallint DEFAULT 1 NOT NULL,
    showgrade smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_companycertificate OWNER TO postgres;

--
-- Name: TABLE mdl_companycertificate; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_companycertificate IS 'for storing the options for the company certificate';


--
-- Name: mdl_companycertificate_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_companycertificate_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_companycertificate_id_seq OWNER TO postgres;

--
-- Name: mdl_companycertificate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_companycertificate_id_seq OWNED BY public.mdl_companycertificate.id;


--
-- Name: mdl_companylicense; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_companylicense (
    id bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    allocation bigint DEFAULT 0 NOT NULL,
    humanallocation bigint DEFAULT 0 NOT NULL,
    validlength bigint DEFAULT 0 NOT NULL,
    startdate bigint DEFAULT 0 NOT NULL,
    expirydate bigint DEFAULT 0 NOT NULL,
    used bigint DEFAULT 0 NOT NULL,
    companyid bigint,
    parentid bigint DEFAULT 0,
    type smallint DEFAULT 0 NOT NULL,
    program smallint DEFAULT 0 NOT NULL,
    reference character varying(100),
    instant smallint DEFAULT 0 NOT NULL,
    cutoffdate bigint DEFAULT 0 NOT NULL,
    clearonexpire smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_companylicense OWNER TO postgres;

--
-- Name: TABLE mdl_companylicense; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_companylicense IS 'To hold the Iomad license allocations';


--
-- Name: mdl_companylicense_courses; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_companylicense_courses (
    id bigint NOT NULL,
    licenseid bigint NOT NULL,
    courseid bigint NOT NULL
);


ALTER TABLE public.mdl_companylicense_courses OWNER TO postgres;

--
-- Name: TABLE mdl_companylicense_courses; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_companylicense_courses IS 'for keeping track of license course allocations';


--
-- Name: mdl_companylicense_courses_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_companylicense_courses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_companylicense_courses_id_seq OWNER TO postgres;

--
-- Name: mdl_companylicense_courses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_companylicense_courses_id_seq OWNED BY public.mdl_companylicense_courses.id;


--
-- Name: mdl_companylicense_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_companylicense_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_companylicense_id_seq OWNER TO postgres;

--
-- Name: mdl_companylicense_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_companylicense_id_seq OWNED BY public.mdl_companylicense.id;


--
-- Name: mdl_companylicense_users; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_companylicense_users (
    id bigint NOT NULL,
    licenseid bigint NOT NULL,
    userid bigint NOT NULL,
    isusing smallint DEFAULT 0 NOT NULL,
    timecompleted bigint,
    score numeric(10,5),
    result text,
    licensecourseid bigint DEFAULT 0,
    issuedate bigint DEFAULT 0,
    groupid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_companylicense_users OWNER TO postgres;

--
-- Name: TABLE mdl_companylicense_users; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_companylicense_users IS 'To tie users to licenses';


--
-- Name: mdl_companylicense_users_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_companylicense_users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_companylicense_users_id_seq OWNER TO postgres;

--
-- Name: mdl_companylicense_users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_companylicense_users_id_seq OWNED BY public.mdl_companylicense_users.id;


--
-- Name: mdl_competency; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency (
    id bigint NOT NULL,
    shortname character varying(100),
    description text,
    descriptionformat smallint DEFAULT 0 NOT NULL,
    idnumber character varying(100),
    competencyframeworkid bigint NOT NULL,
    parentid bigint DEFAULT 0 NOT NULL,
    path character varying(255) DEFAULT ''::character varying NOT NULL,
    sortorder bigint NOT NULL,
    ruletype character varying(100),
    ruleoutcome smallint DEFAULT 0 NOT NULL,
    ruleconfig text,
    scaleid bigint,
    scaleconfiguration text,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint
);


ALTER TABLE public.mdl_competency OWNER TO postgres;

--
-- Name: TABLE mdl_competency; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency IS 'This table contains the master record of each competency in a framework';


--
-- Name: mdl_competency_coursecomp; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_coursecomp (
    id bigint NOT NULL,
    courseid bigint NOT NULL,
    competencyid bigint NOT NULL,
    ruleoutcome smallint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL,
    sortorder bigint NOT NULL
);


ALTER TABLE public.mdl_competency_coursecomp OWNER TO postgres;

--
-- Name: TABLE mdl_competency_coursecomp; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_coursecomp IS 'Link a competency to a course.';


--
-- Name: mdl_competency_coursecomp_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_coursecomp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_coursecomp_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_coursecomp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_coursecomp_id_seq OWNED BY public.mdl_competency_coursecomp.id;


--
-- Name: mdl_competency_coursecompsetting; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_coursecompsetting (
    id bigint NOT NULL,
    courseid bigint NOT NULL,
    pushratingstouserplans smallint,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint
);


ALTER TABLE public.mdl_competency_coursecompsetting OWNER TO postgres;

--
-- Name: TABLE mdl_competency_coursecompsetting; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_coursecompsetting IS 'This table contains the course specific settings for competencies.';


--
-- Name: mdl_competency_coursecompsetting_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_coursecompsetting_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_coursecompsetting_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_coursecompsetting_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_coursecompsetting_id_seq OWNED BY public.mdl_competency_coursecompsetting.id;


--
-- Name: mdl_competency_evidence; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_evidence (
    id bigint NOT NULL,
    usercompetencyid bigint NOT NULL,
    contextid bigint NOT NULL,
    action smallint NOT NULL,
    actionuserid bigint,
    descidentifier character varying(255) DEFAULT ''::character varying NOT NULL,
    desccomponent character varying(255) DEFAULT ''::character varying NOT NULL,
    desca text,
    url character varying(255),
    grade bigint,
    note text,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL
);


ALTER TABLE public.mdl_competency_evidence OWNER TO postgres;

--
-- Name: TABLE mdl_competency_evidence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_evidence IS 'The evidence linked to a user competency';


--
-- Name: mdl_competency_evidence_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_evidence_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_evidence_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_evidence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_evidence_id_seq OWNED BY public.mdl_competency_evidence.id;


--
-- Name: mdl_competency_framework; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_framework (
    id bigint NOT NULL,
    shortname character varying(100),
    contextid bigint NOT NULL,
    idnumber character varying(100),
    description text,
    descriptionformat smallint DEFAULT 0 NOT NULL,
    scaleid bigint,
    scaleconfiguration text NOT NULL,
    visible smallint DEFAULT 1 NOT NULL,
    taxonomies character varying(255) DEFAULT ''::character varying NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint
);


ALTER TABLE public.mdl_competency_framework OWNER TO postgres;

--
-- Name: TABLE mdl_competency_framework; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_framework IS 'List of competency frameworks.';


--
-- Name: mdl_competency_framework_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_framework_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_framework_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_framework_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_framework_id_seq OWNED BY public.mdl_competency_framework.id;


--
-- Name: mdl_competency_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_id_seq OWNED BY public.mdl_competency.id;


--
-- Name: mdl_competency_modulecomp; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_modulecomp (
    id bigint NOT NULL,
    cmid bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL,
    sortorder bigint NOT NULL,
    competencyid bigint NOT NULL,
    ruleoutcome smallint NOT NULL
);


ALTER TABLE public.mdl_competency_modulecomp OWNER TO postgres;

--
-- Name: TABLE mdl_competency_modulecomp; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_modulecomp IS 'Link a competency to a module.';


--
-- Name: mdl_competency_modulecomp_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_modulecomp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_modulecomp_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_modulecomp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_modulecomp_id_seq OWNED BY public.mdl_competency_modulecomp.id;


--
-- Name: mdl_competency_plan; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_plan (
    id bigint NOT NULL,
    name character varying(100) DEFAULT ''::character varying NOT NULL,
    description text,
    descriptionformat smallint DEFAULT 0 NOT NULL,
    userid bigint NOT NULL,
    templateid bigint,
    origtemplateid bigint,
    status smallint NOT NULL,
    duedate bigint DEFAULT 0,
    reviewerid bigint,
    timecreated bigint NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    usermodified bigint NOT NULL
);


ALTER TABLE public.mdl_competency_plan OWNER TO postgres;

--
-- Name: TABLE mdl_competency_plan; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_plan IS 'Learning plans';


--
-- Name: mdl_competency_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_plan_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_plan_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_plan_id_seq OWNED BY public.mdl_competency_plan.id;


--
-- Name: mdl_competency_plancomp; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_plancomp (
    id bigint NOT NULL,
    planid bigint NOT NULL,
    competencyid bigint NOT NULL,
    sortorder bigint,
    timecreated bigint NOT NULL,
    timemodified bigint,
    usermodified bigint NOT NULL
);


ALTER TABLE public.mdl_competency_plancomp OWNER TO postgres;

--
-- Name: TABLE mdl_competency_plancomp; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_plancomp IS 'Plan competencies';


--
-- Name: mdl_competency_plancomp_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_plancomp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_plancomp_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_plancomp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_plancomp_id_seq OWNED BY public.mdl_competency_plancomp.id;


--
-- Name: mdl_competency_relatedcomp; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_relatedcomp (
    id bigint NOT NULL,
    competencyid bigint NOT NULL,
    relatedcompetencyid bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint,
    usermodified bigint NOT NULL
);


ALTER TABLE public.mdl_competency_relatedcomp OWNER TO postgres;

--
-- Name: TABLE mdl_competency_relatedcomp; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_relatedcomp IS 'Related competencies';


--
-- Name: mdl_competency_relatedcomp_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_relatedcomp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_relatedcomp_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_relatedcomp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_relatedcomp_id_seq OWNED BY public.mdl_competency_relatedcomp.id;


--
-- Name: mdl_competency_template; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_template (
    id bigint NOT NULL,
    shortname character varying(100),
    contextid bigint NOT NULL,
    description text,
    descriptionformat smallint DEFAULT 0 NOT NULL,
    visible smallint DEFAULT 1 NOT NULL,
    duedate bigint,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint
);


ALTER TABLE public.mdl_competency_template OWNER TO postgres;

--
-- Name: TABLE mdl_competency_template; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_template IS 'Learning plan templates.';


--
-- Name: mdl_competency_template_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_template_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_template_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_template_id_seq OWNED BY public.mdl_competency_template.id;


--
-- Name: mdl_competency_templatecohort; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_templatecohort (
    id bigint NOT NULL,
    templateid bigint NOT NULL,
    cohortid bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL
);


ALTER TABLE public.mdl_competency_templatecohort OWNER TO postgres;

--
-- Name: TABLE mdl_competency_templatecohort; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_templatecohort IS 'Default comment for the table, please edit me';


--
-- Name: mdl_competency_templatecohort_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_templatecohort_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_templatecohort_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_templatecohort_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_templatecohort_id_seq OWNED BY public.mdl_competency_templatecohort.id;


--
-- Name: mdl_competency_templatecomp; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_templatecomp (
    id bigint NOT NULL,
    templateid bigint NOT NULL,
    competencyid bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL,
    sortorder bigint
);


ALTER TABLE public.mdl_competency_templatecomp OWNER TO postgres;

--
-- Name: TABLE mdl_competency_templatecomp; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_templatecomp IS 'Link a competency to a learning plan template.';


--
-- Name: mdl_competency_templatecomp_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_templatecomp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_templatecomp_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_templatecomp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_templatecomp_id_seq OWNED BY public.mdl_competency_templatecomp.id;


--
-- Name: mdl_competency_usercomp; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_usercomp (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    competencyid bigint NOT NULL,
    status smallint DEFAULT 0 NOT NULL,
    reviewerid bigint,
    proficiency smallint,
    grade bigint,
    timecreated bigint NOT NULL,
    timemodified bigint,
    usermodified bigint NOT NULL
);


ALTER TABLE public.mdl_competency_usercomp OWNER TO postgres;

--
-- Name: TABLE mdl_competency_usercomp; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_usercomp IS 'User competencies';


--
-- Name: mdl_competency_usercomp_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_usercomp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_usercomp_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_usercomp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_usercomp_id_seq OWNED BY public.mdl_competency_usercomp.id;


--
-- Name: mdl_competency_usercompcourse; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_usercompcourse (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    courseid bigint NOT NULL,
    competencyid bigint NOT NULL,
    proficiency smallint,
    grade bigint,
    timecreated bigint NOT NULL,
    timemodified bigint,
    usermodified bigint NOT NULL
);


ALTER TABLE public.mdl_competency_usercompcourse OWNER TO postgres;

--
-- Name: TABLE mdl_competency_usercompcourse; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_usercompcourse IS 'User competencies in a course';


--
-- Name: mdl_competency_usercompcourse_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_usercompcourse_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_usercompcourse_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_usercompcourse_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_usercompcourse_id_seq OWNED BY public.mdl_competency_usercompcourse.id;


--
-- Name: mdl_competency_usercompplan; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_usercompplan (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    competencyid bigint NOT NULL,
    planid bigint NOT NULL,
    proficiency smallint,
    grade bigint,
    sortorder bigint,
    timecreated bigint NOT NULL,
    timemodified bigint,
    usermodified bigint NOT NULL
);


ALTER TABLE public.mdl_competency_usercompplan OWNER TO postgres;

--
-- Name: TABLE mdl_competency_usercompplan; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_usercompplan IS 'User competencies plans';


--
-- Name: mdl_competency_usercompplan_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_usercompplan_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_usercompplan_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_usercompplan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_usercompplan_id_seq OWNED BY public.mdl_competency_usercompplan.id;


--
-- Name: mdl_competency_userevidence; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_userevidence (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    name character varying(100) DEFAULT ''::character varying NOT NULL,
    description text NOT NULL,
    descriptionformat smallint NOT NULL,
    url text NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL
);


ALTER TABLE public.mdl_competency_userevidence OWNER TO postgres;

--
-- Name: TABLE mdl_competency_userevidence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_userevidence IS 'The evidence of prior learning';


--
-- Name: mdl_competency_userevidence_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_userevidence_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_userevidence_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_userevidence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_userevidence_id_seq OWNED BY public.mdl_competency_userevidence.id;


--
-- Name: mdl_competency_userevidencecomp; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_userevidencecomp (
    id bigint NOT NULL,
    userevidenceid bigint NOT NULL,
    competencyid bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL
);


ALTER TABLE public.mdl_competency_userevidencecomp OWNER TO postgres;

--
-- Name: TABLE mdl_competency_userevidencecomp; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_userevidencecomp IS 'Relationship between user evidence and competencies';


--
-- Name: mdl_competency_userevidencecomp_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_userevidencecomp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_userevidencecomp_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_userevidencecomp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_userevidencecomp_id_seq OWNED BY public.mdl_competency_userevidencecomp.id;


--
-- Name: mdl_config; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_config (
    id bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    value text NOT NULL
);


ALTER TABLE public.mdl_config OWNER TO postgres;

--
-- Name: TABLE mdl_config; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_config IS 'Moodle configuration variables';


--
-- Name: mdl_config_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_config_id_seq OWNER TO postgres;

--
-- Name: mdl_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_config_id_seq OWNED BY public.mdl_config.id;


--
-- Name: mdl_config_log; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_config_log (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    timemodified bigint NOT NULL,
    plugin character varying(100),
    name character varying(100) DEFAULT ''::character varying NOT NULL,
    value text,
    oldvalue text
);


ALTER TABLE public.mdl_config_log OWNER TO postgres;

--
-- Name: TABLE mdl_config_log; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_config_log IS 'Changes done in server configuration through admin UI';


--
-- Name: mdl_config_log_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_config_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_config_log_id_seq OWNER TO postgres;

--
-- Name: mdl_config_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_config_log_id_seq OWNED BY public.mdl_config_log.id;


--
-- Name: mdl_config_plugins; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_config_plugins (
    id bigint NOT NULL,
    plugin character varying(100) DEFAULT 'core'::character varying NOT NULL,
    name character varying(100) DEFAULT ''::character varying NOT NULL,
    value text NOT NULL
);


ALTER TABLE public.mdl_config_plugins OWNER TO postgres;

--
-- Name: TABLE mdl_config_plugins; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_config_plugins IS 'Moodle modules and plugins configuration variables';


--
-- Name: mdl_config_plugins_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_config_plugins_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_config_plugins_id_seq OWNER TO postgres;

--
-- Name: mdl_config_plugins_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_config_plugins_id_seq OWNED BY public.mdl_config_plugins.id;


--
-- Name: mdl_context; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_context (
    id bigint NOT NULL,
    contextlevel bigint DEFAULT 0 NOT NULL,
    instanceid bigint DEFAULT 0 NOT NULL,
    path character varying(255),
    depth smallint DEFAULT 0 NOT NULL,
    locked smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_context OWNER TO postgres;

--
-- Name: TABLE mdl_context; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_context IS 'one of these must be set';


--
-- Name: mdl_context_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_context_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_context_id_seq OWNER TO postgres;

--
-- Name: mdl_context_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_context_id_seq OWNED BY public.mdl_context.id;


--
-- Name: mdl_context_temp; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_context_temp (
    id bigint NOT NULL,
    path character varying(255) DEFAULT ''::character varying NOT NULL,
    depth smallint NOT NULL,
    locked smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_context_temp OWNER TO postgres;

--
-- Name: TABLE mdl_context_temp; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_context_temp IS 'Used by build_context_path() in upgrade and cron to keep context depths and paths in sync.';


--
-- Name: mdl_course; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course (
    id bigint NOT NULL,
    category bigint DEFAULT 0 NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL,
    fullname character varying(254) DEFAULT ''::character varying NOT NULL,
    shortname character varying(255) DEFAULT ''::character varying NOT NULL,
    idnumber character varying(100) DEFAULT ''::character varying NOT NULL,
    summary text,
    summaryformat smallint DEFAULT 0 NOT NULL,
    format character varying(21) DEFAULT 'topics'::character varying NOT NULL,
    showgrades smallint DEFAULT 1 NOT NULL,
    newsitems integer DEFAULT 1 NOT NULL,
    startdate bigint DEFAULT 0 NOT NULL,
    enddate bigint DEFAULT 0 NOT NULL,
    relativedatesmode smallint DEFAULT 0 NOT NULL,
    marker bigint DEFAULT 0 NOT NULL,
    maxbytes bigint DEFAULT 0 NOT NULL,
    legacyfiles smallint DEFAULT 0 NOT NULL,
    showreports smallint DEFAULT 0 NOT NULL,
    visible smallint DEFAULT 1 NOT NULL,
    visibleold smallint DEFAULT 1 NOT NULL,
    groupmode smallint DEFAULT 0 NOT NULL,
    groupmodeforce smallint DEFAULT 0 NOT NULL,
    defaultgroupingid bigint DEFAULT 0 NOT NULL,
    lang character varying(30) DEFAULT ''::character varying NOT NULL,
    calendartype character varying(30) DEFAULT ''::character varying NOT NULL,
    theme character varying(50) DEFAULT ''::character varying NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    requested smallint DEFAULT 0 NOT NULL,
    enablecompletion smallint DEFAULT 0 NOT NULL,
    completionnotify smallint DEFAULT 0 NOT NULL,
    cacherev bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_course OWNER TO postgres;

--
-- Name: TABLE mdl_course; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course IS 'Central course table';


--
-- Name: mdl_course_categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course_categories (
    id bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    idnumber character varying(100),
    description text,
    descriptionformat smallint DEFAULT 0 NOT NULL,
    parent bigint DEFAULT 0 NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL,
    coursecount bigint DEFAULT 0 NOT NULL,
    visible smallint DEFAULT 1 NOT NULL,
    visibleold smallint DEFAULT 1 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    depth bigint DEFAULT 0 NOT NULL,
    path character varying(255) DEFAULT ''::character varying NOT NULL,
    theme character varying(50)
);


ALTER TABLE public.mdl_course_categories OWNER TO postgres;

--
-- Name: TABLE mdl_course_categories; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course_categories IS 'Course categories';


--
-- Name: mdl_course_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_categories_id_seq OWNER TO postgres;

--
-- Name: mdl_course_categories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_categories_id_seq OWNED BY public.mdl_course_categories.id;


--
-- Name: mdl_course_completion_aggr_methd; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course_completion_aggr_methd (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    criteriatype bigint,
    method smallint DEFAULT 0 NOT NULL,
    value numeric(10,5)
);


ALTER TABLE public.mdl_course_completion_aggr_methd OWNER TO postgres;

--
-- Name: TABLE mdl_course_completion_aggr_methd; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course_completion_aggr_methd IS 'Course completion aggregation methods for criteria';


--
-- Name: mdl_course_completion_aggr_methd_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_completion_aggr_methd_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_completion_aggr_methd_id_seq OWNER TO postgres;

--
-- Name: mdl_course_completion_aggr_methd_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_completion_aggr_methd_id_seq OWNED BY public.mdl_course_completion_aggr_methd.id;


--
-- Name: mdl_course_completion_crit_compl; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course_completion_crit_compl (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    criteriaid bigint DEFAULT 0 NOT NULL,
    gradefinal numeric(10,5),
    unenroled bigint,
    timecompleted bigint
);


ALTER TABLE public.mdl_course_completion_crit_compl OWNER TO postgres;

--
-- Name: TABLE mdl_course_completion_crit_compl; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course_completion_crit_compl IS 'Course completion user records';


--
-- Name: mdl_course_completion_crit_compl_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_completion_crit_compl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_completion_crit_compl_id_seq OWNER TO postgres;

--
-- Name: mdl_course_completion_crit_compl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_completion_crit_compl_id_seq OWNED BY public.mdl_course_completion_crit_compl.id;


--
-- Name: mdl_course_completion_criteria; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course_completion_criteria (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    criteriatype bigint DEFAULT 0 NOT NULL,
    module character varying(100),
    moduleinstance bigint,
    courseinstance bigint,
    enrolperiod bigint,
    timeend bigint,
    gradepass numeric(10,5),
    role bigint
);


ALTER TABLE public.mdl_course_completion_criteria OWNER TO postgres;

--
-- Name: TABLE mdl_course_completion_criteria; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course_completion_criteria IS 'Course completion criteria';


--
-- Name: mdl_course_completion_criteria_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_completion_criteria_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_completion_criteria_id_seq OWNER TO postgres;

--
-- Name: mdl_course_completion_criteria_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_completion_criteria_id_seq OWNED BY public.mdl_course_completion_criteria.id;


--
-- Name: mdl_course_completion_defaults; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course_completion_defaults (
    id bigint NOT NULL,
    course bigint NOT NULL,
    module bigint NOT NULL,
    completion smallint DEFAULT 0 NOT NULL,
    completionview smallint DEFAULT 0 NOT NULL,
    completionusegrade smallint DEFAULT 0 NOT NULL,
    completionexpected bigint DEFAULT 0 NOT NULL,
    customrules text
);


ALTER TABLE public.mdl_course_completion_defaults OWNER TO postgres;

--
-- Name: TABLE mdl_course_completion_defaults; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course_completion_defaults IS 'Default settings for activities completion';


--
-- Name: mdl_course_completion_defaults_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_completion_defaults_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_completion_defaults_id_seq OWNER TO postgres;

--
-- Name: mdl_course_completion_defaults_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_completion_defaults_id_seq OWNED BY public.mdl_course_completion_defaults.id;


--
-- Name: mdl_course_completions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course_completions (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    timeenrolled bigint DEFAULT 0 NOT NULL,
    timestarted bigint DEFAULT 0 NOT NULL,
    timecompleted bigint,
    reaggregate bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_course_completions OWNER TO postgres;

--
-- Name: TABLE mdl_course_completions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course_completions IS 'Course completion records';


--
-- Name: mdl_course_completions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_completions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_completions_id_seq OWNER TO postgres;

--
-- Name: mdl_course_completions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_completions_id_seq OWNED BY public.mdl_course_completions.id;


--
-- Name: mdl_course_format_options; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course_format_options (
    id bigint NOT NULL,
    courseid bigint NOT NULL,
    format character varying(21) DEFAULT ''::character varying NOT NULL,
    sectionid bigint DEFAULT 0 NOT NULL,
    name character varying(100) DEFAULT ''::character varying NOT NULL,
    value text
);


ALTER TABLE public.mdl_course_format_options OWNER TO postgres;

--
-- Name: TABLE mdl_course_format_options; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course_format_options IS 'Stores format-specific options for the course or course section';


--
-- Name: mdl_course_format_options_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_format_options_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_format_options_id_seq OWNER TO postgres;

--
-- Name: mdl_course_format_options_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_format_options_id_seq OWNED BY public.mdl_course_format_options.id;


--
-- Name: mdl_course_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_id_seq OWNER TO postgres;

--
-- Name: mdl_course_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_id_seq OWNED BY public.mdl_course.id;


--
-- Name: mdl_course_modules; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course_modules (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    module bigint DEFAULT 0 NOT NULL,
    instance bigint DEFAULT 0 NOT NULL,
    section bigint DEFAULT 0 NOT NULL,
    idnumber character varying(100),
    added bigint DEFAULT 0 NOT NULL,
    score smallint DEFAULT 0 NOT NULL,
    indent integer DEFAULT 0 NOT NULL,
    visible smallint DEFAULT 1 NOT NULL,
    visibleoncoursepage smallint DEFAULT 1 NOT NULL,
    visibleold smallint DEFAULT 1 NOT NULL,
    groupmode smallint DEFAULT 0 NOT NULL,
    groupingid bigint DEFAULT 0 NOT NULL,
    completion smallint DEFAULT 0 NOT NULL,
    completiongradeitemnumber bigint,
    completionview smallint DEFAULT 0 NOT NULL,
    completionexpected bigint DEFAULT 0 NOT NULL,
    showdescription smallint DEFAULT 0 NOT NULL,
    availability text,
    deletioninprogress smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_course_modules OWNER TO postgres;

--
-- Name: TABLE mdl_course_modules; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course_modules IS 'course_modules table retrofitted from MySQL';


--
-- Name: mdl_course_modules_completion; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course_modules_completion (
    id bigint NOT NULL,
    coursemoduleid bigint NOT NULL,
    userid bigint NOT NULL,
    completionstate smallint NOT NULL,
    viewed smallint,
    overrideby bigint,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_course_modules_completion OWNER TO postgres;

--
-- Name: TABLE mdl_course_modules_completion; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course_modules_completion IS 'Stores the completion state (completed or not completed, etc) of each user on each activity.';


--
-- Name: mdl_course_modules_completion_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_modules_completion_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_modules_completion_id_seq OWNER TO postgres;

--
-- Name: mdl_course_modules_completion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_modules_completion_id_seq OWNED BY public.mdl_course_modules_completion.id;


--
-- Name: mdl_course_modules_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_modules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_modules_id_seq OWNER TO postgres;

--
-- Name: mdl_course_modules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_modules_id_seq OWNED BY public.mdl_course_modules.id;


--
-- Name: mdl_course_published; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course_published (
    id bigint NOT NULL,
    huburl character varying(255),
    courseid bigint NOT NULL,
    timepublished bigint NOT NULL,
    enrollable smallint DEFAULT 1 NOT NULL,
    hubcourseid bigint NOT NULL,
    status smallint DEFAULT 0,
    timechecked bigint
);


ALTER TABLE public.mdl_course_published OWNER TO postgres;

--
-- Name: TABLE mdl_course_published; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course_published IS 'Information about how and when an local courses were published to hubs';


--
-- Name: mdl_course_published_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_published_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_published_id_seq OWNER TO postgres;

--
-- Name: mdl_course_published_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_published_id_seq OWNED BY public.mdl_course_published.id;


--
-- Name: mdl_course_request; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course_request (
    id bigint NOT NULL,
    fullname character varying(254) DEFAULT ''::character varying NOT NULL,
    shortname character varying(100) DEFAULT ''::character varying NOT NULL,
    summary text NOT NULL,
    summaryformat smallint DEFAULT 0 NOT NULL,
    category bigint DEFAULT 0 NOT NULL,
    reason text NOT NULL,
    requester bigint DEFAULT 0 NOT NULL,
    password character varying(50) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_course_request OWNER TO postgres;

--
-- Name: TABLE mdl_course_request; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course_request IS 'course requests';


--
-- Name: mdl_course_request_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_request_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_request_id_seq OWNER TO postgres;

--
-- Name: mdl_course_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_request_id_seq OWNED BY public.mdl_course_request.id;


--
-- Name: mdl_course_sections; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course_sections (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    section bigint DEFAULT 0 NOT NULL,
    name character varying(255),
    summary text,
    summaryformat smallint DEFAULT 0 NOT NULL,
    sequence text,
    visible smallint DEFAULT 1 NOT NULL,
    availability text,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_course_sections OWNER TO postgres;

--
-- Name: TABLE mdl_course_sections; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course_sections IS 'to define the sections for each course';


--
-- Name: mdl_course_sections_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_sections_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_sections_id_seq OWNER TO postgres;

--
-- Name: mdl_course_sections_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_sections_id_seq OWNED BY public.mdl_course_sections.id;


--
-- Name: mdl_course_shopblockprice; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course_shopblockprice (
    id bigint NOT NULL,
    currency character varying(10) DEFAULT '£'::character varying NOT NULL,
    courseid bigint NOT NULL,
    price_bracket_start bigint DEFAULT 1 NOT NULL,
    price numeric(10,2) NOT NULL,
    validlength bigint DEFAULT 0 NOT NULL,
    shelflife bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_course_shopblockprice OWNER TO postgres;

--
-- Name: TABLE mdl_course_shopblockprice; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course_shopblockprice IS 'license block prices';


--
-- Name: mdl_course_shopblockprice_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_shopblockprice_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_shopblockprice_id_seq OWNER TO postgres;

--
-- Name: mdl_course_shopblockprice_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_shopblockprice_id_seq OWNED BY public.mdl_course_shopblockprice.id;


--
-- Name: mdl_course_shopsettings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course_shopsettings (
    id bigint NOT NULL,
    courseid bigint NOT NULL,
    short_description text NOT NULL,
    long_description text,
    allow_single_purchase smallint DEFAULT 1 NOT NULL,
    allow_license_blocks smallint DEFAULT 1 NOT NULL,
    enabled smallint DEFAULT 1 NOT NULL,
    single_purchase_currency character varying(10) DEFAULT '£'::character varying NOT NULL,
    single_purchase_price numeric(10,2) DEFAULT 0 NOT NULL,
    single_purchase_validlength bigint DEFAULT 0 NOT NULL,
    single_purchase_shelflife bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_course_shopsettings OWNER TO postgres;

--
-- Name: TABLE mdl_course_shopsettings; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course_shopsettings IS 'course settings for shop';


--
-- Name: mdl_course_shopsettings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_shopsettings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_shopsettings_id_seq OWNER TO postgres;

--
-- Name: mdl_course_shopsettings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_shopsettings_id_seq OWNED BY public.mdl_course_shopsettings.id;


--
-- Name: mdl_course_shoptag; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course_shoptag (
    id bigint NOT NULL,
    courseid bigint NOT NULL,
    shoptagid bigint NOT NULL
);


ALTER TABLE public.mdl_course_shoptag OWNER TO postgres;

--
-- Name: TABLE mdl_course_shoptag; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course_shoptag IS 'links courses to shoptags';


--
-- Name: mdl_course_shoptag_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_shoptag_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_shoptag_id_seq OWNER TO postgres;

--
-- Name: mdl_course_shoptag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_shoptag_id_seq OWNED BY public.mdl_course_shoptag.id;


--
-- Name: mdl_customfield_category; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_customfield_category (
    id bigint NOT NULL,
    name character varying(400) DEFAULT ''::character varying NOT NULL,
    description text,
    descriptionformat bigint,
    sortorder bigint,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    component character varying(100) DEFAULT ''::character varying NOT NULL,
    area character varying(100) DEFAULT ''::character varying NOT NULL,
    itemid bigint DEFAULT 0 NOT NULL,
    contextid bigint
);


ALTER TABLE public.mdl_customfield_category OWNER TO postgres;

--
-- Name: TABLE mdl_customfield_category; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_customfield_category IS 'core_customfield category table';


--
-- Name: mdl_customfield_category_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_customfield_category_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_customfield_category_id_seq OWNER TO postgres;

--
-- Name: mdl_customfield_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_customfield_category_id_seq OWNED BY public.mdl_customfield_category.id;


--
-- Name: mdl_customfield_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_customfield_data (
    id bigint NOT NULL,
    fieldid bigint NOT NULL,
    instanceid bigint NOT NULL,
    intvalue bigint,
    decvalue numeric(10,5),
    shortcharvalue character varying(255),
    charvalue character varying(1333),
    value text NOT NULL,
    valueformat bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    contextid bigint
);


ALTER TABLE public.mdl_customfield_data OWNER TO postgres;

--
-- Name: TABLE mdl_customfield_data; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_customfield_data IS 'core_customfield data table';


--
-- Name: mdl_customfield_data_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_customfield_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_customfield_data_id_seq OWNER TO postgres;

--
-- Name: mdl_customfield_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_customfield_data_id_seq OWNED BY public.mdl_customfield_data.id;


--
-- Name: mdl_customfield_field; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_customfield_field (
    id bigint NOT NULL,
    shortname character varying(100) DEFAULT ''::character varying NOT NULL,
    name character varying(400) DEFAULT ''::character varying NOT NULL,
    type character varying(100) DEFAULT ''::character varying NOT NULL,
    description text,
    descriptionformat bigint,
    sortorder bigint,
    categoryid bigint,
    configdata text,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_customfield_field OWNER TO postgres;

--
-- Name: TABLE mdl_customfield_field; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_customfield_field IS 'core_customfield field table';


--
-- Name: mdl_customfield_field_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_customfield_field_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_customfield_field_id_seq OWNER TO postgres;

--
-- Name: mdl_customfield_field_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_customfield_field_id_seq OWNED BY public.mdl_customfield_field.id;


--
-- Name: mdl_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_data (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text NOT NULL,
    introformat smallint DEFAULT 0 NOT NULL,
    comments smallint DEFAULT 0 NOT NULL,
    timeavailablefrom bigint DEFAULT 0 NOT NULL,
    timeavailableto bigint DEFAULT 0 NOT NULL,
    timeviewfrom bigint DEFAULT 0 NOT NULL,
    timeviewto bigint DEFAULT 0 NOT NULL,
    requiredentries integer DEFAULT 0 NOT NULL,
    requiredentriestoview integer DEFAULT 0 NOT NULL,
    maxentries integer DEFAULT 0 NOT NULL,
    rssarticles smallint DEFAULT 0 NOT NULL,
    singletemplate text,
    listtemplate text,
    listtemplateheader text,
    listtemplatefooter text,
    addtemplate text,
    rsstemplate text,
    rsstitletemplate text,
    csstemplate text,
    jstemplate text,
    asearchtemplate text,
    approval smallint DEFAULT 0 NOT NULL,
    manageapproved smallint DEFAULT 1 NOT NULL,
    scale bigint DEFAULT 0 NOT NULL,
    assessed bigint DEFAULT 0 NOT NULL,
    assesstimestart bigint DEFAULT 0 NOT NULL,
    assesstimefinish bigint DEFAULT 0 NOT NULL,
    defaultsort bigint DEFAULT 0 NOT NULL,
    defaultsortdir smallint DEFAULT 0 NOT NULL,
    editany smallint DEFAULT 0 NOT NULL,
    notification bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    config text,
    completionentries bigint DEFAULT 0
);


ALTER TABLE public.mdl_data OWNER TO postgres;

--
-- Name: TABLE mdl_data; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_data IS 'all database activities';


--
-- Name: mdl_data_content; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_data_content (
    id bigint NOT NULL,
    fieldid bigint DEFAULT 0 NOT NULL,
    recordid bigint DEFAULT 0 NOT NULL,
    content text,
    content1 text,
    content2 text,
    content3 text,
    content4 text
);


ALTER TABLE public.mdl_data_content OWNER TO postgres;

--
-- Name: TABLE mdl_data_content; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_data_content IS 'the content introduced in each record/fields';


--
-- Name: mdl_data_content_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_data_content_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_data_content_id_seq OWNER TO postgres;

--
-- Name: mdl_data_content_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_data_content_id_seq OWNED BY public.mdl_data_content.id;


--
-- Name: mdl_data_fields; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_data_fields (
    id bigint NOT NULL,
    dataid bigint DEFAULT 0 NOT NULL,
    type character varying(255) DEFAULT ''::character varying NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    description text NOT NULL,
    required smallint DEFAULT 0 NOT NULL,
    param1 text,
    param2 text,
    param3 text,
    param4 text,
    param5 text,
    param6 text,
    param7 text,
    param8 text,
    param9 text,
    param10 text
);


ALTER TABLE public.mdl_data_fields OWNER TO postgres;

--
-- Name: TABLE mdl_data_fields; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_data_fields IS 'every field available';


--
-- Name: mdl_data_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_data_fields_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_data_fields_id_seq OWNER TO postgres;

--
-- Name: mdl_data_fields_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_data_fields_id_seq OWNED BY public.mdl_data_fields.id;


--
-- Name: mdl_data_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_data_id_seq OWNER TO postgres;

--
-- Name: mdl_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_data_id_seq OWNED BY public.mdl_data.id;


--
-- Name: mdl_data_records; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_data_records (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    groupid bigint DEFAULT 0 NOT NULL,
    dataid bigint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    approved smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_data_records OWNER TO postgres;

--
-- Name: TABLE mdl_data_records; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_data_records IS 'every record introduced';


--
-- Name: mdl_data_records_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_data_records_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_data_records_id_seq OWNER TO postgres;

--
-- Name: mdl_data_records_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_data_records_id_seq OWNED BY public.mdl_data_records.id;


--
-- Name: mdl_department; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_department (
    id bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    shortname character varying(32) DEFAULT ''::character varying NOT NULL,
    company bigint DEFAULT 0 NOT NULL,
    parent bigint
);


ALTER TABLE public.mdl_department OWNER TO postgres;

--
-- Name: TABLE mdl_department; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_department IS 'Perficio department deginitions';


--
-- Name: mdl_department_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_department_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_department_id_seq OWNER TO postgres;

--
-- Name: mdl_department_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_department_id_seq OWNED BY public.mdl_department.id;


--
-- Name: mdl_editor_atto_autosave; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_editor_atto_autosave (
    id bigint NOT NULL,
    elementid character varying(255) DEFAULT ''::character varying NOT NULL,
    contextid bigint NOT NULL,
    pagehash character varying(64) DEFAULT ''::character varying NOT NULL,
    userid bigint NOT NULL,
    drafttext text NOT NULL,
    draftid bigint,
    pageinstance character varying(64) DEFAULT ''::character varying NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_editor_atto_autosave OWNER TO postgres;

--
-- Name: TABLE mdl_editor_atto_autosave; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_editor_atto_autosave IS 'Draft text that is auto-saved every 5 seconds while an editor is open.';


--
-- Name: mdl_editor_atto_autosave_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_editor_atto_autosave_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_editor_atto_autosave_id_seq OWNER TO postgres;

--
-- Name: mdl_editor_atto_autosave_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_editor_atto_autosave_id_seq OWNED BY public.mdl_editor_atto_autosave.id;


--
-- Name: mdl_email; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_email (
    id bigint NOT NULL,
    templatename character varying(100),
    modifiedtime bigint NOT NULL,
    sent bigint,
    subject character varying(255) DEFAULT ''::character varying NOT NULL,
    body text NOT NULL,
    varsreplaced bigint,
    companyid bigint DEFAULT 0 NOT NULL,
    courseid bigint,
    userid bigint NOT NULL,
    invoiceid bigint,
    classroomid bigint,
    senderid bigint,
    headers text,
    due bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_email OWNER TO postgres;

--
-- Name: TABLE mdl_email; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_email IS 'emails to be processed, send or that have been sent';


--
-- Name: mdl_email_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_email_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_email_id_seq OWNER TO postgres;

--
-- Name: mdl_email_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_email_id_seq OWNED BY public.mdl_email.id;


--
-- Name: mdl_email_template; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_email_template (
    id bigint NOT NULL,
    companyid bigint NOT NULL,
    name character varying(50) DEFAULT ''::character varying NOT NULL,
    lang character varying(20) DEFAULT 'en'::character varying NOT NULL,
    subject character varying(100) DEFAULT ''::character varying NOT NULL,
    body text NOT NULL,
    signature text,
    disabled smallint DEFAULT 0 NOT NULL,
    disabledmanager smallint DEFAULT 0 NOT NULL,
    disabledsupervisor smallint DEFAULT 0 NOT NULL,
    emailto character varying(1333),
    emailtoother character varying(1333),
    emailcc character varying(1333),
    emailccother character varying(1333),
    emailfrom bigint,
    emailfromother character varying(100),
    emailreplyto bigint,
    emailreplytoother character varying(100),
    repeatperiod bigint DEFAULT 0 NOT NULL,
    repeatvalue bigint DEFAULT 0 NOT NULL,
    repeatday bigint DEFAULT 0 NOT NULL,
    emailfromothername text
);


ALTER TABLE public.mdl_email_template OWNER TO postgres;

--
-- Name: TABLE mdl_email_template; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_email_template IS 'Table for company email templates';


--
-- Name: mdl_email_template_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_email_template_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_email_template_id_seq OWNER TO postgres;

--
-- Name: mdl_email_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_email_template_id_seq OWNED BY public.mdl_email_template.id;


--
-- Name: mdl_email_templateset; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_email_templateset (
    id bigint NOT NULL,
    templatesetname text NOT NULL
);


ALTER TABLE public.mdl_email_templateset OWNER TO postgres;

--
-- Name: TABLE mdl_email_templateset; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_email_templateset IS 'list of email template sets';


--
-- Name: mdl_email_templateset_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_email_templateset_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_email_templateset_id_seq OWNER TO postgres;

--
-- Name: mdl_email_templateset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_email_templateset_id_seq OWNED BY public.mdl_email_templateset.id;


--
-- Name: mdl_email_templateset_templates; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_email_templateset_templates (
    id bigint NOT NULL,
    templateset bigint NOT NULL,
    name character varying(50) DEFAULT ''::character varying NOT NULL,
    lang character varying(20) DEFAULT ''::character varying NOT NULL,
    subject character varying(255) DEFAULT ''::character varying NOT NULL,
    body text NOT NULL,
    disabled smallint DEFAULT 0 NOT NULL,
    disabledmanager smallint DEFAULT 0 NOT NULL,
    disabledsupervisor smallint DEFAULT 0 NOT NULL,
    repeatperiod bigint DEFAULT 0 NOT NULL,
    repeatvalue bigint DEFAULT 0 NOT NULL,
    repeateday bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_email_templateset_templates OWNER TO postgres;

--
-- Name: TABLE mdl_email_templateset_templates; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_email_templateset_templates IS 'email templates tied to a template set';


--
-- Name: mdl_email_templateset_templates_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_email_templateset_templates_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_email_templateset_templates_id_seq OWNER TO postgres;

--
-- Name: mdl_email_templateset_templates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_email_templateset_templates_id_seq OWNED BY public.mdl_email_templateset_templates.id;


--
-- Name: mdl_enrol; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_enrol (
    id bigint NOT NULL,
    enrol character varying(20) DEFAULT ''::character varying NOT NULL,
    status bigint DEFAULT 0 NOT NULL,
    courseid bigint NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL,
    name character varying(255),
    enrolperiod bigint DEFAULT 0,
    enrolstartdate bigint DEFAULT 0,
    enrolenddate bigint DEFAULT 0,
    expirynotify smallint DEFAULT 0,
    expirythreshold bigint DEFAULT 0,
    notifyall smallint DEFAULT 0,
    password character varying(50),
    cost character varying(20),
    currency character varying(3),
    roleid bigint DEFAULT 0,
    customint1 bigint,
    customint2 bigint,
    customint3 bigint,
    customint4 bigint,
    customint5 bigint,
    customint6 bigint,
    customint7 bigint,
    customint8 bigint,
    customchar1 character varying(255),
    customchar2 character varying(255),
    customchar3 character varying(1333),
    customdec1 numeric(12,7),
    customdec2 numeric(12,7),
    customtext1 text,
    customtext2 text,
    customtext3 text,
    customtext4 text,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_enrol OWNER TO postgres;

--
-- Name: TABLE mdl_enrol; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_enrol IS 'Instances of enrolment plugins used in courses, fields marked as custom have a plugin defined meaning, core does not touch them. Create a new linked table if you need even more custom fields.';


--
-- Name: mdl_enrol_flatfile; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_enrol_flatfile (
    id bigint NOT NULL,
    action character varying(30) DEFAULT ''::character varying NOT NULL,
    roleid bigint NOT NULL,
    userid bigint NOT NULL,
    courseid bigint NOT NULL,
    timestart bigint DEFAULT 0 NOT NULL,
    timeend bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_enrol_flatfile OWNER TO postgres;

--
-- Name: TABLE mdl_enrol_flatfile; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_enrol_flatfile IS 'enrol_flatfile table retrofitted from MySQL';


--
-- Name: mdl_enrol_flatfile_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_flatfile_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_flatfile_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_flatfile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_enrol_flatfile_id_seq OWNED BY public.mdl_enrol_flatfile.id;


--
-- Name: mdl_enrol_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_enrol_id_seq OWNED BY public.mdl_enrol.id;


--
-- Name: mdl_enrol_lti_lti2_consumer; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_enrol_lti_lti2_consumer (
    id bigint NOT NULL,
    name character varying(50) DEFAULT ''::character varying NOT NULL,
    consumerkey256 character varying(255) DEFAULT ''::character varying NOT NULL,
    consumerkey text,
    secret character varying(1024) DEFAULT ''::character varying NOT NULL,
    ltiversion character varying(10),
    consumername character varying(255),
    consumerversion character varying(255),
    consumerguid character varying(1024),
    profile text,
    toolproxy text,
    settings text,
    protected smallint NOT NULL,
    enabled smallint NOT NULL,
    enablefrom bigint,
    enableuntil bigint,
    lastaccess bigint,
    created bigint NOT NULL,
    updated bigint NOT NULL
);


ALTER TABLE public.mdl_enrol_lti_lti2_consumer OWNER TO postgres;

--
-- Name: TABLE mdl_enrol_lti_lti2_consumer; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_enrol_lti_lti2_consumer IS 'LTI consumers interacting with moodle';


--
-- Name: mdl_enrol_lti_lti2_consumer_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_lti_lti2_consumer_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_lti_lti2_consumer_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_lti_lti2_consumer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_enrol_lti_lti2_consumer_id_seq OWNED BY public.mdl_enrol_lti_lti2_consumer.id;


--
-- Name: mdl_enrol_lti_lti2_context; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_enrol_lti_lti2_context (
    id bigint NOT NULL,
    consumerid bigint NOT NULL,
    lticontextkey character varying(255) DEFAULT ''::character varying NOT NULL,
    type character varying(100),
    settings text,
    created bigint NOT NULL,
    updated bigint NOT NULL
);


ALTER TABLE public.mdl_enrol_lti_lti2_context OWNER TO postgres;

--
-- Name: TABLE mdl_enrol_lti_lti2_context; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_enrol_lti_lti2_context IS 'Information about a specific LTI contexts from the consumers';


--
-- Name: mdl_enrol_lti_lti2_context_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_lti_lti2_context_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_lti_lti2_context_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_lti_lti2_context_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_enrol_lti_lti2_context_id_seq OWNED BY public.mdl_enrol_lti_lti2_context.id;


--
-- Name: mdl_enrol_lti_lti2_nonce; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_enrol_lti_lti2_nonce (
    id bigint NOT NULL,
    consumerid bigint NOT NULL,
    value character varying(64) DEFAULT ''::character varying NOT NULL,
    expires bigint NOT NULL
);


ALTER TABLE public.mdl_enrol_lti_lti2_nonce OWNER TO postgres;

--
-- Name: TABLE mdl_enrol_lti_lti2_nonce; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_enrol_lti_lti2_nonce IS 'Nonce used for authentication between moodle and a consumer';


--
-- Name: mdl_enrol_lti_lti2_nonce_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_lti_lti2_nonce_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_lti_lti2_nonce_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_lti_lti2_nonce_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_enrol_lti_lti2_nonce_id_seq OWNED BY public.mdl_enrol_lti_lti2_nonce.id;


--
-- Name: mdl_enrol_lti_lti2_resource_link; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_enrol_lti_lti2_resource_link (
    id bigint NOT NULL,
    contextid bigint,
    consumerid bigint,
    ltiresourcelinkkey character varying(255) DEFAULT ''::character varying NOT NULL,
    settings text,
    primaryresourcelinkid bigint,
    shareapproved smallint,
    created bigint NOT NULL,
    updated bigint NOT NULL
);


ALTER TABLE public.mdl_enrol_lti_lti2_resource_link OWNER TO postgres;

--
-- Name: TABLE mdl_enrol_lti_lti2_resource_link; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_enrol_lti_lti2_resource_link IS 'Link from the consumer to the tool';


--
-- Name: mdl_enrol_lti_lti2_resource_link_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_lti_lti2_resource_link_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_lti_lti2_resource_link_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_lti_lti2_resource_link_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_enrol_lti_lti2_resource_link_id_seq OWNED BY public.mdl_enrol_lti_lti2_resource_link.id;


--
-- Name: mdl_enrol_lti_lti2_share_key; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_enrol_lti_lti2_share_key (
    id bigint NOT NULL,
    sharekey character varying(32) DEFAULT ''::character varying NOT NULL,
    resourcelinkid bigint NOT NULL,
    autoapprove smallint NOT NULL,
    expires bigint NOT NULL
);


ALTER TABLE public.mdl_enrol_lti_lti2_share_key OWNER TO postgres;

--
-- Name: TABLE mdl_enrol_lti_lti2_share_key; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_enrol_lti_lti2_share_key IS 'Resource link share key';


--
-- Name: mdl_enrol_lti_lti2_share_key_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_lti_lti2_share_key_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_lti_lti2_share_key_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_lti_lti2_share_key_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_enrol_lti_lti2_share_key_id_seq OWNED BY public.mdl_enrol_lti_lti2_share_key.id;


--
-- Name: mdl_enrol_lti_lti2_tool_proxy; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_enrol_lti_lti2_tool_proxy (
    id bigint NOT NULL,
    toolproxykey character varying(32) DEFAULT ''::character varying NOT NULL,
    consumerid bigint NOT NULL,
    toolproxy text NOT NULL,
    created bigint NOT NULL,
    updated bigint NOT NULL
);


ALTER TABLE public.mdl_enrol_lti_lti2_tool_proxy OWNER TO postgres;

--
-- Name: TABLE mdl_enrol_lti_lti2_tool_proxy; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_enrol_lti_lti2_tool_proxy IS 'A tool proxy between moodle and a consumer';


--
-- Name: mdl_enrol_lti_lti2_tool_proxy_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_lti_lti2_tool_proxy_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_lti_lti2_tool_proxy_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_lti_lti2_tool_proxy_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_enrol_lti_lti2_tool_proxy_id_seq OWNED BY public.mdl_enrol_lti_lti2_tool_proxy.id;


--
-- Name: mdl_enrol_lti_lti2_user_result; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_enrol_lti_lti2_user_result (
    id bigint NOT NULL,
    resourcelinkid bigint NOT NULL,
    ltiuserkey character varying(255) DEFAULT ''::character varying NOT NULL,
    ltiresultsourcedid character varying(1024) DEFAULT ''::character varying NOT NULL,
    created bigint NOT NULL,
    updated bigint NOT NULL
);


ALTER TABLE public.mdl_enrol_lti_lti2_user_result OWNER TO postgres;

--
-- Name: TABLE mdl_enrol_lti_lti2_user_result; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_enrol_lti_lti2_user_result IS 'Results for each user for each resource link';


--
-- Name: mdl_enrol_lti_lti2_user_result_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_lti_lti2_user_result_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_lti_lti2_user_result_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_lti_lti2_user_result_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_enrol_lti_lti2_user_result_id_seq OWNED BY public.mdl_enrol_lti_lti2_user_result.id;


--
-- Name: mdl_enrol_lti_tool_consumer_map; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_enrol_lti_tool_consumer_map (
    id bigint NOT NULL,
    toolid bigint NOT NULL,
    consumerid bigint NOT NULL
);


ALTER TABLE public.mdl_enrol_lti_tool_consumer_map OWNER TO postgres;

--
-- Name: TABLE mdl_enrol_lti_tool_consumer_map; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_enrol_lti_tool_consumer_map IS 'Table that maps the published tool to tool consumers.';


--
-- Name: mdl_enrol_lti_tool_consumer_map_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_lti_tool_consumer_map_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_lti_tool_consumer_map_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_lti_tool_consumer_map_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_enrol_lti_tool_consumer_map_id_seq OWNED BY public.mdl_enrol_lti_tool_consumer_map.id;


--
-- Name: mdl_enrol_lti_tools; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_enrol_lti_tools (
    id bigint NOT NULL,
    enrolid bigint NOT NULL,
    contextid bigint NOT NULL,
    institution character varying(40) DEFAULT ''::character varying NOT NULL,
    lang character varying(30) DEFAULT 'en'::character varying NOT NULL,
    timezone character varying(100) DEFAULT '99'::character varying NOT NULL,
    maxenrolled bigint DEFAULT 0 NOT NULL,
    maildisplay smallint DEFAULT 2 NOT NULL,
    city character varying(120) DEFAULT ''::character varying NOT NULL,
    country character varying(2) DEFAULT ''::character varying NOT NULL,
    gradesync smallint DEFAULT 0 NOT NULL,
    gradesynccompletion smallint DEFAULT 0 NOT NULL,
    membersync smallint DEFAULT 0 NOT NULL,
    membersyncmode smallint DEFAULT 0 NOT NULL,
    roleinstructor bigint NOT NULL,
    rolelearner bigint NOT NULL,
    secret text,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_enrol_lti_tools OWNER TO postgres;

--
-- Name: TABLE mdl_enrol_lti_tools; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_enrol_lti_tools IS 'List of tools provided to the remote system';


--
-- Name: mdl_enrol_lti_tools_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_lti_tools_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_lti_tools_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_lti_tools_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_enrol_lti_tools_id_seq OWNED BY public.mdl_enrol_lti_tools.id;


--
-- Name: mdl_enrol_lti_users; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_enrol_lti_users (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    toolid bigint NOT NULL,
    serviceurl text,
    sourceid text,
    consumerkey text,
    consumersecret text,
    membershipsurl text,
    membershipsid text,
    lastgrade numeric(10,5),
    lastaccess bigint,
    timecreated bigint
);


ALTER TABLE public.mdl_enrol_lti_users OWNER TO postgres;

--
-- Name: TABLE mdl_enrol_lti_users; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_enrol_lti_users IS 'User access log and gradeback data';


--
-- Name: mdl_enrol_lti_users_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_lti_users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_lti_users_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_lti_users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_enrol_lti_users_id_seq OWNED BY public.mdl_enrol_lti_users.id;


--
-- Name: mdl_enrol_paypal; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_enrol_paypal (
    id bigint NOT NULL,
    business character varying(255) DEFAULT ''::character varying NOT NULL,
    receiver_email character varying(255) DEFAULT ''::character varying NOT NULL,
    receiver_id character varying(255) DEFAULT ''::character varying NOT NULL,
    item_name character varying(255) DEFAULT ''::character varying NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    instanceid bigint DEFAULT 0 NOT NULL,
    memo character varying(255) DEFAULT ''::character varying NOT NULL,
    tax character varying(255) DEFAULT ''::character varying NOT NULL,
    option_name1 character varying(255) DEFAULT ''::character varying NOT NULL,
    option_selection1_x character varying(255) DEFAULT ''::character varying NOT NULL,
    option_name2 character varying(255) DEFAULT ''::character varying NOT NULL,
    option_selection2_x character varying(255) DEFAULT ''::character varying NOT NULL,
    payment_status character varying(255) DEFAULT ''::character varying NOT NULL,
    pending_reason character varying(255) DEFAULT ''::character varying NOT NULL,
    reason_code character varying(30) DEFAULT ''::character varying NOT NULL,
    txn_id character varying(255) DEFAULT ''::character varying NOT NULL,
    parent_txn_id character varying(255) DEFAULT ''::character varying NOT NULL,
    payment_type character varying(30) DEFAULT ''::character varying NOT NULL,
    timeupdated bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_enrol_paypal OWNER TO postgres;

--
-- Name: TABLE mdl_enrol_paypal; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_enrol_paypal IS 'Holds all known information about PayPal transactions';


--
-- Name: mdl_enrol_paypal_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_paypal_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_paypal_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_paypal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_enrol_paypal_id_seq OWNED BY public.mdl_enrol_paypal.id;


--
-- Name: mdl_event; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_event (
    id bigint NOT NULL,
    name text NOT NULL,
    description text NOT NULL,
    format smallint DEFAULT 0 NOT NULL,
    categoryid bigint DEFAULT 0 NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    groupid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    repeatid bigint DEFAULT 0 NOT NULL,
    modulename character varying(20) DEFAULT ''::character varying NOT NULL,
    instance bigint DEFAULT 0 NOT NULL,
    type smallint DEFAULT 0 NOT NULL,
    eventtype character varying(20) DEFAULT ''::character varying NOT NULL,
    timestart bigint DEFAULT 0 NOT NULL,
    timeduration bigint DEFAULT 0 NOT NULL,
    timesort bigint,
    visible smallint DEFAULT 1 NOT NULL,
    uuid character varying(255) DEFAULT ''::character varying NOT NULL,
    sequence bigint DEFAULT 1 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    subscriptionid bigint,
    priority bigint,
    location text
);


ALTER TABLE public.mdl_event OWNER TO postgres;

--
-- Name: TABLE mdl_event; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_event IS 'For everything with a time associated to it';


--
-- Name: mdl_event_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_event_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_event_id_seq OWNER TO postgres;

--
-- Name: mdl_event_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_event_id_seq OWNED BY public.mdl_event.id;


--
-- Name: mdl_event_subscriptions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_event_subscriptions (
    id bigint NOT NULL,
    url character varying(255) DEFAULT ''::character varying NOT NULL,
    categoryid bigint DEFAULT 0 NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    groupid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    eventtype character varying(20) DEFAULT ''::character varying NOT NULL,
    pollinterval bigint DEFAULT 0 NOT NULL,
    lastupdated bigint,
    name character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_event_subscriptions OWNER TO postgres;

--
-- Name: TABLE mdl_event_subscriptions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_event_subscriptions IS 'Tracks subscriptions to remote calendars.';


--
-- Name: mdl_event_subscriptions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_event_subscriptions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_event_subscriptions_id_seq OWNER TO postgres;

--
-- Name: mdl_event_subscriptions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_event_subscriptions_id_seq OWNED BY public.mdl_event_subscriptions.id;


--
-- Name: mdl_events_handlers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_events_handlers (
    id bigint NOT NULL,
    eventname character varying(166) DEFAULT ''::character varying NOT NULL,
    component character varying(166) DEFAULT ''::character varying NOT NULL,
    handlerfile character varying(255) DEFAULT ''::character varying NOT NULL,
    handlerfunction text,
    schedule character varying(255),
    status bigint DEFAULT 0 NOT NULL,
    internal smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_events_handlers OWNER TO postgres;

--
-- Name: TABLE mdl_events_handlers; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_events_handlers IS 'This table is for storing which components requests what type of event, and the location of the responsible handlers. For example, the assignment registers ''grade_updated'' event with a function assignment_grade_handler() that should be called event t';


--
-- Name: mdl_events_handlers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_events_handlers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_events_handlers_id_seq OWNER TO postgres;

--
-- Name: mdl_events_handlers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_events_handlers_id_seq OWNED BY public.mdl_events_handlers.id;


--
-- Name: mdl_events_queue; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_events_queue (
    id bigint NOT NULL,
    eventdata text NOT NULL,
    stackdump text,
    userid bigint,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_events_queue OWNER TO postgres;

--
-- Name: TABLE mdl_events_queue; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_events_queue IS 'This table is for storing queued events. It stores only one copy of the eventdata here, and entries from this table are being references by the event_queue_handlers table.';


--
-- Name: mdl_events_queue_handlers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_events_queue_handlers (
    id bigint NOT NULL,
    queuedeventid bigint NOT NULL,
    handlerid bigint NOT NULL,
    status bigint,
    errormessage text,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_events_queue_handlers OWNER TO postgres;

--
-- Name: TABLE mdl_events_queue_handlers; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_events_queue_handlers IS 'This is the list of queued handlers for processing. The event object is retrieved from the events_queue table. When no further reference is made to the event_queues table, the corresponding entry in the events_queue table should be deleted. Entry sho';


--
-- Name: mdl_events_queue_handlers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_events_queue_handlers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_events_queue_handlers_id_seq OWNER TO postgres;

--
-- Name: mdl_events_queue_handlers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_events_queue_handlers_id_seq OWNED BY public.mdl_events_queue_handlers.id;


--
-- Name: mdl_events_queue_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_events_queue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_events_queue_id_seq OWNER TO postgres;

--
-- Name: mdl_events_queue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_events_queue_id_seq OWNED BY public.mdl_events_queue.id;


--
-- Name: mdl_external_functions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_external_functions (
    id bigint NOT NULL,
    name character varying(200) DEFAULT ''::character varying NOT NULL,
    classname character varying(100) DEFAULT ''::character varying NOT NULL,
    methodname character varying(100) DEFAULT ''::character varying NOT NULL,
    classpath character varying(255),
    component character varying(100) DEFAULT ''::character varying NOT NULL,
    capabilities character varying(255),
    services character varying(1333)
);


ALTER TABLE public.mdl_external_functions OWNER TO postgres;

--
-- Name: TABLE mdl_external_functions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_external_functions IS 'list of all external functions';


--
-- Name: mdl_external_functions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_external_functions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_external_functions_id_seq OWNER TO postgres;

--
-- Name: mdl_external_functions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_external_functions_id_seq OWNED BY public.mdl_external_functions.id;


--
-- Name: mdl_external_services; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_external_services (
    id bigint NOT NULL,
    name character varying(200) DEFAULT ''::character varying NOT NULL,
    enabled smallint NOT NULL,
    requiredcapability character varying(150),
    restrictedusers smallint NOT NULL,
    component character varying(100),
    timecreated bigint NOT NULL,
    timemodified bigint,
    shortname character varying(255),
    downloadfiles smallint DEFAULT 0 NOT NULL,
    uploadfiles smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_external_services OWNER TO postgres;

--
-- Name: TABLE mdl_external_services; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_external_services IS 'built in and custom external services';


--
-- Name: mdl_external_services_functions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_external_services_functions (
    id bigint NOT NULL,
    externalserviceid bigint NOT NULL,
    functionname character varying(200) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_external_services_functions OWNER TO postgres;

--
-- Name: TABLE mdl_external_services_functions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_external_services_functions IS 'lists functions available in each service group';


--
-- Name: mdl_external_services_functions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_external_services_functions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_external_services_functions_id_seq OWNER TO postgres;

--
-- Name: mdl_external_services_functions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_external_services_functions_id_seq OWNED BY public.mdl_external_services_functions.id;


--
-- Name: mdl_external_services_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_external_services_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_external_services_id_seq OWNER TO postgres;

--
-- Name: mdl_external_services_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_external_services_id_seq OWNED BY public.mdl_external_services.id;


--
-- Name: mdl_external_services_users; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_external_services_users (
    id bigint NOT NULL,
    externalserviceid bigint NOT NULL,
    userid bigint NOT NULL,
    iprestriction character varying(255),
    validuntil bigint,
    timecreated bigint
);


ALTER TABLE public.mdl_external_services_users OWNER TO postgres;

--
-- Name: TABLE mdl_external_services_users; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_external_services_users IS 'users allowed to use services with restricted users flag';


--
-- Name: mdl_external_services_users_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_external_services_users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_external_services_users_id_seq OWNER TO postgres;

--
-- Name: mdl_external_services_users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_external_services_users_id_seq OWNED BY public.mdl_external_services_users.id;


--
-- Name: mdl_external_tokens; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_external_tokens (
    id bigint NOT NULL,
    token character varying(128) DEFAULT ''::character varying NOT NULL,
    privatetoken character varying(64),
    tokentype smallint NOT NULL,
    userid bigint NOT NULL,
    externalserviceid bigint NOT NULL,
    sid character varying(128),
    contextid bigint NOT NULL,
    creatorid bigint DEFAULT 1 NOT NULL,
    iprestriction character varying(255),
    validuntil bigint,
    timecreated bigint NOT NULL,
    lastaccess bigint
);


ALTER TABLE public.mdl_external_tokens OWNER TO postgres;

--
-- Name: TABLE mdl_external_tokens; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_external_tokens IS 'Security tokens for accessing of external services';


--
-- Name: mdl_external_tokens_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_external_tokens_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_external_tokens_id_seq OWNER TO postgres;

--
-- Name: mdl_external_tokens_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_external_tokens_id_seq OWNED BY public.mdl_external_tokens.id;


--
-- Name: mdl_favourite; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_favourite (
    id bigint NOT NULL,
    component character varying(100) DEFAULT ''::character varying NOT NULL,
    itemtype character varying(100) DEFAULT ''::character varying NOT NULL,
    itemid bigint NOT NULL,
    contextid bigint NOT NULL,
    userid bigint NOT NULL,
    ordering bigint,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_favourite OWNER TO postgres;

--
-- Name: TABLE mdl_favourite; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_favourite IS 'Stores the relationship between an arbitrary item (itemtype, itemid), and a context area (component, contextid) for a specific user. Used by the favourites subsystem.';


--
-- Name: mdl_favourite_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_favourite_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_favourite_id_seq OWNER TO postgres;

--
-- Name: mdl_favourite_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_favourite_id_seq OWNED BY public.mdl_favourite.id;


--
-- Name: mdl_feedback; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_feedback (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text NOT NULL,
    introformat smallint DEFAULT 0 NOT NULL,
    anonymous smallint DEFAULT 1 NOT NULL,
    email_notification smallint DEFAULT 1 NOT NULL,
    multiple_submit smallint DEFAULT 1 NOT NULL,
    autonumbering smallint DEFAULT 1 NOT NULL,
    site_after_submit character varying(255) DEFAULT ''::character varying NOT NULL,
    page_after_submit text NOT NULL,
    page_after_submitformat smallint DEFAULT 0 NOT NULL,
    publish_stats smallint DEFAULT 0 NOT NULL,
    timeopen bigint DEFAULT 0 NOT NULL,
    timeclose bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    completionsubmit smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_feedback OWNER TO postgres;

--
-- Name: TABLE mdl_feedback; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_feedback IS 'all feedbacks';


--
-- Name: mdl_feedback_completed; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_feedback_completed (
    id bigint NOT NULL,
    feedback bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    random_response bigint DEFAULT 0 NOT NULL,
    anonymous_response smallint DEFAULT 0 NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_feedback_completed OWNER TO postgres;

--
-- Name: TABLE mdl_feedback_completed; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_feedback_completed IS 'filled out feedback';


--
-- Name: mdl_feedback_completed_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_feedback_completed_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_feedback_completed_id_seq OWNER TO postgres;

--
-- Name: mdl_feedback_completed_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_feedback_completed_id_seq OWNED BY public.mdl_feedback_completed.id;


--
-- Name: mdl_feedback_completedtmp; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_feedback_completedtmp (
    id bigint NOT NULL,
    feedback bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    guestid character varying(255) DEFAULT ''::character varying NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    random_response bigint DEFAULT 0 NOT NULL,
    anonymous_response smallint DEFAULT 0 NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_feedback_completedtmp OWNER TO postgres;

--
-- Name: TABLE mdl_feedback_completedtmp; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_feedback_completedtmp IS 'filled out feedback';


--
-- Name: mdl_feedback_completedtmp_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_feedback_completedtmp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_feedback_completedtmp_id_seq OWNER TO postgres;

--
-- Name: mdl_feedback_completedtmp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_feedback_completedtmp_id_seq OWNED BY public.mdl_feedback_completedtmp.id;


--
-- Name: mdl_feedback_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_feedback_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_feedback_id_seq OWNER TO postgres;

--
-- Name: mdl_feedback_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_feedback_id_seq OWNED BY public.mdl_feedback.id;


--
-- Name: mdl_feedback_item; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_feedback_item (
    id bigint NOT NULL,
    feedback bigint DEFAULT 0 NOT NULL,
    template bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    label character varying(255) DEFAULT ''::character varying NOT NULL,
    presentation text NOT NULL,
    typ character varying(255) DEFAULT ''::character varying NOT NULL,
    hasvalue smallint DEFAULT 0 NOT NULL,
    "position" smallint DEFAULT 0 NOT NULL,
    required smallint DEFAULT 0 NOT NULL,
    dependitem bigint DEFAULT 0 NOT NULL,
    dependvalue character varying(255) DEFAULT ''::character varying NOT NULL,
    options character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_feedback_item OWNER TO postgres;

--
-- Name: TABLE mdl_feedback_item; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_feedback_item IS 'feedback_items';


--
-- Name: mdl_feedback_item_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_feedback_item_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_feedback_item_id_seq OWNER TO postgres;

--
-- Name: mdl_feedback_item_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_feedback_item_id_seq OWNED BY public.mdl_feedback_item.id;


--
-- Name: mdl_feedback_sitecourse_map; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_feedback_sitecourse_map (
    id bigint NOT NULL,
    feedbackid bigint DEFAULT 0 NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_feedback_sitecourse_map OWNER TO postgres;

--
-- Name: TABLE mdl_feedback_sitecourse_map; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_feedback_sitecourse_map IS 'feedback sitecourse map';


--
-- Name: mdl_feedback_sitecourse_map_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_feedback_sitecourse_map_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_feedback_sitecourse_map_id_seq OWNER TO postgres;

--
-- Name: mdl_feedback_sitecourse_map_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_feedback_sitecourse_map_id_seq OWNED BY public.mdl_feedback_sitecourse_map.id;


--
-- Name: mdl_feedback_template; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_feedback_template (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    ispublic smallint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_feedback_template OWNER TO postgres;

--
-- Name: TABLE mdl_feedback_template; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_feedback_template IS 'templates of feedbackstructures';


--
-- Name: mdl_feedback_template_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_feedback_template_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_feedback_template_id_seq OWNER TO postgres;

--
-- Name: mdl_feedback_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_feedback_template_id_seq OWNED BY public.mdl_feedback_template.id;


--
-- Name: mdl_feedback_value; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_feedback_value (
    id bigint NOT NULL,
    course_id bigint DEFAULT 0 NOT NULL,
    item bigint DEFAULT 0 NOT NULL,
    completed bigint DEFAULT 0 NOT NULL,
    tmp_completed bigint DEFAULT 0 NOT NULL,
    value text NOT NULL
);


ALTER TABLE public.mdl_feedback_value OWNER TO postgres;

--
-- Name: TABLE mdl_feedback_value; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_feedback_value IS 'values of the completeds';


--
-- Name: mdl_feedback_value_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_feedback_value_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_feedback_value_id_seq OWNER TO postgres;

--
-- Name: mdl_feedback_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_feedback_value_id_seq OWNED BY public.mdl_feedback_value.id;


--
-- Name: mdl_feedback_valuetmp; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_feedback_valuetmp (
    id bigint NOT NULL,
    course_id bigint DEFAULT 0 NOT NULL,
    item bigint DEFAULT 0 NOT NULL,
    completed bigint DEFAULT 0 NOT NULL,
    tmp_completed bigint DEFAULT 0 NOT NULL,
    value text NOT NULL
);


ALTER TABLE public.mdl_feedback_valuetmp OWNER TO postgres;

--
-- Name: TABLE mdl_feedback_valuetmp; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_feedback_valuetmp IS 'values of the completedstmp';


--
-- Name: mdl_feedback_valuetmp_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_feedback_valuetmp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_feedback_valuetmp_id_seq OWNER TO postgres;

--
-- Name: mdl_feedback_valuetmp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_feedback_valuetmp_id_seq OWNED BY public.mdl_feedback_valuetmp.id;


--
-- Name: mdl_file_conversion; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_file_conversion (
    id bigint NOT NULL,
    usermodified bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    sourcefileid bigint NOT NULL,
    targetformat character varying(100) DEFAULT ''::character varying NOT NULL,
    status bigint DEFAULT 0,
    statusmessage text,
    converter character varying(255),
    destfileid bigint,
    data text
);


ALTER TABLE public.mdl_file_conversion OWNER TO postgres;

--
-- Name: TABLE mdl_file_conversion; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_file_conversion IS 'Table to track file conversions.';


--
-- Name: mdl_file_conversion_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_file_conversion_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_file_conversion_id_seq OWNER TO postgres;

--
-- Name: mdl_file_conversion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_file_conversion_id_seq OWNED BY public.mdl_file_conversion.id;


--
-- Name: mdl_files; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_files (
    id bigint NOT NULL,
    contenthash character varying(40) DEFAULT ''::character varying NOT NULL,
    pathnamehash character varying(40) DEFAULT ''::character varying NOT NULL,
    contextid bigint NOT NULL,
    component character varying(100) DEFAULT ''::character varying NOT NULL,
    filearea character varying(50) DEFAULT ''::character varying NOT NULL,
    itemid bigint NOT NULL,
    filepath character varying(255) DEFAULT ''::character varying NOT NULL,
    filename character varying(255) DEFAULT ''::character varying NOT NULL,
    userid bigint,
    filesize bigint NOT NULL,
    mimetype character varying(100),
    status bigint DEFAULT 0 NOT NULL,
    source text,
    author character varying(255),
    license character varying(255),
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL,
    referencefileid bigint
);


ALTER TABLE public.mdl_files OWNER TO postgres;

--
-- Name: TABLE mdl_files; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_files IS 'description of files, content is stored in sha1 file pool';


--
-- Name: mdl_files_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_files_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_files_id_seq OWNER TO postgres;

--
-- Name: mdl_files_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_files_id_seq OWNED BY public.mdl_files.id;


--
-- Name: mdl_files_reference; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_files_reference (
    id bigint NOT NULL,
    repositoryid bigint NOT NULL,
    lastsync bigint,
    reference text,
    referencehash character varying(40) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_files_reference OWNER TO postgres;

--
-- Name: TABLE mdl_files_reference; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_files_reference IS 'Store files references';


--
-- Name: mdl_files_reference_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_files_reference_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_files_reference_id_seq OWNER TO postgres;

--
-- Name: mdl_files_reference_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_files_reference_id_seq OWNED BY public.mdl_files_reference.id;


--
-- Name: mdl_filter_active; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_filter_active (
    id bigint NOT NULL,
    filter character varying(32) DEFAULT ''::character varying NOT NULL,
    contextid bigint NOT NULL,
    active smallint NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_filter_active OWNER TO postgres;

--
-- Name: TABLE mdl_filter_active; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_filter_active IS 'Stores information about which filters are active in which contexts. Also the filter sort order. See get_active_filters in lib/filterlib.php for how this data is used.';


--
-- Name: mdl_filter_active_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_filter_active_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_filter_active_id_seq OWNER TO postgres;

--
-- Name: mdl_filter_active_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_filter_active_id_seq OWNED BY public.mdl_filter_active.id;


--
-- Name: mdl_filter_config; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_filter_config (
    id bigint NOT NULL,
    filter character varying(32) DEFAULT ''::character varying NOT NULL,
    contextid bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    value text
);


ALTER TABLE public.mdl_filter_config OWNER TO postgres;

--
-- Name: TABLE mdl_filter_config; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_filter_config IS 'Stores per-context configuration settings for filters which have them.';


--
-- Name: mdl_filter_config_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_filter_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_filter_config_id_seq OWNER TO postgres;

--
-- Name: mdl_filter_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_filter_config_id_seq OWNED BY public.mdl_filter_config.id;


--
-- Name: mdl_folder; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_folder (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text,
    introformat smallint DEFAULT 0 NOT NULL,
    revision bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    display smallint DEFAULT 0 NOT NULL,
    showexpanded smallint DEFAULT 1 NOT NULL,
    showdownloadfolder smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_folder OWNER TO postgres;

--
-- Name: TABLE mdl_folder; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_folder IS 'each record is one folder resource';


--
-- Name: mdl_folder_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_folder_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_folder_id_seq OWNER TO postgres;

--
-- Name: mdl_folder_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_folder_id_seq OWNED BY public.mdl_folder.id;


--
-- Name: mdl_forum; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_forum (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    type character varying(20) DEFAULT 'general'::character varying NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text NOT NULL,
    introformat smallint DEFAULT 0 NOT NULL,
    duedate bigint DEFAULT 0 NOT NULL,
    cutoffdate bigint DEFAULT 0 NOT NULL,
    assessed bigint DEFAULT 0 NOT NULL,
    assesstimestart bigint DEFAULT 0 NOT NULL,
    assesstimefinish bigint DEFAULT 0 NOT NULL,
    scale bigint DEFAULT 0 NOT NULL,
    grade_forum bigint DEFAULT 0 NOT NULL,
    grade_forum_notify smallint DEFAULT 0 NOT NULL,
    maxbytes bigint DEFAULT 0 NOT NULL,
    maxattachments bigint DEFAULT 1 NOT NULL,
    forcesubscribe smallint DEFAULT 0 NOT NULL,
    trackingtype smallint DEFAULT 1 NOT NULL,
    rsstype smallint DEFAULT 0 NOT NULL,
    rssarticles smallint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    warnafter bigint DEFAULT 0 NOT NULL,
    blockafter bigint DEFAULT 0 NOT NULL,
    blockperiod bigint DEFAULT 0 NOT NULL,
    completiondiscussions integer DEFAULT 0 NOT NULL,
    completionreplies integer DEFAULT 0 NOT NULL,
    completionposts integer DEFAULT 0 NOT NULL,
    displaywordcount smallint DEFAULT 0 NOT NULL,
    lockdiscussionafter bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_forum OWNER TO postgres;

--
-- Name: TABLE mdl_forum; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_forum IS 'Forums contain and structure discussion';


--
-- Name: mdl_forum_digests; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_forum_digests (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    forum bigint NOT NULL,
    maildigest smallint DEFAULT '-1'::integer NOT NULL
);


ALTER TABLE public.mdl_forum_digests OWNER TO postgres;

--
-- Name: TABLE mdl_forum_digests; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_forum_digests IS 'Keeps track of user mail delivery preferences for each forum';


--
-- Name: mdl_forum_digests_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_digests_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_digests_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_digests_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_forum_digests_id_seq OWNED BY public.mdl_forum_digests.id;


--
-- Name: mdl_forum_discussion_subs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_forum_discussion_subs (
    id bigint NOT NULL,
    forum bigint NOT NULL,
    userid bigint NOT NULL,
    discussion bigint NOT NULL,
    preference bigint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_forum_discussion_subs OWNER TO postgres;

--
-- Name: TABLE mdl_forum_discussion_subs; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_forum_discussion_subs IS 'Users may choose to subscribe and unsubscribe from specific discussions.';


--
-- Name: mdl_forum_discussion_subs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_discussion_subs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_discussion_subs_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_discussion_subs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_forum_discussion_subs_id_seq OWNED BY public.mdl_forum_discussion_subs.id;


--
-- Name: mdl_forum_discussions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_forum_discussions (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    forum bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    firstpost bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    groupid bigint DEFAULT '-1'::integer NOT NULL,
    assessed smallint DEFAULT 1 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    usermodified bigint DEFAULT 0 NOT NULL,
    timestart bigint DEFAULT 0 NOT NULL,
    timeend bigint DEFAULT 0 NOT NULL,
    pinned smallint DEFAULT 0 NOT NULL,
    timelocked bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_forum_discussions OWNER TO postgres;

--
-- Name: TABLE mdl_forum_discussions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_forum_discussions IS 'Forums are composed of discussions';


--
-- Name: mdl_forum_discussions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_discussions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_discussions_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_discussions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_forum_discussions_id_seq OWNED BY public.mdl_forum_discussions.id;


--
-- Name: mdl_forum_grades; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_forum_grades (
    id bigint NOT NULL,
    forum bigint NOT NULL,
    itemnumber bigint NOT NULL,
    userid bigint NOT NULL,
    grade numeric(10,5),
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_forum_grades OWNER TO postgres;

--
-- Name: TABLE mdl_forum_grades; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_forum_grades IS 'Grading data for forum instances';


--
-- Name: mdl_forum_grades_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_grades_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_grades_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_grades_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_forum_grades_id_seq OWNED BY public.mdl_forum_grades.id;


--
-- Name: mdl_forum_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_forum_id_seq OWNED BY public.mdl_forum.id;


--
-- Name: mdl_forum_posts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_forum_posts (
    id bigint NOT NULL,
    discussion bigint DEFAULT 0 NOT NULL,
    parent bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    created bigint DEFAULT 0 NOT NULL,
    modified bigint DEFAULT 0 NOT NULL,
    mailed smallint DEFAULT 0 NOT NULL,
    subject character varying(255) DEFAULT ''::character varying NOT NULL,
    message text NOT NULL,
    messageformat smallint DEFAULT 0 NOT NULL,
    messagetrust smallint DEFAULT 0 NOT NULL,
    attachment character varying(100) DEFAULT ''::character varying NOT NULL,
    totalscore smallint DEFAULT 0 NOT NULL,
    mailnow bigint DEFAULT 0 NOT NULL,
    deleted smallint DEFAULT 0 NOT NULL,
    privatereplyto bigint DEFAULT 0 NOT NULL,
    wordcount bigint,
    charcount bigint
);


ALTER TABLE public.mdl_forum_posts OWNER TO postgres;

--
-- Name: TABLE mdl_forum_posts; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_forum_posts IS 'All posts are stored in this table';


--
-- Name: mdl_forum_posts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_posts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_posts_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_posts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_forum_posts_id_seq OWNED BY public.mdl_forum_posts.id;


--
-- Name: mdl_forum_queue; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_forum_queue (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    discussionid bigint DEFAULT 0 NOT NULL,
    postid bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_forum_queue OWNER TO postgres;

--
-- Name: TABLE mdl_forum_queue; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_forum_queue IS 'For keeping track of posts that will be mailed in digest form';


--
-- Name: mdl_forum_queue_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_queue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_queue_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_queue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_forum_queue_id_seq OWNED BY public.mdl_forum_queue.id;


--
-- Name: mdl_forum_read; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_forum_read (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    forumid bigint DEFAULT 0 NOT NULL,
    discussionid bigint DEFAULT 0 NOT NULL,
    postid bigint DEFAULT 0 NOT NULL,
    firstread bigint DEFAULT 0 NOT NULL,
    lastread bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_forum_read OWNER TO postgres;

--
-- Name: TABLE mdl_forum_read; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_forum_read IS 'Tracks each users read posts';


--
-- Name: mdl_forum_read_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_read_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_read_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_read_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_forum_read_id_seq OWNED BY public.mdl_forum_read.id;


--
-- Name: mdl_forum_subscriptions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_forum_subscriptions (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    forum bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_forum_subscriptions OWNER TO postgres;

--
-- Name: TABLE mdl_forum_subscriptions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_forum_subscriptions IS 'Keeps track of who is subscribed to what forum';


--
-- Name: mdl_forum_subscriptions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_subscriptions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_subscriptions_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_subscriptions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_forum_subscriptions_id_seq OWNED BY public.mdl_forum_subscriptions.id;


--
-- Name: mdl_forum_track_prefs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_forum_track_prefs (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    forumid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_forum_track_prefs OWNER TO postgres;

--
-- Name: TABLE mdl_forum_track_prefs; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_forum_track_prefs IS 'Tracks each users untracked forums';


--
-- Name: mdl_forum_track_prefs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_track_prefs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_track_prefs_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_track_prefs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_forum_track_prefs_id_seq OWNED BY public.mdl_forum_track_prefs.id;


--
-- Name: mdl_glossary; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_glossary (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text NOT NULL,
    introformat smallint DEFAULT 0 NOT NULL,
    allowduplicatedentries smallint DEFAULT 0 NOT NULL,
    displayformat character varying(50) DEFAULT 'dictionary'::character varying NOT NULL,
    mainglossary smallint DEFAULT 0 NOT NULL,
    showspecial smallint DEFAULT 1 NOT NULL,
    showalphabet smallint DEFAULT 1 NOT NULL,
    showall smallint DEFAULT 1 NOT NULL,
    allowcomments smallint DEFAULT 0 NOT NULL,
    allowprintview smallint DEFAULT 1 NOT NULL,
    usedynalink smallint DEFAULT 1 NOT NULL,
    defaultapproval smallint DEFAULT 1 NOT NULL,
    approvaldisplayformat character varying(50) DEFAULT 'default'::character varying NOT NULL,
    globalglossary smallint DEFAULT 0 NOT NULL,
    entbypage smallint DEFAULT 10 NOT NULL,
    editalways smallint DEFAULT 0 NOT NULL,
    rsstype smallint DEFAULT 0 NOT NULL,
    rssarticles smallint DEFAULT 0 NOT NULL,
    assessed bigint DEFAULT 0 NOT NULL,
    assesstimestart bigint DEFAULT 0 NOT NULL,
    assesstimefinish bigint DEFAULT 0 NOT NULL,
    scale bigint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    completionentries integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_glossary OWNER TO postgres;

--
-- Name: TABLE mdl_glossary; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_glossary IS 'all glossaries';


--
-- Name: mdl_glossary_alias; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_glossary_alias (
    id bigint NOT NULL,
    entryid bigint DEFAULT 0 NOT NULL,
    alias character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_glossary_alias OWNER TO postgres;

--
-- Name: TABLE mdl_glossary_alias; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_glossary_alias IS 'entries alias';


--
-- Name: mdl_glossary_alias_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_glossary_alias_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_glossary_alias_id_seq OWNER TO postgres;

--
-- Name: mdl_glossary_alias_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_glossary_alias_id_seq OWNED BY public.mdl_glossary_alias.id;


--
-- Name: mdl_glossary_categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_glossary_categories (
    id bigint NOT NULL,
    glossaryid bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    usedynalink smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_glossary_categories OWNER TO postgres;

--
-- Name: TABLE mdl_glossary_categories; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_glossary_categories IS 'all categories for glossary entries';


--
-- Name: mdl_glossary_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_glossary_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_glossary_categories_id_seq OWNER TO postgres;

--
-- Name: mdl_glossary_categories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_glossary_categories_id_seq OWNED BY public.mdl_glossary_categories.id;


--
-- Name: mdl_glossary_entries; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_glossary_entries (
    id bigint NOT NULL,
    glossaryid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    concept character varying(255) DEFAULT ''::character varying NOT NULL,
    definition text NOT NULL,
    definitionformat smallint DEFAULT 0 NOT NULL,
    definitiontrust smallint DEFAULT 0 NOT NULL,
    attachment character varying(100) DEFAULT ''::character varying NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    teacherentry smallint DEFAULT 0 NOT NULL,
    sourceglossaryid bigint DEFAULT 0 NOT NULL,
    usedynalink smallint DEFAULT 1 NOT NULL,
    casesensitive smallint DEFAULT 0 NOT NULL,
    fullmatch smallint DEFAULT 1 NOT NULL,
    approved smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_glossary_entries OWNER TO postgres;

--
-- Name: TABLE mdl_glossary_entries; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_glossary_entries IS 'all glossary entries';


--
-- Name: mdl_glossary_entries_categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_glossary_entries_categories (
    id bigint NOT NULL,
    categoryid bigint DEFAULT 0 NOT NULL,
    entryid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_glossary_entries_categories OWNER TO postgres;

--
-- Name: TABLE mdl_glossary_entries_categories; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_glossary_entries_categories IS 'categories of each glossary entry';


--
-- Name: mdl_glossary_entries_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_glossary_entries_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_glossary_entries_categories_id_seq OWNER TO postgres;

--
-- Name: mdl_glossary_entries_categories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_glossary_entries_categories_id_seq OWNED BY public.mdl_glossary_entries_categories.id;


--
-- Name: mdl_glossary_entries_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_glossary_entries_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_glossary_entries_id_seq OWNER TO postgres;

--
-- Name: mdl_glossary_entries_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_glossary_entries_id_seq OWNED BY public.mdl_glossary_entries.id;


--
-- Name: mdl_glossary_formats; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_glossary_formats (
    id bigint NOT NULL,
    name character varying(50) DEFAULT ''::character varying NOT NULL,
    popupformatname character varying(50) DEFAULT ''::character varying NOT NULL,
    visible smallint DEFAULT 1 NOT NULL,
    showgroup smallint DEFAULT 1 NOT NULL,
    showtabs character varying(100),
    defaultmode character varying(50) DEFAULT ''::character varying NOT NULL,
    defaulthook character varying(50) DEFAULT ''::character varying NOT NULL,
    sortkey character varying(50) DEFAULT ''::character varying NOT NULL,
    sortorder character varying(50) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_glossary_formats OWNER TO postgres;

--
-- Name: TABLE mdl_glossary_formats; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_glossary_formats IS 'Setting of the display formats';


--
-- Name: mdl_glossary_formats_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_glossary_formats_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_glossary_formats_id_seq OWNER TO postgres;

--
-- Name: mdl_glossary_formats_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_glossary_formats_id_seq OWNED BY public.mdl_glossary_formats.id;


--
-- Name: mdl_glossary_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_glossary_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_glossary_id_seq OWNER TO postgres;

--
-- Name: mdl_glossary_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_glossary_id_seq OWNED BY public.mdl_glossary.id;


--
-- Name: mdl_grade_categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grade_categories (
    id bigint NOT NULL,
    courseid bigint NOT NULL,
    parent bigint,
    depth bigint DEFAULT 0 NOT NULL,
    path character varying(255),
    fullname character varying(255) DEFAULT ''::character varying NOT NULL,
    aggregation bigint DEFAULT 0 NOT NULL,
    keephigh bigint DEFAULT 0 NOT NULL,
    droplow bigint DEFAULT 0 NOT NULL,
    aggregateonlygraded smallint DEFAULT 0 NOT NULL,
    aggregateoutcomes smallint DEFAULT 0 NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    hidden smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_grade_categories OWNER TO postgres;

--
-- Name: TABLE mdl_grade_categories; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grade_categories IS 'This table keeps information about categories, used for grouping items.';


--
-- Name: mdl_grade_categories_history; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grade_categories_history (
    id bigint NOT NULL,
    action bigint DEFAULT 0 NOT NULL,
    oldid bigint NOT NULL,
    source character varying(255),
    timemodified bigint,
    loggeduser bigint,
    courseid bigint NOT NULL,
    parent bigint,
    depth bigint DEFAULT 0 NOT NULL,
    path character varying(255),
    fullname character varying(255) DEFAULT ''::character varying NOT NULL,
    aggregation bigint DEFAULT 0 NOT NULL,
    keephigh bigint DEFAULT 0 NOT NULL,
    droplow bigint DEFAULT 0 NOT NULL,
    aggregateonlygraded smallint DEFAULT 0 NOT NULL,
    aggregateoutcomes smallint DEFAULT 0 NOT NULL,
    aggregatesubcats smallint DEFAULT 0 NOT NULL,
    hidden smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_grade_categories_history OWNER TO postgres;

--
-- Name: TABLE mdl_grade_categories_history; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grade_categories_history IS 'History of grade_categories';


--
-- Name: mdl_grade_categories_history_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_categories_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_categories_history_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_categories_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grade_categories_history_id_seq OWNED BY public.mdl_grade_categories_history.id;


--
-- Name: mdl_grade_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_categories_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_categories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grade_categories_id_seq OWNED BY public.mdl_grade_categories.id;


--
-- Name: mdl_grade_grades; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grade_grades (
    id bigint NOT NULL,
    itemid bigint NOT NULL,
    userid bigint NOT NULL,
    rawgrade numeric(10,5),
    rawgrademax numeric(10,5) DEFAULT 100 NOT NULL,
    rawgrademin numeric(10,5) DEFAULT 0 NOT NULL,
    rawscaleid bigint,
    usermodified bigint,
    finalgrade numeric(10,5),
    hidden bigint DEFAULT 0 NOT NULL,
    locked bigint DEFAULT 0 NOT NULL,
    locktime bigint DEFAULT 0 NOT NULL,
    exported bigint DEFAULT 0 NOT NULL,
    overridden bigint DEFAULT 0 NOT NULL,
    excluded bigint DEFAULT 0 NOT NULL,
    feedback text,
    feedbackformat bigint DEFAULT 0 NOT NULL,
    information text,
    informationformat bigint DEFAULT 0 NOT NULL,
    timecreated bigint,
    timemodified bigint,
    aggregationstatus character varying(10) DEFAULT 'unknown'::character varying NOT NULL,
    aggregationweight numeric(10,5)
);


ALTER TABLE public.mdl_grade_grades OWNER TO postgres;

--
-- Name: TABLE mdl_grade_grades; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grade_grades IS 'grade_grades  This table keeps individual grades for each user and each item, exactly as imported or submitted by modules. The rawgrademax/min and rawscaleid are stored here to record the values at the time the grade was stored, because teachers migh';


--
-- Name: mdl_grade_grades_history; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grade_grades_history (
    id bigint NOT NULL,
    action bigint DEFAULT 0 NOT NULL,
    oldid bigint NOT NULL,
    source character varying(255),
    timemodified bigint,
    loggeduser bigint,
    itemid bigint NOT NULL,
    userid bigint NOT NULL,
    rawgrade numeric(10,5),
    rawgrademax numeric(10,5) DEFAULT 100 NOT NULL,
    rawgrademin numeric(10,5) DEFAULT 0 NOT NULL,
    rawscaleid bigint,
    usermodified bigint,
    finalgrade numeric(10,5),
    hidden bigint DEFAULT 0 NOT NULL,
    locked bigint DEFAULT 0 NOT NULL,
    locktime bigint DEFAULT 0 NOT NULL,
    exported bigint DEFAULT 0 NOT NULL,
    overridden bigint DEFAULT 0 NOT NULL,
    excluded bigint DEFAULT 0 NOT NULL,
    feedback text,
    feedbackformat bigint DEFAULT 0 NOT NULL,
    information text,
    informationformat bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_grade_grades_history OWNER TO postgres;

--
-- Name: TABLE mdl_grade_grades_history; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grade_grades_history IS 'History table';


--
-- Name: mdl_grade_grades_history_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_grades_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_grades_history_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_grades_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grade_grades_history_id_seq OWNED BY public.mdl_grade_grades_history.id;


--
-- Name: mdl_grade_grades_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_grades_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_grades_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_grades_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grade_grades_id_seq OWNED BY public.mdl_grade_grades.id;


--
-- Name: mdl_grade_import_newitem; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grade_import_newitem (
    id bigint NOT NULL,
    itemname character varying(255) DEFAULT ''::character varying NOT NULL,
    importcode bigint NOT NULL,
    importer bigint NOT NULL
);


ALTER TABLE public.mdl_grade_import_newitem OWNER TO postgres;

--
-- Name: TABLE mdl_grade_import_newitem; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grade_import_newitem IS 'temporary table for storing new grade_item names from grade import';


--
-- Name: mdl_grade_import_newitem_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_import_newitem_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_import_newitem_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_import_newitem_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grade_import_newitem_id_seq OWNED BY public.mdl_grade_import_newitem.id;


--
-- Name: mdl_grade_import_values; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grade_import_values (
    id bigint NOT NULL,
    itemid bigint,
    newgradeitem bigint,
    userid bigint NOT NULL,
    finalgrade numeric(10,5),
    feedback text,
    importcode bigint NOT NULL,
    importer bigint,
    importonlyfeedback smallint DEFAULT 0
);


ALTER TABLE public.mdl_grade_import_values OWNER TO postgres;

--
-- Name: TABLE mdl_grade_import_values; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grade_import_values IS 'Temporary table for importing grades';


--
-- Name: mdl_grade_import_values_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_import_values_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_import_values_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_import_values_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grade_import_values_id_seq OWNED BY public.mdl_grade_import_values.id;


--
-- Name: mdl_grade_items; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grade_items (
    id bigint NOT NULL,
    courseid bigint,
    categoryid bigint,
    itemname character varying(255),
    itemtype character varying(30) DEFAULT ''::character varying NOT NULL,
    itemmodule character varying(30),
    iteminstance bigint,
    itemnumber bigint,
    iteminfo text,
    idnumber character varying(255),
    calculation text,
    gradetype smallint DEFAULT 1 NOT NULL,
    grademax numeric(10,5) DEFAULT 100 NOT NULL,
    grademin numeric(10,5) DEFAULT 0 NOT NULL,
    scaleid bigint,
    outcomeid bigint,
    gradepass numeric(10,5) DEFAULT 0 NOT NULL,
    multfactor numeric(10,5) DEFAULT 1.0 NOT NULL,
    plusfactor numeric(10,5) DEFAULT 0 NOT NULL,
    aggregationcoef numeric(10,5) DEFAULT 0 NOT NULL,
    aggregationcoef2 numeric(10,5) DEFAULT 0 NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL,
    display bigint DEFAULT 0 NOT NULL,
    decimals smallint,
    hidden bigint DEFAULT 0 NOT NULL,
    locked bigint DEFAULT 0 NOT NULL,
    locktime bigint DEFAULT 0 NOT NULL,
    needsupdate bigint DEFAULT 0 NOT NULL,
    weightoverride smallint DEFAULT 0 NOT NULL,
    timecreated bigint,
    timemodified bigint
);


ALTER TABLE public.mdl_grade_items OWNER TO postgres;

--
-- Name: TABLE mdl_grade_items; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grade_items IS 'This table keeps information about gradeable items (ie columns). If an activity (eg an assignment or quiz) has multiple grade_items associated with it (eg several outcomes or numerical grades), then there will be a corresponding multiple number of ro';


--
-- Name: mdl_grade_items_history; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grade_items_history (
    id bigint NOT NULL,
    action bigint DEFAULT 0 NOT NULL,
    oldid bigint NOT NULL,
    source character varying(255),
    timemodified bigint,
    loggeduser bigint,
    courseid bigint,
    categoryid bigint,
    itemname character varying(255),
    itemtype character varying(30) DEFAULT ''::character varying NOT NULL,
    itemmodule character varying(30),
    iteminstance bigint,
    itemnumber bigint,
    iteminfo text,
    idnumber character varying(255),
    calculation text,
    gradetype smallint DEFAULT 1 NOT NULL,
    grademax numeric(10,5) DEFAULT 100 NOT NULL,
    grademin numeric(10,5) DEFAULT 0 NOT NULL,
    scaleid bigint,
    outcomeid bigint,
    gradepass numeric(10,5) DEFAULT 0 NOT NULL,
    multfactor numeric(10,5) DEFAULT 1.0 NOT NULL,
    plusfactor numeric(10,5) DEFAULT 0 NOT NULL,
    aggregationcoef numeric(10,5) DEFAULT 0 NOT NULL,
    aggregationcoef2 numeric(10,5) DEFAULT 0 NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL,
    hidden bigint DEFAULT 0 NOT NULL,
    locked bigint DEFAULT 0 NOT NULL,
    locktime bigint DEFAULT 0 NOT NULL,
    needsupdate bigint DEFAULT 0 NOT NULL,
    display bigint DEFAULT 0 NOT NULL,
    decimals smallint,
    weightoverride smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_grade_items_history OWNER TO postgres;

--
-- Name: TABLE mdl_grade_items_history; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grade_items_history IS 'History of grade_items';


--
-- Name: mdl_grade_items_history_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_items_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_items_history_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_items_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grade_items_history_id_seq OWNED BY public.mdl_grade_items_history.id;


--
-- Name: mdl_grade_items_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_items_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_items_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_items_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grade_items_id_seq OWNED BY public.mdl_grade_items.id;


--
-- Name: mdl_grade_letters; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grade_letters (
    id bigint NOT NULL,
    contextid bigint NOT NULL,
    lowerboundary numeric(10,5) NOT NULL,
    letter character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_grade_letters OWNER TO postgres;

--
-- Name: TABLE mdl_grade_letters; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grade_letters IS 'Repository for grade letters, for courses and other moodle entities that use grades.';


--
-- Name: mdl_grade_letters_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_letters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_letters_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_letters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grade_letters_id_seq OWNED BY public.mdl_grade_letters.id;


--
-- Name: mdl_grade_outcomes; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grade_outcomes (
    id bigint NOT NULL,
    courseid bigint,
    shortname character varying(255) DEFAULT ''::character varying NOT NULL,
    fullname text NOT NULL,
    scaleid bigint,
    description text,
    descriptionformat smallint DEFAULT 0 NOT NULL,
    timecreated bigint,
    timemodified bigint,
    usermodified bigint
);


ALTER TABLE public.mdl_grade_outcomes OWNER TO postgres;

--
-- Name: TABLE mdl_grade_outcomes; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grade_outcomes IS 'This table describes the outcomes used in the system. An outcome is a statement tied to a rubric scale from low to high, such as âNot met, Borderline, Metâ (stored as 0,1 or 2)';


--
-- Name: mdl_grade_outcomes_courses; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grade_outcomes_courses (
    id bigint NOT NULL,
    courseid bigint NOT NULL,
    outcomeid bigint NOT NULL
);


ALTER TABLE public.mdl_grade_outcomes_courses OWNER TO postgres;

--
-- Name: TABLE mdl_grade_outcomes_courses; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grade_outcomes_courses IS 'stores what outcomes are used in what courses.';


--
-- Name: mdl_grade_outcomes_courses_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_outcomes_courses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_outcomes_courses_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_outcomes_courses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grade_outcomes_courses_id_seq OWNED BY public.mdl_grade_outcomes_courses.id;


--
-- Name: mdl_grade_outcomes_history; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grade_outcomes_history (
    id bigint NOT NULL,
    action bigint DEFAULT 0 NOT NULL,
    oldid bigint NOT NULL,
    source character varying(255),
    timemodified bigint,
    loggeduser bigint,
    courseid bigint,
    shortname character varying(255) DEFAULT ''::character varying NOT NULL,
    fullname text NOT NULL,
    scaleid bigint,
    description text,
    descriptionformat smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_grade_outcomes_history OWNER TO postgres;

--
-- Name: TABLE mdl_grade_outcomes_history; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grade_outcomes_history IS 'History table';


--
-- Name: mdl_grade_outcomes_history_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_outcomes_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_outcomes_history_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_outcomes_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grade_outcomes_history_id_seq OWNED BY public.mdl_grade_outcomes_history.id;


--
-- Name: mdl_grade_outcomes_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_outcomes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_outcomes_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_outcomes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grade_outcomes_id_seq OWNED BY public.mdl_grade_outcomes.id;


--
-- Name: mdl_grade_settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grade_settings (
    id bigint NOT NULL,
    courseid bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    value text
);


ALTER TABLE public.mdl_grade_settings OWNER TO postgres;

--
-- Name: TABLE mdl_grade_settings; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grade_settings IS 'gradebook settings';


--
-- Name: mdl_grade_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_settings_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grade_settings_id_seq OWNED BY public.mdl_grade_settings.id;


--
-- Name: mdl_grading_areas; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grading_areas (
    id bigint NOT NULL,
    contextid bigint NOT NULL,
    component character varying(100) DEFAULT ''::character varying NOT NULL,
    areaname character varying(100) DEFAULT ''::character varying NOT NULL,
    activemethod character varying(100)
);


ALTER TABLE public.mdl_grading_areas OWNER TO postgres;

--
-- Name: TABLE mdl_grading_areas; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grading_areas IS 'Identifies gradable areas where advanced grading can happen. For each area, the current active plugin can be set.';


--
-- Name: mdl_grading_areas_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grading_areas_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grading_areas_id_seq OWNER TO postgres;

--
-- Name: mdl_grading_areas_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grading_areas_id_seq OWNED BY public.mdl_grading_areas.id;


--
-- Name: mdl_grading_definitions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grading_definitions (
    id bigint NOT NULL,
    areaid bigint NOT NULL,
    method character varying(100) DEFAULT ''::character varying NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    description text,
    descriptionformat smallint,
    status bigint DEFAULT 0 NOT NULL,
    copiedfromid bigint,
    timecreated bigint NOT NULL,
    usercreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL,
    timecopied bigint DEFAULT 0,
    options text
);


ALTER TABLE public.mdl_grading_definitions OWNER TO postgres;

--
-- Name: TABLE mdl_grading_definitions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grading_definitions IS 'Contains the basic information about an advanced grading form defined in the given gradable area';


--
-- Name: mdl_grading_definitions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grading_definitions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grading_definitions_id_seq OWNER TO postgres;

--
-- Name: mdl_grading_definitions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grading_definitions_id_seq OWNED BY public.mdl_grading_definitions.id;


--
-- Name: mdl_grading_instances; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grading_instances (
    id bigint NOT NULL,
    definitionid bigint NOT NULL,
    raterid bigint NOT NULL,
    itemid bigint,
    rawgrade numeric(10,5),
    status bigint DEFAULT 0 NOT NULL,
    feedback text,
    feedbackformat smallint,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_grading_instances OWNER TO postgres;

--
-- Name: TABLE mdl_grading_instances; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grading_instances IS 'Grading form instance is an assessment record for one gradable item assessed by one rater';


--
-- Name: mdl_grading_instances_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grading_instances_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grading_instances_id_seq OWNER TO postgres;

--
-- Name: mdl_grading_instances_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grading_instances_id_seq OWNED BY public.mdl_grading_instances.id;


--
-- Name: mdl_gradingform_guide_comments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_gradingform_guide_comments (
    id bigint NOT NULL,
    definitionid bigint NOT NULL,
    sortorder bigint NOT NULL,
    description text,
    descriptionformat smallint
);


ALTER TABLE public.mdl_gradingform_guide_comments OWNER TO postgres;

--
-- Name: TABLE mdl_gradingform_guide_comments; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_gradingform_guide_comments IS 'frequently used comments used in marking guide';


--
-- Name: mdl_gradingform_guide_comments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_gradingform_guide_comments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_gradingform_guide_comments_id_seq OWNER TO postgres;

--
-- Name: mdl_gradingform_guide_comments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_gradingform_guide_comments_id_seq OWNED BY public.mdl_gradingform_guide_comments.id;


--
-- Name: mdl_gradingform_guide_criteria; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_gradingform_guide_criteria (
    id bigint NOT NULL,
    definitionid bigint NOT NULL,
    sortorder bigint NOT NULL,
    shortname character varying(255) DEFAULT ''::character varying NOT NULL,
    description text,
    descriptionformat smallint,
    descriptionmarkers text,
    descriptionmarkersformat smallint,
    maxscore numeric(10,5) NOT NULL
);


ALTER TABLE public.mdl_gradingform_guide_criteria OWNER TO postgres;

--
-- Name: TABLE mdl_gradingform_guide_criteria; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_gradingform_guide_criteria IS 'Stores the rows of the criteria grid.';


--
-- Name: mdl_gradingform_guide_criteria_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_gradingform_guide_criteria_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_gradingform_guide_criteria_id_seq OWNER TO postgres;

--
-- Name: mdl_gradingform_guide_criteria_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_gradingform_guide_criteria_id_seq OWNED BY public.mdl_gradingform_guide_criteria.id;


--
-- Name: mdl_gradingform_guide_fillings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_gradingform_guide_fillings (
    id bigint NOT NULL,
    instanceid bigint NOT NULL,
    criterionid bigint NOT NULL,
    remark text,
    remarkformat smallint,
    score numeric(10,5) NOT NULL
);


ALTER TABLE public.mdl_gradingform_guide_fillings OWNER TO postgres;

--
-- Name: TABLE mdl_gradingform_guide_fillings; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_gradingform_guide_fillings IS 'Stores the data of how the guide is filled by a particular rater';


--
-- Name: mdl_gradingform_guide_fillings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_gradingform_guide_fillings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_gradingform_guide_fillings_id_seq OWNER TO postgres;

--
-- Name: mdl_gradingform_guide_fillings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_gradingform_guide_fillings_id_seq OWNED BY public.mdl_gradingform_guide_fillings.id;


--
-- Name: mdl_gradingform_rubric_criteria; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_gradingform_rubric_criteria (
    id bigint NOT NULL,
    definitionid bigint NOT NULL,
    sortorder bigint NOT NULL,
    description text,
    descriptionformat smallint
);


ALTER TABLE public.mdl_gradingform_rubric_criteria OWNER TO postgres;

--
-- Name: TABLE mdl_gradingform_rubric_criteria; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_gradingform_rubric_criteria IS 'Stores the rows of the rubric grid.';


--
-- Name: mdl_gradingform_rubric_criteria_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_gradingform_rubric_criteria_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_gradingform_rubric_criteria_id_seq OWNER TO postgres;

--
-- Name: mdl_gradingform_rubric_criteria_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_gradingform_rubric_criteria_id_seq OWNED BY public.mdl_gradingform_rubric_criteria.id;


--
-- Name: mdl_gradingform_rubric_fillings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_gradingform_rubric_fillings (
    id bigint NOT NULL,
    instanceid bigint NOT NULL,
    criterionid bigint NOT NULL,
    levelid bigint,
    remark text,
    remarkformat smallint
);


ALTER TABLE public.mdl_gradingform_rubric_fillings OWNER TO postgres;

--
-- Name: TABLE mdl_gradingform_rubric_fillings; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_gradingform_rubric_fillings IS 'Stores the data of how the rubric is filled by a particular rater';


--
-- Name: mdl_gradingform_rubric_fillings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_gradingform_rubric_fillings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_gradingform_rubric_fillings_id_seq OWNER TO postgres;

--
-- Name: mdl_gradingform_rubric_fillings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_gradingform_rubric_fillings_id_seq OWNED BY public.mdl_gradingform_rubric_fillings.id;


--
-- Name: mdl_gradingform_rubric_levels; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_gradingform_rubric_levels (
    id bigint NOT NULL,
    criterionid bigint NOT NULL,
    score numeric(10,5) NOT NULL,
    definition text,
    definitionformat bigint
);


ALTER TABLE public.mdl_gradingform_rubric_levels OWNER TO postgres;

--
-- Name: TABLE mdl_gradingform_rubric_levels; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_gradingform_rubric_levels IS 'Stores the columns of the rubric grid.';


--
-- Name: mdl_gradingform_rubric_levels_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_gradingform_rubric_levels_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_gradingform_rubric_levels_id_seq OWNER TO postgres;

--
-- Name: mdl_gradingform_rubric_levels_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_gradingform_rubric_levels_id_seq OWNED BY public.mdl_gradingform_rubric_levels.id;


--
-- Name: mdl_groupings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_groupings (
    id bigint NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    idnumber character varying(100) DEFAULT ''::character varying NOT NULL,
    description text,
    descriptionformat smallint DEFAULT 0 NOT NULL,
    configdata text,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_groupings OWNER TO postgres;

--
-- Name: TABLE mdl_groupings; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_groupings IS 'A grouping is a collection of groups. WAS: groups_groupings';


--
-- Name: mdl_groupings_groups; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_groupings_groups (
    id bigint NOT NULL,
    groupingid bigint DEFAULT 0 NOT NULL,
    groupid bigint DEFAULT 0 NOT NULL,
    timeadded bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_groupings_groups OWNER TO postgres;

--
-- Name: TABLE mdl_groupings_groups; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_groupings_groups IS 'Link a grouping to a group (note, groups can be in multiple groupings ONLY in a course). WAS: groups_groupings_groups';


--
-- Name: mdl_groupings_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_groupings_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_groupings_groups_id_seq OWNER TO postgres;

--
-- Name: mdl_groupings_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_groupings_groups_id_seq OWNED BY public.mdl_groupings_groups.id;


--
-- Name: mdl_groupings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_groupings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_groupings_id_seq OWNER TO postgres;

--
-- Name: mdl_groupings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_groupings_id_seq OWNED BY public.mdl_groupings.id;


--
-- Name: mdl_groups; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_groups (
    id bigint NOT NULL,
    courseid bigint NOT NULL,
    idnumber character varying(100) DEFAULT ''::character varying NOT NULL,
    name character varying(254) DEFAULT ''::character varying NOT NULL,
    description text,
    descriptionformat smallint DEFAULT 0 NOT NULL,
    enrolmentkey character varying(50),
    picture bigint DEFAULT 0 NOT NULL,
    hidepicture smallint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_groups OWNER TO postgres;

--
-- Name: TABLE mdl_groups; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_groups IS 'Each record represents a group.';


--
-- Name: mdl_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_groups_id_seq OWNER TO postgres;

--
-- Name: mdl_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_groups_id_seq OWNED BY public.mdl_groups.id;


--
-- Name: mdl_groups_members; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_groups_members (
    id bigint NOT NULL,
    groupid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    timeadded bigint DEFAULT 0 NOT NULL,
    component character varying(100) DEFAULT ''::character varying NOT NULL,
    itemid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_groups_members OWNER TO postgres;

--
-- Name: TABLE mdl_groups_members; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_groups_members IS 'Link a user to a group.';


--
-- Name: mdl_groups_members_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_groups_members_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_groups_members_id_seq OWNER TO postgres;

--
-- Name: mdl_groups_members_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_groups_members_id_seq OWNED BY public.mdl_groups_members.id;


--
-- Name: mdl_h5p; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_h5p (
    id bigint NOT NULL,
    jsoncontent text NOT NULL,
    mainlibraryid bigint NOT NULL,
    displayoptions smallint,
    pathnamehash character varying(40) DEFAULT ''::character varying NOT NULL,
    contenthash character varying(40) DEFAULT ''::character varying NOT NULL,
    filtered text,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_h5p OWNER TO postgres;

--
-- Name: TABLE mdl_h5p; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_h5p IS 'Stores H5P content information';


--
-- Name: mdl_h5p_contents_libraries; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_h5p_contents_libraries (
    id bigint NOT NULL,
    h5pid bigint NOT NULL,
    libraryid bigint NOT NULL,
    dependencytype character varying(10) DEFAULT ''::character varying NOT NULL,
    dropcss smallint NOT NULL,
    weight bigint NOT NULL
);


ALTER TABLE public.mdl_h5p_contents_libraries OWNER TO postgres;

--
-- Name: TABLE mdl_h5p_contents_libraries; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_h5p_contents_libraries IS 'Store which library is used in which content.';


--
-- Name: mdl_h5p_contents_libraries_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_h5p_contents_libraries_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_h5p_contents_libraries_id_seq OWNER TO postgres;

--
-- Name: mdl_h5p_contents_libraries_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_h5p_contents_libraries_id_seq OWNED BY public.mdl_h5p_contents_libraries.id;


--
-- Name: mdl_h5p_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_h5p_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_h5p_id_seq OWNER TO postgres;

--
-- Name: mdl_h5p_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_h5p_id_seq OWNED BY public.mdl_h5p.id;


--
-- Name: mdl_h5p_libraries; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_h5p_libraries (
    id bigint NOT NULL,
    machinename character varying(255) DEFAULT ''::character varying NOT NULL,
    title character varying(255) DEFAULT ''::character varying NOT NULL,
    majorversion smallint NOT NULL,
    minorversion smallint NOT NULL,
    patchversion smallint NOT NULL,
    runnable smallint NOT NULL,
    fullscreen smallint DEFAULT 0 NOT NULL,
    embedtypes character varying(255) DEFAULT ''::character varying NOT NULL,
    preloadedjs text,
    preloadedcss text,
    droplibrarycss text,
    semantics text,
    addto text,
    coremajor smallint,
    coreminor smallint
);


ALTER TABLE public.mdl_h5p_libraries OWNER TO postgres;

--
-- Name: TABLE mdl_h5p_libraries; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_h5p_libraries IS 'Stores information about libraries used by H5P content.';


--
-- Name: mdl_h5p_libraries_cachedassets; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_h5p_libraries_cachedassets (
    id bigint NOT NULL,
    libraryid bigint NOT NULL,
    hash character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_h5p_libraries_cachedassets OWNER TO postgres;

--
-- Name: TABLE mdl_h5p_libraries_cachedassets; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_h5p_libraries_cachedassets IS 'H5P cached library assets';


--
-- Name: mdl_h5p_libraries_cachedassets_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_h5p_libraries_cachedassets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_h5p_libraries_cachedassets_id_seq OWNER TO postgres;

--
-- Name: mdl_h5p_libraries_cachedassets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_h5p_libraries_cachedassets_id_seq OWNED BY public.mdl_h5p_libraries_cachedassets.id;


--
-- Name: mdl_h5p_libraries_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_h5p_libraries_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_h5p_libraries_id_seq OWNER TO postgres;

--
-- Name: mdl_h5p_libraries_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_h5p_libraries_id_seq OWNED BY public.mdl_h5p_libraries.id;


--
-- Name: mdl_h5p_library_dependencies; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_h5p_library_dependencies (
    id bigint NOT NULL,
    libraryid bigint NOT NULL,
    requiredlibraryid bigint NOT NULL,
    dependencytype character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_h5p_library_dependencies OWNER TO postgres;

--
-- Name: TABLE mdl_h5p_library_dependencies; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_h5p_library_dependencies IS 'Stores H5P library dependencies';


--
-- Name: mdl_h5p_library_dependencies_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_h5p_library_dependencies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_h5p_library_dependencies_id_seq OWNER TO postgres;

--
-- Name: mdl_h5p_library_dependencies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_h5p_library_dependencies_id_seq OWNED BY public.mdl_h5p_library_dependencies.id;


--
-- Name: mdl_imscp; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_imscp (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text,
    introformat smallint DEFAULT 0 NOT NULL,
    revision bigint DEFAULT 0 NOT NULL,
    keepold bigint DEFAULT '-1'::integer NOT NULL,
    structure text,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_imscp OWNER TO postgres;

--
-- Name: TABLE mdl_imscp; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_imscp IS 'each record is one imscp resource';


--
-- Name: mdl_imscp_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_imscp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_imscp_id_seq OWNER TO postgres;

--
-- Name: mdl_imscp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_imscp_id_seq OWNED BY public.mdl_imscp.id;


--
-- Name: mdl_invoice; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_invoice (
    id bigint NOT NULL,
    reference character varying(10),
    userid bigint NOT NULL,
    status character varying(1) DEFAULT 'b'::character varying NOT NULL,
    checkout_method character varying(50),
    email character varying(100),
    phone1 character varying(20),
    pp_payerid character varying(50),
    pp_payerstatus character varying(10),
    company character varying(50),
    address character varying(70),
    city character varying(120),
    state character varying(120),
    country character varying(2),
    postcode character varying(20),
    firstname character varying(100),
    lastname character varying(100),
    pp_ack character varying(20),
    pp_transactionid character varying(100),
    pp_transactiontype character varying(20),
    pp_paymenttype character varying(20),
    pp_ordertime character varying(20),
    pp_currencycode character varying(3),
    pp_amount character varying(20),
    pp_feeamt character varying(20),
    pp_settleamt character varying(20),
    pp_taxamt character varying(20),
    pp_exchangerate character varying(20),
    pp_paymentstatus character varying(20),
    pp_pendingreason character varying(20),
    pp_reason character varying(20),
    date bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_invoice OWNER TO postgres;

--
-- Name: TABLE mdl_invoice; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_invoice IS 'invoices and baskets';


--
-- Name: mdl_invoice_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_invoice_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_invoice_id_seq OWNER TO postgres;

--
-- Name: mdl_invoice_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_invoice_id_seq OWNED BY public.mdl_invoice.id;


--
-- Name: mdl_invoiceitem; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_invoiceitem (
    id bigint NOT NULL,
    invoiceid bigint NOT NULL,
    invoiceableitemid bigint NOT NULL,
    invoiceableitemtype character varying(20) DEFAULT ''::character varying NOT NULL,
    quantity integer DEFAULT 1 NOT NULL,
    currency character varying(10) DEFAULT '£'::character varying NOT NULL,
    price numeric(10,2) DEFAULT 0 NOT NULL,
    license_allocation bigint NOT NULL,
    license_validlength bigint NOT NULL,
    license_shelflife bigint DEFAULT 0 NOT NULL,
    processed smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_invoiceitem OWNER TO postgres;

--
-- Name: TABLE mdl_invoiceitem; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_invoiceitem IS 'line items on invoice';


--
-- Name: mdl_invoiceitem_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_invoiceitem_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_invoiceitem_id_seq OWNER TO postgres;

--
-- Name: mdl_invoiceitem_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_invoiceitem_id_seq OWNED BY public.mdl_invoiceitem.id;


--
-- Name: mdl_iomad_courses; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_iomad_courses (
    id bigint NOT NULL,
    courseid bigint NOT NULL,
    licensed smallint DEFAULT 0,
    shared smallint DEFAULT 0,
    validlength bigint DEFAULT 0,
    warnexpire bigint DEFAULT 0 NOT NULL,
    warncompletion bigint DEFAULT 0 NOT NULL,
    notifyperiod bigint DEFAULT 0 NOT NULL,
    expireafter bigint DEFAULT 0 NOT NULL,
    warnnotstarted bigint DEFAULT 0 NOT NULL,
    hasgrade smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_iomad_courses OWNER TO postgres;

--
-- Name: TABLE mdl_iomad_courses; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_iomad_courses IS 'Table for holding course information for use within the iomad system.';


--
-- Name: mdl_iomad_courses_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_iomad_courses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_iomad_courses_id_seq OWNER TO postgres;

--
-- Name: mdl_iomad_courses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_iomad_courses_id_seq OWNED BY public.mdl_iomad_courses.id;


--
-- Name: mdl_iomad_frameworks; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_iomad_frameworks (
    id bigint NOT NULL,
    frameworkid bigint NOT NULL,
    shared smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_iomad_frameworks OWNER TO postgres;

--
-- Name: TABLE mdl_iomad_frameworks; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_iomad_frameworks IS 'for holding meta data for company frameworks';


--
-- Name: mdl_iomad_frameworks_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_iomad_frameworks_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_iomad_frameworks_id_seq OWNER TO postgres;

--
-- Name: mdl_iomad_frameworks_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_iomad_frameworks_id_seq OWNED BY public.mdl_iomad_frameworks.id;


--
-- Name: mdl_iomad_learningpath; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_iomad_learningpath (
    id bigint NOT NULL,
    company integer NOT NULL,
    name character varying(80) DEFAULT ''::character varying NOT NULL,
    description text NOT NULL,
    active smallint DEFAULT 0 NOT NULL,
    timecreated bigint NOT NULL,
    timeupdated bigint NOT NULL,
    licenseid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_iomad_learningpath OWNER TO postgres;

--
-- Name: TABLE mdl_iomad_learningpath; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_iomad_learningpath IS 'List of learning paths';


--
-- Name: mdl_iomad_learningpath_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_iomad_learningpath_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_iomad_learningpath_id_seq OWNER TO postgres;

--
-- Name: mdl_iomad_learningpath_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_iomad_learningpath_id_seq OWNED BY public.mdl_iomad_learningpath.id;


--
-- Name: mdl_iomad_learningpathcourse; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_iomad_learningpathcourse (
    id bigint NOT NULL,
    course bigint NOT NULL,
    path bigint NOT NULL,
    sequence bigint DEFAULT 0 NOT NULL,
    groupid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_iomad_learningpathcourse OWNER TO postgres;

--
-- Name: TABLE mdl_iomad_learningpathcourse; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_iomad_learningpathcourse IS 'Courses for each learning path';


--
-- Name: mdl_iomad_learningpathcourse_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_iomad_learningpathcourse_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_iomad_learningpathcourse_id_seq OWNER TO postgres;

--
-- Name: mdl_iomad_learningpathcourse_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_iomad_learningpathcourse_id_seq OWNED BY public.mdl_iomad_learningpathcourse.id;


--
-- Name: mdl_iomad_learningpathgroup; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_iomad_learningpathgroup (
    id bigint NOT NULL,
    learningpath bigint NOT NULL,
    name character varying(50) DEFAULT ''::character varying NOT NULL,
    sequence bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_iomad_learningpathgroup OWNER TO postgres;

--
-- Name: TABLE mdl_iomad_learningpathgroup; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_iomad_learningpathgroup IS 'Group together courses in path';


--
-- Name: mdl_iomad_learningpathgroup_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_iomad_learningpathgroup_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_iomad_learningpathgroup_id_seq OWNER TO postgres;

--
-- Name: mdl_iomad_learningpathgroup_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_iomad_learningpathgroup_id_seq OWNED BY public.mdl_iomad_learningpathgroup.id;


--
-- Name: mdl_iomad_learningpathuser; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_iomad_learningpathuser (
    id bigint NOT NULL,
    pathid bigint NOT NULL,
    userid bigint NOT NULL
);


ALTER TABLE public.mdl_iomad_learningpathuser OWNER TO postgres;

--
-- Name: TABLE mdl_iomad_learningpathuser; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_iomad_learningpathuser IS 'User''s assigned to learning path';


--
-- Name: mdl_iomad_learningpathuser_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_iomad_learningpathuser_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_iomad_learningpathuser_id_seq OWNER TO postgres;

--
-- Name: mdl_iomad_learningpathuser_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_iomad_learningpathuser_id_seq OWNED BY public.mdl_iomad_learningpathuser.id;


--
-- Name: mdl_iomad_templates; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_iomad_templates (
    id bigint NOT NULL,
    templateid bigint NOT NULL,
    shared smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_iomad_templates OWNER TO postgres;

--
-- Name: TABLE mdl_iomad_templates; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_iomad_templates IS 'for holding metadata on company templates';


--
-- Name: mdl_iomad_templates_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_iomad_templates_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_iomad_templates_id_seq OWNER TO postgres;

--
-- Name: mdl_iomad_templates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_iomad_templates_id_seq OWNED BY public.mdl_iomad_templates.id;


--
-- Name: mdl_iomadcertificate; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_iomadcertificate (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text,
    introformat smallint DEFAULT 0 NOT NULL,
    emailteachers smallint DEFAULT 0 NOT NULL,
    emailothers text,
    savecert smallint DEFAULT 0 NOT NULL,
    reportcert smallint DEFAULT 0 NOT NULL,
    delivery smallint DEFAULT 0 NOT NULL,
    requiredtime bigint DEFAULT 0 NOT NULL,
    iomadcertificatetype character varying(50) DEFAULT ''::character varying NOT NULL,
    orientation character varying(10) DEFAULT ''::character varying NOT NULL,
    borderstyle character varying(255) DEFAULT '0'::character varying NOT NULL,
    bordercolor character varying(30) DEFAULT '0'::character varying NOT NULL,
    printwmark character varying(255) DEFAULT '0'::character varying NOT NULL,
    printdate bigint DEFAULT 0 NOT NULL,
    datefmt bigint DEFAULT 0 NOT NULL,
    printnumber smallint DEFAULT 0 NOT NULL,
    printgrade bigint DEFAULT 0 NOT NULL,
    gradefmt bigint DEFAULT 0 NOT NULL,
    printoutcome bigint DEFAULT 0 NOT NULL,
    printhours character varying(255),
    printteacher bigint DEFAULT 0 NOT NULL,
    customtext text,
    printsignature character varying(255) DEFAULT '0'::character varying NOT NULL,
    printseal character varying(255) DEFAULT '0'::character varying NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_iomadcertificate OWNER TO postgres;

--
-- Name: TABLE mdl_iomadcertificate; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_iomadcertificate IS 'Defines iomadcertificates';


--
-- Name: mdl_iomadcertificate_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_iomadcertificate_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_iomadcertificate_id_seq OWNER TO postgres;

--
-- Name: mdl_iomadcertificate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_iomadcertificate_id_seq OWNED BY public.mdl_iomadcertificate.id;


--
-- Name: mdl_iomadcertificate_issues; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_iomadcertificate_issues (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    iomadcertificateid bigint DEFAULT 0 NOT NULL,
    code character varying(40),
    timecreated bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_iomadcertificate_issues OWNER TO postgres;

--
-- Name: TABLE mdl_iomadcertificate_issues; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_iomadcertificate_issues IS 'Info about issued certificates';


--
-- Name: mdl_iomadcertificate_issues_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_iomadcertificate_issues_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_iomadcertificate_issues_id_seq OWNER TO postgres;

--
-- Name: mdl_iomadcertificate_issues_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_iomadcertificate_issues_id_seq OWNED BY public.mdl_iomadcertificate_issues.id;


--
-- Name: mdl_label; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_label (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text NOT NULL,
    introformat smallint DEFAULT 0,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_label OWNER TO postgres;

--
-- Name: TABLE mdl_label; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_label IS 'Defines labels';


--
-- Name: mdl_label_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_label_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_label_id_seq OWNER TO postgres;

--
-- Name: mdl_label_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_label_id_seq OWNED BY public.mdl_label.id;


--
-- Name: mdl_lesson; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lesson (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text,
    introformat smallint DEFAULT 0 NOT NULL,
    practice smallint DEFAULT 0 NOT NULL,
    modattempts smallint DEFAULT 0 NOT NULL,
    usepassword smallint DEFAULT 0 NOT NULL,
    password character varying(32) DEFAULT ''::character varying NOT NULL,
    dependency bigint DEFAULT 0 NOT NULL,
    conditions text NOT NULL,
    grade bigint DEFAULT 0 NOT NULL,
    custom smallint DEFAULT 0 NOT NULL,
    ongoing smallint DEFAULT 0 NOT NULL,
    usemaxgrade smallint DEFAULT 0 NOT NULL,
    maxanswers smallint DEFAULT 4 NOT NULL,
    maxattempts smallint DEFAULT 5 NOT NULL,
    review smallint DEFAULT 0 NOT NULL,
    nextpagedefault smallint DEFAULT 0 NOT NULL,
    feedback smallint DEFAULT 1 NOT NULL,
    minquestions smallint DEFAULT 0 NOT NULL,
    maxpages smallint DEFAULT 0 NOT NULL,
    timelimit bigint DEFAULT 0 NOT NULL,
    retake smallint DEFAULT 1 NOT NULL,
    activitylink bigint DEFAULT 0 NOT NULL,
    mediafile character varying(255) DEFAULT ''::character varying NOT NULL,
    mediaheight bigint DEFAULT 100 NOT NULL,
    mediawidth bigint DEFAULT 650 NOT NULL,
    mediaclose smallint DEFAULT 0 NOT NULL,
    slideshow smallint DEFAULT 0 NOT NULL,
    width bigint DEFAULT 640 NOT NULL,
    height bigint DEFAULT 480 NOT NULL,
    bgcolor character varying(7) DEFAULT '#FFFFFF'::character varying NOT NULL,
    displayleft smallint DEFAULT 0 NOT NULL,
    displayleftif smallint DEFAULT 0 NOT NULL,
    progressbar smallint DEFAULT 0 NOT NULL,
    available bigint DEFAULT 0 NOT NULL,
    deadline bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    completionendreached smallint DEFAULT 0,
    completiontimespent bigint DEFAULT 0,
    allowofflineattempts smallint DEFAULT 0
);


ALTER TABLE public.mdl_lesson OWNER TO postgres;

--
-- Name: TABLE mdl_lesson; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lesson IS 'Defines lesson';


--
-- Name: mdl_lesson_answers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lesson_answers (
    id bigint NOT NULL,
    lessonid bigint DEFAULT 0 NOT NULL,
    pageid bigint DEFAULT 0 NOT NULL,
    jumpto bigint DEFAULT 0 NOT NULL,
    grade smallint DEFAULT 0 NOT NULL,
    score bigint DEFAULT 0 NOT NULL,
    flags smallint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    answer text,
    answerformat smallint DEFAULT 0 NOT NULL,
    response text,
    responseformat smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_lesson_answers OWNER TO postgres;

--
-- Name: TABLE mdl_lesson_answers; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lesson_answers IS 'Defines lesson_answers';


--
-- Name: mdl_lesson_answers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_answers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_answers_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_answers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lesson_answers_id_seq OWNED BY public.mdl_lesson_answers.id;


--
-- Name: mdl_lesson_attempts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lesson_attempts (
    id bigint NOT NULL,
    lessonid bigint DEFAULT 0 NOT NULL,
    pageid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    answerid bigint DEFAULT 0 NOT NULL,
    retry smallint DEFAULT 0 NOT NULL,
    correct bigint DEFAULT 0 NOT NULL,
    useranswer text,
    timeseen bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_lesson_attempts OWNER TO postgres;

--
-- Name: TABLE mdl_lesson_attempts; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lesson_attempts IS 'Defines lesson_attempts';


--
-- Name: mdl_lesson_attempts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_attempts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_attempts_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_attempts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lesson_attempts_id_seq OWNED BY public.mdl_lesson_attempts.id;


--
-- Name: mdl_lesson_branch; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lesson_branch (
    id bigint NOT NULL,
    lessonid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    pageid bigint DEFAULT 0 NOT NULL,
    retry bigint DEFAULT 0 NOT NULL,
    flag smallint DEFAULT 0 NOT NULL,
    timeseen bigint DEFAULT 0 NOT NULL,
    nextpageid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_lesson_branch OWNER TO postgres;

--
-- Name: TABLE mdl_lesson_branch; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lesson_branch IS 'branches for each lesson/user';


--
-- Name: mdl_lesson_branch_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_branch_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_branch_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_branch_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lesson_branch_id_seq OWNED BY public.mdl_lesson_branch.id;


--
-- Name: mdl_lesson_grades; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lesson_grades (
    id bigint NOT NULL,
    lessonid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    grade double precision DEFAULT 0 NOT NULL,
    late smallint DEFAULT 0 NOT NULL,
    completed bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_lesson_grades OWNER TO postgres;

--
-- Name: TABLE mdl_lesson_grades; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lesson_grades IS 'Defines lesson_grades';


--
-- Name: mdl_lesson_grades_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_grades_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_grades_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_grades_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lesson_grades_id_seq OWNED BY public.mdl_lesson_grades.id;


--
-- Name: mdl_lesson_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lesson_id_seq OWNED BY public.mdl_lesson.id;


--
-- Name: mdl_lesson_overrides; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lesson_overrides (
    id bigint NOT NULL,
    lessonid bigint DEFAULT 0 NOT NULL,
    groupid bigint,
    userid bigint,
    available bigint,
    deadline bigint,
    timelimit bigint,
    review smallint,
    maxattempts smallint,
    retake smallint,
    password character varying(32)
);


ALTER TABLE public.mdl_lesson_overrides OWNER TO postgres;

--
-- Name: TABLE mdl_lesson_overrides; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lesson_overrides IS 'The overrides to lesson settings.';


--
-- Name: mdl_lesson_overrides_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_overrides_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_overrides_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_overrides_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lesson_overrides_id_seq OWNED BY public.mdl_lesson_overrides.id;


--
-- Name: mdl_lesson_pages; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lesson_pages (
    id bigint NOT NULL,
    lessonid bigint DEFAULT 0 NOT NULL,
    prevpageid bigint DEFAULT 0 NOT NULL,
    nextpageid bigint DEFAULT 0 NOT NULL,
    qtype smallint DEFAULT 0 NOT NULL,
    qoption smallint DEFAULT 0 NOT NULL,
    layout smallint DEFAULT 1 NOT NULL,
    display smallint DEFAULT 1 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    title character varying(255) DEFAULT ''::character varying NOT NULL,
    contents text NOT NULL,
    contentsformat smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_lesson_pages OWNER TO postgres;

--
-- Name: TABLE mdl_lesson_pages; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lesson_pages IS 'Defines lesson_pages';


--
-- Name: mdl_lesson_pages_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_pages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_pages_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_pages_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lesson_pages_id_seq OWNED BY public.mdl_lesson_pages.id;


--
-- Name: mdl_lesson_timer; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lesson_timer (
    id bigint NOT NULL,
    lessonid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    starttime bigint DEFAULT 0 NOT NULL,
    lessontime bigint DEFAULT 0 NOT NULL,
    completed smallint DEFAULT 0,
    timemodifiedoffline bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_lesson_timer OWNER TO postgres;

--
-- Name: TABLE mdl_lesson_timer; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lesson_timer IS 'lesson timer for each lesson';


--
-- Name: mdl_lesson_timer_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_timer_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_timer_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_timer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lesson_timer_id_seq OWNED BY public.mdl_lesson_timer.id;


--
-- Name: mdl_license; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_license (
    id bigint NOT NULL,
    shortname character varying(255),
    fullname text,
    source character varying(255),
    enabled smallint DEFAULT 1 NOT NULL,
    version bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_license OWNER TO postgres;

--
-- Name: TABLE mdl_license; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_license IS 'store licenses used by moodle';


--
-- Name: mdl_license_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_license_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_license_id_seq OWNER TO postgres;

--
-- Name: mdl_license_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_license_id_seq OWNED BY public.mdl_license.id;


--
-- Name: mdl_local_iomad_track; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_local_iomad_track (
    id bigint NOT NULL,
    courseid bigint NOT NULL,
    coursename character varying(254),
    userid bigint NOT NULL,
    timecompleted bigint,
    timeenrolled bigint,
    timestarted bigint,
    timeexpires bigint,
    finalscore numeric(10,5) DEFAULT 0 NOT NULL,
    companyid bigint NOT NULL,
    licenseid bigint DEFAULT 0,
    licensename character varying(255),
    licenseallocated bigint,
    expirysent bigint,
    notstartedstop smallint DEFAULT 0 NOT NULL,
    completedstop smallint DEFAULT 0 NOT NULL,
    expiredstop smallint DEFAULT 0 NOT NULL,
    modifiedtime bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_local_iomad_track OWNER TO postgres;

--
-- Name: TABLE mdl_local_iomad_track; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_local_iomad_track IS 'Default comment for local_iomad_track, please edit me';


--
-- Name: mdl_local_iomad_track_certs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_local_iomad_track_certs (
    id bigint NOT NULL,
    trackid bigint NOT NULL,
    filename text NOT NULL
);


ALTER TABLE public.mdl_local_iomad_track_certs OWNER TO postgres;

--
-- Name: TABLE mdl_local_iomad_track_certs; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_local_iomad_track_certs IS 'Record certificates issued';


--
-- Name: mdl_local_iomad_track_certs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_local_iomad_track_certs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_local_iomad_track_certs_id_seq OWNER TO postgres;

--
-- Name: mdl_local_iomad_track_certs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_local_iomad_track_certs_id_seq OWNED BY public.mdl_local_iomad_track_certs.id;


--
-- Name: mdl_local_iomad_track_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_local_iomad_track_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_local_iomad_track_id_seq OWNER TO postgres;

--
-- Name: mdl_local_iomad_track_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_local_iomad_track_id_seq OWNED BY public.mdl_local_iomad_track.id;


--
-- Name: mdl_local_report_user_lic_allocs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_local_report_user_lic_allocs (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    licenseid bigint NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    action smallint NOT NULL,
    issuedate bigint,
    modifiedtime bigint
);


ALTER TABLE public.mdl_local_report_user_lic_allocs OWNER TO postgres;

--
-- Name: TABLE mdl_local_report_user_lic_allocs; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_local_report_user_lic_allocs IS 'Default comment for local_report_user_lic_allocs, please edit me';


--
-- Name: mdl_local_report_user_lic_allocs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_local_report_user_lic_allocs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_local_report_user_lic_allocs_id_seq OWNER TO postgres;

--
-- Name: mdl_local_report_user_lic_allocs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_local_report_user_lic_allocs_id_seq OWNED BY public.mdl_local_report_user_lic_allocs.id;


--
-- Name: mdl_local_report_user_logins; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_local_report_user_logins (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    created bigint NOT NULL,
    firstlogin bigint,
    lastlogin bigint,
    logincount bigint DEFAULT 0 NOT NULL,
    modifiedtime bigint NOT NULL
);


ALTER TABLE public.mdl_local_report_user_logins OWNER TO postgres;

--
-- Name: TABLE mdl_local_report_user_logins; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_local_report_user_logins IS 'Default comment for local_report_user_logins, please edit me';


--
-- Name: mdl_local_report_user_logins_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_local_report_user_logins_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_local_report_user_logins_id_seq OWNER TO postgres;

--
-- Name: mdl_local_report_user_logins_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_local_report_user_logins_id_seq OWNED BY public.mdl_local_report_user_logins.id;


--
-- Name: mdl_lock_db; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lock_db (
    id bigint NOT NULL,
    resourcekey character varying(255) DEFAULT ''::character varying NOT NULL,
    expires bigint,
    owner character varying(36)
);


ALTER TABLE public.mdl_lock_db OWNER TO postgres;

--
-- Name: TABLE mdl_lock_db; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lock_db IS 'Stores active and inactive lock types for db locking method.';


--
-- Name: mdl_lock_db_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lock_db_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lock_db_id_seq OWNER TO postgres;

--
-- Name: mdl_lock_db_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lock_db_id_seq OWNED BY public.mdl_lock_db.id;


--
-- Name: mdl_log; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_log (
    id bigint NOT NULL,
    "time" bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    ip character varying(45) DEFAULT ''::character varying NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    module character varying(20) DEFAULT ''::character varying NOT NULL,
    cmid bigint DEFAULT 0 NOT NULL,
    action character varying(40) DEFAULT ''::character varying NOT NULL,
    url character varying(100) DEFAULT ''::character varying NOT NULL,
    info character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_log OWNER TO postgres;

--
-- Name: TABLE mdl_log; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_log IS 'Every action is logged as far as possible';


--
-- Name: mdl_log_display; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_log_display (
    id bigint NOT NULL,
    module character varying(20) DEFAULT ''::character varying NOT NULL,
    action character varying(40) DEFAULT ''::character varying NOT NULL,
    mtable character varying(30) DEFAULT ''::character varying NOT NULL,
    field character varying(200) DEFAULT ''::character varying NOT NULL,
    component character varying(100) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_log_display OWNER TO postgres;

--
-- Name: TABLE mdl_log_display; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_log_display IS 'For a particular module/action, specifies a moodle table/field';


--
-- Name: mdl_log_display_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_log_display_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_log_display_id_seq OWNER TO postgres;

--
-- Name: mdl_log_display_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_log_display_id_seq OWNED BY public.mdl_log_display.id;


--
-- Name: mdl_log_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_log_id_seq OWNER TO postgres;

--
-- Name: mdl_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_log_id_seq OWNED BY public.mdl_log.id;


--
-- Name: mdl_log_queries; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_log_queries (
    id bigint NOT NULL,
    qtype integer NOT NULL,
    sqltext text NOT NULL,
    sqlparams text,
    error integer DEFAULT 0 NOT NULL,
    info text,
    backtrace text,
    exectime numeric(10,5) NOT NULL,
    timelogged bigint NOT NULL
);


ALTER TABLE public.mdl_log_queries OWNER TO postgres;

--
-- Name: TABLE mdl_log_queries; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_log_queries IS 'Logged database queries.';


--
-- Name: mdl_log_queries_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_log_queries_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_log_queries_id_seq OWNER TO postgres;

--
-- Name: mdl_log_queries_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_log_queries_id_seq OWNED BY public.mdl_log_queries.id;


--
-- Name: mdl_logstore_standard_log; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_logstore_standard_log (
    id bigint NOT NULL,
    eventname character varying(255) DEFAULT ''::character varying NOT NULL,
    component character varying(100) DEFAULT ''::character varying NOT NULL,
    action character varying(100) DEFAULT ''::character varying NOT NULL,
    target character varying(100) DEFAULT ''::character varying NOT NULL,
    objecttable character varying(50),
    objectid bigint,
    crud character varying(1) DEFAULT ''::character varying NOT NULL,
    edulevel smallint NOT NULL,
    contextid bigint NOT NULL,
    contextlevel bigint NOT NULL,
    contextinstanceid bigint NOT NULL,
    userid bigint NOT NULL,
    courseid bigint,
    relateduserid bigint,
    anonymous smallint DEFAULT 0 NOT NULL,
    other text,
    timecreated bigint NOT NULL,
    origin character varying(10),
    ip character varying(45),
    realuserid bigint
);


ALTER TABLE public.mdl_logstore_standard_log OWNER TO postgres;

--
-- Name: TABLE mdl_logstore_standard_log; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_logstore_standard_log IS 'Standard log table';


--
-- Name: mdl_logstore_standard_log_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_logstore_standard_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_logstore_standard_log_id_seq OWNER TO postgres;

--
-- Name: mdl_logstore_standard_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_logstore_standard_log_id_seq OWNED BY public.mdl_logstore_standard_log.id;


--
-- Name: mdl_lti; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lti (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text,
    introformat smallint DEFAULT 0,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    typeid bigint,
    toolurl text NOT NULL,
    securetoolurl text,
    instructorchoicesendname smallint,
    instructorchoicesendemailaddr smallint,
    instructorchoiceallowroster smallint,
    instructorchoiceallowsetting smallint,
    instructorcustomparameters character varying(255),
    instructorchoiceacceptgrades smallint,
    grade bigint DEFAULT 100 NOT NULL,
    launchcontainer smallint DEFAULT 1 NOT NULL,
    resourcekey character varying(255),
    password character varying(255),
    debuglaunch smallint DEFAULT 0 NOT NULL,
    showtitlelaunch smallint DEFAULT 0 NOT NULL,
    showdescriptionlaunch smallint DEFAULT 0 NOT NULL,
    servicesalt character varying(40),
    icon text,
    secureicon text
);


ALTER TABLE public.mdl_lti OWNER TO postgres;

--
-- Name: TABLE mdl_lti; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lti IS 'This table contains Basic LTI activities instances';


--
-- Name: mdl_lti_access_tokens; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lti_access_tokens (
    id bigint NOT NULL,
    typeid bigint NOT NULL,
    scope text NOT NULL,
    token character varying(128) DEFAULT ''::character varying NOT NULL,
    validuntil bigint NOT NULL,
    timecreated bigint NOT NULL,
    lastaccess bigint
);


ALTER TABLE public.mdl_lti_access_tokens OWNER TO postgres;

--
-- Name: TABLE mdl_lti_access_tokens; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lti_access_tokens IS 'Security tokens for accessing of LTI services';


--
-- Name: mdl_lti_access_tokens_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lti_access_tokens_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lti_access_tokens_id_seq OWNER TO postgres;

--
-- Name: mdl_lti_access_tokens_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lti_access_tokens_id_seq OWNED BY public.mdl_lti_access_tokens.id;


--
-- Name: mdl_lti_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lti_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lti_id_seq OWNER TO postgres;

--
-- Name: mdl_lti_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lti_id_seq OWNED BY public.mdl_lti.id;


--
-- Name: mdl_lti_submission; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lti_submission (
    id bigint NOT NULL,
    ltiid bigint NOT NULL,
    userid bigint NOT NULL,
    datesubmitted bigint NOT NULL,
    dateupdated bigint NOT NULL,
    gradepercent numeric(10,5) NOT NULL,
    originalgrade numeric(10,5) NOT NULL,
    launchid bigint NOT NULL,
    state smallint NOT NULL
);


ALTER TABLE public.mdl_lti_submission OWNER TO postgres;

--
-- Name: TABLE mdl_lti_submission; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lti_submission IS 'Keeps track of individual submissions for LTI activities.';


--
-- Name: mdl_lti_submission_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lti_submission_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lti_submission_id_seq OWNER TO postgres;

--
-- Name: mdl_lti_submission_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lti_submission_id_seq OWNED BY public.mdl_lti_submission.id;


--
-- Name: mdl_lti_tool_proxies; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lti_tool_proxies (
    id bigint NOT NULL,
    name character varying(255) DEFAULT 'Tool Provider'::character varying NOT NULL,
    regurl text,
    state smallint DEFAULT 1 NOT NULL,
    guid character varying(255),
    secret character varying(255),
    vendorcode character varying(255),
    capabilityoffered text NOT NULL,
    serviceoffered text NOT NULL,
    toolproxy text,
    createdby bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_lti_tool_proxies OWNER TO postgres;

--
-- Name: TABLE mdl_lti_tool_proxies; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lti_tool_proxies IS 'LTI tool proxy registrations';


--
-- Name: mdl_lti_tool_proxies_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lti_tool_proxies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lti_tool_proxies_id_seq OWNER TO postgres;

--
-- Name: mdl_lti_tool_proxies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lti_tool_proxies_id_seq OWNED BY public.mdl_lti_tool_proxies.id;


--
-- Name: mdl_lti_tool_settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lti_tool_settings (
    id bigint NOT NULL,
    toolproxyid bigint NOT NULL,
    typeid bigint,
    course bigint,
    coursemoduleid bigint,
    settings text NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_lti_tool_settings OWNER TO postgres;

--
-- Name: TABLE mdl_lti_tool_settings; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lti_tool_settings IS 'LTI tool setting values';


--
-- Name: mdl_lti_tool_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lti_tool_settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lti_tool_settings_id_seq OWNER TO postgres;

--
-- Name: mdl_lti_tool_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lti_tool_settings_id_seq OWNED BY public.mdl_lti_tool_settings.id;


--
-- Name: mdl_lti_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lti_types (
    id bigint NOT NULL,
    name character varying(255) DEFAULT 'basiclti Activity'::character varying NOT NULL,
    baseurl text NOT NULL,
    tooldomain character varying(255) DEFAULT ''::character varying NOT NULL,
    state smallint DEFAULT 2 NOT NULL,
    course bigint NOT NULL,
    coursevisible smallint DEFAULT 0 NOT NULL,
    ltiversion character varying(10) DEFAULT ''::character varying NOT NULL,
    clientid character varying(255),
    toolproxyid bigint,
    enabledcapability text,
    parameter text,
    icon text,
    secureicon text,
    createdby bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    description text
);


ALTER TABLE public.mdl_lti_types OWNER TO postgres;

--
-- Name: TABLE mdl_lti_types; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lti_types IS 'Basic LTI pre-configured activities';


--
-- Name: mdl_lti_types_config; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lti_types_config (
    id bigint NOT NULL,
    typeid bigint NOT NULL,
    name character varying(100) DEFAULT ''::character varying NOT NULL,
    value text NOT NULL
);


ALTER TABLE public.mdl_lti_types_config OWNER TO postgres;

--
-- Name: TABLE mdl_lti_types_config; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lti_types_config IS 'Basic LTI types configuration';


--
-- Name: mdl_lti_types_config_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lti_types_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lti_types_config_id_seq OWNER TO postgres;

--
-- Name: mdl_lti_types_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lti_types_config_id_seq OWNED BY public.mdl_lti_types_config.id;


--
-- Name: mdl_lti_types_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lti_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lti_types_id_seq OWNER TO postgres;

--
-- Name: mdl_lti_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lti_types_id_seq OWNED BY public.mdl_lti_types.id;


--
-- Name: mdl_ltiservice_gradebookservices; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_ltiservice_gradebookservices (
    id bigint NOT NULL,
    gradeitemid bigint NOT NULL,
    courseid bigint NOT NULL,
    toolproxyid bigint,
    typeid bigint,
    baseurl text,
    ltilinkid bigint,
    tag character varying(255)
);


ALTER TABLE public.mdl_ltiservice_gradebookservices OWNER TO postgres;

--
-- Name: TABLE mdl_ltiservice_gradebookservices; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_ltiservice_gradebookservices IS 'This file records the grade items created by the LTI Gradebook Services service';


--
-- Name: mdl_ltiservice_gradebookservices_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_ltiservice_gradebookservices_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_ltiservice_gradebookservices_id_seq OWNER TO postgres;

--
-- Name: mdl_ltiservice_gradebookservices_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_ltiservice_gradebookservices_id_seq OWNED BY public.mdl_ltiservice_gradebookservices.id;


--
-- Name: mdl_message; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message (
    id bigint NOT NULL,
    useridfrom bigint DEFAULT 0 NOT NULL,
    useridto bigint DEFAULT 0 NOT NULL,
    subject text,
    fullmessage text,
    fullmessageformat smallint DEFAULT 0,
    fullmessagehtml text,
    smallmessage text,
    notification smallint DEFAULT 0,
    contexturl text,
    contexturlname text,
    timecreated bigint DEFAULT 0 NOT NULL,
    timeuserfromdeleted bigint DEFAULT 0 NOT NULL,
    timeusertodeleted bigint DEFAULT 0 NOT NULL,
    component character varying(100),
    eventtype character varying(100),
    customdata text
);


ALTER TABLE public.mdl_message OWNER TO postgres;

--
-- Name: TABLE mdl_message; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message IS 'Stores all unread messages';


--
-- Name: mdl_message_airnotifier_devices; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message_airnotifier_devices (
    id bigint NOT NULL,
    userdeviceid bigint NOT NULL,
    enable smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_message_airnotifier_devices OWNER TO postgres;

--
-- Name: TABLE mdl_message_airnotifier_devices; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message_airnotifier_devices IS 'Store information about the devices registered in Airnotifier for PUSH notifications';


--
-- Name: mdl_message_airnotifier_devices_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_airnotifier_devices_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_airnotifier_devices_id_seq OWNER TO postgres;

--
-- Name: mdl_message_airnotifier_devices_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_airnotifier_devices_id_seq OWNED BY public.mdl_message_airnotifier_devices.id;


--
-- Name: mdl_message_contact_requests; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message_contact_requests (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    requesteduserid bigint NOT NULL,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_message_contact_requests OWNER TO postgres;

--
-- Name: TABLE mdl_message_contact_requests; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message_contact_requests IS 'Maintains list of contact requests between users';


--
-- Name: mdl_message_contact_requests_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_contact_requests_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_contact_requests_id_seq OWNER TO postgres;

--
-- Name: mdl_message_contact_requests_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_contact_requests_id_seq OWNED BY public.mdl_message_contact_requests.id;


--
-- Name: mdl_message_contacts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message_contacts (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    contactid bigint NOT NULL,
    timecreated bigint
);


ALTER TABLE public.mdl_message_contacts OWNER TO postgres;

--
-- Name: TABLE mdl_message_contacts; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message_contacts IS 'Maintains lists of contacts between users';


--
-- Name: mdl_message_contacts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_contacts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_contacts_id_seq OWNER TO postgres;

--
-- Name: mdl_message_contacts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_contacts_id_seq OWNED BY public.mdl_message_contacts.id;


--
-- Name: mdl_message_conversation_actions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message_conversation_actions (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    conversationid bigint NOT NULL,
    action bigint NOT NULL,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_message_conversation_actions OWNER TO postgres;

--
-- Name: TABLE mdl_message_conversation_actions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message_conversation_actions IS 'Stores all per-user actions on individual conversations';


--
-- Name: mdl_message_conversation_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_conversation_actions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_conversation_actions_id_seq OWNER TO postgres;

--
-- Name: mdl_message_conversation_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_conversation_actions_id_seq OWNED BY public.mdl_message_conversation_actions.id;


--
-- Name: mdl_message_conversation_members; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message_conversation_members (
    id bigint NOT NULL,
    conversationid bigint NOT NULL,
    userid bigint NOT NULL,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_message_conversation_members OWNER TO postgres;

--
-- Name: TABLE mdl_message_conversation_members; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message_conversation_members IS 'Stores all members in a conversations';


--
-- Name: mdl_message_conversation_members_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_conversation_members_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_conversation_members_id_seq OWNER TO postgres;

--
-- Name: mdl_message_conversation_members_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_conversation_members_id_seq OWNED BY public.mdl_message_conversation_members.id;


--
-- Name: mdl_message_conversations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message_conversations (
    id bigint NOT NULL,
    type bigint DEFAULT 1 NOT NULL,
    name character varying(255),
    convhash character varying(40),
    component character varying(100),
    itemtype character varying(100),
    itemid bigint,
    contextid bigint,
    enabled smallint DEFAULT 0 NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint
);


ALTER TABLE public.mdl_message_conversations OWNER TO postgres;

--
-- Name: TABLE mdl_message_conversations; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message_conversations IS 'Stores all message conversations';


--
-- Name: mdl_message_conversations_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_conversations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_conversations_id_seq OWNER TO postgres;

--
-- Name: mdl_message_conversations_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_conversations_id_seq OWNED BY public.mdl_message_conversations.id;


--
-- Name: mdl_message_email_messages; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message_email_messages (
    id bigint NOT NULL,
    useridto bigint NOT NULL,
    conversationid bigint NOT NULL,
    messageid bigint NOT NULL
);


ALTER TABLE public.mdl_message_email_messages OWNER TO postgres;

--
-- Name: TABLE mdl_message_email_messages; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message_email_messages IS 'Keeps track of what emails to send in an email digest';


--
-- Name: mdl_message_email_messages_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_email_messages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_email_messages_id_seq OWNER TO postgres;

--
-- Name: mdl_message_email_messages_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_email_messages_id_seq OWNED BY public.mdl_message_email_messages.id;


--
-- Name: mdl_message_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_id_seq OWNER TO postgres;

--
-- Name: mdl_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_id_seq OWNED BY public.mdl_message.id;


--
-- Name: mdl_message_popup; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message_popup (
    id bigint NOT NULL,
    messageid bigint NOT NULL,
    isread smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_message_popup OWNER TO postgres;

--
-- Name: TABLE mdl_message_popup; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message_popup IS 'Keep state of notifications for the popup message processor';


--
-- Name: mdl_message_popup_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_popup_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_popup_id_seq OWNER TO postgres;

--
-- Name: mdl_message_popup_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_popup_id_seq OWNED BY public.mdl_message_popup.id;


--
-- Name: mdl_message_popup_notifications; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message_popup_notifications (
    id bigint NOT NULL,
    notificationid bigint NOT NULL
);


ALTER TABLE public.mdl_message_popup_notifications OWNER TO postgres;

--
-- Name: TABLE mdl_message_popup_notifications; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message_popup_notifications IS 'List of notifications to display in the message output popup';


--
-- Name: mdl_message_popup_notifications_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_popup_notifications_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_popup_notifications_id_seq OWNER TO postgres;

--
-- Name: mdl_message_popup_notifications_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_popup_notifications_id_seq OWNED BY public.mdl_message_popup_notifications.id;


--
-- Name: mdl_message_processors; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message_processors (
    id bigint NOT NULL,
    name character varying(166) DEFAULT ''::character varying NOT NULL,
    enabled smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_message_processors OWNER TO postgres;

--
-- Name: TABLE mdl_message_processors; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message_processors IS 'List of message output plugins';


--
-- Name: mdl_message_processors_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_processors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_processors_id_seq OWNER TO postgres;

--
-- Name: mdl_message_processors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_processors_id_seq OWNED BY public.mdl_message_processors.id;


--
-- Name: mdl_message_providers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message_providers (
    id bigint NOT NULL,
    name character varying(100) DEFAULT ''::character varying NOT NULL,
    component character varying(200) DEFAULT ''::character varying NOT NULL,
    capability character varying(255)
);


ALTER TABLE public.mdl_message_providers OWNER TO postgres;

--
-- Name: TABLE mdl_message_providers; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message_providers IS 'This table stores the message providers (modules and core systems)';


--
-- Name: mdl_message_providers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_providers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_providers_id_seq OWNER TO postgres;

--
-- Name: mdl_message_providers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_providers_id_seq OWNED BY public.mdl_message_providers.id;


--
-- Name: mdl_message_read; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message_read (
    id bigint NOT NULL,
    useridfrom bigint DEFAULT 0 NOT NULL,
    useridto bigint DEFAULT 0 NOT NULL,
    subject text,
    fullmessage text,
    fullmessageformat smallint DEFAULT 0,
    fullmessagehtml text,
    smallmessage text,
    notification smallint DEFAULT 0,
    contexturl text,
    contexturlname text,
    timecreated bigint DEFAULT 0 NOT NULL,
    timeread bigint DEFAULT 0 NOT NULL,
    timeuserfromdeleted bigint DEFAULT 0 NOT NULL,
    timeusertodeleted bigint DEFAULT 0 NOT NULL,
    component character varying(100),
    eventtype character varying(100)
);


ALTER TABLE public.mdl_message_read OWNER TO postgres;

--
-- Name: TABLE mdl_message_read; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message_read IS 'Stores all messages that have been read';


--
-- Name: mdl_message_read_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_read_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_read_id_seq OWNER TO postgres;

--
-- Name: mdl_message_read_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_read_id_seq OWNED BY public.mdl_message_read.id;


--
-- Name: mdl_message_user_actions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message_user_actions (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    messageid bigint NOT NULL,
    action bigint NOT NULL,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_message_user_actions OWNER TO postgres;

--
-- Name: TABLE mdl_message_user_actions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message_user_actions IS 'Stores all per-user actions on individual messages';


--
-- Name: mdl_message_user_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_user_actions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_user_actions_id_seq OWNER TO postgres;

--
-- Name: mdl_message_user_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_user_actions_id_seq OWNED BY public.mdl_message_user_actions.id;


--
-- Name: mdl_message_users_blocked; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message_users_blocked (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    blockeduserid bigint NOT NULL,
    timecreated bigint
);


ALTER TABLE public.mdl_message_users_blocked OWNER TO postgres;

--
-- Name: TABLE mdl_message_users_blocked; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message_users_blocked IS 'Maintains lists of blocked users';


--
-- Name: mdl_message_users_blocked_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_users_blocked_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_users_blocked_id_seq OWNER TO postgres;

--
-- Name: mdl_message_users_blocked_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_users_blocked_id_seq OWNED BY public.mdl_message_users_blocked.id;


--
-- Name: mdl_messageinbound_datakeys; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_messageinbound_datakeys (
    id bigint NOT NULL,
    handler bigint NOT NULL,
    datavalue bigint NOT NULL,
    datakey character varying(64),
    timecreated bigint NOT NULL,
    expires bigint
);


ALTER TABLE public.mdl_messageinbound_datakeys OWNER TO postgres;

--
-- Name: TABLE mdl_messageinbound_datakeys; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_messageinbound_datakeys IS 'Inbound Message data item secret keys.';


--
-- Name: mdl_messageinbound_datakeys_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_messageinbound_datakeys_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_messageinbound_datakeys_id_seq OWNER TO postgres;

--
-- Name: mdl_messageinbound_datakeys_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_messageinbound_datakeys_id_seq OWNED BY public.mdl_messageinbound_datakeys.id;


--
-- Name: mdl_messageinbound_handlers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_messageinbound_handlers (
    id bigint NOT NULL,
    component character varying(100) DEFAULT ''::character varying NOT NULL,
    classname character varying(255) DEFAULT ''::character varying NOT NULL,
    defaultexpiration bigint DEFAULT 86400 NOT NULL,
    validateaddress smallint DEFAULT 1 NOT NULL,
    enabled smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_messageinbound_handlers OWNER TO postgres;

--
-- Name: TABLE mdl_messageinbound_handlers; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_messageinbound_handlers IS 'Inbound Message Handler definitions.';


--
-- Name: mdl_messageinbound_handlers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_messageinbound_handlers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_messageinbound_handlers_id_seq OWNER TO postgres;

--
-- Name: mdl_messageinbound_handlers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_messageinbound_handlers_id_seq OWNED BY public.mdl_messageinbound_handlers.id;


--
-- Name: mdl_messageinbound_messagelist; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_messageinbound_messagelist (
    id bigint NOT NULL,
    messageid text NOT NULL,
    userid bigint NOT NULL,
    address text NOT NULL,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_messageinbound_messagelist OWNER TO postgres;

--
-- Name: TABLE mdl_messageinbound_messagelist; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_messageinbound_messagelist IS 'A list of message IDs for existing replies';


--
-- Name: mdl_messageinbound_messagelist_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_messageinbound_messagelist_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_messageinbound_messagelist_id_seq OWNER TO postgres;

--
-- Name: mdl_messageinbound_messagelist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_messageinbound_messagelist_id_seq OWNED BY public.mdl_messageinbound_messagelist.id;


--
-- Name: mdl_messages; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_messages (
    id bigint NOT NULL,
    useridfrom bigint NOT NULL,
    conversationid bigint NOT NULL,
    subject text,
    fullmessage text,
    fullmessageformat smallint DEFAULT 0 NOT NULL,
    fullmessagehtml text,
    smallmessage text,
    timecreated bigint NOT NULL,
    fullmessagetrust smallint DEFAULT 0 NOT NULL,
    customdata text
);


ALTER TABLE public.mdl_messages OWNER TO postgres;

--
-- Name: TABLE mdl_messages; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_messages IS 'Stores all messages';


--
-- Name: mdl_messages_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_messages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_messages_id_seq OWNER TO postgres;

--
-- Name: mdl_messages_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_messages_id_seq OWNED BY public.mdl_messages.id;


--
-- Name: mdl_microlearning_nugget; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_microlearning_nugget (
    id bigint NOT NULL,
    name character varying(100) DEFAULT ''::character varying NOT NULL,
    threadid bigint NOT NULL,
    sectionid bigint,
    cmid bigint,
    halt_until_fulfilled bytea NOT NULL,
    nuggetorder bigint DEFAULT 0 NOT NULL,
    timecreated bigint NOT NULL,
    url text
);


ALTER TABLE public.mdl_microlearning_nugget OWNER TO postgres;

--
-- Name: TABLE mdl_microlearning_nugget; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_microlearning_nugget IS 'Default comment for the table, please edit me';


--
-- Name: mdl_microlearning_nugget_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_microlearning_nugget_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_microlearning_nugget_id_seq OWNER TO postgres;

--
-- Name: mdl_microlearning_nugget_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_microlearning_nugget_id_seq OWNED BY public.mdl_microlearning_nugget.id;


--
-- Name: mdl_microlearning_nugget_sched; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_microlearning_nugget_sched (
    id bigint NOT NULL,
    nuggetid bigint NOT NULL,
    scheduledate bigint NOT NULL,
    due_date bigint NOT NULL,
    reminder1_date bigint DEFAULT 0 NOT NULL,
    reminder2_date bigint DEFAULT 0 NOT NULL,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_microlearning_nugget_sched OWNER TO postgres;

--
-- Name: TABLE mdl_microlearning_nugget_sched; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_microlearning_nugget_sched IS 'Default comment for the table, please edit me';


--
-- Name: mdl_microlearning_nugget_sched_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_microlearning_nugget_sched_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_microlearning_nugget_sched_id_seq OWNER TO postgres;

--
-- Name: mdl_microlearning_nugget_sched_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_microlearning_nugget_sched_id_seq OWNED BY public.mdl_microlearning_nugget_sched.id;


--
-- Name: mdl_microlearning_thread; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_microlearning_thread (
    id bigint NOT NULL,
    companyid bigint NOT NULL,
    name character varying(100) DEFAULT ''::character varying NOT NULL,
    send_message bytea NOT NULL,
    message_preset bigint DEFAULT 0 NOT NULL,
    message_time bigint DEFAULT 0 NOT NULL,
    send_reminder bytea NOT NULL,
    halt_until_fulfilled bytea NOT NULL,
    reminder1 bigint DEFAULT 0 NOT NULL,
    reminder2 bigint DEFAULT 0 NOT NULL,
    active bytea NOT NULL,
    startdate bigint NOT NULL,
    timecreated bigint NOT NULL,
    releaseinterval bigint DEFAULT 0,
    defaultdue bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_microlearning_thread OWNER TO postgres;

--
-- Name: TABLE mdl_microlearning_thread; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_microlearning_thread IS 'Default comment for the table, please edit me';


--
-- Name: mdl_microlearning_thread_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_microlearning_thread_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_microlearning_thread_id_seq OWNER TO postgres;

--
-- Name: mdl_microlearning_thread_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_microlearning_thread_id_seq OWNED BY public.mdl_microlearning_thread.id;


--
-- Name: mdl_microlearning_thread_user; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_microlearning_thread_user (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    threadid bigint NOT NULL,
    nuggetid bigint NOT NULL,
    schedule_date bigint NOT NULL,
    due_date bigint NOT NULL,
    reminder1_date bigint DEFAULT 0 NOT NULL,
    reminder2_date bigint DEFAULT 0 NOT NULL,
    message_time bigint DEFAULT 0 NOT NULL,
    message_delivered bytea NOT NULL,
    reminder1_delivered bytea NOT NULL,
    reminder2_delivered bytea NOT NULL,
    timecompleted bigint,
    accesskey character varying(240) DEFAULT ''::character varying NOT NULL,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_microlearning_thread_user OWNER TO postgres;

--
-- Name: TABLE mdl_microlearning_thread_user; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_microlearning_thread_user IS 'Default comment for the table, please edit me';


--
-- Name: mdl_microlearning_thread_user_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_microlearning_thread_user_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_microlearning_thread_user_id_seq OWNER TO postgres;

--
-- Name: mdl_microlearning_thread_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_microlearning_thread_user_id_seq OWNED BY public.mdl_microlearning_thread_user.id;


--
-- Name: mdl_mnet_application; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_mnet_application (
    id bigint NOT NULL,
    name character varying(50) DEFAULT ''::character varying NOT NULL,
    display_name character varying(50) DEFAULT ''::character varying NOT NULL,
    xmlrpc_server_url character varying(255) DEFAULT ''::character varying NOT NULL,
    sso_land_url character varying(255) DEFAULT ''::character varying NOT NULL,
    sso_jump_url character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_mnet_application OWNER TO postgres;

--
-- Name: TABLE mdl_mnet_application; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_mnet_application IS 'Information about applications on remote hosts';


--
-- Name: mdl_mnet_application_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_application_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_application_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_application_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_mnet_application_id_seq OWNED BY public.mdl_mnet_application.id;


--
-- Name: mdl_mnet_host; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_mnet_host (
    id bigint NOT NULL,
    deleted smallint DEFAULT 0 NOT NULL,
    wwwroot character varying(255) DEFAULT ''::character varying NOT NULL,
    ip_address character varying(45) DEFAULT ''::character varying NOT NULL,
    name character varying(80) DEFAULT ''::character varying NOT NULL,
    public_key text NOT NULL,
    public_key_expires bigint DEFAULT 0 NOT NULL,
    transport smallint DEFAULT 0 NOT NULL,
    portno integer DEFAULT 0 NOT NULL,
    last_connect_time bigint DEFAULT 0 NOT NULL,
    last_log_id bigint DEFAULT 0 NOT NULL,
    force_theme smallint DEFAULT 0 NOT NULL,
    theme character varying(100),
    applicationid bigint DEFAULT 1 NOT NULL,
    sslverification smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_mnet_host OWNER TO postgres;

--
-- Name: TABLE mdl_mnet_host; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_mnet_host IS 'Information about the local and remote hosts for RPC';


--
-- Name: mdl_mnet_host2service; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_mnet_host2service (
    id bigint NOT NULL,
    hostid bigint DEFAULT 0 NOT NULL,
    serviceid bigint DEFAULT 0 NOT NULL,
    publish smallint DEFAULT 0 NOT NULL,
    subscribe smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_mnet_host2service OWNER TO postgres;

--
-- Name: TABLE mdl_mnet_host2service; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_mnet_host2service IS 'Information about the services for a given host';


--
-- Name: mdl_mnet_host2service_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_host2service_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_host2service_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_host2service_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_mnet_host2service_id_seq OWNED BY public.mdl_mnet_host2service.id;


--
-- Name: mdl_mnet_host_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_host_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_host_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_host_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_mnet_host_id_seq OWNED BY public.mdl_mnet_host.id;


--
-- Name: mdl_mnet_log; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_mnet_log (
    id bigint NOT NULL,
    hostid bigint DEFAULT 0 NOT NULL,
    remoteid bigint DEFAULT 0 NOT NULL,
    "time" bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    ip character varying(45) DEFAULT ''::character varying NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    coursename character varying(40) DEFAULT ''::character varying NOT NULL,
    module character varying(20) DEFAULT ''::character varying NOT NULL,
    cmid bigint DEFAULT 0 NOT NULL,
    action character varying(40) DEFAULT ''::character varying NOT NULL,
    url character varying(100) DEFAULT ''::character varying NOT NULL,
    info character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_mnet_log OWNER TO postgres;

--
-- Name: TABLE mdl_mnet_log; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_mnet_log IS 'Store session data from users migrating to other sites';


--
-- Name: mdl_mnet_log_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_log_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_mnet_log_id_seq OWNED BY public.mdl_mnet_log.id;


--
-- Name: mdl_mnet_remote_rpc; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_mnet_remote_rpc (
    id bigint NOT NULL,
    functionname character varying(40) DEFAULT ''::character varying NOT NULL,
    xmlrpcpath character varying(80) DEFAULT ''::character varying NOT NULL,
    plugintype character varying(20) DEFAULT ''::character varying NOT NULL,
    pluginname character varying(20) DEFAULT ''::character varying NOT NULL,
    enabled smallint NOT NULL
);


ALTER TABLE public.mdl_mnet_remote_rpc OWNER TO postgres;

--
-- Name: TABLE mdl_mnet_remote_rpc; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_mnet_remote_rpc IS 'This table describes functions that might be called remotely (we have less information about them than local functions)';


--
-- Name: mdl_mnet_remote_rpc_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_remote_rpc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_remote_rpc_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_remote_rpc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_mnet_remote_rpc_id_seq OWNED BY public.mdl_mnet_remote_rpc.id;


--
-- Name: mdl_mnet_remote_service2rpc; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_mnet_remote_service2rpc (
    id bigint NOT NULL,
    serviceid bigint DEFAULT 0 NOT NULL,
    rpcid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_mnet_remote_service2rpc OWNER TO postgres;

--
-- Name: TABLE mdl_mnet_remote_service2rpc; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_mnet_remote_service2rpc IS 'Group functions or methods under a service';


--
-- Name: mdl_mnet_remote_service2rpc_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_remote_service2rpc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_remote_service2rpc_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_remote_service2rpc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_mnet_remote_service2rpc_id_seq OWNED BY public.mdl_mnet_remote_service2rpc.id;


--
-- Name: mdl_mnet_rpc; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_mnet_rpc (
    id bigint NOT NULL,
    functionname character varying(40) DEFAULT ''::character varying NOT NULL,
    xmlrpcpath character varying(80) DEFAULT ''::character varying NOT NULL,
    plugintype character varying(20) DEFAULT ''::character varying NOT NULL,
    pluginname character varying(20) DEFAULT ''::character varying NOT NULL,
    enabled smallint DEFAULT 0 NOT NULL,
    help text NOT NULL,
    profile text NOT NULL,
    filename character varying(100) DEFAULT ''::character varying NOT NULL,
    classname character varying(150),
    static smallint
);


ALTER TABLE public.mdl_mnet_rpc OWNER TO postgres;

--
-- Name: TABLE mdl_mnet_rpc; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_mnet_rpc IS 'Functions or methods that we may publish or subscribe to';


--
-- Name: mdl_mnet_rpc_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_rpc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_rpc_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_rpc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_mnet_rpc_id_seq OWNED BY public.mdl_mnet_rpc.id;


--
-- Name: mdl_mnet_service; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_mnet_service (
    id bigint NOT NULL,
    name character varying(40) DEFAULT ''::character varying NOT NULL,
    description character varying(40) DEFAULT ''::character varying NOT NULL,
    apiversion character varying(10) DEFAULT ''::character varying NOT NULL,
    offer smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_mnet_service OWNER TO postgres;

--
-- Name: TABLE mdl_mnet_service; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_mnet_service IS 'A service is a group of functions';


--
-- Name: mdl_mnet_service2rpc; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_mnet_service2rpc (
    id bigint NOT NULL,
    serviceid bigint DEFAULT 0 NOT NULL,
    rpcid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_mnet_service2rpc OWNER TO postgres;

--
-- Name: TABLE mdl_mnet_service2rpc; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_mnet_service2rpc IS 'Group functions or methods under a service';


--
-- Name: mdl_mnet_service2rpc_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_service2rpc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_service2rpc_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_service2rpc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_mnet_service2rpc_id_seq OWNED BY public.mdl_mnet_service2rpc.id;


--
-- Name: mdl_mnet_service_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_service_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_service_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_service_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_mnet_service_id_seq OWNED BY public.mdl_mnet_service.id;


--
-- Name: mdl_mnet_session; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_mnet_session (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    username character varying(100) DEFAULT ''::character varying NOT NULL,
    token character varying(40) DEFAULT ''::character varying NOT NULL,
    mnethostid bigint DEFAULT 0 NOT NULL,
    useragent character varying(40) DEFAULT ''::character varying NOT NULL,
    confirm_timeout bigint DEFAULT 0 NOT NULL,
    session_id character varying(40) DEFAULT ''::character varying NOT NULL,
    expires bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_mnet_session OWNER TO postgres;

--
-- Name: TABLE mdl_mnet_session; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_mnet_session IS 'Store session data from users migrating to other sites';


--
-- Name: mdl_mnet_session_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_session_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_session_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_session_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_mnet_session_id_seq OWNED BY public.mdl_mnet_session.id;


--
-- Name: mdl_mnet_sso_access_control; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_mnet_sso_access_control (
    id bigint NOT NULL,
    username character varying(100) DEFAULT ''::character varying NOT NULL,
    mnet_host_id bigint DEFAULT 0 NOT NULL,
    accessctrl character varying(20) DEFAULT 'allow'::character varying NOT NULL
);


ALTER TABLE public.mdl_mnet_sso_access_control OWNER TO postgres;

--
-- Name: TABLE mdl_mnet_sso_access_control; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_mnet_sso_access_control IS 'Users by host permitted (or not) to login from a remote provider';


--
-- Name: mdl_mnet_sso_access_control_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_sso_access_control_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_sso_access_control_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_sso_access_control_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_mnet_sso_access_control_id_seq OWNED BY public.mdl_mnet_sso_access_control.id;


--
-- Name: mdl_mnetservice_enrol_courses; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_mnetservice_enrol_courses (
    id bigint NOT NULL,
    hostid bigint NOT NULL,
    remoteid bigint NOT NULL,
    categoryid bigint NOT NULL,
    categoryname character varying(255) DEFAULT ''::character varying NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL,
    fullname character varying(254) DEFAULT ''::character varying NOT NULL,
    shortname character varying(100) DEFAULT ''::character varying NOT NULL,
    idnumber character varying(100) DEFAULT ''::character varying NOT NULL,
    summary text NOT NULL,
    summaryformat smallint DEFAULT 0,
    startdate bigint NOT NULL,
    roleid bigint NOT NULL,
    rolename character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_mnetservice_enrol_courses OWNER TO postgres;

--
-- Name: TABLE mdl_mnetservice_enrol_courses; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_mnetservice_enrol_courses IS 'Caches the information fetched via XML-RPC about courses on remote hosts that are offered for our users';


--
-- Name: mdl_mnetservice_enrol_courses_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnetservice_enrol_courses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnetservice_enrol_courses_id_seq OWNER TO postgres;

--
-- Name: mdl_mnetservice_enrol_courses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_mnetservice_enrol_courses_id_seq OWNED BY public.mdl_mnetservice_enrol_courses.id;


--
-- Name: mdl_mnetservice_enrol_enrolments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_mnetservice_enrol_enrolments (
    id bigint NOT NULL,
    hostid bigint NOT NULL,
    userid bigint NOT NULL,
    remotecourseid bigint NOT NULL,
    rolename character varying(255) DEFAULT ''::character varying NOT NULL,
    enroltime bigint DEFAULT 0 NOT NULL,
    enroltype character varying(20) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_mnetservice_enrol_enrolments OWNER TO postgres;

--
-- Name: TABLE mdl_mnetservice_enrol_enrolments; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_mnetservice_enrol_enrolments IS 'Caches the information about enrolments of our local users in courses on remote hosts';


--
-- Name: mdl_mnetservice_enrol_enrolments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnetservice_enrol_enrolments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnetservice_enrol_enrolments_id_seq OWNER TO postgres;

--
-- Name: mdl_mnetservice_enrol_enrolments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_mnetservice_enrol_enrolments_id_seq OWNED BY public.mdl_mnetservice_enrol_enrolments.id;


--
-- Name: mdl_modules; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_modules (
    id bigint NOT NULL,
    name character varying(20) DEFAULT ''::character varying NOT NULL,
    cron bigint DEFAULT 0 NOT NULL,
    lastcron bigint DEFAULT 0 NOT NULL,
    search character varying(255) DEFAULT ''::character varying NOT NULL,
    visible smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_modules OWNER TO postgres;

--
-- Name: TABLE mdl_modules; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_modules IS 'modules available in the site';


--
-- Name: mdl_modules_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_modules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_modules_id_seq OWNER TO postgres;

--
-- Name: mdl_modules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_modules_id_seq OWNED BY public.mdl_modules.id;


--
-- Name: mdl_my_pages; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_my_pages (
    id bigint NOT NULL,
    userid bigint DEFAULT 0,
    name character varying(200) DEFAULT ''::character varying NOT NULL,
    private smallint DEFAULT 1 NOT NULL,
    sortorder integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_my_pages OWNER TO postgres;

--
-- Name: TABLE mdl_my_pages; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_my_pages IS 'Extra user pages for the My Moodle system';


--
-- Name: mdl_my_pages_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_my_pages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_my_pages_id_seq OWNER TO postgres;

--
-- Name: mdl_my_pages_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_my_pages_id_seq OWNED BY public.mdl_my_pages.id;


--
-- Name: mdl_notifications; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_notifications (
    id bigint NOT NULL,
    useridfrom bigint NOT NULL,
    useridto bigint NOT NULL,
    subject text,
    fullmessage text,
    fullmessageformat smallint DEFAULT 0 NOT NULL,
    fullmessagehtml text,
    smallmessage text,
    component character varying(100),
    eventtype character varying(100),
    contexturl text,
    contexturlname text,
    timeread bigint,
    timecreated bigint NOT NULL,
    customdata text
);


ALTER TABLE public.mdl_notifications OWNER TO postgres;

--
-- Name: TABLE mdl_notifications; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_notifications IS 'Stores all notifications';


--
-- Name: mdl_notifications_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_notifications_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_notifications_id_seq OWNER TO postgres;

--
-- Name: mdl_notifications_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_notifications_id_seq OWNED BY public.mdl_notifications.id;


--
-- Name: mdl_oauth2_access_token; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_oauth2_access_token (
    id bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL,
    issuerid bigint NOT NULL,
    token text NOT NULL,
    expires bigint NOT NULL,
    scope text NOT NULL
);


ALTER TABLE public.mdl_oauth2_access_token OWNER TO postgres;

--
-- Name: TABLE mdl_oauth2_access_token; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_oauth2_access_token IS 'Stores access tokens for system accounts in order to be able to use a single token across multiple sessions';


--
-- Name: mdl_oauth2_access_token_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_oauth2_access_token_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_oauth2_access_token_id_seq OWNER TO postgres;

--
-- Name: mdl_oauth2_access_token_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_oauth2_access_token_id_seq OWNED BY public.mdl_oauth2_access_token.id;


--
-- Name: mdl_oauth2_endpoint; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_oauth2_endpoint (
    id bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    url text NOT NULL,
    issuerid bigint NOT NULL
);


ALTER TABLE public.mdl_oauth2_endpoint OWNER TO postgres;

--
-- Name: TABLE mdl_oauth2_endpoint; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_oauth2_endpoint IS 'Describes the named endpoint for an oauth2 service.';


--
-- Name: mdl_oauth2_endpoint_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_oauth2_endpoint_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_oauth2_endpoint_id_seq OWNER TO postgres;

--
-- Name: mdl_oauth2_endpoint_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_oauth2_endpoint_id_seq OWNED BY public.mdl_oauth2_endpoint.id;


--
-- Name: mdl_oauth2_issuer; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_oauth2_issuer (
    id bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    image text NOT NULL,
    baseurl text NOT NULL,
    clientid text NOT NULL,
    clientsecret text NOT NULL,
    loginscopes text NOT NULL,
    loginscopesoffline text NOT NULL,
    loginparams text NOT NULL,
    loginparamsoffline text NOT NULL,
    alloweddomains text NOT NULL,
    scopessupported text,
    enabled smallint DEFAULT 1 NOT NULL,
    showonloginpage smallint DEFAULT 1 NOT NULL,
    basicauth smallint DEFAULT 0 NOT NULL,
    sortorder bigint NOT NULL,
    requireconfirmation smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_oauth2_issuer OWNER TO postgres;

--
-- Name: TABLE mdl_oauth2_issuer; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_oauth2_issuer IS 'Details for an oauth 2 connect identity issuer.';


--
-- Name: mdl_oauth2_issuer_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_oauth2_issuer_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_oauth2_issuer_id_seq OWNER TO postgres;

--
-- Name: mdl_oauth2_issuer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_oauth2_issuer_id_seq OWNED BY public.mdl_oauth2_issuer.id;


--
-- Name: mdl_oauth2_system_account; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_oauth2_system_account (
    id bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL,
    issuerid bigint NOT NULL,
    refreshtoken text NOT NULL,
    grantedscopes text NOT NULL,
    email text,
    username text NOT NULL
);


ALTER TABLE public.mdl_oauth2_system_account OWNER TO postgres;

--
-- Name: TABLE mdl_oauth2_system_account; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_oauth2_system_account IS 'Stored details used to get an access token as a system user for this oauth2 service.';


--
-- Name: mdl_oauth2_system_account_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_oauth2_system_account_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_oauth2_system_account_id_seq OWNER TO postgres;

--
-- Name: mdl_oauth2_system_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_oauth2_system_account_id_seq OWNED BY public.mdl_oauth2_system_account.id;


--
-- Name: mdl_oauth2_user_field_mapping; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_oauth2_user_field_mapping (
    id bigint NOT NULL,
    timemodified bigint NOT NULL,
    timecreated bigint NOT NULL,
    usermodified bigint NOT NULL,
    issuerid bigint NOT NULL,
    externalfield character varying(64) DEFAULT ''::character varying NOT NULL,
    internalfield character varying(64) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_oauth2_user_field_mapping OWNER TO postgres;

--
-- Name: TABLE mdl_oauth2_user_field_mapping; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_oauth2_user_field_mapping IS 'Mapping of oauth user fields to moodle fields.';


--
-- Name: mdl_oauth2_user_field_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_oauth2_user_field_mapping_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_oauth2_user_field_mapping_id_seq OWNER TO postgres;

--
-- Name: mdl_oauth2_user_field_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_oauth2_user_field_mapping_id_seq OWNED BY public.mdl_oauth2_user_field_mapping.id;


--
-- Name: mdl_page; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_page (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text,
    introformat smallint DEFAULT 0 NOT NULL,
    content text,
    contentformat smallint DEFAULT 0 NOT NULL,
    legacyfiles smallint DEFAULT 0 NOT NULL,
    legacyfileslast bigint,
    display smallint DEFAULT 0 NOT NULL,
    displayoptions text,
    revision bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_page OWNER TO postgres;

--
-- Name: TABLE mdl_page; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_page IS 'Each record is one page and its config data';


--
-- Name: mdl_page_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_page_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_page_id_seq OWNER TO postgres;

--
-- Name: mdl_page_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_page_id_seq OWNED BY public.mdl_page.id;


--
-- Name: mdl_portfolio_instance; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_portfolio_instance (
    id bigint NOT NULL,
    plugin character varying(50) DEFAULT ''::character varying NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    visible smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_portfolio_instance OWNER TO postgres;

--
-- Name: TABLE mdl_portfolio_instance; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_portfolio_instance IS 'base table (not including config data) for instances of portfolio plugins.';


--
-- Name: mdl_portfolio_instance_config; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_portfolio_instance_config (
    id bigint NOT NULL,
    instance bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    value text
);


ALTER TABLE public.mdl_portfolio_instance_config OWNER TO postgres;

--
-- Name: TABLE mdl_portfolio_instance_config; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_portfolio_instance_config IS 'config for portfolio plugin instances';


--
-- Name: mdl_portfolio_instance_config_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_portfolio_instance_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_portfolio_instance_config_id_seq OWNER TO postgres;

--
-- Name: mdl_portfolio_instance_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_portfolio_instance_config_id_seq OWNED BY public.mdl_portfolio_instance_config.id;


--
-- Name: mdl_portfolio_instance_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_portfolio_instance_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_portfolio_instance_id_seq OWNER TO postgres;

--
-- Name: mdl_portfolio_instance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_portfolio_instance_id_seq OWNED BY public.mdl_portfolio_instance.id;


--
-- Name: mdl_portfolio_instance_user; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_portfolio_instance_user (
    id bigint NOT NULL,
    instance bigint NOT NULL,
    userid bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    value text
);


ALTER TABLE public.mdl_portfolio_instance_user OWNER TO postgres;

--
-- Name: TABLE mdl_portfolio_instance_user; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_portfolio_instance_user IS 'user data for portfolio instances.';


--
-- Name: mdl_portfolio_instance_user_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_portfolio_instance_user_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_portfolio_instance_user_id_seq OWNER TO postgres;

--
-- Name: mdl_portfolio_instance_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_portfolio_instance_user_id_seq OWNED BY public.mdl_portfolio_instance_user.id;


--
-- Name: mdl_portfolio_log; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_portfolio_log (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    "time" bigint NOT NULL,
    portfolio bigint NOT NULL,
    caller_class character varying(150) DEFAULT ''::character varying NOT NULL,
    caller_file character varying(255) DEFAULT ''::character varying NOT NULL,
    caller_component character varying(255),
    caller_sha1 character varying(255) DEFAULT ''::character varying NOT NULL,
    tempdataid bigint DEFAULT 0 NOT NULL,
    returnurl character varying(255) DEFAULT ''::character varying NOT NULL,
    continueurl character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_portfolio_log OWNER TO postgres;

--
-- Name: TABLE mdl_portfolio_log; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_portfolio_log IS 'log of portfolio transfers (used to later check for duplicates)';


--
-- Name: mdl_portfolio_log_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_portfolio_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_portfolio_log_id_seq OWNER TO postgres;

--
-- Name: mdl_portfolio_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_portfolio_log_id_seq OWNED BY public.mdl_portfolio_log.id;


--
-- Name: mdl_portfolio_mahara_queue; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_portfolio_mahara_queue (
    id bigint NOT NULL,
    transferid bigint NOT NULL,
    token character varying(50) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_portfolio_mahara_queue OWNER TO postgres;

--
-- Name: TABLE mdl_portfolio_mahara_queue; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_portfolio_mahara_queue IS 'maps mahara tokens to transfer ids';


--
-- Name: mdl_portfolio_mahara_queue_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_portfolio_mahara_queue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_portfolio_mahara_queue_id_seq OWNER TO postgres;

--
-- Name: mdl_portfolio_mahara_queue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_portfolio_mahara_queue_id_seq OWNED BY public.mdl_portfolio_mahara_queue.id;


--
-- Name: mdl_portfolio_tempdata; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_portfolio_tempdata (
    id bigint NOT NULL,
    data text,
    expirytime bigint NOT NULL,
    userid bigint NOT NULL,
    instance bigint DEFAULT 0,
    queued smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_portfolio_tempdata OWNER TO postgres;

--
-- Name: TABLE mdl_portfolio_tempdata; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_portfolio_tempdata IS 'stores temporary data for portfolio exports. the id of this table is used for the itemid for the temporary files area.  cron can clean up stale records (and associated file data) after expirytime.';


--
-- Name: mdl_portfolio_tempdata_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_portfolio_tempdata_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_portfolio_tempdata_id_seq OWNER TO postgres;

--
-- Name: mdl_portfolio_tempdata_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_portfolio_tempdata_id_seq OWNED BY public.mdl_portfolio_tempdata.id;


--
-- Name: mdl_post; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_post (
    id bigint NOT NULL,
    module character varying(20) DEFAULT ''::character varying NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    groupid bigint DEFAULT 0 NOT NULL,
    moduleid bigint DEFAULT 0 NOT NULL,
    coursemoduleid bigint DEFAULT 0 NOT NULL,
    subject character varying(128) DEFAULT ''::character varying NOT NULL,
    summary text,
    content text,
    uniquehash character varying(255) DEFAULT ''::character varying NOT NULL,
    rating bigint DEFAULT 0 NOT NULL,
    format bigint DEFAULT 0 NOT NULL,
    summaryformat smallint DEFAULT 0 NOT NULL,
    attachment character varying(100),
    publishstate character varying(20) DEFAULT 'draft'::character varying NOT NULL,
    lastmodified bigint DEFAULT 0 NOT NULL,
    created bigint DEFAULT 0 NOT NULL,
    usermodified bigint
);


ALTER TABLE public.mdl_post OWNER TO postgres;

--
-- Name: TABLE mdl_post; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_post IS 'Generic post table to hold data blog entries etc in different modules';


--
-- Name: mdl_post_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_post_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_post_id_seq OWNER TO postgres;

--
-- Name: mdl_post_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_post_id_seq OWNED BY public.mdl_post.id;


--
-- Name: mdl_profiling; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_profiling (
    id bigint NOT NULL,
    runid character varying(32) DEFAULT ''::character varying NOT NULL,
    url character varying(255) DEFAULT ''::character varying NOT NULL,
    data text NOT NULL,
    totalexecutiontime bigint NOT NULL,
    totalcputime bigint NOT NULL,
    totalcalls bigint NOT NULL,
    totalmemory bigint NOT NULL,
    runreference smallint DEFAULT 0 NOT NULL,
    runcomment character varying(255) DEFAULT ''::character varying NOT NULL,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_profiling OWNER TO postgres;

--
-- Name: TABLE mdl_profiling; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_profiling IS 'Stores the results of all the profiling runs';


--
-- Name: mdl_profiling_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_profiling_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_profiling_id_seq OWNER TO postgres;

--
-- Name: mdl_profiling_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_profiling_id_seq OWNED BY public.mdl_profiling.id;


--
-- Name: mdl_qtype_ddimageortext; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_qtype_ddimageortext (
    id bigint NOT NULL,
    questionid bigint DEFAULT 0 NOT NULL,
    shuffleanswers smallint DEFAULT 1 NOT NULL,
    correctfeedback text NOT NULL,
    correctfeedbackformat smallint DEFAULT 0 NOT NULL,
    partiallycorrectfeedback text NOT NULL,
    partiallycorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    incorrectfeedback text NOT NULL,
    incorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    shownumcorrect smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_qtype_ddimageortext OWNER TO postgres;

--
-- Name: TABLE mdl_qtype_ddimageortext; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_qtype_ddimageortext IS 'Defines drag and drop (text or images onto a background image) questions';


--
-- Name: mdl_qtype_ddimageortext_drags; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_qtype_ddimageortext_drags (
    id bigint NOT NULL,
    questionid bigint DEFAULT 0 NOT NULL,
    no bigint DEFAULT 0 NOT NULL,
    draggroup bigint DEFAULT 0 NOT NULL,
    infinite smallint DEFAULT 0 NOT NULL,
    label text NOT NULL
);


ALTER TABLE public.mdl_qtype_ddimageortext_drags OWNER TO postgres;

--
-- Name: TABLE mdl_qtype_ddimageortext_drags; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_qtype_ddimageortext_drags IS 'Images to drag. Actual file names are not stored here we use the file names as found in the file storage area.';


--
-- Name: mdl_qtype_ddimageortext_drags_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_qtype_ddimageortext_drags_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_qtype_ddimageortext_drags_id_seq OWNER TO postgres;

--
-- Name: mdl_qtype_ddimageortext_drags_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_qtype_ddimageortext_drags_id_seq OWNED BY public.mdl_qtype_ddimageortext_drags.id;


--
-- Name: mdl_qtype_ddimageortext_drops; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_qtype_ddimageortext_drops (
    id bigint NOT NULL,
    questionid bigint DEFAULT 0 NOT NULL,
    no bigint DEFAULT 0 NOT NULL,
    xleft bigint DEFAULT 0 NOT NULL,
    ytop bigint DEFAULT 0 NOT NULL,
    choice bigint DEFAULT 0 NOT NULL,
    label text NOT NULL
);


ALTER TABLE public.mdl_qtype_ddimageortext_drops OWNER TO postgres;

--
-- Name: TABLE mdl_qtype_ddimageortext_drops; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_qtype_ddimageortext_drops IS 'Drop boxes';


--
-- Name: mdl_qtype_ddimageortext_drops_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_qtype_ddimageortext_drops_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_qtype_ddimageortext_drops_id_seq OWNER TO postgres;

--
-- Name: mdl_qtype_ddimageortext_drops_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_qtype_ddimageortext_drops_id_seq OWNED BY public.mdl_qtype_ddimageortext_drops.id;


--
-- Name: mdl_qtype_ddimageortext_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_qtype_ddimageortext_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_qtype_ddimageortext_id_seq OWNER TO postgres;

--
-- Name: mdl_qtype_ddimageortext_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_qtype_ddimageortext_id_seq OWNED BY public.mdl_qtype_ddimageortext.id;


--
-- Name: mdl_qtype_ddmarker; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_qtype_ddmarker (
    id bigint NOT NULL,
    questionid bigint DEFAULT 0 NOT NULL,
    shuffleanswers smallint DEFAULT 1 NOT NULL,
    correctfeedback text NOT NULL,
    correctfeedbackformat smallint DEFAULT 0 NOT NULL,
    partiallycorrectfeedback text NOT NULL,
    partiallycorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    incorrectfeedback text NOT NULL,
    incorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    shownumcorrect smallint DEFAULT 0 NOT NULL,
    showmisplaced smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_qtype_ddmarker OWNER TO postgres;

--
-- Name: TABLE mdl_qtype_ddmarker; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_qtype_ddmarker IS 'Defines drag and drop (text or images onto a background image) questions';


--
-- Name: mdl_qtype_ddmarker_drags; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_qtype_ddmarker_drags (
    id bigint NOT NULL,
    questionid bigint DEFAULT 0 NOT NULL,
    no bigint DEFAULT 0 NOT NULL,
    label text NOT NULL,
    infinite smallint DEFAULT 0 NOT NULL,
    noofdrags bigint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_qtype_ddmarker_drags OWNER TO postgres;

--
-- Name: TABLE mdl_qtype_ddmarker_drags; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_qtype_ddmarker_drags IS 'Labels for markers to drag.';


--
-- Name: mdl_qtype_ddmarker_drags_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_qtype_ddmarker_drags_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_qtype_ddmarker_drags_id_seq OWNER TO postgres;

--
-- Name: mdl_qtype_ddmarker_drags_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_qtype_ddmarker_drags_id_seq OWNED BY public.mdl_qtype_ddmarker_drags.id;


--
-- Name: mdl_qtype_ddmarker_drops; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_qtype_ddmarker_drops (
    id bigint NOT NULL,
    questionid bigint DEFAULT 0 NOT NULL,
    no bigint DEFAULT 0 NOT NULL,
    shape character varying(255),
    coords text NOT NULL,
    choice bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_qtype_ddmarker_drops OWNER TO postgres;

--
-- Name: TABLE mdl_qtype_ddmarker_drops; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_qtype_ddmarker_drops IS 'drop regions';


--
-- Name: mdl_qtype_ddmarker_drops_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_qtype_ddmarker_drops_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_qtype_ddmarker_drops_id_seq OWNER TO postgres;

--
-- Name: mdl_qtype_ddmarker_drops_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_qtype_ddmarker_drops_id_seq OWNED BY public.mdl_qtype_ddmarker_drops.id;


--
-- Name: mdl_qtype_ddmarker_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_qtype_ddmarker_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_qtype_ddmarker_id_seq OWNER TO postgres;

--
-- Name: mdl_qtype_ddmarker_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_qtype_ddmarker_id_seq OWNED BY public.mdl_qtype_ddmarker.id;


--
-- Name: mdl_qtype_essay_options; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_qtype_essay_options (
    id bigint NOT NULL,
    questionid bigint NOT NULL,
    responseformat character varying(16) DEFAULT 'editor'::character varying NOT NULL,
    responserequired smallint DEFAULT 1 NOT NULL,
    responsefieldlines smallint DEFAULT 15 NOT NULL,
    attachments smallint DEFAULT 0 NOT NULL,
    attachmentsrequired smallint DEFAULT 0 NOT NULL,
    graderinfo text,
    graderinfoformat smallint DEFAULT 0 NOT NULL,
    responsetemplate text,
    responsetemplateformat smallint DEFAULT 0 NOT NULL,
    filetypeslist text
);


ALTER TABLE public.mdl_qtype_essay_options OWNER TO postgres;

--
-- Name: TABLE mdl_qtype_essay_options; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_qtype_essay_options IS 'Extra options for essay questions.';


--
-- Name: mdl_qtype_essay_options_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_qtype_essay_options_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_qtype_essay_options_id_seq OWNER TO postgres;

--
-- Name: mdl_qtype_essay_options_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_qtype_essay_options_id_seq OWNED BY public.mdl_qtype_essay_options.id;


--
-- Name: mdl_qtype_match_options; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_qtype_match_options (
    id bigint NOT NULL,
    questionid bigint DEFAULT 0 NOT NULL,
    shuffleanswers smallint DEFAULT 1 NOT NULL,
    correctfeedback text NOT NULL,
    correctfeedbackformat smallint DEFAULT 0 NOT NULL,
    partiallycorrectfeedback text NOT NULL,
    partiallycorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    incorrectfeedback text NOT NULL,
    incorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    shownumcorrect smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_qtype_match_options OWNER TO postgres;

--
-- Name: TABLE mdl_qtype_match_options; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_qtype_match_options IS 'Defines the question-type specific options for matching questions';


--
-- Name: mdl_qtype_match_options_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_qtype_match_options_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_qtype_match_options_id_seq OWNER TO postgres;

--
-- Name: mdl_qtype_match_options_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_qtype_match_options_id_seq OWNED BY public.mdl_qtype_match_options.id;


--
-- Name: mdl_qtype_match_subquestions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_qtype_match_subquestions (
    id bigint NOT NULL,
    questionid bigint DEFAULT 0 NOT NULL,
    questiontext text NOT NULL,
    questiontextformat smallint DEFAULT 0 NOT NULL,
    answertext character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_qtype_match_subquestions OWNER TO postgres;

--
-- Name: TABLE mdl_qtype_match_subquestions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_qtype_match_subquestions IS 'The subquestions that make up a matching question';


--
-- Name: mdl_qtype_match_subquestions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_qtype_match_subquestions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_qtype_match_subquestions_id_seq OWNER TO postgres;

--
-- Name: mdl_qtype_match_subquestions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_qtype_match_subquestions_id_seq OWNED BY public.mdl_qtype_match_subquestions.id;


--
-- Name: mdl_qtype_multichoice_options; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_qtype_multichoice_options (
    id bigint NOT NULL,
    questionid bigint DEFAULT 0 NOT NULL,
    layout smallint DEFAULT 0 NOT NULL,
    single smallint DEFAULT 0 NOT NULL,
    shuffleanswers smallint DEFAULT 1 NOT NULL,
    correctfeedback text NOT NULL,
    correctfeedbackformat smallint DEFAULT 0 NOT NULL,
    partiallycorrectfeedback text NOT NULL,
    partiallycorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    incorrectfeedback text NOT NULL,
    incorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    answernumbering character varying(10) DEFAULT 'abc'::character varying NOT NULL,
    shownumcorrect smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_qtype_multichoice_options OWNER TO postgres;

--
-- Name: TABLE mdl_qtype_multichoice_options; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_qtype_multichoice_options IS 'Options for multiple choice questions';


--
-- Name: mdl_qtype_multichoice_options_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_qtype_multichoice_options_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_qtype_multichoice_options_id_seq OWNER TO postgres;

--
-- Name: mdl_qtype_multichoice_options_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_qtype_multichoice_options_id_seq OWNED BY public.mdl_qtype_multichoice_options.id;


--
-- Name: mdl_qtype_randomsamatch_options; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_qtype_randomsamatch_options (
    id bigint NOT NULL,
    questionid bigint DEFAULT 0 NOT NULL,
    choose bigint DEFAULT 4 NOT NULL,
    subcats smallint DEFAULT 1 NOT NULL,
    correctfeedback text NOT NULL,
    correctfeedbackformat smallint DEFAULT 0 NOT NULL,
    partiallycorrectfeedback text NOT NULL,
    partiallycorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    incorrectfeedback text NOT NULL,
    incorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    shownumcorrect smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_qtype_randomsamatch_options OWNER TO postgres;

--
-- Name: TABLE mdl_qtype_randomsamatch_options; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_qtype_randomsamatch_options IS 'Info about a random short-answer matching question';


--
-- Name: mdl_qtype_randomsamatch_options_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_qtype_randomsamatch_options_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_qtype_randomsamatch_options_id_seq OWNER TO postgres;

--
-- Name: mdl_qtype_randomsamatch_options_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_qtype_randomsamatch_options_id_seq OWNED BY public.mdl_qtype_randomsamatch_options.id;


--
-- Name: mdl_qtype_shortanswer_options; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_qtype_shortanswer_options (
    id bigint NOT NULL,
    questionid bigint DEFAULT 0 NOT NULL,
    usecase smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_qtype_shortanswer_options OWNER TO postgres;

--
-- Name: TABLE mdl_qtype_shortanswer_options; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_qtype_shortanswer_options IS 'Options for short answer questions';


--
-- Name: mdl_qtype_shortanswer_options_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_qtype_shortanswer_options_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_qtype_shortanswer_options_id_seq OWNER TO postgres;

--
-- Name: mdl_qtype_shortanswer_options_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_qtype_shortanswer_options_id_seq OWNED BY public.mdl_qtype_shortanswer_options.id;


--
-- Name: mdl_question; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question (
    id bigint NOT NULL,
    category bigint DEFAULT 0 NOT NULL,
    parent bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    questiontext text NOT NULL,
    questiontextformat smallint DEFAULT 0 NOT NULL,
    generalfeedback text NOT NULL,
    generalfeedbackformat smallint DEFAULT 0 NOT NULL,
    defaultmark numeric(12,7) DEFAULT 1 NOT NULL,
    penalty numeric(12,7) DEFAULT 0.3333333 NOT NULL,
    qtype character varying(20) DEFAULT ''::character varying NOT NULL,
    length bigint DEFAULT 1 NOT NULL,
    stamp character varying(255) DEFAULT ''::character varying NOT NULL,
    version character varying(255) DEFAULT ''::character varying NOT NULL,
    hidden smallint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    createdby bigint,
    modifiedby bigint,
    idnumber character varying(100)
);


ALTER TABLE public.mdl_question OWNER TO postgres;

--
-- Name: TABLE mdl_question; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question IS 'The questions themselves';


--
-- Name: mdl_question_answers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_answers (
    id bigint NOT NULL,
    question bigint DEFAULT 0 NOT NULL,
    answer text NOT NULL,
    answerformat smallint DEFAULT 0 NOT NULL,
    fraction numeric(12,7) DEFAULT 0 NOT NULL,
    feedback text NOT NULL,
    feedbackformat smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_question_answers OWNER TO postgres;

--
-- Name: TABLE mdl_question_answers; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_answers IS 'Answers, with a fractional grade (0-1) and feedback';


--
-- Name: mdl_question_answers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_answers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_answers_id_seq OWNER TO postgres;

--
-- Name: mdl_question_answers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_answers_id_seq OWNED BY public.mdl_question_answers.id;


--
-- Name: mdl_question_attempt_step_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_attempt_step_data (
    id bigint NOT NULL,
    attemptstepid bigint NOT NULL,
    name character varying(32) DEFAULT ''::character varying NOT NULL,
    value text
);


ALTER TABLE public.mdl_question_attempt_step_data OWNER TO postgres;

--
-- Name: TABLE mdl_question_attempt_step_data; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_attempt_step_data IS 'Each question_attempt_step has an associative array of the data that was submitted by the user in the POST request. It can also contain extra data from the question type or behaviour to avoid re-computation. The convention is that names belonging to ';


--
-- Name: mdl_question_attempt_step_data_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_attempt_step_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_attempt_step_data_id_seq OWNER TO postgres;

--
-- Name: mdl_question_attempt_step_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_attempt_step_data_id_seq OWNED BY public.mdl_question_attempt_step_data.id;


--
-- Name: mdl_question_attempt_steps; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_attempt_steps (
    id bigint NOT NULL,
    questionattemptid bigint NOT NULL,
    sequencenumber bigint NOT NULL,
    state character varying(13) DEFAULT ''::character varying NOT NULL,
    fraction numeric(12,7),
    timecreated bigint NOT NULL,
    userid bigint
);


ALTER TABLE public.mdl_question_attempt_steps OWNER TO postgres;

--
-- Name: TABLE mdl_question_attempt_steps; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_attempt_steps IS 'Stores one step in in a question attempt. As well as the data here, the step will have some data in the question_attempt_step_data table.';


--
-- Name: mdl_question_attempt_steps_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_attempt_steps_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_attempt_steps_id_seq OWNER TO postgres;

--
-- Name: mdl_question_attempt_steps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_attempt_steps_id_seq OWNED BY public.mdl_question_attempt_steps.id;


--
-- Name: mdl_question_attempts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_attempts (
    id bigint NOT NULL,
    questionusageid bigint NOT NULL,
    slot bigint NOT NULL,
    behaviour character varying(32) DEFAULT ''::character varying NOT NULL,
    questionid bigint NOT NULL,
    variant bigint DEFAULT 1 NOT NULL,
    maxmark numeric(12,7) NOT NULL,
    minfraction numeric(12,7) NOT NULL,
    maxfraction numeric(12,7) DEFAULT 1 NOT NULL,
    flagged smallint DEFAULT 0 NOT NULL,
    questionsummary text,
    rightanswer text,
    responsesummary text,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_question_attempts OWNER TO postgres;

--
-- Name: TABLE mdl_question_attempts; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_attempts IS 'Each row here corresponds to an attempt at one question, as part of a question_usage. A question_attempt will have some question_attempt_steps';


--
-- Name: mdl_question_attempts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_attempts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_attempts_id_seq OWNER TO postgres;

--
-- Name: mdl_question_attempts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_attempts_id_seq OWNED BY public.mdl_question_attempts.id;


--
-- Name: mdl_question_calculated; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_calculated (
    id bigint NOT NULL,
    question bigint DEFAULT 0 NOT NULL,
    answer bigint DEFAULT 0 NOT NULL,
    tolerance character varying(20) DEFAULT '0.0'::character varying NOT NULL,
    tolerancetype bigint DEFAULT 1 NOT NULL,
    correctanswerlength bigint DEFAULT 2 NOT NULL,
    correctanswerformat bigint DEFAULT 2 NOT NULL
);


ALTER TABLE public.mdl_question_calculated OWNER TO postgres;

--
-- Name: TABLE mdl_question_calculated; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_calculated IS 'Options for questions of type calculated';


--
-- Name: mdl_question_calculated_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_calculated_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_calculated_id_seq OWNER TO postgres;

--
-- Name: mdl_question_calculated_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_calculated_id_seq OWNED BY public.mdl_question_calculated.id;


--
-- Name: mdl_question_calculated_options; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_calculated_options (
    id bigint NOT NULL,
    question bigint DEFAULT 0 NOT NULL,
    synchronize smallint DEFAULT 0 NOT NULL,
    single smallint DEFAULT 0 NOT NULL,
    shuffleanswers smallint DEFAULT 0 NOT NULL,
    correctfeedback text,
    correctfeedbackformat smallint DEFAULT 0 NOT NULL,
    partiallycorrectfeedback text,
    partiallycorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    incorrectfeedback text,
    incorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    answernumbering character varying(10) DEFAULT 'abc'::character varying NOT NULL,
    shownumcorrect smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_question_calculated_options OWNER TO postgres;

--
-- Name: TABLE mdl_question_calculated_options; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_calculated_options IS 'Options for questions of type calculated';


--
-- Name: mdl_question_calculated_options_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_calculated_options_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_calculated_options_id_seq OWNER TO postgres;

--
-- Name: mdl_question_calculated_options_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_calculated_options_id_seq OWNED BY public.mdl_question_calculated_options.id;


--
-- Name: mdl_question_categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_categories (
    id bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    contextid bigint DEFAULT 0 NOT NULL,
    info text NOT NULL,
    infoformat smallint DEFAULT 0 NOT NULL,
    stamp character varying(255) DEFAULT ''::character varying NOT NULL,
    parent bigint DEFAULT 0 NOT NULL,
    sortorder bigint DEFAULT 999 NOT NULL,
    idnumber character varying(100)
);


ALTER TABLE public.mdl_question_categories OWNER TO postgres;

--
-- Name: TABLE mdl_question_categories; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_categories IS 'Categories are for grouping questions';


--
-- Name: mdl_question_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_categories_id_seq OWNER TO postgres;

--
-- Name: mdl_question_categories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_categories_id_seq OWNED BY public.mdl_question_categories.id;


--
-- Name: mdl_question_dataset_definitions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_dataset_definitions (
    id bigint NOT NULL,
    category bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    type bigint DEFAULT 0 NOT NULL,
    options character varying(255) DEFAULT ''::character varying NOT NULL,
    itemcount bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_question_dataset_definitions OWNER TO postgres;

--
-- Name: TABLE mdl_question_dataset_definitions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_dataset_definitions IS 'Organises and stores properties for dataset items';


--
-- Name: mdl_question_dataset_definitions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_dataset_definitions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_dataset_definitions_id_seq OWNER TO postgres;

--
-- Name: mdl_question_dataset_definitions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_dataset_definitions_id_seq OWNED BY public.mdl_question_dataset_definitions.id;


--
-- Name: mdl_question_dataset_items; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_dataset_items (
    id bigint NOT NULL,
    definition bigint DEFAULT 0 NOT NULL,
    itemnumber bigint DEFAULT 0 NOT NULL,
    value character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_question_dataset_items OWNER TO postgres;

--
-- Name: TABLE mdl_question_dataset_items; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_dataset_items IS 'Individual dataset items';


--
-- Name: mdl_question_dataset_items_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_dataset_items_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_dataset_items_id_seq OWNER TO postgres;

--
-- Name: mdl_question_dataset_items_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_dataset_items_id_seq OWNED BY public.mdl_question_dataset_items.id;


--
-- Name: mdl_question_datasets; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_datasets (
    id bigint NOT NULL,
    question bigint DEFAULT 0 NOT NULL,
    datasetdefinition bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_question_datasets OWNER TO postgres;

--
-- Name: TABLE mdl_question_datasets; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_datasets IS 'Many-many relation between questions and dataset definitions';


--
-- Name: mdl_question_datasets_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_datasets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_datasets_id_seq OWNER TO postgres;

--
-- Name: mdl_question_datasets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_datasets_id_seq OWNED BY public.mdl_question_datasets.id;


--
-- Name: mdl_question_ddwtos; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_ddwtos (
    id bigint NOT NULL,
    questionid bigint DEFAULT 0 NOT NULL,
    shuffleanswers smallint DEFAULT 1 NOT NULL,
    correctfeedback text NOT NULL,
    correctfeedbackformat smallint DEFAULT 0 NOT NULL,
    partiallycorrectfeedback text NOT NULL,
    partiallycorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    incorrectfeedback text NOT NULL,
    incorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    shownumcorrect smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_question_ddwtos OWNER TO postgres;

--
-- Name: TABLE mdl_question_ddwtos; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_ddwtos IS 'Defines drag and drop (words into sentences) questions';


--
-- Name: mdl_question_ddwtos_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_ddwtos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_ddwtos_id_seq OWNER TO postgres;

--
-- Name: mdl_question_ddwtos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_ddwtos_id_seq OWNED BY public.mdl_question_ddwtos.id;


--
-- Name: mdl_question_gapselect; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_gapselect (
    id bigint NOT NULL,
    questionid bigint DEFAULT 0 NOT NULL,
    shuffleanswers smallint DEFAULT 1 NOT NULL,
    correctfeedback text NOT NULL,
    correctfeedbackformat smallint DEFAULT 0 NOT NULL,
    partiallycorrectfeedback text NOT NULL,
    partiallycorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    incorrectfeedback text NOT NULL,
    incorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    shownumcorrect smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_question_gapselect OWNER TO postgres;

--
-- Name: TABLE mdl_question_gapselect; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_gapselect IS 'Defines select missing words questions';


--
-- Name: mdl_question_gapselect_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_gapselect_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_gapselect_id_seq OWNER TO postgres;

--
-- Name: mdl_question_gapselect_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_gapselect_id_seq OWNED BY public.mdl_question_gapselect.id;


--
-- Name: mdl_question_hints; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_hints (
    id bigint NOT NULL,
    questionid bigint NOT NULL,
    hint text NOT NULL,
    hintformat smallint DEFAULT 0 NOT NULL,
    shownumcorrect smallint,
    clearwrong smallint,
    options character varying(255)
);


ALTER TABLE public.mdl_question_hints OWNER TO postgres;

--
-- Name: TABLE mdl_question_hints; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_hints IS 'Stores the the part of the question definition that gives different feedback after each try in interactive and similar behaviours.';


--
-- Name: mdl_question_hints_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_hints_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_hints_id_seq OWNER TO postgres;

--
-- Name: mdl_question_hints_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_hints_id_seq OWNED BY public.mdl_question_hints.id;


--
-- Name: mdl_question_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_id_seq OWNER TO postgres;

--
-- Name: mdl_question_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_id_seq OWNED BY public.mdl_question.id;


--
-- Name: mdl_question_multianswer; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_multianswer (
    id bigint NOT NULL,
    question bigint DEFAULT 0 NOT NULL,
    sequence text NOT NULL
);


ALTER TABLE public.mdl_question_multianswer OWNER TO postgres;

--
-- Name: TABLE mdl_question_multianswer; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_multianswer IS 'Options for multianswer questions';


--
-- Name: mdl_question_multianswer_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_multianswer_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_multianswer_id_seq OWNER TO postgres;

--
-- Name: mdl_question_multianswer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_multianswer_id_seq OWNED BY public.mdl_question_multianswer.id;


--
-- Name: mdl_question_numerical; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_numerical (
    id bigint NOT NULL,
    question bigint DEFAULT 0 NOT NULL,
    answer bigint DEFAULT 0 NOT NULL,
    tolerance character varying(255) DEFAULT '0.0'::character varying NOT NULL
);


ALTER TABLE public.mdl_question_numerical OWNER TO postgres;

--
-- Name: TABLE mdl_question_numerical; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_numerical IS 'Options for numerical questions.';


--
-- Name: mdl_question_numerical_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_numerical_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_numerical_id_seq OWNER TO postgres;

--
-- Name: mdl_question_numerical_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_numerical_id_seq OWNED BY public.mdl_question_numerical.id;


--
-- Name: mdl_question_numerical_options; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_numerical_options (
    id bigint NOT NULL,
    question bigint DEFAULT 0 NOT NULL,
    showunits smallint DEFAULT 0 NOT NULL,
    unitsleft smallint DEFAULT 0 NOT NULL,
    unitgradingtype smallint DEFAULT 0 NOT NULL,
    unitpenalty numeric(12,7) DEFAULT 0.1 NOT NULL
);


ALTER TABLE public.mdl_question_numerical_options OWNER TO postgres;

--
-- Name: TABLE mdl_question_numerical_options; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_numerical_options IS 'Options for questions of type numerical This table is also used by the calculated question type';


--
-- Name: mdl_question_numerical_options_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_numerical_options_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_numerical_options_id_seq OWNER TO postgres;

--
-- Name: mdl_question_numerical_options_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_numerical_options_id_seq OWNED BY public.mdl_question_numerical_options.id;


--
-- Name: mdl_question_numerical_units; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_numerical_units (
    id bigint NOT NULL,
    question bigint DEFAULT 0 NOT NULL,
    multiplier numeric(38,19) DEFAULT 1.00000000000000000000 NOT NULL,
    unit character varying(50) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_question_numerical_units OWNER TO postgres;

--
-- Name: TABLE mdl_question_numerical_units; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_numerical_units IS 'Optional unit options for numerical questions. This table is also used by the calculated question type.';


--
-- Name: mdl_question_numerical_units_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_numerical_units_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_numerical_units_id_seq OWNER TO postgres;

--
-- Name: mdl_question_numerical_units_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_numerical_units_id_seq OWNED BY public.mdl_question_numerical_units.id;


--
-- Name: mdl_question_response_analysis; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_response_analysis (
    id bigint NOT NULL,
    hashcode character varying(40) DEFAULT ''::character varying NOT NULL,
    whichtries character varying(255) DEFAULT ''::character varying NOT NULL,
    timemodified bigint NOT NULL,
    questionid bigint NOT NULL,
    variant bigint,
    subqid character varying(100) DEFAULT ''::character varying NOT NULL,
    aid character varying(100),
    response text,
    credit numeric(15,5) NOT NULL
);


ALTER TABLE public.mdl_question_response_analysis OWNER TO postgres;

--
-- Name: TABLE mdl_question_response_analysis; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_response_analysis IS 'Analysis of student responses given to questions.';


--
-- Name: mdl_question_response_analysis_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_response_analysis_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_response_analysis_id_seq OWNER TO postgres;

--
-- Name: mdl_question_response_analysis_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_response_analysis_id_seq OWNED BY public.mdl_question_response_analysis.id;


--
-- Name: mdl_question_response_count; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_response_count (
    id bigint NOT NULL,
    analysisid bigint NOT NULL,
    try bigint NOT NULL,
    rcount bigint NOT NULL
);


ALTER TABLE public.mdl_question_response_count OWNER TO postgres;

--
-- Name: TABLE mdl_question_response_count; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_response_count IS 'Count for each responses for each try at a question.';


--
-- Name: mdl_question_response_count_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_response_count_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_response_count_id_seq OWNER TO postgres;

--
-- Name: mdl_question_response_count_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_response_count_id_seq OWNED BY public.mdl_question_response_count.id;


--
-- Name: mdl_question_statistics; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_statistics (
    id bigint NOT NULL,
    hashcode character varying(40) DEFAULT ''::character varying NOT NULL,
    timemodified bigint NOT NULL,
    questionid bigint NOT NULL,
    slot bigint,
    subquestion smallint NOT NULL,
    variant bigint,
    s bigint DEFAULT 0 NOT NULL,
    effectiveweight numeric(15,5),
    negcovar smallint DEFAULT 0 NOT NULL,
    discriminationindex numeric(15,5),
    discriminativeefficiency numeric(15,5),
    sd numeric(15,10),
    facility numeric(15,10),
    subquestions text,
    maxmark numeric(12,7),
    positions text,
    randomguessscore numeric(12,7)
);


ALTER TABLE public.mdl_question_statistics OWNER TO postgres;

--
-- Name: TABLE mdl_question_statistics; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_statistics IS 'Statistics for individual questions used in an activity.';


--
-- Name: mdl_question_statistics_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_statistics_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_statistics_id_seq OWNER TO postgres;

--
-- Name: mdl_question_statistics_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_statistics_id_seq OWNED BY public.mdl_question_statistics.id;


--
-- Name: mdl_question_truefalse; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_truefalse (
    id bigint NOT NULL,
    question bigint DEFAULT 0 NOT NULL,
    trueanswer bigint DEFAULT 0 NOT NULL,
    falseanswer bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_question_truefalse OWNER TO postgres;

--
-- Name: TABLE mdl_question_truefalse; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_truefalse IS 'Options for True-False questions';


--
-- Name: mdl_question_truefalse_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_truefalse_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_truefalse_id_seq OWNER TO postgres;

--
-- Name: mdl_question_truefalse_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_truefalse_id_seq OWNED BY public.mdl_question_truefalse.id;


--
-- Name: mdl_question_usages; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_usages (
    id bigint NOT NULL,
    contextid bigint NOT NULL,
    component character varying(255) DEFAULT ''::character varying NOT NULL,
    preferredbehaviour character varying(32) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_question_usages OWNER TO postgres;

--
-- Name: TABLE mdl_question_usages; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_usages IS 'This table''s main purpose it to assign a unique id to each attempt at a set of questions by some part of Moodle. A question usage is made up of a number of question_attempts.';


--
-- Name: mdl_question_usages_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_usages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_usages_id_seq OWNER TO postgres;

--
-- Name: mdl_question_usages_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_usages_id_seq OWNED BY public.mdl_question_usages.id;


--
-- Name: mdl_quiz; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_quiz (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text NOT NULL,
    introformat smallint DEFAULT 0 NOT NULL,
    timeopen bigint DEFAULT 0 NOT NULL,
    timeclose bigint DEFAULT 0 NOT NULL,
    timelimit bigint DEFAULT 0 NOT NULL,
    overduehandling character varying(16) DEFAULT 'autoabandon'::character varying NOT NULL,
    graceperiod bigint DEFAULT 0 NOT NULL,
    preferredbehaviour character varying(32) DEFAULT ''::character varying NOT NULL,
    canredoquestions smallint DEFAULT 0 NOT NULL,
    attempts integer DEFAULT 0 NOT NULL,
    attemptonlast smallint DEFAULT 0 NOT NULL,
    grademethod smallint DEFAULT 1 NOT NULL,
    decimalpoints smallint DEFAULT 2 NOT NULL,
    questiondecimalpoints smallint DEFAULT '-1'::integer NOT NULL,
    reviewattempt integer DEFAULT 0 NOT NULL,
    reviewcorrectness integer DEFAULT 0 NOT NULL,
    reviewmarks integer DEFAULT 0 NOT NULL,
    reviewspecificfeedback integer DEFAULT 0 NOT NULL,
    reviewgeneralfeedback integer DEFAULT 0 NOT NULL,
    reviewrightanswer integer DEFAULT 0 NOT NULL,
    reviewoverallfeedback integer DEFAULT 0 NOT NULL,
    questionsperpage bigint DEFAULT 0 NOT NULL,
    navmethod character varying(16) DEFAULT 'free'::character varying NOT NULL,
    shuffleanswers smallint DEFAULT 0 NOT NULL,
    sumgrades numeric(10,5) DEFAULT 0 NOT NULL,
    grade numeric(10,5) DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    password character varying(255) DEFAULT ''::character varying NOT NULL,
    subnet character varying(255) DEFAULT ''::character varying NOT NULL,
    browsersecurity character varying(32) DEFAULT ''::character varying NOT NULL,
    delay1 bigint DEFAULT 0 NOT NULL,
    delay2 bigint DEFAULT 0 NOT NULL,
    showuserpicture smallint DEFAULT 0 NOT NULL,
    showblocks smallint DEFAULT 0 NOT NULL,
    completionattemptsexhausted smallint DEFAULT 0,
    completionpass smallint DEFAULT 0,
    allowofflineattempts smallint DEFAULT 0
);


ALTER TABLE public.mdl_quiz OWNER TO postgres;

--
-- Name: TABLE mdl_quiz; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_quiz IS 'The settings for each quiz.';


--
-- Name: mdl_quiz_attempts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_quiz_attempts (
    id bigint NOT NULL,
    quiz bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    attempt integer DEFAULT 0 NOT NULL,
    uniqueid bigint DEFAULT 0 NOT NULL,
    layout text NOT NULL,
    currentpage bigint DEFAULT 0 NOT NULL,
    preview smallint DEFAULT 0 NOT NULL,
    state character varying(16) DEFAULT 'inprogress'::character varying NOT NULL,
    timestart bigint DEFAULT 0 NOT NULL,
    timefinish bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    timemodifiedoffline bigint DEFAULT 0 NOT NULL,
    timecheckstate bigint DEFAULT 0,
    sumgrades numeric(10,5)
);


ALTER TABLE public.mdl_quiz_attempts OWNER TO postgres;

--
-- Name: TABLE mdl_quiz_attempts; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_quiz_attempts IS 'Stores users attempts at quizzes.';


--
-- Name: mdl_quiz_attempts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_attempts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_attempts_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_attempts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_quiz_attempts_id_seq OWNED BY public.mdl_quiz_attempts.id;


--
-- Name: mdl_quiz_feedback; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_quiz_feedback (
    id bigint NOT NULL,
    quizid bigint DEFAULT 0 NOT NULL,
    feedbacktext text NOT NULL,
    feedbacktextformat smallint DEFAULT 0 NOT NULL,
    mingrade numeric(10,5) DEFAULT 0 NOT NULL,
    maxgrade numeric(10,5) DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_quiz_feedback OWNER TO postgres;

--
-- Name: TABLE mdl_quiz_feedback; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_quiz_feedback IS 'Feedback given to students based on which grade band their overall score lies.';


--
-- Name: mdl_quiz_feedback_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_feedback_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_feedback_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_feedback_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_quiz_feedback_id_seq OWNED BY public.mdl_quiz_feedback.id;


--
-- Name: mdl_quiz_grades; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_quiz_grades (
    id bigint NOT NULL,
    quiz bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    grade numeric(10,5) DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_quiz_grades OWNER TO postgres;

--
-- Name: TABLE mdl_quiz_grades; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_quiz_grades IS 'Stores the overall grade for each user on the quiz, based on their various attempts and the quiz.grademethod setting.';


--
-- Name: mdl_quiz_grades_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_grades_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_grades_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_grades_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_quiz_grades_id_seq OWNED BY public.mdl_quiz_grades.id;


--
-- Name: mdl_quiz_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_quiz_id_seq OWNED BY public.mdl_quiz.id;


--
-- Name: mdl_quiz_overrides; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_quiz_overrides (
    id bigint NOT NULL,
    quiz bigint DEFAULT 0 NOT NULL,
    groupid bigint,
    userid bigint,
    timeopen bigint,
    timeclose bigint,
    timelimit bigint,
    attempts integer,
    password character varying(255)
);


ALTER TABLE public.mdl_quiz_overrides OWNER TO postgres;

--
-- Name: TABLE mdl_quiz_overrides; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_quiz_overrides IS 'The overrides to quiz settings on a per-user and per-group basis.';


--
-- Name: mdl_quiz_overrides_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_overrides_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_overrides_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_overrides_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_quiz_overrides_id_seq OWNED BY public.mdl_quiz_overrides.id;


--
-- Name: mdl_quiz_overview_regrades; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_quiz_overview_regrades (
    id bigint NOT NULL,
    questionusageid bigint NOT NULL,
    slot bigint NOT NULL,
    newfraction numeric(12,7),
    oldfraction numeric(12,7),
    regraded smallint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_quiz_overview_regrades OWNER TO postgres;

--
-- Name: TABLE mdl_quiz_overview_regrades; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_quiz_overview_regrades IS 'This table records which question attempts need regrading and the grade they will be regraded to.';


--
-- Name: mdl_quiz_overview_regrades_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_overview_regrades_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_overview_regrades_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_overview_regrades_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_quiz_overview_regrades_id_seq OWNED BY public.mdl_quiz_overview_regrades.id;


--
-- Name: mdl_quiz_reports; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_quiz_reports (
    id bigint NOT NULL,
    name character varying(255),
    displayorder bigint NOT NULL,
    capability character varying(255)
);


ALTER TABLE public.mdl_quiz_reports OWNER TO postgres;

--
-- Name: TABLE mdl_quiz_reports; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_quiz_reports IS 'Lists all the installed quiz reports and their display order and so on. No need to worry about deleting old records. Only records with an equivalent directory are displayed.';


--
-- Name: mdl_quiz_reports_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_reports_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_reports_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_reports_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_quiz_reports_id_seq OWNED BY public.mdl_quiz_reports.id;


--
-- Name: mdl_quiz_sections; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_quiz_sections (
    id bigint NOT NULL,
    quizid bigint NOT NULL,
    firstslot bigint NOT NULL,
    heading character varying(1333),
    shufflequestions smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_quiz_sections OWNER TO postgres;

--
-- Name: TABLE mdl_quiz_sections; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_quiz_sections IS 'Stores sections of a quiz with section name (heading), from slot-number N and whether the question order should be shuffled.';


--
-- Name: mdl_quiz_sections_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_sections_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_sections_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_sections_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_quiz_sections_id_seq OWNED BY public.mdl_quiz_sections.id;


--
-- Name: mdl_quiz_slot_tags; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_quiz_slot_tags (
    id bigint NOT NULL,
    slotid bigint,
    tagid bigint,
    tagname character varying(255)
);


ALTER TABLE public.mdl_quiz_slot_tags OWNER TO postgres;

--
-- Name: TABLE mdl_quiz_slot_tags; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_quiz_slot_tags IS 'Stores data about the tags that a question must have so that it can be selected for a quiz slot (when having a random question by tags on that slot).';


--
-- Name: mdl_quiz_slot_tags_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_slot_tags_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_slot_tags_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_slot_tags_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_quiz_slot_tags_id_seq OWNED BY public.mdl_quiz_slot_tags.id;


--
-- Name: mdl_quiz_slots; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_quiz_slots (
    id bigint NOT NULL,
    slot bigint NOT NULL,
    quizid bigint DEFAULT 0 NOT NULL,
    page bigint NOT NULL,
    requireprevious smallint DEFAULT 0 NOT NULL,
    questionid bigint DEFAULT 0 NOT NULL,
    questioncategoryid bigint,
    includingsubcategories smallint,
    maxmark numeric(12,7) DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_quiz_slots OWNER TO postgres;

--
-- Name: TABLE mdl_quiz_slots; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_quiz_slots IS 'Stores the question used in a quiz, with the order, and for each question, which page it appears on, and the maximum mark (weight).';


--
-- Name: mdl_quiz_slots_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_slots_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_slots_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_slots_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_quiz_slots_id_seq OWNED BY public.mdl_quiz_slots.id;


--
-- Name: mdl_quiz_statistics; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_quiz_statistics (
    id bigint NOT NULL,
    hashcode character varying(40) DEFAULT ''::character varying NOT NULL,
    whichattempts smallint NOT NULL,
    timemodified bigint NOT NULL,
    firstattemptscount bigint NOT NULL,
    highestattemptscount bigint NOT NULL,
    lastattemptscount bigint NOT NULL,
    allattemptscount bigint NOT NULL,
    firstattemptsavg numeric(15,5),
    highestattemptsavg numeric(15,5),
    lastattemptsavg numeric(15,5),
    allattemptsavg numeric(15,5),
    median numeric(15,5),
    standarddeviation numeric(15,5),
    skewness numeric(15,10),
    kurtosis numeric(15,5),
    cic numeric(15,10),
    errorratio numeric(15,10),
    standarderror numeric(15,10)
);


ALTER TABLE public.mdl_quiz_statistics OWNER TO postgres;

--
-- Name: TABLE mdl_quiz_statistics; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_quiz_statistics IS 'table to cache results from analysis done in statistics report for quizzes.';


--
-- Name: mdl_quiz_statistics_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_statistics_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_statistics_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_statistics_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_quiz_statistics_id_seq OWNED BY public.mdl_quiz_statistics.id;


--
-- Name: mdl_rating; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_rating (
    id bigint NOT NULL,
    contextid bigint NOT NULL,
    component character varying(100) DEFAULT ''::character varying NOT NULL,
    ratingarea character varying(50) DEFAULT ''::character varying NOT NULL,
    itemid bigint NOT NULL,
    scaleid bigint NOT NULL,
    rating bigint NOT NULL,
    userid bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_rating OWNER TO postgres;

--
-- Name: TABLE mdl_rating; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_rating IS 'moodle ratings';


--
-- Name: mdl_rating_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_rating_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_rating_id_seq OWNER TO postgres;

--
-- Name: mdl_rating_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_rating_id_seq OWNED BY public.mdl_rating.id;


--
-- Name: mdl_registration_hubs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_registration_hubs (
    id bigint NOT NULL,
    token character varying(255) DEFAULT ''::character varying NOT NULL,
    hubname character varying(255) DEFAULT ''::character varying NOT NULL,
    huburl character varying(255) DEFAULT ''::character varying NOT NULL,
    confirmed smallint DEFAULT 0 NOT NULL,
    secret character varying(255),
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_registration_hubs OWNER TO postgres;

--
-- Name: TABLE mdl_registration_hubs; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_registration_hubs IS 'hub where the site is registered on with their associated token';


--
-- Name: mdl_registration_hubs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_registration_hubs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_registration_hubs_id_seq OWNER TO postgres;

--
-- Name: mdl_registration_hubs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_registration_hubs_id_seq OWNED BY public.mdl_registration_hubs.id;


--
-- Name: mdl_repository; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_repository (
    id bigint NOT NULL,
    type character varying(255) DEFAULT ''::character varying NOT NULL,
    visible smallint DEFAULT 1,
    sortorder bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_repository OWNER TO postgres;

--
-- Name: TABLE mdl_repository; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_repository IS 'This table contains one entry for every configured external repository instance.';


--
-- Name: mdl_repository_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_repository_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_repository_id_seq OWNER TO postgres;

--
-- Name: mdl_repository_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_repository_id_seq OWNED BY public.mdl_repository.id;


--
-- Name: mdl_repository_instance_config; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_repository_instance_config (
    id bigint NOT NULL,
    instanceid bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    value text
);


ALTER TABLE public.mdl_repository_instance_config OWNER TO postgres;

--
-- Name: TABLE mdl_repository_instance_config; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_repository_instance_config IS 'The config for intances';


--
-- Name: mdl_repository_instance_config_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_repository_instance_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_repository_instance_config_id_seq OWNER TO postgres;

--
-- Name: mdl_repository_instance_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_repository_instance_config_id_seq OWNED BY public.mdl_repository_instance_config.id;


--
-- Name: mdl_repository_instances; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_repository_instances (
    id bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    typeid bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    contextid bigint NOT NULL,
    username character varying(255),
    password character varying(255),
    timecreated bigint,
    timemodified bigint,
    readonly smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_repository_instances OWNER TO postgres;

--
-- Name: TABLE mdl_repository_instances; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_repository_instances IS 'This table contains one entry for every configured external repository instance.';


--
-- Name: mdl_repository_instances_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_repository_instances_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_repository_instances_id_seq OWNER TO postgres;

--
-- Name: mdl_repository_instances_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_repository_instances_id_seq OWNED BY public.mdl_repository_instances.id;


--
-- Name: mdl_repository_onedrive_access; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_repository_onedrive_access (
    id bigint NOT NULL,
    timemodified bigint NOT NULL,
    timecreated bigint NOT NULL,
    usermodified bigint NOT NULL,
    permissionid character varying(255) DEFAULT ''::character varying NOT NULL,
    itemid character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_repository_onedrive_access OWNER TO postgres;

--
-- Name: TABLE mdl_repository_onedrive_access; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_repository_onedrive_access IS 'List of temporary access grants.';


--
-- Name: mdl_repository_onedrive_access_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_repository_onedrive_access_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_repository_onedrive_access_id_seq OWNER TO postgres;

--
-- Name: mdl_repository_onedrive_access_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_repository_onedrive_access_id_seq OWNED BY public.mdl_repository_onedrive_access.id;


--
-- Name: mdl_resource; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_resource (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text,
    introformat smallint DEFAULT 0 NOT NULL,
    tobemigrated smallint DEFAULT 0 NOT NULL,
    legacyfiles smallint DEFAULT 0 NOT NULL,
    legacyfileslast bigint,
    display smallint DEFAULT 0 NOT NULL,
    displayoptions text,
    filterfiles smallint DEFAULT 0 NOT NULL,
    revision bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_resource OWNER TO postgres;

--
-- Name: TABLE mdl_resource; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_resource IS 'Each record is one resource and its config data';


--
-- Name: mdl_resource_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_resource_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_resource_id_seq OWNER TO postgres;

--
-- Name: mdl_resource_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_resource_id_seq OWNED BY public.mdl_resource.id;


--
-- Name: mdl_resource_old; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_resource_old (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    type character varying(30) DEFAULT ''::character varying NOT NULL,
    reference character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text,
    introformat smallint DEFAULT 0 NOT NULL,
    alltext text NOT NULL,
    popup text NOT NULL,
    options character varying(255) DEFAULT ''::character varying NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    oldid bigint NOT NULL,
    cmid bigint,
    newmodule character varying(50),
    newid bigint,
    migrated bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_resource_old OWNER TO postgres;

--
-- Name: TABLE mdl_resource_old; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_resource_old IS 'backup of all old resource instances from 1.9';


--
-- Name: mdl_resource_old_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_resource_old_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_resource_old_id_seq OWNER TO postgres;

--
-- Name: mdl_resource_old_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_resource_old_id_seq OWNED BY public.mdl_resource_old.id;


--
-- Name: mdl_role; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_role (
    id bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    shortname character varying(100) DEFAULT ''::character varying NOT NULL,
    description text NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL,
    archetype character varying(30) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_role OWNER TO postgres;

--
-- Name: TABLE mdl_role; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_role IS 'moodle roles';


--
-- Name: mdl_role_allow_assign; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_role_allow_assign (
    id bigint NOT NULL,
    roleid bigint DEFAULT 0 NOT NULL,
    allowassign bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_role_allow_assign OWNER TO postgres;

--
-- Name: TABLE mdl_role_allow_assign; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_role_allow_assign IS 'this defines what role can assign what role';


--
-- Name: mdl_role_allow_assign_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_allow_assign_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_allow_assign_id_seq OWNER TO postgres;

--
-- Name: mdl_role_allow_assign_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_role_allow_assign_id_seq OWNED BY public.mdl_role_allow_assign.id;


--
-- Name: mdl_role_allow_override; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_role_allow_override (
    id bigint NOT NULL,
    roleid bigint DEFAULT 0 NOT NULL,
    allowoverride bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_role_allow_override OWNER TO postgres;

--
-- Name: TABLE mdl_role_allow_override; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_role_allow_override IS 'this defines what role can override what role';


--
-- Name: mdl_role_allow_override_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_allow_override_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_allow_override_id_seq OWNER TO postgres;

--
-- Name: mdl_role_allow_override_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_role_allow_override_id_seq OWNED BY public.mdl_role_allow_override.id;


--
-- Name: mdl_role_allow_switch; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_role_allow_switch (
    id bigint NOT NULL,
    roleid bigint NOT NULL,
    allowswitch bigint NOT NULL
);


ALTER TABLE public.mdl_role_allow_switch OWNER TO postgres;

--
-- Name: TABLE mdl_role_allow_switch; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_role_allow_switch IS 'This table stores which which other roles a user is allowed to switch to if they have one role.';


--
-- Name: mdl_role_allow_switch_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_allow_switch_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_allow_switch_id_seq OWNER TO postgres;

--
-- Name: mdl_role_allow_switch_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_role_allow_switch_id_seq OWNED BY public.mdl_role_allow_switch.id;


--
-- Name: mdl_role_allow_view; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_role_allow_view (
    id bigint NOT NULL,
    roleid bigint NOT NULL,
    allowview bigint NOT NULL
);


ALTER TABLE public.mdl_role_allow_view OWNER TO postgres;

--
-- Name: TABLE mdl_role_allow_view; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_role_allow_view IS 'This table stores which which other roles a user is allowed to view to if they have one role.';


--
-- Name: mdl_role_allow_view_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_allow_view_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_allow_view_id_seq OWNER TO postgres;

--
-- Name: mdl_role_allow_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_role_allow_view_id_seq OWNED BY public.mdl_role_allow_view.id;


--
-- Name: mdl_role_assignments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_role_assignments (
    id bigint NOT NULL,
    roleid bigint DEFAULT 0 NOT NULL,
    contextid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    modifierid bigint DEFAULT 0 NOT NULL,
    component character varying(100) DEFAULT ''::character varying NOT NULL,
    itemid bigint DEFAULT 0 NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_role_assignments OWNER TO postgres;

--
-- Name: TABLE mdl_role_assignments; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_role_assignments IS 'assigning roles in different context';


--
-- Name: mdl_role_assignments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_assignments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_assignments_id_seq OWNER TO postgres;

--
-- Name: mdl_role_assignments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_role_assignments_id_seq OWNED BY public.mdl_role_assignments.id;


--
-- Name: mdl_role_capabilities; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_role_capabilities (
    id bigint NOT NULL,
    contextid bigint DEFAULT 0 NOT NULL,
    roleid bigint DEFAULT 0 NOT NULL,
    capability character varying(255) DEFAULT ''::character varying NOT NULL,
    permission bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    modifierid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_role_capabilities OWNER TO postgres;

--
-- Name: TABLE mdl_role_capabilities; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_role_capabilities IS 'permission has to be signed, overriding a capability for a particular role in a particular context';


--
-- Name: mdl_role_capabilities_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_capabilities_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_capabilities_id_seq OWNER TO postgres;

--
-- Name: mdl_role_capabilities_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_role_capabilities_id_seq OWNED BY public.mdl_role_capabilities.id;


--
-- Name: mdl_role_context_levels; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_role_context_levels (
    id bigint NOT NULL,
    roleid bigint NOT NULL,
    contextlevel bigint NOT NULL
);


ALTER TABLE public.mdl_role_context_levels OWNER TO postgres;

--
-- Name: TABLE mdl_role_context_levels; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_role_context_levels IS 'Lists which roles can be assigned at which context levels. The assignment is allowed in the corresponding row is present in this table.';


--
-- Name: mdl_role_context_levels_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_context_levels_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_context_levels_id_seq OWNER TO postgres;

--
-- Name: mdl_role_context_levels_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_role_context_levels_id_seq OWNED BY public.mdl_role_context_levels.id;


--
-- Name: mdl_role_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_id_seq OWNER TO postgres;

--
-- Name: mdl_role_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_role_id_seq OWNED BY public.mdl_role.id;


--
-- Name: mdl_role_names; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_role_names (
    id bigint NOT NULL,
    roleid bigint DEFAULT 0 NOT NULL,
    contextid bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_role_names OWNER TO postgres;

--
-- Name: TABLE mdl_role_names; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_role_names IS 'role names in native strings';


--
-- Name: mdl_role_names_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_names_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_names_id_seq OWNER TO postgres;

--
-- Name: mdl_role_names_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_role_names_id_seq OWNED BY public.mdl_role_names.id;


--
-- Name: mdl_scale; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_scale (
    id bigint NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    scale text NOT NULL,
    description text NOT NULL,
    descriptionformat smallint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_scale OWNER TO postgres;

--
-- Name: TABLE mdl_scale; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_scale IS 'Defines grading scales';


--
-- Name: mdl_scale_history; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_scale_history (
    id bigint NOT NULL,
    action bigint DEFAULT 0 NOT NULL,
    oldid bigint NOT NULL,
    source character varying(255),
    timemodified bigint,
    loggeduser bigint,
    courseid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    scale text NOT NULL,
    description text NOT NULL
);


ALTER TABLE public.mdl_scale_history OWNER TO postgres;

--
-- Name: TABLE mdl_scale_history; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_scale_history IS 'History table';


--
-- Name: mdl_scale_history_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scale_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scale_history_id_seq OWNER TO postgres;

--
-- Name: mdl_scale_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_scale_history_id_seq OWNED BY public.mdl_scale_history.id;


--
-- Name: mdl_scale_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scale_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scale_id_seq OWNER TO postgres;

--
-- Name: mdl_scale_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_scale_id_seq OWNED BY public.mdl_scale.id;


--
-- Name: mdl_scorm; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_scorm (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    scormtype character varying(50) DEFAULT 'local'::character varying NOT NULL,
    reference character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text NOT NULL,
    introformat smallint DEFAULT 0 NOT NULL,
    version character varying(9) DEFAULT ''::character varying NOT NULL,
    maxgrade double precision DEFAULT 0 NOT NULL,
    grademethod smallint DEFAULT 0 NOT NULL,
    whatgrade bigint DEFAULT 0 NOT NULL,
    maxattempt bigint DEFAULT 1 NOT NULL,
    forcecompleted smallint DEFAULT 0 NOT NULL,
    forcenewattempt smallint DEFAULT 0 NOT NULL,
    lastattemptlock smallint DEFAULT 0 NOT NULL,
    masteryoverride smallint DEFAULT 1 NOT NULL,
    displayattemptstatus smallint DEFAULT 1 NOT NULL,
    displaycoursestructure smallint DEFAULT 0 NOT NULL,
    updatefreq smallint DEFAULT 0 NOT NULL,
    sha1hash character varying(40),
    md5hash character varying(32) DEFAULT ''::character varying NOT NULL,
    revision bigint DEFAULT 0 NOT NULL,
    launch bigint DEFAULT 0 NOT NULL,
    skipview smallint DEFAULT 1 NOT NULL,
    hidebrowse smallint DEFAULT 0 NOT NULL,
    hidetoc smallint DEFAULT 0 NOT NULL,
    nav smallint DEFAULT 1 NOT NULL,
    navpositionleft bigint DEFAULT '-100'::integer,
    navpositiontop bigint DEFAULT '-100'::integer,
    auto smallint DEFAULT 0 NOT NULL,
    popup smallint DEFAULT 0 NOT NULL,
    options character varying(255) DEFAULT ''::character varying NOT NULL,
    width bigint DEFAULT 100 NOT NULL,
    height bigint DEFAULT 600 NOT NULL,
    timeopen bigint DEFAULT 0 NOT NULL,
    timeclose bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    completionstatusrequired smallint,
    completionscorerequired bigint,
    completionstatusallscos smallint,
    displayactivityname smallint DEFAULT 1 NOT NULL,
    autocommit smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_scorm OWNER TO postgres;

--
-- Name: TABLE mdl_scorm; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_scorm IS 'each table is one SCORM module and its configuration';


--
-- Name: mdl_scorm_aicc_session; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_scorm_aicc_session (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    scormid bigint DEFAULT 0 NOT NULL,
    hacpsession character varying(255) DEFAULT ''::character varying NOT NULL,
    scoid bigint DEFAULT 0,
    scormmode character varying(50),
    scormstatus character varying(255),
    attempt bigint,
    lessonstatus character varying(255),
    sessiontime character varying(255),
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_scorm_aicc_session OWNER TO postgres;

--
-- Name: TABLE mdl_scorm_aicc_session; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_scorm_aicc_session IS 'Used by AICC HACP to store session information';


--
-- Name: mdl_scorm_aicc_session_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_aicc_session_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_aicc_session_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_aicc_session_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_scorm_aicc_session_id_seq OWNED BY public.mdl_scorm_aicc_session.id;


--
-- Name: mdl_scorm_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_scorm_id_seq OWNED BY public.mdl_scorm.id;


--
-- Name: mdl_scorm_scoes; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_scorm_scoes (
    id bigint NOT NULL,
    scorm bigint DEFAULT 0 NOT NULL,
    manifest character varying(255) DEFAULT ''::character varying NOT NULL,
    organization character varying(255) DEFAULT ''::character varying NOT NULL,
    parent character varying(255) DEFAULT ''::character varying NOT NULL,
    identifier character varying(255) DEFAULT ''::character varying NOT NULL,
    launch text NOT NULL,
    scormtype character varying(5) DEFAULT ''::character varying NOT NULL,
    title character varying(255) DEFAULT ''::character varying NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_scorm_scoes OWNER TO postgres;

--
-- Name: TABLE mdl_scorm_scoes; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_scorm_scoes IS 'each SCO part of the SCORM module';


--
-- Name: mdl_scorm_scoes_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_scorm_scoes_data (
    id bigint NOT NULL,
    scoid bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    value text NOT NULL
);


ALTER TABLE public.mdl_scorm_scoes_data OWNER TO postgres;

--
-- Name: TABLE mdl_scorm_scoes_data; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_scorm_scoes_data IS 'Contains variable data get from packages';


--
-- Name: mdl_scorm_scoes_data_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_scoes_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_scoes_data_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_scoes_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_scorm_scoes_data_id_seq OWNED BY public.mdl_scorm_scoes_data.id;


--
-- Name: mdl_scorm_scoes_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_scoes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_scoes_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_scoes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_scorm_scoes_id_seq OWNED BY public.mdl_scorm_scoes.id;


--
-- Name: mdl_scorm_scoes_track; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_scorm_scoes_track (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    scormid bigint DEFAULT 0 NOT NULL,
    scoid bigint DEFAULT 0 NOT NULL,
    attempt bigint DEFAULT 1 NOT NULL,
    element character varying(255) DEFAULT ''::character varying NOT NULL,
    value text NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_scorm_scoes_track OWNER TO postgres;

--
-- Name: TABLE mdl_scorm_scoes_track; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_scorm_scoes_track IS 'to track SCOes';


--
-- Name: mdl_scorm_scoes_track_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_scoes_track_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_scoes_track_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_scoes_track_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_scorm_scoes_track_id_seq OWNED BY public.mdl_scorm_scoes_track.id;


--
-- Name: mdl_scorm_seq_mapinfo; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_scorm_seq_mapinfo (
    id bigint NOT NULL,
    scoid bigint DEFAULT 0 NOT NULL,
    objectiveid bigint DEFAULT 0 NOT NULL,
    targetobjectiveid bigint DEFAULT 0 NOT NULL,
    readsatisfiedstatus smallint DEFAULT 1 NOT NULL,
    readnormalizedmeasure smallint DEFAULT 1 NOT NULL,
    writesatisfiedstatus smallint DEFAULT 0 NOT NULL,
    writenormalizedmeasure smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_scorm_seq_mapinfo OWNER TO postgres;

--
-- Name: TABLE mdl_scorm_seq_mapinfo; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_scorm_seq_mapinfo IS 'SCORM2004 objective mapinfo description';


--
-- Name: mdl_scorm_seq_mapinfo_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_seq_mapinfo_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_seq_mapinfo_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_seq_mapinfo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_scorm_seq_mapinfo_id_seq OWNED BY public.mdl_scorm_seq_mapinfo.id;


--
-- Name: mdl_scorm_seq_objective; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_scorm_seq_objective (
    id bigint NOT NULL,
    scoid bigint DEFAULT 0 NOT NULL,
    primaryobj smallint DEFAULT 0 NOT NULL,
    objectiveid character varying(255) DEFAULT ''::character varying NOT NULL,
    satisfiedbymeasure smallint DEFAULT 1 NOT NULL,
    minnormalizedmeasure real DEFAULT 0.0000 NOT NULL
);


ALTER TABLE public.mdl_scorm_seq_objective OWNER TO postgres;

--
-- Name: TABLE mdl_scorm_seq_objective; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_scorm_seq_objective IS 'SCORM2004 objective description';


--
-- Name: mdl_scorm_seq_objective_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_seq_objective_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_seq_objective_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_seq_objective_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_scorm_seq_objective_id_seq OWNED BY public.mdl_scorm_seq_objective.id;


--
-- Name: mdl_scorm_seq_rolluprule; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_scorm_seq_rolluprule (
    id bigint NOT NULL,
    scoid bigint DEFAULT 0 NOT NULL,
    childactivityset character varying(15) DEFAULT ''::character varying NOT NULL,
    minimumcount bigint DEFAULT 0 NOT NULL,
    minimumpercent real DEFAULT 0.0000 NOT NULL,
    conditioncombination character varying(3) DEFAULT 'all'::character varying NOT NULL,
    action character varying(15) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_scorm_seq_rolluprule OWNER TO postgres;

--
-- Name: TABLE mdl_scorm_seq_rolluprule; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_scorm_seq_rolluprule IS 'SCORM2004 sequencing rule';


--
-- Name: mdl_scorm_seq_rolluprule_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_seq_rolluprule_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_seq_rolluprule_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_seq_rolluprule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_scorm_seq_rolluprule_id_seq OWNED BY public.mdl_scorm_seq_rolluprule.id;


--
-- Name: mdl_scorm_seq_rolluprulecond; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_scorm_seq_rolluprulecond (
    id bigint NOT NULL,
    scoid bigint DEFAULT 0 NOT NULL,
    rollupruleid bigint DEFAULT 0 NOT NULL,
    operator character varying(5) DEFAULT 'noOp'::character varying NOT NULL,
    cond character varying(25) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_scorm_seq_rolluprulecond OWNER TO postgres;

--
-- Name: TABLE mdl_scorm_seq_rolluprulecond; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_scorm_seq_rolluprulecond IS 'SCORM2004 sequencing rule';


--
-- Name: mdl_scorm_seq_rolluprulecond_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_seq_rolluprulecond_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_seq_rolluprulecond_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_seq_rolluprulecond_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_scorm_seq_rolluprulecond_id_seq OWNED BY public.mdl_scorm_seq_rolluprulecond.id;


--
-- Name: mdl_scorm_seq_rulecond; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_scorm_seq_rulecond (
    id bigint NOT NULL,
    scoid bigint DEFAULT 0 NOT NULL,
    ruleconditionsid bigint DEFAULT 0 NOT NULL,
    refrencedobjective character varying(255) DEFAULT ''::character varying NOT NULL,
    measurethreshold real DEFAULT 0.0000 NOT NULL,
    operator character varying(5) DEFAULT 'noOp'::character varying NOT NULL,
    cond character varying(30) DEFAULT 'always'::character varying NOT NULL
);


ALTER TABLE public.mdl_scorm_seq_rulecond OWNER TO postgres;

--
-- Name: TABLE mdl_scorm_seq_rulecond; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_scorm_seq_rulecond IS 'SCORM2004 rule condition';


--
-- Name: mdl_scorm_seq_rulecond_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_seq_rulecond_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_seq_rulecond_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_seq_rulecond_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_scorm_seq_rulecond_id_seq OWNED BY public.mdl_scorm_seq_rulecond.id;


--
-- Name: mdl_scorm_seq_ruleconds; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_scorm_seq_ruleconds (
    id bigint NOT NULL,
    scoid bigint DEFAULT 0 NOT NULL,
    conditioncombination character varying(3) DEFAULT 'all'::character varying NOT NULL,
    ruletype smallint DEFAULT 0 NOT NULL,
    action character varying(25) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_scorm_seq_ruleconds OWNER TO postgres;

--
-- Name: TABLE mdl_scorm_seq_ruleconds; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_scorm_seq_ruleconds IS 'SCORM2004 rule conditions';


--
-- Name: mdl_scorm_seq_ruleconds_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_seq_ruleconds_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_seq_ruleconds_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_seq_ruleconds_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_scorm_seq_ruleconds_id_seq OWNED BY public.mdl_scorm_seq_ruleconds.id;


--
-- Name: mdl_search_index_requests; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_search_index_requests (
    id bigint NOT NULL,
    contextid bigint NOT NULL,
    searcharea character varying(255) DEFAULT ''::character varying NOT NULL,
    timerequested bigint NOT NULL,
    partialarea character varying(255) DEFAULT ''::character varying NOT NULL,
    partialtime bigint NOT NULL,
    indexpriority bigint NOT NULL
);


ALTER TABLE public.mdl_search_index_requests OWNER TO postgres;

--
-- Name: TABLE mdl_search_index_requests; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_search_index_requests IS 'Records requests for (re)indexing of specific contexts. Entries will be removed from this table when indexing of that context is complete. (This table is not used for normal time-based indexing of new content.)';


--
-- Name: mdl_search_index_requests_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_search_index_requests_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_search_index_requests_id_seq OWNER TO postgres;

--
-- Name: mdl_search_index_requests_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_search_index_requests_id_seq OWNED BY public.mdl_search_index_requests.id;


--
-- Name: mdl_search_simpledb_index; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_search_simpledb_index (
    id bigint NOT NULL,
    docid character varying(255) DEFAULT ''::character varying NOT NULL,
    itemid bigint NOT NULL,
    title text,
    content text,
    contextid bigint NOT NULL,
    areaid character varying(255) DEFAULT ''::character varying NOT NULL,
    type smallint NOT NULL,
    courseid bigint NOT NULL,
    owneruserid bigint,
    modified bigint NOT NULL,
    userid bigint,
    description1 text,
    description2 text
);


ALTER TABLE public.mdl_search_simpledb_index OWNER TO postgres;

--
-- Name: TABLE mdl_search_simpledb_index; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_search_simpledb_index IS 'search_simpledb table containing the index data.';


--
-- Name: mdl_search_simpledb_index_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_search_simpledb_index_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_search_simpledb_index_id_seq OWNER TO postgres;

--
-- Name: mdl_search_simpledb_index_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_search_simpledb_index_id_seq OWNED BY public.mdl_search_simpledb_index.id;


--
-- Name: mdl_sessions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_sessions (
    id bigint NOT NULL,
    state bigint DEFAULT 0 NOT NULL,
    sid character varying(128) DEFAULT ''::character varying NOT NULL,
    userid bigint NOT NULL,
    sessdata text,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    firstip character varying(45),
    lastip character varying(45)
);


ALTER TABLE public.mdl_sessions OWNER TO postgres;

--
-- Name: TABLE mdl_sessions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_sessions IS 'Database based session storage - now recommended';


--
-- Name: mdl_sessions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_sessions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_sessions_id_seq OWNER TO postgres;

--
-- Name: mdl_sessions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_sessions_id_seq OWNED BY public.mdl_sessions.id;


--
-- Name: mdl_shoptag; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_shoptag (
    id bigint NOT NULL,
    tag character varying(100) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_shoptag OWNER TO postgres;

--
-- Name: TABLE mdl_shoptag; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_shoptag IS 'shoptags';


--
-- Name: mdl_shoptag_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_shoptag_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_shoptag_id_seq OWNER TO postgres;

--
-- Name: mdl_shoptag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_shoptag_id_seq OWNED BY public.mdl_shoptag.id;


--
-- Name: mdl_stats_daily; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_stats_daily (
    id bigint NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    timeend bigint DEFAULT 0 NOT NULL,
    roleid bigint DEFAULT 0 NOT NULL,
    stattype character varying(20) DEFAULT 'activity'::character varying NOT NULL,
    stat1 bigint DEFAULT 0 NOT NULL,
    stat2 bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_stats_daily OWNER TO postgres;

--
-- Name: TABLE mdl_stats_daily; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_stats_daily IS 'to accumulate daily stats';


--
-- Name: mdl_stats_daily_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_stats_daily_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_stats_daily_id_seq OWNER TO postgres;

--
-- Name: mdl_stats_daily_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_stats_daily_id_seq OWNED BY public.mdl_stats_daily.id;


--
-- Name: mdl_stats_monthly; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_stats_monthly (
    id bigint NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    timeend bigint DEFAULT 0 NOT NULL,
    roleid bigint DEFAULT 0 NOT NULL,
    stattype character varying(20) DEFAULT 'activity'::character varying NOT NULL,
    stat1 bigint DEFAULT 0 NOT NULL,
    stat2 bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_stats_monthly OWNER TO postgres;

--
-- Name: TABLE mdl_stats_monthly; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_stats_monthly IS 'To accumulate monthly stats';


--
-- Name: mdl_stats_monthly_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_stats_monthly_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_stats_monthly_id_seq OWNER TO postgres;

--
-- Name: mdl_stats_monthly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_stats_monthly_id_seq OWNED BY public.mdl_stats_monthly.id;


--
-- Name: mdl_stats_user_daily; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_stats_user_daily (
    id bigint NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    roleid bigint DEFAULT 0 NOT NULL,
    timeend bigint DEFAULT 0 NOT NULL,
    statsreads bigint DEFAULT 0 NOT NULL,
    statswrites bigint DEFAULT 0 NOT NULL,
    stattype character varying(30) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_stats_user_daily OWNER TO postgres;

--
-- Name: TABLE mdl_stats_user_daily; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_stats_user_daily IS 'To accumulate daily stats per course/user';


--
-- Name: mdl_stats_user_daily_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_stats_user_daily_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_stats_user_daily_id_seq OWNER TO postgres;

--
-- Name: mdl_stats_user_daily_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_stats_user_daily_id_seq OWNED BY public.mdl_stats_user_daily.id;


--
-- Name: mdl_stats_user_monthly; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_stats_user_monthly (
    id bigint NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    roleid bigint DEFAULT 0 NOT NULL,
    timeend bigint DEFAULT 0 NOT NULL,
    statsreads bigint DEFAULT 0 NOT NULL,
    statswrites bigint DEFAULT 0 NOT NULL,
    stattype character varying(30) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_stats_user_monthly OWNER TO postgres;

--
-- Name: TABLE mdl_stats_user_monthly; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_stats_user_monthly IS 'To accumulate monthly stats per course/user';


--
-- Name: mdl_stats_user_monthly_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_stats_user_monthly_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_stats_user_monthly_id_seq OWNER TO postgres;

--
-- Name: mdl_stats_user_monthly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_stats_user_monthly_id_seq OWNED BY public.mdl_stats_user_monthly.id;


--
-- Name: mdl_stats_user_weekly; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_stats_user_weekly (
    id bigint NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    roleid bigint DEFAULT 0 NOT NULL,
    timeend bigint DEFAULT 0 NOT NULL,
    statsreads bigint DEFAULT 0 NOT NULL,
    statswrites bigint DEFAULT 0 NOT NULL,
    stattype character varying(30) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_stats_user_weekly OWNER TO postgres;

--
-- Name: TABLE mdl_stats_user_weekly; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_stats_user_weekly IS 'To accumulate weekly stats per course/user';


--
-- Name: mdl_stats_user_weekly_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_stats_user_weekly_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_stats_user_weekly_id_seq OWNER TO postgres;

--
-- Name: mdl_stats_user_weekly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_stats_user_weekly_id_seq OWNED BY public.mdl_stats_user_weekly.id;


--
-- Name: mdl_stats_weekly; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_stats_weekly (
    id bigint NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    timeend bigint DEFAULT 0 NOT NULL,
    roleid bigint DEFAULT 0 NOT NULL,
    stattype character varying(20) DEFAULT 'activity'::character varying NOT NULL,
    stat1 bigint DEFAULT 0 NOT NULL,
    stat2 bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_stats_weekly OWNER TO postgres;

--
-- Name: TABLE mdl_stats_weekly; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_stats_weekly IS 'To accumulate weekly stats';


--
-- Name: mdl_stats_weekly_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_stats_weekly_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_stats_weekly_id_seq OWNER TO postgres;

--
-- Name: mdl_stats_weekly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_stats_weekly_id_seq OWNED BY public.mdl_stats_weekly.id;


--
-- Name: mdl_survey; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_survey (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    template bigint DEFAULT 0 NOT NULL,
    days integer DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text NOT NULL,
    introformat smallint DEFAULT 0 NOT NULL,
    questions character varying(255) DEFAULT ''::character varying NOT NULL,
    completionsubmit smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_survey OWNER TO postgres;

--
-- Name: TABLE mdl_survey; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_survey IS 'Each record is one SURVEY module with its configuration';


--
-- Name: mdl_survey_analysis; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_survey_analysis (
    id bigint NOT NULL,
    survey bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    notes text NOT NULL
);


ALTER TABLE public.mdl_survey_analysis OWNER TO postgres;

--
-- Name: TABLE mdl_survey_analysis; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_survey_analysis IS 'text about each survey submission';


--
-- Name: mdl_survey_analysis_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_survey_analysis_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_survey_analysis_id_seq OWNER TO postgres;

--
-- Name: mdl_survey_analysis_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_survey_analysis_id_seq OWNED BY public.mdl_survey_analysis.id;


--
-- Name: mdl_survey_answers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_survey_answers (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    survey bigint DEFAULT 0 NOT NULL,
    question bigint DEFAULT 0 NOT NULL,
    "time" bigint DEFAULT 0 NOT NULL,
    answer1 text NOT NULL,
    answer2 text NOT NULL
);


ALTER TABLE public.mdl_survey_answers OWNER TO postgres;

--
-- Name: TABLE mdl_survey_answers; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_survey_answers IS 'the answers to each questions filled by the users';


--
-- Name: mdl_survey_answers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_survey_answers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_survey_answers_id_seq OWNER TO postgres;

--
-- Name: mdl_survey_answers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_survey_answers_id_seq OWNED BY public.mdl_survey_answers.id;


--
-- Name: mdl_survey_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_survey_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_survey_id_seq OWNER TO postgres;

--
-- Name: mdl_survey_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_survey_id_seq OWNED BY public.mdl_survey.id;


--
-- Name: mdl_survey_questions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_survey_questions (
    id bigint NOT NULL,
    text character varying(255) DEFAULT ''::character varying NOT NULL,
    shorttext character varying(30) DEFAULT ''::character varying NOT NULL,
    multi character varying(100) DEFAULT ''::character varying NOT NULL,
    intro character varying(50) DEFAULT ''::character varying NOT NULL,
    type smallint DEFAULT 0 NOT NULL,
    options text
);


ALTER TABLE public.mdl_survey_questions OWNER TO postgres;

--
-- Name: TABLE mdl_survey_questions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_survey_questions IS 'the questions conforming one survey';


--
-- Name: mdl_survey_questions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_survey_questions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_survey_questions_id_seq OWNER TO postgres;

--
-- Name: mdl_survey_questions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_survey_questions_id_seq OWNED BY public.mdl_survey_questions.id;


--
-- Name: mdl_tag; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tag (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    tagcollid bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    rawname character varying(255) DEFAULT ''::character varying NOT NULL,
    isstandard smallint DEFAULT 0 NOT NULL,
    description text,
    descriptionformat smallint DEFAULT 0 NOT NULL,
    flag smallint DEFAULT 0,
    timemodified bigint
);


ALTER TABLE public.mdl_tag OWNER TO postgres;

--
-- Name: TABLE mdl_tag; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tag IS 'Tag table - this generic table will replace the old "tags" table.';


--
-- Name: mdl_tag_area; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tag_area (
    id bigint NOT NULL,
    component character varying(100) DEFAULT ''::character varying NOT NULL,
    itemtype character varying(100) DEFAULT ''::character varying NOT NULL,
    enabled smallint DEFAULT 1 NOT NULL,
    tagcollid bigint NOT NULL,
    callback character varying(100),
    callbackfile character varying(100),
    showstandard smallint DEFAULT 0 NOT NULL,
    multiplecontexts smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_tag_area OWNER TO postgres;

--
-- Name: TABLE mdl_tag_area; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tag_area IS 'Defines various tag areas, one area is identified by component and itemtype';


--
-- Name: mdl_tag_area_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tag_area_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tag_area_id_seq OWNER TO postgres;

--
-- Name: mdl_tag_area_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tag_area_id_seq OWNED BY public.mdl_tag_area.id;


--
-- Name: mdl_tag_coll; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tag_coll (
    id bigint NOT NULL,
    name character varying(255),
    isdefault smallint DEFAULT 0 NOT NULL,
    component character varying(100),
    sortorder integer DEFAULT 0 NOT NULL,
    searchable smallint DEFAULT 1 NOT NULL,
    customurl character varying(255)
);


ALTER TABLE public.mdl_tag_coll OWNER TO postgres;

--
-- Name: TABLE mdl_tag_coll; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tag_coll IS 'Defines different set of tags';


--
-- Name: mdl_tag_coll_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tag_coll_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tag_coll_id_seq OWNER TO postgres;

--
-- Name: mdl_tag_coll_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tag_coll_id_seq OWNED BY public.mdl_tag_coll.id;


--
-- Name: mdl_tag_correlation; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tag_correlation (
    id bigint NOT NULL,
    tagid bigint NOT NULL,
    correlatedtags text NOT NULL
);


ALTER TABLE public.mdl_tag_correlation OWNER TO postgres;

--
-- Name: TABLE mdl_tag_correlation; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tag_correlation IS 'The rationale for the ''tag_correlation'' table is performance.   It works as a cache for a potentially heavy load query done at the ''tag_instance'' table.   So, the ''tag_correlation'' table stores redundant information derived from the ''tag_instance'' ta';


--
-- Name: mdl_tag_correlation_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tag_correlation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tag_correlation_id_seq OWNER TO postgres;

--
-- Name: mdl_tag_correlation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tag_correlation_id_seq OWNED BY public.mdl_tag_correlation.id;


--
-- Name: mdl_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tag_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tag_id_seq OWNER TO postgres;

--
-- Name: mdl_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tag_id_seq OWNED BY public.mdl_tag.id;


--
-- Name: mdl_tag_instance; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tag_instance (
    id bigint NOT NULL,
    tagid bigint NOT NULL,
    component character varying(100) DEFAULT ''::character varying NOT NULL,
    itemtype character varying(100) DEFAULT ''::character varying NOT NULL,
    itemid bigint NOT NULL,
    contextid bigint,
    tiuserid bigint DEFAULT 0 NOT NULL,
    ordering bigint,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_tag_instance OWNER TO postgres;

--
-- Name: TABLE mdl_tag_instance; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tag_instance IS 'tag_instance table holds the information of associations between tags and other items';


--
-- Name: mdl_tag_instance_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tag_instance_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tag_instance_id_seq OWNER TO postgres;

--
-- Name: mdl_tag_instance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tag_instance_id_seq OWNED BY public.mdl_tag_instance.id;


--
-- Name: mdl_task_adhoc; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_task_adhoc (
    id bigint NOT NULL,
    component character varying(255) DEFAULT ''::character varying NOT NULL,
    classname character varying(255) DEFAULT ''::character varying NOT NULL,
    nextruntime bigint NOT NULL,
    faildelay bigint,
    customdata text,
    userid bigint,
    blocking smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_task_adhoc OWNER TO postgres;

--
-- Name: TABLE mdl_task_adhoc; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_task_adhoc IS 'List of adhoc tasks waiting to run.';


--
-- Name: mdl_task_adhoc_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_task_adhoc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_task_adhoc_id_seq OWNER TO postgres;

--
-- Name: mdl_task_adhoc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_task_adhoc_id_seq OWNED BY public.mdl_task_adhoc.id;


--
-- Name: mdl_task_log; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_task_log (
    id bigint NOT NULL,
    type smallint NOT NULL,
    component character varying(255) DEFAULT ''::character varying NOT NULL,
    classname character varying(255) DEFAULT ''::character varying NOT NULL,
    userid bigint NOT NULL,
    timestart numeric(20,10) NOT NULL,
    timeend numeric(20,10) NOT NULL,
    dbreads bigint NOT NULL,
    dbwrites bigint NOT NULL,
    result smallint NOT NULL,
    output text NOT NULL
);


ALTER TABLE public.mdl_task_log OWNER TO postgres;

--
-- Name: TABLE mdl_task_log; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_task_log IS 'The log table for all tasks';


--
-- Name: mdl_task_log_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_task_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_task_log_id_seq OWNER TO postgres;

--
-- Name: mdl_task_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_task_log_id_seq OWNED BY public.mdl_task_log.id;


--
-- Name: mdl_task_scheduled; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_task_scheduled (
    id bigint NOT NULL,
    component character varying(255) DEFAULT ''::character varying NOT NULL,
    classname character varying(255) DEFAULT ''::character varying NOT NULL,
    lastruntime bigint,
    nextruntime bigint,
    blocking smallint DEFAULT 0 NOT NULL,
    minute character varying(25) DEFAULT ''::character varying NOT NULL,
    hour character varying(25) DEFAULT ''::character varying NOT NULL,
    day character varying(25) DEFAULT ''::character varying NOT NULL,
    month character varying(25) DEFAULT ''::character varying NOT NULL,
    dayofweek character varying(25) DEFAULT ''::character varying NOT NULL,
    faildelay bigint,
    customised smallint DEFAULT 0 NOT NULL,
    disabled smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_task_scheduled OWNER TO postgres;

--
-- Name: TABLE mdl_task_scheduled; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_task_scheduled IS 'List of scheduled tasks to be run by cron.';


--
-- Name: mdl_task_scheduled_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_task_scheduled_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_task_scheduled_id_seq OWNER TO postgres;

--
-- Name: mdl_task_scheduled_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_task_scheduled_id_seq OWNED BY public.mdl_task_scheduled.id;


--
-- Name: mdl_tool_cohortroles; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_cohortroles (
    id bigint NOT NULL,
    cohortid bigint NOT NULL,
    roleid bigint NOT NULL,
    userid bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint
);


ALTER TABLE public.mdl_tool_cohortroles OWNER TO postgres;

--
-- Name: TABLE mdl_tool_cohortroles; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_cohortroles IS 'Mapping of users to cohort role assignments.';


--
-- Name: mdl_tool_cohortroles_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_cohortroles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_cohortroles_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_cohortroles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_cohortroles_id_seq OWNED BY public.mdl_tool_cohortroles.id;


--
-- Name: mdl_tool_customlang; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_customlang (
    id bigint NOT NULL,
    lang character varying(20) DEFAULT ''::character varying NOT NULL,
    componentid bigint NOT NULL,
    stringid character varying(255) DEFAULT ''::character varying NOT NULL,
    original text NOT NULL,
    master text,
    local text,
    timemodified bigint NOT NULL,
    timecustomized bigint,
    outdated smallint DEFAULT 0,
    modified smallint DEFAULT 0
);


ALTER TABLE public.mdl_tool_customlang OWNER TO postgres;

--
-- Name: TABLE mdl_tool_customlang; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_customlang IS 'Contains the working checkout of all strings and their customization';


--
-- Name: mdl_tool_customlang_components; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_customlang_components (
    id bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    version character varying(255)
);


ALTER TABLE public.mdl_tool_customlang_components OWNER TO postgres;

--
-- Name: TABLE mdl_tool_customlang_components; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_customlang_components IS 'Contains the list of all installed plugins that provide their own language pack';


--
-- Name: mdl_tool_customlang_components_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_customlang_components_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_customlang_components_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_customlang_components_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_customlang_components_id_seq OWNED BY public.mdl_tool_customlang_components.id;


--
-- Name: mdl_tool_customlang_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_customlang_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_customlang_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_customlang_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_customlang_id_seq OWNED BY public.mdl_tool_customlang.id;


--
-- Name: mdl_tool_dataprivacy_category; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_dataprivacy_category (
    id bigint NOT NULL,
    name character varying(100) DEFAULT ''::character varying NOT NULL,
    description text,
    descriptionformat smallint,
    usermodified bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_tool_dataprivacy_category OWNER TO postgres;

--
-- Name: TABLE mdl_tool_dataprivacy_category; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_dataprivacy_category IS 'Data categories';


--
-- Name: mdl_tool_dataprivacy_category_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_dataprivacy_category_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_dataprivacy_category_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_dataprivacy_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_dataprivacy_category_id_seq OWNED BY public.mdl_tool_dataprivacy_category.id;


--
-- Name: mdl_tool_dataprivacy_ctxexpired; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_dataprivacy_ctxexpired (
    id bigint NOT NULL,
    contextid bigint NOT NULL,
    unexpiredroles text,
    expiredroles text,
    defaultexpired smallint NOT NULL,
    status smallint DEFAULT 0 NOT NULL,
    usermodified bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_tool_dataprivacy_ctxexpired OWNER TO postgres;

--
-- Name: TABLE mdl_tool_dataprivacy_ctxexpired; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_dataprivacy_ctxexpired IS 'Default comment for the table, please edit me';


--
-- Name: mdl_tool_dataprivacy_ctxexpired_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_dataprivacy_ctxexpired_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_dataprivacy_ctxexpired_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_dataprivacy_ctxexpired_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_dataprivacy_ctxexpired_id_seq OWNED BY public.mdl_tool_dataprivacy_ctxexpired.id;


--
-- Name: mdl_tool_dataprivacy_ctxinstance; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_dataprivacy_ctxinstance (
    id bigint NOT NULL,
    contextid bigint NOT NULL,
    purposeid bigint,
    categoryid bigint,
    usermodified bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_tool_dataprivacy_ctxinstance OWNER TO postgres;

--
-- Name: TABLE mdl_tool_dataprivacy_ctxinstance; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_dataprivacy_ctxinstance IS 'Default comment for the table, please edit me';


--
-- Name: mdl_tool_dataprivacy_ctxinstance_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_dataprivacy_ctxinstance_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_dataprivacy_ctxinstance_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_dataprivacy_ctxinstance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_dataprivacy_ctxinstance_id_seq OWNED BY public.mdl_tool_dataprivacy_ctxinstance.id;


--
-- Name: mdl_tool_dataprivacy_ctxlevel; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_dataprivacy_ctxlevel (
    id bigint NOT NULL,
    contextlevel smallint NOT NULL,
    purposeid bigint,
    categoryid bigint,
    usermodified bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_tool_dataprivacy_ctxlevel OWNER TO postgres;

--
-- Name: TABLE mdl_tool_dataprivacy_ctxlevel; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_dataprivacy_ctxlevel IS 'Default comment for the table, please edit me';


--
-- Name: mdl_tool_dataprivacy_ctxlevel_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_dataprivacy_ctxlevel_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_dataprivacy_ctxlevel_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_dataprivacy_ctxlevel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_dataprivacy_ctxlevel_id_seq OWNED BY public.mdl_tool_dataprivacy_ctxlevel.id;


--
-- Name: mdl_tool_dataprivacy_purpose; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_dataprivacy_purpose (
    id bigint NOT NULL,
    name character varying(100) DEFAULT ''::character varying NOT NULL,
    description text,
    descriptionformat smallint,
    lawfulbases text NOT NULL,
    sensitivedatareasons text,
    retentionperiod character varying(255) DEFAULT ''::character varying NOT NULL,
    protected smallint,
    usermodified bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_tool_dataprivacy_purpose OWNER TO postgres;

--
-- Name: TABLE mdl_tool_dataprivacy_purpose; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_dataprivacy_purpose IS 'Data purposes';


--
-- Name: mdl_tool_dataprivacy_purpose_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_dataprivacy_purpose_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_dataprivacy_purpose_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_dataprivacy_purpose_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_dataprivacy_purpose_id_seq OWNED BY public.mdl_tool_dataprivacy_purpose.id;


--
-- Name: mdl_tool_dataprivacy_purposerole; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_dataprivacy_purposerole (
    id bigint NOT NULL,
    purposeid bigint NOT NULL,
    roleid bigint NOT NULL,
    lawfulbases text,
    sensitivedatareasons text,
    retentionperiod character varying(255) DEFAULT ''::character varying NOT NULL,
    protected smallint,
    usermodified bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_tool_dataprivacy_purposerole OWNER TO postgres;

--
-- Name: TABLE mdl_tool_dataprivacy_purposerole; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_dataprivacy_purposerole IS 'Data purpose overrides for a specific role';


--
-- Name: mdl_tool_dataprivacy_purposerole_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_dataprivacy_purposerole_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_dataprivacy_purposerole_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_dataprivacy_purposerole_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_dataprivacy_purposerole_id_seq OWNED BY public.mdl_tool_dataprivacy_purposerole.id;


--
-- Name: mdl_tool_dataprivacy_request; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_dataprivacy_request (
    id bigint NOT NULL,
    type bigint DEFAULT 0 NOT NULL,
    comments text,
    commentsformat smallint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    requestedby bigint DEFAULT 0 NOT NULL,
    status smallint DEFAULT 0 NOT NULL,
    dpo bigint DEFAULT 0,
    dpocomment text,
    dpocommentformat smallint DEFAULT 0 NOT NULL,
    usermodified bigint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    creationmethod bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_tool_dataprivacy_request OWNER TO postgres;

--
-- Name: TABLE mdl_tool_dataprivacy_request; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_dataprivacy_request IS 'Table for data requests';


--
-- Name: mdl_tool_dataprivacy_request_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_dataprivacy_request_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_dataprivacy_request_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_dataprivacy_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_dataprivacy_request_id_seq OWNED BY public.mdl_tool_dataprivacy_request.id;


--
-- Name: mdl_tool_iomadmerge; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_iomadmerge (
    id bigint NOT NULL,
    touserid bigint NOT NULL,
    fromuserid bigint NOT NULL,
    success smallint NOT NULL,
    timemodified bigint NOT NULL,
    log text NOT NULL
);


ALTER TABLE public.mdl_tool_iomadmerge OWNER TO postgres;

--
-- Name: TABLE mdl_tool_iomadmerge; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_iomadmerge IS 'List of merged users: data from fromuserid user is merged into touserid user.';


--
-- Name: mdl_tool_iomadmerge_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_iomadmerge_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_iomadmerge_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_iomadmerge_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_iomadmerge_id_seq OWNED BY public.mdl_tool_iomadmerge.id;


--
-- Name: mdl_tool_monitor_events; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_monitor_events (
    id bigint NOT NULL,
    eventname character varying(254) DEFAULT ''::character varying NOT NULL,
    contextid bigint NOT NULL,
    contextlevel bigint NOT NULL,
    contextinstanceid bigint NOT NULL,
    link character varying(254) DEFAULT ''::character varying NOT NULL,
    courseid bigint NOT NULL,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_tool_monitor_events OWNER TO postgres;

--
-- Name: TABLE mdl_tool_monitor_events; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_monitor_events IS 'A table that keeps a log of events related to subscriptions';


--
-- Name: mdl_tool_monitor_events_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_monitor_events_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_monitor_events_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_monitor_events_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_monitor_events_id_seq OWNED BY public.mdl_tool_monitor_events.id;


--
-- Name: mdl_tool_monitor_history; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_monitor_history (
    id bigint NOT NULL,
    sid bigint NOT NULL,
    userid bigint NOT NULL,
    timesent bigint NOT NULL
);


ALTER TABLE public.mdl_tool_monitor_history OWNER TO postgres;

--
-- Name: TABLE mdl_tool_monitor_history; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_monitor_history IS 'Table to store history of message notifications sent';


--
-- Name: mdl_tool_monitor_history_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_monitor_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_monitor_history_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_monitor_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_monitor_history_id_seq OWNED BY public.mdl_tool_monitor_history.id;


--
-- Name: mdl_tool_monitor_rules; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_monitor_rules (
    id bigint NOT NULL,
    description text,
    descriptionformat smallint NOT NULL,
    name character varying(254) DEFAULT ''::character varying NOT NULL,
    userid bigint NOT NULL,
    courseid bigint NOT NULL,
    plugin character varying(254) DEFAULT ''::character varying NOT NULL,
    eventname character varying(254) DEFAULT ''::character varying NOT NULL,
    template text NOT NULL,
    templateformat smallint NOT NULL,
    frequency smallint NOT NULL,
    timewindow integer NOT NULL,
    timemodified bigint NOT NULL,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_tool_monitor_rules OWNER TO postgres;

--
-- Name: TABLE mdl_tool_monitor_rules; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_monitor_rules IS 'Table to store rules';


--
-- Name: mdl_tool_monitor_rules_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_monitor_rules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_monitor_rules_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_monitor_rules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_monitor_rules_id_seq OWNED BY public.mdl_tool_monitor_rules.id;


--
-- Name: mdl_tool_monitor_subscriptions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_monitor_subscriptions (
    id bigint NOT NULL,
    courseid bigint NOT NULL,
    ruleid bigint NOT NULL,
    cmid bigint NOT NULL,
    userid bigint NOT NULL,
    timecreated bigint NOT NULL,
    lastnotificationsent bigint DEFAULT 0 NOT NULL,
    inactivedate bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_tool_monitor_subscriptions OWNER TO postgres;

--
-- Name: TABLE mdl_tool_monitor_subscriptions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_monitor_subscriptions IS 'Table to store user subscriptions to various rules';


--
-- Name: mdl_tool_monitor_subscriptions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_monitor_subscriptions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_monitor_subscriptions_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_monitor_subscriptions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_monitor_subscriptions_id_seq OWNED BY public.mdl_tool_monitor_subscriptions.id;


--
-- Name: mdl_tool_policy; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_policy (
    id bigint NOT NULL,
    sortorder integer DEFAULT 999 NOT NULL,
    currentversionid bigint
);


ALTER TABLE public.mdl_tool_policy OWNER TO postgres;

--
-- Name: TABLE mdl_tool_policy; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_policy IS 'Contains the list of policy documents defined on the site.';


--
-- Name: mdl_tool_policy_acceptances; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_policy_acceptances (
    id bigint NOT NULL,
    policyversionid bigint NOT NULL,
    userid bigint NOT NULL,
    status smallint,
    lang character varying(30) DEFAULT ''::character varying NOT NULL,
    usermodified bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    note text
);


ALTER TABLE public.mdl_tool_policy_acceptances OWNER TO postgres;

--
-- Name: TABLE mdl_tool_policy_acceptances; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_policy_acceptances IS 'Tracks users accepting the policy versions';


--
-- Name: mdl_tool_policy_acceptances_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_policy_acceptances_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_policy_acceptances_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_policy_acceptances_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_policy_acceptances_id_seq OWNED BY public.mdl_tool_policy_acceptances.id;


--
-- Name: mdl_tool_policy_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_policy_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_policy_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_policy_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_policy_id_seq OWNED BY public.mdl_tool_policy.id;


--
-- Name: mdl_tool_policy_versions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_policy_versions (
    id bigint NOT NULL,
    name character varying(1333) DEFAULT ''::character varying NOT NULL,
    type smallint DEFAULT 0 NOT NULL,
    audience smallint DEFAULT 0 NOT NULL,
    archived smallint DEFAULT 0 NOT NULL,
    usermodified bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    policyid bigint NOT NULL,
    agreementstyle smallint DEFAULT 0 NOT NULL,
    optional smallint DEFAULT 0 NOT NULL,
    revision character varying(1333) DEFAULT ''::character varying NOT NULL,
    summary text NOT NULL,
    summaryformat smallint NOT NULL,
    content text NOT NULL,
    contentformat smallint NOT NULL
);


ALTER TABLE public.mdl_tool_policy_versions OWNER TO postgres;

--
-- Name: TABLE mdl_tool_policy_versions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_policy_versions IS 'Holds versions of the policy documents';


--
-- Name: mdl_tool_policy_versions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_policy_versions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_policy_versions_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_policy_versions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_policy_versions_id_seq OWNED BY public.mdl_tool_policy_versions.id;


--
-- Name: mdl_tool_recyclebin_category; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_recyclebin_category (
    id bigint NOT NULL,
    categoryid bigint NOT NULL,
    shortname character varying(255) DEFAULT ''::character varying NOT NULL,
    fullname character varying(255) DEFAULT ''::character varying NOT NULL,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_tool_recyclebin_category OWNER TO postgres;

--
-- Name: TABLE mdl_tool_recyclebin_category; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_recyclebin_category IS 'A list of items in the category recycle bin';


--
-- Name: mdl_tool_recyclebin_category_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_recyclebin_category_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_recyclebin_category_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_recyclebin_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_recyclebin_category_id_seq OWNED BY public.mdl_tool_recyclebin_category.id;


--
-- Name: mdl_tool_recyclebin_course; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_recyclebin_course (
    id bigint NOT NULL,
    courseid bigint NOT NULL,
    section bigint NOT NULL,
    module bigint NOT NULL,
    name character varying(255),
    timecreated bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_tool_recyclebin_course OWNER TO postgres;

--
-- Name: TABLE mdl_tool_recyclebin_course; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_recyclebin_course IS 'A list of items in the course recycle bin';


--
-- Name: mdl_tool_recyclebin_course_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_recyclebin_course_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_recyclebin_course_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_recyclebin_course_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_recyclebin_course_id_seq OWNED BY public.mdl_tool_recyclebin_course.id;


--
-- Name: mdl_tool_usertours_steps; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_usertours_steps (
    id bigint NOT NULL,
    tourid bigint NOT NULL,
    title text,
    content text,
    targettype smallint NOT NULL,
    targetvalue text NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL,
    configdata text NOT NULL
);


ALTER TABLE public.mdl_tool_usertours_steps OWNER TO postgres;

--
-- Name: TABLE mdl_tool_usertours_steps; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_usertours_steps IS 'Steps in an tour';


--
-- Name: mdl_tool_usertours_steps_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_usertours_steps_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_usertours_steps_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_usertours_steps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_usertours_steps_id_seq OWNED BY public.mdl_tool_usertours_steps.id;


--
-- Name: mdl_tool_usertours_tours; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_usertours_tours (
    id bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    description text,
    pathmatch character varying(255),
    enabled smallint DEFAULT 0 NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL,
    configdata text NOT NULL
);


ALTER TABLE public.mdl_tool_usertours_tours OWNER TO postgres;

--
-- Name: TABLE mdl_tool_usertours_tours; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_usertours_tours IS 'List of tours';


--
-- Name: mdl_tool_usertours_tours_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_usertours_tours_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_usertours_tours_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_usertours_tours_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_usertours_tours_id_seq OWNED BY public.mdl_tool_usertours_tours.id;


--
-- Name: mdl_trainingevent; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_trainingevent (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text NOT NULL,
    introformat smallint DEFAULT 0,
    timemodified bigint DEFAULT 0 NOT NULL,
    startdatetime bigint,
    enddatetime bigint,
    classroomid bigint,
    approvaltype smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_trainingevent OWNER TO postgres;

--
-- Name: TABLE mdl_trainingevent; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_trainingevent IS 'Defines classroom information for courses';


--
-- Name: mdl_trainingevent_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_trainingevent_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_trainingevent_id_seq OWNER TO postgres;

--
-- Name: mdl_trainingevent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_trainingevent_id_seq OWNED BY public.mdl_trainingevent.id;


--
-- Name: mdl_trainingevent_users; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_trainingevent_users (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    trainingeventid bigint
);


ALTER TABLE public.mdl_trainingevent_users OWNER TO postgres;

--
-- Name: TABLE mdl_trainingevent_users; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_trainingevent_users IS 'To keep tabs on the users who have booked in this event';


--
-- Name: mdl_trainingevent_users_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_trainingevent_users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_trainingevent_users_id_seq OWNER TO postgres;

--
-- Name: mdl_trainingevent_users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_trainingevent_users_id_seq OWNED BY public.mdl_trainingevent_users.id;


--
-- Name: mdl_upgrade_log; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_upgrade_log (
    id bigint NOT NULL,
    type bigint NOT NULL,
    plugin character varying(100),
    version character varying(100),
    targetversion character varying(100),
    info character varying(255) DEFAULT ''::character varying NOT NULL,
    details text,
    backtrace text,
    userid bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_upgrade_log OWNER TO postgres;

--
-- Name: TABLE mdl_upgrade_log; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_upgrade_log IS 'Upgrade logging';


--
-- Name: mdl_upgrade_log_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_upgrade_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_upgrade_log_id_seq OWNER TO postgres;

--
-- Name: mdl_upgrade_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_upgrade_log_id_seq OWNED BY public.mdl_upgrade_log.id;


--
-- Name: mdl_url; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_url (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text,
    introformat smallint DEFAULT 0 NOT NULL,
    externalurl text NOT NULL,
    display smallint DEFAULT 0 NOT NULL,
    displayoptions text,
    parameters text,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_url OWNER TO postgres;

--
-- Name: TABLE mdl_url; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_url IS 'each record is one url resource';


--
-- Name: mdl_url_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_url_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_url_id_seq OWNER TO postgres;

--
-- Name: mdl_url_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_url_id_seq OWNED BY public.mdl_url.id;


--
-- Name: mdl_user; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_user (
    id bigint NOT NULL,
    auth character varying(20) DEFAULT 'manual'::character varying NOT NULL,
    confirmed smallint DEFAULT 0 NOT NULL,
    policyagreed smallint DEFAULT 0 NOT NULL,
    deleted smallint DEFAULT 0 NOT NULL,
    suspended smallint DEFAULT 0 NOT NULL,
    mnethostid bigint DEFAULT 0 NOT NULL,
    username character varying(100) DEFAULT ''::character varying NOT NULL,
    password character varying(255) DEFAULT ''::character varying NOT NULL,
    idnumber character varying(255) DEFAULT ''::character varying NOT NULL,
    firstname character varying(100) DEFAULT ''::character varying NOT NULL,
    lastname character varying(100) DEFAULT ''::character varying NOT NULL,
    email character varying(100) DEFAULT ''::character varying NOT NULL,
    emailstop smallint DEFAULT 0 NOT NULL,
    icq character varying(15) DEFAULT ''::character varying NOT NULL,
    skype character varying(50) DEFAULT ''::character varying NOT NULL,
    yahoo character varying(50) DEFAULT ''::character varying NOT NULL,
    aim character varying(50) DEFAULT ''::character varying NOT NULL,
    msn character varying(50) DEFAULT ''::character varying NOT NULL,
    phone1 character varying(20) DEFAULT ''::character varying NOT NULL,
    phone2 character varying(20) DEFAULT ''::character varying NOT NULL,
    institution character varying(255) DEFAULT ''::character varying NOT NULL,
    department character varying(255) DEFAULT ''::character varying NOT NULL,
    address character varying(255) DEFAULT ''::character varying NOT NULL,
    city character varying(120) DEFAULT ''::character varying NOT NULL,
    country character varying(2) DEFAULT ''::character varying NOT NULL,
    lang character varying(30) DEFAULT 'en'::character varying NOT NULL,
    calendartype character varying(30) DEFAULT 'gregorian'::character varying NOT NULL,
    theme character varying(50) DEFAULT ''::character varying NOT NULL,
    timezone character varying(100) DEFAULT '99'::character varying NOT NULL,
    firstaccess bigint DEFAULT 0 NOT NULL,
    lastaccess bigint DEFAULT 0 NOT NULL,
    lastlogin bigint DEFAULT 0 NOT NULL,
    currentlogin bigint DEFAULT 0 NOT NULL,
    lastip character varying(45) DEFAULT ''::character varying NOT NULL,
    secret character varying(15) DEFAULT ''::character varying NOT NULL,
    picture bigint DEFAULT 0 NOT NULL,
    url character varying(255) DEFAULT ''::character varying NOT NULL,
    description text,
    descriptionformat smallint DEFAULT 1 NOT NULL,
    mailformat smallint DEFAULT 1 NOT NULL,
    maildigest smallint DEFAULT 0 NOT NULL,
    maildisplay smallint DEFAULT 2 NOT NULL,
    autosubscribe smallint DEFAULT 1 NOT NULL,
    trackforums smallint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    trustbitmask bigint DEFAULT 0 NOT NULL,
    imagealt character varying(255),
    lastnamephonetic character varying(255),
    firstnamephonetic character varying(255),
    middlename character varying(255),
    alternatename character varying(255)
);


ALTER TABLE public.mdl_user OWNER TO postgres;

--
-- Name: TABLE mdl_user; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_user IS 'One record for each person';


--
-- Name: mdl_user_devices; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_user_devices (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    appid character varying(128) DEFAULT ''::character varying NOT NULL,
    name character varying(32) DEFAULT ''::character varying NOT NULL,
    model character varying(32) DEFAULT ''::character varying NOT NULL,
    platform character varying(32) DEFAULT ''::character varying NOT NULL,
    version character varying(32) DEFAULT ''::character varying NOT NULL,
    pushid character varying(255) DEFAULT ''::character varying NOT NULL,
    uuid character varying(255) DEFAULT ''::character varying NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_user_devices OWNER TO postgres;

--
-- Name: TABLE mdl_user_devices; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_user_devices IS 'This table stores user''s mobile devices information in order to send PUSH notifications';


--
-- Name: mdl_user_devices_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_devices_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_devices_id_seq OWNER TO postgres;

--
-- Name: mdl_user_devices_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_user_devices_id_seq OWNED BY public.mdl_user_devices.id;


--
-- Name: mdl_user_enrolments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_user_enrolments (
    id bigint NOT NULL,
    status bigint DEFAULT 0 NOT NULL,
    enrolid bigint NOT NULL,
    userid bigint NOT NULL,
    timestart bigint DEFAULT 0 NOT NULL,
    timeend bigint DEFAULT 2147483647 NOT NULL,
    modifierid bigint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_user_enrolments OWNER TO postgres;

--
-- Name: TABLE mdl_user_enrolments; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_user_enrolments IS 'Users participating in courses (aka enrolled users) - everybody who is participating/visible in course, that means both teachers and students';


--
-- Name: mdl_user_enrolments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_enrolments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_enrolments_id_seq OWNER TO postgres;

--
-- Name: mdl_user_enrolments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_user_enrolments_id_seq OWNED BY public.mdl_user_enrolments.id;


--
-- Name: mdl_user_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_id_seq OWNER TO postgres;

--
-- Name: mdl_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_user_id_seq OWNED BY public.mdl_user.id;


--
-- Name: mdl_user_info_category; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_user_info_category (
    id bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_user_info_category OWNER TO postgres;

--
-- Name: TABLE mdl_user_info_category; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_user_info_category IS 'Customisable fields categories';


--
-- Name: mdl_user_info_category_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_info_category_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_info_category_id_seq OWNER TO postgres;

--
-- Name: mdl_user_info_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_user_info_category_id_seq OWNED BY public.mdl_user_info_category.id;


--
-- Name: mdl_user_info_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_user_info_data (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    fieldid bigint DEFAULT 0 NOT NULL,
    data text NOT NULL,
    dataformat smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_user_info_data OWNER TO postgres;

--
-- Name: TABLE mdl_user_info_data; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_user_info_data IS 'Data for the customisable user fields';


--
-- Name: mdl_user_info_data_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_info_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_info_data_id_seq OWNER TO postgres;

--
-- Name: mdl_user_info_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_user_info_data_id_seq OWNED BY public.mdl_user_info_data.id;


--
-- Name: mdl_user_info_field; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_user_info_field (
    id bigint NOT NULL,
    shortname character varying(255) DEFAULT 'shortname'::character varying NOT NULL,
    name text NOT NULL,
    datatype character varying(255) DEFAULT ''::character varying NOT NULL,
    description text,
    descriptionformat smallint DEFAULT 0 NOT NULL,
    categoryid bigint DEFAULT 0 NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL,
    required smallint DEFAULT 0 NOT NULL,
    locked smallint DEFAULT 0 NOT NULL,
    visible smallint DEFAULT 0 NOT NULL,
    forceunique smallint DEFAULT 0 NOT NULL,
    signup smallint DEFAULT 0 NOT NULL,
    defaultdata text,
    defaultdataformat smallint DEFAULT 0 NOT NULL,
    param1 text,
    param2 text,
    param3 text,
    param4 text,
    param5 text
);


ALTER TABLE public.mdl_user_info_field OWNER TO postgres;

--
-- Name: TABLE mdl_user_info_field; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_user_info_field IS 'Customisable user profile fields';


--
-- Name: mdl_user_info_field_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_info_field_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_info_field_id_seq OWNER TO postgres;

--
-- Name: mdl_user_info_field_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_user_info_field_id_seq OWNED BY public.mdl_user_info_field.id;


--
-- Name: mdl_user_lastaccess; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_user_lastaccess (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    timeaccess bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_user_lastaccess OWNER TO postgres;

--
-- Name: TABLE mdl_user_lastaccess; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_user_lastaccess IS 'To keep track of course page access times, used in online participants block, and participants list';


--
-- Name: mdl_user_lastaccess_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_lastaccess_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_lastaccess_id_seq OWNER TO postgres;

--
-- Name: mdl_user_lastaccess_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_user_lastaccess_id_seq OWNED BY public.mdl_user_lastaccess.id;


--
-- Name: mdl_user_password_history; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_user_password_history (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    hash character varying(255) DEFAULT ''::character varying NOT NULL,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_user_password_history OWNER TO postgres;

--
-- Name: TABLE mdl_user_password_history; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_user_password_history IS 'A rotating log of hashes of previously used passwords for each user.';


--
-- Name: mdl_user_password_history_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_password_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_password_history_id_seq OWNER TO postgres;

--
-- Name: mdl_user_password_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_user_password_history_id_seq OWNED BY public.mdl_user_password_history.id;


--
-- Name: mdl_user_password_resets; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_user_password_resets (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    timerequested bigint NOT NULL,
    timererequested bigint DEFAULT 0 NOT NULL,
    token character varying(32) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_user_password_resets OWNER TO postgres;

--
-- Name: TABLE mdl_user_password_resets; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_user_password_resets IS 'table tracking password reset confirmation tokens';


--
-- Name: mdl_user_password_resets_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_password_resets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_password_resets_id_seq OWNER TO postgres;

--
-- Name: mdl_user_password_resets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_user_password_resets_id_seq OWNED BY public.mdl_user_password_resets.id;


--
-- Name: mdl_user_preferences; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_user_preferences (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    value character varying(1333) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_user_preferences OWNER TO postgres;

--
-- Name: TABLE mdl_user_preferences; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_user_preferences IS 'Allows modules to store arbitrary user preferences';


--
-- Name: mdl_user_preferences_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_preferences_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_preferences_id_seq OWNER TO postgres;

--
-- Name: mdl_user_preferences_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_user_preferences_id_seq OWNED BY public.mdl_user_preferences.id;


--
-- Name: mdl_user_private_key; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_user_private_key (
    id bigint NOT NULL,
    script character varying(128) DEFAULT ''::character varying NOT NULL,
    value character varying(128) DEFAULT ''::character varying NOT NULL,
    userid bigint NOT NULL,
    instance bigint,
    iprestriction character varying(255),
    validuntil bigint,
    timecreated bigint
);


ALTER TABLE public.mdl_user_private_key OWNER TO postgres;

--
-- Name: TABLE mdl_user_private_key; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_user_private_key IS 'access keys used in cookieless scripts - rss, etc.';


--
-- Name: mdl_user_private_key_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_private_key_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_private_key_id_seq OWNER TO postgres;

--
-- Name: mdl_user_private_key_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_user_private_key_id_seq OWNED BY public.mdl_user_private_key.id;


--
-- Name: mdl_wiki; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_wiki (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT 'Wiki'::character varying NOT NULL,
    intro text,
    introformat smallint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    firstpagetitle character varying(255) DEFAULT 'First Page'::character varying NOT NULL,
    wikimode character varying(20) DEFAULT 'collaborative'::character varying NOT NULL,
    defaultformat character varying(20) DEFAULT 'creole'::character varying NOT NULL,
    forceformat smallint DEFAULT 1 NOT NULL,
    editbegin bigint DEFAULT 0 NOT NULL,
    editend bigint DEFAULT 0
);


ALTER TABLE public.mdl_wiki OWNER TO postgres;

--
-- Name: TABLE mdl_wiki; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_wiki IS 'Stores Wiki activity configuration';


--
-- Name: mdl_wiki_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_wiki_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_wiki_id_seq OWNER TO postgres;

--
-- Name: mdl_wiki_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_wiki_id_seq OWNED BY public.mdl_wiki.id;


--
-- Name: mdl_wiki_links; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_wiki_links (
    id bigint NOT NULL,
    subwikiid bigint DEFAULT 0 NOT NULL,
    frompageid bigint DEFAULT 0 NOT NULL,
    topageid bigint DEFAULT 0 NOT NULL,
    tomissingpage character varying(255)
);


ALTER TABLE public.mdl_wiki_links OWNER TO postgres;

--
-- Name: TABLE mdl_wiki_links; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_wiki_links IS 'Page wiki links';


--
-- Name: mdl_wiki_links_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_wiki_links_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_wiki_links_id_seq OWNER TO postgres;

--
-- Name: mdl_wiki_links_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_wiki_links_id_seq OWNED BY public.mdl_wiki_links.id;


--
-- Name: mdl_wiki_locks; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_wiki_locks (
    id bigint NOT NULL,
    pageid bigint DEFAULT 0 NOT NULL,
    sectionname character varying(255),
    userid bigint DEFAULT 0 NOT NULL,
    lockedat bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_wiki_locks OWNER TO postgres;

--
-- Name: TABLE mdl_wiki_locks; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_wiki_locks IS 'Manages page locks';


--
-- Name: mdl_wiki_locks_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_wiki_locks_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_wiki_locks_id_seq OWNER TO postgres;

--
-- Name: mdl_wiki_locks_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_wiki_locks_id_seq OWNED BY public.mdl_wiki_locks.id;


--
-- Name: mdl_wiki_pages; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_wiki_pages (
    id bigint NOT NULL,
    subwikiid bigint DEFAULT 0 NOT NULL,
    title character varying(255) DEFAULT 'title'::character varying NOT NULL,
    cachedcontent text NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    timerendered bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    pageviews bigint DEFAULT 0 NOT NULL,
    readonly smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_wiki_pages OWNER TO postgres;

--
-- Name: TABLE mdl_wiki_pages; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_wiki_pages IS 'Stores wiki pages';


--
-- Name: mdl_wiki_pages_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_wiki_pages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_wiki_pages_id_seq OWNER TO postgres;

--
-- Name: mdl_wiki_pages_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_wiki_pages_id_seq OWNED BY public.mdl_wiki_pages.id;


--
-- Name: mdl_wiki_subwikis; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_wiki_subwikis (
    id bigint NOT NULL,
    wikiid bigint DEFAULT 0 NOT NULL,
    groupid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_wiki_subwikis OWNER TO postgres;

--
-- Name: TABLE mdl_wiki_subwikis; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_wiki_subwikis IS 'Stores subwiki instances';


--
-- Name: mdl_wiki_subwikis_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_wiki_subwikis_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_wiki_subwikis_id_seq OWNER TO postgres;

--
-- Name: mdl_wiki_subwikis_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_wiki_subwikis_id_seq OWNED BY public.mdl_wiki_subwikis.id;


--
-- Name: mdl_wiki_synonyms; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_wiki_synonyms (
    id bigint NOT NULL,
    subwikiid bigint DEFAULT 0 NOT NULL,
    pageid bigint DEFAULT 0 NOT NULL,
    pagesynonym character varying(255) DEFAULT 'Pagesynonym'::character varying NOT NULL
);


ALTER TABLE public.mdl_wiki_synonyms OWNER TO postgres;

--
-- Name: TABLE mdl_wiki_synonyms; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_wiki_synonyms IS 'Stores wiki pages synonyms';


--
-- Name: mdl_wiki_synonyms_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_wiki_synonyms_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_wiki_synonyms_id_seq OWNER TO postgres;

--
-- Name: mdl_wiki_synonyms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_wiki_synonyms_id_seq OWNED BY public.mdl_wiki_synonyms.id;


--
-- Name: mdl_wiki_versions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_wiki_versions (
    id bigint NOT NULL,
    pageid bigint DEFAULT 0 NOT NULL,
    content text NOT NULL,
    contentformat character varying(20) DEFAULT 'creole'::character varying NOT NULL,
    version integer DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_wiki_versions OWNER TO postgres;

--
-- Name: TABLE mdl_wiki_versions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_wiki_versions IS 'Stores wiki page history';


--
-- Name: mdl_wiki_versions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_wiki_versions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_wiki_versions_id_seq OWNER TO postgres;

--
-- Name: mdl_wiki_versions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_wiki_versions_id_seq OWNED BY public.mdl_wiki_versions.id;


--
-- Name: mdl_workshop; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_workshop (
    id bigint NOT NULL,
    course bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text,
    introformat smallint DEFAULT 0 NOT NULL,
    instructauthors text,
    instructauthorsformat smallint DEFAULT 0 NOT NULL,
    instructreviewers text,
    instructreviewersformat smallint DEFAULT 0 NOT NULL,
    timemodified bigint NOT NULL,
    phase smallint DEFAULT 0,
    useexamples smallint DEFAULT 0,
    usepeerassessment smallint DEFAULT 0,
    useselfassessment smallint DEFAULT 0,
    grade numeric(10,5) DEFAULT 80,
    gradinggrade numeric(10,5) DEFAULT 20,
    strategy character varying(30) DEFAULT ''::character varying NOT NULL,
    evaluation character varying(30) DEFAULT ''::character varying NOT NULL,
    gradedecimals smallint DEFAULT 0,
    submissiontypetext smallint DEFAULT 1 NOT NULL,
    submissiontypefile smallint DEFAULT 1 NOT NULL,
    nattachments smallint DEFAULT 1,
    submissionfiletypes character varying(255),
    latesubmissions smallint DEFAULT 0,
    maxbytes bigint DEFAULT 100000,
    examplesmode smallint DEFAULT 0,
    submissionstart bigint DEFAULT 0,
    submissionend bigint DEFAULT 0,
    assessmentstart bigint DEFAULT 0,
    assessmentend bigint DEFAULT 0,
    phaseswitchassessment smallint DEFAULT 0 NOT NULL,
    conclusion text,
    conclusionformat smallint DEFAULT 1 NOT NULL,
    overallfeedbackmode smallint DEFAULT 1,
    overallfeedbackfiles smallint DEFAULT 0,
    overallfeedbackfiletypes character varying(255),
    overallfeedbackmaxbytes bigint DEFAULT 100000
);


ALTER TABLE public.mdl_workshop OWNER TO postgres;

--
-- Name: TABLE mdl_workshop; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_workshop IS 'This table keeps information about the module instances and their settings';


--
-- Name: mdl_workshop_aggregations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_workshop_aggregations (
    id bigint NOT NULL,
    workshopid bigint NOT NULL,
    userid bigint NOT NULL,
    gradinggrade numeric(10,5),
    timegraded bigint
);


ALTER TABLE public.mdl_workshop_aggregations OWNER TO postgres;

--
-- Name: TABLE mdl_workshop_aggregations; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_workshop_aggregations IS 'Aggregated grades for assessment are stored here. The aggregated grade for submission is stored in workshop_submissions';


--
-- Name: mdl_workshop_aggregations_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshop_aggregations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshop_aggregations_id_seq OWNER TO postgres;

--
-- Name: mdl_workshop_aggregations_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_workshop_aggregations_id_seq OWNED BY public.mdl_workshop_aggregations.id;


--
-- Name: mdl_workshop_assessments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_workshop_assessments (
    id bigint NOT NULL,
    submissionid bigint NOT NULL,
    reviewerid bigint NOT NULL,
    weight bigint DEFAULT 1 NOT NULL,
    timecreated bigint DEFAULT 0,
    timemodified bigint DEFAULT 0,
    grade numeric(10,5),
    gradinggrade numeric(10,5),
    gradinggradeover numeric(10,5),
    gradinggradeoverby bigint,
    feedbackauthor text,
    feedbackauthorformat smallint DEFAULT 0,
    feedbackauthorattachment smallint DEFAULT 0,
    feedbackreviewer text,
    feedbackreviewerformat smallint DEFAULT 0
);


ALTER TABLE public.mdl_workshop_assessments OWNER TO postgres;

--
-- Name: TABLE mdl_workshop_assessments; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_workshop_assessments IS 'Info about the made assessment and automatically calculated grade for it. The proposed grade can be overridden by teacher.';


--
-- Name: mdl_workshop_assessments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshop_assessments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshop_assessments_id_seq OWNER TO postgres;

--
-- Name: mdl_workshop_assessments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_workshop_assessments_id_seq OWNED BY public.mdl_workshop_assessments.id;


--
-- Name: mdl_workshop_grades; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_workshop_grades (
    id bigint NOT NULL,
    assessmentid bigint NOT NULL,
    strategy character varying(30) DEFAULT ''::character varying NOT NULL,
    dimensionid bigint NOT NULL,
    grade numeric(10,5) NOT NULL,
    peercomment text,
    peercommentformat smallint DEFAULT 0
);


ALTER TABLE public.mdl_workshop_grades OWNER TO postgres;

--
-- Name: TABLE mdl_workshop_grades; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_workshop_grades IS 'How the reviewers filled-up the grading forms, given grades and comments';


--
-- Name: mdl_workshop_grades_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshop_grades_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshop_grades_id_seq OWNER TO postgres;

--
-- Name: mdl_workshop_grades_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_workshop_grades_id_seq OWNED BY public.mdl_workshop_grades.id;


--
-- Name: mdl_workshop_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshop_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshop_id_seq OWNER TO postgres;

--
-- Name: mdl_workshop_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_workshop_id_seq OWNED BY public.mdl_workshop.id;


--
-- Name: mdl_workshop_submissions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_workshop_submissions (
    id bigint NOT NULL,
    workshopid bigint NOT NULL,
    example smallint DEFAULT 0,
    authorid bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    title character varying(255) DEFAULT ''::character varying NOT NULL,
    content text,
    contentformat smallint DEFAULT 0 NOT NULL,
    contenttrust smallint DEFAULT 0 NOT NULL,
    attachment smallint DEFAULT 0,
    grade numeric(10,5),
    gradeover numeric(10,5),
    gradeoverby bigint,
    feedbackauthor text,
    feedbackauthorformat smallint DEFAULT 0,
    timegraded bigint,
    published smallint DEFAULT 0,
    late smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_workshop_submissions OWNER TO postgres;

--
-- Name: TABLE mdl_workshop_submissions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_workshop_submissions IS 'Info about the submission and the aggregation of the grade for submission, grade for assessment and final grade. Both grade for submission and grade for assessment can be overridden by teacher. Final grade is always the sum of them. All grades are st';


--
-- Name: mdl_workshop_submissions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshop_submissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshop_submissions_id_seq OWNER TO postgres;

--
-- Name: mdl_workshop_submissions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_workshop_submissions_id_seq OWNED BY public.mdl_workshop_submissions.id;


--
-- Name: mdl_workshopallocation_scheduled; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_workshopallocation_scheduled (
    id bigint NOT NULL,
    workshopid bigint NOT NULL,
    enabled smallint DEFAULT 0 NOT NULL,
    submissionend bigint NOT NULL,
    timeallocated bigint,
    settings text,
    resultstatus bigint,
    resultmessage character varying(1333),
    resultlog text
);


ALTER TABLE public.mdl_workshopallocation_scheduled OWNER TO postgres;

--
-- Name: TABLE mdl_workshopallocation_scheduled; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_workshopallocation_scheduled IS 'Stores the allocation settings for the scheduled allocator';


--
-- Name: mdl_workshopallocation_scheduled_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshopallocation_scheduled_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshopallocation_scheduled_id_seq OWNER TO postgres;

--
-- Name: mdl_workshopallocation_scheduled_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_workshopallocation_scheduled_id_seq OWNED BY public.mdl_workshopallocation_scheduled.id;


--
-- Name: mdl_workshopeval_best_settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_workshopeval_best_settings (
    id bigint NOT NULL,
    workshopid bigint NOT NULL,
    comparison smallint DEFAULT 5
);


ALTER TABLE public.mdl_workshopeval_best_settings OWNER TO postgres;

--
-- Name: TABLE mdl_workshopeval_best_settings; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_workshopeval_best_settings IS 'Settings for the grading evaluation subplugin Comparison with the best assessment.';


--
-- Name: mdl_workshopeval_best_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshopeval_best_settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshopeval_best_settings_id_seq OWNER TO postgres;

--
-- Name: mdl_workshopeval_best_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_workshopeval_best_settings_id_seq OWNED BY public.mdl_workshopeval_best_settings.id;


--
-- Name: mdl_workshopform_accumulative; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_workshopform_accumulative (
    id bigint NOT NULL,
    workshopid bigint NOT NULL,
    sort bigint DEFAULT 0,
    description text,
    descriptionformat smallint DEFAULT 0,
    grade bigint NOT NULL,
    weight integer DEFAULT 1
);


ALTER TABLE public.mdl_workshopform_accumulative OWNER TO postgres;

--
-- Name: TABLE mdl_workshopform_accumulative; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_workshopform_accumulative IS 'The assessment dimensions definitions of Accumulative grading strategy forms';


--
-- Name: mdl_workshopform_accumulative_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshopform_accumulative_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshopform_accumulative_id_seq OWNER TO postgres;

--
-- Name: mdl_workshopform_accumulative_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_workshopform_accumulative_id_seq OWNED BY public.mdl_workshopform_accumulative.id;


--
-- Name: mdl_workshopform_comments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_workshopform_comments (
    id bigint NOT NULL,
    workshopid bigint NOT NULL,
    sort bigint DEFAULT 0,
    description text,
    descriptionformat smallint DEFAULT 0
);


ALTER TABLE public.mdl_workshopform_comments OWNER TO postgres;

--
-- Name: TABLE mdl_workshopform_comments; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_workshopform_comments IS 'The assessment dimensions definitions of Comments strategy forms';


--
-- Name: mdl_workshopform_comments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshopform_comments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshopform_comments_id_seq OWNER TO postgres;

--
-- Name: mdl_workshopform_comments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_workshopform_comments_id_seq OWNED BY public.mdl_workshopform_comments.id;


--
-- Name: mdl_workshopform_numerrors; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_workshopform_numerrors (
    id bigint NOT NULL,
    workshopid bigint NOT NULL,
    sort bigint DEFAULT 0,
    description text,
    descriptionformat smallint DEFAULT 0,
    descriptiontrust bigint,
    grade0 character varying(50),
    grade1 character varying(50),
    weight integer DEFAULT 1
);


ALTER TABLE public.mdl_workshopform_numerrors OWNER TO postgres;

--
-- Name: TABLE mdl_workshopform_numerrors; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_workshopform_numerrors IS 'The assessment dimensions definitions of Number of errors grading strategy forms';


--
-- Name: mdl_workshopform_numerrors_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshopform_numerrors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshopform_numerrors_id_seq OWNER TO postgres;

--
-- Name: mdl_workshopform_numerrors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_workshopform_numerrors_id_seq OWNED BY public.mdl_workshopform_numerrors.id;


--
-- Name: mdl_workshopform_numerrors_map; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_workshopform_numerrors_map (
    id bigint NOT NULL,
    workshopid bigint NOT NULL,
    nonegative bigint NOT NULL,
    grade numeric(10,5) NOT NULL
);


ALTER TABLE public.mdl_workshopform_numerrors_map OWNER TO postgres;

--
-- Name: TABLE mdl_workshopform_numerrors_map; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_workshopform_numerrors_map IS 'This maps the number of errors to a percentual grade for submission';


--
-- Name: mdl_workshopform_numerrors_map_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshopform_numerrors_map_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshopform_numerrors_map_id_seq OWNER TO postgres;

--
-- Name: mdl_workshopform_numerrors_map_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_workshopform_numerrors_map_id_seq OWNED BY public.mdl_workshopform_numerrors_map.id;


--
-- Name: mdl_workshopform_rubric; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_workshopform_rubric (
    id bigint NOT NULL,
    workshopid bigint NOT NULL,
    sort bigint DEFAULT 0,
    description text,
    descriptionformat smallint DEFAULT 0
);


ALTER TABLE public.mdl_workshopform_rubric OWNER TO postgres;

--
-- Name: TABLE mdl_workshopform_rubric; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_workshopform_rubric IS 'The assessment dimensions definitions of Rubric grading strategy forms';


--
-- Name: mdl_workshopform_rubric_config; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_workshopform_rubric_config (
    id bigint NOT NULL,
    workshopid bigint NOT NULL,
    layout character varying(30) DEFAULT 'list'::character varying
);


ALTER TABLE public.mdl_workshopform_rubric_config OWNER TO postgres;

--
-- Name: TABLE mdl_workshopform_rubric_config; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_workshopform_rubric_config IS 'Configuration table for the Rubric grading strategy';


--
-- Name: mdl_workshopform_rubric_config_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshopform_rubric_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshopform_rubric_config_id_seq OWNER TO postgres;

--
-- Name: mdl_workshopform_rubric_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_workshopform_rubric_config_id_seq OWNED BY public.mdl_workshopform_rubric_config.id;


--
-- Name: mdl_workshopform_rubric_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshopform_rubric_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshopform_rubric_id_seq OWNER TO postgres;

--
-- Name: mdl_workshopform_rubric_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_workshopform_rubric_id_seq OWNED BY public.mdl_workshopform_rubric.id;


--
-- Name: mdl_workshopform_rubric_levels; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_workshopform_rubric_levels (
    id bigint NOT NULL,
    dimensionid bigint NOT NULL,
    grade numeric(10,5) NOT NULL,
    definition text,
    definitionformat smallint DEFAULT 0
);


ALTER TABLE public.mdl_workshopform_rubric_levels OWNER TO postgres;

--
-- Name: TABLE mdl_workshopform_rubric_levels; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_workshopform_rubric_levels IS 'The definition of rubric rating scales';


--
-- Name: mdl_workshopform_rubric_levels_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshopform_rubric_levels_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshopform_rubric_levels_id_seq OWNER TO postgres;

--
-- Name: mdl_workshopform_rubric_levels_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_workshopform_rubric_levels_id_seq OWNED BY public.mdl_workshopform_rubric_levels.id;


--
-- Name: mdl_analytics_indicator_calc id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_analytics_indicator_calc ALTER COLUMN id SET DEFAULT nextval('public.mdl_analytics_indicator_calc_id_seq'::regclass);


--
-- Name: mdl_analytics_models id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_analytics_models ALTER COLUMN id SET DEFAULT nextval('public.mdl_analytics_models_id_seq'::regclass);


--
-- Name: mdl_analytics_models_log id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_analytics_models_log ALTER COLUMN id SET DEFAULT nextval('public.mdl_analytics_models_log_id_seq'::regclass);


--
-- Name: mdl_analytics_predict_samples id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_analytics_predict_samples ALTER COLUMN id SET DEFAULT nextval('public.mdl_analytics_predict_samples_id_seq'::regclass);


--
-- Name: mdl_analytics_prediction_actions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_analytics_prediction_actions ALTER COLUMN id SET DEFAULT nextval('public.mdl_analytics_prediction_actions_id_seq'::regclass);


--
-- Name: mdl_analytics_predictions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_analytics_predictions ALTER COLUMN id SET DEFAULT nextval('public.mdl_analytics_predictions_id_seq'::regclass);


--
-- Name: mdl_analytics_train_samples id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_analytics_train_samples ALTER COLUMN id SET DEFAULT nextval('public.mdl_analytics_train_samples_id_seq'::regclass);


--
-- Name: mdl_analytics_used_analysables id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_analytics_used_analysables ALTER COLUMN id SET DEFAULT nextval('public.mdl_analytics_used_analysables_id_seq'::regclass);


--
-- Name: mdl_analytics_used_files id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_analytics_used_files ALTER COLUMN id SET DEFAULT nextval('public.mdl_analytics_used_files_id_seq'::regclass);


--
-- Name: mdl_assign id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assign ALTER COLUMN id SET DEFAULT nextval('public.mdl_assign_id_seq'::regclass);


--
-- Name: mdl_assign_grades id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assign_grades ALTER COLUMN id SET DEFAULT nextval('public.mdl_assign_grades_id_seq'::regclass);


--
-- Name: mdl_assign_overrides id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assign_overrides ALTER COLUMN id SET DEFAULT nextval('public.mdl_assign_overrides_id_seq'::regclass);


--
-- Name: mdl_assign_plugin_config id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assign_plugin_config ALTER COLUMN id SET DEFAULT nextval('public.mdl_assign_plugin_config_id_seq'::regclass);


--
-- Name: mdl_assign_submission id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assign_submission ALTER COLUMN id SET DEFAULT nextval('public.mdl_assign_submission_id_seq'::regclass);


--
-- Name: mdl_assign_user_flags id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assign_user_flags ALTER COLUMN id SET DEFAULT nextval('public.mdl_assign_user_flags_id_seq'::regclass);


--
-- Name: mdl_assign_user_mapping id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assign_user_mapping ALTER COLUMN id SET DEFAULT nextval('public.mdl_assign_user_mapping_id_seq'::regclass);


--
-- Name: mdl_assignfeedback_comments id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assignfeedback_comments ALTER COLUMN id SET DEFAULT nextval('public.mdl_assignfeedback_comments_id_seq'::regclass);


--
-- Name: mdl_assignfeedback_editpdf_annot id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assignfeedback_editpdf_annot ALTER COLUMN id SET DEFAULT nextval('public.mdl_assignfeedback_editpdf_annot_id_seq'::regclass);


--
-- Name: mdl_assignfeedback_editpdf_cmnt id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assignfeedback_editpdf_cmnt ALTER COLUMN id SET DEFAULT nextval('public.mdl_assignfeedback_editpdf_cmnt_id_seq'::regclass);


--
-- Name: mdl_assignfeedback_editpdf_queue id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assignfeedback_editpdf_queue ALTER COLUMN id SET DEFAULT nextval('public.mdl_assignfeedback_editpdf_queue_id_seq'::regclass);


--
-- Name: mdl_assignfeedback_editpdf_quick id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assignfeedback_editpdf_quick ALTER COLUMN id SET DEFAULT nextval('public.mdl_assignfeedback_editpdf_quick_id_seq'::regclass);


--
-- Name: mdl_assignfeedback_editpdf_rot id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assignfeedback_editpdf_rot ALTER COLUMN id SET DEFAULT nextval('public.mdl_assignfeedback_editpdf_rot_id_seq'::regclass);


--
-- Name: mdl_assignfeedback_file id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assignfeedback_file ALTER COLUMN id SET DEFAULT nextval('public.mdl_assignfeedback_file_id_seq'::regclass);


--
-- Name: mdl_assignment id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assignment ALTER COLUMN id SET DEFAULT nextval('public.mdl_assignment_id_seq'::regclass);


--
-- Name: mdl_assignment_submissions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assignment_submissions ALTER COLUMN id SET DEFAULT nextval('public.mdl_assignment_submissions_id_seq'::regclass);


--
-- Name: mdl_assignment_upgrade id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assignment_upgrade ALTER COLUMN id SET DEFAULT nextval('public.mdl_assignment_upgrade_id_seq'::regclass);


--
-- Name: mdl_assignsubmission_file id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assignsubmission_file ALTER COLUMN id SET DEFAULT nextval('public.mdl_assignsubmission_file_id_seq'::regclass);


--
-- Name: mdl_assignsubmission_onlinetext id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assignsubmission_onlinetext ALTER COLUMN id SET DEFAULT nextval('public.mdl_assignsubmission_onlinetext_id_seq'::regclass);


--
-- Name: mdl_auth_iomadoidc_prevlogin id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_auth_iomadoidc_prevlogin ALTER COLUMN id SET DEFAULT nextval('public.mdl_auth_iomadoidc_prevlogin_id_seq'::regclass);


--
-- Name: mdl_auth_iomadoidc_state id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_auth_iomadoidc_state ALTER COLUMN id SET DEFAULT nextval('public.mdl_auth_iomadoidc_state_id_seq'::regclass);


--
-- Name: mdl_auth_iomadoidc_token id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_auth_iomadoidc_token ALTER COLUMN id SET DEFAULT nextval('public.mdl_auth_iomadoidc_token_id_seq'::regclass);


--
-- Name: mdl_auth_oauth2_linked_login id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_auth_oauth2_linked_login ALTER COLUMN id SET DEFAULT nextval('public.mdl_auth_oauth2_linked_login_id_seq'::regclass);


--
-- Name: mdl_backup_controllers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_backup_controllers ALTER COLUMN id SET DEFAULT nextval('public.mdl_backup_controllers_id_seq'::regclass);


--
-- Name: mdl_backup_courses id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_backup_courses ALTER COLUMN id SET DEFAULT nextval('public.mdl_backup_courses_id_seq'::regclass);


--
-- Name: mdl_backup_logs id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_backup_logs ALTER COLUMN id SET DEFAULT nextval('public.mdl_backup_logs_id_seq'::regclass);


--
-- Name: mdl_badge id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_badge ALTER COLUMN id SET DEFAULT nextval('public.mdl_badge_id_seq'::regclass);


--
-- Name: mdl_badge_alignment id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_badge_alignment ALTER COLUMN id SET DEFAULT nextval('public.mdl_badge_alignment_id_seq'::regclass);


--
-- Name: mdl_badge_backpack id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_badge_backpack ALTER COLUMN id SET DEFAULT nextval('public.mdl_badge_backpack_id_seq'::regclass);


--
-- Name: mdl_badge_criteria id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_badge_criteria ALTER COLUMN id SET DEFAULT nextval('public.mdl_badge_criteria_id_seq'::regclass);


--
-- Name: mdl_badge_criteria_met id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_badge_criteria_met ALTER COLUMN id SET DEFAULT nextval('public.mdl_badge_criteria_met_id_seq'::regclass);


--
-- Name: mdl_badge_criteria_param id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_badge_criteria_param ALTER COLUMN id SET DEFAULT nextval('public.mdl_badge_criteria_param_id_seq'::regclass);


--
-- Name: mdl_badge_endorsement id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_badge_endorsement ALTER COLUMN id SET DEFAULT nextval('public.mdl_badge_endorsement_id_seq'::regclass);


--
-- Name: mdl_badge_external id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_badge_external ALTER COLUMN id SET DEFAULT nextval('public.mdl_badge_external_id_seq'::regclass);


--
-- Name: mdl_badge_external_backpack id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_badge_external_backpack ALTER COLUMN id SET DEFAULT nextval('public.mdl_badge_external_backpack_id_seq'::regclass);


--
-- Name: mdl_badge_external_identifier id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_badge_external_identifier ALTER COLUMN id SET DEFAULT nextval('public.mdl_badge_external_identifier_id_seq'::regclass);


--
-- Name: mdl_badge_issued id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_badge_issued ALTER COLUMN id SET DEFAULT nextval('public.mdl_badge_issued_id_seq'::regclass);


--
-- Name: mdl_badge_manual_award id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_badge_manual_award ALTER COLUMN id SET DEFAULT nextval('public.mdl_badge_manual_award_id_seq'::regclass);


--
-- Name: mdl_badge_related id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_badge_related ALTER COLUMN id SET DEFAULT nextval('public.mdl_badge_related_id_seq'::regclass);


--
-- Name: mdl_block id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_block ALTER COLUMN id SET DEFAULT nextval('public.mdl_block_id_seq'::regclass);


--
-- Name: mdl_block_instances id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_block_instances ALTER COLUMN id SET DEFAULT nextval('public.mdl_block_instances_id_seq'::regclass);


--
-- Name: mdl_block_iomad_approve_access id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_block_iomad_approve_access ALTER COLUMN id SET DEFAULT nextval('public.mdl_block_iomad_approve_access_id_seq'::regclass);


--
-- Name: mdl_block_iomad_microlearning id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_block_iomad_microlearning ALTER COLUMN id SET DEFAULT nextval('public.mdl_block_iomad_microlearning_id_seq'::regclass);


--
-- Name: mdl_block_positions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_block_positions ALTER COLUMN id SET DEFAULT nextval('public.mdl_block_positions_id_seq'::regclass);


--
-- Name: mdl_block_recent_activity id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_block_recent_activity ALTER COLUMN id SET DEFAULT nextval('public.mdl_block_recent_activity_id_seq'::regclass);


--
-- Name: mdl_block_recentlyaccesseditems id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_block_recentlyaccesseditems ALTER COLUMN id SET DEFAULT nextval('public.mdl_block_recentlyaccesseditems_id_seq'::regclass);


--
-- Name: mdl_block_rss_client id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_block_rss_client ALTER COLUMN id SET DEFAULT nextval('public.mdl_block_rss_client_id_seq'::regclass);


--
-- Name: mdl_blog_association id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_blog_association ALTER COLUMN id SET DEFAULT nextval('public.mdl_blog_association_id_seq'::regclass);


--
-- Name: mdl_blog_external id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_blog_external ALTER COLUMN id SET DEFAULT nextval('public.mdl_blog_external_id_seq'::regclass);


--
-- Name: mdl_book id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_book ALTER COLUMN id SET DEFAULT nextval('public.mdl_book_id_seq'::regclass);


--
-- Name: mdl_book_chapters id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_book_chapters ALTER COLUMN id SET DEFAULT nextval('public.mdl_book_chapters_id_seq'::regclass);


--
-- Name: mdl_cache_filters id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_cache_filters ALTER COLUMN id SET DEFAULT nextval('public.mdl_cache_filters_id_seq'::regclass);


--
-- Name: mdl_cache_flags id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_cache_flags ALTER COLUMN id SET DEFAULT nextval('public.mdl_cache_flags_id_seq'::regclass);


--
-- Name: mdl_capabilities id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_capabilities ALTER COLUMN id SET DEFAULT nextval('public.mdl_capabilities_id_seq'::regclass);


--
-- Name: mdl_certificate_serialnumber id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_certificate_serialnumber ALTER COLUMN id SET DEFAULT nextval('public.mdl_certificate_serialnumber_id_seq'::regclass);


--
-- Name: mdl_chat id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_chat ALTER COLUMN id SET DEFAULT nextval('public.mdl_chat_id_seq'::regclass);


--
-- Name: mdl_chat_messages id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_chat_messages ALTER COLUMN id SET DEFAULT nextval('public.mdl_chat_messages_id_seq'::regclass);


--
-- Name: mdl_chat_messages_current id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_chat_messages_current ALTER COLUMN id SET DEFAULT nextval('public.mdl_chat_messages_current_id_seq'::regclass);


--
-- Name: mdl_chat_users id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_chat_users ALTER COLUMN id SET DEFAULT nextval('public.mdl_chat_users_id_seq'::regclass);


--
-- Name: mdl_choice id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_choice ALTER COLUMN id SET DEFAULT nextval('public.mdl_choice_id_seq'::regclass);


--
-- Name: mdl_choice_answers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_choice_answers ALTER COLUMN id SET DEFAULT nextval('public.mdl_choice_answers_id_seq'::regclass);


--
-- Name: mdl_choice_options id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_choice_options ALTER COLUMN id SET DEFAULT nextval('public.mdl_choice_options_id_seq'::regclass);


--
-- Name: mdl_classroom id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_classroom ALTER COLUMN id SET DEFAULT nextval('public.mdl_classroom_id_seq'::regclass);


--
-- Name: mdl_cohort id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_cohort ALTER COLUMN id SET DEFAULT nextval('public.mdl_cohort_id_seq'::regclass);


--
-- Name: mdl_cohort_members id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_cohort_members ALTER COLUMN id SET DEFAULT nextval('public.mdl_cohort_members_id_seq'::regclass);


--
-- Name: mdl_comments id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_comments ALTER COLUMN id SET DEFAULT nextval('public.mdl_comments_id_seq'::regclass);


--
-- Name: mdl_company id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_company ALTER COLUMN id SET DEFAULT nextval('public.mdl_company_id_seq'::regclass);


--
-- Name: mdl_company_comp_frameworks id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_company_comp_frameworks ALTER COLUMN id SET DEFAULT nextval('public.mdl_company_comp_frameworks_id_seq'::regclass);


--
-- Name: mdl_company_comp_templates id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_company_comp_templates ALTER COLUMN id SET DEFAULT nextval('public.mdl_company_comp_templates_id_seq'::regclass);


--
-- Name: mdl_company_course id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_company_course ALTER COLUMN id SET DEFAULT nextval('public.mdl_company_course_id_seq'::regclass);


--
-- Name: mdl_company_course_groups id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_company_course_groups ALTER COLUMN id SET DEFAULT nextval('public.mdl_company_course_groups_id_seq'::regclass);


--
-- Name: mdl_company_created_courses id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_company_created_courses ALTER COLUMN id SET DEFAULT nextval('public.mdl_company_created_courses_id_seq'::regclass);


--
-- Name: mdl_company_domains id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_company_domains ALTER COLUMN id SET DEFAULT nextval('public.mdl_company_domains_id_seq'::regclass);


--
-- Name: mdl_company_role_restriction id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_company_role_restriction ALTER COLUMN id SET DEFAULT nextval('public.mdl_company_role_restriction_id_seq'::regclass);


--
-- Name: mdl_company_role_templates id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_company_role_templates ALTER COLUMN id SET DEFAULT nextval('public.mdl_company_role_templates_id_seq'::regclass);


--
-- Name: mdl_company_role_templates_ass id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_company_role_templates_ass ALTER COLUMN id SET DEFAULT nextval('public.mdl_company_role_templates_ass_id_seq'::regclass);


--
-- Name: mdl_company_role_templates_caps id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_company_role_templates_caps ALTER COLUMN id SET DEFAULT nextval('public.mdl_company_role_templates_caps_id_seq'::regclass);


--
-- Name: mdl_company_shared_courses id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_company_shared_courses ALTER COLUMN id SET DEFAULT nextval('public.mdl_company_shared_courses_id_seq'::regclass);


--
-- Name: mdl_company_shared_frameworks id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_company_shared_frameworks ALTER COLUMN id SET DEFAULT nextval('public.mdl_company_shared_frameworks_id_seq'::regclass);


--
-- Name: mdl_company_shared_templates id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_company_shared_templates ALTER COLUMN id SET DEFAULT nextval('public.mdl_company_shared_templates_id_seq'::regclass);


--
-- Name: mdl_company_transient_tokens id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_company_transient_tokens ALTER COLUMN id SET DEFAULT nextval('public.mdl_company_transient_tokens_id_seq'::regclass);


--
-- Name: mdl_company_users id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_company_users ALTER COLUMN id SET DEFAULT nextval('public.mdl_company_users_id_seq'::regclass);


--
-- Name: mdl_companycertificate id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_companycertificate ALTER COLUMN id SET DEFAULT nextval('public.mdl_companycertificate_id_seq'::regclass);


--
-- Name: mdl_companylicense id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_companylicense ALTER COLUMN id SET DEFAULT nextval('public.mdl_companylicense_id_seq'::regclass);


--
-- Name: mdl_companylicense_courses id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_companylicense_courses ALTER COLUMN id SET DEFAULT nextval('public.mdl_companylicense_courses_id_seq'::regclass);


--
-- Name: mdl_companylicense_users id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_companylicense_users ALTER COLUMN id SET DEFAULT nextval('public.mdl_companylicense_users_id_seq'::regclass);


--
-- Name: mdl_competency id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_id_seq'::regclass);


--
-- Name: mdl_competency_coursecomp id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_coursecomp ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_coursecomp_id_seq'::regclass);


--
-- Name: mdl_competency_coursecompsetting id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_coursecompsetting ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_coursecompsetting_id_seq'::regclass);


--
-- Name: mdl_competency_evidence id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_evidence ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_evidence_id_seq'::regclass);


--
-- Name: mdl_competency_framework id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_framework ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_framework_id_seq'::regclass);


--
-- Name: mdl_competency_modulecomp id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_modulecomp ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_modulecomp_id_seq'::regclass);


--
-- Name: mdl_competency_plan id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_plan ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_plan_id_seq'::regclass);


--
-- Name: mdl_competency_plancomp id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_plancomp ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_plancomp_id_seq'::regclass);


--
-- Name: mdl_competency_relatedcomp id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_relatedcomp ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_relatedcomp_id_seq'::regclass);


--
-- Name: mdl_competency_template id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_template ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_template_id_seq'::regclass);


--
-- Name: mdl_competency_templatecohort id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_templatecohort ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_templatecohort_id_seq'::regclass);


--
-- Name: mdl_competency_templatecomp id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_templatecomp ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_templatecomp_id_seq'::regclass);


--
-- Name: mdl_competency_usercomp id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_usercomp ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_usercomp_id_seq'::regclass);


--
-- Name: mdl_competency_usercompcourse id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_usercompcourse ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_usercompcourse_id_seq'::regclass);


--
-- Name: mdl_competency_usercompplan id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_usercompplan ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_usercompplan_id_seq'::regclass);


--
-- Name: mdl_competency_userevidence id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_userevidence ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_userevidence_id_seq'::regclass);


--
-- Name: mdl_competency_userevidencecomp id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_userevidencecomp ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_userevidencecomp_id_seq'::regclass);


--
-- Name: mdl_config id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_config ALTER COLUMN id SET DEFAULT nextval('public.mdl_config_id_seq'::regclass);


--
-- Name: mdl_config_log id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_config_log ALTER COLUMN id SET DEFAULT nextval('public.mdl_config_log_id_seq'::regclass);


--
-- Name: mdl_config_plugins id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_config_plugins ALTER COLUMN id SET DEFAULT nextval('public.mdl_config_plugins_id_seq'::regclass);


--
-- Name: mdl_context id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_context ALTER COLUMN id SET DEFAULT nextval('public.mdl_context_id_seq'::regclass);


--
-- Name: mdl_course id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_id_seq'::regclass);


--
-- Name: mdl_course_categories id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course_categories ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_categories_id_seq'::regclass);


--
-- Name: mdl_course_completion_aggr_methd id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course_completion_aggr_methd ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_completion_aggr_methd_id_seq'::regclass);


--
-- Name: mdl_course_completion_crit_compl id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course_completion_crit_compl ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_completion_crit_compl_id_seq'::regclass);


--
-- Name: mdl_course_completion_criteria id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course_completion_criteria ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_completion_criteria_id_seq'::regclass);


--
-- Name: mdl_course_completion_defaults id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course_completion_defaults ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_completion_defaults_id_seq'::regclass);


--
-- Name: mdl_course_completions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course_completions ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_completions_id_seq'::regclass);


--
-- Name: mdl_course_format_options id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course_format_options ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_format_options_id_seq'::regclass);


--
-- Name: mdl_course_modules id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course_modules ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_modules_id_seq'::regclass);


--
-- Name: mdl_course_modules_completion id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course_modules_completion ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_modules_completion_id_seq'::regclass);


--
-- Name: mdl_course_published id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course_published ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_published_id_seq'::regclass);


--
-- Name: mdl_course_request id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course_request ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_request_id_seq'::regclass);


--
-- Name: mdl_course_sections id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course_sections ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_sections_id_seq'::regclass);


--
-- Name: mdl_course_shopblockprice id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course_shopblockprice ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_shopblockprice_id_seq'::regclass);


--
-- Name: mdl_course_shopsettings id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course_shopsettings ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_shopsettings_id_seq'::regclass);


--
-- Name: mdl_course_shoptag id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course_shoptag ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_shoptag_id_seq'::regclass);


--
-- Name: mdl_customfield_category id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_customfield_category ALTER COLUMN id SET DEFAULT nextval('public.mdl_customfield_category_id_seq'::regclass);


--
-- Name: mdl_customfield_data id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_customfield_data ALTER COLUMN id SET DEFAULT nextval('public.mdl_customfield_data_id_seq'::regclass);


--
-- Name: mdl_customfield_field id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_customfield_field ALTER COLUMN id SET DEFAULT nextval('public.mdl_customfield_field_id_seq'::regclass);


--
-- Name: mdl_data id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_data ALTER COLUMN id SET DEFAULT nextval('public.mdl_data_id_seq'::regclass);


--
-- Name: mdl_data_content id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_data_content ALTER COLUMN id SET DEFAULT nextval('public.mdl_data_content_id_seq'::regclass);


--
-- Name: mdl_data_fields id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_data_fields ALTER COLUMN id SET DEFAULT nextval('public.mdl_data_fields_id_seq'::regclass);


--
-- Name: mdl_data_records id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_data_records ALTER COLUMN id SET DEFAULT nextval('public.mdl_data_records_id_seq'::regclass);


--
-- Name: mdl_department id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_department ALTER COLUMN id SET DEFAULT nextval('public.mdl_department_id_seq'::regclass);


--
-- Name: mdl_editor_atto_autosave id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_editor_atto_autosave ALTER COLUMN id SET DEFAULT nextval('public.mdl_editor_atto_autosave_id_seq'::regclass);


--
-- Name: mdl_email id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_email ALTER COLUMN id SET DEFAULT nextval('public.mdl_email_id_seq'::regclass);


--
-- Name: mdl_email_template id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_email_template ALTER COLUMN id SET DEFAULT nextval('public.mdl_email_template_id_seq'::regclass);


--
-- Name: mdl_email_templateset id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_email_templateset ALTER COLUMN id SET DEFAULT nextval('public.mdl_email_templateset_id_seq'::regclass);


--
-- Name: mdl_email_templateset_templates id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_email_templateset_templates ALTER COLUMN id SET DEFAULT nextval('public.mdl_email_templateset_templates_id_seq'::regclass);


--
-- Name: mdl_enrol id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_enrol ALTER COLUMN id SET DEFAULT nextval('public.mdl_enrol_id_seq'::regclass);


--
-- Name: mdl_enrol_flatfile id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_enrol_flatfile ALTER COLUMN id SET DEFAULT nextval('public.mdl_enrol_flatfile_id_seq'::regclass);


--
-- Name: mdl_enrol_lti_lti2_consumer id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_enrol_lti_lti2_consumer ALTER COLUMN id SET DEFAULT nextval('public.mdl_enrol_lti_lti2_consumer_id_seq'::regclass);


--
-- Name: mdl_enrol_lti_lti2_context id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_enrol_lti_lti2_context ALTER COLUMN id SET DEFAULT nextval('public.mdl_enrol_lti_lti2_context_id_seq'::regclass);


--
-- Name: mdl_enrol_lti_lti2_nonce id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_enrol_lti_lti2_nonce ALTER COLUMN id SET DEFAULT nextval('public.mdl_enrol_lti_lti2_nonce_id_seq'::regclass);


--
-- Name: mdl_enrol_lti_lti2_resource_link id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_enrol_lti_lti2_resource_link ALTER COLUMN id SET DEFAULT nextval('public.mdl_enrol_lti_lti2_resource_link_id_seq'::regclass);


--
-- Name: mdl_enrol_lti_lti2_share_key id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_enrol_lti_lti2_share_key ALTER COLUMN id SET DEFAULT nextval('public.mdl_enrol_lti_lti2_share_key_id_seq'::regclass);


--
-- Name: mdl_enrol_lti_lti2_tool_proxy id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_enrol_lti_lti2_tool_proxy ALTER COLUMN id SET DEFAULT nextval('public.mdl_enrol_lti_lti2_tool_proxy_id_seq'::regclass);


--
-- Name: mdl_enrol_lti_lti2_user_result id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_enrol_lti_lti2_user_result ALTER COLUMN id SET DEFAULT nextval('public.mdl_enrol_lti_lti2_user_result_id_seq'::regclass);


--
-- Name: mdl_enrol_lti_tool_consumer_map id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_enrol_lti_tool_consumer_map ALTER COLUMN id SET DEFAULT nextval('public.mdl_enrol_lti_tool_consumer_map_id_seq'::regclass);


--
-- Name: mdl_enrol_lti_tools id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_enrol_lti_tools ALTER COLUMN id SET DEFAULT nextval('public.mdl_enrol_lti_tools_id_seq'::regclass);


--
-- Name: mdl_enrol_lti_users id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_enrol_lti_users ALTER COLUMN id SET DEFAULT nextval('public.mdl_enrol_lti_users_id_seq'::regclass);


--
-- Name: mdl_enrol_paypal id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_enrol_paypal ALTER COLUMN id SET DEFAULT nextval('public.mdl_enrol_paypal_id_seq'::regclass);


--
-- Name: mdl_event id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_event ALTER COLUMN id SET DEFAULT nextval('public.mdl_event_id_seq'::regclass);


--
-- Name: mdl_event_subscriptions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_event_subscriptions ALTER COLUMN id SET DEFAULT nextval('public.mdl_event_subscriptions_id_seq'::regclass);


--
-- Name: mdl_events_handlers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_events_handlers ALTER COLUMN id SET DEFAULT nextval('public.mdl_events_handlers_id_seq'::regclass);


--
-- Name: mdl_events_queue id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_events_queue ALTER COLUMN id SET DEFAULT nextval('public.mdl_events_queue_id_seq'::regclass);


--
-- Name: mdl_events_queue_handlers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_events_queue_handlers ALTER COLUMN id SET DEFAULT nextval('public.mdl_events_queue_handlers_id_seq'::regclass);


--
-- Name: mdl_external_functions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_external_functions ALTER COLUMN id SET DEFAULT nextval('public.mdl_external_functions_id_seq'::regclass);


--
-- Name: mdl_external_services id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_external_services ALTER COLUMN id SET DEFAULT nextval('public.mdl_external_services_id_seq'::regclass);


--
-- Name: mdl_external_services_functions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_external_services_functions ALTER COLUMN id SET DEFAULT nextval('public.mdl_external_services_functions_id_seq'::regclass);


--
-- Name: mdl_external_services_users id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_external_services_users ALTER COLUMN id SET DEFAULT nextval('public.mdl_external_services_users_id_seq'::regclass);


--
-- Name: mdl_external_tokens id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_external_tokens ALTER COLUMN id SET DEFAULT nextval('public.mdl_external_tokens_id_seq'::regclass);


--
-- Name: mdl_favourite id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_favourite ALTER COLUMN id SET DEFAULT nextval('public.mdl_favourite_id_seq'::regclass);


--
-- Name: mdl_feedback id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_feedback ALTER COLUMN id SET DEFAULT nextval('public.mdl_feedback_id_seq'::regclass);


--
-- Name: mdl_feedback_completed id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_feedback_completed ALTER COLUMN id SET DEFAULT nextval('public.mdl_feedback_completed_id_seq'::regclass);


--
-- Name: mdl_feedback_completedtmp id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_feedback_completedtmp ALTER COLUMN id SET DEFAULT nextval('public.mdl_feedback_completedtmp_id_seq'::regclass);


--
-- Name: mdl_feedback_item id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_feedback_item ALTER COLUMN id SET DEFAULT nextval('public.mdl_feedback_item_id_seq'::regclass);


--
-- Name: mdl_feedback_sitecourse_map id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_feedback_sitecourse_map ALTER COLUMN id SET DEFAULT nextval('public.mdl_feedback_sitecourse_map_id_seq'::regclass);


--
-- Name: mdl_feedback_template id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_feedback_template ALTER COLUMN id SET DEFAULT nextval('public.mdl_feedback_template_id_seq'::regclass);


--
-- Name: mdl_feedback_value id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_feedback_value ALTER COLUMN id SET DEFAULT nextval('public.mdl_feedback_value_id_seq'::regclass);


--
-- Name: mdl_feedback_valuetmp id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_feedback_valuetmp ALTER COLUMN id SET DEFAULT nextval('public.mdl_feedback_valuetmp_id_seq'::regclass);


--
-- Name: mdl_file_conversion id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_file_conversion ALTER COLUMN id SET DEFAULT nextval('public.mdl_file_conversion_id_seq'::regclass);


--
-- Name: mdl_files id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_files ALTER COLUMN id SET DEFAULT nextval('public.mdl_files_id_seq'::regclass);


--
-- Name: mdl_files_reference id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_files_reference ALTER COLUMN id SET DEFAULT nextval('public.mdl_files_reference_id_seq'::regclass);


--
-- Name: mdl_filter_active id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_filter_active ALTER COLUMN id SET DEFAULT nextval('public.mdl_filter_active_id_seq'::regclass);


--
-- Name: mdl_filter_config id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_filter_config ALTER COLUMN id SET DEFAULT nextval('public.mdl_filter_config_id_seq'::regclass);


--
-- Name: mdl_folder id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_folder ALTER COLUMN id SET DEFAULT nextval('public.mdl_folder_id_seq'::regclass);


--
-- Name: mdl_forum id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_forum ALTER COLUMN id SET DEFAULT nextval('public.mdl_forum_id_seq'::regclass);


--
-- Name: mdl_forum_digests id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_forum_digests ALTER COLUMN id SET DEFAULT nextval('public.mdl_forum_digests_id_seq'::regclass);


--
-- Name: mdl_forum_discussion_subs id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_forum_discussion_subs ALTER COLUMN id SET DEFAULT nextval('public.mdl_forum_discussion_subs_id_seq'::regclass);


--
-- Name: mdl_forum_discussions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_forum_discussions ALTER COLUMN id SET DEFAULT nextval('public.mdl_forum_discussions_id_seq'::regclass);


--
-- Name: mdl_forum_grades id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_forum_grades ALTER COLUMN id SET DEFAULT nextval('public.mdl_forum_grades_id_seq'::regclass);


--
-- Name: mdl_forum_posts id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_forum_posts ALTER COLUMN id SET DEFAULT nextval('public.mdl_forum_posts_id_seq'::regclass);


--
-- Name: mdl_forum_queue id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_forum_queue ALTER COLUMN id SET DEFAULT nextval('public.mdl_forum_queue_id_seq'::regclass);


--
-- Name: mdl_forum_read id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_forum_read ALTER COLUMN id SET DEFAULT nextval('public.mdl_forum_read_id_seq'::regclass);


--
-- Name: mdl_forum_subscriptions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_forum_subscriptions ALTER COLUMN id SET DEFAULT nextval('public.mdl_forum_subscriptions_id_seq'::regclass);


--
-- Name: mdl_forum_track_prefs id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_forum_track_prefs ALTER COLUMN id SET DEFAULT nextval('public.mdl_forum_track_prefs_id_seq'::regclass);


--
-- Name: mdl_glossary id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_glossary ALTER COLUMN id SET DEFAULT nextval('public.mdl_glossary_id_seq'::regclass);


--
-- Name: mdl_glossary_alias id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_glossary_alias ALTER COLUMN id SET DEFAULT nextval('public.mdl_glossary_alias_id_seq'::regclass);


--
-- Name: mdl_glossary_categories id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_glossary_categories ALTER COLUMN id SET DEFAULT nextval('public.mdl_glossary_categories_id_seq'::regclass);


--
-- Name: mdl_glossary_entries id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_glossary_entries ALTER COLUMN id SET DEFAULT nextval('public.mdl_glossary_entries_id_seq'::regclass);


--
-- Name: mdl_glossary_entries_categories id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_glossary_entries_categories ALTER COLUMN id SET DEFAULT nextval('public.mdl_glossary_entries_categories_id_seq'::regclass);


--
-- Name: mdl_glossary_formats id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_glossary_formats ALTER COLUMN id SET DEFAULT nextval('public.mdl_glossary_formats_id_seq'::regclass);


--
-- Name: mdl_grade_categories id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grade_categories ALTER COLUMN id SET DEFAULT nextval('public.mdl_grade_categories_id_seq'::regclass);


--
-- Name: mdl_grade_categories_history id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grade_categories_history ALTER COLUMN id SET DEFAULT nextval('public.mdl_grade_categories_history_id_seq'::regclass);


--
-- Name: mdl_grade_grades id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grade_grades ALTER COLUMN id SET DEFAULT nextval('public.mdl_grade_grades_id_seq'::regclass);


--
-- Name: mdl_grade_grades_history id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grade_grades_history ALTER COLUMN id SET DEFAULT nextval('public.mdl_grade_grades_history_id_seq'::regclass);


--
-- Name: mdl_grade_import_newitem id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grade_import_newitem ALTER COLUMN id SET DEFAULT nextval('public.mdl_grade_import_newitem_id_seq'::regclass);


--
-- Name: mdl_grade_import_values id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grade_import_values ALTER COLUMN id SET DEFAULT nextval('public.mdl_grade_import_values_id_seq'::regclass);


--
-- Name: mdl_grade_items id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grade_items ALTER COLUMN id SET DEFAULT nextval('public.mdl_grade_items_id_seq'::regclass);


--
-- Name: mdl_grade_items_history id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grade_items_history ALTER COLUMN id SET DEFAULT nextval('public.mdl_grade_items_history_id_seq'::regclass);


--
-- Name: mdl_grade_letters id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grade_letters ALTER COLUMN id SET DEFAULT nextval('public.mdl_grade_letters_id_seq'::regclass);


--
-- Name: mdl_grade_outcomes id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grade_outcomes ALTER COLUMN id SET DEFAULT nextval('public.mdl_grade_outcomes_id_seq'::regclass);


--
-- Name: mdl_grade_outcomes_courses id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grade_outcomes_courses ALTER COLUMN id SET DEFAULT nextval('public.mdl_grade_outcomes_courses_id_seq'::regclass);


--
-- Name: mdl_grade_outcomes_history id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grade_outcomes_history ALTER COLUMN id SET DEFAULT nextval('public.mdl_grade_outcomes_history_id_seq'::regclass);


--
-- Name: mdl_grade_settings id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grade_settings ALTER COLUMN id SET DEFAULT nextval('public.mdl_grade_settings_id_seq'::regclass);


--
-- Name: mdl_grading_areas id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grading_areas ALTER COLUMN id SET DEFAULT nextval('public.mdl_grading_areas_id_seq'::regclass);


--
-- Name: mdl_grading_definitions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grading_definitions ALTER COLUMN id SET DEFAULT nextval('public.mdl_grading_definitions_id_seq'::regclass);


--
-- Name: mdl_grading_instances id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grading_instances ALTER COLUMN id SET DEFAULT nextval('public.mdl_grading_instances_id_seq'::regclass);


--
-- Name: mdl_gradingform_guide_comments id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_gradingform_guide_comments ALTER COLUMN id SET DEFAULT nextval('public.mdl_gradingform_guide_comments_id_seq'::regclass);


--
-- Name: mdl_gradingform_guide_criteria id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_gradingform_guide_criteria ALTER COLUMN id SET DEFAULT nextval('public.mdl_gradingform_guide_criteria_id_seq'::regclass);


--
-- Name: mdl_gradingform_guide_fillings id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_gradingform_guide_fillings ALTER COLUMN id SET DEFAULT nextval('public.mdl_gradingform_guide_fillings_id_seq'::regclass);


--
-- Name: mdl_gradingform_rubric_criteria id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_gradingform_rubric_criteria ALTER COLUMN id SET DEFAULT nextval('public.mdl_gradingform_rubric_criteria_id_seq'::regclass);


--
-- Name: mdl_gradingform_rubric_fillings id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_gradingform_rubric_fillings ALTER COLUMN id SET DEFAULT nextval('public.mdl_gradingform_rubric_fillings_id_seq'::regclass);


--
-- Name: mdl_gradingform_rubric_levels id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_gradingform_rubric_levels ALTER COLUMN id SET DEFAULT nextval('public.mdl_gradingform_rubric_levels_id_seq'::regclass);


--
-- Name: mdl_groupings id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_groupings ALTER COLUMN id SET DEFAULT nextval('public.mdl_groupings_id_seq'::regclass);


--
-- Name: mdl_groupings_groups id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_groupings_groups ALTER COLUMN id SET DEFAULT nextval('public.mdl_groupings_groups_id_seq'::regclass);


--
-- Name: mdl_groups id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_groups ALTER COLUMN id SET DEFAULT nextval('public.mdl_groups_id_seq'::regclass);


--
-- Name: mdl_groups_members id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_groups_members ALTER COLUMN id SET DEFAULT nextval('public.mdl_groups_members_id_seq'::regclass);


--
-- Name: mdl_h5p id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_h5p ALTER COLUMN id SET DEFAULT nextval('public.mdl_h5p_id_seq'::regclass);


--
-- Name: mdl_h5p_contents_libraries id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_h5p_contents_libraries ALTER COLUMN id SET DEFAULT nextval('public.mdl_h5p_contents_libraries_id_seq'::regclass);


--
-- Name: mdl_h5p_libraries id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_h5p_libraries ALTER COLUMN id SET DEFAULT nextval('public.mdl_h5p_libraries_id_seq'::regclass);


--
-- Name: mdl_h5p_libraries_cachedassets id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_h5p_libraries_cachedassets ALTER COLUMN id SET DEFAULT nextval('public.mdl_h5p_libraries_cachedassets_id_seq'::regclass);


--
-- Name: mdl_h5p_library_dependencies id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_h5p_library_dependencies ALTER COLUMN id SET DEFAULT nextval('public.mdl_h5p_library_dependencies_id_seq'::regclass);


--
-- Name: mdl_imscp id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_imscp ALTER COLUMN id SET DEFAULT nextval('public.mdl_imscp_id_seq'::regclass);


--
-- Name: mdl_invoice id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_invoice ALTER COLUMN id SET DEFAULT nextval('public.mdl_invoice_id_seq'::regclass);


--
-- Name: mdl_invoiceitem id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_invoiceitem ALTER COLUMN id SET DEFAULT nextval('public.mdl_invoiceitem_id_seq'::regclass);


--
-- Name: mdl_iomad_courses id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_iomad_courses ALTER COLUMN id SET DEFAULT nextval('public.mdl_iomad_courses_id_seq'::regclass);


--
-- Name: mdl_iomad_frameworks id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_iomad_frameworks ALTER COLUMN id SET DEFAULT nextval('public.mdl_iomad_frameworks_id_seq'::regclass);


--
-- Name: mdl_iomad_learningpath id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_iomad_learningpath ALTER COLUMN id SET DEFAULT nextval('public.mdl_iomad_learningpath_id_seq'::regclass);


--
-- Name: mdl_iomad_learningpathcourse id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_iomad_learningpathcourse ALTER COLUMN id SET DEFAULT nextval('public.mdl_iomad_learningpathcourse_id_seq'::regclass);


--
-- Name: mdl_iomad_learningpathgroup id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_iomad_learningpathgroup ALTER COLUMN id SET DEFAULT nextval('public.mdl_iomad_learningpathgroup_id_seq'::regclass);


--
-- Name: mdl_iomad_learningpathuser id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_iomad_learningpathuser ALTER COLUMN id SET DEFAULT nextval('public.mdl_iomad_learningpathuser_id_seq'::regclass);


--
-- Name: mdl_iomad_templates id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_iomad_templates ALTER COLUMN id SET DEFAULT nextval('public.mdl_iomad_templates_id_seq'::regclass);


--
-- Name: mdl_iomadcertificate id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_iomadcertificate ALTER COLUMN id SET DEFAULT nextval('public.mdl_iomadcertificate_id_seq'::regclass);


--
-- Name: mdl_iomadcertificate_issues id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_iomadcertificate_issues ALTER COLUMN id SET DEFAULT nextval('public.mdl_iomadcertificate_issues_id_seq'::regclass);


--
-- Name: mdl_label id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_label ALTER COLUMN id SET DEFAULT nextval('public.mdl_label_id_seq'::regclass);


--
-- Name: mdl_lesson id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lesson ALTER COLUMN id SET DEFAULT nextval('public.mdl_lesson_id_seq'::regclass);


--
-- Name: mdl_lesson_answers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lesson_answers ALTER COLUMN id SET DEFAULT nextval('public.mdl_lesson_answers_id_seq'::regclass);


--
-- Name: mdl_lesson_attempts id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lesson_attempts ALTER COLUMN id SET DEFAULT nextval('public.mdl_lesson_attempts_id_seq'::regclass);


--
-- Name: mdl_lesson_branch id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lesson_branch ALTER COLUMN id SET DEFAULT nextval('public.mdl_lesson_branch_id_seq'::regclass);


--
-- Name: mdl_lesson_grades id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lesson_grades ALTER COLUMN id SET DEFAULT nextval('public.mdl_lesson_grades_id_seq'::regclass);


--
-- Name: mdl_lesson_overrides id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lesson_overrides ALTER COLUMN id SET DEFAULT nextval('public.mdl_lesson_overrides_id_seq'::regclass);


--
-- Name: mdl_lesson_pages id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lesson_pages ALTER COLUMN id SET DEFAULT nextval('public.mdl_lesson_pages_id_seq'::regclass);


--
-- Name: mdl_lesson_timer id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lesson_timer ALTER COLUMN id SET DEFAULT nextval('public.mdl_lesson_timer_id_seq'::regclass);


--
-- Name: mdl_license id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_license ALTER COLUMN id SET DEFAULT nextval('public.mdl_license_id_seq'::regclass);


--
-- Name: mdl_local_iomad_track id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_local_iomad_track ALTER COLUMN id SET DEFAULT nextval('public.mdl_local_iomad_track_id_seq'::regclass);


--
-- Name: mdl_local_iomad_track_certs id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_local_iomad_track_certs ALTER COLUMN id SET DEFAULT nextval('public.mdl_local_iomad_track_certs_id_seq'::regclass);


--
-- Name: mdl_local_report_user_lic_allocs id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_local_report_user_lic_allocs ALTER COLUMN id SET DEFAULT nextval('public.mdl_local_report_user_lic_allocs_id_seq'::regclass);


--
-- Name: mdl_local_report_user_logins id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_local_report_user_logins ALTER COLUMN id SET DEFAULT nextval('public.mdl_local_report_user_logins_id_seq'::regclass);


--
-- Name: mdl_lock_db id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lock_db ALTER COLUMN id SET DEFAULT nextval('public.mdl_lock_db_id_seq'::regclass);


--
-- Name: mdl_log id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_log ALTER COLUMN id SET DEFAULT nextval('public.mdl_log_id_seq'::regclass);


--
-- Name: mdl_log_display id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_log_display ALTER COLUMN id SET DEFAULT nextval('public.mdl_log_display_id_seq'::regclass);


--
-- Name: mdl_log_queries id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_log_queries ALTER COLUMN id SET DEFAULT nextval('public.mdl_log_queries_id_seq'::regclass);


--
-- Name: mdl_logstore_standard_log id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_logstore_standard_log ALTER COLUMN id SET DEFAULT nextval('public.mdl_logstore_standard_log_id_seq'::regclass);


--
-- Name: mdl_lti id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lti ALTER COLUMN id SET DEFAULT nextval('public.mdl_lti_id_seq'::regclass);


--
-- Name: mdl_lti_access_tokens id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lti_access_tokens ALTER COLUMN id SET DEFAULT nextval('public.mdl_lti_access_tokens_id_seq'::regclass);


--
-- Name: mdl_lti_submission id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lti_submission ALTER COLUMN id SET DEFAULT nextval('public.mdl_lti_submission_id_seq'::regclass);


--
-- Name: mdl_lti_tool_proxies id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lti_tool_proxies ALTER COLUMN id SET DEFAULT nextval('public.mdl_lti_tool_proxies_id_seq'::regclass);


--
-- Name: mdl_lti_tool_settings id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lti_tool_settings ALTER COLUMN id SET DEFAULT nextval('public.mdl_lti_tool_settings_id_seq'::regclass);


--
-- Name: mdl_lti_types id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lti_types ALTER COLUMN id SET DEFAULT nextval('public.mdl_lti_types_id_seq'::regclass);


--
-- Name: mdl_lti_types_config id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lti_types_config ALTER COLUMN id SET DEFAULT nextval('public.mdl_lti_types_config_id_seq'::regclass);


--
-- Name: mdl_ltiservice_gradebookservices id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_ltiservice_gradebookservices ALTER COLUMN id SET DEFAULT nextval('public.mdl_ltiservice_gradebookservices_id_seq'::regclass);


--
-- Name: mdl_message id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_id_seq'::regclass);


--
-- Name: mdl_message_airnotifier_devices id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message_airnotifier_devices ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_airnotifier_devices_id_seq'::regclass);


--
-- Name: mdl_message_contact_requests id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message_contact_requests ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_contact_requests_id_seq'::regclass);


--
-- Name: mdl_message_contacts id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message_contacts ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_contacts_id_seq'::regclass);


--
-- Name: mdl_message_conversation_actions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message_conversation_actions ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_conversation_actions_id_seq'::regclass);


--
-- Name: mdl_message_conversation_members id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message_conversation_members ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_conversation_members_id_seq'::regclass);


--
-- Name: mdl_message_conversations id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message_conversations ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_conversations_id_seq'::regclass);


--
-- Name: mdl_message_email_messages id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message_email_messages ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_email_messages_id_seq'::regclass);


--
-- Name: mdl_message_popup id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message_popup ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_popup_id_seq'::regclass);


--
-- Name: mdl_message_popup_notifications id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message_popup_notifications ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_popup_notifications_id_seq'::regclass);


--
-- Name: mdl_message_processors id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message_processors ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_processors_id_seq'::regclass);


--
-- Name: mdl_message_providers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message_providers ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_providers_id_seq'::regclass);


--
-- Name: mdl_message_read id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message_read ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_read_id_seq'::regclass);


--
-- Name: mdl_message_user_actions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message_user_actions ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_user_actions_id_seq'::regclass);


--
-- Name: mdl_message_users_blocked id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message_users_blocked ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_users_blocked_id_seq'::regclass);


--
-- Name: mdl_messageinbound_datakeys id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_messageinbound_datakeys ALTER COLUMN id SET DEFAULT nextval('public.mdl_messageinbound_datakeys_id_seq'::regclass);


--
-- Name: mdl_messageinbound_handlers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_messageinbound_handlers ALTER COLUMN id SET DEFAULT nextval('public.mdl_messageinbound_handlers_id_seq'::regclass);


--
-- Name: mdl_messageinbound_messagelist id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_messageinbound_messagelist ALTER COLUMN id SET DEFAULT nextval('public.mdl_messageinbound_messagelist_id_seq'::regclass);


--
-- Name: mdl_messages id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_messages ALTER COLUMN id SET DEFAULT nextval('public.mdl_messages_id_seq'::regclass);


--
-- Name: mdl_microlearning_nugget id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_microlearning_nugget ALTER COLUMN id SET DEFAULT nextval('public.mdl_microlearning_nugget_id_seq'::regclass);


--
-- Name: mdl_microlearning_nugget_sched id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_microlearning_nugget_sched ALTER COLUMN id SET DEFAULT nextval('public.mdl_microlearning_nugget_sched_id_seq'::regclass);


--
-- Name: mdl_microlearning_thread id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_microlearning_thread ALTER COLUMN id SET DEFAULT nextval('public.mdl_microlearning_thread_id_seq'::regclass);


--
-- Name: mdl_microlearning_thread_user id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_microlearning_thread_user ALTER COLUMN id SET DEFAULT nextval('public.mdl_microlearning_thread_user_id_seq'::regclass);


--
-- Name: mdl_mnet_application id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_mnet_application ALTER COLUMN id SET DEFAULT nextval('public.mdl_mnet_application_id_seq'::regclass);


--
-- Name: mdl_mnet_host id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_mnet_host ALTER COLUMN id SET DEFAULT nextval('public.mdl_mnet_host_id_seq'::regclass);


--
-- Name: mdl_mnet_host2service id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_mnet_host2service ALTER COLUMN id SET DEFAULT nextval('public.mdl_mnet_host2service_id_seq'::regclass);


--
-- Name: mdl_mnet_log id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_mnet_log ALTER COLUMN id SET DEFAULT nextval('public.mdl_mnet_log_id_seq'::regclass);


--
-- Name: mdl_mnet_remote_rpc id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_mnet_remote_rpc ALTER COLUMN id SET DEFAULT nextval('public.mdl_mnet_remote_rpc_id_seq'::regclass);


--
-- Name: mdl_mnet_remote_service2rpc id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_mnet_remote_service2rpc ALTER COLUMN id SET DEFAULT nextval('public.mdl_mnet_remote_service2rpc_id_seq'::regclass);


--
-- Name: mdl_mnet_rpc id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_mnet_rpc ALTER COLUMN id SET DEFAULT nextval('public.mdl_mnet_rpc_id_seq'::regclass);


--
-- Name: mdl_mnet_service id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_mnet_service ALTER COLUMN id SET DEFAULT nextval('public.mdl_mnet_service_id_seq'::regclass);


--
-- Name: mdl_mnet_service2rpc id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_mnet_service2rpc ALTER COLUMN id SET DEFAULT nextval('public.mdl_mnet_service2rpc_id_seq'::regclass);


--
-- Name: mdl_mnet_session id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_mnet_session ALTER COLUMN id SET DEFAULT nextval('public.mdl_mnet_session_id_seq'::regclass);


--
-- Name: mdl_mnet_sso_access_control id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_mnet_sso_access_control ALTER COLUMN id SET DEFAULT nextval('public.mdl_mnet_sso_access_control_id_seq'::regclass);


--
-- Name: mdl_mnetservice_enrol_courses id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_mnetservice_enrol_courses ALTER COLUMN id SET DEFAULT nextval('public.mdl_mnetservice_enrol_courses_id_seq'::regclass);


--
-- Name: mdl_mnetservice_enrol_enrolments id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_mnetservice_enrol_enrolments ALTER COLUMN id SET DEFAULT nextval('public.mdl_mnetservice_enrol_enrolments_id_seq'::regclass);


--
-- Name: mdl_modules id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_modules ALTER COLUMN id SET DEFAULT nextval('public.mdl_modules_id_seq'::regclass);


--
-- Name: mdl_my_pages id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_my_pages ALTER COLUMN id SET DEFAULT nextval('public.mdl_my_pages_id_seq'::regclass);


--
-- Name: mdl_notifications id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_notifications ALTER COLUMN id SET DEFAULT nextval('public.mdl_notifications_id_seq'::regclass);


--
-- Name: mdl_oauth2_access_token id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_oauth2_access_token ALTER COLUMN id SET DEFAULT nextval('public.mdl_oauth2_access_token_id_seq'::regclass);


--
-- Name: mdl_oauth2_endpoint id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_oauth2_endpoint ALTER COLUMN id SET DEFAULT nextval('public.mdl_oauth2_endpoint_id_seq'::regclass);


--
-- Name: mdl_oauth2_issuer id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_oauth2_issuer ALTER COLUMN id SET DEFAULT nextval('public.mdl_oauth2_issuer_id_seq'::regclass);


--
-- Name: mdl_oauth2_system_account id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_oauth2_system_account ALTER COLUMN id SET DEFAULT nextval('public.mdl_oauth2_system_account_id_seq'::regclass);


--
-- Name: mdl_oauth2_user_field_mapping id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_oauth2_user_field_mapping ALTER COLUMN id SET DEFAULT nextval('public.mdl_oauth2_user_field_mapping_id_seq'::regclass);


--
-- Name: mdl_page id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_page ALTER COLUMN id SET DEFAULT nextval('public.mdl_page_id_seq'::regclass);


--
-- Name: mdl_portfolio_instance id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_portfolio_instance ALTER COLUMN id SET DEFAULT nextval('public.mdl_portfolio_instance_id_seq'::regclass);


--
-- Name: mdl_portfolio_instance_config id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_portfolio_instance_config ALTER COLUMN id SET DEFAULT nextval('public.mdl_portfolio_instance_config_id_seq'::regclass);


--
-- Name: mdl_portfolio_instance_user id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_portfolio_instance_user ALTER COLUMN id SET DEFAULT nextval('public.mdl_portfolio_instance_user_id_seq'::regclass);


--
-- Name: mdl_portfolio_log id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_portfolio_log ALTER COLUMN id SET DEFAULT nextval('public.mdl_portfolio_log_id_seq'::regclass);


--
-- Name: mdl_portfolio_mahara_queue id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_portfolio_mahara_queue ALTER COLUMN id SET DEFAULT nextval('public.mdl_portfolio_mahara_queue_id_seq'::regclass);


--
-- Name: mdl_portfolio_tempdata id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_portfolio_tempdata ALTER COLUMN id SET DEFAULT nextval('public.mdl_portfolio_tempdata_id_seq'::regclass);


--
-- Name: mdl_post id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_post ALTER COLUMN id SET DEFAULT nextval('public.mdl_post_id_seq'::regclass);


--
-- Name: mdl_profiling id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_profiling ALTER COLUMN id SET DEFAULT nextval('public.mdl_profiling_id_seq'::regclass);


--
-- Name: mdl_qtype_ddimageortext id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_qtype_ddimageortext ALTER COLUMN id SET DEFAULT nextval('public.mdl_qtype_ddimageortext_id_seq'::regclass);


--
-- Name: mdl_qtype_ddimageortext_drags id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_qtype_ddimageortext_drags ALTER COLUMN id SET DEFAULT nextval('public.mdl_qtype_ddimageortext_drags_id_seq'::regclass);


--
-- Name: mdl_qtype_ddimageortext_drops id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_qtype_ddimageortext_drops ALTER COLUMN id SET DEFAULT nextval('public.mdl_qtype_ddimageortext_drops_id_seq'::regclass);


--
-- Name: mdl_qtype_ddmarker id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_qtype_ddmarker ALTER COLUMN id SET DEFAULT nextval('public.mdl_qtype_ddmarker_id_seq'::regclass);


--
-- Name: mdl_qtype_ddmarker_drags id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_qtype_ddmarker_drags ALTER COLUMN id SET DEFAULT nextval('public.mdl_qtype_ddmarker_drags_id_seq'::regclass);


--
-- Name: mdl_qtype_ddmarker_drops id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_qtype_ddmarker_drops ALTER COLUMN id SET DEFAULT nextval('public.mdl_qtype_ddmarker_drops_id_seq'::regclass);


--
-- Name: mdl_qtype_essay_options id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_qtype_essay_options ALTER COLUMN id SET DEFAULT nextval('public.mdl_qtype_essay_options_id_seq'::regclass);


--
-- Name: mdl_qtype_match_options id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_qtype_match_options ALTER COLUMN id SET DEFAULT nextval('public.mdl_qtype_match_options_id_seq'::regclass);


--
-- Name: mdl_qtype_match_subquestions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_qtype_match_subquestions ALTER COLUMN id SET DEFAULT nextval('public.mdl_qtype_match_subquestions_id_seq'::regclass);


--
-- Name: mdl_qtype_multichoice_options id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_qtype_multichoice_options ALTER COLUMN id SET DEFAULT nextval('public.mdl_qtype_multichoice_options_id_seq'::regclass);


--
-- Name: mdl_qtype_randomsamatch_options id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_qtype_randomsamatch_options ALTER COLUMN id SET DEFAULT nextval('public.mdl_qtype_randomsamatch_options_id_seq'::regclass);


--
-- Name: mdl_qtype_shortanswer_options id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_qtype_shortanswer_options ALTER COLUMN id SET DEFAULT nextval('public.mdl_qtype_shortanswer_options_id_seq'::regclass);


--
-- Name: mdl_question id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_id_seq'::regclass);


--
-- Name: mdl_question_answers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_answers ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_answers_id_seq'::regclass);


--
-- Name: mdl_question_attempt_step_data id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_attempt_step_data ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_attempt_step_data_id_seq'::regclass);


--
-- Name: mdl_question_attempt_steps id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_attempt_steps ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_attempt_steps_id_seq'::regclass);


--
-- Name: mdl_question_attempts id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_attempts ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_attempts_id_seq'::regclass);


--
-- Name: mdl_question_calculated id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_calculated ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_calculated_id_seq'::regclass);


--
-- Name: mdl_question_calculated_options id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_calculated_options ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_calculated_options_id_seq'::regclass);


--
-- Name: mdl_question_categories id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_categories ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_categories_id_seq'::regclass);


--
-- Name: mdl_question_dataset_definitions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_dataset_definitions ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_dataset_definitions_id_seq'::regclass);


--
-- Name: mdl_question_dataset_items id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_dataset_items ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_dataset_items_id_seq'::regclass);


--
-- Name: mdl_question_datasets id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_datasets ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_datasets_id_seq'::regclass);


--
-- Name: mdl_question_ddwtos id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_ddwtos ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_ddwtos_id_seq'::regclass);


--
-- Name: mdl_question_gapselect id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_gapselect ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_gapselect_id_seq'::regclass);


--
-- Name: mdl_question_hints id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_hints ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_hints_id_seq'::regclass);


--
-- Name: mdl_question_multianswer id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_multianswer ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_multianswer_id_seq'::regclass);


--
-- Name: mdl_question_numerical id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_numerical ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_numerical_id_seq'::regclass);


--
-- Name: mdl_question_numerical_options id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_numerical_options ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_numerical_options_id_seq'::regclass);


--
-- Name: mdl_question_numerical_units id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_numerical_units ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_numerical_units_id_seq'::regclass);


--
-- Name: mdl_question_response_analysis id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_response_analysis ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_response_analysis_id_seq'::regclass);


--
-- Name: mdl_question_response_count id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_response_count ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_response_count_id_seq'::regclass);


--
-- Name: mdl_question_statistics id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_statistics ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_statistics_id_seq'::regclass);


--
-- Name: mdl_question_truefalse id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_truefalse ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_truefalse_id_seq'::regclass);


--
-- Name: mdl_question_usages id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_usages ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_usages_id_seq'::regclass);


--
-- Name: mdl_quiz id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_quiz ALTER COLUMN id SET DEFAULT nextval('public.mdl_quiz_id_seq'::regclass);


--
-- Name: mdl_quiz_attempts id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_quiz_attempts ALTER COLUMN id SET DEFAULT nextval('public.mdl_quiz_attempts_id_seq'::regclass);


--
-- Name: mdl_quiz_feedback id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_quiz_feedback ALTER COLUMN id SET DEFAULT nextval('public.mdl_quiz_feedback_id_seq'::regclass);


--
-- Name: mdl_quiz_grades id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_quiz_grades ALTER COLUMN id SET DEFAULT nextval('public.mdl_quiz_grades_id_seq'::regclass);


--
-- Name: mdl_quiz_overrides id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_quiz_overrides ALTER COLUMN id SET DEFAULT nextval('public.mdl_quiz_overrides_id_seq'::regclass);


--
-- Name: mdl_quiz_overview_regrades id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_quiz_overview_regrades ALTER COLUMN id SET DEFAULT nextval('public.mdl_quiz_overview_regrades_id_seq'::regclass);


--
-- Name: mdl_quiz_reports id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_quiz_reports ALTER COLUMN id SET DEFAULT nextval('public.mdl_quiz_reports_id_seq'::regclass);


--
-- Name: mdl_quiz_sections id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_quiz_sections ALTER COLUMN id SET DEFAULT nextval('public.mdl_quiz_sections_id_seq'::regclass);


--
-- Name: mdl_quiz_slot_tags id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_quiz_slot_tags ALTER COLUMN id SET DEFAULT nextval('public.mdl_quiz_slot_tags_id_seq'::regclass);


--
-- Name: mdl_quiz_slots id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_quiz_slots ALTER COLUMN id SET DEFAULT nextval('public.mdl_quiz_slots_id_seq'::regclass);


--
-- Name: mdl_quiz_statistics id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_quiz_statistics ALTER COLUMN id SET DEFAULT nextval('public.mdl_quiz_statistics_id_seq'::regclass);


--
-- Name: mdl_rating id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_rating ALTER COLUMN id SET DEFAULT nextval('public.mdl_rating_id_seq'::regclass);


--
-- Name: mdl_registration_hubs id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_registration_hubs ALTER COLUMN id SET DEFAULT nextval('public.mdl_registration_hubs_id_seq'::regclass);


--
-- Name: mdl_repository id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_repository ALTER COLUMN id SET DEFAULT nextval('public.mdl_repository_id_seq'::regclass);


--
-- Name: mdl_repository_instance_config id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_repository_instance_config ALTER COLUMN id SET DEFAULT nextval('public.mdl_repository_instance_config_id_seq'::regclass);


--
-- Name: mdl_repository_instances id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_repository_instances ALTER COLUMN id SET DEFAULT nextval('public.mdl_repository_instances_id_seq'::regclass);


--
-- Name: mdl_repository_onedrive_access id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_repository_onedrive_access ALTER COLUMN id SET DEFAULT nextval('public.mdl_repository_onedrive_access_id_seq'::regclass);


--
-- Name: mdl_resource id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_resource ALTER COLUMN id SET DEFAULT nextval('public.mdl_resource_id_seq'::regclass);


--
-- Name: mdl_resource_old id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_resource_old ALTER COLUMN id SET DEFAULT nextval('public.mdl_resource_old_id_seq'::regclass);


--
-- Name: mdl_role id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_role ALTER COLUMN id SET DEFAULT nextval('public.mdl_role_id_seq'::regclass);


--
-- Name: mdl_role_allow_assign id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_role_allow_assign ALTER COLUMN id SET DEFAULT nextval('public.mdl_role_allow_assign_id_seq'::regclass);


--
-- Name: mdl_role_allow_override id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_role_allow_override ALTER COLUMN id SET DEFAULT nextval('public.mdl_role_allow_override_id_seq'::regclass);


--
-- Name: mdl_role_allow_switch id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_role_allow_switch ALTER COLUMN id SET DEFAULT nextval('public.mdl_role_allow_switch_id_seq'::regclass);


--
-- Name: mdl_role_allow_view id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_role_allow_view ALTER COLUMN id SET DEFAULT nextval('public.mdl_role_allow_view_id_seq'::regclass);


--
-- Name: mdl_role_assignments id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_role_assignments ALTER COLUMN id SET DEFAULT nextval('public.mdl_role_assignments_id_seq'::regclass);


--
-- Name: mdl_role_capabilities id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_role_capabilities ALTER COLUMN id SET DEFAULT nextval('public.mdl_role_capabilities_id_seq'::regclass);


--
-- Name: mdl_role_context_levels id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_role_context_levels ALTER COLUMN id SET DEFAULT nextval('public.mdl_role_context_levels_id_seq'::regclass);


--
-- Name: mdl_role_names id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_role_names ALTER COLUMN id SET DEFAULT nextval('public.mdl_role_names_id_seq'::regclass);


--
-- Name: mdl_scale id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_scale ALTER COLUMN id SET DEFAULT nextval('public.mdl_scale_id_seq'::regclass);


--
-- Name: mdl_scale_history id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_scale_history ALTER COLUMN id SET DEFAULT nextval('public.mdl_scale_history_id_seq'::regclass);


--
-- Name: mdl_scorm id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_scorm ALTER COLUMN id SET DEFAULT nextval('public.mdl_scorm_id_seq'::regclass);


--
-- Name: mdl_scorm_aicc_session id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_scorm_aicc_session ALTER COLUMN id SET DEFAULT nextval('public.mdl_scorm_aicc_session_id_seq'::regclass);


--
-- Name: mdl_scorm_scoes id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_scorm_scoes ALTER COLUMN id SET DEFAULT nextval('public.mdl_scorm_scoes_id_seq'::regclass);


--
-- Name: mdl_scorm_scoes_data id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_scorm_scoes_data ALTER COLUMN id SET DEFAULT nextval('public.mdl_scorm_scoes_data_id_seq'::regclass);


--
-- Name: mdl_scorm_scoes_track id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_scorm_scoes_track ALTER COLUMN id SET DEFAULT nextval('public.mdl_scorm_scoes_track_id_seq'::regclass);


--
-- Name: mdl_scorm_seq_mapinfo id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_scorm_seq_mapinfo ALTER COLUMN id SET DEFAULT nextval('public.mdl_scorm_seq_mapinfo_id_seq'::regclass);


--
-- Name: mdl_scorm_seq_objective id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_scorm_seq_objective ALTER COLUMN id SET DEFAULT nextval('public.mdl_scorm_seq_objective_id_seq'::regclass);


--
-- Name: mdl_scorm_seq_rolluprule id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_scorm_seq_rolluprule ALTER COLUMN id SET DEFAULT nextval('public.mdl_scorm_seq_rolluprule_id_seq'::regclass);


--
-- Name: mdl_scorm_seq_rolluprulecond id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_scorm_seq_rolluprulecond ALTER COLUMN id SET DEFAULT nextval('public.mdl_scorm_seq_rolluprulecond_id_seq'::regclass);


--
-- Name: mdl_scorm_seq_rulecond id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_scorm_seq_rulecond ALTER COLUMN id SET DEFAULT nextval('public.mdl_scorm_seq_rulecond_id_seq'::regclass);


--
-- Name: mdl_scorm_seq_ruleconds id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_scorm_seq_ruleconds ALTER COLUMN id SET DEFAULT nextval('public.mdl_scorm_seq_ruleconds_id_seq'::regclass);


--
-- Name: mdl_search_index_requests id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_search_index_requests ALTER COLUMN id SET DEFAULT nextval('public.mdl_search_index_requests_id_seq'::regclass);


--
-- Name: mdl_search_simpledb_index id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_search_simpledb_index ALTER COLUMN id SET DEFAULT nextval('public.mdl_search_simpledb_index_id_seq'::regclass);


--
-- Name: mdl_sessions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_sessions ALTER COLUMN id SET DEFAULT nextval('public.mdl_sessions_id_seq'::regclass);


--
-- Name: mdl_shoptag id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_shoptag ALTER COLUMN id SET DEFAULT nextval('public.mdl_shoptag_id_seq'::regclass);


--
-- Name: mdl_stats_daily id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_stats_daily ALTER COLUMN id SET DEFAULT nextval('public.mdl_stats_daily_id_seq'::regclass);


--
-- Name: mdl_stats_monthly id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_stats_monthly ALTER COLUMN id SET DEFAULT nextval('public.mdl_stats_monthly_id_seq'::regclass);


--
-- Name: mdl_stats_user_daily id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_stats_user_daily ALTER COLUMN id SET DEFAULT nextval('public.mdl_stats_user_daily_id_seq'::regclass);


--
-- Name: mdl_stats_user_monthly id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_stats_user_monthly ALTER COLUMN id SET DEFAULT nextval('public.mdl_stats_user_monthly_id_seq'::regclass);


--
-- Name: mdl_stats_user_weekly id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_stats_user_weekly ALTER COLUMN id SET DEFAULT nextval('public.mdl_stats_user_weekly_id_seq'::regclass);


--
-- Name: mdl_stats_weekly id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_stats_weekly ALTER COLUMN id SET DEFAULT nextval('public.mdl_stats_weekly_id_seq'::regclass);


--
-- Name: mdl_survey id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_survey ALTER COLUMN id SET DEFAULT nextval('public.mdl_survey_id_seq'::regclass);


--
-- Name: mdl_survey_analysis id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_survey_analysis ALTER COLUMN id SET DEFAULT nextval('public.mdl_survey_analysis_id_seq'::regclass);


--
-- Name: mdl_survey_answers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_survey_answers ALTER COLUMN id SET DEFAULT nextval('public.mdl_survey_answers_id_seq'::regclass);


--
-- Name: mdl_survey_questions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_survey_questions ALTER COLUMN id SET DEFAULT nextval('public.mdl_survey_questions_id_seq'::regclass);


--
-- Name: mdl_tag id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tag ALTER COLUMN id SET DEFAULT nextval('public.mdl_tag_id_seq'::regclass);


--
-- Name: mdl_tag_area id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tag_area ALTER COLUMN id SET DEFAULT nextval('public.mdl_tag_area_id_seq'::regclass);


--
-- Name: mdl_tag_coll id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tag_coll ALTER COLUMN id SET DEFAULT nextval('public.mdl_tag_coll_id_seq'::regclass);


--
-- Name: mdl_tag_correlation id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tag_correlation ALTER COLUMN id SET DEFAULT nextval('public.mdl_tag_correlation_id_seq'::regclass);


--
-- Name: mdl_tag_instance id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tag_instance ALTER COLUMN id SET DEFAULT nextval('public.mdl_tag_instance_id_seq'::regclass);


--
-- Name: mdl_task_adhoc id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_task_adhoc ALTER COLUMN id SET DEFAULT nextval('public.mdl_task_adhoc_id_seq'::regclass);


--
-- Name: mdl_task_log id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_task_log ALTER COLUMN id SET DEFAULT nextval('public.mdl_task_log_id_seq'::regclass);


--
-- Name: mdl_task_scheduled id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_task_scheduled ALTER COLUMN id SET DEFAULT nextval('public.mdl_task_scheduled_id_seq'::regclass);


--
-- Name: mdl_tool_cohortroles id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_cohortroles ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_cohortroles_id_seq'::regclass);


--
-- Name: mdl_tool_customlang id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_customlang ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_customlang_id_seq'::regclass);


--
-- Name: mdl_tool_customlang_components id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_customlang_components ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_customlang_components_id_seq'::regclass);


--
-- Name: mdl_tool_dataprivacy_category id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_dataprivacy_category ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_dataprivacy_category_id_seq'::regclass);


--
-- Name: mdl_tool_dataprivacy_ctxexpired id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_dataprivacy_ctxexpired ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_dataprivacy_ctxexpired_id_seq'::regclass);


--
-- Name: mdl_tool_dataprivacy_ctxinstance id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_dataprivacy_ctxinstance ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_dataprivacy_ctxinstance_id_seq'::regclass);


--
-- Name: mdl_tool_dataprivacy_ctxlevel id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_dataprivacy_ctxlevel ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_dataprivacy_ctxlevel_id_seq'::regclass);


--
-- Name: mdl_tool_dataprivacy_purpose id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_dataprivacy_purpose ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_dataprivacy_purpose_id_seq'::regclass);


--
-- Name: mdl_tool_dataprivacy_purposerole id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_dataprivacy_purposerole ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_dataprivacy_purposerole_id_seq'::regclass);


--
-- Name: mdl_tool_dataprivacy_request id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_dataprivacy_request ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_dataprivacy_request_id_seq'::regclass);


--
-- Name: mdl_tool_iomadmerge id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_iomadmerge ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_iomadmerge_id_seq'::regclass);


--
-- Name: mdl_tool_monitor_events id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_monitor_events ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_monitor_events_id_seq'::regclass);


--
-- Name: mdl_tool_monitor_history id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_monitor_history ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_monitor_history_id_seq'::regclass);


--
-- Name: mdl_tool_monitor_rules id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_monitor_rules ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_monitor_rules_id_seq'::regclass);


--
-- Name: mdl_tool_monitor_subscriptions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_monitor_subscriptions ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_monitor_subscriptions_id_seq'::regclass);


--
-- Name: mdl_tool_policy id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_policy ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_policy_id_seq'::regclass);


--
-- Name: mdl_tool_policy_acceptances id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_policy_acceptances ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_policy_acceptances_id_seq'::regclass);


--
-- Name: mdl_tool_policy_versions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_policy_versions ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_policy_versions_id_seq'::regclass);


--
-- Name: mdl_tool_recyclebin_category id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_recyclebin_category ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_recyclebin_category_id_seq'::regclass);


--
-- Name: mdl_tool_recyclebin_course id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_recyclebin_course ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_recyclebin_course_id_seq'::regclass);


--
-- Name: mdl_tool_usertours_steps id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_usertours_steps ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_usertours_steps_id_seq'::regclass);


--
-- Name: mdl_tool_usertours_tours id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_usertours_tours ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_usertours_tours_id_seq'::regclass);


--
-- Name: mdl_trainingevent id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_trainingevent ALTER COLUMN id SET DEFAULT nextval('public.mdl_trainingevent_id_seq'::regclass);


--
-- Name: mdl_trainingevent_users id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_trainingevent_users ALTER COLUMN id SET DEFAULT nextval('public.mdl_trainingevent_users_id_seq'::regclass);


--
-- Name: mdl_upgrade_log id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_upgrade_log ALTER COLUMN id SET DEFAULT nextval('public.mdl_upgrade_log_id_seq'::regclass);


--
-- Name: mdl_url id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_url ALTER COLUMN id SET DEFAULT nextval('public.mdl_url_id_seq'::regclass);


--
-- Name: mdl_user id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_user ALTER COLUMN id SET DEFAULT nextval('public.mdl_user_id_seq'::regclass);


--
-- Name: mdl_user_devices id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_user_devices ALTER COLUMN id SET DEFAULT nextval('public.mdl_user_devices_id_seq'::regclass);


--
-- Name: mdl_user_enrolments id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_user_enrolments ALTER COLUMN id SET DEFAULT nextval('public.mdl_user_enrolments_id_seq'::regclass);


--
-- Name: mdl_user_info_category id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_user_info_category ALTER COLUMN id SET DEFAULT nextval('public.mdl_user_info_category_id_seq'::regclass);


--
-- Name: mdl_user_info_data id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_user_info_data ALTER COLUMN id SET DEFAULT nextval('public.mdl_user_info_data_id_seq'::regclass);


--
-- Name: mdl_user_info_field id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_user_info_field ALTER COLUMN id SET DEFAULT nextval('public.mdl_user_info_field_id_seq'::regclass);


--
-- Name: mdl_user_lastaccess id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_user_lastaccess ALTER COLUMN id SET DEFAULT nextval('public.mdl_user_lastaccess_id_seq'::regclass);


--
-- Name: mdl_user_password_history id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_user_password_history ALTER COLUMN id SET DEFAULT nextval('public.mdl_user_password_history_id_seq'::regclass);


--
-- Name: mdl_user_password_resets id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_user_password_resets ALTER COLUMN id SET DEFAULT nextval('public.mdl_user_password_resets_id_seq'::regclass);


--
-- Name: mdl_user_preferences id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_user_preferences ALTER COLUMN id SET DEFAULT nextval('public.mdl_user_preferences_id_seq'::regclass);


--
-- Name: mdl_user_private_key id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_user_private_key ALTER COLUMN id SET DEFAULT nextval('public.mdl_user_private_key_id_seq'::regclass);


--
-- Name: mdl_wiki id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_wiki ALTER COLUMN id SET DEFAULT nextval('public.mdl_wiki_id_seq'::regclass);


--
-- Name: mdl_wiki_links id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_wiki_links ALTER COLUMN id SET DEFAULT nextval('public.mdl_wiki_links_id_seq'::regclass);


--
-- Name: mdl_wiki_locks id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_wiki_locks ALTER COLUMN id SET DEFAULT nextval('public.mdl_wiki_locks_id_seq'::regclass);


--
-- Name: mdl_wiki_pages id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_wiki_pages ALTER COLUMN id SET DEFAULT nextval('public.mdl_wiki_pages_id_seq'::regclass);


--
-- Name: mdl_wiki_subwikis id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_wiki_subwikis ALTER COLUMN id SET DEFAULT nextval('public.mdl_wiki_subwikis_id_seq'::regclass);


--
-- Name: mdl_wiki_synonyms id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_wiki_synonyms ALTER COLUMN id SET DEFAULT nextval('public.mdl_wiki_synonyms_id_seq'::regclass);


--
-- Name: mdl_wiki_versions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_wiki_versions ALTER COLUMN id SET DEFAULT nextval('public.mdl_wiki_versions_id_seq'::regclass);


--
-- Name: mdl_workshop id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_workshop ALTER COLUMN id SET DEFAULT nextval('public.mdl_workshop_id_seq'::regclass);


--
-- Name: mdl_workshop_aggregations id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_workshop_aggregations ALTER COLUMN id SET DEFAULT nextval('public.mdl_workshop_aggregations_id_seq'::regclass);


--
-- Name: mdl_workshop_assessments id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_workshop_assessments ALTER COLUMN id SET DEFAULT nextval('public.mdl_workshop_assessments_id_seq'::regclass);


--
-- Name: mdl_workshop_grades id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_workshop_grades ALTER COLUMN id SET DEFAULT nextval('public.mdl_workshop_grades_id_seq'::regclass);


--
-- Name: mdl_workshop_submissions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_workshop_submissions ALTER COLUMN id SET DEFAULT nextval('public.mdl_workshop_submissions_id_seq'::regclass);


--
-- Name: mdl_workshopallocation_scheduled id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_workshopallocation_scheduled ALTER COLUMN id SET DEFAULT nextval('public.mdl_workshopallocation_scheduled_id_seq'::regclass);


--
-- Name: mdl_workshopeval_best_settings id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_workshopeval_best_settings ALTER COLUMN id SET DEFAULT nextval('public.mdl_workshopeval_best_settings_id_seq'::regclass);


--
-- Name: mdl_workshopform_accumulative id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_workshopform_accumulative ALTER COLUMN id SET DEFAULT nextval('public.mdl_workshopform_accumulative_id_seq'::regclass);


--
-- Name: mdl_workshopform_comments id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_workshopform_comments ALTER COLUMN id SET DEFAULT nextval('public.mdl_workshopform_comments_id_seq'::regclass);


--
-- Name: mdl_workshopform_numerrors id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_workshopform_numerrors ALTER COLUMN id SET DEFAULT nextval('public.mdl_workshopform_numerrors_id_seq'::regclass);


--
-- Name: mdl_workshopform_numerrors_map id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_workshopform_numerrors_map ALTER COLUMN id SET DEFAULT nextval('public.mdl_workshopform_numerrors_map_id_seq'::regclass);


--
-- Name: mdl_workshopform_rubric id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_workshopform_rubric ALTER COLUMN id SET DEFAULT nextval('public.mdl_workshopform_rubric_id_seq'::regclass);


--
-- Name: mdl_workshopform_rubric_config id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_workshopform_rubric_config ALTER COLUMN id SET DEFAULT nextval('public.mdl_workshopform_rubric_config_id_seq'::regclass);


--
-- Name: mdl_workshopform_rubric_levels id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_workshopform_rubric_levels ALTER COLUMN id SET DEFAULT nextval('public.mdl_workshopform_rubric_levels_id_seq'::regclass);


--
-- Data for Name: mdl_analytics_indicator_calc; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_analytics_indicator_calc (id, starttime, endtime, contextid, sampleorigin, sampleid, indicator, value, timecreated) FROM stdin;
\.


--
-- Data for Name: mdl_analytics_models; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_analytics_models (id, enabled, trained, name, target, indicators, timesplitting, predictionsprocessor, version, contextids, timecreated, timemodified, usermodified) FROM stdin;
1	0	0	\N	\\core_course\\analytics\\target\\course_dropout	["\\\\core\\\\analytics\\\\indicator\\\\any_access_after_end","\\\\core\\\\analytics\\\\indicator\\\\any_access_before_start","\\\\core\\\\analytics\\\\indicator\\\\any_write_action_in_course","\\\\core\\\\analytics\\\\indicator\\\\read_actions","\\\\core_course\\\\analytics\\\\indicator\\\\completion_enabled","\\\\core_course\\\\analytics\\\\indicator\\\\potential_cognitive_depth","\\\\core_course\\\\analytics\\\\indicator\\\\potential_social_breadth","\\\\mod_assign\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_assign\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_book\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_book\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_chat\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_chat\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_choice\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_choice\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_data\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_data\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_feedback\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_feedback\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_folder\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_folder\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_forum\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_forum\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_glossary\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_glossary\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_imscp\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_imscp\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_label\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_label\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_lesson\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_lesson\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_lti\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_lti\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_page\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_page\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_quiz\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_quiz\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_resource\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_resource\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_scorm\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_scorm\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_survey\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_survey\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_url\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_url\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_wiki\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_wiki\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_workshop\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_workshop\\\\analytics\\\\indicator\\\\social_breadth"]	\N	\N	1599810933	\N	1599810933	1599810933	0
2	1	1	\N	\\core_course\\analytics\\target\\no_teaching	["\\\\core_course\\\\analytics\\\\indicator\\\\no_teacher","\\\\core_course\\\\analytics\\\\indicator\\\\no_student"]	\\core\\analytics\\time_splitting\\single_range	\N	1599810933	\N	1599810933	1599810933	0
3	1	1	\N	\\core_user\\analytics\\target\\upcoming_activities_due	["\\\\core_course\\\\analytics\\\\indicator\\\\activities_due"]	\\core\\analytics\\time_splitting\\upcoming_week	\N	1599810933	\N	1599810933	1599810933	0
4	1	1	\N	\\core_course\\analytics\\target\\no_access_since_course_start	["\\\\core\\\\analytics\\\\indicator\\\\any_course_access"]	\\core\\analytics\\time_splitting\\one_month_after_start	\N	1599810933	\N	1599810933	1599810933	0
5	1	1	\N	\\core_course\\analytics\\target\\no_recent_accesses	["\\\\core\\\\analytics\\\\indicator\\\\any_course_access"]	\\core\\analytics\\time_splitting\\past_month	\N	1599810933	\N	1599810933	1599810933	0
\.


--
-- Data for Name: mdl_analytics_models_log; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_analytics_models_log (id, modelid, version, evaluationmode, target, indicators, timesplitting, score, info, dir, timecreated, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_analytics_predict_samples; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_analytics_predict_samples (id, modelid, analysableid, timesplitting, rangeindex, sampleids, timecreated, timemodified) FROM stdin;
\.


--
-- Data for Name: mdl_analytics_prediction_actions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_analytics_prediction_actions (id, predictionid, userid, actionname, timecreated) FROM stdin;
\.


--
-- Data for Name: mdl_analytics_predictions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_analytics_predictions (id, modelid, contextid, sampleid, rangeindex, prediction, predictionscore, calculations, timecreated, timestart, timeend) FROM stdin;
\.


--
-- Data for Name: mdl_analytics_train_samples; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_analytics_train_samples (id, modelid, analysableid, timesplitting, sampleids, timecreated) FROM stdin;
\.


--
-- Data for Name: mdl_analytics_used_analysables; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_analytics_used_analysables (id, modelid, action, analysableid, firstanalysis, timeanalysed) FROM stdin;
\.


--
-- Data for Name: mdl_analytics_used_files; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_analytics_used_files (id, modelid, fileid, action, "time") FROM stdin;
\.


--
-- Data for Name: mdl_assign; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assign (id, course, name, intro, introformat, alwaysshowdescription, nosubmissions, submissiondrafts, sendnotifications, sendlatenotifications, duedate, allowsubmissionsfromdate, grade, timemodified, requiresubmissionstatement, completionsubmit, cutoffdate, gradingduedate, teamsubmission, requireallteammemberssubmit, teamsubmissiongroupingid, blindmarking, hidegrader, revealidentities, attemptreopenmethod, maxattempts, markingworkflow, markingallocation, sendstudentnotifications, preventsubmissionnotingroup) FROM stdin;
\.


--
-- Data for Name: mdl_assign_grades; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assign_grades (id, assignment, userid, timecreated, timemodified, grader, grade, attemptnumber) FROM stdin;
\.


--
-- Data for Name: mdl_assign_overrides; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assign_overrides (id, assignid, groupid, userid, sortorder, allowsubmissionsfromdate, duedate, cutoffdate) FROM stdin;
\.


--
-- Data for Name: mdl_assign_plugin_config; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assign_plugin_config (id, assignment, plugin, subtype, name, value) FROM stdin;
\.


--
-- Data for Name: mdl_assign_submission; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assign_submission (id, assignment, userid, timecreated, timemodified, status, groupid, attemptnumber, latest) FROM stdin;
\.


--
-- Data for Name: mdl_assign_user_flags; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assign_user_flags (id, userid, assignment, locked, mailed, extensionduedate, workflowstate, allocatedmarker) FROM stdin;
\.


--
-- Data for Name: mdl_assign_user_mapping; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assign_user_mapping (id, assignment, userid) FROM stdin;
\.


--
-- Data for Name: mdl_assignfeedback_comments; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assignfeedback_comments (id, assignment, grade, commenttext, commentformat) FROM stdin;
\.


--
-- Data for Name: mdl_assignfeedback_editpdf_annot; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assignfeedback_editpdf_annot (id, gradeid, pageno, x, y, endx, endy, path, type, colour, draft) FROM stdin;
\.


--
-- Data for Name: mdl_assignfeedback_editpdf_cmnt; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assignfeedback_editpdf_cmnt (id, gradeid, x, y, width, rawtext, pageno, colour, draft) FROM stdin;
\.


--
-- Data for Name: mdl_assignfeedback_editpdf_queue; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assignfeedback_editpdf_queue (id, submissionid, submissionattempt, attemptedconversions) FROM stdin;
\.


--
-- Data for Name: mdl_assignfeedback_editpdf_quick; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assignfeedback_editpdf_quick (id, userid, rawtext, width, colour) FROM stdin;
\.


--
-- Data for Name: mdl_assignfeedback_editpdf_rot; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assignfeedback_editpdf_rot (id, gradeid, pageno, pathnamehash, isrotated, degree) FROM stdin;
\.


--
-- Data for Name: mdl_assignfeedback_file; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assignfeedback_file (id, assignment, grade, numfiles) FROM stdin;
\.


--
-- Data for Name: mdl_assignment; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assignment (id, course, name, intro, introformat, assignmenttype, resubmit, preventlate, emailteachers, var1, var2, var3, var4, var5, maxbytes, timedue, timeavailable, grade, timemodified) FROM stdin;
\.


--
-- Data for Name: mdl_assignment_submissions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assignment_submissions (id, assignment, userid, timecreated, timemodified, numfiles, data1, data2, grade, submissioncomment, format, teacher, timemarked, mailed) FROM stdin;
\.


--
-- Data for Name: mdl_assignment_upgrade; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assignment_upgrade (id, oldcmid, oldinstance, newcmid, newinstance, timecreated) FROM stdin;
\.


--
-- Data for Name: mdl_assignsubmission_file; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assignsubmission_file (id, assignment, submission, numfiles) FROM stdin;
\.


--
-- Data for Name: mdl_assignsubmission_onlinetext; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assignsubmission_onlinetext (id, assignment, submission, onlinetext, onlineformat) FROM stdin;
\.


--
-- Data for Name: mdl_auth_iomadoidc_prevlogin; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_auth_iomadoidc_prevlogin (id, userid, method, password) FROM stdin;
\.


--
-- Data for Name: mdl_auth_iomadoidc_state; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_auth_iomadoidc_state (id, sesskey, state, nonce, timecreated, additionaldata) FROM stdin;
\.


--
-- Data for Name: mdl_auth_iomadoidc_token; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_auth_iomadoidc_token (id, iomadoidcuniqid, username, userid, iomadoidcusername, scope, resource, authcode, token, expiry, refreshtoken, idtoken) FROM stdin;
\.


--
-- Data for Name: mdl_auth_oauth2_linked_login; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_auth_oauth2_linked_login (id, timecreated, timemodified, usermodified, userid, issuerid, username, email, confirmtoken, confirmtokenexpires) FROM stdin;
\.


--
-- Data for Name: mdl_backup_controllers; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_backup_controllers (id, backupid, operation, type, itemid, format, interactive, purpose, userid, status, execution, executiontime, checksum, timecreated, timemodified, progress, controller) FROM stdin;
1	bed4b3084fbf8a0fe01aa5e63c26d008	backup	course	3	moodle2	0	50	2	1000	1	0	f8290e74af3f9fb65efd014f1535a258	1600154117	1600154117	0.00000000000000	
13	6dbbde00f52668eb4438456de6f3fb6f	backup	course	8	moodle2	0	50	2	1000	1	0	99b8320ad9f36013f90ffb82e56b65a4	1601556009	1601556011	0.00000000000000	
2	1533e3897510a5c49ce6757c4d353133	backup	course	4	moodle2	0	50	2	1000	1	0	93d90f4f15b7a4921166145f4375a5b9	1600154164	1600154165	0.00000000000000	
3	8a989dcc07cb9ef757c031502f4715c8	backup	course	5	moodle2	0	50	2	1000	1	0	755ac7b2067b094bdc7363133e6e4bf2	1600167188	1600167189	0.00000000000000	
4	a492e94e277224c92053ab21fc0e6e29	backup	course	6	moodle2	0	50	2	1000	1	0	9d497d579f3735421676291e52c7d9f8	1600167389	1600167390	0.00000000000000	
14	09556dbd915298ffbf59c6b2d5aa80e3	backup	course	24	moodle2	0	50	2	1000	1	0	b6f91df0532fd2e51207310d0c90c96d	1603431288	1603431289	0.00000000000000	
5	bbb93ea866283f3fc7ed2bcc23a879dc	backup	course	7	moodle2	0	50	2	1000	1	0	d6c64e89cca83dc90f54d195b8346186	1600167454	1600167455	0.00000000000000	
6	4aeb7ed04c979f12d0f773de188bc4ed	backup	course	16	moodle2	0	50	2	1000	1	0	28619ca61b98c2aba05e95a871b241f8	1601555823	1601555824	0.00000000000000	
7	b3737d3dc5831ada772ee2e86d85c1e2	backup	course	15	moodle2	0	50	2	1000	1	0	ef7a69fb4a83525c7973efa3f1b65f63	1601555946	1601555947	0.00000000000000	
15	68a9ba3e24aef02bd438f55b0109564f	backup	course	18	moodle2	0	50	2	1000	1	0	4e0ae8424550f21170c752c10ead47c0	1603453658	1603453658	0.00000000000000	
8	6ced00bf365370aeefd14f4cb18d2c37	backup	course	14	moodle2	0	50	2	1000	1	0	ac0c539f346a2c051d334b830cf82f5b	1601555958	1601555959	0.00000000000000	
9	9555487b7631a6a7fb744e0713e4f42d	backup	course	13	moodle2	0	50	2	1000	1	0	974b8e566c88c5bccf2670fef7181f28	1601555968	1601555969	0.00000000000000	
10	c3971b241d70f9b8e42443385ad9eb3f	backup	course	12	moodle2	0	50	2	1000	1	0	7efedf87a88767f8bc1e65c88105f2f2	1601555979	1601555979	0.00000000000000	
16	bb492d447e7297a8b6fd11408f0f3fb9	backup	course	21	moodle2	0	50	2	1000	1	0	cda76c3a4502076ff835f7ad076b459f	1603517630	1603517630	0.00000000000000	
11	25ac2d4d7ec8ddb0c067ee315fac0b49	backup	course	11	moodle2	0	50	2	1000	1	0	3335c6fcd2220d76e51465f7b22ded5a	1601555988	1601555989	0.00000000000000	
12	dc62c5fd0ec7bc4e5cf44817f761adaf	backup	course	10	moodle2	0	50	2	1000	1	0	d0d21f177d573756abbed6d8f5030d87	1601555998	1601555999	0.00000000000000	
17	5d5d280168e0835ac741ea676f5fe0af	backup	course	20	moodle2	0	50	2	1000	1	0	4d1bddd0a0b58ed7c4450b453d79b14e	1603517661	1603517662	0.00000000000000	
18	845d6d03ce5f4221570267dfa15fb8ba	backup	course	19	moodle2	0	50	2	1000	1	0	cea7e326a2d1b0ca7fcf13226e3eccf2	1603517671	1603517672	0.00000000000000	
19	24d513b7a6c2a113cab496e151969730	backup	course	17	moodle2	0	50	2	1000	1	0	69e65c0acf908f2ba0e7000616a845cf	1603517684	1603517685	0.00000000000000	
\.


--
-- Data for Name: mdl_backup_courses; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_backup_courses (id, courseid, laststarttime, lastendtime, laststatus, nextstarttime) FROM stdin;
\.


--
-- Data for Name: mdl_backup_logs; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_backup_logs (id, backupid, loglevel, message, timecreated) FROM stdin;
\.


--
-- Data for Name: mdl_badge; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_badge (id, name, description, timecreated, timemodified, usercreated, usermodified, issuername, issuerurl, issuercontact, expiredate, expireperiod, type, courseid, message, messagesubject, attachment, notification, status, nextcron, version, language, imageauthorname, imageauthoremail, imageauthorurl, imagecaption) FROM stdin;
\.


--
-- Data for Name: mdl_badge_alignment; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_badge_alignment (id, badgeid, targetname, targeturl, targetdescription, targetframework, targetcode) FROM stdin;
\.


--
-- Data for Name: mdl_badge_backpack; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_badge_backpack (id, userid, email, backpackuid, autosync, password, externalbackpackid) FROM stdin;
\.


--
-- Data for Name: mdl_badge_criteria; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_badge_criteria (id, badgeid, criteriatype, method, description, descriptionformat) FROM stdin;
\.


--
-- Data for Name: mdl_badge_criteria_met; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_badge_criteria_met (id, issuedid, critid, userid, datemet) FROM stdin;
\.


--
-- Data for Name: mdl_badge_criteria_param; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_badge_criteria_param (id, critid, name, value) FROM stdin;
\.


--
-- Data for Name: mdl_badge_endorsement; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_badge_endorsement (id, badgeid, issuername, issuerurl, issueremail, claimid, claimcomment, dateissued) FROM stdin;
\.


--
-- Data for Name: mdl_badge_external; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_badge_external (id, backpackid, collectionid, entityid) FROM stdin;
\.


--
-- Data for Name: mdl_badge_external_backpack; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_badge_external_backpack (id, backpackapiurl, backpackweburl, apiversion, sortorder, password) FROM stdin;
1	https://backpack.openbadges.org	https://backpack.openbadges.org	1	0	
2	https://api.badgr.io/v2	https://badgr.io	2	1	
\.


--
-- Data for Name: mdl_badge_external_identifier; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_badge_external_identifier (id, sitebackpackid, internalid, externalid, type) FROM stdin;
\.


--
-- Data for Name: mdl_badge_issued; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_badge_issued (id, badgeid, userid, uniquehash, dateissued, dateexpire, visible, issuernotified) FROM stdin;
\.


--
-- Data for Name: mdl_badge_manual_award; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_badge_manual_award (id, badgeid, recipientid, issuerid, issuerrole, datemet) FROM stdin;
\.


--
-- Data for Name: mdl_badge_related; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_badge_related (id, badgeid, relatedbadgeid) FROM stdin;
\.


--
-- Data for Name: mdl_block; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_block (id, name, cron, lastcron, visible) FROM stdin;
1	activity_modules	0	0	1
2	activity_results	0	0	1
3	admin_bookmarks	0	0	1
4	badges	0	0	1
5	blog_menu	0	0	1
6	blog_recent	0	0	1
7	blog_tags	0	0	1
8	calendar_month	0	0	1
9	calendar_upcoming	0	0	1
10	comments	0	0	1
11	completionstatus	0	0	1
12	course_list	0	0	1
13	course_summary	0	0	1
14	feedback	0	0	1
15	globalsearch	0	0	1
16	glossary_random	0	0	1
17	html	0	0	1
18	iomad_approve_access	0	0	1
19	iomad_commerce	0	0	1
20	iomad_company_admin	0	0	1
21	iomad_company_selector	0	0	1
22	iomad_html	0	0	1
23	iomad_learningpath	0	0	1
24	iomad_link	0	0	1
25	iomad_microlearning	0	0	1
26	iomad_onlineusers	0	0	1
27	iomad_progress	0	0	1
28	iomad_reports	0	0	1
29	iomad_welcome	0	0	1
30	login	0	0	1
31	lp	0	0	1
32	mentees	0	0	1
33	mnet_hosts	0	0	1
34	mycourses	0	0	1
35	myoverview	0	0	1
36	myprofile	0	0	1
37	navigation	0	0	1
38	news_items	0	0	1
39	online_users	0	0	1
40	private_files	0	0	1
41	quiz_results	0	0	0
42	recent_activity	0	0	1
43	recentlyaccessedcourses	0	0	1
44	recentlyaccesseditems	0	0	1
45	rss_client	0	0	1
46	search_forums	0	0	1
47	section_links	0	0	1
48	selfcompletion	0	0	1
49	settings	0	0	1
50	site_main_menu	0	0	1
51	social_activities	0	0	1
52	starredcourses	0	0	1
53	tag_flickr	0	0	1
54	tag_youtube	0	0	0
55	tags	0	0	1
56	timeline	0	0	1
\.


--
-- Data for Name: mdl_block_instances; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_block_instances (id, blockname, parentcontextid, showinsubcontexts, requiredbytheme, pagetypepattern, subpagepattern, defaultregion, defaultweight, configdata, timecreated, timemodified) FROM stdin;
1	iomad_company_admin	1	0	0	my-index	\N	content	-10		1599810996	1599810996
2	iomad_link	2	0	0	site-index	\N	side-post	0		1599811000	1599811000
3	mycourses	1	0	0	my-index	\N	content	0		1599811002	1599811002
4	recentlyaccessedcourses	1	0	0	my-index	2	content	0		1599811004	1599811004
5	timeline	1	0	0	my-index	2	side-post	0		1599811006	1599811006
6	admin_bookmarks	1	0	0	admin-*	\N	side-pre	2		1599811006	1599811006
7	timeline	1	0	0	my-index	2	side-post	0		1599811006	1599811006
8	private_files	1	0	0	my-index	2	side-post	1		1599811006	1599811006
9	online_users	1	0	0	my-index	2	side-post	2		1599811006	1599811006
10	badges	1	0	0	my-index	2	side-post	3		1599811006	1599811006
11	calendar_month	1	0	0	my-index	2	side-post	4		1599811006	1599811006
12	calendar_upcoming	1	0	0	my-index	2	side-post	5		1599811006	1599811006
13	lp	1	0	0	my-index	2	content	0		1599811006	1599811006
14	recentlyaccessedcourses	1	0	0	my-index	2	content	1		1599811006	1599811006
15	myoverview	1	0	0	my-index	2	content	2		1599811006	1599811006
16	myoverview	5	0	0	my-index	3	content	2		1599811397	1599811397
17	recentlyaccessedcourses	5	0	0	my-index	3	content	1		1599811397	1599811397
18	lp	5	0	0	my-index	3	content	0		1599811397	1599811397
19	calendar_upcoming	5	0	0	my-index	3	side-post	5		1599811397	1599811397
20	calendar_month	5	0	0	my-index	3	side-post	4		1599811397	1599811397
21	badges	5	0	0	my-index	3	side-post	3		1599811397	1599811397
22	online_users	5	0	0	my-index	3	side-post	2		1599811397	1599811397
23	private_files	5	0	0	my-index	3	side-post	1		1599811397	1599811397
24	timeline	5	0	0	my-index	3	side-post	0		1599811397	1599811397
25	timeline	5	0	0	my-index	3	side-post	0		1599811397	1599811397
26	recentlyaccessedcourses	5	0	0	my-index	3	content	0		1599811397	1599811397
27	myoverview	46	0	0	my-index	5	content	2		1600175019	1600175019
28	recentlyaccessedcourses	46	0	0	my-index	5	content	1		1600175019	1600175019
29	lp	46	0	0	my-index	5	content	0		1600175019	1600175019
30	calendar_upcoming	46	0	0	my-index	5	side-post	5		1600175019	1600175019
31	calendar_month	46	0	0	my-index	5	side-post	4		1600175019	1600175019
32	badges	46	0	0	my-index	5	side-post	3		1600175019	1600175019
33	online_users	46	0	0	my-index	5	side-post	2		1600175019	1600175019
34	private_files	46	0	0	my-index	5	side-post	1		1600175019	1600175019
35	timeline	46	0	0	my-index	5	side-post	0		1600175019	1600175019
36	timeline	46	0	0	my-index	5	side-post	0		1600175019	1600175019
37	recentlyaccessedcourses	46	0	0	my-index	5	content	0		1600175019	1600175019
38	myoverview	60	0	0	my-index	9	content	2		1601119903	1601119903
39	recentlyaccessedcourses	60	0	0	my-index	9	content	1		1601119903	1601119903
40	lp	60	0	0	my-index	9	content	0		1601119903	1601119903
41	calendar_upcoming	60	0	0	my-index	9	side-post	5		1601119903	1601119903
42	calendar_month	60	0	0	my-index	9	side-post	4		1601119903	1601119903
43	badges	60	0	0	my-index	9	side-post	3		1601119903	1601119903
44	online_users	60	0	0	my-index	9	side-post	2		1601119904	1601119904
45	private_files	60	0	0	my-index	9	side-post	1		1601119904	1601119904
46	timeline	60	0	0	my-index	9	side-post	0		1601119904	1601119904
47	timeline	60	0	0	my-index	9	side-post	0		1601119904	1601119904
48	recentlyaccessedcourses	60	0	0	my-index	9	content	0		1601119904	1601119904
49	myoverview	116	0	0	my-index	14	content	2		1601971050	1601971050
50	recentlyaccessedcourses	116	0	0	my-index	14	content	1		1601971050	1601971050
51	lp	116	0	0	my-index	14	content	0		1601971050	1601971050
52	calendar_upcoming	116	0	0	my-index	14	side-post	5		1601971050	1601971050
53	calendar_month	116	0	0	my-index	14	side-post	4		1601971050	1601971050
54	badges	116	0	0	my-index	14	side-post	3		1601971050	1601971050
55	online_users	116	0	0	my-index	14	side-post	2		1601971050	1601971050
56	private_files	116	0	0	my-index	14	side-post	1		1601971050	1601971050
57	timeline	116	0	0	my-index	14	side-post	0		1601971050	1601971050
58	timeline	116	0	0	my-index	14	side-post	0		1601971050	1601971050
59	recentlyaccessedcourses	116	0	0	my-index	14	content	0		1601971050	1601971050
60	recentlyaccessedcourses	132	0	0	my-index	15	content	0		1602052255	1602052255
61	timeline	132	0	0	my-index	15	side-post	0		1602052255	1602052255
62	timeline	132	0	0	my-index	15	side-post	0		1602052255	1602052255
63	private_files	132	0	0	my-index	15	side-post	1		1602052255	1602052255
64	online_users	132	0	0	my-index	15	side-post	2		1602052255	1602052255
65	badges	132	0	0	my-index	15	side-post	3		1602052255	1602052255
66	calendar_month	132	0	0	my-index	15	side-post	4		1602052255	1602052255
67	calendar_upcoming	132	0	0	my-index	15	side-post	5		1602052255	1602052255
68	lp	132	0	0	my-index	15	content	0		1602052255	1602052255
69	recentlyaccessedcourses	132	0	0	my-index	15	content	1		1602052255	1602052255
70	myoverview	132	0	0	my-index	15	content	2		1602052255	1602052255
71	recentlyaccessedcourses	148	0	0	my-index	16	content	0		1603260969	1603260969
72	timeline	148	0	0	my-index	16	side-post	0		1603260969	1603260969
73	timeline	148	0	0	my-index	16	side-post	0		1603260969	1603260969
74	private_files	148	0	0	my-index	16	side-post	1		1603260969	1603260969
75	online_users	148	0	0	my-index	16	side-post	2		1603260969	1603260969
76	badges	148	0	0	my-index	16	side-post	3		1603260969	1603260969
77	calendar_month	148	0	0	my-index	16	side-post	4		1603260969	1603260969
78	calendar_upcoming	148	0	0	my-index	16	side-post	5		1603260969	1603260969
79	lp	148	0	0	my-index	16	content	0		1603260969	1603260969
80	recentlyaccessedcourses	148	0	0	my-index	16	content	1		1603260969	1603260969
81	myoverview	148	0	0	my-index	16	content	2		1603260969	1603260969
82	recentlyaccessedcourses	162	0	0	my-index	17	content	0		1603275956	1603275956
83	timeline	162	0	0	my-index	17	side-post	0		1603275956	1603275956
84	timeline	162	0	0	my-index	17	side-post	0		1603275956	1603275956
85	private_files	162	0	0	my-index	17	side-post	1		1603275956	1603275956
86	online_users	162	0	0	my-index	17	side-post	2		1603275956	1603275956
87	badges	162	0	0	my-index	17	side-post	3		1603275956	1603275956
88	calendar_month	162	0	0	my-index	17	side-post	4		1603275956	1603275956
89	calendar_upcoming	162	0	0	my-index	17	side-post	5		1603275956	1603275956
90	lp	162	0	0	my-index	17	content	0		1603275956	1603275956
91	recentlyaccessedcourses	162	0	0	my-index	17	content	1		1603275956	1603275956
92	myoverview	162	0	0	my-index	17	content	2		1603275956	1603275956
93	recentlyaccessedcourses	175	0	0	my-index	18	content	0		1603349611	1603349611
94	timeline	175	0	0	my-index	18	side-post	0		1603349611	1603349611
95	timeline	175	0	0	my-index	18	side-post	0		1603349611	1603349611
96	private_files	175	0	0	my-index	18	side-post	1		1603349611	1603349611
97	online_users	175	0	0	my-index	18	side-post	2		1603349611	1603349611
98	badges	175	0	0	my-index	18	side-post	3		1603349611	1603349611
99	calendar_month	175	0	0	my-index	18	side-post	4		1603349611	1603349611
100	calendar_upcoming	175	0	0	my-index	18	side-post	5		1603349611	1603349611
101	lp	175	0	0	my-index	18	content	0		1603349611	1603349611
102	recentlyaccessedcourses	175	0	0	my-index	18	content	1		1603349611	1603349611
103	myoverview	175	0	0	my-index	18	content	2		1603349611	1603349611
104	recentlyaccessedcourses	187	0	0	my-index	19	content	0		1603352017	1603352017
105	timeline	187	0	0	my-index	19	side-post	0		1603352017	1603352017
106	timeline	187	0	0	my-index	19	side-post	0		1603352017	1603352017
107	private_files	187	0	0	my-index	19	side-post	1		1603352017	1603352017
108	online_users	187	0	0	my-index	19	side-post	2		1603352017	1603352017
109	badges	187	0	0	my-index	19	side-post	3		1603352017	1603352017
110	calendar_month	187	0	0	my-index	19	side-post	4		1603352017	1603352017
111	calendar_upcoming	187	0	0	my-index	19	side-post	5		1603352017	1603352017
112	lp	187	0	0	my-index	19	content	0		1603352017	1603352017
113	recentlyaccessedcourses	187	0	0	my-index	19	content	1		1603352017	1603352017
114	myoverview	187	0	0	my-index	19	content	2		1603352017	1603352017
115	recentlyaccessedcourses	200	0	0	my-index	20	content	0		1603428099	1603428099
116	timeline	200	0	0	my-index	20	side-post	0		1603428099	1603428099
117	timeline	200	0	0	my-index	20	side-post	0		1603428099	1603428099
118	private_files	200	0	0	my-index	20	side-post	1		1603428099	1603428099
119	online_users	200	0	0	my-index	20	side-post	2		1603428099	1603428099
120	badges	200	0	0	my-index	20	side-post	3		1603428099	1603428099
121	calendar_month	200	0	0	my-index	20	side-post	4		1603428099	1603428099
122	calendar_upcoming	200	0	0	my-index	20	side-post	5		1603428099	1603428099
123	lp	200	0	0	my-index	20	content	0		1603428099	1603428099
124	recentlyaccessedcourses	200	0	0	my-index	20	content	1		1603428099	1603428099
125	myoverview	200	0	0	my-index	20	content	2		1603428099	1603428099
\.


--
-- Data for Name: mdl_block_iomad_approve_access; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_block_iomad_approve_access (id, userid, companyid, courseid, activityid, tm_ok, manager_ok) FROM stdin;
\.


--
-- Data for Name: mdl_block_iomad_microlearning; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_block_iomad_microlearning (id) FROM stdin;
\.


--
-- Data for Name: mdl_block_positions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_block_positions (id, blockinstanceid, contextid, pagetype, subpage, visible, region, weight) FROM stdin;
\.


--
-- Data for Name: mdl_block_recent_activity; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_block_recent_activity (id, courseid, cmid, timecreated, userid, action, modname) FROM stdin;
1	8	8	1600340168	2	0	\N
2	8	7	1600664712	2	1	\N
\.


--
-- Data for Name: mdl_block_recentlyaccesseditems; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_block_recentlyaccesseditems (id, courseid, cmid, userid, timeaccess) FROM stdin;
2	2	1	2	1600839060
\.


--
-- Data for Name: mdl_block_rss_client; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_block_rss_client (id, userid, title, preferredtitle, description, shared, url, skiptime, skipuntil) FROM stdin;
\.


--
-- Data for Name: mdl_blog_association; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_blog_association (id, contextid, blogid) FROM stdin;
\.


--
-- Data for Name: mdl_blog_external; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_blog_external (id, userid, name, description, url, filtertags, failedlastsync, timemodified, timefetched) FROM stdin;
\.


--
-- Data for Name: mdl_book; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_book (id, course, name, intro, introformat, numbering, navstyle, customtitles, revision, timecreated, timemodified) FROM stdin;
\.


--
-- Data for Name: mdl_book_chapters; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_book_chapters (id, bookid, pagenum, subchapter, title, content, contentformat, hidden, timecreated, timemodified, importsrc) FROM stdin;
\.


--
-- Data for Name: mdl_cache_filters; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_cache_filters (id, filter, version, md5key, rawtext, timemodified) FROM stdin;
\.


--
-- Data for Name: mdl_cache_flags; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_cache_flags (id, flagtype, name, timemodified, value, expiry) FROM stdin;
51	userpreferenceschanged	26	1603186068	1	1603193268
52	userpreferenceschanged	27	1603186763	1	1603193963
38	userpreferenceschanged	17	1601962926	1	1601970126
22	userpreferenceschanged	11	1601535874	1	1601543074
53	userpreferenceschanged	28	1603186934	1	1603194134
24	userpreferenceschanged	12	1601544811	1	1601552011
25	userpreferenceschanged	13	1601545328	1	1601552528
39	userpreferenceschanged	18	1601963289	1	1601970489
2	userpreferenceschanged	3	1600088306	1	1600095506
41	userpreferenceschanged	20	1601963892	1	1601971092
3	accesslib/dirtycontexts	/1/3/33/35	1600154118	1	1600161318
4	accesslib/dirtycontexts	/1/3/33/37	1600154165	1	1600161365
5	accesslib/dirtycontexts	/1/3/33/39	1600167189	1	1600174389
6	accesslib/dirtycontexts	/1/3/33/41	1600167390	1	1600174590
7	accesslib/dirtycontexts	/1/3/33/43	1600167455	1	1600174655
8	userpreferenceschanged	4	1600175018	1	1600182218
9	userpreferenceschanged	5	1600175850	1	1600183050
10	userpreferenceschanged	6	1600175959	1	1600183159
63	userpreferenceschanged	38	1603428098	1	1603435298
11	userpreferenceschanged	7	1603187153	1	1603194353
54	userpreferenceschanged	29	1603187915	1	1603195115
40	userpreferenceschanged	19	1601964627	1	1601971827
44	userpreferenceschanged	21	1601968182	1	1601975382
45	userpreferenceschanged	22	1601968560	1	1601975760
12	userpreferenceschanged	8	1601441443	1	1601448643
14	accesslib/dirtyusers	2	1600348084	1	1600355284
47	accesslib/dirtyusers	23	1601970349	1	1601977549
48	accesslib/dirtyusers	22	1601970740	1	1601977940
55	userpreferenceschanged	30	1603260968	1	1603268168
46	userpreferenceschanged	23	1601971163	1	1601978363
27	accesslib/dirtycontexts	/1/3/33/95	1601555825	1	1601563025
49	userpreferenceschanged	24	1601976991	1	1601984191
28	accesslib/dirtycontexts	/1/3/33/93	1601555948	1	1601563148
29	accesslib/dirtycontexts	/1/3/33/91	1601555959	1	1601563159
30	accesslib/dirtycontexts	/1/3/33/87	1601555969	1	1601563169
31	accesslib/dirtycontexts	/1/3/33/82	1601555979	1	1601563179
17	accesslib/dirtyusers	4	1601555989	1	1601563189
32	accesslib/dirtycontexts	/1/3/33/80	1601555989	1	1601563189
70	accesslib/dirtycontexts	/1/3/33/101	1603517672	1	1603524872
15	accesslib/dirtyusers	8	1603517685	1	1603524885
18	accesslib/dirtyusers	6	1600935708	1	1600942908
23	accesslib/dirtyusers	11	1603517685	1	1603524885
33	accesslib/dirtycontexts	/1/3/33/78	1601555999	1	1601563199
56	userpreferenceschanged	31	1603262898	1	1603270098
21	accesslib/dirtyusers	9	1603517685	1	1603524885
13	accesslib/dirtycontexts	/1/3/33/45	1601556012	1	1601563212
57	userpreferenceschanged	32	1603263067	1	1603270267
50	userpreferenceschanged	25	1602052255	1	1602059455
64	userpreferenceschanged	39	1603429071	1	1603436271
65	userpreferenceschanged	40	1603429422	1	1603436622
60	userpreferenceschanged	35	1603516970	1	1603524170
19	userpreferenceschanged	9	1601531179	1	1601538379
58	userpreferenceschanged	33	1603276620	1	1603283820
20	userpreferenceschanged	10	1601533774	1	1601540974
59	userpreferenceschanged	34	1603282390	1	1603289590
1	userpreferenceschanged	2	1603430861	1	1603438061
42	accesslib/dirtyusers	17	1603517630	1	1603524830
66	accesslib/dirtycontexts	/1/3/33/214	1603431289	1	1603438489
43	accesslib/dirtyusers	20	1603517630	1	1603524830
68	accesslib/dirtycontexts	/1/3/33/112	1603517630	1	1603524830
34	userpreferenceschanged	14	1601960382	1	1601967582
16	accesslib/dirtyusers	7	1603517662	1	1603524862
35	userpreferenceschanged	15	1601960999	1	1601968199
36	userpreferenceschanged	16	1601962134	1	1601969334
37	accesslib/dirtyusers	16	1603517686	1	1603524886
61	userpreferenceschanged	36	1603353895	1	1603361095
71	accesslib/dirtycontexts	/1/3/33/96	1603517686	1	1603524886
62	userpreferenceschanged	37	1603371623	1	1603378823
67	accesslib/dirtycontexts	/1/3/33/99	1603453658	1	1603460858
69	accesslib/dirtycontexts	/1/3/33/106	1603517662	1	1603524862
26	accesslib/dirtyusers	10	1603517672	1	1603524872
\.


--
-- Data for Name: mdl_capabilities; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_capabilities (id, name, captype, contextlevel, component, riskbitmask) FROM stdin;
1	moodle/site:config	write	10	moodle	62
2	moodle/site:configview	read	10	moodle	0
3	moodle/site:readallmessages	read	10	moodle	8
4	moodle/site:manageallmessaging	write	10	moodle	8
5	moodle/site:deleteanymessage	write	10	moodle	32
6	moodle/site:sendmessage	write	10	moodle	16
7	moodle/site:deleteownmessage	write	10	moodle	0
8	moodle/site:approvecourse	write	40	moodle	4
9	moodle/backup:backupcourse	write	50	moodle	28
10	moodle/backup:backupsection	write	50	moodle	28
11	moodle/backup:backupactivity	write	70	moodle	28
12	moodle/backup:backuptargetimport	read	50	moodle	28
13	moodle/backup:downloadfile	write	50	moodle	28
14	moodle/backup:configure	write	50	moodle	28
15	moodle/backup:userinfo	read	50	moodle	8
16	moodle/backup:anonymise	read	50	moodle	8
17	moodle/restore:restorecourse	write	50	moodle	28
18	moodle/restore:restoresection	write	50	moodle	28
19	moodle/restore:restoreactivity	write	50	moodle	28
20	moodle/restore:viewautomatedfilearea	write	50	moodle	28
21	moodle/restore:restoretargetimport	write	50	moodle	28
22	moodle/restore:uploadfile	write	50	moodle	28
23	moodle/restore:configure	write	50	moodle	28
24	moodle/restore:rolldates	write	50	moodle	0
25	moodle/restore:userinfo	write	50	moodle	30
26	moodle/restore:createuser	write	10	moodle	24
27	moodle/site:manageblocks	write	80	moodle	20
28	moodle/site:accessallgroups	read	70	moodle	0
29	moodle/site:viewfullnames	read	70	moodle	0
30	moodle/site:viewuseridentity	read	70	moodle	0
31	moodle/site:viewreports	read	50	moodle	8
32	moodle/site:trustcontent	write	70	moodle	4
33	moodle/site:uploadusers	write	10	moodle	24
34	moodle/filter:manage	write	50	moodle	0
35	moodle/user:create	write	10	moodle	24
36	moodle/user:delete	write	10	moodle	40
37	moodle/user:update	write	10	moodle	24
38	moodle/user:viewdetails	read	50	moodle	0
39	moodle/user:viewalldetails	read	30	moodle	8
40	moodle/user:viewlastip	read	30	moodle	8
41	moodle/user:viewhiddendetails	read	50	moodle	8
42	moodle/user:loginas	write	50	moodle	30
43	moodle/user:managesyspages	write	10	moodle	0
44	moodle/user:manageblocks	write	30	moodle	0
45	moodle/user:manageownblocks	write	10	moodle	0
46	moodle/user:manageownfiles	write	10	moodle	0
47	moodle/user:ignoreuserquota	write	10	moodle	0
48	moodle/my:configsyspages	write	10	moodle	0
49	moodle/role:assign	write	50	moodle	28
50	moodle/role:review	read	50	moodle	8
51	moodle/role:override	write	50	moodle	28
52	moodle/role:safeoverride	write	50	moodle	16
53	moodle/role:manage	write	10	moodle	28
54	moodle/role:switchroles	read	50	moodle	12
55	moodle/category:manage	write	40	moodle	4
56	moodle/category:viewcourselist	read	40	moodle	0
57	moodle/category:viewhiddencategories	read	40	moodle	0
58	moodle/cohort:manage	write	40	moodle	0
59	moodle/cohort:assign	write	40	moodle	0
60	moodle/cohort:view	read	50	moodle	0
61	moodle/course:create	write	40	moodle	4
62	moodle/course:creategroupconversations	write	50	moodle	4
63	moodle/course:request	write	40	moodle	0
64	moodle/course:delete	write	50	moodle	32
65	moodle/course:update	write	50	moodle	4
66	moodle/course:view	read	50	moodle	0
67	moodle/course:enrolreview	read	50	moodle	8
68	moodle/course:enrolconfig	write	50	moodle	8
69	moodle/course:reviewotherusers	read	50	moodle	0
70	moodle/course:bulkmessaging	write	50	moodle	16
71	moodle/course:viewhiddenuserfields	read	50	moodle	8
72	moodle/course:viewhiddencourses	read	50	moodle	0
73	moodle/course:visibility	write	50	moodle	0
74	moodle/course:managefiles	write	50	moodle	4
75	moodle/course:ignoreavailabilityrestrictions	read	70	moodle	0
76	moodle/course:ignorefilesizelimits	write	50	moodle	0
77	moodle/course:manageactivities	write	70	moodle	4
78	moodle/course:activityvisibility	write	70	moodle	0
79	moodle/course:viewhiddenactivities	read	70	moodle	0
80	moodle/course:viewparticipants	read	50	moodle	0
81	moodle/course:changefullname	write	50	moodle	4
82	moodle/course:changeshortname	write	50	moodle	4
83	moodle/course:changelockedcustomfields	write	50	moodle	16
84	moodle/course:configurecustomfields	write	10	moodle	16
85	moodle/course:renameroles	write	50	moodle	0
86	moodle/course:changeidnumber	write	50	moodle	4
87	moodle/course:changecategory	write	50	moodle	4
88	moodle/course:changesummary	write	50	moodle	4
89	moodle/course:setforcedlanguage	write	50	moodle	0
90	moodle/site:viewparticipants	read	10	moodle	0
91	moodle/course:isincompletionreports	read	50	moodle	0
92	moodle/course:viewscales	read	50	moodle	0
93	moodle/course:managescales	write	50	moodle	0
94	moodle/course:managegroups	write	50	moodle	4
95	moodle/course:reset	write	50	moodle	32
96	moodle/course:viewsuspendedusers	read	50	moodle	0
97	moodle/course:tag	write	50	moodle	16
98	moodle/blog:view	read	10	moodle	0
99	moodle/blog:search	read	10	moodle	0
100	moodle/blog:viewdrafts	read	10	moodle	8
101	moodle/blog:create	write	10	moodle	16
102	moodle/blog:manageentries	write	10	moodle	16
103	moodle/blog:manageexternal	write	10	moodle	16
104	moodle/calendar:manageownentries	write	50	moodle	16
105	moodle/calendar:managegroupentries	write	50	moodle	16
106	moodle/calendar:manageentries	write	50	moodle	16
107	moodle/user:editprofile	write	30	moodle	24
108	moodle/user:editownprofile	write	10	moodle	16
109	moodle/user:changeownpassword	write	10	moodle	0
110	moodle/user:readuserposts	read	30	moodle	0
111	moodle/user:readuserblogs	read	30	moodle	0
112	moodle/user:viewuseractivitiesreport	read	30	moodle	8
113	moodle/user:editmessageprofile	write	30	moodle	16
114	moodle/user:editownmessageprofile	write	10	moodle	0
115	moodle/question:managecategory	write	50	moodle	20
116	moodle/question:add	write	50	moodle	20
117	moodle/question:editmine	write	50	moodle	20
118	moodle/question:editall	write	50	moodle	20
119	moodle/question:viewmine	read	50	moodle	0
120	moodle/question:viewall	read	50	moodle	0
121	moodle/question:usemine	read	50	moodle	0
122	moodle/question:useall	read	50	moodle	0
123	moodle/question:movemine	write	50	moodle	0
124	moodle/question:moveall	write	50	moodle	0
125	moodle/question:config	write	10	moodle	2
126	moodle/question:flag	write	50	moodle	0
127	moodle/question:tagmine	write	50	moodle	0
128	moodle/question:tagall	write	50	moodle	0
129	moodle/site:doclinks	read	10	moodle	0
130	moodle/course:sectionvisibility	write	50	moodle	0
131	moodle/course:useremail	write	50	moodle	0
132	moodle/course:viewhiddensections	read	50	moodle	0
133	moodle/course:setcurrentsection	write	50	moodle	0
134	moodle/course:movesections	write	50	moodle	0
135	moodle/site:mnetlogintoremote	read	10	moodle	0
136	moodle/grade:viewall	read	50	moodle	8
137	moodle/grade:view	read	50	moodle	0
138	moodle/grade:viewhidden	read	50	moodle	8
139	moodle/grade:import	write	50	moodle	12
140	moodle/grade:export	read	50	moodle	8
141	moodle/grade:manage	write	50	moodle	12
142	moodle/grade:edit	write	50	moodle	12
143	moodle/grade:managegradingforms	write	50	moodle	12
144	moodle/grade:sharegradingforms	write	10	moodle	4
145	moodle/grade:managesharedforms	write	10	moodle	4
146	moodle/grade:manageoutcomes	write	50	moodle	0
147	moodle/grade:manageletters	write	50	moodle	0
148	moodle/grade:hide	write	50	moodle	0
149	moodle/grade:lock	write	50	moodle	0
150	moodle/grade:unlock	write	50	moodle	0
151	moodle/my:manageblocks	write	10	moodle	0
152	moodle/notes:view	read	50	moodle	0
153	moodle/notes:manage	write	50	moodle	16
154	moodle/tag:manage	write	10	moodle	16
155	moodle/tag:edit	write	10	moodle	16
156	moodle/tag:flag	write	10	moodle	16
157	moodle/tag:editblocks	write	10	moodle	0
158	moodle/block:view	read	80	moodle	0
159	moodle/block:edit	write	80	moodle	20
160	moodle/portfolio:export	read	10	moodle	0
161	moodle/comment:view	read	50	moodle	0
162	moodle/comment:post	write	50	moodle	24
163	moodle/comment:delete	write	50	moodle	32
164	moodle/webservice:createtoken	write	10	moodle	62
165	moodle/webservice:managealltokens	write	10	moodle	42
166	moodle/webservice:createmobiletoken	write	10	moodle	24
167	moodle/rating:view	read	50	moodle	0
168	moodle/rating:viewany	read	50	moodle	8
169	moodle/rating:viewall	read	50	moodle	8
170	moodle/rating:rate	write	50	moodle	0
171	moodle/course:markcomplete	write	50	moodle	0
172	moodle/course:overridecompletion	write	50	moodle	0
173	moodle/badges:manageglobalsettings	write	10	moodle	34
174	moodle/badges:viewbadges	read	50	moodle	0
175	moodle/badges:manageownbadges	write	30	moodle	0
176	moodle/badges:viewotherbadges	read	30	moodle	0
177	moodle/badges:earnbadge	write	50	moodle	0
178	moodle/badges:createbadge	write	50	moodle	16
179	moodle/badges:deletebadge	write	50	moodle	32
180	moodle/badges:configuredetails	write	50	moodle	16
181	moodle/badges:configurecriteria	write	50	moodle	4
182	moodle/badges:configuremessages	write	50	moodle	16
183	moodle/badges:awardbadge	write	50	moodle	16
184	moodle/badges:revokebadge	write	50	moodle	16
185	moodle/badges:viewawarded	read	50	moodle	8
186	moodle/site:forcelanguage	read	10	moodle	0
187	moodle/search:query	read	10	moodle	0
188	moodle/competency:competencymanage	write	40	moodle	0
189	moodle/competency:competencyview	read	40	moodle	0
190	moodle/competency:competencygrade	write	50	moodle	0
191	moodle/competency:coursecompetencymanage	write	50	moodle	0
192	moodle/competency:coursecompetencyconfigure	write	70	moodle	0
193	moodle/competency:coursecompetencygradable	read	50	moodle	0
194	moodle/competency:coursecompetencyview	read	50	moodle	0
195	moodle/competency:evidencedelete	write	30	moodle	0
196	moodle/competency:planmanage	write	30	moodle	0
197	moodle/competency:planmanagedraft	write	30	moodle	0
198	moodle/competency:planmanageown	write	30	moodle	0
199	moodle/competency:planmanageowndraft	write	30	moodle	0
200	moodle/competency:planview	read	30	moodle	0
201	moodle/competency:planviewdraft	read	30	moodle	0
202	moodle/competency:planviewown	read	30	moodle	0
203	moodle/competency:planviewowndraft	read	30	moodle	0
204	moodle/competency:planrequestreview	write	30	moodle	0
205	moodle/competency:planrequestreviewown	write	30	moodle	0
206	moodle/competency:planreview	write	30	moodle	0
207	moodle/competency:plancomment	write	30	moodle	0
208	moodle/competency:plancommentown	write	30	moodle	0
209	moodle/competency:usercompetencyview	read	30	moodle	0
210	moodle/competency:usercompetencyrequestreview	write	30	moodle	0
211	moodle/competency:usercompetencyrequestreviewown	write	30	moodle	0
212	moodle/competency:usercompetencyreview	write	30	moodle	0
213	moodle/competency:usercompetencycomment	write	30	moodle	0
214	moodle/competency:usercompetencycommentown	write	30	moodle	0
215	moodle/competency:templatemanage	write	40	moodle	0
216	moodle/analytics:listinsights	read	50	moodle	8
217	moodle/analytics:managemodels	write	10	moodle	2
218	moodle/competency:templateview	read	40	moodle	0
219	moodle/competency:userevidencemanage	write	30	moodle	0
220	moodle/competency:userevidencemanageown	write	30	moodle	0
221	moodle/competency:userevidenceview	read	30	moodle	0
222	moodle/site:maintenanceaccess	write	10	moodle	0
223	moodle/site:messageanyuser	write	10	moodle	16
224	moodle/site:managecontextlocks	write	70	moodle	0
225	moodle/course:togglecompletion	write	70	moodle	0
226	moodle/analytics:listowninsights	read	10	moodle	0
227	moodle/h5p:setdisplayoptions	write	70	moodle	0
228	moodle/h5p:deploy	write	70	moodle	4
229	moodle/h5p:updatelibraries	write	70	moodle	4
230	mod/assign:view	read	70	mod_assign	0
231	mod/assign:submit	write	70	mod_assign	0
232	mod/assign:grade	write	70	mod_assign	4
233	mod/assign:exportownsubmission	read	70	mod_assign	0
234	mod/assign:addinstance	write	50	mod_assign	4
235	mod/assign:editothersubmission	write	70	mod_assign	41
236	mod/assign:grantextension	write	70	mod_assign	0
237	mod/assign:revealidentities	write	70	mod_assign	0
238	mod/assign:reviewgrades	write	70	mod_assign	0
239	mod/assign:releasegrades	write	70	mod_assign	0
240	mod/assign:managegrades	write	70	mod_assign	0
241	mod/assign:manageallocations	write	70	mod_assign	0
242	mod/assign:viewgrades	read	70	mod_assign	0
243	mod/assign:viewblinddetails	write	70	mod_assign	8
244	mod/assign:receivegradernotifications	read	70	mod_assign	0
245	mod/assign:manageoverrides	write	70	mod_assign	0
246	mod/assign:showhiddengrader	read	70	mod_assign	0
247	mod/assignment:view	read	70	mod_assignment	0
248	mod/assignment:addinstance	write	50	mod_assignment	4
249	mod/assignment:submit	write	70	mod_assignment	0
250	mod/assignment:grade	write	70	mod_assignment	4
251	mod/assignment:exportownsubmission	read	70	mod_assignment	0
252	mod/book:addinstance	write	50	mod_book	4
253	mod/book:read	read	70	mod_book	0
254	mod/book:viewhiddenchapters	read	70	mod_book	0
255	mod/book:edit	write	70	mod_book	4
256	mod/chat:addinstance	write	50	mod_chat	4
257	mod/chat:chat	write	70	mod_chat	16
258	mod/chat:readlog	read	70	mod_chat	0
259	mod/chat:deletelog	write	70	mod_chat	0
260	mod/chat:exportparticipatedsession	read	70	mod_chat	8
261	mod/chat:exportsession	read	70	mod_chat	8
262	mod/chat:view	read	70	mod_chat	0
263	mod/choice:addinstance	write	50	mod_choice	4
264	mod/choice:choose	write	70	mod_choice	0
265	mod/choice:readresponses	read	70	mod_choice	0
266	mod/choice:deleteresponses	write	70	mod_choice	0
267	mod/choice:downloadresponses	read	70	mod_choice	0
268	mod/choice:view	read	70	mod_choice	0
269	mod/data:addinstance	write	50	mod_data	4
270	mod/data:viewentry	read	70	mod_data	0
271	mod/data:writeentry	write	70	mod_data	16
272	mod/data:comment	write	70	mod_data	16
273	mod/data:rate	write	70	mod_data	0
274	mod/data:viewrating	read	70	mod_data	0
275	mod/data:viewanyrating	read	70	mod_data	8
276	mod/data:viewallratings	read	70	mod_data	8
277	mod/data:approve	write	70	mod_data	16
278	mod/data:manageentries	write	70	mod_data	16
279	mod/data:managecomments	write	70	mod_data	16
280	mod/data:managetemplates	write	70	mod_data	20
281	mod/data:viewalluserpresets	read	70	mod_data	0
282	mod/data:manageuserpresets	write	70	mod_data	20
283	mod/data:exportentry	read	70	mod_data	8
284	mod/data:exportownentry	read	70	mod_data	0
285	mod/data:exportallentries	read	70	mod_data	8
286	mod/data:exportuserinfo	read	70	mod_data	8
287	mod/data:view	read	70	mod_data	0
288	mod/feedback:addinstance	write	50	mod_feedback	4
289	mod/feedback:view	read	70	mod_feedback	0
290	mod/feedback:complete	write	70	mod_feedback	16
291	mod/feedback:viewanalysepage	read	70	mod_feedback	8
292	mod/feedback:deletesubmissions	write	70	mod_feedback	0
293	mod/feedback:mapcourse	write	70	mod_feedback	0
294	mod/feedback:edititems	write	70	mod_feedback	20
295	mod/feedback:createprivatetemplate	write	70	mod_feedback	16
296	mod/feedback:createpublictemplate	write	70	mod_feedback	16
297	mod/feedback:deletetemplate	write	70	mod_feedback	0
298	mod/feedback:viewreports	read	70	mod_feedback	8
299	mod/feedback:receivemail	read	70	mod_feedback	8
300	mod/folder:addinstance	write	50	mod_folder	4
301	mod/folder:view	read	70	mod_folder	0
302	mod/folder:managefiles	write	70	mod_folder	16
303	mod/forum:addinstance	write	50	mod_forum	4
304	mod/forum:viewdiscussion	read	70	mod_forum	0
305	mod/forum:viewhiddentimedposts	read	70	mod_forum	0
306	mod/forum:startdiscussion	write	70	mod_forum	16
307	mod/forum:replypost	write	70	mod_forum	16
308	mod/forum:addnews	write	70	mod_forum	16
309	mod/forum:replynews	write	70	mod_forum	16
310	mod/forum:viewrating	read	70	mod_forum	0
311	mod/forum:viewanyrating	read	70	mod_forum	8
312	mod/forum:viewallratings	read	70	mod_forum	8
313	mod/forum:rate	write	70	mod_forum	0
314	mod/forum:postprivatereply	write	70	mod_forum	0
315	mod/forum:readprivatereplies	read	70	mod_forum	0
316	mod/forum:createattachment	write	70	mod_forum	16
317	mod/forum:deleteownpost	write	70	mod_forum	0
318	mod/forum:deleteanypost	write	70	mod_forum	0
319	mod/forum:splitdiscussions	write	70	mod_forum	0
320	mod/forum:movediscussions	write	70	mod_forum	0
321	mod/forum:pindiscussions	write	70	mod_forum	0
322	mod/forum:editanypost	write	70	mod_forum	16
323	mod/forum:viewqandawithoutposting	read	70	mod_forum	0
324	mod/forum:viewsubscribers	read	70	mod_forum	0
325	mod/forum:managesubscriptions	write	70	mod_forum	16
326	mod/forum:postwithoutthrottling	write	70	mod_forum	16
327	mod/forum:exportdiscussion	read	70	mod_forum	8
328	mod/forum:exportforum	read	70	mod_forum	8
329	mod/forum:exportpost	read	70	mod_forum	8
330	mod/forum:exportownpost	read	70	mod_forum	8
331	mod/forum:addquestion	write	70	mod_forum	16
332	mod/forum:allowforcesubscribe	read	70	mod_forum	0
333	mod/forum:canposttomygroups	write	70	mod_forum	0
334	mod/forum:canoverridediscussionlock	write	70	mod_forum	0
335	mod/forum:canoverridecutoff	write	70	mod_forum	0
336	mod/forum:cantogglefavourite	write	70	mod_forum	0
337	mod/forum:grade	write	70	mod_forum	0
338	mod/glossary:addinstance	write	50	mod_glossary	4
339	mod/glossary:view	read	70	mod_glossary	0
340	mod/glossary:write	write	70	mod_glossary	16
341	mod/glossary:manageentries	write	70	mod_glossary	16
342	mod/glossary:managecategories	write	70	mod_glossary	16
343	mod/glossary:comment	write	70	mod_glossary	16
344	mod/glossary:managecomments	write	70	mod_glossary	16
345	mod/glossary:import	write	70	mod_glossary	16
346	mod/glossary:export	read	70	mod_glossary	0
347	mod/glossary:approve	write	70	mod_glossary	16
348	mod/glossary:rate	write	70	mod_glossary	0
349	mod/glossary:viewrating	read	70	mod_glossary	0
350	mod/glossary:viewanyrating	read	70	mod_glossary	8
351	mod/glossary:viewallratings	read	70	mod_glossary	8
352	mod/glossary:exportentry	read	70	mod_glossary	8
353	mod/glossary:exportownentry	read	70	mod_glossary	0
354	mod/imscp:view	read	70	mod_imscp	0
355	mod/imscp:addinstance	write	50	mod_imscp	4
356	mod/iomadcertificate:addinstance	write	50	mod_iomadcertificate	4
357	mod/iomadcertificate:view	read	70	mod_iomadcertificate	0
358	mod/iomadcertificate:viewother	read	70	mod_iomadcertificate	0
359	mod/iomadcertificate:manage	read	70	mod_iomadcertificate	0
360	mod/iomadcertificate:printteacher	read	70	mod_iomadcertificate	0
361	mod/label:addinstance	write	50	mod_label	4
362	mod/label:view	read	70	mod_label	0
363	mod/lesson:addinstance	write	50	mod_lesson	4
364	mod/lesson:edit	write	70	mod_lesson	4
365	mod/lesson:grade	write	70	mod_lesson	20
366	mod/lesson:viewreports	read	70	mod_lesson	8
367	mod/lesson:manage	write	70	mod_lesson	0
368	mod/lesson:manageoverrides	write	70	mod_lesson	0
369	mod/lesson:view	read	70	mod_lesson	0
370	mod/lti:view	read	70	mod_lti	0
371	mod/lti:addinstance	write	50	mod_lti	4
372	mod/lti:manage	write	70	mod_lti	8
373	mod/lti:admin	write	70	mod_lti	8
374	mod/lti:addcoursetool	write	50	mod_lti	0
375	mod/lti:requesttooladd	write	50	mod_lti	0
376	mod/page:view	read	70	mod_page	0
377	mod/page:addinstance	write	50	mod_page	4
378	mod/quiz:view	read	70	mod_quiz	0
379	mod/quiz:addinstance	write	50	mod_quiz	4
380	mod/quiz:attempt	write	70	mod_quiz	16
381	mod/quiz:reviewmyattempts	read	70	mod_quiz	0
382	mod/quiz:manage	write	70	mod_quiz	16
383	mod/quiz:manageoverrides	write	70	mod_quiz	0
384	mod/quiz:preview	write	70	mod_quiz	0
385	mod/quiz:grade	write	70	mod_quiz	20
386	mod/quiz:regrade	write	70	mod_quiz	16
387	mod/quiz:viewreports	read	70	mod_quiz	8
388	mod/quiz:deleteattempts	write	70	mod_quiz	32
389	mod/quiz:ignoretimelimits	read	70	mod_quiz	0
390	mod/quiz:emailconfirmsubmission	read	70	mod_quiz	0
391	mod/quiz:emailnotifysubmission	read	70	mod_quiz	0
392	mod/quiz:emailwarnoverdue	read	70	mod_quiz	0
393	mod/resource:view	read	70	mod_resource	0
394	mod/resource:addinstance	write	50	mod_resource	4
395	mod/scorm:addinstance	write	50	mod_scorm	4
396	mod/scorm:viewreport	read	70	mod_scorm	0
397	mod/scorm:skipview	read	70	mod_scorm	0
398	mod/scorm:savetrack	write	70	mod_scorm	0
399	mod/scorm:viewscores	read	70	mod_scorm	0
400	mod/scorm:deleteresponses	write	70	mod_scorm	0
401	mod/scorm:deleteownresponses	write	70	mod_scorm	0
402	mod/survey:addinstance	write	50	mod_survey	4
403	mod/survey:participate	read	70	mod_survey	0
404	mod/survey:readresponses	read	70	mod_survey	0
405	mod/survey:download	read	70	mod_survey	0
406	mod/trainingevent:addinstance	write	50	mod_trainingevent	4
407	mod/trainingevent:invite	read	70	mod_trainingevent	0
408	mod/trainingevent:add	read	70	mod_trainingevent	0
409	mod/trainingevent:viewattendees	read	70	mod_trainingevent	0
410	mod/trainingevent:grade	read	70	mod_trainingevent	0
411	mod/url:view	read	70	mod_url	0
412	mod/url:addinstance	write	50	mod_url	4
413	mod/wiki:addinstance	write	50	mod_wiki	4
414	mod/wiki:viewpage	read	70	mod_wiki	0
415	mod/wiki:editpage	write	70	mod_wiki	16
416	mod/wiki:createpage	write	70	mod_wiki	16
417	mod/wiki:viewcomment	read	70	mod_wiki	0
418	mod/wiki:editcomment	write	70	mod_wiki	16
419	mod/wiki:managecomment	write	70	mod_wiki	0
420	mod/wiki:managefiles	write	70	mod_wiki	0
421	mod/wiki:overridelock	write	70	mod_wiki	0
422	mod/wiki:managewiki	write	70	mod_wiki	0
423	mod/workshop:view	read	70	mod_workshop	0
424	mod/workshop:addinstance	write	50	mod_workshop	4
425	mod/workshop:switchphase	write	70	mod_workshop	0
426	mod/workshop:editdimensions	write	70	mod_workshop	4
427	mod/workshop:submit	write	70	mod_workshop	0
428	mod/workshop:peerassess	write	70	mod_workshop	0
429	mod/workshop:manageexamples	write	70	mod_workshop	0
430	mod/workshop:allocate	write	70	mod_workshop	0
431	mod/workshop:publishsubmissions	write	70	mod_workshop	0
432	mod/workshop:viewauthornames	read	70	mod_workshop	0
433	mod/workshop:viewreviewernames	read	70	mod_workshop	0
434	mod/workshop:viewallsubmissions	read	70	mod_workshop	0
435	mod/workshop:viewpublishedsubmissions	read	70	mod_workshop	0
436	mod/workshop:viewauthorpublished	read	70	mod_workshop	0
437	mod/workshop:viewallassessments	read	70	mod_workshop	0
438	mod/workshop:overridegrades	write	70	mod_workshop	0
439	mod/workshop:ignoredeadlines	write	70	mod_workshop	0
440	mod/workshop:deletesubmissions	write	70	mod_workshop	0
441	mod/workshop:exportsubmissions	read	70	mod_workshop	0
442	auth/iomadoidc:manageconnection	write	30	auth_iomadoidc	2
443	auth/iomadoidc:manageconnectionconnect	write	30	auth_iomadoidc	2
444	auth/iomadoidc:manageconnectiondisconnect	write	30	auth_iomadoidc	2
445	auth/oauth2:managelinkedlogins	write	30	auth_oauth2	0
446	enrol/category:synchronised	write	10	enrol_category	0
447	enrol/category:config	write	50	enrol_category	0
448	enrol/cohort:config	write	50	enrol_cohort	0
449	enrol/cohort:unenrol	write	50	enrol_cohort	0
450	enrol/database:unenrol	write	50	enrol_database	0
451	enrol/database:config	write	50	enrol_database	0
452	enrol/flatfile:manage	write	50	enrol_flatfile	0
453	enrol/flatfile:unenrol	write	50	enrol_flatfile	0
454	enrol/guest:config	write	50	enrol_guest	0
455	enrol/imsenterprise:config	write	50	enrol_imsenterprise	0
456	enrol/ldap:manage	write	50	enrol_ldap	0
457	enrol/license:config	write	50	enrol_license	0
458	enrol/license:manage	write	50	enrol_license	0
459	enrol/license:unenrolself	write	50	enrol_license	0
460	enrol/license:unenrol	write	50	enrol_license	0
461	enrol/lti:config	write	50	enrol_lti	0
462	enrol/lti:unenrol	write	50	enrol_lti	0
463	enrol/manual:config	write	50	enrol_manual	0
464	enrol/manual:enrol	write	50	enrol_manual	0
465	enrol/manual:manage	write	50	enrol_manual	0
466	enrol/manual:unenrol	write	50	enrol_manual	0
467	enrol/manual:unenrolself	write	50	enrol_manual	0
468	enrol/meta:config	write	50	enrol_meta	0
469	enrol/meta:selectaslinked	read	50	enrol_meta	0
470	enrol/meta:unenrol	write	50	enrol_meta	0
471	enrol/mnet:config	write	50	enrol_mnet	0
472	enrol/paypal:config	write	50	enrol_paypal	0
473	enrol/paypal:manage	write	50	enrol_paypal	0
474	enrol/paypal:unenrol	write	50	enrol_paypal	0
475	enrol/paypal:unenrolself	write	50	enrol_paypal	0
476	enrol/self:config	write	50	enrol_self	0
477	enrol/self:manage	write	50	enrol_self	0
478	enrol/self:holdkey	write	50	enrol_self	0
479	enrol/self:unenrolself	write	50	enrol_self	0
480	enrol/self:unenrol	write	50	enrol_self	0
481	message/airnotifier:managedevice	write	10	message_airnotifier	0
482	block/activity_modules:addinstance	write	80	block_activity_modules	20
483	block/activity_results:addinstance	write	80	block_activity_results	20
484	block/admin_bookmarks:myaddinstance	write	10	block_admin_bookmarks	0
485	block/admin_bookmarks:addinstance	write	80	block_admin_bookmarks	20
486	block/badges:addinstance	read	80	block_badges	0
487	block/badges:myaddinstance	read	10	block_badges	8
488	block/blog_menu:addinstance	write	80	block_blog_menu	20
489	block/blog_recent:addinstance	write	80	block_blog_recent	20
490	block/blog_tags:addinstance	write	80	block_blog_tags	20
491	block/calendar_month:myaddinstance	write	10	block_calendar_month	0
492	block/calendar_month:addinstance	write	80	block_calendar_month	20
493	block/calendar_upcoming:myaddinstance	write	10	block_calendar_upcoming	0
494	block/calendar_upcoming:addinstance	write	80	block_calendar_upcoming	20
495	block/comments:myaddinstance	write	10	block_comments	0
496	block/comments:addinstance	write	80	block_comments	20
497	block/completionstatus:addinstance	write	80	block_completionstatus	20
498	block/course_list:myaddinstance	write	10	block_course_list	0
499	block/course_list:addinstance	write	80	block_course_list	20
500	block/course_summary:addinstance	write	80	block_course_summary	20
501	block/feedback:addinstance	write	80	block_feedback	20
502	block/globalsearch:myaddinstance	write	10	block_globalsearch	0
503	block/globalsearch:addinstance	write	80	block_globalsearch	0
504	block/glossary_random:myaddinstance	write	10	block_glossary_random	0
505	block/glossary_random:addinstance	write	80	block_glossary_random	20
506	block/html:myaddinstance	write	10	block_html	0
507	block/html:addinstance	write	80	block_html	20
508	block/iomad_approve_access:addinstance	write	80	block_iomad_approve_access	20
509	block/iomad_approve_access:myaddinstance	write	80	block_iomad_approve_access	0
510	block/iomad_approve_access:approve	write	80	block_iomad_approve_access	20
511	block/iomad_commerce:addinstance	read	80	block_iomad_commerce	0
512	block/iomad_commerce:myaddinstance	read	80	block_iomad_commerce	0
513	block/iomad_commerce:admin_view	read	80	block_iomad_commerce	0
514	block/iomad_commerce:add_course	write	80	block_iomad_commerce	0
515	block/iomad_commerce:edit_course	write	80	block_iomad_commerce	0
516	block/iomad_commerce:hide_course	write	80	block_iomad_commerce	0
517	block/iomad_commerce:buyitnow	write	10	block_iomad_commerce	0
518	block/iomad_commerce:delete_course	write	80	block_iomad_commerce	0
519	block/iomad_company_admin:addinstance	read	80	block_iomad_company_admin	0
520	block/iomad_company_admin:myaddinstance	read	80	block_iomad_company_admin	0
521	block/iomad_company_admin:companymanagement_view	read	80	block_iomad_company_admin	0
522	block/iomad_company_admin:usermanagement_view	read	80	block_iomad_company_admin	0
523	block/iomad_company_admin:coursemanagement_view	read	80	block_iomad_company_admin	0
524	block/iomad_company_admin:licensemanagement_view	read	80	block_iomad_company_admin	0
525	block/iomad_company_admin:competencymanagement_view	read	80	block_iomad_company_admin	0
526	block/iomad_company_admin:assign_company_manager	read	80	block_iomad_company_admin	0
527	block/iomad_company_admin:assign_department_manager	read	80	block_iomad_company_admin	0
528	block/iomad_company_admin:assign_educator	read	80	block_iomad_company_admin	0
529	block/iomad_company_admin:assign_company_reporter	read	80	block_iomad_company_admin	0
530	block/iomad_company_admin:view_my_company_email	read	80	block_iomad_company_admin	0
531	block/iomad_company_admin:company_add	write	80	block_iomad_company_admin	0
532	block/iomad_company_admin:company_add_child	write	80	block_iomad_company_admin	0
533	block/iomad_company_admin:company_edit	write	80	block_iomad_company_admin	0
534	block/iomad_company_admin:company_edit_appearance	write	80	block_iomad_company_admin	0
535	block/iomad_company_admin:company_delete	write	80	block_iomad_company_admin	0
536	block/iomad_company_admin:company_view	write	80	block_iomad_company_admin	0
537	block/iomad_company_admin:company_view_all	write	80	block_iomad_company_admin	0
538	block/iomad_company_admin:company_user	write	80	block_iomad_company_admin	0
539	block/iomad_company_admin:company_manager	write	80	block_iomad_company_admin	0
540	block/iomad_company_admin:company_course	write	80	block_iomad_company_admin	0
541	block/iomad_company_admin:company_course_unenrol	write	80	block_iomad_company_admin	0
542	block/iomad_company_admin:createcourse	write	80	block_iomad_company_admin	0
543	block/iomad_company_admin:deletecourses	write	80	block_iomad_company_admin	0
544	block/iomad_company_admin:deleteallcourses	write	80	block_iomad_company_admin	0
545	block/iomad_company_admin:destroycourses	write	80	block_iomad_company_admin	0
546	block/iomad_company_admin:managecourses	write	80	block_iomad_company_admin	0
547	block/iomad_company_admin:viewcourses	write	80	block_iomad_company_admin	0
548	block/iomad_company_admin:user_create	write	80	block_iomad_company_admin	0
549	block/iomad_company_admin:user_upload	write	80	block_iomad_company_admin	0
550	block/iomad_company_admin:company_course_users	write	80	block_iomad_company_admin	0
551	block/iomad_company_admin:company_license_users	write	80	block_iomad_company_admin	0
552	block/iomad_company_admin:editusers	write	80	block_iomad_company_admin	0
553	block/iomad_company_admin:edituserpassword	write	80	block_iomad_company_admin	0
554	block/iomad_company_admin:deleteuser	write	80	block_iomad_company_admin	0
618	block/lp:addinstance	write	10	block_lp	0
555	block/iomad_company_admin:suspenduser	write	80	block_iomad_company_admin	0
556	block/iomad_company_admin:editmanagers	write	80	block_iomad_company_admin	0
557	block/iomad_company_admin:editallusers	write	80	block_iomad_company_admin	0
558	block/iomad_company_admin:company_user_profiles	write	80	block_iomad_company_admin	0
559	block/iomad_company_admin:allcompany_user_profiles	write	80	block_iomad_company_admin	0
560	block/iomad_company_admin:export_departments	write	80	block_iomad_company_admin	0
561	block/iomad_company_admin:import_departments	write	80	block_iomad_company_admin	0
562	block/iomad_company_admin:edit_all_departments	write	80	block_iomad_company_admin	0
563	block/iomad_company_admin:edit_departments	write	80	block_iomad_company_admin	0
564	block/iomad_company_admin:assign_groups	write	80	block_iomad_company_admin	0
565	block/iomad_company_admin:edit_groups	write	80	block_iomad_company_admin	0
566	block/iomad_company_admin:edit_licenses	write	80	block_iomad_company_admin	0
567	block/iomad_company_admin:split_my_licenses	write	80	block_iomad_company_admin	0
568	block/iomad_company_admin:edit_my_licenses	write	80	block_iomad_company_admin	0
569	block/iomad_company_admin:view_licenses	write	80	block_iomad_company_admin	0
570	block/iomad_company_admin:allocate_licenses	write	80	block_iomad_company_admin	0
571	block/iomad_company_admin:unallocate_licenses	write	80	block_iomad_company_admin	0
572	block/iomad_company_admin:classrooms	write	80	block_iomad_company_admin	0
573	block/iomad_company_admin:classrooms_add	write	80	block_iomad_company_admin	0
574	block/iomad_company_admin:classrooms_edit	write	80	block_iomad_company_admin	0
575	block/iomad_company_admin:classrooms_delete	write	80	block_iomad_company_admin	0
576	block/iomad_company_admin:viewsuspendedusers	write	80	block_iomad_company_admin	0
577	block/iomad_company_admin:suspendcompanies	write	80	block_iomad_company_admin	0
578	block/iomad_company_admin:restrict_capabilities	write	80	block_iomad_company_admin	0
579	block/iomad_company_admin:competencyview	write	80	block_iomad_company_admin	0
580	block/iomad_company_admin:manageframeworks	write	80	block_iomad_company_admin	0
581	block/iomad_company_admin:templateview	write	80	block_iomad_company_admin	0
582	block/iomad_company_admin:company_framework	write	80	block_iomad_company_admin	0
583	block/iomad_company_admin:company_template	write	80	block_iomad_company_admin	0
584	block/iomad_company_admin:managetemplates	write	80	block_iomad_company_admin	0
585	block/iomad_company_admin:company_edit_certificateinfo	write	80	block_iomad_company_admin	0
586	block/iomad_company_selector:addinstance	read	80	block_iomad_company_selector	0
587	block/iomad_company_selector:myaddinstance	read	80	block_iomad_company_selector	0
588	block/iomad_html:myaddinstance	write	10	block_iomad_html	0
589	block/iomad_html:addinstance	write	80	block_iomad_html	20
590	block/iomad_learningpath:myaddinstance	write	10	block_iomad_learningpath	0
591	block/iomad_learningpath:addinstance	write	80	block_iomad_learningpath	0
592	block/iomad_link:addinstance	read	80	block_iomad_link	0
593	block/iomad_link:myaddinstance	read	80	block_iomad_link	0
594	block/iomad_link:view	write	80	block_iomad_link	0
595	block/iomad_microlearning:addinstance	read	80	block_iomad_microlearning	0
596	block/iomad_microlearning:myaddinstance	read	80	block_iomad_microlearning	0
597	block/iomad_microlearning:view	read	80	block_iomad_microlearning	0
598	block/iomad_microlearning:thread_clone	read	80	block_iomad_microlearning	0
599	block/iomad_microlearning:edit_threads	read	80	block_iomad_microlearning	0
600	block/iomad_microlearning:import_threads	read	80	block_iomad_microlearning	0
601	block/iomad_microlearning:edit_nuggets	read	80	block_iomad_microlearning	0
602	block/iomad_microlearning:thread_delete	read	80	block_iomad_microlearning	0
603	block/iomad_microlearning:thread_view	read	80	block_iomad_microlearning	0
604	block/iomad_microlearning:assign_threads	read	80	block_iomad_microlearning	0
605	block/iomad_onlineusers:addinstance	read	80	block_iomad_onlineusers	0
606	block/iomad_onlineusers:myaddinstance	read	80	block_iomad_onlineusers	0
607	block/iomad_onlineusers:viewlist	read	80	block_iomad_onlineusers	0
608	block/iomad_progress:overview	read	50	block_iomad_progress	8
609	block/iomad_progress:addinstance	write	80	block_iomad_progress	8
610	block/iomad_progress:myaddinstance	read	80	block_iomad_progress	8
611	block/iomad_reports:addinstance	read	80	block_iomad_reports	0
612	block/iomad_reports:myaddinstance	read	80	block_iomad_reports	0
613	block/iomad_reports:view	read	80	block_iomad_reports	0
614	block/iomad_welcome:addinstance	read	80	block_iomad_welcome	0
615	block/iomad_welcome:myaddinstance	read	80	block_iomad_welcome	0
616	block/iomad_welcome:view	write	80	block_iomad_welcome	0
617	block/login:addinstance	write	80	block_login	20
619	block/lp:myaddinstance	write	10	block_lp	0
620	block/mentees:myaddinstance	write	10	block_mentees	0
621	block/mentees:addinstance	write	80	block_mentees	20
622	block/mnet_hosts:myaddinstance	write	10	block_mnet_hosts	0
623	block/mnet_hosts:addinstance	write	80	block_mnet_hosts	20
624	block/mycourses:myaddinstance	write	10	block_mycourses	0
625	block/mycourses:addinstance	write	80	block_mycourses	20
626	block/myoverview:myaddinstance	write	10	block_myoverview	0
627	block/myprofile:myaddinstance	write	10	block_myprofile	0
628	block/myprofile:addinstance	write	80	block_myprofile	20
629	block/navigation:myaddinstance	write	10	block_navigation	0
630	block/navigation:addinstance	write	80	block_navigation	20
631	block/news_items:myaddinstance	write	10	block_news_items	0
632	block/news_items:addinstance	write	80	block_news_items	20
633	block/online_users:myaddinstance	write	10	block_online_users	0
634	block/online_users:addinstance	write	80	block_online_users	20
635	block/online_users:viewlist	read	80	block_online_users	0
636	block/private_files:myaddinstance	write	10	block_private_files	0
637	block/private_files:addinstance	write	80	block_private_files	20
638	block/quiz_results:addinstance	write	80	block_quiz_results	20
639	block/recent_activity:addinstance	write	80	block_recent_activity	20
640	block/recent_activity:viewaddupdatemodule	read	50	block_recent_activity	0
641	block/recent_activity:viewdeletemodule	read	50	block_recent_activity	0
642	block/recentlyaccessedcourses:myaddinstance	write	10	block_recentlyaccessedcourses	0
643	block/recentlyaccesseditems:myaddinstance	write	10	block_recentlyaccesseditems	0
644	block/rss_client:myaddinstance	write	10	block_rss_client	0
645	block/rss_client:addinstance	write	80	block_rss_client	20
646	block/rss_client:manageownfeeds	write	80	block_rss_client	0
647	block/rss_client:manageanyfeeds	write	80	block_rss_client	16
648	block/search_forums:addinstance	write	80	block_search_forums	20
649	block/section_links:addinstance	write	80	block_section_links	20
650	block/selfcompletion:addinstance	write	80	block_selfcompletion	20
651	block/settings:myaddinstance	write	10	block_settings	0
652	block/settings:addinstance	write	80	block_settings	20
653	block/site_main_menu:addinstance	write	80	block_site_main_menu	20
654	block/social_activities:addinstance	write	80	block_social_activities	20
655	block/starredcourses:myaddinstance	write	10	block_starredcourses	0
656	block/tag_flickr:addinstance	write	80	block_tag_flickr	20
657	block/tag_youtube:addinstance	write	80	block_tag_youtube	20
658	block/tags:myaddinstance	write	10	block_tags	0
659	block/tags:addinstance	write	80	block_tags	20
660	block/timeline:myaddinstance	write	10	block_timeline	0
661	report/completion:view	read	50	report_completion	8
662	report/courseoverview:view	read	10	report_courseoverview	8
663	report/log:view	read	50	report_log	8
664	report/log:viewtoday	read	50	report_log	8
665	report/loglive:view	read	50	report_loglive	8
666	report/outline:view	read	50	report_outline	8
667	report/outline:viewuserreport	read	50	report_outline	8
668	report/participation:view	read	50	report_participation	8
669	report/performance:view	read	10	report_performance	2
670	report/progress:view	read	50	report_progress	8
671	report/questioninstances:view	read	10	report_questioninstances	0
672	report/security:view	read	10	report_security	2
673	report/stats:view	read	50	report_stats	8
674	report/usersessions:manageownsessions	write	30	report_usersessions	0
675	gradeexport/ods:view	read	50	gradeexport_ods	8
676	gradeexport/ods:publish	read	50	gradeexport_ods	8
677	gradeexport/txt:view	read	50	gradeexport_txt	8
678	gradeexport/txt:publish	read	50	gradeexport_txt	8
679	gradeexport/xls:view	read	50	gradeexport_xls	8
680	gradeexport/xls:publish	read	50	gradeexport_xls	8
681	gradeexport/xml:view	read	50	gradeexport_xml	8
682	gradeexport/xml:publish	read	50	gradeexport_xml	8
683	gradeimport/csv:view	write	50	gradeimport_csv	0
684	gradeimport/direct:view	write	50	gradeimport_direct	0
685	gradeimport/xml:view	write	50	gradeimport_xml	0
686	gradeimport/xml:publish	write	50	gradeimport_xml	0
687	gradereport/grader:view	read	50	gradereport_grader	8
688	gradereport/history:view	read	50	gradereport_history	8
689	gradereport/outcomes:view	read	50	gradereport_outcomes	8
690	gradereport/overview:view	read	50	gradereport_overview	8
691	gradereport/singleview:view	read	50	gradereport_singleview	8
692	gradereport/user:view	read	50	gradereport_user	8
693	webservice/rest:use	read	50	webservice_rest	0
694	webservice/soap:use	read	50	webservice_soap	0
695	webservice/xmlrpc:use	read	50	webservice_xmlrpc	0
696	repository/areafiles:view	read	70	repository_areafiles	0
697	repository/boxnet:view	read	70	repository_boxnet	0
698	repository/coursefiles:view	read	70	repository_coursefiles	0
699	repository/dropbox:view	read	70	repository_dropbox	0
700	repository/equella:view	read	70	repository_equella	0
701	repository/filesystem:view	read	70	repository_filesystem	0
702	repository/flickr:view	read	70	repository_flickr	0
703	repository/flickr_public:view	read	70	repository_flickr_public	0
704	repository/googledocs:view	read	70	repository_googledocs	0
705	repository/local:view	read	70	repository_local	0
706	repository/merlot:view	read	70	repository_merlot	0
707	repository/nextcloud:view	read	70	repository_nextcloud	0
708	repository/onedrive:view	read	70	repository_onedrive	0
709	repository/picasa:view	read	70	repository_picasa	0
710	repository/recent:view	read	70	repository_recent	0
711	repository/s3:view	read	70	repository_s3	0
712	repository/skydrive:view	read	70	repository_skydrive	0
713	repository/upload:view	read	70	repository_upload	0
714	repository/url:view	read	70	repository_url	0
715	repository/user:view	read	70	repository_user	0
716	repository/webdav:view	read	70	repository_webdav	0
717	repository/wikimedia:view	read	70	repository_wikimedia	0
718	repository/youtube:view	read	70	repository_youtube	0
719	tool/customlang:view	read	10	tool_customlang	2
720	tool/customlang:edit	write	10	tool_customlang	6
721	tool/dataprivacy:managedatarequests	write	10	tool_dataprivacy	60
722	tool/dataprivacy:requestdeleteforotheruser	write	10	tool_dataprivacy	60
723	tool/dataprivacy:managedataregistry	write	10	tool_dataprivacy	60
724	tool/dataprivacy:makedatarequestsforchildren	write	30	tool_dataprivacy	24
725	tool/dataprivacy:makedatadeletionrequestsforchildren	write	30	tool_dataprivacy	24
726	tool/dataprivacy:downloadownrequest	read	30	tool_dataprivacy	0
727	tool/dataprivacy:downloadallrequests	read	30	tool_dataprivacy	8
728	tool/dataprivacy:requestdelete	write	30	tool_dataprivacy	32
729	tool/iomadmerge:iomadmerge	write	10	tool_iomadmerge	32
730	tool/lpmigrate:frameworksmigrate	write	10	tool_lpmigrate	0
731	tool/monitor:subscribe	read	50	tool_monitor	8
732	tool/monitor:managerules	write	50	tool_monitor	4
733	tool/monitor:managetool	write	10	tool_monitor	4
734	tool/policy:accept	write	10	tool_policy	0
735	tool/policy:acceptbehalf	write	30	tool_policy	8
736	tool/policy:managedocs	write	10	tool_policy	0
737	tool/policy:viewacceptances	read	10	tool_policy	0
738	tool/recyclebin:deleteitems	write	50	tool_recyclebin	32
739	tool/recyclebin:restoreitems	write	50	tool_recyclebin	0
740	tool/recyclebin:viewitems	read	50	tool_recyclebin	0
741	tool/uploaduser:uploaduserpictures	write	10	tool_uploaduser	16
742	tool/usertours:managetours	write	10	tool_usertours	4
743	local/email:list	read	10	local_email	0
744	local/email:edit	write	10	local_email	0
745	local/email:delete	write	10	local_email	0
746	local/email:add	write	10	local_email	0
747	local/email:send	write	10	local_email	0
748	local/email:templateset_list	read	10	local_email	0
749	local/iomad_learningpath:view	read	10	local_iomad_learningpath	0
750	local/iomad_learningpath:manage	write	10	local_iomad_learningpath	0
751	local/iomad_settings:addinstance	read	80	local_iomad_settings	0
752	local/report_attendance:view	read	10	local_report_attendance	8
753	local/report_companies:view	read	10	local_report_companies	8
754	local/report_completion:view	read	10	local_report_completion	8
755	local/report_completion_monthly:view	read	10	local_report_completion_monthly	8
756	local/report_emails:view	read	10	local_report_emails	8
757	local/report_emails:resend	read	10	local_report_emails	8
758	local/report_license_usage:view	read	10	local_report_license_usage	8
759	local/report_user_license_allocations:view	read	10	local_report_user_license_allocations	8
760	local/report_user_logins:view	read	10	local_report_user_logins	8
761	local/report_users:view	read	10	local_report_users	8
762	local/report_users:deleteentries	read	10	local_report_users	8
763	local/report_users:deleteentriesfull	read	10	local_report_users	8
764	local/report_users:clearentries	read	10	local_report_users	8
765	booktool/exportimscp:export	read	70	booktool_exportimscp	0
766	booktool/importhtml:import	write	70	booktool_importhtml	4
767	booktool/print:print	read	70	booktool_print	0
768	forumreport/summary:view	read	70	forumreport_summary	0
769	forumreport/summary:viewall	read	70	forumreport_summary	8
770	quiz/grading:viewstudentnames	read	70	quiz_grading	0
771	quiz/grading:viewidnumber	read	70	quiz_grading	0
772	quiz/statistics:view	read	70	quiz_statistics	0
773	atto/h5p:addembed	write	70	atto_h5p	0
774	atto/recordrtc:recordaudio	write	70	atto_recordrtc	0
775	atto/recordrtc:recordvideo	write	70	atto_recordrtc	0
\.


--
-- Data for Name: mdl_certificate_serialnumber; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_certificate_serialnumber (id, certificateid, issued_certificate, prefix, sequenceno, timecreated, sequence) FROM stdin;
\.


--
-- Data for Name: mdl_chat; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_chat (id, course, name, intro, introformat, keepdays, studentlogs, chattime, schedule, timemodified) FROM stdin;
\.


--
-- Data for Name: mdl_chat_messages; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_chat_messages (id, chatid, userid, groupid, issystem, message, "timestamp") FROM stdin;
\.


--
-- Data for Name: mdl_chat_messages_current; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_chat_messages_current (id, chatid, userid, groupid, issystem, message, "timestamp") FROM stdin;
\.


--
-- Data for Name: mdl_chat_users; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_chat_users (id, chatid, userid, groupid, version, ip, firstping, lastping, lastmessageping, sid, course, lang) FROM stdin;
\.


--
-- Data for Name: mdl_choice; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_choice (id, course, name, intro, introformat, publish, showresults, display, allowupdate, allowmultiple, showunanswered, includeinactive, limitanswers, timeopen, timeclose, showpreview, timemodified, completionsubmit) FROM stdin;
\.


--
-- Data for Name: mdl_choice_answers; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_choice_answers (id, choiceid, userid, optionid, timemodified) FROM stdin;
\.


--
-- Data for Name: mdl_choice_options; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_choice_options (id, choiceid, text, maxanswers, timemodified) FROM stdin;
\.


--
-- Data for Name: mdl_classroom; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_classroom (id, companyid, name, address, city, country, postcode, capacity) FROM stdin;
\.


--
-- Data for Name: mdl_cohort; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_cohort (id, contextid, name, idnumber, description, descriptionformat, visible, component, timecreated, timemodified, theme) FROM stdin;
\.


--
-- Data for Name: mdl_cohort_members; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_cohort_members (id, cohortid, userid, timeadded) FROM stdin;
\.


--
-- Data for Name: mdl_comments; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_comments (id, contextid, component, commentarea, itemid, content, format, userid, timecreated) FROM stdin;
\.


--
-- Data for Name: mdl_company; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_company (id, name, shortname, code, city, country, maildisplay, mailformat, maildigest, autosubscribe, trackforums, htmleditor, screenreader, timezone, lang, bgcolor_header, bgcolor_content, theme, category, profileid, suspended, customcss, maincolor, headingcolor, linkcolor, emailprofileid, supervisorprofileid, managernotify, parentid, ecommerce, custommenuitems, managerdigestday, previousroletemplateid, previousemailtemplateid, hostname, maxusers, validto, suspendafter, companyterminated) FROM stdin;
\.


--
-- Data for Name: mdl_company_comp_frameworks; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_company_comp_frameworks (id, companyid, frameworkid) FROM stdin;
\.


--
-- Data for Name: mdl_company_comp_templates; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_company_comp_templates (id, companyid, templateid) FROM stdin;
\.


--
-- Data for Name: mdl_company_course; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_company_course (id, companyid, courseid, departmentid, autoenrol) FROM stdin;
\.


--
-- Data for Name: mdl_company_course_groups; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_company_course_groups (id, companyid, groupid, courseid) FROM stdin;
\.


--
-- Data for Name: mdl_company_created_courses; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_company_created_courses (id, companyid, courseid) FROM stdin;
\.


--
-- Data for Name: mdl_company_domains; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_company_domains (id, companyid, domain) FROM stdin;
\.


--
-- Data for Name: mdl_company_role_restriction; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_company_role_restriction (id, companyid, roleid, capability) FROM stdin;
\.


--
-- Data for Name: mdl_company_role_templates; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_company_role_templates (id, name) FROM stdin;
\.


--
-- Data for Name: mdl_company_role_templates_ass; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_company_role_templates_ass (id, companyid, templateid) FROM stdin;
\.


--
-- Data for Name: mdl_company_role_templates_caps; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_company_role_templates_caps (id, templateid, roleid, capability) FROM stdin;
\.


--
-- Data for Name: mdl_company_shared_courses; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_company_shared_courses (id, companyid, courseid) FROM stdin;
\.


--
-- Data for Name: mdl_company_shared_frameworks; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_company_shared_frameworks (id, companyid, frameworkid) FROM stdin;
\.


--
-- Data for Name: mdl_company_shared_templates; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_company_shared_templates (id, companyid, templateid) FROM stdin;
\.


--
-- Data for Name: mdl_company_transient_tokens; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_company_transient_tokens (id, userid, expires, token) FROM stdin;
\.


--
-- Data for Name: mdl_company_users; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_company_users (id, companyid, userid, managertype, departmentid, suspended, educator) FROM stdin;
\.


--
-- Data for Name: mdl_companycertificate; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_companycertificate (id, companyid, uselogo, usewatermark, usesignature, useborder, showgrade) FROM stdin;
\.


--
-- Data for Name: mdl_companylicense; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_companylicense (id, name, allocation, humanallocation, validlength, startdate, expirydate, used, companyid, parentid, type, program, reference, instant, cutoffdate, clearonexpire) FROM stdin;
\.


--
-- Data for Name: mdl_companylicense_courses; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_companylicense_courses (id, licenseid, courseid) FROM stdin;
\.


--
-- Data for Name: mdl_companylicense_users; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_companylicense_users (id, licenseid, userid, isusing, timecompleted, score, result, licensecourseid, issuedate, groupid) FROM stdin;
\.


--
-- Data for Name: mdl_competency; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency (id, shortname, description, descriptionformat, idnumber, competencyframeworkid, parentid, path, sortorder, ruletype, ruleoutcome, ruleconfig, scaleid, scaleconfiguration, timecreated, timemodified, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_competency_coursecomp; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_coursecomp (id, courseid, competencyid, ruleoutcome, timecreated, timemodified, usermodified, sortorder) FROM stdin;
\.


--
-- Data for Name: mdl_competency_coursecompsetting; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_coursecompsetting (id, courseid, pushratingstouserplans, timecreated, timemodified, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_competency_evidence; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_evidence (id, usercompetencyid, contextid, action, actionuserid, descidentifier, desccomponent, desca, url, grade, note, timecreated, timemodified, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_competency_framework; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_framework (id, shortname, contextid, idnumber, description, descriptionformat, scaleid, scaleconfiguration, visible, taxonomies, timecreated, timemodified, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_competency_modulecomp; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_modulecomp (id, cmid, timecreated, timemodified, usermodified, sortorder, competencyid, ruleoutcome) FROM stdin;
\.


--
-- Data for Name: mdl_competency_plan; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_plan (id, name, description, descriptionformat, userid, templateid, origtemplateid, status, duedate, reviewerid, timecreated, timemodified, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_competency_plancomp; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_plancomp (id, planid, competencyid, sortorder, timecreated, timemodified, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_competency_relatedcomp; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_relatedcomp (id, competencyid, relatedcompetencyid, timecreated, timemodified, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_competency_template; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_template (id, shortname, contextid, description, descriptionformat, visible, duedate, timecreated, timemodified, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_competency_templatecohort; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_templatecohort (id, templateid, cohortid, timecreated, timemodified, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_competency_templatecomp; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_templatecomp (id, templateid, competencyid, timecreated, timemodified, usermodified, sortorder) FROM stdin;
\.


--
-- Data for Name: mdl_competency_usercomp; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_usercomp (id, userid, competencyid, status, reviewerid, proficiency, grade, timecreated, timemodified, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_competency_usercompcourse; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_usercompcourse (id, userid, courseid, competencyid, proficiency, grade, timecreated, timemodified, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_competency_usercompplan; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_usercompplan (id, userid, competencyid, planid, proficiency, grade, sortorder, timecreated, timemodified, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_competency_userevidence; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_userevidence (id, userid, name, description, descriptionformat, url, timecreated, timemodified, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_competency_userevidencecomp; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_userevidencecomp (id, userevidenceid, competencyid, timecreated, timemodified, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_config; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_config (id, name, value) FROM stdin;
4	enrol_plugins_enabled	manual,guest,self,cohort,license
6	filter_multilang_converted	1
7	siteidentifier	UUVCF0nMU1gKluBJTCDnBALw8Vcm7NBjarrupe.ac.zw
10	mnet_dispatcher_mode	off
11	sessiontimeout	7200
12	stringfilters	
15	antiviruses	
16	media_plugins_sortorder	videojs,youtube,swf
17	upgrade_extracreditweightsstepignored	1
18	upgrade_calculatedgradeitemsignored	1
19	upgrade_letterboundarycourses	1
20	mnet_localhost_id	1
21	mnet_all_hosts_id	2
22	siteguest	1
27	gdversion	2
28	licenses	unknown,allrightsreserved,public,cc,cc-nd,cc-nc-nd,cc-nc,cc-nc-sa,cc-sa
29	badges_site_backpack	1
30	version	2019111804
3	auth	email,webservice
31	enableoutcomes	0
32	usecomments	1
33	usetags	1
34	enablenotes	1
35	enableportfolios	0
37	enablestats	0
38	enablerssfeeds	0
39	enableblogs	1
41	completiondefault	1
42	enableavailability	1
43	enableplagiarism	0
44	enablebadges	1
45	enableglobalsearch	0
46	allowstealth	0
47	enableanalytics	1
48	allowemojipicker	1
50	defaultpreference_maildisplay	2
51	defaultpreference_mailformat	1
52	defaultpreference_maildigest	0
53	defaultpreference_autosubscribe	1
54	defaultpreference_trackforums	0
55	autologinguests	0
56	hiddenuserfields	
57	showuseridentity	email
58	fullnamedisplay	language
59	alternativefullnameformat	language
60	maxusersperpage	100
61	enablegravatar	0
62	gravatardefaulturl	mm
63	agedigitalconsentverification	0
64	agedigitalconsentmap	*, 16\nAT, 14\nBE, 13\nBG, 14\nCY, 14\nCZ, 15\nDK, 13\nEE, 13\nES, 14\nFI, 13\nFR, 15\nGB, 13\nGR, 15\nIT, 14\nLT, 14\nLV, 13\nMT, 13\nNO, 13\nPT, 13\nSE, 13\nUS, 13
65	sitepolicy	
66	sitepolicyguest	
67	enablecourserequests	1
68	defaultrequestcategory	1
69	lockrequestcategory	0
70	courserequestnotify	
71	enableasyncbackup	0
72	grade_profilereport	user
73	grade_aggregationposition	1
74	grade_includescalesinaggregation	1
75	grade_hiddenasdate	0
76	gradepublishing	0
77	grade_export_exportfeedback	0
78	grade_export_displaytype	1
79	grade_export_decimalpoints	2
80	grade_navmethod	1
81	grade_export_userprofilefields	firstname,lastname,idnumber,institution,department,email
82	grade_export_customprofilefields	
83	recovergradesdefault	0
84	gradeexport	
85	unlimitedgrades	0
86	grade_report_showmin	1
87	gradepointmax	100
88	gradepointdefault	100
89	grade_minmaxtouse	1
90	grade_mygrades_report	overview
91	gradereport_mygradeurl	
92	grade_hideforcedsettings	1
93	grade_aggregation	13
94	grade_aggregation_flag	0
95	grade_aggregations_visible	13
96	grade_aggregateonlygraded	1
97	grade_aggregateonlygraded_flag	2
98	grade_aggregateoutcomes	0
99	grade_aggregateoutcomes_flag	2
100	grade_keephigh	0
101	grade_keephigh_flag	3
102	grade_droplow	0
103	grade_droplow_flag	2
104	grade_overridecat	1
105	grade_displaytype	1
106	grade_decimalpoints	2
107	grade_item_advanced	iteminfo,idnumber,gradepass,plusfactor,multfactor,display,decimals,hiddenuntil,locktime
108	grade_report_studentsperpage	100
109	grade_report_showonlyactiveenrol	1
110	grade_report_quickgrading	1
111	grade_report_showquickfeedback	0
112	grade_report_meanselection	1
113	grade_report_enableajax	0
114	grade_report_showcalculations	1
115	grade_report_showeyecons	0
116	grade_report_showaverages	1
117	grade_report_showlocks	0
118	grade_report_showranges	0
119	grade_report_showanalysisicon	1
120	grade_report_showuserimage	1
121	grade_report_showactivityicons	1
122	grade_report_shownumberofgrades	0
8	backup_version	2019111800
36	enablewebservices	1
14	texteditors	atto,tinymce,textarea
2	rolesactive	1
5	theme	iomadboost
40	enablecompletion	1
24	themerev	1603517064
23	siteadmins	2,35
9	backup_release	3.8
13	filterall	0
123	grade_report_averagesdisplaytype	inherit
124	grade_report_rangesdisplaytype	inherit
125	grade_report_averagesdecimalpoints	inherit
126	grade_report_rangesdecimalpoints	inherit
127	grade_report_historyperpage	50
128	grade_report_overview_showrank	0
129	grade_report_overview_showtotalsifcontainhidden	0
130	grade_report_user_showrank	0
131	grade_report_user_showpercentage	1
132	grade_report_user_showgrade	1
133	grade_report_user_showfeedback	1
134	grade_report_user_showrange	1
135	grade_report_user_showweight	1
136	grade_report_user_showaverage	0
137	grade_report_user_showlettergrade	0
138	grade_report_user_rangedecimals	0
139	grade_report_user_showhiddenitems	1
140	grade_report_user_showtotalsifcontainhidden	0
141	grade_report_user_showcontributiontocoursetotal	1
142	badges_defaultissuername	
143	badges_defaultissuercontact	
144	badges_badgesalt	badges1599810918
145	badges_allowcoursebadges	1
146	badges_allowexternalbackpack	1
148	forcetimezone	99
149	country	0
150	defaultcity	
151	geoip2file	/var/www/moodledata/geoip/GeoLite2-City.mmdb
152	googlemapkey3	
153	allcountrycodes	
154	autolang	1
155	lang	en
156	langmenu	1
157	langlist	
414	defaultblocks_topics	
159	langcache	1
160	langstringcache	1
161	locale	
162	latinexcelexport	0
163	messaging	1
164	messagingallusers	0
165	messagingdefaultpressenter	1
166	messagingdeletereadnotificationsdelay	604800
167	messagingdeleteallnotificationsdelay	2620800
168	messagingallowemailoverride	0
169	requiremodintro	0
171	authloginviaemail	0
172	allowaccountssameemail	0
173	authpreventaccountcreation	0
174	loginpageautofocus	0
175	guestloginbutton	1
176	limitconcurrentlogins	0
177	alternateloginurl	
178	forgottenpasswordurl	
179	auth_instructions	
180	allowemailaddresses	
181	denyemailaddresses	
182	verifychangedemail	1
183	recaptchapublickey	
184	recaptchaprivatekey	
185	filteruploadedfiles	0
186	filtermatchoneperpage	0
187	filtermatchonepertext	0
188	sitedefaultlicense	allrightsreserved
189	media_default_width	400
190	media_default_height	300
191	portfolio_moderate_filesize_threshold	1048576
192	portfolio_high_filesize_threshold	5242880
193	portfolio_moderate_db_threshold	20
194	portfolio_high_db_threshold	50
195	repositorycacheexpire	120
196	repositorygetfiletimeout	30
197	repositorysyncfiletimeout	1
198	repositorysyncimagetimeout	3
199	repositoryallowexternallinks	1
200	legacyfilesinnewcourses	0
201	legacyfilesaddallowed	1
202	searchengine	simpledb
203	searchindexwhendisabled	0
204	searchindextime	600
205	searchallavailablecourses	0
206	searchincludeallcourses	0
207	searchenablecategories	0
208	searchdefaultcategory	core-all
209	searchhideallcategory	0
210	enablewsdocumentation	0
211	allowbeforeblock	0
212	allowedip	
213	blockedip	
214	protectusernames	1
215	forcelogin	1
216	forceloginforprofiles	1
217	forceloginforprofileimage	0
218	opentowebcrawlers	0
219	allowindexing	0
220	maxbytes	0
221	userquota	104857600
222	allowobjectembed	0
223	enabletrusttext	0
224	maxeditingtime	1800
226	keeptagnamecase	1
227	profilesforenrolledusersonly	1
228	cronclionly	1
229	cronremotepassword	
230	lockoutthreshold	0
231	lockoutwindow	1800
232	lockoutduration	1800
234	minpasswordlength	8
235	minpassworddigits	1
236	minpasswordlower	1
237	minpasswordupper	1
238	minpasswordnonalphanum	1
239	maxconsecutiveidentchars	0
240	passwordreuselimit	0
241	pwresettime	1800
242	passwordchangelogout	0
243	passwordchangetokendeletion	0
244	tokenduration	7257600
245	groupenrolmentkeypolicy	1
246	disableuserimages	0
247	emailchangeconfirmation	1
248	rememberusername	2
233	passwordpolicy	0
249	strictformsrequired	0
250	cookiesecure	1
251	cookiehttponly	0
252	allowframembedding	0
253	curlsecurityblockedhosts	
254	curlsecurityallowedport	
255	displayloginfailures	0
256	notifyloginfailures	
257	notifyloginthreshold	10
258	themelist	
259	themedesignermode	0
261	allowcoursethemes	0
262	allowcategorythemes	0
263	allowcohortthemes	0
264	allowthemechangeonurl	0
265	allowuserblockhiding	1
266	custommenuitems	
267	customusermenuitems	grades,grades|/grade/report/mygrades.php|t/grades\nmessages,message|/message/index.php|t/message\npreferences,moodle|/user/preferences.php|t/preferences
268	enabledevicedetection	1
269	devicedetectregex	[]
270	calendartype	gregorian
271	calendar_adminseesall	0
272	calendar_site_timeformat	0
273	calendar_startwday	1
274	calendar_weekend	65
275	calendar_lookahead	21
276	calendar_maxevents	10
277	enablecalendarexport	1
278	calendar_customexport	1
279	calendar_exportlookahead	365
280	calendar_exportlookback	5
260	allowuserthemes	1
282	calendar_showicalsource	1
283	useblogassociations	1
284	bloglevel	4
285	useexternalblogs	1
286	externalblogcrontime	86400
287	maxexternalblogsperuser	1
288	blogusecomments	1
289	blogshowcommentscount	1
290	defaulthomepage	1
291	allowguestmymoodle	1
292	navshowfullcoursenames	0
293	navshowcategories	1
294	navshowmycoursecategories	0
295	navshowallcourses	0
296	navsortmycoursessort	sortorder
297	navsortmycourseshiddenlast	1
298	navcourselimit	10
299	usesitenameforsitepages	0
300	linkadmincategories	1
301	linkcoursesections	1
302	navshowfrontpagemods	1
303	navadduserpostslinks	1
304	formatstringstriptags	1
305	emoticons	[{"text":":-)","imagename":"s\\/smiley","imagecomponent":"core","altidentifier":"smiley","altcomponent":"core_pix"},{"text":":)","imagename":"s\\/smiley","imagecomponent":"core","altidentifier":"smiley","altcomponent":"core_pix"},{"text":":-D","imagename":"s\\/biggrin","imagecomponent":"core","altidentifier":"biggrin","altcomponent":"core_pix"},{"text":";-)","imagename":"s\\/wink","imagecomponent":"core","altidentifier":"wink","altcomponent":"core_pix"},{"text":":-\\/","imagename":"s\\/mixed","imagecomponent":"core","altidentifier":"mixed","altcomponent":"core_pix"},{"text":"V-.","imagename":"s\\/thoughtful","imagecomponent":"core","altidentifier":"thoughtful","altcomponent":"core_pix"},{"text":":-P","imagename":"s\\/tongueout","imagecomponent":"core","altidentifier":"tongueout","altcomponent":"core_pix"},{"text":":-p","imagename":"s\\/tongueout","imagecomponent":"core","altidentifier":"tongueout","altcomponent":"core_pix"},{"text":"B-)","imagename":"s\\/cool","imagecomponent":"core","altidentifier":"cool","altcomponent":"core_pix"},{"text":"^-)","imagename":"s\\/approve","imagecomponent":"core","altidentifier":"approve","altcomponent":"core_pix"},{"text":"8-)","imagename":"s\\/wideeyes","imagecomponent":"core","altidentifier":"wideeyes","altcomponent":"core_pix"},{"text":":o)","imagename":"s\\/clown","imagecomponent":"core","altidentifier":"clown","altcomponent":"core_pix"},{"text":":-(","imagename":"s\\/sad","imagecomponent":"core","altidentifier":"sad","altcomponent":"core_pix"},{"text":":(","imagename":"s\\/sad","imagecomponent":"core","altidentifier":"sad","altcomponent":"core_pix"},{"text":"8-.","imagename":"s\\/shy","imagecomponent":"core","altidentifier":"shy","altcomponent":"core_pix"},{"text":":-I","imagename":"s\\/blush","imagecomponent":"core","altidentifier":"blush","altcomponent":"core_pix"},{"text":":-X","imagename":"s\\/kiss","imagecomponent":"core","altidentifier":"kiss","altcomponent":"core_pix"},{"text":"8-o","imagename":"s\\/surprise","imagecomponent":"core","altidentifier":"surprise","altcomponent":"core_pix"},{"text":"P-|","imagename":"s\\/blackeye","imagecomponent":"core","altidentifier":"blackeye","altcomponent":"core_pix"},{"text":"8-[","imagename":"s\\/angry","imagecomponent":"core","altidentifier":"angry","altcomponent":"core_pix"},{"text":"(grr)","imagename":"s\\/angry","imagecomponent":"core","altidentifier":"angry","altcomponent":"core_pix"},{"text":"xx-P","imagename":"s\\/dead","imagecomponent":"core","altidentifier":"dead","altcomponent":"core_pix"},{"text":"|-.","imagename":"s\\/sleepy","imagecomponent":"core","altidentifier":"sleepy","altcomponent":"core_pix"},{"text":"}-]","imagename":"s\\/evil","imagecomponent":"core","altidentifier":"evil","altcomponent":"core_pix"},{"text":"(h)","imagename":"s\\/heart","imagecomponent":"core","altidentifier":"heart","altcomponent":"core_pix"},{"text":"(heart)","imagename":"s\\/heart","imagecomponent":"core","altidentifier":"heart","altcomponent":"core_pix"},{"text":"(y)","imagename":"s\\/yes","imagecomponent":"core","altidentifier":"yes","altcomponent":"core"},{"text":"(n)","imagename":"s\\/no","imagecomponent":"core","altidentifier":"no","altcomponent":"core"},{"text":"(martin)","imagename":"s\\/martin","imagecomponent":"core","altidentifier":"martin","altcomponent":"core_pix"},{"text":"( )","imagename":"s\\/egg","imagecomponent":"core","altidentifier":"egg","altcomponent":"core_pix"}]
306	docroot	https://docs.moodle.org
307	doclang	
308	doctonewwindow	0
309	coursecontactduplicates	0
310	courselistshortnames	0
311	coursesperpage	20
312	courseswithsummarieslimit	10
313	courseoverviewfileslimit	1
314	courseoverviewfilesext	.jpg,.gif,.png
315	coursegraceperiodbefore	0
316	coursegraceperiodafter	0
317	useexternalyui	0
318	yuicomboloading	1
319	cachejs	1
320	modchooserdefault	1
321	additionalhtmlhead	
322	additionalhtmltopofbody	
323	additionalhtmlfooter	
324	cachetemplates	1
325	pathtophp	
326	pathtodu	
327	aspellpath	
328	pathtodot	
329	pathtogs	/usr/bin/gs
330	pathtopython	
331	supportname	Admin User
332	supportemail	
333	supportpage	
334	dbsessions	0
335	sessioncookie	
336	sessioncookiepath	
337	sessioncookiedomain	
338	statsfirstrun	none
339	statsmaxruntime	0
340	statsruntimedays	31
341	statsuserthreshold	0
342	slasharguments	1
343	getremoteaddrconf	3
344	reverseproxyignore	
345	proxyhost	
346	proxyport	0
347	proxytype	HTTP
348	proxyuser	
349	proxypassword	
350	proxybypass	localhost, 127.0.0.1
351	maintenance_enabled	0
352	maintenance_message	
353	deleteunconfirmed	168
354	deleteincompleteusers	0
355	disablegradehistory	0
356	gradehistorylifetime	0
357	tempdatafoldercleanup	168
358	filescleanupperiod	86400
359	extramemorylimit	512M
360	maxtimelimit	0
361	curlcache	120
362	curltimeoutkbitrate	56
363	task_scheduled_concurrency_limit	3
364	task_scheduled_max_runtime	1800
365	task_adhoc_concurrency_limit	3
366	task_adhoc_max_runtime	1800
367	task_logmode	1
368	task_logtostdout	1
369	task_logretention	2419200
370	task_logretainruns	20
415	defaultblocks_weeks	
371	smtphosts	
372	smtpsecure	
373	smtpauthtype	LOGIN
374	smtpuser	
375	smtppass	
376	smtpmaxbulk	1
377	noreplyaddress	noreply@arrupe.ac.zw
378	allowedemaildomains	
379	sitemailcharset	0
380	allowusermailcharset	0
381	allowattachments	1
382	mailnewline	LF
383	emailfromvia	1
384	emailsubjectprefix	
385	updateautocheck	1
386	updateminmaturity	200
387	updatenotifybuilds	0
388	enablesafebrowserintegration	0
389	dndallowtextandlinks	0
390	pathtosassc	
391	contextlocking	0
392	contextlockappliestoadmin	1
393	forceclean	0
394	enablecourserelativedates	0
395	debug	0
396	debugdisplay	0
397	perfdebug	7
398	debugstringids	0
399	debugvalidators	0
400	debugpageinfo	0
401	profilingenabled	0
402	profilingincluded	
403	profilingexcluded	
404	profilingautofrec	0
405	profilingallowme	0
406	profilingallowall	0
407	profilingslow	0
408	profilinglifetime	1440
409	profilingimportprefix	(I)
281	calendar_exportsalt	h5KSQtgUSDNcR75RzBpp2Q2ayC1KAEfKpakDyWI6Pnf1w92eDl6VpxnB43M1
410	release	3.8.4 (Build: 20200713)
411	branch	38
451	forum_shortpost	300
452	forum_longpost	600
453	forum_manydiscussions	100
454	forum_maxbytes	512000
455	forum_maxattachments	9
456	forum_subscription	0
457	forum_trackingtype	1
458	forum_trackreadposts	1
459	forum_allowforcedreadtracking	0
460	forum_oldpostdays	14
461	forum_usermarksread	0
462	forum_cleanreadtime	2
463	digestmailtime	17
464	forum_enablerssfeeds	0
465	forum_enabletimedposts	1
466	glossary_entbypage	10
467	glossary_dupentries	0
468	glossary_allowcomments	0
469	glossary_linkbydefault	1
470	glossary_defaultapproval	1
471	glossary_enablerssfeeds	0
472	glossary_linkentries	0
473	glossary_casesensitive	0
474	glossary_fullmatch	0
475	commerce_enable_external	0
476	commerce_externalshop_url	
477	commerce_externalshop_link_timeout	30
478	commerce_admin_firstname	
479	commerce_admin_lastname	
480	commerce_admin_email	
481	commerce_admin_currency	GBP
482	commerce_admin_enableall	1
416	allversionshash	fab9b28f1e54009257666193188f50b7e1eaa45a
158	langrev	1603517064
418	registrationpending	0
422	notloggedinroleid	6
423	guestroleid	6
424	defaultuserroleid	7
425	creatornewroleid	3
426	restorernewroleid	3
427	sitepolicyhandler	
428	gradebookroles	5
429	jabberhost	
430	jabberserver	
431	jabberusername	
432	jabberpassword	
433	jabberport	5222
434	airnotifierurl	https://messages.moodle.net
435	airnotifierport	443
436	airnotifiermobileappname	com.moodle.moodlemobile
437	airnotifierappname	commoodlemoodlemobile
438	airnotifieraccesskey	
439	chat_method	ajax
440	chat_refresh_userlist	10
441	chat_old_ping	35
442	chat_refresh_room	5
443	chat_normal_updatemode	jsupdate
225	extendedusernamechars	1
444	chat_serverhost	arrupe.ac.zw
445	chat_serverip	127.0.0.1
446	chat_serverport	9111
447	chat_servermax	100
448	data_enablerssfeeds	0
483	commerce_admin_default_license_access_length	30
449	feedback_allowfullanonymous	0
450	forum_displaymode	3
484	commerce_admin_default_license_shelf_life	365
485	invoice_enabled	0
486	paypal_enabled	0
487	paypal_usesandbox	0
488	paypal_api_username	
489	paypal_api_password	
490	paypal_api_signature	
491	block_html_allowcssclasses	0
492	block_iomad_html_allowcssclasses	0
493	microlearninglinkexpires	30
494	block_iomad_onlineusers_timetosee	5
495	mycourses_archivecutoff	100
496	mycourses_showsummary	0
497	block_online_users_timetosee	5
498	block_online_users_onlinestatushiding	1
499	block_rss_client_num_entries	5
500	block_rss_client_timeout	30
501	pathtounoconv	/usr/bin/unoconv
502	filter_multilang_force_old	0
503	filter_censor_badwords	
504	establishment_code	0
505	iomad_use_email_as_username	0
506	iomad_allow_username	0
507	iomad_sync_institution	0
508	iomad_sync_department	0
509	iomad_autoenrol_managers	1
510	iomad_autoreallocate_licenses	0
511	iomad_hidevalidcourses	0
512	iomad_date_format	Y-m-d
513	iomad_report_fields	
514	iomad_report_grade_places	0
515	iomad_max_list_users	30
516	iomad_max_list_courses	30
517	iomad_max_list_templates	30
518	iomad_max_list_companies	30
519	iomad_max_list_licenses	30
520	iomad_max_list_classrooms	30
521	iomad_max_list_email_templates	30
522	iomad_max_list_competencies	30
523	iomad_max_list_frameworks	30
524	iomad_max_select_users	100
525	iomad_max_select_courses	200
526	iomad_max_select_templates	200
527	iomad_max_select_frameworks	200
528	local_iomad_signup_enable	1
529	local_iomad_signup_showinstructions	1
530	local_iomad_signup_useemail	1
531	local_iomad_signup_autoenrol	1
532	local_iomad_signup_autoenrol_unassigned	0
533	logguests	1
534	loglifetime	0
536	coursecontact	3
537	frontpage	6
538	frontpageloggedin	6
539	maxcategorydepth	2
540	frontpagecourselimit	200
541	commentsperpage	15
542	defaultfrontpageroleid	8
543	messageinbound_enabled	0
544	messageinbound_mailbox	
545	messageinbound_domain	
546	messageinbound_host	
547	messageinbound_hostssl	ssl
548	messageinbound_hostuser	
549	messageinbound_hostpass	
551	enablemobilewebservice	1
552	block_course_list_adminview	all
553	block_course_list_hideallcourseslink	0
554	mobilecssurl	
555	timezone	Europe/London
419	local_iomad_signup_auth	
420	local_iomad_signup_role	0
421	local_iomad_signup_company	0
550	webserviceprotocols	soap,xmlrpc,rest
556	registerauth	email
25	jsrev	1603517064
26	templaterev	1603517064
412	localcachedirpurged	1603517064
413	scheduledtaskreset	1603517064
49	userfiltersdefault	username
535	profileroles	3,4,5
\.


--
-- Data for Name: mdl_config_log; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_config_log (id, userid, timemodified, plugin, name, value, oldvalue) FROM stdin;
1	0	1599810936	\N	enableoutcomes	0	\N
2	0	1599810936	\N	usecomments	1	\N
3	0	1599810936	\N	usetags	1	\N
4	0	1599810936	\N	enablenotes	1	\N
5	0	1599810936	\N	enableportfolios	0	\N
6	0	1599810936	\N	enablewebservices	0	\N
7	0	1599810936	\N	enablestats	0	\N
8	0	1599810936	\N	enablerssfeeds	0	\N
9	0	1599810936	\N	enableblogs	1	\N
10	0	1599810936	\N	enablecompletion	1	\N
11	0	1599810936	\N	completiondefault	1	\N
12	0	1599810936	\N	enableavailability	1	\N
13	0	1599810936	\N	enableplagiarism	0	\N
14	0	1599810936	\N	enablebadges	1	\N
15	0	1599810936	\N	enableglobalsearch	0	\N
16	0	1599810936	\N	allowstealth	0	\N
17	0	1599810936	\N	enableanalytics	1	\N
18	0	1599810936	\N	allowemojipicker	1	\N
19	0	1599810936	\N	userfiltersdefault	realname	\N
20	0	1599810936	\N	defaultpreference_maildisplay	2	\N
21	0	1599810936	\N	defaultpreference_mailformat	1	\N
22	0	1599810936	\N	defaultpreference_maildigest	0	\N
23	0	1599810936	\N	defaultpreference_autosubscribe	1	\N
24	0	1599810936	\N	defaultpreference_trackforums	0	\N
25	0	1599810936	\N	autologinguests	0	\N
26	0	1599810936	\N	hiddenuserfields		\N
27	0	1599810936	\N	showuseridentity	email	\N
28	0	1599810936	\N	fullnamedisplay	language	\N
29	0	1599810936	\N	alternativefullnameformat	language	\N
30	0	1599810936	\N	maxusersperpage	100	\N
31	0	1599810936	\N	enablegravatar	0	\N
32	0	1599810936	\N	gravatardefaulturl	mm	\N
33	0	1599810936	\N	agedigitalconsentverification	0	\N
34	0	1599810936	\N	agedigitalconsentmap	*, 16\nAT, 14\nBE, 13\nBG, 14\nCY, 14\nCZ, 15\nDK, 13\nEE, 13\nES, 14\nFI, 13\nFR, 15\nGB, 13\nGR, 15\nIT, 14\nLT, 14\nLV, 13\nMT, 13\nNO, 13\nPT, 13\nSE, 13\nUS, 13	\N
35	0	1599810936	\N	sitepolicy		\N
36	0	1599810936	\N	sitepolicyguest		\N
37	0	1599810936	moodlecourse	visible	1	\N
38	0	1599810936	moodlecourse	format	topics	\N
39	0	1599810936	moodlecourse	maxsections	52	\N
40	0	1599810936	moodlecourse	numsections	4	\N
41	0	1599810936	moodlecourse	hiddensections	0	\N
42	0	1599810936	moodlecourse	coursedisplay	0	\N
43	0	1599810936	moodlecourse	courseenddateenabled	1	\N
44	0	1599810936	moodlecourse	courseduration	31536000	\N
45	0	1599810936	moodlecourse	lang		\N
46	0	1599810936	moodlecourse	newsitems	5	\N
47	0	1599810936	moodlecourse	showgrades	1	\N
48	0	1599810936	moodlecourse	showreports	0	\N
49	0	1599810936	moodlecourse	maxbytes	0	\N
50	0	1599810936	moodlecourse	enablecompletion	1	\N
51	0	1599810937	moodlecourse	groupmode	0	\N
52	0	1599810937	moodlecourse	groupmodeforce	0	\N
53	0	1599810937	\N	enablecourserequests	1	\N
54	0	1599810937	\N	defaultrequestcategory	1	\N
55	0	1599810937	\N	lockrequestcategory	0	\N
56	0	1599810937	\N	courserequestnotify		\N
57	0	1599810937	backup	loglifetime	30	\N
58	0	1599810937	backup	backup_general_users	1	\N
59	0	1599810937	backup	backup_general_users_locked		\N
60	0	1599810937	backup	backup_general_anonymize	0	\N
61	0	1599810937	backup	backup_general_anonymize_locked		\N
62	0	1599810937	backup	backup_general_role_assignments	1	\N
63	0	1599810937	backup	backup_general_role_assignments_locked		\N
64	0	1599810937	backup	backup_general_activities	1	\N
65	0	1599810937	backup	backup_general_activities_locked		\N
66	0	1599810937	backup	backup_general_blocks	1	\N
67	0	1599810937	backup	backup_general_blocks_locked		\N
68	0	1599810937	backup	backup_general_files	1	\N
69	0	1599810937	backup	backup_general_files_locked		\N
70	0	1599810937	backup	backup_general_filters	1	\N
71	0	1599810937	backup	backup_general_filters_locked		\N
72	0	1599810937	backup	backup_general_comments	1	\N
73	0	1599810937	backup	backup_general_comments_locked		\N
74	0	1599810937	backup	backup_general_badges	1	\N
75	0	1599810937	backup	backup_general_badges_locked		\N
76	0	1599810937	backup	backup_general_calendarevents	1	\N
77	0	1599810937	backup	backup_general_calendarevents_locked		\N
78	0	1599810937	backup	backup_general_userscompletion	1	\N
79	0	1599810937	backup	backup_general_userscompletion_locked		\N
80	0	1599810937	backup	backup_general_logs	0	\N
81	0	1599810937	backup	backup_general_logs_locked		\N
82	0	1599810937	backup	backup_general_histories	0	\N
83	0	1599810937	backup	backup_general_histories_locked		\N
84	0	1599810937	backup	backup_general_questionbank	1	\N
85	0	1599810937	backup	backup_general_questionbank_locked		\N
86	0	1599810937	backup	backup_general_groups	1	\N
87	0	1599810937	backup	backup_general_groups_locked		\N
88	0	1599810937	backup	backup_general_competencies	1	\N
89	0	1599810937	backup	backup_general_competencies_locked		\N
90	0	1599810937	backup	import_general_maxresults	10	\N
91	0	1599810937	backup	import_general_duplicate_admin_allowed	0	\N
92	0	1599810937	backup	backup_import_activities	1	\N
93	0	1599810937	backup	backup_import_activities_locked		\N
94	0	1599810937	backup	backup_import_blocks	1	\N
95	0	1599810937	backup	backup_import_blocks_locked		\N
96	0	1599810937	backup	backup_import_filters	1	\N
97	0	1599810937	backup	backup_import_filters_locked		\N
98	0	1599810937	backup	backup_import_calendarevents	1	\N
99	0	1599810937	backup	backup_import_calendarevents_locked		\N
100	0	1599810937	backup	backup_import_questionbank	1	\N
101	0	1599810937	backup	backup_import_questionbank_locked		\N
102	0	1599810937	backup	backup_import_groups	1	\N
103	0	1599810937	backup	backup_import_groups_locked		\N
104	0	1599810937	backup	backup_import_competencies	1	\N
105	0	1599810937	backup	backup_import_competencies_locked		\N
106	0	1599810937	backup	backup_auto_active	0	\N
107	0	1599810937	backup	backup_auto_weekdays	0000000	\N
108	0	1599810937	backup	backup_auto_hour	0	\N
109	0	1599810937	backup	backup_auto_minute	0	\N
110	0	1599810937	backup	backup_auto_storage	0	\N
111	0	1599810937	backup	backup_auto_destination		\N
112	0	1599810937	backup	backup_auto_max_kept	1	\N
113	0	1599810937	backup	backup_auto_delete_days	0	\N
114	0	1599810937	backup	backup_auto_min_kept	0	\N
115	0	1599810937	backup	backup_shortname	0	\N
116	0	1599810937	backup	backup_auto_skip_hidden	1	\N
117	0	1599810937	backup	backup_auto_skip_modif_days	30	\N
118	0	1599810937	backup	backup_auto_skip_modif_prev	0	\N
119	0	1599810937	backup	backup_auto_users	1	\N
120	0	1599810937	backup	backup_auto_role_assignments	1	\N
121	0	1599810937	backup	backup_auto_activities	1	\N
122	0	1599810937	backup	backup_auto_blocks	1	\N
123	0	1599810937	backup	backup_auto_files	1	\N
124	0	1599810937	backup	backup_auto_filters	1	\N
125	0	1599810937	backup	backup_auto_comments	1	\N
126	0	1599810937	backup	backup_auto_badges	1	\N
127	0	1599810937	backup	backup_auto_calendarevents	1	\N
128	0	1599810937	backup	backup_auto_userscompletion	1	\N
129	0	1599810937	backup	backup_auto_logs	0	\N
130	0	1599810937	backup	backup_auto_histories	0	\N
131	0	1599810937	backup	backup_auto_questionbank	1	\N
132	0	1599810938	backup	backup_auto_groups	1	\N
133	0	1599810938	backup	backup_auto_competencies	1	\N
134	0	1599810938	restore	restore_general_users	1	\N
135	0	1599810938	restore	restore_general_users_locked		\N
136	0	1599810938	restore	restore_general_enrolments	1	\N
137	0	1599810938	restore	restore_general_enrolments_locked		\N
138	0	1599810938	restore	restore_general_role_assignments	1	\N
139	0	1599810938	restore	restore_general_role_assignments_locked		\N
140	0	1599810938	restore	restore_general_activities	1	\N
141	0	1599810938	restore	restore_general_activities_locked		\N
142	0	1599810938	restore	restore_general_blocks	1	\N
143	0	1599810938	restore	restore_general_blocks_locked		\N
144	0	1599810938	restore	restore_general_filters	1	\N
145	0	1599810938	restore	restore_general_filters_locked		\N
146	0	1599810938	restore	restore_general_comments	1	\N
147	0	1599810938	restore	restore_general_comments_locked		\N
148	0	1599810938	restore	restore_general_badges	1	\N
149	0	1599810938	restore	restore_general_badges_locked		\N
150	0	1599810938	restore	restore_general_calendarevents	1	\N
151	0	1599810938	restore	restore_general_calendarevents_locked		\N
152	0	1599810938	restore	restore_general_userscompletion	1	\N
153	0	1599810938	restore	restore_general_userscompletion_locked		\N
154	0	1599810938	restore	restore_general_logs	1	\N
155	0	1599810938	restore	restore_general_logs_locked		\N
156	0	1599810938	restore	restore_general_histories	1	\N
157	0	1599810938	restore	restore_general_histories_locked		\N
158	0	1599810938	restore	restore_general_groups	1	\N
159	0	1599810938	restore	restore_general_groups_locked		\N
160	0	1599810938	restore	restore_general_competencies	1	\N
161	0	1599810938	restore	restore_general_competencies_locked		\N
162	0	1599810938	restore	restore_merge_overwrite_conf	0	\N
163	0	1599810938	restore	restore_merge_overwrite_conf_locked		\N
164	0	1599810938	restore	restore_merge_course_fullname	1	\N
165	0	1599810938	restore	restore_merge_course_fullname_locked		\N
166	0	1599810938	restore	restore_merge_course_shortname	1	\N
167	0	1599810938	restore	restore_merge_course_shortname_locked		\N
168	0	1599810938	restore	restore_merge_course_startdate	1	\N
169	0	1599810938	restore	restore_merge_course_startdate_locked		\N
170	0	1599810938	restore	restore_replace_overwrite_conf	0	\N
171	0	1599810938	restore	restore_replace_overwrite_conf_locked		\N
172	0	1599810938	restore	restore_replace_course_fullname	1	\N
173	0	1599810938	restore	restore_replace_course_fullname_locked		\N
174	0	1599810938	restore	restore_replace_course_shortname	1	\N
175	0	1599810938	restore	restore_replace_course_shortname_locked		\N
176	0	1599810938	restore	restore_replace_course_startdate	1	\N
177	0	1599810938	restore	restore_replace_course_startdate_locked		\N
178	0	1599810938	restore	restore_replace_keep_roles_and_enrolments	0	\N
179	0	1599810938	restore	restore_replace_keep_roles_and_enrolments_locked		\N
180	0	1599810938	restore	restore_replace_keep_groups_and_groupings	0	\N
181	0	1599810938	restore	restore_replace_keep_groups_and_groupings_locked		\N
182	0	1599810938	\N	enableasyncbackup	0	\N
183	0	1599810938	backup	backup_async_message_users	0	\N
184	0	1599810938	backup	backup_async_message_subject	Moodle {operation} completed successfully	\N
185	0	1599810938	backup	backup_async_message	Hi {user_firstname},<br/> Your {operation} (ID: {backupid}) has completed successfully. <br/><br/>You can access it here: {link}.	\N
186	0	1599810938	\N	grade_profilereport	user	\N
187	0	1599810938	\N	grade_aggregationposition	1	\N
188	0	1599810938	\N	grade_includescalesinaggregation	1	\N
189	0	1599810938	\N	grade_hiddenasdate	0	\N
190	0	1599810938	\N	gradepublishing	0	\N
191	0	1599810938	\N	grade_export_exportfeedback	0	\N
192	0	1599810938	\N	grade_export_displaytype	1	\N
193	0	1599810938	\N	grade_export_decimalpoints	2	\N
194	0	1599810938	\N	grade_navmethod	1	\N
195	0	1599810938	\N	grade_export_userprofilefields	firstname,lastname,idnumber,institution,department,email	\N
196	0	1599810939	\N	grade_export_customprofilefields		\N
197	0	1599810939	\N	recovergradesdefault	0	\N
198	0	1599810939	\N	gradeexport		\N
199	0	1599810939	\N	unlimitedgrades	0	\N
200	0	1599810939	\N	grade_report_showmin	1	\N
201	0	1599810939	\N	gradepointmax	100	\N
202	0	1599810939	\N	gradepointdefault	100	\N
203	0	1599810939	\N	grade_minmaxtouse	1	\N
204	0	1599810939	\N	grade_mygrades_report	overview	\N
205	0	1599810939	\N	gradereport_mygradeurl		\N
206	0	1599810939	\N	grade_hideforcedsettings	1	\N
207	0	1599810939	\N	grade_aggregation	13	\N
208	0	1599810939	\N	grade_aggregation_flag	0	\N
209	0	1599810939	\N	grade_aggregations_visible	13	\N
210	0	1599810939	\N	grade_aggregateonlygraded	1	\N
211	0	1599810939	\N	grade_aggregateonlygraded_flag	2	\N
212	0	1599810939	\N	grade_aggregateoutcomes	0	\N
213	0	1599810939	\N	grade_aggregateoutcomes_flag	2	\N
214	0	1599810939	\N	grade_keephigh	0	\N
215	0	1599810939	\N	grade_keephigh_flag	3	\N
216	0	1599810939	\N	grade_droplow	0	\N
217	0	1599810939	\N	grade_droplow_flag	2	\N
218	0	1599810939	\N	grade_overridecat	1	\N
219	0	1599810939	\N	grade_displaytype	1	\N
220	0	1599810939	\N	grade_decimalpoints	2	\N
221	0	1599810939	\N	grade_item_advanced	iteminfo,idnumber,gradepass,plusfactor,multfactor,display,decimals,hiddenuntil,locktime	\N
222	0	1599810939	\N	grade_report_studentsperpage	100	\N
223	0	1599810939	\N	grade_report_showonlyactiveenrol	1	\N
224	0	1599810939	\N	grade_report_quickgrading	1	\N
225	0	1599810939	\N	grade_report_showquickfeedback	0	\N
226	0	1599810939	\N	grade_report_meanselection	1	\N
227	0	1599810939	\N	grade_report_enableajax	0	\N
228	0	1599810939	\N	grade_report_showcalculations	1	\N
229	0	1599810939	\N	grade_report_showeyecons	0	\N
230	0	1599810939	\N	grade_report_showaverages	1	\N
231	0	1599810939	\N	grade_report_showlocks	0	\N
232	0	1599810939	\N	grade_report_showranges	0	\N
233	0	1599810939	\N	grade_report_showanalysisicon	1	\N
234	0	1599810939	\N	grade_report_showuserimage	1	\N
235	0	1599810939	\N	grade_report_showactivityicons	1	\N
236	0	1599810939	\N	grade_report_shownumberofgrades	0	\N
237	0	1599810939	\N	grade_report_averagesdisplaytype	inherit	\N
238	0	1599810939	\N	grade_report_rangesdisplaytype	inherit	\N
239	0	1599810939	\N	grade_report_averagesdecimalpoints	inherit	\N
240	0	1599810939	\N	grade_report_rangesdecimalpoints	inherit	\N
241	0	1599810939	\N	grade_report_historyperpage	50	\N
242	0	1599810939	\N	grade_report_overview_showrank	0	\N
243	0	1599810939	\N	grade_report_overview_showtotalsifcontainhidden	0	\N
244	0	1599810939	\N	grade_report_user_showrank	0	\N
245	0	1599810939	\N	grade_report_user_showpercentage	1	\N
246	0	1599810939	\N	grade_report_user_showgrade	1	\N
247	0	1599810939	\N	grade_report_user_showfeedback	1	\N
248	0	1599810939	\N	grade_report_user_showrange	1	\N
249	0	1599810939	\N	grade_report_user_showweight	1	\N
250	0	1599810939	\N	grade_report_user_showaverage	0	\N
251	0	1599810939	\N	grade_report_user_showlettergrade	0	\N
252	0	1599810939	\N	grade_report_user_rangedecimals	0	\N
253	0	1599810939	\N	grade_report_user_showhiddenitems	1	\N
254	0	1599810939	\N	grade_report_user_showtotalsifcontainhidden	0	\N
255	0	1599810939	\N	grade_report_user_showcontributiontocoursetotal	1	\N
256	0	1599810940	analytics	modeinstruction		\N
257	0	1599810940	analytics	percentonline	0	\N
258	0	1599810940	analytics	typeinstitution		\N
259	0	1599810940	analytics	levelinstitution		\N
260	0	1599810940	analytics	predictionsprocessor	\\mlbackend_php\\processor	\N
261	0	1599810940	analytics	defaulttimesplittingsevaluation	\\core\\analytics\\time_splitting\\quarters_accum,\\core\\analytics\\time_splitting\\quarters,\\core\\analytics\\time_splitting\\single_range	\N
262	0	1599810940	analytics	modeloutputdir	/var/www/moodledata/models	\N
263	0	1599810940	analytics	onlycli	1	\N
264	0	1599810940	analytics	modeltimelimit	1200	\N
265	0	1599810940	core_competency	enabled	1	\N
266	0	1599810940	core_competency	pushcourseratingstouserplans	1	\N
267	0	1599810940	\N	badges_defaultissuername		\N
268	0	1599810940	\N	badges_defaultissuercontact		\N
269	0	1599810940	\N	badges_badgesalt	badges1599810918	\N
270	0	1599810940	\N	badges_allowcoursebadges	1	\N
271	0	1599810940	\N	badges_allowexternalbackpack	1	\N
272	0	1599810940	\N	timezone	Europe/London	\N
273	0	1599810941	\N	forcetimezone	99	\N
274	0	1599810941	\N	country	0	\N
275	0	1599810941	\N	defaultcity		\N
276	0	1599810941	\N	geoip2file	/var/www/moodledata/geoip/GeoLite2-City.mmdb	\N
277	0	1599810941	\N	googlemapkey3		\N
278	0	1599810941	\N	allcountrycodes		\N
279	0	1599810941	\N	autolang	1	\N
280	0	1599810941	\N	lang	en	\N
281	0	1599810941	\N	langmenu	1	\N
282	0	1599810941	\N	langlist		\N
283	0	1599810941	\N	langcache	1	\N
284	0	1599810941	\N	langstringcache	1	\N
285	0	1599810941	\N	locale		\N
286	0	1599810941	\N	latinexcelexport	0	\N
287	0	1599810941	\N	messaging	1	\N
288	0	1599810941	\N	messagingallusers	0	\N
289	0	1599810941	\N	messagingdefaultpressenter	1	\N
290	0	1599810941	\N	messagingdeletereadnotificationsdelay	604800	\N
291	0	1599810941	\N	messagingdeleteallnotificationsdelay	2620800	\N
292	0	1599810941	\N	messagingallowemailoverride	0	\N
293	0	1599810941	\N	requiremodintro	0	\N
294	0	1599810941	\N	registerauth		\N
295	0	1599810941	\N	authloginviaemail	0	\N
296	0	1599810941	\N	allowaccountssameemail	0	\N
297	0	1599810941	\N	authpreventaccountcreation	0	\N
298	0	1599810941	\N	loginpageautofocus	0	\N
299	0	1599810941	\N	guestloginbutton	1	\N
300	0	1599810941	\N	limitconcurrentlogins	0	\N
301	0	1599810942	\N	alternateloginurl		\N
302	0	1599810942	\N	forgottenpasswordurl		\N
303	0	1599810942	\N	auth_instructions		\N
304	0	1599810942	\N	allowemailaddresses		\N
305	0	1599810942	\N	denyemailaddresses		\N
306	0	1599810942	\N	verifychangedemail	1	\N
307	0	1599810942	\N	recaptchapublickey		\N
308	0	1599810942	\N	recaptchaprivatekey		\N
309	0	1599810942	cachestore_apcu	testperformance	0	\N
310	0	1599810942	cachestore_memcached	testservers		\N
311	0	1599810942	cachestore_mongodb	testserver		\N
312	0	1599810942	cachestore_redis	test_server		\N
313	0	1599810942	cachestore_redis	test_password		\N
314	0	1599810942	\N	filteruploadedfiles	0	\N
315	0	1599810942	\N	filtermatchoneperpage	0	\N
316	0	1599810942	\N	filtermatchonepertext	0	\N
317	0	1599810942	\N	sitedefaultlicense	allrightsreserved	\N
318	0	1599810942	\N	media_default_width	400	\N
319	0	1599810942	\N	media_default_height	300	\N
320	0	1599810942	\N	portfolio_moderate_filesize_threshold	1048576	\N
321	0	1599810942	\N	portfolio_high_filesize_threshold	5242880	\N
322	0	1599810942	\N	portfolio_moderate_db_threshold	20	\N
323	0	1599810942	\N	portfolio_high_db_threshold	50	\N
324	0	1599810942	question_preview	behaviour	deferredfeedback	\N
325	0	1599810942	question_preview	correctness	1	\N
326	0	1599810942	question_preview	marks	2	\N
327	0	1599810942	question_preview	markdp	2	\N
328	0	1599810942	question_preview	feedback	1	\N
329	0	1599810942	question_preview	generalfeedback	1	\N
330	0	1599810942	question_preview	rightanswer	1	\N
331	0	1599810942	question_preview	history	0	\N
332	0	1599810942	\N	repositorycacheexpire	120	\N
333	0	1599810942	\N	repositorygetfiletimeout	30	\N
334	0	1599810942	\N	repositorysyncfiletimeout	1	\N
335	0	1599810942	\N	repositorysyncimagetimeout	3	\N
336	0	1599810942	\N	repositoryallowexternallinks	1	\N
337	0	1599810942	\N	legacyfilesinnewcourses	0	\N
338	0	1599810942	\N	legacyfilesaddallowed	1	\N
339	0	1599810942	\N	searchengine	simpledb	\N
340	0	1599810942	\N	searchindexwhendisabled	0	\N
341	0	1599810942	\N	searchindextime	600	\N
342	0	1599810942	\N	searchallavailablecourses	0	\N
343	0	1599810942	\N	searchincludeallcourses	0	\N
344	0	1599810942	\N	searchenablecategories	0	\N
345	0	1599810942	\N	searchdefaultcategory	core-all	\N
346	0	1599810942	\N	searchhideallcategory	0	\N
347	0	1599810942	\N	enablewsdocumentation	0	\N
348	0	1599810942	\N	allowbeforeblock	0	\N
349	0	1599810942	\N	allowedip		\N
350	0	1599810942	\N	blockedip		\N
351	0	1599810942	\N	protectusernames	1	\N
352	0	1599810942	\N	forcelogin	1	\N
353	0	1599810942	\N	forceloginforprofiles	1	\N
354	0	1599810942	\N	forceloginforprofileimage	0	\N
355	0	1599810942	\N	opentowebcrawlers	0	\N
356	0	1599810942	\N	allowindexing	0	\N
357	0	1599810942	\N	maxbytes	0	\N
358	0	1599810942	\N	userquota	104857600	\N
359	0	1599810942	\N	allowobjectembed	0	\N
360	0	1599810942	\N	enabletrusttext	0	\N
361	0	1599810942	\N	maxeditingtime	1800	\N
362	0	1599810942	\N	extendedusernamechars	0	\N
363	0	1599810942	\N	keeptagnamecase	1	\N
364	0	1599810942	\N	profilesforenrolledusersonly	1	\N
365	0	1599810942	\N	cronclionly	1	\N
366	0	1599810942	\N	cronremotepassword		\N
367	0	1599810943	tool_task	enablerunnow	1	\N
368	0	1599810943	\N	lockoutthreshold	0	\N
369	0	1599810943	\N	lockoutwindow	1800	\N
370	0	1599810943	\N	lockoutduration	1800	\N
371	0	1599810943	\N	passwordpolicy	1	\N
372	0	1599810943	\N	minpasswordlength	8	\N
373	0	1599810943	\N	minpassworddigits	1	\N
374	0	1599810943	\N	minpasswordlower	1	\N
375	0	1599810943	\N	minpasswordupper	1	\N
376	0	1599810943	\N	minpasswordnonalphanum	1	\N
377	0	1599810943	\N	maxconsecutiveidentchars	0	\N
378	0	1599810943	\N	passwordreuselimit	0	\N
379	0	1599810943	\N	pwresettime	1800	\N
380	0	1599810943	\N	passwordchangelogout	0	\N
381	0	1599810943	\N	passwordchangetokendeletion	0	\N
382	0	1599810943	\N	tokenduration	7257600	\N
383	0	1599810943	\N	groupenrolmentkeypolicy	1	\N
384	0	1599810943	\N	disableuserimages	0	\N
385	0	1599810943	\N	emailchangeconfirmation	1	\N
386	0	1599810943	\N	rememberusername	2	\N
387	0	1599810943	\N	strictformsrequired	0	\N
388	0	1599810943	\N	cookiesecure	1	\N
389	0	1599810943	\N	cookiehttponly	0	\N
390	0	1599810943	\N	allowframembedding	0	\N
391	0	1599810943	\N	curlsecurityblockedhosts		\N
392	0	1599810943	\N	curlsecurityallowedport		\N
393	0	1599810943	\N	displayloginfailures	0	\N
394	0	1599810943	\N	notifyloginfailures		\N
395	0	1599810943	\N	notifyloginthreshold	10	\N
396	0	1599810943	\N	themelist		\N
397	0	1599810943	\N	themedesignermode	0	\N
398	0	1599810943	\N	allowuserthemes	0	\N
399	0	1599810943	\N	allowcoursethemes	0	\N
400	0	1599810943	\N	allowcategorythemes	0	\N
401	0	1599810943	\N	allowcohortthemes	0	\N
402	0	1599810943	\N	allowthemechangeonurl	0	\N
403	0	1599810943	\N	allowuserblockhiding	1	\N
404	0	1599810943	\N	custommenuitems		\N
405	0	1599810943	\N	customusermenuitems	grades,grades|/grade/report/mygrades.php|t/grades\nmessages,message|/message/index.php|t/message\npreferences,moodle|/user/preferences.php|t/preferences	\N
406	0	1599810943	\N	enabledevicedetection	1	\N
407	0	1599810944	\N	devicedetectregex	[]	\N
408	0	1599810944	theme_boost	preset	default.scss	\N
409	0	1599810944	theme_boost	presetfiles		\N
410	0	1599810944	theme_boost	backgroundimage		\N
411	0	1599810944	theme_boost	brandcolor		\N
412	0	1599810944	theme_boost	scsspre		\N
413	0	1599810944	theme_boost	scss		\N
414	0	1599810944	theme_classic	navbardark	0	\N
415	0	1599810944	theme_classic	preset	default.scss	\N
416	0	1599810944	theme_classic	presetfiles		\N
417	0	1599810944	theme_classic	backgroundimage		\N
418	0	1599810944	theme_classic	brandcolor		\N
419	0	1599810944	theme_classic	scsspre		\N
420	0	1599810944	theme_classic	scss		\N
421	0	1599810944	theme_iomad	preset	default.scss	\N
422	0	1599810944	theme_iomad	presetfiles		\N
423	0	1599810944	theme_iomad	backgroundimage		\N
424	0	1599810944	theme_iomad	brandcolor		\N
425	0	1599810944	theme_iomad	scsspre		\N
426	0	1599810944	theme_iomad	scss		\N
427	0	1599810944	theme_iomadboost	preset	default.scss	\N
428	0	1599810944	theme_iomadboost	presetfiles		\N
429	0	1599810944	theme_iomadboost	backgroundimage		\N
430	0	1599810944	theme_iomadboost	brandcolor		\N
431	0	1599810944	theme_iomadboost	scsspre		\N
432	0	1599810944	theme_iomadboost	scss		\N
433	0	1599810944	theme_iomadbootstrap	navbardark	0	\N
434	0	1599810944	theme_iomadbootstrap	preset	default.scss	\N
435	0	1599810944	theme_iomadbootstrap	presetfiles		\N
436	0	1599810944	theme_iomadbootstrap	backgroundimage		\N
437	0	1599810944	theme_iomadbootstrap	brandcolor		\N
438	0	1599810944	theme_iomadbootstrap	scsspre		\N
439	0	1599810944	theme_iomadbootstrap	scss		\N
440	0	1599810944	core_admin	logo		\N
441	0	1599810944	core_admin	logocompact		\N
442	0	1599810944	core_admin	coursecolor1	#81ecec	\N
443	0	1599810944	core_admin	coursecolor2	#74b9ff	\N
444	0	1599810944	core_admin	coursecolor3	#a29bfe	\N
445	0	1599810944	core_admin	coursecolor4	#dfe6e9	\N
446	0	1599810944	core_admin	coursecolor5	#00b894	\N
447	0	1599810944	core_admin	coursecolor6	#0984e3	\N
448	0	1599810944	core_admin	coursecolor7	#b2bec3	\N
449	0	1599810944	core_admin	coursecolor8	#fdcb6e	\N
450	0	1599810944	core_admin	coursecolor9	#fd79a8	\N
451	0	1599810944	core_admin	coursecolor10	#6c5ce7	\N
452	0	1599810944	\N	calendartype	gregorian	\N
453	0	1599810944	\N	calendar_adminseesall	0	\N
454	0	1599810944	\N	calendar_site_timeformat	0	\N
455	0	1599810944	\N	calendar_startwday	1	\N
456	0	1599810944	\N	calendar_weekend	65	\N
457	0	1599810944	\N	calendar_lookahead	21	\N
458	0	1599810944	\N	calendar_maxevents	10	\N
459	0	1599810944	\N	enablecalendarexport	1	\N
460	0	1599810945	\N	calendar_customexport	1	\N
461	0	1599810945	\N	calendar_exportlookahead	365	\N
462	0	1599810945	\N	calendar_exportlookback	5	\N
463	0	1599810945	\N	calendar_exportsalt	9NPWsRONjWTmjpbKHgFcYbAiNmD7VLS02hjdSmGgRDJEU9tG70A7bMsABxA2	\N
464	0	1599810945	\N	calendar_showicalsource	1	\N
465	0	1599810945	\N	useblogassociations	1	\N
466	0	1599810945	\N	bloglevel	4	\N
467	0	1599810945	\N	useexternalblogs	1	\N
468	0	1599810945	\N	externalblogcrontime	86400	\N
469	0	1599810945	\N	maxexternalblogsperuser	1	\N
470	0	1599810945	\N	blogusecomments	1	\N
471	0	1599810945	\N	blogshowcommentscount	1	\N
472	0	1599810945	\N	defaulthomepage	1	\N
473	0	1599810945	\N	allowguestmymoodle	1	\N
1643	2	1599811322	\N	frontpage	6	\N
474	0	1599810945	\N	navshowfullcoursenames	0	\N
475	0	1599810945	\N	navshowcategories	1	\N
476	0	1599810945	\N	navshowmycoursecategories	0	\N
477	0	1599810945	\N	navshowallcourses	0	\N
478	0	1599810945	\N	navsortmycoursessort	sortorder	\N
479	0	1599810945	\N	navsortmycourseshiddenlast	1	\N
480	0	1599810945	\N	navcourselimit	10	\N
481	0	1599810945	\N	usesitenameforsitepages	0	\N
482	0	1599810945	\N	linkadmincategories	1	\N
483	0	1599810945	\N	linkcoursesections	1	\N
484	0	1599810945	\N	navshowfrontpagemods	1	\N
485	0	1599810945	\N	navadduserpostslinks	1	\N
486	0	1599810945	\N	formatstringstriptags	1	\N
487	0	1599810945	\N	emoticons	[{"text":":-)","imagename":"s\\/smiley","imagecomponent":"core","altidentifier":"smiley","altcomponent":"core_pix"},{"text":":)","imagename":"s\\/smiley","imagecomponent":"core","altidentifier":"smiley","altcomponent":"core_pix"},{"text":":-D","imagename":"s\\/biggrin","imagecomponent":"core","altidentifier":"biggrin","altcomponent":"core_pix"},{"text":";-)","imagename":"s\\/wink","imagecomponent":"core","altidentifier":"wink","altcomponent":"core_pix"},{"text":":-\\/","imagename":"s\\/mixed","imagecomponent":"core","altidentifier":"mixed","altcomponent":"core_pix"},{"text":"V-.","imagename":"s\\/thoughtful","imagecomponent":"core","altidentifier":"thoughtful","altcomponent":"core_pix"},{"text":":-P","imagename":"s\\/tongueout","imagecomponent":"core","altidentifier":"tongueout","altcomponent":"core_pix"},{"text":":-p","imagename":"s\\/tongueout","imagecomponent":"core","altidentifier":"tongueout","altcomponent":"core_pix"},{"text":"B-)","imagename":"s\\/cool","imagecomponent":"core","altidentifier":"cool","altcomponent":"core_pix"},{"text":"^-)","imagename":"s\\/approve","imagecomponent":"core","altidentifier":"approve","altcomponent":"core_pix"},{"text":"8-)","imagename":"s\\/wideeyes","imagecomponent":"core","altidentifier":"wideeyes","altcomponent":"core_pix"},{"text":":o)","imagename":"s\\/clown","imagecomponent":"core","altidentifier":"clown","altcomponent":"core_pix"},{"text":":-(","imagename":"s\\/sad","imagecomponent":"core","altidentifier":"sad","altcomponent":"core_pix"},{"text":":(","imagename":"s\\/sad","imagecomponent":"core","altidentifier":"sad","altcomponent":"core_pix"},{"text":"8-.","imagename":"s\\/shy","imagecomponent":"core","altidentifier":"shy","altcomponent":"core_pix"},{"text":":-I","imagename":"s\\/blush","imagecomponent":"core","altidentifier":"blush","altcomponent":"core_pix"},{"text":":-X","imagename":"s\\/kiss","imagecomponent":"core","altidentifier":"kiss","altcomponent":"core_pix"},{"text":"8-o","imagename":"s\\/surprise","imagecomponent":"core","altidentifier":"surprise","altcomponent":"core_pix"},{"text":"P-|","imagename":"s\\/blackeye","imagecomponent":"core","altidentifier":"blackeye","altcomponent":"core_pix"},{"text":"8-[","imagename":"s\\/angry","imagecomponent":"core","altidentifier":"angry","altcomponent":"core_pix"},{"text":"(grr)","imagename":"s\\/angry","imagecomponent":"core","altidentifier":"angry","altcomponent":"core_pix"},{"text":"xx-P","imagename":"s\\/dead","imagecomponent":"core","altidentifier":"dead","altcomponent":"core_pix"},{"text":"|-.","imagename":"s\\/sleepy","imagecomponent":"core","altidentifier":"sleepy","altcomponent":"core_pix"},{"text":"}-]","imagename":"s\\/evil","imagecomponent":"core","altidentifier":"evil","altcomponent":"core_pix"},{"text":"(h)","imagename":"s\\/heart","imagecomponent":"core","altidentifier":"heart","altcomponent":"core_pix"},{"text":"(heart)","imagename":"s\\/heart","imagecomponent":"core","altidentifier":"heart","altcomponent":"core_pix"},{"text":"(y)","imagename":"s\\/yes","imagecomponent":"core","altidentifier":"yes","altcomponent":"core"},{"text":"(n)","imagename":"s\\/no","imagecomponent":"core","altidentifier":"no","altcomponent":"core"},{"text":"(martin)","imagename":"s\\/martin","imagecomponent":"core","altidentifier":"martin","altcomponent":"core_pix"},{"text":"( )","imagename":"s\\/egg","imagecomponent":"core","altidentifier":"egg","altcomponent":"core_pix"}]	\N
488	0	1599810945	\N	docroot	https://docs.moodle.org	\N
489	0	1599810945	\N	doclang		\N
490	0	1599810945	\N	doctonewwindow	0	\N
491	0	1599810945	\N	coursecontactduplicates	0	\N
492	0	1599810945	\N	courselistshortnames	0	\N
493	0	1599810945	\N	coursesperpage	20	\N
494	0	1599810945	\N	courseswithsummarieslimit	10	\N
495	0	1599810945	\N	courseoverviewfileslimit	1	\N
496	0	1599810945	\N	courseoverviewfilesext	.jpg,.gif,.png	\N
497	0	1599810945	\N	coursegraceperiodbefore	0	\N
498	0	1599810945	\N	coursegraceperiodafter	0	\N
499	0	1599810945	\N	useexternalyui	0	\N
500	0	1599810945	\N	yuicomboloading	1	\N
501	0	1599810945	\N	cachejs	1	\N
502	0	1599810945	\N	modchooserdefault	1	\N
503	0	1599810945	\N	additionalhtmlhead		\N
504	0	1599810945	\N	additionalhtmltopofbody		\N
505	0	1599810945	\N	additionalhtmlfooter		\N
506	0	1599810945	\N	cachetemplates	1	\N
507	0	1599810945	\N	pathtophp		\N
508	0	1599810946	\N	pathtodu		\N
509	0	1599810946	\N	aspellpath		\N
510	0	1599810946	\N	pathtodot		\N
511	0	1599810946	\N	pathtogs	/usr/bin/gs	\N
512	0	1599810946	\N	pathtopython		\N
513	0	1599810946	\N	supportname	Admin User	\N
514	0	1599810946	\N	supportemail		\N
515	0	1599810946	\N	supportpage		\N
516	0	1599810946	\N	dbsessions	0	\N
517	0	1599810946	\N	sessioncookie		\N
518	0	1599810946	\N	sessioncookiepath		\N
519	0	1599810946	\N	sessioncookiedomain		\N
520	0	1599810946	\N	statsfirstrun	none	\N
521	0	1599810946	\N	statsmaxruntime	0	\N
522	0	1599810946	\N	statsruntimedays	31	\N
523	0	1599810946	\N	statsuserthreshold	0	\N
524	0	1599810946	\N	slasharguments	1	\N
525	0	1599810946	\N	getremoteaddrconf	3	\N
526	0	1599810946	\N	reverseproxyignore		\N
527	0	1599810946	\N	proxyhost		\N
528	0	1599810946	\N	proxyport	0	\N
529	0	1599810946	\N	proxytype	HTTP	\N
530	0	1599810946	\N	proxyuser		\N
531	0	1599810946	\N	proxypassword		\N
532	0	1599810946	\N	proxybypass	localhost, 127.0.0.1	\N
533	0	1599810946	\N	maintenance_enabled	0	\N
534	0	1599810946	\N	maintenance_message		\N
535	0	1599810946	\N	deleteunconfirmed	168	\N
536	0	1599810946	\N	deleteincompleteusers	0	\N
537	0	1599810946	\N	disablegradehistory	0	\N
538	0	1599810946	\N	gradehistorylifetime	0	\N
539	0	1599810946	\N	tempdatafoldercleanup	168	\N
540	0	1599810946	\N	filescleanupperiod	86400	\N
541	0	1599810946	\N	extramemorylimit	512M	\N
542	0	1599810946	\N	maxtimelimit	0	\N
543	0	1599810946	\N	curlcache	120	\N
544	0	1599810946	\N	curltimeoutkbitrate	56	\N
545	0	1599810946	\N	task_scheduled_concurrency_limit	3	\N
546	0	1599810946	\N	task_scheduled_max_runtime	1800	\N
547	0	1599810946	\N	task_adhoc_concurrency_limit	3	\N
548	0	1599810946	\N	task_adhoc_max_runtime	1800	\N
549	0	1599810946	\N	task_logmode	1	\N
550	0	1599810946	\N	task_logtostdout	1	\N
551	0	1599810947	\N	task_logretention	2419200	\N
552	0	1599810947	\N	task_logretainruns	20	\N
553	0	1599810947	\N	smtphosts		\N
554	0	1599810947	\N	smtpsecure		\N
555	0	1599810947	\N	smtpauthtype	LOGIN	\N
556	0	1599810947	\N	smtpuser		\N
557	0	1599810947	\N	smtppass		\N
558	0	1599810947	\N	smtpmaxbulk	1	\N
559	0	1599810947	\N	noreplyaddress	noreply@arrupe.ac.zw	\N
560	0	1599810947	\N	allowedemaildomains		\N
561	0	1599810947	\N	sitemailcharset	0	\N
562	0	1599810947	\N	allowusermailcharset	0	\N
563	0	1599810947	\N	allowattachments	1	\N
564	0	1599810947	\N	mailnewline	LF	\N
565	0	1599810947	\N	emailfromvia	1	\N
566	0	1599810947	\N	emailsubjectprefix		\N
567	0	1599810947	\N	updateautocheck	1	\N
568	0	1599810947	\N	updateminmaturity	200	\N
569	0	1599810947	\N	updatenotifybuilds	0	\N
570	0	1599810947	\N	enablesafebrowserintegration	0	\N
571	0	1599810947	\N	dndallowtextandlinks	0	\N
572	0	1599810947	\N	pathtosassc		\N
573	0	1599810947	\N	contextlocking	0	\N
574	0	1599810947	\N	contextlockappliestoadmin	1	\N
575	0	1599810947	\N	forceclean	0	\N
576	0	1599810947	\N	enablecourserelativedates	0	\N
577	0	1599810947	\N	debug	0	\N
578	0	1599810947	\N	debugdisplay	0	\N
579	0	1599810947	\N	perfdebug	7	\N
580	0	1599810947	\N	debugstringids	0	\N
581	0	1599810947	\N	debugvalidators	0	\N
582	0	1599810947	\N	debugpageinfo	0	\N
583	0	1599810947	\N	profilingenabled	0	\N
584	0	1599810947	\N	profilingincluded		\N
585	0	1599810947	\N	profilingexcluded		\N
586	0	1599810947	\N	profilingautofrec	0	\N
587	0	1599810947	\N	profilingallowme	0	\N
588	0	1599810947	\N	profilingallowall	0	\N
589	0	1599810947	\N	profilingslow	0	\N
590	0	1599810947	\N	profilinglifetime	1440	\N
591	0	1599810947	\N	profilingimportprefix	(I)	\N
592	0	1599810953	\N	calendar_exportsalt	h5KSQtgUSDNcR75RzBpp2Q2ayC1KAEfKpakDyWI6Pnf1w92eDl6VpxnB43M1	9NPWsRONjWTmjpbKHgFcYbAiNmD7VLS02hjdSmGgRDJEU9tG70A7bMsABxA2
593	0	1599811007	activitynames	filter_active	1	
594	0	1599811007	displayh5p	filter_active	1	
595	0	1599811008	mathjaxloader	filter_active	1	
596	0	1599811008	mediaplugin	filter_active	1	
597	2	1599811311	\N	notloggedinroleid	6	\N
598	2	1599811311	\N	guestroleid	6	\N
599	2	1599811311	\N	defaultuserroleid	7	\N
600	2	1599811311	\N	creatornewroleid	3	\N
601	2	1599811311	\N	restorernewroleid	3	\N
602	2	1599811311	tool_dataprivacy	contactdataprotectionofficer	0	\N
603	2	1599811311	tool_dataprivacy	automaticdeletionrequests	1	\N
604	2	1599811311	tool_dataprivacy	privacyrequestexpiry	604800	\N
605	2	1599811311	tool_dataprivacy	requireallenddatesforuserdeletion	1	\N
606	2	1599811311	tool_dataprivacy	showdataretentionsummary	1	\N
607	2	1599811311	tool_log	exportlog	1	\N
608	2	1599811311	\N	sitepolicyhandler		\N
609	2	1599811311	\N	gradebookroles	5	\N
610	2	1599811311	analytics	logstore	logstore_standard	\N
611	2	1599811311	\N	jabberhost		\N
612	2	1599811311	\N	jabberserver		\N
613	2	1599811311	\N	jabberusername		\N
614	2	1599811311	\N	jabberpassword		\N
615	2	1599811311	\N	jabberport	5222	\N
616	2	1599811311	\N	airnotifierurl	https://messages.moodle.net	\N
617	2	1599811311	\N	airnotifierport	443	\N
618	2	1599811311	\N	airnotifiermobileappname	com.moodle.moodlemobile	\N
619	2	1599811311	\N	airnotifierappname	commoodlemoodlemobile	\N
620	2	1599811311	\N	airnotifieraccesskey		\N
621	2	1599811311	assign	feedback_plugin_for_gradebook	assignfeedback_comments	\N
622	2	1599811311	assign	showrecentsubmissions	0	\N
623	2	1599811311	assign	submissionreceipts	1	\N
624	2	1599811311	assign	submissionstatement	This submission is my own work, except where I have acknowledged the use of the works of other people.	\N
625	2	1599811311	assign	submissionstatementteamsubmission	This submission is the work of my group, except where we have acknowledged the use of the works of other people.	\N
626	2	1599811311	assign	submissionstatementteamsubmissionallsubmit	This submission is my own work as a group member, except where I have acknowledged the use of the works of other people.	\N
627	2	1599811311	assign	maxperpage	-1	\N
628	2	1599811311	assign	alwaysshowdescription	1	\N
629	2	1599811311	assign	alwaysshowdescription_adv		\N
630	2	1599811311	assign	alwaysshowdescription_locked		\N
631	2	1599811311	assign	allowsubmissionsfromdate	0	\N
632	2	1599811312	assign	allowsubmissionsfromdate_enabled	1	\N
633	2	1599811312	assign	allowsubmissionsfromdate_adv		\N
634	2	1599811312	assign	duedate	604800	\N
635	2	1599811312	assign	duedate_enabled	1	\N
636	2	1599811312	assign	duedate_adv		\N
637	2	1599811312	assign	cutoffdate	1209600	\N
638	2	1599811312	assign	cutoffdate_enabled		\N
639	2	1599811312	assign	cutoffdate_adv		\N
640	2	1599811312	assign	gradingduedate	1209600	\N
641	2	1599811312	assign	gradingduedate_enabled	1	\N
642	2	1599811312	assign	gradingduedate_adv		\N
643	2	1599811312	assign	submissiondrafts	0	\N
644	2	1599811312	assign	submissiondrafts_adv		\N
645	2	1599811312	assign	submissiondrafts_locked		\N
646	2	1599811312	assign	requiresubmissionstatement	0	\N
647	2	1599811312	assign	requiresubmissionstatement_adv		\N
648	2	1599811312	assign	requiresubmissionstatement_locked		\N
649	2	1599811312	assign	attemptreopenmethod	none	\N
650	2	1599811312	assign	attemptreopenmethod_adv		\N
651	2	1599811312	assign	attemptreopenmethod_locked		\N
652	2	1599811312	assign	maxattempts	-1	\N
653	2	1599811312	assign	maxattempts_adv		\N
654	2	1599811312	assign	maxattempts_locked		\N
655	2	1599811312	assign	teamsubmission	0	\N
656	2	1599811312	assign	teamsubmission_adv		\N
657	2	1599811312	assign	teamsubmission_locked		\N
658	2	1599811312	assign	preventsubmissionnotingroup	0	\N
659	2	1599811312	assign	preventsubmissionnotingroup_adv		\N
660	2	1599811312	assign	preventsubmissionnotingroup_locked		\N
661	2	1599811312	assign	requireallteammemberssubmit	0	\N
662	2	1599811312	assign	requireallteammemberssubmit_adv		\N
663	2	1599811312	assign	requireallteammemberssubmit_locked		\N
664	2	1599811312	assign	teamsubmissiongroupingid		\N
665	2	1599811312	assign	teamsubmissiongroupingid_adv		\N
666	2	1599811312	assign	sendnotifications	0	\N
667	2	1599811312	assign	sendnotifications_adv		\N
668	2	1599811312	assign	sendnotifications_locked		\N
669	2	1599811312	assign	sendlatenotifications	0	\N
670	2	1599811312	assign	sendlatenotifications_adv		\N
671	2	1599811312	assign	sendlatenotifications_locked		\N
672	2	1599811312	assign	sendstudentnotifications	1	\N
673	2	1599811312	assign	sendstudentnotifications_adv		\N
674	2	1599811312	assign	sendstudentnotifications_locked		\N
675	2	1599811312	assign	blindmarking	0	\N
676	2	1599811312	assign	blindmarking_adv		\N
677	2	1599811312	assign	blindmarking_locked		\N
678	2	1599811312	assign	hidegrader	0	\N
679	2	1599811312	assign	hidegrader_adv		\N
680	2	1599811312	assign	hidegrader_locked		\N
681	2	1599811312	assign	markingworkflow	0	\N
682	2	1599811312	assign	markingworkflow_adv		\N
683	2	1599811312	assign	markingworkflow_locked		\N
684	2	1599811312	assign	markingallocation	0	\N
685	2	1599811312	assign	markingallocation_adv		\N
686	2	1599811312	assign	markingallocation_locked		\N
687	2	1599811312	assignsubmission_file	default	1	\N
688	2	1599811312	assignsubmission_file	maxfiles	20	\N
689	2	1599811312	assignsubmission_file	filetypes		\N
690	2	1599811312	assignsubmission_file	maxbytes	0	\N
691	2	1599811312	assignsubmission_onlinetext	default	0	\N
692	2	1599811312	assignfeedback_comments	default	1	\N
693	2	1599811312	assignfeedback_comments	inline	0	\N
694	2	1599811312	assignfeedback_comments	inline_adv		\N
695	2	1599811312	assignfeedback_comments	inline_locked		\N
696	2	1599811312	assignfeedback_editpdf	default	1	\N
697	2	1599811312	assignfeedback_editpdf	stamps		\N
698	2	1599811312	assignfeedback_file	default	0	\N
699	2	1599811312	assignfeedback_offline	default	0	\N
700	2	1599811312	book	numberingoptions	0,1,2,3	\N
701	2	1599811312	book	navoptions	0,1,2	\N
702	2	1599811312	book	numbering	1	\N
703	2	1599811312	book	navstyle	1	\N
704	2	1599811312	\N	chat_method	ajax	\N
705	2	1599811312	\N	chat_refresh_userlist	10	\N
706	2	1599811312	\N	chat_old_ping	35	\N
707	2	1599811312	\N	chat_refresh_room	5	\N
708	2	1599811312	\N	chat_normal_updatemode	jsupdate	\N
709	2	1599811312	\N	chat_serverhost	arrupe.ac.zw	\N
710	2	1599811312	\N	chat_serverip	127.0.0.1	\N
711	2	1599811312	\N	chat_serverport	9111	\N
712	2	1599811312	\N	chat_servermax	100	\N
713	2	1599811312	\N	data_enablerssfeeds	0	\N
714	2	1599811312	\N	feedback_allowfullanonymous	0	\N
715	2	1599811312	resource	framesize	130	\N
716	2	1599811312	resource	displayoptions	0,1,4,5,6	\N
717	2	1599811312	resource	printintro	1	\N
718	2	1599811312	resource	display	0	\N
719	2	1599811312	resource	showsize	0	\N
720	2	1599811312	resource	showtype	0	\N
721	2	1599811312	resource	showdate	0	\N
722	2	1599811312	resource	popupwidth	620	\N
723	2	1599811312	resource	popupheight	450	\N
724	2	1599811312	resource	filterfiles	0	\N
725	2	1599811312	folder	showexpanded	1	\N
726	2	1599811312	folder	maxsizetodownload	0	\N
727	2	1599811312	\N	forum_displaymode	3	\N
728	2	1599811312	\N	forum_shortpost	300	\N
729	2	1599811312	\N	forum_longpost	600	\N
730	2	1599811312	\N	forum_manydiscussions	100	\N
731	2	1599811312	\N	forum_maxbytes	512000	\N
732	2	1599811312	\N	forum_maxattachments	9	\N
733	2	1599811312	\N	forum_subscription	0	\N
734	2	1599811312	\N	forum_trackingtype	1	\N
735	2	1599811312	\N	forum_trackreadposts	1	\N
736	2	1599811312	\N	forum_allowforcedreadtracking	0	\N
737	2	1599811312	\N	forum_oldpostdays	14	\N
738	2	1599811312	\N	forum_usermarksread	0	\N
739	2	1599811312	\N	forum_cleanreadtime	2	\N
740	2	1599811312	\N	digestmailtime	17	\N
741	2	1599811312	\N	forum_enablerssfeeds	0	\N
742	2	1599811312	\N	forum_enabletimedposts	1	\N
743	2	1599811312	\N	glossary_entbypage	10	\N
744	2	1599811312	\N	glossary_dupentries	0	\N
745	2	1599811312	\N	glossary_allowcomments	0	\N
746	2	1599811312	\N	glossary_linkbydefault	1	\N
747	2	1599811312	\N	glossary_defaultapproval	1	\N
748	2	1599811312	\N	glossary_enablerssfeeds	0	\N
749	2	1599811312	\N	glossary_linkentries	0	\N
750	2	1599811313	\N	glossary_casesensitive	0	\N
751	2	1599811313	\N	glossary_fullmatch	0	\N
752	2	1599811313	imscp	keepold	1	\N
753	2	1599811313	imscp	keepold_adv		\N
754	2	1599811313	iomadcertificate	uploadimage		\N
755	2	1599811313	iomadcertificate	fontsans	freesans	\N
756	2	1599811313	iomadcertificate	fontserif	freeserif	\N
757	2	1599811313	label	dndmedia	1	\N
758	2	1599811314	label	dndresizewidth	400	\N
759	2	1599811314	label	dndresizeheight	400	\N
760	2	1599811314	mod_lesson	mediafile		\N
761	2	1599811314	mod_lesson	mediafile_adv	1	\N
762	2	1599811314	mod_lesson	mediawidth	640	\N
763	2	1599811314	mod_lesson	mediaheight	480	\N
764	2	1599811314	mod_lesson	mediaclose	0	\N
765	2	1599811314	mod_lesson	progressbar	0	\N
766	2	1599811314	mod_lesson	progressbar_adv		\N
767	2	1599811314	mod_lesson	ongoing	0	\N
768	2	1599811314	mod_lesson	ongoing_adv	1	\N
769	2	1599811314	mod_lesson	displayleftmenu	0	\N
770	2	1599811314	mod_lesson	displayleftmenu_adv		\N
771	2	1599811314	mod_lesson	displayleftif	0	\N
772	2	1599811314	mod_lesson	displayleftif_adv	1	\N
773	2	1599811314	mod_lesson	slideshow	0	\N
774	2	1599811314	mod_lesson	slideshow_adv	1	\N
775	2	1599811314	mod_lesson	slideshowwidth	640	\N
776	2	1599811314	mod_lesson	slideshowheight	480	\N
777	2	1599811314	mod_lesson	slideshowbgcolor	#FFFFFF	\N
778	2	1599811314	mod_lesson	maxanswers	5	\N
779	2	1599811314	mod_lesson	maxanswers_adv	1	\N
780	2	1599811314	mod_lesson	defaultfeedback	0	\N
781	2	1599811314	mod_lesson	defaultfeedback_adv	1	\N
782	2	1599811314	mod_lesson	activitylink		\N
783	2	1599811314	mod_lesson	activitylink_adv	1	\N
784	2	1599811314	mod_lesson	timelimit	0	\N
785	2	1599811314	mod_lesson	timelimit_adv		\N
786	2	1599811314	mod_lesson	password	0	\N
787	2	1599811314	mod_lesson	password_adv	1	\N
788	2	1599811314	mod_lesson	modattempts	0	\N
789	2	1599811314	mod_lesson	modattempts_adv		\N
790	2	1599811314	mod_lesson	displayreview	0	\N
791	2	1599811314	mod_lesson	displayreview_adv		\N
792	2	1599811314	mod_lesson	maximumnumberofattempts	1	\N
793	2	1599811314	mod_lesson	maximumnumberofattempts_adv		\N
794	2	1599811314	mod_lesson	defaultnextpage	0	\N
795	2	1599811314	mod_lesson	defaultnextpage_adv	1	\N
796	2	1599811314	mod_lesson	numberofpagestoshow	1	\N
797	2	1599811314	mod_lesson	numberofpagestoshow_adv	1	\N
798	2	1599811314	mod_lesson	practice	0	\N
799	2	1599811314	mod_lesson	practice_adv		\N
800	2	1599811314	mod_lesson	customscoring	1	\N
801	2	1599811314	mod_lesson	customscoring_adv	1	\N
802	2	1599811314	mod_lesson	retakesallowed	0	\N
803	2	1599811314	mod_lesson	retakesallowed_adv		\N
804	2	1599811314	mod_lesson	handlingofretakes	0	\N
805	2	1599811314	mod_lesson	handlingofretakes_adv	1	\N
806	2	1599811314	mod_lesson	minimumnumberofquestions	0	\N
807	2	1599811314	mod_lesson	minimumnumberofquestions_adv	1	\N
808	2	1599811314	page	displayoptions	5	\N
809	2	1599811314	page	printheading	1	\N
810	2	1599811314	page	printintro	0	\N
811	2	1599811314	page	printlastmodified	1	\N
812	2	1599811314	page	display	5	\N
813	2	1599811314	page	popupwidth	620	\N
814	2	1599811314	page	popupheight	450	\N
815	2	1599811314	quiz	timelimit	0	\N
816	2	1599811314	quiz	timelimit_adv		\N
817	2	1599811314	quiz	overduehandling	autosubmit	\N
818	2	1599811314	quiz	overduehandling_adv		\N
819	2	1599811314	quiz	graceperiod	86400	\N
820	2	1599811314	quiz	graceperiod_adv		\N
821	2	1599811314	quiz	graceperiodmin	60	\N
822	2	1599811314	quiz	attempts	0	\N
823	2	1599811314	quiz	attempts_adv		\N
824	2	1599811314	quiz	grademethod	1	\N
825	2	1599811314	quiz	grademethod_adv		\N
826	2	1599811314	quiz	maximumgrade	10	\N
827	2	1599811314	quiz	questionsperpage	1	\N
828	2	1599811314	quiz	questionsperpage_adv		\N
829	2	1599811314	quiz	navmethod	free	\N
830	2	1599811314	quiz	navmethod_adv	1	\N
831	2	1599811314	quiz	shuffleanswers	1	\N
832	2	1599811314	quiz	shuffleanswers_adv		\N
833	2	1599811314	quiz	preferredbehaviour	deferredfeedback	\N
834	2	1599811314	quiz	canredoquestions	0	\N
835	2	1599811314	quiz	canredoquestions_adv	1	\N
836	2	1599811314	quiz	attemptonlast	0	\N
837	2	1599811314	quiz	attemptonlast_adv	1	\N
838	2	1599811314	quiz	reviewattempt	69904	\N
839	2	1599811314	quiz	reviewcorrectness	69904	\N
840	2	1599811314	quiz	reviewmarks	69904	\N
841	2	1599811314	quiz	reviewspecificfeedback	69904	\N
842	2	1599811314	quiz	reviewgeneralfeedback	69904	\N
843	2	1599811314	quiz	reviewrightanswer	69904	\N
844	2	1599811314	quiz	reviewoverallfeedback	4368	\N
845	2	1599811314	quiz	showuserpicture	0	\N
846	2	1599811315	quiz	showuserpicture_adv		\N
847	2	1599811315	quiz	decimalpoints	2	\N
848	2	1599811315	quiz	decimalpoints_adv		\N
849	2	1599811315	quiz	questiondecimalpoints	-1	\N
850	2	1599811315	quiz	questiondecimalpoints_adv	1	\N
851	2	1599811315	quiz	showblocks	0	\N
852	2	1599811315	quiz	showblocks_adv	1	\N
853	2	1599811315	quiz	password		\N
854	2	1599811315	quiz	password_adv		\N
855	2	1599811315	quiz	subnet		\N
856	2	1599811315	quiz	subnet_adv	1	\N
857	2	1599811315	quiz	delay1	0	\N
858	2	1599811315	quiz	delay1_adv	1	\N
859	2	1599811315	quiz	delay2	0	\N
860	2	1599811315	quiz	delay2_adv	1	\N
861	2	1599811315	quiz	browsersecurity	-	\N
862	2	1599811315	quiz	browsersecurity_adv	1	\N
863	2	1599811315	quiz	initialnumfeedbacks	2	\N
864	2	1599811315	quiz	autosaveperiod	60	\N
865	2	1599811315	scorm	displaycoursestructure	0	\N
866	2	1599811315	scorm	displaycoursestructure_adv		\N
867	2	1599811315	scorm	popup	0	\N
868	2	1599811315	scorm	popup_adv		\N
869	2	1599811315	scorm	displayactivityname	1	\N
870	2	1599811315	scorm	framewidth	100	\N
871	2	1599811315	scorm	framewidth_adv	1	\N
872	2	1599811315	scorm	frameheight	500	\N
873	2	1599811315	scorm	frameheight_adv	1	\N
874	2	1599811315	scorm	winoptgrp_adv	1	\N
875	2	1599811315	scorm	scrollbars	0	\N
876	2	1599811315	scorm	directories	0	\N
877	2	1599811315	scorm	location	0	\N
878	2	1599811315	scorm	menubar	0	\N
879	2	1599811315	scorm	toolbar	0	\N
880	2	1599811315	scorm	status	0	\N
881	2	1599811315	scorm	skipview	0	\N
882	2	1599811315	scorm	skipview_adv	1	\N
883	2	1599811315	scorm	hidebrowse	0	\N
884	2	1599811315	scorm	hidebrowse_adv	1	\N
885	2	1599811315	scorm	hidetoc	0	\N
886	2	1599811315	scorm	hidetoc_adv	1	\N
887	2	1599811315	scorm	nav	1	\N
888	2	1599811315	scorm	nav_adv	1	\N
889	2	1599811315	scorm	navpositionleft	-100	\N
890	2	1599811315	scorm	navpositionleft_adv	1	\N
891	2	1599811315	scorm	navpositiontop	-100	\N
892	2	1599811315	scorm	navpositiontop_adv	1	\N
893	2	1599811315	scorm	collapsetocwinsize	767	\N
894	2	1599811315	scorm	collapsetocwinsize_adv	1	\N
895	2	1599811315	scorm	displayattemptstatus	1	\N
896	2	1599811315	scorm	displayattemptstatus_adv		\N
897	2	1599811315	scorm	grademethod	1	\N
898	2	1599811315	scorm	maxgrade	100	\N
899	2	1599811315	scorm	maxattempt	0	\N
900	2	1599811315	scorm	whatgrade	0	\N
901	2	1599811315	scorm	forcecompleted	0	\N
902	2	1599811315	scorm	forcenewattempt	0	\N
903	2	1599811315	scorm	autocommit	0	\N
904	2	1599811315	scorm	masteryoverride	1	\N
905	2	1599811315	scorm	lastattemptlock	0	\N
906	2	1599811315	scorm	auto	0	\N
907	2	1599811315	scorm	updatefreq	0	\N
908	2	1599811315	scorm	scormstandard	0	\N
909	2	1599811315	scorm	allowtypeexternal	0	\N
910	2	1599811315	scorm	allowtypelocalsync	0	\N
911	2	1599811315	scorm	allowtypeexternalaicc	0	\N
912	2	1599811315	scorm	allowaicchacp	0	\N
913	2	1599811315	scorm	aicchacptimeout	30	\N
914	2	1599811315	scorm	aicchacpkeepsessiondata	1	\N
915	2	1599811315	scorm	aiccuserid	1	\N
916	2	1599811315	scorm	forcejavascript	1	\N
917	2	1599811315	scorm	allowapidebug	0	\N
918	2	1599811315	scorm	apidebugmask	.*	\N
919	2	1599811315	scorm	protectpackagedownloads	0	\N
920	2	1599811315	url	framesize	130	\N
921	2	1599811315	url	secretphrase		\N
922	2	1599811315	url	rolesinparams	0	\N
923	2	1599811315	url	displayoptions	0,1,5,6	\N
924	2	1599811315	url	printintro	1	\N
925	2	1599811315	url	display	0	\N
926	2	1599811315	url	popupwidth	620	\N
927	2	1599811315	url	popupheight	450	\N
928	2	1599811315	workshop	grade	80	\N
929	2	1599811315	workshop	gradinggrade	20	\N
930	2	1599811315	workshop	gradedecimals	0	\N
931	2	1599811315	workshop	maxbytes	0	\N
932	2	1599811315	workshop	strategy	accumulative	\N
933	2	1599811315	workshop	examplesmode	0	\N
934	2	1599811315	workshopallocation_random	numofreviews	5	\N
935	2	1599811315	workshopform_numerrors	grade0	No	\N
936	2	1599811315	workshopform_numerrors	grade1	Yes	\N
937	2	1599811315	workshopeval_best	comparison	5	\N
938	2	1599811315	tool_iomadmerge	suspenduser	1	\N
939	2	1599811315	tool_iomadmerge	transactions_only	1	\N
940	2	1599811315	tool_iomadmerge	excluded_exceptions	none	\N
941	2	1599811315	tool_iomadmerge	quizattemptsaction	remain	\N
942	2	1599811315	tool_iomadmerge	uniquekeynewidtomaintain	1	\N
943	2	1599811315	tool_recyclebin	coursebinenable	1	\N
944	2	1599811315	tool_recyclebin	coursebinexpiry	604800	\N
945	2	1599811315	tool_recyclebin	categorybinenable	1	\N
946	2	1599811315	tool_recyclebin	categorybinexpiry	604800	\N
947	2	1599811315	tool_recyclebin	autohide	1	\N
948	2	1599811315	antivirus_clamav	runningmethod	commandline	\N
949	2	1599811315	antivirus_clamav	pathtoclam		\N
950	2	1599811315	antivirus_clamav	pathtounixsocket		\N
951	2	1599811315	antivirus_clamav	clamfailureonupload	donothing	\N
952	2	1599811315	auth_cas	field_map_firstname		\N
953	2	1599811315	auth_cas	field_updatelocal_firstname	oncreate	\N
954	2	1599811315	auth_cas	field_updateremote_firstname	0	\N
955	2	1599811315	auth_cas	field_lock_firstname	unlocked	\N
956	2	1599811315	auth_cas	field_map_lastname		\N
957	2	1599811315	auth_cas	field_updatelocal_lastname	oncreate	\N
958	2	1599811315	auth_cas	field_updateremote_lastname	0	\N
959	2	1599811315	auth_cas	field_lock_lastname	unlocked	\N
960	2	1599811315	auth_cas	field_map_email		\N
961	2	1599811315	auth_cas	field_updatelocal_email	oncreate	\N
962	2	1599811315	auth_cas	field_updateremote_email	0	\N
963	2	1599811315	auth_cas	field_lock_email	unlocked	\N
964	2	1599811315	auth_cas	field_map_city		\N
965	2	1599811315	auth_cas	field_updatelocal_city	oncreate	\N
966	2	1599811315	auth_cas	field_updateremote_city	0	\N
967	2	1599811315	auth_cas	field_lock_city	unlocked	\N
968	2	1599811315	auth_cas	field_map_country		\N
969	2	1599811315	auth_cas	field_updatelocal_country	oncreate	\N
970	2	1599811315	auth_cas	field_updateremote_country	0	\N
971	2	1599811315	auth_cas	field_lock_country	unlocked	\N
972	2	1599811315	auth_cas	field_map_lang		\N
973	2	1599811316	auth_cas	field_updatelocal_lang	oncreate	\N
974	2	1599811316	auth_cas	field_updateremote_lang	0	\N
975	2	1599811316	auth_cas	field_lock_lang	unlocked	\N
976	2	1599811316	auth_cas	field_map_description		\N
977	2	1599811316	auth_cas	field_updatelocal_description	oncreate	\N
978	2	1599811316	auth_cas	field_updateremote_description	0	\N
979	2	1599811316	auth_cas	field_lock_description	unlocked	\N
980	2	1599811316	auth_cas	field_map_url		\N
981	2	1599811316	auth_cas	field_updatelocal_url	oncreate	\N
982	2	1599811316	auth_cas	field_updateremote_url	0	\N
983	2	1599811316	auth_cas	field_lock_url	unlocked	\N
984	2	1599811316	auth_cas	field_map_idnumber		\N
985	2	1599811316	auth_cas	field_updatelocal_idnumber	oncreate	\N
986	2	1599811316	auth_cas	field_updateremote_idnumber	0	\N
987	2	1599811316	auth_cas	field_lock_idnumber	unlocked	\N
988	2	1599811316	auth_cas	field_map_institution		\N
989	2	1599811316	auth_cas	field_updatelocal_institution	oncreate	\N
990	2	1599811316	auth_cas	field_updateremote_institution	0	\N
991	2	1599811316	auth_cas	field_lock_institution	unlocked	\N
992	2	1599811316	auth_cas	field_map_department		\N
993	2	1599811316	auth_cas	field_updatelocal_department	oncreate	\N
994	2	1599811316	auth_cas	field_updateremote_department	0	\N
995	2	1599811316	auth_cas	field_lock_department	unlocked	\N
996	2	1599811316	auth_cas	field_map_phone1		\N
997	2	1599811316	auth_cas	field_updatelocal_phone1	oncreate	\N
998	2	1599811316	auth_cas	field_updateremote_phone1	0	\N
999	2	1599811316	auth_cas	field_lock_phone1	unlocked	\N
1000	2	1599811316	auth_cas	field_map_phone2		\N
1001	2	1599811316	auth_cas	field_updatelocal_phone2	oncreate	\N
1002	2	1599811316	auth_cas	field_updateremote_phone2	0	\N
1003	2	1599811316	auth_cas	field_lock_phone2	unlocked	\N
1004	2	1599811316	auth_cas	field_map_address		\N
1005	2	1599811316	auth_cas	field_updatelocal_address	oncreate	\N
1006	2	1599811316	auth_cas	field_updateremote_address	0	\N
1007	2	1599811316	auth_cas	field_lock_address	unlocked	\N
1008	2	1599811316	auth_cas	field_map_firstnamephonetic		\N
1009	2	1599811316	auth_cas	field_updatelocal_firstnamephonetic	oncreate	\N
1010	2	1599811316	auth_cas	field_updateremote_firstnamephonetic	0	\N
1011	2	1599811316	auth_cas	field_lock_firstnamephonetic	unlocked	\N
1012	2	1599811316	auth_cas	field_map_lastnamephonetic		\N
1013	2	1599811316	auth_cas	field_updatelocal_lastnamephonetic	oncreate	\N
1014	2	1599811316	auth_cas	field_updateremote_lastnamephonetic	0	\N
1015	2	1599811316	auth_cas	field_lock_lastnamephonetic	unlocked	\N
1016	2	1599811316	auth_cas	field_map_middlename		\N
1017	2	1599811316	auth_cas	field_updatelocal_middlename	oncreate	\N
1018	2	1599811316	auth_cas	field_updateremote_middlename	0	\N
1019	2	1599811316	auth_cas	field_lock_middlename	unlocked	\N
1020	2	1599811316	auth_cas	field_map_alternatename		\N
1021	2	1599811316	auth_cas	field_updatelocal_alternatename	oncreate	\N
1022	2	1599811316	auth_cas	field_updateremote_alternatename	0	\N
1023	2	1599811316	auth_cas	field_lock_alternatename	unlocked	\N
1024	2	1599811316	auth_email	recaptcha	0	\N
1025	2	1599811316	auth_email	field_lock_firstname	unlocked	\N
1026	2	1599811316	auth_email	field_lock_lastname	unlocked	\N
1027	2	1599811316	auth_email	field_lock_email	unlocked	\N
1028	2	1599811316	auth_email	field_lock_city	unlocked	\N
1029	2	1599811316	auth_email	field_lock_country	unlocked	\N
1030	2	1599811316	auth_email	field_lock_lang	unlocked	\N
1031	2	1599811316	auth_email	field_lock_description	unlocked	\N
1032	2	1599811316	auth_email	field_lock_url	unlocked	\N
1033	2	1599811316	auth_email	field_lock_idnumber	unlocked	\N
1034	2	1599811316	auth_email	field_lock_institution	unlocked	\N
1035	2	1599811316	auth_email	field_lock_department	unlocked	\N
1036	2	1599811316	auth_email	field_lock_phone1	unlocked	\N
1037	2	1599811316	auth_email	field_lock_phone2	unlocked	\N
1038	2	1599811316	auth_email	field_lock_address	unlocked	\N
1039	2	1599811316	auth_email	field_lock_firstnamephonetic	unlocked	\N
1040	2	1599811316	auth_email	field_lock_lastnamephonetic	unlocked	\N
1041	2	1599811316	auth_email	field_lock_middlename	unlocked	\N
1042	2	1599811316	auth_email	field_lock_alternatename	unlocked	\N
1043	2	1599811316	auth_db	host	127.0.0.1	\N
1044	2	1599811316	auth_db	type	mysqli	\N
1045	2	1599811316	auth_db	sybasequoting	0	\N
1046	2	1599811316	auth_db	name		\N
1047	2	1599811316	auth_db	user		\N
1048	2	1599811316	auth_db	pass		\N
1049	2	1599811316	auth_db	table		\N
1050	2	1599811316	auth_db	fielduser		\N
1051	2	1599811316	auth_db	fieldpass		\N
1052	2	1599811316	auth_db	passtype	plaintext	\N
1053	2	1599811316	auth_db	extencoding	utf-8	\N
1054	2	1599811316	auth_db	setupsql		\N
1055	2	1599811316	auth_db	debugauthdb	0	\N
1056	2	1599811316	auth_db	changepasswordurl		\N
1057	2	1599811316	auth_db	removeuser	0	\N
1058	2	1599811316	auth_db	updateusers	0	\N
1059	2	1599811316	auth_db	field_map_firstname		\N
1060	2	1599811316	auth_db	field_updatelocal_firstname	oncreate	\N
1061	2	1599811316	auth_db	field_updateremote_firstname	0	\N
1062	2	1599811316	auth_db	field_lock_firstname	unlocked	\N
1063	2	1599811316	auth_db	field_map_lastname		\N
1064	2	1599811316	auth_db	field_updatelocal_lastname	oncreate	\N
1065	2	1599811316	auth_db	field_updateremote_lastname	0	\N
1066	2	1599811316	auth_db	field_lock_lastname	unlocked	\N
1067	2	1599811316	auth_db	field_map_email		\N
1068	2	1599811316	auth_db	field_updatelocal_email	oncreate	\N
1069	2	1599811316	auth_db	field_updateremote_email	0	\N
1070	2	1599811316	auth_db	field_lock_email	unlocked	\N
1071	2	1599811316	auth_db	field_map_city		\N
1072	2	1599811316	auth_db	field_updatelocal_city	oncreate	\N
1073	2	1599811316	auth_db	field_updateremote_city	0	\N
1074	2	1599811316	auth_db	field_lock_city	unlocked	\N
1075	2	1599811316	auth_db	field_map_country		\N
1076	2	1599811316	auth_db	field_updatelocal_country	oncreate	\N
1077	2	1599811316	auth_db	field_updateremote_country	0	\N
1078	2	1599811316	auth_db	field_lock_country	unlocked	\N
1079	2	1599811316	auth_db	field_map_lang		\N
1080	2	1599811316	auth_db	field_updatelocal_lang	oncreate	\N
1081	2	1599811316	auth_db	field_updateremote_lang	0	\N
1082	2	1599811316	auth_db	field_lock_lang	unlocked	\N
1083	2	1599811316	auth_db	field_map_description		\N
1084	2	1599811316	auth_db	field_updatelocal_description	oncreate	\N
1085	2	1599811316	auth_db	field_updateremote_description	0	\N
1086	2	1599811316	auth_db	field_lock_description	unlocked	\N
1087	2	1599811316	auth_db	field_map_url		\N
1088	2	1599811316	auth_db	field_updatelocal_url	oncreate	\N
1089	2	1599811316	auth_db	field_updateremote_url	0	\N
1090	2	1599811316	auth_db	field_lock_url	unlocked	\N
1091	2	1599811316	auth_db	field_map_idnumber		\N
1092	2	1599811316	auth_db	field_updatelocal_idnumber	oncreate	\N
1093	2	1599811316	auth_db	field_updateremote_idnumber	0	\N
1094	2	1599811316	auth_db	field_lock_idnumber	unlocked	\N
1095	2	1599811316	auth_db	field_map_institution		\N
1096	2	1599811316	auth_db	field_updatelocal_institution	oncreate	\N
1097	2	1599811316	auth_db	field_updateremote_institution	0	\N
1098	2	1599811316	auth_db	field_lock_institution	unlocked	\N
1099	2	1599811316	auth_db	field_map_department		\N
1100	2	1599811317	auth_db	field_updatelocal_department	oncreate	\N
1101	2	1599811317	auth_db	field_updateremote_department	0	\N
1102	2	1599811317	auth_db	field_lock_department	unlocked	\N
1103	2	1599811317	auth_db	field_map_phone1		\N
1104	2	1599811317	auth_db	field_updatelocal_phone1	oncreate	\N
1105	2	1599811317	auth_db	field_updateremote_phone1	0	\N
1106	2	1599811317	auth_db	field_lock_phone1	unlocked	\N
1107	2	1599811317	auth_db	field_map_phone2		\N
1108	2	1599811317	auth_db	field_updatelocal_phone2	oncreate	\N
1109	2	1599811317	auth_db	field_updateremote_phone2	0	\N
1110	2	1599811317	auth_db	field_lock_phone2	unlocked	\N
1111	2	1599811317	auth_db	field_map_address		\N
1112	2	1599811317	auth_db	field_updatelocal_address	oncreate	\N
1113	2	1599811317	auth_db	field_updateremote_address	0	\N
1114	2	1599811317	auth_db	field_lock_address	unlocked	\N
1115	2	1599811317	auth_db	field_map_firstnamephonetic		\N
1116	2	1599811317	auth_db	field_updatelocal_firstnamephonetic	oncreate	\N
1117	2	1599811317	auth_db	field_updateremote_firstnamephonetic	0	\N
1118	2	1599811317	auth_db	field_lock_firstnamephonetic	unlocked	\N
1119	2	1599811317	auth_db	field_map_lastnamephonetic		\N
1120	2	1599811317	auth_db	field_updatelocal_lastnamephonetic	oncreate	\N
1121	2	1599811317	auth_db	field_updateremote_lastnamephonetic	0	\N
1122	2	1599811317	auth_db	field_lock_lastnamephonetic	unlocked	\N
1123	2	1599811317	auth_db	field_map_middlename		\N
1124	2	1599811317	auth_db	field_updatelocal_middlename	oncreate	\N
1125	2	1599811317	auth_db	field_updateremote_middlename	0	\N
1126	2	1599811317	auth_db	field_lock_middlename	unlocked	\N
1127	2	1599811317	auth_db	field_map_alternatename		\N
1128	2	1599811317	auth_db	field_updatelocal_alternatename	oncreate	\N
1129	2	1599811317	auth_db	field_updateremote_alternatename	0	\N
1130	2	1599811317	auth_db	field_lock_alternatename	unlocked	\N
1131	2	1599811317	auth_iomadoidc	opname	IOMAD OpenID Connect	\N
1132	2	1599811317	auth_iomadoidc	clientid		\N
1133	2	1599811317	auth_iomadoidc	clientsecret		\N
1134	2	1599811317	auth_iomadoidc	authendpoint	https://login.microsoftonline.com/common/oauth2/authorize	\N
1135	2	1599811317	auth_iomadoidc	tokenendpoint	https://login.microsoftonline.com/common/oauth2/token	\N
1136	2	1599811317	auth_iomadoidc	iomadoidcresource	https://graph.microsoft.com	\N
1137	2	1599811317	auth_iomadoidc	iomadoidcscope	openid profile email	\N
1138	2	1599811317	auth_iomadoidc	forceredirect	0	\N
1139	2	1599811317	auth_iomadoidc	autoappend		\N
1140	2	1599811317	auth_iomadoidc	domainhint		\N
1141	2	1599811317	auth_iomadoidc	loginflow	authcode	\N
1142	2	1599811317	auth_iomadoidc	userrestrictions		\N
1143	2	1599811317	auth_iomadoidc	debugmode	0	\N
1144	2	1599811317	auth_iomadoidc	icon	auth_iomadoidc:o365	\N
1145	2	1599811317	auth_iomadoidc	customicon		\N
1146	2	1599811317	auth_ldap	field_map_firstname		\N
1147	2	1599811317	auth_ldap	field_updatelocal_firstname	oncreate	\N
1148	2	1599811317	auth_ldap	field_updateremote_firstname	0	\N
1149	2	1599811317	auth_ldap	field_lock_firstname	unlocked	\N
1150	2	1599811317	auth_ldap	field_map_lastname		\N
1151	2	1599811317	auth_ldap	field_updatelocal_lastname	oncreate	\N
1152	2	1599811317	auth_ldap	field_updateremote_lastname	0	\N
1153	2	1599811317	auth_ldap	field_lock_lastname	unlocked	\N
1154	2	1599811317	auth_ldap	field_map_email		\N
1155	2	1599811317	auth_ldap	field_updatelocal_email	oncreate	\N
1156	2	1599811317	auth_ldap	field_updateremote_email	0	\N
1157	2	1599811317	auth_ldap	field_lock_email	unlocked	\N
1158	2	1599811317	auth_ldap	field_map_city		\N
1159	2	1599811317	auth_ldap	field_updatelocal_city	oncreate	\N
1160	2	1599811317	auth_ldap	field_updateremote_city	0	\N
1161	2	1599811317	auth_ldap	field_lock_city	unlocked	\N
1162	2	1599811317	auth_ldap	field_map_country		\N
1163	2	1599811317	auth_ldap	field_updatelocal_country	oncreate	\N
1164	2	1599811317	auth_ldap	field_updateremote_country	0	\N
1165	2	1599811317	auth_ldap	field_lock_country	unlocked	\N
1166	2	1599811317	auth_ldap	field_map_lang		\N
1167	2	1599811317	auth_ldap	field_updatelocal_lang	oncreate	\N
1168	2	1599811317	auth_ldap	field_updateremote_lang	0	\N
1169	2	1599811317	auth_ldap	field_lock_lang	unlocked	\N
1170	2	1599811317	auth_ldap	field_map_description		\N
1171	2	1599811317	auth_ldap	field_updatelocal_description	oncreate	\N
1172	2	1599811317	auth_ldap	field_updateremote_description	0	\N
1173	2	1599811317	auth_ldap	field_lock_description	unlocked	\N
1174	2	1599811317	auth_ldap	field_map_url		\N
1175	2	1599811317	auth_ldap	field_updatelocal_url	oncreate	\N
1176	2	1599811317	auth_ldap	field_updateremote_url	0	\N
1177	2	1599811317	auth_ldap	field_lock_url	unlocked	\N
1178	2	1599811317	auth_ldap	field_map_idnumber		\N
1179	2	1599811317	auth_ldap	field_updatelocal_idnumber	oncreate	\N
1180	2	1599811317	auth_ldap	field_updateremote_idnumber	0	\N
1181	2	1599811317	auth_ldap	field_lock_idnumber	unlocked	\N
1182	2	1599811317	auth_ldap	field_map_institution		\N
1183	2	1599811317	auth_ldap	field_updatelocal_institution	oncreate	\N
1184	2	1599811317	auth_ldap	field_updateremote_institution	0	\N
1185	2	1599811317	auth_ldap	field_lock_institution	unlocked	\N
1186	2	1599811317	auth_ldap	field_map_department		\N
1187	2	1599811317	auth_ldap	field_updatelocal_department	oncreate	\N
1188	2	1599811317	auth_ldap	field_updateremote_department	0	\N
1189	2	1599811317	auth_ldap	field_lock_department	unlocked	\N
1190	2	1599811317	auth_ldap	field_map_phone1		\N
1191	2	1599811317	auth_ldap	field_updatelocal_phone1	oncreate	\N
1192	2	1599811317	auth_ldap	field_updateremote_phone1	0	\N
1193	2	1599811317	auth_ldap	field_lock_phone1	unlocked	\N
1194	2	1599811317	auth_ldap	field_map_phone2		\N
1195	2	1599811317	auth_ldap	field_updatelocal_phone2	oncreate	\N
1196	2	1599811317	auth_ldap	field_updateremote_phone2	0	\N
1197	2	1599811317	auth_ldap	field_lock_phone2	unlocked	\N
1198	2	1599811317	auth_ldap	field_map_address		\N
1199	2	1599811317	auth_ldap	field_updatelocal_address	oncreate	\N
1200	2	1599811317	auth_ldap	field_updateremote_address	0	\N
1201	2	1599811317	auth_ldap	field_lock_address	unlocked	\N
1202	2	1599811317	auth_ldap	field_map_firstnamephonetic		\N
1203	2	1599811317	auth_ldap	field_updatelocal_firstnamephonetic	oncreate	\N
1204	2	1599811317	auth_ldap	field_updateremote_firstnamephonetic	0	\N
1205	2	1599811317	auth_ldap	field_lock_firstnamephonetic	unlocked	\N
1206	2	1599811317	auth_ldap	field_map_lastnamephonetic		\N
1207	2	1599811317	auth_ldap	field_updatelocal_lastnamephonetic	oncreate	\N
1208	2	1599811317	auth_ldap	field_updateremote_lastnamephonetic	0	\N
1209	2	1599811317	auth_ldap	field_lock_lastnamephonetic	unlocked	\N
1210	2	1599811317	auth_ldap	field_map_middlename		\N
1211	2	1599811317	auth_ldap	field_updatelocal_middlename	oncreate	\N
1212	2	1599811317	auth_ldap	field_updateremote_middlename	0	\N
1213	2	1599811317	auth_ldap	field_lock_middlename	unlocked	\N
1214	2	1599811317	auth_ldap	field_map_alternatename		\N
1215	2	1599811317	auth_ldap	field_updatelocal_alternatename	oncreate	\N
1216	2	1599811317	auth_ldap	field_updateremote_alternatename	0	\N
1217	2	1599811317	auth_ldap	field_lock_alternatename	unlocked	\N
1218	2	1599811317	auth_manual	expiration	0	\N
1219	2	1599811317	auth_manual	expirationtime	30	\N
1220	2	1599811317	auth_manual	expiration_warning	0	\N
1221	2	1599811317	auth_manual	field_lock_firstname	unlocked	\N
1222	2	1599811317	auth_manual	field_lock_lastname	unlocked	\N
1223	2	1599811317	auth_manual	field_lock_email	unlocked	\N
1224	2	1599811317	auth_manual	field_lock_city	unlocked	\N
1225	2	1599811317	auth_manual	field_lock_country	unlocked	\N
1226	2	1599811317	auth_manual	field_lock_lang	unlocked	\N
1227	2	1599811317	auth_manual	field_lock_description	unlocked	\N
1228	2	1599811317	auth_manual	field_lock_url	unlocked	\N
1229	2	1599811317	auth_manual	field_lock_idnumber	unlocked	\N
1230	2	1599811317	auth_manual	field_lock_institution	unlocked	\N
1231	2	1599811317	auth_manual	field_lock_department	unlocked	\N
1232	2	1599811317	auth_manual	field_lock_phone1	unlocked	\N
1233	2	1599811317	auth_manual	field_lock_phone2	unlocked	\N
1234	2	1599811317	auth_manual	field_lock_address	unlocked	\N
1235	2	1599811317	auth_manual	field_lock_firstnamephonetic	unlocked	\N
1236	2	1599811317	auth_manual	field_lock_lastnamephonetic	unlocked	\N
1237	2	1599811317	auth_manual	field_lock_middlename	unlocked	\N
1238	2	1599811317	auth_manual	field_lock_alternatename	unlocked	\N
1239	2	1599811317	auth_mnet	rpc_negotiation_timeout	30	\N
1240	2	1599811317	auth_none	field_lock_firstname	unlocked	\N
1241	2	1599811317	auth_none	field_lock_lastname	unlocked	\N
1242	2	1599811317	auth_none	field_lock_email	unlocked	\N
1243	2	1599811317	auth_none	field_lock_city	unlocked	\N
1244	2	1599811317	auth_none	field_lock_country	unlocked	\N
1245	2	1599811317	auth_none	field_lock_lang	unlocked	\N
1246	2	1599811317	auth_none	field_lock_description	unlocked	\N
1247	2	1599811317	auth_none	field_lock_url	unlocked	\N
1248	2	1599811317	auth_none	field_lock_idnumber	unlocked	\N
1249	2	1599811317	auth_none	field_lock_institution	unlocked	\N
1250	2	1599811317	auth_none	field_lock_department	unlocked	\N
1251	2	1599811317	auth_none	field_lock_phone1	unlocked	\N
1252	2	1599811317	auth_none	field_lock_phone2	unlocked	\N
1253	2	1599811317	auth_none	field_lock_address	unlocked	\N
1254	2	1599811317	auth_none	field_lock_firstnamephonetic	unlocked	\N
1255	2	1599811317	auth_none	field_lock_lastnamephonetic	unlocked	\N
1256	2	1599811317	auth_none	field_lock_middlename	unlocked	\N
1257	2	1599811317	auth_none	field_lock_alternatename	unlocked	\N
1258	2	1599811317	auth_oauth2	field_lock_firstname	unlocked	\N
1259	2	1599811317	auth_oauth2	field_lock_lastname	unlocked	\N
1260	2	1599811318	auth_oauth2	field_lock_email	unlocked	\N
1261	2	1599811318	auth_oauth2	field_lock_city	unlocked	\N
1262	2	1599811318	auth_oauth2	field_lock_country	unlocked	\N
1263	2	1599811318	auth_oauth2	field_lock_lang	unlocked	\N
1264	2	1599811318	auth_oauth2	field_lock_description	unlocked	\N
1265	2	1599811318	auth_oauth2	field_lock_url	unlocked	\N
1266	2	1599811318	auth_oauth2	field_lock_idnumber	unlocked	\N
1267	2	1599811318	auth_oauth2	field_lock_institution	unlocked	\N
1268	2	1599811318	auth_oauth2	field_lock_department	unlocked	\N
1269	2	1599811318	auth_oauth2	field_lock_phone1	unlocked	\N
1270	2	1599811318	auth_oauth2	field_lock_phone2	unlocked	\N
1271	2	1599811318	auth_oauth2	field_lock_address	unlocked	\N
1272	2	1599811318	auth_oauth2	field_lock_firstnamephonetic	unlocked	\N
1273	2	1599811318	auth_oauth2	field_lock_lastnamephonetic	unlocked	\N
1274	2	1599811318	auth_oauth2	field_lock_middlename	unlocked	\N
1275	2	1599811318	auth_oauth2	field_lock_alternatename	unlocked	\N
1276	2	1599811318	auth_shibboleth	user_attribute		\N
1277	2	1599811318	auth_shibboleth	convert_data		\N
1278	2	1599811318	auth_shibboleth	alt_login	off	\N
1279	2	1599811318	auth_shibboleth	organization_selection	urn:mace:organization1:providerID, Example Organization 1\n        https://another.idp-id.com/shibboleth, Other Example Organization, /Shibboleth.sso/DS/SWITCHaai\n        urn:mace:organization2:providerID, Example Organization 2, /Shibboleth.sso/WAYF/SWITCHaai	\N
1280	2	1599811318	auth_shibboleth	logout_handler		\N
1281	2	1599811318	auth_shibboleth	logout_return_url		\N
1282	2	1599811318	auth_shibboleth	login_name	Shibboleth Login	\N
1283	2	1599811318	auth_shibboleth	auth_logo		\N
1284	2	1599811318	auth_shibboleth	auth_instructions	Use the <a href="https://arrupe.ac.zw/acis/iomad/auth/shibboleth/index.php">Shibboleth login</a> to get access via Shibboleth, if your institution supports it. Otherwise, use the normal login form shown here.	\N
1285	2	1599811318	auth_shibboleth	changepasswordurl		\N
1286	2	1599811318	auth_shibboleth	field_map_firstname		\N
1287	2	1599811318	auth_shibboleth	field_updatelocal_firstname	oncreate	\N
1288	2	1599811318	auth_shibboleth	field_lock_firstname	unlocked	\N
1289	2	1599811318	auth_shibboleth	field_map_lastname		\N
1290	2	1599811318	auth_shibboleth	field_updatelocal_lastname	oncreate	\N
1291	2	1599811318	auth_shibboleth	field_lock_lastname	unlocked	\N
1292	2	1599811318	auth_shibboleth	field_map_email		\N
1293	2	1599811318	auth_shibboleth	field_updatelocal_email	oncreate	\N
1294	2	1599811318	auth_shibboleth	field_lock_email	unlocked	\N
1295	2	1599811318	auth_shibboleth	field_map_city		\N
1296	2	1599811318	auth_shibboleth	field_updatelocal_city	oncreate	\N
1297	2	1599811318	auth_shibboleth	field_lock_city	unlocked	\N
1298	2	1599811318	auth_shibboleth	field_map_country		\N
1299	2	1599811318	auth_shibboleth	field_updatelocal_country	oncreate	\N
1300	2	1599811318	auth_shibboleth	field_lock_country	unlocked	\N
1301	2	1599811318	auth_shibboleth	field_map_lang		\N
1302	2	1599811318	auth_shibboleth	field_updatelocal_lang	oncreate	\N
1303	2	1599811318	auth_shibboleth	field_lock_lang	unlocked	\N
1304	2	1599811318	auth_shibboleth	field_map_description		\N
1305	2	1599811318	auth_shibboleth	field_updatelocal_description	oncreate	\N
1306	2	1599811318	auth_shibboleth	field_lock_description	unlocked	\N
1307	2	1599811318	auth_shibboleth	field_map_url		\N
1308	2	1599811318	auth_shibboleth	field_updatelocal_url	oncreate	\N
1309	2	1599811318	auth_shibboleth	field_lock_url	unlocked	\N
1310	2	1599811318	auth_shibboleth	field_map_idnumber		\N
1311	2	1599811318	auth_shibboleth	field_updatelocal_idnumber	oncreate	\N
1312	2	1599811318	auth_shibboleth	field_lock_idnumber	unlocked	\N
1313	2	1599811318	auth_shibboleth	field_map_institution		\N
1314	2	1599811318	auth_shibboleth	field_updatelocal_institution	oncreate	\N
1315	2	1599811318	auth_shibboleth	field_lock_institution	unlocked	\N
1316	2	1599811318	auth_shibboleth	field_map_department		\N
1317	2	1599811318	auth_shibboleth	field_updatelocal_department	oncreate	\N
1318	2	1599811318	auth_shibboleth	field_lock_department	unlocked	\N
1319	2	1599811318	auth_shibboleth	field_map_phone1		\N
1320	2	1599811318	auth_shibboleth	field_updatelocal_phone1	oncreate	\N
1321	2	1599811318	auth_shibboleth	field_lock_phone1	unlocked	\N
1322	2	1599811318	auth_shibboleth	field_map_phone2		\N
1323	2	1599811318	auth_shibboleth	field_updatelocal_phone2	oncreate	\N
1324	2	1599811318	auth_shibboleth	field_lock_phone2	unlocked	\N
1325	2	1599811318	auth_shibboleth	field_map_address		\N
1326	2	1599811318	auth_shibboleth	field_updatelocal_address	oncreate	\N
1327	2	1599811318	auth_shibboleth	field_lock_address	unlocked	\N
1328	2	1599811318	auth_shibboleth	field_map_firstnamephonetic		\N
1329	2	1599811318	auth_shibboleth	field_updatelocal_firstnamephonetic	oncreate	\N
1330	2	1599811318	auth_shibboleth	field_lock_firstnamephonetic	unlocked	\N
1331	2	1599811318	auth_shibboleth	field_map_lastnamephonetic		\N
1332	2	1599811318	auth_shibboleth	field_updatelocal_lastnamephonetic	oncreate	\N
1333	2	1599811318	auth_shibboleth	field_lock_lastnamephonetic	unlocked	\N
1334	2	1599811318	auth_shibboleth	field_map_middlename		\N
1335	2	1599811318	auth_shibboleth	field_updatelocal_middlename	oncreate	\N
1336	2	1599811318	auth_shibboleth	field_lock_middlename	unlocked	\N
1337	2	1599811318	auth_shibboleth	field_map_alternatename		\N
1338	2	1599811318	auth_shibboleth	field_updatelocal_alternatename	oncreate	\N
1339	2	1599811318	auth_shibboleth	field_lock_alternatename	unlocked	\N
1340	2	1599811318	block_activity_results	config_showbest	3	\N
1341	2	1599811318	block_activity_results	config_showbest_locked		\N
1342	2	1599811318	block_activity_results	config_showworst	0	\N
1343	2	1599811318	block_activity_results	config_showworst_locked		\N
1344	2	1599811318	block_activity_results	config_usegroups	0	\N
1345	2	1599811318	block_activity_results	config_usegroups_locked		\N
1346	2	1599811318	block_activity_results	config_nameformat	1	\N
1347	2	1599811318	block_activity_results	config_nameformat_locked		\N
1348	2	1599811318	block_activity_results	config_gradeformat	1	\N
1349	2	1599811318	block_activity_results	config_gradeformat_locked		\N
1350	2	1599811318	block_activity_results	config_decimalpoints	2	\N
1351	2	1599811318	block_activity_results	config_decimalpoints_locked		\N
1352	2	1599811318	block_myoverview	displaycategories	1	\N
1353	2	1599811318	block_myoverview	layouts	card,list,summary	\N
1354	2	1599811318	block_myoverview	displaygroupingallincludinghidden	0	\N
1355	2	1599811318	block_myoverview	displaygroupingall	1	\N
1356	2	1599811318	block_myoverview	displaygroupinginprogress	1	\N
1357	2	1599811318	block_myoverview	displaygroupingpast	1	\N
1358	2	1599811318	block_myoverview	displaygroupingfuture	1	\N
1359	2	1599811318	block_myoverview	displaygroupingcustomfield	0	\N
1360	2	1599811318	block_myoverview	customfiltergrouping		\N
1361	2	1599811318	block_myoverview	displaygroupingstarred	1	\N
1362	2	1599811318	block_myoverview	displaygroupinghidden	1	\N
1363	2	1599811318	\N	commerce_enable_external	0	\N
1364	2	1599811318	\N	commerce_externalshop_url		\N
1365	2	1599811318	\N	commerce_externalshop_link_timeout	30	\N
1366	2	1599811318	\N	commerce_admin_firstname		\N
1367	2	1599811318	\N	commerce_admin_lastname		\N
1368	2	1599811318	\N	commerce_admin_email		\N
1369	2	1599811318	\N	commerce_admin_currency	GBP	\N
1370	2	1599811319	\N	commerce_admin_enableall	1	\N
1371	2	1599811319	\N	commerce_admin_default_license_access_length	30	\N
1372	2	1599811319	\N	commerce_admin_default_license_shelf_life	365	\N
1373	2	1599811319	\N	invoice_enabled	0	\N
1374	2	1599811319	\N	paypal_enabled	0	\N
1375	2	1599811319	\N	paypal_usesandbox	0	\N
1376	2	1599811319	\N	paypal_api_username		\N
1377	2	1599811319	\N	paypal_api_password		\N
1378	2	1599811319	\N	paypal_api_signature		\N
1379	2	1599811319	\N	block_html_allowcssclasses	0	\N
1380	2	1599811319	\N	block_iomad_html_allowcssclasses	0	\N
1381	2	1599811319	\N	microlearninglinkexpires	30	\N
1382	2	1599811319	\N	block_iomad_onlineusers_timetosee	5	\N
1383	2	1599811319	\N	mycourses_archivecutoff	100	\N
1384	2	1599811319	\N	mycourses_showsummary	0	\N
1385	2	1599811319	\N	block_online_users_timetosee	5	\N
1386	2	1599811319	\N	block_online_users_onlinestatushiding	1	\N
1387	2	1599811319	block_iomad_progress	coursenametoshow	shortname	\N
1388	2	1599811319	block_iomad_progress	attempted_colour	#5CD85C	\N
1389	2	1599811319	block_iomad_progress	notattempted_colour	#FF5C5C	\N
1390	2	1599811319	block_iomad_progress	futurenotattempted_colour	#5C5CFF	\N
1391	2	1599811319	block_recentlyaccessedcourses	displaycategories	1	\N
1392	2	1599811319	\N	block_rss_client_num_entries	5	\N
1393	2	1599811319	\N	block_rss_client_timeout	30	\N
1394	2	1599811319	block_section_links	numsections1	22	\N
1395	2	1599811319	block_section_links	incby1	2	\N
1396	2	1599811319	block_section_links	numsections2	40	\N
1397	2	1599811319	block_section_links	incby2	5	\N
1398	2	1599811319	block_starredcourses	displaycategories	1	\N
1399	2	1599811319	block_tag_youtube	apikey		\N
1400	2	1599811319	format_singleactivity	activitytype	forum	\N
1401	2	1599811319	fileconverter_googledrive	issuerid		\N
1402	2	1599811319	\N	pathtounoconv	/usr/bin/unoconv	\N
1403	2	1599811319	enrol_cohort	roleid	5	\N
1404	2	1599811319	enrol_cohort	unenrolaction	0	\N
1405	2	1599811319	enrol_meta	nosyncroleids		\N
1406	2	1599811319	enrol_meta	syncall	1	\N
1407	2	1599811319	enrol_meta	unenrolaction	3	\N
1408	2	1599811319	enrol_meta	coursesort	sortorder	\N
1409	2	1599811319	enrol_database	dbtype		\N
1410	2	1599811319	enrol_database	dbhost	localhost	\N
1411	2	1599811319	enrol_database	dbuser		\N
1412	2	1599811319	enrol_database	dbpass		\N
1413	2	1599811319	enrol_database	dbname		\N
1414	2	1599811319	enrol_database	dbencoding	utf-8	\N
1415	2	1599811319	enrol_database	dbsetupsql		\N
1416	2	1599811319	enrol_database	dbsybasequoting	0	\N
1417	2	1599811319	enrol_database	debugdb	0	\N
1418	2	1599811319	enrol_database	localcoursefield	idnumber	\N
1419	2	1599811319	enrol_database	localuserfield	idnumber	\N
1420	2	1599811319	enrol_database	localrolefield	shortname	\N
1421	2	1599811319	enrol_database	localcategoryfield	id	\N
1422	2	1599811319	enrol_database	remoteenroltable		\N
1423	2	1599811319	enrol_database	remotecoursefield		\N
1424	2	1599811319	enrol_database	remoteuserfield		\N
1425	2	1599811319	enrol_database	remoterolefield		\N
1426	2	1599811319	enrol_database	remoteotheruserfield		\N
1427	2	1599811319	enrol_database	defaultrole	5	\N
1428	2	1599811319	enrol_database	ignorehiddencourses	0	\N
1429	2	1599811319	enrol_database	unenrolaction	0	\N
1430	2	1599811319	enrol_database	newcoursetable		\N
1431	2	1599811319	enrol_database	newcoursefullname	fullname	\N
1432	2	1599811319	enrol_database	newcourseshortname	shortname	\N
1433	2	1599811319	enrol_database	newcourseidnumber	idnumber	\N
1434	2	1599811319	enrol_database	newcoursecategory		\N
1435	2	1599811319	enrol_database	defaultcategory	1	\N
1436	2	1599811319	enrol_database	templatecourse		\N
1437	2	1599811319	enrol_flatfile	location		\N
1438	2	1599811319	enrol_flatfile	encoding	UTF-8	\N
1439	2	1599811319	enrol_flatfile	mailstudents	0	\N
1440	2	1599811319	enrol_flatfile	mailteachers	0	\N
1441	2	1599811319	enrol_flatfile	mailadmins	0	\N
1442	2	1599811319	enrol_flatfile	unenrolaction	3	\N
1443	2	1599811319	enrol_flatfile	expiredaction	3	\N
1444	2	1599811319	enrol_guest	requirepassword	0	\N
1445	2	1599811319	enrol_guest	usepasswordpolicy	0	\N
1446	2	1599811319	enrol_guest	showhint	0	\N
1447	2	1599811319	enrol_guest	defaultenrol	1	\N
1448	2	1599811319	enrol_guest	status	1	\N
1449	2	1599811319	enrol_guest	status_adv		\N
1450	2	1599811319	enrol_imsenterprise	imsfilelocation		\N
1451	2	1599811319	enrol_imsenterprise	logtolocation		\N
1452	2	1599811319	enrol_imsenterprise	mailadmins	0	\N
1453	2	1599811319	enrol_imsenterprise	createnewusers	0	\N
1454	2	1599811319	enrol_imsenterprise	imsupdateusers	0	\N
1455	2	1599811319	enrol_imsenterprise	imsdeleteusers	0	\N
1456	2	1599811319	enrol_imsenterprise	fixcaseusernames	0	\N
1457	2	1599811319	enrol_imsenterprise	fixcasepersonalnames	0	\N
1458	2	1599811319	enrol_imsenterprise	imssourcedidfallback	0	\N
1459	2	1599811319	enrol_imsenterprise	imsrolemap01	5	\N
1460	2	1599811319	enrol_imsenterprise	imsrolemap02	3	\N
1461	2	1599811319	enrol_imsenterprise	imsrolemap03	3	\N
1462	2	1599811319	enrol_imsenterprise	imsrolemap04	5	\N
1463	2	1599811319	enrol_imsenterprise	imsrolemap05	0	\N
1464	2	1599811319	enrol_imsenterprise	imsrolemap06	4	\N
1465	2	1599811319	enrol_imsenterprise	imsrolemap07	0	\N
1466	2	1599811319	enrol_imsenterprise	imsrolemap08	4	\N
1467	2	1599811319	enrol_imsenterprise	truncatecoursecodes	0	\N
1468	2	1599811319	enrol_imsenterprise	createnewcourses	0	\N
1469	2	1599811319	enrol_imsenterprise	updatecourses	0	\N
1470	2	1599811319	enrol_imsenterprise	createnewcategories	0	\N
1471	2	1599811319	enrol_imsenterprise	nestedcategories	0	\N
1472	2	1599811319	enrol_imsenterprise	categoryidnumber	0	\N
1473	2	1599811319	enrol_imsenterprise	categoryseparator		\N
1474	2	1599811320	enrol_imsenterprise	imsunenrol	0	\N
1475	2	1599811320	enrol_imsenterprise	imscoursemapshortname	coursecode	\N
1476	2	1599811320	enrol_imsenterprise	imscoursemapfullname	short	\N
1477	2	1599811320	enrol_imsenterprise	imscoursemapsummary	ignore	\N
1478	2	1599811320	enrol_imsenterprise	imsrestricttarget		\N
1479	2	1599811320	enrol_imsenterprise	imscapitafix	0	\N
1480	2	1599811320	enrol_license	defaultenrol	1	\N
1481	2	1599811320	enrol_license	status	1	\N
1482	2	1599811320	enrol_license	roleid	5	\N
1483	2	1599811320	enrol_license	longtimenosee	0	\N
1484	2	1599811320	enrol_license	sendcoursewelcomemessage	1	\N
1485	2	1599811320	enrol_manual	expiredaction	1	\N
1486	2	1599811320	enrol_manual	expirynotifyhour	6	\N
1487	2	1599811320	enrol_manual	defaultenrol	1	\N
1488	2	1599811320	enrol_manual	status	0	\N
1489	2	1599811320	enrol_manual	roleid	5	\N
1490	2	1599811320	enrol_manual	enrolstart	4	\N
1491	2	1599811320	enrol_manual	enrolperiod	0	\N
1492	2	1599811320	enrol_manual	expirynotify	0	\N
1493	2	1599811320	enrol_manual	expirythreshold	86400	\N
1494	2	1599811320	enrol_mnet	roleid	5	\N
1495	2	1599811320	enrol_mnet	roleid_adv	1	\N
1496	2	1599811320	enrol_paypal	paypalbusiness		\N
1497	2	1599811320	enrol_paypal	mailstudents	0	\N
1498	2	1599811320	enrol_paypal	mailteachers	0	\N
1499	2	1599811320	enrol_paypal	mailadmins	0	\N
1500	2	1599811320	enrol_paypal	expiredaction	3	\N
1501	2	1599811320	enrol_paypal	status	1	\N
1502	2	1599811320	enrol_paypal	cost	0	\N
1503	2	1599811320	enrol_paypal	currency	USD	\N
1504	2	1599811320	enrol_paypal	roleid	5	\N
1505	2	1599811320	enrol_paypal	enrolperiod	0	\N
1506	2	1599811320	enrol_lti	emaildisplay	2	\N
1507	2	1599811320	enrol_lti	city		\N
1508	2	1599811320	enrol_lti	country		\N
1509	2	1599811320	enrol_lti	timezone	99	\N
1510	2	1599811320	enrol_lti	lang	en	\N
1511	2	1599811320	enrol_lti	institution		\N
1512	2	1599811320	enrol_self	requirepassword	0	\N
1513	2	1599811320	enrol_self	usepasswordpolicy	0	\N
1514	2	1599811320	enrol_self	showhint	0	\N
1515	2	1599811320	enrol_self	expiredaction	1	\N
1516	2	1599811320	enrol_self	expirynotifyhour	6	\N
1517	2	1599811320	enrol_self	defaultenrol	1	\N
1518	2	1599811320	enrol_self	status	1	\N
1519	2	1599811320	enrol_self	newenrols	1	\N
1520	2	1599811320	enrol_self	groupkey	0	\N
1521	2	1599811320	enrol_self	roleid	5	\N
1522	2	1599811320	enrol_self	enrolperiod	0	\N
1523	2	1599811320	enrol_self	expirynotify	0	\N
1524	2	1599811320	enrol_self	expirythreshold	86400	\N
1525	2	1599811320	enrol_self	longtimenosee	0	\N
1526	2	1599811320	enrol_self	maxenrolled	0	\N
1527	2	1599811320	enrol_self	sendcoursewelcomemessage	1	\N
1528	2	1599811320	filter_displayh5p	allowedsources		\N
1529	2	1599811320	filter_mathjaxloader	httpsurl	https://cdn.jsdelivr.net/npm/mathjax@2.7.8/MathJax.js	\N
1530	2	1599811320	filter_mathjaxloader	texfiltercompatibility	0	\N
1531	2	1599811320	filter_mathjaxloader	mathjaxconfig	\nMathJax.Hub.Config({\n    config: ["Accessible.js", "Safe.js"],\n    errorSettings: { message: ["!"] },\n    skipStartupTypeset: true,\n    messageStyle: "none"\n});\n	\N
1532	2	1599811320	filter_mathjaxloader	additionaldelimiters		\N
1533	2	1599811320	\N	filter_multilang_force_old	0	\N
1534	2	1599811320	filter_tex	latexpreamble	\\usepackage[latin1]{inputenc}\n\\usepackage{amsmath}\n\\usepackage{amsfonts}\n\\RequirePackage{amsmath,amssymb,latexsym}\n	\N
1535	2	1599811320	filter_tex	latexbackground	#FFFFFF	\N
1536	2	1599811320	filter_tex	density	120	\N
1537	2	1599811320	filter_tex	pathlatex	/usr/bin/latex	\N
1538	2	1599811320	filter_tex	pathdvips	/usr/bin/dvips	\N
1539	2	1599811320	filter_tex	pathconvert	/usr/bin/convert	\N
1540	2	1599811320	filter_tex	pathdvisvgm	/usr/bin/dvisvgm	\N
1541	2	1599811320	filter_tex	pathmimetex		\N
1542	2	1599811320	filter_tex	convertformat	gif	\N
1543	2	1599811320	\N	filter_censor_badwords		\N
1544	2	1599811320	local_iomad_learningpath	showcoursename	shortname	\N
1545	2	1599811320	local_iomad_learningpath	showcoursedescription	1	\N
1546	2	1599811320	local_iomad_learningpath	showprogress	1	\N
1547	2	1599811320	\N	establishment_code	0	\N
1548	2	1599811320	\N	iomad_use_email_as_username	0	\N
1549	2	1599811320	\N	iomad_allow_username	0	\N
1550	2	1599811320	\N	iomad_sync_institution	0	\N
1551	2	1599811320	\N	iomad_sync_department	0	\N
1552	2	1599811320	\N	iomad_autoenrol_managers	1	\N
1553	2	1599811320	\N	iomad_autoreallocate_licenses	0	\N
1554	2	1599811320	\N	iomad_hidevalidcourses	0	\N
1555	2	1599811320	\N	iomad_date_format	Y-m-d	\N
1556	2	1599811320	\N	iomad_report_fields		\N
1557	2	1599811320	\N	iomad_report_grade_places	0	\N
1558	2	1599811320	\N	iomad_max_list_users	30	\N
1559	2	1599811320	\N	iomad_max_list_courses	30	\N
1560	2	1599811320	\N	iomad_max_list_templates	30	\N
1561	2	1599811320	\N	iomad_max_list_companies	30	\N
1562	2	1599811320	\N	iomad_max_list_licenses	30	\N
1563	2	1599811320	\N	iomad_max_list_classrooms	30	\N
1564	2	1599811320	\N	iomad_max_list_email_templates	30	\N
1565	2	1599811320	\N	iomad_max_list_competencies	30	\N
1566	2	1599811320	\N	iomad_max_list_frameworks	30	\N
1567	2	1599811320	\N	iomad_max_select_users	100	\N
1568	2	1599811320	\N	iomad_max_select_courses	200	\N
1569	2	1599811320	\N	iomad_max_select_templates	200	\N
1570	2	1599811320	\N	iomad_max_select_frameworks	200	\N
1571	2	1599811320	local_iomad_settings	iomadcertificate_logo		\N
1572	2	1599811320	local_iomad_settings	iomadcertificate_signature		\N
1573	2	1599811320	local_iomad_settings	iomadcertificate_border		\N
1574	2	1599811320	local_iomad_settings	iomadcertificate_watermark		\N
1575	2	1599811320	\N	local_iomad_signup_enable	1	\N
1576	2	1599811320	\N	local_iomad_signup_showinstructions	1	\N
1577	2	1599811320	\N	local_iomad_signup_useemail	1	\N
1578	2	1599811320	\N	local_iomad_signup_autoenrol	1	\N
1579	2	1599811320	\N	local_iomad_signup_autoenrol_unassigned	0	\N
1580	2	1599811320	logstore_database	dbdriver		\N
1581	2	1599811320	logstore_database	dbhost		\N
1582	2	1599811320	logstore_database	dbuser		\N
1583	2	1599811320	logstore_database	dbpass		\N
1584	2	1599811320	logstore_database	dbname		\N
1585	2	1599811320	logstore_database	dbtable		\N
1586	2	1599811320	logstore_database	dbpersist	0	\N
1587	2	1599811321	logstore_database	dbsocket		\N
1588	2	1599811321	logstore_database	dbport		\N
1589	2	1599811321	logstore_database	dbschema		\N
1590	2	1599811321	logstore_database	dbcollation		\N
1591	2	1599811321	logstore_database	dbhandlesoptions	0	\N
1592	2	1599811321	logstore_database	buffersize	50	\N
1593	2	1599811321	logstore_database	jsonformat	1	\N
1594	2	1599811321	logstore_database	logguests	0	\N
1595	2	1599811321	logstore_database	includelevels	1,2,0	\N
1596	2	1599811321	logstore_database	includeactions	c,r,u,d	\N
1597	2	1599811321	logstore_legacy	loglegacy	0	\N
1598	2	1599811321	\N	logguests	1	\N
1599	2	1599811321	\N	loglifetime	0	\N
1600	2	1599811321	logstore_standard	logguests	1	\N
1601	2	1599811321	logstore_standard	jsonformat	1	\N
1602	2	1599811321	logstore_standard	loglifetime	0	\N
1603	2	1599811321	logstore_standard	buffersize	50	\N
1604	2	1599811321	mlbackend_python	useserver	0	\N
1605	2	1599811321	mlbackend_python	host		\N
1606	2	1599811321	mlbackend_python	port	0	\N
1607	2	1599811321	mlbackend_python	secure	0	\N
1608	2	1599811321	mlbackend_python	username	default	\N
1609	2	1599811321	mlbackend_python	password		\N
1610	2	1599811321	media_videojs	videoextensions	html_video,media_source,.f4v,.flv	\N
1611	2	1599811321	media_videojs	audioextensions	html_audio	\N
1612	2	1599811321	media_videojs	rtmp	0	\N
1613	2	1599811321	media_videojs	useflash	0	\N
1614	2	1599811321	media_videojs	youtube	1	\N
1615	2	1599811321	media_videojs	videocssclass	video-js	\N
1616	2	1599811321	media_videojs	audiocssclass	video-js	\N
1617	2	1599811321	media_videojs	limitsize	1	\N
1618	2	1599811321	qtype_multichoice	answerhowmany	1	\N
1619	2	1599811321	qtype_multichoice	shuffleanswers	1	\N
1620	2	1599811321	qtype_multichoice	answernumbering	abc	\N
1621	2	1599811321	editor_atto	toolbar	collapse = collapse\nstyle1 = title, bold, italic\nlist = unorderedlist, orderedlist\nlinks = link\nfiles = image, media, recordrtc, managefiles, h5p\nstyle2 = underline, strike, subscript, superscript\nalign = align\nindent = indent\ninsert = equation, charmap, table, clear\nundo = undo\naccessibility = accessibilitychecker, accessibilityhelper\nother = html	\N
1622	2	1599811321	editor_atto	autosavefrequency	60	\N
1623	2	1599811321	atto_collapse	showgroups	5	\N
1624	2	1599811321	atto_equation	librarygroup1	\n\\cdot\n\\times\n\\ast\n\\div\n\\diamond\n\\pm\n\\mp\n\\oplus\n\\ominus\n\\otimes\n\\oslash\n\\odot\n\\circ\n\\bullet\n\\asymp\n\\equiv\n\\subseteq\n\\supseteq\n\\leq\n\\geq\n\\preceq\n\\succeq\n\\sim\n\\simeq\n\\approx\n\\subset\n\\supset\n\\ll\n\\gg\n\\prec\n\\succ\n\\infty\n\\in\n\\ni\n\\forall\n\\exists\n\\neq\n	\N
1625	2	1599811321	atto_equation	librarygroup2	\n\\leftarrow\n\\rightarrow\n\\uparrow\n\\downarrow\n\\leftrightarrow\n\\nearrow\n\\searrow\n\\swarrow\n\\nwarrow\n\\Leftarrow\n\\Rightarrow\n\\Uparrow\n\\Downarrow\n\\Leftrightarrow\n	\N
1626	2	1599811321	atto_equation	librarygroup3	\n\\alpha\n\\beta\n\\gamma\n\\delta\n\\epsilon\n\\zeta\n\\eta\n\\theta\n\\iota\n\\kappa\n\\lambda\n\\mu\n\\nu\n\\xi\n\\pi\n\\rho\n\\sigma\n\\tau\n\\upsilon\n\\phi\n\\chi\n\\psi\n\\omega\n\\Gamma\n\\Delta\n\\Theta\n\\Lambda\n\\Xi\n\\Pi\n\\Sigma\n\\Upsilon\n\\Phi\n\\Psi\n\\Omega\n	\N
1627	2	1599811321	atto_equation	librarygroup4	\n\\sum{a,b}\n\\sqrt[a]{b+c}\n\\int_{a}^{b}{c}\n\\iint_{a}^{b}{c}\n\\iiint_{a}^{b}{c}\n\\oint{a}\n(a)\n[a]\n\\lbrace{a}\\rbrace\n\\left| \\begin{matrix} a_1 & a_2 \\ a_3 & a_4 \\end{matrix} \\right|\n\\frac{a}{b+c}\n\\vec{a}\n\\binom {a} {b}\n{a \\brack b}\n{a \\brace b}\n	\N
1628	2	1599811321	atto_recordrtc	allowedtypes	both	\N
1629	2	1599811321	atto_recordrtc	audiobitrate	128000	\N
1630	2	1599811321	atto_recordrtc	videobitrate	2500000	\N
1631	2	1599811321	atto_recordrtc	timelimit	120	\N
1632	2	1599811321	atto_table	allowborders	0	\N
1633	2	1599811321	atto_table	allowbackgroundcolour	0	\N
1634	2	1599811321	atto_table	allowwidth	0	\N
1635	2	1599811321	editor_tinymce	customtoolbar	wrap,formatselect,wrap,bold,italic,wrap,bullist,numlist,wrap,link,unlink,wrap,image\n\nundo,redo,wrap,underline,strikethrough,sub,sup,wrap,justifyleft,justifycenter,justifyright,wrap,outdent,indent,wrap,forecolor,backcolor,wrap,ltr,rtl\n\nfontselect,fontsizeselect,wrap,code,search,replace,wrap,nonbreaking,charmap,table,wrap,cleanup,removeformat,pastetext,pasteword,wrap,fullscreen	\N
1636	2	1599811321	editor_tinymce	fontselectlist	Trebuchet=Trebuchet MS,Verdana,Arial,Helvetica,sans-serif;Arial=arial,helvetica,sans-serif;Courier New=courier new,courier,monospace;Georgia=georgia,times new roman,times,serif;Tahoma=tahoma,arial,helvetica,sans-serif;Times New Roman=times new roman,times,serif;Verdana=verdana,arial,helvetica,sans-serif;Impact=impact;Wingdings=wingdings	\N
1637	2	1599811322	editor_tinymce	customconfig		\N
1638	2	1599811322	tinymce_moodleemoticon	requireemoticon	1	\N
1639	2	1599811322	tinymce_spellchecker	spellengine		\N
1640	2	1599811322	tinymce_spellchecker	spelllanguagelist	+English=en,Danish=da,Dutch=nl,Finnish=fi,French=fr,German=de,Italian=it,Polish=pl,Portuguese=pt,Spanish=es,Swedish=sv	\N
1641	2	1599811322	\N	profileroles	5,4,3	\N
1642	2	1599811322	\N	coursecontact	3	\N
1644	2	1599811322	\N	frontpageloggedin	6	\N
1645	2	1599811322	\N	maxcategorydepth	2	\N
1646	2	1599811322	\N	frontpagecourselimit	200	\N
1647	2	1599811322	\N	commentsperpage	15	\N
1648	2	1599811322	\N	defaultfrontpageroleid	8	\N
1649	2	1599811322	\N	messageinbound_enabled	0	\N
1650	2	1599811322	\N	messageinbound_mailbox		\N
1651	2	1599811322	\N	messageinbound_domain		\N
1652	2	1599811322	\N	messageinbound_host		\N
1653	2	1599811322	\N	messageinbound_hostssl	ssl	\N
1654	2	1599811322	\N	messageinbound_hostuser		\N
1655	2	1599811322	\N	messageinbound_hostpass		\N
1656	2	1599811322	\N	enablemobilewebservice	1	\N
1657	2	1599811323	\N	block_course_list_adminview	all	\N
1658	2	1599811323	\N	block_course_list_hideallcourseslink	0	\N
1659	2	1599811323	\N	mobilecssurl		\N
1660	2	1599811374	\N	timezone	Europe/London	\N
1661	2	1599811374	\N	registerauth		\N
1662	2	1600085006	\N	enablewebservices	0	1
1663	2	1600086072	\N	registerauth	email	
1664	2	1600086244	\N	userfiltersdefault	username	realname
1665	2	1600087645	\N	enablewebservices	1	0
1666	2	1603262705	\N	profileroles	3,4,5	5,4,3
1667	2	1603262705	\N	passwordpolicy	0	1
1668	2	1603430958	core	siteadmins	2, 35	2
\.


--
-- Data for Name: mdl_config_plugins; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_config_plugins (id, plugin, name, value) FROM stdin;
1	question	multichoice_sortorder	1
2	question	truefalse_sortorder	2
3	question	match_sortorder	3
4	question	shortanswer_sortorder	4
5	question	numerical_sortorder	5
6	question	essay_sortorder	6
7	moodlecourse	visible	1
8	moodlecourse	format	topics
9	moodlecourse	maxsections	52
10	moodlecourse	numsections	4
11	moodlecourse	hiddensections	0
12	moodlecourse	coursedisplay	0
13	moodlecourse	courseenddateenabled	1
14	moodlecourse	courseduration	31536000
15	moodlecourse	lang	
16	moodlecourse	newsitems	5
17	moodlecourse	showgrades	1
18	moodlecourse	showreports	0
19	moodlecourse	maxbytes	0
20	moodlecourse	enablecompletion	1
21	moodlecourse	groupmode	0
22	moodlecourse	groupmodeforce	0
23	backup	loglifetime	30
24	backup	backup_general_users	1
25	backup	backup_general_users_locked	
26	backup	backup_general_anonymize	0
27	backup	backup_general_anonymize_locked	
28	backup	backup_general_role_assignments	1
29	backup	backup_general_role_assignments_locked	
30	backup	backup_general_activities	1
31	backup	backup_general_activities_locked	
32	backup	backup_general_blocks	1
33	backup	backup_general_blocks_locked	
34	backup	backup_general_files	1
35	backup	backup_general_files_locked	
36	backup	backup_general_filters	1
37	backup	backup_general_filters_locked	
38	backup	backup_general_comments	1
39	backup	backup_general_comments_locked	
40	backup	backup_general_badges	1
41	backup	backup_general_badges_locked	
42	backup	backup_general_calendarevents	1
43	backup	backup_general_calendarevents_locked	
44	backup	backup_general_userscompletion	1
45	backup	backup_general_userscompletion_locked	
46	backup	backup_general_logs	0
47	backup	backup_general_logs_locked	
48	backup	backup_general_histories	0
49	backup	backup_general_histories_locked	
50	backup	backup_general_questionbank	1
51	backup	backup_general_questionbank_locked	
52	backup	backup_general_groups	1
53	backup	backup_general_groups_locked	
54	backup	backup_general_competencies	1
55	backup	backup_general_competencies_locked	
56	backup	import_general_maxresults	10
57	backup	import_general_duplicate_admin_allowed	0
58	backup	backup_import_activities	1
59	backup	backup_import_activities_locked	
60	backup	backup_import_blocks	1
61	backup	backup_import_blocks_locked	
62	backup	backup_import_filters	1
63	backup	backup_import_filters_locked	
64	backup	backup_import_calendarevents	1
65	backup	backup_import_calendarevents_locked	
66	backup	backup_import_questionbank	1
67	backup	backup_import_questionbank_locked	
68	backup	backup_import_groups	1
69	backup	backup_import_groups_locked	
70	backup	backup_import_competencies	1
71	backup	backup_import_competencies_locked	
72	backup	backup_auto_active	0
73	backup	backup_auto_weekdays	0000000
74	backup	backup_auto_hour	0
75	backup	backup_auto_minute	0
76	backup	backup_auto_storage	0
77	backup	backup_auto_destination	
78	backup	backup_auto_max_kept	1
79	backup	backup_auto_delete_days	0
80	backup	backup_auto_min_kept	0
81	backup	backup_shortname	0
82	backup	backup_auto_skip_hidden	1
83	backup	backup_auto_skip_modif_days	30
84	backup	backup_auto_skip_modif_prev	0
85	backup	backup_auto_users	1
86	backup	backup_auto_role_assignments	1
87	backup	backup_auto_activities	1
88	backup	backup_auto_blocks	1
89	backup	backup_auto_files	1
90	backup	backup_auto_filters	1
91	backup	backup_auto_comments	1
92	backup	backup_auto_badges	1
93	backup	backup_auto_calendarevents	1
94	backup	backup_auto_userscompletion	1
95	backup	backup_auto_logs	0
96	backup	backup_auto_histories	0
97	backup	backup_auto_questionbank	1
98	backup	backup_auto_groups	1
99	backup	backup_auto_competencies	1
100	restore	restore_general_users	1
101	restore	restore_general_users_locked	
102	restore	restore_general_enrolments	1
103	restore	restore_general_enrolments_locked	
104	restore	restore_general_role_assignments	1
105	restore	restore_general_role_assignments_locked	
106	restore	restore_general_activities	1
107	restore	restore_general_activities_locked	
108	restore	restore_general_blocks	1
109	restore	restore_general_blocks_locked	
110	restore	restore_general_filters	1
111	restore	restore_general_filters_locked	
112	restore	restore_general_comments	1
113	restore	restore_general_comments_locked	
114	restore	restore_general_badges	1
115	restore	restore_general_badges_locked	
116	restore	restore_general_calendarevents	1
117	restore	restore_general_calendarevents_locked	
118	restore	restore_general_userscompletion	1
119	restore	restore_general_userscompletion_locked	
120	restore	restore_general_logs	1
121	restore	restore_general_logs_locked	
122	restore	restore_general_histories	1
123	restore	restore_general_histories_locked	
124	restore	restore_general_groups	1
125	restore	restore_general_groups_locked	
126	restore	restore_general_competencies	1
127	restore	restore_general_competencies_locked	
128	restore	restore_merge_overwrite_conf	0
129	restore	restore_merge_overwrite_conf_locked	
130	restore	restore_merge_course_fullname	1
131	restore	restore_merge_course_fullname_locked	
132	restore	restore_merge_course_shortname	1
133	restore	restore_merge_course_shortname_locked	
134	restore	restore_merge_course_startdate	1
135	restore	restore_merge_course_startdate_locked	
136	restore	restore_replace_overwrite_conf	0
137	restore	restore_replace_overwrite_conf_locked	
138	restore	restore_replace_course_fullname	1
139	restore	restore_replace_course_fullname_locked	
140	restore	restore_replace_course_shortname	1
141	restore	restore_replace_course_shortname_locked	
142	restore	restore_replace_course_startdate	1
143	restore	restore_replace_course_startdate_locked	
144	restore	restore_replace_keep_roles_and_enrolments	0
145	restore	restore_replace_keep_roles_and_enrolments_locked	
146	restore	restore_replace_keep_groups_and_groupings	0
147	restore	restore_replace_keep_groups_and_groupings_locked	
148	backup	backup_async_message_users	0
149	backup	backup_async_message_subject	Moodle {operation} completed successfully
150	backup	backup_async_message	Hi {user_firstname},<br/> Your {operation} (ID: {backupid}) has completed successfully. <br/><br/>You can access it here: {link}.
151	analytics	modeinstruction	
152	analytics	percentonline	0
153	analytics	typeinstitution	
154	analytics	levelinstitution	
155	analytics	predictionsprocessor	\\mlbackend_php\\processor
156	analytics	defaulttimesplittingsevaluation	\\core\\analytics\\time_splitting\\quarters_accum,\\core\\analytics\\time_splitting\\quarters,\\core\\analytics\\time_splitting\\single_range
157	analytics	modeloutputdir	/var/www/moodledata/models
158	analytics	onlycli	1
159	analytics	modeltimelimit	1200
160	core_competency	enabled	1
161	core_competency	pushcourseratingstouserplans	1
162	cachestore_apcu	testperformance	0
163	cachestore_memcached	testservers	
164	cachestore_mongodb	testserver	
165	cachestore_redis	test_server	
166	cachestore_redis	test_password	
167	question_preview	behaviour	deferredfeedback
168	question_preview	correctness	1
169	question_preview	marks	2
170	question_preview	markdp	2
171	question_preview	feedback	1
172	question_preview	generalfeedback	1
173	question_preview	rightanswer	1
174	question_preview	history	0
175	tool_task	enablerunnow	1
176	theme_boost	preset	default.scss
177	theme_boost	presetfiles	
178	theme_boost	backgroundimage	
179	theme_boost	brandcolor	
180	theme_boost	scsspre	
181	theme_boost	scss	
182	theme_classic	navbardark	0
183	theme_classic	preset	default.scss
184	theme_classic	presetfiles	
185	theme_classic	backgroundimage	
186	theme_classic	brandcolor	
187	theme_classic	scsspre	
188	theme_classic	scss	
189	theme_iomad	preset	default.scss
190	theme_iomad	presetfiles	
191	theme_iomad	backgroundimage	
192	theme_iomad	brandcolor	
193	theme_iomad	scsspre	
194	theme_iomad	scss	
195	theme_iomadboost	preset	default.scss
196	theme_iomadboost	presetfiles	
197	theme_iomadboost	backgroundimage	
198	theme_iomadboost	brandcolor	
199	theme_iomadboost	scsspre	
200	theme_iomadboost	scss	
201	theme_iomadbootstrap	navbardark	0
202	theme_iomadbootstrap	preset	default.scss
203	theme_iomadbootstrap	presetfiles	
204	theme_iomadbootstrap	backgroundimage	
205	theme_iomadbootstrap	brandcolor	
206	theme_iomadbootstrap	scsspre	
207	theme_iomadbootstrap	scss	
208	core_admin	logo	
209	core_admin	logocompact	
210	core_admin	coursecolor1	#81ecec
211	core_admin	coursecolor2	#74b9ff
212	core_admin	coursecolor3	#a29bfe
213	core_admin	coursecolor4	#dfe6e9
214	core_admin	coursecolor5	#00b894
215	core_admin	coursecolor6	#0984e3
216	core_admin	coursecolor7	#b2bec3
217	core_admin	coursecolor8	#fdcb6e
218	core_admin	coursecolor9	#fd79a8
219	core_admin	coursecolor10	#6c5ce7
220	antivirus_clamav	version	2019111800
221	availability_completion	version	2019111800
222	availability_date	version	2019111800
223	availability_grade	version	2019111800
224	availability_group	version	2019111800
225	availability_grouping	version	2019111800
226	availability_profile	version	2019111800
227	qtype_calculated	version	2019111800
228	qtype_calculatedmulti	version	2019111800
229	qtype_calculatedsimple	version	2019111800
230	qtype_ddimageortext	version	2019111800
231	qtype_ddmarker	version	2019111800
232	qtype_ddwtos	version	2019111800
233	qtype_description	version	2019111800
234	qtype_essay	version	2019111800
235	qtype_gapselect	version	2019111800
236	qtype_match	version	2019111800
237	qtype_missingtype	version	2019111800
238	qtype_multianswer	version	2019111800
239	qtype_multichoice	version	2019111800
240	qtype_numerical	version	2019111800
241	qtype_random	version	2019111800
242	qtype_randomsamatch	version	2019111800
243	qtype_shortanswer	version	2019111800
244	qtype_truefalse	version	2019111800
245	mod_assign	version	2019111800
246	mod_assignment	version	2019111800
248	mod_book	version	2019111800
249	mod_chat	version	2019111800
250	mod_choice	version	2019111800
251	mod_data	version	2019111800
252	mod_feedback	version	2019111800
254	mod_folder	version	2019111800
256	mod_forum	version	2019111801
257	mod_glossary	version	2019111800
258	mod_imscp	version	2019111800
260	mod_iomadcertificate	version	2016052300
261	mod_label	version	2019111800
262	mod_lesson	version	2019111800
263	mod_lti	version	2019111800
265	mod_lti	kid	89ebebd872628d0feb85
266	mod_lti	privatekey	-----BEGIN PRIVATE KEY-----\nMIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDKToqwaTFnZ2JD\nLLsH2ozmlk/EBHUUEmh0ApHyUpep+TmyapkV8vpR8STBLGDfEZaGjyTTFYlnT1c/\nbLitKnjzK7JtJgTr8X5nUShPhj10qQSuPBVO0Z0tidiR2T8JLEv5G9E1NLL7IoOU\n0tYAgHyrmy6lEu1xb6X4jwIXUlkU5DHK+qMB/KruMUIlKPH4F1bdJltC2Z3pnA5W\n/hseftPP16QnZd4bmNtJ6iKAhyOIn5v0MuyUudmQplWZHlknN0pHagSoG23r57y4\nKl47Jra0lh3kbdoMZO+QAs73lZcLndqYREuvOTHq2bZrCadAmq0GBC2s7x5DEBcq\n/Via0FaxAgMBAAECggEADwiDGdTXTP3LuX4rb8v3yHLG/qPuJ02u4WAHhGBK0OCq\nPu3Y7l6d51TqDEjF8g2Wh+0/KUhia4Dj1Ny5ZHTRhBBtM9stZnMNl5PaUP6CtpaQ\nuHnSg4bkDSw/IadpHb9i7eH5S+Dco/jOmlKIgIULvpzLfIzJhDJtvOizmRQPdpPU\ncZXJRqYF0Hc5Htb6aDewsSIqes5RFM9iFJOJn8GnFqQXz7VSaQBvc4hSZcrx32Fd\nCcNQxDv3a4FO9/uml2heL6dw4pgYUf6MNnxuXXN6u0NNNLnesgpBPzTl5Pq7CPNa\nf8G/tlrRsSdr8fzeEWOy0yUTwrUlfVK8HfQ6P6wJoQKBgQD9ur2DrkCuaxP6foDN\nJwyQ1jsgEibOgEhkrmcLVzGHkVJ9ai3yMu8QDsXtDgltKrf9TINBDIY6PjYyVI4T\nsqvXLCQ8jecWRcctphcE22h4nW3WYd5beG4Oo41H7KXBYFam+/pZwPkEUfdXTIie\nqyFXAcMJAI8+c1I1RbTROE8XvQKBgQDMHf/Ix4XsZqx+US2ZCAWS/naNqz4DScMp\nm63CiuNiTosewmphHZsoEMjZ+Z9EfXwmvmBfH6kTGgxXWJyKrrz9JUelTSSGN+bU\nZ4Pm/raO5inU6b660v6XQN+niRBs3iRubUf5tIEl7IMQFv8w1iSxOmdCVRDonjZK\nJt5VWLZgBQKBgAzsV/6+/1hi58+YZeMNHBy8bKKDiip2ajmGkIUJWeJ3ymXM5K4z\nXe3JctdSIbTHujtSjFTh2GxbAtOpbtsd/JanDuluqNh/kVeH4CBFNJsAGboTngm2\nppRkTCvfp8mjqIY0y1mK9KP9sMVnhoXeXYJa+p4YwzMBGKzR8hW98nlZAoGBALvY\ny+JiRMzHvO1PFhCkwkSCLGa6doqeIp6zJ9lG6nY5ZGz9bNtNXNIliEKaKMnmVhBt\n2dERGQ98RGlKIl666zBpU6M7+GYRIjzNuyUluqqOBWdtalsS/LwENxA+4r/ePFbn\n+XpDdSuKmx9+moG+QexcnFT+Zl495Caf2LNgvg5lAoGAJbI9DiepY5EIzQTrP+6m\n/+9glBUlZaHvQiXwSzdjh40aMYfYNTur7JcOpLrQE4awyuJDxj/RUfDG89xqf8kz\now4zLNdlc0AGndZbyu1slGXFuc5tNyV6IHDUSHRVngo9tWvpaIeLKVTyKYf/8wtH\neSnYKGGldJ5s0gctcEgGr6Y=\n-----END PRIVATE KEY-----\n
267	mod_page	version	2019111800
269	mod_quiz	version	2019111800
270	mod_resource	version	2019111800
271	mod_scorm	version	2019111800
272	mod_survey	version	2019111800
274	mod_trainingevent	version	2020052500
275	mod_url	version	2019111800
277	mod_wiki	version	2019111800
279	mod_workshop	version	2019111800
280	auth_cas	version	2019111800
282	auth_db	version	2019111800
284	auth_email	version	2019111800
285	auth_iomadoidc	version	2020020301
286	auth_ldap	version	2019111800
288	auth_lti	version	2019111800
289	auth_manual	version	2019111800
290	auth_mnet	version	2019111800
292	auth_nologin	version	2019111800
293	auth_none	version	2019111800
294	auth_oauth2	version	2019111800
295	auth_shibboleth	version	2019111800
297	auth_webservice	version	2019111800
298	calendartype_gregorian	version	2019111800
299	customfield_checkbox	version	2019111800
300	customfield_date	version	2019111800
301	customfield_select	version	2019111800
302	customfield_text	version	2019111800
303	customfield_textarea	version	2019111800
304	enrol_category	version	2019111800
306	enrol_cohort	version	2019111800
307	enrol_database	version	2019111800
309	enrol_flatfile	version	2019111800
311	enrol_flatfile	map_1	manager
312	enrol_flatfile	map_2	coursecreator
313	enrol_flatfile	map_3	editingteacher
314	enrol_flatfile	map_4	teacher
315	enrol_flatfile	map_5	student
316	enrol_flatfile	map_6	guest
317	enrol_flatfile	map_7	user
318	enrol_flatfile	map_8	frontpage
319	enrol_flatfile	map_9	clientadministrator
320	enrol_flatfile	map_10	companymanager
321	enrol_flatfile	map_11	companydepartmentmanager
322	enrol_flatfile	map_12	companycourseeditor
323	enrol_flatfile	map_13	companycoursenoneditor
324	enrol_flatfile	map_14	clientreporter
325	enrol_flatfile	map_15	companyreporter
326	enrol_guest	version	2019111800
327	enrol_imsenterprise	version	2019111800
329	enrol_ldap	version	2019111800
331	enrol_license	version	2019082300
333	enrol_lti	version	2019111800
334	enrol_manual	version	2019111800
336	enrol_meta	version	2019111800
338	enrol_mnet	version	2019111800
339	enrol_paypal	version	2019111800
340	enrol_self	version	2019111800
342	message_airnotifier	version	2019111800
344	message	airnotifier_provider_enrol_imsenterprise_imsenterprise_enrolment_permitted	permitted
345	message	airnotifier_provider_enrol_paypal_paypal_enrolment_permitted	permitted
346	message	airnotifier_provider_mod_feedback_submission_permitted	permitted
347	message	airnotifier_provider_mod_feedback_message_permitted	permitted
348	message	airnotifier_provider_enrol_manual_expiry_notification_permitted	permitted
349	message	airnotifier_provider_mod_quiz_submission_permitted	permitted
350	message	airnotifier_provider_mod_quiz_confirmation_permitted	permitted
353	message	airnotifier_provider_mod_quiz_attempt_overdue_permitted	permitted
356	message	airnotifier_provider_mod_lesson_graded_essay_permitted	permitted
359	message	airnotifier_provider_enrol_self_expiry_notification_permitted	permitted
360	message	airnotifier_provider_enrol_flatfile_flatfile_enrolment_permitted	permitted
361	message	airnotifier_provider_mod_assignment_assignment_updates_permitted	permitted
362	message	airnotifier_provider_mod_assign_assign_notification_permitted	permitted
363	message	airnotifier_provider_moodle_notices_permitted	permitted
364	message	airnotifier_provider_moodle_errors_permitted	permitted
365	message	airnotifier_provider_moodle_availableupdate_permitted	permitted
366	message	airnotifier_provider_moodle_instantmessage_permitted	permitted
367	message	airnotifier_provider_moodle_backup_permitted	permitted
368	message	airnotifier_provider_moodle_courserequested_permitted	permitted
369	message	airnotifier_provider_moodle_courserequestapproved_permitted	permitted
372	message	airnotifier_provider_moodle_courserequestrejected_permitted	permitted
375	message	airnotifier_provider_moodle_badgerecipientnotice_permitted	permitted
378	message	airnotifier_provider_moodle_badgecreatornotice_permitted	permitted
379	message	airnotifier_provider_moodle_competencyplancomment_permitted	permitted
380	message	airnotifier_provider_moodle_competencyusercompcomment_permitted	permitted
381	message	airnotifier_provider_moodle_insights_permitted	permitted
384	message	airnotifier_provider_moodle_messagecontactrequests_permitted	permitted
385	message	message_provider_moodle_messagecontactrequests_loggedin	airnotifier
387	message	airnotifier_provider_moodle_asyncbackupnotification_permitted	permitted
388	message	airnotifier_provider_moodle_gradenotifications_permitted	permitted
389	message	airnotifier_provider_mod_forum_posts_permitted	permitted
392	message	airnotifier_provider_mod_forum_digests_permitted	permitted
393	message_email	version	2019111800
395	message	email_provider_enrol_imsenterprise_imsenterprise_enrolment_permitted	permitted
396	message	message_provider_enrol_imsenterprise_imsenterprise_enrolment_loggedin	email
397	message	message_provider_enrol_imsenterprise_imsenterprise_enrolment_loggedoff	email
398	message	email_provider_enrol_paypal_paypal_enrolment_permitted	permitted
399	message	message_provider_enrol_paypal_paypal_enrolment_loggedin	email
400	message	message_provider_enrol_paypal_paypal_enrolment_loggedoff	email
401	message	email_provider_mod_feedback_submission_permitted	permitted
402	message	message_provider_mod_feedback_submission_loggedin	email
403	message	message_provider_mod_feedback_submission_loggedoff	email
404	message	email_provider_mod_feedback_message_permitted	permitted
405	message	message_provider_mod_feedback_message_loggedin	email
406	message	message_provider_mod_feedback_message_loggedoff	email
376	message	message_provider_moodle_badgerecipientnotice_loggedin	popup,airnotifier
382	message	message_provider_moodle_insights_loggedin	popup,airnotifier
407	message	email_provider_enrol_manual_expiry_notification_permitted	permitted
408	message	message_provider_enrol_manual_expiry_notification_loggedin	email
409	message	message_provider_enrol_manual_expiry_notification_loggedoff	email
410	message	email_provider_mod_quiz_submission_permitted	permitted
411	message	message_provider_mod_quiz_submission_loggedin	email
412	message	message_provider_mod_quiz_submission_loggedoff	email
413	message	email_provider_mod_quiz_confirmation_permitted	permitted
351	message	message_provider_mod_quiz_confirmation_loggedin	email,airnotifier
352	message	message_provider_mod_quiz_confirmation_loggedoff	email,airnotifier
414	message	email_provider_mod_quiz_attempt_overdue_permitted	permitted
354	message	message_provider_mod_quiz_attempt_overdue_loggedin	email,airnotifier
355	message	message_provider_mod_quiz_attempt_overdue_loggedoff	email,airnotifier
415	message	email_provider_mod_lesson_graded_essay_permitted	permitted
357	message	message_provider_mod_lesson_graded_essay_loggedin	email,airnotifier
358	message	message_provider_mod_lesson_graded_essay_loggedoff	email,airnotifier
416	message	email_provider_enrol_self_expiry_notification_permitted	permitted
417	message	message_provider_enrol_self_expiry_notification_loggedin	email
418	message	message_provider_enrol_self_expiry_notification_loggedoff	email
419	message	email_provider_enrol_flatfile_flatfile_enrolment_permitted	permitted
420	message	message_provider_enrol_flatfile_flatfile_enrolment_loggedin	email
421	message	message_provider_enrol_flatfile_flatfile_enrolment_loggedoff	email
422	message	email_provider_mod_assignment_assignment_updates_permitted	permitted
423	message	message_provider_mod_assignment_assignment_updates_loggedin	email
424	message	message_provider_mod_assignment_assignment_updates_loggedoff	email
425	message	email_provider_mod_assign_assign_notification_permitted	permitted
426	message	message_provider_mod_assign_assign_notification_loggedin	email
427	message	message_provider_mod_assign_assign_notification_loggedoff	email
428	message	email_provider_moodle_notices_permitted	permitted
429	message	message_provider_moodle_notices_loggedin	email
430	message	message_provider_moodle_notices_loggedoff	email
431	message	email_provider_moodle_errors_permitted	permitted
432	message	message_provider_moodle_errors_loggedin	email
433	message	message_provider_moodle_errors_loggedoff	email
434	message	email_provider_moodle_availableupdate_permitted	permitted
435	message	message_provider_moodle_availableupdate_loggedin	email
436	message	message_provider_moodle_availableupdate_loggedoff	email
437	message	email_provider_moodle_instantmessage_permitted	permitted
439	message	email_provider_moodle_backup_permitted	permitted
440	message	message_provider_moodle_backup_loggedin	email
441	message	message_provider_moodle_backup_loggedoff	email
442	message	email_provider_moodle_courserequested_permitted	permitted
443	message	message_provider_moodle_courserequested_loggedin	email
444	message	message_provider_moodle_courserequested_loggedoff	email
445	message	email_provider_moodle_courserequestapproved_permitted	permitted
370	message	message_provider_moodle_courserequestapproved_loggedin	email,airnotifier
371	message	message_provider_moodle_courserequestapproved_loggedoff	email,airnotifier
446	message	email_provider_moodle_courserequestrejected_permitted	permitted
373	message	message_provider_moodle_courserequestrejected_loggedin	email,airnotifier
374	message	message_provider_moodle_courserequestrejected_loggedoff	email,airnotifier
447	message	email_provider_moodle_badgerecipientnotice_permitted	permitted
448	message	email_provider_moodle_badgecreatornotice_permitted	permitted
449	message	message_provider_moodle_badgecreatornotice_loggedoff	email
450	message	email_provider_moodle_competencyplancomment_permitted	permitted
451	message	message_provider_moodle_competencyplancomment_loggedin	email
452	message	message_provider_moodle_competencyplancomment_loggedoff	email
453	message	email_provider_moodle_competencyusercompcomment_permitted	permitted
454	message	message_provider_moodle_competencyusercompcomment_loggedin	email
455	message	message_provider_moodle_competencyusercompcomment_loggedoff	email
456	message	email_provider_moodle_insights_permitted	permitted
457	message	email_provider_moodle_messagecontactrequests_permitted	permitted
386	message	message_provider_moodle_messagecontactrequests_loggedoff	email,airnotifier
458	message	email_provider_moodle_asyncbackupnotification_permitted	permitted
460	message	email_provider_moodle_gradenotifications_permitted	permitted
462	message	email_provider_mod_forum_posts_permitted	permitted
390	message	message_provider_mod_forum_posts_loggedin	email,airnotifier
391	message	message_provider_mod_forum_posts_loggedoff	email,airnotifier
463	message	email_provider_mod_forum_digests_permitted	permitted
464	message	message_provider_mod_forum_digests_loggedin	email
465	message	message_provider_mod_forum_digests_loggedoff	email
466	message_jabber	version	2019111800
468	message	jabber_provider_enrol_imsenterprise_imsenterprise_enrolment_permitted	permitted
469	message	jabber_provider_enrol_paypal_paypal_enrolment_permitted	permitted
470	message	jabber_provider_mod_feedback_submission_permitted	permitted
471	message	jabber_provider_mod_feedback_message_permitted	permitted
472	message	jabber_provider_enrol_manual_expiry_notification_permitted	permitted
473	message	jabber_provider_mod_quiz_submission_permitted	permitted
474	message	jabber_provider_mod_quiz_confirmation_permitted	permitted
475	message	jabber_provider_mod_quiz_attempt_overdue_permitted	permitted
476	message	jabber_provider_mod_lesson_graded_essay_permitted	permitted
477	message	jabber_provider_enrol_self_expiry_notification_permitted	permitted
478	message	jabber_provider_enrol_flatfile_flatfile_enrolment_permitted	permitted
479	message	jabber_provider_mod_assignment_assignment_updates_permitted	permitted
480	message	jabber_provider_mod_assign_assign_notification_permitted	permitted
481	message	jabber_provider_moodle_notices_permitted	permitted
482	message	jabber_provider_moodle_errors_permitted	permitted
483	message	jabber_provider_moodle_availableupdate_permitted	permitted
484	message	jabber_provider_moodle_instantmessage_permitted	permitted
485	message	jabber_provider_moodle_backup_permitted	permitted
486	message	jabber_provider_moodle_courserequested_permitted	permitted
487	message	jabber_provider_moodle_courserequestapproved_permitted	permitted
488	message	jabber_provider_moodle_courserequestrejected_permitted	permitted
489	message	jabber_provider_moodle_badgerecipientnotice_permitted	permitted
490	message	jabber_provider_moodle_badgecreatornotice_permitted	permitted
491	message	jabber_provider_moodle_competencyplancomment_permitted	permitted
492	message	jabber_provider_moodle_competencyusercompcomment_permitted	permitted
493	message	jabber_provider_moodle_insights_permitted	permitted
494	message	jabber_provider_moodle_messagecontactrequests_permitted	permitted
495	message	jabber_provider_moodle_asyncbackupnotification_permitted	permitted
496	message	jabber_provider_moodle_gradenotifications_permitted	permitted
497	message	jabber_provider_mod_forum_posts_permitted	permitted
498	message	jabber_provider_mod_forum_digests_permitted	permitted
499	message_popup	version	2019111800
501	message	popup_provider_enrol_imsenterprise_imsenterprise_enrolment_permitted	permitted
502	message	popup_provider_enrol_paypal_paypal_enrolment_permitted	permitted
503	message	popup_provider_mod_feedback_submission_permitted	permitted
504	message	popup_provider_mod_feedback_message_permitted	permitted
505	message	popup_provider_enrol_manual_expiry_notification_permitted	permitted
506	message	popup_provider_mod_quiz_submission_permitted	permitted
507	message	popup_provider_mod_quiz_confirmation_permitted	permitted
508	message	popup_provider_mod_quiz_attempt_overdue_permitted	permitted
509	message	popup_provider_mod_lesson_graded_essay_permitted	permitted
510	message	popup_provider_enrol_self_expiry_notification_permitted	permitted
511	message	popup_provider_enrol_flatfile_flatfile_enrolment_permitted	permitted
512	message	popup_provider_mod_assignment_assignment_updates_permitted	permitted
513	message	popup_provider_mod_assign_assign_notification_permitted	permitted
514	message	popup_provider_moodle_notices_permitted	permitted
515	message	popup_provider_moodle_errors_permitted	permitted
516	message	popup_provider_moodle_availableupdate_permitted	permitted
517	message	popup_provider_moodle_instantmessage_permitted	permitted
518	message	message_provider_moodle_instantmessage_loggedin	popup
438	message	message_provider_moodle_instantmessage_loggedoff	popup,email
519	message	popup_provider_moodle_backup_permitted	permitted
520	message	popup_provider_moodle_courserequested_permitted	permitted
521	message	popup_provider_moodle_courserequestapproved_permitted	permitted
522	message	popup_provider_moodle_courserequestrejected_permitted	permitted
523	message	popup_provider_moodle_badgerecipientnotice_permitted	permitted
377	message	message_provider_moodle_badgerecipientnotice_loggedoff	popup,email,airnotifier
524	message	popup_provider_moodle_badgecreatornotice_permitted	permitted
525	message	popup_provider_moodle_competencyplancomment_permitted	permitted
526	message	popup_provider_moodle_competencyusercompcomment_permitted	permitted
527	message	popup_provider_moodle_insights_permitted	permitted
383	message	message_provider_moodle_insights_loggedoff	popup,email,airnotifier
528	message	popup_provider_moodle_messagecontactrequests_permitted	permitted
529	message	popup_provider_moodle_asyncbackupnotification_permitted	permitted
530	message	message_provider_moodle_asyncbackupnotification_loggedin	popup
459	message	message_provider_moodle_asyncbackupnotification_loggedoff	popup,email
531	message	popup_provider_moodle_gradenotifications_permitted	permitted
532	message	message_provider_moodle_gradenotifications_loggedin	popup
461	message	message_provider_moodle_gradenotifications_loggedoff	popup,email
533	message	popup_provider_mod_forum_posts_permitted	permitted
534	message	popup_provider_mod_forum_digests_permitted	permitted
535	block_activity_modules	version	2019111800
536	block_activity_results	version	2019111800
537	block_admin_bookmarks	version	2019111800
538	block_badges	version	2019111800
539	block_blog_menu	version	2019111800
540	block_blog_recent	version	2019111800
541	block_blog_tags	version	2019111800
542	block_calendar_month	version	2019111800
543	block_calendar_upcoming	version	2019111800
544	block_comments	version	2019111800
545	block_completionstatus	version	2019111800
546	block_course_list	version	2019111800
547	block_course_summary	version	2019111800
548	block_feedback	version	2019111800
550	block_globalsearch	version	2019111800
551	block_glossary_random	version	2019111800
552	block_html	version	2019111800
553	block_iomad_approve_access	version	2020052500
555	block_iomad_commerce	version	2017030702
556	block_iomad_company_admin	version	2020050700
558	block_iomad_company_selector	version	2016083100
559	block_iomad_html	version	2016111400
560	block_iomad_learningpath	version	2018032600
561	block_iomad_link	version	2016083100
563	block_iomad_microlearning	version	2019120800
564	block_iomad_onlineusers	version	2016083100
565	block_iomad_progress	version	2016091800
566	block_iomad_reports	version	2016083100
567	block_iomad_welcome	version	2017020100
568	block_login	version	2019111800
569	block_lp	version	2019111800
570	block_mentees	version	2019111800
571	block_mnet_hosts	version	2019111800
572	block_mycourses	version	2015051502
574	block_myoverview	version	2019111800
575	block_myprofile	version	2019111800
576	block_navigation	version	2019111800
577	block_news_items	version	2019111800
578	block_online_users	version	2019111800
579	block_private_files	version	2019111800
580	block_quiz_results	version	2019111800
582	block_recent_activity	version	2019111800
583	block_recentlyaccessedcourses	version	2019111800
585	block_recentlyaccesseditems	version	2019111800
586	block_rss_client	version	2019111800
587	block_search_forums	version	2019111800
588	block_section_links	version	2019111800
589	block_selfcompletion	version	2019111800
590	block_settings	version	2019111800
591	block_site_main_menu	version	2019111800
592	block_social_activities	version	2019111800
593	block_starredcourses	version	2019111800
594	block_tag_flickr	version	2019111800
595	block_tag_youtube	version	2019111800
597	block_tags	version	2019111800
598	block_timeline	version	2019111800
600	media_html5audio	version	2019111800
601	media_html5video	version	2019111800
602	media_swf	version	2019111800
603	media_videojs	version	2019111800
604	media_vimeo	version	2019111800
605	media_youtube	version	2019111800
606	filter_activitynames	version	2019111800
608	filter_algebra	version	2019111800
609	filter_censor	version	2019111800
610	filter_data	version	2019111800
612	filter_displayh5p	version	2020031700
614	filter_emailprotect	version	2019111800
615	filter_emoticon	version	2019111800
616	filter_glossary	version	2019111800
618	filter_mathjaxloader	version	2019111801
620	filter_mediaplugin	version	2019111800
622	filter_multilang	version	2019111800
623	filter_tex	version	2019111800
625	filter_tidy	version	2019111800
626	filter_urltolink	version	2019111800
627	editor_atto	version	2019111800
629	editor_textarea	version	2019111800
630	editor_tinymce	version	2019111800
631	format_singleactivity	version	2019111800
632	format_social	version	2019111800
633	format_topics	version	2019111800
634	format_weeks	version	2019111800
635	dataformat_csv	version	2019111800
636	dataformat_excel	version	2019111800
637	dataformat_html	version	2019111800
638	dataformat_json	version	2019111800
639	dataformat_ods	version	2019111800
640	dataformat_pdf	version	2019111800
641	profilefield_checkbox	version	2019111800
642	profilefield_datetime	version	2019111800
643	profilefield_menu	version	2019111800
644	profilefield_text	version	2019111800
645	profilefield_textarea	version	2019111800
646	report_backups	version	2019111800
647	report_competency	version	2019111800
648	report_completion	version	2019111800
650	report_configlog	version	2019111800
651	report_courseoverview	version	2019111800
652	report_eventlist	version	2019111800
653	report_insights	version	2019111800
654	report_log	version	2019111800
656	report_loglive	version	2019111800
657	report_outline	version	2019111800
659	report_participation	version	2019111800
661	report_performance	version	2019111800
662	report_progress	version	2019111800
664	report_questioninstances	version	2019111800
665	report_security	version	2019111800
666	report_stats	version	2019111800
668	report_usersessions	version	2019111800
669	gradeexport_ods	version	2019111800
670	gradeexport_txt	version	2019111800
671	gradeexport_xls	version	2019111800
672	gradeexport_xml	version	2019111800
673	gradeimport_csv	version	2019111800
674	gradeimport_direct	version	2019111800
675	gradeimport_xml	version	2019111800
676	gradereport_grader	version	2019111800
677	gradereport_history	version	2019111801
678	gradereport_outcomes	version	2019111800
679	gradereport_overview	version	2019111800
680	gradereport_singleview	version	2019111800
681	gradereport_user	version	2019111800
682	gradingform_guide	version	2019111800
683	gradingform_rubric	version	2019111800
684	mlbackend_php	version	2019111800
685	mlbackend_python	version	2019111800
686	mnetservice_enrol	version	2019111800
687	webservice_rest	version	2019111800
688	webservice_soap	version	2019111800
689	webservice_xmlrpc	version	2019111800
690	repository_areafiles	version	2019111800
692	areafiles	enablecourseinstances	0
693	areafiles	enableuserinstances	0
694	repository_boxnet	version	2019111800
695	repository_coursefiles	version	2019111800
696	repository_dropbox	version	2019111800
697	repository_equella	version	2019111800
698	repository_filesystem	version	2019111800
699	repository_flickr	version	2019111800
700	repository_flickr_public	version	2019111800
701	repository_googledocs	version	2019111800
702	repository_local	version	2019111800
704	local	enablecourseinstances	0
705	local	enableuserinstances	0
706	repository_merlot	version	2019111800
707	repository_nextcloud	version	2019111800
708	repository_onedrive	version	2019111800
709	repository_picasa	version	2019111800
710	repository_recent	version	2019111800
712	recent	enablecourseinstances	0
713	recent	enableuserinstances	0
714	repository_s3	version	2019111800
715	repository_skydrive	version	2019111800
716	repository_upload	version	2019111800
718	upload	enablecourseinstances	0
719	upload	enableuserinstances	0
720	repository_url	version	2019111800
722	url	enablecourseinstances	0
723	url	enableuserinstances	0
724	repository_user	version	2019111800
726	user	enablecourseinstances	0
727	user	enableuserinstances	0
728	repository_webdav	version	2019111800
729	repository_wikimedia	version	2019111800
731	wikimedia	enablecourseinstances	0
732	wikimedia	enableuserinstances	0
733	repository_youtube	version	2019111800
735	portfolio_boxnet	version	2019111800
736	portfolio_download	version	2019111800
737	portfolio_flickr	version	2019111800
738	portfolio_googledocs	version	2019111800
739	portfolio_mahara	version	2019111800
740	portfolio_picasa	version	2019111800
741	search_simpledb	version	2019111800
743	search_solr	version	2019111800
744	qbehaviour_adaptive	version	2019111800
745	qbehaviour_adaptivenopenalty	version	2019111800
746	qbehaviour_deferredcbm	version	2019111800
747	qbehaviour_deferredfeedback	version	2019111800
748	qbehaviour_immediatecbm	version	2019111800
749	qbehaviour_immediatefeedback	version	2019111800
750	qbehaviour_informationitem	version	2019111800
751	qbehaviour_interactive	version	2019111800
752	qbehaviour_interactivecountback	version	2019111800
753	qbehaviour_manualgraded	version	2019111800
755	question	disabledbehaviours	manualgraded
756	qbehaviour_missing	version	2019111800
757	qformat_aiken	version	2019111800
758	qformat_blackboard_six	version	2019111800
759	qformat_examview	version	2019111800
760	qformat_gift	version	2019111800
761	qformat_missingword	version	2019111800
762	qformat_multianswer	version	2019111800
763	qformat_webct	version	2019111800
764	qformat_xhtml	version	2019111800
765	qformat_xml	version	2019111800
766	tool_analytics	version	2019111800
767	tool_availabilityconditions	version	2019111800
768	tool_behat	version	2019111800
769	tool_capability	version	2019111800
770	tool_checklearningrecords	version	2020043000
772	tool_cohortroles	version	2019111801
773	tool_customlang	version	2019111800
775	tool_dataprivacy	version	2019111801
776	message	airnotifier_provider_tool_dataprivacy_contactdataprotectionofficer_permitted	permitted
777	message	email_provider_tool_dataprivacy_contactdataprotectionofficer_permitted	permitted
778	message	jabber_provider_tool_dataprivacy_contactdataprotectionofficer_permitted	permitted
779	message	popup_provider_tool_dataprivacy_contactdataprotectionofficer_permitted	permitted
780	message	message_provider_tool_dataprivacy_contactdataprotectionofficer_loggedin	email,popup
781	message	message_provider_tool_dataprivacy_contactdataprotectionofficer_loggedoff	email,popup
782	message	airnotifier_provider_tool_dataprivacy_datarequestprocessingresults_permitted	permitted
783	message	email_provider_tool_dataprivacy_datarequestprocessingresults_permitted	permitted
784	message	jabber_provider_tool_dataprivacy_datarequestprocessingresults_permitted	permitted
785	message	popup_provider_tool_dataprivacy_datarequestprocessingresults_permitted	permitted
786	message	message_provider_tool_dataprivacy_datarequestprocessingresults_loggedin	email,popup
787	message	message_provider_tool_dataprivacy_datarequestprocessingresults_loggedoff	email,popup
788	message	airnotifier_provider_tool_dataprivacy_notifyexceptions_permitted	permitted
789	message	email_provider_tool_dataprivacy_notifyexceptions_permitted	permitted
790	message	jabber_provider_tool_dataprivacy_notifyexceptions_permitted	permitted
791	message	popup_provider_tool_dataprivacy_notifyexceptions_permitted	permitted
792	message	message_provider_tool_dataprivacy_notifyexceptions_loggedin	email
793	message	message_provider_tool_dataprivacy_notifyexceptions_loggedoff	email
794	tool_dbtransfer	version	2019111800
795	tool_filetypes	version	2019111800
796	tool_generator	version	2019111800
797	tool_health	version	2019111800
798	tool_httpsreplace	version	2019111800
799	tool_innodb	version	2019111800
800	tool_installaddon	version	2019111800
801	tool_iomadmerge	version	2017060801
802	tool_iomadsite	version	2018031000
803	tool_langimport	version	2019111800
804	tool_log	version	2019111800
806	tool_log	enabled_stores	logstore_standard
807	tool_lp	version	2019111800
808	tool_lpimportcsv	version	2019111800
809	tool_lpmigrate	version	2019111800
810	tool_messageinbound	version	2019111800
811	message	airnotifier_provider_tool_messageinbound_invalidrecipienthandler_permitted	permitted
812	message	email_provider_tool_messageinbound_invalidrecipienthandler_permitted	permitted
813	message	jabber_provider_tool_messageinbound_invalidrecipienthandler_permitted	permitted
814	message	popup_provider_tool_messageinbound_invalidrecipienthandler_permitted	permitted
815	message	message_provider_tool_messageinbound_invalidrecipienthandler_loggedin	email
816	message	message_provider_tool_messageinbound_invalidrecipienthandler_loggedoff	email
817	message	airnotifier_provider_tool_messageinbound_messageprocessingerror_permitted	permitted
818	message	email_provider_tool_messageinbound_messageprocessingerror_permitted	permitted
819	message	jabber_provider_tool_messageinbound_messageprocessingerror_permitted	permitted
820	message	popup_provider_tool_messageinbound_messageprocessingerror_permitted	permitted
821	message	message_provider_tool_messageinbound_messageprocessingerror_loggedin	email
822	message	message_provider_tool_messageinbound_messageprocessingerror_loggedoff	email
823	message	airnotifier_provider_tool_messageinbound_messageprocessingsuccess_permitted	permitted
824	message	email_provider_tool_messageinbound_messageprocessingsuccess_permitted	permitted
825	message	jabber_provider_tool_messageinbound_messageprocessingsuccess_permitted	permitted
826	message	popup_provider_tool_messageinbound_messageprocessingsuccess_permitted	permitted
827	message	message_provider_tool_messageinbound_messageprocessingsuccess_loggedin	email
828	message	message_provider_tool_messageinbound_messageprocessingsuccess_loggedoff	email
829	tool_mobile	version	2019111800
830	tool_monitor	version	2019111800
831	message	airnotifier_provider_tool_monitor_notification_permitted	permitted
832	message	email_provider_tool_monitor_notification_permitted	permitted
833	message	jabber_provider_tool_monitor_notification_permitted	permitted
834	message	popup_provider_tool_monitor_notification_permitted	permitted
835	message	message_provider_tool_monitor_notification_loggedin	email
836	message	message_provider_tool_monitor_notification_loggedoff	email
837	tool_multilangupgrade	version	2019111800
838	tool_oauth2	version	2019111800
839	tool_phpunit	version	2019111800
840	tool_policy	version	2019111800
841	tool_profiling	version	2019111800
842	tool_recyclebin	version	2019111800
843	tool_redocerts	version	2019051400
844	tool_replace	version	2019111800
845	tool_spamcleaner	version	2019111800
846	tool_task	version	2019111800
847	tool_templatelibrary	version	2019111800
848	tool_unsuproles	version	2019111800
850	tool_uploadcourse	version	2019111800
851	tool_uploaduser	version	2019111800
852	tool_usertours	version	2019111801
854	tool_xmldb	version	2019111800
855	cachestore_apcu	version	2019111800
856	cachestore_file	version	2019111800
857	cachestore_memcached	version	2019111800
858	cachestore_mongodb	version	2019111800
859	cachestore_redis	version	2019111800
860	cachestore_session	version	2019111800
861	cachestore_static	version	2019111800
862	cachelock_file	version	2019111800
863	fileconverter_googledrive	version	2019111800
864	fileconverter_unoconv	version	2019111800
866	theme_boost	version	2019111800
867	theme_classic	version	2019111800
868	theme_iomad	version	2019111800
869	theme_iomadboost	version	2019111800
870	theme_iomadbootstrap	version	2019111800
871	local_course_selector	version	2010121500
872	local_email	version	2020042100
873	local_email_reports	version	2016040601
874	local_framework_selector	version	2016083100
875	local_iomad	version	2019030113
877	local_iomad_learningpath	version	2019040500
878	local_iomad_settings	version	2019022701
879	local_iomad_signup	version	2016090301
880	local_iomad_track	version	2020051900
882	local_report_attendance	version	2016120600
883	local_report_companies	version	2019010900
884	local_report_completion	version	2016120600
885	local_report_completion_monthly	version	2019012100
886	local_report_emails	version	2019012101
887	local_report_license_usage	version	2019012100
888	local_report_user_license_allocations	version	2019012100
890	local_report_user_logins	version	2019012100
892	local_report_users	version	2020042400
893	local_template_selector	version	2016083100
894	assignsubmission_comments	version	2019111800
953	quizaccess_password	version	2019111800
954	quizaccess_safebrowser	version	2019111800
955	quizaccess_securewindow	version	2019111800
899	assignsubmission_file	version	2019111800
900	assignsubmission_onlinetext	version	2019111800
956	quizaccess_timelimit	version	2019111800
957	scormreport_basic	version	2019111800
958	scormreport_graphs	version	2019111800
898	assignsubmission_onlinetext	sortorder	0
896	assignsubmission_file	sortorder	1
897	assignsubmission_comments	sortorder	2
902	assignfeedback_comments	version	2019111800
908	assignfeedback_editpdf	version	2019111800
910	assignfeedback_file	version	2019111800
904	assignfeedback_comments	sortorder	0
905	assignfeedback_editpdf	sortorder	1
907	assignfeedback_offline	sortorder	2
906	assignfeedback_file	sortorder	3
912	assignfeedback_offline	version	2019111800
913	assignment_offline	version	2019111800
914	assignment_online	version	2019111800
915	assignment_upload	version	2019111800
916	assignment_uploadsingle	version	2019111800
917	booktool_exportimscp	version	2019111800
918	booktool_importhtml	version	2019111800
919	booktool_print	version	2019111800
920	datafield_checkbox	version	2019111800
921	datafield_date	version	2019111800
922	datafield_file	version	2019111800
923	datafield_latlong	version	2019111800
924	datafield_menu	version	2019111800
925	datafield_multimenu	version	2019111800
926	datafield_number	version	2019111800
927	datafield_picture	version	2019111800
928	datafield_radiobutton	version	2019111800
929	datafield_text	version	2019111800
930	datafield_textarea	version	2019111800
931	datafield_url	version	2019111800
932	datapreset_imagegallery	version	2019111800
933	forumreport_summary	version	2019111800
934	ltiservice_basicoutcomes	version	2019111800
935	ltiservice_gradebookservices	version	2019111800
936	ltiservice_memberships	version	2019111800
937	ltiservice_profile	version	2019111800
938	ltiservice_toolproxy	version	2019111800
939	ltiservice_toolsettings	version	2019111800
940	quiz_grading	version	2019111800
942	quiz_overview	version	2019111800
944	quiz_responses	version	2019111800
946	quiz_statistics	version	2019111800
948	quizaccess_delaybetweenattempts	version	2019111800
949	quizaccess_ipaddress	version	2019111800
950	quizaccess_numattempts	version	2019111800
951	quizaccess_offlineattempts	version	2019111800
952	quizaccess_openclosedate	version	2019111800
959	scormreport_interactions	version	2019111800
960	scormreport_objectives	version	2019111800
961	workshopform_accumulative	version	2019111800
963	workshopform_comments	version	2019111800
965	workshopform_numerrors	version	2019111800
967	workshopform_rubric	version	2019111800
969	workshopallocation_manual	version	2019111800
970	workshopallocation_random	version	2019111800
971	workshopallocation_scheduled	version	2019111800
972	workshopeval_best	version	2019111800
973	atto_accessibilitychecker	version	2019111800
974	atto_accessibilityhelper	version	2019111800
975	atto_align	version	2019111800
976	atto_backcolor	version	2019111800
977	atto_bold	version	2019111800
978	atto_charmap	version	2019111800
979	atto_clear	version	2019111800
980	atto_collapse	version	2019111800
981	atto_emojipicker	version	2019111800
982	atto_emoticon	version	2019111800
983	atto_equation	version	2019111800
984	atto_fontcolor	version	2019111800
985	atto_h5p	version	2019111800
986	atto_html	version	2019111800
987	atto_image	version	2019111800
988	atto_indent	version	2019111800
989	atto_italic	version	2019111800
990	atto_link	version	2019111800
991	atto_managefiles	version	2019111800
992	atto_media	version	2019111800
993	atto_noautolink	version	2019111800
994	atto_orderedlist	version	2019111800
995	atto_recordrtc	version	2019111800
996	atto_rtl	version	2019111800
997	atto_strike	version	2019111800
998	atto_subscript	version	2019111800
999	atto_superscript	version	2019111800
1000	atto_table	version	2019111800
1001	atto_title	version	2019111800
1002	atto_underline	version	2019111800
1003	atto_undo	version	2019111800
1004	atto_unorderedlist	version	2019111800
1005	tinymce_ctrlhelp	version	2019111800
1006	tinymce_managefiles	version	2019111800
1007	tinymce_moodleemoticon	version	2019111800
1008	tinymce_moodleimage	version	2019111800
1009	tinymce_moodlemedia	version	2019111800
1010	tinymce_moodlenolink	version	2019111800
1011	tinymce_pdw	version	2019111800
1012	tinymce_spellchecker	version	2019111800
1014	tinymce_wrap	version	2019111800
1015	logstore_database	version	2019111800
1016	logstore_legacy	version	2019111800
1017	logstore_standard	version	2019111800
1018	tool_dataprivacy	contactdataprotectionofficer	0
1019	tool_dataprivacy	automaticdeletionrequests	1
1020	tool_dataprivacy	privacyrequestexpiry	604800
1021	tool_dataprivacy	requireallenddatesforuserdeletion	1
1022	tool_dataprivacy	showdataretentionsummary	1
1023	tool_log	exportlog	1
1024	analytics	logstore	logstore_standard
1025	assign	feedback_plugin_for_gradebook	assignfeedback_comments
1026	assign	showrecentsubmissions	0
1027	assign	submissionreceipts	1
1028	assign	submissionstatement	This submission is my own work, except where I have acknowledged the use of the works of other people.
1029	assign	submissionstatementteamsubmission	This submission is the work of my group, except where we have acknowledged the use of the works of other people.
1030	assign	submissionstatementteamsubmissionallsubmit	This submission is my own work as a group member, except where I have acknowledged the use of the works of other people.
1031	assign	maxperpage	-1
1032	assign	alwaysshowdescription	1
1033	assign	alwaysshowdescription_adv	
1034	assign	alwaysshowdescription_locked	
1035	assign	allowsubmissionsfromdate	0
1036	assign	allowsubmissionsfromdate_enabled	1
1037	assign	allowsubmissionsfromdate_adv	
1038	assign	duedate	604800
1039	assign	duedate_enabled	1
1040	assign	duedate_adv	
1041	assign	cutoffdate	1209600
1042	assign	cutoffdate_enabled	
1043	assign	cutoffdate_adv	
1044	assign	gradingduedate	1209600
1045	assign	gradingduedate_enabled	1
1046	assign	gradingduedate_adv	
1047	assign	submissiondrafts	0
1048	assign	submissiondrafts_adv	
1049	assign	submissiondrafts_locked	
1050	assign	requiresubmissionstatement	0
1051	assign	requiresubmissionstatement_adv	
1052	assign	requiresubmissionstatement_locked	
1053	assign	attemptreopenmethod	none
1054	assign	attemptreopenmethod_adv	
1055	assign	attemptreopenmethod_locked	
1056	assign	maxattempts	-1
1057	assign	maxattempts_adv	
1058	assign	maxattempts_locked	
1059	assign	teamsubmission	0
1060	assign	teamsubmission_adv	
1061	assign	teamsubmission_locked	
1062	assign	preventsubmissionnotingroup	0
1063	assign	preventsubmissionnotingroup_adv	
1064	assign	preventsubmissionnotingroup_locked	
1065	assign	requireallteammemberssubmit	0
1066	assign	requireallteammemberssubmit_adv	
1067	assign	requireallteammemberssubmit_locked	
1068	assign	teamsubmissiongroupingid	
1069	assign	teamsubmissiongroupingid_adv	
1070	assign	sendnotifications	0
1071	assign	sendnotifications_adv	
1072	assign	sendnotifications_locked	
1073	assign	sendlatenotifications	0
1074	assign	sendlatenotifications_adv	
1075	assign	sendlatenotifications_locked	
1076	assign	sendstudentnotifications	1
1077	assign	sendstudentnotifications_adv	
1078	assign	sendstudentnotifications_locked	
1079	assign	blindmarking	0
1080	assign	blindmarking_adv	
1081	assign	blindmarking_locked	
1082	assign	hidegrader	0
1083	assign	hidegrader_adv	
1084	assign	hidegrader_locked	
1085	assign	markingworkflow	0
1086	assign	markingworkflow_adv	
1087	assign	markingworkflow_locked	
1088	assign	markingallocation	0
1089	assign	markingallocation_adv	
1090	assign	markingallocation_locked	
1091	assignsubmission_file	default	1
1092	assignsubmission_file	maxfiles	20
1093	assignsubmission_file	filetypes	
1094	assignsubmission_file	maxbytes	0
1095	assignsubmission_onlinetext	default	0
1096	assignfeedback_comments	default	1
1097	assignfeedback_comments	inline	0
1098	assignfeedback_comments	inline_adv	
1099	assignfeedback_comments	inline_locked	
1100	assignfeedback_editpdf	default	1
1101	assignfeedback_editpdf	stamps	
1102	assignfeedback_file	default	0
1103	assignfeedback_offline	default	0
1104	book	numberingoptions	0,1,2,3
1105	book	navoptions	0,1,2
1106	book	numbering	1
1107	book	navstyle	1
1108	resource	framesize	130
1109	resource	displayoptions	0,1,4,5,6
1110	resource	printintro	1
1111	resource	display	0
1112	resource	showsize	0
1113	resource	showtype	0
1114	resource	showdate	0
1115	resource	popupwidth	620
1116	resource	popupheight	450
1117	resource	filterfiles	0
1118	folder	showexpanded	1
1119	folder	maxsizetodownload	0
1120	imscp	keepold	1
1121	imscp	keepold_adv	
1122	iomadcertificate	uploadimage	
1123	iomadcertificate	fontsans	freesans
1124	iomadcertificate	fontserif	freeserif
1125	label	dndmedia	1
1126	label	dndresizewidth	400
1127	label	dndresizeheight	400
1128	mod_lesson	mediafile	
1129	mod_lesson	mediafile_adv	1
1130	mod_lesson	mediawidth	640
1131	mod_lesson	mediaheight	480
1132	mod_lesson	mediaclose	0
1133	mod_lesson	progressbar	0
1134	mod_lesson	progressbar_adv	
1135	mod_lesson	ongoing	0
1136	mod_lesson	ongoing_adv	1
1137	mod_lesson	displayleftmenu	0
1138	mod_lesson	displayleftmenu_adv	
1139	mod_lesson	displayleftif	0
1140	mod_lesson	displayleftif_adv	1
1141	mod_lesson	slideshow	0
1142	mod_lesson	slideshow_adv	1
1143	mod_lesson	slideshowwidth	640
1144	mod_lesson	slideshowheight	480
1145	mod_lesson	slideshowbgcolor	#FFFFFF
1146	mod_lesson	maxanswers	5
1147	mod_lesson	maxanswers_adv	1
1148	mod_lesson	defaultfeedback	0
1149	mod_lesson	defaultfeedback_adv	1
1150	mod_lesson	activitylink	
1151	mod_lesson	activitylink_adv	1
1152	mod_lesson	timelimit	0
1153	mod_lesson	timelimit_adv	
1154	mod_lesson	password	0
1155	mod_lesson	password_adv	1
1156	mod_lesson	modattempts	0
1157	mod_lesson	modattempts_adv	
1158	mod_lesson	displayreview	0
1159	mod_lesson	displayreview_adv	
1160	mod_lesson	maximumnumberofattempts	1
1161	mod_lesson	maximumnumberofattempts_adv	
1162	mod_lesson	defaultnextpage	0
1163	mod_lesson	defaultnextpage_adv	1
1164	mod_lesson	numberofpagestoshow	1
1165	mod_lesson	numberofpagestoshow_adv	1
1166	mod_lesson	practice	0
1167	mod_lesson	practice_adv	
1168	mod_lesson	customscoring	1
1169	mod_lesson	customscoring_adv	1
1170	mod_lesson	retakesallowed	0
1171	mod_lesson	retakesallowed_adv	
1172	mod_lesson	handlingofretakes	0
1173	mod_lesson	handlingofretakes_adv	1
1174	mod_lesson	minimumnumberofquestions	0
1175	mod_lesson	minimumnumberofquestions_adv	1
1176	page	displayoptions	5
1177	page	printheading	1
1178	page	printintro	0
1179	page	printlastmodified	1
1180	page	display	5
1181	page	popupwidth	620
1182	page	popupheight	450
1183	quiz	timelimit	0
1184	quiz	timelimit_adv	
1185	quiz	overduehandling	autosubmit
1186	quiz	overduehandling_adv	
1187	quiz	graceperiod	86400
1188	quiz	graceperiod_adv	
1189	quiz	graceperiodmin	60
1190	quiz	attempts	0
1191	quiz	attempts_adv	
1192	quiz	grademethod	1
1193	quiz	grademethod_adv	
1194	quiz	maximumgrade	10
1195	quiz	questionsperpage	1
1196	quiz	questionsperpage_adv	
1197	quiz	navmethod	free
1198	quiz	navmethod_adv	1
1199	quiz	shuffleanswers	1
1200	quiz	shuffleanswers_adv	
1201	quiz	preferredbehaviour	deferredfeedback
1202	quiz	canredoquestions	0
1203	quiz	canredoquestions_adv	1
1204	quiz	attemptonlast	0
1205	quiz	attemptonlast_adv	1
1206	quiz	reviewattempt	69904
1207	quiz	reviewcorrectness	69904
1208	quiz	reviewmarks	69904
1209	quiz	reviewspecificfeedback	69904
1210	quiz	reviewgeneralfeedback	69904
1211	quiz	reviewrightanswer	69904
1212	quiz	reviewoverallfeedback	4368
1213	quiz	showuserpicture	0
1214	quiz	showuserpicture_adv	
1215	quiz	decimalpoints	2
1216	quiz	decimalpoints_adv	
1217	quiz	questiondecimalpoints	-1
1218	quiz	questiondecimalpoints_adv	1
1219	quiz	showblocks	0
1220	quiz	showblocks_adv	1
1221	quiz	password	
1222	quiz	password_adv	
1223	quiz	subnet	
1224	quiz	subnet_adv	1
1225	quiz	delay1	0
1226	quiz	delay1_adv	1
1227	quiz	delay2	0
1228	quiz	delay2_adv	1
1229	quiz	browsersecurity	-
1230	quiz	browsersecurity_adv	1
1231	quiz	initialnumfeedbacks	2
1232	quiz	autosaveperiod	60
1233	scorm	displaycoursestructure	0
1234	scorm	displaycoursestructure_adv	
1235	scorm	popup	0
1236	scorm	popup_adv	
1237	scorm	displayactivityname	1
1238	scorm	framewidth	100
1239	scorm	framewidth_adv	1
1240	scorm	frameheight	500
1241	scorm	frameheight_adv	1
1242	scorm	winoptgrp_adv	1
1243	scorm	scrollbars	0
1244	scorm	directories	0
1245	scorm	location	0
1246	scorm	menubar	0
1247	scorm	toolbar	0
1248	scorm	status	0
1249	scorm	skipview	0
1250	scorm	skipview_adv	1
1251	scorm	hidebrowse	0
1252	scorm	hidebrowse_adv	1
1253	scorm	hidetoc	0
1254	scorm	hidetoc_adv	1
1255	scorm	nav	1
1256	scorm	nav_adv	1
1257	scorm	navpositionleft	-100
1258	scorm	navpositionleft_adv	1
1259	scorm	navpositiontop	-100
1260	scorm	navpositiontop_adv	1
1261	scorm	collapsetocwinsize	767
1262	scorm	collapsetocwinsize_adv	1
1263	scorm	displayattemptstatus	1
1264	scorm	displayattemptstatus_adv	
1265	scorm	grademethod	1
1266	scorm	maxgrade	100
1267	scorm	maxattempt	0
1268	scorm	whatgrade	0
1269	scorm	forcecompleted	0
1270	scorm	forcenewattempt	0
1271	scorm	autocommit	0
1272	scorm	masteryoverride	1
1273	scorm	lastattemptlock	0
1274	scorm	auto	0
1275	scorm	updatefreq	0
1276	scorm	scormstandard	0
1277	scorm	allowtypeexternal	0
1278	scorm	allowtypelocalsync	0
1279	scorm	allowtypeexternalaicc	0
1280	scorm	allowaicchacp	0
1281	scorm	aicchacptimeout	30
1282	scorm	aicchacpkeepsessiondata	1
1283	scorm	aiccuserid	1
1284	scorm	forcejavascript	1
1285	scorm	allowapidebug	0
1286	scorm	apidebugmask	.*
1287	scorm	protectpackagedownloads	0
1288	url	framesize	130
1289	url	secretphrase	
1290	url	rolesinparams	0
1291	url	displayoptions	0,1,5,6
1292	url	printintro	1
1293	url	display	0
1294	url	popupwidth	620
1295	url	popupheight	450
1296	workshop	grade	80
1297	workshop	gradinggrade	20
1298	workshop	gradedecimals	0
1299	workshop	maxbytes	0
1300	workshop	strategy	accumulative
1301	workshop	examplesmode	0
1302	workshopallocation_random	numofreviews	5
1303	workshopform_numerrors	grade0	No
1304	workshopform_numerrors	grade1	Yes
1305	workshopeval_best	comparison	5
1306	tool_iomadmerge	suspenduser	1
1307	tool_iomadmerge	transactions_only	1
1308	tool_iomadmerge	excluded_exceptions	none
1309	tool_iomadmerge	quizattemptsaction	remain
1310	tool_iomadmerge	uniquekeynewidtomaintain	1
1311	tool_recyclebin	coursebinenable	1
1312	tool_recyclebin	coursebinexpiry	604800
1313	tool_recyclebin	categorybinenable	1
1314	tool_recyclebin	categorybinexpiry	604800
1315	tool_recyclebin	autohide	1
1316	antivirus_clamav	runningmethod	commandline
1317	antivirus_clamav	pathtoclam	
1318	antivirus_clamav	pathtounixsocket	
1319	antivirus_clamav	clamfailureonupload	donothing
1320	auth_cas	field_map_firstname	
1321	auth_cas	field_updatelocal_firstname	oncreate
1322	auth_cas	field_updateremote_firstname	0
1323	auth_cas	field_lock_firstname	unlocked
1324	auth_cas	field_map_lastname	
1325	auth_cas	field_updatelocal_lastname	oncreate
1326	auth_cas	field_updateremote_lastname	0
1327	auth_cas	field_lock_lastname	unlocked
1328	auth_cas	field_map_email	
1329	auth_cas	field_updatelocal_email	oncreate
1330	auth_cas	field_updateremote_email	0
1331	auth_cas	field_lock_email	unlocked
1332	auth_cas	field_map_city	
1333	auth_cas	field_updatelocal_city	oncreate
1334	auth_cas	field_updateremote_city	0
1335	auth_cas	field_lock_city	unlocked
1336	auth_cas	field_map_country	
1337	auth_cas	field_updatelocal_country	oncreate
1338	auth_cas	field_updateremote_country	0
1339	auth_cas	field_lock_country	unlocked
1340	auth_cas	field_map_lang	
1341	auth_cas	field_updatelocal_lang	oncreate
1342	auth_cas	field_updateremote_lang	0
1343	auth_cas	field_lock_lang	unlocked
1344	auth_cas	field_map_description	
1345	auth_cas	field_updatelocal_description	oncreate
1346	auth_cas	field_updateremote_description	0
1347	auth_cas	field_lock_description	unlocked
1348	auth_cas	field_map_url	
1349	auth_cas	field_updatelocal_url	oncreate
1350	auth_cas	field_updateremote_url	0
1351	auth_cas	field_lock_url	unlocked
1352	auth_cas	field_map_idnumber	
1353	auth_cas	field_updatelocal_idnumber	oncreate
1354	auth_cas	field_updateremote_idnumber	0
1355	auth_cas	field_lock_idnumber	unlocked
1356	auth_cas	field_map_institution	
1357	auth_cas	field_updatelocal_institution	oncreate
1358	auth_cas	field_updateremote_institution	0
1359	auth_cas	field_lock_institution	unlocked
1360	auth_cas	field_map_department	
1361	auth_cas	field_updatelocal_department	oncreate
1362	auth_cas	field_updateremote_department	0
1363	auth_cas	field_lock_department	unlocked
1364	auth_cas	field_map_phone1	
1365	auth_cas	field_updatelocal_phone1	oncreate
1366	auth_cas	field_updateremote_phone1	0
1367	auth_cas	field_lock_phone1	unlocked
1368	auth_cas	field_map_phone2	
1369	auth_cas	field_updatelocal_phone2	oncreate
1370	auth_cas	field_updateremote_phone2	0
1371	auth_cas	field_lock_phone2	unlocked
1372	auth_cas	field_map_address	
1373	auth_cas	field_updatelocal_address	oncreate
1374	auth_cas	field_updateremote_address	0
1375	auth_cas	field_lock_address	unlocked
1376	auth_cas	field_map_firstnamephonetic	
1377	auth_cas	field_updatelocal_firstnamephonetic	oncreate
1378	auth_cas	field_updateremote_firstnamephonetic	0
1379	auth_cas	field_lock_firstnamephonetic	unlocked
1380	auth_cas	field_map_lastnamephonetic	
1381	auth_cas	field_updatelocal_lastnamephonetic	oncreate
1382	auth_cas	field_updateremote_lastnamephonetic	0
1383	auth_cas	field_lock_lastnamephonetic	unlocked
1384	auth_cas	field_map_middlename	
1385	auth_cas	field_updatelocal_middlename	oncreate
1386	auth_cas	field_updateremote_middlename	0
1387	auth_cas	field_lock_middlename	unlocked
1388	auth_cas	field_map_alternatename	
1389	auth_cas	field_updatelocal_alternatename	oncreate
1390	auth_cas	field_updateremote_alternatename	0
1391	auth_cas	field_lock_alternatename	unlocked
1392	auth_email	recaptcha	0
1393	auth_email	field_lock_firstname	unlocked
1394	auth_email	field_lock_lastname	unlocked
1395	auth_email	field_lock_email	unlocked
1396	auth_email	field_lock_city	unlocked
1397	auth_email	field_lock_country	unlocked
1398	auth_email	field_lock_lang	unlocked
1399	auth_email	field_lock_description	unlocked
1400	auth_email	field_lock_url	unlocked
1401	auth_email	field_lock_idnumber	unlocked
1402	auth_email	field_lock_institution	unlocked
1403	auth_email	field_lock_department	unlocked
1404	auth_email	field_lock_phone1	unlocked
1405	auth_email	field_lock_phone2	unlocked
1406	auth_email	field_lock_address	unlocked
1407	auth_email	field_lock_firstnamephonetic	unlocked
1408	auth_email	field_lock_lastnamephonetic	unlocked
1409	auth_email	field_lock_middlename	unlocked
1410	auth_email	field_lock_alternatename	unlocked
1411	auth_db	host	127.0.0.1
1412	auth_db	type	mysqli
1413	auth_db	sybasequoting	0
1414	auth_db	name	
1415	auth_db	user	
1416	auth_db	pass	
1417	auth_db	table	
1418	auth_db	fielduser	
1419	auth_db	fieldpass	
1420	auth_db	passtype	plaintext
1421	auth_db	extencoding	utf-8
1422	auth_db	setupsql	
1423	auth_db	debugauthdb	0
1424	auth_db	changepasswordurl	
1425	auth_db	removeuser	0
1426	auth_db	updateusers	0
1427	auth_db	field_map_firstname	
1428	auth_db	field_updatelocal_firstname	oncreate
1429	auth_db	field_updateremote_firstname	0
1430	auth_db	field_lock_firstname	unlocked
1431	auth_db	field_map_lastname	
1432	auth_db	field_updatelocal_lastname	oncreate
1433	auth_db	field_updateremote_lastname	0
1434	auth_db	field_lock_lastname	unlocked
1435	auth_db	field_map_email	
1436	auth_db	field_updatelocal_email	oncreate
1437	auth_db	field_updateremote_email	0
1438	auth_db	field_lock_email	unlocked
1439	auth_db	field_map_city	
1440	auth_db	field_updatelocal_city	oncreate
1441	auth_db	field_updateremote_city	0
1442	auth_db	field_lock_city	unlocked
1443	auth_db	field_map_country	
1444	auth_db	field_updatelocal_country	oncreate
1445	auth_db	field_updateremote_country	0
1446	auth_db	field_lock_country	unlocked
1447	auth_db	field_map_lang	
1448	auth_db	field_updatelocal_lang	oncreate
1449	auth_db	field_updateremote_lang	0
1450	auth_db	field_lock_lang	unlocked
1451	auth_db	field_map_description	
1452	auth_db	field_updatelocal_description	oncreate
1453	auth_db	field_updateremote_description	0
1454	auth_db	field_lock_description	unlocked
1455	auth_db	field_map_url	
1456	auth_db	field_updatelocal_url	oncreate
1457	auth_db	field_updateremote_url	0
1458	auth_db	field_lock_url	unlocked
1459	auth_db	field_map_idnumber	
1460	auth_db	field_updatelocal_idnumber	oncreate
1461	auth_db	field_updateremote_idnumber	0
1462	auth_db	field_lock_idnumber	unlocked
1463	auth_db	field_map_institution	
1464	auth_db	field_updatelocal_institution	oncreate
1465	auth_db	field_updateremote_institution	0
1466	auth_db	field_lock_institution	unlocked
1467	auth_db	field_map_department	
1468	auth_db	field_updatelocal_department	oncreate
1469	auth_db	field_updateremote_department	0
1470	auth_db	field_lock_department	unlocked
1471	auth_db	field_map_phone1	
1472	auth_db	field_updatelocal_phone1	oncreate
1473	auth_db	field_updateremote_phone1	0
1474	auth_db	field_lock_phone1	unlocked
1475	auth_db	field_map_phone2	
1476	auth_db	field_updatelocal_phone2	oncreate
1477	auth_db	field_updateremote_phone2	0
1478	auth_db	field_lock_phone2	unlocked
1479	auth_db	field_map_address	
1480	auth_db	field_updatelocal_address	oncreate
1481	auth_db	field_updateremote_address	0
1482	auth_db	field_lock_address	unlocked
1483	auth_db	field_map_firstnamephonetic	
1484	auth_db	field_updatelocal_firstnamephonetic	oncreate
1485	auth_db	field_updateremote_firstnamephonetic	0
1486	auth_db	field_lock_firstnamephonetic	unlocked
1487	auth_db	field_map_lastnamephonetic	
1488	auth_db	field_updatelocal_lastnamephonetic	oncreate
1489	auth_db	field_updateremote_lastnamephonetic	0
1490	auth_db	field_lock_lastnamephonetic	unlocked
1491	auth_db	field_map_middlename	
1492	auth_db	field_updatelocal_middlename	oncreate
1493	auth_db	field_updateremote_middlename	0
1494	auth_db	field_lock_middlename	unlocked
1495	auth_db	field_map_alternatename	
1496	auth_db	field_updatelocal_alternatename	oncreate
1497	auth_db	field_updateremote_alternatename	0
1498	auth_db	field_lock_alternatename	unlocked
1499	auth_iomadoidc	opname	IOMAD OpenID Connect
1500	auth_iomadoidc	clientid	
1501	auth_iomadoidc	clientsecret	
1502	auth_iomadoidc	authendpoint	https://login.microsoftonline.com/common/oauth2/authorize
1503	auth_iomadoidc	tokenendpoint	https://login.microsoftonline.com/common/oauth2/token
1504	auth_iomadoidc	iomadoidcresource	https://graph.microsoft.com
1505	auth_iomadoidc	iomadoidcscope	openid profile email
1506	auth_iomadoidc	forceredirect	0
1507	auth_iomadoidc	autoappend	
1508	auth_iomadoidc	domainhint	
1509	auth_iomadoidc	loginflow	authcode
1510	auth_iomadoidc	userrestrictions	
1511	auth_iomadoidc	debugmode	0
1512	auth_iomadoidc	icon	auth_iomadoidc:o365
1513	auth_iomadoidc	customicon	
1514	auth_ldap	field_map_firstname	
1515	auth_ldap	field_updatelocal_firstname	oncreate
1516	auth_ldap	field_updateremote_firstname	0
1517	auth_ldap	field_lock_firstname	unlocked
1518	auth_ldap	field_map_lastname	
1519	auth_ldap	field_updatelocal_lastname	oncreate
1520	auth_ldap	field_updateremote_lastname	0
1521	auth_ldap	field_lock_lastname	unlocked
1522	auth_ldap	field_map_email	
1523	auth_ldap	field_updatelocal_email	oncreate
1524	auth_ldap	field_updateremote_email	0
1525	auth_ldap	field_lock_email	unlocked
1526	auth_ldap	field_map_city	
1527	auth_ldap	field_updatelocal_city	oncreate
1528	auth_ldap	field_updateremote_city	0
1529	auth_ldap	field_lock_city	unlocked
1530	auth_ldap	field_map_country	
1531	auth_ldap	field_updatelocal_country	oncreate
1532	auth_ldap	field_updateremote_country	0
1533	auth_ldap	field_lock_country	unlocked
1534	auth_ldap	field_map_lang	
1535	auth_ldap	field_updatelocal_lang	oncreate
1536	auth_ldap	field_updateremote_lang	0
1537	auth_ldap	field_lock_lang	unlocked
1538	auth_ldap	field_map_description	
1539	auth_ldap	field_updatelocal_description	oncreate
1540	auth_ldap	field_updateremote_description	0
1541	auth_ldap	field_lock_description	unlocked
1542	auth_ldap	field_map_url	
1543	auth_ldap	field_updatelocal_url	oncreate
1544	auth_ldap	field_updateremote_url	0
1545	auth_ldap	field_lock_url	unlocked
1546	auth_ldap	field_map_idnumber	
1547	auth_ldap	field_updatelocal_idnumber	oncreate
1548	auth_ldap	field_updateremote_idnumber	0
1549	auth_ldap	field_lock_idnumber	unlocked
1550	auth_ldap	field_map_institution	
1551	auth_ldap	field_updatelocal_institution	oncreate
1552	auth_ldap	field_updateremote_institution	0
1553	auth_ldap	field_lock_institution	unlocked
1554	auth_ldap	field_map_department	
1555	auth_ldap	field_updatelocal_department	oncreate
1556	auth_ldap	field_updateremote_department	0
1557	auth_ldap	field_lock_department	unlocked
1558	auth_ldap	field_map_phone1	
1559	auth_ldap	field_updatelocal_phone1	oncreate
1560	auth_ldap	field_updateremote_phone1	0
1561	auth_ldap	field_lock_phone1	unlocked
1562	auth_ldap	field_map_phone2	
1563	auth_ldap	field_updatelocal_phone2	oncreate
1564	auth_ldap	field_updateremote_phone2	0
1565	auth_ldap	field_lock_phone2	unlocked
1566	auth_ldap	field_map_address	
1567	auth_ldap	field_updatelocal_address	oncreate
1568	auth_ldap	field_updateremote_address	0
1569	auth_ldap	field_lock_address	unlocked
1570	auth_ldap	field_map_firstnamephonetic	
1571	auth_ldap	field_updatelocal_firstnamephonetic	oncreate
1572	auth_ldap	field_updateremote_firstnamephonetic	0
1573	auth_ldap	field_lock_firstnamephonetic	unlocked
1574	auth_ldap	field_map_lastnamephonetic	
1575	auth_ldap	field_updatelocal_lastnamephonetic	oncreate
1576	auth_ldap	field_updateremote_lastnamephonetic	0
1577	auth_ldap	field_lock_lastnamephonetic	unlocked
1578	auth_ldap	field_map_middlename	
1579	auth_ldap	field_updatelocal_middlename	oncreate
1580	auth_ldap	field_updateremote_middlename	0
1581	auth_ldap	field_lock_middlename	unlocked
1582	auth_ldap	field_map_alternatename	
1583	auth_ldap	field_updatelocal_alternatename	oncreate
1584	auth_ldap	field_updateremote_alternatename	0
1585	auth_ldap	field_lock_alternatename	unlocked
1586	auth_manual	expiration	0
1587	auth_manual	expirationtime	30
1588	auth_manual	expiration_warning	0
1589	auth_manual	field_lock_firstname	unlocked
1590	auth_manual	field_lock_lastname	unlocked
1591	auth_manual	field_lock_email	unlocked
1592	auth_manual	field_lock_city	unlocked
1593	auth_manual	field_lock_country	unlocked
1594	auth_manual	field_lock_lang	unlocked
1595	auth_manual	field_lock_description	unlocked
1596	auth_manual	field_lock_url	unlocked
1597	auth_manual	field_lock_idnumber	unlocked
1598	auth_manual	field_lock_institution	unlocked
1599	auth_manual	field_lock_department	unlocked
1600	auth_manual	field_lock_phone1	unlocked
1601	auth_manual	field_lock_phone2	unlocked
1602	auth_manual	field_lock_address	unlocked
1603	auth_manual	field_lock_firstnamephonetic	unlocked
1604	auth_manual	field_lock_lastnamephonetic	unlocked
1605	auth_manual	field_lock_middlename	unlocked
1606	auth_manual	field_lock_alternatename	unlocked
1607	auth_mnet	rpc_negotiation_timeout	30
1608	auth_none	field_lock_firstname	unlocked
1609	auth_none	field_lock_lastname	unlocked
1610	auth_none	field_lock_email	unlocked
1611	auth_none	field_lock_city	unlocked
1612	auth_none	field_lock_country	unlocked
1613	auth_none	field_lock_lang	unlocked
1614	auth_none	field_lock_description	unlocked
1615	auth_none	field_lock_url	unlocked
1616	auth_none	field_lock_idnumber	unlocked
1617	auth_none	field_lock_institution	unlocked
1618	auth_none	field_lock_department	unlocked
1619	auth_none	field_lock_phone1	unlocked
1620	auth_none	field_lock_phone2	unlocked
1621	auth_none	field_lock_address	unlocked
1622	auth_none	field_lock_firstnamephonetic	unlocked
1623	auth_none	field_lock_lastnamephonetic	unlocked
1624	auth_none	field_lock_middlename	unlocked
1625	auth_none	field_lock_alternatename	unlocked
1626	auth_oauth2	field_lock_firstname	unlocked
1627	auth_oauth2	field_lock_lastname	unlocked
1628	auth_oauth2	field_lock_email	unlocked
1629	auth_oauth2	field_lock_city	unlocked
1630	auth_oauth2	field_lock_country	unlocked
1631	auth_oauth2	field_lock_lang	unlocked
1632	auth_oauth2	field_lock_description	unlocked
1633	auth_oauth2	field_lock_url	unlocked
1634	auth_oauth2	field_lock_idnumber	unlocked
1635	auth_oauth2	field_lock_institution	unlocked
1636	auth_oauth2	field_lock_department	unlocked
1637	auth_oauth2	field_lock_phone1	unlocked
1638	auth_oauth2	field_lock_phone2	unlocked
1639	auth_oauth2	field_lock_address	unlocked
1640	auth_oauth2	field_lock_firstnamephonetic	unlocked
1641	auth_oauth2	field_lock_lastnamephonetic	unlocked
1642	auth_oauth2	field_lock_middlename	unlocked
1643	auth_oauth2	field_lock_alternatename	unlocked
1644	auth_shibboleth	user_attribute	
1645	auth_shibboleth	convert_data	
1646	auth_shibboleth	alt_login	off
1647	auth_shibboleth	organization_selection	urn:mace:organization1:providerID, Example Organization 1\n        https://another.idp-id.com/shibboleth, Other Example Organization, /Shibboleth.sso/DS/SWITCHaai\n        urn:mace:organization2:providerID, Example Organization 2, /Shibboleth.sso/WAYF/SWITCHaai
1648	auth_shibboleth	logout_handler	
1649	auth_shibboleth	logout_return_url	
1650	auth_shibboleth	login_name	Shibboleth Login
1651	auth_shibboleth	auth_logo	
1652	auth_shibboleth	auth_instructions	Use the <a href="https://arrupe.ac.zw/acis/iomad/auth/shibboleth/index.php">Shibboleth login</a> to get access via Shibboleth, if your institution supports it. Otherwise, use the normal login form shown here.
1653	auth_shibboleth	changepasswordurl	
1654	auth_shibboleth	field_map_firstname	
1655	auth_shibboleth	field_updatelocal_firstname	oncreate
1656	auth_shibboleth	field_lock_firstname	unlocked
1657	auth_shibboleth	field_map_lastname	
1658	auth_shibboleth	field_updatelocal_lastname	oncreate
1659	auth_shibboleth	field_lock_lastname	unlocked
1660	auth_shibboleth	field_map_email	
1661	auth_shibboleth	field_updatelocal_email	oncreate
1662	auth_shibboleth	field_lock_email	unlocked
1663	auth_shibboleth	field_map_city	
1664	auth_shibboleth	field_updatelocal_city	oncreate
1665	auth_shibboleth	field_lock_city	unlocked
1666	auth_shibboleth	field_map_country	
1667	auth_shibboleth	field_updatelocal_country	oncreate
1668	auth_shibboleth	field_lock_country	unlocked
1669	auth_shibboleth	field_map_lang	
1670	auth_shibboleth	field_updatelocal_lang	oncreate
1671	auth_shibboleth	field_lock_lang	unlocked
1672	auth_shibboleth	field_map_description	
1673	auth_shibboleth	field_updatelocal_description	oncreate
1674	auth_shibboleth	field_lock_description	unlocked
1675	auth_shibboleth	field_map_url	
1676	auth_shibboleth	field_updatelocal_url	oncreate
1677	auth_shibboleth	field_lock_url	unlocked
1678	auth_shibboleth	field_map_idnumber	
1679	auth_shibboleth	field_updatelocal_idnumber	oncreate
1680	auth_shibboleth	field_lock_idnumber	unlocked
1681	auth_shibboleth	field_map_institution	
1682	auth_shibboleth	field_updatelocal_institution	oncreate
1683	auth_shibboleth	field_lock_institution	unlocked
1684	auth_shibboleth	field_map_department	
1685	auth_shibboleth	field_updatelocal_department	oncreate
1686	auth_shibboleth	field_lock_department	unlocked
1687	auth_shibboleth	field_map_phone1	
1688	auth_shibboleth	field_updatelocal_phone1	oncreate
1689	auth_shibboleth	field_lock_phone1	unlocked
1690	auth_shibboleth	field_map_phone2	
1691	auth_shibboleth	field_updatelocal_phone2	oncreate
1692	auth_shibboleth	field_lock_phone2	unlocked
1693	auth_shibboleth	field_map_address	
1694	auth_shibboleth	field_updatelocal_address	oncreate
1695	auth_shibboleth	field_lock_address	unlocked
1696	auth_shibboleth	field_map_firstnamephonetic	
1697	auth_shibboleth	field_updatelocal_firstnamephonetic	oncreate
1698	auth_shibboleth	field_lock_firstnamephonetic	unlocked
1699	auth_shibboleth	field_map_lastnamephonetic	
1700	auth_shibboleth	field_updatelocal_lastnamephonetic	oncreate
1701	auth_shibboleth	field_lock_lastnamephonetic	unlocked
1702	auth_shibboleth	field_map_middlename	
1703	auth_shibboleth	field_updatelocal_middlename	oncreate
1704	auth_shibboleth	field_lock_middlename	unlocked
1705	auth_shibboleth	field_map_alternatename	
1706	auth_shibboleth	field_updatelocal_alternatename	oncreate
1707	auth_shibboleth	field_lock_alternatename	unlocked
1708	block_activity_results	config_showbest	3
1709	block_activity_results	config_showbest_locked	
1710	block_activity_results	config_showworst	0
1711	block_activity_results	config_showworst_locked	
1712	block_activity_results	config_usegroups	0
1713	block_activity_results	config_usegroups_locked	
1714	block_activity_results	config_nameformat	1
1715	block_activity_results	config_nameformat_locked	
1716	block_activity_results	config_gradeformat	1
1717	block_activity_results	config_gradeformat_locked	
1718	block_activity_results	config_decimalpoints	2
1719	block_activity_results	config_decimalpoints_locked	
1720	block_myoverview	displaycategories	1
1721	block_myoverview	layouts	card,list,summary
1722	block_myoverview	displaygroupingallincludinghidden	0
1723	block_myoverview	displaygroupingall	1
1724	block_myoverview	displaygroupinginprogress	1
1725	block_myoverview	displaygroupingpast	1
1726	block_myoverview	displaygroupingfuture	1
1727	block_myoverview	displaygroupingcustomfield	0
1728	block_myoverview	customfiltergrouping	
1729	block_myoverview	displaygroupingstarred	1
1730	block_myoverview	displaygroupinghidden	1
1731	block_iomad_progress	coursenametoshow	shortname
1732	block_iomad_progress	attempted_colour	#5CD85C
1733	block_iomad_progress	notattempted_colour	#FF5C5C
1734	block_iomad_progress	futurenotattempted_colour	#5C5CFF
1735	block_recentlyaccessedcourses	displaycategories	1
1736	block_section_links	numsections1	22
1737	block_section_links	incby1	2
1738	block_section_links	numsections2	40
1739	block_section_links	incby2	5
1740	block_starredcourses	displaycategories	1
1741	block_tag_youtube	apikey	
1742	format_singleactivity	activitytype	forum
1743	fileconverter_googledrive	issuerid	
1744	enrol_cohort	roleid	5
1745	enrol_cohort	unenrolaction	0
1746	enrol_meta	nosyncroleids	
1747	enrol_meta	syncall	1
1748	enrol_meta	unenrolaction	3
1749	enrol_meta	coursesort	sortorder
1750	enrol_database	dbtype	
1751	enrol_database	dbhost	localhost
1752	enrol_database	dbuser	
1753	enrol_database	dbpass	
1754	enrol_database	dbname	
1755	enrol_database	dbencoding	utf-8
1756	enrol_database	dbsetupsql	
1757	enrol_database	dbsybasequoting	0
1758	enrol_database	debugdb	0
1759	enrol_database	localcoursefield	idnumber
1760	enrol_database	localuserfield	idnumber
1761	enrol_database	localrolefield	shortname
1762	enrol_database	localcategoryfield	id
1763	enrol_database	remoteenroltable	
1764	enrol_database	remotecoursefield	
1765	enrol_database	remoteuserfield	
1766	enrol_database	remoterolefield	
1767	enrol_database	remoteotheruserfield	
1768	enrol_database	defaultrole	5
1769	enrol_database	ignorehiddencourses	0
1770	enrol_database	unenrolaction	0
1771	enrol_database	newcoursetable	
1772	enrol_database	newcoursefullname	fullname
1773	enrol_database	newcourseshortname	shortname
1774	enrol_database	newcourseidnumber	idnumber
1775	enrol_database	newcoursecategory	
1776	enrol_database	defaultcategory	1
1777	enrol_database	templatecourse	
1778	enrol_flatfile	location	
1779	enrol_flatfile	encoding	UTF-8
1780	enrol_flatfile	mailstudents	0
1781	enrol_flatfile	mailteachers	0
1782	enrol_flatfile	mailadmins	0
1783	enrol_flatfile	unenrolaction	3
1784	enrol_flatfile	expiredaction	3
1785	enrol_guest	requirepassword	0
1786	enrol_guest	usepasswordpolicy	0
1787	enrol_guest	showhint	0
1788	enrol_guest	defaultenrol	1
1789	enrol_guest	status	1
1790	enrol_guest	status_adv	
1791	enrol_imsenterprise	imsfilelocation	
1792	enrol_imsenterprise	logtolocation	
1793	enrol_imsenterprise	mailadmins	0
1794	enrol_imsenterprise	createnewusers	0
1795	enrol_imsenterprise	imsupdateusers	0
1796	enrol_imsenterprise	imsdeleteusers	0
1797	enrol_imsenterprise	fixcaseusernames	0
1798	enrol_imsenterprise	fixcasepersonalnames	0
1799	enrol_imsenterprise	imssourcedidfallback	0
1800	enrol_imsenterprise	imsrolemap01	5
1801	enrol_imsenterprise	imsrolemap02	3
1802	enrol_imsenterprise	imsrolemap03	3
1803	enrol_imsenterprise	imsrolemap04	5
1804	enrol_imsenterprise	imsrolemap05	0
1805	enrol_imsenterprise	imsrolemap06	4
1806	enrol_imsenterprise	imsrolemap07	0
1807	enrol_imsenterprise	imsrolemap08	4
1808	enrol_imsenterprise	truncatecoursecodes	0
1809	enrol_imsenterprise	createnewcourses	0
1810	enrol_imsenterprise	updatecourses	0
1811	enrol_imsenterprise	createnewcategories	0
1812	enrol_imsenterprise	nestedcategories	0
1813	enrol_imsenterprise	categoryidnumber	0
1814	enrol_imsenterprise	categoryseparator	
1815	enrol_imsenterprise	imsunenrol	0
1816	enrol_imsenterprise	imscoursemapshortname	coursecode
1817	enrol_imsenterprise	imscoursemapfullname	short
1818	enrol_imsenterprise	imscoursemapsummary	ignore
1819	enrol_imsenterprise	imsrestricttarget	
1820	enrol_imsenterprise	imscapitafix	0
1821	enrol_license	defaultenrol	1
1822	enrol_license	status	1
1823	enrol_license	roleid	5
1824	enrol_license	longtimenosee	0
1825	enrol_license	sendcoursewelcomemessage	1
1826	enrol_manual	expiredaction	1
1827	enrol_manual	expirynotifyhour	6
1828	enrol_manual	defaultenrol	1
1829	enrol_manual	status	0
1830	enrol_manual	roleid	5
1831	enrol_manual	enrolstart	4
1832	enrol_manual	enrolperiod	0
1833	enrol_manual	expirynotify	0
1834	enrol_manual	expirythreshold	86400
1835	enrol_mnet	roleid	5
1836	enrol_mnet	roleid_adv	1
1837	enrol_paypal	paypalbusiness	
1838	enrol_paypal	mailstudents	0
1839	enrol_paypal	mailteachers	0
1840	enrol_paypal	mailadmins	0
1841	enrol_paypal	expiredaction	3
1842	enrol_paypal	status	1
1843	enrol_paypal	cost	0
1844	enrol_paypal	currency	USD
1845	enrol_paypal	roleid	5
1846	enrol_paypal	enrolperiod	0
1847	enrol_lti	emaildisplay	2
1848	enrol_lti	city	
1849	enrol_lti	country	
1850	enrol_lti	timezone	99
1851	enrol_lti	lang	en
1852	enrol_lti	institution	
1853	enrol_self	requirepassword	0
1854	enrol_self	usepasswordpolicy	0
1855	enrol_self	showhint	0
1856	enrol_self	expiredaction	1
1857	enrol_self	expirynotifyhour	6
1858	enrol_self	defaultenrol	1
1859	enrol_self	status	1
1860	enrol_self	newenrols	1
1861	enrol_self	groupkey	0
1862	enrol_self	roleid	5
1863	enrol_self	enrolperiod	0
1864	enrol_self	expirynotify	0
1865	enrol_self	expirythreshold	86400
1866	enrol_self	longtimenosee	0
1867	enrol_self	maxenrolled	0
1868	enrol_self	sendcoursewelcomemessage	1
1869	filter_displayh5p	allowedsources	
1870	filter_mathjaxloader	httpsurl	https://cdn.jsdelivr.net/npm/mathjax@2.7.8/MathJax.js
1871	filter_mathjaxloader	texfiltercompatibility	0
1872	filter_mathjaxloader	mathjaxconfig	\nMathJax.Hub.Config({\n    config: ["Accessible.js", "Safe.js"],\n    errorSettings: { message: ["!"] },\n    skipStartupTypeset: true,\n    messageStyle: "none"\n});\n
1873	filter_mathjaxloader	additionaldelimiters	
1874	filter_tex	latexpreamble	\\usepackage[latin1]{inputenc}\n\\usepackage{amsmath}\n\\usepackage{amsfonts}\n\\RequirePackage{amsmath,amssymb,latexsym}\n
1875	filter_tex	latexbackground	#FFFFFF
1876	filter_tex	density	120
1877	filter_tex	pathlatex	/usr/bin/latex
1878	filter_tex	pathdvips	/usr/bin/dvips
1879	filter_tex	pathconvert	/usr/bin/convert
1880	filter_tex	pathdvisvgm	/usr/bin/dvisvgm
1881	filter_tex	pathmimetex	
1882	filter_tex	convertformat	gif
1883	local_iomad_learningpath	showcoursename	shortname
1884	local_iomad_learningpath	showcoursedescription	1
1885	local_iomad_learningpath	showprogress	1
1886	local_iomad_settings	iomadcertificate_logo	
1887	local_iomad_settings	iomadcertificate_signature	
1888	local_iomad_settings	iomadcertificate_border	
1889	local_iomad_settings	iomadcertificate_watermark	
1890	logstore_database	dbdriver	
1891	logstore_database	dbhost	
1892	logstore_database	dbuser	
1893	logstore_database	dbpass	
1894	logstore_database	dbname	
1895	logstore_database	dbtable	
1896	logstore_database	dbpersist	0
1897	logstore_database	dbsocket	
1898	logstore_database	dbport	
1899	logstore_database	dbschema	
1900	logstore_database	dbcollation	
1901	logstore_database	dbhandlesoptions	0
1902	logstore_database	buffersize	50
1903	logstore_database	jsonformat	1
1904	logstore_database	logguests	0
1905	logstore_database	includelevels	1,2,0
1906	logstore_database	includeactions	c,r,u,d
1907	logstore_legacy	loglegacy	0
1908	logstore_standard	logguests	1
1909	logstore_standard	jsonformat	1
1910	logstore_standard	loglifetime	0
1911	logstore_standard	buffersize	50
1912	mlbackend_python	useserver	0
1913	mlbackend_python	host	
1914	mlbackend_python	port	0
1915	mlbackend_python	secure	0
1916	mlbackend_python	username	default
1917	mlbackend_python	password	
1918	media_videojs	videoextensions	html_video,media_source,.f4v,.flv
1919	media_videojs	audioextensions	html_audio
1920	media_videojs	rtmp	0
1921	media_videojs	useflash	0
1922	media_videojs	youtube	1
1923	media_videojs	videocssclass	video-js
1924	media_videojs	audiocssclass	video-js
1925	media_videojs	limitsize	1
1926	qtype_multichoice	answerhowmany	1
1927	qtype_multichoice	shuffleanswers	1
1928	qtype_multichoice	answernumbering	abc
1929	editor_atto	toolbar	collapse = collapse\nstyle1 = title, bold, italic\nlist = unorderedlist, orderedlist\nlinks = link\nfiles = image, media, recordrtc, managefiles, h5p\nstyle2 = underline, strike, subscript, superscript\nalign = align\nindent = indent\ninsert = equation, charmap, table, clear\nundo = undo\naccessibility = accessibilitychecker, accessibilityhelper\nother = html
1930	editor_atto	autosavefrequency	60
1931	atto_collapse	showgroups	5
1932	atto_equation	librarygroup1	\n\\cdot\n\\times\n\\ast\n\\div\n\\diamond\n\\pm\n\\mp\n\\oplus\n\\ominus\n\\otimes\n\\oslash\n\\odot\n\\circ\n\\bullet\n\\asymp\n\\equiv\n\\subseteq\n\\supseteq\n\\leq\n\\geq\n\\preceq\n\\succeq\n\\sim\n\\simeq\n\\approx\n\\subset\n\\supset\n\\ll\n\\gg\n\\prec\n\\succ\n\\infty\n\\in\n\\ni\n\\forall\n\\exists\n\\neq\n
1933	atto_equation	librarygroup2	\n\\leftarrow\n\\rightarrow\n\\uparrow\n\\downarrow\n\\leftrightarrow\n\\nearrow\n\\searrow\n\\swarrow\n\\nwarrow\n\\Leftarrow\n\\Rightarrow\n\\Uparrow\n\\Downarrow\n\\Leftrightarrow\n
1934	atto_equation	librarygroup3	\n\\alpha\n\\beta\n\\gamma\n\\delta\n\\epsilon\n\\zeta\n\\eta\n\\theta\n\\iota\n\\kappa\n\\lambda\n\\mu\n\\nu\n\\xi\n\\pi\n\\rho\n\\sigma\n\\tau\n\\upsilon\n\\phi\n\\chi\n\\psi\n\\omega\n\\Gamma\n\\Delta\n\\Theta\n\\Lambda\n\\Xi\n\\Pi\n\\Sigma\n\\Upsilon\n\\Phi\n\\Psi\n\\Omega\n
1935	atto_equation	librarygroup4	\n\\sum{a,b}\n\\sqrt[a]{b+c}\n\\int_{a}^{b}{c}\n\\iint_{a}^{b}{c}\n\\iiint_{a}^{b}{c}\n\\oint{a}\n(a)\n[a]\n\\lbrace{a}\\rbrace\n\\left| \\begin{matrix} a_1 & a_2 \\ a_3 & a_4 \\end{matrix} \\right|\n\\frac{a}{b+c}\n\\vec{a}\n\\binom {a} {b}\n{a \\brack b}\n{a \\brace b}\n
1936	atto_recordrtc	allowedtypes	both
1937	atto_recordrtc	audiobitrate	128000
1938	atto_recordrtc	videobitrate	2500000
1939	atto_recordrtc	timelimit	120
1940	atto_table	allowborders	0
1941	atto_table	allowbackgroundcolour	0
1942	atto_table	allowwidth	0
1943	editor_tinymce	customtoolbar	wrap,formatselect,wrap,bold,italic,wrap,bullist,numlist,wrap,link,unlink,wrap,image\n\nundo,redo,wrap,underline,strikethrough,sub,sup,wrap,justifyleft,justifycenter,justifyright,wrap,outdent,indent,wrap,forecolor,backcolor,wrap,ltr,rtl\n\nfontselect,fontsizeselect,wrap,code,search,replace,wrap,nonbreaking,charmap,table,wrap,cleanup,removeformat,pastetext,pasteword,wrap,fullscreen
1944	editor_tinymce	fontselectlist	Trebuchet=Trebuchet MS,Verdana,Arial,Helvetica,sans-serif;Arial=arial,helvetica,sans-serif;Courier New=courier new,courier,monospace;Georgia=georgia,times new roman,times,serif;Tahoma=tahoma,arial,helvetica,sans-serif;Times New Roman=times new roman,times,serif;Verdana=verdana,arial,helvetica,sans-serif;Impact=impact;Wingdings=wingdings
1945	editor_tinymce	customconfig	
1946	tinymce_moodleemoticon	requireemoticon	1
1947	tinymce_spellchecker	spellengine	
1948	tinymce_spellchecker	spelllanguagelist	+English=en,Danish=da,Dutch=nl,Finnish=fi,French=fr,German=de,Italian=it,Polish=pl,Portuguese=pt,Spanish=es,Swedish=sv
1949	enrol_ldap	objectclass	(objectClass=*)
\.


--
-- Data for Name: mdl_context; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_context (id, contextlevel, instanceid, path, depth, locked) FROM stdin;
1	10	0	/1	1	0
58	30	5	/1/58	2	0
2	50	1	/1/2	2	0
3	40	1	/1/3	2	0
59	30	6	/1/59	2	0
4	30	1	/1/4	2	0
5	30	2	/1/5	2	0
60	30	7	/1/60	2	0
6	80	1	/1/6	2	0
108	30	17	/1/108	2	0
7	80	2	/1/2/7	3	0
61	30	8	/1/61	2	0
8	80	3	/1/8	2	0
9	80	4	/1/9	2	0
62	70	1	/1/3/33/34/62	5	0
10	80	5	/1/10	2	0
109	30	18	/1/109	2	0
11	80	6	/1/11	2	0
12	80	7	/1/12	2	0
110	30	19	/1/110	2	0
13	80	8	/1/13	2	0
14	80	9	/1/14	2	0
111	30	20	/1/111	2	0
15	80	10	/1/15	2	0
65	80	38	/1/60/65	3	0
16	80	11	/1/16	2	0
17	80	12	/1/17	2	0
66	80	39	/1/60/66	3	0
18	80	13	/1/18	2	0
19	80	14	/1/19	2	0
67	80	40	/1/60/67	3	0
20	80	15	/1/20	2	0
21	80	16	/1/5/21	3	0
68	80	41	/1/60/68	3	0
22	80	17	/1/5/22	3	0
23	80	18	/1/5/23	3	0
69	80	42	/1/60/69	3	0
24	80	19	/1/5/24	3	0
25	80	20	/1/5/25	3	0
70	80	43	/1/60/70	3	0
26	80	21	/1/5/26	3	0
114	30	21	/1/114	2	0
27	80	22	/1/5/27	3	0
71	80	44	/1/60/71	3	0
28	80	23	/1/5/28	3	0
29	80	24	/1/5/29	3	0
72	80	45	/1/60/72	3	0
30	80	25	/1/5/30	3	0
115	30	22	/1/115	2	0
31	80	26	/1/5/31	3	0
73	80	46	/1/60/73	3	0
32	30	3	/1/32	2	0
33	40	2	/1/3/33	3	0
74	80	47	/1/60/74	3	0
34	50	2	/1/3/33/34	4	0
116	30	23	/1/116	2	0
75	80	48	/1/60/75	3	0
76	50	9	/1/3/76	3	0
117	50	22	/1/3/33/117	4	0
77	70	9	/1/3/76/77	4	0
118	50	23	/1/3/33/118	4	0
119	70	23	/1/3/33/118/119	5	0
120	80	49	/1/116/120	3	0
121	80	50	/1/116/121	3	0
122	80	51	/1/116/122	3	0
83	30	9	/1/83	2	0
123	80	52	/1/116/123	3	0
84	30	10	/1/84	2	0
124	80	53	/1/116/124	3	0
46	30	4	/1/46	2	0
125	80	54	/1/116/125	3	0
47	80	27	/1/46/47	3	0
86	30	11	/1/86	2	0
48	80	28	/1/46/48	3	0
49	80	29	/1/46/49	3	0
126	80	55	/1/116/126	3	0
50	80	30	/1/46/50	3	0
51	80	31	/1/46/51	3	0
88	30	12	/1/88	2	0
52	80	32	/1/46/52	3	0
127	80	56	/1/116/127	3	0
53	80	33	/1/46/53	3	0
89	30	13	/1/89	2	0
54	80	34	/1/46/54	3	0
55	80	35	/1/46/55	3	0
128	80	57	/1/116/128	3	0
56	80	36	/1/46/56	3	0
57	80	37	/1/46/57	3	0
129	80	58	/1/116/129	3	0
130	80	59	/1/116/130	3	0
131	30	24	/1/131	2	0
132	30	25	/1/132	2	0
133	80	60	/1/132/133	3	0
134	80	61	/1/132/134	3	0
135	80	62	/1/132/135	3	0
136	80	63	/1/132/136	3	0
137	80	64	/1/132/137	3	0
103	30	14	/1/103	2	0
138	80	65	/1/132/138	3	0
104	30	15	/1/104	2	0
105	30	16	/1/105	2	0
139	80	66	/1/132/139	3	0
140	80	67	/1/132/140	3	0
141	80	68	/1/132/141	3	0
142	80	69	/1/132/142	3	0
143	80	70	/1/132/143	3	0
144	30	26	/1/144	2	0
187	30	36	/1/187	2	0
145	30	27	/1/145	2	0
146	30	28	/1/146	2	0
188	80	104	/1/187/188	3	0
147	30	29	/1/147	2	0
148	30	30	/1/148	2	0
189	80	105	/1/187/189	3	0
149	80	71	/1/148/149	3	0
150	80	72	/1/148/150	3	0
190	80	106	/1/187/190	3	0
151	80	73	/1/148/151	3	0
152	80	74	/1/148/152	3	0
191	80	107	/1/187/191	3	0
153	80	75	/1/148/153	3	0
154	80	76	/1/148/154	3	0
192	80	108	/1/187/192	3	0
155	80	77	/1/148/155	3	0
156	80	78	/1/148/156	3	0
193	80	109	/1/187/193	3	0
157	80	79	/1/148/157	3	0
158	80	80	/1/148/158	3	0
194	80	110	/1/187/194	3	0
159	80	81	/1/148/159	3	0
160	30	31	/1/160	2	0
195	80	111	/1/187/195	3	0
161	30	32	/1/161	2	0
162	30	33	/1/162	2	0
196	80	112	/1/187/196	3	0
163	80	82	/1/162/163	3	0
164	80	83	/1/162/164	3	0
197	80	113	/1/187/197	3	0
165	80	84	/1/162/165	3	0
166	80	85	/1/162/166	3	0
198	80	114	/1/187/198	3	0
167	80	86	/1/162/167	3	0
168	80	87	/1/162/168	3	0
199	30	37	/1/199	2	0
169	80	88	/1/162/169	3	0
170	80	89	/1/162/170	3	0
200	30	38	/1/200	2	0
171	80	90	/1/162/171	3	0
172	80	91	/1/162/172	3	0
201	80	115	/1/200/201	3	0
173	80	92	/1/162/173	3	0
174	30	34	/1/174	2	0
202	80	116	/1/200/202	3	0
175	30	35	/1/175	2	0
176	80	93	/1/175/176	3	0
203	80	117	/1/200/203	3	0
177	80	94	/1/175/177	3	0
178	80	95	/1/175/178	3	0
204	80	118	/1/200/204	3	0
179	80	96	/1/175/179	3	0
180	80	97	/1/175/180	3	0
205	80	119	/1/200/205	3	0
181	80	98	/1/175/181	3	0
182	80	99	/1/175/182	3	0
206	80	120	/1/200/206	3	0
183	80	100	/1/175/183	3	0
184	80	101	/1/175/184	3	0
207	80	121	/1/200/207	3	0
185	80	102	/1/175/185	3	0
186	80	103	/1/175/186	3	0
208	80	122	/1/200/208	3	0
209	80	123	/1/200/209	3	0
210	80	124	/1/200/210	3	0
211	80	125	/1/200/211	3	0
212	30	39	/1/212	2	0
213	30	40	/1/213	2	0
217	40	4	/1/3/217	3	0
219	50	25	/1/3/217/219	4	0
220	40	6	/1/3/220	3	0
221	70	25	/1/3/217/219/221	5	0
222	40	7	/1/3/222	3	0
223	50	26	/1/3/222/223	4	0
224	40	8	/1/3/224	3	0
225	50	27	/1/3/217/225	4	0
226	40	9	/1/3/226	3	0
\.


--
-- Data for Name: mdl_context_temp; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_context_temp (id, path, depth, locked) FROM stdin;
\.


--
-- Data for Name: mdl_course; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_course (id, category, sortorder, fullname, shortname, idnumber, summary, summaryformat, format, showgrades, newsitems, startdate, enddate, relativedatesmode, marker, maxbytes, legacyfiles, showreports, visible, visibleold, groupmode, groupmodeforce, defaultgroupingid, lang, calendartype, theme, timecreated, timemodified, requested, enablecompletion, completionnotify, cacherev) FROM stdin;
9	2	10001				\N	1	topics	1	5	0	0	0	0	100	0	1	1	1	0	0	0				1601366448	1601366448	0	1	0	1603517064
1	2	1					0	site	1	3	0	0	0	0	0	0	0	1	1	0	0	0				1599810918	1599811374	0	0	0	1603517064
2	2	20003				\N	1	topics	1	5	0	0	0	0	100	0	1	1	1	0	0	0				1600089305	1600089305	0	1	0	1603517064
26	7	50001	Academic Writing	APH103	5120	\N	1	topics	1	5	0	0	0	0	100	0	1	1	1	0	0	0				1603517327	1603517327	0	1	0	1603517329
25	8	60001	iomad25	IMT25	5871	\N	1	topics	1	5	0	0	0	0	100	0	1	1	1	0	0	0				1603453676	1603453676	0	1	0	1603517064
27	9	30001	iomad26	IMT26	5865	\N	1	topics	1	5	0	0	0	0	100	0	1