--
-- PostgreSQL database dump
--

-- Dumped from database version 10.14 (Ubuntu 10.14-1.pgdg16.04+1)
-- Dumped by pg_dump version 10.14 (Ubuntu 10.14-1.pgdg16.04+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: mdl_analytics_indicator_calc; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_analytics_indicator_calc (
    id bigint NOT NULL,
    starttime bigint NOT NULL,
    endtime bigint NOT NULL,
    contextid bigint NOT NULL,
    sampleorigin character varying(255) DEFAULT ''::character varying NOT NULL,
    sampleid bigint NOT NULL,
    indicator character varying(255) DEFAULT ''::character varying NOT NULL,
    value numeric(10,2),
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_analytics_indicator_calc OWNER TO postgres;

--
-- Name: TABLE mdl_analytics_indicator_calc; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_analytics_indicator_calc IS 'Stored indicator calculations';


--
-- Name: mdl_analytics_indicator_calc_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_analytics_indicator_calc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_analytics_indicator_calc_id_seq OWNER TO postgres;

--
-- Name: mdl_analytics_indicator_calc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_analytics_indicator_calc_id_seq OWNED BY public.mdl_analytics_indicator_calc.id;


--
-- Name: mdl_analytics_models; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_analytics_models (
    id bigint NOT NULL,
    enabled smallint DEFAULT 0 NOT NULL,
    trained smallint DEFAULT 0 NOT NULL,
    name character varying(1333),
    target character varying(255) DEFAULT ''::character varying NOT NULL,
    indicators text NOT NULL,
    timesplitting character varying(255),
    predictionsprocessor character varying(255),
    version bigint NOT NULL,
    contextids text,
    timecreated bigint,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL
);


ALTER TABLE public.mdl_analytics_models OWNER TO postgres;

--
-- Name: TABLE mdl_analytics_models; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_analytics_models IS 'Analytic models.';


--
-- Name: mdl_analytics_models_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_analytics_models_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_analytics_models_id_seq OWNER TO postgres;

--
-- Name: mdl_analytics_models_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_analytics_models_id_seq OWNED BY public.mdl_analytics_models.id;


--
-- Name: mdl_analytics_models_log; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_analytics_models_log (
    id bigint NOT NULL,
    modelid bigint NOT NULL,
    version bigint NOT NULL,
    evaluationmode character varying(50) DEFAULT ''::character varying NOT NULL,
    target character varying(255) DEFAULT ''::character varying NOT NULL,
    indicators text NOT NULL,
    timesplitting character varying(255),
    score numeric(10,5) DEFAULT 0 NOT NULL,
    info text,
    dir text NOT NULL,
    timecreated bigint NOT NULL,
    usermodified bigint NOT NULL
);


ALTER TABLE public.mdl_analytics_models_log OWNER TO postgres;

--
-- Name: TABLE mdl_analytics_models_log; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_analytics_models_log IS 'Analytic models changes during evaluation.';


--
-- Name: mdl_analytics_models_log_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_analytics_models_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_analytics_models_log_id_seq OWNER TO postgres;

--
-- Name: mdl_analytics_models_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_analytics_models_log_id_seq OWNED BY public.mdl_analytics_models_log.id;


--
-- Name: mdl_analytics_predict_samples; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_analytics_predict_samples (
    id bigint NOT NULL,
    modelid bigint NOT NULL,
    analysableid bigint NOT NULL,
    timesplitting character varying(255) DEFAULT ''::character varying NOT NULL,
    rangeindex bigint NOT NULL,
    sampleids text NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_analytics_predict_samples OWNER TO postgres;

--
-- Name: TABLE mdl_analytics_predict_samples; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_analytics_predict_samples IS 'Samples already used for predictions.';


--
-- Name: mdl_analytics_predict_samples_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_analytics_predict_samples_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_analytics_predict_samples_id_seq OWNER TO postgres;

--
-- Name: mdl_analytics_predict_samples_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_analytics_predict_samples_id_seq OWNED BY public.mdl_analytics_predict_samples.id;


--
-- Name: mdl_analytics_prediction_actions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_analytics_prediction_actions (
    id bigint NOT NULL,
    predictionid bigint NOT NULL,
    userid bigint NOT NULL,
    actionname character varying(255) DEFAULT ''::character varying NOT NULL,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_analytics_prediction_actions OWNER TO postgres;

--
-- Name: TABLE mdl_analytics_prediction_actions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_analytics_prediction_actions IS 'Register of user actions over predictions.';


--
-- Name: mdl_analytics_prediction_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_analytics_prediction_actions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_analytics_prediction_actions_id_seq OWNER TO postgres;

--
-- Name: mdl_analytics_prediction_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_analytics_prediction_actions_id_seq OWNED BY public.mdl_analytics_prediction_actions.id;


--
-- Name: mdl_analytics_predictions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_analytics_predictions (
    id bigint NOT NULL,
    modelid bigint NOT NULL,
    contextid bigint NOT NULL,
    sampleid bigint NOT NULL,
    rangeindex integer NOT NULL,
    prediction numeric(10,2) NOT NULL,
    predictionscore numeric(10,5) NOT NULL,
    calculations text NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timestart bigint,
    timeend bigint
);


ALTER TABLE public.mdl_analytics_predictions OWNER TO postgres;

--
-- Name: TABLE mdl_analytics_predictions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_analytics_predictions IS 'Predictions';


--
-- Name: mdl_analytics_predictions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_analytics_predictions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_analytics_predictions_id_seq OWNER TO postgres;

--
-- Name: mdl_analytics_predictions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_analytics_predictions_id_seq OWNED BY public.mdl_analytics_predictions.id;


--
-- Name: mdl_analytics_train_samples; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_analytics_train_samples (
    id bigint NOT NULL,
    modelid bigint NOT NULL,
    analysableid bigint NOT NULL,
    timesplitting character varying(255) DEFAULT ''::character varying NOT NULL,
    sampleids text NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_analytics_train_samples OWNER TO postgres;

--
-- Name: TABLE mdl_analytics_train_samples; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_analytics_train_samples IS 'Samples used for training';


--
-- Name: mdl_analytics_train_samples_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_analytics_train_samples_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_analytics_train_samples_id_seq OWNER TO postgres;

--
-- Name: mdl_analytics_train_samples_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_analytics_train_samples_id_seq OWNED BY public.mdl_analytics_train_samples.id;


--
-- Name: mdl_analytics_used_analysables; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_analytics_used_analysables (
    id bigint NOT NULL,
    modelid bigint NOT NULL,
    action character varying(50) DEFAULT ''::character varying NOT NULL,
    analysableid bigint NOT NULL,
    firstanalysis bigint NOT NULL,
    timeanalysed bigint NOT NULL
);


ALTER TABLE public.mdl_analytics_used_analysables OWNER TO postgres;

--
-- Name: TABLE mdl_analytics_used_analysables; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_analytics_used_analysables IS 'List of analysables used by each model';


--
-- Name: mdl_analytics_used_analysables_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_analytics_used_analysables_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_analytics_used_analysables_id_seq OWNER TO postgres;

--
-- Name: mdl_analytics_used_analysables_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_analytics_used_analysables_id_seq OWNED BY public.mdl_analytics_used_analysables.id;


--
-- Name: mdl_analytics_used_files; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_analytics_used_files (
    id bigint NOT NULL,
    modelid bigint DEFAULT 0 NOT NULL,
    fileid bigint DEFAULT 0 NOT NULL,
    action character varying(50) DEFAULT ''::character varying NOT NULL,
    "time" bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_analytics_used_files OWNER TO postgres;

--
-- Name: TABLE mdl_analytics_used_files; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_analytics_used_files IS 'Files that have already been used for training and prediction.';


--
-- Name: mdl_analytics_used_files_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_analytics_used_files_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_analytics_used_files_id_seq OWNER TO postgres;

--
-- Name: mdl_analytics_used_files_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_analytics_used_files_id_seq OWNED BY public.mdl_analytics_used_files.id;


--
-- Name: mdl_assign; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assign (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text NOT NULL,
    introformat smallint DEFAULT 0 NOT NULL,
    alwaysshowdescription smallint DEFAULT 0 NOT NULL,
    nosubmissions smallint DEFAULT 0 NOT NULL,
    submissiondrafts smallint DEFAULT 0 NOT NULL,
    sendnotifications smallint DEFAULT 0 NOT NULL,
    sendlatenotifications smallint DEFAULT 0 NOT NULL,
    duedate bigint DEFAULT 0 NOT NULL,
    allowsubmissionsfromdate bigint DEFAULT 0 NOT NULL,
    grade bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    requiresubmissionstatement smallint DEFAULT 0 NOT NULL,
    completionsubmit smallint DEFAULT 0 NOT NULL,
    cutoffdate bigint DEFAULT 0 NOT NULL,
    gradingduedate bigint DEFAULT 0 NOT NULL,
    teamsubmission smallint DEFAULT 0 NOT NULL,
    requireallteammemberssubmit smallint DEFAULT 0 NOT NULL,
    teamsubmissiongroupingid bigint DEFAULT 0 NOT NULL,
    blindmarking smallint DEFAULT 0 NOT NULL,
    hidegrader smallint DEFAULT 0 NOT NULL,
    revealidentities smallint DEFAULT 0 NOT NULL,
    attemptreopenmethod character varying(10) DEFAULT 'none'::character varying NOT NULL,
    maxattempts integer DEFAULT '-1'::integer NOT NULL,
    markingworkflow smallint DEFAULT 0 NOT NULL,
    markingallocation smallint DEFAULT 0 NOT NULL,
    sendstudentnotifications smallint DEFAULT 1 NOT NULL,
    preventsubmissionnotingroup smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_assign OWNER TO postgres;

--
-- Name: TABLE mdl_assign; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assign IS 'This table saves information about an instance of mod_assign in a course.';


--
-- Name: mdl_assign_grades; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assign_grades (
    id bigint NOT NULL,
    assignment bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    grader bigint DEFAULT 0 NOT NULL,
    grade numeric(10,5) DEFAULT 0,
    attemptnumber bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_assign_grades OWNER TO postgres;

--
-- Name: TABLE mdl_assign_grades; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assign_grades IS 'Grading information about a single assignment submission.';


--
-- Name: mdl_assign_grades_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assign_grades_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assign_grades_id_seq OWNER TO postgres;

--
-- Name: mdl_assign_grades_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assign_grades_id_seq OWNED BY public.mdl_assign_grades.id;


--
-- Name: mdl_assign_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assign_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assign_id_seq OWNER TO postgres;

--
-- Name: mdl_assign_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assign_id_seq OWNED BY public.mdl_assign.id;


--
-- Name: mdl_assign_overrides; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assign_overrides (
    id bigint NOT NULL,
    assignid bigint DEFAULT 0 NOT NULL,
    groupid bigint,
    userid bigint,
    sortorder bigint,
    allowsubmissionsfromdate bigint,
    duedate bigint,
    cutoffdate bigint
);


ALTER TABLE public.mdl_assign_overrides OWNER TO postgres;

--
-- Name: TABLE mdl_assign_overrides; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assign_overrides IS 'The overrides to assign settings.';


--
-- Name: mdl_assign_overrides_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assign_overrides_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assign_overrides_id_seq OWNER TO postgres;

--
-- Name: mdl_assign_overrides_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assign_overrides_id_seq OWNED BY public.mdl_assign_overrides.id;


--
-- Name: mdl_assign_plugin_config; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assign_plugin_config (
    id bigint NOT NULL,
    assignment bigint DEFAULT 0 NOT NULL,
    plugin character varying(28) DEFAULT ''::character varying NOT NULL,
    subtype character varying(28) DEFAULT ''::character varying NOT NULL,
    name character varying(28) DEFAULT ''::character varying NOT NULL,
    value text
);


ALTER TABLE public.mdl_assign_plugin_config OWNER TO postgres;

--
-- Name: TABLE mdl_assign_plugin_config; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assign_plugin_config IS 'Config data for an instance of a plugin in an assignment.';


--
-- Name: mdl_assign_plugin_config_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assign_plugin_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assign_plugin_config_id_seq OWNER TO postgres;

--
-- Name: mdl_assign_plugin_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assign_plugin_config_id_seq OWNED BY public.mdl_assign_plugin_config.id;


--
-- Name: mdl_assign_submission; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assign_submission (
    id bigint NOT NULL,
    assignment bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    status character varying(10),
    groupid bigint DEFAULT 0 NOT NULL,
    attemptnumber bigint DEFAULT 0 NOT NULL,
    latest smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_assign_submission OWNER TO postgres;

--
-- Name: TABLE mdl_assign_submission; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assign_submission IS 'This table keeps information about student interactions with the mod/assign. This is limited to metadata about a student submission but does not include the submission itself which is stored by plugins.';


--
-- Name: mdl_assign_submission_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assign_submission_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assign_submission_id_seq OWNER TO postgres;

--
-- Name: mdl_assign_submission_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assign_submission_id_seq OWNED BY public.mdl_assign_submission.id;


--
-- Name: mdl_assign_user_flags; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assign_user_flags (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    assignment bigint DEFAULT 0 NOT NULL,
    locked bigint DEFAULT 0 NOT NULL,
    mailed smallint DEFAULT 0 NOT NULL,
    extensionduedate bigint DEFAULT 0 NOT NULL,
    workflowstate character varying(20),
    allocatedmarker bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_assign_user_flags OWNER TO postgres;

--
-- Name: TABLE mdl_assign_user_flags; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assign_user_flags IS 'List of flags that can be set for a single user in a single assignment.';


--
-- Name: mdl_assign_user_flags_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assign_user_flags_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assign_user_flags_id_seq OWNER TO postgres;

--
-- Name: mdl_assign_user_flags_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assign_user_flags_id_seq OWNED BY public.mdl_assign_user_flags.id;


--
-- Name: mdl_assign_user_mapping; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assign_user_mapping (
    id bigint NOT NULL,
    assignment bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_assign_user_mapping OWNER TO postgres;

--
-- Name: TABLE mdl_assign_user_mapping; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assign_user_mapping IS 'Map an assignment specific id number to a user';


--
-- Name: mdl_assign_user_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assign_user_mapping_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assign_user_mapping_id_seq OWNER TO postgres;

--
-- Name: mdl_assign_user_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assign_user_mapping_id_seq OWNED BY public.mdl_assign_user_mapping.id;


--
-- Name: mdl_assignfeedback_comments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assignfeedback_comments (
    id bigint NOT NULL,
    assignment bigint DEFAULT 0 NOT NULL,
    grade bigint DEFAULT 0 NOT NULL,
    commenttext text,
    commentformat smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_assignfeedback_comments OWNER TO postgres;

--
-- Name: TABLE mdl_assignfeedback_comments; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assignfeedback_comments IS 'Text feedback for submitted assignments';


--
-- Name: mdl_assignfeedback_comments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assignfeedback_comments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assignfeedback_comments_id_seq OWNER TO postgres;

--
-- Name: mdl_assignfeedback_comments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assignfeedback_comments_id_seq OWNED BY public.mdl_assignfeedback_comments.id;


--
-- Name: mdl_assignfeedback_editpdf_annot; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assignfeedback_editpdf_annot (
    id bigint NOT NULL,
    gradeid bigint DEFAULT 0 NOT NULL,
    pageno bigint DEFAULT 0 NOT NULL,
    x bigint DEFAULT 0,
    y bigint DEFAULT 0,
    endx bigint DEFAULT 0,
    endy bigint DEFAULT 0,
    path text,
    type character varying(10) DEFAULT 'line'::character varying,
    colour character varying(10) DEFAULT 'black'::character varying,
    draft smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_assignfeedback_editpdf_annot OWNER TO postgres;

--
-- Name: TABLE mdl_assignfeedback_editpdf_annot; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assignfeedback_editpdf_annot IS 'stores annotations added to pdfs submitted by students';


--
-- Name: mdl_assignfeedback_editpdf_annot_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assignfeedback_editpdf_annot_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assignfeedback_editpdf_annot_id_seq OWNER TO postgres;

--
-- Name: mdl_assignfeedback_editpdf_annot_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assignfeedback_editpdf_annot_id_seq OWNED BY public.mdl_assignfeedback_editpdf_annot.id;


--
-- Name: mdl_assignfeedback_editpdf_cmnt; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assignfeedback_editpdf_cmnt (
    id bigint NOT NULL,
    gradeid bigint DEFAULT 0 NOT NULL,
    x bigint DEFAULT 0,
    y bigint DEFAULT 0,
    width bigint DEFAULT 120,
    rawtext text,
    pageno bigint DEFAULT 0 NOT NULL,
    colour character varying(10) DEFAULT 'black'::character varying,
    draft smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_assignfeedback_editpdf_cmnt OWNER TO postgres;

--
-- Name: TABLE mdl_assignfeedback_editpdf_cmnt; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assignfeedback_editpdf_cmnt IS 'Stores comments added to pdfs';


--
-- Name: mdl_assignfeedback_editpdf_cmnt_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assignfeedback_editpdf_cmnt_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assignfeedback_editpdf_cmnt_id_seq OWNER TO postgres;

--
-- Name: mdl_assignfeedback_editpdf_cmnt_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assignfeedback_editpdf_cmnt_id_seq OWNED BY public.mdl_assignfeedback_editpdf_cmnt.id;


--
-- Name: mdl_assignfeedback_editpdf_queue; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assignfeedback_editpdf_queue (
    id bigint NOT NULL,
    submissionid bigint NOT NULL,
    submissionattempt bigint NOT NULL,
    attemptedconversions bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_assignfeedback_editpdf_queue OWNER TO postgres;

--
-- Name: TABLE mdl_assignfeedback_editpdf_queue; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assignfeedback_editpdf_queue IS 'Queue for processing.';


--
-- Name: mdl_assignfeedback_editpdf_queue_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assignfeedback_editpdf_queue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assignfeedback_editpdf_queue_id_seq OWNER TO postgres;

--
-- Name: mdl_assignfeedback_editpdf_queue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assignfeedback_editpdf_queue_id_seq OWNED BY public.mdl_assignfeedback_editpdf_queue.id;


--
-- Name: mdl_assignfeedback_editpdf_quick; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assignfeedback_editpdf_quick (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    rawtext text NOT NULL,
    width bigint DEFAULT 120 NOT NULL,
    colour character varying(10) DEFAULT 'yellow'::character varying
);


ALTER TABLE public.mdl_assignfeedback_editpdf_quick OWNER TO postgres;

--
-- Name: TABLE mdl_assignfeedback_editpdf_quick; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assignfeedback_editpdf_quick IS 'Stores teacher specified quicklist comments';


--
-- Name: mdl_assignfeedback_editpdf_quick_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assignfeedback_editpdf_quick_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assignfeedback_editpdf_quick_id_seq OWNER TO postgres;

--
-- Name: mdl_assignfeedback_editpdf_quick_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assignfeedback_editpdf_quick_id_seq OWNED BY public.mdl_assignfeedback_editpdf_quick.id;


--
-- Name: mdl_assignfeedback_editpdf_rot; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assignfeedback_editpdf_rot (
    id bigint NOT NULL,
    gradeid bigint DEFAULT 0 NOT NULL,
    pageno bigint DEFAULT 0 NOT NULL,
    pathnamehash text NOT NULL,
    isrotated smallint DEFAULT 0 NOT NULL,
    degree bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_assignfeedback_editpdf_rot OWNER TO postgres;

--
-- Name: TABLE mdl_assignfeedback_editpdf_rot; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assignfeedback_editpdf_rot IS 'Stores rotation information of a page.';


--
-- Name: mdl_assignfeedback_editpdf_rot_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assignfeedback_editpdf_rot_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assignfeedback_editpdf_rot_id_seq OWNER TO postgres;

--
-- Name: mdl_assignfeedback_editpdf_rot_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assignfeedback_editpdf_rot_id_seq OWNED BY public.mdl_assignfeedback_editpdf_rot.id;


--
-- Name: mdl_assignfeedback_file; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assignfeedback_file (
    id bigint NOT NULL,
    assignment bigint DEFAULT 0 NOT NULL,
    grade bigint DEFAULT 0 NOT NULL,
    numfiles bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_assignfeedback_file OWNER TO postgres;

--
-- Name: TABLE mdl_assignfeedback_file; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assignfeedback_file IS 'Stores info about the number of files submitted by a student.';


--
-- Name: mdl_assignfeedback_file_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assignfeedback_file_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assignfeedback_file_id_seq OWNER TO postgres;

--
-- Name: mdl_assignfeedback_file_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assignfeedback_file_id_seq OWNED BY public.mdl_assignfeedback_file.id;


--
-- Name: mdl_assignment; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assignment (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text NOT NULL,
    introformat smallint DEFAULT 0 NOT NULL,
    assignmenttype character varying(50) DEFAULT ''::character varying NOT NULL,
    resubmit smallint DEFAULT 0 NOT NULL,
    preventlate smallint DEFAULT 0 NOT NULL,
    emailteachers smallint DEFAULT 0 NOT NULL,
    var1 bigint DEFAULT 0,
    var2 bigint DEFAULT 0,
    var3 bigint DEFAULT 0,
    var4 bigint DEFAULT 0,
    var5 bigint DEFAULT 0,
    maxbytes bigint DEFAULT 100000 NOT NULL,
    timedue bigint DEFAULT 0 NOT NULL,
    timeavailable bigint DEFAULT 0 NOT NULL,
    grade bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_assignment OWNER TO postgres;

--
-- Name: TABLE mdl_assignment; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assignment IS 'Defines assignments';


--
-- Name: mdl_assignment_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assignment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assignment_id_seq OWNER TO postgres;

--
-- Name: mdl_assignment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assignment_id_seq OWNED BY public.mdl_assignment.id;


--
-- Name: mdl_assignment_submissions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assignment_submissions (
    id bigint NOT NULL,
    assignment bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    numfiles bigint DEFAULT 0 NOT NULL,
    data1 text,
    data2 text,
    grade bigint DEFAULT 0 NOT NULL,
    submissioncomment text NOT NULL,
    format smallint DEFAULT 0 NOT NULL,
    teacher bigint DEFAULT 0 NOT NULL,
    timemarked bigint DEFAULT 0 NOT NULL,
    mailed smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_assignment_submissions OWNER TO postgres;

--
-- Name: TABLE mdl_assignment_submissions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assignment_submissions IS 'Info about submitted assignments';


--
-- Name: mdl_assignment_submissions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assignment_submissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assignment_submissions_id_seq OWNER TO postgres;

--
-- Name: mdl_assignment_submissions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assignment_submissions_id_seq OWNED BY public.mdl_assignment_submissions.id;


--
-- Name: mdl_assignment_upgrade; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assignment_upgrade (
    id bigint NOT NULL,
    oldcmid bigint DEFAULT 0 NOT NULL,
    oldinstance bigint DEFAULT 0 NOT NULL,
    newcmid bigint DEFAULT 0 NOT NULL,
    newinstance bigint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_assignment_upgrade OWNER TO postgres;

--
-- Name: TABLE mdl_assignment_upgrade; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assignment_upgrade IS 'Info about upgraded assignments';


--
-- Name: mdl_assignment_upgrade_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assignment_upgrade_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assignment_upgrade_id_seq OWNER TO postgres;

--
-- Name: mdl_assignment_upgrade_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assignment_upgrade_id_seq OWNED BY public.mdl_assignment_upgrade.id;


--
-- Name: mdl_assignsubmission_file; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assignsubmission_file (
    id bigint NOT NULL,
    assignment bigint DEFAULT 0 NOT NULL,
    submission bigint DEFAULT 0 NOT NULL,
    numfiles bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_assignsubmission_file OWNER TO postgres;

--
-- Name: TABLE mdl_assignsubmission_file; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assignsubmission_file IS 'Info about file submissions for assignments';


--
-- Name: mdl_assignsubmission_file_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assignsubmission_file_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assignsubmission_file_id_seq OWNER TO postgres;

--
-- Name: mdl_assignsubmission_file_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assignsubmission_file_id_seq OWNED BY public.mdl_assignsubmission_file.id;


--
-- Name: mdl_assignsubmission_onlinetext; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_assignsubmission_onlinetext (
    id bigint NOT NULL,
    assignment bigint DEFAULT 0 NOT NULL,
    submission bigint DEFAULT 0 NOT NULL,
    onlinetext text,
    onlineformat smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_assignsubmission_onlinetext OWNER TO postgres;

--
-- Name: TABLE mdl_assignsubmission_onlinetext; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_assignsubmission_onlinetext IS 'Info about onlinetext submission';


--
-- Name: mdl_assignsubmission_onlinetext_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assignsubmission_onlinetext_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assignsubmission_onlinetext_id_seq OWNER TO postgres;

--
-- Name: mdl_assignsubmission_onlinetext_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_assignsubmission_onlinetext_id_seq OWNED BY public.mdl_assignsubmission_onlinetext.id;


--
-- Name: mdl_auth_oauth2_linked_login; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_auth_oauth2_linked_login (
    id bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL,
    userid bigint NOT NULL,
    issuerid bigint NOT NULL,
    username character varying(255) DEFAULT ''::character varying NOT NULL,
    email text NOT NULL,
    confirmtoken character varying(64) DEFAULT ''::character varying NOT NULL,
    confirmtokenexpires bigint
);


ALTER TABLE public.mdl_auth_oauth2_linked_login OWNER TO postgres;

--
-- Name: TABLE mdl_auth_oauth2_linked_login; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_auth_oauth2_linked_login IS 'Accounts linked to a users Moodle account.';


--
-- Name: mdl_auth_oauth2_linked_login_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_auth_oauth2_linked_login_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_auth_oauth2_linked_login_id_seq OWNER TO postgres;

--
-- Name: mdl_auth_oauth2_linked_login_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_auth_oauth2_linked_login_id_seq OWNED BY public.mdl_auth_oauth2_linked_login.id;


--
-- Name: mdl_backup_controllers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_backup_controllers (
    id bigint NOT NULL,
    backupid character varying(32) DEFAULT ''::character varying NOT NULL,
    operation character varying(20) DEFAULT 'backup'::character varying NOT NULL,
    type character varying(10) DEFAULT ''::character varying NOT NULL,
    itemid bigint NOT NULL,
    format character varying(20) DEFAULT ''::character varying NOT NULL,
    interactive smallint NOT NULL,
    purpose smallint NOT NULL,
    userid bigint NOT NULL,
    status smallint NOT NULL,
    execution smallint NOT NULL,
    executiontime bigint NOT NULL,
    checksum character varying(32) DEFAULT ''::character varying NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    progress numeric(15,14) DEFAULT 0 NOT NULL,
    controller text NOT NULL
);


ALTER TABLE public.mdl_backup_controllers OWNER TO postgres;

--
-- Name: TABLE mdl_backup_controllers; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_backup_controllers IS 'To store the backup_controllers as they are used';


--
-- Name: mdl_backup_controllers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_backup_controllers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_backup_controllers_id_seq OWNER TO postgres;

--
-- Name: mdl_backup_controllers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_backup_controllers_id_seq OWNED BY public.mdl_backup_controllers.id;


--
-- Name: mdl_backup_courses; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_backup_courses (
    id bigint NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    laststarttime bigint DEFAULT 0 NOT NULL,
    lastendtime bigint DEFAULT 0 NOT NULL,
    laststatus character varying(1) DEFAULT '5'::character varying NOT NULL,
    nextstarttime bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_backup_courses OWNER TO postgres;

--
-- Name: TABLE mdl_backup_courses; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_backup_courses IS 'To store every course backup status';


--
-- Name: mdl_backup_courses_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_backup_courses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_backup_courses_id_seq OWNER TO postgres;

--
-- Name: mdl_backup_courses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_backup_courses_id_seq OWNED BY public.mdl_backup_courses.id;


--
-- Name: mdl_backup_logs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_backup_logs (
    id bigint NOT NULL,
    backupid character varying(32) DEFAULT ''::character varying NOT NULL,
    loglevel smallint NOT NULL,
    message text NOT NULL,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_backup_logs OWNER TO postgres;

--
-- Name: TABLE mdl_backup_logs; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_backup_logs IS 'To store all the logs from backup and restore operations (by db logger)';


--
-- Name: mdl_backup_logs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_backup_logs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_backup_logs_id_seq OWNER TO postgres;

--
-- Name: mdl_backup_logs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_backup_logs_id_seq OWNED BY public.mdl_backup_logs.id;


--
-- Name: mdl_badge; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_badge (
    id bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    description text,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    usercreated bigint NOT NULL,
    usermodified bigint NOT NULL,
    issuername character varying(255) DEFAULT ''::character varying NOT NULL,
    issuerurl character varying(255) DEFAULT ''::character varying NOT NULL,
    issuercontact character varying(255),
    expiredate bigint,
    expireperiod bigint,
    type smallint DEFAULT 1 NOT NULL,
    courseid bigint,
    message text NOT NULL,
    messagesubject text NOT NULL,
    attachment smallint DEFAULT 1 NOT NULL,
    notification smallint DEFAULT 1 NOT NULL,
    status smallint DEFAULT 0 NOT NULL,
    nextcron bigint,
    version character varying(255),
    language character varying(255),
    imageauthorname character varying(255),
    imageauthoremail character varying(255),
    imageauthorurl character varying(255),
    imagecaption text
);


ALTER TABLE public.mdl_badge OWNER TO postgres;

--
-- Name: TABLE mdl_badge; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_badge IS 'Defines badge';


--
-- Name: mdl_badge_alignment; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_badge_alignment (
    id bigint NOT NULL,
    badgeid bigint DEFAULT 0 NOT NULL,
    targetname character varying(255) DEFAULT ''::character varying NOT NULL,
    targeturl character varying(255) DEFAULT ''::character varying NOT NULL,
    targetdescription text,
    targetframework character varying(255),
    targetcode character varying(255)
);


ALTER TABLE public.mdl_badge_alignment OWNER TO postgres;

--
-- Name: TABLE mdl_badge_alignment; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_badge_alignment IS 'Defines alignment for badges';


--
-- Name: mdl_badge_alignment_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_badge_alignment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_badge_alignment_id_seq OWNER TO postgres;

--
-- Name: mdl_badge_alignment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_badge_alignment_id_seq OWNED BY public.mdl_badge_alignment.id;


--
-- Name: mdl_badge_backpack; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_badge_backpack (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    email character varying(100) DEFAULT ''::character varying NOT NULL,
    backpackuid bigint NOT NULL,
    autosync smallint DEFAULT 0 NOT NULL,
    password character varying(50),
    externalbackpackid bigint
);


ALTER TABLE public.mdl_badge_backpack OWNER TO postgres;

--
-- Name: TABLE mdl_badge_backpack; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_badge_backpack IS 'Defines settings for connecting external backpack';


--
-- Name: mdl_badge_backpack_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_badge_backpack_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_badge_backpack_id_seq OWNER TO postgres;

--
-- Name: mdl_badge_backpack_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_badge_backpack_id_seq OWNED BY public.mdl_badge_backpack.id;


--
-- Name: mdl_badge_backpack_oauth2; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_badge_backpack_oauth2 (
    id bigint NOT NULL,
    usermodified bigint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    userid bigint NOT NULL,
    issuerid bigint NOT NULL,
    externalbackpackid bigint NOT NULL,
    token text NOT NULL,
    refreshtoken text NOT NULL,
    expires bigint,
    scope text
);


ALTER TABLE public.mdl_badge_backpack_oauth2 OWNER TO postgres;

--
-- Name: TABLE mdl_badge_backpack_oauth2; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_badge_backpack_oauth2 IS 'Default comment for the table, please edit me';


--
-- Name: mdl_badge_backpack_oauth2_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_badge_backpack_oauth2_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_badge_backpack_oauth2_id_seq OWNER TO postgres;

--
-- Name: mdl_badge_backpack_oauth2_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_badge_backpack_oauth2_id_seq OWNED BY public.mdl_badge_backpack_oauth2.id;


--
-- Name: mdl_badge_criteria; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_badge_criteria (
    id bigint NOT NULL,
    badgeid bigint DEFAULT 0 NOT NULL,
    criteriatype bigint,
    method smallint DEFAULT 1 NOT NULL,
    description text,
    descriptionformat smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_badge_criteria OWNER TO postgres;

--
-- Name: TABLE mdl_badge_criteria; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_badge_criteria IS 'Defines criteria for issuing badges';


--
-- Name: mdl_badge_criteria_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_badge_criteria_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_badge_criteria_id_seq OWNER TO postgres;

--
-- Name: mdl_badge_criteria_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_badge_criteria_id_seq OWNED BY public.mdl_badge_criteria.id;


--
-- Name: mdl_badge_criteria_met; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_badge_criteria_met (
    id bigint NOT NULL,
    issuedid bigint,
    critid bigint NOT NULL,
    userid bigint NOT NULL,
    datemet bigint NOT NULL
);


ALTER TABLE public.mdl_badge_criteria_met OWNER TO postgres;

--
-- Name: TABLE mdl_badge_criteria_met; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_badge_criteria_met IS 'Defines criteria that were met for an issued badge';


--
-- Name: mdl_badge_criteria_met_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_badge_criteria_met_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_badge_criteria_met_id_seq OWNER TO postgres;

--
-- Name: mdl_badge_criteria_met_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_badge_criteria_met_id_seq OWNED BY public.mdl_badge_criteria_met.id;


--
-- Name: mdl_badge_criteria_param; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_badge_criteria_param (
    id bigint NOT NULL,
    critid bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    value character varying(255)
);


ALTER TABLE public.mdl_badge_criteria_param OWNER TO postgres;

--
-- Name: TABLE mdl_badge_criteria_param; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_badge_criteria_param IS 'Defines parameters for badges criteria';


--
-- Name: mdl_badge_criteria_param_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_badge_criteria_param_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_badge_criteria_param_id_seq OWNER TO postgres;

--
-- Name: mdl_badge_criteria_param_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_badge_criteria_param_id_seq OWNED BY public.mdl_badge_criteria_param.id;


--
-- Name: mdl_badge_endorsement; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_badge_endorsement (
    id bigint NOT NULL,
    badgeid bigint DEFAULT 0 NOT NULL,
    issuername character varying(255) DEFAULT ''::character varying NOT NULL,
    issuerurl character varying(255) DEFAULT ''::character varying NOT NULL,
    issueremail character varying(255) DEFAULT ''::character varying NOT NULL,
    claimid character varying(255),
    claimcomment text,
    dateissued bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_badge_endorsement OWNER TO postgres;

--
-- Name: TABLE mdl_badge_endorsement; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_badge_endorsement IS 'Defines endorsement for badge';


--
-- Name: mdl_badge_endorsement_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_badge_endorsement_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_badge_endorsement_id_seq OWNER TO postgres;

--
-- Name: mdl_badge_endorsement_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_badge_endorsement_id_seq OWNED BY public.mdl_badge_endorsement.id;


--
-- Name: mdl_badge_external; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_badge_external (
    id bigint NOT NULL,
    backpackid bigint NOT NULL,
    collectionid bigint NOT NULL,
    entityid character varying(255),
    assertion text
);


ALTER TABLE public.mdl_badge_external OWNER TO postgres;

--
-- Name: TABLE mdl_badge_external; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_badge_external IS 'Setting for external badges display';


--
-- Name: mdl_badge_external_backpack; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_badge_external_backpack (
    id bigint NOT NULL,
    backpackapiurl character varying(255) DEFAULT ''::character varying NOT NULL,
    backpackweburl character varying(255) DEFAULT ''::character varying NOT NULL,
    apiversion character varying(12) DEFAULT '1.0'::character varying NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL,
    password character varying(255),
    oauth2_issuerid bigint
);


ALTER TABLE public.mdl_badge_external_backpack OWNER TO postgres;

--
-- Name: TABLE mdl_badge_external_backpack; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_badge_external_backpack IS 'Defines settings for site level backpacks that a user can connect to.';


--
-- Name: mdl_badge_external_backpack_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_badge_external_backpack_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_badge_external_backpack_id_seq OWNER TO postgres;

--
-- Name: mdl_badge_external_backpack_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_badge_external_backpack_id_seq OWNED BY public.mdl_badge_external_backpack.id;


--
-- Name: mdl_badge_external_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_badge_external_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_badge_external_id_seq OWNER TO postgres;

--
-- Name: mdl_badge_external_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_badge_external_id_seq OWNED BY public.mdl_badge_external.id;


--
-- Name: mdl_badge_external_identifier; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_badge_external_identifier (
    id bigint NOT NULL,
    sitebackpackid bigint NOT NULL,
    internalid character varying(128) DEFAULT ''::character varying NOT NULL,
    externalid character varying(128) DEFAULT ''::character varying NOT NULL,
    type character varying(16) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_badge_external_identifier OWNER TO postgres;

--
-- Name: TABLE mdl_badge_external_identifier; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_badge_external_identifier IS 'Setting for external badges mappings';


--
-- Name: mdl_badge_external_identifier_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_badge_external_identifier_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_badge_external_identifier_id_seq OWNER TO postgres;

--
-- Name: mdl_badge_external_identifier_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_badge_external_identifier_id_seq OWNED BY public.mdl_badge_external_identifier.id;


--
-- Name: mdl_badge_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_badge_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_badge_id_seq OWNER TO postgres;

--
-- Name: mdl_badge_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_badge_id_seq OWNED BY public.mdl_badge.id;


--
-- Name: mdl_badge_issued; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_badge_issued (
    id bigint NOT NULL,
    badgeid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    uniquehash text NOT NULL,
    dateissued bigint DEFAULT 0 NOT NULL,
    dateexpire bigint,
    visible smallint DEFAULT 0 NOT NULL,
    issuernotified bigint
);


ALTER TABLE public.mdl_badge_issued OWNER TO postgres;

--
-- Name: TABLE mdl_badge_issued; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_badge_issued IS 'Defines issued badges';


--
-- Name: mdl_badge_issued_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_badge_issued_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_badge_issued_id_seq OWNER TO postgres;

--
-- Name: mdl_badge_issued_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_badge_issued_id_seq OWNED BY public.mdl_badge_issued.id;


--
-- Name: mdl_badge_manual_award; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_badge_manual_award (
    id bigint NOT NULL,
    badgeid bigint NOT NULL,
    recipientid bigint NOT NULL,
    issuerid bigint NOT NULL,
    issuerrole bigint NOT NULL,
    datemet bigint NOT NULL
);


ALTER TABLE public.mdl_badge_manual_award OWNER TO postgres;

--
-- Name: TABLE mdl_badge_manual_award; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_badge_manual_award IS 'Track manual award criteria for badges';


--
-- Name: mdl_badge_manual_award_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_badge_manual_award_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_badge_manual_award_id_seq OWNER TO postgres;

--
-- Name: mdl_badge_manual_award_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_badge_manual_award_id_seq OWNED BY public.mdl_badge_manual_award.id;


--
-- Name: mdl_badge_related; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_badge_related (
    id bigint NOT NULL,
    badgeid bigint DEFAULT 0 NOT NULL,
    relatedbadgeid bigint
);


ALTER TABLE public.mdl_badge_related OWNER TO postgres;

--
-- Name: TABLE mdl_badge_related; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_badge_related IS 'Defines badge related for badges';


--
-- Name: mdl_badge_related_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_badge_related_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_badge_related_id_seq OWNER TO postgres;

--
-- Name: mdl_badge_related_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_badge_related_id_seq OWNED BY public.mdl_badge_related.id;


--
-- Name: mdl_block; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_block (
    id bigint NOT NULL,
    name character varying(40) DEFAULT ''::character varying NOT NULL,
    cron bigint DEFAULT 0 NOT NULL,
    lastcron bigint DEFAULT 0 NOT NULL,
    visible smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_block OWNER TO postgres;

--
-- Name: TABLE mdl_block; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_block IS 'contains all installed blocks';


--
-- Name: mdl_block_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_block_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_block_id_seq OWNER TO postgres;

--
-- Name: mdl_block_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_block_id_seq OWNED BY public.mdl_block.id;


--
-- Name: mdl_block_instances; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_block_instances (
    id bigint NOT NULL,
    blockname character varying(40) DEFAULT ''::character varying NOT NULL,
    parentcontextid bigint NOT NULL,
    showinsubcontexts smallint NOT NULL,
    requiredbytheme smallint DEFAULT 0 NOT NULL,
    pagetypepattern character varying(64) DEFAULT ''::character varying NOT NULL,
    subpagepattern character varying(16),
    defaultregion character varying(16) DEFAULT ''::character varying NOT NULL,
    defaultweight bigint NOT NULL,
    configdata text,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_block_instances OWNER TO postgres;

--
-- Name: TABLE mdl_block_instances; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_block_instances IS 'This table stores block instances. The type of block this is is given by the blockname column. The places this block instance appears is controlled by the parentcontexid, showinsubcontexts, pagetypepattern and subpagepattern fields. Where the block a';


--
-- Name: mdl_block_instances_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_block_instances_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_block_instances_id_seq OWNER TO postgres;

--
-- Name: mdl_block_instances_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_block_instances_id_seq OWNED BY public.mdl_block_instances.id;


--
-- Name: mdl_block_positions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_block_positions (
    id bigint NOT NULL,
    blockinstanceid bigint NOT NULL,
    contextid bigint NOT NULL,
    pagetype character varying(64) DEFAULT ''::character varying NOT NULL,
    subpage character varying(16) DEFAULT ''::character varying NOT NULL,
    visible smallint NOT NULL,
    region character varying(16) DEFAULT ''::character varying NOT NULL,
    weight bigint NOT NULL
);


ALTER TABLE public.mdl_block_positions OWNER TO postgres;

--
-- Name: TABLE mdl_block_positions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_block_positions IS 'Stores the position of a sticky block_instance on a another page than the one where it was added.';


--
-- Name: mdl_block_positions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_block_positions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_block_positions_id_seq OWNER TO postgres;

--
-- Name: mdl_block_positions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_block_positions_id_seq OWNED BY public.mdl_block_positions.id;


--
-- Name: mdl_block_recent_activity; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_block_recent_activity (
    id bigint NOT NULL,
    courseid bigint NOT NULL,
    cmid bigint NOT NULL,
    timecreated bigint NOT NULL,
    userid bigint NOT NULL,
    action smallint NOT NULL,
    modname character varying(20)
);


ALTER TABLE public.mdl_block_recent_activity OWNER TO postgres;

--
-- Name: TABLE mdl_block_recent_activity; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_block_recent_activity IS 'Recent activity block';


--
-- Name: mdl_block_recent_activity_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_block_recent_activity_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_block_recent_activity_id_seq OWNER TO postgres;

--
-- Name: mdl_block_recent_activity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_block_recent_activity_id_seq OWNED BY public.mdl_block_recent_activity.id;


--
-- Name: mdl_block_recentlyaccesseditems; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_block_recentlyaccesseditems (
    id bigint NOT NULL,
    courseid bigint NOT NULL,
    cmid bigint NOT NULL,
    userid bigint NOT NULL,
    timeaccess bigint NOT NULL
);


ALTER TABLE public.mdl_block_recentlyaccesseditems OWNER TO postgres;

--
-- Name: TABLE mdl_block_recentlyaccesseditems; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_block_recentlyaccesseditems IS 'Most recently accessed items accessed by a user';


--
-- Name: mdl_block_recentlyaccesseditems_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_block_recentlyaccesseditems_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_block_recentlyaccesseditems_id_seq OWNER TO postgres;

--
-- Name: mdl_block_recentlyaccesseditems_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_block_recentlyaccesseditems_id_seq OWNED BY public.mdl_block_recentlyaccesseditems.id;


--
-- Name: mdl_block_rss_client; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_block_rss_client (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    title text NOT NULL,
    preferredtitle character varying(64) DEFAULT ''::character varying NOT NULL,
    description text NOT NULL,
    shared smallint DEFAULT 0 NOT NULL,
    url character varying(255) DEFAULT ''::character varying NOT NULL,
    skiptime bigint DEFAULT 0 NOT NULL,
    skipuntil bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_block_rss_client OWNER TO postgres;

--
-- Name: TABLE mdl_block_rss_client; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_block_rss_client IS 'Remote news feed information. Contains the news feed id, the userid of the user who added the feed, the title of the feed itself and a description of the feed contents along with the url used to access the remote feed. Preferredtitle is a field for f';


--
-- Name: mdl_block_rss_client_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_block_rss_client_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_block_rss_client_id_seq OWNER TO postgres;

--
-- Name: mdl_block_rss_client_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_block_rss_client_id_seq OWNED BY public.mdl_block_rss_client.id;


--
-- Name: mdl_blog_association; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_blog_association (
    id bigint NOT NULL,
    contextid bigint NOT NULL,
    blogid bigint NOT NULL
);


ALTER TABLE public.mdl_blog_association OWNER TO postgres;

--
-- Name: TABLE mdl_blog_association; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_blog_association IS 'Associations of blog entries with courses and module instances';


--
-- Name: mdl_blog_association_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_blog_association_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_blog_association_id_seq OWNER TO postgres;

--
-- Name: mdl_blog_association_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_blog_association_id_seq OWNED BY public.mdl_blog_association.id;


--
-- Name: mdl_blog_external; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_blog_external (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    description text,
    url text NOT NULL,
    filtertags character varying(255),
    failedlastsync smallint DEFAULT 0 NOT NULL,
    timemodified bigint,
    timefetched bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_blog_external OWNER TO postgres;

--
-- Name: TABLE mdl_blog_external; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_blog_external IS 'External blog links used for RSS copying of blog entries to Moodle user blogs';


--
-- Name: mdl_blog_external_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_blog_external_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_blog_external_id_seq OWNER TO postgres;

--
-- Name: mdl_blog_external_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_blog_external_id_seq OWNED BY public.mdl_blog_external.id;


--
-- Name: mdl_book; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_book (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text,
    introformat smallint DEFAULT 0 NOT NULL,
    numbering smallint DEFAULT 0 NOT NULL,
    navstyle smallint DEFAULT 1 NOT NULL,
    customtitles smallint DEFAULT 0 NOT NULL,
    revision bigint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_book OWNER TO postgres;

--
-- Name: TABLE mdl_book; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_book IS 'Defines book';


--
-- Name: mdl_book_chapters; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_book_chapters (
    id bigint NOT NULL,
    bookid bigint DEFAULT 0 NOT NULL,
    pagenum bigint DEFAULT 0 NOT NULL,
    subchapter bigint DEFAULT 0 NOT NULL,
    title character varying(255) DEFAULT ''::character varying NOT NULL,
    content text NOT NULL,
    contentformat smallint DEFAULT 0 NOT NULL,
    hidden smallint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    importsrc character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_book_chapters OWNER TO postgres;

--
-- Name: TABLE mdl_book_chapters; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_book_chapters IS 'Defines book_chapters';


--
-- Name: mdl_book_chapters_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_book_chapters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_book_chapters_id_seq OWNER TO postgres;

--
-- Name: mdl_book_chapters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_book_chapters_id_seq OWNED BY public.mdl_book_chapters.id;


--
-- Name: mdl_book_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_book_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_book_id_seq OWNER TO postgres;

--
-- Name: mdl_book_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_book_id_seq OWNED BY public.mdl_book.id;


--
-- Name: mdl_cache_filters; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_cache_filters (
    id bigint NOT NULL,
    filter character varying(32) DEFAULT ''::character varying NOT NULL,
    version bigint DEFAULT 0 NOT NULL,
    md5key character varying(32) DEFAULT ''::character varying NOT NULL,
    rawtext text NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_cache_filters OWNER TO postgres;

--
-- Name: TABLE mdl_cache_filters; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_cache_filters IS 'For keeping information about cached data';


--
-- Name: mdl_cache_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_cache_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_cache_filters_id_seq OWNER TO postgres;

--
-- Name: mdl_cache_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_cache_filters_id_seq OWNED BY public.mdl_cache_filters.id;


--
-- Name: mdl_cache_flags; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_cache_flags (
    id bigint NOT NULL,
    flagtype character varying(255) DEFAULT ''::character varying NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    value text NOT NULL,
    expiry bigint NOT NULL
);


ALTER TABLE public.mdl_cache_flags OWNER TO postgres;

--
-- Name: TABLE mdl_cache_flags; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_cache_flags IS 'Cache of time-sensitive flags';


--
-- Name: mdl_cache_flags_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_cache_flags_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_cache_flags_id_seq OWNER TO postgres;

--
-- Name: mdl_cache_flags_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_cache_flags_id_seq OWNED BY public.mdl_cache_flags.id;


--
-- Name: mdl_capabilities; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_capabilities (
    id bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    captype character varying(50) DEFAULT ''::character varying NOT NULL,
    contextlevel bigint DEFAULT 0 NOT NULL,
    component character varying(100) DEFAULT ''::character varying NOT NULL,
    riskbitmask bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_capabilities OWNER TO postgres;

--
-- Name: TABLE mdl_capabilities; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_capabilities IS 'this defines all capabilities';


--
-- Name: mdl_capabilities_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_capabilities_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_capabilities_id_seq OWNER TO postgres;

--
-- Name: mdl_capabilities_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_capabilities_id_seq OWNED BY public.mdl_capabilities.id;


--
-- Name: mdl_chat; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_chat (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text NOT NULL,
    introformat smallint DEFAULT 0 NOT NULL,
    keepdays bigint DEFAULT 0 NOT NULL,
    studentlogs smallint DEFAULT 0 NOT NULL,
    chattime bigint DEFAULT 0 NOT NULL,
    schedule smallint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_chat OWNER TO postgres;

--
-- Name: TABLE mdl_chat; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_chat IS 'Each of these is a chat room';


--
-- Name: mdl_chat_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_chat_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_chat_id_seq OWNER TO postgres;

--
-- Name: mdl_chat_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_chat_id_seq OWNED BY public.mdl_chat.id;


--
-- Name: mdl_chat_messages; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_chat_messages (
    id bigint NOT NULL,
    chatid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    groupid bigint DEFAULT 0 NOT NULL,
    issystem smallint DEFAULT 0 NOT NULL,
    message text NOT NULL,
    "timestamp" bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_chat_messages OWNER TO postgres;

--
-- Name: TABLE mdl_chat_messages; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_chat_messages IS 'Stores all the actual chat messages';


--
-- Name: mdl_chat_messages_current; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_chat_messages_current (
    id bigint NOT NULL,
    chatid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    groupid bigint DEFAULT 0 NOT NULL,
    issystem smallint DEFAULT 0 NOT NULL,
    message text NOT NULL,
    "timestamp" bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_chat_messages_current OWNER TO postgres;

--
-- Name: TABLE mdl_chat_messages_current; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_chat_messages_current IS 'Stores current session';


--
-- Name: mdl_chat_messages_current_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_chat_messages_current_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_chat_messages_current_id_seq OWNER TO postgres;

--
-- Name: mdl_chat_messages_current_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_chat_messages_current_id_seq OWNED BY public.mdl_chat_messages_current.id;


--
-- Name: mdl_chat_messages_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_chat_messages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_chat_messages_id_seq OWNER TO postgres;

--
-- Name: mdl_chat_messages_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_chat_messages_id_seq OWNED BY public.mdl_chat_messages.id;


--
-- Name: mdl_chat_users; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_chat_users (
    id bigint NOT NULL,
    chatid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    groupid bigint DEFAULT 0 NOT NULL,
    version character varying(16) DEFAULT ''::character varying NOT NULL,
    ip character varying(45) DEFAULT ''::character varying NOT NULL,
    firstping bigint DEFAULT 0 NOT NULL,
    lastping bigint DEFAULT 0 NOT NULL,
    lastmessageping bigint DEFAULT 0 NOT NULL,
    sid character varying(32) DEFAULT ''::character varying NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    lang character varying(30) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_chat_users OWNER TO postgres;

--
-- Name: TABLE mdl_chat_users; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_chat_users IS 'Keeps track of which users are in which chat rooms';


--
-- Name: mdl_chat_users_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_chat_users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_chat_users_id_seq OWNER TO postgres;

--
-- Name: mdl_chat_users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_chat_users_id_seq OWNED BY public.mdl_chat_users.id;


--
-- Name: mdl_choice; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_choice (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text NOT NULL,
    introformat smallint DEFAULT 0 NOT NULL,
    publish smallint DEFAULT 0 NOT NULL,
    showresults smallint DEFAULT 0 NOT NULL,
    display smallint DEFAULT 0 NOT NULL,
    allowupdate smallint DEFAULT 0 NOT NULL,
    allowmultiple smallint DEFAULT 0 NOT NULL,
    showunanswered smallint DEFAULT 0 NOT NULL,
    includeinactive smallint DEFAULT 1 NOT NULL,
    limitanswers smallint DEFAULT 0 NOT NULL,
    timeopen bigint DEFAULT 0 NOT NULL,
    timeclose bigint DEFAULT 0 NOT NULL,
    showpreview smallint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    completionsubmit smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_choice OWNER TO postgres;

--
-- Name: TABLE mdl_choice; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_choice IS 'Available choices are stored here';


--
-- Name: mdl_choice_answers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_choice_answers (
    id bigint NOT NULL,
    choiceid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    optionid bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_choice_answers OWNER TO postgres;

--
-- Name: TABLE mdl_choice_answers; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_choice_answers IS 'choices performed by users';


--
-- Name: mdl_choice_answers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_choice_answers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_choice_answers_id_seq OWNER TO postgres;

--
-- Name: mdl_choice_answers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_choice_answers_id_seq OWNED BY public.mdl_choice_answers.id;


--
-- Name: mdl_choice_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_choice_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_choice_id_seq OWNER TO postgres;

--
-- Name: mdl_choice_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_choice_id_seq OWNED BY public.mdl_choice.id;


--
-- Name: mdl_choice_options; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_choice_options (
    id bigint NOT NULL,
    choiceid bigint DEFAULT 0 NOT NULL,
    text text,
    maxanswers bigint DEFAULT 0,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_choice_options OWNER TO postgres;

--
-- Name: TABLE mdl_choice_options; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_choice_options IS 'available options to choice';


--
-- Name: mdl_choice_options_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_choice_options_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_choice_options_id_seq OWNER TO postgres;

--
-- Name: mdl_choice_options_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_choice_options_id_seq OWNED BY public.mdl_choice_options.id;


--
-- Name: mdl_cohort; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_cohort (
    id bigint NOT NULL,
    contextid bigint NOT NULL,
    name character varying(254) DEFAULT ''::character varying NOT NULL,
    idnumber character varying(100),
    description text,
    descriptionformat smallint NOT NULL,
    visible smallint DEFAULT 1 NOT NULL,
    component character varying(100) DEFAULT ''::character varying NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    theme character varying(50)
);


ALTER TABLE public.mdl_cohort OWNER TO postgres;

--
-- Name: TABLE mdl_cohort; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_cohort IS 'Each record represents one cohort (aka site-wide group).';


--
-- Name: mdl_cohort_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_cohort_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_cohort_id_seq OWNER TO postgres;

--
-- Name: mdl_cohort_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_cohort_id_seq OWNED BY public.mdl_cohort.id;


--
-- Name: mdl_cohort_members; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_cohort_members (
    id bigint NOT NULL,
    cohortid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    timeadded bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_cohort_members OWNER TO postgres;

--
-- Name: TABLE mdl_cohort_members; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_cohort_members IS 'Link a user to a cohort.';


--
-- Name: mdl_cohort_members_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_cohort_members_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_cohort_members_id_seq OWNER TO postgres;

--
-- Name: mdl_cohort_members_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_cohort_members_id_seq OWNED BY public.mdl_cohort_members.id;


--
-- Name: mdl_comments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_comments (
    id bigint NOT NULL,
    contextid bigint NOT NULL,
    component character varying(255),
    commentarea character varying(255) DEFAULT ''::character varying NOT NULL,
    itemid bigint NOT NULL,
    content text NOT NULL,
    format smallint DEFAULT 0 NOT NULL,
    userid bigint NOT NULL,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_comments OWNER TO postgres;

--
-- Name: TABLE mdl_comments; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_comments IS 'moodle comments module';


--
-- Name: mdl_comments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_comments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_comments_id_seq OWNER TO postgres;

--
-- Name: mdl_comments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_comments_id_seq OWNED BY public.mdl_comments.id;


--
-- Name: mdl_competency; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency (
    id bigint NOT NULL,
    shortname character varying(100),
    description text,
    descriptionformat smallint DEFAULT 0 NOT NULL,
    idnumber character varying(100),
    competencyframeworkid bigint NOT NULL,
    parentid bigint DEFAULT 0 NOT NULL,
    path character varying(255) DEFAULT ''::character varying NOT NULL,
    sortorder bigint NOT NULL,
    ruletype character varying(100),
    ruleoutcome smallint DEFAULT 0 NOT NULL,
    ruleconfig text,
    scaleid bigint,
    scaleconfiguration text,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint
);


ALTER TABLE public.mdl_competency OWNER TO postgres;

--
-- Name: TABLE mdl_competency; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency IS 'This table contains the master record of each competency in a framework';


--
-- Name: mdl_competency_coursecomp; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_coursecomp (
    id bigint NOT NULL,
    courseid bigint NOT NULL,
    competencyid bigint NOT NULL,
    ruleoutcome smallint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL,
    sortorder bigint NOT NULL
);


ALTER TABLE public.mdl_competency_coursecomp OWNER TO postgres;

--
-- Name: TABLE mdl_competency_coursecomp; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_coursecomp IS 'Link a competency to a course.';


--
-- Name: mdl_competency_coursecomp_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_coursecomp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_coursecomp_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_coursecomp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_coursecomp_id_seq OWNED BY public.mdl_competency_coursecomp.id;


--
-- Name: mdl_competency_coursecompsetting; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_coursecompsetting (
    id bigint NOT NULL,
    courseid bigint NOT NULL,
    pushratingstouserplans smallint,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint
);


ALTER TABLE public.mdl_competency_coursecompsetting OWNER TO postgres;

--
-- Name: TABLE mdl_competency_coursecompsetting; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_coursecompsetting IS 'This table contains the course specific settings for competencies.';


--
-- Name: mdl_competency_coursecompsetting_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_coursecompsetting_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_coursecompsetting_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_coursecompsetting_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_coursecompsetting_id_seq OWNED BY public.mdl_competency_coursecompsetting.id;


--
-- Name: mdl_competency_evidence; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_evidence (
    id bigint NOT NULL,
    usercompetencyid bigint NOT NULL,
    contextid bigint NOT NULL,
    action smallint NOT NULL,
    actionuserid bigint,
    descidentifier character varying(255) DEFAULT ''::character varying NOT NULL,
    desccomponent character varying(255) DEFAULT ''::character varying NOT NULL,
    desca text,
    url character varying(255),
    grade bigint,
    note text,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL
);


ALTER TABLE public.mdl_competency_evidence OWNER TO postgres;

--
-- Name: TABLE mdl_competency_evidence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_evidence IS 'The evidence linked to a user competency';


--
-- Name: mdl_competency_evidence_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_evidence_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_evidence_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_evidence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_evidence_id_seq OWNED BY public.mdl_competency_evidence.id;


--
-- Name: mdl_competency_framework; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_framework (
    id bigint NOT NULL,
    shortname character varying(100),
    contextid bigint NOT NULL,
    idnumber character varying(100),
    description text,
    descriptionformat smallint DEFAULT 0 NOT NULL,
    scaleid bigint,
    scaleconfiguration text NOT NULL,
    visible smallint DEFAULT 1 NOT NULL,
    taxonomies character varying(255) DEFAULT ''::character varying NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint
);


ALTER TABLE public.mdl_competency_framework OWNER TO postgres;

--
-- Name: TABLE mdl_competency_framework; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_framework IS 'List of competency frameworks.';


--
-- Name: mdl_competency_framework_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_framework_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_framework_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_framework_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_framework_id_seq OWNED BY public.mdl_competency_framework.id;


--
-- Name: mdl_competency_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_id_seq OWNED BY public.mdl_competency.id;


--
-- Name: mdl_competency_modulecomp; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_modulecomp (
    id bigint NOT NULL,
    cmid bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL,
    sortorder bigint NOT NULL,
    competencyid bigint NOT NULL,
    ruleoutcome smallint NOT NULL
);


ALTER TABLE public.mdl_competency_modulecomp OWNER TO postgres;

--
-- Name: TABLE mdl_competency_modulecomp; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_modulecomp IS 'Link a competency to a module.';


--
-- Name: mdl_competency_modulecomp_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_modulecomp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_modulecomp_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_modulecomp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_modulecomp_id_seq OWNED BY public.mdl_competency_modulecomp.id;


--
-- Name: mdl_competency_plan; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_plan (
    id bigint NOT NULL,
    name character varying(100) DEFAULT ''::character varying NOT NULL,
    description text,
    descriptionformat smallint DEFAULT 0 NOT NULL,
    userid bigint NOT NULL,
    templateid bigint,
    origtemplateid bigint,
    status smallint NOT NULL,
    duedate bigint DEFAULT 0,
    reviewerid bigint,
    timecreated bigint NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    usermodified bigint NOT NULL
);


ALTER TABLE public.mdl_competency_plan OWNER TO postgres;

--
-- Name: TABLE mdl_competency_plan; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_plan IS 'Learning plans';


--
-- Name: mdl_competency_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_plan_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_plan_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_plan_id_seq OWNED BY public.mdl_competency_plan.id;


--
-- Name: mdl_competency_plancomp; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_plancomp (
    id bigint NOT NULL,
    planid bigint NOT NULL,
    competencyid bigint NOT NULL,
    sortorder bigint,
    timecreated bigint NOT NULL,
    timemodified bigint,
    usermodified bigint NOT NULL
);


ALTER TABLE public.mdl_competency_plancomp OWNER TO postgres;

--
-- Name: TABLE mdl_competency_plancomp; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_plancomp IS 'Plan competencies';


--
-- Name: mdl_competency_plancomp_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_plancomp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_plancomp_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_plancomp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_plancomp_id_seq OWNED BY public.mdl_competency_plancomp.id;


--
-- Name: mdl_competency_relatedcomp; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_relatedcomp (
    id bigint NOT NULL,
    competencyid bigint NOT NULL,
    relatedcompetencyid bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint,
    usermodified bigint NOT NULL
);


ALTER TABLE public.mdl_competency_relatedcomp OWNER TO postgres;

--
-- Name: TABLE mdl_competency_relatedcomp; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_relatedcomp IS 'Related competencies';


--
-- Name: mdl_competency_relatedcomp_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_relatedcomp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_relatedcomp_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_relatedcomp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_relatedcomp_id_seq OWNED BY public.mdl_competency_relatedcomp.id;


--
-- Name: mdl_competency_template; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_template (
    id bigint NOT NULL,
    shortname character varying(100),
    contextid bigint NOT NULL,
    description text,
    descriptionformat smallint DEFAULT 0 NOT NULL,
    visible smallint DEFAULT 1 NOT NULL,
    duedate bigint,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint
);


ALTER TABLE public.mdl_competency_template OWNER TO postgres;

--
-- Name: TABLE mdl_competency_template; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_template IS 'Learning plan templates.';


--
-- Name: mdl_competency_template_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_template_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_template_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_template_id_seq OWNED BY public.mdl_competency_template.id;


--
-- Name: mdl_competency_templatecohort; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_templatecohort (
    id bigint NOT NULL,
    templateid bigint NOT NULL,
    cohortid bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL
);


ALTER TABLE public.mdl_competency_templatecohort OWNER TO postgres;

--
-- Name: TABLE mdl_competency_templatecohort; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_templatecohort IS 'Default comment for the table, please edit me';


--
-- Name: mdl_competency_templatecohort_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_templatecohort_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_templatecohort_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_templatecohort_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_templatecohort_id_seq OWNED BY public.mdl_competency_templatecohort.id;


--
-- Name: mdl_competency_templatecomp; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_templatecomp (
    id bigint NOT NULL,
    templateid bigint NOT NULL,
    competencyid bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL,
    sortorder bigint
);


ALTER TABLE public.mdl_competency_templatecomp OWNER TO postgres;

--
-- Name: TABLE mdl_competency_templatecomp; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_templatecomp IS 'Link a competency to a learning plan template.';


--
-- Name: mdl_competency_templatecomp_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_templatecomp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_templatecomp_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_templatecomp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_templatecomp_id_seq OWNED BY public.mdl_competency_templatecomp.id;


--
-- Name: mdl_competency_usercomp; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_usercomp (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    competencyid bigint NOT NULL,
    status smallint DEFAULT 0 NOT NULL,
    reviewerid bigint,
    proficiency smallint,
    grade bigint,
    timecreated bigint NOT NULL,
    timemodified bigint,
    usermodified bigint NOT NULL
);


ALTER TABLE public.mdl_competency_usercomp OWNER TO postgres;

--
-- Name: TABLE mdl_competency_usercomp; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_usercomp IS 'User competencies';


--
-- Name: mdl_competency_usercomp_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_usercomp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_usercomp_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_usercomp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_usercomp_id_seq OWNED BY public.mdl_competency_usercomp.id;


--
-- Name: mdl_competency_usercompcourse; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_usercompcourse (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    courseid bigint NOT NULL,
    competencyid bigint NOT NULL,
    proficiency smallint,
    grade bigint,
    timecreated bigint NOT NULL,
    timemodified bigint,
    usermodified bigint NOT NULL
);


ALTER TABLE public.mdl_competency_usercompcourse OWNER TO postgres;

--
-- Name: TABLE mdl_competency_usercompcourse; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_usercompcourse IS 'User competencies in a course';


--
-- Name: mdl_competency_usercompcourse_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_usercompcourse_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_usercompcourse_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_usercompcourse_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_usercompcourse_id_seq OWNED BY public.mdl_competency_usercompcourse.id;


--
-- Name: mdl_competency_usercompplan; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_usercompplan (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    competencyid bigint NOT NULL,
    planid bigint NOT NULL,
    proficiency smallint,
    grade bigint,
    sortorder bigint,
    timecreated bigint NOT NULL,
    timemodified bigint,
    usermodified bigint NOT NULL
);


ALTER TABLE public.mdl_competency_usercompplan OWNER TO postgres;

--
-- Name: TABLE mdl_competency_usercompplan; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_usercompplan IS 'User competencies plans';


--
-- Name: mdl_competency_usercompplan_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_usercompplan_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_usercompplan_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_usercompplan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_usercompplan_id_seq OWNED BY public.mdl_competency_usercompplan.id;


--
-- Name: mdl_competency_userevidence; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_userevidence (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    name character varying(100) DEFAULT ''::character varying NOT NULL,
    description text NOT NULL,
    descriptionformat smallint NOT NULL,
    url text NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL
);


ALTER TABLE public.mdl_competency_userevidence OWNER TO postgres;

--
-- Name: TABLE mdl_competency_userevidence; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_userevidence IS 'The evidence of prior learning';


--
-- Name: mdl_competency_userevidence_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_userevidence_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_userevidence_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_userevidence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_userevidence_id_seq OWNED BY public.mdl_competency_userevidence.id;


--
-- Name: mdl_competency_userevidencecomp; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_competency_userevidencecomp (
    id bigint NOT NULL,
    userevidenceid bigint NOT NULL,
    competencyid bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL
);


ALTER TABLE public.mdl_competency_userevidencecomp OWNER TO postgres;

--
-- Name: TABLE mdl_competency_userevidencecomp; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_competency_userevidencecomp IS 'Relationship between user evidence and competencies';


--
-- Name: mdl_competency_userevidencecomp_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_competency_userevidencecomp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_competency_userevidencecomp_id_seq OWNER TO postgres;

--
-- Name: mdl_competency_userevidencecomp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_competency_userevidencecomp_id_seq OWNED BY public.mdl_competency_userevidencecomp.id;


--
-- Name: mdl_config; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_config (
    id bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    value text NOT NULL
);


ALTER TABLE public.mdl_config OWNER TO postgres;

--
-- Name: TABLE mdl_config; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_config IS 'Moodle configuration variables';


--
-- Name: mdl_config_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_config_id_seq OWNER TO postgres;

--
-- Name: mdl_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_config_id_seq OWNED BY public.mdl_config.id;


--
-- Name: mdl_config_log; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_config_log (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    timemodified bigint NOT NULL,
    plugin character varying(100),
    name character varying(100) DEFAULT ''::character varying NOT NULL,
    value text,
    oldvalue text
);


ALTER TABLE public.mdl_config_log OWNER TO postgres;

--
-- Name: TABLE mdl_config_log; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_config_log IS 'Changes done in server configuration through admin UI';


--
-- Name: mdl_config_log_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_config_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_config_log_id_seq OWNER TO postgres;

--
-- Name: mdl_config_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_config_log_id_seq OWNED BY public.mdl_config_log.id;


--
-- Name: mdl_config_plugins; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_config_plugins (
    id bigint NOT NULL,
    plugin character varying(100) DEFAULT 'core'::character varying NOT NULL,
    name character varying(100) DEFAULT ''::character varying NOT NULL,
    value text NOT NULL
);


ALTER TABLE public.mdl_config_plugins OWNER TO postgres;

--
-- Name: TABLE mdl_config_plugins; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_config_plugins IS 'Moodle modules and plugins configuration variables';


--
-- Name: mdl_config_plugins_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_config_plugins_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_config_plugins_id_seq OWNER TO postgres;

--
-- Name: mdl_config_plugins_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_config_plugins_id_seq OWNED BY public.mdl_config_plugins.id;


--
-- Name: mdl_contentbank_content; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_contentbank_content (
    id bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    contenttype character varying(100) DEFAULT ''::character varying NOT NULL,
    contextid bigint NOT NULL,
    instanceid bigint,
    configdata text,
    usercreated bigint NOT NULL,
    usermodified bigint,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0
);


ALTER TABLE public.mdl_contentbank_content OWNER TO postgres;

--
-- Name: TABLE mdl_contentbank_content; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_contentbank_content IS 'This table stores content data in the content bank.';


--
-- Name: mdl_contentbank_content_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_contentbank_content_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_contentbank_content_id_seq OWNER TO postgres;

--
-- Name: mdl_contentbank_content_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_contentbank_content_id_seq OWNED BY public.mdl_contentbank_content.id;


--
-- Name: mdl_context; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_context (
    id bigint NOT NULL,
    contextlevel bigint DEFAULT 0 NOT NULL,
    instanceid bigint DEFAULT 0 NOT NULL,
    path character varying(255),
    depth smallint DEFAULT 0 NOT NULL,
    locked smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_context OWNER TO postgres;

--
-- Name: TABLE mdl_context; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_context IS 'one of these must be set';


--
-- Name: mdl_context_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_context_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_context_id_seq OWNER TO postgres;

--
-- Name: mdl_context_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_context_id_seq OWNED BY public.mdl_context.id;


--
-- Name: mdl_context_temp; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_context_temp (
    id bigint NOT NULL,
    path character varying(255) DEFAULT ''::character varying NOT NULL,
    depth smallint NOT NULL,
    locked smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_context_temp OWNER TO postgres;

--
-- Name: TABLE mdl_context_temp; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_context_temp IS 'Used by build_context_path() in upgrade and cron to keep context depths and paths in sync.';


--
-- Name: mdl_course; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course (
    id bigint NOT NULL,
    category bigint DEFAULT 0 NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL,
    fullname character varying(254) DEFAULT ''::character varying NOT NULL,
    shortname character varying(255) DEFAULT ''::character varying NOT NULL,
    idnumber character varying(100) DEFAULT ''::character varying NOT NULL,
    summary text,
    summaryformat smallint DEFAULT 0 NOT NULL,
    format character varying(21) DEFAULT 'topics'::character varying NOT NULL,
    showgrades smallint DEFAULT 1 NOT NULL,
    newsitems integer DEFAULT 1 NOT NULL,
    startdate bigint DEFAULT 0 NOT NULL,
    enddate bigint DEFAULT 0 NOT NULL,
    relativedatesmode smallint DEFAULT 0 NOT NULL,
    marker bigint DEFAULT 0 NOT NULL,
    maxbytes bigint DEFAULT 0 NOT NULL,
    legacyfiles smallint DEFAULT 0 NOT NULL,
    showreports smallint DEFAULT 0 NOT NULL,
    visible smallint DEFAULT 1 NOT NULL,
    visibleold smallint DEFAULT 1 NOT NULL,
    groupmode smallint DEFAULT 0 NOT NULL,
    groupmodeforce smallint DEFAULT 0 NOT NULL,
    defaultgroupingid bigint DEFAULT 0 NOT NULL,
    lang character varying(30) DEFAULT ''::character varying NOT NULL,
    calendartype character varying(30) DEFAULT ''::character varying NOT NULL,
    theme character varying(50) DEFAULT ''::character varying NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    requested smallint DEFAULT 0 NOT NULL,
    enablecompletion smallint DEFAULT 0 NOT NULL,
    completionnotify smallint DEFAULT 0 NOT NULL,
    cacherev bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_course OWNER TO postgres;

--
-- Name: TABLE mdl_course; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course IS 'Central course table';


--
-- Name: mdl_course_categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course_categories (
    id bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    idnumber character varying(100),
    description text,
    descriptionformat smallint DEFAULT 0 NOT NULL,
    parent bigint DEFAULT 0 NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL,
    coursecount bigint DEFAULT 0 NOT NULL,
    visible smallint DEFAULT 1 NOT NULL,
    visibleold smallint DEFAULT 1 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    depth bigint DEFAULT 0 NOT NULL,
    path character varying(255) DEFAULT ''::character varying NOT NULL,
    theme character varying(50)
);


ALTER TABLE public.mdl_course_categories OWNER TO postgres;

--
-- Name: TABLE mdl_course_categories; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course_categories IS 'Course categories';


--
-- Name: mdl_course_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_categories_id_seq OWNER TO postgres;

--
-- Name: mdl_course_categories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_categories_id_seq OWNED BY public.mdl_course_categories.id;


--
-- Name: mdl_course_completion_aggr_methd; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course_completion_aggr_methd (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    criteriatype bigint,
    method smallint DEFAULT 0 NOT NULL,
    value numeric(10,5)
);


ALTER TABLE public.mdl_course_completion_aggr_methd OWNER TO postgres;

--
-- Name: TABLE mdl_course_completion_aggr_methd; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course_completion_aggr_methd IS 'Course completion aggregation methods for criteria';


--
-- Name: mdl_course_completion_aggr_methd_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_completion_aggr_methd_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_completion_aggr_methd_id_seq OWNER TO postgres;

--
-- Name: mdl_course_completion_aggr_methd_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_completion_aggr_methd_id_seq OWNED BY public.mdl_course_completion_aggr_methd.id;


--
-- Name: mdl_course_completion_crit_compl; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course_completion_crit_compl (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    criteriaid bigint DEFAULT 0 NOT NULL,
    gradefinal numeric(10,5),
    unenroled bigint,
    timecompleted bigint
);


ALTER TABLE public.mdl_course_completion_crit_compl OWNER TO postgres;

--
-- Name: TABLE mdl_course_completion_crit_compl; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course_completion_crit_compl IS 'Course completion user records';


--
-- Name: mdl_course_completion_crit_compl_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_completion_crit_compl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_completion_crit_compl_id_seq OWNER TO postgres;

--
-- Name: mdl_course_completion_crit_compl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_completion_crit_compl_id_seq OWNED BY public.mdl_course_completion_crit_compl.id;


--
-- Name: mdl_course_completion_criteria; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course_completion_criteria (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    criteriatype bigint DEFAULT 0 NOT NULL,
    module character varying(100),
    moduleinstance bigint,
    courseinstance bigint,
    enrolperiod bigint,
    timeend bigint,
    gradepass numeric(10,5),
    role bigint
);


ALTER TABLE public.mdl_course_completion_criteria OWNER TO postgres;

--
-- Name: TABLE mdl_course_completion_criteria; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course_completion_criteria IS 'Course completion criteria';


--
-- Name: mdl_course_completion_criteria_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_completion_criteria_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_completion_criteria_id_seq OWNER TO postgres;

--
-- Name: mdl_course_completion_criteria_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_completion_criteria_id_seq OWNED BY public.mdl_course_completion_criteria.id;


--
-- Name: mdl_course_completion_defaults; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course_completion_defaults (
    id bigint NOT NULL,
    course bigint NOT NULL,
    module bigint NOT NULL,
    completion smallint DEFAULT 0 NOT NULL,
    completionview smallint DEFAULT 0 NOT NULL,
    completionusegrade smallint DEFAULT 0 NOT NULL,
    completionexpected bigint DEFAULT 0 NOT NULL,
    customrules text
);


ALTER TABLE public.mdl_course_completion_defaults OWNER TO postgres;

--
-- Name: TABLE mdl_course_completion_defaults; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course_completion_defaults IS 'Default settings for activities completion';


--
-- Name: mdl_course_completion_defaults_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_completion_defaults_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_completion_defaults_id_seq OWNER TO postgres;

--
-- Name: mdl_course_completion_defaults_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_completion_defaults_id_seq OWNED BY public.mdl_course_completion_defaults.id;


--
-- Name: mdl_course_completions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course_completions (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    timeenrolled bigint DEFAULT 0 NOT NULL,
    timestarted bigint DEFAULT 0 NOT NULL,
    timecompleted bigint,
    reaggregate bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_course_completions OWNER TO postgres;

--
-- Name: TABLE mdl_course_completions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course_completions IS 'Course completion records';


--
-- Name: mdl_course_completions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_completions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_completions_id_seq OWNER TO postgres;

--
-- Name: mdl_course_completions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_completions_id_seq OWNED BY public.mdl_course_completions.id;


--
-- Name: mdl_course_format_options; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course_format_options (
    id bigint NOT NULL,
    courseid bigint NOT NULL,
    format character varying(21) DEFAULT ''::character varying NOT NULL,
    sectionid bigint DEFAULT 0 NOT NULL,
    name character varying(100) DEFAULT ''::character varying NOT NULL,
    value text
);


ALTER TABLE public.mdl_course_format_options OWNER TO postgres;

--
-- Name: TABLE mdl_course_format_options; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course_format_options IS 'Stores format-specific options for the course or course section';


--
-- Name: mdl_course_format_options_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_format_options_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_format_options_id_seq OWNER TO postgres;

--
-- Name: mdl_course_format_options_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_format_options_id_seq OWNED BY public.mdl_course_format_options.id;


--
-- Name: mdl_course_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_id_seq OWNER TO postgres;

--
-- Name: mdl_course_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_id_seq OWNED BY public.mdl_course.id;


--
-- Name: mdl_course_modules; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course_modules (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    module bigint DEFAULT 0 NOT NULL,
    instance bigint DEFAULT 0 NOT NULL,
    section bigint DEFAULT 0 NOT NULL,
    idnumber character varying(100),
    added bigint DEFAULT 0 NOT NULL,
    score smallint DEFAULT 0 NOT NULL,
    indent integer DEFAULT 0 NOT NULL,
    visible smallint DEFAULT 1 NOT NULL,
    visibleoncoursepage smallint DEFAULT 1 NOT NULL,
    visibleold smallint DEFAULT 1 NOT NULL,
    groupmode smallint DEFAULT 0 NOT NULL,
    groupingid bigint DEFAULT 0 NOT NULL,
    completion smallint DEFAULT 0 NOT NULL,
    completiongradeitemnumber bigint,
    completionview smallint DEFAULT 0 NOT NULL,
    completionexpected bigint DEFAULT 0 NOT NULL,
    showdescription smallint DEFAULT 0 NOT NULL,
    availability text,
    deletioninprogress smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_course_modules OWNER TO postgres;

--
-- Name: TABLE mdl_course_modules; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course_modules IS 'course_modules table retrofitted from MySQL';


--
-- Name: mdl_course_modules_completion; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course_modules_completion (
    id bigint NOT NULL,
    coursemoduleid bigint NOT NULL,
    userid bigint NOT NULL,
    completionstate smallint NOT NULL,
    viewed smallint,
    overrideby bigint,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_course_modules_completion OWNER TO postgres;

--
-- Name: TABLE mdl_course_modules_completion; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course_modules_completion IS 'Stores the completion state (completed or not completed, etc) of each user on each activity.';


--
-- Name: mdl_course_modules_completion_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_modules_completion_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_modules_completion_id_seq OWNER TO postgres;

--
-- Name: mdl_course_modules_completion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_modules_completion_id_seq OWNED BY public.mdl_course_modules_completion.id;


--
-- Name: mdl_course_modules_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_modules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_modules_id_seq OWNER TO postgres;

--
-- Name: mdl_course_modules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_modules_id_seq OWNED BY public.mdl_course_modules.id;


--
-- Name: mdl_course_published; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course_published (
    id bigint NOT NULL,
    huburl character varying(255),
    courseid bigint NOT NULL,
    timepublished bigint NOT NULL,
    enrollable smallint DEFAULT 1 NOT NULL,
    hubcourseid bigint NOT NULL,
    status smallint DEFAULT 0,
    timechecked bigint
);


ALTER TABLE public.mdl_course_published OWNER TO postgres;

--
-- Name: TABLE mdl_course_published; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course_published IS 'Information about how and when an local courses were published to hubs';


--
-- Name: mdl_course_published_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_published_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_published_id_seq OWNER TO postgres;

--
-- Name: mdl_course_published_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_published_id_seq OWNED BY public.mdl_course_published.id;


--
-- Name: mdl_course_request; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course_request (
    id bigint NOT NULL,
    fullname character varying(254) DEFAULT ''::character varying NOT NULL,
    shortname character varying(100) DEFAULT ''::character varying NOT NULL,
    summary text NOT NULL,
    summaryformat smallint DEFAULT 0 NOT NULL,
    category bigint DEFAULT 0 NOT NULL,
    reason text NOT NULL,
    requester bigint DEFAULT 0 NOT NULL,
    password character varying(50) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_course_request OWNER TO postgres;

--
-- Name: TABLE mdl_course_request; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course_request IS 'course requests';


--
-- Name: mdl_course_request_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_request_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_request_id_seq OWNER TO postgres;

--
-- Name: mdl_course_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_request_id_seq OWNED BY public.mdl_course_request.id;


--
-- Name: mdl_course_sections; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_course_sections (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    section bigint DEFAULT 0 NOT NULL,
    name character varying(255),
    summary text,
    summaryformat smallint DEFAULT 0 NOT NULL,
    sequence text,
    visible smallint DEFAULT 1 NOT NULL,
    availability text,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_course_sections OWNER TO postgres;

--
-- Name: TABLE mdl_course_sections; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_course_sections IS 'to define the sections for each course';


--
-- Name: mdl_course_sections_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_sections_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_sections_id_seq OWNER TO postgres;

--
-- Name: mdl_course_sections_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_course_sections_id_seq OWNED BY public.mdl_course_sections.id;


--
-- Name: mdl_customfield_category; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_customfield_category (
    id bigint NOT NULL,
    name character varying(400) DEFAULT ''::character varying NOT NULL,
    description text,
    descriptionformat bigint,
    sortorder bigint,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    component character varying(100) DEFAULT ''::character varying NOT NULL,
    area character varying(100) DEFAULT ''::character varying NOT NULL,
    itemid bigint DEFAULT 0 NOT NULL,
    contextid bigint
);


ALTER TABLE public.mdl_customfield_category OWNER TO postgres;

--
-- Name: TABLE mdl_customfield_category; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_customfield_category IS 'core_customfield category table';


--
-- Name: mdl_customfield_category_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_customfield_category_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_customfield_category_id_seq OWNER TO postgres;

--
-- Name: mdl_customfield_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_customfield_category_id_seq OWNED BY public.mdl_customfield_category.id;


--
-- Name: mdl_customfield_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_customfield_data (
    id bigint NOT NULL,
    fieldid bigint NOT NULL,
    instanceid bigint NOT NULL,
    intvalue bigint,
    decvalue numeric(10,5),
    shortcharvalue character varying(255),
    charvalue character varying(1333),
    value text NOT NULL,
    valueformat bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    contextid bigint
);


ALTER TABLE public.mdl_customfield_data OWNER TO postgres;

--
-- Name: TABLE mdl_customfield_data; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_customfield_data IS 'core_customfield data table';


--
-- Name: mdl_customfield_data_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_customfield_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_customfield_data_id_seq OWNER TO postgres;

--
-- Name: mdl_customfield_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_customfield_data_id_seq OWNED BY public.mdl_customfield_data.id;


--
-- Name: mdl_customfield_field; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_customfield_field (
    id bigint NOT NULL,
    shortname character varying(100) DEFAULT ''::character varying NOT NULL,
    name character varying(400) DEFAULT ''::character varying NOT NULL,
    type character varying(100) DEFAULT ''::character varying NOT NULL,
    description text,
    descriptionformat bigint,
    sortorder bigint,
    categoryid bigint,
    configdata text,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_customfield_field OWNER TO postgres;

--
-- Name: TABLE mdl_customfield_field; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_customfield_field IS 'core_customfield field table';


--
-- Name: mdl_customfield_field_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_customfield_field_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_customfield_field_id_seq OWNER TO postgres;

--
-- Name: mdl_customfield_field_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_customfield_field_id_seq OWNED BY public.mdl_customfield_field.id;


--
-- Name: mdl_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_data (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text NOT NULL,
    introformat smallint DEFAULT 0 NOT NULL,
    comments smallint DEFAULT 0 NOT NULL,
    timeavailablefrom bigint DEFAULT 0 NOT NULL,
    timeavailableto bigint DEFAULT 0 NOT NULL,
    timeviewfrom bigint DEFAULT 0 NOT NULL,
    timeviewto bigint DEFAULT 0 NOT NULL,
    requiredentries integer DEFAULT 0 NOT NULL,
    requiredentriestoview integer DEFAULT 0 NOT NULL,
    maxentries integer DEFAULT 0 NOT NULL,
    rssarticles smallint DEFAULT 0 NOT NULL,
    singletemplate text,
    listtemplate text,
    listtemplateheader text,
    listtemplatefooter text,
    addtemplate text,
    rsstemplate text,
    rsstitletemplate text,
    csstemplate text,
    jstemplate text,
    asearchtemplate text,
    approval smallint DEFAULT 0 NOT NULL,
    manageapproved smallint DEFAULT 1 NOT NULL,
    scale bigint DEFAULT 0 NOT NULL,
    assessed bigint DEFAULT 0 NOT NULL,
    assesstimestart bigint DEFAULT 0 NOT NULL,
    assesstimefinish bigint DEFAULT 0 NOT NULL,
    defaultsort bigint DEFAULT 0 NOT NULL,
    defaultsortdir smallint DEFAULT 0 NOT NULL,
    editany smallint DEFAULT 0 NOT NULL,
    notification bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    config text,
    completionentries bigint DEFAULT 0
);


ALTER TABLE public.mdl_data OWNER TO postgres;

--
-- Name: TABLE mdl_data; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_data IS 'all database activities';


--
-- Name: mdl_data_content; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_data_content (
    id bigint NOT NULL,
    fieldid bigint DEFAULT 0 NOT NULL,
    recordid bigint DEFAULT 0 NOT NULL,
    content text,
    content1 text,
    content2 text,
    content3 text,
    content4 text
);


ALTER TABLE public.mdl_data_content OWNER TO postgres;

--
-- Name: TABLE mdl_data_content; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_data_content IS 'the content introduced in each record/fields';


--
-- Name: mdl_data_content_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_data_content_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_data_content_id_seq OWNER TO postgres;

--
-- Name: mdl_data_content_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_data_content_id_seq OWNED BY public.mdl_data_content.id;


--
-- Name: mdl_data_fields; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_data_fields (
    id bigint NOT NULL,
    dataid bigint DEFAULT 0 NOT NULL,
    type character varying(255) DEFAULT ''::character varying NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    description text NOT NULL,
    required smallint DEFAULT 0 NOT NULL,
    param1 text,
    param2 text,
    param3 text,
    param4 text,
    param5 text,
    param6 text,
    param7 text,
    param8 text,
    param9 text,
    param10 text
);


ALTER TABLE public.mdl_data_fields OWNER TO postgres;

--
-- Name: TABLE mdl_data_fields; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_data_fields IS 'every field available';


--
-- Name: mdl_data_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_data_fields_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_data_fields_id_seq OWNER TO postgres;

--
-- Name: mdl_data_fields_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_data_fields_id_seq OWNED BY public.mdl_data_fields.id;


--
-- Name: mdl_data_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_data_id_seq OWNER TO postgres;

--
-- Name: mdl_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_data_id_seq OWNED BY public.mdl_data.id;


--
-- Name: mdl_data_records; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_data_records (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    groupid bigint DEFAULT 0 NOT NULL,
    dataid bigint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    approved smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_data_records OWNER TO postgres;

--
-- Name: TABLE mdl_data_records; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_data_records IS 'every record introduced';


--
-- Name: mdl_data_records_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_data_records_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_data_records_id_seq OWNER TO postgres;

--
-- Name: mdl_data_records_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_data_records_id_seq OWNED BY public.mdl_data_records.id;


--
-- Name: mdl_editor_atto_autosave; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_editor_atto_autosave (
    id bigint NOT NULL,
    elementid character varying(255) DEFAULT ''::character varying NOT NULL,
    contextid bigint NOT NULL,
    pagehash character varying(64) DEFAULT ''::character varying NOT NULL,
    userid bigint NOT NULL,
    drafttext text NOT NULL,
    draftid bigint,
    pageinstance character varying(64) DEFAULT ''::character varying NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_editor_atto_autosave OWNER TO postgres;

--
-- Name: TABLE mdl_editor_atto_autosave; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_editor_atto_autosave IS 'Draft text that is auto-saved every 5 seconds while an editor is open.';


--
-- Name: mdl_editor_atto_autosave_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_editor_atto_autosave_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_editor_atto_autosave_id_seq OWNER TO postgres;

--
-- Name: mdl_editor_atto_autosave_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_editor_atto_autosave_id_seq OWNED BY public.mdl_editor_atto_autosave.id;


--
-- Name: mdl_enrol; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_enrol (
    id bigint NOT NULL,
    enrol character varying(20) DEFAULT ''::character varying NOT NULL,
    status bigint DEFAULT 0 NOT NULL,
    courseid bigint NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL,
    name character varying(255),
    enrolperiod bigint DEFAULT 0,
    enrolstartdate bigint DEFAULT 0,
    enrolenddate bigint DEFAULT 0,
    expirynotify smallint DEFAULT 0,
    expirythreshold bigint DEFAULT 0,
    notifyall smallint DEFAULT 0,
    password character varying(50),
    cost character varying(20),
    currency character varying(3),
    roleid bigint DEFAULT 0,
    customint1 bigint,
    customint2 bigint,
    customint3 bigint,
    customint4 bigint,
    customint5 bigint,
    customint6 bigint,
    customint7 bigint,
    customint8 bigint,
    customchar1 character varying(255),
    customchar2 character varying(255),
    customchar3 character varying(1333),
    customdec1 numeric(12,7),
    customdec2 numeric(12,7),
    customtext1 text,
    customtext2 text,
    customtext3 text,
    customtext4 text,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_enrol OWNER TO postgres;

--
-- Name: TABLE mdl_enrol; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_enrol IS 'Instances of enrolment plugins used in courses, fields marked as custom have a plugin defined meaning, core does not touch them. Create a new linked table if you need even more custom fields.';


--
-- Name: mdl_enrol_flatfile; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_enrol_flatfile (
    id bigint NOT NULL,
    action character varying(30) DEFAULT ''::character varying NOT NULL,
    roleid bigint NOT NULL,
    userid bigint NOT NULL,
    courseid bigint NOT NULL,
    timestart bigint DEFAULT 0 NOT NULL,
    timeend bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_enrol_flatfile OWNER TO postgres;

--
-- Name: TABLE mdl_enrol_flatfile; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_enrol_flatfile IS 'enrol_flatfile table retrofitted from MySQL';


--
-- Name: mdl_enrol_flatfile_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_flatfile_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_flatfile_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_flatfile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_enrol_flatfile_id_seq OWNED BY public.mdl_enrol_flatfile.id;


--
-- Name: mdl_enrol_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_enrol_id_seq OWNED BY public.mdl_enrol.id;


--
-- Name: mdl_enrol_lti_lti2_consumer; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_enrol_lti_lti2_consumer (
    id bigint NOT NULL,
    name character varying(50) DEFAULT ''::character varying NOT NULL,
    consumerkey256 character varying(255) DEFAULT ''::character varying NOT NULL,
    consumerkey text,
    secret character varying(1024) DEFAULT ''::character varying NOT NULL,
    ltiversion character varying(10),
    consumername character varying(255),
    consumerversion character varying(255),
    consumerguid character varying(1024),
    profile text,
    toolproxy text,
    settings text,
    protected smallint NOT NULL,
    enabled smallint NOT NULL,
    enablefrom bigint,
    enableuntil bigint,
    lastaccess bigint,
    created bigint NOT NULL,
    updated bigint NOT NULL
);


ALTER TABLE public.mdl_enrol_lti_lti2_consumer OWNER TO postgres;

--
-- Name: TABLE mdl_enrol_lti_lti2_consumer; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_enrol_lti_lti2_consumer IS 'LTI consumers interacting with moodle';


--
-- Name: mdl_enrol_lti_lti2_consumer_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_lti_lti2_consumer_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_lti_lti2_consumer_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_lti_lti2_consumer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_enrol_lti_lti2_consumer_id_seq OWNED BY public.mdl_enrol_lti_lti2_consumer.id;


--
-- Name: mdl_enrol_lti_lti2_context; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_enrol_lti_lti2_context (
    id bigint NOT NULL,
    consumerid bigint NOT NULL,
    lticontextkey character varying(255) DEFAULT ''::character varying NOT NULL,
    type character varying(100),
    settings text,
    created bigint NOT NULL,
    updated bigint NOT NULL
);


ALTER TABLE public.mdl_enrol_lti_lti2_context OWNER TO postgres;

--
-- Name: TABLE mdl_enrol_lti_lti2_context; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_enrol_lti_lti2_context IS 'Information about a specific LTI contexts from the consumers';


--
-- Name: mdl_enrol_lti_lti2_context_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_lti_lti2_context_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_lti_lti2_context_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_lti_lti2_context_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_enrol_lti_lti2_context_id_seq OWNED BY public.mdl_enrol_lti_lti2_context.id;


--
-- Name: mdl_enrol_lti_lti2_nonce; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_enrol_lti_lti2_nonce (
    id bigint NOT NULL,
    consumerid bigint NOT NULL,
    value character varying(64) DEFAULT ''::character varying NOT NULL,
    expires bigint NOT NULL
);


ALTER TABLE public.mdl_enrol_lti_lti2_nonce OWNER TO postgres;

--
-- Name: TABLE mdl_enrol_lti_lti2_nonce; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_enrol_lti_lti2_nonce IS 'Nonce used for authentication between moodle and a consumer';


--
-- Name: mdl_enrol_lti_lti2_nonce_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_lti_lti2_nonce_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_lti_lti2_nonce_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_lti_lti2_nonce_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_enrol_lti_lti2_nonce_id_seq OWNED BY public.mdl_enrol_lti_lti2_nonce.id;


--
-- Name: mdl_enrol_lti_lti2_resource_link; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_enrol_lti_lti2_resource_link (
    id bigint NOT NULL,
    contextid bigint,
    consumerid bigint,
    ltiresourcelinkkey character varying(255) DEFAULT ''::character varying NOT NULL,
    settings text,
    primaryresourcelinkid bigint,
    shareapproved smallint,
    created bigint NOT NULL,
    updated bigint NOT NULL
);


ALTER TABLE public.mdl_enrol_lti_lti2_resource_link OWNER TO postgres;

--
-- Name: TABLE mdl_enrol_lti_lti2_resource_link; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_enrol_lti_lti2_resource_link IS 'Link from the consumer to the tool';


--
-- Name: mdl_enrol_lti_lti2_resource_link_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_lti_lti2_resource_link_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_lti_lti2_resource_link_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_lti_lti2_resource_link_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_enrol_lti_lti2_resource_link_id_seq OWNED BY public.mdl_enrol_lti_lti2_resource_link.id;


--
-- Name: mdl_enrol_lti_lti2_share_key; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_enrol_lti_lti2_share_key (
    id bigint NOT NULL,
    sharekey character varying(32) DEFAULT ''::character varying NOT NULL,
    resourcelinkid bigint NOT NULL,
    autoapprove smallint NOT NULL,
    expires bigint NOT NULL
);


ALTER TABLE public.mdl_enrol_lti_lti2_share_key OWNER TO postgres;

--
-- Name: TABLE mdl_enrol_lti_lti2_share_key; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_enrol_lti_lti2_share_key IS 'Resource link share key';


--
-- Name: mdl_enrol_lti_lti2_share_key_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_lti_lti2_share_key_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_lti_lti2_share_key_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_lti_lti2_share_key_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_enrol_lti_lti2_share_key_id_seq OWNED BY public.mdl_enrol_lti_lti2_share_key.id;


--
-- Name: mdl_enrol_lti_lti2_tool_proxy; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_enrol_lti_lti2_tool_proxy (
    id bigint NOT NULL,
    toolproxykey character varying(32) DEFAULT ''::character varying NOT NULL,
    consumerid bigint NOT NULL,
    toolproxy text NOT NULL,
    created bigint NOT NULL,
    updated bigint NOT NULL
);


ALTER TABLE public.mdl_enrol_lti_lti2_tool_proxy OWNER TO postgres;

--
-- Name: TABLE mdl_enrol_lti_lti2_tool_proxy; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_enrol_lti_lti2_tool_proxy IS 'A tool proxy between moodle and a consumer';


--
-- Name: mdl_enrol_lti_lti2_tool_proxy_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_lti_lti2_tool_proxy_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_lti_lti2_tool_proxy_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_lti_lti2_tool_proxy_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_enrol_lti_lti2_tool_proxy_id_seq OWNED BY public.mdl_enrol_lti_lti2_tool_proxy.id;


--
-- Name: mdl_enrol_lti_lti2_user_result; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_enrol_lti_lti2_user_result (
    id bigint NOT NULL,
    resourcelinkid bigint NOT NULL,
    ltiuserkey character varying(255) DEFAULT ''::character varying NOT NULL,
    ltiresultsourcedid character varying(1024) DEFAULT ''::character varying NOT NULL,
    created bigint NOT NULL,
    updated bigint NOT NULL
);


ALTER TABLE public.mdl_enrol_lti_lti2_user_result OWNER TO postgres;

--
-- Name: TABLE mdl_enrol_lti_lti2_user_result; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_enrol_lti_lti2_user_result IS 'Results for each user for each resource link';


--
-- Name: mdl_enrol_lti_lti2_user_result_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_lti_lti2_user_result_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_lti_lti2_user_result_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_lti_lti2_user_result_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_enrol_lti_lti2_user_result_id_seq OWNED BY public.mdl_enrol_lti_lti2_user_result.id;


--
-- Name: mdl_enrol_lti_tool_consumer_map; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_enrol_lti_tool_consumer_map (
    id bigint NOT NULL,
    toolid bigint NOT NULL,
    consumerid bigint NOT NULL
);


ALTER TABLE public.mdl_enrol_lti_tool_consumer_map OWNER TO postgres;

--
-- Name: TABLE mdl_enrol_lti_tool_consumer_map; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_enrol_lti_tool_consumer_map IS 'Table that maps the published tool to tool consumers.';


--
-- Name: mdl_enrol_lti_tool_consumer_map_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_lti_tool_consumer_map_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_lti_tool_consumer_map_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_lti_tool_consumer_map_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_enrol_lti_tool_consumer_map_id_seq OWNED BY public.mdl_enrol_lti_tool_consumer_map.id;


--
-- Name: mdl_enrol_lti_tools; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_enrol_lti_tools (
    id bigint NOT NULL,
    enrolid bigint NOT NULL,
    contextid bigint NOT NULL,
    institution character varying(40) DEFAULT ''::character varying NOT NULL,
    lang character varying(30) DEFAULT 'en'::character varying NOT NULL,
    timezone character varying(100) DEFAULT '99'::character varying NOT NULL,
    maxenrolled bigint DEFAULT 0 NOT NULL,
    maildisplay smallint DEFAULT 2 NOT NULL,
    city character varying(120) DEFAULT ''::character varying NOT NULL,
    country character varying(2) DEFAULT ''::character varying NOT NULL,
    gradesync smallint DEFAULT 0 NOT NULL,
    gradesynccompletion smallint DEFAULT 0 NOT NULL,
    membersync smallint DEFAULT 0 NOT NULL,
    membersyncmode smallint DEFAULT 0 NOT NULL,
    roleinstructor bigint NOT NULL,
    rolelearner bigint NOT NULL,
    secret text,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_enrol_lti_tools OWNER TO postgres;

--
-- Name: TABLE mdl_enrol_lti_tools; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_enrol_lti_tools IS 'List of tools provided to the remote system';


--
-- Name: mdl_enrol_lti_tools_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_lti_tools_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_lti_tools_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_lti_tools_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_enrol_lti_tools_id_seq OWNED BY public.mdl_enrol_lti_tools.id;


--
-- Name: mdl_enrol_lti_users; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_enrol_lti_users (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    toolid bigint NOT NULL,
    serviceurl text,
    sourceid text,
    consumerkey text,
    consumersecret text,
    membershipsurl text,
    membershipsid text,
    lastgrade numeric(10,5),
    lastaccess bigint,
    timecreated bigint
);


ALTER TABLE public.mdl_enrol_lti_users OWNER TO postgres;

--
-- Name: TABLE mdl_enrol_lti_users; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_enrol_lti_users IS 'User access log and gradeback data';


--
-- Name: mdl_enrol_lti_users_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_lti_users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_lti_users_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_lti_users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_enrol_lti_users_id_seq OWNED BY public.mdl_enrol_lti_users.id;


--
-- Name: mdl_enrol_paypal; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_enrol_paypal (
    id bigint NOT NULL,
    business character varying(255) DEFAULT ''::character varying NOT NULL,
    receiver_email character varying(255) DEFAULT ''::character varying NOT NULL,
    receiver_id character varying(255) DEFAULT ''::character varying NOT NULL,
    item_name character varying(255) DEFAULT ''::character varying NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    instanceid bigint DEFAULT 0 NOT NULL,
    memo character varying(255) DEFAULT ''::character varying NOT NULL,
    tax character varying(255) DEFAULT ''::character varying NOT NULL,
    option_name1 character varying(255) DEFAULT ''::character varying NOT NULL,
    option_selection1_x character varying(255) DEFAULT ''::character varying NOT NULL,
    option_name2 character varying(255) DEFAULT ''::character varying NOT NULL,
    option_selection2_x character varying(255) DEFAULT ''::character varying NOT NULL,
    payment_status character varying(255) DEFAULT ''::character varying NOT NULL,
    pending_reason character varying(255) DEFAULT ''::character varying NOT NULL,
    reason_code character varying(30) DEFAULT ''::character varying NOT NULL,
    txn_id character varying(255) DEFAULT ''::character varying NOT NULL,
    parent_txn_id character varying(255) DEFAULT ''::character varying NOT NULL,
    payment_type character varying(30) DEFAULT ''::character varying NOT NULL,
    timeupdated bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_enrol_paypal OWNER TO postgres;

--
-- Name: TABLE mdl_enrol_paypal; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_enrol_paypal IS 'Holds all known information about PayPal transactions';


--
-- Name: mdl_enrol_paypal_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_paypal_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_paypal_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_paypal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_enrol_paypal_id_seq OWNED BY public.mdl_enrol_paypal.id;


--
-- Name: mdl_event; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_event (
    id bigint NOT NULL,
    name text NOT NULL,
    description text NOT NULL,
    format smallint DEFAULT 0 NOT NULL,
    categoryid bigint DEFAULT 0 NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    groupid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    repeatid bigint DEFAULT 0 NOT NULL,
    component character varying(100),
    modulename character varying(20) DEFAULT ''::character varying NOT NULL,
    instance bigint DEFAULT 0 NOT NULL,
    type smallint DEFAULT 0 NOT NULL,
    eventtype character varying(20) DEFAULT ''::character varying NOT NULL,
    timestart bigint DEFAULT 0 NOT NULL,
    timeduration bigint DEFAULT 0 NOT NULL,
    timesort bigint,
    visible smallint DEFAULT 1 NOT NULL,
    uuid character varying(255) DEFAULT ''::character varying NOT NULL,
    sequence bigint DEFAULT 1 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    subscriptionid bigint,
    priority bigint,
    location text
);


ALTER TABLE public.mdl_event OWNER TO postgres;

--
-- Name: TABLE mdl_event; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_event IS 'For everything with a time associated to it';


--
-- Name: mdl_event_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_event_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_event_id_seq OWNER TO postgres;

--
-- Name: mdl_event_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_event_id_seq OWNED BY public.mdl_event.id;


--
-- Name: mdl_event_subscriptions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_event_subscriptions (
    id bigint NOT NULL,
    url character varying(255) DEFAULT ''::character varying NOT NULL,
    categoryid bigint DEFAULT 0 NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    groupid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    eventtype character varying(20) DEFAULT ''::character varying NOT NULL,
    pollinterval bigint DEFAULT 0 NOT NULL,
    lastupdated bigint,
    name character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_event_subscriptions OWNER TO postgres;

--
-- Name: TABLE mdl_event_subscriptions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_event_subscriptions IS 'Tracks subscriptions to remote calendars.';


--
-- Name: mdl_event_subscriptions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_event_subscriptions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_event_subscriptions_id_seq OWNER TO postgres;

--
-- Name: mdl_event_subscriptions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_event_subscriptions_id_seq OWNED BY public.mdl_event_subscriptions.id;


--
-- Name: mdl_events_handlers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_events_handlers (
    id bigint NOT NULL,
    eventname character varying(166) DEFAULT ''::character varying NOT NULL,
    component character varying(166) DEFAULT ''::character varying NOT NULL,
    handlerfile character varying(255) DEFAULT ''::character varying NOT NULL,
    handlerfunction text,
    schedule character varying(255),
    status bigint DEFAULT 0 NOT NULL,
    internal smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_events_handlers OWNER TO postgres;

--
-- Name: TABLE mdl_events_handlers; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_events_handlers IS 'This table is for storing which components requests what type of event, and the location of the responsible handlers. For example, the assignment registers ''grade_updated'' event with a function assignment_grade_handler() that should be called event t';


--
-- Name: mdl_events_handlers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_events_handlers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_events_handlers_id_seq OWNER TO postgres;

--
-- Name: mdl_events_handlers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_events_handlers_id_seq OWNED BY public.mdl_events_handlers.id;


--
-- Name: mdl_events_queue; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_events_queue (
    id bigint NOT NULL,
    eventdata text NOT NULL,
    stackdump text,
    userid bigint,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_events_queue OWNER TO postgres;

--
-- Name: TABLE mdl_events_queue; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_events_queue IS 'This table is for storing queued events. It stores only one copy of the eventdata here, and entries from this table are being references by the event_queue_handlers table.';


--
-- Name: mdl_events_queue_handlers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_events_queue_handlers (
    id bigint NOT NULL,
    queuedeventid bigint NOT NULL,
    handlerid bigint NOT NULL,
    status bigint,
    errormessage text,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_events_queue_handlers OWNER TO postgres;

--
-- Name: TABLE mdl_events_queue_handlers; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_events_queue_handlers IS 'This is the list of queued handlers for processing. The event object is retrieved from the events_queue table. When no further reference is made to the event_queues table, the corresponding entry in the events_queue table should be deleted. Entry sho';


--
-- Name: mdl_events_queue_handlers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_events_queue_handlers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_events_queue_handlers_id_seq OWNER TO postgres;

--
-- Name: mdl_events_queue_handlers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_events_queue_handlers_id_seq OWNED BY public.mdl_events_queue_handlers.id;


--
-- Name: mdl_events_queue_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_events_queue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_events_queue_id_seq OWNER TO postgres;

--
-- Name: mdl_events_queue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_events_queue_id_seq OWNED BY public.mdl_events_queue.id;


--
-- Name: mdl_external_functions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_external_functions (
    id bigint NOT NULL,
    name character varying(200) DEFAULT ''::character varying NOT NULL,
    classname character varying(100) DEFAULT ''::character varying NOT NULL,
    methodname character varying(100) DEFAULT ''::character varying NOT NULL,
    classpath character varying(255),
    component character varying(100) DEFAULT ''::character varying NOT NULL,
    capabilities character varying(255),
    services character varying(1333)
);


ALTER TABLE public.mdl_external_functions OWNER TO postgres;

--
-- Name: TABLE mdl_external_functions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_external_functions IS 'list of all external functions';


--
-- Name: mdl_external_functions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_external_functions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_external_functions_id_seq OWNER TO postgres;

--
-- Name: mdl_external_functions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_external_functions_id_seq OWNED BY public.mdl_external_functions.id;


--
-- Name: mdl_external_services; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_external_services (
    id bigint NOT NULL,
    name character varying(200) DEFAULT ''::character varying NOT NULL,
    enabled smallint NOT NULL,
    requiredcapability character varying(150),
    restrictedusers smallint NOT NULL,
    component character varying(100),
    timecreated bigint NOT NULL,
    timemodified bigint,
    shortname character varying(255),
    downloadfiles smallint DEFAULT 0 NOT NULL,
    uploadfiles smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_external_services OWNER TO postgres;

--
-- Name: TABLE mdl_external_services; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_external_services IS 'built in and custom external services';


--
-- Name: mdl_external_services_functions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_external_services_functions (
    id bigint NOT NULL,
    externalserviceid bigint NOT NULL,
    functionname character varying(200) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_external_services_functions OWNER TO postgres;

--
-- Name: TABLE mdl_external_services_functions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_external_services_functions IS 'lists functions available in each service group';


--
-- Name: mdl_external_services_functions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_external_services_functions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_external_services_functions_id_seq OWNER TO postgres;

--
-- Name: mdl_external_services_functions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_external_services_functions_id_seq OWNED BY public.mdl_external_services_functions.id;


--
-- Name: mdl_external_services_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_external_services_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_external_services_id_seq OWNER TO postgres;

--
-- Name: mdl_external_services_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_external_services_id_seq OWNED BY public.mdl_external_services.id;


--
-- Name: mdl_external_services_users; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_external_services_users (
    id bigint NOT NULL,
    externalserviceid bigint NOT NULL,
    userid bigint NOT NULL,
    iprestriction character varying(255),
    validuntil bigint,
    timecreated bigint
);


ALTER TABLE public.mdl_external_services_users OWNER TO postgres;

--
-- Name: TABLE mdl_external_services_users; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_external_services_users IS 'users allowed to use services with restricted users flag';


--
-- Name: mdl_external_services_users_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_external_services_users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_external_services_users_id_seq OWNER TO postgres;

--
-- Name: mdl_external_services_users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_external_services_users_id_seq OWNED BY public.mdl_external_services_users.id;


--
-- Name: mdl_external_tokens; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_external_tokens (
    id bigint NOT NULL,
    token character varying(128) DEFAULT ''::character varying NOT NULL,
    privatetoken character varying(64),
    tokentype smallint NOT NULL,
    userid bigint NOT NULL,
    externalserviceid bigint NOT NULL,
    sid character varying(128),
    contextid bigint NOT NULL,
    creatorid bigint DEFAULT 1 NOT NULL,
    iprestriction character varying(255),
    validuntil bigint,
    timecreated bigint NOT NULL,
    lastaccess bigint
);


ALTER TABLE public.mdl_external_tokens OWNER TO postgres;

--
-- Name: TABLE mdl_external_tokens; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_external_tokens IS 'Security tokens for accessing of external services';


--
-- Name: mdl_external_tokens_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_external_tokens_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_external_tokens_id_seq OWNER TO postgres;

--
-- Name: mdl_external_tokens_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_external_tokens_id_seq OWNED BY public.mdl_external_tokens.id;


--
-- Name: mdl_favourite; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_favourite (
    id bigint NOT NULL,
    component character varying(100) DEFAULT ''::character varying NOT NULL,
    itemtype character varying(100) DEFAULT ''::character varying NOT NULL,
    itemid bigint NOT NULL,
    contextid bigint NOT NULL,
    userid bigint NOT NULL,
    ordering bigint,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_favourite OWNER TO postgres;

--
-- Name: TABLE mdl_favourite; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_favourite IS 'Stores the relationship between an arbitrary item (itemtype, itemid), and a context area (component, contextid) for a specific user. Used by the favourites subsystem.';


--
-- Name: mdl_favourite_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_favourite_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_favourite_id_seq OWNER TO postgres;

--
-- Name: mdl_favourite_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_favourite_id_seq OWNED BY public.mdl_favourite.id;


--
-- Name: mdl_feedback; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_feedback (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text NOT NULL,
    introformat smallint DEFAULT 0 NOT NULL,
    anonymous smallint DEFAULT 1 NOT NULL,
    email_notification smallint DEFAULT 1 NOT NULL,
    multiple_submit smallint DEFAULT 1 NOT NULL,
    autonumbering smallint DEFAULT 1 NOT NULL,
    site_after_submit character varying(255) DEFAULT ''::character varying NOT NULL,
    page_after_submit text NOT NULL,
    page_after_submitformat smallint DEFAULT 0 NOT NULL,
    publish_stats smallint DEFAULT 0 NOT NULL,
    timeopen bigint DEFAULT 0 NOT NULL,
    timeclose bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    completionsubmit smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_feedback OWNER TO postgres;

--
-- Name: TABLE mdl_feedback; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_feedback IS 'all feedbacks';


--
-- Name: mdl_feedback_completed; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_feedback_completed (
    id bigint NOT NULL,
    feedback bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    random_response bigint DEFAULT 0 NOT NULL,
    anonymous_response smallint DEFAULT 0 NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_feedback_completed OWNER TO postgres;

--
-- Name: TABLE mdl_feedback_completed; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_feedback_completed IS 'filled out feedback';


--
-- Name: mdl_feedback_completed_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_feedback_completed_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_feedback_completed_id_seq OWNER TO postgres;

--
-- Name: mdl_feedback_completed_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_feedback_completed_id_seq OWNED BY public.mdl_feedback_completed.id;


--
-- Name: mdl_feedback_completedtmp; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_feedback_completedtmp (
    id bigint NOT NULL,
    feedback bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    guestid character varying(255) DEFAULT ''::character varying NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    random_response bigint DEFAULT 0 NOT NULL,
    anonymous_response smallint DEFAULT 0 NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_feedback_completedtmp OWNER TO postgres;

--
-- Name: TABLE mdl_feedback_completedtmp; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_feedback_completedtmp IS 'filled out feedback';


--
-- Name: mdl_feedback_completedtmp_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_feedback_completedtmp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_feedback_completedtmp_id_seq OWNER TO postgres;

--
-- Name: mdl_feedback_completedtmp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_feedback_completedtmp_id_seq OWNED BY public.mdl_feedback_completedtmp.id;


--
-- Name: mdl_feedback_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_feedback_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_feedback_id_seq OWNER TO postgres;

--
-- Name: mdl_feedback_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_feedback_id_seq OWNED BY public.mdl_feedback.id;


--
-- Name: mdl_feedback_item; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_feedback_item (
    id bigint NOT NULL,
    feedback bigint DEFAULT 0 NOT NULL,
    template bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    label character varying(255) DEFAULT ''::character varying NOT NULL,
    presentation text NOT NULL,
    typ character varying(255) DEFAULT ''::character varying NOT NULL,
    hasvalue smallint DEFAULT 0 NOT NULL,
    "position" smallint DEFAULT 0 NOT NULL,
    required smallint DEFAULT 0 NOT NULL,
    dependitem bigint DEFAULT 0 NOT NULL,
    dependvalue character varying(255) DEFAULT ''::character varying NOT NULL,
    options character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_feedback_item OWNER TO postgres;

--
-- Name: TABLE mdl_feedback_item; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_feedback_item IS 'feedback_items';


--
-- Name: mdl_feedback_item_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_feedback_item_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_feedback_item_id_seq OWNER TO postgres;

--
-- Name: mdl_feedback_item_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_feedback_item_id_seq OWNED BY public.mdl_feedback_item.id;


--
-- Name: mdl_feedback_sitecourse_map; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_feedback_sitecourse_map (
    id bigint NOT NULL,
    feedbackid bigint DEFAULT 0 NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_feedback_sitecourse_map OWNER TO postgres;

--
-- Name: TABLE mdl_feedback_sitecourse_map; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_feedback_sitecourse_map IS 'feedback sitecourse map';


--
-- Name: mdl_feedback_sitecourse_map_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_feedback_sitecourse_map_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_feedback_sitecourse_map_id_seq OWNER TO postgres;

--
-- Name: mdl_feedback_sitecourse_map_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_feedback_sitecourse_map_id_seq OWNED BY public.mdl_feedback_sitecourse_map.id;


--
-- Name: mdl_feedback_template; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_feedback_template (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    ispublic smallint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_feedback_template OWNER TO postgres;

--
-- Name: TABLE mdl_feedback_template; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_feedback_template IS 'templates of feedbackstructures';


--
-- Name: mdl_feedback_template_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_feedback_template_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_feedback_template_id_seq OWNER TO postgres;

--
-- Name: mdl_feedback_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_feedback_template_id_seq OWNED BY public.mdl_feedback_template.id;


--
-- Name: mdl_feedback_value; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_feedback_value (
    id bigint NOT NULL,
    course_id bigint DEFAULT 0 NOT NULL,
    item bigint DEFAULT 0 NOT NULL,
    completed bigint DEFAULT 0 NOT NULL,
    tmp_completed bigint DEFAULT 0 NOT NULL,
    value text NOT NULL
);


ALTER TABLE public.mdl_feedback_value OWNER TO postgres;

--
-- Name: TABLE mdl_feedback_value; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_feedback_value IS 'values of the completeds';


--
-- Name: mdl_feedback_value_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_feedback_value_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_feedback_value_id_seq OWNER TO postgres;

--
-- Name: mdl_feedback_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_feedback_value_id_seq OWNED BY public.mdl_feedback_value.id;


--
-- Name: mdl_feedback_valuetmp; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_feedback_valuetmp (
    id bigint NOT NULL,
    course_id bigint DEFAULT 0 NOT NULL,
    item bigint DEFAULT 0 NOT NULL,
    completed bigint DEFAULT 0 NOT NULL,
    tmp_completed bigint DEFAULT 0 NOT NULL,
    value text NOT NULL
);


ALTER TABLE public.mdl_feedback_valuetmp OWNER TO postgres;

--
-- Name: TABLE mdl_feedback_valuetmp; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_feedback_valuetmp IS 'values of the completedstmp';


--
-- Name: mdl_feedback_valuetmp_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_feedback_valuetmp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_feedback_valuetmp_id_seq OWNER TO postgres;

--
-- Name: mdl_feedback_valuetmp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_feedback_valuetmp_id_seq OWNED BY public.mdl_feedback_valuetmp.id;


--
-- Name: mdl_file_conversion; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_file_conversion (
    id bigint NOT NULL,
    usermodified bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    sourcefileid bigint NOT NULL,
    targetformat character varying(100) DEFAULT ''::character varying NOT NULL,
    status bigint DEFAULT 0,
    statusmessage text,
    converter character varying(255),
    destfileid bigint,
    data text
);


ALTER TABLE public.mdl_file_conversion OWNER TO postgres;

--
-- Name: TABLE mdl_file_conversion; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_file_conversion IS 'Table to track file conversions.';


--
-- Name: mdl_file_conversion_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_file_conversion_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_file_conversion_id_seq OWNER TO postgres;

--
-- Name: mdl_file_conversion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_file_conversion_id_seq OWNED BY public.mdl_file_conversion.id;


--
-- Name: mdl_files; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_files (
    id bigint NOT NULL,
    contenthash character varying(40) DEFAULT ''::character varying NOT NULL,
    pathnamehash character varying(40) DEFAULT ''::character varying NOT NULL,
    contextid bigint NOT NULL,
    component character varying(100) DEFAULT ''::character varying NOT NULL,
    filearea character varying(50) DEFAULT ''::character varying NOT NULL,
    itemid bigint NOT NULL,
    filepath character varying(255) DEFAULT ''::character varying NOT NULL,
    filename character varying(255) DEFAULT ''::character varying NOT NULL,
    userid bigint,
    filesize bigint NOT NULL,
    mimetype character varying(100),
    status bigint DEFAULT 0 NOT NULL,
    source text,
    author character varying(255),
    license character varying(255),
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL,
    referencefileid bigint
);


ALTER TABLE public.mdl_files OWNER TO postgres;

--
-- Name: TABLE mdl_files; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_files IS 'description of files, content is stored in sha1 file pool';


--
-- Name: mdl_files_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_files_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_files_id_seq OWNER TO postgres;

--
-- Name: mdl_files_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_files_id_seq OWNED BY public.mdl_files.id;


--
-- Name: mdl_files_reference; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_files_reference (
    id bigint NOT NULL,
    repositoryid bigint NOT NULL,
    lastsync bigint,
    reference text,
    referencehash character varying(40) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_files_reference OWNER TO postgres;

--
-- Name: TABLE mdl_files_reference; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_files_reference IS 'Store files references';


--
-- Name: mdl_files_reference_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_files_reference_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_files_reference_id_seq OWNER TO postgres;

--
-- Name: mdl_files_reference_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_files_reference_id_seq OWNED BY public.mdl_files_reference.id;


--
-- Name: mdl_filter_active; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_filter_active (
    id bigint NOT NULL,
    filter character varying(32) DEFAULT ''::character varying NOT NULL,
    contextid bigint NOT NULL,
    active smallint NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_filter_active OWNER TO postgres;

--
-- Name: TABLE mdl_filter_active; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_filter_active IS 'Stores information about which filters are active in which contexts. Also the filter sort order. See get_active_filters in lib/filterlib.php for how this data is used.';


--
-- Name: mdl_filter_active_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_filter_active_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_filter_active_id_seq OWNER TO postgres;

--
-- Name: mdl_filter_active_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_filter_active_id_seq OWNED BY public.mdl_filter_active.id;


--
-- Name: mdl_filter_config; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_filter_config (
    id bigint NOT NULL,
    filter character varying(32) DEFAULT ''::character varying NOT NULL,
    contextid bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    value text
);


ALTER TABLE public.mdl_filter_config OWNER TO postgres;

--
-- Name: TABLE mdl_filter_config; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_filter_config IS 'Stores per-context configuration settings for filters which have them.';


--
-- Name: mdl_filter_config_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_filter_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_filter_config_id_seq OWNER TO postgres;

--
-- Name: mdl_filter_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_filter_config_id_seq OWNED BY public.mdl_filter_config.id;


--
-- Name: mdl_folder; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_folder (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text,
    introformat smallint DEFAULT 0 NOT NULL,
    revision bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    display smallint DEFAULT 0 NOT NULL,
    showexpanded smallint DEFAULT 1 NOT NULL,
    showdownloadfolder smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_folder OWNER TO postgres;

--
-- Name: TABLE mdl_folder; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_folder IS 'each record is one folder resource';


--
-- Name: mdl_folder_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_folder_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_folder_id_seq OWNER TO postgres;

--
-- Name: mdl_folder_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_folder_id_seq OWNED BY public.mdl_folder.id;


--
-- Name: mdl_forum; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_forum (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    type character varying(20) DEFAULT 'general'::character varying NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text NOT NULL,
    introformat smallint DEFAULT 0 NOT NULL,
    duedate bigint DEFAULT 0 NOT NULL,
    cutoffdate bigint DEFAULT 0 NOT NULL,
    assessed bigint DEFAULT 0 NOT NULL,
    assesstimestart bigint DEFAULT 0 NOT NULL,
    assesstimefinish bigint DEFAULT 0 NOT NULL,
    scale bigint DEFAULT 0 NOT NULL,
    grade_forum bigint DEFAULT 0 NOT NULL,
    grade_forum_notify smallint DEFAULT 0 NOT NULL,
    maxbytes bigint DEFAULT 0 NOT NULL,
    maxattachments bigint DEFAULT 1 NOT NULL,
    forcesubscribe smallint DEFAULT 0 NOT NULL,
    trackingtype smallint DEFAULT 1 NOT NULL,
    rsstype smallint DEFAULT 0 NOT NULL,
    rssarticles smallint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    warnafter bigint DEFAULT 0 NOT NULL,
    blockafter bigint DEFAULT 0 NOT NULL,
    blockperiod bigint DEFAULT 0 NOT NULL,
    completiondiscussions integer DEFAULT 0 NOT NULL,
    completionreplies integer DEFAULT 0 NOT NULL,
    completionposts integer DEFAULT 0 NOT NULL,
    displaywordcount smallint DEFAULT 0 NOT NULL,
    lockdiscussionafter bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_forum OWNER TO postgres;

--
-- Name: TABLE mdl_forum; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_forum IS 'Forums contain and structure discussion';


--
-- Name: mdl_forum_digests; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_forum_digests (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    forum bigint NOT NULL,
    maildigest smallint DEFAULT '-1'::integer NOT NULL
);


ALTER TABLE public.mdl_forum_digests OWNER TO postgres;

--
-- Name: TABLE mdl_forum_digests; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_forum_digests IS 'Keeps track of user mail delivery preferences for each forum';


--
-- Name: mdl_forum_digests_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_digests_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_digests_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_digests_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_forum_digests_id_seq OWNED BY public.mdl_forum_digests.id;


--
-- Name: mdl_forum_discussion_subs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_forum_discussion_subs (
    id bigint NOT NULL,
    forum bigint NOT NULL,
    userid bigint NOT NULL,
    discussion bigint NOT NULL,
    preference bigint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_forum_discussion_subs OWNER TO postgres;

--
-- Name: TABLE mdl_forum_discussion_subs; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_forum_discussion_subs IS 'Users may choose to subscribe and unsubscribe from specific discussions.';


--
-- Name: mdl_forum_discussion_subs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_discussion_subs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_discussion_subs_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_discussion_subs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_forum_discussion_subs_id_seq OWNED BY public.mdl_forum_discussion_subs.id;


--
-- Name: mdl_forum_discussions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_forum_discussions (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    forum bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    firstpost bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    groupid bigint DEFAULT '-1'::integer NOT NULL,
    assessed smallint DEFAULT 1 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    usermodified bigint DEFAULT 0 NOT NULL,
    timestart bigint DEFAULT 0 NOT NULL,
    timeend bigint DEFAULT 0 NOT NULL,
    pinned smallint DEFAULT 0 NOT NULL,
    timelocked bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_forum_discussions OWNER TO postgres;

--
-- Name: TABLE mdl_forum_discussions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_forum_discussions IS 'Forums are composed of discussions';


--
-- Name: mdl_forum_discussions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_discussions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_discussions_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_discussions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_forum_discussions_id_seq OWNED BY public.mdl_forum_discussions.id;


--
-- Name: mdl_forum_grades; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_forum_grades (
    id bigint NOT NULL,
    forum bigint NOT NULL,
    itemnumber bigint NOT NULL,
    userid bigint NOT NULL,
    grade numeric(10,5),
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_forum_grades OWNER TO postgres;

--
-- Name: TABLE mdl_forum_grades; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_forum_grades IS 'Grading data for forum instances';


--
-- Name: mdl_forum_grades_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_grades_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_grades_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_grades_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_forum_grades_id_seq OWNED BY public.mdl_forum_grades.id;


--
-- Name: mdl_forum_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_forum_id_seq OWNED BY public.mdl_forum.id;


--
-- Name: mdl_forum_posts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_forum_posts (
    id bigint NOT NULL,
    discussion bigint DEFAULT 0 NOT NULL,
    parent bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    created bigint DEFAULT 0 NOT NULL,
    modified bigint DEFAULT 0 NOT NULL,
    mailed smallint DEFAULT 0 NOT NULL,
    subject character varying(255) DEFAULT ''::character varying NOT NULL,
    message text NOT NULL,
    messageformat smallint DEFAULT 0 NOT NULL,
    messagetrust smallint DEFAULT 0 NOT NULL,
    attachment character varying(100) DEFAULT ''::character varying NOT NULL,
    totalscore smallint DEFAULT 0 NOT NULL,
    mailnow bigint DEFAULT 0 NOT NULL,
    deleted smallint DEFAULT 0 NOT NULL,
    privatereplyto bigint DEFAULT 0 NOT NULL,
    wordcount bigint,
    charcount bigint
);


ALTER TABLE public.mdl_forum_posts OWNER TO postgres;

--
-- Name: TABLE mdl_forum_posts; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_forum_posts IS 'All posts are stored in this table';


--
-- Name: mdl_forum_posts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_posts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_posts_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_posts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_forum_posts_id_seq OWNED BY public.mdl_forum_posts.id;


--
-- Name: mdl_forum_queue; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_forum_queue (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    discussionid bigint DEFAULT 0 NOT NULL,
    postid bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_forum_queue OWNER TO postgres;

--
-- Name: TABLE mdl_forum_queue; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_forum_queue IS 'For keeping track of posts that will be mailed in digest form';


--
-- Name: mdl_forum_queue_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_queue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_queue_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_queue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_forum_queue_id_seq OWNED BY public.mdl_forum_queue.id;


--
-- Name: mdl_forum_read; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_forum_read (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    forumid bigint DEFAULT 0 NOT NULL,
    discussionid bigint DEFAULT 0 NOT NULL,
    postid bigint DEFAULT 0 NOT NULL,
    firstread bigint DEFAULT 0 NOT NULL,
    lastread bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_forum_read OWNER TO postgres;

--
-- Name: TABLE mdl_forum_read; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_forum_read IS 'Tracks each users read posts';


--
-- Name: mdl_forum_read_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_read_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_read_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_read_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_forum_read_id_seq OWNED BY public.mdl_forum_read.id;


--
-- Name: mdl_forum_subscriptions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_forum_subscriptions (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    forum bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_forum_subscriptions OWNER TO postgres;

--
-- Name: TABLE mdl_forum_subscriptions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_forum_subscriptions IS 'Keeps track of who is subscribed to what forum';


--
-- Name: mdl_forum_subscriptions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_subscriptions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_subscriptions_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_subscriptions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_forum_subscriptions_id_seq OWNED BY public.mdl_forum_subscriptions.id;


--
-- Name: mdl_forum_track_prefs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_forum_track_prefs (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    forumid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_forum_track_prefs OWNER TO postgres;

--
-- Name: TABLE mdl_forum_track_prefs; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_forum_track_prefs IS 'Tracks each users untracked forums';


--
-- Name: mdl_forum_track_prefs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_track_prefs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_track_prefs_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_track_prefs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_forum_track_prefs_id_seq OWNED BY public.mdl_forum_track_prefs.id;


--
-- Name: mdl_glossary; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_glossary (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text NOT NULL,
    introformat smallint DEFAULT 0 NOT NULL,
    allowduplicatedentries smallint DEFAULT 0 NOT NULL,
    displayformat character varying(50) DEFAULT 'dictionary'::character varying NOT NULL,
    mainglossary smallint DEFAULT 0 NOT NULL,
    showspecial smallint DEFAULT 1 NOT NULL,
    showalphabet smallint DEFAULT 1 NOT NULL,
    showall smallint DEFAULT 1 NOT NULL,
    allowcomments smallint DEFAULT 0 NOT NULL,
    allowprintview smallint DEFAULT 1 NOT NULL,
    usedynalink smallint DEFAULT 1 NOT NULL,
    defaultapproval smallint DEFAULT 1 NOT NULL,
    approvaldisplayformat character varying(50) DEFAULT 'default'::character varying NOT NULL,
    globalglossary smallint DEFAULT 0 NOT NULL,
    entbypage smallint DEFAULT 10 NOT NULL,
    editalways smallint DEFAULT 0 NOT NULL,
    rsstype smallint DEFAULT 0 NOT NULL,
    rssarticles smallint DEFAULT 0 NOT NULL,
    assessed bigint DEFAULT 0 NOT NULL,
    assesstimestart bigint DEFAULT 0 NOT NULL,
    assesstimefinish bigint DEFAULT 0 NOT NULL,
    scale bigint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    completionentries integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_glossary OWNER TO postgres;

--
-- Name: TABLE mdl_glossary; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_glossary IS 'all glossaries';


--
-- Name: mdl_glossary_alias; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_glossary_alias (
    id bigint NOT NULL,
    entryid bigint DEFAULT 0 NOT NULL,
    alias character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_glossary_alias OWNER TO postgres;

--
-- Name: TABLE mdl_glossary_alias; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_glossary_alias IS 'entries alias';


--
-- Name: mdl_glossary_alias_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_glossary_alias_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_glossary_alias_id_seq OWNER TO postgres;

--
-- Name: mdl_glossary_alias_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_glossary_alias_id_seq OWNED BY public.mdl_glossary_alias.id;


--
-- Name: mdl_glossary_categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_glossary_categories (
    id bigint NOT NULL,
    glossaryid bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    usedynalink smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_glossary_categories OWNER TO postgres;

--
-- Name: TABLE mdl_glossary_categories; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_glossary_categories IS 'all categories for glossary entries';


--
-- Name: mdl_glossary_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_glossary_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_glossary_categories_id_seq OWNER TO postgres;

--
-- Name: mdl_glossary_categories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_glossary_categories_id_seq OWNED BY public.mdl_glossary_categories.id;


--
-- Name: mdl_glossary_entries; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_glossary_entries (
    id bigint NOT NULL,
    glossaryid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    concept character varying(255) DEFAULT ''::character varying NOT NULL,
    definition text NOT NULL,
    definitionformat smallint DEFAULT 0 NOT NULL,
    definitiontrust smallint DEFAULT 0 NOT NULL,
    attachment character varying(100) DEFAULT ''::character varying NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    teacherentry smallint DEFAULT 0 NOT NULL,
    sourceglossaryid bigint DEFAULT 0 NOT NULL,
    usedynalink smallint DEFAULT 1 NOT NULL,
    casesensitive smallint DEFAULT 0 NOT NULL,
    fullmatch smallint DEFAULT 1 NOT NULL,
    approved smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_glossary_entries OWNER TO postgres;

--
-- Name: TABLE mdl_glossary_entries; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_glossary_entries IS 'all glossary entries';


--
-- Name: mdl_glossary_entries_categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_glossary_entries_categories (
    id bigint NOT NULL,
    categoryid bigint DEFAULT 0 NOT NULL,
    entryid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_glossary_entries_categories OWNER TO postgres;

--
-- Name: TABLE mdl_glossary_entries_categories; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_glossary_entries_categories IS 'categories of each glossary entry';


--
-- Name: mdl_glossary_entries_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_glossary_entries_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_glossary_entries_categories_id_seq OWNER TO postgres;

--
-- Name: mdl_glossary_entries_categories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_glossary_entries_categories_id_seq OWNED BY public.mdl_glossary_entries_categories.id;


--
-- Name: mdl_glossary_entries_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_glossary_entries_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_glossary_entries_id_seq OWNER TO postgres;

--
-- Name: mdl_glossary_entries_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_glossary_entries_id_seq OWNED BY public.mdl_glossary_entries.id;


--
-- Name: mdl_glossary_formats; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_glossary_formats (
    id bigint NOT NULL,
    name character varying(50) DEFAULT ''::character varying NOT NULL,
    popupformatname character varying(50) DEFAULT ''::character varying NOT NULL,
    visible smallint DEFAULT 1 NOT NULL,
    showgroup smallint DEFAULT 1 NOT NULL,
    showtabs character varying(100),
    defaultmode character varying(50) DEFAULT ''::character varying NOT NULL,
    defaulthook character varying(50) DEFAULT ''::character varying NOT NULL,
    sortkey character varying(50) DEFAULT ''::character varying NOT NULL,
    sortorder character varying(50) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_glossary_formats OWNER TO postgres;

--
-- Name: TABLE mdl_glossary_formats; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_glossary_formats IS 'Setting of the display formats';


--
-- Name: mdl_glossary_formats_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_glossary_formats_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_glossary_formats_id_seq OWNER TO postgres;

--
-- Name: mdl_glossary_formats_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_glossary_formats_id_seq OWNED BY public.mdl_glossary_formats.id;


--
-- Name: mdl_glossary_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_glossary_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_glossary_id_seq OWNER TO postgres;

--
-- Name: mdl_glossary_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_glossary_id_seq OWNED BY public.mdl_glossary.id;


--
-- Name: mdl_grade_categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grade_categories (
    id bigint NOT NULL,
    courseid bigint NOT NULL,
    parent bigint,
    depth bigint DEFAULT 0 NOT NULL,
    path character varying(255),
    fullname character varying(255) DEFAULT ''::character varying NOT NULL,
    aggregation bigint DEFAULT 0 NOT NULL,
    keephigh bigint DEFAULT 0 NOT NULL,
    droplow bigint DEFAULT 0 NOT NULL,
    aggregateonlygraded smallint DEFAULT 0 NOT NULL,
    aggregateoutcomes smallint DEFAULT 0 NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    hidden smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_grade_categories OWNER TO postgres;

--
-- Name: TABLE mdl_grade_categories; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grade_categories IS 'This table keeps information about categories, used for grouping items.';


--
-- Name: mdl_grade_categories_history; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grade_categories_history (
    id bigint NOT NULL,
    action bigint DEFAULT 0 NOT NULL,
    oldid bigint NOT NULL,
    source character varying(255),
    timemodified bigint,
    loggeduser bigint,
    courseid bigint NOT NULL,
    parent bigint,
    depth bigint DEFAULT 0 NOT NULL,
    path character varying(255),
    fullname character varying(255) DEFAULT ''::character varying NOT NULL,
    aggregation bigint DEFAULT 0 NOT NULL,
    keephigh bigint DEFAULT 0 NOT NULL,
    droplow bigint DEFAULT 0 NOT NULL,
    aggregateonlygraded smallint DEFAULT 0 NOT NULL,
    aggregateoutcomes smallint DEFAULT 0 NOT NULL,
    aggregatesubcats smallint DEFAULT 0 NOT NULL,
    hidden smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_grade_categories_history OWNER TO postgres;

--
-- Name: TABLE mdl_grade_categories_history; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grade_categories_history IS 'History of grade_categories';


--
-- Name: mdl_grade_categories_history_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_categories_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_categories_history_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_categories_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grade_categories_history_id_seq OWNED BY public.mdl_grade_categories_history.id;


--
-- Name: mdl_grade_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_categories_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_categories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grade_categories_id_seq OWNED BY public.mdl_grade_categories.id;


--
-- Name: mdl_grade_grades; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grade_grades (
    id bigint NOT NULL,
    itemid bigint NOT NULL,
    userid bigint NOT NULL,
    rawgrade numeric(10,5),
    rawgrademax numeric(10,5) DEFAULT 100 NOT NULL,
    rawgrademin numeric(10,5) DEFAULT 0 NOT NULL,
    rawscaleid bigint,
    usermodified bigint,
    finalgrade numeric(10,5),
    hidden bigint DEFAULT 0 NOT NULL,
    locked bigint DEFAULT 0 NOT NULL,
    locktime bigint DEFAULT 0 NOT NULL,
    exported bigint DEFAULT 0 NOT NULL,
    overridden bigint DEFAULT 0 NOT NULL,
    excluded bigint DEFAULT 0 NOT NULL,
    feedback text,
    feedbackformat bigint DEFAULT 0 NOT NULL,
    information text,
    informationformat bigint DEFAULT 0 NOT NULL,
    timecreated bigint,
    timemodified bigint,
    aggregationstatus character varying(10) DEFAULT 'unknown'::character varying NOT NULL,
    aggregationweight numeric(10,5)
);


ALTER TABLE public.mdl_grade_grades OWNER TO postgres;

--
-- Name: TABLE mdl_grade_grades; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grade_grades IS 'grade_grades  This table keeps individual grades for each user and each item, exactly as imported or submitted by modules. The rawgrademax/min and rawscaleid are stored here to record the values at the time the grade was stored, because teachers migh';


--
-- Name: mdl_grade_grades_history; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grade_grades_history (
    id bigint NOT NULL,
    action bigint DEFAULT 0 NOT NULL,
    oldid bigint NOT NULL,
    source character varying(255),
    timemodified bigint,
    loggeduser bigint,
    itemid bigint NOT NULL,
    userid bigint NOT NULL,
    rawgrade numeric(10,5),
    rawgrademax numeric(10,5) DEFAULT 100 NOT NULL,
    rawgrademin numeric(10,5) DEFAULT 0 NOT NULL,
    rawscaleid bigint,
    usermodified bigint,
    finalgrade numeric(10,5),
    hidden bigint DEFAULT 0 NOT NULL,
    locked bigint DEFAULT 0 NOT NULL,
    locktime bigint DEFAULT 0 NOT NULL,
    exported bigint DEFAULT 0 NOT NULL,
    overridden bigint DEFAULT 0 NOT NULL,
    excluded bigint DEFAULT 0 NOT NULL,
    feedback text,
    feedbackformat bigint DEFAULT 0 NOT NULL,
    information text,
    informationformat bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_grade_grades_history OWNER TO postgres;

--
-- Name: TABLE mdl_grade_grades_history; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grade_grades_history IS 'History table';


--
-- Name: mdl_grade_grades_history_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_grades_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_grades_history_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_grades_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grade_grades_history_id_seq OWNED BY public.mdl_grade_grades_history.id;


--
-- Name: mdl_grade_grades_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_grades_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_grades_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_grades_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grade_grades_id_seq OWNED BY public.mdl_grade_grades.id;


--
-- Name: mdl_grade_import_newitem; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grade_import_newitem (
    id bigint NOT NULL,
    itemname character varying(255) DEFAULT ''::character varying NOT NULL,
    importcode bigint NOT NULL,
    importer bigint NOT NULL
);


ALTER TABLE public.mdl_grade_import_newitem OWNER TO postgres;

--
-- Name: TABLE mdl_grade_import_newitem; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grade_import_newitem IS 'temporary table for storing new grade_item names from grade import';


--
-- Name: mdl_grade_import_newitem_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_import_newitem_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_import_newitem_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_import_newitem_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grade_import_newitem_id_seq OWNED BY public.mdl_grade_import_newitem.id;


--
-- Name: mdl_grade_import_values; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grade_import_values (
    id bigint NOT NULL,
    itemid bigint,
    newgradeitem bigint,
    userid bigint NOT NULL,
    finalgrade numeric(10,5),
    feedback text,
    importcode bigint NOT NULL,
    importer bigint,
    importonlyfeedback smallint DEFAULT 0
);


ALTER TABLE public.mdl_grade_import_values OWNER TO postgres;

--
-- Name: TABLE mdl_grade_import_values; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grade_import_values IS 'Temporary table for importing grades';


--
-- Name: mdl_grade_import_values_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_import_values_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_import_values_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_import_values_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grade_import_values_id_seq OWNED BY public.mdl_grade_import_values.id;


--
-- Name: mdl_grade_items; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grade_items (
    id bigint NOT NULL,
    courseid bigint,
    categoryid bigint,
    itemname character varying(255),
    itemtype character varying(30) DEFAULT ''::character varying NOT NULL,
    itemmodule character varying(30),
    iteminstance bigint,
    itemnumber bigint,
    iteminfo text,
    idnumber character varying(255),
    calculation text,
    gradetype smallint DEFAULT 1 NOT NULL,
    grademax numeric(10,5) DEFAULT 100 NOT NULL,
    grademin numeric(10,5) DEFAULT 0 NOT NULL,
    scaleid bigint,
    outcomeid bigint,
    gradepass numeric(10,5) DEFAULT 0 NOT NULL,
    multfactor numeric(10,5) DEFAULT 1.0 NOT NULL,
    plusfactor numeric(10,5) DEFAULT 0 NOT NULL,
    aggregationcoef numeric(10,5) DEFAULT 0 NOT NULL,
    aggregationcoef2 numeric(10,5) DEFAULT 0 NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL,
    display bigint DEFAULT 0 NOT NULL,
    decimals smallint,
    hidden bigint DEFAULT 0 NOT NULL,
    locked bigint DEFAULT 0 NOT NULL,
    locktime bigint DEFAULT 0 NOT NULL,
    needsupdate bigint DEFAULT 0 NOT NULL,
    weightoverride smallint DEFAULT 0 NOT NULL,
    timecreated bigint,
    timemodified bigint
);


ALTER TABLE public.mdl_grade_items OWNER TO postgres;

--
-- Name: TABLE mdl_grade_items; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grade_items IS 'This table keeps information about gradeable items (ie columns). If an activity (eg an assignment or quiz) has multiple grade_items associated with it (eg several outcomes or numerical grades), then there will be a corresponding multiple number of ro';


--
-- Name: mdl_grade_items_history; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grade_items_history (
    id bigint NOT NULL,
    action bigint DEFAULT 0 NOT NULL,
    oldid bigint NOT NULL,
    source character varying(255),
    timemodified bigint,
    loggeduser bigint,
    courseid bigint,
    categoryid bigint,
    itemname character varying(255),
    itemtype character varying(30) DEFAULT ''::character varying NOT NULL,
    itemmodule character varying(30),
    iteminstance bigint,
    itemnumber bigint,
    iteminfo text,
    idnumber character varying(255),
    calculation text,
    gradetype smallint DEFAULT 1 NOT NULL,
    grademax numeric(10,5) DEFAULT 100 NOT NULL,
    grademin numeric(10,5) DEFAULT 0 NOT NULL,
    scaleid bigint,
    outcomeid bigint,
    gradepass numeric(10,5) DEFAULT 0 NOT NULL,
    multfactor numeric(10,5) DEFAULT 1.0 NOT NULL,
    plusfactor numeric(10,5) DEFAULT 0 NOT NULL,
    aggregationcoef numeric(10,5) DEFAULT 0 NOT NULL,
    aggregationcoef2 numeric(10,5) DEFAULT 0 NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL,
    hidden bigint DEFAULT 0 NOT NULL,
    locked bigint DEFAULT 0 NOT NULL,
    locktime bigint DEFAULT 0 NOT NULL,
    needsupdate bigint DEFAULT 0 NOT NULL,
    display bigint DEFAULT 0 NOT NULL,
    decimals smallint,
    weightoverride smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_grade_items_history OWNER TO postgres;

--
-- Name: TABLE mdl_grade_items_history; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grade_items_history IS 'History of grade_items';


--
-- Name: mdl_grade_items_history_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_items_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_items_history_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_items_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grade_items_history_id_seq OWNED BY public.mdl_grade_items_history.id;


--
-- Name: mdl_grade_items_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_items_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_items_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_items_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grade_items_id_seq OWNED BY public.mdl_grade_items.id;


--
-- Name: mdl_grade_letters; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grade_letters (
    id bigint NOT NULL,
    contextid bigint NOT NULL,
    lowerboundary numeric(10,5) NOT NULL,
    letter character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_grade_letters OWNER TO postgres;

--
-- Name: TABLE mdl_grade_letters; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grade_letters IS 'Repository for grade letters, for courses and other moodle entities that use grades.';


--
-- Name: mdl_grade_letters_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_letters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_letters_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_letters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grade_letters_id_seq OWNED BY public.mdl_grade_letters.id;


--
-- Name: mdl_grade_outcomes; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grade_outcomes (
    id bigint NOT NULL,
    courseid bigint,
    shortname character varying(255) DEFAULT ''::character varying NOT NULL,
    fullname text NOT NULL,
    scaleid bigint,
    description text,
    descriptionformat smallint DEFAULT 0 NOT NULL,
    timecreated bigint,
    timemodified bigint,
    usermodified bigint
);


ALTER TABLE public.mdl_grade_outcomes OWNER TO postgres;

--
-- Name: TABLE mdl_grade_outcomes; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grade_outcomes IS 'This table describes the outcomes used in the system. An outcome is a statement tied to a rubric scale from low to high, such as âNot met, Borderline, Metâ (stored as 0,1 or 2)';


--
-- Name: mdl_grade_outcomes_courses; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grade_outcomes_courses (
    id bigint NOT NULL,
    courseid bigint NOT NULL,
    outcomeid bigint NOT NULL
);


ALTER TABLE public.mdl_grade_outcomes_courses OWNER TO postgres;

--
-- Name: TABLE mdl_grade_outcomes_courses; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grade_outcomes_courses IS 'stores what outcomes are used in what courses.';


--
-- Name: mdl_grade_outcomes_courses_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_outcomes_courses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_outcomes_courses_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_outcomes_courses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grade_outcomes_courses_id_seq OWNED BY public.mdl_grade_outcomes_courses.id;


--
-- Name: mdl_grade_outcomes_history; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grade_outcomes_history (
    id bigint NOT NULL,
    action bigint DEFAULT 0 NOT NULL,
    oldid bigint NOT NULL,
    source character varying(255),
    timemodified bigint,
    loggeduser bigint,
    courseid bigint,
    shortname character varying(255) DEFAULT ''::character varying NOT NULL,
    fullname text NOT NULL,
    scaleid bigint,
    description text,
    descriptionformat smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_grade_outcomes_history OWNER TO postgres;

--
-- Name: TABLE mdl_grade_outcomes_history; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grade_outcomes_history IS 'History table';


--
-- Name: mdl_grade_outcomes_history_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_outcomes_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_outcomes_history_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_outcomes_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grade_outcomes_history_id_seq OWNED BY public.mdl_grade_outcomes_history.id;


--
-- Name: mdl_grade_outcomes_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_outcomes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_outcomes_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_outcomes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grade_outcomes_id_seq OWNED BY public.mdl_grade_outcomes.id;


--
-- Name: mdl_grade_settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grade_settings (
    id bigint NOT NULL,
    courseid bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    value text
);


ALTER TABLE public.mdl_grade_settings OWNER TO postgres;

--
-- Name: TABLE mdl_grade_settings; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grade_settings IS 'gradebook settings';


--
-- Name: mdl_grade_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_settings_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grade_settings_id_seq OWNED BY public.mdl_grade_settings.id;


--
-- Name: mdl_grading_areas; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grading_areas (
    id bigint NOT NULL,
    contextid bigint NOT NULL,
    component character varying(100) DEFAULT ''::character varying NOT NULL,
    areaname character varying(100) DEFAULT ''::character varying NOT NULL,
    activemethod character varying(100)
);


ALTER TABLE public.mdl_grading_areas OWNER TO postgres;

--
-- Name: TABLE mdl_grading_areas; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grading_areas IS 'Identifies gradable areas where advanced grading can happen. For each area, the current active plugin can be set.';


--
-- Name: mdl_grading_areas_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grading_areas_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grading_areas_id_seq OWNER TO postgres;

--
-- Name: mdl_grading_areas_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grading_areas_id_seq OWNED BY public.mdl_grading_areas.id;


--
-- Name: mdl_grading_definitions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grading_definitions (
    id bigint NOT NULL,
    areaid bigint NOT NULL,
    method character varying(100) DEFAULT ''::character varying NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    description text,
    descriptionformat smallint,
    status bigint DEFAULT 0 NOT NULL,
    copiedfromid bigint,
    timecreated bigint NOT NULL,
    usercreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL,
    timecopied bigint DEFAULT 0,
    options text
);


ALTER TABLE public.mdl_grading_definitions OWNER TO postgres;

--
-- Name: TABLE mdl_grading_definitions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grading_definitions IS 'Contains the basic information about an advanced grading form defined in the given gradable area';


--
-- Name: mdl_grading_definitions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grading_definitions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grading_definitions_id_seq OWNER TO postgres;

--
-- Name: mdl_grading_definitions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grading_definitions_id_seq OWNED BY public.mdl_grading_definitions.id;


--
-- Name: mdl_grading_instances; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_grading_instances (
    id bigint NOT NULL,
    definitionid bigint NOT NULL,
    raterid bigint NOT NULL,
    itemid bigint,
    rawgrade numeric(10,5),
    status bigint DEFAULT 0 NOT NULL,
    feedback text,
    feedbackformat smallint,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_grading_instances OWNER TO postgres;

--
-- Name: TABLE mdl_grading_instances; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_grading_instances IS 'Grading form instance is an assessment record for one gradable item assessed by one rater';


--
-- Name: mdl_grading_instances_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grading_instances_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grading_instances_id_seq OWNER TO postgres;

--
-- Name: mdl_grading_instances_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_grading_instances_id_seq OWNED BY public.mdl_grading_instances.id;


--
-- Name: mdl_gradingform_guide_comments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_gradingform_guide_comments (
    id bigint NOT NULL,
    definitionid bigint NOT NULL,
    sortorder bigint NOT NULL,
    description text,
    descriptionformat smallint
);


ALTER TABLE public.mdl_gradingform_guide_comments OWNER TO postgres;

--
-- Name: TABLE mdl_gradingform_guide_comments; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_gradingform_guide_comments IS 'frequently used comments used in marking guide';


--
-- Name: mdl_gradingform_guide_comments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_gradingform_guide_comments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_gradingform_guide_comments_id_seq OWNER TO postgres;

--
-- Name: mdl_gradingform_guide_comments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_gradingform_guide_comments_id_seq OWNED BY public.mdl_gradingform_guide_comments.id;


--
-- Name: mdl_gradingform_guide_criteria; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_gradingform_guide_criteria (
    id bigint NOT NULL,
    definitionid bigint NOT NULL,
    sortorder bigint NOT NULL,
    shortname character varying(255) DEFAULT ''::character varying NOT NULL,
    description text,
    descriptionformat smallint,
    descriptionmarkers text,
    descriptionmarkersformat smallint,
    maxscore numeric(10,5) NOT NULL
);


ALTER TABLE public.mdl_gradingform_guide_criteria OWNER TO postgres;

--
-- Name: TABLE mdl_gradingform_guide_criteria; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_gradingform_guide_criteria IS 'Stores the rows of the criteria grid.';


--
-- Name: mdl_gradingform_guide_criteria_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_gradingform_guide_criteria_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_gradingform_guide_criteria_id_seq OWNER TO postgres;

--
-- Name: mdl_gradingform_guide_criteria_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_gradingform_guide_criteria_id_seq OWNED BY public.mdl_gradingform_guide_criteria.id;


--
-- Name: mdl_gradingform_guide_fillings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_gradingform_guide_fillings (
    id bigint NOT NULL,
    instanceid bigint NOT NULL,
    criterionid bigint NOT NULL,
    remark text,
    remarkformat smallint,
    score numeric(10,5) NOT NULL
);


ALTER TABLE public.mdl_gradingform_guide_fillings OWNER TO postgres;

--
-- Name: TABLE mdl_gradingform_guide_fillings; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_gradingform_guide_fillings IS 'Stores the data of how the guide is filled by a particular rater';


--
-- Name: mdl_gradingform_guide_fillings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_gradingform_guide_fillings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_gradingform_guide_fillings_id_seq OWNER TO postgres;

--
-- Name: mdl_gradingform_guide_fillings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_gradingform_guide_fillings_id_seq OWNED BY public.mdl_gradingform_guide_fillings.id;


--
-- Name: mdl_gradingform_rubric_criteria; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_gradingform_rubric_criteria (
    id bigint NOT NULL,
    definitionid bigint NOT NULL,
    sortorder bigint NOT NULL,
    description text,
    descriptionformat smallint
);


ALTER TABLE public.mdl_gradingform_rubric_criteria OWNER TO postgres;

--
-- Name: TABLE mdl_gradingform_rubric_criteria; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_gradingform_rubric_criteria IS 'Stores the rows of the rubric grid.';


--
-- Name: mdl_gradingform_rubric_criteria_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_gradingform_rubric_criteria_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_gradingform_rubric_criteria_id_seq OWNER TO postgres;

--
-- Name: mdl_gradingform_rubric_criteria_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_gradingform_rubric_criteria_id_seq OWNED BY public.mdl_gradingform_rubric_criteria.id;


--
-- Name: mdl_gradingform_rubric_fillings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_gradingform_rubric_fillings (
    id bigint NOT NULL,
    instanceid bigint NOT NULL,
    criterionid bigint NOT NULL,
    levelid bigint,
    remark text,
    remarkformat smallint
);


ALTER TABLE public.mdl_gradingform_rubric_fillings OWNER TO postgres;

--
-- Name: TABLE mdl_gradingform_rubric_fillings; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_gradingform_rubric_fillings IS 'Stores the data of how the rubric is filled by a particular rater';


--
-- Name: mdl_gradingform_rubric_fillings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_gradingform_rubric_fillings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_gradingform_rubric_fillings_id_seq OWNER TO postgres;

--
-- Name: mdl_gradingform_rubric_fillings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_gradingform_rubric_fillings_id_seq OWNED BY public.mdl_gradingform_rubric_fillings.id;


--
-- Name: mdl_gradingform_rubric_levels; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_gradingform_rubric_levels (
    id bigint NOT NULL,
    criterionid bigint NOT NULL,
    score numeric(10,5) NOT NULL,
    definition text,
    definitionformat bigint
);


ALTER TABLE public.mdl_gradingform_rubric_levels OWNER TO postgres;

--
-- Name: TABLE mdl_gradingform_rubric_levels; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_gradingform_rubric_levels IS 'Stores the columns of the rubric grid.';


--
-- Name: mdl_gradingform_rubric_levels_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_gradingform_rubric_levels_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_gradingform_rubric_levels_id_seq OWNER TO postgres;

--
-- Name: mdl_gradingform_rubric_levels_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_gradingform_rubric_levels_id_seq OWNED BY public.mdl_gradingform_rubric_levels.id;


--
-- Name: mdl_groupings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_groupings (
    id bigint NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    idnumber character varying(100) DEFAULT ''::character varying NOT NULL,
    description text,
    descriptionformat smallint DEFAULT 0 NOT NULL,
    configdata text,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_groupings OWNER TO postgres;

--
-- Name: TABLE mdl_groupings; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_groupings IS 'A grouping is a collection of groups. WAS: groups_groupings';


--
-- Name: mdl_groupings_groups; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_groupings_groups (
    id bigint NOT NULL,
    groupingid bigint DEFAULT 0 NOT NULL,
    groupid bigint DEFAULT 0 NOT NULL,
    timeadded bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_groupings_groups OWNER TO postgres;

--
-- Name: TABLE mdl_groupings_groups; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_groupings_groups IS 'Link a grouping to a group (note, groups can be in multiple groupings ONLY in a course). WAS: groups_groupings_groups';


--
-- Name: mdl_groupings_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_groupings_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_groupings_groups_id_seq OWNER TO postgres;

--
-- Name: mdl_groupings_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_groupings_groups_id_seq OWNED BY public.mdl_groupings_groups.id;


--
-- Name: mdl_groupings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_groupings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_groupings_id_seq OWNER TO postgres;

--
-- Name: mdl_groupings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_groupings_id_seq OWNED BY public.mdl_groupings.id;


--
-- Name: mdl_groups; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_groups (
    id bigint NOT NULL,
    courseid bigint NOT NULL,
    idnumber character varying(100) DEFAULT ''::character varying NOT NULL,
    name character varying(254) DEFAULT ''::character varying NOT NULL,
    description text,
    descriptionformat smallint DEFAULT 0 NOT NULL,
    enrolmentkey character varying(50),
    picture bigint DEFAULT 0 NOT NULL,
    hidepicture smallint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_groups OWNER TO postgres;

--
-- Name: TABLE mdl_groups; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_groups IS 'Each record represents a group.';


--
-- Name: mdl_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_groups_id_seq OWNER TO postgres;

--
-- Name: mdl_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_groups_id_seq OWNED BY public.mdl_groups.id;


--
-- Name: mdl_groups_members; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_groups_members (
    id bigint NOT NULL,
    groupid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    timeadded bigint DEFAULT 0 NOT NULL,
    component character varying(100) DEFAULT ''::character varying NOT NULL,
    itemid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_groups_members OWNER TO postgres;

--
-- Name: TABLE mdl_groups_members; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_groups_members IS 'Link a user to a group.';


--
-- Name: mdl_groups_members_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_groups_members_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_groups_members_id_seq OWNER TO postgres;

--
-- Name: mdl_groups_members_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_groups_members_id_seq OWNED BY public.mdl_groups_members.id;


--
-- Name: mdl_h5p; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_h5p (
    id bigint NOT NULL,
    jsoncontent text NOT NULL,
    mainlibraryid bigint NOT NULL,
    displayoptions smallint,
    pathnamehash character varying(40) DEFAULT ''::character varying NOT NULL,
    contenthash character varying(40) DEFAULT ''::character varying NOT NULL,
    filtered text,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_h5p OWNER TO postgres;

--
-- Name: TABLE mdl_h5p; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_h5p IS 'Stores H5P content information';


--
-- Name: mdl_h5p_contents_libraries; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_h5p_contents_libraries (
    id bigint NOT NULL,
    h5pid bigint NOT NULL,
    libraryid bigint NOT NULL,
    dependencytype character varying(10) DEFAULT ''::character varying NOT NULL,
    dropcss smallint NOT NULL,
    weight bigint NOT NULL
);


ALTER TABLE public.mdl_h5p_contents_libraries OWNER TO postgres;

--
-- Name: TABLE mdl_h5p_contents_libraries; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_h5p_contents_libraries IS 'Store which library is used in which content.';


--
-- Name: mdl_h5p_contents_libraries_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_h5p_contents_libraries_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_h5p_contents_libraries_id_seq OWNER TO postgres;

--
-- Name: mdl_h5p_contents_libraries_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_h5p_contents_libraries_id_seq OWNED BY public.mdl_h5p_contents_libraries.id;


--
-- Name: mdl_h5p_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_h5p_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_h5p_id_seq OWNER TO postgres;

--
-- Name: mdl_h5p_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_h5p_id_seq OWNED BY public.mdl_h5p.id;


--
-- Name: mdl_h5p_libraries; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_h5p_libraries (
    id bigint NOT NULL,
    machinename character varying(255) DEFAULT ''::character varying NOT NULL,
    title character varying(255) DEFAULT ''::character varying NOT NULL,
    majorversion smallint NOT NULL,
    minorversion smallint NOT NULL,
    patchversion smallint NOT NULL,
    runnable smallint NOT NULL,
    fullscreen smallint DEFAULT 0 NOT NULL,
    embedtypes character varying(255) DEFAULT ''::character varying NOT NULL,
    preloadedjs text,
    preloadedcss text,
    droplibrarycss text,
    semantics text,
    addto text,
    coremajor smallint,
    coreminor smallint
);


ALTER TABLE public.mdl_h5p_libraries OWNER TO postgres;

--
-- Name: TABLE mdl_h5p_libraries; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_h5p_libraries IS 'Stores information about libraries used by H5P content.';


--
-- Name: mdl_h5p_libraries_cachedassets; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_h5p_libraries_cachedassets (
    id bigint NOT NULL,
    libraryid bigint NOT NULL,
    hash character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_h5p_libraries_cachedassets OWNER TO postgres;

--
-- Name: TABLE mdl_h5p_libraries_cachedassets; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_h5p_libraries_cachedassets IS 'H5P cached library assets';


--
-- Name: mdl_h5p_libraries_cachedassets_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_h5p_libraries_cachedassets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_h5p_libraries_cachedassets_id_seq OWNER TO postgres;

--
-- Name: mdl_h5p_libraries_cachedassets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_h5p_libraries_cachedassets_id_seq OWNED BY public.mdl_h5p_libraries_cachedassets.id;


--
-- Name: mdl_h5p_libraries_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_h5p_libraries_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_h5p_libraries_id_seq OWNER TO postgres;

--
-- Name: mdl_h5p_libraries_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_h5p_libraries_id_seq OWNED BY public.mdl_h5p_libraries.id;


--
-- Name: mdl_h5p_library_dependencies; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_h5p_library_dependencies (
    id bigint NOT NULL,
    libraryid bigint NOT NULL,
    requiredlibraryid bigint NOT NULL,
    dependencytype character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_h5p_library_dependencies OWNER TO postgres;

--
-- Name: TABLE mdl_h5p_library_dependencies; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_h5p_library_dependencies IS 'Stores H5P library dependencies';


--
-- Name: mdl_h5p_library_dependencies_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_h5p_library_dependencies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_h5p_library_dependencies_id_seq OWNER TO postgres;

--
-- Name: mdl_h5p_library_dependencies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_h5p_library_dependencies_id_seq OWNED BY public.mdl_h5p_library_dependencies.id;


--
-- Name: mdl_h5pactivity; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_h5pactivity (
    id bigint NOT NULL,
    course bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    intro text,
    introformat smallint DEFAULT 0 NOT NULL,
    grade bigint DEFAULT 0,
    displayoptions smallint DEFAULT 0 NOT NULL,
    enabletracking smallint DEFAULT 1 NOT NULL,
    grademethod smallint DEFAULT 1 NOT NULL,
    reviewmode smallint DEFAULT 1
);


ALTER TABLE public.mdl_h5pactivity OWNER TO postgres;

--
-- Name: TABLE mdl_h5pactivity; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_h5pactivity IS 'Stores the h5pactivity activity module instances.';


--
-- Name: mdl_h5pactivity_attempts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_h5pactivity_attempts (
    id bigint NOT NULL,
    h5pactivityid bigint NOT NULL,
    userid bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    attempt integer DEFAULT 1 NOT NULL,
    rawscore bigint DEFAULT 0,
    maxscore bigint DEFAULT 0,
    scaled numeric(10,5) DEFAULT 0 NOT NULL,
    duration bigint DEFAULT 0,
    completion smallint,
    success smallint
);


ALTER TABLE public.mdl_h5pactivity_attempts OWNER TO postgres;

--
-- Name: TABLE mdl_h5pactivity_attempts; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_h5pactivity_attempts IS 'Users attempts inside H5P activities';


--
-- Name: mdl_h5pactivity_attempts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_h5pactivity_attempts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_h5pactivity_attempts_id_seq OWNER TO postgres;

--
-- Name: mdl_h5pactivity_attempts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_h5pactivity_attempts_id_seq OWNED BY public.mdl_h5pactivity_attempts.id;


--
-- Name: mdl_h5pactivity_attempts_results; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_h5pactivity_attempts_results (
    id bigint NOT NULL,
    attemptid bigint NOT NULL,
    subcontent character varying(128),
    timecreated bigint NOT NULL,
    interactiontype character varying(128),
    description text,
    correctpattern text,
    response text NOT NULL,
    additionals text,
    rawscore bigint DEFAULT 0 NOT NULL,
    maxscore bigint DEFAULT 0 NOT NULL,
    duration bigint DEFAULT 0,
    completion smallint,
    success smallint
);


ALTER TABLE public.mdl_h5pactivity_attempts_results OWNER TO postgres;

--
-- Name: TABLE mdl_h5pactivity_attempts_results; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_h5pactivity_attempts_results IS 'H5Pactivities_attempts tracking info';


--
-- Name: mdl_h5pactivity_attempts_results_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_h5pactivity_attempts_results_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_h5pactivity_attempts_results_id_seq OWNER TO postgres;

--
-- Name: mdl_h5pactivity_attempts_results_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_h5pactivity_attempts_results_id_seq OWNED BY public.mdl_h5pactivity_attempts_results.id;


--
-- Name: mdl_h5pactivity_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_h5pactivity_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_h5pactivity_id_seq OWNER TO postgres;

--
-- Name: mdl_h5pactivity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_h5pactivity_id_seq OWNED BY public.mdl_h5pactivity.id;


--
-- Name: mdl_imscp; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_imscp (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text,
    introformat smallint DEFAULT 0 NOT NULL,
    revision bigint DEFAULT 0 NOT NULL,
    keepold bigint DEFAULT '-1'::integer NOT NULL,
    structure text,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_imscp OWNER TO postgres;

--
-- Name: TABLE mdl_imscp; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_imscp IS 'each record is one imscp resource';


--
-- Name: mdl_imscp_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_imscp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_imscp_id_seq OWNER TO postgres;

--
-- Name: mdl_imscp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_imscp_id_seq OWNED BY public.mdl_imscp.id;


--
-- Name: mdl_label; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_label (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text NOT NULL,
    introformat smallint DEFAULT 0,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_label OWNER TO postgres;

--
-- Name: TABLE mdl_label; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_label IS 'Defines labels';


--
-- Name: mdl_label_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_label_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_label_id_seq OWNER TO postgres;

--
-- Name: mdl_label_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_label_id_seq OWNED BY public.mdl_label.id;


--
-- Name: mdl_lesson; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lesson (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text,
    introformat smallint DEFAULT 0 NOT NULL,
    practice smallint DEFAULT 0 NOT NULL,
    modattempts smallint DEFAULT 0 NOT NULL,
    usepassword smallint DEFAULT 0 NOT NULL,
    password character varying(32) DEFAULT ''::character varying NOT NULL,
    dependency bigint DEFAULT 0 NOT NULL,
    conditions text NOT NULL,
    grade bigint DEFAULT 0 NOT NULL,
    custom smallint DEFAULT 0 NOT NULL,
    ongoing smallint DEFAULT 0 NOT NULL,
    usemaxgrade smallint DEFAULT 0 NOT NULL,
    maxanswers smallint DEFAULT 4 NOT NULL,
    maxattempts smallint DEFAULT 5 NOT NULL,
    review smallint DEFAULT 0 NOT NULL,
    nextpagedefault smallint DEFAULT 0 NOT NULL,
    feedback smallint DEFAULT 1 NOT NULL,
    minquestions smallint DEFAULT 0 NOT NULL,
    maxpages smallint DEFAULT 0 NOT NULL,
    timelimit bigint DEFAULT 0 NOT NULL,
    retake smallint DEFAULT 1 NOT NULL,
    activitylink bigint DEFAULT 0 NOT NULL,
    mediafile character varying(255) DEFAULT ''::character varying NOT NULL,
    mediaheight bigint DEFAULT 100 NOT NULL,
    mediawidth bigint DEFAULT 650 NOT NULL,
    mediaclose smallint DEFAULT 0 NOT NULL,
    slideshow smallint DEFAULT 0 NOT NULL,
    width bigint DEFAULT 640 NOT NULL,
    height bigint DEFAULT 480 NOT NULL,
    bgcolor character varying(7) DEFAULT '#FFFFFF'::character varying NOT NULL,
    displayleft smallint DEFAULT 0 NOT NULL,
    displayleftif smallint DEFAULT 0 NOT NULL,
    progressbar smallint DEFAULT 0 NOT NULL,
    available bigint DEFAULT 0 NOT NULL,
    deadline bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    completionendreached smallint DEFAULT 0,
    completiontimespent bigint DEFAULT 0,
    allowofflineattempts smallint DEFAULT 0
);


ALTER TABLE public.mdl_lesson OWNER TO postgres;

--
-- Name: TABLE mdl_lesson; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lesson IS 'Defines lesson';


--
-- Name: mdl_lesson_answers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lesson_answers (
    id bigint NOT NULL,
    lessonid bigint DEFAULT 0 NOT NULL,
    pageid bigint DEFAULT 0 NOT NULL,
    jumpto bigint DEFAULT 0 NOT NULL,
    grade smallint DEFAULT 0 NOT NULL,
    score bigint DEFAULT 0 NOT NULL,
    flags smallint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    answer text,
    answerformat smallint DEFAULT 0 NOT NULL,
    response text,
    responseformat smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_lesson_answers OWNER TO postgres;

--
-- Name: TABLE mdl_lesson_answers; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lesson_answers IS 'Defines lesson_answers';


--
-- Name: mdl_lesson_answers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_answers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_answers_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_answers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lesson_answers_id_seq OWNED BY public.mdl_lesson_answers.id;


--
-- Name: mdl_lesson_attempts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lesson_attempts (
    id bigint NOT NULL,
    lessonid bigint DEFAULT 0 NOT NULL,
    pageid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    answerid bigint DEFAULT 0 NOT NULL,
    retry smallint DEFAULT 0 NOT NULL,
    correct bigint DEFAULT 0 NOT NULL,
    useranswer text,
    timeseen bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_lesson_attempts OWNER TO postgres;

--
-- Name: TABLE mdl_lesson_attempts; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lesson_attempts IS 'Defines lesson_attempts';


--
-- Name: mdl_lesson_attempts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_attempts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_attempts_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_attempts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lesson_attempts_id_seq OWNED BY public.mdl_lesson_attempts.id;


--
-- Name: mdl_lesson_branch; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lesson_branch (
    id bigint NOT NULL,
    lessonid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    pageid bigint DEFAULT 0 NOT NULL,
    retry bigint DEFAULT 0 NOT NULL,
    flag smallint DEFAULT 0 NOT NULL,
    timeseen bigint DEFAULT 0 NOT NULL,
    nextpageid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_lesson_branch OWNER TO postgres;

--
-- Name: TABLE mdl_lesson_branch; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lesson_branch IS 'branches for each lesson/user';


--
-- Name: mdl_lesson_branch_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_branch_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_branch_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_branch_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lesson_branch_id_seq OWNED BY public.mdl_lesson_branch.id;


--
-- Name: mdl_lesson_grades; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lesson_grades (
    id bigint NOT NULL,
    lessonid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    grade double precision DEFAULT 0 NOT NULL,
    late smallint DEFAULT 0 NOT NULL,
    completed bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_lesson_grades OWNER TO postgres;

--
-- Name: TABLE mdl_lesson_grades; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lesson_grades IS 'Defines lesson_grades';


--
-- Name: mdl_lesson_grades_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_grades_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_grades_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_grades_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lesson_grades_id_seq OWNED BY public.mdl_lesson_grades.id;


--
-- Name: mdl_lesson_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lesson_id_seq OWNED BY public.mdl_lesson.id;


--
-- Name: mdl_lesson_overrides; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lesson_overrides (
    id bigint NOT NULL,
    lessonid bigint DEFAULT 0 NOT NULL,
    groupid bigint,
    userid bigint,
    available bigint,
    deadline bigint,
    timelimit bigint,
    review smallint,
    maxattempts smallint,
    retake smallint,
    password character varying(32)
);


ALTER TABLE public.mdl_lesson_overrides OWNER TO postgres;

--
-- Name: TABLE mdl_lesson_overrides; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lesson_overrides IS 'The overrides to lesson settings.';


--
-- Name: mdl_lesson_overrides_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_overrides_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_overrides_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_overrides_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lesson_overrides_id_seq OWNED BY public.mdl_lesson_overrides.id;


--
-- Name: mdl_lesson_pages; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lesson_pages (
    id bigint NOT NULL,
    lessonid bigint DEFAULT 0 NOT NULL,
    prevpageid bigint DEFAULT 0 NOT NULL,
    nextpageid bigint DEFAULT 0 NOT NULL,
    qtype smallint DEFAULT 0 NOT NULL,
    qoption smallint DEFAULT 0 NOT NULL,
    layout smallint DEFAULT 1 NOT NULL,
    display smallint DEFAULT 1 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    title character varying(255) DEFAULT ''::character varying NOT NULL,
    contents text NOT NULL,
    contentsformat smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_lesson_pages OWNER TO postgres;

--
-- Name: TABLE mdl_lesson_pages; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lesson_pages IS 'Defines lesson_pages';


--
-- Name: mdl_lesson_pages_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_pages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_pages_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_pages_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lesson_pages_id_seq OWNED BY public.mdl_lesson_pages.id;


--
-- Name: mdl_lesson_timer; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lesson_timer (
    id bigint NOT NULL,
    lessonid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    starttime bigint DEFAULT 0 NOT NULL,
    lessontime bigint DEFAULT 0 NOT NULL,
    completed smallint DEFAULT 0,
    timemodifiedoffline bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_lesson_timer OWNER TO postgres;

--
-- Name: TABLE mdl_lesson_timer; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lesson_timer IS 'lesson timer for each lesson';


--
-- Name: mdl_lesson_timer_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_timer_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_timer_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_timer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lesson_timer_id_seq OWNED BY public.mdl_lesson_timer.id;


--
-- Name: mdl_license; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_license (
    id bigint NOT NULL,
    shortname character varying(255),
    fullname text,
    source character varying(255),
    enabled smallint DEFAULT 1 NOT NULL,
    version bigint DEFAULT 0 NOT NULL,
    custom smallint DEFAULT 0 NOT NULL,
    sortorder integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_license OWNER TO postgres;

--
-- Name: TABLE mdl_license; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_license IS 'store licenses used by moodle';


--
-- Name: mdl_license_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_license_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_license_id_seq OWNER TO postgres;

--
-- Name: mdl_license_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_license_id_seq OWNED BY public.mdl_license.id;


--
-- Name: mdl_lock_db; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lock_db (
    id bigint NOT NULL,
    resourcekey character varying(255) DEFAULT ''::character varying NOT NULL,
    expires bigint,
    owner character varying(36)
);


ALTER TABLE public.mdl_lock_db OWNER TO postgres;

--
-- Name: TABLE mdl_lock_db; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lock_db IS 'Stores active and inactive lock types for db locking method.';


--
-- Name: mdl_lock_db_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lock_db_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lock_db_id_seq OWNER TO postgres;

--
-- Name: mdl_lock_db_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lock_db_id_seq OWNED BY public.mdl_lock_db.id;


--
-- Name: mdl_log; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_log (
    id bigint NOT NULL,
    "time" bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    ip character varying(45) DEFAULT ''::character varying NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    module character varying(20) DEFAULT ''::character varying NOT NULL,
    cmid bigint DEFAULT 0 NOT NULL,
    action character varying(40) DEFAULT ''::character varying NOT NULL,
    url character varying(100) DEFAULT ''::character varying NOT NULL,
    info character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_log OWNER TO postgres;

--
-- Name: TABLE mdl_log; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_log IS 'Every action is logged as far as possible';


--
-- Name: mdl_log_display; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_log_display (
    id bigint NOT NULL,
    module character varying(20) DEFAULT ''::character varying NOT NULL,
    action character varying(40) DEFAULT ''::character varying NOT NULL,
    mtable character varying(30) DEFAULT ''::character varying NOT NULL,
    field character varying(200) DEFAULT ''::character varying NOT NULL,
    component character varying(100) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_log_display OWNER TO postgres;

--
-- Name: TABLE mdl_log_display; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_log_display IS 'For a particular module/action, specifies a moodle table/field';


--
-- Name: mdl_log_display_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_log_display_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_log_display_id_seq OWNER TO postgres;

--
-- Name: mdl_log_display_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_log_display_id_seq OWNED BY public.mdl_log_display.id;


--
-- Name: mdl_log_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_log_id_seq OWNER TO postgres;

--
-- Name: mdl_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_log_id_seq OWNED BY public.mdl_log.id;


--
-- Name: mdl_log_queries; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_log_queries (
    id bigint NOT NULL,
    qtype integer NOT NULL,
    sqltext text NOT NULL,
    sqlparams text,
    error integer DEFAULT 0 NOT NULL,
    info text,
    backtrace text,
    exectime numeric(10,5) NOT NULL,
    timelogged bigint NOT NULL
);


ALTER TABLE public.mdl_log_queries OWNER TO postgres;

--
-- Name: TABLE mdl_log_queries; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_log_queries IS 'Logged database queries.';


--
-- Name: mdl_log_queries_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_log_queries_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_log_queries_id_seq OWNER TO postgres;

--
-- Name: mdl_log_queries_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_log_queries_id_seq OWNED BY public.mdl_log_queries.id;


--
-- Name: mdl_logstore_standard_log; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_logstore_standard_log (
    id bigint NOT NULL,
    eventname character varying(255) DEFAULT ''::character varying NOT NULL,
    component character varying(100) DEFAULT ''::character varying NOT NULL,
    action character varying(100) DEFAULT ''::character varying NOT NULL,
    target character varying(100) DEFAULT ''::character varying NOT NULL,
    objecttable character varying(50),
    objectid bigint,
    crud character varying(1) DEFAULT ''::character varying NOT NULL,
    edulevel smallint NOT NULL,
    contextid bigint NOT NULL,
    contextlevel bigint NOT NULL,
    contextinstanceid bigint NOT NULL,
    userid bigint NOT NULL,
    courseid bigint,
    relateduserid bigint,
    anonymous smallint DEFAULT 0 NOT NULL,
    other text,
    timecreated bigint NOT NULL,
    origin character varying(10),
    ip character varying(45),
    realuserid bigint
);


ALTER TABLE public.mdl_logstore_standard_log OWNER TO postgres;

--
-- Name: TABLE mdl_logstore_standard_log; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_logstore_standard_log IS 'Standard log table';


--
-- Name: mdl_logstore_standard_log_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_logstore_standard_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_logstore_standard_log_id_seq OWNER TO postgres;

--
-- Name: mdl_logstore_standard_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_logstore_standard_log_id_seq OWNED BY public.mdl_logstore_standard_log.id;


--
-- Name: mdl_lti; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lti (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text,
    introformat smallint DEFAULT 0,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    typeid bigint,
    toolurl text NOT NULL,
    securetoolurl text,
    instructorchoicesendname smallint,
    instructorchoicesendemailaddr smallint,
    instructorchoiceallowroster smallint,
    instructorchoiceallowsetting smallint,
    instructorcustomparameters character varying(255),
    instructorchoiceacceptgrades smallint,
    grade bigint DEFAULT 100 NOT NULL,
    launchcontainer smallint DEFAULT 1 NOT NULL,
    resourcekey character varying(255),
    password character varying(255),
    debuglaunch smallint DEFAULT 0 NOT NULL,
    showtitlelaunch smallint DEFAULT 0 NOT NULL,
    showdescriptionlaunch smallint DEFAULT 0 NOT NULL,
    servicesalt character varying(40),
    icon text,
    secureicon text
);


ALTER TABLE public.mdl_lti OWNER TO postgres;

--
-- Name: TABLE mdl_lti; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lti IS 'This table contains Basic LTI activities instances';


--
-- Name: mdl_lti_access_tokens; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lti_access_tokens (
    id bigint NOT NULL,
    typeid bigint NOT NULL,
    scope text NOT NULL,
    token character varying(128) DEFAULT ''::character varying NOT NULL,
    validuntil bigint NOT NULL,
    timecreated bigint NOT NULL,
    lastaccess bigint
);


ALTER TABLE public.mdl_lti_access_tokens OWNER TO postgres;

--
-- Name: TABLE mdl_lti_access_tokens; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lti_access_tokens IS 'Security tokens for accessing of LTI services';


--
-- Name: mdl_lti_access_tokens_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lti_access_tokens_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lti_access_tokens_id_seq OWNER TO postgres;

--
-- Name: mdl_lti_access_tokens_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lti_access_tokens_id_seq OWNED BY public.mdl_lti_access_tokens.id;


--
-- Name: mdl_lti_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lti_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lti_id_seq OWNER TO postgres;

--
-- Name: mdl_lti_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lti_id_seq OWNED BY public.mdl_lti.id;


--
-- Name: mdl_lti_submission; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lti_submission (
    id bigint NOT NULL,
    ltiid bigint NOT NULL,
    userid bigint NOT NULL,
    datesubmitted bigint NOT NULL,
    dateupdated bigint NOT NULL,
    gradepercent numeric(10,5) NOT NULL,
    originalgrade numeric(10,5) NOT NULL,
    launchid bigint NOT NULL,
    state smallint NOT NULL
);


ALTER TABLE public.mdl_lti_submission OWNER TO postgres;

--
-- Name: TABLE mdl_lti_submission; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lti_submission IS 'Keeps track of individual submissions for LTI activities.';


--
-- Name: mdl_lti_submission_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lti_submission_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lti_submission_id_seq OWNER TO postgres;

--
-- Name: mdl_lti_submission_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lti_submission_id_seq OWNED BY public.mdl_lti_submission.id;


--
-- Name: mdl_lti_tool_proxies; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lti_tool_proxies (
    id bigint NOT NULL,
    name character varying(255) DEFAULT 'Tool Provider'::character varying NOT NULL,
    regurl text,
    state smallint DEFAULT 1 NOT NULL,
    guid character varying(255),
    secret character varying(255),
    vendorcode character varying(255),
    capabilityoffered text NOT NULL,
    serviceoffered text NOT NULL,
    toolproxy text,
    createdby bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_lti_tool_proxies OWNER TO postgres;

--
-- Name: TABLE mdl_lti_tool_proxies; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lti_tool_proxies IS 'LTI tool proxy registrations';


--
-- Name: mdl_lti_tool_proxies_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lti_tool_proxies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lti_tool_proxies_id_seq OWNER TO postgres;

--
-- Name: mdl_lti_tool_proxies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lti_tool_proxies_id_seq OWNED BY public.mdl_lti_tool_proxies.id;


--
-- Name: mdl_lti_tool_settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lti_tool_settings (
    id bigint NOT NULL,
    toolproxyid bigint NOT NULL,
    typeid bigint,
    course bigint,
    coursemoduleid bigint,
    settings text NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_lti_tool_settings OWNER TO postgres;

--
-- Name: TABLE mdl_lti_tool_settings; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lti_tool_settings IS 'LTI tool setting values';


--
-- Name: mdl_lti_tool_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lti_tool_settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lti_tool_settings_id_seq OWNER TO postgres;

--
-- Name: mdl_lti_tool_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lti_tool_settings_id_seq OWNED BY public.mdl_lti_tool_settings.id;


--
-- Name: mdl_lti_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lti_types (
    id bigint NOT NULL,
    name character varying(255) DEFAULT 'basiclti Activity'::character varying NOT NULL,
    baseurl text NOT NULL,
    tooldomain character varying(255) DEFAULT ''::character varying NOT NULL,
    state smallint DEFAULT 2 NOT NULL,
    course bigint NOT NULL,
    coursevisible smallint DEFAULT 0 NOT NULL,
    ltiversion character varying(10) DEFAULT ''::character varying NOT NULL,
    clientid character varying(255),
    toolproxyid bigint,
    enabledcapability text,
    parameter text,
    icon text,
    secureicon text,
    createdby bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    description text
);


ALTER TABLE public.mdl_lti_types OWNER TO postgres;

--
-- Name: TABLE mdl_lti_types; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lti_types IS 'Basic LTI pre-configured activities';


--
-- Name: mdl_lti_types_config; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_lti_types_config (
    id bigint NOT NULL,
    typeid bigint NOT NULL,
    name character varying(100) DEFAULT ''::character varying NOT NULL,
    value text NOT NULL
);


ALTER TABLE public.mdl_lti_types_config OWNER TO postgres;

--
-- Name: TABLE mdl_lti_types_config; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_lti_types_config IS 'Basic LTI types configuration';


--
-- Name: mdl_lti_types_config_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lti_types_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lti_types_config_id_seq OWNER TO postgres;

--
-- Name: mdl_lti_types_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lti_types_config_id_seq OWNED BY public.mdl_lti_types_config.id;


--
-- Name: mdl_lti_types_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lti_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lti_types_id_seq OWNER TO postgres;

--
-- Name: mdl_lti_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_lti_types_id_seq OWNED BY public.mdl_lti_types.id;


--
-- Name: mdl_ltiservice_gradebookservices; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_ltiservice_gradebookservices (
    id bigint NOT NULL,
    gradeitemid bigint NOT NULL,
    courseid bigint NOT NULL,
    toolproxyid bigint,
    typeid bigint,
    baseurl text,
    ltilinkid bigint,
    resourceid character varying(512),
    tag character varying(255)
);


ALTER TABLE public.mdl_ltiservice_gradebookservices OWNER TO postgres;

--
-- Name: TABLE mdl_ltiservice_gradebookservices; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_ltiservice_gradebookservices IS 'This file records the grade items created by the LTI Gradebook Services service';


--
-- Name: mdl_ltiservice_gradebookservices_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_ltiservice_gradebookservices_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_ltiservice_gradebookservices_id_seq OWNER TO postgres;

--
-- Name: mdl_ltiservice_gradebookservices_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_ltiservice_gradebookservices_id_seq OWNED BY public.mdl_ltiservice_gradebookservices.id;


--
-- Name: mdl_message; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message (
    id bigint NOT NULL,
    useridfrom bigint DEFAULT 0 NOT NULL,
    useridto bigint DEFAULT 0 NOT NULL,
    subject text,
    fullmessage text,
    fullmessageformat smallint DEFAULT 0,
    fullmessagehtml text,
    smallmessage text,
    notification smallint DEFAULT 0,
    contexturl text,
    contexturlname text,
    timecreated bigint DEFAULT 0 NOT NULL,
    timeuserfromdeleted bigint DEFAULT 0 NOT NULL,
    timeusertodeleted bigint DEFAULT 0 NOT NULL,
    component character varying(100),
    eventtype character varying(100),
    customdata text
);


ALTER TABLE public.mdl_message OWNER TO postgres;

--
-- Name: TABLE mdl_message; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message IS 'Stores all unread messages';


--
-- Name: mdl_message_airnotifier_devices; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message_airnotifier_devices (
    id bigint NOT NULL,
    userdeviceid bigint NOT NULL,
    enable smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_message_airnotifier_devices OWNER TO postgres;

--
-- Name: TABLE mdl_message_airnotifier_devices; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message_airnotifier_devices IS 'Store information about the devices registered in Airnotifier for PUSH notifications';


--
-- Name: mdl_message_airnotifier_devices_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_airnotifier_devices_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_airnotifier_devices_id_seq OWNER TO postgres;

--
-- Name: mdl_message_airnotifier_devices_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_airnotifier_devices_id_seq OWNED BY public.mdl_message_airnotifier_devices.id;


--
-- Name: mdl_message_contact_requests; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message_contact_requests (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    requesteduserid bigint NOT NULL,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_message_contact_requests OWNER TO postgres;

--
-- Name: TABLE mdl_message_contact_requests; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message_contact_requests IS 'Maintains list of contact requests between users';


--
-- Name: mdl_message_contact_requests_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_contact_requests_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_contact_requests_id_seq OWNER TO postgres;

--
-- Name: mdl_message_contact_requests_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_contact_requests_id_seq OWNED BY public.mdl_message_contact_requests.id;


--
-- Name: mdl_message_contacts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message_contacts (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    contactid bigint NOT NULL,
    timecreated bigint
);


ALTER TABLE public.mdl_message_contacts OWNER TO postgres;

--
-- Name: TABLE mdl_message_contacts; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message_contacts IS 'Maintains lists of contacts between users';


--
-- Name: mdl_message_contacts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_contacts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_contacts_id_seq OWNER TO postgres;

--
-- Name: mdl_message_contacts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_contacts_id_seq OWNED BY public.mdl_message_contacts.id;


--
-- Name: mdl_message_conversation_actions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message_conversation_actions (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    conversationid bigint NOT NULL,
    action bigint NOT NULL,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_message_conversation_actions OWNER TO postgres;

--
-- Name: TABLE mdl_message_conversation_actions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message_conversation_actions IS 'Stores all per-user actions on individual conversations';


--
-- Name: mdl_message_conversation_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_conversation_actions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_conversation_actions_id_seq OWNER TO postgres;

--
-- Name: mdl_message_conversation_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_conversation_actions_id_seq OWNED BY public.mdl_message_conversation_actions.id;


--
-- Name: mdl_message_conversation_members; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message_conversation_members (
    id bigint NOT NULL,
    conversationid bigint NOT NULL,
    userid bigint NOT NULL,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_message_conversation_members OWNER TO postgres;

--
-- Name: TABLE mdl_message_conversation_members; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message_conversation_members IS 'Stores all members in a conversations';


--
-- Name: mdl_message_conversation_members_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_conversation_members_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_conversation_members_id_seq OWNER TO postgres;

--
-- Name: mdl_message_conversation_members_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_conversation_members_id_seq OWNED BY public.mdl_message_conversation_members.id;


--
-- Name: mdl_message_conversations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message_conversations (
    id bigint NOT NULL,
    type bigint DEFAULT 1 NOT NULL,
    name character varying(255),
    convhash character varying(40),
    component character varying(100),
    itemtype character varying(100),
    itemid bigint,
    contextid bigint,
    enabled smallint DEFAULT 0 NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint
);


ALTER TABLE public.mdl_message_conversations OWNER TO postgres;

--
-- Name: TABLE mdl_message_conversations; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message_conversations IS 'Stores all message conversations';


--
-- Name: mdl_message_conversations_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_conversations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_conversations_id_seq OWNER TO postgres;

--
-- Name: mdl_message_conversations_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_conversations_id_seq OWNED BY public.mdl_message_conversations.id;


--
-- Name: mdl_message_email_messages; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message_email_messages (
    id bigint NOT NULL,
    useridto bigint NOT NULL,
    conversationid bigint NOT NULL,
    messageid bigint NOT NULL
);


ALTER TABLE public.mdl_message_email_messages OWNER TO postgres;

--
-- Name: TABLE mdl_message_email_messages; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message_email_messages IS 'Keeps track of what emails to send in an email digest';


--
-- Name: mdl_message_email_messages_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_email_messages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_email_messages_id_seq OWNER TO postgres;

--
-- Name: mdl_message_email_messages_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_email_messages_id_seq OWNED BY public.mdl_message_email_messages.id;


--
-- Name: mdl_message_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_id_seq OWNER TO postgres;

--
-- Name: mdl_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_id_seq OWNED BY public.mdl_message.id;


--
-- Name: mdl_message_popup; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message_popup (
    id bigint NOT NULL,
    messageid bigint NOT NULL,
    isread smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_message_popup OWNER TO postgres;

--
-- Name: TABLE mdl_message_popup; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message_popup IS 'Keep state of notifications for the popup message processor';


--
-- Name: mdl_message_popup_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_popup_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_popup_id_seq OWNER TO postgres;

--
-- Name: mdl_message_popup_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_popup_id_seq OWNED BY public.mdl_message_popup.id;


--
-- Name: mdl_message_popup_notifications; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message_popup_notifications (
    id bigint NOT NULL,
    notificationid bigint NOT NULL
);


ALTER TABLE public.mdl_message_popup_notifications OWNER TO postgres;

--
-- Name: TABLE mdl_message_popup_notifications; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message_popup_notifications IS 'List of notifications to display in the message output popup';


--
-- Name: mdl_message_popup_notifications_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_popup_notifications_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_popup_notifications_id_seq OWNER TO postgres;

--
-- Name: mdl_message_popup_notifications_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_popup_notifications_id_seq OWNED BY public.mdl_message_popup_notifications.id;


--
-- Name: mdl_message_processors; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message_processors (
    id bigint NOT NULL,
    name character varying(166) DEFAULT ''::character varying NOT NULL,
    enabled smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_message_processors OWNER TO postgres;

--
-- Name: TABLE mdl_message_processors; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message_processors IS 'List of message output plugins';


--
-- Name: mdl_message_processors_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_processors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_processors_id_seq OWNER TO postgres;

--
-- Name: mdl_message_processors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_processors_id_seq OWNED BY public.mdl_message_processors.id;


--
-- Name: mdl_message_providers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message_providers (
    id bigint NOT NULL,
    name character varying(100) DEFAULT ''::character varying NOT NULL,
    component character varying(200) DEFAULT ''::character varying NOT NULL,
    capability character varying(255)
);


ALTER TABLE public.mdl_message_providers OWNER TO postgres;

--
-- Name: TABLE mdl_message_providers; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message_providers IS 'This table stores the message providers (modules and core systems)';


--
-- Name: mdl_message_providers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_providers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_providers_id_seq OWNER TO postgres;

--
-- Name: mdl_message_providers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_providers_id_seq OWNED BY public.mdl_message_providers.id;


--
-- Name: mdl_message_read; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message_read (
    id bigint NOT NULL,
    useridfrom bigint DEFAULT 0 NOT NULL,
    useridto bigint DEFAULT 0 NOT NULL,
    subject text,
    fullmessage text,
    fullmessageformat smallint DEFAULT 0,
    fullmessagehtml text,
    smallmessage text,
    notification smallint DEFAULT 0,
    contexturl text,
    contexturlname text,
    timecreated bigint DEFAULT 0 NOT NULL,
    timeread bigint DEFAULT 0 NOT NULL,
    timeuserfromdeleted bigint DEFAULT 0 NOT NULL,
    timeusertodeleted bigint DEFAULT 0 NOT NULL,
    component character varying(100),
    eventtype character varying(100)
);


ALTER TABLE public.mdl_message_read OWNER TO postgres;

--
-- Name: TABLE mdl_message_read; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message_read IS 'Stores all messages that have been read';


--
-- Name: mdl_message_read_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_read_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_read_id_seq OWNER TO postgres;

--
-- Name: mdl_message_read_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_read_id_seq OWNED BY public.mdl_message_read.id;


--
-- Name: mdl_message_user_actions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message_user_actions (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    messageid bigint NOT NULL,
    action bigint NOT NULL,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_message_user_actions OWNER TO postgres;

--
-- Name: TABLE mdl_message_user_actions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message_user_actions IS 'Stores all per-user actions on individual messages';


--
-- Name: mdl_message_user_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_user_actions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_user_actions_id_seq OWNER TO postgres;

--
-- Name: mdl_message_user_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_user_actions_id_seq OWNED BY public.mdl_message_user_actions.id;


--
-- Name: mdl_message_users_blocked; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_message_users_blocked (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    blockeduserid bigint NOT NULL,
    timecreated bigint
);


ALTER TABLE public.mdl_message_users_blocked OWNER TO postgres;

--
-- Name: TABLE mdl_message_users_blocked; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_message_users_blocked IS 'Maintains lists of blocked users';


--
-- Name: mdl_message_users_blocked_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_users_blocked_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_users_blocked_id_seq OWNER TO postgres;

--
-- Name: mdl_message_users_blocked_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_message_users_blocked_id_seq OWNED BY public.mdl_message_users_blocked.id;


--
-- Name: mdl_messageinbound_datakeys; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_messageinbound_datakeys (
    id bigint NOT NULL,
    handler bigint NOT NULL,
    datavalue bigint NOT NULL,
    datakey character varying(64),
    timecreated bigint NOT NULL,
    expires bigint
);


ALTER TABLE public.mdl_messageinbound_datakeys OWNER TO postgres;

--
-- Name: TABLE mdl_messageinbound_datakeys; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_messageinbound_datakeys IS 'Inbound Message data item secret keys.';


--
-- Name: mdl_messageinbound_datakeys_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_messageinbound_datakeys_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_messageinbound_datakeys_id_seq OWNER TO postgres;

--
-- Name: mdl_messageinbound_datakeys_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_messageinbound_datakeys_id_seq OWNED BY public.mdl_messageinbound_datakeys.id;


--
-- Name: mdl_messageinbound_handlers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_messageinbound_handlers (
    id bigint NOT NULL,
    component character varying(100) DEFAULT ''::character varying NOT NULL,
    classname character varying(255) DEFAULT ''::character varying NOT NULL,
    defaultexpiration bigint DEFAULT 86400 NOT NULL,
    validateaddress smallint DEFAULT 1 NOT NULL,
    enabled smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_messageinbound_handlers OWNER TO postgres;

--
-- Name: TABLE mdl_messageinbound_handlers; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_messageinbound_handlers IS 'Inbound Message Handler definitions.';


--
-- Name: mdl_messageinbound_handlers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_messageinbound_handlers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_messageinbound_handlers_id_seq OWNER TO postgres;

--
-- Name: mdl_messageinbound_handlers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_messageinbound_handlers_id_seq OWNED BY public.mdl_messageinbound_handlers.id;


--
-- Name: mdl_messageinbound_messagelist; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_messageinbound_messagelist (
    id bigint NOT NULL,
    messageid text NOT NULL,
    userid bigint NOT NULL,
    address text NOT NULL,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_messageinbound_messagelist OWNER TO postgres;

--
-- Name: TABLE mdl_messageinbound_messagelist; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_messageinbound_messagelist IS 'A list of message IDs for existing replies';


--
-- Name: mdl_messageinbound_messagelist_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_messageinbound_messagelist_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_messageinbound_messagelist_id_seq OWNER TO postgres;

--
-- Name: mdl_messageinbound_messagelist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_messageinbound_messagelist_id_seq OWNED BY public.mdl_messageinbound_messagelist.id;


--
-- Name: mdl_messages; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_messages (
    id bigint NOT NULL,
    useridfrom bigint NOT NULL,
    conversationid bigint NOT NULL,
    subject text,
    fullmessage text,
    fullmessageformat smallint DEFAULT 0 NOT NULL,
    fullmessagehtml text,
    smallmessage text,
    timecreated bigint NOT NULL,
    fullmessagetrust smallint DEFAULT 0 NOT NULL,
    customdata text
);


ALTER TABLE public.mdl_messages OWNER TO postgres;

--
-- Name: TABLE mdl_messages; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_messages IS 'Stores all messages';


--
-- Name: mdl_messages_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_messages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_messages_id_seq OWNER TO postgres;

--
-- Name: mdl_messages_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_messages_id_seq OWNED BY public.mdl_messages.id;


--
-- Name: mdl_mnet_application; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_mnet_application (
    id bigint NOT NULL,
    name character varying(50) DEFAULT ''::character varying NOT NULL,
    display_name character varying(50) DEFAULT ''::character varying NOT NULL,
    xmlrpc_server_url character varying(255) DEFAULT ''::character varying NOT NULL,
    sso_land_url character varying(255) DEFAULT ''::character varying NOT NULL,
    sso_jump_url character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_mnet_application OWNER TO postgres;

--
-- Name: TABLE mdl_mnet_application; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_mnet_application IS 'Information about applications on remote hosts';


--
-- Name: mdl_mnet_application_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_application_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_application_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_application_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_mnet_application_id_seq OWNED BY public.mdl_mnet_application.id;


--
-- Name: mdl_mnet_host; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_mnet_host (
    id bigint NOT NULL,
    deleted smallint DEFAULT 0 NOT NULL,
    wwwroot character varying(255) DEFAULT ''::character varying NOT NULL,
    ip_address character varying(45) DEFAULT ''::character varying NOT NULL,
    name character varying(80) DEFAULT ''::character varying NOT NULL,
    public_key text NOT NULL,
    public_key_expires bigint DEFAULT 0 NOT NULL,
    transport smallint DEFAULT 0 NOT NULL,
    portno integer DEFAULT 0 NOT NULL,
    last_connect_time bigint DEFAULT 0 NOT NULL,
    last_log_id bigint DEFAULT 0 NOT NULL,
    force_theme smallint DEFAULT 0 NOT NULL,
    theme character varying(100),
    applicationid bigint DEFAULT 1 NOT NULL,
    sslverification smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_mnet_host OWNER TO postgres;

--
-- Name: TABLE mdl_mnet_host; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_mnet_host IS 'Information about the local and remote hosts for RPC';


--
-- Name: mdl_mnet_host2service; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_mnet_host2service (
    id bigint NOT NULL,
    hostid bigint DEFAULT 0 NOT NULL,
    serviceid bigint DEFAULT 0 NOT NULL,
    publish smallint DEFAULT 0 NOT NULL,
    subscribe smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_mnet_host2service OWNER TO postgres;

--
-- Name: TABLE mdl_mnet_host2service; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_mnet_host2service IS 'Information about the services for a given host';


--
-- Name: mdl_mnet_host2service_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_host2service_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_host2service_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_host2service_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_mnet_host2service_id_seq OWNED BY public.mdl_mnet_host2service.id;


--
-- Name: mdl_mnet_host_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_host_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_host_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_host_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_mnet_host_id_seq OWNED BY public.mdl_mnet_host.id;


--
-- Name: mdl_mnet_log; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_mnet_log (
    id bigint NOT NULL,
    hostid bigint DEFAULT 0 NOT NULL,
    remoteid bigint DEFAULT 0 NOT NULL,
    "time" bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    ip character varying(45) DEFAULT ''::character varying NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    coursename character varying(40) DEFAULT ''::character varying NOT NULL,
    module character varying(20) DEFAULT ''::character varying NOT NULL,
    cmid bigint DEFAULT 0 NOT NULL,
    action character varying(40) DEFAULT ''::character varying NOT NULL,
    url character varying(100) DEFAULT ''::character varying NOT NULL,
    info character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_mnet_log OWNER TO postgres;

--
-- Name: TABLE mdl_mnet_log; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_mnet_log IS 'Store session data from users migrating to other sites';


--
-- Name: mdl_mnet_log_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_log_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_mnet_log_id_seq OWNED BY public.mdl_mnet_log.id;


--
-- Name: mdl_mnet_remote_rpc; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_mnet_remote_rpc (
    id bigint NOT NULL,
    functionname character varying(40) DEFAULT ''::character varying NOT NULL,
    xmlrpcpath character varying(80) DEFAULT ''::character varying NOT NULL,
    plugintype character varying(20) DEFAULT ''::character varying NOT NULL,
    pluginname character varying(20) DEFAULT ''::character varying NOT NULL,
    enabled smallint NOT NULL
);


ALTER TABLE public.mdl_mnet_remote_rpc OWNER TO postgres;

--
-- Name: TABLE mdl_mnet_remote_rpc; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_mnet_remote_rpc IS 'This table describes functions that might be called remotely (we have less information about them than local functions)';


--
-- Name: mdl_mnet_remote_rpc_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_remote_rpc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_remote_rpc_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_remote_rpc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_mnet_remote_rpc_id_seq OWNED BY public.mdl_mnet_remote_rpc.id;


--
-- Name: mdl_mnet_remote_service2rpc; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_mnet_remote_service2rpc (
    id bigint NOT NULL,
    serviceid bigint DEFAULT 0 NOT NULL,
    rpcid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_mnet_remote_service2rpc OWNER TO postgres;

--
-- Name: TABLE mdl_mnet_remote_service2rpc; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_mnet_remote_service2rpc IS 'Group functions or methods under a service';


--
-- Name: mdl_mnet_remote_service2rpc_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_remote_service2rpc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_remote_service2rpc_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_remote_service2rpc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_mnet_remote_service2rpc_id_seq OWNED BY public.mdl_mnet_remote_service2rpc.id;


--
-- Name: mdl_mnet_rpc; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_mnet_rpc (
    id bigint NOT NULL,
    functionname character varying(40) DEFAULT ''::character varying NOT NULL,
    xmlrpcpath character varying(80) DEFAULT ''::character varying NOT NULL,
    plugintype character varying(20) DEFAULT ''::character varying NOT NULL,
    pluginname character varying(20) DEFAULT ''::character varying NOT NULL,
    enabled smallint DEFAULT 0 NOT NULL,
    help text NOT NULL,
    profile text NOT NULL,
    filename character varying(100) DEFAULT ''::character varying NOT NULL,
    classname character varying(150),
    static smallint
);


ALTER TABLE public.mdl_mnet_rpc OWNER TO postgres;

--
-- Name: TABLE mdl_mnet_rpc; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_mnet_rpc IS 'Functions or methods that we may publish or subscribe to';


--
-- Name: mdl_mnet_rpc_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_rpc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_rpc_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_rpc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_mnet_rpc_id_seq OWNED BY public.mdl_mnet_rpc.id;


--
-- Name: mdl_mnet_service; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_mnet_service (
    id bigint NOT NULL,
    name character varying(40) DEFAULT ''::character varying NOT NULL,
    description character varying(40) DEFAULT ''::character varying NOT NULL,
    apiversion character varying(10) DEFAULT ''::character varying NOT NULL,
    offer smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_mnet_service OWNER TO postgres;

--
-- Name: TABLE mdl_mnet_service; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_mnet_service IS 'A service is a group of functions';


--
-- Name: mdl_mnet_service2rpc; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_mnet_service2rpc (
    id bigint NOT NULL,
    serviceid bigint DEFAULT 0 NOT NULL,
    rpcid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_mnet_service2rpc OWNER TO postgres;

--
-- Name: TABLE mdl_mnet_service2rpc; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_mnet_service2rpc IS 'Group functions or methods under a service';


--
-- Name: mdl_mnet_service2rpc_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_service2rpc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_service2rpc_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_service2rpc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_mnet_service2rpc_id_seq OWNED BY public.mdl_mnet_service2rpc.id;


--
-- Name: mdl_mnet_service_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_service_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_service_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_service_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_mnet_service_id_seq OWNED BY public.mdl_mnet_service.id;


--
-- Name: mdl_mnet_session; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_mnet_session (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    username character varying(100) DEFAULT ''::character varying NOT NULL,
    token character varying(40) DEFAULT ''::character varying NOT NULL,
    mnethostid bigint DEFAULT 0 NOT NULL,
    useragent character varying(40) DEFAULT ''::character varying NOT NULL,
    confirm_timeout bigint DEFAULT 0 NOT NULL,
    session_id character varying(40) DEFAULT ''::character varying NOT NULL,
    expires bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_mnet_session OWNER TO postgres;

--
-- Name: TABLE mdl_mnet_session; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_mnet_session IS 'Store session data from users migrating to other sites';


--
-- Name: mdl_mnet_session_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_session_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_session_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_session_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_mnet_session_id_seq OWNED BY public.mdl_mnet_session.id;


--
-- Name: mdl_mnet_sso_access_control; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_mnet_sso_access_control (
    id bigint NOT NULL,
    username character varying(100) DEFAULT ''::character varying NOT NULL,
    mnet_host_id bigint DEFAULT 0 NOT NULL,
    accessctrl character varying(20) DEFAULT 'allow'::character varying NOT NULL
);


ALTER TABLE public.mdl_mnet_sso_access_control OWNER TO postgres;

--
-- Name: TABLE mdl_mnet_sso_access_control; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_mnet_sso_access_control IS 'Users by host permitted (or not) to login from a remote provider';


--
-- Name: mdl_mnet_sso_access_control_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_sso_access_control_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_sso_access_control_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_sso_access_control_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_mnet_sso_access_control_id_seq OWNED BY public.mdl_mnet_sso_access_control.id;


--
-- Name: mdl_mnetservice_enrol_courses; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_mnetservice_enrol_courses (
    id bigint NOT NULL,
    hostid bigint NOT NULL,
    remoteid bigint NOT NULL,
    categoryid bigint NOT NULL,
    categoryname character varying(255) DEFAULT ''::character varying NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL,
    fullname character varying(254) DEFAULT ''::character varying NOT NULL,
    shortname character varying(100) DEFAULT ''::character varying NOT NULL,
    idnumber character varying(100) DEFAULT ''::character varying NOT NULL,
    summary text NOT NULL,
    summaryformat smallint DEFAULT 0,
    startdate bigint NOT NULL,
    roleid bigint NOT NULL,
    rolename character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_mnetservice_enrol_courses OWNER TO postgres;

--
-- Name: TABLE mdl_mnetservice_enrol_courses; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_mnetservice_enrol_courses IS 'Caches the information fetched via XML-RPC about courses on remote hosts that are offered for our users';


--
-- Name: mdl_mnetservice_enrol_courses_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnetservice_enrol_courses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnetservice_enrol_courses_id_seq OWNER TO postgres;

--
-- Name: mdl_mnetservice_enrol_courses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_mnetservice_enrol_courses_id_seq OWNED BY public.mdl_mnetservice_enrol_courses.id;


--
-- Name: mdl_mnetservice_enrol_enrolments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_mnetservice_enrol_enrolments (
    id bigint NOT NULL,
    hostid bigint NOT NULL,
    userid bigint NOT NULL,
    remotecourseid bigint NOT NULL,
    rolename character varying(255) DEFAULT ''::character varying NOT NULL,
    enroltime bigint DEFAULT 0 NOT NULL,
    enroltype character varying(20) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_mnetservice_enrol_enrolments OWNER TO postgres;

--
-- Name: TABLE mdl_mnetservice_enrol_enrolments; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_mnetservice_enrol_enrolments IS 'Caches the information about enrolments of our local users in courses on remote hosts';


--
-- Name: mdl_mnetservice_enrol_enrolments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnetservice_enrol_enrolments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnetservice_enrol_enrolments_id_seq OWNER TO postgres;

--
-- Name: mdl_mnetservice_enrol_enrolments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_mnetservice_enrol_enrolments_id_seq OWNED BY public.mdl_mnetservice_enrol_enrolments.id;


--
-- Name: mdl_modules; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_modules (
    id bigint NOT NULL,
    name character varying(20) DEFAULT ''::character varying NOT NULL,
    cron bigint DEFAULT 0 NOT NULL,
    lastcron bigint DEFAULT 0 NOT NULL,
    search character varying(255) DEFAULT ''::character varying NOT NULL,
    visible smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_modules OWNER TO postgres;

--
-- Name: TABLE mdl_modules; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_modules IS 'modules available in the site';


--
-- Name: mdl_modules_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_modules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_modules_id_seq OWNER TO postgres;

--
-- Name: mdl_modules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_modules_id_seq OWNED BY public.mdl_modules.id;


--
-- Name: mdl_my_pages; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_my_pages (
    id bigint NOT NULL,
    userid bigint DEFAULT 0,
    name character varying(200) DEFAULT ''::character varying NOT NULL,
    private smallint DEFAULT 1 NOT NULL,
    sortorder integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_my_pages OWNER TO postgres;

--
-- Name: TABLE mdl_my_pages; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_my_pages IS 'Extra user pages for the My Moodle system';


--
-- Name: mdl_my_pages_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_my_pages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_my_pages_id_seq OWNER TO postgres;

--
-- Name: mdl_my_pages_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_my_pages_id_seq OWNED BY public.mdl_my_pages.id;


--
-- Name: mdl_notifications; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_notifications (
    id bigint NOT NULL,
    useridfrom bigint NOT NULL,
    useridto bigint NOT NULL,
    subject text,
    fullmessage text,
    fullmessageformat smallint DEFAULT 0 NOT NULL,
    fullmessagehtml text,
    smallmessage text,
    component character varying(100),
    eventtype character varying(100),
    contexturl text,
    contexturlname text,
    timeread bigint,
    timecreated bigint NOT NULL,
    customdata text
);


ALTER TABLE public.mdl_notifications OWNER TO postgres;

--
-- Name: TABLE mdl_notifications; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_notifications IS 'Stores all notifications';


--
-- Name: mdl_notifications_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_notifications_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_notifications_id_seq OWNER TO postgres;

--
-- Name: mdl_notifications_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_notifications_id_seq OWNED BY public.mdl_notifications.id;


--
-- Name: mdl_oauth2_access_token; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_oauth2_access_token (
    id bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL,
    issuerid bigint NOT NULL,
    token text NOT NULL,
    expires bigint NOT NULL,
    scope text NOT NULL
);


ALTER TABLE public.mdl_oauth2_access_token OWNER TO postgres;

--
-- Name: TABLE mdl_oauth2_access_token; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_oauth2_access_token IS 'Stores access tokens for system accounts in order to be able to use a single token across multiple sessions';


--
-- Name: mdl_oauth2_access_token_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_oauth2_access_token_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_oauth2_access_token_id_seq OWNER TO postgres;

--
-- Name: mdl_oauth2_access_token_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_oauth2_access_token_id_seq OWNED BY public.mdl_oauth2_access_token.id;


--
-- Name: mdl_oauth2_endpoint; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_oauth2_endpoint (
    id bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    url text NOT NULL,
    issuerid bigint NOT NULL
);


ALTER TABLE public.mdl_oauth2_endpoint OWNER TO postgres;

--
-- Name: TABLE mdl_oauth2_endpoint; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_oauth2_endpoint IS 'Describes the named endpoint for an oauth2 service.';


--
-- Name: mdl_oauth2_endpoint_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_oauth2_endpoint_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_oauth2_endpoint_id_seq OWNER TO postgres;

--
-- Name: mdl_oauth2_endpoint_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_oauth2_endpoint_id_seq OWNED BY public.mdl_oauth2_endpoint.id;


--
-- Name: mdl_oauth2_issuer; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_oauth2_issuer (
    id bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    image text NOT NULL,
    baseurl text NOT NULL,
    clientid text NOT NULL,
    clientsecret text NOT NULL,
    loginscopes text NOT NULL,
    loginscopesoffline text NOT NULL,
    loginparams text NOT NULL,
    loginparamsoffline text NOT NULL,
    alloweddomains text NOT NULL,
    scopessupported text,
    enabled smallint DEFAULT 1 NOT NULL,
    showonloginpage smallint DEFAULT 1 NOT NULL,
    basicauth smallint DEFAULT 0 NOT NULL,
    sortorder bigint NOT NULL,
    requireconfirmation smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_oauth2_issuer OWNER TO postgres;

--
-- Name: TABLE mdl_oauth2_issuer; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_oauth2_issuer IS 'Details for an oauth 2 connect identity issuer.';


--
-- Name: mdl_oauth2_issuer_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_oauth2_issuer_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_oauth2_issuer_id_seq OWNER TO postgres;

--
-- Name: mdl_oauth2_issuer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_oauth2_issuer_id_seq OWNED BY public.mdl_oauth2_issuer.id;


--
-- Name: mdl_oauth2_system_account; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_oauth2_system_account (
    id bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint NOT NULL,
    issuerid bigint NOT NULL,
    refreshtoken text NOT NULL,
    grantedscopes text NOT NULL,
    email text,
    username text NOT NULL
);


ALTER TABLE public.mdl_oauth2_system_account OWNER TO postgres;

--
-- Name: TABLE mdl_oauth2_system_account; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_oauth2_system_account IS 'Stored details used to get an access token as a system user for this oauth2 service.';


--
-- Name: mdl_oauth2_system_account_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_oauth2_system_account_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_oauth2_system_account_id_seq OWNER TO postgres;

--
-- Name: mdl_oauth2_system_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_oauth2_system_account_id_seq OWNED BY public.mdl_oauth2_system_account.id;


--
-- Name: mdl_oauth2_user_field_mapping; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_oauth2_user_field_mapping (
    id bigint NOT NULL,
    timemodified bigint NOT NULL,
    timecreated bigint NOT NULL,
    usermodified bigint NOT NULL,
    issuerid bigint NOT NULL,
    externalfield character varying(64) DEFAULT ''::character varying NOT NULL,
    internalfield character varying(64) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_oauth2_user_field_mapping OWNER TO postgres;

--
-- Name: TABLE mdl_oauth2_user_field_mapping; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_oauth2_user_field_mapping IS 'Mapping of oauth user fields to moodle fields.';


--
-- Name: mdl_oauth2_user_field_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_oauth2_user_field_mapping_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_oauth2_user_field_mapping_id_seq OWNER TO postgres;

--
-- Name: mdl_oauth2_user_field_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_oauth2_user_field_mapping_id_seq OWNED BY public.mdl_oauth2_user_field_mapping.id;


--
-- Name: mdl_page; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_page (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text,
    introformat smallint DEFAULT 0 NOT NULL,
    content text,
    contentformat smallint DEFAULT 0 NOT NULL,
    legacyfiles smallint DEFAULT 0 NOT NULL,
    legacyfileslast bigint,
    display smallint DEFAULT 0 NOT NULL,
    displayoptions text,
    revision bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_page OWNER TO postgres;

--
-- Name: TABLE mdl_page; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_page IS 'Each record is one page and its config data';


--
-- Name: mdl_page_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_page_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_page_id_seq OWNER TO postgres;

--
-- Name: mdl_page_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_page_id_seq OWNED BY public.mdl_page.id;


--
-- Name: mdl_portfolio_instance; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_portfolio_instance (
    id bigint NOT NULL,
    plugin character varying(50) DEFAULT ''::character varying NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    visible smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_portfolio_instance OWNER TO postgres;

--
-- Name: TABLE mdl_portfolio_instance; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_portfolio_instance IS 'base table (not including config data) for instances of portfolio plugins.';


--
-- Name: mdl_portfolio_instance_config; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_portfolio_instance_config (
    id bigint NOT NULL,
    instance bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    value text
);


ALTER TABLE public.mdl_portfolio_instance_config OWNER TO postgres;

--
-- Name: TABLE mdl_portfolio_instance_config; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_portfolio_instance_config IS 'config for portfolio plugin instances';


--
-- Name: mdl_portfolio_instance_config_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_portfolio_instance_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_portfolio_instance_config_id_seq OWNER TO postgres;

--
-- Name: mdl_portfolio_instance_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_portfolio_instance_config_id_seq OWNED BY public.mdl_portfolio_instance_config.id;


--
-- Name: mdl_portfolio_instance_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_portfolio_instance_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_portfolio_instance_id_seq OWNER TO postgres;

--
-- Name: mdl_portfolio_instance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_portfolio_instance_id_seq OWNED BY public.mdl_portfolio_instance.id;


--
-- Name: mdl_portfolio_instance_user; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_portfolio_instance_user (
    id bigint NOT NULL,
    instance bigint NOT NULL,
    userid bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    value text
);


ALTER TABLE public.mdl_portfolio_instance_user OWNER TO postgres;

--
-- Name: TABLE mdl_portfolio_instance_user; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_portfolio_instance_user IS 'user data for portfolio instances.';


--
-- Name: mdl_portfolio_instance_user_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_portfolio_instance_user_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_portfolio_instance_user_id_seq OWNER TO postgres;

--
-- Name: mdl_portfolio_instance_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_portfolio_instance_user_id_seq OWNED BY public.mdl_portfolio_instance_user.id;


--
-- Name: mdl_portfolio_log; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_portfolio_log (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    "time" bigint NOT NULL,
    portfolio bigint NOT NULL,
    caller_class character varying(150) DEFAULT ''::character varying NOT NULL,
    caller_file character varying(255) DEFAULT ''::character varying NOT NULL,
    caller_component character varying(255),
    caller_sha1 character varying(255) DEFAULT ''::character varying NOT NULL,
    tempdataid bigint DEFAULT 0 NOT NULL,
    returnurl character varying(255) DEFAULT ''::character varying NOT NULL,
    continueurl character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_portfolio_log OWNER TO postgres;

--
-- Name: TABLE mdl_portfolio_log; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_portfolio_log IS 'log of portfolio transfers (used to later check for duplicates)';


--
-- Name: mdl_portfolio_log_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_portfolio_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_portfolio_log_id_seq OWNER TO postgres;

--
-- Name: mdl_portfolio_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_portfolio_log_id_seq OWNED BY public.mdl_portfolio_log.id;


--
-- Name: mdl_portfolio_mahara_queue; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_portfolio_mahara_queue (
    id bigint NOT NULL,
    transferid bigint NOT NULL,
    token character varying(50) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_portfolio_mahara_queue OWNER TO postgres;

--
-- Name: TABLE mdl_portfolio_mahara_queue; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_portfolio_mahara_queue IS 'maps mahara tokens to transfer ids';


--
-- Name: mdl_portfolio_mahara_queue_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_portfolio_mahara_queue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_portfolio_mahara_queue_id_seq OWNER TO postgres;

--
-- Name: mdl_portfolio_mahara_queue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_portfolio_mahara_queue_id_seq OWNED BY public.mdl_portfolio_mahara_queue.id;


--
-- Name: mdl_portfolio_tempdata; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_portfolio_tempdata (
    id bigint NOT NULL,
    data text,
    expirytime bigint NOT NULL,
    userid bigint NOT NULL,
    instance bigint DEFAULT 0,
    queued smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_portfolio_tempdata OWNER TO postgres;

--
-- Name: TABLE mdl_portfolio_tempdata; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_portfolio_tempdata IS 'stores temporary data for portfolio exports. the id of this table is used for the itemid for the temporary files area.  cron can clean up stale records (and associated file data) after expirytime.';


--
-- Name: mdl_portfolio_tempdata_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_portfolio_tempdata_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_portfolio_tempdata_id_seq OWNER TO postgres;

--
-- Name: mdl_portfolio_tempdata_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_portfolio_tempdata_id_seq OWNED BY public.mdl_portfolio_tempdata.id;


--
-- Name: mdl_post; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_post (
    id bigint NOT NULL,
    module character varying(20) DEFAULT ''::character varying NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    groupid bigint DEFAULT 0 NOT NULL,
    moduleid bigint DEFAULT 0 NOT NULL,
    coursemoduleid bigint DEFAULT 0 NOT NULL,
    subject character varying(128) DEFAULT ''::character varying NOT NULL,
    summary text,
    content text,
    uniquehash character varying(255) DEFAULT ''::character varying NOT NULL,
    rating bigint DEFAULT 0 NOT NULL,
    format bigint DEFAULT 0 NOT NULL,
    summaryformat smallint DEFAULT 0 NOT NULL,
    attachment character varying(100),
    publishstate character varying(20) DEFAULT 'draft'::character varying NOT NULL,
    lastmodified bigint DEFAULT 0 NOT NULL,
    created bigint DEFAULT 0 NOT NULL,
    usermodified bigint
);


ALTER TABLE public.mdl_post OWNER TO postgres;

--
-- Name: TABLE mdl_post; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_post IS 'Generic post table to hold data blog entries etc in different modules';


--
-- Name: mdl_post_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_post_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_post_id_seq OWNER TO postgres;

--
-- Name: mdl_post_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_post_id_seq OWNED BY public.mdl_post.id;


--
-- Name: mdl_profiling; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_profiling (
    id bigint NOT NULL,
    runid character varying(32) DEFAULT ''::character varying NOT NULL,
    url character varying(255) DEFAULT ''::character varying NOT NULL,
    data text NOT NULL,
    totalexecutiontime bigint NOT NULL,
    totalcputime bigint NOT NULL,
    totalcalls bigint NOT NULL,
    totalmemory bigint NOT NULL,
    runreference smallint DEFAULT 0 NOT NULL,
    runcomment character varying(255) DEFAULT ''::character varying NOT NULL,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_profiling OWNER TO postgres;

--
-- Name: TABLE mdl_profiling; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_profiling IS 'Stores the results of all the profiling runs';


--
-- Name: mdl_profiling_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_profiling_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_profiling_id_seq OWNER TO postgres;

--
-- Name: mdl_profiling_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_profiling_id_seq OWNED BY public.mdl_profiling.id;


--
-- Name: mdl_qtype_ddimageortext; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_qtype_ddimageortext (
    id bigint NOT NULL,
    questionid bigint DEFAULT 0 NOT NULL,
    shuffleanswers smallint DEFAULT 1 NOT NULL,
    correctfeedback text NOT NULL,
    correctfeedbackformat smallint DEFAULT 0 NOT NULL,
    partiallycorrectfeedback text NOT NULL,
    partiallycorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    incorrectfeedback text NOT NULL,
    incorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    shownumcorrect smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_qtype_ddimageortext OWNER TO postgres;

--
-- Name: TABLE mdl_qtype_ddimageortext; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_qtype_ddimageortext IS 'Defines drag and drop (text or images onto a background image) questions';


--
-- Name: mdl_qtype_ddimageortext_drags; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_qtype_ddimageortext_drags (
    id bigint NOT NULL,
    questionid bigint DEFAULT 0 NOT NULL,
    no bigint DEFAULT 0 NOT NULL,
    draggroup bigint DEFAULT 0 NOT NULL,
    infinite smallint DEFAULT 0 NOT NULL,
    label text NOT NULL
);


ALTER TABLE public.mdl_qtype_ddimageortext_drags OWNER TO postgres;

--
-- Name: TABLE mdl_qtype_ddimageortext_drags; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_qtype_ddimageortext_drags IS 'Images to drag. Actual file names are not stored here we use the file names as found in the file storage area.';


--
-- Name: mdl_qtype_ddimageortext_drags_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_qtype_ddimageortext_drags_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_qtype_ddimageortext_drags_id_seq OWNER TO postgres;

--
-- Name: mdl_qtype_ddimageortext_drags_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_qtype_ddimageortext_drags_id_seq OWNED BY public.mdl_qtype_ddimageortext_drags.id;


--
-- Name: mdl_qtype_ddimageortext_drops; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_qtype_ddimageortext_drops (
    id bigint NOT NULL,
    questionid bigint DEFAULT 0 NOT NULL,
    no bigint DEFAULT 0 NOT NULL,
    xleft bigint DEFAULT 0 NOT NULL,
    ytop bigint DEFAULT 0 NOT NULL,
    choice bigint DEFAULT 0 NOT NULL,
    label text NOT NULL
);


ALTER TABLE public.mdl_qtype_ddimageortext_drops OWNER TO postgres;

--
-- Name: TABLE mdl_qtype_ddimageortext_drops; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_qtype_ddimageortext_drops IS 'Drop boxes';


--
-- Name: mdl_qtype_ddimageortext_drops_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_qtype_ddimageortext_drops_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_qtype_ddimageortext_drops_id_seq OWNER TO postgres;

--
-- Name: mdl_qtype_ddimageortext_drops_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_qtype_ddimageortext_drops_id_seq OWNED BY public.mdl_qtype_ddimageortext_drops.id;


--
-- Name: mdl_qtype_ddimageortext_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_qtype_ddimageortext_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_qtype_ddimageortext_id_seq OWNER TO postgres;

--
-- Name: mdl_qtype_ddimageortext_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_qtype_ddimageortext_id_seq OWNED BY public.mdl_qtype_ddimageortext.id;


--
-- Name: mdl_qtype_ddmarker; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_qtype_ddmarker (
    id bigint NOT NULL,
    questionid bigint DEFAULT 0 NOT NULL,
    shuffleanswers smallint DEFAULT 1 NOT NULL,
    correctfeedback text NOT NULL,
    correctfeedbackformat smallint DEFAULT 0 NOT NULL,
    partiallycorrectfeedback text NOT NULL,
    partiallycorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    incorrectfeedback text NOT NULL,
    incorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    shownumcorrect smallint DEFAULT 0 NOT NULL,
    showmisplaced smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_qtype_ddmarker OWNER TO postgres;

--
-- Name: TABLE mdl_qtype_ddmarker; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_qtype_ddmarker IS 'Defines drag and drop (text or images onto a background image) questions';


--
-- Name: mdl_qtype_ddmarker_drags; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_qtype_ddmarker_drags (
    id bigint NOT NULL,
    questionid bigint DEFAULT 0 NOT NULL,
    no bigint DEFAULT 0 NOT NULL,
    label text NOT NULL,
    infinite smallint DEFAULT 0 NOT NULL,
    noofdrags bigint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_qtype_ddmarker_drags OWNER TO postgres;

--
-- Name: TABLE mdl_qtype_ddmarker_drags; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_qtype_ddmarker_drags IS 'Labels for markers to drag.';


--
-- Name: mdl_qtype_ddmarker_drags_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_qtype_ddmarker_drags_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_qtype_ddmarker_drags_id_seq OWNER TO postgres;

--
-- Name: mdl_qtype_ddmarker_drags_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_qtype_ddmarker_drags_id_seq OWNED BY public.mdl_qtype_ddmarker_drags.id;


--
-- Name: mdl_qtype_ddmarker_drops; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_qtype_ddmarker_drops (
    id bigint NOT NULL,
    questionid bigint DEFAULT 0 NOT NULL,
    no bigint DEFAULT 0 NOT NULL,
    shape character varying(255),
    coords text NOT NULL,
    choice bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_qtype_ddmarker_drops OWNER TO postgres;

--
-- Name: TABLE mdl_qtype_ddmarker_drops; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_qtype_ddmarker_drops IS 'drop regions';


--
-- Name: mdl_qtype_ddmarker_drops_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_qtype_ddmarker_drops_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_qtype_ddmarker_drops_id_seq OWNER TO postgres;

--
-- Name: mdl_qtype_ddmarker_drops_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_qtype_ddmarker_drops_id_seq OWNED BY public.mdl_qtype_ddmarker_drops.id;


--
-- Name: mdl_qtype_ddmarker_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_qtype_ddmarker_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_qtype_ddmarker_id_seq OWNER TO postgres;

--
-- Name: mdl_qtype_ddmarker_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_qtype_ddmarker_id_seq OWNED BY public.mdl_qtype_ddmarker.id;


--
-- Name: mdl_qtype_essay_options; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_qtype_essay_options (
    id bigint NOT NULL,
    questionid bigint NOT NULL,
    responseformat character varying(16) DEFAULT 'editor'::character varying NOT NULL,
    responserequired smallint DEFAULT 1 NOT NULL,
    responsefieldlines smallint DEFAULT 15 NOT NULL,
    attachments smallint DEFAULT 0 NOT NULL,
    attachmentsrequired smallint DEFAULT 0 NOT NULL,
    graderinfo text,
    graderinfoformat smallint DEFAULT 0 NOT NULL,
    responsetemplate text,
    responsetemplateformat smallint DEFAULT 0 NOT NULL,
    filetypeslist text
);


ALTER TABLE public.mdl_qtype_essay_options OWNER TO postgres;

--
-- Name: TABLE mdl_qtype_essay_options; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_qtype_essay_options IS 'Extra options for essay questions.';


--
-- Name: mdl_qtype_essay_options_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_qtype_essay_options_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_qtype_essay_options_id_seq OWNER TO postgres;

--
-- Name: mdl_qtype_essay_options_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_qtype_essay_options_id_seq OWNED BY public.mdl_qtype_essay_options.id;


--
-- Name: mdl_qtype_match_options; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_qtype_match_options (
    id bigint NOT NULL,
    questionid bigint DEFAULT 0 NOT NULL,
    shuffleanswers smallint DEFAULT 1 NOT NULL,
    correctfeedback text NOT NULL,
    correctfeedbackformat smallint DEFAULT 0 NOT NULL,
    partiallycorrectfeedback text NOT NULL,
    partiallycorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    incorrectfeedback text NOT NULL,
    incorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    shownumcorrect smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_qtype_match_options OWNER TO postgres;

--
-- Name: TABLE mdl_qtype_match_options; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_qtype_match_options IS 'Defines the question-type specific options for matching questions';


--
-- Name: mdl_qtype_match_options_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_qtype_match_options_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_qtype_match_options_id_seq OWNER TO postgres;

--
-- Name: mdl_qtype_match_options_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_qtype_match_options_id_seq OWNED BY public.mdl_qtype_match_options.id;


--
-- Name: mdl_qtype_match_subquestions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_qtype_match_subquestions (
    id bigint NOT NULL,
    questionid bigint DEFAULT 0 NOT NULL,
    questiontext text NOT NULL,
    questiontextformat smallint DEFAULT 0 NOT NULL,
    answertext character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_qtype_match_subquestions OWNER TO postgres;

--
-- Name: TABLE mdl_qtype_match_subquestions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_qtype_match_subquestions IS 'The subquestions that make up a matching question';


--
-- Name: mdl_qtype_match_subquestions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_qtype_match_subquestions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_qtype_match_subquestions_id_seq OWNER TO postgres;

--
-- Name: mdl_qtype_match_subquestions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_qtype_match_subquestions_id_seq OWNED BY public.mdl_qtype_match_subquestions.id;


--
-- Name: mdl_qtype_multichoice_options; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_qtype_multichoice_options (
    id bigint NOT NULL,
    questionid bigint DEFAULT 0 NOT NULL,
    layout smallint DEFAULT 0 NOT NULL,
    single smallint DEFAULT 0 NOT NULL,
    shuffleanswers smallint DEFAULT 1 NOT NULL,
    correctfeedback text NOT NULL,
    correctfeedbackformat smallint DEFAULT 0 NOT NULL,
    partiallycorrectfeedback text NOT NULL,
    partiallycorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    incorrectfeedback text NOT NULL,
    incorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    answernumbering character varying(10) DEFAULT 'abc'::character varying NOT NULL,
    shownumcorrect smallint DEFAULT 0 NOT NULL,
    showstandardinstruction smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.mdl_qtype_multichoice_options OWNER TO postgres;

--
-- Name: TABLE mdl_qtype_multichoice_options; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_qtype_multichoice_options IS 'Options for multiple choice questions';


--
-- Name: mdl_qtype_multichoice_options_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_qtype_multichoice_options_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_qtype_multichoice_options_id_seq OWNER TO postgres;

--
-- Name: mdl_qtype_multichoice_options_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_qtype_multichoice_options_id_seq OWNED BY public.mdl_qtype_multichoice_options.id;


--
-- Name: mdl_qtype_randomsamatch_options; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_qtype_randomsamatch_options (
    id bigint NOT NULL,
    questionid bigint DEFAULT 0 NOT NULL,
    choose bigint DEFAULT 4 NOT NULL,
    subcats smallint DEFAULT 1 NOT NULL,
    correctfeedback text NOT NULL,
    correctfeedbackformat smallint DEFAULT 0 NOT NULL,
    partiallycorrectfeedback text NOT NULL,
    partiallycorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    incorrectfeedback text NOT NULL,
    incorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    shownumcorrect smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_qtype_randomsamatch_options OWNER TO postgres;

--
-- Name: TABLE mdl_qtype_randomsamatch_options; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_qtype_randomsamatch_options IS 'Info about a random short-answer matching question';


--
-- Name: mdl_qtype_randomsamatch_options_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_qtype_randomsamatch_options_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_qtype_randomsamatch_options_id_seq OWNER TO postgres;

--
-- Name: mdl_qtype_randomsamatch_options_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_qtype_randomsamatch_options_id_seq OWNED BY public.mdl_qtype_randomsamatch_options.id;


--
-- Name: mdl_qtype_shortanswer_options; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_qtype_shortanswer_options (
    id bigint NOT NULL,
    questionid bigint DEFAULT 0 NOT NULL,
    usecase smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_qtype_shortanswer_options OWNER TO postgres;

--
-- Name: TABLE mdl_qtype_shortanswer_options; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_qtype_shortanswer_options IS 'Options for short answer questions';


--
-- Name: mdl_qtype_shortanswer_options_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_qtype_shortanswer_options_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_qtype_shortanswer_options_id_seq OWNER TO postgres;

--
-- Name: mdl_qtype_shortanswer_options_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_qtype_shortanswer_options_id_seq OWNED BY public.mdl_qtype_shortanswer_options.id;


--
-- Name: mdl_question; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question (
    id bigint NOT NULL,
    category bigint DEFAULT 0 NOT NULL,
    parent bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    questiontext text NOT NULL,
    questiontextformat smallint DEFAULT 0 NOT NULL,
    generalfeedback text NOT NULL,
    generalfeedbackformat smallint DEFAULT 0 NOT NULL,
    defaultmark numeric(12,7) DEFAULT 1 NOT NULL,
    penalty numeric(12,7) DEFAULT 0.3333333 NOT NULL,
    qtype character varying(20) DEFAULT ''::character varying NOT NULL,
    length bigint DEFAULT 1 NOT NULL,
    stamp character varying(255) DEFAULT ''::character varying NOT NULL,
    version character varying(255) DEFAULT ''::character varying NOT NULL,
    hidden smallint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    createdby bigint,
    modifiedby bigint,
    idnumber character varying(100)
);


ALTER TABLE public.mdl_question OWNER TO postgres;

--
-- Name: TABLE mdl_question; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question IS 'The questions themselves';


--
-- Name: mdl_question_answers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_answers (
    id bigint NOT NULL,
    question bigint DEFAULT 0 NOT NULL,
    answer text NOT NULL,
    answerformat smallint DEFAULT 0 NOT NULL,
    fraction numeric(12,7) DEFAULT 0 NOT NULL,
    feedback text NOT NULL,
    feedbackformat smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_question_answers OWNER TO postgres;

--
-- Name: TABLE mdl_question_answers; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_answers IS 'Answers, with a fractional grade (0-1) and feedback';


--
-- Name: mdl_question_answers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_answers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_answers_id_seq OWNER TO postgres;

--
-- Name: mdl_question_answers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_answers_id_seq OWNED BY public.mdl_question_answers.id;


--
-- Name: mdl_question_attempt_step_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_attempt_step_data (
    id bigint NOT NULL,
    attemptstepid bigint NOT NULL,
    name character varying(32) DEFAULT ''::character varying NOT NULL,
    value text
);


ALTER TABLE public.mdl_question_attempt_step_data OWNER TO postgres;

--
-- Name: TABLE mdl_question_attempt_step_data; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_attempt_step_data IS 'Each question_attempt_step has an associative array of the data that was submitted by the user in the POST request. It can also contain extra data from the question type or behaviour to avoid re-computation. The convention is that names belonging to ';


--
-- Name: mdl_question_attempt_step_data_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_attempt_step_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_attempt_step_data_id_seq OWNER TO postgres;

--
-- Name: mdl_question_attempt_step_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_attempt_step_data_id_seq OWNED BY public.mdl_question_attempt_step_data.id;


--
-- Name: mdl_question_attempt_steps; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_attempt_steps (
    id bigint NOT NULL,
    questionattemptid bigint NOT NULL,
    sequencenumber bigint NOT NULL,
    state character varying(13) DEFAULT ''::character varying NOT NULL,
    fraction numeric(12,7),
    timecreated bigint NOT NULL,
    userid bigint
);


ALTER TABLE public.mdl_question_attempt_steps OWNER TO postgres;

--
-- Name: TABLE mdl_question_attempt_steps; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_attempt_steps IS 'Stores one step in in a question attempt. As well as the data here, the step will have some data in the question_attempt_step_data table.';


--
-- Name: mdl_question_attempt_steps_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_attempt_steps_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_attempt_steps_id_seq OWNER TO postgres;

--
-- Name: mdl_question_attempt_steps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_attempt_steps_id_seq OWNED BY public.mdl_question_attempt_steps.id;


--
-- Name: mdl_question_attempts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_attempts (
    id bigint NOT NULL,
    questionusageid bigint NOT NULL,
    slot bigint NOT NULL,
    behaviour character varying(32) DEFAULT ''::character varying NOT NULL,
    questionid bigint NOT NULL,
    variant bigint DEFAULT 1 NOT NULL,
    maxmark numeric(12,7) NOT NULL,
    minfraction numeric(12,7) NOT NULL,
    maxfraction numeric(12,7) DEFAULT 1 NOT NULL,
    flagged smallint DEFAULT 0 NOT NULL,
    questionsummary text,
    rightanswer text,
    responsesummary text,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_question_attempts OWNER TO postgres;

--
-- Name: TABLE mdl_question_attempts; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_attempts IS 'Each row here corresponds to an attempt at one question, as part of a question_usage. A question_attempt will have some question_attempt_steps';


--
-- Name: mdl_question_attempts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_attempts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_attempts_id_seq OWNER TO postgres;

--
-- Name: mdl_question_attempts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_attempts_id_seq OWNED BY public.mdl_question_attempts.id;


--
-- Name: mdl_question_calculated; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_calculated (
    id bigint NOT NULL,
    question bigint DEFAULT 0 NOT NULL,
    answer bigint DEFAULT 0 NOT NULL,
    tolerance character varying(20) DEFAULT '0.0'::character varying NOT NULL,
    tolerancetype bigint DEFAULT 1 NOT NULL,
    correctanswerlength bigint DEFAULT 2 NOT NULL,
    correctanswerformat bigint DEFAULT 2 NOT NULL
);


ALTER TABLE public.mdl_question_calculated OWNER TO postgres;

--
-- Name: TABLE mdl_question_calculated; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_calculated IS 'Options for questions of type calculated';


--
-- Name: mdl_question_calculated_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_calculated_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_calculated_id_seq OWNER TO postgres;

--
-- Name: mdl_question_calculated_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_calculated_id_seq OWNED BY public.mdl_question_calculated.id;


--
-- Name: mdl_question_calculated_options; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_calculated_options (
    id bigint NOT NULL,
    question bigint DEFAULT 0 NOT NULL,
    synchronize smallint DEFAULT 0 NOT NULL,
    single smallint DEFAULT 0 NOT NULL,
    shuffleanswers smallint DEFAULT 0 NOT NULL,
    correctfeedback text,
    correctfeedbackformat smallint DEFAULT 0 NOT NULL,
    partiallycorrectfeedback text,
    partiallycorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    incorrectfeedback text,
    incorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    answernumbering character varying(10) DEFAULT 'abc'::character varying NOT NULL,
    shownumcorrect smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_question_calculated_options OWNER TO postgres;

--
-- Name: TABLE mdl_question_calculated_options; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_calculated_options IS 'Options for questions of type calculated';


--
-- Name: mdl_question_calculated_options_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_calculated_options_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_calculated_options_id_seq OWNER TO postgres;

--
-- Name: mdl_question_calculated_options_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_calculated_options_id_seq OWNED BY public.mdl_question_calculated_options.id;


--
-- Name: mdl_question_categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_categories (
    id bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    contextid bigint DEFAULT 0 NOT NULL,
    info text NOT NULL,
    infoformat smallint DEFAULT 0 NOT NULL,
    stamp character varying(255) DEFAULT ''::character varying NOT NULL,
    parent bigint DEFAULT 0 NOT NULL,
    sortorder bigint DEFAULT 999 NOT NULL,
    idnumber character varying(100)
);


ALTER TABLE public.mdl_question_categories OWNER TO postgres;

--
-- Name: TABLE mdl_question_categories; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_categories IS 'Categories are for grouping questions';


--
-- Name: mdl_question_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_categories_id_seq OWNER TO postgres;

--
-- Name: mdl_question_categories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_categories_id_seq OWNED BY public.mdl_question_categories.id;


--
-- Name: mdl_question_dataset_definitions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_dataset_definitions (
    id bigint NOT NULL,
    category bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    type bigint DEFAULT 0 NOT NULL,
    options character varying(255) DEFAULT ''::character varying NOT NULL,
    itemcount bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_question_dataset_definitions OWNER TO postgres;

--
-- Name: TABLE mdl_question_dataset_definitions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_dataset_definitions IS 'Organises and stores properties for dataset items';


--
-- Name: mdl_question_dataset_definitions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_dataset_definitions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_dataset_definitions_id_seq OWNER TO postgres;

--
-- Name: mdl_question_dataset_definitions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_dataset_definitions_id_seq OWNED BY public.mdl_question_dataset_definitions.id;


--
-- Name: mdl_question_dataset_items; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_dataset_items (
    id bigint NOT NULL,
    definition bigint DEFAULT 0 NOT NULL,
    itemnumber bigint DEFAULT 0 NOT NULL,
    value character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_question_dataset_items OWNER TO postgres;

--
-- Name: TABLE mdl_question_dataset_items; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_dataset_items IS 'Individual dataset items';


--
-- Name: mdl_question_dataset_items_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_dataset_items_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_dataset_items_id_seq OWNER TO postgres;

--
-- Name: mdl_question_dataset_items_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_dataset_items_id_seq OWNED BY public.mdl_question_dataset_items.id;


--
-- Name: mdl_question_datasets; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_datasets (
    id bigint NOT NULL,
    question bigint DEFAULT 0 NOT NULL,
    datasetdefinition bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_question_datasets OWNER TO postgres;

--
-- Name: TABLE mdl_question_datasets; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_datasets IS 'Many-many relation between questions and dataset definitions';


--
-- Name: mdl_question_datasets_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_datasets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_datasets_id_seq OWNER TO postgres;

--
-- Name: mdl_question_datasets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_datasets_id_seq OWNED BY public.mdl_question_datasets.id;


--
-- Name: mdl_question_ddwtos; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_ddwtos (
    id bigint NOT NULL,
    questionid bigint DEFAULT 0 NOT NULL,
    shuffleanswers smallint DEFAULT 1 NOT NULL,
    correctfeedback text NOT NULL,
    correctfeedbackformat smallint DEFAULT 0 NOT NULL,
    partiallycorrectfeedback text NOT NULL,
    partiallycorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    incorrectfeedback text NOT NULL,
    incorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    shownumcorrect smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_question_ddwtos OWNER TO postgres;

--
-- Name: TABLE mdl_question_ddwtos; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_ddwtos IS 'Defines drag and drop (words into sentences) questions';


--
-- Name: mdl_question_ddwtos_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_ddwtos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_ddwtos_id_seq OWNER TO postgres;

--
-- Name: mdl_question_ddwtos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_ddwtos_id_seq OWNED BY public.mdl_question_ddwtos.id;


--
-- Name: mdl_question_gapselect; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_gapselect (
    id bigint NOT NULL,
    questionid bigint DEFAULT 0 NOT NULL,
    shuffleanswers smallint DEFAULT 1 NOT NULL,
    correctfeedback text NOT NULL,
    correctfeedbackformat smallint DEFAULT 0 NOT NULL,
    partiallycorrectfeedback text NOT NULL,
    partiallycorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    incorrectfeedback text NOT NULL,
    incorrectfeedbackformat smallint DEFAULT 0 NOT NULL,
    shownumcorrect smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_question_gapselect OWNER TO postgres;

--
-- Name: TABLE mdl_question_gapselect; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_gapselect IS 'Defines select missing words questions';


--
-- Name: mdl_question_gapselect_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_gapselect_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_gapselect_id_seq OWNER TO postgres;

--
-- Name: mdl_question_gapselect_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_gapselect_id_seq OWNED BY public.mdl_question_gapselect.id;


--
-- Name: mdl_question_hints; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_hints (
    id bigint NOT NULL,
    questionid bigint NOT NULL,
    hint text NOT NULL,
    hintformat smallint DEFAULT 0 NOT NULL,
    shownumcorrect smallint,
    clearwrong smallint,
    options character varying(255)
);


ALTER TABLE public.mdl_question_hints OWNER TO postgres;

--
-- Name: TABLE mdl_question_hints; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_hints IS 'Stores the the part of the question definition that gives different feedback after each try in interactive and similar behaviours.';


--
-- Name: mdl_question_hints_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_hints_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_hints_id_seq OWNER TO postgres;

--
-- Name: mdl_question_hints_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_hints_id_seq OWNED BY public.mdl_question_hints.id;


--
-- Name: mdl_question_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_id_seq OWNER TO postgres;

--
-- Name: mdl_question_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_id_seq OWNED BY public.mdl_question.id;


--
-- Name: mdl_question_multianswer; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_multianswer (
    id bigint NOT NULL,
    question bigint DEFAULT 0 NOT NULL,
    sequence text NOT NULL
);


ALTER TABLE public.mdl_question_multianswer OWNER TO postgres;

--
-- Name: TABLE mdl_question_multianswer; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_multianswer IS 'Options for multianswer questions';


--
-- Name: mdl_question_multianswer_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_multianswer_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_multianswer_id_seq OWNER TO postgres;

--
-- Name: mdl_question_multianswer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_multianswer_id_seq OWNED BY public.mdl_question_multianswer.id;


--
-- Name: mdl_question_numerical; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_numerical (
    id bigint NOT NULL,
    question bigint DEFAULT 0 NOT NULL,
    answer bigint DEFAULT 0 NOT NULL,
    tolerance character varying(255) DEFAULT '0.0'::character varying NOT NULL
);


ALTER TABLE public.mdl_question_numerical OWNER TO postgres;

--
-- Name: TABLE mdl_question_numerical; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_numerical IS 'Options for numerical questions.';


--
-- Name: mdl_question_numerical_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_numerical_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_numerical_id_seq OWNER TO postgres;

--
-- Name: mdl_question_numerical_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_numerical_id_seq OWNED BY public.mdl_question_numerical.id;


--
-- Name: mdl_question_numerical_options; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_numerical_options (
    id bigint NOT NULL,
    question bigint DEFAULT 0 NOT NULL,
    showunits smallint DEFAULT 0 NOT NULL,
    unitsleft smallint DEFAULT 0 NOT NULL,
    unitgradingtype smallint DEFAULT 0 NOT NULL,
    unitpenalty numeric(12,7) DEFAULT 0.1 NOT NULL
);


ALTER TABLE public.mdl_question_numerical_options OWNER TO postgres;

--
-- Name: TABLE mdl_question_numerical_options; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_numerical_options IS 'Options for questions of type numerical This table is also used by the calculated question type';


--
-- Name: mdl_question_numerical_options_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_numerical_options_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_numerical_options_id_seq OWNER TO postgres;

--
-- Name: mdl_question_numerical_options_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_numerical_options_id_seq OWNED BY public.mdl_question_numerical_options.id;


--
-- Name: mdl_question_numerical_units; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_numerical_units (
    id bigint NOT NULL,
    question bigint DEFAULT 0 NOT NULL,
    multiplier numeric(38,19) DEFAULT 1.00000000000000000000 NOT NULL,
    unit character varying(50) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_question_numerical_units OWNER TO postgres;

--
-- Name: TABLE mdl_question_numerical_units; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_numerical_units IS 'Optional unit options for numerical questions. This table is also used by the calculated question type.';


--
-- Name: mdl_question_numerical_units_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_numerical_units_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_numerical_units_id_seq OWNER TO postgres;

--
-- Name: mdl_question_numerical_units_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_numerical_units_id_seq OWNED BY public.mdl_question_numerical_units.id;


--
-- Name: mdl_question_response_analysis; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_response_analysis (
    id bigint NOT NULL,
    hashcode character varying(40) DEFAULT ''::character varying NOT NULL,
    whichtries character varying(255) DEFAULT ''::character varying NOT NULL,
    timemodified bigint NOT NULL,
    questionid bigint NOT NULL,
    variant bigint,
    subqid character varying(100) DEFAULT ''::character varying NOT NULL,
    aid character varying(100),
    response text,
    credit numeric(15,5) NOT NULL
);


ALTER TABLE public.mdl_question_response_analysis OWNER TO postgres;

--
-- Name: TABLE mdl_question_response_analysis; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_response_analysis IS 'Analysis of student responses given to questions.';


--
-- Name: mdl_question_response_analysis_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_response_analysis_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_response_analysis_id_seq OWNER TO postgres;

--
-- Name: mdl_question_response_analysis_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_response_analysis_id_seq OWNED BY public.mdl_question_response_analysis.id;


--
-- Name: mdl_question_response_count; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_response_count (
    id bigint NOT NULL,
    analysisid bigint NOT NULL,
    try bigint NOT NULL,
    rcount bigint NOT NULL
);


ALTER TABLE public.mdl_question_response_count OWNER TO postgres;

--
-- Name: TABLE mdl_question_response_count; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_response_count IS 'Count for each responses for each try at a question.';


--
-- Name: mdl_question_response_count_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_response_count_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_response_count_id_seq OWNER TO postgres;

--
-- Name: mdl_question_response_count_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_response_count_id_seq OWNED BY public.mdl_question_response_count.id;


--
-- Name: mdl_question_statistics; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_statistics (
    id bigint NOT NULL,
    hashcode character varying(40) DEFAULT ''::character varying NOT NULL,
    timemodified bigint NOT NULL,
    questionid bigint NOT NULL,
    slot bigint,
    subquestion smallint NOT NULL,
    variant bigint,
    s bigint DEFAULT 0 NOT NULL,
    effectiveweight numeric(15,5),
    negcovar smallint DEFAULT 0 NOT NULL,
    discriminationindex numeric(15,5),
    discriminativeefficiency numeric(15,5),
    sd numeric(15,10),
    facility numeric(15,10),
    subquestions text,
    maxmark numeric(12,7),
    positions text,
    randomguessscore numeric(12,7)
);


ALTER TABLE public.mdl_question_statistics OWNER TO postgres;

--
-- Name: TABLE mdl_question_statistics; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_statistics IS 'Statistics for individual questions used in an activity.';


--
-- Name: mdl_question_statistics_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_statistics_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_statistics_id_seq OWNER TO postgres;

--
-- Name: mdl_question_statistics_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_statistics_id_seq OWNED BY public.mdl_question_statistics.id;


--
-- Name: mdl_question_truefalse; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_truefalse (
    id bigint NOT NULL,
    question bigint DEFAULT 0 NOT NULL,
    trueanswer bigint DEFAULT 0 NOT NULL,
    falseanswer bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_question_truefalse OWNER TO postgres;

--
-- Name: TABLE mdl_question_truefalse; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_truefalse IS 'Options for True-False questions';


--
-- Name: mdl_question_truefalse_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_truefalse_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_truefalse_id_seq OWNER TO postgres;

--
-- Name: mdl_question_truefalse_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_truefalse_id_seq OWNED BY public.mdl_question_truefalse.id;


--
-- Name: mdl_question_usages; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_question_usages (
    id bigint NOT NULL,
    contextid bigint NOT NULL,
    component character varying(255) DEFAULT ''::character varying NOT NULL,
    preferredbehaviour character varying(32) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_question_usages OWNER TO postgres;

--
-- Name: TABLE mdl_question_usages; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_question_usages IS 'This table''s main purpose it to assign a unique id to each attempt at a set of questions by some part of Moodle. A question usage is made up of a number of question_attempts.';


--
-- Name: mdl_question_usages_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_usages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_usages_id_seq OWNER TO postgres;

--
-- Name: mdl_question_usages_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_question_usages_id_seq OWNED BY public.mdl_question_usages.id;


--
-- Name: mdl_quiz; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_quiz (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text NOT NULL,
    introformat smallint DEFAULT 0 NOT NULL,
    timeopen bigint DEFAULT 0 NOT NULL,
    timeclose bigint DEFAULT 0 NOT NULL,
    timelimit bigint DEFAULT 0 NOT NULL,
    overduehandling character varying(16) DEFAULT 'autoabandon'::character varying NOT NULL,
    graceperiod bigint DEFAULT 0 NOT NULL,
    preferredbehaviour character varying(32) DEFAULT ''::character varying NOT NULL,
    canredoquestions smallint DEFAULT 0 NOT NULL,
    attempts integer DEFAULT 0 NOT NULL,
    attemptonlast smallint DEFAULT 0 NOT NULL,
    grademethod smallint DEFAULT 1 NOT NULL,
    decimalpoints smallint DEFAULT 2 NOT NULL,
    questiondecimalpoints smallint DEFAULT '-1'::integer NOT NULL,
    reviewattempt integer DEFAULT 0 NOT NULL,
    reviewcorrectness integer DEFAULT 0 NOT NULL,
    reviewmarks integer DEFAULT 0 NOT NULL,
    reviewspecificfeedback integer DEFAULT 0 NOT NULL,
    reviewgeneralfeedback integer DEFAULT 0 NOT NULL,
    reviewrightanswer integer DEFAULT 0 NOT NULL,
    reviewoverallfeedback integer DEFAULT 0 NOT NULL,
    questionsperpage bigint DEFAULT 0 NOT NULL,
    navmethod character varying(16) DEFAULT 'free'::character varying NOT NULL,
    shuffleanswers smallint DEFAULT 0 NOT NULL,
    sumgrades numeric(10,5) DEFAULT 0 NOT NULL,
    grade numeric(10,5) DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    password character varying(255) DEFAULT ''::character varying NOT NULL,
    subnet character varying(255) DEFAULT ''::character varying NOT NULL,
    browsersecurity character varying(32) DEFAULT ''::character varying NOT NULL,
    delay1 bigint DEFAULT 0 NOT NULL,
    delay2 bigint DEFAULT 0 NOT NULL,
    showuserpicture smallint DEFAULT 0 NOT NULL,
    showblocks smallint DEFAULT 0 NOT NULL,
    completionattemptsexhausted smallint DEFAULT 0,
    completionpass smallint DEFAULT 0,
    allowofflineattempts smallint DEFAULT 0
);


ALTER TABLE public.mdl_quiz OWNER TO postgres;

--
-- Name: TABLE mdl_quiz; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_quiz IS 'The settings for each quiz.';


--
-- Name: mdl_quiz_attempts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_quiz_attempts (
    id bigint NOT NULL,
    quiz bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    attempt integer DEFAULT 0 NOT NULL,
    uniqueid bigint DEFAULT 0 NOT NULL,
    layout text NOT NULL,
    currentpage bigint DEFAULT 0 NOT NULL,
    preview smallint DEFAULT 0 NOT NULL,
    state character varying(16) DEFAULT 'inprogress'::character varying NOT NULL,
    timestart bigint DEFAULT 0 NOT NULL,
    timefinish bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    timemodifiedoffline bigint DEFAULT 0 NOT NULL,
    timecheckstate bigint DEFAULT 0,
    sumgrades numeric(10,5)
);


ALTER TABLE public.mdl_quiz_attempts OWNER TO postgres;

--
-- Name: TABLE mdl_quiz_attempts; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_quiz_attempts IS 'Stores users attempts at quizzes.';


--
-- Name: mdl_quiz_attempts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_attempts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_attempts_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_attempts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_quiz_attempts_id_seq OWNED BY public.mdl_quiz_attempts.id;


--
-- Name: mdl_quiz_feedback; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_quiz_feedback (
    id bigint NOT NULL,
    quizid bigint DEFAULT 0 NOT NULL,
    feedbacktext text NOT NULL,
    feedbacktextformat smallint DEFAULT 0 NOT NULL,
    mingrade numeric(10,5) DEFAULT 0 NOT NULL,
    maxgrade numeric(10,5) DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_quiz_feedback OWNER TO postgres;

--
-- Name: TABLE mdl_quiz_feedback; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_quiz_feedback IS 'Feedback given to students based on which grade band their overall score lies.';


--
-- Name: mdl_quiz_feedback_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_feedback_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_feedback_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_feedback_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_quiz_feedback_id_seq OWNED BY public.mdl_quiz_feedback.id;


--
-- Name: mdl_quiz_grades; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_quiz_grades (
    id bigint NOT NULL,
    quiz bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    grade numeric(10,5) DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_quiz_grades OWNER TO postgres;

--
-- Name: TABLE mdl_quiz_grades; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_quiz_grades IS 'Stores the overall grade for each user on the quiz, based on their various attempts and the quiz.grademethod setting.';


--
-- Name: mdl_quiz_grades_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_grades_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_grades_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_grades_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_quiz_grades_id_seq OWNED BY public.mdl_quiz_grades.id;


--
-- Name: mdl_quiz_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_quiz_id_seq OWNED BY public.mdl_quiz.id;


--
-- Name: mdl_quiz_overrides; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_quiz_overrides (
    id bigint NOT NULL,
    quiz bigint DEFAULT 0 NOT NULL,
    groupid bigint,
    userid bigint,
    timeopen bigint,
    timeclose bigint,
    timelimit bigint,
    attempts integer,
    password character varying(255)
);


ALTER TABLE public.mdl_quiz_overrides OWNER TO postgres;

--
-- Name: TABLE mdl_quiz_overrides; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_quiz_overrides IS 'The overrides to quiz settings on a per-user and per-group basis.';


--
-- Name: mdl_quiz_overrides_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_overrides_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_overrides_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_overrides_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_quiz_overrides_id_seq OWNED BY public.mdl_quiz_overrides.id;


--
-- Name: mdl_quiz_overview_regrades; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_quiz_overview_regrades (
    id bigint NOT NULL,
    questionusageid bigint NOT NULL,
    slot bigint NOT NULL,
    newfraction numeric(12,7),
    oldfraction numeric(12,7),
    regraded smallint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_quiz_overview_regrades OWNER TO postgres;

--
-- Name: TABLE mdl_quiz_overview_regrades; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_quiz_overview_regrades IS 'This table records which question attempts need regrading and the grade they will be regraded to.';


--
-- Name: mdl_quiz_overview_regrades_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_overview_regrades_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_overview_regrades_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_overview_regrades_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_quiz_overview_regrades_id_seq OWNED BY public.mdl_quiz_overview_regrades.id;


--
-- Name: mdl_quiz_reports; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_quiz_reports (
    id bigint NOT NULL,
    name character varying(255),
    displayorder bigint NOT NULL,
    capability character varying(255)
);


ALTER TABLE public.mdl_quiz_reports OWNER TO postgres;

--
-- Name: TABLE mdl_quiz_reports; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_quiz_reports IS 'Lists all the installed quiz reports and their display order and so on. No need to worry about deleting old records. Only records with an equivalent directory are displayed.';


--
-- Name: mdl_quiz_reports_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_reports_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_reports_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_reports_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_quiz_reports_id_seq OWNED BY public.mdl_quiz_reports.id;


--
-- Name: mdl_quiz_sections; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_quiz_sections (
    id bigint NOT NULL,
    quizid bigint NOT NULL,
    firstslot bigint NOT NULL,
    heading character varying(1333),
    shufflequestions smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_quiz_sections OWNER TO postgres;

--
-- Name: TABLE mdl_quiz_sections; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_quiz_sections IS 'Stores sections of a quiz with section name (heading), from slot-number N and whether the question order should be shuffled.';


--
-- Name: mdl_quiz_sections_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_sections_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_sections_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_sections_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_quiz_sections_id_seq OWNED BY public.mdl_quiz_sections.id;


--
-- Name: mdl_quiz_slot_tags; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_quiz_slot_tags (
    id bigint NOT NULL,
    slotid bigint,
    tagid bigint,
    tagname character varying(255)
);


ALTER TABLE public.mdl_quiz_slot_tags OWNER TO postgres;

--
-- Name: TABLE mdl_quiz_slot_tags; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_quiz_slot_tags IS 'Stores data about the tags that a question must have so that it can be selected for a quiz slot (when having a random question by tags on that slot).';


--
-- Name: mdl_quiz_slot_tags_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_slot_tags_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_slot_tags_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_slot_tags_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_quiz_slot_tags_id_seq OWNED BY public.mdl_quiz_slot_tags.id;


--
-- Name: mdl_quiz_slots; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_quiz_slots (
    id bigint NOT NULL,
    slot bigint NOT NULL,
    quizid bigint DEFAULT 0 NOT NULL,
    page bigint NOT NULL,
    requireprevious smallint DEFAULT 0 NOT NULL,
    questionid bigint DEFAULT 0 NOT NULL,
    questioncategoryid bigint,
    includingsubcategories smallint,
    maxmark numeric(12,7) DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_quiz_slots OWNER TO postgres;

--
-- Name: TABLE mdl_quiz_slots; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_quiz_slots IS 'Stores the question used in a quiz, with the order, and for each question, which page it appears on, and the maximum mark (weight).';


--
-- Name: mdl_quiz_slots_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_slots_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_slots_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_slots_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_quiz_slots_id_seq OWNED BY public.mdl_quiz_slots.id;


--
-- Name: mdl_quiz_statistics; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_quiz_statistics (
    id bigint NOT NULL,
    hashcode character varying(40) DEFAULT ''::character varying NOT NULL,
    whichattempts smallint NOT NULL,
    timemodified bigint NOT NULL,
    firstattemptscount bigint NOT NULL,
    highestattemptscount bigint NOT NULL,
    lastattemptscount bigint NOT NULL,
    allattemptscount bigint NOT NULL,
    firstattemptsavg numeric(15,5),
    highestattemptsavg numeric(15,5),
    lastattemptsavg numeric(15,5),
    allattemptsavg numeric(15,5),
    median numeric(15,5),
    standarddeviation numeric(15,5),
    skewness numeric(15,10),
    kurtosis numeric(15,5),
    cic numeric(15,10),
    errorratio numeric(15,10),
    standarderror numeric(15,10)
);


ALTER TABLE public.mdl_quiz_statistics OWNER TO postgres;

--
-- Name: TABLE mdl_quiz_statistics; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_quiz_statistics IS 'table to cache results from analysis done in statistics report for quizzes.';


--
-- Name: mdl_quiz_statistics_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_statistics_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_statistics_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_statistics_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_quiz_statistics_id_seq OWNED BY public.mdl_quiz_statistics.id;


--
-- Name: mdl_quizaccess_seb_quizsettings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_quizaccess_seb_quizsettings (
    id bigint NOT NULL,
    quizid bigint NOT NULL,
    cmid bigint NOT NULL,
    templateid bigint NOT NULL,
    requiresafeexambrowser smallint NOT NULL,
    showsebtaskbar smallint,
    showwificontrol smallint,
    showreloadbutton smallint,
    showtime smallint,
    showkeyboardlayout smallint,
    allowuserquitseb smallint,
    quitpassword text,
    linkquitseb text,
    userconfirmquit smallint,
    enableaudiocontrol smallint,
    muteonstartup smallint,
    allowspellchecking smallint,
    allowreloadinexam smallint,
    activateurlfiltering smallint,
    filterembeddedcontent smallint,
    expressionsallowed text,
    regexallowed text,
    expressionsblocked text,
    regexblocked text,
    allowedbrowserexamkeys text,
    showsebdownloadlink smallint,
    usermodified bigint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_quizaccess_seb_quizsettings OWNER TO postgres;

--
-- Name: TABLE mdl_quizaccess_seb_quizsettings; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_quizaccess_seb_quizsettings IS 'Stores the quiz level Safe Exam Browser configuration.';


--
-- Name: mdl_quizaccess_seb_quizsettings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quizaccess_seb_quizsettings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quizaccess_seb_quizsettings_id_seq OWNER TO postgres;

--
-- Name: mdl_quizaccess_seb_quizsettings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_quizaccess_seb_quizsettings_id_seq OWNED BY public.mdl_quizaccess_seb_quizsettings.id;


--
-- Name: mdl_quizaccess_seb_template; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_quizaccess_seb_template (
    id bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    description text NOT NULL,
    content text NOT NULL,
    enabled smallint NOT NULL,
    sortorder bigint NOT NULL,
    usermodified bigint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_quizaccess_seb_template OWNER TO postgres;

--
-- Name: TABLE mdl_quizaccess_seb_template; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_quizaccess_seb_template IS 'Templates for Safe Exam Browser configuration.';


--
-- Name: mdl_quizaccess_seb_template_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quizaccess_seb_template_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quizaccess_seb_template_id_seq OWNER TO postgres;

--
-- Name: mdl_quizaccess_seb_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_quizaccess_seb_template_id_seq OWNED BY public.mdl_quizaccess_seb_template.id;


--
-- Name: mdl_rating; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_rating (
    id bigint NOT NULL,
    contextid bigint NOT NULL,
    component character varying(100) DEFAULT ''::character varying NOT NULL,
    ratingarea character varying(50) DEFAULT ''::character varying NOT NULL,
    itemid bigint NOT NULL,
    scaleid bigint NOT NULL,
    rating bigint NOT NULL,
    userid bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_rating OWNER TO postgres;

--
-- Name: TABLE mdl_rating; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_rating IS 'moodle ratings';


--
-- Name: mdl_rating_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_rating_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_rating_id_seq OWNER TO postgres;

--
-- Name: mdl_rating_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_rating_id_seq OWNED BY public.mdl_rating.id;


--
-- Name: mdl_registration_hubs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_registration_hubs (
    id bigint NOT NULL,
    token character varying(255) DEFAULT ''::character varying NOT NULL,
    hubname character varying(255) DEFAULT ''::character varying NOT NULL,
    huburl character varying(255) DEFAULT ''::character varying NOT NULL,
    confirmed smallint DEFAULT 0 NOT NULL,
    secret character varying(255),
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_registration_hubs OWNER TO postgres;

--
-- Name: TABLE mdl_registration_hubs; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_registration_hubs IS 'hub where the site is registered on with their associated token';


--
-- Name: mdl_registration_hubs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_registration_hubs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_registration_hubs_id_seq OWNER TO postgres;

--
-- Name: mdl_registration_hubs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_registration_hubs_id_seq OWNED BY public.mdl_registration_hubs.id;


--
-- Name: mdl_repository; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_repository (
    id bigint NOT NULL,
    type character varying(255) DEFAULT ''::character varying NOT NULL,
    visible smallint DEFAULT 1,
    sortorder bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_repository OWNER TO postgres;

--
-- Name: TABLE mdl_repository; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_repository IS 'This table contains one entry for every configured external repository instance.';


--
-- Name: mdl_repository_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_repository_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_repository_id_seq OWNER TO postgres;

--
-- Name: mdl_repository_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_repository_id_seq OWNED BY public.mdl_repository.id;


--
-- Name: mdl_repository_instance_config; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_repository_instance_config (
    id bigint NOT NULL,
    instanceid bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    value text
);


ALTER TABLE public.mdl_repository_instance_config OWNER TO postgres;

--
-- Name: TABLE mdl_repository_instance_config; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_repository_instance_config IS 'The config for intances';


--
-- Name: mdl_repository_instance_config_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_repository_instance_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_repository_instance_config_id_seq OWNER TO postgres;

--
-- Name: mdl_repository_instance_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_repository_instance_config_id_seq OWNED BY public.mdl_repository_instance_config.id;


--
-- Name: mdl_repository_instances; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_repository_instances (
    id bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    typeid bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    contextid bigint NOT NULL,
    username character varying(255),
    password character varying(255),
    timecreated bigint,
    timemodified bigint,
    readonly smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_repository_instances OWNER TO postgres;

--
-- Name: TABLE mdl_repository_instances; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_repository_instances IS 'This table contains one entry for every configured external repository instance.';


--
-- Name: mdl_repository_instances_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_repository_instances_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_repository_instances_id_seq OWNER TO postgres;

--
-- Name: mdl_repository_instances_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_repository_instances_id_seq OWNED BY public.mdl_repository_instances.id;


--
-- Name: mdl_repository_onedrive_access; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_repository_onedrive_access (
    id bigint NOT NULL,
    timemodified bigint NOT NULL,
    timecreated bigint NOT NULL,
    usermodified bigint NOT NULL,
    permissionid character varying(255) DEFAULT ''::character varying NOT NULL,
    itemid character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_repository_onedrive_access OWNER TO postgres;

--
-- Name: TABLE mdl_repository_onedrive_access; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_repository_onedrive_access IS 'List of temporary access grants.';


--
-- Name: mdl_repository_onedrive_access_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_repository_onedrive_access_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_repository_onedrive_access_id_seq OWNER TO postgres;

--
-- Name: mdl_repository_onedrive_access_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_repository_onedrive_access_id_seq OWNED BY public.mdl_repository_onedrive_access.id;


--
-- Name: mdl_resource; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_resource (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text,
    introformat smallint DEFAULT 0 NOT NULL,
    tobemigrated smallint DEFAULT 0 NOT NULL,
    legacyfiles smallint DEFAULT 0 NOT NULL,
    legacyfileslast bigint,
    display smallint DEFAULT 0 NOT NULL,
    displayoptions text,
    filterfiles smallint DEFAULT 0 NOT NULL,
    revision bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_resource OWNER TO postgres;

--
-- Name: TABLE mdl_resource; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_resource IS 'Each record is one resource and its config data';


--
-- Name: mdl_resource_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_resource_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_resource_id_seq OWNER TO postgres;

--
-- Name: mdl_resource_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_resource_id_seq OWNED BY public.mdl_resource.id;


--
-- Name: mdl_resource_old; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_resource_old (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    type character varying(30) DEFAULT ''::character varying NOT NULL,
    reference character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text,
    introformat smallint DEFAULT 0 NOT NULL,
    alltext text NOT NULL,
    popup text NOT NULL,
    options character varying(255) DEFAULT ''::character varying NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    oldid bigint NOT NULL,
    cmid bigint,
    newmodule character varying(50),
    newid bigint,
    migrated bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_resource_old OWNER TO postgres;

--
-- Name: TABLE mdl_resource_old; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_resource_old IS 'backup of all old resource instances from 1.9';


--
-- Name: mdl_resource_old_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_resource_old_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_resource_old_id_seq OWNER TO postgres;

--
-- Name: mdl_resource_old_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_resource_old_id_seq OWNED BY public.mdl_resource_old.id;


--
-- Name: mdl_role; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_role (
    id bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    shortname character varying(100) DEFAULT ''::character varying NOT NULL,
    description text NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL,
    archetype character varying(30) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_role OWNER TO postgres;

--
-- Name: TABLE mdl_role; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_role IS 'moodle roles';


--
-- Name: mdl_role_allow_assign; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_role_allow_assign (
    id bigint NOT NULL,
    roleid bigint DEFAULT 0 NOT NULL,
    allowassign bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_role_allow_assign OWNER TO postgres;

--
-- Name: TABLE mdl_role_allow_assign; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_role_allow_assign IS 'this defines what role can assign what role';


--
-- Name: mdl_role_allow_assign_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_allow_assign_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_allow_assign_id_seq OWNER TO postgres;

--
-- Name: mdl_role_allow_assign_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_role_allow_assign_id_seq OWNED BY public.mdl_role_allow_assign.id;


--
-- Name: mdl_role_allow_override; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_role_allow_override (
    id bigint NOT NULL,
    roleid bigint DEFAULT 0 NOT NULL,
    allowoverride bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_role_allow_override OWNER TO postgres;

--
-- Name: TABLE mdl_role_allow_override; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_role_allow_override IS 'this defines what role can override what role';


--
-- Name: mdl_role_allow_override_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_allow_override_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_allow_override_id_seq OWNER TO postgres;

--
-- Name: mdl_role_allow_override_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_role_allow_override_id_seq OWNED BY public.mdl_role_allow_override.id;


--
-- Name: mdl_role_allow_switch; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_role_allow_switch (
    id bigint NOT NULL,
    roleid bigint NOT NULL,
    allowswitch bigint NOT NULL
);


ALTER TABLE public.mdl_role_allow_switch OWNER TO postgres;

--
-- Name: TABLE mdl_role_allow_switch; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_role_allow_switch IS 'This table stores which which other roles a user is allowed to switch to if they have one role.';


--
-- Name: mdl_role_allow_switch_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_allow_switch_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_allow_switch_id_seq OWNER TO postgres;

--
-- Name: mdl_role_allow_switch_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_role_allow_switch_id_seq OWNED BY public.mdl_role_allow_switch.id;


--
-- Name: mdl_role_allow_view; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_role_allow_view (
    id bigint NOT NULL,
    roleid bigint NOT NULL,
    allowview bigint NOT NULL
);


ALTER TABLE public.mdl_role_allow_view OWNER TO postgres;

--
-- Name: TABLE mdl_role_allow_view; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_role_allow_view IS 'This table stores which which other roles a user is allowed to view to if they have one role.';


--
-- Name: mdl_role_allow_view_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_allow_view_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_allow_view_id_seq OWNER TO postgres;

--
-- Name: mdl_role_allow_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_role_allow_view_id_seq OWNED BY public.mdl_role_allow_view.id;


--
-- Name: mdl_role_assignments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_role_assignments (
    id bigint NOT NULL,
    roleid bigint DEFAULT 0 NOT NULL,
    contextid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    modifierid bigint DEFAULT 0 NOT NULL,
    component character varying(100) DEFAULT ''::character varying NOT NULL,
    itemid bigint DEFAULT 0 NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_role_assignments OWNER TO postgres;

--
-- Name: TABLE mdl_role_assignments; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_role_assignments IS 'assigning roles in different context';


--
-- Name: mdl_role_assignments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_assignments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_assignments_id_seq OWNER TO postgres;

--
-- Name: mdl_role_assignments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_role_assignments_id_seq OWNED BY public.mdl_role_assignments.id;


--
-- Name: mdl_role_capabilities; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_role_capabilities (
    id bigint NOT NULL,
    contextid bigint DEFAULT 0 NOT NULL,
    roleid bigint DEFAULT 0 NOT NULL,
    capability character varying(255) DEFAULT ''::character varying NOT NULL,
    permission bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    modifierid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_role_capabilities OWNER TO postgres;

--
-- Name: TABLE mdl_role_capabilities; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_role_capabilities IS 'permission has to be signed, overriding a capability for a particular role in a particular context';


--
-- Name: mdl_role_capabilities_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_capabilities_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_capabilities_id_seq OWNER TO postgres;

--
-- Name: mdl_role_capabilities_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_role_capabilities_id_seq OWNED BY public.mdl_role_capabilities.id;


--
-- Name: mdl_role_context_levels; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_role_context_levels (
    id bigint NOT NULL,
    roleid bigint NOT NULL,
    contextlevel bigint NOT NULL
);


ALTER TABLE public.mdl_role_context_levels OWNER TO postgres;

--
-- Name: TABLE mdl_role_context_levels; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_role_context_levels IS 'Lists which roles can be assigned at which context levels. The assignment is allowed in the corresponding row is present in this table.';


--
-- Name: mdl_role_context_levels_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_context_levels_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_context_levels_id_seq OWNER TO postgres;

--
-- Name: mdl_role_context_levels_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_role_context_levels_id_seq OWNED BY public.mdl_role_context_levels.id;


--
-- Name: mdl_role_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_id_seq OWNER TO postgres;

--
-- Name: mdl_role_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_role_id_seq OWNED BY public.mdl_role.id;


--
-- Name: mdl_role_names; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_role_names (
    id bigint NOT NULL,
    roleid bigint DEFAULT 0 NOT NULL,
    contextid bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_role_names OWNER TO postgres;

--
-- Name: TABLE mdl_role_names; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_role_names IS 'role names in native strings';


--
-- Name: mdl_role_names_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_names_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_names_id_seq OWNER TO postgres;

--
-- Name: mdl_role_names_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_role_names_id_seq OWNED BY public.mdl_role_names.id;


--
-- Name: mdl_scale; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_scale (
    id bigint NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    scale text NOT NULL,
    description text NOT NULL,
    descriptionformat smallint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_scale OWNER TO postgres;

--
-- Name: TABLE mdl_scale; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_scale IS 'Defines grading scales';


--
-- Name: mdl_scale_history; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_scale_history (
    id bigint NOT NULL,
    action bigint DEFAULT 0 NOT NULL,
    oldid bigint NOT NULL,
    source character varying(255),
    timemodified bigint,
    loggeduser bigint,
    courseid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    scale text NOT NULL,
    description text NOT NULL
);


ALTER TABLE public.mdl_scale_history OWNER TO postgres;

--
-- Name: TABLE mdl_scale_history; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_scale_history IS 'History table';


--
-- Name: mdl_scale_history_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scale_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scale_history_id_seq OWNER TO postgres;

--
-- Name: mdl_scale_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_scale_history_id_seq OWNED BY public.mdl_scale_history.id;


--
-- Name: mdl_scale_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scale_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scale_id_seq OWNER TO postgres;

--
-- Name: mdl_scale_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_scale_id_seq OWNED BY public.mdl_scale.id;


--
-- Name: mdl_scorm; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_scorm (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    scormtype character varying(50) DEFAULT 'local'::character varying NOT NULL,
    reference character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text NOT NULL,
    introformat smallint DEFAULT 0 NOT NULL,
    version character varying(9) DEFAULT ''::character varying NOT NULL,
    maxgrade double precision DEFAULT 0 NOT NULL,
    grademethod smallint DEFAULT 0 NOT NULL,
    whatgrade bigint DEFAULT 0 NOT NULL,
    maxattempt bigint DEFAULT 1 NOT NULL,
    forcecompleted smallint DEFAULT 0 NOT NULL,
    forcenewattempt smallint DEFAULT 0 NOT NULL,
    lastattemptlock smallint DEFAULT 0 NOT NULL,
    masteryoverride smallint DEFAULT 1 NOT NULL,
    displayattemptstatus smallint DEFAULT 1 NOT NULL,
    displaycoursestructure smallint DEFAULT 0 NOT NULL,
    updatefreq smallint DEFAULT 0 NOT NULL,
    sha1hash character varying(40),
    md5hash character varying(32) DEFAULT ''::character varying NOT NULL,
    revision bigint DEFAULT 0 NOT NULL,
    launch bigint DEFAULT 0 NOT NULL,
    skipview smallint DEFAULT 1 NOT NULL,
    hidebrowse smallint DEFAULT 0 NOT NULL,
    hidetoc smallint DEFAULT 0 NOT NULL,
    nav smallint DEFAULT 1 NOT NULL,
    navpositionleft bigint DEFAULT '-100'::integer,
    navpositiontop bigint DEFAULT '-100'::integer,
    auto smallint DEFAULT 0 NOT NULL,
    popup smallint DEFAULT 0 NOT NULL,
    options character varying(255) DEFAULT ''::character varying NOT NULL,
    width bigint DEFAULT 100 NOT NULL,
    height bigint DEFAULT 600 NOT NULL,
    timeopen bigint DEFAULT 0 NOT NULL,
    timeclose bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    completionstatusrequired smallint,
    completionscorerequired bigint,
    completionstatusallscos smallint,
    displayactivityname smallint DEFAULT 1 NOT NULL,
    autocommit smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_scorm OWNER TO postgres;

--
-- Name: TABLE mdl_scorm; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_scorm IS 'each table is one SCORM module and its configuration';


--
-- Name: mdl_scorm_aicc_session; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_scorm_aicc_session (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    scormid bigint DEFAULT 0 NOT NULL,
    hacpsession character varying(255) DEFAULT ''::character varying NOT NULL,
    scoid bigint DEFAULT 0,
    scormmode character varying(50),
    scormstatus character varying(255),
    attempt bigint,
    lessonstatus character varying(255),
    sessiontime character varying(255),
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_scorm_aicc_session OWNER TO postgres;

--
-- Name: TABLE mdl_scorm_aicc_session; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_scorm_aicc_session IS 'Used by AICC HACP to store session information';


--
-- Name: mdl_scorm_aicc_session_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_aicc_session_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_aicc_session_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_aicc_session_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_scorm_aicc_session_id_seq OWNED BY public.mdl_scorm_aicc_session.id;


--
-- Name: mdl_scorm_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_scorm_id_seq OWNED BY public.mdl_scorm.id;


--
-- Name: mdl_scorm_scoes; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_scorm_scoes (
    id bigint NOT NULL,
    scorm bigint DEFAULT 0 NOT NULL,
    manifest character varying(255) DEFAULT ''::character varying NOT NULL,
    organization character varying(255) DEFAULT ''::character varying NOT NULL,
    parent character varying(255) DEFAULT ''::character varying NOT NULL,
    identifier character varying(255) DEFAULT ''::character varying NOT NULL,
    launch text NOT NULL,
    scormtype character varying(5) DEFAULT ''::character varying NOT NULL,
    title character varying(255) DEFAULT ''::character varying NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_scorm_scoes OWNER TO postgres;

--
-- Name: TABLE mdl_scorm_scoes; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_scorm_scoes IS 'each SCO part of the SCORM module';


--
-- Name: mdl_scorm_scoes_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_scorm_scoes_data (
    id bigint NOT NULL,
    scoid bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    value text NOT NULL
);


ALTER TABLE public.mdl_scorm_scoes_data OWNER TO postgres;

--
-- Name: TABLE mdl_scorm_scoes_data; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_scorm_scoes_data IS 'Contains variable data get from packages';


--
-- Name: mdl_scorm_scoes_data_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_scoes_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_scoes_data_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_scoes_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_scorm_scoes_data_id_seq OWNED BY public.mdl_scorm_scoes_data.id;


--
-- Name: mdl_scorm_scoes_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_scoes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_scoes_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_scoes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_scorm_scoes_id_seq OWNED BY public.mdl_scorm_scoes.id;


--
-- Name: mdl_scorm_scoes_track; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_scorm_scoes_track (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    scormid bigint DEFAULT 0 NOT NULL,
    scoid bigint DEFAULT 0 NOT NULL,
    attempt bigint DEFAULT 1 NOT NULL,
    element character varying(255) DEFAULT ''::character varying NOT NULL,
    value text NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_scorm_scoes_track OWNER TO postgres;

--
-- Name: TABLE mdl_scorm_scoes_track; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_scorm_scoes_track IS 'to track SCOes';


--
-- Name: mdl_scorm_scoes_track_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_scoes_track_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_scoes_track_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_scoes_track_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_scorm_scoes_track_id_seq OWNED BY public.mdl_scorm_scoes_track.id;


--
-- Name: mdl_scorm_seq_mapinfo; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_scorm_seq_mapinfo (
    id bigint NOT NULL,
    scoid bigint DEFAULT 0 NOT NULL,
    objectiveid bigint DEFAULT 0 NOT NULL,
    targetobjectiveid bigint DEFAULT 0 NOT NULL,
    readsatisfiedstatus smallint DEFAULT 1 NOT NULL,
    readnormalizedmeasure smallint DEFAULT 1 NOT NULL,
    writesatisfiedstatus smallint DEFAULT 0 NOT NULL,
    writenormalizedmeasure smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_scorm_seq_mapinfo OWNER TO postgres;

--
-- Name: TABLE mdl_scorm_seq_mapinfo; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_scorm_seq_mapinfo IS 'SCORM2004 objective mapinfo description';


--
-- Name: mdl_scorm_seq_mapinfo_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_seq_mapinfo_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_seq_mapinfo_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_seq_mapinfo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_scorm_seq_mapinfo_id_seq OWNED BY public.mdl_scorm_seq_mapinfo.id;


--
-- Name: mdl_scorm_seq_objective; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_scorm_seq_objective (
    id bigint NOT NULL,
    scoid bigint DEFAULT 0 NOT NULL,
    primaryobj smallint DEFAULT 0 NOT NULL,
    objectiveid character varying(255) DEFAULT ''::character varying NOT NULL,
    satisfiedbymeasure smallint DEFAULT 1 NOT NULL,
    minnormalizedmeasure real DEFAULT 0.0000 NOT NULL
);


ALTER TABLE public.mdl_scorm_seq_objective OWNER TO postgres;

--
-- Name: TABLE mdl_scorm_seq_objective; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_scorm_seq_objective IS 'SCORM2004 objective description';


--
-- Name: mdl_scorm_seq_objective_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_seq_objective_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_seq_objective_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_seq_objective_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_scorm_seq_objective_id_seq OWNED BY public.mdl_scorm_seq_objective.id;


--
-- Name: mdl_scorm_seq_rolluprule; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_scorm_seq_rolluprule (
    id bigint NOT NULL,
    scoid bigint DEFAULT 0 NOT NULL,
    childactivityset character varying(15) DEFAULT ''::character varying NOT NULL,
    minimumcount bigint DEFAULT 0 NOT NULL,
    minimumpercent real DEFAULT 0.0000 NOT NULL,
    conditioncombination character varying(3) DEFAULT 'all'::character varying NOT NULL,
    action character varying(15) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_scorm_seq_rolluprule OWNER TO postgres;

--
-- Name: TABLE mdl_scorm_seq_rolluprule; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_scorm_seq_rolluprule IS 'SCORM2004 sequencing rule';


--
-- Name: mdl_scorm_seq_rolluprule_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_seq_rolluprule_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_seq_rolluprule_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_seq_rolluprule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_scorm_seq_rolluprule_id_seq OWNED BY public.mdl_scorm_seq_rolluprule.id;


--
-- Name: mdl_scorm_seq_rolluprulecond; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_scorm_seq_rolluprulecond (
    id bigint NOT NULL,
    scoid bigint DEFAULT 0 NOT NULL,
    rollupruleid bigint DEFAULT 0 NOT NULL,
    operator character varying(5) DEFAULT 'noOp'::character varying NOT NULL,
    cond character varying(25) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_scorm_seq_rolluprulecond OWNER TO postgres;

--
-- Name: TABLE mdl_scorm_seq_rolluprulecond; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_scorm_seq_rolluprulecond IS 'SCORM2004 sequencing rule';


--
-- Name: mdl_scorm_seq_rolluprulecond_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_seq_rolluprulecond_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_seq_rolluprulecond_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_seq_rolluprulecond_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_scorm_seq_rolluprulecond_id_seq OWNED BY public.mdl_scorm_seq_rolluprulecond.id;


--
-- Name: mdl_scorm_seq_rulecond; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_scorm_seq_rulecond (
    id bigint NOT NULL,
    scoid bigint DEFAULT 0 NOT NULL,
    ruleconditionsid bigint DEFAULT 0 NOT NULL,
    refrencedobjective character varying(255) DEFAULT ''::character varying NOT NULL,
    measurethreshold real DEFAULT 0.0000 NOT NULL,
    operator character varying(5) DEFAULT 'noOp'::character varying NOT NULL,
    cond character varying(30) DEFAULT 'always'::character varying NOT NULL
);


ALTER TABLE public.mdl_scorm_seq_rulecond OWNER TO postgres;

--
-- Name: TABLE mdl_scorm_seq_rulecond; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_scorm_seq_rulecond IS 'SCORM2004 rule condition';


--
-- Name: mdl_scorm_seq_rulecond_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_seq_rulecond_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_seq_rulecond_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_seq_rulecond_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_scorm_seq_rulecond_id_seq OWNED BY public.mdl_scorm_seq_rulecond.id;


--
-- Name: mdl_scorm_seq_ruleconds; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_scorm_seq_ruleconds (
    id bigint NOT NULL,
    scoid bigint DEFAULT 0 NOT NULL,
    conditioncombination character varying(3) DEFAULT 'all'::character varying NOT NULL,
    ruletype smallint DEFAULT 0 NOT NULL,
    action character varying(25) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_scorm_seq_ruleconds OWNER TO postgres;

--
-- Name: TABLE mdl_scorm_seq_ruleconds; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_scorm_seq_ruleconds IS 'SCORM2004 rule conditions';


--
-- Name: mdl_scorm_seq_ruleconds_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_seq_ruleconds_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_seq_ruleconds_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_seq_ruleconds_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_scorm_seq_ruleconds_id_seq OWNED BY public.mdl_scorm_seq_ruleconds.id;


--
-- Name: mdl_search_index_requests; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_search_index_requests (
    id bigint NOT NULL,
    contextid bigint NOT NULL,
    searcharea character varying(255) DEFAULT ''::character varying NOT NULL,
    timerequested bigint NOT NULL,
    partialarea character varying(255) DEFAULT ''::character varying NOT NULL,
    partialtime bigint NOT NULL,
    indexpriority bigint NOT NULL
);


ALTER TABLE public.mdl_search_index_requests OWNER TO postgres;

--
-- Name: TABLE mdl_search_index_requests; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_search_index_requests IS 'Records requests for (re)indexing of specific contexts. Entries will be removed from this table when indexing of that context is complete. (This table is not used for normal time-based indexing of new content.)';


--
-- Name: mdl_search_index_requests_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_search_index_requests_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_search_index_requests_id_seq OWNER TO postgres;

--
-- Name: mdl_search_index_requests_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_search_index_requests_id_seq OWNED BY public.mdl_search_index_requests.id;


--
-- Name: mdl_search_simpledb_index; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_search_simpledb_index (
    id bigint NOT NULL,
    docid character varying(255) DEFAULT ''::character varying NOT NULL,
    itemid bigint NOT NULL,
    title text,
    content text,
    contextid bigint NOT NULL,
    areaid character varying(255) DEFAULT ''::character varying NOT NULL,
    type smallint NOT NULL,
    courseid bigint NOT NULL,
    owneruserid bigint,
    modified bigint NOT NULL,
    userid bigint,
    description1 text,
    description2 text
);


ALTER TABLE public.mdl_search_simpledb_index OWNER TO postgres;

--
-- Name: TABLE mdl_search_simpledb_index; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_search_simpledb_index IS 'search_simpledb table containing the index data.';


--
-- Name: mdl_search_simpledb_index_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_search_simpledb_index_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_search_simpledb_index_id_seq OWNER TO postgres;

--
-- Name: mdl_search_simpledb_index_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_search_simpledb_index_id_seq OWNED BY public.mdl_search_simpledb_index.id;


--
-- Name: mdl_sessions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_sessions (
    id bigint NOT NULL,
    state bigint DEFAULT 0 NOT NULL,
    sid character varying(128) DEFAULT ''::character varying NOT NULL,
    userid bigint NOT NULL,
    sessdata text,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    firstip character varying(45),
    lastip character varying(45)
);


ALTER TABLE public.mdl_sessions OWNER TO postgres;

--
-- Name: TABLE mdl_sessions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_sessions IS 'Database based session storage - now recommended';


--
-- Name: mdl_sessions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_sessions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_sessions_id_seq OWNER TO postgres;

--
-- Name: mdl_sessions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_sessions_id_seq OWNED BY public.mdl_sessions.id;


--
-- Name: mdl_stats_daily; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_stats_daily (
    id bigint NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    timeend bigint DEFAULT 0 NOT NULL,
    roleid bigint DEFAULT 0 NOT NULL,
    stattype character varying(20) DEFAULT 'activity'::character varying NOT NULL,
    stat1 bigint DEFAULT 0 NOT NULL,
    stat2 bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_stats_daily OWNER TO postgres;

--
-- Name: TABLE mdl_stats_daily; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_stats_daily IS 'to accumulate daily stats';


--
-- Name: mdl_stats_daily_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_stats_daily_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_stats_daily_id_seq OWNER TO postgres;

--
-- Name: mdl_stats_daily_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_stats_daily_id_seq OWNED BY public.mdl_stats_daily.id;


--
-- Name: mdl_stats_monthly; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_stats_monthly (
    id bigint NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    timeend bigint DEFAULT 0 NOT NULL,
    roleid bigint DEFAULT 0 NOT NULL,
    stattype character varying(20) DEFAULT 'activity'::character varying NOT NULL,
    stat1 bigint DEFAULT 0 NOT NULL,
    stat2 bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_stats_monthly OWNER TO postgres;

--
-- Name: TABLE mdl_stats_monthly; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_stats_monthly IS 'To accumulate monthly stats';


--
-- Name: mdl_stats_monthly_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_stats_monthly_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_stats_monthly_id_seq OWNER TO postgres;

--
-- Name: mdl_stats_monthly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_stats_monthly_id_seq OWNED BY public.mdl_stats_monthly.id;


--
-- Name: mdl_stats_user_daily; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_stats_user_daily (
    id bigint NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    roleid bigint DEFAULT 0 NOT NULL,
    timeend bigint DEFAULT 0 NOT NULL,
    statsreads bigint DEFAULT 0 NOT NULL,
    statswrites bigint DEFAULT 0 NOT NULL,
    stattype character varying(30) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_stats_user_daily OWNER TO postgres;

--
-- Name: TABLE mdl_stats_user_daily; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_stats_user_daily IS 'To accumulate daily stats per course/user';


--
-- Name: mdl_stats_user_daily_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_stats_user_daily_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_stats_user_daily_id_seq OWNER TO postgres;

--
-- Name: mdl_stats_user_daily_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_stats_user_daily_id_seq OWNED BY public.mdl_stats_user_daily.id;


--
-- Name: mdl_stats_user_monthly; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_stats_user_monthly (
    id bigint NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    roleid bigint DEFAULT 0 NOT NULL,
    timeend bigint DEFAULT 0 NOT NULL,
    statsreads bigint DEFAULT 0 NOT NULL,
    statswrites bigint DEFAULT 0 NOT NULL,
    stattype character varying(30) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_stats_user_monthly OWNER TO postgres;

--
-- Name: TABLE mdl_stats_user_monthly; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_stats_user_monthly IS 'To accumulate monthly stats per course/user';


--
-- Name: mdl_stats_user_monthly_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_stats_user_monthly_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_stats_user_monthly_id_seq OWNER TO postgres;

--
-- Name: mdl_stats_user_monthly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_stats_user_monthly_id_seq OWNED BY public.mdl_stats_user_monthly.id;


--
-- Name: mdl_stats_user_weekly; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_stats_user_weekly (
    id bigint NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    roleid bigint DEFAULT 0 NOT NULL,
    timeend bigint DEFAULT 0 NOT NULL,
    statsreads bigint DEFAULT 0 NOT NULL,
    statswrites bigint DEFAULT 0 NOT NULL,
    stattype character varying(30) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_stats_user_weekly OWNER TO postgres;

--
-- Name: TABLE mdl_stats_user_weekly; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_stats_user_weekly IS 'To accumulate weekly stats per course/user';


--
-- Name: mdl_stats_user_weekly_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_stats_user_weekly_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_stats_user_weekly_id_seq OWNER TO postgres;

--
-- Name: mdl_stats_user_weekly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_stats_user_weekly_id_seq OWNED BY public.mdl_stats_user_weekly.id;


--
-- Name: mdl_stats_weekly; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_stats_weekly (
    id bigint NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    timeend bigint DEFAULT 0 NOT NULL,
    roleid bigint DEFAULT 0 NOT NULL,
    stattype character varying(20) DEFAULT 'activity'::character varying NOT NULL,
    stat1 bigint DEFAULT 0 NOT NULL,
    stat2 bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_stats_weekly OWNER TO postgres;

--
-- Name: TABLE mdl_stats_weekly; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_stats_weekly IS 'To accumulate weekly stats';


--
-- Name: mdl_stats_weekly_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_stats_weekly_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_stats_weekly_id_seq OWNER TO postgres;

--
-- Name: mdl_stats_weekly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_stats_weekly_id_seq OWNED BY public.mdl_stats_weekly.id;


--
-- Name: mdl_survey; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_survey (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    template bigint DEFAULT 0 NOT NULL,
    days integer DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text NOT NULL,
    introformat smallint DEFAULT 0 NOT NULL,
    questions character varying(255) DEFAULT ''::character varying NOT NULL,
    completionsubmit smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_survey OWNER TO postgres;

--
-- Name: TABLE mdl_survey; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_survey IS 'Each record is one SURVEY module with its configuration';


--
-- Name: mdl_survey_analysis; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_survey_analysis (
    id bigint NOT NULL,
    survey bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    notes text NOT NULL
);


ALTER TABLE public.mdl_survey_analysis OWNER TO postgres;

--
-- Name: TABLE mdl_survey_analysis; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_survey_analysis IS 'text about each survey submission';


--
-- Name: mdl_survey_analysis_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_survey_analysis_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_survey_analysis_id_seq OWNER TO postgres;

--
-- Name: mdl_survey_analysis_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_survey_analysis_id_seq OWNED BY public.mdl_survey_analysis.id;


--
-- Name: mdl_survey_answers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_survey_answers (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    survey bigint DEFAULT 0 NOT NULL,
    question bigint DEFAULT 0 NOT NULL,
    "time" bigint DEFAULT 0 NOT NULL,
    answer1 text NOT NULL,
    answer2 text NOT NULL
);


ALTER TABLE public.mdl_survey_answers OWNER TO postgres;

--
-- Name: TABLE mdl_survey_answers; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_survey_answers IS 'the answers to each questions filled by the users';


--
-- Name: mdl_survey_answers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_survey_answers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_survey_answers_id_seq OWNER TO postgres;

--
-- Name: mdl_survey_answers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_survey_answers_id_seq OWNED BY public.mdl_survey_answers.id;


--
-- Name: mdl_survey_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_survey_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_survey_id_seq OWNER TO postgres;

--
-- Name: mdl_survey_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_survey_id_seq OWNED BY public.mdl_survey.id;


--
-- Name: mdl_survey_questions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_survey_questions (
    id bigint NOT NULL,
    text character varying(255) DEFAULT ''::character varying NOT NULL,
    shorttext character varying(30) DEFAULT ''::character varying NOT NULL,
    multi character varying(100) DEFAULT ''::character varying NOT NULL,
    intro character varying(50) DEFAULT ''::character varying NOT NULL,
    type smallint DEFAULT 0 NOT NULL,
    options text
);


ALTER TABLE public.mdl_survey_questions OWNER TO postgres;

--
-- Name: TABLE mdl_survey_questions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_survey_questions IS 'the questions conforming one survey';


--
-- Name: mdl_survey_questions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_survey_questions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_survey_questions_id_seq OWNER TO postgres;

--
-- Name: mdl_survey_questions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_survey_questions_id_seq OWNED BY public.mdl_survey_questions.id;


--
-- Name: mdl_tag; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tag (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    tagcollid bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    rawname character varying(255) DEFAULT ''::character varying NOT NULL,
    isstandard smallint DEFAULT 0 NOT NULL,
    description text,
    descriptionformat smallint DEFAULT 0 NOT NULL,
    flag smallint DEFAULT 0,
    timemodified bigint
);


ALTER TABLE public.mdl_tag OWNER TO postgres;

--
-- Name: TABLE mdl_tag; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tag IS 'Tag table - this generic table will replace the old "tags" table.';


--
-- Name: mdl_tag_area; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tag_area (
    id bigint NOT NULL,
    component character varying(100) DEFAULT ''::character varying NOT NULL,
    itemtype character varying(100) DEFAULT ''::character varying NOT NULL,
    enabled smallint DEFAULT 1 NOT NULL,
    tagcollid bigint NOT NULL,
    callback character varying(100),
    callbackfile character varying(100),
    showstandard smallint DEFAULT 0 NOT NULL,
    multiplecontexts smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_tag_area OWNER TO postgres;

--
-- Name: TABLE mdl_tag_area; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tag_area IS 'Defines various tag areas, one area is identified by component and itemtype';


--
-- Name: mdl_tag_area_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tag_area_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tag_area_id_seq OWNER TO postgres;

--
-- Name: mdl_tag_area_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tag_area_id_seq OWNED BY public.mdl_tag_area.id;


--
-- Name: mdl_tag_coll; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tag_coll (
    id bigint NOT NULL,
    name character varying(255),
    isdefault smallint DEFAULT 0 NOT NULL,
    component character varying(100),
    sortorder integer DEFAULT 0 NOT NULL,
    searchable smallint DEFAULT 1 NOT NULL,
    customurl character varying(255)
);


ALTER TABLE public.mdl_tag_coll OWNER TO postgres;

--
-- Name: TABLE mdl_tag_coll; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tag_coll IS 'Defines different set of tags';


--
-- Name: mdl_tag_coll_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tag_coll_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tag_coll_id_seq OWNER TO postgres;

--
-- Name: mdl_tag_coll_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tag_coll_id_seq OWNED BY public.mdl_tag_coll.id;


--
-- Name: mdl_tag_correlation; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tag_correlation (
    id bigint NOT NULL,
    tagid bigint NOT NULL,
    correlatedtags text NOT NULL
);


ALTER TABLE public.mdl_tag_correlation OWNER TO postgres;

--
-- Name: TABLE mdl_tag_correlation; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tag_correlation IS 'The rationale for the ''tag_correlation'' table is performance.   It works as a cache for a potentially heavy load query done at the ''tag_instance'' table.   So, the ''tag_correlation'' table stores redundant information derived from the ''tag_instance'' ta';


--
-- Name: mdl_tag_correlation_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tag_correlation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tag_correlation_id_seq OWNER TO postgres;

--
-- Name: mdl_tag_correlation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tag_correlation_id_seq OWNED BY public.mdl_tag_correlation.id;


--
-- Name: mdl_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tag_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tag_id_seq OWNER TO postgres;

--
-- Name: mdl_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tag_id_seq OWNED BY public.mdl_tag.id;


--
-- Name: mdl_tag_instance; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tag_instance (
    id bigint NOT NULL,
    tagid bigint NOT NULL,
    component character varying(100) DEFAULT ''::character varying NOT NULL,
    itemtype character varying(100) DEFAULT ''::character varying NOT NULL,
    itemid bigint NOT NULL,
    contextid bigint,
    tiuserid bigint DEFAULT 0 NOT NULL,
    ordering bigint,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_tag_instance OWNER TO postgres;

--
-- Name: TABLE mdl_tag_instance; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tag_instance IS 'tag_instance table holds the information of associations between tags and other items';


--
-- Name: mdl_tag_instance_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tag_instance_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tag_instance_id_seq OWNER TO postgres;

--
-- Name: mdl_tag_instance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tag_instance_id_seq OWNED BY public.mdl_tag_instance.id;


--
-- Name: mdl_task_adhoc; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_task_adhoc (
    id bigint NOT NULL,
    component character varying(255) DEFAULT ''::character varying NOT NULL,
    classname character varying(255) DEFAULT ''::character varying NOT NULL,
    nextruntime bigint NOT NULL,
    faildelay bigint,
    customdata text,
    userid bigint,
    blocking smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_task_adhoc OWNER TO postgres;

--
-- Name: TABLE mdl_task_adhoc; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_task_adhoc IS 'List of adhoc tasks waiting to run.';


--
-- Name: mdl_task_adhoc_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_task_adhoc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_task_adhoc_id_seq OWNER TO postgres;

--
-- Name: mdl_task_adhoc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_task_adhoc_id_seq OWNED BY public.mdl_task_adhoc.id;


--
-- Name: mdl_task_log; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_task_log (
    id bigint NOT NULL,
    type smallint NOT NULL,
    component character varying(255) DEFAULT ''::character varying NOT NULL,
    classname character varying(255) DEFAULT ''::character varying NOT NULL,
    userid bigint NOT NULL,
    timestart numeric(20,10) NOT NULL,
    timeend numeric(20,10) NOT NULL,
    dbreads bigint NOT NULL,
    dbwrites bigint NOT NULL,
    result smallint NOT NULL,
    output text NOT NULL
);


ALTER TABLE public.mdl_task_log OWNER TO postgres;

--
-- Name: TABLE mdl_task_log; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_task_log IS 'The log table for all tasks';


--
-- Name: mdl_task_log_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_task_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_task_log_id_seq OWNER TO postgres;

--
-- Name: mdl_task_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_task_log_id_seq OWNED BY public.mdl_task_log.id;


--
-- Name: mdl_task_scheduled; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_task_scheduled (
    id bigint NOT NULL,
    component character varying(255) DEFAULT ''::character varying NOT NULL,
    classname character varying(255) DEFAULT ''::character varying NOT NULL,
    lastruntime bigint,
    nextruntime bigint,
    blocking smallint DEFAULT 0 NOT NULL,
    minute character varying(25) DEFAULT ''::character varying NOT NULL,
    hour character varying(25) DEFAULT ''::character varying NOT NULL,
    day character varying(25) DEFAULT ''::character varying NOT NULL,
    month character varying(25) DEFAULT ''::character varying NOT NULL,
    dayofweek character varying(25) DEFAULT ''::character varying NOT NULL,
    faildelay bigint,
    customised smallint DEFAULT 0 NOT NULL,
    disabled smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_task_scheduled OWNER TO postgres;

--
-- Name: TABLE mdl_task_scheduled; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_task_scheduled IS 'List of scheduled tasks to be run by cron.';


--
-- Name: mdl_task_scheduled_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_task_scheduled_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_task_scheduled_id_seq OWNER TO postgres;

--
-- Name: mdl_task_scheduled_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_task_scheduled_id_seq OWNED BY public.mdl_task_scheduled.id;


--
-- Name: mdl_tool_cohortroles; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_cohortroles (
    id bigint NOT NULL,
    cohortid bigint NOT NULL,
    roleid bigint NOT NULL,
    userid bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    usermodified bigint
);


ALTER TABLE public.mdl_tool_cohortroles OWNER TO postgres;

--
-- Name: TABLE mdl_tool_cohortroles; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_cohortroles IS 'Mapping of users to cohort role assignments.';


--
-- Name: mdl_tool_cohortroles_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_cohortroles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_cohortroles_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_cohortroles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_cohortroles_id_seq OWNED BY public.mdl_tool_cohortroles.id;


--
-- Name: mdl_tool_customlang; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_customlang (
    id bigint NOT NULL,
    lang character varying(20) DEFAULT ''::character varying NOT NULL,
    componentid bigint NOT NULL,
    stringid character varying(255) DEFAULT ''::character varying NOT NULL,
    original text NOT NULL,
    master text,
    local text,
    timemodified bigint NOT NULL,
    timecustomized bigint,
    outdated smallint DEFAULT 0,
    modified smallint DEFAULT 0
);


ALTER TABLE public.mdl_tool_customlang OWNER TO postgres;

--
-- Name: TABLE mdl_tool_customlang; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_customlang IS 'Contains the working checkout of all strings and their customization';


--
-- Name: mdl_tool_customlang_components; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_customlang_components (
    id bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    version character varying(255)
);


ALTER TABLE public.mdl_tool_customlang_components OWNER TO postgres;

--
-- Name: TABLE mdl_tool_customlang_components; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_customlang_components IS 'Contains the list of all installed plugins that provide their own language pack';


--
-- Name: mdl_tool_customlang_components_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_customlang_components_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_customlang_components_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_customlang_components_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_customlang_components_id_seq OWNED BY public.mdl_tool_customlang_components.id;


--
-- Name: mdl_tool_customlang_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_customlang_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_customlang_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_customlang_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_customlang_id_seq OWNED BY public.mdl_tool_customlang.id;


--
-- Name: mdl_tool_dataprivacy_category; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_dataprivacy_category (
    id bigint NOT NULL,
    name character varying(100) DEFAULT ''::character varying NOT NULL,
    description text,
    descriptionformat smallint,
    usermodified bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_tool_dataprivacy_category OWNER TO postgres;

--
-- Name: TABLE mdl_tool_dataprivacy_category; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_dataprivacy_category IS 'Data categories';


--
-- Name: mdl_tool_dataprivacy_category_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_dataprivacy_category_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_dataprivacy_category_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_dataprivacy_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_dataprivacy_category_id_seq OWNED BY public.mdl_tool_dataprivacy_category.id;


--
-- Name: mdl_tool_dataprivacy_ctxexpired; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_dataprivacy_ctxexpired (
    id bigint NOT NULL,
    contextid bigint NOT NULL,
    unexpiredroles text,
    expiredroles text,
    defaultexpired smallint NOT NULL,
    status smallint DEFAULT 0 NOT NULL,
    usermodified bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_tool_dataprivacy_ctxexpired OWNER TO postgres;

--
-- Name: TABLE mdl_tool_dataprivacy_ctxexpired; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_dataprivacy_ctxexpired IS 'Default comment for the table, please edit me';


--
-- Name: mdl_tool_dataprivacy_ctxexpired_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_dataprivacy_ctxexpired_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_dataprivacy_ctxexpired_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_dataprivacy_ctxexpired_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_dataprivacy_ctxexpired_id_seq OWNED BY public.mdl_tool_dataprivacy_ctxexpired.id;


--
-- Name: mdl_tool_dataprivacy_ctxinstance; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_dataprivacy_ctxinstance (
    id bigint NOT NULL,
    contextid bigint NOT NULL,
    purposeid bigint,
    categoryid bigint,
    usermodified bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_tool_dataprivacy_ctxinstance OWNER TO postgres;

--
-- Name: TABLE mdl_tool_dataprivacy_ctxinstance; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_dataprivacy_ctxinstance IS 'Default comment for the table, please edit me';


--
-- Name: mdl_tool_dataprivacy_ctxinstance_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_dataprivacy_ctxinstance_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_dataprivacy_ctxinstance_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_dataprivacy_ctxinstance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_dataprivacy_ctxinstance_id_seq OWNED BY public.mdl_tool_dataprivacy_ctxinstance.id;


--
-- Name: mdl_tool_dataprivacy_ctxlevel; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_dataprivacy_ctxlevel (
    id bigint NOT NULL,
    contextlevel smallint NOT NULL,
    purposeid bigint,
    categoryid bigint,
    usermodified bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_tool_dataprivacy_ctxlevel OWNER TO postgres;

--
-- Name: TABLE mdl_tool_dataprivacy_ctxlevel; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_dataprivacy_ctxlevel IS 'Default comment for the table, please edit me';


--
-- Name: mdl_tool_dataprivacy_ctxlevel_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_dataprivacy_ctxlevel_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_dataprivacy_ctxlevel_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_dataprivacy_ctxlevel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_dataprivacy_ctxlevel_id_seq OWNED BY public.mdl_tool_dataprivacy_ctxlevel.id;


--
-- Name: mdl_tool_dataprivacy_purpose; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_dataprivacy_purpose (
    id bigint NOT NULL,
    name character varying(100) DEFAULT ''::character varying NOT NULL,
    description text,
    descriptionformat smallint,
    lawfulbases text NOT NULL,
    sensitivedatareasons text,
    retentionperiod character varying(255) DEFAULT ''::character varying NOT NULL,
    protected smallint,
    usermodified bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_tool_dataprivacy_purpose OWNER TO postgres;

--
-- Name: TABLE mdl_tool_dataprivacy_purpose; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_dataprivacy_purpose IS 'Data purposes';


--
-- Name: mdl_tool_dataprivacy_purpose_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_dataprivacy_purpose_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_dataprivacy_purpose_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_dataprivacy_purpose_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_dataprivacy_purpose_id_seq OWNED BY public.mdl_tool_dataprivacy_purpose.id;


--
-- Name: mdl_tool_dataprivacy_purposerole; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_dataprivacy_purposerole (
    id bigint NOT NULL,
    purposeid bigint NOT NULL,
    roleid bigint NOT NULL,
    lawfulbases text,
    sensitivedatareasons text,
    retentionperiod character varying(255) DEFAULT ''::character varying NOT NULL,
    protected smallint,
    usermodified bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_tool_dataprivacy_purposerole OWNER TO postgres;

--
-- Name: TABLE mdl_tool_dataprivacy_purposerole; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_dataprivacy_purposerole IS 'Data purpose overrides for a specific role';


--
-- Name: mdl_tool_dataprivacy_purposerole_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_dataprivacy_purposerole_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_dataprivacy_purposerole_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_dataprivacy_purposerole_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_dataprivacy_purposerole_id_seq OWNED BY public.mdl_tool_dataprivacy_purposerole.id;


--
-- Name: mdl_tool_dataprivacy_request; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_dataprivacy_request (
    id bigint NOT NULL,
    type bigint DEFAULT 0 NOT NULL,
    comments text,
    commentsformat smallint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    requestedby bigint DEFAULT 0 NOT NULL,
    status smallint DEFAULT 0 NOT NULL,
    dpo bigint DEFAULT 0,
    dpocomment text,
    dpocommentformat smallint DEFAULT 0 NOT NULL,
    systemapproved smallint DEFAULT 0 NOT NULL,
    usermodified bigint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    creationmethod bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_tool_dataprivacy_request OWNER TO postgres;

--
-- Name: TABLE mdl_tool_dataprivacy_request; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_dataprivacy_request IS 'Table for data requests';


--
-- Name: mdl_tool_dataprivacy_request_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_dataprivacy_request_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_dataprivacy_request_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_dataprivacy_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_dataprivacy_request_id_seq OWNED BY public.mdl_tool_dataprivacy_request.id;


--
-- Name: mdl_tool_monitor_events; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_monitor_events (
    id bigint NOT NULL,
    eventname character varying(254) DEFAULT ''::character varying NOT NULL,
    contextid bigint NOT NULL,
    contextlevel bigint NOT NULL,
    contextinstanceid bigint NOT NULL,
    link character varying(254) DEFAULT ''::character varying NOT NULL,
    courseid bigint NOT NULL,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_tool_monitor_events OWNER TO postgres;

--
-- Name: TABLE mdl_tool_monitor_events; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_monitor_events IS 'A table that keeps a log of events related to subscriptions';


--
-- Name: mdl_tool_monitor_events_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_monitor_events_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_monitor_events_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_monitor_events_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_monitor_events_id_seq OWNED BY public.mdl_tool_monitor_events.id;


--
-- Name: mdl_tool_monitor_history; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_monitor_history (
    id bigint NOT NULL,
    sid bigint NOT NULL,
    userid bigint NOT NULL,
    timesent bigint NOT NULL
);


ALTER TABLE public.mdl_tool_monitor_history OWNER TO postgres;

--
-- Name: TABLE mdl_tool_monitor_history; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_monitor_history IS 'Table to store history of message notifications sent';


--
-- Name: mdl_tool_monitor_history_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_monitor_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_monitor_history_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_monitor_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_monitor_history_id_seq OWNED BY public.mdl_tool_monitor_history.id;


--
-- Name: mdl_tool_monitor_rules; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_monitor_rules (
    id bigint NOT NULL,
    description text,
    descriptionformat smallint NOT NULL,
    name character varying(254) DEFAULT ''::character varying NOT NULL,
    userid bigint NOT NULL,
    courseid bigint NOT NULL,
    plugin character varying(254) DEFAULT ''::character varying NOT NULL,
    eventname character varying(254) DEFAULT ''::character varying NOT NULL,
    template text NOT NULL,
    templateformat smallint NOT NULL,
    frequency smallint NOT NULL,
    timewindow integer NOT NULL,
    timemodified bigint NOT NULL,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_tool_monitor_rules OWNER TO postgres;

--
-- Name: TABLE mdl_tool_monitor_rules; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_monitor_rules IS 'Table to store rules';


--
-- Name: mdl_tool_monitor_rules_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_monitor_rules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_monitor_rules_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_monitor_rules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_monitor_rules_id_seq OWNED BY public.mdl_tool_monitor_rules.id;


--
-- Name: mdl_tool_monitor_subscriptions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_monitor_subscriptions (
    id bigint NOT NULL,
    courseid bigint NOT NULL,
    ruleid bigint NOT NULL,
    cmid bigint NOT NULL,
    userid bigint NOT NULL,
    timecreated bigint NOT NULL,
    lastnotificationsent bigint DEFAULT 0 NOT NULL,
    inactivedate bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_tool_monitor_subscriptions OWNER TO postgres;

--
-- Name: TABLE mdl_tool_monitor_subscriptions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_monitor_subscriptions IS 'Table to store user subscriptions to various rules';


--
-- Name: mdl_tool_monitor_subscriptions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_monitor_subscriptions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_monitor_subscriptions_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_monitor_subscriptions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_monitor_subscriptions_id_seq OWNED BY public.mdl_tool_monitor_subscriptions.id;


--
-- Name: mdl_tool_policy; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_policy (
    id bigint NOT NULL,
    sortorder integer DEFAULT 999 NOT NULL,
    currentversionid bigint
);


ALTER TABLE public.mdl_tool_policy OWNER TO postgres;

--
-- Name: TABLE mdl_tool_policy; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_policy IS 'Contains the list of policy documents defined on the site.';


--
-- Name: mdl_tool_policy_acceptances; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_policy_acceptances (
    id bigint NOT NULL,
    policyversionid bigint NOT NULL,
    userid bigint NOT NULL,
    status smallint,
    lang character varying(30) DEFAULT ''::character varying NOT NULL,
    usermodified bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    note text
);


ALTER TABLE public.mdl_tool_policy_acceptances OWNER TO postgres;

--
-- Name: TABLE mdl_tool_policy_acceptances; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_policy_acceptances IS 'Tracks users accepting the policy versions';


--
-- Name: mdl_tool_policy_acceptances_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_policy_acceptances_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_policy_acceptances_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_policy_acceptances_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_policy_acceptances_id_seq OWNED BY public.mdl_tool_policy_acceptances.id;


--
-- Name: mdl_tool_policy_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_policy_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_policy_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_policy_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_policy_id_seq OWNED BY public.mdl_tool_policy.id;


--
-- Name: mdl_tool_policy_versions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_policy_versions (
    id bigint NOT NULL,
    name character varying(1333) DEFAULT ''::character varying NOT NULL,
    type smallint DEFAULT 0 NOT NULL,
    audience smallint DEFAULT 0 NOT NULL,
    archived smallint DEFAULT 0 NOT NULL,
    usermodified bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    policyid bigint NOT NULL,
    agreementstyle smallint DEFAULT 0 NOT NULL,
    optional smallint DEFAULT 0 NOT NULL,
    revision character varying(1333) DEFAULT ''::character varying NOT NULL,
    summary text NOT NULL,
    summaryformat smallint NOT NULL,
    content text NOT NULL,
    contentformat smallint NOT NULL
);


ALTER TABLE public.mdl_tool_policy_versions OWNER TO postgres;

--
-- Name: TABLE mdl_tool_policy_versions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_policy_versions IS 'Holds versions of the policy documents';


--
-- Name: mdl_tool_policy_versions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_policy_versions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_policy_versions_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_policy_versions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_policy_versions_id_seq OWNED BY public.mdl_tool_policy_versions.id;


--
-- Name: mdl_tool_recyclebin_category; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_recyclebin_category (
    id bigint NOT NULL,
    categoryid bigint NOT NULL,
    shortname character varying(255) DEFAULT ''::character varying NOT NULL,
    fullname character varying(255) DEFAULT ''::character varying NOT NULL,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_tool_recyclebin_category OWNER TO postgres;

--
-- Name: TABLE mdl_tool_recyclebin_category; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_recyclebin_category IS 'A list of items in the category recycle bin';


--
-- Name: mdl_tool_recyclebin_category_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_recyclebin_category_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_recyclebin_category_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_recyclebin_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_recyclebin_category_id_seq OWNED BY public.mdl_tool_recyclebin_category.id;


--
-- Name: mdl_tool_recyclebin_course; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_recyclebin_course (
    id bigint NOT NULL,
    courseid bigint NOT NULL,
    section bigint NOT NULL,
    module bigint NOT NULL,
    name character varying(255),
    timecreated bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_tool_recyclebin_course OWNER TO postgres;

--
-- Name: TABLE mdl_tool_recyclebin_course; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_recyclebin_course IS 'A list of items in the course recycle bin';


--
-- Name: mdl_tool_recyclebin_course_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_recyclebin_course_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_recyclebin_course_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_recyclebin_course_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_recyclebin_course_id_seq OWNED BY public.mdl_tool_recyclebin_course.id;


--
-- Name: mdl_tool_usertours_steps; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_usertours_steps (
    id bigint NOT NULL,
    tourid bigint NOT NULL,
    title text,
    content text,
    targettype smallint NOT NULL,
    targetvalue text NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL,
    configdata text NOT NULL
);


ALTER TABLE public.mdl_tool_usertours_steps OWNER TO postgres;

--
-- Name: TABLE mdl_tool_usertours_steps; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_usertours_steps IS 'Steps in an tour';


--
-- Name: mdl_tool_usertours_steps_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_usertours_steps_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_usertours_steps_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_usertours_steps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_usertours_steps_id_seq OWNED BY public.mdl_tool_usertours_steps.id;


--
-- Name: mdl_tool_usertours_tours; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_tool_usertours_tours (
    id bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    description text,
    pathmatch character varying(255),
    enabled smallint DEFAULT 0 NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL,
    configdata text NOT NULL
);


ALTER TABLE public.mdl_tool_usertours_tours OWNER TO postgres;

--
-- Name: TABLE mdl_tool_usertours_tours; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_tool_usertours_tours IS 'List of tours';


--
-- Name: mdl_tool_usertours_tours_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tool_usertours_tours_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tool_usertours_tours_id_seq OWNER TO postgres;

--
-- Name: mdl_tool_usertours_tours_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_tool_usertours_tours_id_seq OWNED BY public.mdl_tool_usertours_tours.id;


--
-- Name: mdl_upgrade_log; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_upgrade_log (
    id bigint NOT NULL,
    type bigint NOT NULL,
    plugin character varying(100),
    version character varying(100),
    targetversion character varying(100),
    info character varying(255) DEFAULT ''::character varying NOT NULL,
    details text,
    backtrace text,
    userid bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_upgrade_log OWNER TO postgres;

--
-- Name: TABLE mdl_upgrade_log; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_upgrade_log IS 'Upgrade logging';


--
-- Name: mdl_upgrade_log_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_upgrade_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_upgrade_log_id_seq OWNER TO postgres;

--
-- Name: mdl_upgrade_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_upgrade_log_id_seq OWNED BY public.mdl_upgrade_log.id;


--
-- Name: mdl_url; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_url (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text,
    introformat smallint DEFAULT 0 NOT NULL,
    externalurl text NOT NULL,
    display smallint DEFAULT 0 NOT NULL,
    displayoptions text,
    parameters text,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_url OWNER TO postgres;

--
-- Name: TABLE mdl_url; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_url IS 'each record is one url resource';


--
-- Name: mdl_url_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_url_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_url_id_seq OWNER TO postgres;

--
-- Name: mdl_url_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_url_id_seq OWNED BY public.mdl_url.id;


--
-- Name: mdl_user; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_user (
    id bigint NOT NULL,
    auth character varying(20) DEFAULT 'manual'::character varying NOT NULL,
    confirmed smallint DEFAULT 0 NOT NULL,
    policyagreed smallint DEFAULT 0 NOT NULL,
    deleted smallint DEFAULT 0 NOT NULL,
    suspended smallint DEFAULT 0 NOT NULL,
    mnethostid bigint DEFAULT 0 NOT NULL,
    username character varying(100) DEFAULT ''::character varying NOT NULL,
    password character varying(255) DEFAULT ''::character varying NOT NULL,
    idnumber character varying(255) DEFAULT ''::character varying NOT NULL,
    firstname character varying(100) DEFAULT ''::character varying NOT NULL,
    lastname character varying(100) DEFAULT ''::character varying NOT NULL,
    email character varying(100) DEFAULT ''::character varying NOT NULL,
    emailstop smallint DEFAULT 0 NOT NULL,
    icq character varying(15) DEFAULT ''::character varying NOT NULL,
    skype character varying(50) DEFAULT ''::character varying NOT NULL,
    yahoo character varying(50) DEFAULT ''::character varying NOT NULL,
    aim character varying(50) DEFAULT ''::character varying NOT NULL,
    msn character varying(50) DEFAULT ''::character varying NOT NULL,
    phone1 character varying(20) DEFAULT ''::character varying NOT NULL,
    phone2 character varying(20) DEFAULT ''::character varying NOT NULL,
    institution character varying(255) DEFAULT ''::character varying NOT NULL,
    department character varying(255) DEFAULT ''::character varying NOT NULL,
    address character varying(255) DEFAULT ''::character varying NOT NULL,
    city character varying(120) DEFAULT ''::character varying NOT NULL,
    country character varying(2) DEFAULT ''::character varying NOT NULL,
    lang character varying(30) DEFAULT 'en'::character varying NOT NULL,
    calendartype character varying(30) DEFAULT 'gregorian'::character varying NOT NULL,
    theme character varying(50) DEFAULT ''::character varying NOT NULL,
    timezone character varying(100) DEFAULT '99'::character varying NOT NULL,
    firstaccess bigint DEFAULT 0 NOT NULL,
    lastaccess bigint DEFAULT 0 NOT NULL,
    lastlogin bigint DEFAULT 0 NOT NULL,
    currentlogin bigint DEFAULT 0 NOT NULL,
    lastip character varying(45) DEFAULT ''::character varying NOT NULL,
    secret character varying(15) DEFAULT ''::character varying NOT NULL,
    picture bigint DEFAULT 0 NOT NULL,
    url character varying(255) DEFAULT ''::character varying NOT NULL,
    description text,
    descriptionformat smallint DEFAULT 1 NOT NULL,
    mailformat smallint DEFAULT 1 NOT NULL,
    maildigest smallint DEFAULT 0 NOT NULL,
    maildisplay smallint DEFAULT 2 NOT NULL,
    autosubscribe smallint DEFAULT 1 NOT NULL,
    trackforums smallint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    trustbitmask bigint DEFAULT 0 NOT NULL,
    imagealt character varying(255),
    lastnamephonetic character varying(255),
    firstnamephonetic character varying(255),
    middlename character varying(255),
    alternatename character varying(255),
    moodlenetprofile character varying(255)
);


ALTER TABLE public.mdl_user OWNER TO postgres;

--
-- Name: TABLE mdl_user; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_user IS 'One record for each person';


--
-- Name: mdl_user_devices; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_user_devices (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    appid character varying(128) DEFAULT ''::character varying NOT NULL,
    name character varying(32) DEFAULT ''::character varying NOT NULL,
    model character varying(32) DEFAULT ''::character varying NOT NULL,
    platform character varying(32) DEFAULT ''::character varying NOT NULL,
    version character varying(32) DEFAULT ''::character varying NOT NULL,
    pushid character varying(255) DEFAULT ''::character varying NOT NULL,
    uuid character varying(255) DEFAULT ''::character varying NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL
);


ALTER TABLE public.mdl_user_devices OWNER TO postgres;

--
-- Name: TABLE mdl_user_devices; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_user_devices IS 'This table stores user''s mobile devices information in order to send PUSH notifications';


--
-- Name: mdl_user_devices_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_devices_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_devices_id_seq OWNER TO postgres;

--
-- Name: mdl_user_devices_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_user_devices_id_seq OWNED BY public.mdl_user_devices.id;


--
-- Name: mdl_user_enrolments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_user_enrolments (
    id bigint NOT NULL,
    status bigint DEFAULT 0 NOT NULL,
    enrolid bigint NOT NULL,
    userid bigint NOT NULL,
    timestart bigint DEFAULT 0 NOT NULL,
    timeend bigint DEFAULT 2147483647 NOT NULL,
    modifierid bigint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_user_enrolments OWNER TO postgres;

--
-- Name: TABLE mdl_user_enrolments; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_user_enrolments IS 'Users participating in courses (aka enrolled users) - everybody who is participating/visible in course, that means both teachers and students';


--
-- Name: mdl_user_enrolments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_enrolments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_enrolments_id_seq OWNER TO postgres;

--
-- Name: mdl_user_enrolments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_user_enrolments_id_seq OWNED BY public.mdl_user_enrolments.id;


--
-- Name: mdl_user_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_id_seq OWNER TO postgres;

--
-- Name: mdl_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_user_id_seq OWNED BY public.mdl_user.id;


--
-- Name: mdl_user_info_category; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_user_info_category (
    id bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_user_info_category OWNER TO postgres;

--
-- Name: TABLE mdl_user_info_category; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_user_info_category IS 'Customisable fields categories';


--
-- Name: mdl_user_info_category_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_info_category_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_info_category_id_seq OWNER TO postgres;

--
-- Name: mdl_user_info_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_user_info_category_id_seq OWNED BY public.mdl_user_info_category.id;


--
-- Name: mdl_user_info_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_user_info_data (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    fieldid bigint DEFAULT 0 NOT NULL,
    data text NOT NULL,
    dataformat smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_user_info_data OWNER TO postgres;

--
-- Name: TABLE mdl_user_info_data; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_user_info_data IS 'Data for the customisable user fields';


--
-- Name: mdl_user_info_data_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_info_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_info_data_id_seq OWNER TO postgres;

--
-- Name: mdl_user_info_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_user_info_data_id_seq OWNED BY public.mdl_user_info_data.id;


--
-- Name: mdl_user_info_field; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_user_info_field (
    id bigint NOT NULL,
    shortname character varying(255) DEFAULT 'shortname'::character varying NOT NULL,
    name text NOT NULL,
    datatype character varying(255) DEFAULT ''::character varying NOT NULL,
    description text,
    descriptionformat smallint DEFAULT 0 NOT NULL,
    categoryid bigint DEFAULT 0 NOT NULL,
    sortorder bigint DEFAULT 0 NOT NULL,
    required smallint DEFAULT 0 NOT NULL,
    locked smallint DEFAULT 0 NOT NULL,
    visible smallint DEFAULT 0 NOT NULL,
    forceunique smallint DEFAULT 0 NOT NULL,
    signup smallint DEFAULT 0 NOT NULL,
    defaultdata text,
    defaultdataformat smallint DEFAULT 0 NOT NULL,
    param1 text,
    param2 text,
    param3 text,
    param4 text,
    param5 text
);


ALTER TABLE public.mdl_user_info_field OWNER TO postgres;

--
-- Name: TABLE mdl_user_info_field; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_user_info_field IS 'Customisable user profile fields';


--
-- Name: mdl_user_info_field_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_info_field_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_info_field_id_seq OWNER TO postgres;

--
-- Name: mdl_user_info_field_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_user_info_field_id_seq OWNED BY public.mdl_user_info_field.id;


--
-- Name: mdl_user_lastaccess; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_user_lastaccess (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    courseid bigint DEFAULT 0 NOT NULL,
    timeaccess bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_user_lastaccess OWNER TO postgres;

--
-- Name: TABLE mdl_user_lastaccess; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_user_lastaccess IS 'To keep track of course page access times, used in online participants block, and participants list';


--
-- Name: mdl_user_lastaccess_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_lastaccess_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_lastaccess_id_seq OWNER TO postgres;

--
-- Name: mdl_user_lastaccess_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_user_lastaccess_id_seq OWNED BY public.mdl_user_lastaccess.id;


--
-- Name: mdl_user_password_history; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_user_password_history (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    hash character varying(255) DEFAULT ''::character varying NOT NULL,
    timecreated bigint NOT NULL
);


ALTER TABLE public.mdl_user_password_history OWNER TO postgres;

--
-- Name: TABLE mdl_user_password_history; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_user_password_history IS 'A rotating log of hashes of previously used passwords for each user.';


--
-- Name: mdl_user_password_history_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_password_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_password_history_id_seq OWNER TO postgres;

--
-- Name: mdl_user_password_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_user_password_history_id_seq OWNED BY public.mdl_user_password_history.id;


--
-- Name: mdl_user_password_resets; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_user_password_resets (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    timerequested bigint NOT NULL,
    timererequested bigint DEFAULT 0 NOT NULL,
    token character varying(32) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_user_password_resets OWNER TO postgres;

--
-- Name: TABLE mdl_user_password_resets; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_user_password_resets IS 'table tracking password reset confirmation tokens';


--
-- Name: mdl_user_password_resets_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_password_resets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_password_resets_id_seq OWNER TO postgres;

--
-- Name: mdl_user_password_resets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_user_password_resets_id_seq OWNED BY public.mdl_user_password_resets.id;


--
-- Name: mdl_user_preferences; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_user_preferences (
    id bigint NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    value character varying(1333) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mdl_user_preferences OWNER TO postgres;

--
-- Name: TABLE mdl_user_preferences; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_user_preferences IS 'Allows modules to store arbitrary user preferences';


--
-- Name: mdl_user_preferences_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_preferences_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_preferences_id_seq OWNER TO postgres;

--
-- Name: mdl_user_preferences_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_user_preferences_id_seq OWNED BY public.mdl_user_preferences.id;


--
-- Name: mdl_user_private_key; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_user_private_key (
    id bigint NOT NULL,
    script character varying(128) DEFAULT ''::character varying NOT NULL,
    value character varying(128) DEFAULT ''::character varying NOT NULL,
    userid bigint NOT NULL,
    instance bigint,
    iprestriction character varying(255),
    validuntil bigint,
    timecreated bigint
);


ALTER TABLE public.mdl_user_private_key OWNER TO postgres;

--
-- Name: TABLE mdl_user_private_key; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_user_private_key IS 'access keys used in cookieless scripts - rss, etc.';


--
-- Name: mdl_user_private_key_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_private_key_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_private_key_id_seq OWNER TO postgres;

--
-- Name: mdl_user_private_key_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_user_private_key_id_seq OWNED BY public.mdl_user_private_key.id;


--
-- Name: mdl_wiki; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_wiki (
    id bigint NOT NULL,
    course bigint DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT 'Wiki'::character varying NOT NULL,
    intro text,
    introformat smallint DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    firstpagetitle character varying(255) DEFAULT 'First Page'::character varying NOT NULL,
    wikimode character varying(20) DEFAULT 'collaborative'::character varying NOT NULL,
    defaultformat character varying(20) DEFAULT 'creole'::character varying NOT NULL,
    forceformat smallint DEFAULT 1 NOT NULL,
    editbegin bigint DEFAULT 0 NOT NULL,
    editend bigint DEFAULT 0
);


ALTER TABLE public.mdl_wiki OWNER TO postgres;

--
-- Name: TABLE mdl_wiki; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_wiki IS 'Stores Wiki activity configuration';


--
-- Name: mdl_wiki_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_wiki_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_wiki_id_seq OWNER TO postgres;

--
-- Name: mdl_wiki_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_wiki_id_seq OWNED BY public.mdl_wiki.id;


--
-- Name: mdl_wiki_links; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_wiki_links (
    id bigint NOT NULL,
    subwikiid bigint DEFAULT 0 NOT NULL,
    frompageid bigint DEFAULT 0 NOT NULL,
    topageid bigint DEFAULT 0 NOT NULL,
    tomissingpage character varying(255)
);


ALTER TABLE public.mdl_wiki_links OWNER TO postgres;

--
-- Name: TABLE mdl_wiki_links; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_wiki_links IS 'Page wiki links';


--
-- Name: mdl_wiki_links_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_wiki_links_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_wiki_links_id_seq OWNER TO postgres;

--
-- Name: mdl_wiki_links_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_wiki_links_id_seq OWNED BY public.mdl_wiki_links.id;


--
-- Name: mdl_wiki_locks; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_wiki_locks (
    id bigint NOT NULL,
    pageid bigint DEFAULT 0 NOT NULL,
    sectionname character varying(255),
    userid bigint DEFAULT 0 NOT NULL,
    lockedat bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_wiki_locks OWNER TO postgres;

--
-- Name: TABLE mdl_wiki_locks; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_wiki_locks IS 'Manages page locks';


--
-- Name: mdl_wiki_locks_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_wiki_locks_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_wiki_locks_id_seq OWNER TO postgres;

--
-- Name: mdl_wiki_locks_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_wiki_locks_id_seq OWNED BY public.mdl_wiki_locks.id;


--
-- Name: mdl_wiki_pages; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_wiki_pages (
    id bigint NOT NULL,
    subwikiid bigint DEFAULT 0 NOT NULL,
    title character varying(255) DEFAULT 'title'::character varying NOT NULL,
    cachedcontent text NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    timemodified bigint DEFAULT 0 NOT NULL,
    timerendered bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL,
    pageviews bigint DEFAULT 0 NOT NULL,
    readonly smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_wiki_pages OWNER TO postgres;

--
-- Name: TABLE mdl_wiki_pages; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_wiki_pages IS 'Stores wiki pages';


--
-- Name: mdl_wiki_pages_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_wiki_pages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_wiki_pages_id_seq OWNER TO postgres;

--
-- Name: mdl_wiki_pages_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_wiki_pages_id_seq OWNED BY public.mdl_wiki_pages.id;


--
-- Name: mdl_wiki_subwikis; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_wiki_subwikis (
    id bigint NOT NULL,
    wikiid bigint DEFAULT 0 NOT NULL,
    groupid bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_wiki_subwikis OWNER TO postgres;

--
-- Name: TABLE mdl_wiki_subwikis; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_wiki_subwikis IS 'Stores subwiki instances';


--
-- Name: mdl_wiki_subwikis_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_wiki_subwikis_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_wiki_subwikis_id_seq OWNER TO postgres;

--
-- Name: mdl_wiki_subwikis_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_wiki_subwikis_id_seq OWNED BY public.mdl_wiki_subwikis.id;


--
-- Name: mdl_wiki_synonyms; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_wiki_synonyms (
    id bigint NOT NULL,
    subwikiid bigint DEFAULT 0 NOT NULL,
    pageid bigint DEFAULT 0 NOT NULL,
    pagesynonym character varying(255) DEFAULT 'Pagesynonym'::character varying NOT NULL
);


ALTER TABLE public.mdl_wiki_synonyms OWNER TO postgres;

--
-- Name: TABLE mdl_wiki_synonyms; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_wiki_synonyms IS 'Stores wiki pages synonyms';


--
-- Name: mdl_wiki_synonyms_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_wiki_synonyms_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_wiki_synonyms_id_seq OWNER TO postgres;

--
-- Name: mdl_wiki_synonyms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_wiki_synonyms_id_seq OWNED BY public.mdl_wiki_synonyms.id;


--
-- Name: mdl_wiki_versions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_wiki_versions (
    id bigint NOT NULL,
    pageid bigint DEFAULT 0 NOT NULL,
    content text NOT NULL,
    contentformat character varying(20) DEFAULT 'creole'::character varying NOT NULL,
    version integer DEFAULT 0 NOT NULL,
    timecreated bigint DEFAULT 0 NOT NULL,
    userid bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_wiki_versions OWNER TO postgres;

--
-- Name: TABLE mdl_wiki_versions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_wiki_versions IS 'Stores wiki page history';


--
-- Name: mdl_wiki_versions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_wiki_versions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_wiki_versions_id_seq OWNER TO postgres;

--
-- Name: mdl_wiki_versions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_wiki_versions_id_seq OWNED BY public.mdl_wiki_versions.id;


--
-- Name: mdl_workshop; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_workshop (
    id bigint NOT NULL,
    course bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    intro text,
    introformat smallint DEFAULT 0 NOT NULL,
    instructauthors text,
    instructauthorsformat smallint DEFAULT 0 NOT NULL,
    instructreviewers text,
    instructreviewersformat smallint DEFAULT 0 NOT NULL,
    timemodified bigint NOT NULL,
    phase smallint DEFAULT 0,
    useexamples smallint DEFAULT 0,
    usepeerassessment smallint DEFAULT 0,
    useselfassessment smallint DEFAULT 0,
    grade numeric(10,5) DEFAULT 80,
    gradinggrade numeric(10,5) DEFAULT 20,
    strategy character varying(30) DEFAULT ''::character varying NOT NULL,
    evaluation character varying(30) DEFAULT ''::character varying NOT NULL,
    gradedecimals smallint DEFAULT 0,
    submissiontypetext smallint DEFAULT 1 NOT NULL,
    submissiontypefile smallint DEFAULT 1 NOT NULL,
    nattachments smallint DEFAULT 1,
    submissionfiletypes character varying(255),
    latesubmissions smallint DEFAULT 0,
    maxbytes bigint DEFAULT 100000,
    examplesmode smallint DEFAULT 0,
    submissionstart bigint DEFAULT 0,
    submissionend bigint DEFAULT 0,
    assessmentstart bigint DEFAULT 0,
    assessmentend bigint DEFAULT 0,
    phaseswitchassessment smallint DEFAULT 0 NOT NULL,
    conclusion text,
    conclusionformat smallint DEFAULT 1 NOT NULL,
    overallfeedbackmode smallint DEFAULT 1,
    overallfeedbackfiles smallint DEFAULT 0,
    overallfeedbackfiletypes character varying(255),
    overallfeedbackmaxbytes bigint DEFAULT 100000
);


ALTER TABLE public.mdl_workshop OWNER TO postgres;

--
-- Name: TABLE mdl_workshop; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_workshop IS 'This table keeps information about the module instances and their settings';


--
-- Name: mdl_workshop_aggregations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_workshop_aggregations (
    id bigint NOT NULL,
    workshopid bigint NOT NULL,
    userid bigint NOT NULL,
    gradinggrade numeric(10,5),
    timegraded bigint
);


ALTER TABLE public.mdl_workshop_aggregations OWNER TO postgres;

--
-- Name: TABLE mdl_workshop_aggregations; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_workshop_aggregations IS 'Aggregated grades for assessment are stored here. The aggregated grade for submission is stored in workshop_submissions';


--
-- Name: mdl_workshop_aggregations_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshop_aggregations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshop_aggregations_id_seq OWNER TO postgres;

--
-- Name: mdl_workshop_aggregations_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_workshop_aggregations_id_seq OWNED BY public.mdl_workshop_aggregations.id;


--
-- Name: mdl_workshop_assessments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_workshop_assessments (
    id bigint NOT NULL,
    submissionid bigint NOT NULL,
    reviewerid bigint NOT NULL,
    weight bigint DEFAULT 1 NOT NULL,
    timecreated bigint DEFAULT 0,
    timemodified bigint DEFAULT 0,
    grade numeric(10,5),
    gradinggrade numeric(10,5),
    gradinggradeover numeric(10,5),
    gradinggradeoverby bigint,
    feedbackauthor text,
    feedbackauthorformat smallint DEFAULT 0,
    feedbackauthorattachment smallint DEFAULT 0,
    feedbackreviewer text,
    feedbackreviewerformat smallint DEFAULT 0
);


ALTER TABLE public.mdl_workshop_assessments OWNER TO postgres;

--
-- Name: TABLE mdl_workshop_assessments; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_workshop_assessments IS 'Info about the made assessment and automatically calculated grade for it. The proposed grade can be overridden by teacher.';


--
-- Name: mdl_workshop_assessments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshop_assessments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshop_assessments_id_seq OWNER TO postgres;

--
-- Name: mdl_workshop_assessments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_workshop_assessments_id_seq OWNED BY public.mdl_workshop_assessments.id;


--
-- Name: mdl_workshop_grades; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_workshop_grades (
    id bigint NOT NULL,
    assessmentid bigint NOT NULL,
    strategy character varying(30) DEFAULT ''::character varying NOT NULL,
    dimensionid bigint NOT NULL,
    grade numeric(10,5) NOT NULL,
    peercomment text,
    peercommentformat smallint DEFAULT 0
);


ALTER TABLE public.mdl_workshop_grades OWNER TO postgres;

--
-- Name: TABLE mdl_workshop_grades; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_workshop_grades IS 'How the reviewers filled-up the grading forms, given grades and comments';


--
-- Name: mdl_workshop_grades_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshop_grades_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshop_grades_id_seq OWNER TO postgres;

--
-- Name: mdl_workshop_grades_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_workshop_grades_id_seq OWNED BY public.mdl_workshop_grades.id;


--
-- Name: mdl_workshop_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshop_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshop_id_seq OWNER TO postgres;

--
-- Name: mdl_workshop_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_workshop_id_seq OWNED BY public.mdl_workshop.id;


--
-- Name: mdl_workshop_submissions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_workshop_submissions (
    id bigint NOT NULL,
    workshopid bigint NOT NULL,
    example smallint DEFAULT 0,
    authorid bigint NOT NULL,
    timecreated bigint NOT NULL,
    timemodified bigint NOT NULL,
    title character varying(255) DEFAULT ''::character varying NOT NULL,
    content text,
    contentformat smallint DEFAULT 0 NOT NULL,
    contenttrust smallint DEFAULT 0 NOT NULL,
    attachment smallint DEFAULT 0,
    grade numeric(10,5),
    gradeover numeric(10,5),
    gradeoverby bigint,
    feedbackauthor text,
    feedbackauthorformat smallint DEFAULT 0,
    timegraded bigint,
    published smallint DEFAULT 0,
    late smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.mdl_workshop_submissions OWNER TO postgres;

--
-- Name: TABLE mdl_workshop_submissions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_workshop_submissions IS 'Info about the submission and the aggregation of the grade for submission, grade for assessment and final grade. Both grade for submission and grade for assessment can be overridden by teacher. Final grade is always the sum of them. All grades are st';


--
-- Name: mdl_workshop_submissions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshop_submissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshop_submissions_id_seq OWNER TO postgres;

--
-- Name: mdl_workshop_submissions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_workshop_submissions_id_seq OWNED BY public.mdl_workshop_submissions.id;


--
-- Name: mdl_workshopallocation_scheduled; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_workshopallocation_scheduled (
    id bigint NOT NULL,
    workshopid bigint NOT NULL,
    enabled smallint DEFAULT 0 NOT NULL,
    submissionend bigint NOT NULL,
    timeallocated bigint,
    settings text,
    resultstatus bigint,
    resultmessage character varying(1333),
    resultlog text
);


ALTER TABLE public.mdl_workshopallocation_scheduled OWNER TO postgres;

--
-- Name: TABLE mdl_workshopallocation_scheduled; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_workshopallocation_scheduled IS 'Stores the allocation settings for the scheduled allocator';


--
-- Name: mdl_workshopallocation_scheduled_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshopallocation_scheduled_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshopallocation_scheduled_id_seq OWNER TO postgres;

--
-- Name: mdl_workshopallocation_scheduled_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_workshopallocation_scheduled_id_seq OWNED BY public.mdl_workshopallocation_scheduled.id;


--
-- Name: mdl_workshopeval_best_settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_workshopeval_best_settings (
    id bigint NOT NULL,
    workshopid bigint NOT NULL,
    comparison smallint DEFAULT 5
);


ALTER TABLE public.mdl_workshopeval_best_settings OWNER TO postgres;

--
-- Name: TABLE mdl_workshopeval_best_settings; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_workshopeval_best_settings IS 'Settings for the grading evaluation subplugin Comparison with the best assessment.';


--
-- Name: mdl_workshopeval_best_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshopeval_best_settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshopeval_best_settings_id_seq OWNER TO postgres;

--
-- Name: mdl_workshopeval_best_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_workshopeval_best_settings_id_seq OWNED BY public.mdl_workshopeval_best_settings.id;


--
-- Name: mdl_workshopform_accumulative; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_workshopform_accumulative (
    id bigint NOT NULL,
    workshopid bigint NOT NULL,
    sort bigint DEFAULT 0,
    description text,
    descriptionformat smallint DEFAULT 0,
    grade bigint NOT NULL,
    weight integer DEFAULT 1
);


ALTER TABLE public.mdl_workshopform_accumulative OWNER TO postgres;

--
-- Name: TABLE mdl_workshopform_accumulative; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_workshopform_accumulative IS 'The assessment dimensions definitions of Accumulative grading strategy forms';


--
-- Name: mdl_workshopform_accumulative_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshopform_accumulative_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshopform_accumulative_id_seq OWNER TO postgres;

--
-- Name: mdl_workshopform_accumulative_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_workshopform_accumulative_id_seq OWNED BY public.mdl_workshopform_accumulative.id;


--
-- Name: mdl_workshopform_comments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_workshopform_comments (
    id bigint NOT NULL,
    workshopid bigint NOT NULL,
    sort bigint DEFAULT 0,
    description text,
    descriptionformat smallint DEFAULT 0
);


ALTER TABLE public.mdl_workshopform_comments OWNER TO postgres;

--
-- Name: TABLE mdl_workshopform_comments; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_workshopform_comments IS 'The assessment dimensions definitions of Comments strategy forms';


--
-- Name: mdl_workshopform_comments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshopform_comments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshopform_comments_id_seq OWNER TO postgres;

--
-- Name: mdl_workshopform_comments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_workshopform_comments_id_seq OWNED BY public.mdl_workshopform_comments.id;


--
-- Name: mdl_workshopform_numerrors; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_workshopform_numerrors (
    id bigint NOT NULL,
    workshopid bigint NOT NULL,
    sort bigint DEFAULT 0,
    description text,
    descriptionformat smallint DEFAULT 0,
    descriptiontrust bigint,
    grade0 character varying(50),
    grade1 character varying(50),
    weight integer DEFAULT 1
);


ALTER TABLE public.mdl_workshopform_numerrors OWNER TO postgres;

--
-- Name: TABLE mdl_workshopform_numerrors; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_workshopform_numerrors IS 'The assessment dimensions definitions of Number of errors grading strategy forms';


--
-- Name: mdl_workshopform_numerrors_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshopform_numerrors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshopform_numerrors_id_seq OWNER TO postgres;

--
-- Name: mdl_workshopform_numerrors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_workshopform_numerrors_id_seq OWNED BY public.mdl_workshopform_numerrors.id;


--
-- Name: mdl_workshopform_numerrors_map; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_workshopform_numerrors_map (
    id bigint NOT NULL,
    workshopid bigint NOT NULL,
    nonegative bigint NOT NULL,
    grade numeric(10,5) NOT NULL
);


ALTER TABLE public.mdl_workshopform_numerrors_map OWNER TO postgres;

--
-- Name: TABLE mdl_workshopform_numerrors_map; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_workshopform_numerrors_map IS 'This maps the number of errors to a percentual grade for submission';


--
-- Name: mdl_workshopform_numerrors_map_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshopform_numerrors_map_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshopform_numerrors_map_id_seq OWNER TO postgres;

--
-- Name: mdl_workshopform_numerrors_map_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_workshopform_numerrors_map_id_seq OWNED BY public.mdl_workshopform_numerrors_map.id;


--
-- Name: mdl_workshopform_rubric; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_workshopform_rubric (
    id bigint NOT NULL,
    workshopid bigint NOT NULL,
    sort bigint DEFAULT 0,
    description text,
    descriptionformat smallint DEFAULT 0
);


ALTER TABLE public.mdl_workshopform_rubric OWNER TO postgres;

--
-- Name: TABLE mdl_workshopform_rubric; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_workshopform_rubric IS 'The assessment dimensions definitions of Rubric grading strategy forms';


--
-- Name: mdl_workshopform_rubric_config; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_workshopform_rubric_config (
    id bigint NOT NULL,
    workshopid bigint NOT NULL,
    layout character varying(30) DEFAULT 'list'::character varying
);


ALTER TABLE public.mdl_workshopform_rubric_config OWNER TO postgres;

--
-- Name: TABLE mdl_workshopform_rubric_config; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_workshopform_rubric_config IS 'Configuration table for the Rubric grading strategy';


--
-- Name: mdl_workshopform_rubric_config_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshopform_rubric_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshopform_rubric_config_id_seq OWNER TO postgres;

--
-- Name: mdl_workshopform_rubric_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_workshopform_rubric_config_id_seq OWNED BY public.mdl_workshopform_rubric_config.id;


--
-- Name: mdl_workshopform_rubric_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshopform_rubric_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshopform_rubric_id_seq OWNER TO postgres;

--
-- Name: mdl_workshopform_rubric_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_workshopform_rubric_id_seq OWNED BY public.mdl_workshopform_rubric.id;


--
-- Name: mdl_workshopform_rubric_levels; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdl_workshopform_rubric_levels (
    id bigint NOT NULL,
    dimensionid bigint NOT NULL,
    grade numeric(10,5) NOT NULL,
    definition text,
    definitionformat smallint DEFAULT 0
);


ALTER TABLE public.mdl_workshopform_rubric_levels OWNER TO postgres;

--
-- Name: TABLE mdl_workshopform_rubric_levels; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.mdl_workshopform_rubric_levels IS 'The definition of rubric rating scales';


--
-- Name: mdl_workshopform_rubric_levels_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshopform_rubric_levels_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshopform_rubric_levels_id_seq OWNER TO postgres;

--
-- Name: mdl_workshopform_rubric_levels_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdl_workshopform_rubric_levels_id_seq OWNED BY public.mdl_workshopform_rubric_levels.id;


--
-- Name: mdl_analytics_indicator_calc id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_analytics_indicator_calc ALTER COLUMN id SET DEFAULT nextval('public.mdl_analytics_indicator_calc_id_seq'::regclass);


--
-- Name: mdl_analytics_models id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_analytics_models ALTER COLUMN id SET DEFAULT nextval('public.mdl_analytics_models_id_seq'::regclass);


--
-- Name: mdl_analytics_models_log id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_analytics_models_log ALTER COLUMN id SET DEFAULT nextval('public.mdl_analytics_models_log_id_seq'::regclass);


--
-- Name: mdl_analytics_predict_samples id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_analytics_predict_samples ALTER COLUMN id SET DEFAULT nextval('public.mdl_analytics_predict_samples_id_seq'::regclass);


--
-- Name: mdl_analytics_prediction_actions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_analytics_prediction_actions ALTER COLUMN id SET DEFAULT nextval('public.mdl_analytics_prediction_actions_id_seq'::regclass);


--
-- Name: mdl_analytics_predictions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_analytics_predictions ALTER COLUMN id SET DEFAULT nextval('public.mdl_analytics_predictions_id_seq'::regclass);


--
-- Name: mdl_analytics_train_samples id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_analytics_train_samples ALTER COLUMN id SET DEFAULT nextval('public.mdl_analytics_train_samples_id_seq'::regclass);


--
-- Name: mdl_analytics_used_analysables id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_analytics_used_analysables ALTER COLUMN id SET DEFAULT nextval('public.mdl_analytics_used_analysables_id_seq'::regclass);


--
-- Name: mdl_analytics_used_files id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_analytics_used_files ALTER COLUMN id SET DEFAULT nextval('public.mdl_analytics_used_files_id_seq'::regclass);


--
-- Name: mdl_assign id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assign ALTER COLUMN id SET DEFAULT nextval('public.mdl_assign_id_seq'::regclass);


--
-- Name: mdl_assign_grades id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assign_grades ALTER COLUMN id SET DEFAULT nextval('public.mdl_assign_grades_id_seq'::regclass);


--
-- Name: mdl_assign_overrides id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assign_overrides ALTER COLUMN id SET DEFAULT nextval('public.mdl_assign_overrides_id_seq'::regclass);


--
-- Name: mdl_assign_plugin_config id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assign_plugin_config ALTER COLUMN id SET DEFAULT nextval('public.mdl_assign_plugin_config_id_seq'::regclass);


--
-- Name: mdl_assign_submission id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assign_submission ALTER COLUMN id SET DEFAULT nextval('public.mdl_assign_submission_id_seq'::regclass);


--
-- Name: mdl_assign_user_flags id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assign_user_flags ALTER COLUMN id SET DEFAULT nextval('public.mdl_assign_user_flags_id_seq'::regclass);


--
-- Name: mdl_assign_user_mapping id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assign_user_mapping ALTER COLUMN id SET DEFAULT nextval('public.mdl_assign_user_mapping_id_seq'::regclass);


--
-- Name: mdl_assignfeedback_comments id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assignfeedback_comments ALTER COLUMN id SET DEFAULT nextval('public.mdl_assignfeedback_comments_id_seq'::regclass);


--
-- Name: mdl_assignfeedback_editpdf_annot id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assignfeedback_editpdf_annot ALTER COLUMN id SET DEFAULT nextval('public.mdl_assignfeedback_editpdf_annot_id_seq'::regclass);


--
-- Name: mdl_assignfeedback_editpdf_cmnt id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assignfeedback_editpdf_cmnt ALTER COLUMN id SET DEFAULT nextval('public.mdl_assignfeedback_editpdf_cmnt_id_seq'::regclass);


--
-- Name: mdl_assignfeedback_editpdf_queue id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assignfeedback_editpdf_queue ALTER COLUMN id SET DEFAULT nextval('public.mdl_assignfeedback_editpdf_queue_id_seq'::regclass);


--
-- Name: mdl_assignfeedback_editpdf_quick id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assignfeedback_editpdf_quick ALTER COLUMN id SET DEFAULT nextval('public.mdl_assignfeedback_editpdf_quick_id_seq'::regclass);


--
-- Name: mdl_assignfeedback_editpdf_rot id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assignfeedback_editpdf_rot ALTER COLUMN id SET DEFAULT nextval('public.mdl_assignfeedback_editpdf_rot_id_seq'::regclass);


--
-- Name: mdl_assignfeedback_file id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assignfeedback_file ALTER COLUMN id SET DEFAULT nextval('public.mdl_assignfeedback_file_id_seq'::regclass);


--
-- Name: mdl_assignment id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assignment ALTER COLUMN id SET DEFAULT nextval('public.mdl_assignment_id_seq'::regclass);


--
-- Name: mdl_assignment_submissions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assignment_submissions ALTER COLUMN id SET DEFAULT nextval('public.mdl_assignment_submissions_id_seq'::regclass);


--
-- Name: mdl_assignment_upgrade id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assignment_upgrade ALTER COLUMN id SET DEFAULT nextval('public.mdl_assignment_upgrade_id_seq'::regclass);


--
-- Name: mdl_assignsubmission_file id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assignsubmission_file ALTER COLUMN id SET DEFAULT nextval('public.mdl_assignsubmission_file_id_seq'::regclass);


--
-- Name: mdl_assignsubmission_onlinetext id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_assignsubmission_onlinetext ALTER COLUMN id SET DEFAULT nextval('public.mdl_assignsubmission_onlinetext_id_seq'::regclass);


--
-- Name: mdl_auth_oauth2_linked_login id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_auth_oauth2_linked_login ALTER COLUMN id SET DEFAULT nextval('public.mdl_auth_oauth2_linked_login_id_seq'::regclass);


--
-- Name: mdl_backup_controllers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_backup_controllers ALTER COLUMN id SET DEFAULT nextval('public.mdl_backup_controllers_id_seq'::regclass);


--
-- Name: mdl_backup_courses id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_backup_courses ALTER COLUMN id SET DEFAULT nextval('public.mdl_backup_courses_id_seq'::regclass);


--
-- Name: mdl_backup_logs id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_backup_logs ALTER COLUMN id SET DEFAULT nextval('public.mdl_backup_logs_id_seq'::regclass);


--
-- Name: mdl_badge id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_badge ALTER COLUMN id SET DEFAULT nextval('public.mdl_badge_id_seq'::regclass);


--
-- Name: mdl_badge_alignment id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_badge_alignment ALTER COLUMN id SET DEFAULT nextval('public.mdl_badge_alignment_id_seq'::regclass);


--
-- Name: mdl_badge_backpack id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_badge_backpack ALTER COLUMN id SET DEFAULT nextval('public.mdl_badge_backpack_id_seq'::regclass);


--
-- Name: mdl_badge_backpack_oauth2 id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_badge_backpack_oauth2 ALTER COLUMN id SET DEFAULT nextval('public.mdl_badge_backpack_oauth2_id_seq'::regclass);


--
-- Name: mdl_badge_criteria id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_badge_criteria ALTER COLUMN id SET DEFAULT nextval('public.mdl_badge_criteria_id_seq'::regclass);


--
-- Name: mdl_badge_criteria_met id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_badge_criteria_met ALTER COLUMN id SET DEFAULT nextval('public.mdl_badge_criteria_met_id_seq'::regclass);


--
-- Name: mdl_badge_criteria_param id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_badge_criteria_param ALTER COLUMN id SET DEFAULT nextval('public.mdl_badge_criteria_param_id_seq'::regclass);


--
-- Name: mdl_badge_endorsement id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_badge_endorsement ALTER COLUMN id SET DEFAULT nextval('public.mdl_badge_endorsement_id_seq'::regclass);


--
-- Name: mdl_badge_external id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_badge_external ALTER COLUMN id SET DEFAULT nextval('public.mdl_badge_external_id_seq'::regclass);


--
-- Name: mdl_badge_external_backpack id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_badge_external_backpack ALTER COLUMN id SET DEFAULT nextval('public.mdl_badge_external_backpack_id_seq'::regclass);


--
-- Name: mdl_badge_external_identifier id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_badge_external_identifier ALTER COLUMN id SET DEFAULT nextval('public.mdl_badge_external_identifier_id_seq'::regclass);


--
-- Name: mdl_badge_issued id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_badge_issued ALTER COLUMN id SET DEFAULT nextval('public.mdl_badge_issued_id_seq'::regclass);


--
-- Name: mdl_badge_manual_award id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_badge_manual_award ALTER COLUMN id SET DEFAULT nextval('public.mdl_badge_manual_award_id_seq'::regclass);


--
-- Name: mdl_badge_related id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_badge_related ALTER COLUMN id SET DEFAULT nextval('public.mdl_badge_related_id_seq'::regclass);


--
-- Name: mdl_block id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_block ALTER COLUMN id SET DEFAULT nextval('public.mdl_block_id_seq'::regclass);


--
-- Name: mdl_block_instances id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_block_instances ALTER COLUMN id SET DEFAULT nextval('public.mdl_block_instances_id_seq'::regclass);


--
-- Name: mdl_block_positions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_block_positions ALTER COLUMN id SET DEFAULT nextval('public.mdl_block_positions_id_seq'::regclass);


--
-- Name: mdl_block_recent_activity id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_block_recent_activity ALTER COLUMN id SET DEFAULT nextval('public.mdl_block_recent_activity_id_seq'::regclass);


--
-- Name: mdl_block_recentlyaccesseditems id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_block_recentlyaccesseditems ALTER COLUMN id SET DEFAULT nextval('public.mdl_block_recentlyaccesseditems_id_seq'::regclass);


--
-- Name: mdl_block_rss_client id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_block_rss_client ALTER COLUMN id SET DEFAULT nextval('public.mdl_block_rss_client_id_seq'::regclass);


--
-- Name: mdl_blog_association id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_blog_association ALTER COLUMN id SET DEFAULT nextval('public.mdl_blog_association_id_seq'::regclass);


--
-- Name: mdl_blog_external id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_blog_external ALTER COLUMN id SET DEFAULT nextval('public.mdl_blog_external_id_seq'::regclass);


--
-- Name: mdl_book id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_book ALTER COLUMN id SET DEFAULT nextval('public.mdl_book_id_seq'::regclass);


--
-- Name: mdl_book_chapters id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_book_chapters ALTER COLUMN id SET DEFAULT nextval('public.mdl_book_chapters_id_seq'::regclass);


--
-- Name: mdl_cache_filters id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_cache_filters ALTER COLUMN id SET DEFAULT nextval('public.mdl_cache_filters_id_seq'::regclass);


--
-- Name: mdl_cache_flags id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_cache_flags ALTER COLUMN id SET DEFAULT nextval('public.mdl_cache_flags_id_seq'::regclass);


--
-- Name: mdl_capabilities id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_capabilities ALTER COLUMN id SET DEFAULT nextval('public.mdl_capabilities_id_seq'::regclass);


--
-- Name: mdl_chat id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_chat ALTER COLUMN id SET DEFAULT nextval('public.mdl_chat_id_seq'::regclass);


--
-- Name: mdl_chat_messages id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_chat_messages ALTER COLUMN id SET DEFAULT nextval('public.mdl_chat_messages_id_seq'::regclass);


--
-- Name: mdl_chat_messages_current id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_chat_messages_current ALTER COLUMN id SET DEFAULT nextval('public.mdl_chat_messages_current_id_seq'::regclass);


--
-- Name: mdl_chat_users id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_chat_users ALTER COLUMN id SET DEFAULT nextval('public.mdl_chat_users_id_seq'::regclass);


--
-- Name: mdl_choice id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_choice ALTER COLUMN id SET DEFAULT nextval('public.mdl_choice_id_seq'::regclass);


--
-- Name: mdl_choice_answers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_choice_answers ALTER COLUMN id SET DEFAULT nextval('public.mdl_choice_answers_id_seq'::regclass);


--
-- Name: mdl_choice_options id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_choice_options ALTER COLUMN id SET DEFAULT nextval('public.mdl_choice_options_id_seq'::regclass);


--
-- Name: mdl_cohort id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_cohort ALTER COLUMN id SET DEFAULT nextval('public.mdl_cohort_id_seq'::regclass);


--
-- Name: mdl_cohort_members id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_cohort_members ALTER COLUMN id SET DEFAULT nextval('public.mdl_cohort_members_id_seq'::regclass);


--
-- Name: mdl_comments id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_comments ALTER COLUMN id SET DEFAULT nextval('public.mdl_comments_id_seq'::regclass);


--
-- Name: mdl_competency id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_id_seq'::regclass);


--
-- Name: mdl_competency_coursecomp id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_coursecomp ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_coursecomp_id_seq'::regclass);


--
-- Name: mdl_competency_coursecompsetting id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_coursecompsetting ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_coursecompsetting_id_seq'::regclass);


--
-- Name: mdl_competency_evidence id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_evidence ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_evidence_id_seq'::regclass);


--
-- Name: mdl_competency_framework id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_framework ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_framework_id_seq'::regclass);


--
-- Name: mdl_competency_modulecomp id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_modulecomp ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_modulecomp_id_seq'::regclass);


--
-- Name: mdl_competency_plan id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_plan ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_plan_id_seq'::regclass);


--
-- Name: mdl_competency_plancomp id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_plancomp ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_plancomp_id_seq'::regclass);


--
-- Name: mdl_competency_relatedcomp id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_relatedcomp ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_relatedcomp_id_seq'::regclass);


--
-- Name: mdl_competency_template id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_template ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_template_id_seq'::regclass);


--
-- Name: mdl_competency_templatecohort id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_templatecohort ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_templatecohort_id_seq'::regclass);


--
-- Name: mdl_competency_templatecomp id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_templatecomp ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_templatecomp_id_seq'::regclass);


--
-- Name: mdl_competency_usercomp id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_usercomp ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_usercomp_id_seq'::regclass);


--
-- Name: mdl_competency_usercompcourse id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_usercompcourse ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_usercompcourse_id_seq'::regclass);


--
-- Name: mdl_competency_usercompplan id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_usercompplan ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_usercompplan_id_seq'::regclass);


--
-- Name: mdl_competency_userevidence id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_userevidence ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_userevidence_id_seq'::regclass);


--
-- Name: mdl_competency_userevidencecomp id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_competency_userevidencecomp ALTER COLUMN id SET DEFAULT nextval('public.mdl_competency_userevidencecomp_id_seq'::regclass);


--
-- Name: mdl_config id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_config ALTER COLUMN id SET DEFAULT nextval('public.mdl_config_id_seq'::regclass);


--
-- Name: mdl_config_log id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_config_log ALTER COLUMN id SET DEFAULT nextval('public.mdl_config_log_id_seq'::regclass);


--
-- Name: mdl_config_plugins id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_config_plugins ALTER COLUMN id SET DEFAULT nextval('public.mdl_config_plugins_id_seq'::regclass);


--
-- Name: mdl_contentbank_content id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_contentbank_content ALTER COLUMN id SET DEFAULT nextval('public.mdl_contentbank_content_id_seq'::regclass);


--
-- Name: mdl_context id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_context ALTER COLUMN id SET DEFAULT nextval('public.mdl_context_id_seq'::regclass);


--
-- Name: mdl_course id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_id_seq'::regclass);


--
-- Name: mdl_course_categories id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course_categories ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_categories_id_seq'::regclass);


--
-- Name: mdl_course_completion_aggr_methd id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course_completion_aggr_methd ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_completion_aggr_methd_id_seq'::regclass);


--
-- Name: mdl_course_completion_crit_compl id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course_completion_crit_compl ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_completion_crit_compl_id_seq'::regclass);


--
-- Name: mdl_course_completion_criteria id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course_completion_criteria ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_completion_criteria_id_seq'::regclass);


--
-- Name: mdl_course_completion_defaults id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course_completion_defaults ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_completion_defaults_id_seq'::regclass);


--
-- Name: mdl_course_completions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course_completions ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_completions_id_seq'::regclass);


--
-- Name: mdl_course_format_options id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course_format_options ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_format_options_id_seq'::regclass);


--
-- Name: mdl_course_modules id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course_modules ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_modules_id_seq'::regclass);


--
-- Name: mdl_course_modules_completion id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course_modules_completion ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_modules_completion_id_seq'::regclass);


--
-- Name: mdl_course_published id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course_published ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_published_id_seq'::regclass);


--
-- Name: mdl_course_request id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course_request ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_request_id_seq'::regclass);


--
-- Name: mdl_course_sections id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_course_sections ALTER COLUMN id SET DEFAULT nextval('public.mdl_course_sections_id_seq'::regclass);


--
-- Name: mdl_customfield_category id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_customfield_category ALTER COLUMN id SET DEFAULT nextval('public.mdl_customfield_category_id_seq'::regclass);


--
-- Name: mdl_customfield_data id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_customfield_data ALTER COLUMN id SET DEFAULT nextval('public.mdl_customfield_data_id_seq'::regclass);


--
-- Name: mdl_customfield_field id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_customfield_field ALTER COLUMN id SET DEFAULT nextval('public.mdl_customfield_field_id_seq'::regclass);


--
-- Name: mdl_data id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_data ALTER COLUMN id SET DEFAULT nextval('public.mdl_data_id_seq'::regclass);


--
-- Name: mdl_data_content id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_data_content ALTER COLUMN id SET DEFAULT nextval('public.mdl_data_content_id_seq'::regclass);


--
-- Name: mdl_data_fields id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_data_fields ALTER COLUMN id SET DEFAULT nextval('public.mdl_data_fields_id_seq'::regclass);


--
-- Name: mdl_data_records id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_data_records ALTER COLUMN id SET DEFAULT nextval('public.mdl_data_records_id_seq'::regclass);


--
-- Name: mdl_editor_atto_autosave id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_editor_atto_autosave ALTER COLUMN id SET DEFAULT nextval('public.mdl_editor_atto_autosave_id_seq'::regclass);


--
-- Name: mdl_enrol id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_enrol ALTER COLUMN id SET DEFAULT nextval('public.mdl_enrol_id_seq'::regclass);


--
-- Name: mdl_enrol_flatfile id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_enrol_flatfile ALTER COLUMN id SET DEFAULT nextval('public.mdl_enrol_flatfile_id_seq'::regclass);


--
-- Name: mdl_enrol_lti_lti2_consumer id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_enrol_lti_lti2_consumer ALTER COLUMN id SET DEFAULT nextval('public.mdl_enrol_lti_lti2_consumer_id_seq'::regclass);


--
-- Name: mdl_enrol_lti_lti2_context id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_enrol_lti_lti2_context ALTER COLUMN id SET DEFAULT nextval('public.mdl_enrol_lti_lti2_context_id_seq'::regclass);


--
-- Name: mdl_enrol_lti_lti2_nonce id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_enrol_lti_lti2_nonce ALTER COLUMN id SET DEFAULT nextval('public.mdl_enrol_lti_lti2_nonce_id_seq'::regclass);


--
-- Name: mdl_enrol_lti_lti2_resource_link id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_enrol_lti_lti2_resource_link ALTER COLUMN id SET DEFAULT nextval('public.mdl_enrol_lti_lti2_resource_link_id_seq'::regclass);


--
-- Name: mdl_enrol_lti_lti2_share_key id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_enrol_lti_lti2_share_key ALTER COLUMN id SET DEFAULT nextval('public.mdl_enrol_lti_lti2_share_key_id_seq'::regclass);


--
-- Name: mdl_enrol_lti_lti2_tool_proxy id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_enrol_lti_lti2_tool_proxy ALTER COLUMN id SET DEFAULT nextval('public.mdl_enrol_lti_lti2_tool_proxy_id_seq'::regclass);


--
-- Name: mdl_enrol_lti_lti2_user_result id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_enrol_lti_lti2_user_result ALTER COLUMN id SET DEFAULT nextval('public.mdl_enrol_lti_lti2_user_result_id_seq'::regclass);


--
-- Name: mdl_enrol_lti_tool_consumer_map id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_enrol_lti_tool_consumer_map ALTER COLUMN id SET DEFAULT nextval('public.mdl_enrol_lti_tool_consumer_map_id_seq'::regclass);


--
-- Name: mdl_enrol_lti_tools id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_enrol_lti_tools ALTER COLUMN id SET DEFAULT nextval('public.mdl_enrol_lti_tools_id_seq'::regclass);


--
-- Name: mdl_enrol_lti_users id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_enrol_lti_users ALTER COLUMN id SET DEFAULT nextval('public.mdl_enrol_lti_users_id_seq'::regclass);


--
-- Name: mdl_enrol_paypal id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_enrol_paypal ALTER COLUMN id SET DEFAULT nextval('public.mdl_enrol_paypal_id_seq'::regclass);


--
-- Name: mdl_event id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_event ALTER COLUMN id SET DEFAULT nextval('public.mdl_event_id_seq'::regclass);


--
-- Name: mdl_event_subscriptions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_event_subscriptions ALTER COLUMN id SET DEFAULT nextval('public.mdl_event_subscriptions_id_seq'::regclass);


--
-- Name: mdl_events_handlers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_events_handlers ALTER COLUMN id SET DEFAULT nextval('public.mdl_events_handlers_id_seq'::regclass);


--
-- Name: mdl_events_queue id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_events_queue ALTER COLUMN id SET DEFAULT nextval('public.mdl_events_queue_id_seq'::regclass);


--
-- Name: mdl_events_queue_handlers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_events_queue_handlers ALTER COLUMN id SET DEFAULT nextval('public.mdl_events_queue_handlers_id_seq'::regclass);


--
-- Name: mdl_external_functions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_external_functions ALTER COLUMN id SET DEFAULT nextval('public.mdl_external_functions_id_seq'::regclass);


--
-- Name: mdl_external_services id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_external_services ALTER COLUMN id SET DEFAULT nextval('public.mdl_external_services_id_seq'::regclass);


--
-- Name: mdl_external_services_functions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_external_services_functions ALTER COLUMN id SET DEFAULT nextval('public.mdl_external_services_functions_id_seq'::regclass);


--
-- Name: mdl_external_services_users id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_external_services_users ALTER COLUMN id SET DEFAULT nextval('public.mdl_external_services_users_id_seq'::regclass);


--
-- Name: mdl_external_tokens id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_external_tokens ALTER COLUMN id SET DEFAULT nextval('public.mdl_external_tokens_id_seq'::regclass);


--
-- Name: mdl_favourite id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_favourite ALTER COLUMN id SET DEFAULT nextval('public.mdl_favourite_id_seq'::regclass);


--
-- Name: mdl_feedback id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_feedback ALTER COLUMN id SET DEFAULT nextval('public.mdl_feedback_id_seq'::regclass);


--
-- Name: mdl_feedback_completed id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_feedback_completed ALTER COLUMN id SET DEFAULT nextval('public.mdl_feedback_completed_id_seq'::regclass);


--
-- Name: mdl_feedback_completedtmp id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_feedback_completedtmp ALTER COLUMN id SET DEFAULT nextval('public.mdl_feedback_completedtmp_id_seq'::regclass);


--
-- Name: mdl_feedback_item id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_feedback_item ALTER COLUMN id SET DEFAULT nextval('public.mdl_feedback_item_id_seq'::regclass);


--
-- Name: mdl_feedback_sitecourse_map id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_feedback_sitecourse_map ALTER COLUMN id SET DEFAULT nextval('public.mdl_feedback_sitecourse_map_id_seq'::regclass);


--
-- Name: mdl_feedback_template id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_feedback_template ALTER COLUMN id SET DEFAULT nextval('public.mdl_feedback_template_id_seq'::regclass);


--
-- Name: mdl_feedback_value id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_feedback_value ALTER COLUMN id SET DEFAULT nextval('public.mdl_feedback_value_id_seq'::regclass);


--
-- Name: mdl_feedback_valuetmp id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_feedback_valuetmp ALTER COLUMN id SET DEFAULT nextval('public.mdl_feedback_valuetmp_id_seq'::regclass);


--
-- Name: mdl_file_conversion id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_file_conversion ALTER COLUMN id SET DEFAULT nextval('public.mdl_file_conversion_id_seq'::regclass);


--
-- Name: mdl_files id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_files ALTER COLUMN id SET DEFAULT nextval('public.mdl_files_id_seq'::regclass);


--
-- Name: mdl_files_reference id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_files_reference ALTER COLUMN id SET DEFAULT nextval('public.mdl_files_reference_id_seq'::regclass);


--
-- Name: mdl_filter_active id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_filter_active ALTER COLUMN id SET DEFAULT nextval('public.mdl_filter_active_id_seq'::regclass);


--
-- Name: mdl_filter_config id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_filter_config ALTER COLUMN id SET DEFAULT nextval('public.mdl_filter_config_id_seq'::regclass);


--
-- Name: mdl_folder id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_folder ALTER COLUMN id SET DEFAULT nextval('public.mdl_folder_id_seq'::regclass);


--
-- Name: mdl_forum id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_forum ALTER COLUMN id SET DEFAULT nextval('public.mdl_forum_id_seq'::regclass);


--
-- Name: mdl_forum_digests id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_forum_digests ALTER COLUMN id SET DEFAULT nextval('public.mdl_forum_digests_id_seq'::regclass);


--
-- Name: mdl_forum_discussion_subs id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_forum_discussion_subs ALTER COLUMN id SET DEFAULT nextval('public.mdl_forum_discussion_subs_id_seq'::regclass);


--
-- Name: mdl_forum_discussions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_forum_discussions ALTER COLUMN id SET DEFAULT nextval('public.mdl_forum_discussions_id_seq'::regclass);


--
-- Name: mdl_forum_grades id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_forum_grades ALTER COLUMN id SET DEFAULT nextval('public.mdl_forum_grades_id_seq'::regclass);


--
-- Name: mdl_forum_posts id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_forum_posts ALTER COLUMN id SET DEFAULT nextval('public.mdl_forum_posts_id_seq'::regclass);


--
-- Name: mdl_forum_queue id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_forum_queue ALTER COLUMN id SET DEFAULT nextval('public.mdl_forum_queue_id_seq'::regclass);


--
-- Name: mdl_forum_read id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_forum_read ALTER COLUMN id SET DEFAULT nextval('public.mdl_forum_read_id_seq'::regclass);


--
-- Name: mdl_forum_subscriptions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_forum_subscriptions ALTER COLUMN id SET DEFAULT nextval('public.mdl_forum_subscriptions_id_seq'::regclass);


--
-- Name: mdl_forum_track_prefs id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_forum_track_prefs ALTER COLUMN id SET DEFAULT nextval('public.mdl_forum_track_prefs_id_seq'::regclass);


--
-- Name: mdl_glossary id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_glossary ALTER COLUMN id SET DEFAULT nextval('public.mdl_glossary_id_seq'::regclass);


--
-- Name: mdl_glossary_alias id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_glossary_alias ALTER COLUMN id SET DEFAULT nextval('public.mdl_glossary_alias_id_seq'::regclass);


--
-- Name: mdl_glossary_categories id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_glossary_categories ALTER COLUMN id SET DEFAULT nextval('public.mdl_glossary_categories_id_seq'::regclass);


--
-- Name: mdl_glossary_entries id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_glossary_entries ALTER COLUMN id SET DEFAULT nextval('public.mdl_glossary_entries_id_seq'::regclass);


--
-- Name: mdl_glossary_entries_categories id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_glossary_entries_categories ALTER COLUMN id SET DEFAULT nextval('public.mdl_glossary_entries_categories_id_seq'::regclass);


--
-- Name: mdl_glossary_formats id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_glossary_formats ALTER COLUMN id SET DEFAULT nextval('public.mdl_glossary_formats_id_seq'::regclass);


--
-- Name: mdl_grade_categories id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grade_categories ALTER COLUMN id SET DEFAULT nextval('public.mdl_grade_categories_id_seq'::regclass);


--
-- Name: mdl_grade_categories_history id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grade_categories_history ALTER COLUMN id SET DEFAULT nextval('public.mdl_grade_categories_history_id_seq'::regclass);


--
-- Name: mdl_grade_grades id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grade_grades ALTER COLUMN id SET DEFAULT nextval('public.mdl_grade_grades_id_seq'::regclass);


--
-- Name: mdl_grade_grades_history id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grade_grades_history ALTER COLUMN id SET DEFAULT nextval('public.mdl_grade_grades_history_id_seq'::regclass);


--
-- Name: mdl_grade_import_newitem id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grade_import_newitem ALTER COLUMN id SET DEFAULT nextval('public.mdl_grade_import_newitem_id_seq'::regclass);


--
-- Name: mdl_grade_import_values id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grade_import_values ALTER COLUMN id SET DEFAULT nextval('public.mdl_grade_import_values_id_seq'::regclass);


--
-- Name: mdl_grade_items id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grade_items ALTER COLUMN id SET DEFAULT nextval('public.mdl_grade_items_id_seq'::regclass);


--
-- Name: mdl_grade_items_history id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grade_items_history ALTER COLUMN id SET DEFAULT nextval('public.mdl_grade_items_history_id_seq'::regclass);


--
-- Name: mdl_grade_letters id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grade_letters ALTER COLUMN id SET DEFAULT nextval('public.mdl_grade_letters_id_seq'::regclass);


--
-- Name: mdl_grade_outcomes id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grade_outcomes ALTER COLUMN id SET DEFAULT nextval('public.mdl_grade_outcomes_id_seq'::regclass);


--
-- Name: mdl_grade_outcomes_courses id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grade_outcomes_courses ALTER COLUMN id SET DEFAULT nextval('public.mdl_grade_outcomes_courses_id_seq'::regclass);


--
-- Name: mdl_grade_outcomes_history id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grade_outcomes_history ALTER COLUMN id SET DEFAULT nextval('public.mdl_grade_outcomes_history_id_seq'::regclass);


--
-- Name: mdl_grade_settings id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grade_settings ALTER COLUMN id SET DEFAULT nextval('public.mdl_grade_settings_id_seq'::regclass);


--
-- Name: mdl_grading_areas id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grading_areas ALTER COLUMN id SET DEFAULT nextval('public.mdl_grading_areas_id_seq'::regclass);


--
-- Name: mdl_grading_definitions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grading_definitions ALTER COLUMN id SET DEFAULT nextval('public.mdl_grading_definitions_id_seq'::regclass);


--
-- Name: mdl_grading_instances id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_grading_instances ALTER COLUMN id SET DEFAULT nextval('public.mdl_grading_instances_id_seq'::regclass);


--
-- Name: mdl_gradingform_guide_comments id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_gradingform_guide_comments ALTER COLUMN id SET DEFAULT nextval('public.mdl_gradingform_guide_comments_id_seq'::regclass);


--
-- Name: mdl_gradingform_guide_criteria id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_gradingform_guide_criteria ALTER COLUMN id SET DEFAULT nextval('public.mdl_gradingform_guide_criteria_id_seq'::regclass);


--
-- Name: mdl_gradingform_guide_fillings id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_gradingform_guide_fillings ALTER COLUMN id SET DEFAULT nextval('public.mdl_gradingform_guide_fillings_id_seq'::regclass);


--
-- Name: mdl_gradingform_rubric_criteria id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_gradingform_rubric_criteria ALTER COLUMN id SET DEFAULT nextval('public.mdl_gradingform_rubric_criteria_id_seq'::regclass);


--
-- Name: mdl_gradingform_rubric_fillings id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_gradingform_rubric_fillings ALTER COLUMN id SET DEFAULT nextval('public.mdl_gradingform_rubric_fillings_id_seq'::regclass);


--
-- Name: mdl_gradingform_rubric_levels id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_gradingform_rubric_levels ALTER COLUMN id SET DEFAULT nextval('public.mdl_gradingform_rubric_levels_id_seq'::regclass);


--
-- Name: mdl_groupings id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_groupings ALTER COLUMN id SET DEFAULT nextval('public.mdl_groupings_id_seq'::regclass);


--
-- Name: mdl_groupings_groups id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_groupings_groups ALTER COLUMN id SET DEFAULT nextval('public.mdl_groupings_groups_id_seq'::regclass);


--
-- Name: mdl_groups id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_groups ALTER COLUMN id SET DEFAULT nextval('public.mdl_groups_id_seq'::regclass);


--
-- Name: mdl_groups_members id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_groups_members ALTER COLUMN id SET DEFAULT nextval('public.mdl_groups_members_id_seq'::regclass);


--
-- Name: mdl_h5p id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_h5p ALTER COLUMN id SET DEFAULT nextval('public.mdl_h5p_id_seq'::regclass);


--
-- Name: mdl_h5p_contents_libraries id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_h5p_contents_libraries ALTER COLUMN id SET DEFAULT nextval('public.mdl_h5p_contents_libraries_id_seq'::regclass);


--
-- Name: mdl_h5p_libraries id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_h5p_libraries ALTER COLUMN id SET DEFAULT nextval('public.mdl_h5p_libraries_id_seq'::regclass);


--
-- Name: mdl_h5p_libraries_cachedassets id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_h5p_libraries_cachedassets ALTER COLUMN id SET DEFAULT nextval('public.mdl_h5p_libraries_cachedassets_id_seq'::regclass);


--
-- Name: mdl_h5p_library_dependencies id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_h5p_library_dependencies ALTER COLUMN id SET DEFAULT nextval('public.mdl_h5p_library_dependencies_id_seq'::regclass);


--
-- Name: mdl_h5pactivity id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_h5pactivity ALTER COLUMN id SET DEFAULT nextval('public.mdl_h5pactivity_id_seq'::regclass);


--
-- Name: mdl_h5pactivity_attempts id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_h5pactivity_attempts ALTER COLUMN id SET DEFAULT nextval('public.mdl_h5pactivity_attempts_id_seq'::regclass);


--
-- Name: mdl_h5pactivity_attempts_results id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_h5pactivity_attempts_results ALTER COLUMN id SET DEFAULT nextval('public.mdl_h5pactivity_attempts_results_id_seq'::regclass);


--
-- Name: mdl_imscp id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_imscp ALTER COLUMN id SET DEFAULT nextval('public.mdl_imscp_id_seq'::regclass);


--
-- Name: mdl_label id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_label ALTER COLUMN id SET DEFAULT nextval('public.mdl_label_id_seq'::regclass);


--
-- Name: mdl_lesson id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lesson ALTER COLUMN id SET DEFAULT nextval('public.mdl_lesson_id_seq'::regclass);


--
-- Name: mdl_lesson_answers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lesson_answers ALTER COLUMN id SET DEFAULT nextval('public.mdl_lesson_answers_id_seq'::regclass);


--
-- Name: mdl_lesson_attempts id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lesson_attempts ALTER COLUMN id SET DEFAULT nextval('public.mdl_lesson_attempts_id_seq'::regclass);


--
-- Name: mdl_lesson_branch id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lesson_branch ALTER COLUMN id SET DEFAULT nextval('public.mdl_lesson_branch_id_seq'::regclass);


--
-- Name: mdl_lesson_grades id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lesson_grades ALTER COLUMN id SET DEFAULT nextval('public.mdl_lesson_grades_id_seq'::regclass);


--
-- Name: mdl_lesson_overrides id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lesson_overrides ALTER COLUMN id SET DEFAULT nextval('public.mdl_lesson_overrides_id_seq'::regclass);


--
-- Name: mdl_lesson_pages id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lesson_pages ALTER COLUMN id SET DEFAULT nextval('public.mdl_lesson_pages_id_seq'::regclass);


--
-- Name: mdl_lesson_timer id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lesson_timer ALTER COLUMN id SET DEFAULT nextval('public.mdl_lesson_timer_id_seq'::regclass);


--
-- Name: mdl_license id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_license ALTER COLUMN id SET DEFAULT nextval('public.mdl_license_id_seq'::regclass);


--
-- Name: mdl_lock_db id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lock_db ALTER COLUMN id SET DEFAULT nextval('public.mdl_lock_db_id_seq'::regclass);


--
-- Name: mdl_log id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_log ALTER COLUMN id SET DEFAULT nextval('public.mdl_log_id_seq'::regclass);


--
-- Name: mdl_log_display id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_log_display ALTER COLUMN id SET DEFAULT nextval('public.mdl_log_display_id_seq'::regclass);


--
-- Name: mdl_log_queries id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_log_queries ALTER COLUMN id SET DEFAULT nextval('public.mdl_log_queries_id_seq'::regclass);


--
-- Name: mdl_logstore_standard_log id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_logstore_standard_log ALTER COLUMN id SET DEFAULT nextval('public.mdl_logstore_standard_log_id_seq'::regclass);


--
-- Name: mdl_lti id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lti ALTER COLUMN id SET DEFAULT nextval('public.mdl_lti_id_seq'::regclass);


--
-- Name: mdl_lti_access_tokens id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lti_access_tokens ALTER COLUMN id SET DEFAULT nextval('public.mdl_lti_access_tokens_id_seq'::regclass);


--
-- Name: mdl_lti_submission id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lti_submission ALTER COLUMN id SET DEFAULT nextval('public.mdl_lti_submission_id_seq'::regclass);


--
-- Name: mdl_lti_tool_proxies id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lti_tool_proxies ALTER COLUMN id SET DEFAULT nextval('public.mdl_lti_tool_proxies_id_seq'::regclass);


--
-- Name: mdl_lti_tool_settings id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lti_tool_settings ALTER COLUMN id SET DEFAULT nextval('public.mdl_lti_tool_settings_id_seq'::regclass);


--
-- Name: mdl_lti_types id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lti_types ALTER COLUMN id SET DEFAULT nextval('public.mdl_lti_types_id_seq'::regclass);


--
-- Name: mdl_lti_types_config id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_lti_types_config ALTER COLUMN id SET DEFAULT nextval('public.mdl_lti_types_config_id_seq'::regclass);


--
-- Name: mdl_ltiservice_gradebookservices id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_ltiservice_gradebookservices ALTER COLUMN id SET DEFAULT nextval('public.mdl_ltiservice_gradebookservices_id_seq'::regclass);


--
-- Name: mdl_message id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_id_seq'::regclass);


--
-- Name: mdl_message_airnotifier_devices id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message_airnotifier_devices ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_airnotifier_devices_id_seq'::regclass);


--
-- Name: mdl_message_contact_requests id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message_contact_requests ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_contact_requests_id_seq'::regclass);


--
-- Name: mdl_message_contacts id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message_contacts ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_contacts_id_seq'::regclass);


--
-- Name: mdl_message_conversation_actions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message_conversation_actions ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_conversation_actions_id_seq'::regclass);


--
-- Name: mdl_message_conversation_members id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message_conversation_members ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_conversation_members_id_seq'::regclass);


--
-- Name: mdl_message_conversations id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message_conversations ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_conversations_id_seq'::regclass);


--
-- Name: mdl_message_email_messages id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message_email_messages ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_email_messages_id_seq'::regclass);


--
-- Name: mdl_message_popup id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message_popup ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_popup_id_seq'::regclass);


--
-- Name: mdl_message_popup_notifications id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message_popup_notifications ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_popup_notifications_id_seq'::regclass);


--
-- Name: mdl_message_processors id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message_processors ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_processors_id_seq'::regclass);


--
-- Name: mdl_message_providers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message_providers ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_providers_id_seq'::regclass);


--
-- Name: mdl_message_read id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message_read ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_read_id_seq'::regclass);


--
-- Name: mdl_message_user_actions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message_user_actions ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_user_actions_id_seq'::regclass);


--
-- Name: mdl_message_users_blocked id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_message_users_blocked ALTER COLUMN id SET DEFAULT nextval('public.mdl_message_users_blocked_id_seq'::regclass);


--
-- Name: mdl_messageinbound_datakeys id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_messageinbound_datakeys ALTER COLUMN id SET DEFAULT nextval('public.mdl_messageinbound_datakeys_id_seq'::regclass);


--
-- Name: mdl_messageinbound_handlers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_messageinbound_handlers ALTER COLUMN id SET DEFAULT nextval('public.mdl_messageinbound_handlers_id_seq'::regclass);


--
-- Name: mdl_messageinbound_messagelist id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_messageinbound_messagelist ALTER COLUMN id SET DEFAULT nextval('public.mdl_messageinbound_messagelist_id_seq'::regclass);


--
-- Name: mdl_messages id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_messages ALTER COLUMN id SET DEFAULT nextval('public.mdl_messages_id_seq'::regclass);


--
-- Name: mdl_mnet_application id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_mnet_application ALTER COLUMN id SET DEFAULT nextval('public.mdl_mnet_application_id_seq'::regclass);


--
-- Name: mdl_mnet_host id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_mnet_host ALTER COLUMN id SET DEFAULT nextval('public.mdl_mnet_host_id_seq'::regclass);


--
-- Name: mdl_mnet_host2service id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_mnet_host2service ALTER COLUMN id SET DEFAULT nextval('public.mdl_mnet_host2service_id_seq'::regclass);


--
-- Name: mdl_mnet_log id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_mnet_log ALTER COLUMN id SET DEFAULT nextval('public.mdl_mnet_log_id_seq'::regclass);


--
-- Name: mdl_mnet_remote_rpc id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_mnet_remote_rpc ALTER COLUMN id SET DEFAULT nextval('public.mdl_mnet_remote_rpc_id_seq'::regclass);


--
-- Name: mdl_mnet_remote_service2rpc id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_mnet_remote_service2rpc ALTER COLUMN id SET DEFAULT nextval('public.mdl_mnet_remote_service2rpc_id_seq'::regclass);


--
-- Name: mdl_mnet_rpc id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_mnet_rpc ALTER COLUMN id SET DEFAULT nextval('public.mdl_mnet_rpc_id_seq'::regclass);


--
-- Name: mdl_mnet_service id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_mnet_service ALTER COLUMN id SET DEFAULT nextval('public.mdl_mnet_service_id_seq'::regclass);


--
-- Name: mdl_mnet_service2rpc id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_mnet_service2rpc ALTER COLUMN id SET DEFAULT nextval('public.mdl_mnet_service2rpc_id_seq'::regclass);


--
-- Name: mdl_mnet_session id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_mnet_session ALTER COLUMN id SET DEFAULT nextval('public.mdl_mnet_session_id_seq'::regclass);


--
-- Name: mdl_mnet_sso_access_control id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_mnet_sso_access_control ALTER COLUMN id SET DEFAULT nextval('public.mdl_mnet_sso_access_control_id_seq'::regclass);


--
-- Name: mdl_mnetservice_enrol_courses id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_mnetservice_enrol_courses ALTER COLUMN id SET DEFAULT nextval('public.mdl_mnetservice_enrol_courses_id_seq'::regclass);


--
-- Name: mdl_mnetservice_enrol_enrolments id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_mnetservice_enrol_enrolments ALTER COLUMN id SET DEFAULT nextval('public.mdl_mnetservice_enrol_enrolments_id_seq'::regclass);


--
-- Name: mdl_modules id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_modules ALTER COLUMN id SET DEFAULT nextval('public.mdl_modules_id_seq'::regclass);


--
-- Name: mdl_my_pages id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_my_pages ALTER COLUMN id SET DEFAULT nextval('public.mdl_my_pages_id_seq'::regclass);


--
-- Name: mdl_notifications id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_notifications ALTER COLUMN id SET DEFAULT nextval('public.mdl_notifications_id_seq'::regclass);


--
-- Name: mdl_oauth2_access_token id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_oauth2_access_token ALTER COLUMN id SET DEFAULT nextval('public.mdl_oauth2_access_token_id_seq'::regclass);


--
-- Name: mdl_oauth2_endpoint id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_oauth2_endpoint ALTER COLUMN id SET DEFAULT nextval('public.mdl_oauth2_endpoint_id_seq'::regclass);


--
-- Name: mdl_oauth2_issuer id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_oauth2_issuer ALTER COLUMN id SET DEFAULT nextval('public.mdl_oauth2_issuer_id_seq'::regclass);


--
-- Name: mdl_oauth2_system_account id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_oauth2_system_account ALTER COLUMN id SET DEFAULT nextval('public.mdl_oauth2_system_account_id_seq'::regclass);


--
-- Name: mdl_oauth2_user_field_mapping id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_oauth2_user_field_mapping ALTER COLUMN id SET DEFAULT nextval('public.mdl_oauth2_user_field_mapping_id_seq'::regclass);


--
-- Name: mdl_page id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_page ALTER COLUMN id SET DEFAULT nextval('public.mdl_page_id_seq'::regclass);


--
-- Name: mdl_portfolio_instance id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_portfolio_instance ALTER COLUMN id SET DEFAULT nextval('public.mdl_portfolio_instance_id_seq'::regclass);


--
-- Name: mdl_portfolio_instance_config id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_portfolio_instance_config ALTER COLUMN id SET DEFAULT nextval('public.mdl_portfolio_instance_config_id_seq'::regclass);


--
-- Name: mdl_portfolio_instance_user id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_portfolio_instance_user ALTER COLUMN id SET DEFAULT nextval('public.mdl_portfolio_instance_user_id_seq'::regclass);


--
-- Name: mdl_portfolio_log id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_portfolio_log ALTER COLUMN id SET DEFAULT nextval('public.mdl_portfolio_log_id_seq'::regclass);


--
-- Name: mdl_portfolio_mahara_queue id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_portfolio_mahara_queue ALTER COLUMN id SET DEFAULT nextval('public.mdl_portfolio_mahara_queue_id_seq'::regclass);


--
-- Name: mdl_portfolio_tempdata id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_portfolio_tempdata ALTER COLUMN id SET DEFAULT nextval('public.mdl_portfolio_tempdata_id_seq'::regclass);


--
-- Name: mdl_post id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_post ALTER COLUMN id SET DEFAULT nextval('public.mdl_post_id_seq'::regclass);


--
-- Name: mdl_profiling id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_profiling ALTER COLUMN id SET DEFAULT nextval('public.mdl_profiling_id_seq'::regclass);


--
-- Name: mdl_qtype_ddimageortext id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_qtype_ddimageortext ALTER COLUMN id SET DEFAULT nextval('public.mdl_qtype_ddimageortext_id_seq'::regclass);


--
-- Name: mdl_qtype_ddimageortext_drags id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_qtype_ddimageortext_drags ALTER COLUMN id SET DEFAULT nextval('public.mdl_qtype_ddimageortext_drags_id_seq'::regclass);


--
-- Name: mdl_qtype_ddimageortext_drops id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_qtype_ddimageortext_drops ALTER COLUMN id SET DEFAULT nextval('public.mdl_qtype_ddimageortext_drops_id_seq'::regclass);


--
-- Name: mdl_qtype_ddmarker id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_qtype_ddmarker ALTER COLUMN id SET DEFAULT nextval('public.mdl_qtype_ddmarker_id_seq'::regclass);


--
-- Name: mdl_qtype_ddmarker_drags id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_qtype_ddmarker_drags ALTER COLUMN id SET DEFAULT nextval('public.mdl_qtype_ddmarker_drags_id_seq'::regclass);


--
-- Name: mdl_qtype_ddmarker_drops id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_qtype_ddmarker_drops ALTER COLUMN id SET DEFAULT nextval('public.mdl_qtype_ddmarker_drops_id_seq'::regclass);


--
-- Name: mdl_qtype_essay_options id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_qtype_essay_options ALTER COLUMN id SET DEFAULT nextval('public.mdl_qtype_essay_options_id_seq'::regclass);


--
-- Name: mdl_qtype_match_options id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_qtype_match_options ALTER COLUMN id SET DEFAULT nextval('public.mdl_qtype_match_options_id_seq'::regclass);


--
-- Name: mdl_qtype_match_subquestions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_qtype_match_subquestions ALTER COLUMN id SET DEFAULT nextval('public.mdl_qtype_match_subquestions_id_seq'::regclass);


--
-- Name: mdl_qtype_multichoice_options id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_qtype_multichoice_options ALTER COLUMN id SET DEFAULT nextval('public.mdl_qtype_multichoice_options_id_seq'::regclass);


--
-- Name: mdl_qtype_randomsamatch_options id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_qtype_randomsamatch_options ALTER COLUMN id SET DEFAULT nextval('public.mdl_qtype_randomsamatch_options_id_seq'::regclass);


--
-- Name: mdl_qtype_shortanswer_options id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_qtype_shortanswer_options ALTER COLUMN id SET DEFAULT nextval('public.mdl_qtype_shortanswer_options_id_seq'::regclass);


--
-- Name: mdl_question id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_id_seq'::regclass);


--
-- Name: mdl_question_answers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_answers ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_answers_id_seq'::regclass);


--
-- Name: mdl_question_attempt_step_data id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_attempt_step_data ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_attempt_step_data_id_seq'::regclass);


--
-- Name: mdl_question_attempt_steps id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_attempt_steps ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_attempt_steps_id_seq'::regclass);


--
-- Name: mdl_question_attempts id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_attempts ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_attempts_id_seq'::regclass);


--
-- Name: mdl_question_calculated id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_calculated ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_calculated_id_seq'::regclass);


--
-- Name: mdl_question_calculated_options id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_calculated_options ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_calculated_options_id_seq'::regclass);


--
-- Name: mdl_question_categories id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_categories ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_categories_id_seq'::regclass);


--
-- Name: mdl_question_dataset_definitions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_dataset_definitions ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_dataset_definitions_id_seq'::regclass);


--
-- Name: mdl_question_dataset_items id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_dataset_items ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_dataset_items_id_seq'::regclass);


--
-- Name: mdl_question_datasets id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_datasets ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_datasets_id_seq'::regclass);


--
-- Name: mdl_question_ddwtos id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_ddwtos ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_ddwtos_id_seq'::regclass);


--
-- Name: mdl_question_gapselect id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_gapselect ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_gapselect_id_seq'::regclass);


--
-- Name: mdl_question_hints id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_hints ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_hints_id_seq'::regclass);


--
-- Name: mdl_question_multianswer id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_multianswer ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_multianswer_id_seq'::regclass);


--
-- Name: mdl_question_numerical id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_numerical ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_numerical_id_seq'::regclass);


--
-- Name: mdl_question_numerical_options id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_numerical_options ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_numerical_options_id_seq'::regclass);


--
-- Name: mdl_question_numerical_units id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_numerical_units ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_numerical_units_id_seq'::regclass);


--
-- Name: mdl_question_response_analysis id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_response_analysis ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_response_analysis_id_seq'::regclass);


--
-- Name: mdl_question_response_count id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_response_count ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_response_count_id_seq'::regclass);


--
-- Name: mdl_question_statistics id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_statistics ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_statistics_id_seq'::regclass);


--
-- Name: mdl_question_truefalse id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_truefalse ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_truefalse_id_seq'::regclass);


--
-- Name: mdl_question_usages id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_question_usages ALTER COLUMN id SET DEFAULT nextval('public.mdl_question_usages_id_seq'::regclass);


--
-- Name: mdl_quiz id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_quiz ALTER COLUMN id SET DEFAULT nextval('public.mdl_quiz_id_seq'::regclass);


--
-- Name: mdl_quiz_attempts id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_quiz_attempts ALTER COLUMN id SET DEFAULT nextval('public.mdl_quiz_attempts_id_seq'::regclass);


--
-- Name: mdl_quiz_feedback id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_quiz_feedback ALTER COLUMN id SET DEFAULT nextval('public.mdl_quiz_feedback_id_seq'::regclass);


--
-- Name: mdl_quiz_grades id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_quiz_grades ALTER COLUMN id SET DEFAULT nextval('public.mdl_quiz_grades_id_seq'::regclass);


--
-- Name: mdl_quiz_overrides id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_quiz_overrides ALTER COLUMN id SET DEFAULT nextval('public.mdl_quiz_overrides_id_seq'::regclass);


--
-- Name: mdl_quiz_overview_regrades id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_quiz_overview_regrades ALTER COLUMN id SET DEFAULT nextval('public.mdl_quiz_overview_regrades_id_seq'::regclass);


--
-- Name: mdl_quiz_reports id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_quiz_reports ALTER COLUMN id SET DEFAULT nextval('public.mdl_quiz_reports_id_seq'::regclass);


--
-- Name: mdl_quiz_sections id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_quiz_sections ALTER COLUMN id SET DEFAULT nextval('public.mdl_quiz_sections_id_seq'::regclass);


--
-- Name: mdl_quiz_slot_tags id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_quiz_slot_tags ALTER COLUMN id SET DEFAULT nextval('public.mdl_quiz_slot_tags_id_seq'::regclass);


--
-- Name: mdl_quiz_slots id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_quiz_slots ALTER COLUMN id SET DEFAULT nextval('public.mdl_quiz_slots_id_seq'::regclass);


--
-- Name: mdl_quiz_statistics id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_quiz_statistics ALTER COLUMN id SET DEFAULT nextval('public.mdl_quiz_statistics_id_seq'::regclass);


--
-- Name: mdl_quizaccess_seb_quizsettings id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_quizaccess_seb_quizsettings ALTER COLUMN id SET DEFAULT nextval('public.mdl_quizaccess_seb_quizsettings_id_seq'::regclass);


--
-- Name: mdl_quizaccess_seb_template id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_quizaccess_seb_template ALTER COLUMN id SET DEFAULT nextval('public.mdl_quizaccess_seb_template_id_seq'::regclass);


--
-- Name: mdl_rating id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_rating ALTER COLUMN id SET DEFAULT nextval('public.mdl_rating_id_seq'::regclass);


--
-- Name: mdl_registration_hubs id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_registration_hubs ALTER COLUMN id SET DEFAULT nextval('public.mdl_registration_hubs_id_seq'::regclass);


--
-- Name: mdl_repository id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_repository ALTER COLUMN id SET DEFAULT nextval('public.mdl_repository_id_seq'::regclass);


--
-- Name: mdl_repository_instance_config id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_repository_instance_config ALTER COLUMN id SET DEFAULT nextval('public.mdl_repository_instance_config_id_seq'::regclass);


--
-- Name: mdl_repository_instances id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_repository_instances ALTER COLUMN id SET DEFAULT nextval('public.mdl_repository_instances_id_seq'::regclass);


--
-- Name: mdl_repository_onedrive_access id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_repository_onedrive_access ALTER COLUMN id SET DEFAULT nextval('public.mdl_repository_onedrive_access_id_seq'::regclass);


--
-- Name: mdl_resource id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_resource ALTER COLUMN id SET DEFAULT nextval('public.mdl_resource_id_seq'::regclass);


--
-- Name: mdl_resource_old id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_resource_old ALTER COLUMN id SET DEFAULT nextval('public.mdl_resource_old_id_seq'::regclass);


--
-- Name: mdl_role id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_role ALTER COLUMN id SET DEFAULT nextval('public.mdl_role_id_seq'::regclass);


--
-- Name: mdl_role_allow_assign id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_role_allow_assign ALTER COLUMN id SET DEFAULT nextval('public.mdl_role_allow_assign_id_seq'::regclass);


--
-- Name: mdl_role_allow_override id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_role_allow_override ALTER COLUMN id SET DEFAULT nextval('public.mdl_role_allow_override_id_seq'::regclass);


--
-- Name: mdl_role_allow_switch id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_role_allow_switch ALTER COLUMN id SET DEFAULT nextval('public.mdl_role_allow_switch_id_seq'::regclass);


--
-- Name: mdl_role_allow_view id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_role_allow_view ALTER COLUMN id SET DEFAULT nextval('public.mdl_role_allow_view_id_seq'::regclass);


--
-- Name: mdl_role_assignments id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_role_assignments ALTER COLUMN id SET DEFAULT nextval('public.mdl_role_assignments_id_seq'::regclass);


--
-- Name: mdl_role_capabilities id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_role_capabilities ALTER COLUMN id SET DEFAULT nextval('public.mdl_role_capabilities_id_seq'::regclass);


--
-- Name: mdl_role_context_levels id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_role_context_levels ALTER COLUMN id SET DEFAULT nextval('public.mdl_role_context_levels_id_seq'::regclass);


--
-- Name: mdl_role_names id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_role_names ALTER COLUMN id SET DEFAULT nextval('public.mdl_role_names_id_seq'::regclass);


--
-- Name: mdl_scale id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_scale ALTER COLUMN id SET DEFAULT nextval('public.mdl_scale_id_seq'::regclass);


--
-- Name: mdl_scale_history id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_scale_history ALTER COLUMN id SET DEFAULT nextval('public.mdl_scale_history_id_seq'::regclass);


--
-- Name: mdl_scorm id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_scorm ALTER COLUMN id SET DEFAULT nextval('public.mdl_scorm_id_seq'::regclass);


--
-- Name: mdl_scorm_aicc_session id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_scorm_aicc_session ALTER COLUMN id SET DEFAULT nextval('public.mdl_scorm_aicc_session_id_seq'::regclass);


--
-- Name: mdl_scorm_scoes id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_scorm_scoes ALTER COLUMN id SET DEFAULT nextval('public.mdl_scorm_scoes_id_seq'::regclass);


--
-- Name: mdl_scorm_scoes_data id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_scorm_scoes_data ALTER COLUMN id SET DEFAULT nextval('public.mdl_scorm_scoes_data_id_seq'::regclass);


--
-- Name: mdl_scorm_scoes_track id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_scorm_scoes_track ALTER COLUMN id SET DEFAULT nextval('public.mdl_scorm_scoes_track_id_seq'::regclass);


--
-- Name: mdl_scorm_seq_mapinfo id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_scorm_seq_mapinfo ALTER COLUMN id SET DEFAULT nextval('public.mdl_scorm_seq_mapinfo_id_seq'::regclass);


--
-- Name: mdl_scorm_seq_objective id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_scorm_seq_objective ALTER COLUMN id SET DEFAULT nextval('public.mdl_scorm_seq_objective_id_seq'::regclass);


--
-- Name: mdl_scorm_seq_rolluprule id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_scorm_seq_rolluprule ALTER COLUMN id SET DEFAULT nextval('public.mdl_scorm_seq_rolluprule_id_seq'::regclass);


--
-- Name: mdl_scorm_seq_rolluprulecond id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_scorm_seq_rolluprulecond ALTER COLUMN id SET DEFAULT nextval('public.mdl_scorm_seq_rolluprulecond_id_seq'::regclass);


--
-- Name: mdl_scorm_seq_rulecond id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_scorm_seq_rulecond ALTER COLUMN id SET DEFAULT nextval('public.mdl_scorm_seq_rulecond_id_seq'::regclass);


--
-- Name: mdl_scorm_seq_ruleconds id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_scorm_seq_ruleconds ALTER COLUMN id SET DEFAULT nextval('public.mdl_scorm_seq_ruleconds_id_seq'::regclass);


--
-- Name: mdl_search_index_requests id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_search_index_requests ALTER COLUMN id SET DEFAULT nextval('public.mdl_search_index_requests_id_seq'::regclass);


--
-- Name: mdl_search_simpledb_index id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_search_simpledb_index ALTER COLUMN id SET DEFAULT nextval('public.mdl_search_simpledb_index_id_seq'::regclass);


--
-- Name: mdl_sessions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_sessions ALTER COLUMN id SET DEFAULT nextval('public.mdl_sessions_id_seq'::regclass);


--
-- Name: mdl_stats_daily id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_stats_daily ALTER COLUMN id SET DEFAULT nextval('public.mdl_stats_daily_id_seq'::regclass);


--
-- Name: mdl_stats_monthly id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_stats_monthly ALTER COLUMN id SET DEFAULT nextval('public.mdl_stats_monthly_id_seq'::regclass);


--
-- Name: mdl_stats_user_daily id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_stats_user_daily ALTER COLUMN id SET DEFAULT nextval('public.mdl_stats_user_daily_id_seq'::regclass);


--
-- Name: mdl_stats_user_monthly id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_stats_user_monthly ALTER COLUMN id SET DEFAULT nextval('public.mdl_stats_user_monthly_id_seq'::regclass);


--
-- Name: mdl_stats_user_weekly id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_stats_user_weekly ALTER COLUMN id SET DEFAULT nextval('public.mdl_stats_user_weekly_id_seq'::regclass);


--
-- Name: mdl_stats_weekly id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_stats_weekly ALTER COLUMN id SET DEFAULT nextval('public.mdl_stats_weekly_id_seq'::regclass);


--
-- Name: mdl_survey id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_survey ALTER COLUMN id SET DEFAULT nextval('public.mdl_survey_id_seq'::regclass);


--
-- Name: mdl_survey_analysis id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_survey_analysis ALTER COLUMN id SET DEFAULT nextval('public.mdl_survey_analysis_id_seq'::regclass);


--
-- Name: mdl_survey_answers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_survey_answers ALTER COLUMN id SET DEFAULT nextval('public.mdl_survey_answers_id_seq'::regclass);


--
-- Name: mdl_survey_questions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_survey_questions ALTER COLUMN id SET DEFAULT nextval('public.mdl_survey_questions_id_seq'::regclass);


--
-- Name: mdl_tag id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tag ALTER COLUMN id SET DEFAULT nextval('public.mdl_tag_id_seq'::regclass);


--
-- Name: mdl_tag_area id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tag_area ALTER COLUMN id SET DEFAULT nextval('public.mdl_tag_area_id_seq'::regclass);


--
-- Name: mdl_tag_coll id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tag_coll ALTER COLUMN id SET DEFAULT nextval('public.mdl_tag_coll_id_seq'::regclass);


--
-- Name: mdl_tag_correlation id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tag_correlation ALTER COLUMN id SET DEFAULT nextval('public.mdl_tag_correlation_id_seq'::regclass);


--
-- Name: mdl_tag_instance id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tag_instance ALTER COLUMN id SET DEFAULT nextval('public.mdl_tag_instance_id_seq'::regclass);


--
-- Name: mdl_task_adhoc id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_task_adhoc ALTER COLUMN id SET DEFAULT nextval('public.mdl_task_adhoc_id_seq'::regclass);


--
-- Name: mdl_task_log id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_task_log ALTER COLUMN id SET DEFAULT nextval('public.mdl_task_log_id_seq'::regclass);


--
-- Name: mdl_task_scheduled id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_task_scheduled ALTER COLUMN id SET DEFAULT nextval('public.mdl_task_scheduled_id_seq'::regclass);


--
-- Name: mdl_tool_cohortroles id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_cohortroles ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_cohortroles_id_seq'::regclass);


--
-- Name: mdl_tool_customlang id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_customlang ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_customlang_id_seq'::regclass);


--
-- Name: mdl_tool_customlang_components id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_customlang_components ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_customlang_components_id_seq'::regclass);


--
-- Name: mdl_tool_dataprivacy_category id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_dataprivacy_category ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_dataprivacy_category_id_seq'::regclass);


--
-- Name: mdl_tool_dataprivacy_ctxexpired id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_dataprivacy_ctxexpired ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_dataprivacy_ctxexpired_id_seq'::regclass);


--
-- Name: mdl_tool_dataprivacy_ctxinstance id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_dataprivacy_ctxinstance ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_dataprivacy_ctxinstance_id_seq'::regclass);


--
-- Name: mdl_tool_dataprivacy_ctxlevel id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_dataprivacy_ctxlevel ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_dataprivacy_ctxlevel_id_seq'::regclass);


--
-- Name: mdl_tool_dataprivacy_purpose id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_dataprivacy_purpose ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_dataprivacy_purpose_id_seq'::regclass);


--
-- Name: mdl_tool_dataprivacy_purposerole id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_dataprivacy_purposerole ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_dataprivacy_purposerole_id_seq'::regclass);


--
-- Name: mdl_tool_dataprivacy_request id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_dataprivacy_request ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_dataprivacy_request_id_seq'::regclass);


--
-- Name: mdl_tool_monitor_events id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_monitor_events ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_monitor_events_id_seq'::regclass);


--
-- Name: mdl_tool_monitor_history id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_monitor_history ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_monitor_history_id_seq'::regclass);


--
-- Name: mdl_tool_monitor_rules id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_monitor_rules ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_monitor_rules_id_seq'::regclass);


--
-- Name: mdl_tool_monitor_subscriptions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_monitor_subscriptions ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_monitor_subscriptions_id_seq'::regclass);


--
-- Name: mdl_tool_policy id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_policy ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_policy_id_seq'::regclass);


--
-- Name: mdl_tool_policy_acceptances id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_policy_acceptances ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_policy_acceptances_id_seq'::regclass);


--
-- Name: mdl_tool_policy_versions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_policy_versions ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_policy_versions_id_seq'::regclass);


--
-- Name: mdl_tool_recyclebin_category id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_recyclebin_category ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_recyclebin_category_id_seq'::regclass);


--
-- Name: mdl_tool_recyclebin_course id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_recyclebin_course ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_recyclebin_course_id_seq'::regclass);


--
-- Name: mdl_tool_usertours_steps id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_usertours_steps ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_usertours_steps_id_seq'::regclass);


--
-- Name: mdl_tool_usertours_tours id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_tool_usertours_tours ALTER COLUMN id SET DEFAULT nextval('public.mdl_tool_usertours_tours_id_seq'::regclass);


--
-- Name: mdl_upgrade_log id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_upgrade_log ALTER COLUMN id SET DEFAULT nextval('public.mdl_upgrade_log_id_seq'::regclass);


--
-- Name: mdl_url id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_url ALTER COLUMN id SET DEFAULT nextval('public.mdl_url_id_seq'::regclass);


--
-- Name: mdl_user id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_user ALTER COLUMN id SET DEFAULT nextval('public.mdl_user_id_seq'::regclass);


--
-- Name: mdl_user_devices id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_user_devices ALTER COLUMN id SET DEFAULT nextval('public.mdl_user_devices_id_seq'::regclass);


--
-- Name: mdl_user_enrolments id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_user_enrolments ALTER COLUMN id SET DEFAULT nextval('public.mdl_user_enrolments_id_seq'::regclass);


--
-- Name: mdl_user_info_category id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_user_info_category ALTER COLUMN id SET DEFAULT nextval('public.mdl_user_info_category_id_seq'::regclass);


--
-- Name: mdl_user_info_data id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_user_info_data ALTER COLUMN id SET DEFAULT nextval('public.mdl_user_info_data_id_seq'::regclass);


--
-- Name: mdl_user_info_field id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_user_info_field ALTER COLUMN id SET DEFAULT nextval('public.mdl_user_info_field_id_seq'::regclass);


--
-- Name: mdl_user_lastaccess id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_user_lastaccess ALTER COLUMN id SET DEFAULT nextval('public.mdl_user_lastaccess_id_seq'::regclass);


--
-- Name: mdl_user_password_history id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_user_password_history ALTER COLUMN id SET DEFAULT nextval('public.mdl_user_password_history_id_seq'::regclass);


--
-- Name: mdl_user_password_resets id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_user_password_resets ALTER COLUMN id SET DEFAULT nextval('public.mdl_user_password_resets_id_seq'::regclass);


--
-- Name: mdl_user_preferences id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_user_preferences ALTER COLUMN id SET DEFAULT nextval('public.mdl_user_preferences_id_seq'::regclass);


--
-- Name: mdl_user_private_key id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_user_private_key ALTER COLUMN id SET DEFAULT nextval('public.mdl_user_private_key_id_seq'::regclass);


--
-- Name: mdl_wiki id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_wiki ALTER COLUMN id SET DEFAULT nextval('public.mdl_wiki_id_seq'::regclass);


--
-- Name: mdl_wiki_links id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_wiki_links ALTER COLUMN id SET DEFAULT nextval('public.mdl_wiki_links_id_seq'::regclass);


--
-- Name: mdl_wiki_locks id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_wiki_locks ALTER COLUMN id SET DEFAULT nextval('public.mdl_wiki_locks_id_seq'::regclass);


--
-- Name: mdl_wiki_pages id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_wiki_pages ALTER COLUMN id SET DEFAULT nextval('public.mdl_wiki_pages_id_seq'::regclass);


--
-- Name: mdl_wiki_subwikis id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_wiki_subwikis ALTER COLUMN id SET DEFAULT nextval('public.mdl_wiki_subwikis_id_seq'::regclass);


--
-- Name: mdl_wiki_synonyms id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_wiki_synonyms ALTER COLUMN id SET DEFAULT nextval('public.mdl_wiki_synonyms_id_seq'::regclass);


--
-- Name: mdl_wiki_versions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_wiki_versions ALTER COLUMN id SET DEFAULT nextval('public.mdl_wiki_versions_id_seq'::regclass);


--
-- Name: mdl_workshop id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_workshop ALTER COLUMN id SET DEFAULT nextval('public.mdl_workshop_id_seq'::regclass);


--
-- Name: mdl_workshop_aggregations id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_workshop_aggregations ALTER COLUMN id SET DEFAULT nextval('public.mdl_workshop_aggregations_id_seq'::regclass);


--
-- Name: mdl_workshop_assessments id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_workshop_assessments ALTER COLUMN id SET DEFAULT nextval('public.mdl_workshop_assessments_id_seq'::regclass);


--
-- Name: mdl_workshop_grades id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_workshop_grades ALTER COLUMN id SET DEFAULT nextval('public.mdl_workshop_grades_id_seq'::regclass);


--
-- Name: mdl_workshop_submissions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_workshop_submissions ALTER COLUMN id SET DEFAULT nextval('public.mdl_workshop_submissions_id_seq'::regclass);


--
-- Name: mdl_workshopallocation_scheduled id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_workshopallocation_scheduled ALTER COLUMN id SET DEFAULT nextval('public.mdl_workshopallocation_scheduled_id_seq'::regclass);


--
-- Name: mdl_workshopeval_best_settings id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_workshopeval_best_settings ALTER COLUMN id SET DEFAULT nextval('public.mdl_workshopeval_best_settings_id_seq'::regclass);


--
-- Name: mdl_workshopform_accumulative id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_workshopform_accumulative ALTER COLUMN id SET DEFAULT nextval('public.mdl_workshopform_accumulative_id_seq'::regclass);


--
-- Name: mdl_workshopform_comments id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_workshopform_comments ALTER COLUMN id SET DEFAULT nextval('public.mdl_workshopform_comments_id_seq'::regclass);


--
-- Name: mdl_workshopform_numerrors id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_workshopform_numerrors ALTER COLUMN id SET DEFAULT nextval('public.mdl_workshopform_numerrors_id_seq'::regclass);


--
-- Name: mdl_workshopform_numerrors_map id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_workshopform_numerrors_map ALTER COLUMN id SET DEFAULT nextval('public.mdl_workshopform_numerrors_map_id_seq'::regclass);


--
-- Name: mdl_workshopform_rubric id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_workshopform_rubric ALTER COLUMN id SET DEFAULT nextval('public.mdl_workshopform_rubric_id_seq'::regclass);


--
-- Name: mdl_workshopform_rubric_config id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_workshopform_rubric_config ALTER COLUMN id SET DEFAULT nextval('public.mdl_workshopform_rubric_config_id_seq'::regclass);


--
-- Name: mdl_workshopform_rubric_levels id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdl_workshopform_rubric_levels ALTER COLUMN id SET DEFAULT nextval('public.mdl_workshopform_rubric_levels_id_seq'::regclass);


--
-- Data for Name: mdl_analytics_indicator_calc; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_analytics_indicator_calc (id, starttime, endtime, contextid, sampleorigin, sampleid, indicator, value, timecreated) FROM stdin;
\.


--
-- Data for Name: mdl_analytics_models; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_analytics_models (id, enabled, trained, name, target, indicators, timesplitting, predictionsprocessor, version, contextids, timecreated, timemodified, usermodified) FROM stdin;
1	0	0	\N	\\core_course\\analytics\\target\\course_dropout	["\\\\core\\\\analytics\\\\indicator\\\\any_access_after_end","\\\\core\\\\analytics\\\\indicator\\\\any_access_before_start","\\\\core\\\\analytics\\\\indicator\\\\any_write_action_in_course","\\\\core\\\\analytics\\\\indicator\\\\read_actions","\\\\core_course\\\\analytics\\\\indicator\\\\completion_enabled","\\\\core_course\\\\analytics\\\\indicator\\\\potential_cognitive_depth","\\\\core_course\\\\analytics\\\\indicator\\\\potential_social_breadth","\\\\mod_assign\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_assign\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_book\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_book\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_chat\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_chat\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_choice\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_choice\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_data\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_data\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_feedback\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_feedback\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_folder\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_folder\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_forum\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_forum\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_glossary\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_glossary\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_imscp\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_imscp\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_label\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_label\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_lesson\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_lesson\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_lti\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_lti\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_page\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_page\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_quiz\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_quiz\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_resource\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_resource\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_scorm\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_scorm\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_survey\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_survey\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_url\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_url\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_wiki\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_wiki\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_workshop\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_workshop\\\\analytics\\\\indicator\\\\social_breadth"]	\N	\N	1597315737	\N	1597315737	1597315737	0
2	1	1	\N	\\core_course\\analytics\\target\\no_teaching	["\\\\core_course\\\\analytics\\\\indicator\\\\no_teacher","\\\\core_course\\\\analytics\\\\indicator\\\\no_student"]	\\core\\analytics\\time_splitting\\single_range	\N	1597315737	\N	1597315737	1597315737	0
3	1	1	\N	\\core_user\\analytics\\target\\upcoming_activities_due	["\\\\core_course\\\\analytics\\\\indicator\\\\activities_due"]	\\core\\analytics\\time_splitting\\upcoming_week	\N	1597315737	\N	1597315737	1597315737	0
4	1	1	\N	\\core_course\\analytics\\target\\no_access_since_course_start	["\\\\core\\\\analytics\\\\indicator\\\\any_course_access"]	\\core\\analytics\\time_splitting\\one_month_after_start	\N	1597315737	\N	1597315737	1597315737	0
5	1	1	\N	\\core_course\\analytics\\target\\no_recent_accesses	["\\\\core\\\\analytics\\\\indicator\\\\any_course_access"]	\\core\\analytics\\time_splitting\\past_month	\N	1597315737	\N	1597315737	1597315737	0
\.


--
-- Data for Name: mdl_analytics_models_log; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_analytics_models_log (id, modelid, version, evaluationmode, target, indicators, timesplitting, score, info, dir, timecreated, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_analytics_predict_samples; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_analytics_predict_samples (id, modelid, analysableid, timesplitting, rangeindex, sampleids, timecreated, timemodified) FROM stdin;
\.


--
-- Data for Name: mdl_analytics_prediction_actions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_analytics_prediction_actions (id, predictionid, userid, actionname, timecreated) FROM stdin;
\.


--
-- Data for Name: mdl_analytics_predictions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_analytics_predictions (id, modelid, contextid, sampleid, rangeindex, prediction, predictionscore, calculations, timecreated, timestart, timeend) FROM stdin;
\.


--
-- Data for Name: mdl_analytics_train_samples; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_analytics_train_samples (id, modelid, analysableid, timesplitting, sampleids, timecreated) FROM stdin;
\.


--
-- Data for Name: mdl_analytics_used_analysables; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_analytics_used_analysables (id, modelid, action, analysableid, firstanalysis, timeanalysed) FROM stdin;
\.


--
-- Data for Name: mdl_analytics_used_files; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_analytics_used_files (id, modelid, fileid, action, "time") FROM stdin;
\.


--
-- Data for Name: mdl_assign; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assign (id, course, name, intro, introformat, alwaysshowdescription, nosubmissions, submissiondrafts, sendnotifications, sendlatenotifications, duedate, allowsubmissionsfromdate, grade, timemodified, requiresubmissionstatement, completionsubmit, cutoffdate, gradingduedate, teamsubmission, requireallteammemberssubmit, teamsubmissiongroupingid, blindmarking, hidegrader, revealidentities, attemptreopenmethod, maxattempts, markingworkflow, markingallocation, sendstudentnotifications, preventsubmissionnotingroup) FROM stdin;
\.


--
-- Data for Name: mdl_assign_grades; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assign_grades (id, assignment, userid, timecreated, timemodified, grader, grade, attemptnumber) FROM stdin;
\.


--
-- Data for Name: mdl_assign_overrides; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assign_overrides (id, assignid, groupid, userid, sortorder, allowsubmissionsfromdate, duedate, cutoffdate) FROM stdin;
\.


--
-- Data for Name: mdl_assign_plugin_config; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assign_plugin_config (id, assignment, plugin, subtype, name, value) FROM stdin;
\.


--
-- Data for Name: mdl_assign_submission; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assign_submission (id, assignment, userid, timecreated, timemodified, status, groupid, attemptnumber, latest) FROM stdin;
\.


--
-- Data for Name: mdl_assign_user_flags; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assign_user_flags (id, userid, assignment, locked, mailed, extensionduedate, workflowstate, allocatedmarker) FROM stdin;
\.


--
-- Data for Name: mdl_assign_user_mapping; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assign_user_mapping (id, assignment, userid) FROM stdin;
\.


--
-- Data for Name: mdl_assignfeedback_comments; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assignfeedback_comments (id, assignment, grade, commenttext, commentformat) FROM stdin;
\.


--
-- Data for Name: mdl_assignfeedback_editpdf_annot; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assignfeedback_editpdf_annot (id, gradeid, pageno, x, y, endx, endy, path, type, colour, draft) FROM stdin;
\.


--
-- Data for Name: mdl_assignfeedback_editpdf_cmnt; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assignfeedback_editpdf_cmnt (id, gradeid, x, y, width, rawtext, pageno, colour, draft) FROM stdin;
\.


--
-- Data for Name: mdl_assignfeedback_editpdf_queue; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assignfeedback_editpdf_queue (id, submissionid, submissionattempt, attemptedconversions) FROM stdin;
\.


--
-- Data for Name: mdl_assignfeedback_editpdf_quick; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assignfeedback_editpdf_quick (id, userid, rawtext, width, colour) FROM stdin;
\.


--
-- Data for Name: mdl_assignfeedback_editpdf_rot; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assignfeedback_editpdf_rot (id, gradeid, pageno, pathnamehash, isrotated, degree) FROM stdin;
\.


--
-- Data for Name: mdl_assignfeedback_file; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assignfeedback_file (id, assignment, grade, numfiles) FROM stdin;
\.


--
-- Data for Name: mdl_assignment; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assignment (id, course, name, intro, introformat, assignmenttype, resubmit, preventlate, emailteachers, var1, var2, var3, var4, var5, maxbytes, timedue, timeavailable, grade, timemodified) FROM stdin;
\.


--
-- Data for Name: mdl_assignment_submissions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assignment_submissions (id, assignment, userid, timecreated, timemodified, numfiles, data1, data2, grade, submissioncomment, format, teacher, timemarked, mailed) FROM stdin;
\.


--
-- Data for Name: mdl_assignment_upgrade; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assignment_upgrade (id, oldcmid, oldinstance, newcmid, newinstance, timecreated) FROM stdin;
\.


--
-- Data for Name: mdl_assignsubmission_file; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assignsubmission_file (id, assignment, submission, numfiles) FROM stdin;
\.


--
-- Data for Name: mdl_assignsubmission_onlinetext; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_assignsubmission_onlinetext (id, assignment, submission, onlinetext, onlineformat) FROM stdin;
\.


--
-- Data for Name: mdl_auth_oauth2_linked_login; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_auth_oauth2_linked_login (id, timecreated, timemodified, usermodified, userid, issuerid, username, email, confirmtoken, confirmtokenexpires) FROM stdin;
\.


--
-- Data for Name: mdl_backup_controllers; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_backup_controllers (id, backupid, operation, type, itemid, format, interactive, purpose, userid, status, execution, executiontime, checksum, timecreated, timemodified, progress, controller) FROM stdin;
1	3efe9ad54c46989e3ffc61d8628ecc96	backup	course	1	moodle2	1	10	2	500	1	0	936b1ec16a7679c7a262bcb9624a9509	1597317708	0	0.00000000000000	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
\.


--
-- Data for Name: mdl_backup_courses; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_backup_courses (id, courseid, laststarttime, lastendtime, laststatus, nextstarttime) FROM stdin;
\.


--
-- Data for Name: mdl_backup_logs; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_backup_logs (id, backupid, loglevel, message, timecreated) FROM stdin;
\.


--
-- Data for Name: mdl_badge; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_badge (id, name, description, timecreated, timemodified, usercreated, usermodified, issuername, issuerurl, issuercontact, expiredate, expireperiod, type, courseid, message, messagesubject, attachment, notification, status, nextcron, version, language, imageauthorname, imageauthoremail, imageauthorurl, imagecaption) FROM stdin;
\.


--
-- Data for Name: mdl_badge_alignment; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_badge_alignment (id, badgeid, targetname, targeturl, targetdescription, targetframework, targetcode) FROM stdin;
\.


--
-- Data for Name: mdl_badge_backpack; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_badge_backpack (id, userid, email, backpackuid, autosync, password, externalbackpackid) FROM stdin;
\.


--
-- Data for Name: mdl_badge_backpack_oauth2; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_badge_backpack_oauth2 (id, usermodified, timecreated, timemodified, userid, issuerid, externalbackpackid, token, refreshtoken, expires, scope) FROM stdin;
\.


--
-- Data for Name: mdl_badge_criteria; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_badge_criteria (id, badgeid, criteriatype, method, description, descriptionformat) FROM stdin;
\.


--
-- Data for Name: mdl_badge_criteria_met; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_badge_criteria_met (id, issuedid, critid, userid, datemet) FROM stdin;
\.


--
-- Data for Name: mdl_badge_criteria_param; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_badge_criteria_param (id, critid, name, value) FROM stdin;
\.


--
-- Data for Name: mdl_badge_endorsement; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_badge_endorsement (id, badgeid, issuername, issuerurl, issueremail, claimid, claimcomment, dateissued) FROM stdin;
\.


--
-- Data for Name: mdl_badge_external; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_badge_external (id, backpackid, collectionid, entityid, assertion) FROM stdin;
\.


--
-- Data for Name: mdl_badge_external_backpack; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_badge_external_backpack (id, backpackapiurl, backpackweburl, apiversion, sortorder, password, oauth2_issuerid) FROM stdin;
1	https://api.badgr.io/v2	https://badgr.io	2	1		\N
\.


--
-- Data for Name: mdl_badge_external_identifier; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_badge_external_identifier (id, sitebackpackid, internalid, externalid, type) FROM stdin;
\.


--
-- Data for Name: mdl_badge_issued; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_badge_issued (id, badgeid, userid, uniquehash, dateissued, dateexpire, visible, issuernotified) FROM stdin;
\.


--
-- Data for Name: mdl_badge_manual_award; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_badge_manual_award (id, badgeid, recipientid, issuerid, issuerrole, datemet) FROM stdin;
\.


--
-- Data for Name: mdl_badge_related; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_badge_related (id, badgeid, relatedbadgeid) FROM stdin;
\.


--
-- Data for Name: mdl_block; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_block (id, name, cron, lastcron, visible) FROM stdin;
1	activity_modules	0	0	1
2	activity_results	0	0	1
3	admin_bookmarks	0	0	1
4	badges	0	0	1
5	blog_menu	0	0	1
6	blog_recent	0	0	1
7	blog_tags	0	0	1
8	calendar_month	0	0	1
9	calendar_upcoming	0	0	1
10	comments	0	0	1
11	completionstatus	0	0	1
12	course_list	0	0	1
13	course_summary	0	0	1
14	feedback	0	0	1
15	globalsearch	0	0	1
16	glossary_random	0	0	1
17	html	0	0	1
18	login	0	0	1
19	lp	0	0	1
20	mentees	0	0	1
21	mnet_hosts	0	0	1
22	myoverview	0	0	1
23	myprofile	0	0	1
24	navigation	0	0	1
25	news_items	0	0	1
26	online_users	0	0	1
27	private_files	0	0	1
28	quiz_results	0	0	0
29	recent_activity	0	0	1
30	recentlyaccessedcourses	0	0	1
31	recentlyaccesseditems	0	0	1
32	rss_client	0	0	1
33	search_forums	0	0	1
34	section_links	0	0	1
35	selfcompletion	0	0	1
36	settings	0	0	1
37	site_main_menu	0	0	1
38	social_activities	0	0	1
39	starredcourses	0	0	1
40	tag_flickr	0	0	1
41	tag_youtube	0	0	0
42	tags	0	0	1
43	timeline	0	0	1
\.


--
-- Data for Name: mdl_block_instances; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_block_instances (id, blockname, parentcontextid, showinsubcontexts, requiredbytheme, pagetypepattern, subpagepattern, defaultregion, defaultweight, configdata, timecreated, timemodified) FROM stdin;
1	admin_bookmarks	1	0	0	admin-*	\N	side-pre	2		1597315788	1597315788
2	timeline	1	0	0	my-index	2	side-post	0		1597315788	1597315788
3	private_files	1	0	0	my-index	2	side-post	1		1597315788	1597315788
4	online_users	1	0	0	my-index	2	side-post	2		1597315788	1597315788
5	badges	1	0	0	my-index	2	side-post	3		1597315788	1597315788
6	calendar_month	1	0	0	my-index	2	side-post	4		1597315788	1597315788
7	calendar_upcoming	1	0	0	my-index	2	side-post	5		1597315788	1597315788
8	lp	1	0	0	my-index	2	content	0		1597315788	1597315788
9	recentlyaccessedcourses	1	0	0	my-index	2	content	1		1597315788	1597315788
10	myoverview	1	0	0	my-index	2	content	2		1597315788	1597315788
11	myoverview	5	0	0	my-index	4	content	2		1597316130	1597316130
12	recentlyaccessedcourses	5	0	0	my-index	4	content	1		1597316130	1597316130
13	lp	5	0	0	my-index	4	content	0		1597316130	1597316130
14	calendar_upcoming	5	0	0	my-index	4	side-post	5		1597316130	1597316130
15	calendar_month	5	0	0	my-index	4	side-post	4		1597316130	1597316130
16	badges	5	0	0	my-index	4	side-post	3		1597316130	1597316130
17	online_users	5	0	0	my-index	4	side-post	2		1597316130	1597316130
18	private_files	5	0	0	my-index	4	side-post	1		1597316130	1597316130
19	timeline	5	0	0	my-index	4	side-post	0		1597316130	1597316130
\.


--
-- Data for Name: mdl_block_positions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_block_positions (id, blockinstanceid, contextid, pagetype, subpage, visible, region, weight) FROM stdin;
\.


--
-- Data for Name: mdl_block_recent_activity; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_block_recent_activity (id, courseid, cmid, timecreated, userid, action, modname) FROM stdin;
\.


--
-- Data for Name: mdl_block_recentlyaccesseditems; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_block_recentlyaccesseditems (id, courseid, cmid, userid, timeaccess) FROM stdin;
\.


--
-- Data for Name: mdl_block_rss_client; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_block_rss_client (id, userid, title, preferredtitle, description, shared, url, skiptime, skipuntil) FROM stdin;
\.


--
-- Data for Name: mdl_blog_association; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_blog_association (id, contextid, blogid) FROM stdin;
\.


--
-- Data for Name: mdl_blog_external; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_blog_external (id, userid, name, description, url, filtertags, failedlastsync, timemodified, timefetched) FROM stdin;
\.


--
-- Data for Name: mdl_book; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_book (id, course, name, intro, introformat, numbering, navstyle, customtitles, revision, timecreated, timemodified) FROM stdin;
\.


--
-- Data for Name: mdl_book_chapters; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_book_chapters (id, bookid, pagenum, subchapter, title, content, contentformat, hidden, timecreated, timemodified, importsrc) FROM stdin;
\.


--
-- Data for Name: mdl_cache_filters; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_cache_filters (id, filter, version, md5key, rawtext, timemodified) FROM stdin;
\.


--
-- Data for Name: mdl_cache_flags; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_cache_flags (id, flagtype, name, timemodified, value, expiry) FROM stdin;
1	userpreferenceschanged	2	1599805894	1	1599834694
\.


--
-- Data for Name: mdl_capabilities; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_capabilities (id, name, captype, contextlevel, component, riskbitmask) FROM stdin;
1	moodle/site:config	write	10	moodle	62
2	moodle/site:configview	read	10	moodle	0
3	moodle/site:readallmessages	read	10	moodle	8
4	moodle/site:manageallmessaging	write	10	moodle	8
5	moodle/site:deleteanymessage	write	10	moodle	32
6	moodle/site:sendmessage	write	10	moodle	16
7	moodle/site:deleteownmessage	write	10	moodle	0
8	moodle/site:approvecourse	write	40	moodle	4
9	moodle/backup:backupcourse	write	50	moodle	28
10	moodle/backup:backupsection	write	50	moodle	28
11	moodle/backup:backupactivity	write	70	moodle	28
12	moodle/backup:backuptargetimport	read	50	moodle	28
13	moodle/backup:downloadfile	write	50	moodle	28
14	moodle/backup:configure	write	50	moodle	28
15	moodle/backup:userinfo	read	50	moodle	8
16	moodle/backup:anonymise	read	50	moodle	8
17	moodle/restore:restorecourse	write	50	moodle	28
18	moodle/restore:restoresection	write	50	moodle	28
19	moodle/restore:restoreactivity	write	50	moodle	28
20	moodle/restore:viewautomatedfilearea	write	50	moodle	28
21	moodle/restore:restoretargetimport	write	50	moodle	28
22	moodle/restore:uploadfile	write	50	moodle	28
23	moodle/restore:configure	write	50	moodle	28
24	moodle/restore:rolldates	write	50	moodle	0
25	moodle/restore:userinfo	write	50	moodle	30
26	moodle/restore:createuser	write	10	moodle	24
27	moodle/site:manageblocks	write	80	moodle	20
28	moodle/site:accessallgroups	read	70	moodle	0
29	moodle/site:viewanonymousevents	read	70	moodle	8
30	moodle/site:viewfullnames	read	70	moodle	0
31	moodle/site:viewuseridentity	read	70	moodle	0
32	moodle/site:viewreports	read	50	moodle	8
33	moodle/site:trustcontent	write	70	moodle	4
34	moodle/site:uploadusers	write	10	moodle	24
35	moodle/filter:manage	write	50	moodle	0
36	moodle/user:create	write	10	moodle	24
37	moodle/user:delete	write	10	moodle	40
38	moodle/user:update	write	10	moodle	24
39	moodle/user:viewdetails	read	50	moodle	0
40	moodle/user:viewalldetails	read	30	moodle	8
41	moodle/user:viewlastip	read	30	moodle	8
42	moodle/user:viewhiddendetails	read	50	moodle	8
43	moodle/user:loginas	write	50	moodle	30
44	moodle/user:managesyspages	write	10	moodle	0
45	moodle/user:manageblocks	write	30	moodle	0
46	moodle/user:manageownblocks	write	10	moodle	0
47	moodle/user:manageownfiles	write	10	moodle	0
48	moodle/user:ignoreuserquota	write	10	moodle	0
49	moodle/my:configsyspages	write	10	moodle	0
50	moodle/role:assign	write	50	moodle	28
51	moodle/role:review	read	50	moodle	8
52	moodle/role:override	write	50	moodle	28
53	moodle/role:safeoverride	write	50	moodle	16
54	moodle/role:manage	write	10	moodle	28
55	moodle/role:switchroles	read	50	moodle	12
56	moodle/category:manage	write	40	moodle	4
57	moodle/category:viewcourselist	read	40	moodle	0
58	moodle/category:viewhiddencategories	read	40	moodle	0
59	moodle/cohort:manage	write	40	moodle	0
60	moodle/cohort:assign	write	40	moodle	0
61	moodle/cohort:view	read	50	moodle	0
62	moodle/course:create	write	40	moodle	4
63	moodle/course:creategroupconversations	write	50	moodle	4
64	moodle/course:request	write	40	moodle	0
65	moodle/course:delete	write	50	moodle	32
66	moodle/course:update	write	50	moodle	4
67	moodle/course:view	read	50	moodle	0
68	moodle/course:enrolreview	read	50	moodle	8
69	moodle/course:enrolconfig	write	50	moodle	8
70	moodle/course:reviewotherusers	read	50	moodle	0
71	moodle/course:bulkmessaging	write	50	moodle	16
72	moodle/course:viewhiddenuserfields	read	50	moodle	8
73	moodle/course:viewhiddencourses	read	50	moodle	0
74	moodle/course:visibility	write	50	moodle	0
75	moodle/course:managefiles	write	50	moodle	4
76	moodle/course:ignoreavailabilityrestrictions	read	70	moodle	0
77	moodle/course:ignorefilesizelimits	write	50	moodle	0
78	moodle/course:manageactivities	write	70	moodle	4
79	moodle/course:activityvisibility	write	70	moodle	0
80	moodle/course:viewhiddenactivities	read	70	moodle	0
81	moodle/course:viewparticipants	read	50	moodle	0
82	moodle/course:changefullname	write	50	moodle	4
83	moodle/course:changeshortname	write	50	moodle	4
84	moodle/course:changelockedcustomfields	write	50	moodle	16
85	moodle/course:configurecustomfields	write	10	moodle	16
86	moodle/course:renameroles	write	50	moodle	0
87	moodle/course:changeidnumber	write	50	moodle	4
88	moodle/course:changecategory	write	50	moodle	4
89	moodle/course:changesummary	write	50	moodle	4
90	moodle/course:setforcedlanguage	write	50	moodle	0
91	moodle/site:viewparticipants	read	10	moodle	0
92	moodle/course:isincompletionreports	read	50	moodle	0
93	moodle/course:viewscales	read	50	moodle	0
94	moodle/course:managescales	write	50	moodle	0
95	moodle/course:managegroups	write	50	moodle	4
96	moodle/course:reset	write	50	moodle	32
97	moodle/course:viewsuspendedusers	read	50	moodle	0
98	moodle/course:tag	write	50	moodle	16
99	moodle/blog:view	read	10	moodle	0
100	moodle/blog:search	read	10	moodle	0
101	moodle/blog:viewdrafts	read	10	moodle	8
102	moodle/blog:create	write	10	moodle	16
103	moodle/blog:manageentries	write	10	moodle	16
104	moodle/blog:manageexternal	write	10	moodle	16
105	moodle/calendar:manageownentries	write	50	moodle	16
106	moodle/calendar:managegroupentries	write	50	moodle	16
107	moodle/calendar:manageentries	write	50	moodle	16
108	moodle/user:editprofile	write	30	moodle	24
109	moodle/user:editownprofile	write	10	moodle	16
110	moodle/user:changeownpassword	write	10	moodle	0
111	moodle/user:readuserposts	read	30	moodle	0
112	moodle/user:readuserblogs	read	30	moodle	0
113	moodle/user:viewuseractivitiesreport	read	30	moodle	8
114	moodle/user:editmessageprofile	write	30	moodle	16
115	moodle/user:editownmessageprofile	write	10	moodle	0
116	moodle/question:managecategory	write	50	moodle	20
117	moodle/question:add	write	50	moodle	20
118	moodle/question:editmine	write	50	moodle	20
119	moodle/question:editall	write	50	moodle	20
120	moodle/question:viewmine	read	50	moodle	0
121	moodle/question:viewall	read	50	moodle	0
122	moodle/question:usemine	read	50	moodle	0
123	moodle/question:useall	read	50	moodle	0
124	moodle/question:movemine	write	50	moodle	0
125	moodle/question:moveall	write	50	moodle	0
126	moodle/question:config	write	10	moodle	2
127	moodle/question:flag	write	50	moodle	0
128	moodle/question:tagmine	write	50	moodle	0
129	moodle/question:tagall	write	50	moodle	0
130	moodle/site:doclinks	read	10	moodle	0
131	moodle/course:sectionvisibility	write	50	moodle	0
132	moodle/course:useremail	write	50	moodle	0
133	moodle/course:viewhiddensections	read	50	moodle	0
134	moodle/course:setcurrentsection	write	50	moodle	0
135	moodle/course:movesections	write	50	moodle	0
136	moodle/site:mnetlogintoremote	read	10	moodle	0
137	moodle/grade:viewall	read	50	moodle	8
138	moodle/grade:view	read	50	moodle	0
139	moodle/grade:viewhidden	read	50	moodle	8
140	moodle/grade:import	write	50	moodle	12
141	moodle/grade:export	read	50	moodle	8
142	moodle/grade:manage	write	50	moodle	12
143	moodle/grade:edit	write	50	moodle	12
144	moodle/grade:managegradingforms	write	50	moodle	12
145	moodle/grade:sharegradingforms	write	10	moodle	4
146	moodle/grade:managesharedforms	write	10	moodle	4
147	moodle/grade:manageoutcomes	write	50	moodle	0
148	moodle/grade:manageletters	write	50	moodle	0
149	moodle/grade:hide	write	50	moodle	0
150	moodle/grade:lock	write	50	moodle	0
151	moodle/grade:unlock	write	50	moodle	0
152	moodle/my:manageblocks	write	10	moodle	0
153	moodle/notes:view	read	50	moodle	0
154	moodle/notes:manage	write	50	moodle	16
155	moodle/tag:manage	write	10	moodle	16
156	moodle/tag:edit	write	10	moodle	16
157	moodle/tag:flag	write	10	moodle	16
158	moodle/tag:editblocks	write	10	moodle	0
159	moodle/block:view	read	80	moodle	0
160	moodle/block:edit	write	80	moodle	20
161	moodle/portfolio:export	read	10	moodle	0
162	moodle/comment:view	read	50	moodle	0
163	moodle/comment:post	write	50	moodle	24
164	moodle/comment:delete	write	50	moodle	32
165	moodle/webservice:createtoken	write	10	moodle	62
166	moodle/webservice:managealltokens	write	10	moodle	42
167	moodle/webservice:createmobiletoken	write	10	moodle	24
168	moodle/rating:view	read	50	moodle	0
169	moodle/rating:viewany	read	50	moodle	8
170	moodle/rating:viewall	read	50	moodle	8
171	moodle/rating:rate	write	50	moodle	0
172	moodle/course:markcomplete	write	50	moodle	0
173	moodle/course:overridecompletion	write	50	moodle	0
174	moodle/badges:manageglobalsettings	write	10	moodle	34
175	moodle/badges:viewbadges	read	50	moodle	0
176	moodle/badges:manageownbadges	write	30	moodle	0
177	moodle/badges:viewotherbadges	read	30	moodle	0
178	moodle/badges:earnbadge	write	50	moodle	0
179	moodle/badges:createbadge	write	50	moodle	16
180	moodle/badges:deletebadge	write	50	moodle	32
181	moodle/badges:configuredetails	write	50	moodle	16
182	moodle/badges:configurecriteria	write	50	moodle	4
183	moodle/badges:configuremessages	write	50	moodle	16
184	moodle/badges:awardbadge	write	50	moodle	16
185	moodle/badges:revokebadge	write	50	moodle	16
186	moodle/badges:viewawarded	read	50	moodle	8
187	moodle/site:forcelanguage	read	10	moodle	0
188	moodle/search:query	read	10	moodle	0
189	moodle/competency:competencymanage	write	40	moodle	0
190	moodle/competency:competencyview	read	40	moodle	0
191	moodle/competency:competencygrade	write	50	moodle	0
192	moodle/competency:coursecompetencymanage	write	50	moodle	0
193	moodle/competency:coursecompetencyconfigure	write	70	moodle	0
194	moodle/competency:coursecompetencygradable	read	50	moodle	0
195	moodle/competency:coursecompetencyview	read	50	moodle	0
196	moodle/competency:evidencedelete	write	30	moodle	0
197	moodle/competency:planmanage	write	30	moodle	0
198	moodle/competency:planmanagedraft	write	30	moodle	0
199	moodle/competency:planmanageown	write	30	moodle	0
200	moodle/competency:planmanageowndraft	write	30	moodle	0
201	moodle/competency:planview	read	30	moodle	0
202	moodle/competency:planviewdraft	read	30	moodle	0
203	moodle/competency:planviewown	read	30	moodle	0
204	moodle/competency:planviewowndraft	read	30	moodle	0
205	moodle/competency:planrequestreview	write	30	moodle	0
206	moodle/competency:planrequestreviewown	write	30	moodle	0
207	moodle/competency:planreview	write	30	moodle	0
208	moodle/competency:plancomment	write	30	moodle	0
209	moodle/competency:plancommentown	write	30	moodle	0
210	moodle/competency:usercompetencyview	read	30	moodle	0
211	moodle/competency:usercompetencyrequestreview	write	30	moodle	0
212	moodle/competency:usercompetencyrequestreviewown	write	30	moodle	0
213	moodle/competency:usercompetencyreview	write	30	moodle	0
214	moodle/competency:usercompetencycomment	write	30	moodle	0
215	moodle/competency:usercompetencycommentown	write	30	moodle	0
216	moodle/competency:templatemanage	write	40	moodle	0
217	moodle/analytics:listinsights	read	50	moodle	8
218	moodle/analytics:managemodels	write	10	moodle	2
219	moodle/competency:templateview	read	40	moodle	0
220	moodle/competency:userevidencemanage	write	30	moodle	0
221	moodle/competency:userevidencemanageown	write	30	moodle	0
222	moodle/competency:userevidenceview	read	30	moodle	0
223	moodle/site:maintenanceaccess	write	10	moodle	0
224	moodle/site:messageanyuser	write	10	moodle	16
225	moodle/site:managecontextlocks	write	70	moodle	0
226	moodle/course:togglecompletion	write	70	moodle	0
227	moodle/analytics:listowninsights	read	10	moodle	0
228	moodle/h5p:setdisplayoptions	write	70	moodle	0
229	moodle/h5p:deploy	write	70	moodle	4
230	moodle/h5p:updatelibraries	write	70	moodle	4
231	moodle/course:recommendactivity	write	10	moodle	0
232	moodle/contentbank:access	read	50	moodle	0
233	moodle/contentbank:upload	write	50	moodle	16
234	moodle/contentbank:deleteanycontent	write	50	moodle	32
235	moodle/contentbank:deleteowncontent	write	50	moodle	0
236	moodle/contentbank:manageanycontent	write	50	moodle	32
237	moodle/contentbank:manageowncontent	write	50	moodle	0
238	moodle/contentbank:useeditor	write	50	moodle	16
239	mod/assign:view	read	70	mod_assign	0
240	mod/assign:submit	write	70	mod_assign	0
241	mod/assign:grade	write	70	mod_assign	4
242	mod/assign:exportownsubmission	read	70	mod_assign	0
243	mod/assign:addinstance	write	50	mod_assign	4
244	mod/assign:editothersubmission	write	70	mod_assign	41
245	mod/assign:grantextension	write	70	mod_assign	0
246	mod/assign:revealidentities	write	70	mod_assign	0
247	mod/assign:reviewgrades	write	70	mod_assign	0
248	mod/assign:releasegrades	write	70	mod_assign	0
249	mod/assign:managegrades	write	70	mod_assign	0
250	mod/assign:manageallocations	write	70	mod_assign	0
251	mod/assign:viewgrades	read	70	mod_assign	0
252	mod/assign:viewblinddetails	write	70	mod_assign	8
253	mod/assign:receivegradernotifications	read	70	mod_assign	0
254	mod/assign:manageoverrides	write	70	mod_assign	0
255	mod/assign:showhiddengrader	read	70	mod_assign	0
256	mod/assignment:view	read	70	mod_assignment	0
257	mod/assignment:addinstance	write	50	mod_assignment	4
258	mod/assignment:submit	write	70	mod_assignment	0
259	mod/assignment:grade	write	70	mod_assignment	4
260	mod/assignment:exportownsubmission	read	70	mod_assignment	0
261	mod/book:addinstance	write	50	mod_book	4
262	mod/book:read	read	70	mod_book	0
263	mod/book:viewhiddenchapters	read	70	mod_book	0
264	mod/book:edit	write	70	mod_book	4
265	mod/chat:addinstance	write	50	mod_chat	4
266	mod/chat:chat	write	70	mod_chat	16
267	mod/chat:readlog	read	70	mod_chat	0
268	mod/chat:deletelog	write	70	mod_chat	0
269	mod/chat:exportparticipatedsession	read	70	mod_chat	8
270	mod/chat:exportsession	read	70	mod_chat	8
271	mod/chat:view	read	70	mod_chat	0
272	mod/choice:addinstance	write	50	mod_choice	4
273	mod/choice:choose	write	70	mod_choice	0
274	mod/choice:readresponses	read	70	mod_choice	0
275	mod/choice:deleteresponses	write	70	mod_choice	0
276	mod/choice:downloadresponses	read	70	mod_choice	0
277	mod/choice:view	read	70	mod_choice	0
278	mod/data:addinstance	write	50	mod_data	4
279	mod/data:viewentry	read	70	mod_data	0
280	mod/data:writeentry	write	70	mod_data	16
281	mod/data:comment	write	70	mod_data	16
282	mod/data:rate	write	70	mod_data	0
283	mod/data:viewrating	read	70	mod_data	0
284	mod/data:viewanyrating	read	70	mod_data	8
285	mod/data:viewallratings	read	70	mod_data	8
286	mod/data:approve	write	70	mod_data	16
287	mod/data:manageentries	write	70	mod_data	16
288	mod/data:managecomments	write	70	mod_data	16
289	mod/data:managetemplates	write	70	mod_data	20
290	mod/data:viewalluserpresets	read	70	mod_data	0
291	mod/data:manageuserpresets	write	70	mod_data	20
292	mod/data:exportentry	read	70	mod_data	8
293	mod/data:exportownentry	read	70	mod_data	0
294	mod/data:exportallentries	read	70	mod_data	8
295	mod/data:exportuserinfo	read	70	mod_data	8
296	mod/data:view	read	70	mod_data	0
297	mod/feedback:addinstance	write	50	mod_feedback	4
298	mod/feedback:view	read	70	mod_feedback	0
299	mod/feedback:complete	write	70	mod_feedback	16
300	mod/feedback:viewanalysepage	read	70	mod_feedback	8
301	mod/feedback:deletesubmissions	write	70	mod_feedback	0
302	mod/feedback:mapcourse	write	70	mod_feedback	0
303	mod/feedback:edititems	write	70	mod_feedback	20
304	mod/feedback:createprivatetemplate	write	70	mod_feedback	16
305	mod/feedback:createpublictemplate	write	70	mod_feedback	16
306	mod/feedback:deletetemplate	write	70	mod_feedback	0
307	mod/feedback:viewreports	read	70	mod_feedback	8
308	mod/feedback:receivemail	read	70	mod_feedback	8
309	mod/folder:addinstance	write	50	mod_folder	4
310	mod/folder:view	read	70	mod_folder	0
311	mod/folder:managefiles	write	70	mod_folder	16
312	mod/forum:addinstance	write	50	mod_forum	4
313	mod/forum:viewdiscussion	read	70	mod_forum	0
314	mod/forum:viewhiddentimedposts	read	70	mod_forum	0
315	mod/forum:startdiscussion	write	70	mod_forum	16
316	mod/forum:replypost	write	70	mod_forum	16
317	mod/forum:addnews	write	70	mod_forum	16
318	mod/forum:replynews	write	70	mod_forum	16
319	mod/forum:viewrating	read	70	mod_forum	0
320	mod/forum:viewanyrating	read	70	mod_forum	8
321	mod/forum:viewallratings	read	70	mod_forum	8
322	mod/forum:rate	write	70	mod_forum	0
323	mod/forum:postprivatereply	write	70	mod_forum	0
324	mod/forum:readprivatereplies	read	70	mod_forum	0
325	mod/forum:createattachment	write	70	mod_forum	16
326	mod/forum:deleteownpost	write	70	mod_forum	0
327	mod/forum:deleteanypost	write	70	mod_forum	0
328	mod/forum:splitdiscussions	write	70	mod_forum	0
329	mod/forum:movediscussions	write	70	mod_forum	0
330	mod/forum:pindiscussions	write	70	mod_forum	0
331	mod/forum:editanypost	write	70	mod_forum	16
332	mod/forum:viewqandawithoutposting	read	70	mod_forum	0
333	mod/forum:viewsubscribers	read	70	mod_forum	0
334	mod/forum:managesubscriptions	write	70	mod_forum	16
335	mod/forum:postwithoutthrottling	write	70	mod_forum	16
336	mod/forum:exportdiscussion	read	70	mod_forum	8
337	mod/forum:exportforum	read	70	mod_forum	8
338	mod/forum:exportpost	read	70	mod_forum	8
339	mod/forum:exportownpost	read	70	mod_forum	8
340	mod/forum:addquestion	write	70	mod_forum	16
341	mod/forum:allowforcesubscribe	read	70	mod_forum	0
342	mod/forum:canposttomygroups	write	70	mod_forum	0
343	mod/forum:canoverridediscussionlock	write	70	mod_forum	0
344	mod/forum:canoverridecutoff	write	70	mod_forum	0
345	mod/forum:cantogglefavourite	write	70	mod_forum	0
346	mod/forum:grade	write	70	mod_forum	0
347	mod/glossary:addinstance	write	50	mod_glossary	4
348	mod/glossary:view	read	70	mod_glossary	0
349	mod/glossary:write	write	70	mod_glossary	16
350	mod/glossary:manageentries	write	70	mod_glossary	16
351	mod/glossary:managecategories	write	70	mod_glossary	16
352	mod/glossary:comment	write	70	mod_glossary	16
353	mod/glossary:managecomments	write	70	mod_glossary	16
354	mod/glossary:import	write	70	mod_glossary	16
355	mod/glossary:export	read	70	mod_glossary	0
356	mod/glossary:approve	write	70	mod_glossary	16
357	mod/glossary:rate	write	70	mod_glossary	0
358	mod/glossary:viewrating	read	70	mod_glossary	0
359	mod/glossary:viewanyrating	read	70	mod_glossary	8
360	mod/glossary:viewallratings	read	70	mod_glossary	8
361	mod/glossary:exportentry	read	70	mod_glossary	8
362	mod/glossary:exportownentry	read	70	mod_glossary	0
363	mod/h5pactivity:view	read	70	mod_h5pactivity	0
364	mod/h5pactivity:addinstance	write	50	mod_h5pactivity	0
365	mod/h5pactivity:submit	write	70	mod_h5pactivity	0
366	mod/h5pactivity:reviewattempts	read	70	mod_h5pactivity	0
367	mod/imscp:view	read	70	mod_imscp	0
368	mod/imscp:addinstance	write	50	mod_imscp	4
369	mod/label:addinstance	write	50	mod_label	4
370	mod/label:view	read	70	mod_label	0
371	mod/lesson:addinstance	write	50	mod_lesson	4
372	mod/lesson:edit	write	70	mod_lesson	4
373	mod/lesson:grade	write	70	mod_lesson	20
374	mod/lesson:viewreports	read	70	mod_lesson	8
375	mod/lesson:manage	write	70	mod_lesson	0
376	mod/lesson:manageoverrides	write	70	mod_lesson	0
377	mod/lesson:view	read	70	mod_lesson	0
378	mod/lti:view	read	70	mod_lti	0
379	mod/lti:addinstance	write	50	mod_lti	4
380	mod/lti:manage	write	70	mod_lti	8
381	mod/lti:admin	write	70	mod_lti	8
382	mod/lti:addcoursetool	write	50	mod_lti	0
383	mod/lti:addpreconfiguredinstance	write	50	mod_lti	0
384	mod/lti:addmanualinstance	write	50	mod_lti	0
385	mod/lti:requesttooladd	write	50	mod_lti	0
386	mod/page:view	read	70	mod_page	0
387	mod/page:addinstance	write	50	mod_page	4
388	mod/quiz:view	read	70	mod_quiz	0
389	mod/quiz:addinstance	write	50	mod_quiz	4
390	mod/quiz:attempt	write	70	mod_quiz	16
391	mod/quiz:reviewmyattempts	read	70	mod_quiz	0
392	mod/quiz:manage	write	70	mod_quiz	16
393	mod/quiz:manageoverrides	write	70	mod_quiz	0
394	mod/quiz:preview	write	70	mod_quiz	0
395	mod/quiz:grade	write	70	mod_quiz	20
396	mod/quiz:regrade	write	70	mod_quiz	16
397	mod/quiz:viewreports	read	70	mod_quiz	8
398	mod/quiz:deleteattempts	write	70	mod_quiz	32
399	mod/quiz:ignoretimelimits	read	70	mod_quiz	0
400	mod/quiz:emailconfirmsubmission	read	70	mod_quiz	0
401	mod/quiz:emailnotifysubmission	read	70	mod_quiz	0
402	mod/quiz:emailwarnoverdue	read	70	mod_quiz	0
403	mod/resource:view	read	70	mod_resource	0
404	mod/resource:addinstance	write	50	mod_resource	4
405	mod/scorm:addinstance	write	50	mod_scorm	4
406	mod/scorm:viewreport	read	70	mod_scorm	0
407	mod/scorm:skipview	read	70	mod_scorm	0
408	mod/scorm:savetrack	write	70	mod_scorm	0
409	mod/scorm:viewscores	read	70	mod_scorm	0
410	mod/scorm:deleteresponses	write	70	mod_scorm	0
411	mod/scorm:deleteownresponses	write	70	mod_scorm	0
412	mod/survey:addinstance	write	50	mod_survey	4
413	mod/survey:participate	read	70	mod_survey	0
414	mod/survey:readresponses	read	70	mod_survey	0
415	mod/survey:download	read	70	mod_survey	0
416	mod/url:view	read	70	mod_url	0
417	mod/url:addinstance	write	50	mod_url	4
418	mod/wiki:addinstance	write	50	mod_wiki	4
419	mod/wiki:viewpage	read	70	mod_wiki	0
420	mod/wiki:editpage	write	70	mod_wiki	16
421	mod/wiki:createpage	write	70	mod_wiki	16
422	mod/wiki:viewcomment	read	70	mod_wiki	0
423	mod/wiki:editcomment	write	70	mod_wiki	16
424	mod/wiki:managecomment	write	70	mod_wiki	0
425	mod/wiki:managefiles	write	70	mod_wiki	0
426	mod/wiki:overridelock	write	70	mod_wiki	0
427	mod/wiki:managewiki	write	70	mod_wiki	0
428	mod/workshop:view	read	70	mod_workshop	0
429	mod/workshop:addinstance	write	50	mod_workshop	4
430	mod/workshop:switchphase	write	70	mod_workshop	0
431	mod/workshop:editdimensions	write	70	mod_workshop	4
432	mod/workshop:submit	write	70	mod_workshop	0
433	mod/workshop:peerassess	write	70	mod_workshop	0
434	mod/workshop:manageexamples	write	70	mod_workshop	0
435	mod/workshop:allocate	write	70	mod_workshop	0
436	mod/workshop:publishsubmissions	write	70	mod_workshop	0
437	mod/workshop:viewauthornames	read	70	mod_workshop	0
438	mod/workshop:viewreviewernames	read	70	mod_workshop	0
439	mod/workshop:viewallsubmissions	read	70	mod_workshop	0
440	mod/workshop:viewpublishedsubmissions	read	70	mod_workshop	0
441	mod/workshop:viewauthorpublished	read	70	mod_workshop	0
442	mod/workshop:viewallassessments	read	70	mod_workshop	0
443	mod/workshop:overridegrades	write	70	mod_workshop	0
444	mod/workshop:ignoredeadlines	write	70	mod_workshop	0
445	mod/workshop:deletesubmissions	write	70	mod_workshop	0
446	mod/workshop:exportsubmissions	read	70	mod_workshop	0
447	auth/oauth2:managelinkedlogins	write	30	auth_oauth2	0
448	enrol/category:synchronised	write	10	enrol_category	0
449	enrol/category:config	write	50	enrol_category	0
450	enrol/cohort:config	write	50	enrol_cohort	0
451	enrol/cohort:unenrol	write	50	enrol_cohort	0
452	enrol/database:unenrol	write	50	enrol_database	0
453	enrol/database:config	write	50	enrol_database	0
454	enrol/flatfile:manage	write	50	enrol_flatfile	0
455	enrol/flatfile:unenrol	write	50	enrol_flatfile	0
456	enrol/guest:config	write	50	enrol_guest	0
457	enrol/imsenterprise:config	write	50	enrol_imsenterprise	0
458	enrol/ldap:manage	write	50	enrol_ldap	0
459	enrol/lti:config	write	50	enrol_lti	0
460	enrol/lti:unenrol	write	50	enrol_lti	0
461	enrol/manual:config	write	50	enrol_manual	0
462	enrol/manual:enrol	write	50	enrol_manual	0
463	enrol/manual:manage	write	50	enrol_manual	0
464	enrol/manual:unenrol	write	50	enrol_manual	0
465	enrol/manual:unenrolself	write	50	enrol_manual	0
466	enrol/meta:config	write	50	enrol_meta	0
467	enrol/meta:selectaslinked	read	50	enrol_meta	0
468	enrol/meta:unenrol	write	50	enrol_meta	0
469	enrol/mnet:config	write	50	enrol_mnet	0
470	enrol/paypal:config	write	50	enrol_paypal	0
471	enrol/paypal:manage	write	50	enrol_paypal	0
472	enrol/paypal:unenrol	write	50	enrol_paypal	0
473	enrol/paypal:unenrolself	write	50	enrol_paypal	0
474	enrol/self:config	write	50	enrol_self	0
475	enrol/self:manage	write	50	enrol_self	0
476	enrol/self:holdkey	write	50	enrol_self	0
477	enrol/self:unenrolself	write	50	enrol_self	0
478	enrol/self:unenrol	write	50	enrol_self	0
479	message/airnotifier:managedevice	write	10	message_airnotifier	0
480	block/activity_modules:addinstance	write	80	block_activity_modules	20
481	block/activity_results:addinstance	write	80	block_activity_results	20
482	block/admin_bookmarks:myaddinstance	write	10	block_admin_bookmarks	0
483	block/admin_bookmarks:addinstance	write	80	block_admin_bookmarks	20
484	block/badges:addinstance	read	80	block_badges	0
485	block/badges:myaddinstance	read	10	block_badges	8
486	block/blog_menu:addinstance	write	80	block_blog_menu	20
487	block/blog_recent:addinstance	write	80	block_blog_recent	20
488	block/blog_tags:addinstance	write	80	block_blog_tags	20
489	block/calendar_month:myaddinstance	write	10	block_calendar_month	0
490	block/calendar_month:addinstance	write	80	block_calendar_month	20
491	block/calendar_upcoming:myaddinstance	write	10	block_calendar_upcoming	0
492	block/calendar_upcoming:addinstance	write	80	block_calendar_upcoming	20
493	block/comments:myaddinstance	write	10	block_comments	0
494	block/comments:addinstance	write	80	block_comments	20
495	block/completionstatus:addinstance	write	80	block_completionstatus	20
496	block/course_list:myaddinstance	write	10	block_course_list	0
497	block/course_list:addinstance	write	80	block_course_list	20
498	block/course_summary:addinstance	write	80	block_course_summary	20
499	block/feedback:addinstance	write	80	block_feedback	20
500	block/globalsearch:myaddinstance	write	10	block_globalsearch	0
501	block/globalsearch:addinstance	write	80	block_globalsearch	0
502	block/glossary_random:myaddinstance	write	10	block_glossary_random	0
503	block/glossary_random:addinstance	write	80	block_glossary_random	20
504	block/html:myaddinstance	write	10	block_html	0
505	block/html:addinstance	write	80	block_html	20
506	block/login:addinstance	write	80	block_login	20
507	block/lp:addinstance	write	10	block_lp	0
508	block/lp:myaddinstance	write	10	block_lp	0
509	block/mentees:myaddinstance	write	10	block_mentees	0
510	block/mentees:addinstance	write	80	block_mentees	20
511	block/mnet_hosts:myaddinstance	write	10	block_mnet_hosts	0
512	block/mnet_hosts:addinstance	write	80	block_mnet_hosts	20
513	block/myoverview:myaddinstance	write	10	block_myoverview	0
514	block/myprofile:myaddinstance	write	10	block_myprofile	0
515	block/myprofile:addinstance	write	80	block_myprofile	20
516	block/navigation:myaddinstance	write	10	block_navigation	0
517	block/navigation:addinstance	write	80	block_navigation	20
518	block/news_items:myaddinstance	write	10	block_news_items	0
519	block/news_items:addinstance	write	80	block_news_items	20
520	block/online_users:myaddinstance	write	10	block_online_users	0
521	block/online_users:addinstance	write	80	block_online_users	20
522	block/online_users:viewlist	read	80	block_online_users	0
523	block/private_files:myaddinstance	write	10	block_private_files	0
524	block/private_files:addinstance	write	80	block_private_files	20
525	block/quiz_results:addinstance	write	80	block_quiz_results	20
526	block/recent_activity:addinstance	write	80	block_recent_activity	20
527	block/recent_activity:viewaddupdatemodule	read	50	block_recent_activity	0
528	block/recent_activity:viewdeletemodule	read	50	block_recent_activity	0
529	block/recentlyaccessedcourses:myaddinstance	write	10	block_recentlyaccessedcourses	0
530	block/recentlyaccesseditems:myaddinstance	write	10	block_recentlyaccesseditems	0
531	block/rss_client:myaddinstance	write	10	block_rss_client	0
532	block/rss_client:addinstance	write	80	block_rss_client	20
533	block/rss_client:manageownfeeds	write	80	block_rss_client	0
534	block/rss_client:manageanyfeeds	write	80	block_rss_client	16
535	block/search_forums:addinstance	write	80	block_search_forums	20
536	block/section_links:addinstance	write	80	block_section_links	20
537	block/selfcompletion:addinstance	write	80	block_selfcompletion	20
538	block/settings:myaddinstance	write	10	block_settings	0
539	block/settings:addinstance	write	80	block_settings	20
540	block/site_main_menu:addinstance	write	80	block_site_main_menu	20
541	block/social_activities:addinstance	write	80	block_social_activities	20
542	block/starredcourses:myaddinstance	write	10	block_starredcourses	0
543	block/tag_flickr:addinstance	write	80	block_tag_flickr	20
544	block/tag_youtube:addinstance	write	80	block_tag_youtube	20
545	block/tags:myaddinstance	write	10	block_tags	0
546	block/tags:addinstance	write	80	block_tags	20
547	block/timeline:myaddinstance	write	10	block_timeline	0
548	report/completion:view	read	50	report_completion	8
549	report/courseoverview:view	read	10	report_courseoverview	8
550	report/log:view	read	50	report_log	8
551	report/log:viewtoday	read	50	report_log	8
552	report/loglive:view	read	50	report_loglive	8
553	report/outline:view	read	50	report_outline	8
554	report/outline:viewuserreport	read	50	report_outline	8
555	report/participation:view	read	50	report_participation	8
556	report/performance:view	read	10	report_performance	2
557	report/progress:view	read	50	report_progress	8
558	report/questioninstances:view	read	10	report_questioninstances	0
559	report/security:view	read	10	report_security	2
560	report/stats:view	read	50	report_stats	8
561	report/status:view	read	10	report_status	2
562	report/usersessions:manageownsessions	write	30	report_usersessions	0
563	gradeexport/ods:view	read	50	gradeexport_ods	8
564	gradeexport/ods:publish	read	50	gradeexport_ods	8
565	gradeexport/txt:view	read	50	gradeexport_txt	8
566	gradeexport/txt:publish	read	50	gradeexport_txt	8
567	gradeexport/xls:view	read	50	gradeexport_xls	8
568	gradeexport/xls:publish	read	50	gradeexport_xls	8
569	gradeexport/xml:view	read	50	gradeexport_xml	8
570	gradeexport/xml:publish	read	50	gradeexport_xml	8
571	gradeimport/csv:view	write	50	gradeimport_csv	0
572	gradeimport/direct:view	write	50	gradeimport_direct	0
573	gradeimport/xml:view	write	50	gradeimport_xml	0
574	gradeimport/xml:publish	write	50	gradeimport_xml	0
575	gradereport/grader:view	read	50	gradereport_grader	8
576	gradereport/history:view	read	50	gradereport_history	8
577	gradereport/outcomes:view	read	50	gradereport_outcomes	8
578	gradereport/overview:view	read	50	gradereport_overview	8
579	gradereport/singleview:view	read	50	gradereport_singleview	8
580	gradereport/user:view	read	50	gradereport_user	8
581	webservice/rest:use	read	50	webservice_rest	0
582	webservice/soap:use	read	50	webservice_soap	0
583	webservice/xmlrpc:use	read	50	webservice_xmlrpc	0
584	repository/areafiles:view	read	70	repository_areafiles	0
585	repository/boxnet:view	read	70	repository_boxnet	0
586	repository/contentbank:view	read	70	repository_contentbank	0
587	repository/contentbank:accesscoursecontent	read	50	repository_contentbank	0
588	repository/contentbank:accesscoursecategorycontent	read	40	repository_contentbank	0
589	repository/contentbank:accessgeneralcontent	read	40	repository_contentbank	0
590	repository/coursefiles:view	read	70	repository_coursefiles	0
591	repository/dropbox:view	read	70	repository_dropbox	0
592	repository/equella:view	read	70	repository_equella	0
593	repository/filesystem:view	read	70	repository_filesystem	0
594	repository/flickr:view	read	70	repository_flickr	0
595	repository/flickr_public:view	read	70	repository_flickr_public	0
596	repository/googledocs:view	read	70	repository_googledocs	0
597	repository/local:view	read	70	repository_local	0
598	repository/merlot:view	read	70	repository_merlot	0
599	repository/nextcloud:view	read	70	repository_nextcloud	0
600	repository/onedrive:view	read	70	repository_onedrive	0
601	repository/picasa:view	read	70	repository_picasa	0
602	repository/recent:view	read	70	repository_recent	0
603	repository/s3:view	read	70	repository_s3	0
604	repository/skydrive:view	read	70	repository_skydrive	0
605	repository/upload:view	read	70	repository_upload	0
606	repository/url:view	read	70	repository_url	0
607	repository/user:view	read	70	repository_user	0
608	repository/webdav:view	read	70	repository_webdav	0
609	repository/wikimedia:view	read	70	repository_wikimedia	0
610	repository/youtube:view	read	70	repository_youtube	0
611	tool/customlang:view	read	10	tool_customlang	2
612	tool/customlang:edit	write	10	tool_customlang	6
613	tool/dataprivacy:managedatarequests	write	10	tool_dataprivacy	60
614	tool/dataprivacy:requestdeleteforotheruser	write	10	tool_dataprivacy	60
615	tool/dataprivacy:managedataregistry	write	10	tool_dataprivacy	60
616	tool/dataprivacy:makedatarequestsforchildren	write	30	tool_dataprivacy	24
617	tool/dataprivacy:makedatadeletionrequestsforchildren	write	30	tool_dataprivacy	24
618	tool/dataprivacy:downloadownrequest	read	30	tool_dataprivacy	0
619	tool/dataprivacy:downloadallrequests	read	30	tool_dataprivacy	8
620	tool/dataprivacy:requestdelete	write	30	tool_dataprivacy	32
621	tool/lpmigrate:frameworksmigrate	write	10	tool_lpmigrate	0
622	tool/monitor:subscribe	read	50	tool_monitor	8
623	tool/monitor:managerules	write	50	tool_monitor	4
624	tool/monitor:managetool	write	10	tool_monitor	4
625	tool/policy:accept	write	10	tool_policy	0
626	tool/policy:acceptbehalf	write	30	tool_policy	8
627	tool/policy:managedocs	write	10	tool_policy	0
628	tool/policy:viewacceptances	read	10	tool_policy	0
629	tool/recyclebin:deleteitems	write	50	tool_recyclebin	32
630	tool/recyclebin:restoreitems	write	50	tool_recyclebin	0
631	tool/recyclebin:viewitems	read	50	tool_recyclebin	0
632	tool/uploaduser:uploaduserpictures	write	10	tool_uploaduser	16
633	tool/usertours:managetours	write	10	tool_usertours	4
634	contenttype/h5p:access	read	50	contenttype_h5p	0
635	contenttype/h5p:upload	write	50	contenttype_h5p	16
636	contenttype/h5p:useeditor	write	50	contenttype_h5p	16
637	booktool/exportimscp:export	read	70	booktool_exportimscp	0
638	booktool/importhtml:import	write	70	booktool_importhtml	4
639	booktool/print:print	read	70	booktool_print	0
640	forumreport/summary:view	read	70	forumreport_summary	0
641	forumreport/summary:viewall	read	70	forumreport_summary	8
642	quiz/grading:viewstudentnames	read	70	quiz_grading	0
643	quiz/grading:viewidnumber	read	70	quiz_grading	0
644	quiz/statistics:view	read	70	quiz_statistics	0
645	quizaccess/seb:managetemplates	write	10	quizaccess_seb	0
646	quizaccess/seb:bypassseb	read	70	quizaccess_seb	0
647	quizaccess/seb:manage_seb_requiresafeexambrowser	write	70	quizaccess_seb	0
648	quizaccess/seb:manage_seb_templateid	read	70	quizaccess_seb	0
649	quizaccess/seb:manage_filemanager_sebconfigfile	write	70	quizaccess_seb	0
650	quizaccess/seb:manage_seb_showsebdownloadlink	write	70	quizaccess_seb	0
651	quizaccess/seb:manage_seb_allowedbrowserexamkeys	write	70	quizaccess_seb	0
652	quizaccess/seb:manage_seb_linkquitseb	write	70	quizaccess_seb	0
653	quizaccess/seb:manage_seb_userconfirmquit	write	70	quizaccess_seb	0
654	quizaccess/seb:manage_seb_allowuserquitseb	write	70	quizaccess_seb	0
655	quizaccess/seb:manage_seb_quitpassword	write	70	quizaccess_seb	0
656	quizaccess/seb:manage_seb_allowreloadinexam	write	70	quizaccess_seb	0
657	quizaccess/seb:manage_seb_showsebtaskbar	write	70	quizaccess_seb	0
658	quizaccess/seb:manage_seb_showreloadbutton	write	70	quizaccess_seb	0
659	quizaccess/seb:manage_seb_showtime	write	70	quizaccess_seb	0
660	quizaccess/seb:manage_seb_showkeyboardlayout	write	70	quizaccess_seb	0
661	quizaccess/seb:manage_seb_showwificontrol	write	70	quizaccess_seb	0
662	quizaccess/seb:manage_seb_enableaudiocontrol	write	70	quizaccess_seb	0
663	quizaccess/seb:manage_seb_muteonstartup	write	70	quizaccess_seb	0
664	quizaccess/seb:manage_seb_allowspellchecking	write	70	quizaccess_seb	0
665	quizaccess/seb:manage_seb_activateurlfiltering	write	70	quizaccess_seb	0
666	quizaccess/seb:manage_seb_filterembeddedcontent	write	70	quizaccess_seb	0
667	quizaccess/seb:manage_seb_expressionsallowed	write	70	quizaccess_seb	0
668	quizaccess/seb:manage_seb_regexallowed	write	70	quizaccess_seb	0
669	quizaccess/seb:manage_seb_expressionsblocked	write	70	quizaccess_seb	0
670	quizaccess/seb:manage_seb_regexblocked	write	70	quizaccess_seb	0
671	atto/h5p:addembed	write	70	atto_h5p	0
672	atto/recordrtc:recordaudio	write	70	atto_recordrtc	0
673	atto/recordrtc:recordvideo	write	70	atto_recordrtc	0
\.


--
-- Data for Name: mdl_chat; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_chat (id, course, name, intro, introformat, keepdays, studentlogs, chattime, schedule, timemodified) FROM stdin;
\.


--
-- Data for Name: mdl_chat_messages; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_chat_messages (id, chatid, userid, groupid, issystem, message, "timestamp") FROM stdin;
\.


--
-- Data for Name: mdl_chat_messages_current; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_chat_messages_current (id, chatid, userid, groupid, issystem, message, "timestamp") FROM stdin;
\.


--
-- Data for Name: mdl_chat_users; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_chat_users (id, chatid, userid, groupid, version, ip, firstping, lastping, lastmessageping, sid, course, lang) FROM stdin;
\.


--
-- Data for Name: mdl_choice; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_choice (id, course, name, intro, introformat, publish, showresults, display, allowupdate, allowmultiple, showunanswered, includeinactive, limitanswers, timeopen, timeclose, showpreview, timemodified, completionsubmit) FROM stdin;
\.


--
-- Data for Name: mdl_choice_answers; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_choice_answers (id, choiceid, userid, optionid, timemodified) FROM stdin;
\.


--
-- Data for Name: mdl_choice_options; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_choice_options (id, choiceid, text, maxanswers, timemodified) FROM stdin;
\.


--
-- Data for Name: mdl_cohort; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_cohort (id, contextid, name, idnumber, description, descriptionformat, visible, component, timecreated, timemodified, theme) FROM stdin;
\.


--
-- Data for Name: mdl_cohort_members; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_cohort_members (id, cohortid, userid, timeadded) FROM stdin;
\.


--
-- Data for Name: mdl_comments; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_comments (id, contextid, component, commentarea, itemid, content, format, userid, timecreated) FROM stdin;
\.


--
-- Data for Name: mdl_competency; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency (id, shortname, description, descriptionformat, idnumber, competencyframeworkid, parentid, path, sortorder, ruletype, ruleoutcome, ruleconfig, scaleid, scaleconfiguration, timecreated, timemodified, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_competency_coursecomp; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_coursecomp (id, courseid, competencyid, ruleoutcome, timecreated, timemodified, usermodified, sortorder) FROM stdin;
\.


--
-- Data for Name: mdl_competency_coursecompsetting; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_coursecompsetting (id, courseid, pushratingstouserplans, timecreated, timemodified, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_competency_evidence; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_evidence (id, usercompetencyid, contextid, action, actionuserid, descidentifier, desccomponent, desca, url, grade, note, timecreated, timemodified, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_competency_framework; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_framework (id, shortname, contextid, idnumber, description, descriptionformat, scaleid, scaleconfiguration, visible, taxonomies, timecreated, timemodified, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_competency_modulecomp; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_modulecomp (id, cmid, timecreated, timemodified, usermodified, sortorder, competencyid, ruleoutcome) FROM stdin;
\.


--
-- Data for Name: mdl_competency_plan; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_plan (id, name, description, descriptionformat, userid, templateid, origtemplateid, status, duedate, reviewerid, timecreated, timemodified, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_competency_plancomp; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_plancomp (id, planid, competencyid, sortorder, timecreated, timemodified, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_competency_relatedcomp; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_relatedcomp (id, competencyid, relatedcompetencyid, timecreated, timemodified, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_competency_template; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_template (id, shortname, contextid, description, descriptionformat, visible, duedate, timecreated, timemodified, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_competency_templatecohort; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_templatecohort (id, templateid, cohortid, timecreated, timemodified, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_competency_templatecomp; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_templatecomp (id, templateid, competencyid, timecreated, timemodified, usermodified, sortorder) FROM stdin;
\.


--
-- Data for Name: mdl_competency_usercomp; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_usercomp (id, userid, competencyid, status, reviewerid, proficiency, grade, timecreated, timemodified, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_competency_usercompcourse; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_usercompcourse (id, userid, courseid, competencyid, proficiency, grade, timecreated, timemodified, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_competency_usercompplan; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_usercompplan (id, userid, competencyid, planid, proficiency, grade, sortorder, timecreated, timemodified, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_competency_userevidence; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_userevidence (id, userid, name, description, descriptionformat, url, timecreated, timemodified, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_competency_userevidencecomp; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_competency_userevidencecomp (id, userevidenceid, competencyid, timecreated, timemodified, usermodified) FROM stdin;
\.


--
-- Data for Name: mdl_config; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_config (id, name, value) FROM stdin;
3	auth	email
4	enrol_plugins_enabled	manual,guest,self,cohort
5	theme	boost
6	filter_multilang_converted	1
7	siteidentifier	uMdSOF8MHNVKvCkmZ9aChTEJp7FfMQ2qarrupe.ac.zw
10	mnet_dispatcher_mode	off
11	sessiontimeout	28800
12	stringfilters	
15	antiviruses	
16	media_plugins_sortorder	videojs,youtube,swf
17	upgrade_extracreditweightsstepignored	1
18	upgrade_calculatedgradeitemsignored	1
19	upgrade_letterboundarycourses	1
20	mnet_localhost_id	1
21	mnet_all_hosts_id	2
22	siteguest	1
23	siteadmins	2
27	gdversion	2
28	licenses	unknown,allrightsreserved,public,cc,cc-nd,cc-nc-nd,cc-nc,cc-nc-sa,cc-sa
29	sitedefaultlicense	unknown
30	badges_site_backpack	1
31	version	2020061501.06
32	enableuserfeedback	0
33	userfeedback_nextreminder	1
34	userfeedback_remindafter	90
35	enableoutcomes	0
36	usecomments	1
37	usetags	1
38	enablenotes	1
39	enableportfolios	0
41	enablestats	0
42	enablerssfeeds	0
43	enableblogs	1
44	enablecompletion	1
45	completiondefault	1
46	enableavailability	1
47	enableplagiarism	0
48	enablebadges	1
49	enableglobalsearch	0
50	allowstealth	0
51	enableanalytics	1
52	allowemojipicker	1
53	userfiltersdefault	realname
54	defaultpreference_maildisplay	2
55	defaultpreference_mailformat	1
56	defaultpreference_maildigest	0
57	defaultpreference_autosubscribe	1
58	defaultpreference_trackforums	0
59	autologinguests	0
60	hiddenuserfields	
61	showuseridentity	email
62	fullnamedisplay	language
63	alternativefullnameformat	language
64	maxusersperpage	100
65	enablegravatar	0
66	gravatardefaulturl	mm
67	agedigitalconsentverification	0
68	agedigitalconsentmap	*, 16\nAT, 14\nBE, 13\nBG, 14\nCY, 14\nCZ, 15\nDK, 13\nEE, 13\nES, 14\nFI, 13\nFR, 15\nGB, 13\nGR, 15\nIT, 14\nLT, 14\nLV, 13\nMT, 13\nNO, 13\nPT, 13\nSE, 13\nUS, 13
69	sitepolicy	
70	sitepolicyguest	
71	enablecourserequests	1
72	defaultrequestcategory	1
73	lockrequestcategory	0
74	courserequestnotify	
75	activitychoosertabmode	0
76	enableasyncbackup	0
77	grade_profilereport	user
78	grade_aggregationposition	1
79	grade_includescalesinaggregation	1
80	grade_hiddenasdate	0
81	gradepublishing	0
82	grade_export_exportfeedback	0
83	grade_export_displaytype	1
84	grade_export_decimalpoints	2
85	grade_navmethod	1
86	grade_export_userprofilefields	firstname,lastname,idnumber,institution,department,email
87	grade_export_customprofilefields	
88	recovergradesdefault	0
89	gradeexport	
90	unlimitedgrades	0
91	grade_report_showmin	1
92	gradepointmax	100
93	gradepointdefault	100
94	grade_minmaxtouse	1
95	grade_mygrades_report	overview
96	gradereport_mygradeurl	
97	grade_hideforcedsettings	1
98	grade_aggregation	13
99	grade_aggregation_flag	0
100	grade_aggregations_visible	13
101	grade_aggregateonlygraded	1
102	grade_aggregateonlygraded_flag	2
103	grade_aggregateoutcomes	0
104	grade_aggregateoutcomes_flag	2
105	grade_keephigh	0
106	grade_keephigh_flag	3
107	grade_droplow	0
108	grade_droplow_flag	2
109	grade_overridecat	1
110	grade_displaytype	1
111	grade_decimalpoints	2
112	grade_item_advanced	iteminfo,idnumber,gradepass,plusfactor,multfactor,display,decimals,hiddenuntil,locktime
113	grade_report_studentsperpage	100
114	grade_report_showonlyactiveenrol	1
115	grade_report_quickgrading	1
116	grade_report_showquickfeedback	0
117	grade_report_meanselection	1
118	grade_report_enableajax	0
119	grade_report_showcalculations	1
120	grade_report_showeyecons	0
121	grade_report_showaverages	1
122	grade_report_showlocks	0
123	grade_report_showranges	0
24	themerev	1606304223
25	jsrev	1606304223
13	filterall	0
2	rolesactive	1
40	enablewebservices	1
8	backup_version	2020061500
9	backup_release	3.9
26	templaterev	1606304223
124	grade_report_showanalysisicon	1
125	grade_report_showuserimage	1
126	grade_report_showactivityicons	1
127	grade_report_shownumberofgrades	0
128	grade_report_averagesdisplaytype	inherit
129	grade_report_rangesdisplaytype	inherit
130	grade_report_averagesdecimalpoints	inherit
131	grade_report_rangesdecimalpoints	inherit
132	grade_report_historyperpage	50
133	grade_report_overview_showrank	0
134	grade_report_overview_showtotalsifcontainhidden	0
135	grade_report_user_showrank	0
136	grade_report_user_showpercentage	1
137	grade_report_user_showgrade	1
138	grade_report_user_showfeedback	1
139	grade_report_user_showrange	1
140	grade_report_user_showweight	1
141	grade_report_user_showaverage	0
142	grade_report_user_showlettergrade	0
143	grade_report_user_rangedecimals	0
144	grade_report_user_showhiddenitems	1
145	grade_report_user_showtotalsifcontainhidden	0
146	grade_report_user_showcontributiontocoursetotal	1
147	badges_defaultissuername	
148	badges_defaultissuercontact	
149	badges_badgesalt	badges1597315726
150	badges_allowcoursebadges	1
151	badges_allowexternalbackpack	1
152	rememberuserlicensepref	1
154	forcetimezone	99
155	country	0
156	defaultcity	
157	geoip2file	/var/www/moodledata/geoip/GeoLite2-City.mmdb
158	googlemapkey3	
159	allcountrycodes	
160	autolang	1
161	lang	en
162	langmenu	1
163	langlist	
165	langcache	1
166	langstringcache	1
167	locale	
168	latinexcelexport	0
169	messaging	1
170	messagingallusers	0
171	messagingdefaultpressenter	1
172	messagingdeletereadnotificationsdelay	604800
173	messagingdeleteallnotificationsdelay	2620800
174	messagingallowemailoverride	0
175	requiremodintro	0
177	authloginviaemail	0
178	allowaccountssameemail	0
179	authpreventaccountcreation	0
180	loginpageautofocus	0
181	guestloginbutton	1
182	limitconcurrentlogins	0
183	alternateloginurl	
184	forgottenpasswordurl	
185	auth_instructions	
186	allowemailaddresses	
187	denyemailaddresses	
188	verifychangedemail	1
189	recaptchapublickey	
190	recaptchaprivatekey	
191	filteruploadedfiles	0
192	filtermatchoneperpage	0
193	filtermatchonepertext	0
194	media_default_width	400
195	media_default_height	300
196	portfolio_moderate_filesize_threshold	1048576
197	portfolio_high_filesize_threshold	5242880
198	portfolio_moderate_db_threshold	20
199	portfolio_high_db_threshold	50
200	repositorycacheexpire	120
201	repositorygetfiletimeout	30
202	repositorysyncfiletimeout	1
203	repositorysyncimagetimeout	3
204	repositoryallowexternallinks	1
205	legacyfilesinnewcourses	0
206	legacyfilesaddallowed	1
207	searchengine	simpledb
208	searchindexwhendisabled	0
209	searchindextime	600
210	searchallavailablecourses	0
211	searchincludeallcourses	0
212	searchenablecategories	0
213	searchdefaultcategory	core-all
214	searchhideallcategory	0
215	enablewsdocumentation	0
216	allowbeforeblock	0
217	allowedip	
218	blockedip	
219	protectusernames	1
220	forcelogin	0
221	forceloginforprofiles	1
222	forceloginforprofileimage	0
223	opentowebcrawlers	0
224	allowindexing	0
225	maxbytes	0
226	userquota	104857600
227	allowobjectembed	0
228	enabletrusttext	0
229	maxeditingtime	1800
230	extendedusernamechars	0
231	keeptagnamecase	1
232	profilesforenrolledusersonly	1
233	cronclionly	1
234	cronremotepassword	
235	lockoutthreshold	0
236	lockoutwindow	1800
237	lockoutduration	1800
238	passwordpolicy	1
239	minpasswordlength	8
240	minpassworddigits	1
241	minpasswordlower	1
242	minpasswordupper	1
243	minpasswordnonalphanum	1
244	maxconsecutiveidentchars	0
245	passwordpolicycheckonlogin	0
246	passwordreuselimit	0
247	pwresettime	1800
248	passwordchangelogout	0
249	passwordchangetokendeletion	0
250	tokenduration	7257600
251	groupenrolmentkeypolicy	1
252	disableuserimages	0
253	emailchangeconfirmation	1
254	rememberusername	2
255	strictformsrequired	0
256	cookiesecure	1
257	cookiehttponly	0
258	allowframembedding	0
259	curlsecurityblockedhosts	
260	curlsecurityallowedport	
261	displayloginfailures	0
262	notifyloginfailures	
263	notifyloginthreshold	10
264	themelist	
265	themedesignermode	0
266	allowuserthemes	0
267	allowcoursethemes	0
268	allowcategorythemes	0
269	allowcohortthemes	0
270	allowthemechangeonurl	0
271	allowuserblockhiding	1
272	langmenuinsecurelayout	0
273	logininfoinsecurelayout	0
274	custommenuitems	
275	customusermenuitems	grades,grades|/grade/report/mygrades.php|t/grades\nmessages,message|/message/index.php|t/message\npreferences,moodle|/user/preferences.php|t/preferences
276	enabledevicedetection	1
277	devicedetectregex	[]
278	calendartype	gregorian
279	calendar_adminseesall	0
280	calendar_site_timeformat	0
281	calendar_startwday	1
282	calendar_weekend	65
283	calendar_lookahead	21
284	calendar_maxevents	10
285	enablecalendarexport	1
286	calendar_customexport	1
287	calendar_exportlookahead	365
288	calendar_exportlookback	5
290	calendar_showicalsource	1
291	useblogassociations	1
292	bloglevel	4
293	useexternalblogs	1
294	externalblogcrontime	86400
295	maxexternalblogsperuser	1
296	blogusecomments	1
297	blogshowcommentscount	1
298	defaulthomepage	1
299	allowguestmymoodle	1
300	navshowfullcoursenames	0
301	navshowcategories	1
302	navshowmycoursecategories	0
303	navshowallcourses	0
304	navsortmycoursessort	sortorder
305	navsortmycourseshiddenlast	1
306	navcourselimit	10
307	usesitenameforsitepages	0
308	linkadmincategories	1
309	linkcoursesections	1
310	navshowfrontpagemods	1
311	navadduserpostslinks	1
312	formatstringstriptags	1
313	emoticons	[{"text":":-)","imagename":"s\\/smiley","imagecomponent":"core","altidentifier":"smiley","altcomponent":"core_pix"},{"text":":)","imagename":"s\\/smiley","imagecomponent":"core","altidentifier":"smiley","altcomponent":"core_pix"},{"text":":-D","imagename":"s\\/biggrin","imagecomponent":"core","altidentifier":"biggrin","altcomponent":"core_pix"},{"text":";-)","imagename":"s\\/wink","imagecomponent":"core","altidentifier":"wink","altcomponent":"core_pix"},{"text":":-\\/","imagename":"s\\/mixed","imagecomponent":"core","altidentifier":"mixed","altcomponent":"core_pix"},{"text":"V-.","imagename":"s\\/thoughtful","imagecomponent":"core","altidentifier":"thoughtful","altcomponent":"core_pix"},{"text":":-P","imagename":"s\\/tongueout","imagecomponent":"core","altidentifier":"tongueout","altcomponent":"core_pix"},{"text":":-p","imagename":"s\\/tongueout","imagecomponent":"core","altidentifier":"tongueout","altcomponent":"core_pix"},{"text":"B-)","imagename":"s\\/cool","imagecomponent":"core","altidentifier":"cool","altcomponent":"core_pix"},{"text":"^-)","imagename":"s\\/approve","imagecomponent":"core","altidentifier":"approve","altcomponent":"core_pix"},{"text":"8-)","imagename":"s\\/wideeyes","imagecomponent":"core","altidentifier":"wideeyes","altcomponent":"core_pix"},{"text":":o)","imagename":"s\\/clown","imagecomponent":"core","altidentifier":"clown","altcomponent":"core_pix"},{"text":":-(","imagename":"s\\/sad","imagecomponent":"core","altidentifier":"sad","altcomponent":"core_pix"},{"text":":(","imagename":"s\\/sad","imagecomponent":"core","altidentifier":"sad","altcomponent":"core_pix"},{"text":"8-.","imagename":"s\\/shy","imagecomponent":"core","altidentifier":"shy","altcomponent":"core_pix"},{"text":":-I","imagename":"s\\/blush","imagecomponent":"core","altidentifier":"blush","altcomponent":"core_pix"},{"text":":-X","imagename":"s\\/kiss","imagecomponent":"core","altidentifier":"kiss","altcomponent":"core_pix"},{"text":"8-o","imagename":"s\\/surprise","imagecomponent":"core","altidentifier":"surprise","altcomponent":"core_pix"},{"text":"P-|","imagename":"s\\/blackeye","imagecomponent":"core","altidentifier":"blackeye","altcomponent":"core_pix"},{"text":"8-[","imagename":"s\\/angry","imagecomponent":"core","altidentifier":"angry","altcomponent":"core_pix"},{"text":"(grr)","imagename":"s\\/angry","imagecomponent":"core","altidentifier":"angry","altcomponent":"core_pix"},{"text":"xx-P","imagename":"s\\/dead","imagecomponent":"core","altidentifier":"dead","altcomponent":"core_pix"},{"text":"|-.","imagename":"s\\/sleepy","imagecomponent":"core","altidentifier":"sleepy","altcomponent":"core_pix"},{"text":"}-]","imagename":"s\\/evil","imagecomponent":"core","altidentifier":"evil","altcomponent":"core_pix"},{"text":"(h)","imagename":"s\\/heart","imagecomponent":"core","altidentifier":"heart","altcomponent":"core_pix"},{"text":"(heart)","imagename":"s\\/heart","imagecomponent":"core","altidentifier":"heart","altcomponent":"core_pix"},{"text":"(y)","imagename":"s\\/yes","imagecomponent":"core","altidentifier":"yes","altcomponent":"core"},{"text":"(n)","imagename":"s\\/no","imagecomponent":"core","altidentifier":"no","altcomponent":"core"},{"text":"(martin)","imagename":"s\\/martin","imagecomponent":"core","altidentifier":"martin","altcomponent":"core_pix"},{"text":"( )","imagename":"s\\/egg","imagecomponent":"core","altidentifier":"egg","altcomponent":"core_pix"}]
314	docroot	https://docs.moodle.org
315	doclang	
316	doctonewwindow	0
317	coursecontactduplicates	0
318	courselistshortnames	0
319	coursesperpage	20
320	courseswithsummarieslimit	10
321	courseoverviewfileslimit	1
322	courseoverviewfilesext	.jpg,.gif,.png
323	coursegraceperiodbefore	0
324	coursegraceperiodafter	0
325	useexternalyui	0
326	yuicomboloading	1
327	cachejs	1
328	modchooserdefault	1
329	additionalhtmlhead	
330	additionalhtmltopofbody	
331	additionalhtmlfooter	
332	cachetemplates	1
333	pathtophp	
334	pathtodu	
335	aspellpath	
336	pathtodot	
337	pathtogs	/usr/bin/gs
338	pathtopython	
339	supportname	Admin User
340	supportemail	
341	supportpage	
342	dbsessions	0
343	sessioncookie	
344	sessioncookiepath	
345	sessioncookiedomain	
346	statsfirstrun	none
347	statsmaxruntime	0
348	statsruntimedays	31
349	statsuserthreshold	0
350	slasharguments	1
351	getremoteaddrconf	3
352	reverseproxyignore	
353	proxyhost	
354	proxyport	0
355	proxytype	HTTP
356	proxyuser	
357	proxypassword	
358	proxybypass	localhost, 127.0.0.1
359	maintenance_enabled	0
360	maintenance_message	
361	deleteunconfirmed	168
362	deleteincompleteusers	0
363	disablegradehistory	0
364	gradehistorylifetime	0
365	tempdatafoldercleanup	168
366	filescleanupperiod	86400
367	extramemorylimit	512M
368	maxtimelimit	0
369	curlcache	120
370	curltimeoutkbitrate	56
498	messageinbound_enabled	0
499	messageinbound_mailbox	
500	messageinbound_domain	
371	task_scheduled_concurrency_limit	3
372	task_scheduled_max_runtime	1800
373	task_adhoc_concurrency_limit	3
374	task_adhoc_max_runtime	1800
375	task_logmode	1
376	task_logtostdout	1
377	task_logretention	2419200
378	task_logretainruns	20
379	smtphosts	
380	smtpsecure	
381	smtpauthtype	LOGIN
382	smtpuser	
383	smtppass	
384	smtpmaxbulk	1
385	noreplyaddress	noreply@arrupe.ac.zw
386	allowedemaildomains	
387	sitemailcharset	0
388	allowusermailcharset	0
389	allowattachments	1
390	mailnewline	LF
391	emailfromvia	1
392	emailsubjectprefix	
393	updateautocheck	1
394	updateminmaturity	200
395	updatenotifybuilds	0
396	dndallowtextandlinks	0
397	pathtosassc	
398	contextlocking	0
399	contextlockappliestoadmin	1
400	forceclean	0
401	enablecourserelativedates	0
402	debug	0
403	debugdisplay	0
404	perfdebug	7
405	debugstringids	0
406	debugvalidators	0
407	debugpageinfo	0
408	profilingenabled	0
409	profilingincluded	
410	profilingexcluded	
411	profilingautofrec	0
412	profilingallowme	0
413	profilingallowall	0
414	profilingslow	0
415	profilinglifetime	1440
416	profilingimportprefix	(I)
289	calendar_exportsalt	644FhPDRCXurCiloroJ0oqVZJ7XcxZCMjLUdF5e5f6OyO230TbrzBR5oYccQ
417	release	3.9.1+ (Build: 20200807)
444	chat_old_ping	35
445	chat_refresh_room	5
446	chat_normal_updatemode	jsupdate
447	chat_serverhost	arrupe.ac.zw
448	chat_serverip	127.0.0.1
449	chat_serverport	9111
450	chat_servermax	100
451	data_enablerssfeeds	0
452	feedback_allowfullanonymous	0
453	forum_displaymode	3
454	forum_shortpost	300
455	forum_longpost	600
456	forum_manydiscussions	100
457	forum_maxbytes	512000
458	forum_maxattachments	9
459	forum_subscription	0
460	forum_trackingtype	1
461	forum_trackreadposts	1
462	forum_allowforcedreadtracking	0
463	forum_oldpostdays	14
464	forum_usermarksread	0
465	forum_cleanreadtime	2
466	digestmailtime	17
467	forum_enablerssfeeds	0
468	forum_enabletimedposts	1
469	glossary_entbypage	10
470	glossary_dupentries	0
471	glossary_allowcomments	0
472	glossary_linkbydefault	1
473	glossary_defaultapproval	1
474	glossary_enablerssfeeds	0
475	glossary_linkentries	0
476	glossary_casesensitive	0
477	glossary_fullmatch	0
478	block_course_list_adminview	all
479	block_course_list_hideallcourseslink	0
420	allversionshash	7cb413315b25aa4ae6e8dce0dbfa1c4a3e27c741
164	langrev	1606304223
418	localcachedirpurged	1606304223
423	branch	39
424	notloggedinroleid	6
425	guestroleid	6
426	defaultuserroleid	7
427	creatornewroleid	3
14	texteditors	atto,tinymce,textarea
428	restorernewroleid	3
429	sitepolicyhandler	
430	gradebookroles	5
431	h5plibraryhandler	h5plib_v124
432	jabberhost	
433	jabberserver	
434	jabberusername	
435	jabberpassword	
436	jabberport	5222
437	airnotifierurl	https://messages.moodle.net
438	airnotifierport	443
439	airnotifiermobileappname	com.moodle.moodlemobile
440	airnotifierappname	commoodlemoodlemobile
480	block_html_allowcssclasses	0
441	airnotifieraccesskey	
442	chat_method	ajax
443	chat_refresh_userlist	10
481	block_online_users_timetosee	5
482	block_online_users_onlinestatushiding	1
483	block_rss_client_num_entries	5
484	block_rss_client_timeout	30
485	pathtounoconv	/usr/bin/unoconv
486	filter_multilang_force_old	0
487	filter_censor_badwords	
488	logguests	1
489	loglifetime	0
490	profileroles	5,4,3
491	coursecontact	3
492	frontpage	6
493	frontpageloggedin	6
494	maxcategorydepth	2
495	frontpagecourselimit	200
496	commentsperpage	15
497	defaultfrontpageroleid	8
422	registrationpending	0
419	scheduledtaskreset	1606304223
501	messageinbound_host	
502	messageinbound_hostssl	ssl
503	messageinbound_hostuser	
504	messageinbound_hostpass	
505	webserviceprotocols	rest
506	enablemobilewebservice	1
507	mobilecssurl	
508	timezone	Europe/London
509	registerauth	
\.


--
-- Data for Name: mdl_config_log; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_config_log (id, userid, timemodified, plugin, name, value, oldvalue) FROM stdin;
1	0	1597315739	\N	enableuserfeedback	0	\N
2	0	1597315739	\N	userfeedback_nextreminder	1	\N
3	0	1597315739	\N	userfeedback_remindafter	90	\N
4	0	1597315739	\N	enableoutcomes	0	\N
5	0	1597315739	\N	usecomments	1	\N
6	0	1597315739	\N	usetags	1	\N
7	0	1597315739	\N	enablenotes	1	\N
8	0	1597315739	\N	enableportfolios	0	\N
9	0	1597315739	\N	enablewebservices	0	\N
10	0	1597315739	\N	enablestats	0	\N
11	0	1597315739	\N	enablerssfeeds	0	\N
12	0	1597315739	\N	enableblogs	1	\N
13	0	1597315739	\N	enablecompletion	1	\N
14	0	1597315739	\N	completiondefault	1	\N
15	0	1597315739	\N	enableavailability	1	\N
16	0	1597315739	\N	enableplagiarism	0	\N
17	0	1597315739	\N	enablebadges	1	\N
18	0	1597315739	\N	enableglobalsearch	0	\N
19	0	1597315739	\N	allowstealth	0	\N
20	0	1597315739	\N	enableanalytics	1	\N
21	0	1597315739	\N	allowemojipicker	1	\N
22	0	1597315739	\N	userfiltersdefault	realname	\N
23	0	1597315739	\N	defaultpreference_maildisplay	2	\N
24	0	1597315739	\N	defaultpreference_mailformat	1	\N
25	0	1597315739	\N	defaultpreference_maildigest	0	\N
26	0	1597315739	\N	defaultpreference_autosubscribe	1	\N
27	0	1597315739	\N	defaultpreference_trackforums	0	\N
28	0	1597315739	\N	autologinguests	0	\N
29	0	1597315739	\N	hiddenuserfields		\N
30	0	1597315739	\N	showuseridentity	email	\N
31	0	1597315739	\N	fullnamedisplay	language	\N
32	0	1597315739	\N	alternativefullnameformat	language	\N
33	0	1597315739	\N	maxusersperpage	100	\N
34	0	1597315739	\N	enablegravatar	0	\N
35	0	1597315739	\N	gravatardefaulturl	mm	\N
36	0	1597315739	\N	agedigitalconsentverification	0	\N
37	0	1597315739	\N	agedigitalconsentmap	*, 16\nAT, 14\nBE, 13\nBG, 14\nCY, 14\nCZ, 15\nDK, 13\nEE, 13\nES, 14\nFI, 13\nFR, 15\nGB, 13\nGR, 15\nIT, 14\nLT, 14\nLV, 13\nMT, 13\nNO, 13\nPT, 13\nSE, 13\nUS, 13	\N
38	0	1597315739	\N	sitepolicy		\N
39	0	1597315739	\N	sitepolicyguest		\N
40	0	1597315739	moodlecourse	visible	1	\N
41	0	1597315739	moodlecourse	format	topics	\N
42	0	1597315739	moodlecourse	maxsections	52	\N
43	0	1597315739	moodlecourse	numsections	4	\N
44	0	1597315739	moodlecourse	hiddensections	0	\N
45	0	1597315739	moodlecourse	coursedisplay	0	\N
46	0	1597315739	moodlecourse	courseenddateenabled	1	\N
47	0	1597315739	moodlecourse	courseduration	31536000	\N
48	0	1597315739	moodlecourse	lang		\N
49	0	1597315739	moodlecourse	newsitems	5	\N
50	0	1597315739	moodlecourse	showgrades	1	\N
51	0	1597315739	moodlecourse	showreports	0	\N
52	0	1597315739	moodlecourse	maxbytes	0	\N
53	0	1597315739	moodlecourse	enablecompletion	1	\N
54	0	1597315739	moodlecourse	groupmode	0	\N
55	0	1597315739	moodlecourse	groupmodeforce	0	\N
56	0	1597315739	\N	enablecourserequests	1	\N
57	0	1597315739	\N	defaultrequestcategory	1	\N
58	0	1597315739	\N	lockrequestcategory	0	\N
59	0	1597315739	\N	courserequestnotify		\N
60	0	1597315739	\N	activitychoosertabmode	0	\N
61	0	1597315739	backup	loglifetime	30	\N
62	0	1597315739	backup	backup_general_users	1	\N
63	0	1597315739	backup	backup_general_users_locked		\N
64	0	1597315739	backup	backup_general_anonymize	0	\N
65	0	1597315739	backup	backup_general_anonymize_locked		\N
66	0	1597315739	backup	backup_general_role_assignments	1	\N
67	0	1597315739	backup	backup_general_role_assignments_locked		\N
68	0	1597315739	backup	backup_general_activities	1	\N
69	0	1597315739	backup	backup_general_activities_locked		\N
70	0	1597315739	backup	backup_general_blocks	1	\N
71	0	1597315739	backup	backup_general_blocks_locked		\N
72	0	1597315739	backup	backup_general_files	1	\N
73	0	1597315739	backup	backup_general_files_locked		\N
74	0	1597315739	backup	backup_general_filters	1	\N
75	0	1597315739	backup	backup_general_filters_locked		\N
76	0	1597315739	backup	backup_general_comments	1	\N
77	0	1597315739	backup	backup_general_comments_locked		\N
78	0	1597315739	backup	backup_general_badges	1	\N
79	0	1597315739	backup	backup_general_badges_locked		\N
80	0	1597315739	backup	backup_general_calendarevents	1	\N
81	0	1597315739	backup	backup_general_calendarevents_locked		\N
82	0	1597315739	backup	backup_general_userscompletion	1	\N
83	0	1597315739	backup	backup_general_userscompletion_locked		\N
84	0	1597315739	backup	backup_general_logs	0	\N
85	0	1597315739	backup	backup_general_logs_locked		\N
86	0	1597315739	backup	backup_general_histories	0	\N
87	0	1597315739	backup	backup_general_histories_locked		\N
88	0	1597315739	backup	backup_general_questionbank	1	\N
89	0	1597315739	backup	backup_general_questionbank_locked		\N
90	0	1597315739	backup	backup_general_groups	1	\N
91	0	1597315739	backup	backup_general_groups_locked		\N
92	0	1597315739	backup	backup_general_competencies	1	\N
93	0	1597315739	backup	backup_general_competencies_locked		\N
94	0	1597315739	backup	backup_general_contentbankcontent	1	\N
95	0	1597315739	backup	backup_general_contentbankcontent_locked		\N
96	0	1597315739	backup	import_general_maxresults	10	\N
97	0	1597315739	backup	import_general_duplicate_admin_allowed	0	\N
98	0	1597315739	backup	backup_import_activities	1	\N
99	0	1597315739	backup	backup_import_activities_locked		\N
100	0	1597315739	backup	backup_import_blocks	1	\N
101	0	1597315740	backup	backup_import_blocks_locked		\N
102	0	1597315740	backup	backup_import_filters	1	\N
103	0	1597315740	backup	backup_import_filters_locked		\N
104	0	1597315740	backup	backup_import_calendarevents	1	\N
105	0	1597315740	backup	backup_import_calendarevents_locked		\N
106	0	1597315740	backup	backup_import_questionbank	1	\N
107	0	1597315740	backup	backup_import_questionbank_locked		\N
108	0	1597315740	backup	backup_import_groups	1	\N
109	0	1597315740	backup	backup_import_groups_locked		\N
110	0	1597315740	backup	backup_import_competencies	1	\N
111	0	1597315740	backup	backup_import_competencies_locked		\N
112	0	1597315740	backup	backup_import_contentbankcontent	1	\N
113	0	1597315740	backup	backup_import_contentbankcontent_locked		\N
114	0	1597315740	backup	backup_auto_active	0	\N
115	0	1597315740	backup	backup_auto_weekdays	0000000	\N
116	0	1597315740	backup	backup_auto_hour	0	\N
117	0	1597315740	backup	backup_auto_minute	0	\N
118	0	1597315740	backup	backup_auto_storage	0	\N
119	0	1597315740	backup	backup_auto_destination		\N
120	0	1597315740	backup	backup_auto_max_kept	1	\N
121	0	1597315740	backup	backup_auto_delete_days	0	\N
122	0	1597315740	backup	backup_auto_min_kept	0	\N
123	0	1597315740	backup	backup_shortname	0	\N
124	0	1597315740	backup	backup_auto_skip_hidden	1	\N
125	0	1597315740	backup	backup_auto_skip_modif_days	30	\N
126	0	1597315740	backup	backup_auto_skip_modif_prev	0	\N
127	0	1597315740	backup	backup_auto_users	1	\N
128	0	1597315740	backup	backup_auto_role_assignments	1	\N
129	0	1597315740	backup	backup_auto_activities	1	\N
130	0	1597315740	backup	backup_auto_blocks	1	\N
131	0	1597315740	backup	backup_auto_files	1	\N
132	0	1597315740	backup	backup_auto_filters	1	\N
133	0	1597315740	backup	backup_auto_comments	1	\N
134	0	1597315740	backup	backup_auto_badges	1	\N
135	0	1597315740	backup	backup_auto_calendarevents	1	\N
136	0	1597315740	backup	backup_auto_userscompletion	1	\N
137	0	1597315740	backup	backup_auto_logs	0	\N
138	0	1597315740	backup	backup_auto_histories	0	\N
139	0	1597315740	backup	backup_auto_questionbank	1	\N
140	0	1597315740	backup	backup_auto_groups	1	\N
141	0	1597315740	backup	backup_auto_competencies	1	\N
142	0	1597315740	backup	backup_auto_contentbankcontent	1	\N
143	0	1597315740	restore	restore_general_users	1	\N
144	0	1597315740	restore	restore_general_users_locked		\N
145	0	1597315740	restore	restore_general_enrolments	1	\N
146	0	1597315740	restore	restore_general_enrolments_locked		\N
147	0	1597315740	restore	restore_general_role_assignments	1	\N
148	0	1597315740	restore	restore_general_role_assignments_locked		\N
149	0	1597315740	restore	restore_general_activities	1	\N
150	0	1597315740	restore	restore_general_activities_locked		\N
151	0	1597315740	restore	restore_general_blocks	1	\N
152	0	1597315740	restore	restore_general_blocks_locked		\N
153	0	1597315740	restore	restore_general_filters	1	\N
154	0	1597315740	restore	restore_general_filters_locked		\N
155	0	1597315740	restore	restore_general_comments	1	\N
156	0	1597315740	restore	restore_general_comments_locked		\N
157	0	1597315740	restore	restore_general_badges	1	\N
158	0	1597315740	restore	restore_general_badges_locked		\N
159	0	1597315740	restore	restore_general_calendarevents	1	\N
160	0	1597315740	restore	restore_general_calendarevents_locked		\N
161	0	1597315740	restore	restore_general_userscompletion	1	\N
162	0	1597315740	restore	restore_general_userscompletion_locked		\N
163	0	1597315740	restore	restore_general_logs	1	\N
164	0	1597315740	restore	restore_general_logs_locked		\N
165	0	1597315740	restore	restore_general_histories	1	\N
166	0	1597315740	restore	restore_general_histories_locked		\N
167	0	1597315740	restore	restore_general_groups	1	\N
168	0	1597315740	restore	restore_general_groups_locked		\N
169	0	1597315740	restore	restore_general_competencies	1	\N
170	0	1597315740	restore	restore_general_competencies_locked		\N
171	0	1597315740	restore	restore_general_contentbankcontent	1	\N
172	0	1597315740	restore	restore_general_contentbankcontent_locked		\N
173	0	1597315740	restore	restore_merge_overwrite_conf	0	\N
174	0	1597315740	restore	restore_merge_overwrite_conf_locked		\N
175	0	1597315740	restore	restore_merge_course_fullname	1	\N
176	0	1597315740	restore	restore_merge_course_fullname_locked		\N
177	0	1597315740	restore	restore_merge_course_shortname	1	\N
178	0	1597315740	restore	restore_merge_course_shortname_locked		\N
179	0	1597315741	restore	restore_merge_course_startdate	1	\N
180	0	1597315741	restore	restore_merge_course_startdate_locked		\N
181	0	1597315741	restore	restore_replace_overwrite_conf	0	\N
182	0	1597315741	restore	restore_replace_overwrite_conf_locked		\N
183	0	1597315741	restore	restore_replace_course_fullname	1	\N
184	0	1597315741	restore	restore_replace_course_fullname_locked		\N
185	0	1597315741	restore	restore_replace_course_shortname	1	\N
186	0	1597315741	restore	restore_replace_course_shortname_locked		\N
187	0	1597315741	restore	restore_replace_course_startdate	1	\N
188	0	1597315741	restore	restore_replace_course_startdate_locked		\N
189	0	1597315741	restore	restore_replace_keep_roles_and_enrolments	0	\N
190	0	1597315741	restore	restore_replace_keep_roles_and_enrolments_locked		\N
191	0	1597315741	restore	restore_replace_keep_groups_and_groupings	0	\N
192	0	1597315741	restore	restore_replace_keep_groups_and_groupings_locked		\N
193	0	1597315741	\N	enableasyncbackup	0	\N
194	0	1597315741	backup	backup_async_message_users	0	\N
195	0	1597315741	backup	backup_async_message_subject	Moodle {operation} completed successfully	\N
196	0	1597315741	backup	backup_async_message	Hi {user_firstname},<br/> Your {operation} (ID: {backupid}) has completed successfully. <br/><br/>You can access it here: {link}.	\N
197	0	1597315741	\N	grade_profilereport	user	\N
198	0	1597315741	\N	grade_aggregationposition	1	\N
199	0	1597315741	\N	grade_includescalesinaggregation	1	\N
200	0	1597315741	\N	grade_hiddenasdate	0	\N
201	0	1597315741	\N	gradepublishing	0	\N
202	0	1597315741	\N	grade_export_exportfeedback	0	\N
203	0	1597315741	\N	grade_export_displaytype	1	\N
204	0	1597315741	\N	grade_export_decimalpoints	2	\N
205	0	1597315741	\N	grade_navmethod	1	\N
206	0	1597315741	\N	grade_export_userprofilefields	firstname,lastname,idnumber,institution,department,email	\N
207	0	1597315741	\N	grade_export_customprofilefields		\N
208	0	1597315741	\N	recovergradesdefault	0	\N
209	0	1597315741	\N	gradeexport		\N
210	0	1597315741	\N	unlimitedgrades	0	\N
211	0	1597315741	\N	grade_report_showmin	1	\N
212	0	1597315741	\N	gradepointmax	100	\N
213	0	1597315741	\N	gradepointdefault	100	\N
214	0	1597315741	\N	grade_minmaxtouse	1	\N
215	0	1597315741	\N	grade_mygrades_report	overview	\N
216	0	1597315741	\N	gradereport_mygradeurl		\N
217	0	1597315742	\N	grade_hideforcedsettings	1	\N
218	0	1597315742	\N	grade_aggregation	13	\N
219	0	1597315742	\N	grade_aggregation_flag	0	\N
220	0	1597315742	\N	grade_aggregations_visible	13	\N
221	0	1597315742	\N	grade_aggregateonlygraded	1	\N
222	0	1597315742	\N	grade_aggregateonlygraded_flag	2	\N
223	0	1597315742	\N	grade_aggregateoutcomes	0	\N
224	0	1597315742	\N	grade_aggregateoutcomes_flag	2	\N
225	0	1597315742	\N	grade_keephigh	0	\N
226	0	1597315742	\N	grade_keephigh_flag	3	\N
227	0	1597315742	\N	grade_droplow	0	\N
228	0	1597315742	\N	grade_droplow_flag	2	\N
229	0	1597315742	\N	grade_overridecat	1	\N
230	0	1597315742	\N	grade_displaytype	1	\N
231	0	1597315742	\N	grade_decimalpoints	2	\N
232	0	1597315742	\N	grade_item_advanced	iteminfo,idnumber,gradepass,plusfactor,multfactor,display,decimals,hiddenuntil,locktime	\N
233	0	1597315742	\N	grade_report_studentsperpage	100	\N
234	0	1597315742	\N	grade_report_showonlyactiveenrol	1	\N
235	0	1597315742	\N	grade_report_quickgrading	1	\N
236	0	1597315742	\N	grade_report_showquickfeedback	0	\N
237	0	1597315742	\N	grade_report_meanselection	1	\N
238	0	1597315742	\N	grade_report_enableajax	0	\N
239	0	1597315742	\N	grade_report_showcalculations	1	\N
240	0	1597315742	\N	grade_report_showeyecons	0	\N
241	0	1597315742	\N	grade_report_showaverages	1	\N
242	0	1597315742	\N	grade_report_showlocks	0	\N
243	0	1597315742	\N	grade_report_showranges	0	\N
244	0	1597315742	\N	grade_report_showanalysisicon	1	\N
245	0	1597315742	\N	grade_report_showuserimage	1	\N
246	0	1597315742	\N	grade_report_showactivityicons	1	\N
247	0	1597315742	\N	grade_report_shownumberofgrades	0	\N
248	0	1597315742	\N	grade_report_averagesdisplaytype	inherit	\N
249	0	1597315742	\N	grade_report_rangesdisplaytype	inherit	\N
250	0	1597315742	\N	grade_report_averagesdecimalpoints	inherit	\N
251	0	1597315742	\N	grade_report_rangesdecimalpoints	inherit	\N
252	0	1597315742	\N	grade_report_historyperpage	50	\N
253	0	1597315742	\N	grade_report_overview_showrank	0	\N
254	0	1597315742	\N	grade_report_overview_showtotalsifcontainhidden	0	\N
255	0	1597315743	\N	grade_report_user_showrank	0	\N
256	0	1597315743	\N	grade_report_user_showpercentage	1	\N
257	0	1597315743	\N	grade_report_user_showgrade	1	\N
258	0	1597315743	\N	grade_report_user_showfeedback	1	\N
259	0	1597315743	\N	grade_report_user_showrange	1	\N
260	0	1597315743	\N	grade_report_user_showweight	1	\N
261	0	1597315743	\N	grade_report_user_showaverage	0	\N
262	0	1597315743	\N	grade_report_user_showlettergrade	0	\N
263	0	1597315743	\N	grade_report_user_rangedecimals	0	\N
264	0	1597315743	\N	grade_report_user_showhiddenitems	1	\N
265	0	1597315743	\N	grade_report_user_showtotalsifcontainhidden	0	\N
266	0	1597315743	\N	grade_report_user_showcontributiontocoursetotal	1	\N
267	0	1597315743	analytics	modeinstruction		\N
268	0	1597315743	analytics	percentonline	0	\N
269	0	1597315743	analytics	typeinstitution		\N
270	0	1597315743	analytics	levelinstitution		\N
271	0	1597315743	analytics	predictionsprocessor	\\mlbackend_php\\processor	\N
371	0	1597315746	\N	enabletrusttext	0	\N
372	0	1597315746	\N	maxeditingtime	1800	\N
272	0	1597315743	analytics	defaulttimesplittingsevaluation	\\core\\analytics\\time_splitting\\quarters_accum,\\core\\analytics\\time_splitting\\quarters,\\core\\analytics\\time_splitting\\single_range	\N
273	0	1597315743	analytics	modeloutputdir	/var/www/moodledata/models	\N
274	0	1597315743	analytics	onlycli	1	\N
275	0	1597315743	analytics	modeltimelimit	1200	\N
276	0	1597315743	core_competency	enabled	1	\N
277	0	1597315743	core_competency	pushcourseratingstouserplans	1	\N
278	0	1597315743	\N	badges_defaultissuername		\N
279	0	1597315743	\N	badges_defaultissuercontact		\N
280	0	1597315743	\N	badges_badgesalt	badges1597315726	\N
281	0	1597315743	\N	badges_allowcoursebadges	1	\N
282	0	1597315743	\N	badges_allowexternalbackpack	1	\N
283	0	1597315743	\N	rememberuserlicensepref	1	\N
284	0	1597315744	\N	timezone	Europe/London	\N
285	0	1597315745	\N	forcetimezone	99	\N
286	0	1597315745	\N	country	0	\N
287	0	1597315745	\N	defaultcity		\N
288	0	1597315745	\N	geoip2file	/var/www/moodledata/geoip/GeoLite2-City.mmdb	\N
289	0	1597315745	\N	googlemapkey3		\N
290	0	1597315745	\N	allcountrycodes		\N
291	0	1597315745	\N	autolang	1	\N
292	0	1597315745	\N	lang	en	\N
293	0	1597315745	\N	langmenu	1	\N
294	0	1597315745	\N	langlist		\N
295	0	1597315745	\N	langcache	1	\N
296	0	1597315745	\N	langstringcache	1	\N
297	0	1597315745	\N	locale		\N
298	0	1597315745	\N	latinexcelexport	0	\N
299	0	1597315745	\N	messaging	1	\N
300	0	1597315745	\N	messagingallusers	0	\N
301	0	1597315745	\N	messagingdefaultpressenter	1	\N
302	0	1597315745	\N	messagingdeletereadnotificationsdelay	604800	\N
303	0	1597315745	\N	messagingdeleteallnotificationsdelay	2620800	\N
304	0	1597315745	\N	messagingallowemailoverride	0	\N
305	0	1597315745	\N	requiremodintro	0	\N
306	0	1597315745	\N	registerauth		\N
307	0	1597315745	\N	authloginviaemail	0	\N
308	0	1597315745	\N	allowaccountssameemail	0	\N
309	0	1597315745	\N	authpreventaccountcreation	0	\N
310	0	1597315745	\N	loginpageautofocus	0	\N
311	0	1597315745	\N	guestloginbutton	1	\N
312	0	1597315745	\N	limitconcurrentlogins	0	\N
313	0	1597315746	\N	alternateloginurl		\N
314	0	1597315746	\N	forgottenpasswordurl		\N
315	0	1597315746	\N	auth_instructions		\N
316	0	1597315746	\N	allowemailaddresses		\N
317	0	1597315746	\N	denyemailaddresses		\N
318	0	1597315746	\N	verifychangedemail	1	\N
319	0	1597315746	\N	recaptchapublickey		\N
320	0	1597315746	\N	recaptchaprivatekey		\N
321	0	1597315746	cachestore_apcu	testperformance	0	\N
322	0	1597315746	cachestore_memcached	testservers		\N
323	0	1597315746	cachestore_mongodb	testserver		\N
324	0	1597315746	cachestore_redis	test_server		\N
325	0	1597315746	cachestore_redis	test_password		\N
326	0	1597315746	\N	filteruploadedfiles	0	\N
327	0	1597315746	\N	filtermatchoneperpage	0	\N
328	0	1597315746	\N	filtermatchonepertext	0	\N
329	0	1597315746	\N	media_default_width	400	\N
330	0	1597315746	\N	media_default_height	300	\N
331	0	1597315746	\N	portfolio_moderate_filesize_threshold	1048576	\N
332	0	1597315746	\N	portfolio_high_filesize_threshold	5242880	\N
333	0	1597315746	\N	portfolio_moderate_db_threshold	20	\N
334	0	1597315746	\N	portfolio_high_db_threshold	50	\N
335	0	1597315746	question_preview	behaviour	deferredfeedback	\N
336	0	1597315746	question_preview	correctness	1	\N
337	0	1597315746	question_preview	marks	2	\N
338	0	1597315746	question_preview	markdp	2	\N
339	0	1597315746	question_preview	feedback	1	\N
340	0	1597315746	question_preview	generalfeedback	1	\N
341	0	1597315746	question_preview	rightanswer	1	\N
342	0	1597315746	question_preview	history	0	\N
343	0	1597315746	\N	repositorycacheexpire	120	\N
344	0	1597315746	\N	repositorygetfiletimeout	30	\N
345	0	1597315746	\N	repositorysyncfiletimeout	1	\N
346	0	1597315746	\N	repositorysyncimagetimeout	3	\N
347	0	1597315746	\N	repositoryallowexternallinks	1	\N
348	0	1597315746	\N	legacyfilesinnewcourses	0	\N
349	0	1597315746	\N	legacyfilesaddallowed	1	\N
350	0	1597315746	\N	searchengine	simpledb	\N
351	0	1597315746	\N	searchindexwhendisabled	0	\N
352	0	1597315746	\N	searchindextime	600	\N
353	0	1597315746	\N	searchallavailablecourses	0	\N
354	0	1597315746	\N	searchincludeallcourses	0	\N
355	0	1597315746	\N	searchenablecategories	0	\N
356	0	1597315746	\N	searchdefaultcategory	core-all	\N
357	0	1597315746	\N	searchhideallcategory	0	\N
358	0	1597315746	\N	enablewsdocumentation	0	\N
359	0	1597315746	\N	allowbeforeblock	0	\N
360	0	1597315746	\N	allowedip		\N
361	0	1597315746	\N	blockedip		\N
362	0	1597315746	\N	protectusernames	1	\N
363	0	1597315746	\N	forcelogin	0	\N
364	0	1597315746	\N	forceloginforprofiles	1	\N
365	0	1597315746	\N	forceloginforprofileimage	0	\N
366	0	1597315746	\N	opentowebcrawlers	0	\N
367	0	1597315746	\N	allowindexing	0	\N
368	0	1597315746	\N	maxbytes	0	\N
369	0	1597315746	\N	userquota	104857600	\N
370	0	1597315746	\N	allowobjectembed	0	\N
573	0	1597315749	\N	perfdebug	7	\N
373	0	1597315746	\N	extendedusernamechars	0	\N
374	0	1597315746	\N	keeptagnamecase	1	\N
375	0	1597315746	\N	profilesforenrolledusersonly	1	\N
376	0	1597315746	\N	cronclionly	1	\N
377	0	1597315746	\N	cronremotepassword		\N
378	0	1597315746	tool_task	enablerunnow	1	\N
379	0	1597315746	\N	lockoutthreshold	0	\N
380	0	1597315746	\N	lockoutwindow	1800	\N
381	0	1597315746	\N	lockoutduration	1800	\N
382	0	1597315746	\N	passwordpolicy	1	\N
383	0	1597315746	\N	minpasswordlength	8	\N
384	0	1597315746	\N	minpassworddigits	1	\N
385	0	1597315746	\N	minpasswordlower	1	\N
386	0	1597315746	\N	minpasswordupper	1	\N
387	0	1597315746	\N	minpasswordnonalphanum	1	\N
388	0	1597315746	\N	maxconsecutiveidentchars	0	\N
389	0	1597315746	\N	passwordpolicycheckonlogin	0	\N
390	0	1597315746	\N	passwordreuselimit	0	\N
391	0	1597315746	\N	pwresettime	1800	\N
392	0	1597315746	\N	passwordchangelogout	0	\N
393	0	1597315746	\N	passwordchangetokendeletion	0	\N
394	0	1597315746	\N	tokenduration	7257600	\N
395	0	1597315746	\N	groupenrolmentkeypolicy	1	\N
396	0	1597315747	\N	disableuserimages	0	\N
397	0	1597315747	\N	emailchangeconfirmation	1	\N
398	0	1597315747	\N	rememberusername	2	\N
399	0	1597315747	\N	strictformsrequired	0	\N
400	0	1597315747	\N	cookiesecure	1	\N
401	0	1597315747	\N	cookiehttponly	0	\N
402	0	1597315747	\N	allowframembedding	0	\N
403	0	1597315747	\N	curlsecurityblockedhosts		\N
404	0	1597315747	\N	curlsecurityallowedport		\N
405	0	1597315747	\N	displayloginfailures	0	\N
406	0	1597315747	\N	notifyloginfailures		\N
407	0	1597315747	\N	notifyloginthreshold	10	\N
408	0	1597315747	\N	themelist		\N
409	0	1597315747	\N	themedesignermode	0	\N
410	0	1597315747	\N	allowuserthemes	0	\N
411	0	1597315747	\N	allowcoursethemes	0	\N
412	0	1597315747	\N	allowcategorythemes	0	\N
413	0	1597315747	\N	allowcohortthemes	0	\N
414	0	1597315747	\N	allowthemechangeonurl	0	\N
415	0	1597315747	\N	allowuserblockhiding	1	\N
416	0	1597315747	\N	langmenuinsecurelayout	0	\N
417	0	1597315747	\N	logininfoinsecurelayout	0	\N
418	0	1597315747	\N	custommenuitems		\N
419	0	1597315747	\N	customusermenuitems	grades,grades|/grade/report/mygrades.php|t/grades\nmessages,message|/message/index.php|t/message\npreferences,moodle|/user/preferences.php|t/preferences	\N
420	0	1597315747	\N	enabledevicedetection	1	\N
421	0	1597315747	\N	devicedetectregex	[]	\N
422	0	1597315747	theme_boost	preset	default.scss	\N
423	0	1597315747	theme_boost	presetfiles		\N
424	0	1597315747	theme_boost	backgroundimage		\N
425	0	1597315747	theme_boost	brandcolor		\N
426	0	1597315747	theme_boost	scsspre		\N
427	0	1597315747	theme_boost	scss		\N
428	0	1597315747	theme_classic	navbardark	0	\N
429	0	1597315747	theme_classic	preset	default.scss	\N
430	0	1597315747	theme_classic	presetfiles		\N
431	0	1597315747	theme_classic	backgroundimage		\N
432	0	1597315747	theme_classic	brandcolor		\N
433	0	1597315747	theme_classic	scsspre		\N
434	0	1597315747	theme_classic	scss		\N
435	0	1597315747	core_admin	logo		\N
436	0	1597315747	core_admin	logocompact		\N
437	0	1597315747	core_admin	coursecolor1	#81ecec	\N
438	0	1597315747	core_admin	coursecolor2	#74b9ff	\N
439	0	1597315747	core_admin	coursecolor3	#a29bfe	\N
440	0	1597315747	core_admin	coursecolor4	#dfe6e9	\N
441	0	1597315747	core_admin	coursecolor5	#00b894	\N
442	0	1597315747	core_admin	coursecolor6	#0984e3	\N
443	0	1597315747	core_admin	coursecolor7	#b2bec3	\N
444	0	1597315747	core_admin	coursecolor8	#fdcb6e	\N
445	0	1597315747	core_admin	coursecolor9	#fd79a8	\N
446	0	1597315747	core_admin	coursecolor10	#6c5ce7	\N
447	0	1597315747	\N	calendartype	gregorian	\N
448	0	1597315747	\N	calendar_adminseesall	0	\N
449	0	1597315747	\N	calendar_site_timeformat	0	\N
450	0	1597315747	\N	calendar_startwday	1	\N
451	0	1597315747	\N	calendar_weekend	65	\N
452	0	1597315747	\N	calendar_lookahead	21	\N
453	0	1597315747	\N	calendar_maxevents	10	\N
454	0	1597315747	\N	enablecalendarexport	1	\N
455	0	1597315747	\N	calendar_customexport	1	\N
456	0	1597315747	\N	calendar_exportlookahead	365	\N
457	0	1597315747	\N	calendar_exportlookback	5	\N
458	0	1597315747	\N	calendar_exportsalt	yCwuJmGUAl5m0ZqmZclhxLp3mBAyxdGsStuKFDfqVDQubF7VIfZJhV0mDDEl	\N
459	0	1597315747	\N	calendar_showicalsource	1	\N
460	0	1597315747	\N	useblogassociations	1	\N
461	0	1597315747	\N	bloglevel	4	\N
462	0	1597315747	\N	useexternalblogs	1	\N
463	0	1597315747	\N	externalblogcrontime	86400	\N
464	0	1597315747	\N	maxexternalblogsperuser	1	\N
465	0	1597315747	\N	blogusecomments	1	\N
466	0	1597315747	\N	blogshowcommentscount	1	\N
467	0	1597315747	\N	defaulthomepage	1	\N
468	0	1597315747	\N	allowguestmymoodle	1	\N
469	0	1597315747	\N	navshowfullcoursenames	0	\N
470	0	1597315747	\N	navshowcategories	1	\N
471	0	1597315747	\N	navshowmycoursecategories	0	\N
472	0	1597315747	\N	navshowallcourses	0	\N
473	0	1597315747	\N	navsortmycoursessort	sortorder	\N
474	0	1597315747	\N	navsortmycourseshiddenlast	1	\N
475	0	1597315747	\N	navcourselimit	10	\N
476	0	1597315747	\N	usesitenameforsitepages	0	\N
477	0	1597315747	\N	linkadmincategories	1	\N
478	0	1597315747	\N	linkcoursesections	1	\N
479	0	1597315747	\N	navshowfrontpagemods	1	\N
480	0	1597315747	\N	navadduserpostslinks	1	\N
481	0	1597315747	\N	formatstringstriptags	1	\N
482	0	1597315748	\N	emoticons	[{"text":":-)","imagename":"s\\/smiley","imagecomponent":"core","altidentifier":"smiley","altcomponent":"core_pix"},{"text":":)","imagename":"s\\/smiley","imagecomponent":"core","altidentifier":"smiley","altcomponent":"core_pix"},{"text":":-D","imagename":"s\\/biggrin","imagecomponent":"core","altidentifier":"biggrin","altcomponent":"core_pix"},{"text":";-)","imagename":"s\\/wink","imagecomponent":"core","altidentifier":"wink","altcomponent":"core_pix"},{"text":":-\\/","imagename":"s\\/mixed","imagecomponent":"core","altidentifier":"mixed","altcomponent":"core_pix"},{"text":"V-.","imagename":"s\\/thoughtful","imagecomponent":"core","altidentifier":"thoughtful","altcomponent":"core_pix"},{"text":":-P","imagename":"s\\/tongueout","imagecomponent":"core","altidentifier":"tongueout","altcomponent":"core_pix"},{"text":":-p","imagename":"s\\/tongueout","imagecomponent":"core","altidentifier":"tongueout","altcomponent":"core_pix"},{"text":"B-)","imagename":"s\\/cool","imagecomponent":"core","altidentifier":"cool","altcomponent":"core_pix"},{"text":"^-)","imagename":"s\\/approve","imagecomponent":"core","altidentifier":"approve","altcomponent":"core_pix"},{"text":"8-)","imagename":"s\\/wideeyes","imagecomponent":"core","altidentifier":"wideeyes","altcomponent":"core_pix"},{"text":":o)","imagename":"s\\/clown","imagecomponent":"core","altidentifier":"clown","altcomponent":"core_pix"},{"text":":-(","imagename":"s\\/sad","imagecomponent":"core","altidentifier":"sad","altcomponent":"core_pix"},{"text":":(","imagename":"s\\/sad","imagecomponent":"core","altidentifier":"sad","altcomponent":"core_pix"},{"text":"8-.","imagename":"s\\/shy","imagecomponent":"core","altidentifier":"shy","altcomponent":"core_pix"},{"text":":-I","imagename":"s\\/blush","imagecomponent":"core","altidentifier":"blush","altcomponent":"core_pix"},{"text":":-X","imagename":"s\\/kiss","imagecomponent":"core","altidentifier":"kiss","altcomponent":"core_pix"},{"text":"8-o","imagename":"s\\/surprise","imagecomponent":"core","altidentifier":"surprise","altcomponent":"core_pix"},{"text":"P-|","imagename":"s\\/blackeye","imagecomponent":"core","altidentifier":"blackeye","altcomponent":"core_pix"},{"text":"8-[","imagename":"s\\/angry","imagecomponent":"core","altidentifier":"angry","altcomponent":"core_pix"},{"text":"(grr)","imagename":"s\\/angry","imagecomponent":"core","altidentifier":"angry","altcomponent":"core_pix"},{"text":"xx-P","imagename":"s\\/dead","imagecomponent":"core","altidentifier":"dead","altcomponent":"core_pix"},{"text":"|-.","imagename":"s\\/sleepy","imagecomponent":"core","altidentifier":"sleepy","altcomponent":"core_pix"},{"text":"}-]","imagename":"s\\/evil","imagecomponent":"core","altidentifier":"evil","altcomponent":"core_pix"},{"text":"(h)","imagename":"s\\/heart","imagecomponent":"core","altidentifier":"heart","altcomponent":"core_pix"},{"text":"(heart)","imagename":"s\\/heart","imagecomponent":"core","altidentifier":"heart","altcomponent":"core_pix"},{"text":"(y)","imagename":"s\\/yes","imagecomponent":"core","altidentifier":"yes","altcomponent":"core"},{"text":"(n)","imagename":"s\\/no","imagecomponent":"core","altidentifier":"no","altcomponent":"core"},{"text":"(martin)","imagename":"s\\/martin","imagecomponent":"core","altidentifier":"martin","altcomponent":"core_pix"},{"text":"( )","imagename":"s\\/egg","imagecomponent":"core","altidentifier":"egg","altcomponent":"core_pix"}]	\N
483	0	1597315748	\N	docroot	https://docs.moodle.org	\N
484	0	1597315748	\N	doclang		\N
485	0	1597315748	\N	doctonewwindow	0	\N
486	0	1597315748	\N	coursecontactduplicates	0	\N
487	0	1597315748	\N	courselistshortnames	0	\N
488	0	1597315748	\N	coursesperpage	20	\N
489	0	1597315748	\N	courseswithsummarieslimit	10	\N
490	0	1597315748	\N	courseoverviewfileslimit	1	\N
491	0	1597315748	\N	courseoverviewfilesext	.jpg,.gif,.png	\N
492	0	1597315748	\N	coursegraceperiodbefore	0	\N
493	0	1597315748	\N	coursegraceperiodafter	0	\N
494	0	1597315748	\N	useexternalyui	0	\N
495	0	1597315748	\N	yuicomboloading	1	\N
496	0	1597315748	\N	cachejs	1	\N
497	0	1597315748	\N	modchooserdefault	1	\N
498	0	1597315748	\N	additionalhtmlhead		\N
499	0	1597315748	\N	additionalhtmltopofbody		\N
500	0	1597315748	\N	additionalhtmlfooter		\N
501	0	1597315748	\N	cachetemplates	1	\N
502	0	1597315748	\N	pathtophp		\N
503	0	1597315748	\N	pathtodu		\N
504	0	1597315748	\N	aspellpath		\N
505	0	1597315748	\N	pathtodot		\N
506	0	1597315748	\N	pathtogs	/usr/bin/gs	\N
507	0	1597315748	\N	pathtopython		\N
508	0	1597315748	\N	supportname	Admin User	\N
509	0	1597315748	\N	supportemail		\N
510	0	1597315748	\N	supportpage		\N
511	0	1597315748	\N	dbsessions	0	\N
512	0	1597315748	\N	sessioncookie		\N
513	0	1597315748	\N	sessioncookiepath		\N
514	0	1597315748	\N	sessioncookiedomain		\N
515	0	1597315748	\N	statsfirstrun	none	\N
516	0	1597315748	\N	statsmaxruntime	0	\N
517	0	1597315748	\N	statsruntimedays	31	\N
518	0	1597315748	\N	statsuserthreshold	0	\N
519	0	1597315748	\N	slasharguments	1	\N
520	0	1597315748	\N	getremoteaddrconf	3	\N
521	0	1597315748	\N	reverseproxyignore		\N
522	0	1597315748	\N	proxyhost		\N
523	0	1597315748	\N	proxyport	0	\N
524	0	1597315748	\N	proxytype	HTTP	\N
525	0	1597315748	\N	proxyuser		\N
526	0	1597315748	\N	proxypassword		\N
527	0	1597315748	\N	proxybypass	localhost, 127.0.0.1	\N
528	0	1597315748	\N	maintenance_enabled	0	\N
529	0	1597315748	\N	maintenance_message		\N
530	0	1597315748	\N	deleteunconfirmed	168	\N
531	0	1597315748	\N	deleteincompleteusers	0	\N
532	0	1597315748	\N	disablegradehistory	0	\N
533	0	1597315748	\N	gradehistorylifetime	0	\N
534	0	1597315748	\N	tempdatafoldercleanup	168	\N
535	0	1597315748	\N	filescleanupperiod	86400	\N
536	0	1597315748	\N	extramemorylimit	512M	\N
537	0	1597315748	\N	maxtimelimit	0	\N
538	0	1597315748	\N	curlcache	120	\N
539	0	1597315748	\N	curltimeoutkbitrate	56	\N
540	0	1597315748	\N	task_scheduled_concurrency_limit	3	\N
541	0	1597315748	\N	task_scheduled_max_runtime	1800	\N
542	0	1597315748	\N	task_adhoc_concurrency_limit	3	\N
543	0	1597315748	\N	task_adhoc_max_runtime	1800	\N
544	0	1597315748	\N	task_logmode	1	\N
545	0	1597315748	\N	task_logtostdout	1	\N
546	0	1597315749	\N	task_logretention	2419200	\N
547	0	1597315749	\N	task_logretainruns	20	\N
548	0	1597315749	\N	smtphosts		\N
549	0	1597315749	\N	smtpsecure		\N
550	0	1597315749	\N	smtpauthtype	LOGIN	\N
551	0	1597315749	\N	smtpuser		\N
552	0	1597315749	\N	smtppass		\N
553	0	1597315749	\N	smtpmaxbulk	1	\N
554	0	1597315749	\N	noreplyaddress	noreply@arrupe.ac.zw	\N
555	0	1597315749	\N	allowedemaildomains		\N
556	0	1597315749	\N	sitemailcharset	0	\N
557	0	1597315749	\N	allowusermailcharset	0	\N
558	0	1597315749	\N	allowattachments	1	\N
559	0	1597315749	\N	mailnewline	LF	\N
560	0	1597315749	\N	emailfromvia	1	\N
561	0	1597315749	\N	emailsubjectprefix		\N
562	0	1597315749	\N	updateautocheck	1	\N
563	0	1597315749	\N	updateminmaturity	200	\N
564	0	1597315749	\N	updatenotifybuilds	0	\N
565	0	1597315749	\N	dndallowtextandlinks	0	\N
566	0	1597315749	\N	pathtosassc		\N
567	0	1597315749	\N	contextlocking	0	\N
568	0	1597315749	\N	contextlockappliestoadmin	1	\N
569	0	1597315749	\N	forceclean	0	\N
570	0	1597315749	\N	enablecourserelativedates	0	\N
571	0	1597315749	\N	debug	0	\N
572	0	1597315749	\N	debugdisplay	0	\N
574	0	1597315749	\N	debugstringids	0	\N
575	0	1597315749	\N	debugvalidators	0	\N
576	0	1597315749	\N	debugpageinfo	0	\N
577	0	1597315749	\N	profilingenabled	0	\N
578	0	1597315749	\N	profilingincluded		\N
579	0	1597315749	\N	profilingexcluded		\N
580	0	1597315749	\N	profilingautofrec	0	\N
581	0	1597315749	\N	profilingallowme	0	\N
582	0	1597315749	\N	profilingallowall	0	\N
583	0	1597315749	\N	profilingslow	0	\N
584	0	1597315749	\N	profilinglifetime	1440	\N
585	0	1597315749	\N	profilingimportprefix	(I)	\N
586	0	1597315754	\N	calendar_exportsalt	644FhPDRCXurCiloroJ0oqVZJ7XcxZCMjLUdF5e5f6OyO230TbrzBR5oYccQ	yCwuJmGUAl5m0ZqmZclhxLp3mBAyxdGsStuKFDfqVDQubF7VIfZJhV0mDDEl
587	0	1597315789	activitynames	filter_active	1	
588	0	1597315789	displayh5p	filter_active	1	
589	0	1597315789	emoticon	filter_active	1	
590	0	1597315790	mathjaxloader	filter_active	1	
591	0	1597315790	mediaplugin	filter_active	1	
592	0	1597315790	urltolink	filter_active	1	
593	2	1597315914	\N	notloggedinroleid	6	\N
594	2	1597315914	\N	guestroleid	6	\N
595	2	1597315914	\N	defaultuserroleid	7	\N
596	2	1597315914	\N	creatornewroleid	3	\N
597	2	1597315914	\N	restorernewroleid	3	\N
598	2	1597315914	tool_dataprivacy	contactdataprotectionofficer	0	\N
599	2	1597315914	tool_dataprivacy	automaticdataexportapproval	0	\N
600	2	1597315914	tool_dataprivacy	automaticdatadeletionapproval	0	\N
601	2	1597315914	tool_dataprivacy	automaticdeletionrequests	1	\N
602	2	1597315914	tool_dataprivacy	privacyrequestexpiry	604800	\N
603	2	1597315914	tool_dataprivacy	requireallenddatesforuserdeletion	1	\N
604	2	1597315914	tool_dataprivacy	showdataretentionsummary	1	\N
605	2	1597315914	tool_log	exportlog	1	\N
606	2	1597315914	\N	sitepolicyhandler		\N
607	2	1597315914	\N	gradebookroles	5	\N
608	2	1597315914	analytics	logstore	logstore_standard	\N
609	2	1597315914	\N	h5plibraryhandler	h5plib_v124	\N
610	2	1597315914	\N	jabberhost		\N
611	2	1597315914	\N	jabberserver		\N
612	2	1597315914	\N	jabberusername		\N
613	2	1597315914	\N	jabberpassword		\N
614	2	1597315914	\N	jabberport	5222	\N
615	2	1597315914	\N	airnotifierurl	https://messages.moodle.net	\N
616	2	1597315914	\N	airnotifierport	443	\N
617	2	1597315914	\N	airnotifiermobileappname	com.moodle.moodlemobile	\N
618	2	1597315914	\N	airnotifierappname	commoodlemoodlemobile	\N
619	2	1597315914	\N	airnotifieraccesskey		\N
620	2	1597315914	assign	feedback_plugin_for_gradebook	assignfeedback_comments	\N
621	2	1597315914	assign	showrecentsubmissions	0	\N
622	2	1597315914	assign	submissionreceipts	1	\N
623	2	1597315914	assign	submissionstatement	This submission is my own work, except where I have acknowledged the use of the works of other people.	\N
624	2	1597315914	assign	submissionstatementteamsubmission	This submission is the work of my group, except where we have acknowledged the use of the works of other people.	\N
625	2	1597315914	assign	submissionstatementteamsubmissionallsubmit	This submission is my own work as a group member, except where I have acknowledged the use of the works of other people.	\N
626	2	1597315914	assign	maxperpage	-1	\N
627	2	1597315914	assign	alwaysshowdescription	1	\N
628	2	1597315914	assign	alwaysshowdescription_adv		\N
629	2	1597315914	assign	alwaysshowdescription_locked		\N
630	2	1597315914	assign	allowsubmissionsfromdate	0	\N
631	2	1597315914	assign	allowsubmissionsfromdate_enabled	1	\N
632	2	1597315914	assign	allowsubmissionsfromdate_adv		\N
633	2	1597315914	assign	duedate	604800	\N
634	2	1597315914	assign	duedate_enabled	1	\N
635	2	1597315914	assign	duedate_adv		\N
636	2	1597315914	assign	cutoffdate	1209600	\N
637	2	1597315914	assign	cutoffdate_enabled		\N
638	2	1597315914	assign	cutoffdate_adv		\N
639	2	1597315914	assign	gradingduedate	1209600	\N
640	2	1597315914	assign	gradingduedate_enabled	1	\N
641	2	1597315914	assign	gradingduedate_adv		\N
642	2	1597315914	assign	submissiondrafts	0	\N
643	2	1597315914	assign	submissiondrafts_adv		\N
644	2	1597315914	assign	submissiondrafts_locked		\N
645	2	1597315914	assign	requiresubmissionstatement	0	\N
646	2	1597315914	assign	requiresubmissionstatement_adv		\N
647	2	1597315914	assign	requiresubmissionstatement_locked		\N
648	2	1597315914	assign	attemptreopenmethod	none	\N
649	2	1597315914	assign	attemptreopenmethod_adv		\N
650	2	1597315914	assign	attemptreopenmethod_locked		\N
651	2	1597315914	assign	maxattempts	-1	\N
652	2	1597315914	assign	maxattempts_adv		\N
653	2	1597315914	assign	maxattempts_locked		\N
654	2	1597315914	assign	teamsubmission	0	\N
655	2	1597315914	assign	teamsubmission_adv		\N
656	2	1597315914	assign	teamsubmission_locked		\N
657	2	1597315914	assign	preventsubmissionnotingroup	0	\N
658	2	1597315914	assign	preventsubmissionnotingroup_adv		\N
659	2	1597315914	assign	preventsubmissionnotingroup_locked		\N
660	2	1597315914	assign	requireallteammemberssubmit	0	\N
661	2	1597315914	assign	requireallteammemberssubmit_adv		\N
662	2	1597315914	assign	requireallteammemberssubmit_locked		\N
663	2	1597315914	assign	teamsubmissiongroupingid		\N
664	2	1597315914	assign	teamsubmissiongroupingid_adv		\N
665	2	1597315914	assign	sendnotifications	0	\N
666	2	1597315914	assign	sendnotifications_adv		\N
667	2	1597315914	assign	sendnotifications_locked		\N
668	2	1597315914	assign	sendlatenotifications	0	\N
669	2	1597315914	assign	sendlatenotifications_adv		\N
670	2	1597315914	assign	sendlatenotifications_locked		\N
671	2	1597315914	assign	sendstudentnotifications	1	\N
672	2	1597315914	assign	sendstudentnotifications_adv		\N
673	2	1597315914	assign	sendstudentnotifications_locked		\N
674	2	1597315914	assign	blindmarking	0	\N
675	2	1597315914	assign	blindmarking_adv		\N
676	2	1597315914	assign	blindmarking_locked		\N
677	2	1597315914	assign	hidegrader	0	\N
678	2	1597315914	assign	hidegrader_adv		\N
679	2	1597315914	assign	hidegrader_locked		\N
680	2	1597315914	assign	markingworkflow	0	\N
681	2	1597315914	assign	markingworkflow_adv		\N
682	2	1597315914	assign	markingworkflow_locked		\N
683	2	1597315914	assign	markingallocation	0	\N
684	2	1597315914	assign	markingallocation_adv		\N
685	2	1597315914	assign	markingallocation_locked		\N
686	2	1597315914	assignsubmission_file	default	1	\N
687	2	1597315914	assignsubmission_file	maxfiles	20	\N
688	2	1597315914	assignsubmission_file	filetypes		\N
689	2	1597315914	assignsubmission_file	maxbytes	0	\N
690	2	1597315914	assignsubmission_onlinetext	default	0	\N
691	2	1597315914	assignfeedback_comments	default	1	\N
692	2	1597315914	assignfeedback_comments	inline	0	\N
693	2	1597315914	assignfeedback_comments	inline_adv		\N
694	2	1597315915	assignfeedback_comments	inline_locked		\N
695	2	1597315915	assignfeedback_editpdf	default	1	\N
696	2	1597315915	assignfeedback_editpdf	stamps		\N
697	2	1597315915	assignfeedback_file	default	0	\N
698	2	1597315915	assignfeedback_offline	default	0	\N
699	2	1597315915	book	numberingoptions	0,1,2,3	\N
700	2	1597315915	book	navoptions	0,1,2	\N
701	2	1597315915	book	numbering	1	\N
702	2	1597315915	book	navstyle	1	\N
703	2	1597315915	\N	chat_method	ajax	\N
704	2	1597315915	\N	chat_refresh_userlist	10	\N
705	2	1597315915	\N	chat_old_ping	35	\N
706	2	1597315915	\N	chat_refresh_room	5	\N
707	2	1597315915	\N	chat_normal_updatemode	jsupdate	\N
708	2	1597315915	\N	chat_serverhost	arrupe.ac.zw	\N
709	2	1597315915	\N	chat_serverip	127.0.0.1	\N
710	2	1597315915	\N	chat_serverport	9111	\N
711	2	1597315915	\N	chat_servermax	100	\N
712	2	1597315915	\N	data_enablerssfeeds	0	\N
713	2	1597315915	\N	feedback_allowfullanonymous	0	\N
714	2	1597315915	resource	framesize	130	\N
715	2	1597315915	resource	displayoptions	0,1,4,5,6	\N
716	2	1597315915	resource	printintro	1	\N
717	2	1597315915	resource	display	0	\N
718	2	1597315915	resource	showsize	0	\N
719	2	1597315915	resource	showtype	0	\N
720	2	1597315915	resource	showdate	0	\N
721	2	1597315915	resource	popupwidth	620	\N
722	2	1597315915	resource	popupheight	450	\N
723	2	1597315915	resource	filterfiles	0	\N
724	2	1597315915	folder	showexpanded	1	\N
725	2	1597315915	folder	maxsizetodownload	0	\N
726	2	1597315915	\N	forum_displaymode	3	\N
727	2	1597315915	\N	forum_shortpost	300	\N
728	2	1597315915	\N	forum_longpost	600	\N
729	2	1597315915	\N	forum_manydiscussions	100	\N
730	2	1597315915	\N	forum_maxbytes	512000	\N
731	2	1597315915	\N	forum_maxattachments	9	\N
732	2	1597315915	\N	forum_subscription	0	\N
733	2	1597315915	\N	forum_trackingtype	1	\N
734	2	1597315915	\N	forum_trackreadposts	1	\N
735	2	1597315915	\N	forum_allowforcedreadtracking	0	\N
736	2	1597315915	\N	forum_oldpostdays	14	\N
737	2	1597315915	\N	forum_usermarksread	0	\N
738	2	1597315915	\N	forum_cleanreadtime	2	\N
739	2	1597315915	\N	digestmailtime	17	\N
740	2	1597315915	\N	forum_enablerssfeeds	0	\N
741	2	1597315915	\N	forum_enabletimedposts	1	\N
742	2	1597315915	\N	glossary_entbypage	10	\N
743	2	1597315915	\N	glossary_dupentries	0	\N
744	2	1597315915	\N	glossary_allowcomments	0	\N
745	2	1597315915	\N	glossary_linkbydefault	1	\N
746	2	1597315915	\N	glossary_defaultapproval	1	\N
747	2	1597315915	\N	glossary_enablerssfeeds	0	\N
748	2	1597315915	\N	glossary_linkentries	0	\N
749	2	1597315915	\N	glossary_casesensitive	0	\N
750	2	1597315915	\N	glossary_fullmatch	0	\N
751	2	1597315915	imscp	keepold	1	\N
752	2	1597315915	imscp	keepold_adv		\N
753	2	1597315915	label	dndmedia	1	\N
754	2	1597315915	label	dndresizewidth	400	\N
755	2	1597315915	label	dndresizeheight	400	\N
756	2	1597315915	mod_lesson	mediafile		\N
757	2	1597315915	mod_lesson	mediafile_adv	1	\N
758	2	1597315915	mod_lesson	mediawidth	640	\N
759	2	1597315915	mod_lesson	mediaheight	480	\N
760	2	1597315915	mod_lesson	mediaclose	0	\N
761	2	1597315915	mod_lesson	progressbar	0	\N
762	2	1597315915	mod_lesson	progressbar_adv		\N
1050	2	1597315917	auth_db	table		\N
763	2	1597315915	mod_lesson	ongoing	0	\N
764	2	1597315915	mod_lesson	ongoing_adv	1	\N
765	2	1597315915	mod_lesson	displayleftmenu	0	\N
766	2	1597315915	mod_lesson	displayleftmenu_adv		\N
767	2	1597315915	mod_lesson	displayleftif	0	\N
768	2	1597315915	mod_lesson	displayleftif_adv	1	\N
769	2	1597315915	mod_lesson	slideshow	0	\N
770	2	1597315915	mod_lesson	slideshow_adv	1	\N
771	2	1597315915	mod_lesson	slideshowwidth	640	\N
772	2	1597315915	mod_lesson	slideshowheight	480	\N
773	2	1597315915	mod_lesson	slideshowbgcolor	#FFFFFF	\N
774	2	1597315915	mod_lesson	maxanswers	5	\N
775	2	1597315915	mod_lesson	maxanswers_adv	1	\N
776	2	1597315915	mod_lesson	defaultfeedback	0	\N
777	2	1597315915	mod_lesson	defaultfeedback_adv	1	\N
778	2	1597315915	mod_lesson	activitylink		\N
779	2	1597315915	mod_lesson	activitylink_adv	1	\N
780	2	1597315915	mod_lesson	timelimit	0	\N
781	2	1597315915	mod_lesson	timelimit_adv		\N
782	2	1597315915	mod_lesson	password	0	\N
783	2	1597315915	mod_lesson	password_adv	1	\N
784	2	1597315915	mod_lesson	modattempts	0	\N
785	2	1597315915	mod_lesson	modattempts_adv		\N
786	2	1597315915	mod_lesson	displayreview	0	\N
787	2	1597315915	mod_lesson	displayreview_adv		\N
788	2	1597315915	mod_lesson	maximumnumberofattempts	1	\N
789	2	1597315915	mod_lesson	maximumnumberofattempts_adv		\N
790	2	1597315915	mod_lesson	defaultnextpage	0	\N
791	2	1597315915	mod_lesson	defaultnextpage_adv	1	\N
792	2	1597315915	mod_lesson	numberofpagestoshow	1	\N
793	2	1597315915	mod_lesson	numberofpagestoshow_adv	1	\N
794	2	1597315915	mod_lesson	practice	0	\N
795	2	1597315915	mod_lesson	practice_adv		\N
796	2	1597315915	mod_lesson	customscoring	1	\N
797	2	1597315915	mod_lesson	customscoring_adv	1	\N
798	2	1597315915	mod_lesson	retakesallowed	0	\N
799	2	1597315915	mod_lesson	retakesallowed_adv		\N
800	2	1597315915	mod_lesson	handlingofretakes	0	\N
801	2	1597315915	mod_lesson	handlingofretakes_adv	1	\N
802	2	1597315915	mod_lesson	minimumnumberofquestions	0	\N
803	2	1597315915	mod_lesson	minimumnumberofquestions_adv	1	\N
804	2	1597315915	page	displayoptions	5	\N
805	2	1597315915	page	printheading	1	\N
806	2	1597315915	page	printintro	0	\N
807	2	1597315915	page	printlastmodified	1	\N
808	2	1597315915	page	display	5	\N
809	2	1597315915	page	popupwidth	620	\N
810	2	1597315915	page	popupheight	450	\N
811	2	1597315915	quiz	timelimit	0	\N
812	2	1597315915	quiz	timelimit_adv		\N
813	2	1597315915	quiz	overduehandling	autosubmit	\N
814	2	1597315915	quiz	overduehandling_adv		\N
815	2	1597315915	quiz	graceperiod	86400	\N
816	2	1597315915	quiz	graceperiod_adv		\N
817	2	1597315915	quiz	graceperiodmin	60	\N
818	2	1597315915	quiz	attempts	0	\N
819	2	1597315915	quiz	attempts_adv		\N
820	2	1597315915	quiz	grademethod	1	\N
821	2	1597315915	quiz	grademethod_adv		\N
822	2	1597315915	quiz	maximumgrade	10	\N
823	2	1597315915	quiz	questionsperpage	1	\N
824	2	1597315915	quiz	questionsperpage_adv		\N
825	2	1597315915	quiz	navmethod	free	\N
826	2	1597315915	quiz	navmethod_adv	1	\N
827	2	1597315915	quiz	shuffleanswers	1	\N
828	2	1597315915	quiz	shuffleanswers_adv		\N
829	2	1597315916	quiz	preferredbehaviour	deferredfeedback	\N
830	2	1597315916	quiz	canredoquestions	0	\N
831	2	1597315916	quiz	canredoquestions_adv	1	\N
832	2	1597315916	quiz	attemptonlast	0	\N
833	2	1597315916	quiz	attemptonlast_adv	1	\N
834	2	1597315916	quiz	reviewattempt	69904	\N
835	2	1597315916	quiz	reviewcorrectness	69904	\N
836	2	1597315916	quiz	reviewmarks	69904	\N
837	2	1597315916	quiz	reviewspecificfeedback	69904	\N
838	2	1597315916	quiz	reviewgeneralfeedback	69904	\N
839	2	1597315916	quiz	reviewrightanswer	69904	\N
840	2	1597315916	quiz	reviewoverallfeedback	4368	\N
841	2	1597315916	quiz	showuserpicture	0	\N
842	2	1597315916	quiz	showuserpicture_adv		\N
843	2	1597315916	quiz	decimalpoints	2	\N
844	2	1597315916	quiz	decimalpoints_adv		\N
845	2	1597315916	quiz	questiondecimalpoints	-1	\N
846	2	1597315916	quiz	questiondecimalpoints_adv		\N
847	2	1597315916	quiz	showblocks	0	\N
848	2	1597315916	quiz	showblocks_adv	1	\N
849	2	1597315916	quiz	quizpassword		\N
850	2	1597315916	quiz	quizpassword_adv		\N
851	2	1597315916	quiz	quizpassword_required		\N
852	2	1597315916	quiz	subnet		\N
853	2	1597315916	quiz	subnet_adv	1	\N
854	2	1597315916	quiz	delay1	0	\N
855	2	1597315916	quiz	delay1_adv	1	\N
856	2	1597315916	quiz	delay2	0	\N
857	2	1597315916	quiz	delay2_adv	1	\N
858	2	1597315916	quiz	browsersecurity	-	\N
859	2	1597315916	quiz	browsersecurity_adv	1	\N
860	2	1597315916	quiz	initialnumfeedbacks	2	\N
861	2	1597315916	quiz	autosaveperiod	60	\N
862	2	1597315916	quizaccess_seb	autoreconfigureseb	1	\N
863	2	1597315916	quizaccess_seb	showseblinks	seb,http	\N
864	2	1597315916	quizaccess_seb	downloadlink	https://safeexambrowser.org/download_en.html	\N
865	2	1597315916	quizaccess_seb	quizpasswordrequired	0	\N
866	2	1597315916	quizaccess_seb	displayblocksbeforestart	0	\N
867	2	1597315916	quizaccess_seb	displayblockswhenfinished	1	\N
868	2	1597315916	scorm	displaycoursestructure	0	\N
869	2	1597315916	scorm	displaycoursestructure_adv		\N
870	2	1597315916	scorm	popup	0	\N
871	2	1597315916	scorm	popup_adv		\N
872	2	1597315916	scorm	displayactivityname	1	\N
873	2	1597315916	scorm	framewidth	100	\N
874	2	1597315916	scorm	framewidth_adv	1	\N
875	2	1597315916	scorm	frameheight	500	\N
876	2	1597315916	scorm	frameheight_adv	1	\N
877	2	1597315916	scorm	winoptgrp_adv	1	\N
878	2	1597315916	scorm	scrollbars	0	\N
879	2	1597315916	scorm	directories	0	\N
880	2	1597315916	scorm	location	0	\N
881	2	1597315916	scorm	menubar	0	\N
882	2	1597315916	scorm	toolbar	0	\N
883	2	1597315916	scorm	status	0	\N
884	2	1597315916	scorm	skipview	0	\N
885	2	1597315916	scorm	skipview_adv	1	\N
886	2	1597315916	scorm	hidebrowse	0	\N
887	2	1597315916	scorm	hidebrowse_adv	1	\N
888	2	1597315916	scorm	hidetoc	0	\N
889	2	1597315916	scorm	hidetoc_adv	1	\N
890	2	1597315916	scorm	nav	1	\N
891	2	1597315916	scorm	nav_adv	1	\N
892	2	1597315916	scorm	navpositionleft	-100	\N
893	2	1597315916	scorm	navpositionleft_adv	1	\N
894	2	1597315916	scorm	navpositiontop	-100	\N
895	2	1597315916	scorm	navpositiontop_adv	1	\N
896	2	1597315916	scorm	collapsetocwinsize	767	\N
897	2	1597315916	scorm	collapsetocwinsize_adv	1	\N
898	2	1597315916	scorm	displayattemptstatus	1	\N
899	2	1597315916	scorm	displayattemptstatus_adv		\N
900	2	1597315916	scorm	grademethod	1	\N
901	2	1597315916	scorm	maxgrade	100	\N
902	2	1597315916	scorm	maxattempt	0	\N
903	2	1597315916	scorm	whatgrade	0	\N
904	2	1597315916	scorm	forcecompleted	0	\N
905	2	1597315916	scorm	forcenewattempt	0	\N
906	2	1597315916	scorm	autocommit	0	\N
907	2	1597315916	scorm	masteryoverride	1	\N
908	2	1597315916	scorm	lastattemptlock	0	\N
909	2	1597315916	scorm	auto	0	\N
910	2	1597315916	scorm	updatefreq	0	\N
911	2	1597315916	scorm	scormstandard	0	\N
912	2	1597315916	scorm	allowtypeexternal	0	\N
913	2	1597315916	scorm	allowtypelocalsync	0	\N
914	2	1597315916	scorm	allowtypeexternalaicc	0	\N
915	2	1597315916	scorm	allowaicchacp	0	\N
916	2	1597315916	scorm	aicchacptimeout	30	\N
917	2	1597315916	scorm	aicchacpkeepsessiondata	1	\N
918	2	1597315916	scorm	aiccuserid	1	\N
919	2	1597315916	scorm	forcejavascript	1	\N
920	2	1597315916	scorm	allowapidebug	0	\N
921	2	1597315916	scorm	apidebugmask	.*	\N
922	2	1597315916	scorm	protectpackagedownloads	0	\N
923	2	1597315916	url	framesize	130	\N
924	2	1597315916	url	secretphrase		\N
925	2	1597315916	url	rolesinparams	0	\N
926	2	1597315916	url	displayoptions	0,1,5,6	\N
927	2	1597315916	url	printintro	1	\N
928	2	1597315916	url	display	0	\N
929	2	1597315916	url	popupwidth	620	\N
930	2	1597315916	url	popupheight	450	\N
931	2	1597315916	workshop	grade	80	\N
932	2	1597315916	workshop	gradinggrade	20	\N
933	2	1597315916	workshop	gradedecimals	0	\N
934	2	1597315916	workshop	maxbytes	0	\N
935	2	1597315916	workshop	strategy	accumulative	\N
936	2	1597315916	workshop	examplesmode	0	\N
937	2	1597315916	workshopallocation_random	numofreviews	5	\N
938	2	1597315916	workshopform_numerrors	grade0	No	\N
939	2	1597315916	workshopform_numerrors	grade1	Yes	\N
940	2	1597315916	workshopeval_best	comparison	5	\N
941	2	1597315916	tool_recyclebin	coursebinenable	1	\N
942	2	1597315916	tool_recyclebin	coursebinexpiry	604800	\N
943	2	1597315916	tool_recyclebin	categorybinenable	1	\N
944	2	1597315916	tool_recyclebin	categorybinexpiry	604800	\N
945	2	1597315916	tool_recyclebin	autohide	1	\N
946	2	1597315916	antivirus_clamav	runningmethod	commandline	\N
947	2	1597315916	antivirus_clamav	pathtoclam		\N
948	2	1597315916	antivirus_clamav	pathtounixsocket		\N
949	2	1597315916	antivirus_clamav	tcpsockethost		\N
950	2	1597315916	antivirus_clamav	tcpsocketport	3310	\N
951	2	1597315916	antivirus_clamav	clamfailureonupload	donothing	\N
952	2	1597315916	antivirus_clamav	tries	1	\N
953	2	1597315916	auth_cas	field_map_firstname		\N
954	2	1597315916	auth_cas	field_updatelocal_firstname	oncreate	\N
955	2	1597315916	auth_cas	field_updateremote_firstname	0	\N
956	2	1597315916	auth_cas	field_lock_firstname	unlocked	\N
957	2	1597315916	auth_cas	field_map_lastname		\N
958	2	1597315916	auth_cas	field_updatelocal_lastname	oncreate	\N
959	2	1597315916	auth_cas	field_updateremote_lastname	0	\N
960	2	1597315916	auth_cas	field_lock_lastname	unlocked	\N
961	2	1597315916	auth_cas	field_map_email		\N
962	2	1597315916	auth_cas	field_updatelocal_email	oncreate	\N
963	2	1597315916	auth_cas	field_updateremote_email	0	\N
964	2	1597315916	auth_cas	field_lock_email	unlocked	\N
965	2	1597315916	auth_cas	field_map_city		\N
966	2	1597315917	auth_cas	field_updatelocal_city	oncreate	\N
967	2	1597315917	auth_cas	field_updateremote_city	0	\N
968	2	1597315917	auth_cas	field_lock_city	unlocked	\N
969	2	1597315917	auth_cas	field_map_country		\N
970	2	1597315917	auth_cas	field_updatelocal_country	oncreate	\N
971	2	1597315917	auth_cas	field_updateremote_country	0	\N
972	2	1597315917	auth_cas	field_lock_country	unlocked	\N
973	2	1597315917	auth_cas	field_map_lang		\N
974	2	1597315917	auth_cas	field_updatelocal_lang	oncreate	\N
975	2	1597315917	auth_cas	field_updateremote_lang	0	\N
976	2	1597315917	auth_cas	field_lock_lang	unlocked	\N
977	2	1597315917	auth_cas	field_map_description		\N
978	2	1597315917	auth_cas	field_updatelocal_description	oncreate	\N
979	2	1597315917	auth_cas	field_updateremote_description	0	\N
980	2	1597315917	auth_cas	field_lock_description	unlocked	\N
981	2	1597315917	auth_cas	field_map_url		\N
982	2	1597315917	auth_cas	field_updatelocal_url	oncreate	\N
983	2	1597315917	auth_cas	field_updateremote_url	0	\N
984	2	1597315917	auth_cas	field_lock_url	unlocked	\N
985	2	1597315917	auth_cas	field_map_idnumber		\N
986	2	1597315917	auth_cas	field_updatelocal_idnumber	oncreate	\N
987	2	1597315917	auth_cas	field_updateremote_idnumber	0	\N
988	2	1597315917	auth_cas	field_lock_idnumber	unlocked	\N
989	2	1597315917	auth_cas	field_map_institution		\N
990	2	1597315917	auth_cas	field_updatelocal_institution	oncreate	\N
991	2	1597315917	auth_cas	field_updateremote_institution	0	\N
992	2	1597315917	auth_cas	field_lock_institution	unlocked	\N
993	2	1597315917	auth_cas	field_map_department		\N
994	2	1597315917	auth_cas	field_updatelocal_department	oncreate	\N
995	2	1597315917	auth_cas	field_updateremote_department	0	\N
996	2	1597315917	auth_cas	field_lock_department	unlocked	\N
997	2	1597315917	auth_cas	field_map_phone1		\N
998	2	1597315917	auth_cas	field_updatelocal_phone1	oncreate	\N
999	2	1597315917	auth_cas	field_updateremote_phone1	0	\N
1000	2	1597315917	auth_cas	field_lock_phone1	unlocked	\N
1001	2	1597315917	auth_cas	field_map_phone2		\N
1002	2	1597315917	auth_cas	field_updatelocal_phone2	oncreate	\N
1003	2	1597315917	auth_cas	field_updateremote_phone2	0	\N
1004	2	1597315917	auth_cas	field_lock_phone2	unlocked	\N
1005	2	1597315917	auth_cas	field_map_address		\N
1006	2	1597315917	auth_cas	field_updatelocal_address	oncreate	\N
1007	2	1597315917	auth_cas	field_updateremote_address	0	\N
1008	2	1597315917	auth_cas	field_lock_address	unlocked	\N
1009	2	1597315917	auth_cas	field_map_firstnamephonetic		\N
1010	2	1597315917	auth_cas	field_updatelocal_firstnamephonetic	oncreate	\N
1011	2	1597315917	auth_cas	field_updateremote_firstnamephonetic	0	\N
1012	2	1597315917	auth_cas	field_lock_firstnamephonetic	unlocked	\N
1013	2	1597315917	auth_cas	field_map_lastnamephonetic		\N
1014	2	1597315917	auth_cas	field_updatelocal_lastnamephonetic	oncreate	\N
1015	2	1597315917	auth_cas	field_updateremote_lastnamephonetic	0	\N
1016	2	1597315917	auth_cas	field_lock_lastnamephonetic	unlocked	\N
1017	2	1597315917	auth_cas	field_map_middlename		\N
1018	2	1597315917	auth_cas	field_updatelocal_middlename	oncreate	\N
1019	2	1597315917	auth_cas	field_updateremote_middlename	0	\N
1020	2	1597315917	auth_cas	field_lock_middlename	unlocked	\N
1021	2	1597315917	auth_cas	field_map_alternatename		\N
1022	2	1597315917	auth_cas	field_updatelocal_alternatename	oncreate	\N
1023	2	1597315917	auth_cas	field_updateremote_alternatename	0	\N
1024	2	1597315917	auth_cas	field_lock_alternatename	unlocked	\N
1025	2	1597315917	auth_email	recaptcha	0	\N
1026	2	1597315917	auth_email	field_lock_firstname	unlocked	\N
1027	2	1597315917	auth_email	field_lock_lastname	unlocked	\N
1028	2	1597315917	auth_email	field_lock_email	unlocked	\N
1029	2	1597315917	auth_email	field_lock_city	unlocked	\N
1030	2	1597315917	auth_email	field_lock_country	unlocked	\N
1031	2	1597315917	auth_email	field_lock_lang	unlocked	\N
1032	2	1597315917	auth_email	field_lock_description	unlocked	\N
1033	2	1597315917	auth_email	field_lock_url	unlocked	\N
1034	2	1597315917	auth_email	field_lock_idnumber	unlocked	\N
1035	2	1597315917	auth_email	field_lock_institution	unlocked	\N
1036	2	1597315917	auth_email	field_lock_department	unlocked	\N
1037	2	1597315917	auth_email	field_lock_phone1	unlocked	\N
1038	2	1597315917	auth_email	field_lock_phone2	unlocked	\N
1039	2	1597315917	auth_email	field_lock_address	unlocked	\N
1040	2	1597315917	auth_email	field_lock_firstnamephonetic	unlocked	\N
1041	2	1597315917	auth_email	field_lock_lastnamephonetic	unlocked	\N
1042	2	1597315917	auth_email	field_lock_middlename	unlocked	\N
1043	2	1597315917	auth_email	field_lock_alternatename	unlocked	\N
1044	2	1597315917	auth_db	host	127.0.0.1	\N
1045	2	1597315917	auth_db	type	mysqli	\N
1046	2	1597315917	auth_db	sybasequoting	0	\N
1047	2	1597315917	auth_db	name		\N
1048	2	1597315917	auth_db	user		\N
1049	2	1597315917	auth_db	pass		\N
1051	2	1597315917	auth_db	fielduser		\N
1052	2	1597315917	auth_db	fieldpass		\N
1053	2	1597315917	auth_db	passtype	plaintext	\N
1054	2	1597315917	auth_db	extencoding	utf-8	\N
1055	2	1597315917	auth_db	setupsql		\N
1056	2	1597315917	auth_db	debugauthdb	0	\N
1057	2	1597315917	auth_db	changepasswordurl		\N
1058	2	1597315917	auth_db	removeuser	0	\N
1059	2	1597315917	auth_db	updateusers	0	\N
1060	2	1597315917	auth_db	field_map_firstname		\N
1061	2	1597315917	auth_db	field_updatelocal_firstname	oncreate	\N
1062	2	1597315917	auth_db	field_updateremote_firstname	0	\N
1063	2	1597315917	auth_db	field_lock_firstname	unlocked	\N
1064	2	1597315917	auth_db	field_map_lastname		\N
1065	2	1597315917	auth_db	field_updatelocal_lastname	oncreate	\N
1066	2	1597315917	auth_db	field_updateremote_lastname	0	\N
1067	2	1597315917	auth_db	field_lock_lastname	unlocked	\N
1068	2	1597315917	auth_db	field_map_email		\N
1069	2	1597315917	auth_db	field_updatelocal_email	oncreate	\N
1070	2	1597315917	auth_db	field_updateremote_email	0	\N
1071	2	1597315917	auth_db	field_lock_email	unlocked	\N
1072	2	1597315917	auth_db	field_map_city		\N
1073	2	1597315917	auth_db	field_updatelocal_city	oncreate	\N
1074	2	1597315917	auth_db	field_updateremote_city	0	\N
1075	2	1597315917	auth_db	field_lock_city	unlocked	\N
1076	2	1597315917	auth_db	field_map_country		\N
1077	2	1597315917	auth_db	field_updatelocal_country	oncreate	\N
1078	2	1597315917	auth_db	field_updateremote_country	0	\N
1079	2	1597315917	auth_db	field_lock_country	unlocked	\N
1080	2	1597315917	auth_db	field_map_lang		\N
1081	2	1597315917	auth_db	field_updatelocal_lang	oncreate	\N
1082	2	1597315917	auth_db	field_updateremote_lang	0	\N
1083	2	1597315917	auth_db	field_lock_lang	unlocked	\N
1084	2	1597315917	auth_db	field_map_description		\N
1085	2	1597315917	auth_db	field_updatelocal_description	oncreate	\N
1086	2	1597315917	auth_db	field_updateremote_description	0	\N
1087	2	1597315917	auth_db	field_lock_description	unlocked	\N
1088	2	1597315917	auth_db	field_map_url		\N
1089	2	1597315917	auth_db	field_updatelocal_url	oncreate	\N
1090	2	1597315917	auth_db	field_updateremote_url	0	\N
1091	2	1597315917	auth_db	field_lock_url	unlocked	\N
1092	2	1597315917	auth_db	field_map_idnumber		\N
1093	2	1597315917	auth_db	field_updatelocal_idnumber	oncreate	\N
1094	2	1597315917	auth_db	field_updateremote_idnumber	0	\N
1095	2	1597315917	auth_db	field_lock_idnumber	unlocked	\N
1096	2	1597315917	auth_db	field_map_institution		\N
1097	2	1597315917	auth_db	field_updatelocal_institution	oncreate	\N
1098	2	1597315917	auth_db	field_updateremote_institution	0	\N
1099	2	1597315917	auth_db	field_lock_institution	unlocked	\N
1100	2	1597315917	auth_db	field_map_department		\N
1101	2	1597315917	auth_db	field_updatelocal_department	oncreate	\N
1102	2	1597315917	auth_db	field_updateremote_department	0	\N
1103	2	1597315917	auth_db	field_lock_department	unlocked	\N
1104	2	1597315917	auth_db	field_map_phone1		\N
1105	2	1597315917	auth_db	field_updatelocal_phone1	oncreate	\N
1106	2	1597315917	auth_db	field_updateremote_phone1	0	\N
1107	2	1597315917	auth_db	field_lock_phone1	unlocked	\N
1108	2	1597315917	auth_db	field_map_phone2		\N
1109	2	1597315918	auth_db	field_updatelocal_phone2	oncreate	\N
1110	2	1597315918	auth_db	field_updateremote_phone2	0	\N
1111	2	1597315918	auth_db	field_lock_phone2	unlocked	\N
1112	2	1597315918	auth_db	field_map_address		\N
1113	2	1597315918	auth_db	field_updatelocal_address	oncreate	\N
1114	2	1597315918	auth_db	field_updateremote_address	0	\N
1115	2	1597315918	auth_db	field_lock_address	unlocked	\N
1116	2	1597315918	auth_db	field_map_firstnamephonetic		\N
1117	2	1597315918	auth_db	field_updatelocal_firstnamephonetic	oncreate	\N
1118	2	1597315918	auth_db	field_updateremote_firstnamephonetic	0	\N
1119	2	1597315918	auth_db	field_lock_firstnamephonetic	unlocked	\N
1120	2	1597315918	auth_db	field_map_lastnamephonetic		\N
1121	2	1597315918	auth_db	field_updatelocal_lastnamephonetic	oncreate	\N
1122	2	1597315918	auth_db	field_updateremote_lastnamephonetic	0	\N
1123	2	1597315918	auth_db	field_lock_lastnamephonetic	unlocked	\N
1124	2	1597315918	auth_db	field_map_middlename		\N
1125	2	1597315918	auth_db	field_updatelocal_middlename	oncreate	\N
1126	2	1597315918	auth_db	field_updateremote_middlename	0	\N
1127	2	1597315918	auth_db	field_lock_middlename	unlocked	\N
1128	2	1597315918	auth_db	field_map_alternatename		\N
1129	2	1597315918	auth_db	field_updatelocal_alternatename	oncreate	\N
1130	2	1597315918	auth_db	field_updateremote_alternatename	0	\N
1131	2	1597315918	auth_db	field_lock_alternatename	unlocked	\N
1132	2	1597315918	auth_ldap	field_map_firstname		\N
1133	2	1597315918	auth_ldap	field_updatelocal_firstname	oncreate	\N
1134	2	1597315918	auth_ldap	field_updateremote_firstname	0	\N
1135	2	1597315918	auth_ldap	field_lock_firstname	unlocked	\N
1136	2	1597315918	auth_ldap	field_map_lastname		\N
1137	2	1597315918	auth_ldap	field_updatelocal_lastname	oncreate	\N
1138	2	1597315918	auth_ldap	field_updateremote_lastname	0	\N
1139	2	1597315918	auth_ldap	field_lock_lastname	unlocked	\N
1140	2	1597315918	auth_ldap	field_map_email		\N
1141	2	1597315918	auth_ldap	field_updatelocal_email	oncreate	\N
1142	2	1597315918	auth_ldap	field_updateremote_email	0	\N
1143	2	1597315918	auth_ldap	field_lock_email	unlocked	\N
1144	2	1597315918	auth_ldap	field_map_city		\N
1145	2	1597315918	auth_ldap	field_updatelocal_city	oncreate	\N
1146	2	1597315918	auth_ldap	field_updateremote_city	0	\N
1147	2	1597315918	auth_ldap	field_lock_city	unlocked	\N
1148	2	1597315918	auth_ldap	field_map_country		\N
1149	2	1597315918	auth_ldap	field_updatelocal_country	oncreate	\N
1150	2	1597315918	auth_ldap	field_updateremote_country	0	\N
1151	2	1597315918	auth_ldap	field_lock_country	unlocked	\N
1152	2	1597315918	auth_ldap	field_map_lang		\N
1153	2	1597315918	auth_ldap	field_updatelocal_lang	oncreate	\N
1154	2	1597315918	auth_ldap	field_updateremote_lang	0	\N
1155	2	1597315918	auth_ldap	field_lock_lang	unlocked	\N
1156	2	1597315918	auth_ldap	field_map_description		\N
1157	2	1597315918	auth_ldap	field_updatelocal_description	oncreate	\N
1158	2	1597315918	auth_ldap	field_updateremote_description	0	\N
1159	2	1597315918	auth_ldap	field_lock_description	unlocked	\N
1160	2	1597315918	auth_ldap	field_map_url		\N
1161	2	1597315918	auth_ldap	field_updatelocal_url	oncreate	\N
1162	2	1597315918	auth_ldap	field_updateremote_url	0	\N
1163	2	1597315918	auth_ldap	field_lock_url	unlocked	\N
1164	2	1597315918	auth_ldap	field_map_idnumber		\N
1165	2	1597315918	auth_ldap	field_updatelocal_idnumber	oncreate	\N
1166	2	1597315918	auth_ldap	field_updateremote_idnumber	0	\N
1167	2	1597315918	auth_ldap	field_lock_idnumber	unlocked	\N
1168	2	1597315918	auth_ldap	field_map_institution		\N
1169	2	1597315918	auth_ldap	field_updatelocal_institution	oncreate	\N
1170	2	1597315918	auth_ldap	field_updateremote_institution	0	\N
1171	2	1597315918	auth_ldap	field_lock_institution	unlocked	\N
1172	2	1597315918	auth_ldap	field_map_department		\N
1173	2	1597315918	auth_ldap	field_updatelocal_department	oncreate	\N
1174	2	1597315918	auth_ldap	field_updateremote_department	0	\N
1175	2	1597315918	auth_ldap	field_lock_department	unlocked	\N
1176	2	1597315918	auth_ldap	field_map_phone1		\N
1177	2	1597315918	auth_ldap	field_updatelocal_phone1	oncreate	\N
1178	2	1597315918	auth_ldap	field_updateremote_phone1	0	\N
1179	2	1597315918	auth_ldap	field_lock_phone1	unlocked	\N
1180	2	1597315918	auth_ldap	field_map_phone2		\N
1181	2	1597315918	auth_ldap	field_updatelocal_phone2	oncreate	\N
1182	2	1597315918	auth_ldap	field_updateremote_phone2	0	\N
1183	2	1597315918	auth_ldap	field_lock_phone2	unlocked	\N
1184	2	1597315918	auth_ldap	field_map_address		\N
1185	2	1597315918	auth_ldap	field_updatelocal_address	oncreate	\N
1186	2	1597315918	auth_ldap	field_updateremote_address	0	\N
1187	2	1597315918	auth_ldap	field_lock_address	unlocked	\N
1188	2	1597315918	auth_ldap	field_map_firstnamephonetic		\N
1189	2	1597315918	auth_ldap	field_updatelocal_firstnamephonetic	oncreate	\N
1190	2	1597315918	auth_ldap	field_updateremote_firstnamephonetic	0	\N
1191	2	1597315918	auth_ldap	field_lock_firstnamephonetic	unlocked	\N
1192	2	1597315918	auth_ldap	field_map_lastnamephonetic		\N
1193	2	1597315918	auth_ldap	field_updatelocal_lastnamephonetic	oncreate	\N
1194	2	1597315918	auth_ldap	field_updateremote_lastnamephonetic	0	\N
1195	2	1597315918	auth_ldap	field_lock_lastnamephonetic	unlocked	\N
1196	2	1597315918	auth_ldap	field_map_middlename		\N
1197	2	1597315918	auth_ldap	field_updatelocal_middlename	oncreate	\N
1198	2	1597315918	auth_ldap	field_updateremote_middlename	0	\N
1199	2	1597315918	auth_ldap	field_lock_middlename	unlocked	\N
1200	2	1597315918	auth_ldap	field_map_alternatename		\N
1201	2	1597315918	auth_ldap	field_updatelocal_alternatename	oncreate	\N
1202	2	1597315918	auth_ldap	field_updateremote_alternatename	0	\N
1203	2	1597315918	auth_ldap	field_lock_alternatename	unlocked	\N
1204	2	1597315918	auth_manual	expiration	0	\N
1205	2	1597315918	auth_manual	expirationtime	30	\N
1206	2	1597315918	auth_manual	expiration_warning	0	\N
1207	2	1597315918	auth_manual	field_lock_firstname	unlocked	\N
1208	2	1597315918	auth_manual	field_lock_lastname	unlocked	\N
1209	2	1597315918	auth_manual	field_lock_email	unlocked	\N
1210	2	1597315918	auth_manual	field_lock_city	unlocked	\N
1211	2	1597315918	auth_manual	field_lock_country	unlocked	\N
1212	2	1597315918	auth_manual	field_lock_lang	unlocked	\N
1213	2	1597315918	auth_manual	field_lock_description	unlocked	\N
1214	2	1597315918	auth_manual	field_lock_url	unlocked	\N
1215	2	1597315918	auth_manual	field_lock_idnumber	unlocked	\N
1216	2	1597315918	auth_manual	field_lock_institution	unlocked	\N
1217	2	1597315918	auth_manual	field_lock_department	unlocked	\N
1218	2	1597315918	auth_manual	field_lock_phone1	unlocked	\N
1219	2	1597315918	auth_manual	field_lock_phone2	unlocked	\N
1220	2	1597315918	auth_manual	field_lock_address	unlocked	\N
1221	2	1597315918	auth_manual	field_lock_firstnamephonetic	unlocked	\N
1222	2	1597315918	auth_manual	field_lock_lastnamephonetic	unlocked	\N
1223	2	1597315918	auth_manual	field_lock_middlename	unlocked	\N
1224	2	1597315918	auth_manual	field_lock_alternatename	unlocked	\N
1225	2	1597315918	auth_mnet	rpc_negotiation_timeout	30	\N
1226	2	1597315918	auth_none	field_lock_firstname	unlocked	\N
1227	2	1597315918	auth_none	field_lock_lastname	unlocked	\N
1228	2	1597315918	auth_none	field_lock_email	unlocked	\N
1229	2	1597315918	auth_none	field_lock_city	unlocked	\N
1230	2	1597315918	auth_none	field_lock_country	unlocked	\N
1231	2	1597315918	auth_none	field_lock_lang	unlocked	\N
1232	2	1597315918	auth_none	field_lock_description	unlocked	\N
1233	2	1597315918	auth_none	field_lock_url	unlocked	\N
1234	2	1597315918	auth_none	field_lock_idnumber	unlocked	\N
1235	2	1597315918	auth_none	field_lock_institution	unlocked	\N
1236	2	1597315918	auth_none	field_lock_department	unlocked	\N
1237	2	1597315918	auth_none	field_lock_phone1	unlocked	\N
1238	2	1597315918	auth_none	field_lock_phone2	unlocked	\N
1239	2	1597315918	auth_none	field_lock_address	unlocked	\N
1240	2	1597315918	auth_none	field_lock_firstnamephonetic	unlocked	\N
1241	2	1597315918	auth_none	field_lock_lastnamephonetic	unlocked	\N
1242	2	1597315918	auth_none	field_lock_middlename	unlocked	\N
1243	2	1597315918	auth_none	field_lock_alternatename	unlocked	\N
1244	2	1597315918	auth_oauth2	field_lock_firstname	unlocked	\N
1245	2	1597315918	auth_oauth2	field_lock_lastname	unlocked	\N
1246	2	1597315918	auth_oauth2	field_lock_email	unlocked	\N
1247	2	1597315919	auth_oauth2	field_lock_city	unlocked	\N
1248	2	1597315919	auth_oauth2	field_lock_country	unlocked	\N
1249	2	1597315919	auth_oauth2	field_lock_lang	unlocked	\N
1250	2	1597315919	auth_oauth2	field_lock_description	unlocked	\N
1251	2	1597315919	auth_oauth2	field_lock_url	unlocked	\N
1252	2	1597315919	auth_oauth2	field_lock_idnumber	unlocked	\N
1253	2	1597315919	auth_oauth2	field_lock_institution	unlocked	\N
1254	2	1597315919	auth_oauth2	field_lock_department	unlocked	\N
1255	2	1597315919	auth_oauth2	field_lock_phone1	unlocked	\N
1256	2	1597315919	auth_oauth2	field_lock_phone2	unlocked	\N
1257	2	1597315919	auth_oauth2	field_lock_address	unlocked	\N
1258	2	1597315919	auth_oauth2	field_lock_firstnamephonetic	unlocked	\N
1259	2	1597315919	auth_oauth2	field_lock_lastnamephonetic	unlocked	\N
1260	2	1597315919	auth_oauth2	field_lock_middlename	unlocked	\N
1261	2	1597315919	auth_oauth2	field_lock_alternatename	unlocked	\N
1262	2	1597315919	auth_shibboleth	user_attribute		\N
1263	2	1597315919	auth_shibboleth	convert_data		\N
1264	2	1597315919	auth_shibboleth	alt_login	off	\N
1265	2	1597315919	auth_shibboleth	organization_selection	urn:mace:organization1:providerID, Example Organization 1\n        https://another.idp-id.com/shibboleth, Other Example Organization, /Shibboleth.sso/DS/SWITCHaai\n        urn:mace:organization2:providerID, Example Organization 2, /Shibboleth.sso/WAYF/SWITCHaai	\N
1266	2	1597315919	auth_shibboleth	logout_handler		\N
1267	2	1597315919	auth_shibboleth	logout_return_url		\N
1268	2	1597315919	auth_shibboleth	login_name	Shibboleth Login	\N
1269	2	1597315919	auth_shibboleth	auth_logo		\N
1270	2	1597315919	auth_shibboleth	auth_instructions	Use the <a href="https://arrupe.ac.zw/acis/lms/auth/shibboleth/index.php">Shibboleth login</a> to get access via Shibboleth, if your institution supports it. Otherwise, use the normal login form shown here.	\N
1271	2	1597315919	auth_shibboleth	changepasswordurl		\N
1272	2	1597315919	auth_shibboleth	field_map_firstname		\N
1273	2	1597315919	auth_shibboleth	field_updatelocal_firstname	oncreate	\N
1274	2	1597315919	auth_shibboleth	field_lock_firstname	unlocked	\N
1275	2	1597315919	auth_shibboleth	field_map_lastname		\N
1276	2	1597315919	auth_shibboleth	field_updatelocal_lastname	oncreate	\N
1277	2	1597315919	auth_shibboleth	field_lock_lastname	unlocked	\N
1278	2	1597315919	auth_shibboleth	field_map_email		\N
1279	2	1597315919	auth_shibboleth	field_updatelocal_email	oncreate	\N
1280	2	1597315919	auth_shibboleth	field_lock_email	unlocked	\N
1281	2	1597315919	auth_shibboleth	field_map_city		\N
1282	2	1597315919	auth_shibboleth	field_updatelocal_city	oncreate	\N
1283	2	1597315919	auth_shibboleth	field_lock_city	unlocked	\N
1284	2	1597315919	auth_shibboleth	field_map_country		\N
1285	2	1597315919	auth_shibboleth	field_updatelocal_country	oncreate	\N
1286	2	1597315919	auth_shibboleth	field_lock_country	unlocked	\N
1287	2	1597315919	auth_shibboleth	field_map_lang		\N
1288	2	1597315919	auth_shibboleth	field_updatelocal_lang	oncreate	\N
1289	2	1597315919	auth_shibboleth	field_lock_lang	unlocked	\N
1290	2	1597315919	auth_shibboleth	field_map_description		\N
1291	2	1597315919	auth_shibboleth	field_updatelocal_description	oncreate	\N
1292	2	1597315919	auth_shibboleth	field_lock_description	unlocked	\N
1293	2	1597315919	auth_shibboleth	field_map_url		\N
1294	2	1597315919	auth_shibboleth	field_updatelocal_url	oncreate	\N
1295	2	1597315919	auth_shibboleth	field_lock_url	unlocked	\N
1296	2	1597315919	auth_shibboleth	field_map_idnumber		\N
1297	2	1597315919	auth_shibboleth	field_updatelocal_idnumber	oncreate	\N
1298	2	1597315919	auth_shibboleth	field_lock_idnumber	unlocked	\N
1299	2	1597315919	auth_shibboleth	field_map_institution		\N
1300	2	1597315919	auth_shibboleth	field_updatelocal_institution	oncreate	\N
1301	2	1597315919	auth_shibboleth	field_lock_institution	unlocked	\N
1302	2	1597315919	auth_shibboleth	field_map_department		\N
1303	2	1597315919	auth_shibboleth	field_updatelocal_department	oncreate	\N
1304	2	1597315919	auth_shibboleth	field_lock_department	unlocked	\N
1305	2	1597315919	auth_shibboleth	field_map_phone1		\N
1306	2	1597315919	auth_shibboleth	field_updatelocal_phone1	oncreate	\N
1307	2	1597315919	auth_shibboleth	field_lock_phone1	unlocked	\N
1308	2	1597315919	auth_shibboleth	field_map_phone2		\N
1309	2	1597315919	auth_shibboleth	field_updatelocal_phone2	oncreate	\N
1310	2	1597315919	auth_shibboleth	field_lock_phone2	unlocked	\N
1311	2	1597315919	auth_shibboleth	field_map_address		\N
1312	2	1597315919	auth_shibboleth	field_updatelocal_address	oncreate	\N
1313	2	1597315919	auth_shibboleth	field_lock_address	unlocked	\N
1314	2	1597315919	auth_shibboleth	field_map_firstnamephonetic		\N
1315	2	1597315919	auth_shibboleth	field_updatelocal_firstnamephonetic	oncreate	\N
1316	2	1597315919	auth_shibboleth	field_lock_firstnamephonetic	unlocked	\N
1317	2	1597315919	auth_shibboleth	field_map_lastnamephonetic		\N
1318	2	1597315919	auth_shibboleth	field_updatelocal_lastnamephonetic	oncreate	\N
1319	2	1597315919	auth_shibboleth	field_lock_lastnamephonetic	unlocked	\N
1320	2	1597315919	auth_shibboleth	field_map_middlename		\N
1321	2	1597315919	auth_shibboleth	field_updatelocal_middlename	oncreate	\N
1322	2	1597315919	auth_shibboleth	field_lock_middlename	unlocked	\N
1323	2	1597315919	auth_shibboleth	field_map_alternatename		\N
1324	2	1597315919	auth_shibboleth	field_updatelocal_alternatename	oncreate	\N
1325	2	1597315919	auth_shibboleth	field_lock_alternatename	unlocked	\N
1326	2	1597315919	block_activity_results	config_showbest	3	\N
1327	2	1597315919	block_activity_results	config_showbest_locked		\N
1328	2	1597315919	block_activity_results	config_showworst	0	\N
1329	2	1597315919	block_activity_results	config_showworst_locked		\N
1330	2	1597315919	block_activity_results	config_usegroups	0	\N
1331	2	1597315919	block_activity_results	config_usegroups_locked		\N
1332	2	1597315919	block_activity_results	config_nameformat	1	\N
1333	2	1597315919	block_activity_results	config_nameformat_locked		\N
1334	2	1597315919	block_activity_results	config_gradeformat	1	\N
1335	2	1597315919	block_activity_results	config_gradeformat_locked		\N
1336	2	1597315919	block_activity_results	config_decimalpoints	2	\N
1337	2	1597315919	block_activity_results	config_decimalpoints_locked		\N
1338	2	1597315919	block_myoverview	displaycategories	1	\N
1339	2	1597315919	block_myoverview	layouts	card,list,summary	\N
1340	2	1597315919	block_myoverview	displaygroupingallincludinghidden	0	\N
1341	2	1597315919	block_myoverview	displaygroupingall	1	\N
1342	2	1597315919	block_myoverview	displaygroupinginprogress	1	\N
1343	2	1597315919	block_myoverview	displaygroupingpast	1	\N
1344	2	1597315919	block_myoverview	displaygroupingfuture	1	\N
1345	2	1597315919	block_myoverview	displaygroupingcustomfield	0	\N
1346	2	1597315919	block_myoverview	customfiltergrouping		\N
1347	2	1597315919	block_myoverview	displaygroupingfavourites	1	\N
1348	2	1597315919	block_myoverview	displaygroupinghidden	1	\N
1349	2	1597315919	\N	block_course_list_adminview	all	\N
1350	2	1597315919	\N	block_course_list_hideallcourseslink	0	\N
1351	2	1597315919	\N	block_html_allowcssclasses	0	\N
1352	2	1597315919	\N	block_online_users_timetosee	5	\N
1353	2	1597315919	\N	block_online_users_onlinestatushiding	1	\N
1354	2	1597315919	block_recentlyaccessedcourses	displaycategories	1	\N
1355	2	1597315919	\N	block_rss_client_num_entries	5	\N
1356	2	1597315920	\N	block_rss_client_timeout	30	\N
1357	2	1597315920	block_section_links	numsections1	22	\N
1358	2	1597315920	block_section_links	incby1	2	\N
1359	2	1597315920	block_section_links	numsections2	40	\N
1360	2	1597315920	block_section_links	incby2	5	\N
1361	2	1597315920	block_starredcourses	displaycategories	1	\N
1362	2	1597315920	block_tag_youtube	apikey		\N
1363	2	1597315920	format_singleactivity	activitytype	forum	\N
1364	2	1597315920	fileconverter_googledrive	issuerid		\N
1365	2	1597315920	\N	pathtounoconv	/usr/bin/unoconv	\N
1366	2	1597315920	enrol_cohort	roleid	5	\N
1367	2	1597315920	enrol_cohort	unenrolaction	0	\N
1368	2	1597315920	enrol_meta	nosyncroleids		\N
1369	2	1597315920	enrol_meta	syncall	1	\N
1370	2	1597315920	enrol_meta	unenrolaction	3	\N
1371	2	1597315920	enrol_meta	coursesort	sortorder	\N
1372	2	1597315920	enrol_database	dbtype		\N
1373	2	1597315920	enrol_database	dbhost	localhost	\N
1374	2	1597315920	enrol_database	dbuser		\N
1375	2	1597315920	enrol_database	dbpass		\N
1376	2	1597315920	enrol_database	dbname		\N
1377	2	1597315920	enrol_database	dbencoding	utf-8	\N
1378	2	1597315920	enrol_database	dbsetupsql		\N
1379	2	1597315920	enrol_database	dbsybasequoting	0	\N
1380	2	1597315920	enrol_database	debugdb	0	\N
1381	2	1597315920	enrol_database	localcoursefield	idnumber	\N
1382	2	1597315920	enrol_database	localuserfield	idnumber	\N
1383	2	1597315920	enrol_database	localrolefield	shortname	\N
1384	2	1597315920	enrol_database	localcategoryfield	id	\N
1385	2	1597315920	enrol_database	remoteenroltable		\N
1386	2	1597315920	enrol_database	remotecoursefield		\N
1387	2	1597315920	enrol_database	remoteuserfield		\N
1388	2	1597315920	enrol_database	remoterolefield		\N
1389	2	1597315920	enrol_database	remoteotheruserfield		\N
1390	2	1597315920	enrol_database	defaultrole	5	\N
1391	2	1597315920	enrol_database	ignorehiddencourses	0	\N
1392	2	1597315920	enrol_database	unenrolaction	0	\N
1393	2	1597315920	enrol_database	newcoursetable		\N
1394	2	1597315920	enrol_database	newcoursefullname	fullname	\N
1395	2	1597315920	enrol_database	newcourseshortname	shortname	\N
1396	2	1597315920	enrol_database	newcourseidnumber	idnumber	\N
1397	2	1597315920	enrol_database	newcoursecategory		\N
1398	2	1597315920	enrol_database	defaultcategory	1	\N
1399	2	1597315920	enrol_database	templatecourse		\N
1400	2	1597315920	enrol_flatfile	location		\N
1401	2	1597315920	enrol_flatfile	encoding	UTF-8	\N
1402	2	1597315920	enrol_flatfile	mailstudents	0	\N
1403	2	1597315920	enrol_flatfile	mailteachers	0	\N
1404	2	1597315920	enrol_flatfile	mailadmins	0	\N
1405	2	1597315920	enrol_flatfile	unenrolaction	3	\N
1406	2	1597315920	enrol_flatfile	expiredaction	3	\N
1407	2	1597315920	enrol_guest	requirepassword	0	\N
1408	2	1597315920	enrol_guest	usepasswordpolicy	0	\N
1409	2	1597315920	enrol_guest	showhint	0	\N
1410	2	1597315920	enrol_guest	defaultenrol	1	\N
1411	2	1597315920	enrol_guest	status	1	\N
1412	2	1597315920	enrol_guest	status_adv		\N
1413	2	1597315920	enrol_imsenterprise	imsfilelocation		\N
1414	2	1597315920	enrol_imsenterprise	logtolocation		\N
1415	2	1597315920	enrol_imsenterprise	mailadmins	0	\N
1416	2	1597315920	enrol_imsenterprise	createnewusers	0	\N
1417	2	1597315920	enrol_imsenterprise	imsupdateusers	0	\N
1418	2	1597315920	enrol_imsenterprise	imsdeleteusers	0	\N
1419	2	1597315920	enrol_imsenterprise	fixcaseusernames	0	\N
1420	2	1597315920	enrol_imsenterprise	fixcasepersonalnames	0	\N
1421	2	1597315920	enrol_imsenterprise	imssourcedidfallback	0	\N
1422	2	1597315920	enrol_imsenterprise	imsrolemap01	5	\N
1423	2	1597315920	enrol_imsenterprise	imsrolemap02	3	\N
1424	2	1597315920	enrol_imsenterprise	imsrolemap03	3	\N
1425	2	1597315920	enrol_imsenterprise	imsrolemap04	5	\N
1426	2	1597315920	enrol_imsenterprise	imsrolemap05	0	\N
1427	2	1597315920	enrol_imsenterprise	imsrolemap06	4	\N
1428	2	1597315920	enrol_imsenterprise	imsrolemap07	0	\N
1429	2	1597315920	enrol_imsenterprise	imsrolemap08	4	\N
1430	2	1597315920	enrol_imsenterprise	truncatecoursecodes	0	\N
1431	2	1597315920	enrol_imsenterprise	createnewcourses	0	\N
1432	2	1597315920	enrol_imsenterprise	updatecourses	0	\N
1433	2	1597315920	enrol_imsenterprise	createnewcategories	0	\N
1434	2	1597315920	enrol_imsenterprise	nestedcategories	0	\N
1435	2	1597315920	enrol_imsenterprise	categoryidnumber	0	\N
1436	2	1597315920	enrol_imsenterprise	categoryseparator		\N
1437	2	1597315920	enrol_imsenterprise	imsunenrol	0	\N
1438	2	1597315920	enrol_imsenterprise	imscoursemapshortname	coursecode	\N
1439	2	1597315920	enrol_imsenterprise	imscoursemapfullname	short	\N
1440	2	1597315920	enrol_imsenterprise	imscoursemapsummary	ignore	\N
1441	2	1597315920	enrol_imsenterprise	imsrestricttarget		\N
1442	2	1597315920	enrol_imsenterprise	imscapitafix	0	\N
1443	2	1597315920	enrol_manual	expiredaction	1	\N
1444	2	1597315920	enrol_manual	expirynotifyhour	6	\N
1445	2	1597315920	enrol_manual	defaultenrol	1	\N
1446	2	1597315920	enrol_manual	status	0	\N
1447	2	1597315920	enrol_manual	roleid	5	\N
1448	2	1597315920	enrol_manual	enrolstart	4	\N
1449	2	1597315920	enrol_manual	enrolperiod	0	\N
1450	2	1597315920	enrol_manual	expirynotify	0	\N
1451	2	1597315920	enrol_manual	expirythreshold	86400	\N
1452	2	1597315920	enrol_mnet	roleid	5	\N
1453	2	1597315920	enrol_mnet	roleid_adv	1	\N
1454	2	1597315920	enrol_paypal	paypalbusiness		\N
1455	2	1597315920	enrol_paypal	mailstudents	0	\N
1456	2	1597315920	enrol_paypal	mailteachers	0	\N
1457	2	1597315920	enrol_paypal	mailadmins	0	\N
1458	2	1597315920	enrol_paypal	expiredaction	3	\N
1459	2	1597315920	enrol_paypal	status	1	\N
1460	2	1597315920	enrol_paypal	cost	0	\N
1461	2	1597315920	enrol_paypal	currency	USD	\N
1462	2	1597315920	enrol_paypal	roleid	5	\N
1463	2	1597315920	enrol_paypal	enrolperiod	0	\N
1464	2	1597315920	enrol_lti	emaildisplay	2	\N
1465	2	1597315920	enrol_lti	city		\N
1466	2	1597315920	enrol_lti	country		\N
1467	2	1597315920	enrol_lti	timezone	99	\N
1468	2	1597315920	enrol_lti	lang	en	\N
1469	2	1597315920	enrol_lti	institution		\N
1470	2	1597315920	enrol_self	requirepassword	0	\N
1471	2	1597315920	enrol_self	usepasswordpolicy	0	\N
1472	2	1597315920	enrol_self	showhint	0	\N
1473	2	1597315920	enrol_self	expiredaction	1	\N
1474	2	1597315920	enrol_self	expirynotifyhour	6	\N
1475	2	1597315920	enrol_self	defaultenrol	1	\N
1476	2	1597315920	enrol_self	status	1	\N
1477	2	1597315920	enrol_self	newenrols	1	\N
1478	2	1597315920	enrol_self	groupkey	0	\N
1479	2	1597315920	enrol_self	roleid	5	\N
1480	2	1597315920	enrol_self	enrolperiod	0	\N
1481	2	1597315920	enrol_self	expirynotify	0	\N
1482	2	1597315920	enrol_self	expirythreshold	86400	\N
1483	2	1597315920	enrol_self	longtimenosee	0	\N
1484	2	1597315920	enrol_self	maxenrolled	0	\N
1485	2	1597315920	enrol_self	sendcoursewelcomemessage	1	\N
1486	2	1597315920	filter_urltolink	formats	1,4,0	\N
1487	2	1597315920	filter_urltolink	embedimages	1	\N
1488	2	1597315920	filter_emoticon	formats	1,4,0	\N
1489	2	1597315920	filter_displayh5p	allowedsources		\N
1490	2	1597315920	filter_mathjaxloader	httpsurl	https://cdn.jsdelivr.net/npm/mathjax@2.7.8/MathJax.js	\N
1491	2	1597315920	filter_mathjaxloader	texfiltercompatibility	0	\N
1492	2	1597315920	filter_mathjaxloader	mathjaxconfig	\nMathJax.Hub.Config({\n    config: ["Accessible.js", "Safe.js"],\n    errorSettings: { message: ["!"] },\n    skipStartupTypeset: true,\n    messageStyle: "none"\n});\n	\N
1493	2	1597315920	filter_mathjaxloader	additionaldelimiters		\N
1494	2	1597315920	\N	filter_multilang_force_old	0	\N
1495	2	1597315920	filter_tex	latexpreamble	\\usepackage[latin1]{inputenc}\n\\usepackage{amsmath}\n\\usepackage{amsfonts}\n\\RequirePackage{amsmath,amssymb,latexsym}\n	\N
1496	2	1597315920	filter_tex	latexbackground	#FFFFFF	\N
1497	2	1597315920	filter_tex	density	120	\N
1498	2	1597315920	filter_tex	pathlatex	/usr/bin/latex	\N
1499	2	1597315920	filter_tex	pathdvips	/usr/bin/dvips	\N
1500	2	1597315920	filter_tex	pathconvert	/usr/bin/convert	\N
1501	2	1597315920	filter_tex	pathdvisvgm	/usr/bin/dvisvgm	\N
1502	2	1597315920	filter_tex	pathmimetex		\N
1503	2	1597315920	filter_tex	convertformat	gif	\N
1504	2	1597315920	\N	filter_censor_badwords		\N
1505	2	1597315920	logstore_database	dbdriver		\N
1506	2	1597315920	logstore_database	dbhost		\N
1507	2	1597315920	logstore_database	dbuser		\N
1508	2	1597315920	logstore_database	dbpass		\N
1509	2	1597315920	logstore_database	dbname		\N
1510	2	1597315920	logstore_database	dbtable		\N
1511	2	1597315920	logstore_database	dbpersist	0	\N
1512	2	1597315920	logstore_database	dbsocket		\N
1513	2	1597315920	logstore_database	dbport		\N
1514	2	1597315920	logstore_database	dbschema		\N
1515	2	1597315921	logstore_database	dbcollation		\N
1516	2	1597315921	logstore_database	dbhandlesoptions	0	\N
1517	2	1597315921	logstore_database	buffersize	50	\N
1518	2	1597315921	logstore_database	jsonformat	1	\N
1519	2	1597315921	logstore_database	logguests	0	\N
1520	2	1597315921	logstore_database	includelevels	1,2,0	\N
1521	2	1597315921	logstore_database	includeactions	c,r,u,d	\N
1522	2	1597315921	logstore_legacy	loglegacy	0	\N
1523	2	1597315921	\N	logguests	1	\N
1524	2	1597315921	\N	loglifetime	0	\N
1525	2	1597315921	logstore_standard	logguests	1	\N
1526	2	1597315921	logstore_standard	jsonformat	1	\N
1527	2	1597315921	logstore_standard	loglifetime	0	\N
1528	2	1597315921	logstore_standard	buffersize	50	\N
1529	2	1597315921	mlbackend_python	useserver	0	\N
1530	2	1597315921	mlbackend_python	host		\N
1531	2	1597315921	mlbackend_python	port	0	\N
1532	2	1597315921	mlbackend_python	secure	0	\N
1533	2	1597315921	mlbackend_python	username	default	\N
1534	2	1597315921	mlbackend_python	password		\N
1535	2	1597315921	media_videojs	videoextensions	html_video,media_source,.f4v,.flv	\N
1536	2	1597315921	media_videojs	audioextensions	html_audio	\N
1537	2	1597315921	media_videojs	rtmp	0	\N
1538	2	1597315921	media_videojs	useflash	0	\N
1539	2	1597315921	media_videojs	youtube	1	\N
1540	2	1597315921	media_videojs	videocssclass	video-js	\N
1541	2	1597315921	media_videojs	audiocssclass	video-js	\N
1542	2	1597315921	media_videojs	limitsize	1	\N
1543	2	1597315921	qtype_multichoice	answerhowmany	1	\N
1544	2	1597315921	qtype_multichoice	shuffleanswers	1	\N
1545	2	1597315921	qtype_multichoice	answernumbering	abc	\N
1546	2	1597315921	editor_atto	toolbar	collapse = collapse\nstyle1 = title, bold, italic\nlist = unorderedlist, orderedlist, indent\nlinks = link\nfiles = emojipicker, image, media, recordrtc, managefiles, h5p\nstyle2 = underline, strike, subscript, superscript\nalign = align\ninsert = equation, charmap, table, clear\nundo = undo\naccessibility = accessibilitychecker, accessibilityhelper\nother = html	\N
1547	2	1597315921	editor_atto	autosavefrequency	60	\N
1548	2	1597315921	atto_collapse	showgroups	5	\N
1549	2	1597315921	atto_equation	librarygroup1	\n\\cdot\n\\times\n\\ast\n\\div\n\\diamond\n\\pm\n\\mp\n\\oplus\n\\ominus\n\\otimes\n\\oslash\n\\odot\n\\circ\n\\bullet\n\\asymp\n\\equiv\n\\subseteq\n\\supseteq\n\\leq\n\\geq\n\\preceq\n\\succeq\n\\sim\n\\simeq\n\\approx\n\\subset\n\\supset\n\\ll\n\\gg\n\\prec\n\\succ\n\\infty\n\\in\n\\ni\n\\forall\n\\exists\n\\neq\n	\N
1550	2	1597315921	atto_equation	librarygroup2	\n\\leftarrow\n\\rightarrow\n\\uparrow\n\\downarrow\n\\leftrightarrow\n\\nearrow\n\\searrow\n\\swarrow\n\\nwarrow\n\\Leftarrow\n\\Rightarrow\n\\Uparrow\n\\Downarrow\n\\Leftrightarrow\n	\N
1551	2	1597315921	atto_equation	librarygroup3	\n\\alpha\n\\beta\n\\gamma\n\\delta\n\\epsilon\n\\zeta\n\\eta\n\\theta\n\\iota\n\\kappa\n\\lambda\n\\mu\n\\nu\n\\xi\n\\pi\n\\rho\n\\sigma\n\\tau\n\\upsilon\n\\phi\n\\chi\n\\psi\n\\omega\n\\Gamma\n\\Delta\n\\Theta\n\\Lambda\n\\Xi\n\\Pi\n\\Sigma\n\\Upsilon\n\\Phi\n\\Psi\n\\Omega\n	\N
1552	2	1597315921	atto_equation	librarygroup4	\n\\sum{a,b}\n\\sqrt[a]{b+c}\n\\int_{a}^{b}{c}\n\\iint_{a}^{b}{c}\n\\iiint_{a}^{b}{c}\n\\oint{a}\n(a)\n[a]\n\\lbrace{a}\\rbrace\n\\left| \\begin{matrix} a_1 & a_2 \\ a_3 & a_4 \\end{matrix} \\right|\n\\frac{a}{b+c}\n\\vec{a}\n\\binom {a} {b}\n{a \\brack b}\n{a \\brace b}\n	\N
1553	2	1597315921	atto_recordrtc	allowedtypes	both	\N
1554	2	1597315921	atto_recordrtc	audiobitrate	128000	\N
1555	2	1597315921	atto_recordrtc	videobitrate	2500000	\N
1556	2	1597315921	atto_recordrtc	timelimit	120	\N
1557	2	1597315921	atto_table	allowborders	0	\N
1558	2	1597315921	atto_table	allowbackgroundcolour	0	\N
1559	2	1597315921	atto_table	allowwidth	0	\N
1560	2	1597315921	editor_tinymce	customtoolbar	wrap,formatselect,wrap,bold,italic,wrap,bullist,numlist,wrap,link,unlink,wrap,image\n\nundo,redo,wrap,underline,strikethrough,sub,sup,wrap,justifyleft,justifycenter,justifyright,wrap,outdent,indent,wrap,forecolor,backcolor,wrap,ltr,rtl\n\nfontselect,fontsizeselect,wrap,code,search,replace,wrap,nonbreaking,charmap,table,wrap,cleanup,removeformat,pastetext,pasteword,wrap,fullscreen	\N
1561	2	1597315921	editor_tinymce	fontselectlist	Trebuchet=Trebuchet MS,Verdana,Arial,Helvetica,sans-serif;Arial=arial,helvetica,sans-serif;Courier New=courier new,courier,monospace;Georgia=georgia,times new roman,times,serif;Tahoma=tahoma,arial,helvetica,sans-serif;Times New Roman=times new roman,times,serif;Verdana=verdana,arial,helvetica,sans-serif;Impact=impact;Wingdings=wingdings	\N
1562	2	1597315921	editor_tinymce	customconfig		\N
1563	2	1597315921	tinymce_moodleemoticon	requireemoticon	1	\N
1564	2	1597315921	tinymce_spellchecker	spellengine		\N
1565	2	1597315921	tinymce_spellchecker	spelllanguagelist	+English=en,Danish=da,Dutch=nl,Finnish=fi,French=fr,German=de,Italian=it,Polish=pl,Portuguese=pt,Spanish=es,Swedish=sv	\N
1566	2	1597315921	\N	profileroles	5,4,3	\N
1567	2	1597315921	\N	coursecontact	3	\N
1568	2	1597315921	\N	frontpage	6	\N
1569	2	1597315921	\N	frontpageloggedin	6	\N
1570	2	1597315921	\N	maxcategorydepth	2	\N
1571	2	1597315921	\N	frontpagecourselimit	200	\N
1572	2	1597315921	\N	commentsperpage	15	\N
1573	2	1597315921	\N	defaultfrontpageroleid	8	\N
1574	2	1597315921	\N	messageinbound_enabled	0	\N
1575	2	1597315921	\N	messageinbound_mailbox		\N
1576	2	1597315921	\N	messageinbound_domain		\N
1577	2	1597315921	\N	messageinbound_host		\N
1578	2	1597315921	\N	messageinbound_hostssl	ssl	\N
1579	2	1597315921	\N	messageinbound_hostuser		\N
1580	2	1597315921	\N	messageinbound_hostpass		\N
1581	2	1597315921	\N	enablemobilewebservice	1	\N
1582	2	1597315921	tool_mobile	apppolicy		\N
1583	2	1597315921	tool_mobile	typeoflogin	1	\N
1584	2	1597315921	tool_mobile	qrcodetype	2	\N
1585	2	1597315921	tool_mobile	forcedurlscheme	moodlemobile	\N
1586	2	1597315921	tool_mobile	minimumversion		\N
1587	2	1597315921	\N	mobilecssurl		\N
1588	2	1597315921	tool_mobile	enablesmartappbanners	0	\N
1589	2	1597315921	tool_mobile	iosappid	633359593	\N
1590	2	1597315921	tool_mobile	androidappid	com.moodle.moodlemobile	\N
1591	2	1597315921	tool_mobile	setuplink	https://download.moodle.org/mobile	\N
1592	2	1597315921	tool_mobile	forcelogout	0	\N
1593	2	1597315921	tool_mobile	disabledfeatures		\N
1594	2	1597315921	tool_mobile	custommenuitems		\N
1595	2	1597315921	tool_mobile	customlangstrings		\N
1596	2	1597315921	tool_moodlenet	enablemoodlenet	0	\N
1597	2	1597315921	tool_moodlenet	defaultmoodlenetname	MoodleNet Central	\N
1598	2	1597315921	tool_moodlenet	defaultmoodlenet	https://moodle.net	\N
1599	2	1597315946	\N	timezone	Europe/London	\N
1600	2	1597315946	\N	registerauth		\N
\.


--
-- Data for Name: mdl_config_plugins; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_config_plugins (id, plugin, name, value) FROM stdin;
1	question	multichoice_sortorder	1
2	question	truefalse_sortorder	2
3	question	match_sortorder	3
4	question	shortanswer_sortorder	4
5	question	numerical_sortorder	5
6	question	essay_sortorder	6
7	moodlecourse	visible	1
8	moodlecourse	format	topics
9	moodlecourse	maxsections	52
10	moodlecourse	numsections	4
11	moodlecourse	hiddensections	0
12	moodlecourse	coursedisplay	0
13	moodlecourse	courseenddateenabled	1
14	moodlecourse	courseduration	31536000
15	moodlecourse	lang	
16	moodlecourse	newsitems	5
17	moodlecourse	showgrades	1
18	moodlecourse	showreports	0
19	moodlecourse	maxbytes	0
20	moodlecourse	enablecompletion	1
21	moodlecourse	groupmode	0
22	moodlecourse	groupmodeforce	0
23	backup	loglifetime	30
24	backup	backup_general_users	1
25	backup	backup_general_users_locked	
26	backup	backup_general_anonymize	0
27	backup	backup_general_anonymize_locked	
28	backup	backup_general_role_assignments	1
29	backup	backup_general_role_assignments_locked	
30	backup	backup_general_activities	1
31	backup	backup_general_activities_locked	
32	backup	backup_general_blocks	1
33	backup	backup_general_blocks_locked	
34	backup	backup_general_files	1
35	backup	backup_general_files_locked	
36	backup	backup_general_filters	1
37	backup	backup_general_filters_locked	
38	backup	backup_general_comments	1
39	backup	backup_general_comments_locked	
40	backup	backup_general_badges	1
41	backup	backup_general_badges_locked	
42	backup	backup_general_calendarevents	1
43	backup	backup_general_calendarevents_locked	
44	backup	backup_general_userscompletion	1
45	backup	backup_general_userscompletion_locked	
46	backup	backup_general_logs	0
47	backup	backup_general_logs_locked	
48	backup	backup_general_histories	0
49	backup	backup_general_histories_locked	
50	backup	backup_general_questionbank	1
51	backup	backup_general_questionbank_locked	
52	backup	backup_general_groups	1
53	backup	backup_general_groups_locked	
54	backup	backup_general_competencies	1
55	backup	backup_general_competencies_locked	
56	backup	backup_general_contentbankcontent	1
57	backup	backup_general_contentbankcontent_locked	
58	backup	import_general_maxresults	10
59	backup	import_general_duplicate_admin_allowed	0
60	backup	backup_import_activities	1
61	backup	backup_import_activities_locked	
62	backup	backup_import_blocks	1
63	backup	backup_import_blocks_locked	
64	backup	backup_import_filters	1
65	backup	backup_import_filters_locked	
66	backup	backup_import_calendarevents	1
67	backup	backup_import_calendarevents_locked	
68	backup	backup_import_questionbank	1
69	backup	backup_import_questionbank_locked	
70	backup	backup_import_groups	1
71	backup	backup_import_groups_locked	
72	backup	backup_import_competencies	1
73	backup	backup_import_competencies_locked	
74	backup	backup_import_contentbankcontent	1
75	backup	backup_import_contentbankcontent_locked	
76	backup	backup_auto_active	0
77	backup	backup_auto_weekdays	0000000
78	backup	backup_auto_hour	0
79	backup	backup_auto_minute	0
80	backup	backup_auto_storage	0
81	backup	backup_auto_destination	
82	backup	backup_auto_max_kept	1
83	backup	backup_auto_delete_days	0
84	backup	backup_auto_min_kept	0
85	backup	backup_shortname	0
86	backup	backup_auto_skip_hidden	1
87	backup	backup_auto_skip_modif_days	30
88	backup	backup_auto_skip_modif_prev	0
89	backup	backup_auto_users	1
90	backup	backup_auto_role_assignments	1
91	backup	backup_auto_activities	1
92	backup	backup_auto_blocks	1
93	backup	backup_auto_files	1
94	backup	backup_auto_filters	1
95	backup	backup_auto_comments	1
96	backup	backup_auto_badges	1
97	backup	backup_auto_calendarevents	1
98	backup	backup_auto_userscompletion	1
99	backup	backup_auto_logs	0
100	backup	backup_auto_histories	0
101	backup	backup_auto_questionbank	1
102	backup	backup_auto_groups	1
103	backup	backup_auto_competencies	1
104	backup	backup_auto_contentbankcontent	1
105	restore	restore_general_users	1
106	restore	restore_general_users_locked	
107	restore	restore_general_enrolments	1
108	restore	restore_general_enrolments_locked	
109	restore	restore_general_role_assignments	1
110	restore	restore_general_role_assignments_locked	
111	restore	restore_general_activities	1
112	restore	restore_general_activities_locked	
113	restore	restore_general_blocks	1
114	restore	restore_general_blocks_locked	
115	restore	restore_general_filters	1
116	restore	restore_general_filters_locked	
117	restore	restore_general_comments	1
118	restore	restore_general_comments_locked	
119	restore	restore_general_badges	1
120	restore	restore_general_badges_locked	
121	restore	restore_general_calendarevents	1
122	restore	restore_general_calendarevents_locked	
123	restore	restore_general_userscompletion	1
124	restore	restore_general_userscompletion_locked	
125	restore	restore_general_logs	1
126	restore	restore_general_logs_locked	
127	restore	restore_general_histories	1
128	restore	restore_general_histories_locked	
129	restore	restore_general_groups	1
130	restore	restore_general_groups_locked	
131	restore	restore_general_competencies	1
132	restore	restore_general_competencies_locked	
133	restore	restore_general_contentbankcontent	1
134	restore	restore_general_contentbankcontent_locked	
135	restore	restore_merge_overwrite_conf	0
136	restore	restore_merge_overwrite_conf_locked	
137	restore	restore_merge_course_fullname	1
138	restore	restore_merge_course_fullname_locked	
139	restore	restore_merge_course_shortname	1
140	restore	restore_merge_course_shortname_locked	
141	restore	restore_merge_course_startdate	1
142	restore	restore_merge_course_startdate_locked	
143	restore	restore_replace_overwrite_conf	0
144	restore	restore_replace_overwrite_conf_locked	
145	restore	restore_replace_course_fullname	1
146	restore	restore_replace_course_fullname_locked	
147	restore	restore_replace_course_shortname	1
148	restore	restore_replace_course_shortname_locked	
149	restore	restore_replace_course_startdate	1
150	restore	restore_replace_course_startdate_locked	
151	restore	restore_replace_keep_roles_and_enrolments	0
152	restore	restore_replace_keep_roles_and_enrolments_locked	
153	restore	restore_replace_keep_groups_and_groupings	0
154	restore	restore_replace_keep_groups_and_groupings_locked	
155	backup	backup_async_message_users	0
156	backup	backup_async_message_subject	Moodle {operation} completed successfully
157	backup	backup_async_message	Hi {user_firstname},<br/> Your {operation} (ID: {backupid}) has completed successfully. <br/><br/>You can access it here: {link}.
158	analytics	modeinstruction	
159	analytics	percentonline	0
160	analytics	typeinstitution	
161	analytics	levelinstitution	
162	analytics	predictionsprocessor	\\mlbackend_php\\processor
163	analytics	defaulttimesplittingsevaluation	\\core\\analytics\\time_splitting\\quarters_accum,\\core\\analytics\\time_splitting\\quarters,\\core\\analytics\\time_splitting\\single_range
164	analytics	modeloutputdir	/var/www/moodledata/models
165	analytics	onlycli	1
166	analytics	modeltimelimit	1200
167	core_competency	enabled	1
168	core_competency	pushcourseratingstouserplans	1
169	cachestore_apcu	testperformance	0
170	cachestore_memcached	testservers	
171	cachestore_mongodb	testserver	
172	cachestore_redis	test_server	
173	cachestore_redis	test_password	
174	question_preview	behaviour	deferredfeedback
175	question_preview	correctness	1
176	question_preview	marks	2
177	question_preview	markdp	2
178	question_preview	feedback	1
179	question_preview	generalfeedback	1
180	question_preview	rightanswer	1
181	question_preview	history	0
182	tool_task	enablerunnow	1
183	theme_boost	preset	default.scss
184	theme_boost	presetfiles	
185	theme_boost	backgroundimage	
186	theme_boost	brandcolor	
187	theme_boost	scsspre	
188	theme_boost	scss	
189	theme_classic	navbardark	0
190	theme_classic	preset	default.scss
191	theme_classic	presetfiles	
192	theme_classic	backgroundimage	
193	theme_classic	brandcolor	
194	theme_classic	scsspre	
195	theme_classic	scss	
196	core_admin	logo	
197	core_admin	logocompact	
198	core_admin	coursecolor1	#81ecec
199	core_admin	coursecolor2	#74b9ff
200	core_admin	coursecolor3	#a29bfe
201	core_admin	coursecolor4	#dfe6e9
202	core_admin	coursecolor5	#00b894
203	core_admin	coursecolor6	#0984e3
204	core_admin	coursecolor7	#b2bec3
205	core_admin	coursecolor8	#fdcb6e
206	core_admin	coursecolor9	#fd79a8
207	core_admin	coursecolor10	#6c5ce7
208	antivirus_clamav	version	2020061500
209	availability_completion	version	2020061500
210	availability_date	version	2020061500
211	availability_grade	version	2020061500
212	availability_group	version	2020061500
213	availability_grouping	version	2020061500
214	availability_profile	version	2020061500
215	qtype_calculated	version	2020061500
216	qtype_calculatedmulti	version	2020061500
217	qtype_calculatedsimple	version	2020061500
218	qtype_ddimageortext	version	2020061500
219	qtype_ddmarker	version	2020061500
220	qtype_ddwtos	version	2020061500
221	qtype_description	version	2020061500
222	qtype_essay	version	2020061500
223	qtype_gapselect	version	2020061500
224	qtype_match	version	2020061500
225	qtype_missingtype	version	2020061500
226	qtype_multianswer	version	2020061500
227	qtype_multichoice	version	2020061500
228	qtype_numerical	version	2020061500
229	qtype_random	version	2020061500
230	qtype_randomsamatch	version	2020061500
231	qtype_shortanswer	version	2020061500
232	qtype_truefalse	version	2020061500
233	mod_assign	version	2020061500
234	mod_assignment	version	2020061500
236	mod_book	version	2020061500
237	mod_chat	version	2020061500
238	mod_choice	version	2020061500
239	mod_data	version	2020061500
240	mod_feedback	version	2020061500
242	mod_folder	version	2020061500
244	mod_forum	version	2020061501
245	mod_glossary	version	2020061500
246	mod_h5pactivity	version	2020061500
247	mod_imscp	version	2020061500
249	mod_label	version	2020061500
250	mod_lesson	version	2020061500
251	mod_lti	version	2020061500
253	mod_lti	kid	7c59848b432eda5564a8
254	mod_lti	privatekey	-----BEGIN PRIVATE KEY-----\nMIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQC8iHdroWhl6p/B\np2uCnVaMuWGJEHZZIRrJnV3nK0LB5ATTNTlYRlUkmAFFwblTyXpOqJy7P1Off8Xl\nWNkNSWZ31nxkMucljwhljrIy+BHa8hZv78kLCsz3KQA6JydoECP0mrQnlCe/aeMG\nEeOcA1FC5yU0rDqt5wuzBvIb1NxG/4+9W/NQcG6aVhKScj5G+eGzTplZzEQvBZI/\n12/aH8P+riDqseh/Gmn9mhcVy/M7rgiJUvBmtq2PTMmsZ+C0SpWhqgjGA9zWXuoc\nw6b9u2yRvwEjgS9zkrFpyXI1P9jrHr24VJfVd84ZEos1/Q/O7yDxCM6TmEzJUSA6\nuVQZP8QlAgMBAAECggEBALeYuZrhwzXEpzDB5it7JwbBnN8KXgXr/BcsnX56HXeN\nork/komJbG7HbC3POrgCc43YG1EpmTixCDmRLUYIHbZD9DzraTelM4sazCRgeZra\nt8joHMMZEIL8tZDsAi8P0MPqR9hnKdH4vrFxiFKs1FyvlgbWVgp1/mmoMOuzfZPQ\nrLMhWAY5EzGoeWNGRa9Kk8mHvh+j3qSmbEloWwQBd5y/EoDQHnFqgXMAqoWQm5eW\nWyuIjTg/A9v2T+TncZrc1VSnftlVDsKRApyxRBKJXvcAiNy7QXAvAMXRhhoqphki\nfd622xL1G7pmy4QqA4XkXpWqgH2lKCx6/pud02R17D0CgYEA7VWfrMgDjC0XvMV7\nVvSnXUPFOG+0KvHGVFHoM+tU6w4KCDxBcyDfjRN1TOMXamGicvObXxOE6rKgJyuv\nD7xTZB+aqTuokEi1Kvcn+d3Jtm7Wo5XejVY4nKZlLP79pRfrMRbvCu3LrD3iRA9R\nso8/JpEY3FjNuLU8WARIV/bVricCgYEAy1xMnl1CnNI1C4SUUe3y1FKcD2m3EOn0\nLRxvGh/xpDYwU98UsmFuXAlAEGOzpLmUIpyY8GI3J+WM7ToZXDqYHVybpcP7cEVR\nUZHSwVib4J0ZdI1yP89ZExAuZ23LgFsdeb+y0skAez6CHoFqxdmGr0O41uaPp4Om\nByiEREyTNtMCgYEA5+fwvH48qS4usbAuEwvAtitQfRL5c7UH3MCkKodbVMtFFkL6\nmSqYBlvrFJQZ/0Mj3zsWqNKD4GlmgJ/40WFuArm3AIJg9Yt2K2OSVl9XiMHJTdNV\nwblsW/Vji5Il+rnigPct4Pn3OHjHrUViyR2b0W2aY0UKz9+X9VFJ91oj9aUCgYEA\nu8FwDBbW1atOxl+WAT7MIDRVWfWky7z1cGD8QwaTN6XAYO9qUHecSOVRfNBQoBmn\nJ32lxusnOXK69pvZpkmDADjsi9OyZinZtpIIH/MLmAnz4qRlg3yRJQSfk2bPqKZ3\nRF01YV+rTh6cTEX4qsr3iwHfuqoMoADwXVOPKu/4S3kCgYAdaxkSRQbY4KKYeOrN\nCFB6rx3wTYyD4w3yjBkiD8g1zYyoHFKoy6VOVzMAxcna759oZc9000j4yPrCBDV0\nznPhADy1X4zzoi8HgI8JZ/yl0Th/XS5EKv/qFwBrjJjJh6NVuShQnMrWEkVe05SL\n8EsODdwUtyj9Dm3u03Jxx3qi1w==\n-----END PRIVATE KEY-----\n
255	mod_page	version	2020061500
257	mod_quiz	version	2020061500
258	mod_resource	version	2020061500
259	mod_scorm	version	2020061500
260	mod_survey	version	2020061500
262	mod_url	version	2020061500
264	mod_wiki	version	2020061500
266	mod_workshop	version	2020061500
267	auth_cas	version	2020061500
269	auth_db	version	2020061500
271	auth_email	version	2020061500
272	auth_ldap	version	2020061500
274	auth_lti	version	2020061500
275	auth_manual	version	2020061500
276	auth_mnet	version	2020061500
278	auth_nologin	version	2020061500
279	auth_none	version	2020061500
280	auth_oauth2	version	2020061500
281	auth_shibboleth	version	2020061500
283	auth_webservice	version	2020061500
284	calendartype_gregorian	version	2020061500
285	customfield_checkbox	version	2020061500
286	customfield_date	version	2020061500
287	customfield_select	version	2020061500
288	customfield_text	version	2020061500
289	customfield_textarea	version	2020061500
290	enrol_category	version	2020061500
292	enrol_cohort	version	2020061500
293	enrol_database	version	2020061500
295	enrol_flatfile	version	2020061500
297	enrol_flatfile	map_1	manager
298	enrol_flatfile	map_2	coursecreator
299	enrol_flatfile	map_3	editingteacher
300	enrol_flatfile	map_4	teacher
301	enrol_flatfile	map_5	student
302	enrol_flatfile	map_6	guest
303	enrol_flatfile	map_7	user
304	enrol_flatfile	map_8	frontpage
305	enrol_guest	version	2020061500
306	enrol_imsenterprise	version	2020061500
308	enrol_ldap	version	2020061500
310	enrol_lti	version	2020061500
311	enrol_manual	version	2020061500
313	enrol_meta	version	2020061500
315	enrol_mnet	version	2020061500
316	enrol_paypal	version	2020061500
317	enrol_self	version	2020061500
319	message_airnotifier	version	2020061500
321	message	airnotifier_provider_enrol_imsenterprise_imsenterprise_enrolment_permitted	permitted
322	message	airnotifier_provider_enrol_paypal_paypal_enrolment_permitted	permitted
323	message	airnotifier_provider_mod_feedback_submission_permitted	permitted
324	message	airnotifier_provider_mod_feedback_message_permitted	permitted
325	message	airnotifier_provider_enrol_manual_expiry_notification_permitted	permitted
326	message	airnotifier_provider_mod_quiz_submission_permitted	permitted
327	message	airnotifier_provider_mod_quiz_confirmation_permitted	permitted
330	message	airnotifier_provider_mod_quiz_attempt_overdue_permitted	permitted
333	message	airnotifier_provider_mod_lesson_graded_essay_permitted	permitted
624	report_progress	version	2020061500
336	message	airnotifier_provider_enrol_self_expiry_notification_permitted	permitted
337	message	airnotifier_provider_enrol_flatfile_flatfile_enrolment_permitted	permitted
338	message	airnotifier_provider_mod_assignment_assignment_updates_permitted	permitted
339	message	airnotifier_provider_mod_assign_assign_notification_permitted	permitted
340	message	airnotifier_provider_moodle_notices_permitted	permitted
341	message	airnotifier_provider_moodle_errors_permitted	permitted
342	message	airnotifier_provider_moodle_availableupdate_permitted	permitted
343	message	airnotifier_provider_moodle_instantmessage_permitted	permitted
344	message	airnotifier_provider_moodle_backup_permitted	permitted
345	message	airnotifier_provider_moodle_courserequested_permitted	permitted
346	message	airnotifier_provider_moodle_courserequestapproved_permitted	permitted
626	report_questioninstances	version	2020061500
349	message	airnotifier_provider_moodle_courserequestrejected_permitted	permitted
627	report_security	version	2020061500
628	report_stats	version	2020061500
352	message	airnotifier_provider_moodle_badgerecipientnotice_permitted	permitted
355	message	airnotifier_provider_moodle_badgecreatornotice_permitted	permitted
356	message	airnotifier_provider_moodle_competencyplancomment_permitted	permitted
357	message	airnotifier_provider_moodle_competencyusercompcomment_permitted	permitted
358	message	airnotifier_provider_moodle_insights_permitted	permitted
630	report_status	version	2020061500
361	message	airnotifier_provider_moodle_messagecontactrequests_permitted	permitted
362	message	message_provider_moodle_messagecontactrequests_loggedin	airnotifier
631	report_usersessions	version	2020061500
364	message	airnotifier_provider_moodle_asyncbackupnotification_permitted	permitted
365	message	airnotifier_provider_moodle_gradenotifications_permitted	permitted
366	message	airnotifier_provider_mod_forum_posts_permitted	permitted
632	gradeexport_ods	version	2020061500
633	gradeexport_txt	version	2020061500
369	message	airnotifier_provider_mod_forum_digests_permitted	permitted
370	message_email	version	2020061500
634	gradeexport_xls	version	2020061500
372	message	email_provider_enrol_imsenterprise_imsenterprise_enrolment_permitted	permitted
373	message	message_provider_enrol_imsenterprise_imsenterprise_enrolment_loggedin	email
374	message	message_provider_enrol_imsenterprise_imsenterprise_enrolment_loggedoff	email
375	message	email_provider_enrol_paypal_paypal_enrolment_permitted	permitted
376	message	message_provider_enrol_paypal_paypal_enrolment_loggedin	email
377	message	message_provider_enrol_paypal_paypal_enrolment_loggedoff	email
378	message	email_provider_mod_feedback_submission_permitted	permitted
379	message	message_provider_mod_feedback_submission_loggedin	email
380	message	message_provider_mod_feedback_submission_loggedoff	email
381	message	email_provider_mod_feedback_message_permitted	permitted
382	message	message_provider_mod_feedback_message_loggedin	email
383	message	message_provider_mod_feedback_message_loggedoff	email
384	message	email_provider_enrol_manual_expiry_notification_permitted	permitted
385	message	message_provider_enrol_manual_expiry_notification_loggedin	email
386	message	message_provider_enrol_manual_expiry_notification_loggedoff	email
387	message	email_provider_mod_quiz_submission_permitted	permitted
388	message	message_provider_mod_quiz_submission_loggedin	email
389	message	message_provider_mod_quiz_submission_loggedoff	email
390	message	email_provider_mod_quiz_confirmation_permitted	permitted
328	message	message_provider_mod_quiz_confirmation_loggedin	email,airnotifier
329	message	message_provider_mod_quiz_confirmation_loggedoff	email,airnotifier
391	message	email_provider_mod_quiz_attempt_overdue_permitted	permitted
331	message	message_provider_mod_quiz_attempt_overdue_loggedin	email,airnotifier
332	message	message_provider_mod_quiz_attempt_overdue_loggedoff	email,airnotifier
392	message	email_provider_mod_lesson_graded_essay_permitted	permitted
334	message	message_provider_mod_lesson_graded_essay_loggedin	email,airnotifier
353	message	message_provider_moodle_badgerecipientnotice_loggedin	popup,airnotifier
359	message	message_provider_moodle_insights_loggedin	popup,airnotifier
635	gradeexport_xml	version	2020061500
636	gradeimport_csv	version	2020061500
637	gradeimport_direct	version	2020061500
638	gradeimport_xml	version	2020061500
639	gradereport_grader	version	2020061500
640	gradereport_history	version	2020061500
641	gradereport_outcomes	version	2020061500
642	gradereport_overview	version	2020061500
643	gradereport_singleview	version	2020061500
644	gradereport_user	version	2020061500
645	gradingform_guide	version	2020061500
646	gradingform_rubric	version	2020061500
647	mlbackend_php	version	2020061500
335	message	message_provider_mod_lesson_graded_essay_loggedoff	email,airnotifier
393	message	email_provider_enrol_self_expiry_notification_permitted	permitted
394	message	message_provider_enrol_self_expiry_notification_loggedin	email
395	message	message_provider_enrol_self_expiry_notification_loggedoff	email
396	message	email_provider_enrol_flatfile_flatfile_enrolment_permitted	permitted
397	message	message_provider_enrol_flatfile_flatfile_enrolment_loggedin	email
398	message	message_provider_enrol_flatfile_flatfile_enrolment_loggedoff	email
399	message	email_provider_mod_assignment_assignment_updates_permitted	permitted
400	message	message_provider_mod_assignment_assignment_updates_loggedin	email
401	message	message_provider_mod_assignment_assignment_updates_loggedoff	email
402	message	email_provider_mod_assign_assign_notification_permitted	permitted
403	message	message_provider_mod_assign_assign_notification_loggedin	email
404	message	message_provider_mod_assign_assign_notification_loggedoff	email
405	message	email_provider_moodle_notices_permitted	permitted
406	message	message_provider_moodle_notices_loggedin	email
407	message	message_provider_moodle_notices_loggedoff	email
408	message	email_provider_moodle_errors_permitted	permitted
409	message	message_provider_moodle_errors_loggedin	email
410	message	message_provider_moodle_errors_loggedoff	email
411	message	email_provider_moodle_availableupdate_permitted	permitted
412	message	message_provider_moodle_availableupdate_loggedin	email
413	message	message_provider_moodle_availableupdate_loggedoff	email
414	message	email_provider_moodle_instantmessage_permitted	permitted
648	mlbackend_python	version	2020061500
416	message	email_provider_moodle_backup_permitted	permitted
417	message	message_provider_moodle_backup_loggedin	email
418	message	message_provider_moodle_backup_loggedoff	email
419	message	email_provider_moodle_courserequested_permitted	permitted
420	message	message_provider_moodle_courserequested_loggedin	email
421	message	message_provider_moodle_courserequested_loggedoff	email
422	message	email_provider_moodle_courserequestapproved_permitted	permitted
347	message	message_provider_moodle_courserequestapproved_loggedin	email,airnotifier
348	message	message_provider_moodle_courserequestapproved_loggedoff	email,airnotifier
423	message	email_provider_moodle_courserequestrejected_permitted	permitted
350	message	message_provider_moodle_courserequestrejected_loggedin	email,airnotifier
351	message	message_provider_moodle_courserequestrejected_loggedoff	email,airnotifier
424	message	email_provider_moodle_badgerecipientnotice_permitted	permitted
649	mnetservice_enrol	version	2020061500
425	message	email_provider_moodle_badgecreatornotice_permitted	permitted
426	message	message_provider_moodle_badgecreatornotice_loggedoff	email
427	message	email_provider_moodle_competencyplancomment_permitted	permitted
428	message	message_provider_moodle_competencyplancomment_loggedin	email
429	message	message_provider_moodle_competencyplancomment_loggedoff	email
430	message	email_provider_moodle_competencyusercompcomment_permitted	permitted
431	message	message_provider_moodle_competencyusercompcomment_loggedin	email
432	message	message_provider_moodle_competencyusercompcomment_loggedoff	email
433	message	email_provider_moodle_insights_permitted	permitted
650	webservice_rest	version	2020061500
434	message	email_provider_moodle_messagecontactrequests_permitted	permitted
363	message	message_provider_moodle_messagecontactrequests_loggedoff	email,airnotifier
435	message	email_provider_moodle_asyncbackupnotification_permitted	permitted
651	webservice_soap	version	2020061500
437	message	email_provider_moodle_gradenotifications_permitted	permitted
652	webservice_xmlrpc	version	2020061500
439	message	email_provider_mod_forum_posts_permitted	permitted
367	message	message_provider_mod_forum_posts_loggedin	email,airnotifier
368	message	message_provider_mod_forum_posts_loggedoff	email,airnotifier
440	message	email_provider_mod_forum_digests_permitted	permitted
441	message	message_provider_mod_forum_digests_loggedin	email
442	message	message_provider_mod_forum_digests_loggedoff	email
443	message_jabber	version	2020061500
653	repository_areafiles	version	2020061500
445	message	jabber_provider_enrol_imsenterprise_imsenterprise_enrolment_permitted	permitted
446	message	jabber_provider_enrol_paypal_paypal_enrolment_permitted	permitted
447	message	jabber_provider_mod_feedback_submission_permitted	permitted
448	message	jabber_provider_mod_feedback_message_permitted	permitted
449	message	jabber_provider_enrol_manual_expiry_notification_permitted	permitted
450	message	jabber_provider_mod_quiz_submission_permitted	permitted
451	message	jabber_provider_mod_quiz_confirmation_permitted	permitted
452	message	jabber_provider_mod_quiz_attempt_overdue_permitted	permitted
453	message	jabber_provider_mod_lesson_graded_essay_permitted	permitted
454	message	jabber_provider_enrol_self_expiry_notification_permitted	permitted
455	message	jabber_provider_enrol_flatfile_flatfile_enrolment_permitted	permitted
456	message	jabber_provider_mod_assignment_assignment_updates_permitted	permitted
457	message	jabber_provider_mod_assign_assign_notification_permitted	permitted
458	message	jabber_provider_moodle_notices_permitted	permitted
459	message	jabber_provider_moodle_errors_permitted	permitted
460	message	jabber_provider_moodle_availableupdate_permitted	permitted
461	message	jabber_provider_moodle_instantmessage_permitted	permitted
462	message	jabber_provider_moodle_backup_permitted	permitted
463	message	jabber_provider_moodle_courserequested_permitted	permitted
464	message	jabber_provider_moodle_courserequestapproved_permitted	permitted
465	message	jabber_provider_moodle_courserequestrejected_permitted	permitted
466	message	jabber_provider_moodle_badgerecipientnotice_permitted	permitted
467	message	jabber_provider_moodle_badgecreatornotice_permitted	permitted
468	message	jabber_provider_moodle_competencyplancomment_permitted	permitted
469	message	jabber_provider_moodle_competencyusercompcomment_permitted	permitted
470	message	jabber_provider_moodle_insights_permitted	permitted
471	message	jabber_provider_moodle_messagecontactrequests_permitted	permitted
472	message	jabber_provider_moodle_asyncbackupnotification_permitted	permitted
473	message	jabber_provider_moodle_gradenotifications_permitted	permitted
474	message	jabber_provider_mod_forum_posts_permitted	permitted
475	message	jabber_provider_mod_forum_digests_permitted	permitted
476	message_popup	version	2020061500
478	message	popup_provider_enrol_imsenterprise_imsenterprise_enrolment_permitted	permitted
479	message	popup_provider_enrol_paypal_paypal_enrolment_permitted	permitted
480	message	popup_provider_mod_feedback_submission_permitted	permitted
481	message	popup_provider_mod_feedback_message_permitted	permitted
482	message	popup_provider_enrol_manual_expiry_notification_permitted	permitted
483	message	popup_provider_mod_quiz_submission_permitted	permitted
484	message	popup_provider_mod_quiz_confirmation_permitted	permitted
485	message	popup_provider_mod_quiz_attempt_overdue_permitted	permitted
486	message	popup_provider_mod_lesson_graded_essay_permitted	permitted
487	message	popup_provider_enrol_self_expiry_notification_permitted	permitted
488	message	popup_provider_enrol_flatfile_flatfile_enrolment_permitted	permitted
489	message	popup_provider_mod_assignment_assignment_updates_permitted	permitted
490	message	popup_provider_mod_assign_assign_notification_permitted	permitted
491	message	popup_provider_moodle_notices_permitted	permitted
492	message	popup_provider_moodle_errors_permitted	permitted
493	message	popup_provider_moodle_availableupdate_permitted	permitted
494	message	popup_provider_moodle_instantmessage_permitted	permitted
495	message	message_provider_moodle_instantmessage_loggedin	popup
415	message	message_provider_moodle_instantmessage_loggedoff	popup,email
496	message	popup_provider_moodle_backup_permitted	permitted
497	message	popup_provider_moodle_courserequested_permitted	permitted
498	message	popup_provider_moodle_courserequestapproved_permitted	permitted
499	message	popup_provider_moodle_courserequestrejected_permitted	permitted
500	message	popup_provider_moodle_badgerecipientnotice_permitted	permitted
354	message	message_provider_moodle_badgerecipientnotice_loggedoff	popup,email,airnotifier
501	message	popup_provider_moodle_badgecreatornotice_permitted	permitted
502	message	popup_provider_moodle_competencyplancomment_permitted	permitted
503	message	popup_provider_moodle_competencyusercompcomment_permitted	permitted
504	message	popup_provider_moodle_insights_permitted	permitted
360	message	message_provider_moodle_insights_loggedoff	popup,email,airnotifier
505	message	popup_provider_moodle_messagecontactrequests_permitted	permitted
506	message	popup_provider_moodle_asyncbackupnotification_permitted	permitted
507	message	message_provider_moodle_asyncbackupnotification_loggedin	popup
436	message	message_provider_moodle_asyncbackupnotification_loggedoff	popup,email
508	message	popup_provider_moodle_gradenotifications_permitted	permitted
509	message	message_provider_moodle_gradenotifications_loggedin	popup
438	message	message_provider_moodle_gradenotifications_loggedoff	popup,email
510	message	popup_provider_mod_forum_posts_permitted	permitted
511	message	popup_provider_mod_forum_digests_permitted	permitted
512	block_activity_modules	version	2020061500
513	block_activity_results	version	2020061500
514	block_admin_bookmarks	version	2020061500
515	block_badges	version	2020061500
516	block_blog_menu	version	2020061500
517	block_blog_recent	version	2020061500
518	block_blog_tags	version	2020061500
519	block_calendar_month	version	2020061500
520	block_calendar_upcoming	version	2020061500
521	block_comments	version	2020061500
522	block_completionstatus	version	2020061500
523	block_course_list	version	2020061500
524	block_course_summary	version	2020061500
525	block_feedback	version	2020061500
527	block_globalsearch	version	2020061500
528	block_glossary_random	version	2020061500
529	block_html	version	2020061500
530	block_login	version	2020061500
531	block_lp	version	2020061500
532	block_mentees	version	2020061500
533	block_mnet_hosts	version	2020061500
534	block_myoverview	version	2020061500
535	block_myprofile	version	2020061500
536	block_navigation	version	2020061500
537	block_news_items	version	2020061500
538	block_online_users	version	2020061500
539	block_private_files	version	2020061500
540	block_quiz_results	version	2020061500
655	areafiles	enablecourseinstances	0
542	block_recent_activity	version	2020061500
543	block_recentlyaccessedcourses	version	2020061500
656	areafiles	enableuserinstances	0
545	block_recentlyaccesseditems	version	2020061500
546	block_rss_client	version	2020061500
547	block_search_forums	version	2020061500
548	block_section_links	version	2020061500
549	block_selfcompletion	version	2020061500
550	block_settings	version	2020061500
551	block_site_main_menu	version	2020061500
552	block_social_activities	version	2020061500
553	block_starredcourses	version	2020061500
554	block_tag_flickr	version	2020061500
555	block_tag_youtube	version	2020061500
657	repository_boxnet	version	2020061500
557	block_tags	version	2020061500
558	block_timeline	version	2020061500
658	repository_contentbank	version	2020061500
560	media_html5audio	version	2020061500
561	media_html5video	version	2020061500
562	media_swf	version	2020061500
563	media_videojs	version	2020061500
564	media_vimeo	version	2020061500
565	media_youtube	version	2020061500
566	filter_activitynames	version	2020061500
568	filter_algebra	version	2020061500
569	filter_censor	version	2020061500
570	filter_data	version	2020061500
660	contentbank	enablecourseinstances	0
572	filter_displayh5p	version	2020061500
661	contentbank	enableuserinstances	0
574	filter_emailprotect	version	2020061500
575	filter_emoticon	version	2020061500
662	repository_coursefiles	version	2020061500
577	filter_glossary	version	2020061500
663	repository_dropbox	version	2020061500
579	filter_mathjaxloader	version	2020061500
664	repository_equella	version	2020061500
581	filter_mediaplugin	version	2020061500
665	repository_filesystem	version	2020061500
583	filter_multilang	version	2020061500
584	filter_tex	version	2020061500
666	repository_flickr	version	2020061500
586	filter_tidy	version	2020061500
587	filter_urltolink	version	2020061500
667	repository_flickr_public	version	2020061500
589	editor_atto	version	2020061500
668	repository_googledocs	version	2020061500
591	editor_textarea	version	2020061500
592	editor_tinymce	version	2020061500
593	format_singleactivity	version	2020061500
594	format_social	version	2020061500
595	format_topics	version	2020061500
596	format_weeks	version	2020061500
597	dataformat_csv	version	2020061500
598	dataformat_excel	version	2020061500
599	dataformat_html	version	2020061500
600	dataformat_json	version	2020061500
601	dataformat_ods	version	2020061500
602	dataformat_pdf	version	2020061500
603	profilefield_checkbox	version	2020061500
604	profilefield_datetime	version	2020061500
605	profilefield_menu	version	2020061500
606	profilefield_text	version	2020061500
607	profilefield_textarea	version	2020061500
608	report_backups	version	2020061500
609	report_competency	version	2020061500
610	report_completion	version	2020061500
669	repository_local	version	2020061500
612	report_configlog	version	2020061500
613	report_courseoverview	version	2020061500
614	report_eventlist	version	2020061500
615	report_insights	version	2020061500
616	report_log	version	2020061500
618	report_loglive	version	2020061500
619	report_outline	version	2020061500
671	local	enablecourseinstances	0
621	report_participation	version	2020061500
672	local	enableuserinstances	0
623	report_performance	version	2020061500
673	repository_merlot	version	2020061500
674	repository_nextcloud	version	2020061500
675	repository_onedrive	version	2020061500
676	repository_picasa	version	2020061500
677	repository_recent	version	2020061500
679	recent	enablecourseinstances	0
680	recent	enableuserinstances	0
681	repository_s3	version	2020061500
682	repository_skydrive	version	2020061500
683	repository_upload	version	2020061500
685	upload	enablecourseinstances	0
686	upload	enableuserinstances	0
687	repository_url	version	2020061500
689	url	enablecourseinstances	0
690	url	enableuserinstances	0
691	repository_user	version	2020061500
693	user	enablecourseinstances	0
694	user	enableuserinstances	0
695	repository_webdav	version	2020061500
696	repository_wikimedia	version	2020061500
698	wikimedia	enablecourseinstances	0
699	wikimedia	enableuserinstances	0
700	repository_youtube	version	2020061500
702	portfolio_boxnet	version	2020061500
703	portfolio_download	version	2020061500
704	portfolio_flickr	version	2020061500
705	portfolio_googledocs	version	2020061500
706	portfolio_mahara	version	2020061500
707	portfolio_picasa	version	2020061500
708	search_simpledb	version	2020061500
710	search_solr	version	2020061500
711	qbehaviour_adaptive	version	2020061500
712	qbehaviour_adaptivenopenalty	version	2020061500
713	qbehaviour_deferredcbm	version	2020061500
714	qbehaviour_deferredfeedback	version	2020061500
715	qbehaviour_immediatecbm	version	2020061500
716	qbehaviour_immediatefeedback	version	2020061500
717	qbehaviour_informationitem	version	2020061500
718	qbehaviour_interactive	version	2020061500
719	qbehaviour_interactivecountback	version	2020061500
720	qbehaviour_manualgraded	version	2020061500
722	question	disabledbehaviours	manualgraded
723	qbehaviour_missing	version	2020061500
724	qformat_aiken	version	2020061500
725	qformat_blackboard_six	version	2020061500
726	qformat_examview	version	2020061500
727	qformat_gift	version	2020061500
728	qformat_missingword	version	2020061500
729	qformat_multianswer	version	2020061500
730	qformat_webct	version	2020061500
731	qformat_xhtml	version	2020061500
732	qformat_xml	version	2020061500
733	tool_analytics	version	2020061500
734	tool_availabilityconditions	version	2020061500
735	tool_behat	version	2020061500
736	tool_capability	version	2020061500
737	tool_cohortroles	version	2020061500
738	tool_customlang	version	2020061500
740	tool_dataprivacy	version	2020061501
741	message	airnotifier_provider_tool_dataprivacy_contactdataprotectionofficer_permitted	permitted
742	message	email_provider_tool_dataprivacy_contactdataprotectionofficer_permitted	permitted
743	message	jabber_provider_tool_dataprivacy_contactdataprotectionofficer_permitted	permitted
744	message	popup_provider_tool_dataprivacy_contactdataprotectionofficer_permitted	permitted
745	message	message_provider_tool_dataprivacy_contactdataprotectionofficer_loggedin	email,popup
746	message	message_provider_tool_dataprivacy_contactdataprotectionofficer_loggedoff	email,popup
747	message	airnotifier_provider_tool_dataprivacy_datarequestprocessingresults_permitted	permitted
748	message	email_provider_tool_dataprivacy_datarequestprocessingresults_permitted	permitted
749	message	jabber_provider_tool_dataprivacy_datarequestprocessingresults_permitted	permitted
750	message	popup_provider_tool_dataprivacy_datarequestprocessingresults_permitted	permitted
751	message	message_provider_tool_dataprivacy_datarequestprocessingresults_loggedin	email,popup
752	message	message_provider_tool_dataprivacy_datarequestprocessingresults_loggedoff	email,popup
753	message	airnotifier_provider_tool_dataprivacy_notifyexceptions_permitted	permitted
754	message	email_provider_tool_dataprivacy_notifyexceptions_permitted	permitted
755	message	jabber_provider_tool_dataprivacy_notifyexceptions_permitted	permitted
756	message	popup_provider_tool_dataprivacy_notifyexceptions_permitted	permitted
757	message	message_provider_tool_dataprivacy_notifyexceptions_loggedin	email
758	message	message_provider_tool_dataprivacy_notifyexceptions_loggedoff	email
759	tool_dbtransfer	version	2020061500
760	tool_filetypes	version	2020061500
761	tool_generator	version	2020061500
762	tool_health	version	2020061500
763	tool_httpsreplace	version	2020061500
764	tool_innodb	version	2020061500
765	tool_installaddon	version	2020061500
766	tool_langimport	version	2020061500
767	tool_licensemanager	version	2020061500
768	tool_log	version	2020061500
770	tool_log	enabled_stores	logstore_standard
771	tool_lp	version	2020061500
772	tool_lpimportcsv	version	2020061500
773	tool_lpmigrate	version	2020061500
774	tool_messageinbound	version	2020061500
775	message	airnotifier_provider_tool_messageinbound_invalidrecipienthandler_permitted	permitted
776	message	email_provider_tool_messageinbound_invalidrecipienthandler_permitted	permitted
777	message	jabber_provider_tool_messageinbound_invalidrecipienthandler_permitted	permitted
778	message	popup_provider_tool_messageinbound_invalidrecipienthandler_permitted	permitted
779	message	message_provider_tool_messageinbound_invalidrecipienthandler_loggedin	email
780	message	message_provider_tool_messageinbound_invalidrecipienthandler_loggedoff	email
781	message	airnotifier_provider_tool_messageinbound_messageprocessingerror_permitted	permitted
782	message	email_provider_tool_messageinbound_messageprocessingerror_permitted	permitted
783	message	jabber_provider_tool_messageinbound_messageprocessingerror_permitted	permitted
784	message	popup_provider_tool_messageinbound_messageprocessingerror_permitted	permitted
785	message	message_provider_tool_messageinbound_messageprocessingerror_loggedin	email
786	message	message_provider_tool_messageinbound_messageprocessingerror_loggedoff	email
787	message	airnotifier_provider_tool_messageinbound_messageprocessingsuccess_permitted	permitted
788	message	email_provider_tool_messageinbound_messageprocessingsuccess_permitted	permitted
789	message	jabber_provider_tool_messageinbound_messageprocessingsuccess_permitted	permitted
790	message	popup_provider_tool_messageinbound_messageprocessingsuccess_permitted	permitted
791	message	message_provider_tool_messageinbound_messageprocessingsuccess_loggedin	email
792	message	message_provider_tool_messageinbound_messageprocessingsuccess_loggedoff	email
793	tool_mobile	version	2020061500
794	tool_monitor	version	2020061500
795	message	airnotifier_provider_tool_monitor_notification_permitted	permitted
796	message	email_provider_tool_monitor_notification_permitted	permitted
797	message	jabber_provider_tool_monitor_notification_permitted	permitted
798	message	popup_provider_tool_monitor_notification_permitted	permitted
799	message	message_provider_tool_monitor_notification_loggedin	email
800	message	message_provider_tool_monitor_notification_loggedoff	email
801	tool_moodlenet	version	2020061502
802	tool_multilangupgrade	version	2020061500
803	tool_oauth2	version	2020061500
804	tool_phpunit	version	2020061500
805	tool_policy	version	2020061500
806	tool_profiling	version	2020061500
807	tool_recyclebin	version	2020061500
808	tool_replace	version	2020061500
809	tool_spamcleaner	version	2020061500
810	tool_task	version	2020061500
811	tool_templatelibrary	version	2020061500
812	tool_unsuproles	version	2020061500
814	tool_uploadcourse	version	2020061500
815	tool_uploaduser	version	2020061500
816	tool_usertours	version	2020061501
818	tool_xmldb	version	2020061500
819	cachestore_apcu	version	2020061500
820	cachestore_file	version	2020061500
821	cachestore_memcached	version	2020061500
822	cachestore_mongodb	version	2020061500
823	cachestore_redis	version	2020061500
824	cachestore_session	version	2020061500
825	cachestore_static	version	2020061500
826	cachelock_file	version	2020061500
827	fileconverter_googledrive	version	2020061500
828	fileconverter_unoconv	version	2020061500
830	contenttype_h5p	version	2020061500
831	theme_boost	version	2020061500
832	theme_classic	version	2020061500
833	h5plib_v124	version	2020061500
834	assignsubmission_comments	version	2020061500
870	datafield_textarea	version	2020061500
871	datafield_url	version	2020061500
872	datapreset_imagegallery	version	2020061500
839	assignsubmission_file	version	2020061500
840	assignsubmission_onlinetext	version	2020061500
873	forumreport_summary	version	2020061500
874	ltiservice_basicoutcomes	version	2020061500
875	ltiservice_gradebookservices	version	2020061500
838	assignsubmission_onlinetext	sortorder	0
836	assignsubmission_file	sortorder	1
837	assignsubmission_comments	sortorder	2
842	assignfeedback_comments	version	2020061500
848	assignfeedback_editpdf	version	2020061500
850	assignfeedback_file	version	2020061500
844	assignfeedback_comments	sortorder	0
845	assignfeedback_editpdf	sortorder	1
847	assignfeedback_offline	sortorder	2
846	assignfeedback_file	sortorder	3
852	assignfeedback_offline	version	2020061500
853	assignment_offline	version	2020061500
854	assignment_online	version	2020061500
855	assignment_upload	version	2020061500
856	assignment_uploadsingle	version	2020061500
857	booktool_exportimscp	version	2020061500
858	booktool_importhtml	version	2020061500
859	booktool_print	version	2020061500
860	datafield_checkbox	version	2020061500
861	datafield_date	version	2020061500
862	datafield_file	version	2020061500
863	datafield_latlong	version	2020061500
864	datafield_menu	version	2020061500
865	datafield_multimenu	version	2020061500
866	datafield_number	version	2020061500
867	datafield_picture	version	2020061500
868	datafield_radiobutton	version	2020061500
869	datafield_text	version	2020061500
876	ltiservice_memberships	version	2020061500
877	ltiservice_profile	version	2020061500
878	ltiservice_toolproxy	version	2020061500
879	ltiservice_toolsettings	version	2020061500
880	quiz_grading	version	2020061500
882	quiz_overview	version	2020061500
884	quiz_responses	version	2020061500
886	quiz_statistics	version	2020061500
888	quizaccess_delaybetweenattempts	version	2020061500
889	quizaccess_ipaddress	version	2020061500
890	quizaccess_numattempts	version	2020061500
891	quizaccess_offlineattempts	version	2020061500
892	quizaccess_openclosedate	version	2020061500
893	quizaccess_password	version	2020061500
894	quizaccess_seb	version	2020061500
896	quizaccess_securewindow	version	2020061500
897	quizaccess_timelimit	version	2020061500
898	scormreport_basic	version	2020061500
899	scormreport_graphs	version	2020061500
900	scormreport_interactions	version	2020061500
901	scormreport_objectives	version	2020061500
902	workshopform_accumulative	version	2020061500
904	workshopform_comments	version	2020061500
906	workshopform_numerrors	version	2020061500
908	workshopform_rubric	version	2020061500
910	workshopallocation_manual	version	2020061500
911	workshopallocation_random	version	2020061500
912	workshopallocation_scheduled	version	2020061500
913	workshopeval_best	version	2020061500
914	atto_accessibilitychecker	version	2020061500
915	atto_accessibilityhelper	version	2020061500
916	atto_align	version	2020061500
917	atto_backcolor	version	2020061500
918	atto_bold	version	2020061500
919	atto_charmap	version	2020061500
920	atto_clear	version	2020061500
921	atto_collapse	version	2020061500
922	atto_emojipicker	version	2020061500
923	atto_emoticon	version	2020061500
924	atto_equation	version	2020061500
925	atto_fontcolor	version	2020061500
926	atto_h5p	version	2020061500
927	atto_html	version	2020061500
928	atto_image	version	2020061500
929	atto_indent	version	2020061500
930	atto_italic	version	2020061500
931	atto_link	version	2020061500
932	atto_managefiles	version	2020061500
933	atto_media	version	2020061500
934	atto_noautolink	version	2020061500
935	atto_orderedlist	version	2020061500
936	atto_recordrtc	version	2020061500
937	atto_rtl	version	2020061500
938	atto_strike	version	2020061500
939	atto_subscript	version	2020061500
940	atto_superscript	version	2020061500
941	atto_table	version	2020061500
942	atto_title	version	2020061500
943	atto_underline	version	2020061500
944	atto_undo	version	2020061500
945	atto_unorderedlist	version	2020061500
946	tinymce_ctrlhelp	version	2020061500
947	tinymce_managefiles	version	2020061500
948	tinymce_moodleemoticon	version	2020061500
949	tinymce_moodleimage	version	2020061500
950	tinymce_moodlemedia	version	2020061500
951	tinymce_moodlenolink	version	2020061500
952	tinymce_pdw	version	2020061500
953	tinymce_spellchecker	version	2020061500
955	tinymce_wrap	version	2020061500
956	logstore_database	version	2020061500
957	logstore_legacy	version	2020061500
958	logstore_standard	version	2020061500
959	tool_dataprivacy	contactdataprotectionofficer	0
960	tool_dataprivacy	automaticdataexportapproval	0
961	tool_dataprivacy	automaticdatadeletionapproval	0
962	tool_dataprivacy	automaticdeletionrequests	1
963	tool_dataprivacy	privacyrequestexpiry	604800
964	tool_dataprivacy	requireallenddatesforuserdeletion	1
965	tool_dataprivacy	showdataretentionsummary	1
966	tool_log	exportlog	1
967	analytics	logstore	logstore_standard
968	assign	feedback_plugin_for_gradebook	assignfeedback_comments
969	assign	showrecentsubmissions	0
970	assign	submissionreceipts	1
971	assign	submissionstatement	This submission is my own work, except where I have acknowledged the use of the works of other people.
972	assign	submissionstatementteamsubmission	This submission is the work of my group, except where we have acknowledged the use of the works of other people.
973	assign	submissionstatementteamsubmissionallsubmit	This submission is my own work as a group member, except where I have acknowledged the use of the works of other people.
974	assign	maxperpage	-1
975	assign	alwaysshowdescription	1
976	assign	alwaysshowdescription_adv	
977	assign	alwaysshowdescription_locked	
978	assign	allowsubmissionsfromdate	0
979	assign	allowsubmissionsfromdate_enabled	1
980	assign	allowsubmissionsfromdate_adv	
981	assign	duedate	604800
982	assign	duedate_enabled	1
983	assign	duedate_adv	
984	assign	cutoffdate	1209600
985	assign	cutoffdate_enabled	
986	assign	cutoffdate_adv	
987	assign	gradingduedate	1209600
988	assign	gradingduedate_enabled	1
989	assign	gradingduedate_adv	
990	assign	submissiondrafts	0
991	assign	submissiondrafts_adv	
992	assign	submissiondrafts_locked	
993	assign	requiresubmissionstatement	0
994	assign	requiresubmissionstatement_adv	
995	assign	requiresubmissionstatement_locked	
996	assign	attemptreopenmethod	none
997	assign	attemptreopenmethod_adv	
998	assign	attemptreopenmethod_locked	
999	assign	maxattempts	-1
1000	assign	maxattempts_adv	
1001	assign	maxattempts_locked	
1002	assign	teamsubmission	0
1003	assign	teamsubmission_adv	
1004	assign	teamsubmission_locked	
1005	assign	preventsubmissionnotingroup	0
1006	assign	preventsubmissionnotingroup_adv	
1007	assign	preventsubmissionnotingroup_locked	
1008	assign	requireallteammemberssubmit	0
1009	assign	requireallteammemberssubmit_adv	
1010	assign	requireallteammemberssubmit_locked	
1011	assign	teamsubmissiongroupingid	
1012	assign	teamsubmissiongroupingid_adv	
1013	assign	sendnotifications	0
1014	assign	sendnotifications_adv	
1015	assign	sendnotifications_locked	
1016	assign	sendlatenotifications	0
1017	assign	sendlatenotifications_adv	
1018	assign	sendlatenotifications_locked	
1019	assign	sendstudentnotifications	1
1020	assign	sendstudentnotifications_adv	
1021	assign	sendstudentnotifications_locked	
1022	assign	blindmarking	0
1023	assign	blindmarking_adv	
1024	assign	blindmarking_locked	
1025	assign	hidegrader	0
1026	assign	hidegrader_adv	
1027	assign	hidegrader_locked	
1028	assign	markingworkflow	0
1029	assign	markingworkflow_adv	
1030	assign	markingworkflow_locked	
1031	assign	markingallocation	0
1032	assign	markingallocation_adv	
1033	assign	markingallocation_locked	
1034	assignsubmission_file	default	1
1035	assignsubmission_file	maxfiles	20
1036	assignsubmission_file	filetypes	
1037	assignsubmission_file	maxbytes	0
1038	assignsubmission_onlinetext	default	0
1039	assignfeedback_comments	default	1
1040	assignfeedback_comments	inline	0
1041	assignfeedback_comments	inline_adv	
1042	assignfeedback_comments	inline_locked	
1043	assignfeedback_editpdf	default	1
1044	assignfeedback_editpdf	stamps	
1045	assignfeedback_file	default	0
1046	assignfeedback_offline	default	0
1047	book	numberingoptions	0,1,2,3
1048	book	navoptions	0,1,2
1049	book	numbering	1
1050	book	navstyle	1
1051	resource	framesize	130
1052	resource	displayoptions	0,1,4,5,6
1053	resource	printintro	1
1054	resource	display	0
1055	resource	showsize	0
1056	resource	showtype	0
1057	resource	showdate	0
1058	resource	popupwidth	620
1059	resource	popupheight	450
1060	resource	filterfiles	0
1061	folder	showexpanded	1
1062	folder	maxsizetodownload	0
1063	imscp	keepold	1
1064	imscp	keepold_adv	
1065	label	dndmedia	1
1066	label	dndresizewidth	400
1067	label	dndresizeheight	400
1068	mod_lesson	mediafile	
1069	mod_lesson	mediafile_adv	1
1070	mod_lesson	mediawidth	640
1071	mod_lesson	mediaheight	480
1072	mod_lesson	mediaclose	0
1073	mod_lesson	progressbar	0
1074	mod_lesson	progressbar_adv	
1075	mod_lesson	ongoing	0
1076	mod_lesson	ongoing_adv	1
1077	mod_lesson	displayleftmenu	0
1078	mod_lesson	displayleftmenu_adv	
1079	mod_lesson	displayleftif	0
1080	mod_lesson	displayleftif_adv	1
1081	mod_lesson	slideshow	0
1082	mod_lesson	slideshow_adv	1
1083	mod_lesson	slideshowwidth	640
1084	mod_lesson	slideshowheight	480
1085	mod_lesson	slideshowbgcolor	#FFFFFF
1086	mod_lesson	maxanswers	5
1087	mod_lesson	maxanswers_adv	1
1088	mod_lesson	defaultfeedback	0
1089	mod_lesson	defaultfeedback_adv	1
1090	mod_lesson	activitylink	
1091	mod_lesson	activitylink_adv	1
1092	mod_lesson	timelimit	0
1093	mod_lesson	timelimit_adv	
1094	mod_lesson	password	0
1095	mod_lesson	password_adv	1
1096	mod_lesson	modattempts	0
1097	mod_lesson	modattempts_adv	
1098	mod_lesson	displayreview	0
1099	mod_lesson	displayreview_adv	
1100	mod_lesson	maximumnumberofattempts	1
1101	mod_lesson	maximumnumberofattempts_adv	
1102	mod_lesson	defaultnextpage	0
1103	mod_lesson	defaultnextpage_adv	1
1104	mod_lesson	numberofpagestoshow	1
1105	mod_lesson	numberofpagestoshow_adv	1
1106	mod_lesson	practice	0
1107	mod_lesson	practice_adv	
1108	mod_lesson	customscoring	1
1109	mod_lesson	customscoring_adv	1
1110	mod_lesson	retakesallowed	0
1111	mod_lesson	retakesallowed_adv	
1112	mod_lesson	handlingofretakes	0
1113	mod_lesson	handlingofretakes_adv	1
1114	mod_lesson	minimumnumberofquestions	0
1115	mod_lesson	minimumnumberofquestions_adv	1
1116	page	displayoptions	5
1117	page	printheading	1
1118	page	printintro	0
1119	page	printlastmodified	1
1120	page	display	5
1121	page	popupwidth	620
1122	page	popupheight	450
1123	quiz	timelimit	0
1124	quiz	timelimit_adv	
1125	quiz	overduehandling	autosubmit
1126	quiz	overduehandling_adv	
1127	quiz	graceperiod	86400
1128	quiz	graceperiod_adv	
1129	quiz	graceperiodmin	60
1130	quiz	attempts	0
1131	quiz	attempts_adv	
1132	quiz	grademethod	1
1133	quiz	grademethod_adv	
1134	quiz	maximumgrade	10
1135	quiz	questionsperpage	1
1136	quiz	questionsperpage_adv	
1137	quiz	navmethod	free
1138	quiz	navmethod_adv	1
1139	quiz	shuffleanswers	1
1140	quiz	shuffleanswers_adv	
1141	quiz	preferredbehaviour	deferredfeedback
1142	quiz	canredoquestions	0
1143	quiz	canredoquestions_adv	1
1144	quiz	attemptonlast	0
1145	quiz	attemptonlast_adv	1
1146	quiz	reviewattempt	69904
1147	quiz	reviewcorrectness	69904
1148	quiz	reviewmarks	69904
1149	quiz	reviewspecificfeedback	69904
1150	quiz	reviewgeneralfeedback	69904
1151	quiz	reviewrightanswer	69904
1152	quiz	reviewoverallfeedback	4368
1153	quiz	showuserpicture	0
1154	quiz	showuserpicture_adv	
1155	quiz	decimalpoints	2
1156	quiz	decimalpoints_adv	
1157	quiz	questiondecimalpoints	-1
1158	quiz	questiondecimalpoints_adv	
1159	quiz	showblocks	0
1160	quiz	showblocks_adv	1
1161	quiz	quizpassword	
1162	quiz	quizpassword_adv	
1163	quiz	quizpassword_required	
1164	quiz	subnet	
1165	quiz	subnet_adv	1
1166	quiz	delay1	0
1167	quiz	delay1_adv	1
1168	quiz	delay2	0
1169	quiz	delay2_adv	1
1170	quiz	browsersecurity	-
1171	quiz	browsersecurity_adv	1
1172	quiz	initialnumfeedbacks	2
1173	quiz	autosaveperiod	60
1174	quizaccess_seb	autoreconfigureseb	1
1175	quizaccess_seb	showseblinks	seb,http
1176	quizaccess_seb	downloadlink	https://safeexambrowser.org/download_en.html
1177	quizaccess_seb	quizpasswordrequired	0
1178	quizaccess_seb	displayblocksbeforestart	0
1179	quizaccess_seb	displayblockswhenfinished	1
1180	scorm	displaycoursestructure	0
1181	scorm	displaycoursestructure_adv	
1182	scorm	popup	0
1183	scorm	popup_adv	
1184	scorm	displayactivityname	1
1185	scorm	framewidth	100
1186	scorm	framewidth_adv	1
1187	scorm	frameheight	500
1188	scorm	frameheight_adv	1
1189	scorm	winoptgrp_adv	1
1190	scorm	scrollbars	0
1191	scorm	directories	0
1192	scorm	location	0
1193	scorm	menubar	0
1194	scorm	toolbar	0
1195	scorm	status	0
1196	scorm	skipview	0
1197	scorm	skipview_adv	1
1198	scorm	hidebrowse	0
1199	scorm	hidebrowse_adv	1
1200	scorm	hidetoc	0
1201	scorm	hidetoc_adv	1
1202	scorm	nav	1
1203	scorm	nav_adv	1
1204	scorm	navpositionleft	-100
1205	scorm	navpositionleft_adv	1
1206	scorm	navpositiontop	-100
1207	scorm	navpositiontop_adv	1
1208	scorm	collapsetocwinsize	767
1209	scorm	collapsetocwinsize_adv	1
1210	scorm	displayattemptstatus	1
1211	scorm	displayattemptstatus_adv	
1212	scorm	grademethod	1
1213	scorm	maxgrade	100
1214	scorm	maxattempt	0
1215	scorm	whatgrade	0
1216	scorm	forcecompleted	0
1217	scorm	forcenewattempt	0
1218	scorm	autocommit	0
1219	scorm	masteryoverride	1
1220	scorm	lastattemptlock	0
1221	scorm	auto	0
1222	scorm	updatefreq	0
1223	scorm	scormstandard	0
1224	scorm	allowtypeexternal	0
1225	scorm	allowtypelocalsync	0
1226	scorm	allowtypeexternalaicc	0
1227	scorm	allowaicchacp	0
1228	scorm	aicchacptimeout	30
1229	scorm	aicchacpkeepsessiondata	1
1230	scorm	aiccuserid	1
1231	scorm	forcejavascript	1
1232	scorm	allowapidebug	0
1233	scorm	apidebugmask	.*
1234	scorm	protectpackagedownloads	0
1235	url	framesize	130
1236	url	secretphrase	
1237	url	rolesinparams	0
1238	url	displayoptions	0,1,5,6
1239	url	printintro	1
1240	url	display	0
1241	url	popupwidth	620
1242	url	popupheight	450
1243	workshop	grade	80
1244	workshop	gradinggrade	20
1245	workshop	gradedecimals	0
1246	workshop	maxbytes	0
1247	workshop	strategy	accumulative
1248	workshop	examplesmode	0
1249	workshopallocation_random	numofreviews	5
1250	workshopform_numerrors	grade0	No
1251	workshopform_numerrors	grade1	Yes
1252	workshopeval_best	comparison	5
1253	tool_recyclebin	coursebinenable	1
1254	tool_recyclebin	coursebinexpiry	604800
1255	tool_recyclebin	categorybinenable	1
1256	tool_recyclebin	categorybinexpiry	604800
1257	tool_recyclebin	autohide	1
1258	antivirus_clamav	runningmethod	commandline
1259	antivirus_clamav	pathtoclam	
1260	antivirus_clamav	pathtounixsocket	
1261	antivirus_clamav	tcpsockethost	
1262	antivirus_clamav	tcpsocketport	3310
1263	antivirus_clamav	clamfailureonupload	donothing
1264	antivirus_clamav	tries	1
1265	auth_cas	field_map_firstname	
1266	auth_cas	field_updatelocal_firstname	oncreate
1267	auth_cas	field_updateremote_firstname	0
1268	auth_cas	field_lock_firstname	unlocked
1269	auth_cas	field_map_lastname	
1270	auth_cas	field_updatelocal_lastname	oncreate
1271	auth_cas	field_updateremote_lastname	0
1272	auth_cas	field_lock_lastname	unlocked
1273	auth_cas	field_map_email	
1274	auth_cas	field_updatelocal_email	oncreate
1275	auth_cas	field_updateremote_email	0
1276	auth_cas	field_lock_email	unlocked
1277	auth_cas	field_map_city	
1278	auth_cas	field_updatelocal_city	oncreate
1279	auth_cas	field_updateremote_city	0
1280	auth_cas	field_lock_city	unlocked
1281	auth_cas	field_map_country	
1282	auth_cas	field_updatelocal_country	oncreate
1283	auth_cas	field_updateremote_country	0
1284	auth_cas	field_lock_country	unlocked
1285	auth_cas	field_map_lang	
1286	auth_cas	field_updatelocal_lang	oncreate
1287	auth_cas	field_updateremote_lang	0
1288	auth_cas	field_lock_lang	unlocked
1289	auth_cas	field_map_description	
1290	auth_cas	field_updatelocal_description	oncreate
1291	auth_cas	field_updateremote_description	0
1292	auth_cas	field_lock_description	unlocked
1293	auth_cas	field_map_url	
1294	auth_cas	field_updatelocal_url	oncreate
1295	auth_cas	field_updateremote_url	0
1296	auth_cas	field_lock_url	unlocked
1297	auth_cas	field_map_idnumber	
1298	auth_cas	field_updatelocal_idnumber	oncreate
1299	auth_cas	field_updateremote_idnumber	0
1300	auth_cas	field_lock_idnumber	unlocked
1301	auth_cas	field_map_institution	
1302	auth_cas	field_updatelocal_institution	oncreate
1303	auth_cas	field_updateremote_institution	0
1304	auth_cas	field_lock_institution	unlocked
1305	auth_cas	field_map_department	
1306	auth_cas	field_updatelocal_department	oncreate
1307	auth_cas	field_updateremote_department	0
1308	auth_cas	field_lock_department	unlocked
1309	auth_cas	field_map_phone1	
1310	auth_cas	field_updatelocal_phone1	oncreate
1311	auth_cas	field_updateremote_phone1	0
1312	auth_cas	field_lock_phone1	unlocked
1313	auth_cas	field_map_phone2	
1314	auth_cas	field_updatelocal_phone2	oncreate
1315	auth_cas	field_updateremote_phone2	0
1316	auth_cas	field_lock_phone2	unlocked
1317	auth_cas	field_map_address	
1318	auth_cas	field_updatelocal_address	oncreate
1319	auth_cas	field_updateremote_address	0
1320	auth_cas	field_lock_address	unlocked
1321	auth_cas	field_map_firstnamephonetic	
1322	auth_cas	field_updatelocal_firstnamephonetic	oncreate
1323	auth_cas	field_updateremote_firstnamephonetic	0
1324	auth_cas	field_lock_firstnamephonetic	unlocked
1325	auth_cas	field_map_lastnamephonetic	
1326	auth_cas	field_updatelocal_lastnamephonetic	oncreate
1327	auth_cas	field_updateremote_lastnamephonetic	0
1328	auth_cas	field_lock_lastnamephonetic	unlocked
1329	auth_cas	field_map_middlename	
1330	auth_cas	field_updatelocal_middlename	oncreate
1331	auth_cas	field_updateremote_middlename	0
1332	auth_cas	field_lock_middlename	unlocked
1333	auth_cas	field_map_alternatename	
1334	auth_cas	field_updatelocal_alternatename	oncreate
1335	auth_cas	field_updateremote_alternatename	0
1336	auth_cas	field_lock_alternatename	unlocked
1337	auth_email	recaptcha	0
1338	auth_email	field_lock_firstname	unlocked
1339	auth_email	field_lock_lastname	unlocked
1340	auth_email	field_lock_email	unlocked
1341	auth_email	field_lock_city	unlocked
1342	auth_email	field_lock_country	unlocked
1343	auth_email	field_lock_lang	unlocked
1344	auth_email	field_lock_description	unlocked
1345	auth_email	field_lock_url	unlocked
1346	auth_email	field_lock_idnumber	unlocked
1347	auth_email	field_lock_institution	unlocked
1348	auth_email	field_lock_department	unlocked
1349	auth_email	field_lock_phone1	unlocked
1350	auth_email	field_lock_phone2	unlocked
1351	auth_email	field_lock_address	unlocked
1352	auth_email	field_lock_firstnamephonetic	unlocked
1353	auth_email	field_lock_lastnamephonetic	unlocked
1354	auth_email	field_lock_middlename	unlocked
1355	auth_email	field_lock_alternatename	unlocked
1356	auth_db	host	127.0.0.1
1357	auth_db	type	mysqli
1358	auth_db	sybasequoting	0
1359	auth_db	name	
1360	auth_db	user	
1361	auth_db	pass	
1362	auth_db	table	
1363	auth_db	fielduser	
1364	auth_db	fieldpass	
1365	auth_db	passtype	plaintext
1366	auth_db	extencoding	utf-8
1367	auth_db	setupsql	
1368	auth_db	debugauthdb	0
1369	auth_db	changepasswordurl	
1370	auth_db	removeuser	0
1371	auth_db	updateusers	0
1372	auth_db	field_map_firstname	
1373	auth_db	field_updatelocal_firstname	oncreate
1374	auth_db	field_updateremote_firstname	0
1375	auth_db	field_lock_firstname	unlocked
1376	auth_db	field_map_lastname	
1377	auth_db	field_updatelocal_lastname	oncreate
1378	auth_db	field_updateremote_lastname	0
1379	auth_db	field_lock_lastname	unlocked
1380	auth_db	field_map_email	
1381	auth_db	field_updatelocal_email	oncreate
1382	auth_db	field_updateremote_email	0
1383	auth_db	field_lock_email	unlocked
1384	auth_db	field_map_city	
1385	auth_db	field_updatelocal_city	oncreate
1386	auth_db	field_updateremote_city	0
1387	auth_db	field_lock_city	unlocked
1388	auth_db	field_map_country	
1389	auth_db	field_updatelocal_country	oncreate
1390	auth_db	field_updateremote_country	0
1391	auth_db	field_lock_country	unlocked
1392	auth_db	field_map_lang	
1393	auth_db	field_updatelocal_lang	oncreate
1394	auth_db	field_updateremote_lang	0
1395	auth_db	field_lock_lang	unlocked
1396	auth_db	field_map_description	
1397	auth_db	field_updatelocal_description	oncreate
1398	auth_db	field_updateremote_description	0
1399	auth_db	field_lock_description	unlocked
1400	auth_db	field_map_url	
1401	auth_db	field_updatelocal_url	oncreate
1402	auth_db	field_updateremote_url	0
1403	auth_db	field_lock_url	unlocked
1404	auth_db	field_map_idnumber	
1405	auth_db	field_updatelocal_idnumber	oncreate
1406	auth_db	field_updateremote_idnumber	0
1407	auth_db	field_lock_idnumber	unlocked
1408	auth_db	field_map_institution	
1409	auth_db	field_updatelocal_institution	oncreate
1410	auth_db	field_updateremote_institution	0
1411	auth_db	field_lock_institution	unlocked
1412	auth_db	field_map_department	
1413	auth_db	field_updatelocal_department	oncreate
1414	auth_db	field_updateremote_department	0
1415	auth_db	field_lock_department	unlocked
1416	auth_db	field_map_phone1	
1417	auth_db	field_updatelocal_phone1	oncreate
1418	auth_db	field_updateremote_phone1	0
1419	auth_db	field_lock_phone1	unlocked
1420	auth_db	field_map_phone2	
1421	auth_db	field_updatelocal_phone2	oncreate
1422	auth_db	field_updateremote_phone2	0
1423	auth_db	field_lock_phone2	unlocked
1424	auth_db	field_map_address	
1425	auth_db	field_updatelocal_address	oncreate
1426	auth_db	field_updateremote_address	0
1427	auth_db	field_lock_address	unlocked
1428	auth_db	field_map_firstnamephonetic	
1429	auth_db	field_updatelocal_firstnamephonetic	oncreate
1430	auth_db	field_updateremote_firstnamephonetic	0
1431	auth_db	field_lock_firstnamephonetic	unlocked
1432	auth_db	field_map_lastnamephonetic	
1433	auth_db	field_updatelocal_lastnamephonetic	oncreate
1434	auth_db	field_updateremote_lastnamephonetic	0
1435	auth_db	field_lock_lastnamephonetic	unlocked
1436	auth_db	field_map_middlename	
1437	auth_db	field_updatelocal_middlename	oncreate
1438	auth_db	field_updateremote_middlename	0
1439	auth_db	field_lock_middlename	unlocked
1440	auth_db	field_map_alternatename	
1441	auth_db	field_updatelocal_alternatename	oncreate
1442	auth_db	field_updateremote_alternatename	0
1443	auth_db	field_lock_alternatename	unlocked
1444	auth_ldap	field_map_firstname	
1445	auth_ldap	field_updatelocal_firstname	oncreate
1446	auth_ldap	field_updateremote_firstname	0
1447	auth_ldap	field_lock_firstname	unlocked
1448	auth_ldap	field_map_lastname	
1449	auth_ldap	field_updatelocal_lastname	oncreate
1450	auth_ldap	field_updateremote_lastname	0
1451	auth_ldap	field_lock_lastname	unlocked
1452	auth_ldap	field_map_email	
1453	auth_ldap	field_updatelocal_email	oncreate
1454	auth_ldap	field_updateremote_email	0
1455	auth_ldap	field_lock_email	unlocked
1456	auth_ldap	field_map_city	
1457	auth_ldap	field_updatelocal_city	oncreate
1458	auth_ldap	field_updateremote_city	0
1459	auth_ldap	field_lock_city	unlocked
1460	auth_ldap	field_map_country	
1461	auth_ldap	field_updatelocal_country	oncreate
1462	auth_ldap	field_updateremote_country	0
1463	auth_ldap	field_lock_country	unlocked
1464	auth_ldap	field_map_lang	
1465	auth_ldap	field_updatelocal_lang	oncreate
1466	auth_ldap	field_updateremote_lang	0
1467	auth_ldap	field_lock_lang	unlocked
1468	auth_ldap	field_map_description	
1469	auth_ldap	field_updatelocal_description	oncreate
1470	auth_ldap	field_updateremote_description	0
1471	auth_ldap	field_lock_description	unlocked
1472	auth_ldap	field_map_url	
1473	auth_ldap	field_updatelocal_url	oncreate
1474	auth_ldap	field_updateremote_url	0
1475	auth_ldap	field_lock_url	unlocked
1476	auth_ldap	field_map_idnumber	
1477	auth_ldap	field_updatelocal_idnumber	oncreate
1478	auth_ldap	field_updateremote_idnumber	0
1479	auth_ldap	field_lock_idnumber	unlocked
1480	auth_ldap	field_map_institution	
1481	auth_ldap	field_updatelocal_institution	oncreate
1482	auth_ldap	field_updateremote_institution	0
1483	auth_ldap	field_lock_institution	unlocked
1484	auth_ldap	field_map_department	
1485	auth_ldap	field_updatelocal_department	oncreate
1486	auth_ldap	field_updateremote_department	0
1487	auth_ldap	field_lock_department	unlocked
1488	auth_ldap	field_map_phone1	
1489	auth_ldap	field_updatelocal_phone1	oncreate
1490	auth_ldap	field_updateremote_phone1	0
1491	auth_ldap	field_lock_phone1	unlocked
1492	auth_ldap	field_map_phone2	
1493	auth_ldap	field_updatelocal_phone2	oncreate
1494	auth_ldap	field_updateremote_phone2	0
1495	auth_ldap	field_lock_phone2	unlocked
1496	auth_ldap	field_map_address	
1497	auth_ldap	field_updatelocal_address	oncreate
1498	auth_ldap	field_updateremote_address	0
1499	auth_ldap	field_lock_address	unlocked
1500	auth_ldap	field_map_firstnamephonetic	
1501	auth_ldap	field_updatelocal_firstnamephonetic	oncreate
1502	auth_ldap	field_updateremote_firstnamephonetic	0
1503	auth_ldap	field_lock_firstnamephonetic	unlocked
1504	auth_ldap	field_map_lastnamephonetic	
1505	auth_ldap	field_updatelocal_lastnamephonetic	oncreate
1506	auth_ldap	field_updateremote_lastnamephonetic	0
1507	auth_ldap	field_lock_lastnamephonetic	unlocked
1508	auth_ldap	field_map_middlename	
1509	auth_ldap	field_updatelocal_middlename	oncreate
1510	auth_ldap	field_updateremote_middlename	0
1511	auth_ldap	field_lock_middlename	unlocked
1512	auth_ldap	field_map_alternatename	
1513	auth_ldap	field_updatelocal_alternatename	oncreate
1514	auth_ldap	field_updateremote_alternatename	0
1515	auth_ldap	field_lock_alternatename	unlocked
1516	auth_manual	expiration	0
1517	auth_manual	expirationtime	30
1518	auth_manual	expiration_warning	0
1519	auth_manual	field_lock_firstname	unlocked
1520	auth_manual	field_lock_lastname	unlocked
1521	auth_manual	field_lock_email	unlocked
1522	auth_manual	field_lock_city	unlocked
1523	auth_manual	field_lock_country	unlocked
1524	auth_manual	field_lock_lang	unlocked
1525	auth_manual	field_lock_description	unlocked
1526	auth_manual	field_lock_url	unlocked
1527	auth_manual	field_lock_idnumber	unlocked
1528	auth_manual	field_lock_institution	unlocked
1529	auth_manual	field_lock_department	unlocked
1530	auth_manual	field_lock_phone1	unlocked
1531	auth_manual	field_lock_phone2	unlocked
1532	auth_manual	field_lock_address	unlocked
1533	auth_manual	field_lock_firstnamephonetic	unlocked
1534	auth_manual	field_lock_lastnamephonetic	unlocked
1535	auth_manual	field_lock_middlename	unlocked
1536	auth_manual	field_lock_alternatename	unlocked
1537	auth_mnet	rpc_negotiation_timeout	30
1538	auth_none	field_lock_firstname	unlocked
1539	auth_none	field_lock_lastname	unlocked
1540	auth_none	field_lock_email	unlocked
1541	auth_none	field_lock_city	unlocked
1542	auth_none	field_lock_country	unlocked
1543	auth_none	field_lock_lang	unlocked
1544	auth_none	field_lock_description	unlocked
1545	auth_none	field_lock_url	unlocked
1546	auth_none	field_lock_idnumber	unlocked
1547	auth_none	field_lock_institution	unlocked
1548	auth_none	field_lock_department	unlocked
1549	auth_none	field_lock_phone1	unlocked
1550	auth_none	field_lock_phone2	unlocked
1551	auth_none	field_lock_address	unlocked
1552	auth_none	field_lock_firstnamephonetic	unlocked
1553	auth_none	field_lock_lastnamephonetic	unlocked
1554	auth_none	field_lock_middlename	unlocked
1555	auth_none	field_lock_alternatename	unlocked
1556	auth_oauth2	field_lock_firstname	unlocked
1557	auth_oauth2	field_lock_lastname	unlocked
1558	auth_oauth2	field_lock_email	unlocked
1559	auth_oauth2	field_lock_city	unlocked
1560	auth_oauth2	field_lock_country	unlocked
1561	auth_oauth2	field_lock_lang	unlocked
1562	auth_oauth2	field_lock_description	unlocked
1563	auth_oauth2	field_lock_url	unlocked
1564	auth_oauth2	field_lock_idnumber	unlocked
1565	auth_oauth2	field_lock_institution	unlocked
1566	auth_oauth2	field_lock_department	unlocked
1567	auth_oauth2	field_lock_phone1	unlocked
1568	auth_oauth2	field_lock_phone2	unlocked
1569	auth_oauth2	field_lock_address	unlocked
1570	auth_oauth2	field_lock_firstnamephonetic	unlocked
1571	auth_oauth2	field_lock_lastnamephonetic	unlocked
1572	auth_oauth2	field_lock_middlename	unlocked
1573	auth_oauth2	field_lock_alternatename	unlocked
1574	auth_shibboleth	user_attribute	
1575	auth_shibboleth	convert_data	
1576	auth_shibboleth	alt_login	off
1577	auth_shibboleth	organization_selection	urn:mace:organization1:providerID, Example Organization 1\n        https://another.idp-id.com/shibboleth, Other Example Organization, /Shibboleth.sso/DS/SWITCHaai\n        urn:mace:organization2:providerID, Example Organization 2, /Shibboleth.sso/WAYF/SWITCHaai
1578	auth_shibboleth	logout_handler	
1579	auth_shibboleth	logout_return_url	
1580	auth_shibboleth	login_name	Shibboleth Login
1581	auth_shibboleth	auth_logo	
1582	auth_shibboleth	auth_instructions	Use the <a href="https://arrupe.ac.zw/acis/lms/auth/shibboleth/index.php">Shibboleth login</a> to get access via Shibboleth, if your institution supports it. Otherwise, use the normal login form shown here.
1583	auth_shibboleth	changepasswordurl	
1584	auth_shibboleth	field_map_firstname	
1585	auth_shibboleth	field_updatelocal_firstname	oncreate
1586	auth_shibboleth	field_lock_firstname	unlocked
1587	auth_shibboleth	field_map_lastname	
1588	auth_shibboleth	field_updatelocal_lastname	oncreate
1589	auth_shibboleth	field_lock_lastname	unlocked
1590	auth_shibboleth	field_map_email	
1591	auth_shibboleth	field_updatelocal_email	oncreate
1592	auth_shibboleth	field_lock_email	unlocked
1593	auth_shibboleth	field_map_city	
1594	auth_shibboleth	field_updatelocal_city	oncreate
1595	auth_shibboleth	field_lock_city	unlocked
1596	auth_shibboleth	field_map_country	
1597	auth_shibboleth	field_updatelocal_country	oncreate
1598	auth_shibboleth	field_lock_country	unlocked
1599	auth_shibboleth	field_map_lang	
1600	auth_shibboleth	field_updatelocal_lang	oncreate
1601	auth_shibboleth	field_lock_lang	unlocked
1602	auth_shibboleth	field_map_description	
1603	auth_shibboleth	field_updatelocal_description	oncreate
1604	auth_shibboleth	field_lock_description	unlocked
1605	auth_shibboleth	field_map_url	
1606	auth_shibboleth	field_updatelocal_url	oncreate
1607	auth_shibboleth	field_lock_url	unlocked
1608	auth_shibboleth	field_map_idnumber	
1609	auth_shibboleth	field_updatelocal_idnumber	oncreate
1610	auth_shibboleth	field_lock_idnumber	unlocked
1611	auth_shibboleth	field_map_institution	
1612	auth_shibboleth	field_updatelocal_institution	oncreate
1613	auth_shibboleth	field_lock_institution	unlocked
1614	auth_shibboleth	field_map_department	
1615	auth_shibboleth	field_updatelocal_department	oncreate
1616	auth_shibboleth	field_lock_department	unlocked
1617	auth_shibboleth	field_map_phone1	
1618	auth_shibboleth	field_updatelocal_phone1	oncreate
1619	auth_shibboleth	field_lock_phone1	unlocked
1620	auth_shibboleth	field_map_phone2	
1621	auth_shibboleth	field_updatelocal_phone2	oncreate
1622	auth_shibboleth	field_lock_phone2	unlocked
1623	auth_shibboleth	field_map_address	
1624	auth_shibboleth	field_updatelocal_address	oncreate
1625	auth_shibboleth	field_lock_address	unlocked
1626	auth_shibboleth	field_map_firstnamephonetic	
1627	auth_shibboleth	field_updatelocal_firstnamephonetic	oncreate
1628	auth_shibboleth	field_lock_firstnamephonetic	unlocked
1629	auth_shibboleth	field_map_lastnamephonetic	
1630	auth_shibboleth	field_updatelocal_lastnamephonetic	oncreate
1631	auth_shibboleth	field_lock_lastnamephonetic	unlocked
1632	auth_shibboleth	field_map_middlename	
1633	auth_shibboleth	field_updatelocal_middlename	oncreate
1634	auth_shibboleth	field_lock_middlename	unlocked
1635	auth_shibboleth	field_map_alternatename	
1636	auth_shibboleth	field_updatelocal_alternatename	oncreate
1637	auth_shibboleth	field_lock_alternatename	unlocked
1638	block_activity_results	config_showbest	3
1639	block_activity_results	config_showbest_locked	
1640	block_activity_results	config_showworst	0
1641	block_activity_results	config_showworst_locked	
1642	block_activity_results	config_usegroups	0
1643	block_activity_results	config_usegroups_locked	
1644	block_activity_results	config_nameformat	1
1645	block_activity_results	config_nameformat_locked	
1646	block_activity_results	config_gradeformat	1
1647	block_activity_results	config_gradeformat_locked	
1648	block_activity_results	config_decimalpoints	2
1649	block_activity_results	config_decimalpoints_locked	
1650	block_myoverview	displaycategories	1
1651	block_myoverview	layouts	card,list,summary
1652	block_myoverview	displaygroupingallincludinghidden	0
1653	block_myoverview	displaygroupingall	1
1654	block_myoverview	displaygroupinginprogress	1
1655	block_myoverview	displaygroupingpast	1
1656	block_myoverview	displaygroupingfuture	1
1657	block_myoverview	displaygroupingcustomfield	0
1658	block_myoverview	customfiltergrouping	
1659	block_myoverview	displaygroupingfavourites	1
1660	block_myoverview	displaygroupinghidden	1
1661	block_recentlyaccessedcourses	displaycategories	1
1662	block_section_links	numsections1	22
1663	block_section_links	incby1	2
1664	block_section_links	numsections2	40
1665	block_section_links	incby2	5
1666	block_starredcourses	displaycategories	1
1667	block_tag_youtube	apikey	
1668	format_singleactivity	activitytype	forum
1785	enrol_self	expirynotify	0
1669	fileconverter_googledrive	issuerid	
1670	enrol_cohort	roleid	5
1671	enrol_cohort	unenrolaction	0
1672	enrol_meta	nosyncroleids	
1673	enrol_meta	syncall	1
1674	enrol_meta	unenrolaction	3
1675	enrol_meta	coursesort	sortorder
1676	enrol_database	dbtype	
1677	enrol_database	dbhost	localhost
1678	enrol_database	dbuser	
1679	enrol_database	dbpass	
1680	enrol_database	dbname	
1681	enrol_database	dbencoding	utf-8
1682	enrol_database	dbsetupsql	
1683	enrol_database	dbsybasequoting	0
1684	enrol_database	debugdb	0
1685	enrol_database	localcoursefield	idnumber
1686	enrol_database	localuserfield	idnumber
1687	enrol_database	localrolefield	shortname
1688	enrol_database	localcategoryfield	id
1689	enrol_database	remoteenroltable	
1690	enrol_database	remotecoursefield	
1691	enrol_database	remoteuserfield	
1692	enrol_database	remoterolefield	
1693	enrol_database	remoteotheruserfield	
1694	enrol_database	defaultrole	5
1695	enrol_database	ignorehiddencourses	0
1696	enrol_database	unenrolaction	0
1697	enrol_database	newcoursetable	
1698	enrol_database	newcoursefullname	fullname
1699	enrol_database	newcourseshortname	shortname
1700	enrol_database	newcourseidnumber	idnumber
1701	enrol_database	newcoursecategory	
1702	enrol_database	defaultcategory	1
1703	enrol_database	templatecourse	
1704	enrol_flatfile	location	
1705	enrol_flatfile	encoding	UTF-8
1706	enrol_flatfile	mailstudents	0
1707	enrol_flatfile	mailteachers	0
1708	enrol_flatfile	mailadmins	0
1709	enrol_flatfile	unenrolaction	3
1710	enrol_flatfile	expiredaction	3
1711	enrol_guest	requirepassword	0
1712	enrol_guest	usepasswordpolicy	0
1713	enrol_guest	showhint	0
1714	enrol_guest	defaultenrol	1
1715	enrol_guest	status	1
1716	enrol_guest	status_adv	
1717	enrol_imsenterprise	imsfilelocation	
1718	enrol_imsenterprise	logtolocation	
1719	enrol_imsenterprise	mailadmins	0
1720	enrol_imsenterprise	createnewusers	0
1721	enrol_imsenterprise	imsupdateusers	0
1722	enrol_imsenterprise	imsdeleteusers	0
1723	enrol_imsenterprise	fixcaseusernames	0
1724	enrol_imsenterprise	fixcasepersonalnames	0
1725	enrol_imsenterprise	imssourcedidfallback	0
1726	enrol_imsenterprise	imsrolemap01	5
1727	enrol_imsenterprise	imsrolemap02	3
1728	enrol_imsenterprise	imsrolemap03	3
1729	enrol_imsenterprise	imsrolemap04	5
1730	enrol_imsenterprise	imsrolemap05	0
1731	enrol_imsenterprise	imsrolemap06	4
1732	enrol_imsenterprise	imsrolemap07	0
1733	enrol_imsenterprise	imsrolemap08	4
1734	enrol_imsenterprise	truncatecoursecodes	0
1735	enrol_imsenterprise	createnewcourses	0
1736	enrol_imsenterprise	updatecourses	0
1737	enrol_imsenterprise	createnewcategories	0
1738	enrol_imsenterprise	nestedcategories	0
1739	enrol_imsenterprise	categoryidnumber	0
1740	enrol_imsenterprise	categoryseparator	
1741	enrol_imsenterprise	imsunenrol	0
1742	enrol_imsenterprise	imscoursemapshortname	coursecode
1743	enrol_imsenterprise	imscoursemapfullname	short
1744	enrol_imsenterprise	imscoursemapsummary	ignore
1745	enrol_imsenterprise	imsrestricttarget	
1746	enrol_imsenterprise	imscapitafix	0
1747	enrol_manual	expiredaction	1
1748	enrol_manual	expirynotifyhour	6
1749	enrol_manual	defaultenrol	1
1750	enrol_manual	status	0
1751	enrol_manual	roleid	5
1752	enrol_manual	enrolstart	4
1753	enrol_manual	enrolperiod	0
1754	enrol_manual	expirynotify	0
1755	enrol_manual	expirythreshold	86400
1756	enrol_mnet	roleid	5
1757	enrol_mnet	roleid_adv	1
1758	enrol_paypal	paypalbusiness	
1759	enrol_paypal	mailstudents	0
1760	enrol_paypal	mailteachers	0
1761	enrol_paypal	mailadmins	0
1762	enrol_paypal	expiredaction	3
1763	enrol_paypal	status	1
1764	enrol_paypal	cost	0
1765	enrol_paypal	currency	USD
1766	enrol_paypal	roleid	5
1767	enrol_paypal	enrolperiod	0
1768	enrol_lti	emaildisplay	2
1769	enrol_lti	city	
1770	enrol_lti	country	
1771	enrol_lti	timezone	99
1772	enrol_lti	lang	en
1773	enrol_lti	institution	
1774	enrol_self	requirepassword	0
1775	enrol_self	usepasswordpolicy	0
1776	enrol_self	showhint	0
1777	enrol_self	expiredaction	1
1778	enrol_self	expirynotifyhour	6
1779	enrol_self	defaultenrol	1
1780	enrol_self	status	1
1781	enrol_self	newenrols	1
1782	enrol_self	groupkey	0
1783	enrol_self	roleid	5
1784	enrol_self	enrolperiod	0
1786	enrol_self	expirythreshold	86400
1787	enrol_self	longtimenosee	0
1788	enrol_self	maxenrolled	0
1789	enrol_self	sendcoursewelcomemessage	1
1790	filter_urltolink	formats	1,4,0
1791	filter_urltolink	embedimages	1
1792	filter_emoticon	formats	1,4,0
1793	filter_displayh5p	allowedsources	
1794	filter_mathjaxloader	httpsurl	https://cdn.jsdelivr.net/npm/mathjax@2.7.8/MathJax.js
1795	filter_mathjaxloader	texfiltercompatibility	0
1796	filter_mathjaxloader	mathjaxconfig	\nMathJax.Hub.Config({\n    config: ["Accessible.js", "Safe.js"],\n    errorSettings: { message: ["!"] },\n    skipStartupTypeset: true,\n    messageStyle: "none"\n});\n
1797	filter_mathjaxloader	additionaldelimiters	
1798	filter_tex	latexpreamble	\\usepackage[latin1]{inputenc}\n\\usepackage{amsmath}\n\\usepackage{amsfonts}\n\\RequirePackage{amsmath,amssymb,latexsym}\n
1799	filter_tex	latexbackground	#FFFFFF
1800	filter_tex	density	120
1801	filter_tex	pathlatex	/usr/bin/latex
1802	filter_tex	pathdvips	/usr/bin/dvips
1803	filter_tex	pathconvert	/usr/bin/convert
1804	filter_tex	pathdvisvgm	/usr/bin/dvisvgm
1805	filter_tex	pathmimetex	
1806	filter_tex	convertformat	gif
1807	logstore_database	dbdriver	
1808	logstore_database	dbhost	
1809	logstore_database	dbuser	
1810	logstore_database	dbpass	
1811	logstore_database	dbname	
1812	logstore_database	dbtable	
1813	logstore_database	dbpersist	0
1814	logstore_database	dbsocket	
1815	logstore_database	dbport	
1816	logstore_database	dbschema	
1817	logstore_database	dbcollation	
1818	logstore_database	dbhandlesoptions	0
1819	logstore_database	buffersize	50
1820	logstore_database	jsonformat	1
1821	logstore_database	logguests	0
1822	logstore_database	includelevels	1,2,0
1823	logstore_database	includeactions	c,r,u,d
1824	logstore_legacy	loglegacy	0
1825	logstore_standard	logguests	1
1826	logstore_standard	jsonformat	1
1827	logstore_standard	loglifetime	0
1828	logstore_standard	buffersize	50
1829	mlbackend_python	useserver	0
1830	mlbackend_python	host	
1831	mlbackend_python	port	0
1832	mlbackend_python	secure	0
1833	mlbackend_python	username	default
1834	mlbackend_python	password	
1835	media_videojs	videoextensions	html_video,media_source,.f4v,.flv
1836	media_videojs	audioextensions	html_audio
1837	media_videojs	rtmp	0
1838	media_videojs	useflash	0
1839	media_videojs	youtube	1
1840	media_videojs	videocssclass	video-js
1841	media_videojs	audiocssclass	video-js
1842	media_videojs	limitsize	1
1843	qtype_multichoice	answerhowmany	1
1844	qtype_multichoice	shuffleanswers	1
1845	qtype_multichoice	answernumbering	abc
1846	editor_atto	toolbar	collapse = collapse\nstyle1 = title, bold, italic\nlist = unorderedlist, orderedlist, indent\nlinks = link\nfiles = emojipicker, image, media, recordrtc, managefiles, h5p\nstyle2 = underline, strike, subscript, superscript\nalign = align\ninsert = equation, charmap, table, clear\nundo = undo\naccessibility = accessibilitychecker, accessibilityhelper\nother = html
1847	editor_atto	autosavefrequency	60
1848	atto_collapse	showgroups	5
1849	atto_equation	librarygroup1	\n\\cdot\n\\times\n\\ast\n\\div\n\\diamond\n\\pm\n\\mp\n\\oplus\n\\ominus\n\\otimes\n\\oslash\n\\odot\n\\circ\n\\bullet\n\\asymp\n\\equiv\n\\subseteq\n\\supseteq\n\\leq\n\\geq\n\\preceq\n\\succeq\n\\sim\n\\simeq\n\\approx\n\\subset\n\\supset\n\\ll\n\\gg\n\\prec\n\\succ\n\\infty\n\\in\n\\ni\n\\forall\n\\exists\n\\neq\n
1850	atto_equation	librarygroup2	\n\\leftarrow\n\\rightarrow\n\\uparrow\n\\downarrow\n\\leftrightarrow\n\\nearrow\n\\searrow\n\\swarrow\n\\nwarrow\n\\Leftarrow\n\\Rightarrow\n\\Uparrow\n\\Downarrow\n\\Leftrightarrow\n
1851	atto_equation	librarygroup3	\n\\alpha\n\\beta\n\\gamma\n\\delta\n\\epsilon\n\\zeta\n\\eta\n\\theta\n\\iota\n\\kappa\n\\lambda\n\\mu\n\\nu\n\\xi\n\\pi\n\\rho\n\\sigma\n\\tau\n\\upsilon\n\\phi\n\\chi\n\\psi\n\\omega\n\\Gamma\n\\Delta\n\\Theta\n\\Lambda\n\\Xi\n\\Pi\n\\Sigma\n\\Upsilon\n\\Phi\n\\Psi\n\\Omega\n
1852	atto_equation	librarygroup4	\n\\sum{a,b}\n\\sqrt[a]{b+c}\n\\int_{a}^{b}{c}\n\\iint_{a}^{b}{c}\n\\iiint_{a}^{b}{c}\n\\oint{a}\n(a)\n[a]\n\\lbrace{a}\\rbrace\n\\left| \\begin{matrix} a_1 & a_2 \\ a_3 & a_4 \\end{matrix} \\right|\n\\frac{a}{b+c}\n\\vec{a}\n\\binom {a} {b}\n{a \\brack b}\n{a \\brace b}\n
1853	atto_recordrtc	allowedtypes	both
1854	atto_recordrtc	audiobitrate	128000
1855	atto_recordrtc	videobitrate	2500000
1856	atto_recordrtc	timelimit	120
1857	atto_table	allowborders	0
1858	atto_table	allowbackgroundcolour	0
1859	atto_table	allowwidth	0
1860	editor_tinymce	customtoolbar	wrap,formatselect,wrap,bold,italic,wrap,bullist,numlist,wrap,link,unlink,wrap,image\n\nundo,redo,wrap,underline,strikethrough,sub,sup,wrap,justifyleft,justifycenter,justifyright,wrap,outdent,indent,wrap,forecolor,backcolor,wrap,ltr,rtl\n\nfontselect,fontsizeselect,wrap,code,search,replace,wrap,nonbreaking,charmap,table,wrap,cleanup,removeformat,pastetext,pasteword,wrap,fullscreen
1861	editor_tinymce	fontselectlist	Trebuchet=Trebuchet MS,Verdana,Arial,Helvetica,sans-serif;Arial=arial,helvetica,sans-serif;Courier New=courier new,courier,monospace;Georgia=georgia,times new roman,times,serif;Tahoma=tahoma,arial,helvetica,sans-serif;Times New Roman=times new roman,times,serif;Verdana=verdana,arial,helvetica,sans-serif;Impact=impact;Wingdings=wingdings
1862	editor_tinymce	customconfig	
1863	tinymce_moodleemoticon	requireemoticon	1
1864	tinymce_spellchecker	spellengine	
1865	tinymce_spellchecker	spelllanguagelist	+English=en,Danish=da,Dutch=nl,Finnish=fi,French=fr,German=de,Italian=it,Polish=pl,Portuguese=pt,Spanish=es,Swedish=sv
1866	tool_mobile	apppolicy	
1867	tool_mobile	typeoflogin	1
1868	tool_mobile	qrcodetype	2
1869	tool_mobile	forcedurlscheme	moodlemobile
1870	tool_mobile	minimumversion	
1871	tool_mobile	enablesmartappbanners	0
1872	tool_mobile	iosappid	633359593
1873	tool_mobile	androidappid	com.moodle.moodlemobile
1874	tool_mobile	setuplink	https://download.moodle.org/mobile
1875	tool_mobile	forcelogout	0
1876	tool_mobile	disabledfeatures	
1877	tool_mobile	custommenuitems	
1878	tool_mobile	customlangstrings	
1879	tool_moodlenet	enablemoodlenet	0
1880	tool_moodlenet	defaultmoodlenetname	MoodleNet Central
1881	tool_moodlenet	defaultmoodlenet	https://moodle.net
\.


--
-- Data for Name: mdl_contentbank_content; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_contentbank_content (id, name, contenttype, contextid, instanceid, configdata, usercreated, usermodified, timecreated, timemodified) FROM stdin;
\.


--
-- Data for Name: mdl_context; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_context (id, contextlevel, instanceid, path, depth, locked) FROM stdin;
1	10	0	/1	1	0
2	50	1	/1/2	2	0
3	40	1	/1/3	2	0
4	30	1	/1/4	2	0
5	30	2	/1/5	2	0
6	80	1	/1/6	2	0
7	80	2	/1/7	2	0
8	80	3	/1/8	2	0
9	80	4	/1/9	2	0
10	80	5	/1/10	2	0
11	80	6	/1/11	2	0
12	80	7	/1/12	2	0
13	80	8	/1/13	2	0
14	80	9	/1/14	2	0
15	80	10	/1/15	2	0
16	80	11	/1/5/16	3	0
17	80	12	/1/5/17	3	0
18	80	13	/1/5/18	3	0
19	80	14	/1/5/19	3	0
20	80	15	/1/5/20	3	0
21	80	16	/1/5/21	3	0
22	80	17	/1/5/22	3	0
23	80	18	/1/5/23	3	0
24	80	19	/1/5/24	3	0
\.


--
-- Data for Name: mdl_context_temp; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_context_temp (id, path, depth, locked) FROM stdin;
\.


--
-- Data for Name: mdl_course; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_course (id, category, sortorder, fullname, shortname, idnumber, summary, summaryformat, format, showgrades, newsitems, startdate, enddate, relativedatesmode, marker, maxbytes, legacyfiles, showreports, visible, visibleold, groupmode, groupmodeforce, defaultgroupingid, lang, calendartype, theme, timecreated, timemodified, requested, enablecompletion, completionnotify, cacherev) FROM stdin;
1	0	0	acisc	aci			0	site	1	3	0	0	0	0	0	0	0	1	1	0	0	0				1597315726	1597315946	0	0	0	1606304223
\.


--
-- Data for Name: mdl_course_categories; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_course_categories (id, name, idnumber, description, descriptionformat, parent, sortorder, coursecount, visible, visibleold, timemodified, depth, path, theme) FROM stdin;
1	Miscellaneous	\N	\N	0	0	10000	0	1	1	1597315726	1	/1	\N
\.


--
-- Data for Name: mdl_course_completion_aggr_methd; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_course_completion_aggr_methd (id, course, criteriatype, method, value) FROM stdin;
\.


--
-- Data for Name: mdl_course_completion_crit_compl; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_course_completion_crit_compl (id, userid, course, criteriaid, gradefinal, unenroled, timecompleted) FROM stdin;
\.


--
-- Data for Name: mdl_course_completion_criteria; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_course_completion_criteria (id, course, criteriatype, module, moduleinstance, courseinstance, enrolperiod, timeend, gradepass, role) FROM stdin;
\.


--
-- Data for Name: mdl_course_completion_defaults; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_course_completion_defaults (id, course, module, completion, completionview, completionusegrade, completionexpected, customrules) FROM stdin;
\.


--
-- Data for Name: mdl_course_completions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_course_completions (id, userid, course, timeenrolled, timestarted, timecompleted, reaggregate) FROM stdin;
\.


--
-- Data for Name: mdl_course_format_options; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_course_format_options (id, courseid, format, sectionid, name, value) FROM stdin;
1	1	site	0	numsections	1
\.


--
-- Data for Name: mdl_course_modules; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_course_modules (id, course, module, instance, section, idnumber, added, score, indent, visible, visibleoncoursepage, visibleold, groupmode, groupingid, completion, completiongradeitemnumber, completionview, completionexpected, showdescription, availability, deletioninprogress) FROM stdin;
\.


--
-- Data for Name: mdl_course_modules_completion; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_course_modules_completion (id, coursemoduleid, userid, completionstate, viewed, overrideby, timemodified) FROM stdin;
\.


--
-- Data for Name: mdl_course_published; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_course_published (id, huburl, courseid, timepublished, enrollable, hubcourseid, status, timechecked) FROM stdin;
\.


--
-- Data for Name: mdl_course_request; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_course_request (id, fullname, shortname, summary, summaryformat, category, reason, requester, password) FROM stdin;
\.


--
-- Data for Name: mdl_course_sections; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_course_sections (id, course, section, name, summary, summaryformat, sequence, visible, availability, timemodified) FROM stdin;
1	1	1	\N		1		1	\N	1597316759
\.


--
-- Data for Name: mdl_customfield_category; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_customfield_category (id, name, description, descriptionformat, sortorder, timecreated, timemodified, component, area, itemid, contextid) FROM stdin;
\.


--
-- Data for Name: mdl_customfield_data; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_customfield_data (id, fieldid, instanceid, intvalue, decvalue, shortcharvalue, charvalue, value, valueformat, timecreated, timemodified, contextid) FROM stdin;
\.


--
-- Data for Name: mdl_customfield_field; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_customfield_field (id, shortname, name, type, description, descriptionformat, sortorder, categoryid, configdata, timecreated, timemodified) FROM stdin;
\.


--
-- Data for Name: mdl_data; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_data (id, course, name, intro, introformat, comments, timeavailablefrom, timeavailableto, timeviewfrom, timeviewto, requiredentries, requiredentriestoview, maxentries, rssarticles, singletemplate, listtemplate, listtemplateheader, listtemplatefooter, addtemplate, rsstemplate, rsstitletemplate, csstemplate, jstemplate, asearchtemplate, approval, manageapproved, scale, assessed, assesstimestart, assesstimefinish, defaultsort, defaultsortdir, editany, notification, timemodified, config, completionentries) FROM stdin;
\.


--
-- Data for Name: mdl_data_content; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_data_content (id, fieldid, recordid, content, content1, content2, content3, content4) FROM stdin;
\.


--
-- Data for Name: mdl_data_fields; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_data_fields (id, dataid, type, name, description, required, param1, param2, param3, param4, param5, param6, param7, param8, param9, param10) FROM stdin;
\.


--
-- Data for Name: mdl_data_records; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_data_records (id, userid, groupid, dataid, timecreated, timemodified, approved) FROM stdin;
\.


--
-- Data for Name: mdl_editor_atto_autosave; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_editor_atto_autosave (id, elementid, contextid, pagehash, userid, drafttext, draftid, pageinstance, timemodified) FROM stdin;
2	id_summary_editor	2	b87399a88e5fcefdf8d1bd86d57e844cb80bccb6	2		470287724	yui_3_17_2_1_1597354788118_101	1597316785
\.


--
-- Data for Name: mdl_enrol; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_enrol (id, enrol, status, courseid, sortorder, name, enrolperiod, enrolstartdate, enrolenddate, expirynotify, expirythreshold, notifyall, password, cost, currency, roleid, customint1, customint2, customint3, customint4, customint5, customint6, customint7, customint8, customchar1, customchar2, customchar3, customdec1, customdec2, customtext1, customtext2, customtext3, customtext4, timecreated, timemodified) FROM stdin;
\.


--
-- Data for Name: mdl_enrol_flatfile; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_enrol_flatfile (id, action, roleid, userid, courseid, timestart, timeend, timemodified) FROM stdin;
\.


--
-- Data for Name: mdl_enrol_lti_lti2_consumer; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_enrol_lti_lti2_consumer (id, name, consumerkey256, consumerkey, secret, ltiversion, consumername, consumerversion, consumerguid, profile, toolproxy, settings, protected, enabled, enablefrom, enableuntil, lastaccess, created, updated) FROM stdin;
\.


--
-- Data for Name: mdl_enrol_lti_lti2_context; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_enrol_lti_lti2_context (id, consumerid, lticontextkey, type, settings, created, updated) FROM stdin;
\.


--
-- Data for Name: mdl_enrol_lti_lti2_nonce; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_enrol_lti_lti2_nonce (id, consumerid, value, expires) FROM stdin;
\.


--
-- Data for Name: mdl_enrol_lti_lti2_resource_link; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_enrol_lti_lti2_resource_link (id, contextid, consumerid, ltiresourcelinkkey, settings, primaryresourcelinkid, shareapproved, created, updated) FROM stdin;
\.


--
-- Data for Name: mdl_enrol_lti_lti2_share_key; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_enrol_lti_lti2_share_key (id, sharekey, resourcelinkid, autoapprove, expires) FROM stdin;
\.


--
-- Data for Name: mdl_enrol_lti_lti2_tool_proxy; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_enrol_lti_lti2_tool_proxy (id, toolproxykey, consumerid, toolproxy, created, updated) FROM stdin;
\.


--
-- Data for Name: mdl_enrol_lti_lti2_user_result; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_enrol_lti_lti2_user_result (id, resourcelinkid, ltiuserkey, ltiresultsourcedid, created, updated) FROM stdin;
\.


--
-- Data for Name: mdl_enrol_lti_tool_consumer_map; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_enrol_lti_tool_consumer_map (id, toolid, consumerid) FROM stdin;
\.


--
-- Data for Name: mdl_enrol_lti_tools; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_enrol_lti_tools (id, enrolid, contextid, institution, lang, timezone, maxenrolled, maildisplay, city, country, gradesync, gradesynccompletion, membersync, membersyncmode, roleinstructor, rolelearner, secret, timecreated, timemodified) FROM stdin;
\.


--
-- Data for Name: mdl_enrol_lti_users; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_enrol_lti_users (id, userid, toolid, serviceurl, sourceid, consumerkey, consumersecret, membershipsurl, membershipsid, lastgrade, lastaccess, timecreated) FROM stdin;
\.


--
-- Data for Name: mdl_enrol_paypal; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_enrol_paypal (id, business, receiver_email, receiver_id, item_name, courseid, userid, instanceid, memo, tax, option_name1, option_selection1_x, option_name2, option_selection2_x, payment_status, pending_reason, reason_code, txn_id, parent_txn_id, payment_type, timeupdated) FROM stdin;
\.


--
-- Data for Name: mdl_event; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_event (id, name, description, format, categoryid, courseid, groupid, userid, repeatid, component, modulename, instance, type, eventtype, timestart, timeduration, timesort, visible, uuid, sequence, timemodified, subscriptionid, priority, location) FROM stdin;
\.


--
-- Data for Name: mdl_event_subscriptions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_event_subscriptions (id, url, categoryid, courseid, groupid, userid, eventtype, pollinterval, lastupdated, name) FROM stdin;
\.


--
-- Data for Name: mdl_events_handlers; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_events_handlers (id, eventname, component, handlerfile, handlerfunction, schedule, status, internal) FROM stdin;
\.


--
-- Data for Name: mdl_events_queue; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_events_queue (id, eventdata, stackdump, userid, timecreated) FROM stdin;
\.


--
-- Data for Name: mdl_events_queue_handlers; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_events_queue_handlers (id, queuedeventid, handlerid, status, errormessage, timemodified) FROM stdin;
\.


--
-- Data for Name: mdl_external_functions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdl_external_functions (id, name, classname, methodname, classpath, component, capabilities, services) FROM stdin;
1	core_auth_confirm_user	core_auth_external	confirm_user	\N	moodle		\N
2	core_auth_request_password_reset	core_auth_external	request_password_reset	\N	moodle		\N
3	core_auth_is_minor	core_auth_external	is_minor	\N	moodle		\N
4	core_auth_is_age_digital_consent_verification_enabled	core_auth_external	is_age_digital_consent_verification_enabled	\N	moodle		\N
5	core_auth_resend_confirmation_email	core_auth_external	resend_confirmation_email	\N	moodle		\N
6	core_backup_get_async_backup_progress	core_backup_external	get_async_backup_progress	backup/externallib.php	moodle		\N
7	core_backup_get_async_backup_links_backup	core_backup_external	get_async_backup_links_backup	backup/externallib.php	moodle		\N
8	core_backup_get_async_backup_links_restore	core_backup_external	get_async_backup_links_restore	backup/externallib.php	moodle		\N
9	core_backup_get_copy_progress	core_backup_external	get_copy_progress	backup/externallib.php	moodle		\N
10	core_backup_submit_copy_form	core_backup_external	submit_copy_form	backup/externallib.php	moodle		\N
11	core_badges_get_user_badges	core_badges_external	get_user_badges	\N	moodle	moodle/badges:viewotherbadges	moodle_mobile_app
12	core_blog_get_entries	core_blog\\external	get_entries	\N	moodle		moodle_mobile_app
13	core_blog_view_entries	core_blog\\external	view_entries	\N	moodle		moodle_mobile_app
14	core_calendar_get_calendar_monthly_view	core_calendar_external	get_calendar_monthly_view	calendar/externallib.php	moodle		moodle_mobile_app
15	core_calendar_get_calendar_day_view	core_calendar_external	get_calendar_day_view	calendar/externallib.php	moodle		moodle_mobile_app
16	core_calendar_get_calendar_upcoming_view	core_calendar_external	get_calendar_upcoming_view	calendar/externallib.php	moodle		moodle_mobile_app
17	core_calendar_update_event_start_day	core_calendar_external	update_event_start_day	calendar/externallib.php	moodle	moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries	moodle_mobile_app
18	core_calendar_create_calendar_events	core_calendar_external	create_calendar_events	calendar/externallib.php	moodle	moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries	moodle_mobile_app
19	core_calendar_delete_calendar_events	core_calendar_external	delete_calendar_events	calendar/externallib.php	moodle	moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries	moodle_mobile_app
20	core_calendar_get_calendar_events	core_calendar_external	get_calendar_events	calendar/externallib.php	moodle	moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries	moodle_mobile_app
21	core_calendar_get_action_events_by_timesort	core_calendar_external	get_calendar_action_events_by_timesort	calendar/externallib.php	moodle	moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries	moodle_mobile_app
22	core_calendar_get_action_events_by_course	core_calendar_external	get_calendar_action_events_by_course	calendar/externallib.php	moodle	moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries	moodle_mobile_app
23	core_calendar_get_action_events_by_courses	core_calendar_external	get_calendar_action_events_by_courses	calendar/externallib.php	moodle	moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries	moodle_mobile_app
24	core_calendar_get_calendar_event_by_id	core_calendar_external	get_calendar_event_by_id	calendar/externallib.php	moodle	moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries	moodle_mobile_app
25	core_calendar_submit_create_update_form	core_calendar_external	submit_create_update_form	calendar/externallib.php	moodle	moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries	moodle_mobile_app
26	core_calendar_get_calendar_access_information	core_calendar_external	get_calendar_access_information	calendar/externallib.php	moodle		moodle_mobile_app
27	core_calendar_get_allowed_event_types	core_calendar_external	get_allowed_event_types	calendar/externallib.php	moodle		moodle_mobile_app
28	core_calendar_get_timestamps	core_calendar_external	get_timestamps	calendar/externallib.php	moodle		\N
29	core_cohort_add_cohort_members	core_cohort_external	add_cohort_members	cohort/externallib.php	moodle	moodle/cohort:assign	\N
30	core_cohort_create_cohorts	core_cohort_external	create_cohorts	cohort/externallib.php	moodle	moodle/cohort:manage	\N
31	core_cohort_delete_cohort_members	core_cohort_external	delete_cohort_members	cohort/externallib.php	moodle	moodle/cohort:assign	\N
32	core_cohort_delete_cohorts	core_cohort_external	delete_cohorts	cohort/externallib.php	moodle	moodle/cohort:manage	\N
33	core_cohort_get_cohort_members	core_cohort_external	get_cohort_members	cohort/externallib.php	moodle	moodle/cohort:view	\N
34	core_cohort_search_cohorts	core_cohort_external	search_cohorts	cohort/externallib.php	moodle	moodle/cohort:view	\N
35	core_cohort_get_cohorts	core_cohort_external	get_cohorts	cohort/externallib.php	moodle	moodle/cohort:view	\N
36	core_cohort_update_cohorts	core_cohort_external	update_cohorts	cohort/externallib.php	moodle	moodle/cohort:manage	\N
37	core_comment_get_comments	core_comment_external	get_comments	\N	moodle	moodle/comment:view	moodle_mobile_app
38	core_comment_add_comments	core_comment_external	add_comments	\N	moodle		moodle_mobile_app
39	core_comment_delete_comments	core_comment_external	delete_comments	\N	moodle		moodle_mobile_app
40	core_completion_get_activities_completion_status	core_completion_external	get_activities_completion_status	\N	moodle		moodle_mobile_app
41	core_completion_get_course_completion_status	core_completion_external	get_course_completion_status	\N	moodle	report/completion:view	moodle_mobile_app
42	core_completion_mark_course_self_completed	core_completion_external	mark_course_self_completed	\N	moodle		moodle_mobile_app
43	core_completion_update_activity_completion_status_manually	core_completion_external	update_activity_completion_status_manually	\N	moodle		moodle_mobile_app
44	core_completion_override_activity_completion_status	core_completion_external	override_activity_completion_status	\N	moodle	moodle/course:overridecompletion	\N
45	core_course_create_categories	core_course_external	create_categories	course/externallib.php	moodle	moodle/category:manage	\N
46	core_course_create_courses	core_course_external	create_courses	course/externallib.php	moodle	moodle/course:create, moodle/course:visibility	\N
47	core_course_delete_categories	core_course_external	delete_categories	course/externallib.php	moodle	moodle/category:manage	\N
48	core_course_delete_courses	core_course_external	delete_courses	course/externallib.php	moodle	moodle/course:delete	\N
49	core_course_delete_modules	core_course_external	delete_modules	course/externallib.php	moodle	moodle/course:manageactivities	\N
50	core_course_duplicate_course	core_course_external	duplicate_course	course/externallib.php	moodle	moodle/backup:backupcourse, moodle/restore:restorecourse, moodle/course:create	\N
51	core_course_get_categories	core_course_external	get_categories	course/externallib.php	moodle	moodle/category:viewhiddencategories	moodle_mobile_app
52	core_course_get_contents	core_course_external	get_course_contents	course/externallib.php	moodle	moodle/course:update, moodle/course:viewhiddencourses	moodle_mobile_app
53	core_course_get_course_module	core_course_external	get_course_module	course/externallib.php	moodle		moodle_mobile_app
54	core_course_get_course_module_by_instance	core_course_external	get_course_module_by_instance	course/externallib.php	moodle		moodle_mobile_app
55	core_course_get_module	core_course_external	get_module	course/externallib.php	moodle		\N
56	core_course_edit_module	core_course_external	edit_module	course/externallib.php	moodle		\N
57	core_course_edit_section	core_course_external	edit_section	course/externallib.php	moodle		\N
58	core_course_get_courses	core_course_external	get_courses	course/externallib.php	moodle	moodle/course:view, moodle/course:update, moodle/course:viewhiddencourses	moodle_mobile_app
59	core_course_import_course	core_course_external	import_course	course/externallib.php	moodle	moodle/backup:backuptargetimport, moodle/restore:restoretargetimport	\N
60	core_course_search_courses	core_course_external	search_courses	course/externallib.php	moodle		moodle_mobile_app
61	core_course_update_categories	core_course_external	update_categories	course/externallib.php	moodle	moodle/category:manage	\N
62	core_course_update_courses	core_course_external	update_courses	course/externallib.php	moodle	moodle/course:update, moodle/course:changecategory, moodle/course:changefullname, moodle/course:changeshortname, moodle/course:changeidnumber, moodle/course:changesummary, moodle/course:visibility	\N
63	core_course_view_course	core_course_external	view_course	course/externallib.php	moodle		moodle_mobile_app
64	core_course_get_user_navigation_options	core_course_external	get_user_navigation_options	course/externallib.php	moodle		moodle_mobile_app
65	core_course_get_user_administration_options	core_course_external	get_user_administration_options	course/externallib.php	moodle		moodle_mobile_app
66	core_course_get_courses_by_field	core_course_external	get_courses_by_field	course/externallib.php	moodle		moodle_mobile_app
67	core_course_check_updates	core_course_external	check_updates	course/externallib.php	moodle		moodle_mobile_app
68	core_course_get_updates_since	core_course_external	get_updates_since	course/externallib.php	moodle		moodle_mobile_app
69	core_course_get_enrolled_courses_by_timeline_classification	core_course_external	get_enrolled_courses_by_timeline_classification	course/externallib.php	moodle		moodle_mobile_app
70	core_course_get_recent_courses	core_course_external	get_recent_courses	course/externallib.php	moodle		moodle_mobile_app
71	core_course_set_favourite_courses	core_course_external	set_favourite_courses	course/externallib.php	moodle		moodle_mobile_app
72	core_course_get_enrolled_users_by_cmid	core_course_external	get_enrolled_users_by_cmid	course/externallib.php	moodle		\N
73	core_course_add_content_item_to_user_favourites	core_course_external	add_content_item_to_user_favourites	course/externallib.php	moodle		\N
74	core_course_remove_content_item_from_user_favourites	core_course_external	remove_content_item_from_user_favourites	course/externallib.php	moodle		\N
75	core_course_get_course_content_items	core_course_external	get_course_content_items	course/externallib.php	moodle		\N
76	core_course_get_activity_chooser_footer	core_course_external	get_activity_chooser_footer	course/externallib.php	moodle		\N
77	core_course_toggle_activity_recommendation	core_course_external	toggle_activity_recommendation	course/externallib.php	moodle		\N
78	core_enrol_get_course_enrolment_methods	core_enrol_external	get_course_enrolment_methods	enrol/externallib.php	moodle		moodle_mobile_app
79	core_enrol_get_enrolled_users	core_enrol_external	get_enrolled_users	enrol/externallib.php	moodle	moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update, moodle/site:accessallgroups	moodle_mobile_app
80	core_enrol_get_enrolled_users_with_capability	core_enrol_external	get_enrolled_users_with_capability	enrol/externallib.php	moodle		\N
81	core_enrol_get_potential_users	core_enrol_external	get_potential_users	enrol/externallib.php	moodle	moodle/course:enrolreview	\N
82	core_enrol_search_users	core_enrol_external	search_users	enrol/externallib.php	moodle	moodle/course:viewparticipants	moodle_mobile_app
83	core_enrol_get_users_courses	core_enrol_external	get_users_courses	enrol/externallib.php	moodle	moodle/course:viewparticipants	moodle_mobile_app
84	core_enrol_edit_user_enrolment	core_enrol_external	edit_user_enrolment	enrol/externallib.php	moodle		\N
85	core_enrol_submit_user_enrolment_form	core_enrol_external	submit_user_enrolment_form	enrol/externallib.php	moodle		\N
86	core_enrol_unenrol_user_enrolment	core_enrol_external	unenrol_user_enrolment	enrol/externallib.php	moodle		\N
87	core_fetch_notifications	core_external	fetch_notifications	lib/external/externallib.php	moodle		\N
88	core_session_touch	core\\session\\external	touch_session	\N	moodle		\N
89	core_session_time_remaining	core\\session\\external	time_remaining	\N	moodle		\N
90	core_files_get_files	core_files_external	get_files	files/externallib.php	moodle		moodle_mobile_app
91	core_files_upload	core_files_external	upload	files/externallib.php	moodle		\N
92	core_form_get_filetypes_browser_data	core_form\\external	get_filetypes_browser_data	\N	moodle		\N
93	core_get_component_strings	core_external	get_component_strings	lib/external/externallib.php	moodle		moodle_mobile_app
94	core_get_fragment	core_external	get_fragment	lib/external/externallib.php	moodle		\N
95	core_get_string	core_external	get_string	lib/external/externallib.php	moodle		\N
96	core_get_strings	core_external	get_strings	lib/external/externallib.php	moodle		\N
97	core_get_user_dates	core_external	get_user_dates	lib/external/externallib.php	moodle		\N
98	core_grades_get_grades	core_grades_external	get_grades	\N	moodle	moodle/grade:view, moodle/grade:viewall, moodle/grade:viewhidden	\N
99	core_grades_update_grades	core_grades_external	update_grades	\N	moodle		\N
100	core_grades_grader_gradingpanel_point_fetch	core_grades\\grades\\grader\\gradingpanel\\point\\external\\fetch	execute	\N	moodle		moodle_mobile_app
101	core_grades_grader_gradingpanel_point_store	core_grades\\grades\\grader\\gradingpanel\\point\\external\\store	execute	\N	moodle		moodle_mobile_app
102	core_grades_grader_gradingpanel_scale_fetch	core_grades\\grades\\grader\\gradingpanel\\scale\\external\\fetch	execute	\N	moodle		moodle_mobile_app
103	core_grades_grader_gradingpanel_scale_store	core_grades\\grades\\grader\\gradingpanel\\scale\\external\\store	execute	\N	moodle		moodle_mobile_app
104	core_grading_get_definitions	core_grading_external	get_definitions	\N	moodle		\N
105	core_grading_get_gradingform_instances	core_grading_external	get_gradingform_instances	\N	moodle		\N
106	core_grading_save_definitions	core_grading_external	save_definitions	\N	moodle		\N
107	core_group_add_group_members	core_group_external	add_group_members	group/externallib.php	moodle	moodle/course:managegroups	\N
108	core_group_assign_grouping	core_group_external	assign_grouping	group/externallib.php	moodle		\N
109	core_group_create_groupings	core_group_external	create_groupings	group/externallib.php	moodle		\N
110	core_group_create_groups	core_group_external	create_groups	group/externallib.php	moodle	moodle/course:managegroups	\N
111	core_group_delete_group_members	core_group_external	delete_group_members	group/externallib.php	moodle	moodle/course:managegroups	\N
112	core_group_delete_groupings	core_group_external	delete_groupings	group/externallib.php	moodle		\N
113	core_group_delete_groups	core_group_external	delete_groups	group/externallib.php	moodle	moodle/course:managegroups	\N
114	core_group_get_activity_allowed_groups	core_group_external	get_activity_allowed_groups	group/externallib.php	moodle		moodle_mobile_app
115	core_group_get_activity_groupmode	core_group_external	get_activity_groupmode	group/externallib.php	moodle		moodle_mobile_app
116	core_group_get_course_groupings	core_group_external	get_course_groupings	group/externallib.php	moodle		moodle_mobile_app
117	core_group_get_course_groups	core_group_external	get_course_groups	group/externallib.php	moodle	moodle/course:managegroups	moodle_mobile_app
118	core_group_get_course_user_groups	core_group_external	get_course_user_groups	group/externallib.php	moodle	moodle/course:managegroups	moodle_mobile_app
119	core_group_get_group_members	core_group_external	get_group_members	group/externallib.php	moodle	moodle/course:managegroups	\N
120	core_group_get_groupings	core_group_external	get_groupings	group/externallib.php	moodle		\N
121	core_group_get_groups	core_group_external	get_groups	group/externallib.php	moodle	moodle/course:managegroups	\N
122	core_group_unassign_grouping	core_group_external	unassign_grouping	group/externallib.php	moodle		\N
123	core_group_update_groupings	core_group_external	update_groupings	group/externallib.php	moodle		\N
124	core_group_update_groups	core_group_external	update_groups	group/externallib.php	moodle	moodle/course:managegroups	\N
125	core_message_mute_conversations	core_message_external	mute_conversations	message/externallib.php	moodle		moodle_mobile_app
126	core_message_unmute_conversations	core_message_external	unmute_conversations	message/externallib.php	moodle		moodle_mobile_app
127	core_message_block_user	core_message_external	block_user	message/externallib.php	moodle		moodle_mobile_app
128	core_message_block_contacts	core_message_external	block_contacts	message/externallib.php	moodle		moodle_mobile_app
129	core_message_create_contacts	core_message_external	create_contacts	message/externallib.php	moodle		moodle_mobile_app
130	core_message_get_contact_requests	core_message_external	get_contact_requests	message/externallib.php	moodle		moodle_mobile_app
131	core_message_create_contact_request	core_message_external	create_contact_request	message/externallib.php	moodle		moodle_mobile_app
132	core_message_confirm_contact_request	core_message_external	confirm_contact_request	message/externallib.php	moodle		moodle_mobile_app
133	core_message_decline_contact_request	core_message_external	decline_contact_request	message/externallib.php	moodle		moodle_mobile_app
134	core_message_get_received_contact_requests_count	core_message_external	get_received_contact_requests_count	message/externallib.php	moodle		moodle_mobile_app
135	core_message_delete_contacts	core_message_external	delete_contacts	message/externallib.php	moodle		moodle_mobile_app
136	core_message_delete_conversation	core_message_external	delete_conversation	message/externallib.php	moodle	moodle/site:deleteownmessage	moodle_mobile_app
137	core_message_delete_conversations_by_id	core_message_external	delete_conversations_by_id	message/externallib.php	moodle	moodle/site:deleteownmessage	moodle_mobile_app
138	core_message_delete_message	core_message_external	delete_message	message/externallib.php	moodle	moodle/site:deleteownmessage	moodle_mobile_app
139	core_message_get_blocked_users	core_message_external	get_blocked_users	message/externallib.php	moodle		moodle_mobile_app
140	core_message_data_for_messagearea_search_messages	core_message_external	data_for_messagearea_search_messages	message/externallib.php	moodle		moodle_mobile_app
141	core_message_data_for_messagearea_search_users	core_message_external	data_for_messagearea_search_users	message/externallib.php	moodle		\N
142	core_message_data_for_messagearea_search_users_in_course	core_message_external	data_for_messagearea_search_users_in_course	message/externallib.php	moodle		\N
143	core_message_message_search_users	core_message_external	message_search_users	message/externallib.php	moodle		moodle_mobile_app
144	core_message_data_for_messagearea_conversations	core_message_external	data_for_messagearea_conversations	message/externallib.php	moodle		moodle_mobile_app
145	core_message_data_for_messagearea_contacts	core_message_external	data_for_messagearea_contacts	message/externallib.php	moodle		moodle_mobile_app
146	core_message_data_for_messagearea_messages	core_message_external	data_for_messagearea_messages	message/externallib.php	moodle		moodle_mobile_app
147	core_message_data_for_messagearea_get_most_recent_message	core_message_external	data_for_messagearea_get_most_recent_message	message/externallib.php	moodle		\N
148	core_message_data_for_messagearea_get_profile	core_message_external	data_for_messagearea_get_profile	message/externallib.php	moodle		\N
149	core_message_get_contacts	core_message_external	get_contacts	message/externallib.php	moodle		moodle_mobile_app
150	core_message_get_user_contacts	core_message_external	get_user_contacts	message/externallib.php	moodle		moodle_mobile_app
151	core_message_get_conversations	core_message_external	get_conversations	message/externallib.php	moodle		moodle_mobile_app
152	core_message_get_conversation	core_message_external	get_conversation	message/externallib.php	moodle		moodle_mobile_app
153	core_message_get_conversation_between_users	core_message_external	get_conversation_between_users	message/externallib.php	moodle		moodle_mobile_app
154	core_message_get_self_conversation	core_message_external	get_self_conversation	message/externallib.php	moodle		moodle_mobile_app
155	core_message_get_messages	core_message_external	get_messages	message/externallib.php	moodle		moodle_mobile_app
156	core_message_get_conversation_counts	core_message_external	get_conversation_counts	message/externallib.php	moodle		moodle_mobile_app
157	core_message_get_unread_conversation_counts	core_message_external	get_unread_conversation_counts	message/externallib.php	moodle		moodle_mobile_app
158	core_message_get_conversation_members	core_message_external	get_conversation_members	message/externallib.php	moodle		moodle_mobile_app
159	core_message_get_member_info	core_message_external	get_member_info	message/externallib.php	moodle		moodle_mobile_app
160	core_message_get_unread_conversations_count	core_message_external	get_unread_conversations_count	message/externallib.php	moodle		moodle_mobile_app
161	core_message_mark_all_notifications_as_read	core_message_external	mark_all_notifications_as_read	message/externallib.php	moodle		moodle_mobile_app
162	core_message_mark_all_messages_as_read	core_message_external	mark_all_messages_as_read	message/externallib.php	moodle		moodle_mobile_app
163	core_message_mark_all_conversation_messages_as_read	core_message_external	mark_all_conversation_messages_as_read	message/externallib.php	moodle		moodle_mobile_app
164	core_message_mark_message_read	core_message_external	mark_message_read	message/externallib.php	moodle		moodle_mobile_app
165	core_message_mark_notification_read	core_message_external	mark_notification_read	message/externallib.php	moodle		moodle_mobile_app
166	core_message_message_processor_config_form	core_message_external	message_processor_config_form	message/externallib.php	moodle		moodle_mobile_app
167	core_message_get_message_processor	core_message_external	get_message_processor	message/externallib.php	moodle		\N
168	core_message_search_contacts	core_message_external	search_contacts	message/externallib.php	moodle		moodle_mobile_app
169	core_message_send_instant_messages	core_message_external	send_instant_messages	message/externallib.php	moodle	moodle/site:sendmessage	moodle_mobile_app
170	core_message_send_messages_to_conversation	core_message_external	send_messages_to_conversation	message/externallib.php	moodle	moodle/site:sendmessage	moodle_mobile_app
171	core_message_get_conversation_messages	core_message_external	get_conversation_messages	message/externallib.php	moodle		moodle_mobile_app
172	core_message_unblock_user	core_message_external	unblock_user	message/externallib.php	moodle		moodle_mobile_app
173	core_message_unblock_contacts	core_message_external	unblock_contacts	message/externallib.php	moodle		moodle_mobile_app
174	core_message_get_user_notification_preferences	core_message_external	get_user_notification_preferences	message/externallib.php	moodle	moodle/user:editownmessageprofile	moodle_mobile_app
175	core_message_get_user_message_preferences	core_message_external	get_user_message_preferences	message/externallib.php	moodle	moodle/user:editownmessageprofile	moodle_mobile_app
176	core_message_set_favourite_conversations	core_message_external	set_favourite_conversations	message/externallib.php	moodle		moodle_mobile_app
177	core_message_unset_favourite_conversations	core_message_external	unset_favourite_conversations	message/externallib.php	moodle		moodle_mobile_app
178	core_message_delete_message_for_all_users	core_message_external	delete_message_for_all_users	message/externallib.php	moodle	moodle/site:deleteanymessage	moodle_mobile_app
179	core_notes_create_notes	core_notes_external	create_notes	notes/externallib.php	moodle	moodle/notes:manage	moodle_mobile_app
180	core_notes_delete_notes	core_notes_external	delete_notes	notes/externallib.php	moodle	moodle/notes:manage	moodle_mobile_app
181	core_notes_get_course_notes	core_notes_external	get_course_notes	notes/externallib.php	moodle	moodle/notes:view	moodle_mobile_app
182	core_notes_get_notes	core_notes_external	get_notes	notes/externallib.php	moodle	moodle/notes:view	\N
183	core_notes_update_notes	core_notes_external	update_notes	notes/externallib.php	moodle	moodle/notes:manage	\N
184	core_notes_view_notes	core_notes_external	view_notes	notes/externallib.php	moodle	moodle/notes:view	moodle_mobile_app
185	core_output_load_template	core\\output\\external	load_template	\N	moodle		\N
186	core_output_load_template_with_dependencies	core\\output\\external	load_template_with_dependencies	\N	moodle		\N
187	core_output_load_fontawesome_icon_map	core\\output\\external	load_fontawesome_icon_map	\N	moodle		\N
188	core_output_load_fontawesome_icon_system_map	core\\external\\output\\icon_system\\load_fontawesome_map	execute	\N	moodle		\N
189	core_question_update_flag	core_question_external	update_flag	\N	moodle	moodle/question:flag	moodle_mobile_app
190	core_question_submit_tags_form	core_question_external	submit_tags_form	\N	moodle		\N
191	core_question_get_random_question_summaries	core_question_external	get_random_question_summaries	\N	moodle		\N
192	core_rating_get_item_ratings	core_rating_external	get_item_ratings	\N	moodle	moodle/rating:view	moodle_mobile_app
193	core_rating_add_rating	core_rating_external	add_rating	\N	moodle	moodle/rating:rate	moodle_mobile_app
194	core_role_assign_roles	core_role_external	assign_roles	enrol/externallib.php	moodle	moodle/role:assign	\N
195	core_role_unassign_roles	core_role_external	unassign_roles	enrol/externallib.php	moodle	moodle/role:assign	\N
196	core_search_get_relevant_users	\\core_search\\external	get_relevant_users	\N	moodle		\N
197	core_tag_get_tagindex	core_tag_external	get_tagindex	\N	moodle		moodle_mobile_app
198	core_tag_get_tags	core_tag_external	get_tags	\N	moodle		\N
199	core_tag_update_tags	core_tag_external	update_tags	\N	moodle		\N
200	core_tag_get_tagindex_per_area	core_tag_external	get_tagindex_per_area	\N	moodle		moodle_mobile_app
201	core_tag_get_tag_areas	core_tag_external	get_tag_areas	\N	moodle		moodle_mobile_app
202	core_tag_get_tag_collections	core_tag_external	get_tag_collections	\N	moodle		moodle_mobile_app
203	core_tag_get_tag_cloud	core_tag_external	get_tag_cloud	\N	moodle		moodle_mobile_app
204	core_update_inplace_editable	core_external	update_inplace_editable	lib/external/externallib.php	moodle		\N
205	core_user_add_user_device	core_user_external	add_user_device	user/externallib.php	moodle		moodle_mobile_app
206	core_user_add_user_private_files	core_user_external	add_user_private_files	user/externallib.php	moodle	moodle/user:manageownfiles	moodle_mobile_app
207	core_user_create_users	core_user_external	create_users	user/externallib.php	moodle	moodle/user:create	\N
208	core_user_delete_users	core_user_external	delete_users	user/externallib.php	moodle	moodle/user:delete	\N
209	core_user_get_course_user_profiles	core_user_external	get_course_user_profiles	user/externallib.php	moodle	moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update, moodle/site:accessallgroups	moodle_mobile_app
210	core_user_get_users	core_user_external	get_users	user/externallib.php	moodle	moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update	\N
211	core_user_get_users_by_field	core_user_external	get_users_by_field	user/externallib.php	moodle	moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update	moodle_mobile_app
212	core_user_remove_user_device	core_user_external	remove_user_device	user/externallib.php	moodle		moodle_mobile_app
213	core_user_update_users	core_user_external	update_users	user/externallib.php	moodle	moodle/user:update	\N
214	core_user_update_user_preferences	core_user_external	update_user_preferences	user/externallib.php	moodle	moodle/user:editownmessageprofile, moodle/user:editmessageprofile	moodle_mobile_app
215	core_user_view_user_list	core_user_external	view_user_list	user/externallib.php	moodle	moodle/course:viewparticipants	moodle_mobile_app
216	core_user_view_user_profile	core_user_external	view_user_profile	user/externallib.php	moodle	moodle/user:viewdetails	moodle_mobile_app
217	core_user_get_user_preferences	core_user_external	get_user_preferences	user/externallib.php	moodle		moodle_mobile_app
218	core_user_update_picture	core_user_external	update_picture	user/externallib.php	moodle	moodle/user:editownprofile, moodle/user:editprofile	moodle_mobile_app
219	core_user_set_user_preferences	core_user_external	set_user_preferences	user/externallib.php	moodle	moodle/site:config	moodle_mobile_app
220	core_user_agree_site_policy	core_user_external	agree_site_policy	user/externallib.php	moodle		moodle_mobile_app
221	core_user_get_private_files_info	core_user_external	get_private_files_info	user/externallib.php	moodle	moodle/user:manageownfiles	moodle_mobile_app
222	core_competency_create_competency_framework	core_competency\\external	create_competency_framework	\N	moodle	moodle/competency:competencymanage	\N
223	core_competency_read_competency_framework	core_competency\\external	read_competency_framework	\N	moodle	moodle/competency:competencyview	\N
224	core_competency_duplicate_competency_framework	core_competency\\external	duplicate_competency_framework	\N	moodle	moodle/competency:competencymanage	\N
225	core_competency_delete_competency_framework	core_competency\\external	delete_competency_framework	\N	moodle	moodle/competency:competencymanage	\N
226	core_competency_update_competency_framework	core_competency\\external	update_competency_framework	\N	moodle	moodle/competency:competencymanage	\N
227	core_competency_list_competency_frameworks	core_competency\\external	list_competency_frameworks	\N	moodle	moodle/competency:competencyview	\N
228	core_competency_count_competency_frameworks	core_competency\\external	count_competency_frameworks	\N	moodle	moodle/competency:competencyview	\N
229	core_competency_competency_framework_viewed	core_competency\\external	competency_framework_viewed	\N	moodle	moodle/competency:competencyview	\N
230	core_competency_create_competency	core_competency\\external	create_competency	\N	moodle	moodle/competency:competencymanage	\N
231	core_competency_read_competency	core_competency\\external	read_competency	\N	moodle	moodle/competency:competencyview	\N
232	core_competency_competency_viewed	core_competency\\external	competency_viewed	\N	moodle	moodle/competency:competencyview	moodle_mobile_app
233	core_competency_delete_competency	core_competency\\external	delete_competency	\N	moodle	moodle/competency:competencymanage	\N
234	core_competency_update_competency	core_competency\\external	update_competency	\N	moodle	moodle/competency:competencymanage	\N
235	core_competency_list_competencies	core_competency\\external	list_competencies	\N	moodle	moodle/competency:competencyview	\N
236	core_competency_list_competencies_in_template	core_competency\\external	list_competencies_in_template	\N	moodle	moodle/competency:competencyview	\N
237	core_competency_count_competencies	core_competency\\external	count_competencies	\N	moodle	moodle/competency:competencyview	\N
238	core_competency_count_competencies_in_template	core_competency\\external	count_competencies_in_template	\N	moodle	moodle/competency:competencyview	\N
239	core_competency_search_competencies	core_competency\\external	search_competencies	\N	moodle	moodle/competency:competencyview	\N
240	core_competency_set_parent_competency	core_competency\\external	set_parent_competency	\N	moodle	moodle/competency:competencymanage	\N
241	core_competency_move_up_competency	core_competency\\external	move_up_competency	\N	moodle	moodle/competency:competencymanage	\N
438	mod_lesson_get_pages	mod_lesson_external	get_pages	\N	mod_lesson	mod/lesson:view	moodle_mobile_app
242	core_competency_move_down_competency	core_competency\\external	move_down_competency	\N	moodle	moodle/competency:competencymanage	\N
243	core_competency_list_course_module_competencies	core_competency\\external	list_course_module_competencies	\N	moodle	moodle/competency:coursecompetencyview	\N
244	core_competency_count_course_module_competencies	core_competency\\external	count_course_module_competencies	\N	moodle	moodle/competency:coursecompetencyview	\N
245	core_competency_list_course_competencies	core_competency\\external	list_course_competencies	\N	moodle	moodle/competency:coursecompetencyview	moodle_mobile_app
246	core_competency_count_competencies_in_course	core_competency\\external	count_competencies_in_course	\N	moodle	moodle/competency:coursecompetencyview	\N
247	core_competency_count_courses_using_competency	core_competency\\external	count_courses_using_competency	\N	moodle	moodle/competency:coursecompetencyview	\N
248	core_competency_add_competency_to_course	core_competency\\external	add_competency_to_course	\N	moodle	moodle/competency:coursecompetencymanage	\N
249	core_competency_add_competency_to_template	core_competency\\external	add_competency_to_template	\N	moodle	moodle/competency:templatemanage	\N
250	core_competency_remove_competency_from_course	core_competency\\external	remove_competency_from_course	\N	moodle	moodle/competency:coursecompetencymanage	\N
251	core_competency_set_course_competency_ruleoutcome	core_competency\\external	set_course_competency_ruleoutcome	\N	moodle	moodle/competency:coursecompetencymanage	\N
252	core_competency_remove_competency_from_template	core_competency\\external	remove_competency_from_template	\N	moodle	moodle/competency:templatemanage	\N
253	core_competency_reorder_course_competency	core_competency\\external	reorder_course_competency	\N	moodle	moodle/competency:coursecompetencymanage	\N
254	core_competency_reorder_template_competency	core_competency\\external	reorder_template_competency	\N	moodle	moodle/competency:templatemanage	\N
255	core_competency_create_template	core_competency\\external	create_template	\N	moodle	moodle/competency:templatemanage	\N
256	core_competency_duplicate_template	core_competency\\external	duplicate_template	\N	moodle	moodle/competency:templatemanage	\N
257	core_competency_read_template	core_competency\\external	read_template	\N	moodle	moodle/competency:templateview	\N
258	core_competency_delete_template	core_competency\\external	delete_template	\N	moodle	moodle/competency:templatemanage	\N
259	core_competency_update_template	core_competency\\external	update_template	\N	moodle	moodle/competency:templatemanage	\N
260	core_competency_list_templates	core_competency\\external	list_templates	\N	moodle	moodle/competency:templateview	\N
261	core_competency_list_templates_using_competency	core_competency\\external	list_templates_using_competency	\N	moodle	moodle/competency:templateview	\N
262	core_competency_count_templates	core_competency\\external	count_templates	\N	moodle	moodle/competency:templateview	\N
263	core_competency_count_templates_using_competency	core_competency\\external	count_templates_using_competency	\N	moodle	moodle/competency:templateview	\N
264	core_competency_create_plan	core_competency\\external	create_plan	\N	moodle	moodle/competency:planmanage	\N
265	core_competency_update_plan	core_competency\\external	update_plan	\N	moodle	moodle/competency:planmanage	\N
266	core_competency_complete_plan	core_competency\\external	complete_plan	\N	moodle	moodle/competency:planmanage	\N
267	core_competency_reopen_plan	core_competency\\external	reopen_plan	\N	moodle	moodle/competency:planmanage	\N
268	core_competency_read_plan	core_competency\\external	read_plan	\N	moodle	moodle/competency:planviewown	\N
269	core_competency_delete_plan	core_competency\\external	delete_plan	\N	moodle	moodle/competency:planmanage	\N
270	core_competency_list_user_plans	core_competency\\external	list_user_plans	\N	moodle	moodle/competency:planviewown	\N
271	core_competency_list_plan_competencies	core_competency\\external	list_plan_competencies	\N	moodle	moodle/competency:planviewown	\N
272	core_competency_add_competency_to_plan	core_competency\\external	add_competency_to_plan	\N	moodle	moodle/competency:planmanage	\N
273	core_competency_remove_competency_from_plan	core_competency\\external	remove_competency_from_plan	\N	moodle	moodle/competency:planmanage	\N
274	core_competency_reorder_plan_competency	core_competency\\external	reorder_plan_competency	\N	moodle	moodle/competency:planmanage	\N
275	core_competency_plan_request_review	core_competency\\external	plan_request_review	\N	moodle	moodle/competency:planmanagedraft	\N
276	core_competency_plan_start_review	core_competency\\external	plan_start_review	\N	moodle	moodle/competency:planmanage	\N
277	core_competency_plan_stop_review	core_competency\\external	plan_stop_review	\N	moodle	moodle/competency:planmanage	\N
278	core_competency_plan_cancel_review_request	core_competency\\external	plan_cancel_review_request	\N	moodle	moodle/competency:planmanagedraft	\N
279	core_competency_approve_plan	core_competency\\external	approve_plan	\N	moodle	moodle/competency:planmanage	\N
280	core_competency_unapprove_plan	core_competency\\external	unapprove_plan	\N	moodle	moodle/competency:planmanage	\N
281	core_competency_template_has_related_data	core_competency\\external	template_has_related_data	\N	moodle	moodle/competency:templateview	\N
282	core_competency_get_scale_values	core_competency\\external	get_scale_values	\N	moodle	moodle/competency:competencymanage	moodle_mobile_app
283	core_competency_add_related_competency	core_competency\\external	add_related_competency	\N	moodle	moodle/competency:competencymanage	\N
284	core_competency_remove_related_competency	core_competency\\external	remove_related_competency	\N	moodle	moodle/competency:competencymanage	\N
285	core_competency_read_user_evidence	core_competency\\external	read_user_evidence	\N	moodle	moodle/competency:userevidenceview	\N
286	core_competency_delete_user_evidence	core_competency\\external	delete_user_evidence	\N	moodle	moodle/competency:userevidencemanageown	\N
287	core_competency_create_user_evidence_competency	core_competency\\external	create_user_evidence_competency	\N	moodle	moodle/competency:userevidencemanageown, moodle/competency:competencyview	\N
288	core_competency_delete_user_evidence_competency	core_competency\\external	delete_user_evidence_competency	\N	moodle	moodle/competency:userevidencemanageown	\N
289	core_competency_user_competency_cancel_review_request	core_competency\\external	user_competency_cancel_review_request	\N	moodle	moodle/competency:userevidencemanageown	\N
290	core_competency_user_competency_request_review	core_competency\\external	user_competency_request_review	\N	moodle	moodle/competency:userevidencemanageown	\N
291	core_competency_user_competency_start_review	core_competency\\external	user_competency_start_review	\N	moodle	moodle/competency:competencygrade	\N
292	core_competency_user_competency_stop_review	core_competency\\external	user_competency_stop_review	\N	moodle	moodle/competency:competencygrade	\N
293	core_competency_user_competency_viewed	core_competency\\external	user_competency_viewed	\N	moodle	moodle/competency:usercompetencyview	moodle_mobile_app
294	core_competency_user_competency_viewed_in_plan	core_competency\\external	user_competency_viewed_in_plan	\N	moodle	moodle/competency:usercompetencyview	moodle_mobile_app
295	core_competency_user_competency_viewed_in_course	core_competency\\external	user_competency_viewed_in_course	\N	moodle	moodle/competency:usercompetencyview	moodle_mobile_app
296	core_competency_user_competency_plan_viewed	core_competency\\external	user_competency_plan_viewed	\N	moodle	moodle/competency:usercompetencyview	moodle_mobile_app
297	core_competency_grade_competency	core_competency\\external	grade_competency	\N	moodle	moodle/competency:competencygrade	\N
298	core_competency_grade_competency_in_plan	core_competency\\external	grade_competency_in_plan	\N	moodle	moodle/competency:competencygrade	\N
299	core_competency_grade_competency_in_course	core_competency\\external	grade_competency_in_course	\N	moodle	moodle/competency:competencygrade	moodle_mobile_app
300	core_competency_unlink_plan_from_template	core_competency\\external	unlink_plan_from_template	\N	moodle	moodle/competency:planmanage	\N
301	core_competency_template_viewed	core_competency\\external	template_viewed	\N	moodle	moodle/competency:templateview	\N
302	core_competency_request_review_of_user_evidence_linked_competencies	core_competency\\external	request_review_of_user_evidence_linked_competencies	\N	moodle	moodle/competency:userevidencemanageown	\N
303	core_competency_update_course_competency_settings	core_competency\\external	update_course_competency_settings	\N	moodle	moodle/competency:coursecompetencyconfigure	\N
304	core_competency_delete_evidence	core_competency\\external	delete_evidence	\N	moodle	moodle/competency:evidencedelete	moodle_mobile_app
305	core_webservice_get_site_info	core_webservice_external	get_site_info	webservice/externallib.php	moodle		moodle_mobile_app
306	core_block_get_course_blocks	core_block_external	get_course_blocks	\N	moodle		moodle_mobile_app
307	core_block_get_dashboard_blocks	core_block_external	get_dashboard_blocks	\N	moodle		moodle_mobile_app
308	core_filters_get_available_in_context	core_filters\\external	get_available_in_context	\N	moodle		moodle_mobile_app
309	core_customfield_delete_field	core_customfield_external	delete_field	customfield/externallib.php	moodle		\N
310	core_customfield_reload_template	core_customfield_external	reload_template	customfield/externallib.php	moodle		\N
311	core_customfield_create_category	core_customfield_external	create_category	customfield/externallib.php	moodle		\N
312	core_customfield_delete_category	core_customfield_external	delete_category	customfield/externallib.php	moodle		\N
313	core_customfield_move_field	core_customfield_external	move_field	customfield/externallib.php	moodle		\N
314	core_customfield_move_category	core_customfield_external	move_category	customfield/externallib.php	moodle		\N
315	core_h5p_get_trusted_h5p_file	core_h5p\\external	get_trusted_h5p_file	\N	moodle		moodle_mobile_app
316	core_table_get_dynamic_table_content	core_table\\external\\dynamic\\get	execute	\N	moodle		moodle_mobile_app
317	core_xapi_statement_post	core_xapi\\external\\post_statement	execute	\N	moodle		moodle_mobile_app
318	core_contentbank_delete_content	core_contentbank\\external\\delete_content	execute	\N	moodle	moodle/contentbank:deleteanycontent	\N
319	core_contentbank_rename_content	core_contentbank\\external\\rename_content	execute	\N	moodle	moodle/contentbank:manageowncontent	\N
320	core_create_userfeedback_action_record	core\\external\\record_userfeedback_action	execute	\N	moodle		\N
321	mod_assign_copy_previous_attempt	mod_assign_external	copy_previous_attempt	mod/assign/externallib.php	mod_assign	mod/assign:view, mod/assign:submit	\N
322	mod_assign_get_grades	mod_assign_external	get_grades	mod/assign/externallib.php	mod_assign		moodle_mobile_app
323	mod_assign_get_assignments	mod_assign_external	get_assignments	mod/assign/externallib.php	mod_assign		moodle_mobile_app
324	mod_assign_get_submissions	mod_assign_external	get_submissions	mod/assign/externallib.php	mod_assign		moodle_mobile_app
325	mod_assign_get_user_flags	mod_assign_external	get_user_flags	mod/assign/externallib.php	mod_assign		moodle_mobile_app
326	mod_assign_set_user_flags	mod_assign_external	set_user_flags	mod/assign/externallib.php	mod_assign	mod/assign:grade	moodle_mobile_app
327	mod_assign_get_user_mappings	mod_assign_external	get_user_mappings	mod/assign/externallib.php	mod_assign		moodle_mobile_app
328	mod_assign_revert_submissions_to_draft	mod_assign_external	revert_submissions_to_draft	mod/assign/externallib.php	mod_assign		moodle_mobile_app
329	mod_assign_lock_submissions	mod_assign_external	lock_submissions	mod/assign/externallib.php	mod_assign		moodle_mobile_app
330	mod_assign_unlock_submissions	mod_assign_external	unlock_submissions	mod/assign/externallib.php	mod_assign		moodle_mobile_app
331	mod_assign_save_submission	mod_assign_external	save_submission	mod/assign/externallib.php	mod_assign		moodle_mobile_app
332	mod_assign_submit_for_grading	mod_assign_external	submit_for_grading	mod/assign/externallib.php	mod_assign		moodle_mobile_app
333	mod_assign_save_grade	mod_assign_external	save_grade	mod/assign/externallib.php	mod_assign		moodle_mobile_app
334	mod_assign_save_grades	mod_assign_external	save_grades	mod/assign/externallib.php	mod_assign		moodle_mobile_app
335	mod_assign_save_user_extensions	mod_assign_external	save_user_extensions	mod/assign/externallib.php	mod_assign		moodle_mobile_app
336	mod_assign_reveal_identities	mod_assign_external	reveal_identities	mod/assign/externallib.php	mod_assign		moodle_mobile_app
337	mod_assign_view_grading_table	mod_assign_external	view_grading_table	mod/assign/externallib.php	mod_assign	mod/assign:view, mod/assign:viewgrades	moodle_mobile_app
338	mod_assign_view_submission_status	mod_assign_external	view_submission_status	mod/assign/externallib.php	mod_assign	mod/assign:view	moodle_mobile_app
339	mod_assign_get_submission_status	mod_assign_external	get_submission_status	mod/assign/externallib.php	mod_assign	mod/assign:view	moodle_mobile_app
340	mod_assign_list_participants	mod_assign_external	list_participants	mod/assign/externallib.php	mod_assign	mod/assign:view, mod/assign:viewgrades	moodle_mobile_app
341	mod_assign_submit_grading_form	mod_assign_external	submit_grading_form	mod/assign/externallib.php	mod_assign	mod/assign:grade	moodle_mobile_app
342	mod_assign_get_participant	mod_assign_external	get_participant	mod/assign/externallib.php	mod_assign	mod/assign:view, mod/assign:viewgrades	moodle_mobile_app
343	mod_assign_view_assign	mod_assign_external	view_assign	mod/assign/externallib.php	mod_assign	mod/assign:view	moodle_mobile_app
344	mod_book_view_book	mod_book_external	view_book	\N	mod_book	mod/book:read	moodle_mobile_app
345	mod_book_get_books_by_courses	mod_book_external	get_books_by_courses	\N	mod_book		moodle_mobile_app
346	mod_chat_login_user	mod_chat_external	login_user	\N	mod_chat	mod/chat:chat	moodle_mobile_app
347	mod_chat_get_chat_users	mod_chat_external	get_chat_users	\N	mod_chat	mod/chat:chat	moodle_mobile_app
348	mod_chat_send_chat_message	mod_chat_external	send_chat_message	\N	mod_chat	mod/chat:chat	moodle_mobile_app
349	mod_chat_get_chat_latest_messages	mod_chat_external	get_chat_latest_messages	\N	mod_chat	mod/chat:chat	moodle_mobile_app
350	mod_chat_view_chat	mod_chat_external	view_chat	\N	mod_chat	mod/chat:chat	moodle_mobile_app
351	mod_chat_get_chats_by_courses	mod_chat_external	get_chats_by_courses	\N	mod_chat		moodle_mobile_app
352	mod_chat_get_sessions	mod_chat_external	get_sessions	\N	mod_chat		moodle_mobile_app
353	mod_chat_get_session_messages	mod_chat_external	get_session_messages	\N	mod_chat		moodle_mobile_app
354	mod_choice_get_choice_results	mod_choice_external	get_choice_results	\N	mod_choice		moodle_mobile_app
355	mod_choice_get_choice_options	mod_choice_external	get_choice_options	\N	mod_choice	mod/choice:choose	moodle_mobile_app
356	mod_choice_submit_choice_response	mod_choice_external	submit_choice_response	\N	mod_choice	mod/choice:choose	moodle_mobile_app
357	mod_choice_view_choice	mod_choice_external	view_choice	\N	mod_choice		moodle_mobile_app
358	mod_choice_get_choices_by_courses	mod_choice_external	get_choices_by_courses	\N	mod_choice		moodle_mobile_app
359	mod_choice_delete_choice_responses	mod_choice_external	delete_choice_responses	\N	mod_choice	mod/choice:choose	moodle_mobile_app
360	mod_data_get_databases_by_courses	mod_data_external	get_databases_by_courses	\N	mod_data	mod/data:viewentry	moodle_mobile_app
361	mod_data_view_database	mod_data_external	view_database	\N	mod_data	mod/data:viewentry	moodle_mobile_app
362	mod_data_get_data_access_information	mod_data_external	get_data_access_information	\N	mod_data	mod/data:viewentry	moodle_mobile_app
363	mod_data_get_entries	mod_data_external	get_entries	\N	mod_data	mod/data:viewentry	moodle_mobile_app
364	mod_data_get_entry	mod_data_external	get_entry	\N	mod_data	mod/data:viewentry	moodle_mobile_app
365	mod_data_get_fields	mod_data_external	get_fields	\N	mod_data	mod/data:viewentry	moodle_mobile_app
366	mod_data_search_entries	mod_data_external	search_entries	\N	mod_data	mod/data:viewentry	moodle_mobile_app
367	mod_data_approve_entry	mod_data_external	approve_entry	\N	mod_data	mod/data:approve	moodle_mobile_app
368	mod_data_delete_entry	mod_data_external	delete_entry	\N	mod_data	mod/data:manageentries	moodle_mobile_app
369	mod_data_add_entry	mod_data_external	add_entry	\N	mod_data	mod/data:writeentry	moodle_mobile_app
370	mod_data_update_entry	mod_data_external	update_entry	\N	mod_data	mod/data:writeentry	moodle_mobile_app
371	mod_feedback_get_feedbacks_by_courses	mod_feedback_external	get_feedbacks_by_courses	\N	mod_feedback	mod/feedback:view	moodle_mobile_app
372	mod_feedback_get_feedback_access_information	mod_feedback_external	get_feedback_access_information	\N	mod_feedback	mod/feedback:view	moodle_mobile_app
373	mod_feedback_view_feedback	mod_feedback_external	view_feedback	\N	mod_feedback	mod/feedback:view	moodle_mobile_app
374	mod_feedback_get_current_completed_tmp	mod_feedback_external	get_current_completed_tmp	\N	mod_feedback	mod/feedback:view	moodle_mobile_app
375	mod_feedback_get_items	mod_feedback_external	get_items	\N	mod_feedback	mod/feedback:view	moodle_mobile_app
376	mod_feedback_launch_feedback	mod_feedback_external	launch_feedback	\N	mod_feedback	mod/feedback:complete	moodle_mobile_app
377	mod_feedback_get_page_items	mod_feedback_external	get_page_items	\N	mod_feedback	mod/feedback:complete	moodle_mobile_app
378	mod_feedback_process_page	mod_feedback_external	process_page	\N	mod_feedback	mod/feedback:complete	moodle_mobile_app
379	mod_feedback_get_analysis	mod_feedback_external	get_analysis	\N	mod_feedback	mod/feedback:viewanalysepage	moodle_mobile_app
380	mod_feedback_get_unfinished_responses	mod_feedback_external	get_unfinished_responses	\N	mod_feedback	mod/feedback:view	moodle_mobile_app
381	mod_feedback_get_finished_responses	mod_feedback_external	get_finished_responses	\N	mod_feedback	mod/feedback:view	moodle_mobile_app
382	mod_feedback_get_non_respondents	mod_feedback_external	get_non_respondents	\N	mod_feedback	mod/feedback:viewreports	moodle_mobile_app
383	mod_feedback_get_responses_analysis	mod_feedback_external	get_responses_analysis	\N	mod_feedback	mod/feedback:viewreports	moodle_mobile_app
384	mod_feedback_get_last_completed	mod_feedback_external	get_last_completed	\N	mod_feedback	mod/feedback:view	moodle_mobile_app
385	mod_folder_view_folder	mod_folder_external	view_folder	\N	mod_folder	mod/folder:view	moodle_mobile_app
386	mod_folder_get_folders_by_courses	mod_folder_external	get_folders_by_courses	\N	mod_folder	mod/folder:view	moodle_mobile_app
387	mod_forum_get_forums_by_courses	mod_forum_external	get_forums_by_courses	mod/forum/externallib.php	mod_forum	mod/forum:viewdiscussion	moodle_mobile_app
388	mod_forum_get_discussion_posts	mod_forum_external	get_discussion_posts	mod/forum/externallib.php	mod_forum	mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting	moodle_mobile_app
389	mod_forum_get_forum_discussion_posts	mod_forum_external	get_forum_discussion_posts	mod/forum/externallib.php	mod_forum	mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting	moodle_mobile_app
594	tool_mobile_get_config	tool_mobile\\external	get_config	\N	tool_mobile		moodle_mobile_app
390	mod_forum_get_forum_discussions_paginated	mod_forum_external	get_forum_discussions_paginated	mod/forum/externallib.php	mod_forum	mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting	moodle_mobile_app
391	mod_forum_get_forum_discussions	mod_forum_external	get_forum_discussions	mod/forum/externallib.php	mod_forum	mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting	moodle_mobile_app
392	mod_forum_view_forum	mod_forum_external	view_forum	mod/forum/externallib.php	mod_forum	mod/forum:viewdiscussion	moodle_mobile_app
393	mod_forum_view_forum_discussion	mod_forum_external	view_forum_discussion	mod/forum/externallib.php	mod_forum	mod/forum:viewdiscussion	moodle_mobile_app
394	mod_forum_add_discussion_post	mod_forum_external	add_discussion_post	mod/forum/externallib.php	mod_forum	mod/forum:replypost	moodle_mobile_app
395	mod_forum_add_discussion	mod_forum_external	add_discussion	mod/forum/externallib.php	mod_forum	mod/forum:startdiscussion	moodle_mobile_app
396	mod_forum_can_add_discussion	mod_forum_external	can_add_discussion	mod/forum/externallib.php	mod_forum		moodle_mobile_app
397	mod_forum_get_forum_access_information	mod_forum_external	get_forum_access_information	\N	mod_forum		moodle_mobile_app
398	mod_forum_set_subscription_state	mod_forum_external	set_subscription_state	mod/forum/externallib.php	mod_forum		moodle_mobile_app
399	mod_forum_set_lock_state	mod_forum_external	set_lock_state	mod/forum/externallib.php	mod_forum	moodle/course:manageactivities	moodle_mobile_app
400	mod_forum_toggle_favourite_state	mod_forum_external	toggle_favourite_state	mod/forum/externallib.php	mod_forum		moodle_mobile_app
401	mod_forum_set_pin_state	mod_forum_external	set_pin_state	mod/forum/externallib.php	mod_forum		moodle_mobile_app
402	mod_forum_delete_post	mod_forum_external	delete_post	mod/forum/externallib.php	mod_forum		moodle_mobile_app
403	mod_forum_get_discussion_posts_by_userid	mod_forum_external	get_discussion_posts_by_userid	mod/forum/externallib.php	mod_forum	mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting	\N
404	mod_forum_get_discussion_post	mod_forum_external	get_discussion_post	mod/forum/externallib.php	mod_forum		moodle_mobile_app
405	mod_forum_prepare_draft_area_for_post	mod_forum_external	prepare_draft_area_for_post	mod/forum/externallib.php	mod_forum		moodle_mobile_app
406	mod_forum_update_discussion_post	mod_forum_external	update_discussion_post	mod/forum/externallib.php	mod_forum		moodle_mobile_app
407	mod_glossary_get_glossaries_by_courses	mod_glossary_external	get_glossaries_by_courses	\N	mod_glossary	mod/glossary:view	moodle_mobile_app
408	mod_glossary_view_glossary	mod_glossary_external	view_glossary	\N	mod_glossary	mod/glossary:view	moodle_mobile_app
409	mod_glossary_view_entry	mod_glossary_external	view_entry	\N	mod_glossary	mod/glossary:view	moodle_mobile_app
410	mod_glossary_get_entries_by_letter	mod_glossary_external	get_entries_by_letter	\N	mod_glossary	mod/glossary:view	moodle_mobile_app
411	mod_glossary_get_entries_by_date	mod_glossary_external	get_entries_by_date	\N	mod_glossary	mod/glossary:view	moodle_mobile_app
412	mod_glossary_get_categories	mod_glossary_external	get_categories	\N	mod_glossary	mod/glossary:view	moodle_mobile_app
413	mod_glossary_get_entries_by_category	mod_glossary_external	get_entries_by_category	\N	mod_glossary	mod/glossary:view	moodle_mobile_app
414	mod_glossary_get_authors	mod_glossary_external	get_authors	\N	mod_glossary	mod/glossary:view	moodle_mobile_app
415	mod_glossary_get_entries_by_author	mod_glossary_external	get_entries_by_author	\N	mod_glossary	mod/glossary:view	moodle_mobile_app
416	mod_glossary_get_entries_by_author_id	mod_glossary_external	get_entries_by_author_id	\N	mod_glossary	mod/glossary:view	moodle_mobile_app
417	mod_glossary_get_entries_by_search	mod_glossary_external	get_entries_by_search	\N	mod_glossary	mod/glossary:view	moodle_mobile_app
418	mod_glossary_get_entries_by_term	mod_glossary_external	get_entries_by_term	\N	mod_glossary	mod/glossary:view	moodle_mobile_app
419	mod_glossary_get_entries_to_approve	mod_glossary_external	get_entries_to_approve	\N	mod_glossary	mod/glossary:approve	moodle_mobile_app
420	mod_glossary_get_entry_by_id	mod_glossary_external	get_entry_by_id	\N	mod_glossary	mod/glossary:view	moodle_mobile_app
421	mod_glossary_add_entry	mod_glossary_external	add_entry	\N	mod_glossary	mod/glossary:write	moodle_mobile_app
422	mod_h5pactivity_get_h5pactivity_access_information	mod_h5pactivity\\external\\get_h5pactivity_access_information	execute	\N	mod_h5pactivity	mod/h5pactivity:view	moodle_mobile_app
423	mod_h5pactivity_view_h5pactivity	mod_h5pactivity\\external\\view_h5pactivity	execute	\N	mod_h5pactivity	mod/h5pactivity:view	moodle_mobile_app
424	mod_h5pactivity_get_attempts	mod_h5pactivity\\external\\get_attempts	execute	\N	mod_h5pactivity	mod/h5pactivity:view	moodle_mobile_app
425	mod_h5pactivity_get_results	mod_h5pactivity\\external\\get_results	execute	\N	mod_h5pactivity	mod/h5pactivity:view	moodle_mobile_app
426	mod_h5pactivity_get_h5pactivities_by_courses	mod_h5pactivity\\external\\get_h5pactivities_by_courses	execute	\N	mod_h5pactivity	mod/h5pactivity:view	moodle_mobile_app
427	mod_imscp_view_imscp	mod_imscp_external	view_imscp	\N	mod_imscp	mod/imscp:view	moodle_mobile_app
428	mod_imscp_get_imscps_by_courses	mod_imscp_external	get_imscps_by_courses	\N	mod_imscp	mod/imscp:view	moodle_mobile_app
429	mod_label_get_labels_by_courses	mod_label_external	get_labels_by_courses	\N	mod_label	mod/label:view	moodle_mobile_app
430	mod_lesson_get_lessons_by_courses	mod_lesson_external	get_lessons_by_courses	\N	mod_lesson	mod/lesson:view	moodle_mobile_app
431	mod_lesson_get_lesson_access_information	mod_lesson_external	get_lesson_access_information	\N	mod_lesson	mod/lesson:view	moodle_mobile_app
432	mod_lesson_view_lesson	mod_lesson_external	view_lesson	\N	mod_lesson	mod/lesson:view	moodle_mobile_app
433	mod_lesson_get_questions_attempts	mod_lesson_external	get_questions_attempts	\N	mod_lesson	mod/lesson:view	moodle_mobile_app
434	mod_lesson_get_user_grade	mod_lesson_external	get_user_grade	\N	mod_lesson	mod/lesson:view	moodle_mobile_app
435	mod_lesson_get_user_attempt_grade	mod_lesson_external	get_user_attempt_grade	\N	mod_lesson	mod/lesson:view	moodle_mobile_app
436	mod_lesson_get_content_pages_viewed	mod_lesson_external	get_content_pages_viewed	\N	mod_lesson	mod/lesson:view	moodle_mobile_app
437	mod_lesson_get_user_timers	mod_lesson_external	get_user_timers	\N	mod_lesson	mod/lesson:view	moodle_mobile_app
439	mod_lesson_launch_attempt	mod_lesson_external	launch_attempt	\N	mod_lesson	mod/lesson:view	moodle_mobile_app
440	mod_lesson_get_page_data	mod_lesson_external	get_page_data	\N	mod_lesson	mod/lesson:view	moodle_mobile_app
441	mod_lesson_process_page	mod_lesson_external	process_page	\N	mod_lesson	mod/lesson:view	moodle_mobile_app
442	mod_lesson_finish_attempt	mod_lesson_external	finish_attempt	\N	mod_lesson	mod/lesson:view	moodle_mobile_app
443	mod_lesson_get_attempts_overview	mod_lesson_external	get_attempts_overview	\N	mod_lesson	mod/lesson:viewreports	moodle_mobile_app
444	mod_lesson_get_user_attempt	mod_lesson_external	get_user_attempt	\N	mod_lesson	mod/lesson:viewreports	moodle_mobile_app
445	mod_lesson_get_pages_possible_jumps	mod_lesson_external	get_pages_possible_jumps	\N	mod_lesson	mod/lesson:view	moodle_mobile_app
446	mod_lesson_get_lesson	mod_lesson_external	get_lesson	\N	mod_lesson	mod/lesson:view	moodle_mobile_app
447	mod_lti_get_tool_launch_data	mod_lti_external	get_tool_launch_data	\N	mod_lti	mod/lti:view	moodle_mobile_app
448	mod_lti_get_ltis_by_courses	mod_lti_external	get_ltis_by_courses	\N	mod_lti	mod/lti:view	moodle_mobile_app
449	mod_lti_view_lti	mod_lti_external	view_lti	\N	mod_lti	mod/lti:view	moodle_mobile_app
450	mod_lti_get_tool_proxies	mod_lti_external	get_tool_proxies	\N	mod_lti	moodle/site:config	\N
451	mod_lti_create_tool_proxy	mod_lti_external	create_tool_proxy	\N	mod_lti	moodle/site:config	\N
452	mod_lti_delete_tool_proxy	mod_lti_external	delete_tool_proxy	\N	mod_lti	moodle/site:config	\N
453	mod_lti_get_tool_proxy_registration_request	mod_lti_external	get_tool_proxy_registration_request	\N	mod_lti	moodle/site:config	\N
454	mod_lti_get_tool_types	mod_lti_external	get_tool_types	\N	mod_lti	moodle/site:config	\N
455	mod_lti_create_tool_type	mod_lti_external	create_tool_type	\N	mod_lti	moodle/site:config	\N
456	mod_lti_update_tool_type	mod_lti_external	update_tool_type	\N	mod_lti	moodle/site:config	\N
457	mod_lti_delete_tool_type	mod_lti_external	delete_tool_type	\N	mod_lti	moodle/site:config	\N
458	mod_lti_is_cartridge	mod_lti_external	is_cartridge	\N	mod_lti	moodle/site:config	\N
459	mod_page_view_page	mod_page_external	view_page	\N	mod_page	mod/page:view	moodle_mobile_app
460	mod_page_get_pages_by_courses	mod_page_external	get_pages_by_courses	\N	mod_page	mod/page:view	moodle_mobile_app
461	mod_quiz_get_quizzes_by_courses	mod_quiz_external	get_quizzes_by_courses	\N	mod_quiz	mod/quiz:view	moodle_mobile_app
462	mod_quiz_view_quiz	mod_quiz_external	view_quiz	\N	mod_quiz	mod/quiz:view	moodle_mobile_app
463	mod_quiz_get_user_attempts	mod_quiz_external	get_user_attempts	\N	mod_quiz	mod/quiz:view	moodle_mobile_app
464	mod_quiz_get_user_best_grade	mod_quiz_external	get_user_best_grade	\N	mod_quiz	mod/quiz:view	moodle_mobile_app
465	mod_quiz_get_combined_review_options	mod_quiz_external	get_combined_review_options	\N	mod_quiz	mod/quiz:view	moodle_mobile_app
466	mod_quiz_start_attempt	mod_quiz_external	start_attempt	\N	mod_quiz	mod/quiz:attempt	moodle_mobile_app
467	mod_quiz_get_attempt_data	mod_quiz_external	get_attempt_data	\N	mod_quiz	mod/quiz:attempt	moodle_mobile_app
468	mod_quiz_get_attempt_summary	mod_quiz_external	get_attempt_summary	\N	mod_quiz	mod/quiz:attempt	moodle_mobile_app
469	mod_quiz_save_attempt	mod_quiz_external	save_attempt	\N	mod_quiz	mod/quiz:attempt	moodle_mobile_app
470	mod_quiz_process_attempt	mod_quiz_external	process_attempt	\N	mod_quiz	mod/quiz:attempt	moodle_mobile_app
471	mod_quiz_get_attempt_review	mod_quiz_external	get_attempt_review	\N	mod_quiz	mod/quiz:reviewmyattempts	moodle_mobile_app
472	mod_quiz_view_attempt	mod_quiz_external	view_attempt	\N	mod_quiz	mod/quiz:attempt	moodle_mobile_app
473	mod_quiz_view_attempt_summary	mod_quiz_external	view_attempt_summary	\N	mod_quiz	mod/quiz:attempt	moodle_mobile_app
474	mod_quiz_view_attempt_review	mod_quiz_external	view_attempt_review	\N	mod_quiz	mod/quiz:reviewmyattempts	moodle_mobile_app
475	mod_quiz_get_quiz_feedback_for_grade	mod_quiz_external	get_quiz_feedback_for_grade	\N	mod_quiz	mod/quiz:view	moodle_mobile_app
476	mod_quiz_get_quiz_access_information	mod_quiz_external	get_quiz_access_information	\N	mod_quiz	mod/quiz:view	moodle_mobile_app
477	mod_quiz_get_attempt_access_information	mod_quiz_external	get_attempt_access_information	\N	mod_quiz	mod/quiz:view	moodle_mobile_app
478	mod_quiz_get_quiz_required_qtypes	mod_quiz_external	get_quiz_required_qtypes	\N	mod_quiz	mod/quiz:view	moodle_mobile_app
479	mod_resource_view_resource	mod_resource_external	view_resource	\N	mod_resource	mod/resource:view	moodle_mobile_app
480	mod_resource_get_resources_by_courses	mod_resource_external	get_resources_by_courses	\N	mod_resource	mod/resource:view	moodle_mobile_app
481	mod_scorm_view_scorm	mod_scorm_external	view_scorm	\N	mod_scorm		moodle_mobile_app
482	mod_scorm_get_scorm_attempt_count	mod_scorm_external	get_scorm_attempt_count	\N	mod_scorm		moodle_mobile_app
483	mod_scorm_get_scorm_scoes	mod_scorm_external	get_scorm_scoes	\N	mod_scorm		moodle_mobile_app
484	mod_scorm_get_scorm_user_data	mod_scorm_external	get_scorm_user_data	\N	mod_scorm		moodle_mobile_app
485	mod_scorm_insert_scorm_tracks	mod_scorm_external	insert_scorm_tracks	\N	mod_scorm	mod/scorm:savetrack	moodle_mobile_app
486	mod_scorm_get_scorm_sco_tracks	mod_scorm_external	get_scorm_sco_tracks	\N	mod_scorm		moodle_mobile_app
487	mod_scorm_get_scorms_by_courses	mod_scorm_external	get_scorms_by_courses	\N	mod_scorm		moodle_mobile_app
488	mod_scorm_launch_sco	mod_scorm_external	launch_sco	\N	mod_scorm		moodle_mobile_app
489	mod_scorm_get_scorm_access_information	mod_scorm_external	get_scorm_access_information	\N	mod_scorm		moodle_mobile_app
490	mod_survey_get_surveys_by_courses	mod_survey_external	get_surveys_by_courses	\N	mod_survey		moodle_mobile_app
491	mod_survey_view_survey	mod_survey_external	view_survey	\N	mod_survey	mod/survey:participate	moodle_mobile_app
492	mod_survey_get_questions	mod_survey_external	get_questions	\N	mod_survey	mod/survey:participate	moodle_mobile_app
493	mod_survey_submit_answers	mod_survey_external	submit_answers	\N	mod_survey	mod/survey:participate	moodle_mobile_app
494	mod_url_view_url	mod_url_external	view_url	\N	mod_url	mod/url:view	moodle_mobile_app
495	mod_url_get_urls_by_courses	mod_url_external	get_urls_by_courses	\N	mod_url	mod/url:view	moodle_mobile_app
496	mod_wiki_get_wikis_by_courses	mod_wiki_external	get_wikis_by_courses	\N	mod_wiki	mod/wiki:viewpage	moodle_mobile_app
497	mod_wiki_view_wiki	mod_wiki_external	view_wiki	\N	mod_wiki	mod/wiki:viewpage	moodle_mobile_app
498	mod_wiki_view_page	mod_wiki_external	view_page	\N	mod_wiki	mod/wiki:viewpage	moodle_mobile_app
499	mod_wiki_get_subwikis	mod_wiki_external	get_subwikis	\N	mod_wiki	mod/wiki:viewpage	moodle_mobile_app
500	mod_wiki_get_subwiki_pages	mod_wiki_external	get_subwiki_pages	\N	mod_wiki	mod/wiki:viewpage	moodle_mobile_app
501	mod_wiki_get_subwiki_files	mod_wiki_external	get_subwiki_files	\N	mod_wiki	mod/wiki:viewpage	moodle_mobile_app
502	mod_wiki_get_page_contents	mod_wiki_external	get_page_contents	\N	mod_wiki	mod/wiki:viewpage	moodle_mobile_app
503	mod_wiki_get_page_for_editing	mod_wiki_external	get_page_for_editing	\N	mod_wiki	mod/wiki:editpage	moodle_mobile_app
504	mod_wiki_new_page	mod_wiki_external	new_page	\N	mod_wiki	mod/wiki:editpage	moodle_mobile_app
505	mod_wiki_edit_page	mod_wiki_external	edit_page	\N	mod_wiki	mod/wiki:editpage	moodle_mobile_app
506	mod_workshop_get_workshops_by_courses	mod_workshop_external	get_workshops_by_courses	\N	mod_workshop	mod/workshop:view	moodle_mobile_app
507	mod_workshop_get_workshop_access_information	mod_workshop_external	get_workshop_access_information	\N	mod_workshop	mod/workshop:view	moodle_mobile_app
508	mod_workshop_get_user_plan	mod_workshop_external	get_user_plan	\N	mod_workshop	mod/workshop:view	moodle_mobile_app
509	mod_workshop_view_workshop	mod_workshop_external	view_workshop	\N	mod_workshop	mod/workshop:view	moodle_mobile_app
510	mod_workshop_add_submission	mod_workshop_external	add_submission	\N	mod_workshop	mod/workshop:submit	moodle_mobile_app
511	mod_workshop_update_submission	mod_workshop_external	update_submission	\N	mod_workshop	mod/workshop:submit	moodle_mobile_app
512	mod_workshop_delete_submission	mod_workshop_external	delete_submission	\N	mod_workshop	mod/workshop:submit	moodle_mobile_app
513	mod_workshop_get_submissions	mod_workshop_external	get_submissions	\N	mod_workshop		moodle_mobile_app
514	mod_workshop_get_submission	mod_workshop_external	get_submission	\N	mod_workshop		moodle_mobile_app
515	mod_workshop_get_submission_assessments	mod_workshop_external	get_submission_assessments	\N	mod_workshop		moodle_mobile_app
516	mod_workshop_get_assessment	mod_workshop_external	get_assessment	\N	mod_workshop		moodle_mobile_app
517	mod_workshop_get_assessment_form_definition	mod_workshop_external	get_assessment_form_definition	\N	mod_workshop		moodle_mobile_app
518	mod_workshop_get_reviewer_assessments	mod_workshop_external	get_reviewer_assessments	\N	mod_workshop		moodle_mobile_app
519	mod_workshop_update_assessment	mod_workshop_external	update_assessment	\N	mod_workshop		moodle_mobile_app
520	mod_workshop_get_grades	mod_workshop_external	get_grades	\N	mod_workshop		moodle_mobile_app
521	mod_workshop_evaluate_assessment	mod_workshop_external	evaluate_assessment	\N	mod_workshop		moodle_mobile_app
522	mod_workshop_get_grades_report	mod_workshop_external	get_grades_report	\N	mod_workshop		moodle_mobile_app
523	mod_workshop_view_submission	mod_workshop_external	view_submission	\N	mod_workshop	mod/workshop:view	moodle_mobile_app
524	mod_workshop_evaluate_submission	mod_workshop_external	evaluate_submission	\N	mod_workshop		moodle_mobile_app
525	auth_email_get_signup_settings	auth_email_external	get_signup_settings	\N	auth_email		\N
526	auth_email_signup_user	auth_email_external	signup_user	\N	auth_email		\N
527	enrol_guest_get_instance_info	enrol_guest_external	get_instance_info	\N	enrol_guest		moodle_mobile_app
528	enrol_manual_enrol_users	enrol_manual_external	enrol_users	enrol/manual/externallib.php	enrol_manual	enrol/manual:enrol	\N
529	enrol_manual_unenrol_users	enrol_manual_external	unenrol_users	enrol/manual/externallib.php	enrol_manual	enrol/manual:unenrol	\N
530	enrol_self_get_instance_info	enrol_self_external	get_instance_info	enrol/self/externallib.php	enrol_self		moodle_mobile_app
531	enrol_self_enrol_user	enrol_self_external	enrol_user	enrol/self/externallib.php	enrol_self		moodle_mobile_app
532	message_airnotifier_is_system_configured	message_airnotifier_external	is_system_configured	message/output/airnotifier/externallib.php	message_airnotifier		moodle_mobile_app
533	message_airnotifier_are_notification_preferences_configured	message_airnotifier_external	are_notification_preferences_configured	message/output/airnotifier/externallib.php	message_airnotifier		moodle_mobile_app
534	message_airnotifier_get_user_devices	message_airnotifier_external	get_user_devices	message/output/airnotifier/externallib.php	message_airnotifier		moodle_mobile_app
535	message_airnotifier_enable_device	message_airnotifier_external	enable_device	message/output/airnotifier/externallib.php	message_airnotifier	message/airnotifier:managedevice	moodle_mobile_app
536	message_popup_get_popup_notifications	message_popup_external	get_popup_notifications	message/output/popup/externallib.php	message_popup		moodle_mobile_app
537	message_popup_get_unread_popup_notification_count	message_popup_external	get_unread_popup_notification_count	message/output/popup/externallib.php	message_popup		moodle_mobile_app
538	block_recentlyaccesseditems_get_recent_items	block_recentlyaccesseditems\\external	get_recent_items	\N	block_recentlyaccesseditems		moodle_mobile_app
539	block_starredcourses_get_starred_courses	block_starredcourses_external	get_starred_courses	block/starredcourses/classes/external.php	block_starredcourses		moodle_mobile_app
540	report_competency_data_for_report	report_competency\\external	data_for_report	\N	report_competency	moodle/competency:coursecompetencyview	\N
541	report_insights_set_notuseful_prediction	report_insights\\external	set_notuseful_prediction	\N	report_insights		moodle_mobile_app
542	report_insights_set_fixed_prediction	report_insights\\external	set_fixed_prediction	\N	report_insights		moodle_mobile_app
543	report_insights_action_executed	report_insights\\external	action_executed	\N	report_insights		moodle_mobile_app
544	gradereport_overview_get_course_grades	gradereport_overview_external	get_course_grades	\N	gradereport_overview		moodle_mobile_app
593	tool_mobile_get_public_config	tool_mobile\\external	get_public_config	\N	tool_mobile		moodle_mobile_app
545	gradereport_overview_view_grade_report	gradereport_overview_external	view_grade_report	\N	gradereport_overview	gradereport/overview:view	moodle_mobile_app
546	gradereport_user_get_grades_table	gradereport_user_external	get_grades_table	grade/report/user/externallib.php	gradereport_user	gradereport/user:view	moodle_mobile_app
547	gradereport_user_view_grade_report	gradereport_user_external	view_grade_report	grade/report/user/externallib.php	gradereport_user	gradereport/user:view	moodle_mobile_app
548	gradereport_user_get_grade_items	gradereport_user_external	get_grade_items	grade/report/user/externallib.php	gradereport_user	gradereport/user:view	moodle_mobile_app
549	gradingform_guide_grader_gradingpanel_fetch	gradingform_guide\\grades\\grader\\gradingpanel\\external\\fetch	execute	\N	gradingform_guide		\N
550	gradingform_guide_grader_gradingpanel_store	gradingform_guide\\grades\\grader\\gradingpanel\\external\\store	execute	\N	gradingform_guide		\N
551	gradingform_rubric_grader_gradingpanel_fetch	gradingform_rubric\\grades\\grader\\gradingpanel\\external\\fetch	execute	\N	gradingform_rubric		\N
552	gradingform_rubric_grader_gradingpanel_store	gradingform_rubric\\grades\\grader\\gradingpanel\\external\\store	execute	\N	gradingform_rubric		\N
553	tool_analytics_potential_contexts	tool_analytics\\external	potential_contexts	\N	tool_analytics		moodle_mobile_app
554	tool_dataprivacy_cancel_data_request	tool_dataprivacy\\external	cancel_data_request	\N	tool_dataprivacy		\N
555	tool_dataprivacy_contact_dpo	tool_dataprivacy\\external	contact_dpo	\N	tool_dataprivacy		\N
556	tool_dataprivacy_mark_complete	tool_dataprivacy\\external	mark_complete	\N	tool_dataprivacy	tool/dataprivacy:managedatarequests	\N
557	tool_dataprivacy_get_data_request	tool_dataprivacy\\external	get_data_request	\N	tool_dataprivacy	tool/dataprivacy:managedatarequests	\N
558	tool_dataprivacy_approve_data_request	tool_dataprivacy\\external	approve_data_request	\N	tool_dataprivacy	tool/dataprivacy:managedatarequests	\N
559	tool_dataprivacy_bulk_approve_data_requests	tool_dataprivacy\\external	bulk_approve_data_requests	\N	tool_dataprivacy	tool/dataprivacy:managedatarequests	\N
560	tool_dataprivacy_deny_data_request	tool_dataprivacy\\external	deny_data_request	\N	tool_dataprivacy	tool/dataprivacy:managedatarequests	\N
561	tool_dataprivacy_bulk_deny_data_requests	tool_dataprivacy\\external	bulk_deny_data_requests	\N	tool_dataprivacy	tool/dataprivacy:managedatarequests	\N
562	tool_dataprivacy_get_users	tool_dataprivacy\\external	get_users	\N	tool_dataprivacy	tool/dataprivacy:managedatarequests	\N
563	tool_dataprivacy_create_purpose_form	tool_dataprivacy\\external	create_purpose_form	\N	tool_dataprivacy		\N
564	tool_dataprivacy_create_category_form	tool_dataprivacy\\external	create_category_form	\N	tool_dataprivacy		\N
565	tool_dataprivacy_delete_purpose	tool_dataprivacy\\external	delete_purpose	\N	tool_dataprivacy		\N
566	tool_dataprivacy_delete_category	tool_dataprivacy\\external	delete_category	\N	tool_dataprivacy		\N
567	tool_dataprivacy_set_contextlevel_form	tool_dataprivacy\\external	set_contextlevel_form	\N	tool_dataprivacy		\N
568	tool_dataprivacy_set_context_form	tool_dataprivacy\\external	set_context_form	\N	tool_dataprivacy		\N
569	tool_dataprivacy_tree_extra_branches	tool_dataprivacy\\external	tree_extra_branches	\N	tool_dataprivacy		\N
570	tool_dataprivacy_confirm_contexts_for_deletion	tool_dataprivacy\\external	confirm_contexts_for_deletion	\N	tool_dataprivacy		\N
571	tool_dataprivacy_set_context_defaults	tool_dataprivacy\\external	set_context_defaults	\N	tool_dataprivacy	tool/dataprivacy:managedataregistry	\N
572	tool_dataprivacy_get_category_options	tool_dataprivacy\\external	get_category_options	\N	tool_dataprivacy	tool/dataprivacy:managedataregistry	\N
573	tool_dataprivacy_get_purpose_options	tool_dataprivacy\\external	get_purpose_options	\N	tool_dataprivacy	tool/dataprivacy:managedataregistry	\N
574	tool_dataprivacy_get_activity_options	tool_dataprivacy\\external	get_activity_options	\N	tool_dataprivacy	tool/dataprivacy:managedataregistry	\N
575	tool_lp_data_for_competency_frameworks_manage_