<?php

/**
* Returns all the school terms active concurrently with another school term at the same school.  The current school term is also returned in a comma seperated list.  ex. get_all_school_term('QTR','1') returns "'1','2','3','0'"
*
* @param String $mp The school term term of the next parameter (QTR for quarters, PRO for progress period, FY for full year, SEM for semester).
* @param int $school_term_id The id of the school term for which we want all other concurrent school terms.
*/
function get_all_school_term($mp,$school_term_id='0')
{	global $_SYSTEM;

	if($school_term_id==0)
	{
		// there should be exactly one fy school term unless the fy does not exist yet
		$array = db_request(db_execute("SELECT SCHOOL_TERM_ID FROM SCHOOL_YEARS WHERE SCHOOL_YEAR='".get_school_year()."' AND SCHOOL_ID='".get_school_id()."'"));
		if(count($array))
		{
			$school_term_id = $array[1]['SCHOOL_TERM_ID'];
			$mp = 'FY';
		}
		else
			return '0';
	}
	elseif(!$mp)
		$mp = get_school_termTable(get_school_term($school_term_id,'MP_TABLE'));

	if(!$_SYSTEM['get_all_school_term'][$mp])
	{
		switch($mp)
		{
			case 'PRO':
				$array = db_request(db_execute("SELECT SCHOOL_TERM_ID FROM SCHOOL_YEARS WHERE SCHOOL_YEAR='".get_school_year()."' AND SCHOOL_ID='".get_school_id()."'"));
				$fy = $array[1]['SCHOOL_TERM_ID'];

				$array = db_request(db_execute("SELECT SCHOOL_TERM_ID,SEMESTER_ID FROM SCHOOL_QUARTERS WHERE SCHOOL_YEAR='".get_school_year()."' AND SCHOOL_ID='".get_school_id()."'"));
				foreach($array as $value)
				{
					$_SYSTEM['get_all_school_term'][$mp][$value['SCHOOL_TERM_ID']] = "'0','$fy','$value[SEMESTER_ID]','$value[SCHOOL_TERM_ID]'";
					$_SYSTEM['get_all_school_term'][$mp][$value['SCHOOL_TERM_ID']] .= ','.get_child_school_term($mp,$value['SCHOOL_TERM_ID']);
					if(substr($_SYSTEM['get_all_school_term'][$mp][$value['SCHOOL_TERM_ID']],-1)==',')
						$_SYSTEM['get_all_school_term'][$mp][$value['SCHOOL_TERM_ID']] = substr($_SYSTEM['get_all_school_term'][$mp][$value['SCHOOL_TERM_ID']],0,-1);
				}
			break;

			case 'QTR':
				$array = db_request(db_execute("SELECT SCHOOL_TERM_ID FROM SCHOOL_YEARS WHERE SCHOOL_YEAR='".get_school_year()."' AND SCHOOL_ID='".get_school_id()."'"));
				$fy = $array[1]['SCHOOL_TERM_ID'];

				$array = db_request(db_execute("SELECT SCHOOL_TERM_ID,SEMESTER_ID FROM SCHOOL_QUARTERS WHERE SCHOOL_YEAR='".get_school_year()."' AND SCHOOL_ID='".get_school_id()."'"));
				foreach($array as $value)
					$_SYSTEM['get_all_school_term'][$mp][$value['SCHOOL_TERM_ID']] = "'0','$fy','$value[SEMESTER_ID]','$value[SCHOOL_TERM_ID]'";
			break;

			case 'SEM':
				$array = db_request(db_execute("SELECT SCHOOL_TERM_ID FROM SCHOOL_YEARS WHERE SCHOOL_YEAR='".get_school_year()."' AND SCHOOL_ID='".get_school_id()."'"));
				$fy = $array[1]['SCHOOL_TERM_ID'];
				$array = db_request(db_execute("SELECT SCHOOL_TERM_ID,SEMESTER_ID FROM SCHOOL_QUARTERS WHERE SCHOOL_YEAR='".get_school_year()."' AND SCHOOL_ID='".get_school_id()."'"),array(),array('SEMESTER_ID'));
				foreach($array as $sem=>$value)
				{
					$_SYSTEM['get_all_school_term'][$mp][$sem] = "'0','$fy','$sem'";
					foreach($value as $qtr)
						$_SYSTEM['get_all_school_term'][$mp][$sem] .= ",'$qtr[SCHOOL_TERM_ID]'";
				}
				// GET DATA FOR SEMESTERS WITHOUT ANY QUARTERS
				$array = db_request(db_execute("SELECT SCHOOL_TERM_ID FROM SCHOOL_SEMESTERS s WHERE NOT EXISTS (SELECT '' FROM SCHOOL_QUARTERS q WHERE q.SEMESTER_ID=s.SCHOOL_TERM_ID) AND SCHOOL_YEAR='".get_school_year()."' AND SCHOOL_ID='".get_school_id()."'"));
				if(count($array))
				{
					foreach($array as $value)
						$_SYSTEM['get_all_school_term'][$mp][$value['SCHOOL_TERM_ID']] = "'0','$fy','$value[SCHOOL_TERM_ID]'";
				}
			break;

			case 'FY':
				$array = db_request(db_execute("SELECT SCHOOL_TERM_ID,SEMESTER_ID FROM SCHOOL_QUARTERS WHERE SCHOOL_YEAR='".get_school_year()."' AND SCHOOL_ID='".get_school_id()."' ORDER BY SORT_ORDER"),array(),array('SEMESTER_ID'));
				$_SYSTEM['get_all_school_term'][$mp][$school_term_id] = "'0'";
				foreach($array as $sem=>$value)
				{
					$_SYSTEM['get_all_school_term'][$mp][$school_term_id] .= ",'$sem'";
					foreach($value as $qtr)
						$_SYSTEM['get_all_school_term'][$mp][$school_term_id] .= ",'$qtr[SCHOOL_TERM_ID]'";
				}
				$array = db_request(db_execute("SELECT SCHOOL_TERM_ID FROM SCHOOL_SEMESTERS s WHERE NOT EXISTS (SELECT '' FROM SCHOOL_QUARTERS q WHERE q.SEMESTER_ID=s.SCHOOL_TERM_ID) AND SCHOOL_YEAR='".get_school_year()."' AND SCHOOL_ID='".get_school_id()."'"));
				foreach($array as $value)
					$_SYSTEM['get_all_school_term'][$mp][$school_term_id] .= ",'$value[SCHOOL_TERM_ID]'";
			break;
		}
	}

	return $_SYSTEM['get_all_school_term'][$mp][$school_term_id];
}

/**
* Returns all the school terms active on some date in a comma seperated list.
*
* @param String $date The date for which we want to find all active school terms (YYYY-MM-DD)
* @param String $date_type The type of date for which we want to find all active school terms (DATE = POSTGRES,POST,REGISTRATION)
* @param String $school The school_id, default 0 = all schools
*/
function get_all_school_termByDate($date,$date_type='POSTGRES',$school=0,$st_table='ALL')
{	global $_SYSTEM;

	// TO MAKE SURE THAT $_SESSION['get_school_term'] is populated
	get_school_term('0');

//	var_dump($_SESSION['get_school_term']);
	foreach($_SESSION['get_school_term'] as $school_term_id=>$mp)
	{
		$mp = $mp[1];
//		var_dump($mp);
		if($mp[$date_type.'_START_DATE'] && $mp[$date_type.'_END_DATE'] && ($mp[$date_type.'_START_DATE']<=$date && $mp[$date_type.'_END_DATE']>=$date))
		{
			if($st_table=='ALL')
			{
				if((!$school || $mp['SCHOOL_ID']==$school) && $mp['SCHOOL_YEAR']==get_school_year())
					$return .= ",'$school_term_id'";
			}
			else
			{
				if((!$school || $mp['SCHOOL_ID']==$school) && $mp['SCHOOL_YEAR']==get_school_year() && $mp['MP_TABLE']==$st_table)
					$return .= ",'$school_term_id'";
			}
			
		}
	}
	$return = substr($return,1);

	return $return;
}

function get_parent_school_term($mp,$school_term_id='0')
{	global $_SYSTEM;
//echo "got in|".$school_term_id;
	if(!$_SYSTEM['get_parent_school_term'][$mp])
	{
//			echo $mp;
		switch($mp)
		{

			case 'QTR':
				$_SYSTEM['get_parent_school_term'][$mp] = db_request(db_execute("SELECT SCHOOL_TERM_ID,QUARTER_ID AS PARENT_ID FROM SCHOOL_WEEKS WHERE SCHOOL_YEAR='".get_school_year()."' AND SCHOOL_ID='".get_school_id()."'"),array(),array('SCHOOL_TERM_ID'));
			break;

			case 'SEM':
				$_SYSTEM['get_parent_school_term'][$mp] = db_request(db_execute("SELECT SCHOOL_TERM_ID,SEMESTER_ID AS PARENT_ID FROM SCHOOL_QUARTERS WHERE SCHOOL_YEAR='".get_school_year()."' AND SCHOOL_ID='".get_school_id()."'"),array(),array('SCHOOL_TERM_ID'));
			break;

			case 'FY':
				$_SYSTEM['get_parent_school_term'][$mp] = db_request(db_execute("SELECT SCHOOL_TERM_ID,YEAR_ID AS PARENT_ID FROM SCHOOL_SEMESTERS WHERE SCHOOL_YEAR='".get_school_year()."' AND SCHOOL_ID='".get_school_id()."'"),array(),array('SCHOOL_TERM_ID'));
			break;
		}

	}
	return $_SYSTEM['get_parent_school_term'][$mp][$school_term_id][1]['PARENT_ID'];
}

function get_child_school_term($mp,$school_term_id='0')
{	global $_SYSTEM;

	switch($mp)
	{
		case 'FY':
			if(!$_SYSTEM['get_child_school_term']['FY'])
			{
				$array = db_request(db_execute("SELECT SCHOOL_TERM_ID,SEMESTER_ID FROM SCHOOL_QUARTERS WHERE SCHOOL_YEAR='".get_school_year()."' AND SCHOOL_ID='".get_school_id()."'"),array(),array('SEMESTER_ID'));
				foreach($array as $sem=>$value)
				{
					$_SYSTEM['get_child_school_term'][$mp]['0'] .= ",'$sem'";
					foreach($value as $qtr)
						$_SYSTEM['get_child_school_term'][$mp]['0'] .= ",'$qtr[SCHOOL_TERM_ID]'";
				}
				$_SYSTEM['get_child_school_term'][$mp]['0'] = substr($_SYSTEM['get_child_school_term'][$mp]['0'],1);
			}
			return $_SYSTEM['get_child_school_term'][$mp]['0'];
		break;

		case 'SEM':
			if(get_school_term($school_term_id,'MP_TABLE')=='SCHOOL_QUARTERS')
				$school_term_id = get_parent_school_term('SEM',$school_term_id);
			if(!$_SYSTEM['get_child_school_term']['SEM'])
			{
				$array = db_request(db_execute("SELECT SCHOOL_TERM_ID,SEMESTER_ID FROM SCHOOL_QUARTERS WHERE SCHOOL_YEAR='".get_school_year()."' AND SCHOOL_ID='".get_school_id()."'"),array(),array('SEMESTER_ID'));
				foreach($array as $sem=>$value)
				{
					foreach($value as $qtr)
						$_SYSTEM['get_child_school_term'][$mp][$sem] .= ",'$qtr[SCHOOL_TERM_ID]'";
					$_SYSTEM['get_child_school_term'][$mp][$sem] = substr($_SYSTEM['get_child_school_term'][$mp][$sem],1);
				}
			}
			return $_SYSTEM['get_child_school_term'][$mp][$school_term_id];
		break;

		case 'QTR':
			return "'".$school_term_id."'";
		break;

		case 'PRO':
			if(!$_SYSTEM['get_child_school_term']['PRO'])
			{
				$array = db_request(db_execute("SELECT SCHOOL_TERM_ID,QUARTER_ID FROM SCHOOL_WEEKS WHERE SCHOOL_YEAR='".get_school_year()."' AND SCHOOL_ID='".get_school_id()."'"),array(),array('QUARTER_ID'));
				foreach($array as $qtr=>$value)
				{
					foreach($value as $pro)
						$_SYSTEM['get_child_school_term'][$mp][$qtr] .= ",'$pro[SCHOOL_TERM_ID]'";
					$_SYSTEM['get_child_school_term'][$mp][$qtr] = substr($_SYSTEM['get_child_school_term'][$mp][$qtr],1);
				}
			}
			return $_SYSTEM['get_child_school_term'][$mp][$school_term_id];
		break;
	}
}

function GetAllTerms($table)
{	global $_SYSTEM;

	$mps_array = db_request(db_execute("SELECT SCHOOL_TERM_ID FROM ".$table." ORDER BY SCHOOL_YEAR DESC,SORT_ORDER ASC"),array(),array('SCHOOL_TERM_ID'));
	foreach($mps_array as $mp_id=>$mp)
	{
		$mp_list .= ",'$mp_id'";
	}
	$mp_list = substr($mp_list,1);
	
	return $mp_list;
}

function get_school_terms_by_year($table,$school_year)
{	global $_SYSTEM;

	if(!$school_year) $school_year = get_school_year();
	$sta_array = db_request(db_execute("SELECT SCHOOL_TERM_ID FROM ".$table." WHERE SCHOOL_YEAR = ".$school_year." AND SCHOOL_ID = ".get_school_id()." ORDER BY SCHOOL_YEAR DESC,SORT_ORDER ASC"),array(),array('SCHOOL_TERM_ID'));
	foreach($sta_array as $st_id=>$st)
	{
		$st_list .= ",'$st_id'";
	}
	$st_list = substr($st_list,1);
	
	return $st_list;
}

function SortSchoolTerms($school_term_type,$school_terms_id)
{
	global $_SYSTEM;
	$i=0;
	if(!is_array($school_terms_id))
	{
		$school_terms_id = str_replace("'","",$school_terms_id);
	    	$school_terms_id = explode(',',$school_terms_id);
	}
	switch($school_term_type)
	{
		case 'SEM':
			$table = 'SCHOOL_SEMESTERS';
		break;		
		case 'QTR':
			$table = 'SCHOOL_QUARTERS';
		break;		
	}	
	$school_term_arr = db_request(db_execute("SELECT SCHOOL_TERM_ID,SORT_ORDER FROM ".$table." ORDER BY SCHOOL_YEAR DESC,SORT_ORDER ASC"),array(),array('SCHOOL_TERM_ID'));
	foreach($school_term_arr as $st_id=>$so)
	{
		if(in_array($st_id, $school_terms_id))
		{
			if($so[1]['SORT_ORDER'])
				$st_list_arr[$so[1]['SORT_ORDER']]=$st_id;
			else
			{	$i++;
				$st_list_arr[$i]=$st_id;
			}
		}
	}
	foreach($st_list_arr as $st_sorted_id)
	{
		if(!is_array($school_terms_id))
		{
			$st_list .= ",'".$st_sorted_id."'";
			$st_list = substr($st_list,1);
		}
		else
			$st_list[] = $st_sorted_id;
	}
	

	return $st_list;
}

?>