<?php
require_once ($staticpath."modules/mod_portal/date_to_ru.php");

set_time_limit(0);
DisplayHeader(".:".ProgramTitle().":.");
DisplayHeader('<DIV style="width:800;padding-left:10px;">'.
    sprintf(_('This function works only if the school changes anything affecting the Attendance setup.'),strtolower($plural)).'</DIV><BR>');
    
    
//    Use this program when you change the attendance system preferences during the middle of the year and need to have AIS Integral recalculate daily attendance using the new system preferences. If you havent changed any attendance-related system preferences, this program will have no effect.'),strtolower($plural)).'</DIV><BR>');

$message = '<TABLE><TR><TD colspan=7 align=center>'._('Start Date').PrepareDate(get_db_date(),'_min').'<BR>'._('End Date').'&nbsp;'.PrepareDate(get_db_date(),'_max').'</TD></TR></TABLE>';
if(Prompt(_('Recalculation'),_('Choose a period of time for daily attendance recalculation.'),$message))
{
	$current_array = db_request(db_execute("SELECT DISTINCT ".db_to_char('SCHOOL_DATE','dd-MON-yy')." as SCHOOL_DATE FROM SCHOOL_CALENDAR_DAYS WHERE SCHOOL_ID='".get_school_id()."' AND SCHOOL_YEAR='".get_school_year()."'"),array(),array('SCHOOL_DATE'));
	$_REQUEST['include_inactive'] = 'Y';
	$addition = array('SELECT_ONLY'=>'ssm.STUDENT_ID');
	$students_array = get_student_list($addition);

	$begin = mktime(0,0,0,MonthNWSwitch($_REQUEST['month_min'],'to_num'),$_REQUEST['day_min']*1,$_REQUEST['year_min']) + 43200; // add half a day so as not to be affected by day light savings time
	$end = mktime(0,0,0,MonthNWSwitch($_REQUEST['month_max'],'to_num'),$_REQUEST['day_max']*1,$_REQUEST['year_max']) + 43200;

	for($i=$begin;$i<=$end;$i+=86400)
	{
		if($current_array[strtoupper(date('d-M-y',$i))])
		{
			// THESE QUERIES JOIN ON SCHOOL_QUARTERS TO LIMIT THE RECORDS TO THOSE AT THE CURRENT SCHOOL.  HOWEVER, IF A SCHOOL DELETES A SCHOOL_TERM, THIS COULD POTENTIALLY CAUSE A PROBLEM. 
			$date = strtoupper(date('d-M-y',$i));
			$time = mktime(0,0,0,(MonthNWSwitch(substr($date,3,3))*1),(substr($date,0,2)*1),substr($date,7));
			$day = date('D',$time);
                        /*                                     			
		     if (Preferences('LANGUAGE') == 'ru_RU')
		     {
		        $day_en = $day;
			switch($day)
			{
				case 'Sun':
				    $day = 'Вс';
				    $day_en = 'U';
				break;
				case 'Thu':
				    $day = 'Чт';
				    $day_en = 'H';
				break;
				default:
					//$day = substr($day,0,2);
				    $day = change_date_ru('days_replace',$day);
				break;
			    }
		        }
                	else
                        {
                            switch($day)
                    	    {
                        	case 'Sun':
                            	    $day = 'U';
                                break;
                                case 'Thu':
                            	    $day = 'H';
                                break;
                                default:
                            	    $day = substr($day,0,1);
                                break;
                            }
                         }
*/
			if(SystemPreferences('VARIABLE_PERIOD_LENGTH')=='Y')
			{
//			    if (Preferences('LANGUAGE') == 'ru_RU')
//				$length_col = 'LENGTH_'.$day_en;
//			    else
				$length_col = 'LENGTH_'.$day;
			}
			else
				$length_col = 'LENGTH';

			$sql = "SELECT 
						sum(sp.".$length_col.") AS TOTAL,s.STUDENT_ID
					FROM STUDENT_SCHEDULE s,COURSE_SECTIONS cs,SCHOOL_PERIODS sp,SCHOOL_CALENDAR_DAYS ac
					WHERE
						s.COURSE_SECTION_ID = cs.COURSE_SECTION_ID AND cs.DOES_ATTENDANCE='Y'
						AND ac.SCHOOL_DATE='$date' AND (ac.BLOCK=sp.BLOCK OR sp.BLOCK IS NULL)
						AND ac.CALENDAR_ID=cs.CALENDAR_ID AND ac.SCHOOL_ID=s.SCHOOL_ID AND ac.SCHOOL_YEAR=s.SCHOOL_YEAR
						AND s.SCHOOL_YEAR = cs.SCHOOL_YEAR AND sp.SCHOOL_PERIOD_ID = cs.SCHOOL_PERIOD_ID
						AND cs.DAYS LIKE '%".$day."%'
						AND s.SCHOOL_ID='".get_school_id()."' 
						AND s.SCHOOL_YEAR='".get_school_year()."' 
						AND ('".$date."' BETWEEN s.START_DATE AND s.END_DATE OR (s.END_DATE IS NULL AND '$date'>=s.START_DATE))
						AND s.SCHOOL_TERM_ID IN (".get_all_school_term('QTR',get_current_school_term('QTR',$date)).")
					GROUP BY s.STUDENT_ID
					";
			$_SYSTEM['UpdateAttendanceDaily']['schedule_total'][$date] = db_request(db_execute($sql),null,array('STUDENT_ID'));
			
			$_SYSTEM['UpdateAttendanceDaily']['current_array'][$date] = db_request(db_execute("SELECT ad.MINUTES_PRESENT,ad.STATE_VALUE,ad.COMMENT,ad.DAILY_CODE,ad.STUDENT_ID FROM STUDENT_ATTENDANCE_DAYS ad,SCHOOL_QUARTERS q WHERE q.SCHOOL_TERM_ID=ad.SCHOOL_TERM_ID AND q.SCHOOL_YEAR='".get_school_year()."' AND ad.SCHOOL_DATE='$date'"),null,array('STUDENT_ID'));
			
			$sql = "SELECT sum(sp.".$length_col.") AS TOTAL,ap.STUDENT_ID
					FROM STUDENT_ATTENDANCE_PERIODS ap,SCHOOL_PERIODS sp,ATTENDANCE_CODES_SETTINGS ac, SCHOOL_QUARTERS q
					WHERE ap.SCHOOL_TERM_ID=q.SCHOOL_TERM_ID AND ap.SCHOOL_DATE='$date' AND ap.SCHOOL_PERIOD_ID=sp.SCHOOL_PERIOD_ID AND ac.ID = ap.ATTENDANCE_CODE AND ac.STATE_CODE='A'
					AND sp.SCHOOL_YEAR='".get_school_year()."' GROUP BY ap.STUDENT_ID";
			$_SYSTEM['UpdateAttendanceDaily']['absent_array'][$date] = db_request(db_execute($sql),null,array('STUDENT_ID'));
	
			$sql = "SELECT sum(sp.".$length_col.") AS TOTAL,ap.STUDENT_ID
					FROM STUDENT_ATTENDANCE_PERIODS ap,SCHOOL_PERIODS sp,ATTENDANCE_CODES_SETTINGS ac, SCHOOL_QUARTERS q
					WHERE ap.SCHOOL_TERM_ID=q.SCHOOL_TERM_ID AND ap.SCHOOL_DATE='$date' AND ap.SCHOOL_PERIOD_ID=sp.SCHOOL_PERIOD_ID AND ac.ID = ap.ATTENDANCE_CODE AND ac.STATE_CODE='H'
						AND sp.SCHOOL_YEAR='".get_school_year()."'
					GROUP BY ap.STUDENT_ID
					";
			$_SYSTEM['UpdateAttendanceDaily']['half_array'][$date] = db_request(db_execute($sql),null,array('STUDENT_ID'));
			
			$_SYSTEM['UpdateAttendanceDaily']['daily_code_array'][$date] = db_request(db_execute("SELECT ac.SHORT_NAME,ap.STUDENT_ID FROM STUDENT_ATTENDANCE_PERIODS ap,ATTENDANCE_CODES_SETTINGS ac WHERE ac.ID = ap.ATTENDANCE_CODE AND ac.SCHOOL_ID='".get_school_id()."' AND ap.SCHOOL_DATE='$date' AND ac.IS_DAILY_CODE='Y' ORDER BY ac.SORT_ORDER"),null,array('STUDENT_ID'));

			foreach($students_array as $student)
			{
				UpdateAttendanceDaily($student['STUDENT_ID'],date('d-M-y',$i));
			}
		}
	}
	
	unset($_REQUEST['servicefunction']);
	DisplayHeader('<IMG SRC=images/check.gif> '._('The Daily Attendance for this period of time has been successfully recalculated.'));
}

?>