CREATE TABLE [dbo].[roundcube_cache] (
        [cache_id] [int] IDENTITY (1, 1) NOT NULL ,
        [user_id] [int] NOT NULL ,
        [session_id] [varchar] (32) COLLATE Latin1_General_CI_AI NULL ,
        [cache_key] [varchar] (128) COLLATE Latin1_General_CI_AI NOT NULL ,
        [created] [datetime] NOT NULL ,
        [data] [text] COLLATE Latin1_General_CI_AI NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[roundcube_contacts] (
        [contact_id] [int] IDENTITY (1, 1) NOT NULL ,
        [user_id] [int] NOT NULL ,
        [changed] [datetime] NOT NULL ,
        [del] [char] (1) COLLATE Latin1_General_CI_AI NOT NULL ,
        [name] [varchar] (128) COLLATE Latin1_General_CI_AI NOT NULL ,
        [email] [varchar] (128) COLLATE Latin1_General_CI_AI NOT NULL ,
        [firstname] [varchar] (128) COLLATE Latin1_General_CI_AI NOT NULL ,
        [surname] [varchar] (128) COLLATE Latin1_General_CI_AI NOT NULL ,
        [vcard] [text] COLLATE Latin1_General_CI_AI NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[roundcube_identities] (
        [identity_id] [int] IDENTITY (1, 1) NOT NULL ,
        [user_id] [int] NOT NULL ,
        [del] [char] (1) COLLATE Latin1_General_CI_AI NOT NULL ,
        [standard] [char] (1) COLLATE Latin1_General_CI_AI NOT NULL ,
        [name] [varchar] (128) COLLATE Latin1_General_CI_AI NOT NULL ,
        [organization] [varchar] (128) COLLATE Latin1_General_CI_AI NOT NULL ,
        [email] [varchar] (128) COLLATE Latin1_General_CI_AI NOT NULL ,
        [reply-to] [varchar] (128) COLLATE Latin1_General_CI_AI NOT NULL ,
        [bcc] [varchar] (128) COLLATE Latin1_General_CI_AI NOT NULL ,
        [signature] [text] COLLATE Latin1_General_CI_AI NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[roundcube_messages] (
        [message_id] [int] IDENTITY (1, 1) NOT NULL ,
        [user_id] [int] NOT NULL ,
        [del] [tinyint] NOT NULL ,
        [cache_key] [varchar] (128) COLLATE Latin1_General_CI_AI NOT NULL ,
        [created] [datetime] NOT NULL ,
        [idx] [int] NOT NULL ,
        [uid] [int] NOT NULL ,
        [subject] [varchar] (255) COLLATE Latin1_General_CI_AI NOT NULL ,
        [from] [varchar] (255) COLLATE Latin1_General_CI_AI NOT NULL ,
        [to] [varchar] (255) COLLATE Latin1_General_CI_AI NOT NULL ,
        [cc] [varchar] (255) COLLATE Latin1_General_CI_AI NOT NULL ,
        [date] [datetime] NOT NULL ,
        [size] [int] NOT NULL ,
        [headers] [text] COLLATE Latin1_General_CI_AI NOT NULL ,
        [structure] [text] COLLATE Latin1_General_CI_AI NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[roundcube_session] (
        [sess_id] [varchar] (32) COLLATE Latin1_General_CI_AI NOT NULL ,
        [created] [datetime] NOT NULL ,
        [changed] [datetime] NULL ,
        [ip] [varchar] (40) COLLATE Latin1_General_CI_AI NOT NULL ,
        [vars] [text] COLLATE Latin1_General_CI_AI NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[roundcube_users] (
        [user_id] [int] IDENTITY (1, 1) NOT NULL ,
        [username] [varchar] (128) COLLATE Latin1_General_CI_AI NOT NULL ,
        [mail_host] [varchar] (128) COLLATE Latin1_General_CI_AI NOT NULL ,
        [alias] [varchar] (128) COLLATE Latin1_General_CI_AI NOT NULL ,
        [created] [datetime] NOT NULL ,
        [last_login] [datetime] NULL ,
        [language] [varchar] (5) COLLATE Latin1_General_CI_AI NOT NULL ,
        [preferences] [text] COLLATE Latin1_General_CI_AI NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

ALTER TABLE [dbo].[roundcube_cache] WITH NOCHECK ADD
         PRIMARY KEY  CLUSTERED
        (
                [cache_id]
        )  ON [PRIMARY]
GO

ALTER TABLE [dbo].[roundcube_contacts] WITH NOCHECK ADD
        CONSTRAINT [PK_contacts_contact_id] PRIMARY KEY  CLUSTERED
        (
                [contact_id]
        )  ON [PRIMARY]
GO

ALTER TABLE [dbo].[roundcube_identities] WITH NOCHECK ADD
         PRIMARY KEY  CLUSTERED
        (
                [identity_id]
        )  ON [PRIMARY]
GO

ALTER TABLE [dbo].[roundcube_messages] WITH NOCHECK ADD
         PRIMARY KEY  CLUSTERED
        (
                [message_id]
        )  ON [PRIMARY]
GO

ALTER TABLE [dbo].[roundcube_session] WITH NOCHECK ADD
        CONSTRAINT [PK_session_sess_id] PRIMARY KEY  CLUSTERED
        (
                [sess_id]
        )  ON [PRIMARY]
GO

ALTER TABLE [dbo].[roundcube_users] WITH NOCHECK ADD
        CONSTRAINT [PK_users_user_id] PRIMARY KEY  CLUSTERED
        (
                [user_id]
        )  ON [PRIMARY]
GO

ALTER TABLE [dbo].[roundcube_cache] ADD
        CONSTRAINT [DF_cache_user_id] DEFAULT ('0') FOR [user_id],
        CONSTRAINT [DF_cache_session_id] DEFAULT (null) FOR [session_id],
        CONSTRAINT [DF_cache_cache_key] DEFAULT ('') FOR [cache_key],
        CONSTRAINT [DF_cache_created] DEFAULT (getdate()) FOR [created]
GO

 CREATE  INDEX [IX_cache_user_id] ON [dbo].[roundcube_cache]([user_id]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_cache_cache_key] ON [dbo].[roundcube_cache]([cache_key]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_cache_session_id] ON [dbo].[roundcube_cache]([session_id]) ON [PRIMARY]
GO

ALTER TABLE [dbo].[roundcube_contacts] ADD
        CONSTRAINT [DF_contacts_user_id] DEFAULT (0) FOR [user_id],
        CONSTRAINT [DF_contacts_changed] DEFAULT (getdate()) FOR [changed],
        CONSTRAINT [DF_contacts_del] DEFAULT ('0') FOR [del],
        CONSTRAINT [DF_contacts_name] DEFAULT ('') FOR [name],
        CONSTRAINT [DF_contacts_email] DEFAULT ('') FOR [email],
        CONSTRAINT [DF_contacts_firstname] DEFAULT ('') FOR [firstname],
        CONSTRAINT [DF_contacts_surname] DEFAULT ('') FOR [surname],
        CONSTRAINT [CK_contacts_del] CHECK ([del] = '1' or [del] = '0')
GO

 CREATE  INDEX [IX_contacts_user_id] ON [dbo].[roundcube_contacts]([user_id]) ON [PRIMARY]
GO

ALTER TABLE [dbo].[roundcube_identities] ADD
        CONSTRAINT [DF_identities_user] DEFAULT ('0') FOR [user_id],
        CONSTRAINT [DF_identities_del] DEFAULT ('0') FOR [del],
        CONSTRAINT [DF_identities_standard] DEFAULT ('0') FOR [standard],
        CONSTRAINT [DF_identities_name] DEFAULT ('') FOR [name],
        CONSTRAINT [DF_identities_organization] DEFAULT ('') FOR [organization],
        CONSTRAINT [DF_identities_email] DEFAULT ('') FOR [email],
        CONSTRAINT [DF_identities_reply] DEFAULT ('') FOR [reply-to],
        CONSTRAINT [DF_identities_bcc] DEFAULT ('') FOR [bcc],
         CHECK ([standard] = '1' or [standard] = '0'),
         CHECK ([del] = '1' or [del] = '0')
GO

 CREATE  INDEX [IX_identities_user_id] ON [dbo].[roundcube_identities]([user_id]) ON [PRIMARY]
GO

ALTER TABLE [dbo].[roundcube_messages] ADD
        CONSTRAINT [DF_messages_user_id] DEFAULT (0) FOR [user_id],
        CONSTRAINT [DF_messages_del] DEFAULT (0) FOR [del],
        CONSTRAINT [DF_messages_cache_key] DEFAULT ('') FOR [cache_key],
        CONSTRAINT [DF_messages_created] DEFAULT (getdate()) FOR [created],
        CONSTRAINT [DF_messages_idx] DEFAULT (0) FOR [idx],
        CONSTRAINT [DF_messages_uid] DEFAULT (0) FOR [uid],
        CONSTRAINT [DF_messages_subject] DEFAULT ('') FOR [subject],
        CONSTRAINT [DF_messages_from] DEFAULT ('') FOR [from],
        CONSTRAINT [DF_messages_to] DEFAULT ('') FOR [to],
        CONSTRAINT [DF_messages_cc] DEFAULT ('') FOR [cc],
        CONSTRAINT [DF_messages_date] DEFAULT (getdate()) FOR [date],
        CONSTRAINT [DF_messages_size] DEFAULT (0) FOR [size]
GO

 CREATE  INDEX [IX_messages_user_id] ON [dbo].[roundcube_messages]([user_id]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_messages_cache_key] ON [dbo].[roundcube_messages]([cache_key]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_messages_idx] ON [dbo].[roundcube_messages]([idx]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_messages_uid] ON [dbo].[roundcube_messages]([uid]) ON [PRIMARY]
GO

ALTER TABLE [dbo].[roundcube_session] ADD
        CONSTRAINT [DF_session_sess_id] DEFAULT ('') FOR [sess_id],
        CONSTRAINT [DF_session_created] DEFAULT (getdate()) FOR [created],
        CONSTRAINT [DF_session_ip] DEFAULT ('') FOR [ip]
GO

ALTER TABLE [dbo].[roundcube_users] ADD
        CONSTRAINT [DF_users_username] DEFAULT ('') FOR [username],
        CONSTRAINT [DF_users_mail_host] DEFAULT ('') FOR [mail_host],
        CONSTRAINT [DF_users_alias] DEFAULT ('') FOR [alias],
        CONSTRAINT [DF_users_created] DEFAULT (getdate()) FOR [created],
        CONSTRAINT [DF_users_language] DEFAULT ('en') FOR [language]
GO