<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

$string['actions'] = 'Actions';
$string['addnewchildcompany'] = 'Add a new child company';
$string['addnewcompany'] = 'Add a new company';
$string['allcourses'] = 'All courses';
$string['alltemplates'] = 'All competency templates';
$string['allframeworks'] = 'All competency frameworks';
$string['allemails'] = 'Both completion and reminder emails';
$string['allocated'] = 'Allocated';
$string['allocatedcourses'] = 'Allocated courses';
$string['alphabet'] = 'A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z';
$string['appearance'] = 'Appearance';
$string['applyemailtemplate'] = 'Apply email template set (Previously applied was {$a})';
$string['applyemailtemplate_help'] = 'Applying this email template will replace the current company email template setting with those from the chosen email template set.';
$string['applyroletemplate'] = 'Apply role template (Previously applied was {$a})';
$string['assigncompetencytemplates'] = 'Assign company learning plan templates';
$string['assigncompetencyframeworks'] = 'Assign company competency frameworks';
$string['assigncourses'] = 'Assign courses';
$string['assigncoursegroups'] = 'Assign course groups';
$string['assigneducator'] = 'Assign as educator';
$string['assignlicenses'] = 'Assign licenses';
$string['assignmanagers'] = 'Assign department users/managers';
$string['assigntocompany'] = 'Assign to company';
$string['assigntocompany'] = 'Assign to company';
$string['assignusers'] = 'Assign users';
$string['availabletemplates'] = 'Available role templates';
$string['availabletemplates_help'] = 'These are the list of role templates which are available to company managers when creating a child company';
$string['backtocompanytemplate'] = 'Back to company template';
$string['autocourses'] = 'Autoenrolment courses';
$string['autocourses_help'] = 'This is the list of courses which users created using the local Iomad Signup process will automatically get enrolled on.';
$string['bgcolor_content'] = 'Content Background Colour';
$string['bgcolor_header'] = 'Header Background Colour';
$string['blocktitle'] = 'Company / User Admin';
$string['cantdeletedepartment'] = 'You cannot delete this department until all of the users are removed.';
$string['cantdeletetopdepartment'] = 'You cannot delete the top level department';
$string['cantedittopdepartment'] = 'You cannot edit the top level department';
$string['certificatedesign'] = 'Certificate design';
$string['classroom_capacity'] = 'Room capacity';
$string['classroom_delete_checkfull'] = 'Are you absolutely sure you want to delete {$a}?';
$string['classroom_delete'] = 'Delete teaching location';
$string['classroom_name'] = 'Room name/number';
$string['classrooms_add'] = 'Add a teaching location';
$string['classrooms_edit'] = 'Edit teaching location';
$string['classrooms_for'] = 'Teaching locations for {$a}';
$string['classrooms'] = 'Teaching locations';
$string['classroom'] = 'Teaching location';
$string['classroomaddedok'] = 'The teaching location was added successfully';
$string['classroomdeletedok'] = 'The teaching location was deleted successfully';
$string['classroomupdatedok'] = 'The teaching location was updated successfully';
$string['clearonexpire'] = 'Clear on expire';
$string['clearonexpire_help'] = 'All user course interactions will be cleared down for all users with incomplete licenses after the cut-off date is reached';
$string['closed'] = 'Closed sharing';
$string['choosecompletiontype'] = 'Select completion status';
$string['companycity'] = 'Location (Town/City)';
$string['companycityfilter'] = 'Company location contains';
$string['companycode'] = 'Company code';
$string['companycodetaken'] = 'Company code is already in use in the system';
$string['companygroupsusers'] = 'Manage course groups for ';
$string['company'] = 'Company';
$string['companies'] = 'Companies';
$string['companycertificateseal'] = 'Certificate logo';
$string['companycertificateseal_help'] = 'This image will replace the default site logo for issued certificates where appropriate. The uploaded image should be 80 pixels high and have a transparent background.';
$string['companycertificatesignature'] = 'Certificate signature';
$string['companycertificatesignature_help'] = 'This image will replace the default site signature for issued certificates where appropriate. The uploaded image should be 31 pixels x 150 pixels and have a transparent background';
$string['companycertificateborder'] = 'Certificate border';
$string['companycertificateborder_help'] = 'This image will replace the default site border for issued certificates where appropriate. The uploaded image should be 800 pixels x 604 pixels.';
$string['companycertificatewatermark'] = 'Certificate watermark';
$string['companycertificatewatermark_help'] = 'This image will replace the default site watermark for issued certificates where appropriate. The uploaded image should be no more than 800 pixels x 604 pixels.';
$string['companycount'] = '{$a} Company';
$string['companycountplural'] = '{$a} Companies';
$string['companycountryfilter'] = 'Company country contains';
$string['companycourse'] = 'Course details';
$string['company_course_form_title'] = 'Manage company courses';
$string['companycourses'] = 'Company courses';
$string['company_courses'] = 'Courses';
$string['company_courses_for'] = 'Company courses for \'{$a}\'';
$string['companycoursesmatching'] = 'Company courses matching \'{$a}\'';
$string['company_course_users_title'] = 'Assign users to course';
$string['companycreated'] = 'Company created';
$string['companycreatedok'] = 'Company was created successfully';
$string['companydeletecheckfull'] = 'Are you absolutely sure you want to completely delete {$a} and its users ?';
$string['companydeletelicensecheckfull'] = 'Are you absolutely sure you want to completely delete {$a}?';
$string['companydepartment'] = 'Company departments for ';
$string['companydomains'] = 'List of company domains';
$string['companydomains_help'] = 'This is the list of company email domains which will be used to auto assign users to this company through the local Iomad signup plugin.';
$string['company_edit_advanced_title'] = 'Editing User';
$string['company_edit_users_title'] = 'Edit Users';
$string['company_edit_companies_title'] = 'Edit Companies';
$string['companyfilter'] = 'Filter results';
$string['companyframeworks'] = 'Assign frameworks to company';
$string['company_frameworks_for'] = 'Company competency frameworks for \'{$a}\'';
$string['companygroups'] = 'Groups for ';
$string['companyhostname'] = 'Webserver hostname';
$string['companyhostname_help'] = 'If this is defined and the user accesses the site using this hostname they will be redirected to login page branded for this company.';
$string['companyhostnametaken'] = 'Hostname is already used for another company ({$a})';
$string['companymaxusers'] = 'Maximum active users';
$string['companymaxusers_help'] = 'This sets the maximum number of active users allowed for this company.';
$string['companysuspendafter'] = 'Suspend after';
$string['companysuspendafter_help'] = 'If there is a contract end date for the company, the company and all if its users will be suspended after this timeframe.  The company can be unsuspended but the contract end date will need to be updated first to prevent it from being suspended again.';
$string['companyvalidto'] = 'Contract end date';
$string['companyvalidto_help'] = 'This is the date after which all of the companies course access and licenses will be removed.  If there is a value for the "Suspend after" field, then the company and all of its users will automatically be suspended from the system too.  All reporting information is still kept.';
$string['compfromraw'] = 'Start date';
$string['comptoraw'] = 'End date';
$string['couldnotdeletecourse'] = 'Course could not be deleted';
$string['couldnotremovecoursefromcompany'] = 'Course could not be removed from the company';
$string['currcompanyframeworks'] = 'Assigned frameworks';
$string['currcompanyframeworksmatching'] = 'Assigned frameworks matching\'{$a}\'';
$string['companylicensecreated'] = 'Company license created';
$string['companylicensedeleted'] = 'Company license deleted';
$string['companylicenseupdated'] = 'Company license updated';
$string['company_license_list_title'] = 'List Company Licenses';
$string['company_license_users_title'] = 'Manage user license allocations';
$string['company_list_title'] = 'Company Overview';
$string['companylogo'] = 'Company Logo';
$string['companymanagement'] = 'Companies';
$string['company_manager_form_title'] = 'Assign department users/managers';
$string['companymanager'] = 'Company manager';
$string['companymanagers'] = 'Company managers';
$string['company_managers_for'] = 'Company managers for \'{$a}\'';
$string['company_managers'] = 'Managers';
$string['companymanagersforminfo'] = 'Select the users in either the left or right box and click on the button to update';
$string['companymanagersmatching'] = 'Company managers matching \'{$a}\'';
$string['companyname'] = 'Long Name';
$string['companynamefilter'] = 'Company name contains';
$string['companynametaken'] = 'Long name is already used for another company ({$a})';
$string['companyoverview'] = 'Company overview';
$string['companyprofilefields'] = ' Company Additional Profile Fields';
$string['companyprofileshortname'] = 'Short name (must be unique)';
$string['companyreporters'] = 'Company reporters';
$string['companysavedok'] = 'Company details saved successfully';
$string['companysearchfields'] = 'Company search fields';
$string['companyshortname'] = 'Short Name';
$string['companyshortnametaken'] = 'Short name is already used for another company ({$a})';
$string['company_showgrade'] = 'Display course grade on company certificate';
$string['company_showgrade_help'] = 'If you are using the company certificate type then unchecking this will remove any text for the user\'s grade for this company';
$string['companysuspended'] = 'Company suspended';
$string['company_templates_for'] = 'Company learning plan templates for {$a}';
$string['companyterminated'] = 'Company terminated';
$string['companytemplates'] = 'Assign learning plan templates to company';
$string['companyupdated'] = 'Company updated';
$string['companyunsuspended'] = 'Company un-suspended';
$string['company_uselogo'] = 'Display logo on company certificate';
$string['company_uselogo_help'] = 'If you are using the company certificate type then unchecking this will remove any certificate seal image for this company';
$string['company_usesignature'] = 'Display signature on company certificate';
$string['company_usesignature_help'] = 'If you are using the company certificate type then unchecking this will remove any certificate signature image for this company';
$string['company_useborder'] = 'Display border on company certificate';
$string['company_useborder_help'] = 'If you are using the company certificate type then unchecking this will remove any certificate border image for this company';
$string['company_usewatermark'] = 'Display watermark on company certificate';
$string['company_usewatermark_help'] = 'If you are using the company certificate type then unchecking this will remove any certificate watermark image for this company';
$string['currcompanytemplates'] = 'Assigned templates';
$string['currcompanytemplatesmatching'] = 'Assigned templates matching \'{$a}\'';
$string['currentcompany'] = 'Your company is \'{$a}\'';
$string['companyadvanced'] = 'Advanced Company Settings';
$string['company_competency_framework_form_title'] = 'Manage company competency frameworks';
$string['company_competency_template_form_title'] = 'Manage company learning plan templates';
$string['companyuser'] = 'Company user ({$a})';
$string['companyuserassigned'] = 'Company user assigned';
$string['company_user_form_title'] = 'Assign users to company';
$string['companyusers'] = 'Company users';
$string['company_users_course_title'] = 'Manage user enrolments';
$string['company_users_for'] = 'Company users for \'{$a}\'';
$string['company_users_for'] = 'Students for \'{$a}\'';
$string['companyusersmatching'] = 'Company users matching \'{$a}\'';
$string['company_users'] = 'Users';
$string['companyuserunassigned'] = 'Company user unassigned';
$string['competencymanagement'] = 'Competencies';
$string['completion_course_supervisor_subject'] = 'Notice: Course {$a->fullname} has been completed';
$string['completion_course_supervisor_body'] = '{$a->firstname} {$a->lastname} has completed the AC Education training course, {$a->fullname}, on {$a->date}. Please find attached a copy of their certificate for your records.

The certificate is also available from the User Report section on our system should you need a copy in the future.';
$string['completion_warn_supervisor_subject'] = 'Notice: Course {$a->fullname} has not been completed';
$string['completion_warn_supervisor_body'] = '{$a->firstname} {$a->lastname} has not completed their training in course {$a->fullname} within the normal timeframe';
$string['completion_expiry_warn_supervisor_subject'] = 'Notice: Course {$a->fullname} training expiry';
$string['completion_expiry_warn_supervisor_body'] = 'The training for {$a->firstname} {$a->lastname} in course {$a->fullname} will expiry shortly.  Please arrange for them to retake this training if appropriate.';
$string['completionemails'] = 'Completion emails';
$string['couldnotdeletecourse'] = 'Could not delete the course';
$string['coursecreatedok'] = 'Course was created successfully';
$string['coursemanagement'] = 'Courses';
$string['coursenamesearch'] = 'Search by course name';
$string['coursegroup'] = 'Course group for ';
$string['courses'] = 'Available Courses';
$string['coursesmatching'] = 'Courses matching \'{$a}\'';
$string['courseusers'] = 'Course Users';
$string['createandvisitcourse'] = 'Create and go to course';
$string['createcompany'] = 'Create company';
$string['createcourse'] = 'Create course';
$string['createcourse_title'] = 'Create a course';
$string['created'] = 'User created';
$string['createdepartment'] = 'Create department';
$string['createdepartment_title'] = 'Manage departments';
$string['createlicense'] = 'Create license';
$string['creategroup'] = 'Create group';
$string['createnewcompany'] = 'Create a new company';
$string['createchildcompany'] = 'Create child company';
$string['createuser'] = 'Create user';
$string['createuseragain'] = 'Submit and create another user';
$string['createuserandback'] = 'Submit and back to dashboard';
$string['createuserforcompany'] = 'Select';
$string['css_color_format'] = 'Colour should be in CSS colour format, #xxx or #xxxxxx where x can be A-F or 0-9';
$string['curlicensecourses'] = 'Current license courses';
$string['curlicensecoursesmatching'] = 'Current license courses matching \'{$a}\'';
$string['currentgroupusers'] = 'Current group users';
$string['currentgroupusersmatching'] = 'Current group students matching \'{$a}\'';
$string['currentlyenrolledusers'] = 'Enrolled students';
$string['currentlyenrolledusersmatching'] = 'Enrolled students matching \'{$a}\'';
$string['curusersmatching'] = 'Users matching \'{$a}\'';
$string['curusers'] = 'Users';
$string['customcss'] = 'Custom company CSS';
$string['dashboard'] = 'Iomad Dashboard';
$string['deleteanddestroycoursesfull'] = 'Are you sure you want to delete course {$a}? Clicking continue will remove all current user enrolments, any license allocations and the course from the company. If you click destroy, it will also remove all of the user reords from the all reports. <b>There is no recovery from this without backup</b>';
$string['deletecoursesfull'] = 'Are you sure you want to delete course {$a}? Clicking continue will remove all current user enrolments, any license allocations and the course from the company. <b>There is no recovery from this without backup</b>';
$srting['deletecourse_successful'] = 'Course was successfully removed';
$string['deletecheckfull'] = 'Do you really want to delete this user';
$string['deletecompany'] = 'Delete company';
$string['deletecourse_successful'] = 'Course was deleted successfully';
$string['deletedepartment'] = 'Delete departments';
$string['deletegroup'] = 'Delete group';
$string['deletelicense'] = 'Delete license';
$string['deleteroletemplate'] = 'Delete role template';
$string['deleteroletemplatefull'] = 'Are you sure you want to remove this role template?  This does not remove any restrictions from companies, it simply removes this template as an option which can be applied.';
$string['deleteuser'] = 'Delete user -';
$string['department'] = 'Department';
$string['department_help'] = 'Select which department you are wanting to manage.';
$string['departmentcreatedok'] = 'Department successfully created';
$string['departmentimport'] = 'Import department';
$string['departmentnameinuse'] = 'This department shortnme is already in use';
$string['deletedepartmentcheckfull'] = 'Are you absolutely sure you want to delete department {$a} and all of it\'s sub-departments?  This will not delete the default company department';
$string['departmentmanager'] = 'Department training manager';
$string['departmentmanagers'] = 'Department training managers';
$string['departmentmanagersmatching'] = 'Department training managers matching \'{$a}\'';
$string['departmentnoselect'] = '<h3>***No department selected***</h3>';
$string['departmentupdatedok'] = 'Department successfully updated';
$string['departmentusersmatching'] = 'Users in this department matching \'{$a}\'';
$string['departmentusers'] = 'Users in this department';
$string['designatedcompany'] = 'Designated company';
$string['disableecommerce'] = 'Disable shop access';
$string['destroy'] = 'Destroy';
$string['downloadusers'] = 'Download to file';
$string['ecommerce'] ='ecommerce';
$string['ecommerce_help'] ='ecommerce help text  ';
$string['ecommerceenabled'] = 'Enable shop access';
$string['editacompany'] = 'Edit a company';
$string['editcompany'] = 'Edit company';
$string['edit_companies_title'] = 'Iomad company settings';
$string['editdepartment'] = 'Manage departments';
$string['editdepartments'] = 'Edit department';
$string['editgroup'] = 'Edit group';
$string['edit_licenses'] = 'Edit license';
$string['edit_licenses_title'] = 'Edit/update course licenses';
$string['editroletemplate'] = 'Edit role template';
$string['edituser'] = 'Edit users';
$string['educator'] = 'Course educator';
$string['educator_help'] = 'Course educators get teacher type roles within company courses.';
$string['educatorreusable'] = 'Course educator - reusable';
$string['emailfromraw'] = 'Email sent from';
$string['emailpasswordstask'] = 'Email out passwords for newly created Iomad users';
$string['emailprofileid'] = 'External supervisor email field';
$string['emailprofileid_help'] = 'Choose the profile field which will contain the email address of a user\'s manager who does not have an account on the system.';
$string['emailtoraw'] = 'Email sent to';
$string['edit_users_title'] = 'Edit Users';
$string['enableecommerce'] = 'Allowed to access shop?';
$string['enrolcourse'] = 'Self Enrolled Course';
$string['enrolcourse_help'] = 'This defines how a user will gain access to the course.';
$string['enrolcoursetype'] = 'Course enrolment type';
$string['enrolled'] = 'Users are enrolled onto course by a manager';
$string['erroredusers'] = '<h2>These users were not added</h2>';
$string['expireafter'] = 'Enrolment expires after (days)';
$string['expireafter_help'] = 'This is the value in days after which the users enrolment is removed once they have completed the course.  If this is set to 0, then the user will not be unenrolled (unless you have set the valid length value which will be used instead).  For licensed courses, the user is removed from the course after whichever is earliest, time after completion or license enrolment length.';
$string['exportdepartment'] = 'Export department structure';
$string['filtercompany'] = 'Filter company/courses';
$string['firstcompany'] = 'You must create at least one company before you can use Iomad';
$string['hasgrade'] = 'Display course grade';
$string['hasgrade_help'] = 'If this is set to "No" then the course grade will not display in any of the reports for this course.  If there are multiple courses with mixed values then this column will display with a value of "N/A".';
$string['hideexpiredlicenses'] = 'Hide expired licenses';
$string['hidevalidcourses'] = 'Remove expired course results';
$string['importdepartment'] = 'Import department structure';
$string['inherit'] = 'Inherit';
$string['invaliddepartment'] = 'Invalid department';
$string['invaliddepartmentjson'] = 'The file imported does not match the company structure.';
$string['invalidlicense'] = 'The selected license is invalid.';
$string['invalidlicensename'] = 'The license name is not valid.  Please use numbers, letters and - or _ only.';
$string['invalidnumber'] = 'Invalid number';
$string['invaliduser'] = 'Invalid user';
$string['invalidstartdate'] = 'The license start date is not valid';
$string['iomadcapabilities_boiler'] = 'Please be aware that the capabilities for the Iomad system are fairly complex and disabling one of these may not completely take away the capability from the role you are editing.  You are advised to <b>test</b> any role changes you make to ensure that they work as you expect.';
$string['iomaddashboard'] = 'Iomad dashboard';
$string['iomad_company_admin:addinstance'] = 'Add a new Iomad company admin block';
$string['iomad_company_admin:assign_groups'] = 'Assign users to company groups';
$string['iomad_company_admin:assign_company_manager'] = 'Assign a company manager';
$string['iomad_company_admin:assign_company_reporter'] = 'Assign a company reporter';
$string['iomad_company_admin:assign_department_manager'] = 'Assign a department manager';
$string['iomad_company_admin:assign_educator'] = 'Assign a course educator';
$string['iomad_company_admin:allcompany_user_profiles'] = 'Manage all user profiles for all companies';
$string['iomad_company_admin:allocate_licenses'] = 'Allocate licenses to users';
$string['iomad_company_admin:classrooms'] = 'Access teaching location menus';
$string['iomad_company_admin:classrooms_add'] = 'Add teaching locations';
$string['iomad_company_admin:classrooms_delete'] = 'Remove teaching locations';
$string['iomad_company_admin:classrooms_edit'] = 'Edit teaching locations';
$string['iomad_company_admin:company_add'] = 'Add a company';
$string['iomad_company_admin:company_add_child'] = 'Add a child company';
$string['iomad_company_admin:company_course'] = 'Add a course to a company';
$string['iomad_company_admin:company_course_unenrol'] = 'Add/remove a course with existing enrolments';
$string['iomad_company_admin:company_course_users'] = 'Enrol/unenrol users on company courses';
$string['iomad_company_admin:company_delete'] = 'Delete a company';
$string['iomad_company_admin:company_edit'] = 'Edit a company';
$string['iomad_company_admin:company_edit_appearance'] = 'Edit the company appearance';
$string['iomad_company_admin:company_edit_certificateinfo'] = 'Edit the company certificate options';
$string['iomad_company_admin:company_framework'] = 'Assign competency frameworks to a company';
$string['iomad_company_admin:company_manager'] = 'Company manager form';
$string['iomad_company_admin:companymanagement_view'] = 'View company management tab';
$string['iomad_company_admin:company_template'] = 'Assign learning plan templates to a company';
$string['iomad_company_admin:company_user'] = 'Company user form';
$string['iomad_company_admin:company_user_profiles'] = 'Manage all user profiles for company';
$string['iomad_company_admin:company_view_all'] = 'View all companies';
$string['iomad_company_admin:company_view'] = 'View list of companies';
$string['iomad_company_admin:competencymanagement_view'] = 'View competency management tab in dashboard';
$string['iomad_company_admin:competencyview'] = 'View competencies from dashboard';
$string['iomad_company_admin:createcourse'] = 'Create a course';
$string['iomad_company_admin:coursemanagement_view'] = 'View the course management tab';
$string['iomad_company_admin:edit_all_departments'] = 'Edit all company departments';
$string['iomad_company_admin:editallusers'] = 'Edit users in every company';
$string['iomad_company_admin:edit_departments'] = 'Edit own company departments';
$string['iomad_company_admin:edit_groups'] = 'Edit company course groups';
$string['iomad_company_admin:edit_licenses'] = 'Edit company licenses';
$string['iomad_company_admin:edit_my_licenses'] = 'Edit my company licenses';
$string['iomad_company_admin:editmanagers'] = 'Edit company managers in own company';
$string['iomad_company_admin:editusers'] = 'Edit users in own company';
$string['iomad_company_admin:edituserpassword'] = 'Resend password details to users in own company';
$string['iomad_company_admin:export_departments'] = 'Export company departments to a file';
$string['iomad_company_admin:deleteuser'] = 'Delete users in own company';
$string['iomad_company_admin:suspenduser'] = 'Suspend users in own company';
$string['iomad_company_admin:company_license_users'] = 'Modify user license allocations';
$string['iomad_company_admin:import_departments'] = 'Import company departments from a file';
$string['iomad_company_admin:licensemanagement_view'] = 'View the license management tab';
$string['iomad_company_admin:deleteallcourses'] = 'Delete any course';
$string['iomad_company_admin:deletecourses'] = 'Delete a non-shared company course';
$string['iomad_company_admin:destroycourses'] = 'Delete a non-shared company course and remove all held user data for it.';
$string['iomad_company_admin:managecourses'] = 'Mage Iomad course settings';
$string['iomad_company_admin:viewcourses'] = 'View company courses';
$string['iomad_company_admin:manageframeworks'] = 'Manage Iomad competency framework settings';
$string['iomad_company_admin:managetemplates'] = 'Manage Iomad learning plan template settings';
$string['iomad_company_admin:myaddinstance'] = 'Add a new Iomad company admin block to the users dashboard';
$string['iomad_company_admin:restrict_capabilities'] = 'Restrict IOMAD role capabilties for company';
$string['iomad_company_admin:split_my_licenses'] = 'Split a license to a child company';
$string['iomad_company_admin:suspendcompanies'] = 'Suspend a company';
$string['iomad_company_admin:templateview'] = 'View templates from dashboard';
$string['iomad_company_admin:unallocate_licenses'] = 'Unallocate licenses from company';
$string['iomad_company_admin:user_create'] = 'Create a user';
$string['iomad_company_admin:usermanagement_view'] = 'View the user management tab';
$string['iomad_company_admin:user_upload'] = 'Upload users';
$string['iomad_company_admin:view_licenses'] = 'View company licenses';
$string['iomad_company_admin:view_my_company_email'] = 'Unused ';
$string['iomad_company_admin:view'] = 'View a company';
$string['isdefaultgroupdelete'] = 'This is the default company course group.  You can edit it but not delete it.';
$string['isdefaultgroupusers'] = 'This is the default course group.  You cannot remove members from it.</br>If you want to move users out of it, please select another group and add users to that group instead.';
$string['enrol'] = 'Enrol';
$string['enrolall'] = 'Enrol all';
$string['enrolunenrollusers'] = 'Enrol/unenrol users';
$string['enroluser'] = 'Course enrolments';
$string['enroluser'] = 'User enrolments';
$string['framework'] = 'Competency framework';
$string['frameworksettings'] = 'Manage Iomad framework settings';
$string['fullnamedepartment_help'] = 'This is the full name for the department';
$string['fullnamedepartment'] = 'Long name of the department';
$string['fullnamegroup'] = 'Name of the group';
$string['fullnamegroup_help'] = 'This sets the course group description/name';
$string['globalcoursesmatchipesng'] = 'Sitewide courses matching \'{$a}\'';
$string['globalcourses'] = 'Sitewide courses';
$string['groupdescription'] = 'Group name';
$string['group_users_for'] = 'Group {$a->group} in course {$a->course}';
$string['hasenrollments'] = 'existing enrolments';
$string['hide_suspended_companies'] = 'Hide suspended companies?';
$string['invalid_company'] = 'Optional field profile_field_company must match your company\'s shortname.';
$string['inuse'] = 'In use';
$string['iomad_frameworks_title'] = 'Manage competency frameworks';
$string['iomad_templates_title'] = 'Manage learning plan templates';
$string['leavepasswordemptytogenerate'] = 'Leave empty to have a password generated.</br>If you are manually setting a password, for</br>security reasons, only select to send by email</br>if the force change password option is selected!';
$string['licenseaddnew'] = 'Create new license';
$string['licenseallocate'] = 'Allocate license';
$string['licenseallocateall'] = 'Allocate licenses to all';
$string['licenseallocated'] = 'Max';
$string['licenseallocatedfromraw'] = 'License allocated from';
$string['licenseallocatedtoraw'] = 'License allocated to';
$string['licenseallocation'] = 'Number of licenses to allocate';
$string['licenseassignedto'] = 'License is valid for courses : ';
$string['licenseallocation_help'] = 'This is the maximum number of available slots which can be allocated to users for the courses within the license.';
$string['licensecutoffdate'] = 'Course cut off date';
$string['licensecutoffdate_help'] = 'When used with a standard license, the users enrolment on the licensed courses will end on this date rather than for the valid for license'; 
$string['licensed'] = 'Is licensed';
$string['licensed_help'] = 'If set to <b>Yes</b> users must be allocated via licenses and all other enrolment options are disabled. If set to <b>No</b> users are enrolled normally';
$string['licensedcourse'] = 'Users require a license to access course';
$string['licensecreatedok'] = 'License was successfully created';
$string['licensedateallocated'] = 'License allocated';
$string['licensedateused'] = 'License used';
$string['licensedeletedok'] = 'License deleted successfully';
$string['licensedetails'] = '({$a->used} used out of {$a->allocation})';
$string['licensedetails2'] = '{$a->used}';
$string['licensedetails3'] = '{$a->allocation}';
$string['licenseduration_help'] = 'This is how long a user can access the course for after they start it';
$string['licenseduration'] = 'License is valid for (days)';
$string['licenseexpires_help'] = 'This sets the date after which the current license allocation will no longer be available to be assigned to a user';
$string['licenseexpires'] = 'License expires after';
$string['licenseinstant'] = 'Instant access';
$string['licenseinstant_help'] = 'An instant access license will immediately enrol the user, using the license, when given to a user.';
$string['licenseinuse'] = 'The selected license is being used and cannot be deleted';
$string['licensemanagement'] = 'Licenses';
$string['licensename_help'] = 'This is the code which will be used to identify the license for reporting purposes';
$string['licensename'] = 'License identifier';
$string['licensenotenough'] = 'There are not enough available license slots';
$string['licenseprogram'] = 'Program of courses';
$string['licenseprogram_help'] = 'A license for a program of courses will give access to all courses associated to the license when given to a user.';
$string['licensereference_help'] = 'This is to be used for extra license identification';
$string['licensereference'] = 'License reference';
$string['licensestartdate'] = 'License valid from';
$string['licensestartdate_help'] = 'This is the date that users can start using the license from.  Licenses can be allocated to users before this date but email notifications will be sent out on the date the license starts and they will not be able to access the course';
$string['licenseremaining'] = 'Used';
$string['licenseremove'] = 'Unallocate license';
$string['licenseremoveall'] = 'Unallocate all licenses';
$string['licenseselect'] = 'Select a license';
$string['licenses'] = 'Available licenses';
$string['licensestartdate'] = 'License startdate';
$string['licensestartdate_help'] = 'The license becomes valid from this day on.';
$string['licensestatus'] = 'License status';
$string['licensetoomanyusers'] = 'You have tried to allocate more than the available number of licenses.';
$string['licensetotal'] = ' licenses can been allocated';
$string['licensetype'] = 'License type';
$string['licensetype_help'] = 'Standard licenses cannot be taken off of a user if they have used it.  Reusable license allow for a license to be taken off of a user even if they started the courese.  Their access is removed but their course information is not removed.';
$string['licenseunallocatedfromraw'] = 'License unallocated from';
$string['licenseunallocatedtoraw'] = 'License unallocated to';
$string['licenseupdatedok'] = 'License was successfully updated';
$string['licenseusedwarning'] = '<center>* Users who are marked with an asterix are already using their license allocation for a course and so cannot have their license taken away from them.</br></center>';
$string['licenseuserinuse'] = 'License in use';
$string['license_users_for'] = 'Users for license \'{$a}\' ';
$string['licenseusers'] = 'User license allocations';
$string['licenseusersmatching'] = 'Current users matching \'{$a}\' ';
$string['listroles'] = 'Show Iomad roles';
$string['loginfromraw'] = 'Logged in from';
$string['logintoraw'] = 'Logged in to';
$string['managecompanies'] = 'Manage companies';
$string['managecompany'] = 'Manage company';
$string['managecourses'] = 'Select';
$string['managegroups'] = 'Manage company groups';
$string['managelicenses'] = 'License management';
$string['managemanagers'] = 'Select';
$string['managementtitle'] = 'Company, User and Course Management';
$string['manager'] = 'Manager';
$string['manageremails'] = 'Manager emails';
$string['managernotify'] = 'Send manager emails';
$string['managernotify_help'] = 'Choose what type of notifications a company manager will get for their users.  Whether it is reminder emails to complete a course or course completion information for users or both.';
$string['managerdigestday'] = 'Send manager digest emails on';
$string['managerdigestday_help'] = 'This sends out report emails to managers on this day of the week only';
$string['managertype'] = 'Role to assign';
$string['managertype_help'] = 'This selects what type of role you would like to assign/unassign.';
$string['managetemplates'] = 'Manage role templates';
$string['manageusers'] = 'Select';
$string['maxuserswarning'] = 'You have exceeded the allowed maximum number of active users allowed ({$a}). You will need to either suspend or delete some current users or contact the site administrator to increase the allowed value.';
$string['maxuserswarningplural'] = 'Adding these users will increase the total number of active users in company beyond the maximum allowed ({$a}). You will need to either suspend or delete some current users or contact the site administrator to increase the allowed value.';
$string['missingcompany'] = 'Missing company';
$string['missingfullnamedepartment'] = 'Missing department name';
$string['missinggroupdescription'] = 'Missing the group name';
$string['missinglicenseallocation'] = 'Missing license allocation';
$string['missinglicensecourses'] = 'Missing courses for license';
$string['missinglicenseduration'] = 'Missing license duration (this is required for a standard license)';
$string['missinglicenseexpires'] = 'Missing license expires after';
$string['missinglicensename'] = 'Missing license identifier';
$string['missingroletemplatename'] = 'Missing the name for the role template';
$string['missingshortnamedepartment'] = 'Missing department shortname';
$string['missingstartdate'] = 'Missing license start date';
$string['missingvalidlength'] = 'Missing License valid for days';
$string['movedepartment'] = 'Department is being moved.';
$string['movedepartmentcheckfull'] = 'You are moving this department to another place in the tree.  Are you sure you want to move {$a->current} under {$a->newparent}?';
$string['newcourse'] = 'New course';
$string['newuser'] = 'New user';
$string['nocompanies'] = 'There are no companies - please add a company first';
$string['nocompaniesfilter'] = 'No companies match your current filter';
$string['nocompaniesfound'] = 'There are no companies which match your criteria';
$string['nocompany'] = 'Unallocated courses';
$string['nocompanyframeworks'] = 'Unallocated competency frameworks';
$string['nocompanyselected'] = 'No company is selected. Please make a selection above';
$string['nocompanytemplates'] = 'Unallocated competency templates';
$string['nocourses'] = 'There are no courses.';
$string['nogroups'] = 'There are no course groups';
$string['nodepartments'] = 'There are no departments defined';
$string['nolicensesleft'] = '0 licenses left to allocate';
$string['nolocations'] = 'No teaching locations have been created yet';
$string['noneselected'] = 'No company selected';
$string['notemplates'] = 'There are no saved templates';
$string['numlogins'] = 'Total number of logins';
$string['notallocated'] = 'Not allocated';
$string['notinuse'] = 'Not in use';
$string['licensecount'] = 'Licenses allocated:';
$string['licensedueafterexpirywarning'] = 'Cannot send out an email after the license has expired';
$string['licenseduebeforestartwarning'] = 'Cannot send out an email before the license is available';
$string['licenseerrors'] = 'Licenses not allocated:';
$string['licenseexpired'] = 'expired on {$a}';
$string['licenseleft1'] = 'You have ';
$string['licenseleft2'] = ' courses left to allocate on this license';
$string['licensevalidfrom'] = 'available from {$a}';
$string['licensevalidfromwarning'] = 'you can assign this license to users but emails will only be set out after {$a} and users will not be able to access the course until this date.';
$string['programleft2'] = ' program slots left to allocate on this license';
$string['editlicensestitle'] = 'Edit Course Allocations';
$string['selectlicenseblurb'] = 'Please select a license from above';
$string['showexpiredlicenses'] = 'Show expired licenses';
$string['showvalidcourses'] = 'Include expired course results';
$string['nolicenses'] = '<p> Your license has either expired or you have allocated all your available places. Please contact your account manager to discuss. </p>';
$string['licensehelp'] = 'On this screen you are able to change the course allocations for your learners. To edit course allocations for your student, select your desired license from the license drop down menu below. Any courses that your learner is currently allocated will display in the left hand side box, select courses from the right hand box and click enrol to allocate the course(s). You can select multiple courses in the right hand box by holding CTRL as you select the courses.';
$string['licenseuseage'] = 'License allocated';
$string['nolicense'] = 'Don\'t allocate a license';
$string['notallowedtoaccessothercompaniesdata'] = 'You\'re not allowed to that.';
$string['notawholenumber'] = 'This needs to be a whole number.';
$string['notifyperiod'] = 'Days between email alerts';
$string['notifyperiod_help'] = 'This is the number of days between nag emails set to the users';
$string['nousers'] = 'There are no users.';
$string['oktounenroll'] = 'OK to unenroll users';
$string['open'] = 'Open sharing';
$string['optionalfieldserror'] = 'Error reading optional fields';
$string['iomad_company_courses_title'] = 'Manage Iomad course settings';
$string['iomad_company_frameworks_title'] = 'Manage Iomad competency framework settings';
$string['iomad_company_templates_title'] = 'Manage Iomad competency template settings';
$string['iomad_courses_title'] = 'Manage Iomad course settings';
$string['iomadreports'] = 'Company reports';
$string['parentcompany'] = 'Parent company';
$string['parentcompany_help'] = 'Select the parent company for this company.  Company managers in the parent company will automatically be assigned as company managers in this company and licenses can be split from a parent company to a child company.';
$string['parentcompanysuspended'] = 'Company cannot be un-suspended without it\'s parent company';
$string['parentdepartment'] = 'Select parent department';
$string['parentlicenseavailable'] = 'Parent license available slots';
$string['parentlicensename'] = 'Parent license name';
$string['parentlicenseused'] = 'Parent license used amount';
$string['pleaseselect'] = 'Please select a company from the dropdown box on the Dashboard page';
$string['pluginname'] = 'Iomad Company / User Admin';
$string['potcoursesmatching'] = 'Potential courses matching \'{$a}\'';
$string['potcourses'] = 'Potential courses';
$string['potentialcourseusersmatching'] = 'Potential students matching \'{$a}\'';
$string['potentialcourseusers'] = 'Potential students';
$string['potentialdepartmentusers'] = 'Potential users';
$string['potentialgroupusers'] = 'Potential students';
$string['potentialgroupusersmatching'] = 'Potential students matching \'{$a}\'';
$string['potframeworks'] = 'Potential frameworks';
$string['potframeworksmatching'] = 'Potential frameworks matching \'{$a}\'';
$string['potlicensecourses'] = 'Potential license courses';
$string['potlicensecoursesmatching'] = 'Potential license courses matching \'{$a}\'';
$string['potmanagersmatching'] = 'Potential managers matching \'{$a}\'';
$string['potmanagers'] = 'Potential managers';
$string['pottemplates'] = 'Potential templates';
$string['pottemplatesmatching'] = 'Potential templates matching \'{$a}\'';
$string['potusersmatching'] = 'Potential users matching \'{$a}\'';
$string['potusers'] = 'Potential users';
$string['privacy:metadata'] = 'The Iomad Company admin block only shows data stored in other locations.';
$string['profile_field_company_not_empty_does_not_match_selected'] = 'profile_field_company is not empty and does not match the selected company.';
$string['profile_field_company_not_set'] = 'profile_field_company is required when no company has been selected.';
$string['programallocate'] = 'Allocate program license';
$string['programallocate_help'] = 'Selecting yes will allocate all of the courses in this program to the user.';
$string['reminderemails'] = 'Reminder emails';
$string['reports'] = 'Reports';
$string['resetpassword'] = 'Re-send user details';
$string['resetpasswordcheck'] = 'Do you really want to reset this user\'s password';
$string['resetpasswordcheckfull'] = 'Do you really want to reset this user\'s password';
$string['return_to'] = 'Return to {$a}';
$string['restrictcapabilities'] = 'Restrict capabilities';
$string['restrictcapabilitiesfor'] = 'Restrict capabilities for \'{$a}\'';
$string['reusable'] = 'Reusable';
$string['rolename'] = 'Role name \'{$a}\'';
$string['roletemplate'] = 'Role template';
$string['roletemplate_help'] = 'Select the role template to be applied to this company.  Child companies can inherit as well as use a template which is allocated to the company.  This will change all of the company and department managers capabilities for this company';
$string['roletemplatename'] = 'Role template name';
$string['roletemplatename_help'] = 'This is the name which the template will be saved as.  You can select this when creating companies';
$string['roletemplatedeleted'] = 'Role template successfully deleted';
$string['roletemplatesaved'] = 'Role template successfully saved';
$string['roletemplates'] = 'Role templates';
$string['saveasnewcompany'] = 'Save new company';
$string['saveroletemplate'] = 'Save as role template';
$string['savetemplate'] = 'Save template';
$string['selectacompany'] = 'Select a company';
$string['selectacountry'] = 'Select a country';
$string['selectatheme'] = 'Select an installed theme';
$string['selectcourse'] = 'Select course';
$string['selectenrolmentcourse'] = 'Select course to enrol into';
$string['selectenrolmentcourses'] = 'Select courses to enrol into';
$string['selectgroup'] = 'Select group';
$string['selectlicensecourse'] = 'Select a course to edit licenses for';
$string['select_license'] = 'Select a license';
$string['select_license_courses'] = 'Select Courses to provide a license for';
$string['selfenrolled'] = 'Users can enrol themselves onto course';
$string['senddate'] = 'Send email on';
$string['senddate_help'] = 'This defines when the email to the user is sent out informing them of this action.';
$string['sendemailsforcepasswordchange'] = '\'{$a->forcechange}\' needs to be ticked when \'{$a->sendemail}\' is Yes.';
$string['sendnewpasswordemails'] = 'Send temporary passwords by email';
$string['shared'] = 'Is shared';
$string['shared_help'] = '<ul><li><b>No</b> - Course is not shared</li><li><b>Open sharing</b> - Course is shared across <b>all</b> companies</li><li><b>Closed sharing</b> - Course is shared between selected companies (see <i>Course management > Assign to company</i>)</li></ul>';
$string['shared_framework_help'] = '<ul><li><b>No</b> - Framework is not shared</li><li><b>Open sharing</b> - Framework is shared across <b>all</b> companies</li><li><b>Closed sharing</b> - Framework is shared between selected companies (see <i>Competency management > Assign framework to company</i>)</li></ul>';
$string['shared_template'] = 'sharing competency template settings';
$string['shared_framework'] = 'sharing competency framework settings';
$string['shared_template_help'] = '<ul><li><b>No</b> - Template is not shared</li><li><b>Open sharing</b> - Template is shared across <b>all</b> companies</li><li><b>Closed sharing</b> - Template is shared between selected companies (see <i>Competency management > Assign template to company</i>)</li></ul>';
$string['sharedhasenrollments'] = 'shared with enrolments';
$string['shortnamedepartment'] = 'Department short name';
$string['shortnamedepartment_help'] = 'This is the shorname code which will be used to display the department in drop down menus';
$string['showallcompanies'] = 'Show all companies';
$string['show_all_company_users'] = 'Show users from every company?';
$string['showhistoricusers'] = 'Show historic results';
$string['showothermanagers'] = 'Show external company managers';
$string['showothermanagers_help'] = 'Select this if you would like to show company managers from other companies.  This is only available if the role type you are assigning is the company manager one.';
$string['show_suspended_companies'] = 'Show suspended companies?';
$string['split'] = 'Split';
$string['split_licenses'] = 'Split license';
$string['standard'] = 'standard';
$string['subdepartments'] = 'Sub departments';
$string['suspend'] = 'Suspend';
$string['suspendcheck'] = 'Do you really want to suspend this user';
$string['suspendcheckfull'] = 'Do you really want to suspend this user';
$string['suspendcompany'] = 'Suspend company';
$string['suspendcompanycheck'] = 'Do you really want to suspend this company?';
$string['suspendcompanycheckfull'] = 'Do you really want to suspend this company?  This will suspend all of the users who are associate to this company but will keep the courses and other company details intact.';
$string['suspenduser'] = 'Suspend user';
$string['template'] = 'Competency template';
$string['templatenamealreadyinuse'] = 'Template name is already in use';
$string['templatesettings'] = 'Manage Iomad template settings';
$string['theoptionsbelow'] = '<p><b>NOTE: The options below may only work with the Iomad themes</b></p>';
$string['todashboard'] = 'Return to Dashboard';
$string['triedtoallocatetoomanylicenses'] = 'You have tried to allocate licenses for more courses than there are available allocations';
$string['unenrollincapable'] = '<span id="unenrollwarning">NOTE: If "(existing enrolments)" is shown, you do not have the necessary rights to add/remove this courses. Remove existing user enrolments first.</span>';
$string['unenrollwarning'] = '<span id="unenrollwarning">WARNING: If "(existing enrolments)" is shown you must tick the box beneath to allow add or remove. If you do this, all users will be unenrolled and ALL THEIR DATA (for that course) IS LOST. This cannot be undone</span>';
$string['unenrol'] = 'Unenrol';
$string['unenrolall'] = 'Unenrol all';
$string['unsuspend'] = 'Unsuspend';
$string['unsuspendcheck'] = 'Do you really want to unsuspend this user';
$string['unsuspendcheckfull'] = 'Do you really want to unsuspend this user';
$string['unsuspendcompany'] = 'Unsuspend company';
$string['unsuspendcompanycheck'] = 'Do you really want to unsuspend this company?';
$string['unsuspendcompanycheckfull'] = 'Do you really want to unsuspend this company?  This will unsuspend all of the users who are associate to this company.';
$string['unsuspenduser'] = 'Unsuspend user';
$string['updatedepartmentusersselection'] = 'Choose Department';
$string['updatelicense'] = 'Update license allocation';
$string['uploadfilecontainerror'] = 'The file contents could not be processed.';
$string['uploadfilecontentsnovaliddata'] = 'The uploaded file is either in an invalid format or there were no user changes to process.';
$string['uploadfromfile'] = 'Upload from file';
$string['upload_no_company_no_courses'] = 'Courses can only be selected when a company is selected.';
$string['upload_no_company_selected'] = 'No company selected, profile_field_company must be present in the uploaded file.';
$string['user_bulk_download_title'] = 'User Bulk Download';
$string['usercourses'] = 'Enrolled courses';
$string['user_courses_for'] = 'Editing Course allocation for {$a}';
$string['usercreatedok'] = 'Account was created successfully';
$string['usercreated'] = 'User created successfully';
$string['user_create_title'] = 'Create Users';
$string['userdefaults'] = 'User defaults';
$string['userdeletedok'] = 'User was successfully deleted';
$string['userenrolments'] = 'Change course enrolments';
$string['userlicenses'] = 'Change course licenses';
$string['userlicenseassigned'] = 'License assigned to user';
$string['userlicenseunassigned'] = 'License unassigned from user';
$string['userlicenseused'] = 'License used by user';
$string['usermanagement'] = 'Users';
$string['userprofiles'] = 'Optional profiles';
$string['users_bulk'] = 'Bulk user actions';
$string['users_download'] = 'User Bulk Download';
$string['usersuspendedok'] = 'User was successfully suspended';
$string['usertype'] = 'User type';
$string['userunsuspendedok'] = 'User was successfully unsuspended';
$string['user_upload_title'] = 'Upload Users';
$string['user'] = 'User';
$string['usercontrols'] = 'User controls';
$string['uupreprocessedcount'] = '{$a} user(s)';
$string['validfor'] = 'Training expires after (days)';
$string['validfor_help'] = 'This is the number of days after which the training undertaken by the user is said to no longer be valid or must be retaken. If the course does not expire, then set this to zero.  The user\'s enrolment will be removed at the time of expiry (or the number of days to warn before this, if set) if the user still has access to the course.';
$string['iomad_company_admin:viewsuspendedusers'] = 'View suspended users';
$string['warncompletion'] = 'Days to email after if not complete';
$string['warncompletion_help'] = 'If a training expiration time has been set, a reminder email will be sent after this number of days if the course has not already been successfully repeated';
$string['warnexpire'] = 'Days to email before training expires';
$string['warnexpire_help'] = 'If a training expiration time has been set a reminder email will be sent this number of days before the expiration day.  If the user is still enrolled their enrolment will be removed at this time.';
$string['warnnotstarted'] = 'Days to email after if user has not started';
$string['warnnotstarted_help'] = 'If this is set, then any user who has been granted access to a course and has not started in this time frame, will be sent an email.';
$string['licenseleft1'] = 'You have ';
$string['licenseleft2'] = ' courses left to allocate on this license';
$string['editlicensestitle'] = 'Edit Course Allocations';
$string['selectlicenseblurb'] = 'Please select a license from above';
$string['nolicenses'] = '<p> You do not have any valid licenses. Please contact your account manager to discuss. </p>';
$string['licensehelp'] = 'On this screen you are able to change the course allocations for your learners. To edit course allocations for your student, select your desired license from the license drop down menu below. Any courses that your learner is currently allocated will display in the left hand side box, select courses from the right hand box and click enrol to allocate the course(s). You can select multiple courses in the right hand box by holding CTRL as you select the courses.';
$string['headingcolor'] = 'Heading Colour';
$string['maincolor'] = 'Main Colour';
$string['linkcolor'] = 'Link Colour';

// Role stuff
$string['archetypeclientadministrator_role'] = 'Iomad client administrator';
$string['clientadministrator_role'] = 'Iomad client administrator';
$string['archetypecompanymanager_role'] = 'Company manager';
$string['companymanager_role'] = 'Company manager';
$string['archetypecompanydepartmentmanager_role'] = 'Company department manager';
$string['companydepartmentmanager_role'] = 'Company department manager';
$string['archetypecompanycourseeditor_role'] = 'Company course editing teacher';
$string['companycourseeditor_role'] = 'Company course editing teacher';
$string['archetypecompanycoursenoneditor_role'] = 'Company course non editing teacher';
$string['companycoursenoneditor_role'] = 'Company course non editing teacher';
$string['archetypeclientreporter_role'] = 'Company report only';
$string['clientreporter_role'] = 'Client report only';
$string['clientreporter'] = 'Client report only';
$string['archetypecompanyreporter_role'] = 'Company report only';
$string['companyreporter_role'] = 'Company report only';
$string['companyreporter'] = 'Company report only';
