<?php

/**
* Return the school that is currently selected by the user
* 
* @return int The school ID of the currently selected school
*
*/
function get_school_id()
{
	return $_SESSION['get_school_id'];
}

function get_school_array()
{
    $QI=db_execute("SELECT ID,TITLE FROM SCHOOLS");//TITLE,VALUE,
    $data = db_request($QI,array(),array('ID'));
    foreach($data as $school_id=>$other)
    {
	    if($school_id<>'')
                $rdata[$school_id] = $school_id;
    }
    return $rdata;
}
function get_apply_school_array()
{
    $QI=db_execute("SELECT SCHOOL_ID FROM SYSTEM_CONFIG WHERE PROGRAM='system' AND TITLE = 'APPLY_MODE' AND VALUE='Y'");//TITLE,VALUE,
    $data = db_request($QI,array(),array('SCHOOL_ID'));
    unset($school_id);
    unset($other);
    unset($rdata);
    foreach($data as $school_id=>$other)
    {
	    if($school_id<>'')
                $rdata[$school_id] = $school_id;
    }
    return $rdata;
}
/**
* Return the school that selected as apply_mode
*
* @return int The school ID of the selected as apply_mode
*
*/
function get_apply_school_id($edu_category_id=false,$type='integral')
{
	if($type=='online' && $edu_category_id!==false)
	{
	    $QI=db_execute("SELECT SCHOOL_ID FROM APP_EDU_CATEGORIES WHERE ID = '".intval($edu_category_id)."'");
    	    $data = db_request($QI,array(),array());
            $data = $data[1]['SCHOOL_ID'];
    	}
        elseif($type=='integral' && $edu_category_id==false)
        {
            return get_school_id();
        }
    	else
    	{
    	    $QI=db_execute("SELECT TITLE,VALUE,SCHOOL_ID FROM SYSTEM_CONFIG WHERE PROGRAM='system' AND TITLE = 'APPLY_MODE' AND VALUE = 'Y'");
    	    $data = db_request($QI,array(),array());
            $data = $data[1]['SCHOOL_ID'];
    	}
        return $data;
}

/**
* Return the Y if selected school is in admission mode
*
* @return varchar Y or NULL/N
*
*/

function is_apply_school()
{
	$QI=db_execute("SELECT TITLE,VALUE,SCHOOL_ID FROM SYSTEM_CONFIG WHERE PROGRAM='system' AND TITLE = 'APPLY_MODE' AND VALUE = 'Y'");
        $data = db_request($QI,array(),array('SCHOOL_ID'));
        if($data[get_school_id()][1]['VALUE'])
	        return $data[get_school_id()][1]['VALUE'];
	else
		return 'N';
}

/**
* Return the school year that is currently selected by the user
* 
* @return int The currently-selected school year.
* 
* example: The 2007-2008 school year is represented by the number 2007.
*/
function get_school_year()
{
	return $_SESSION['get_school_year'];	
}

/**
* Return the School Term ID (always a quarter) that is currently selected by the user
* 
* @return int The currently-selected School Term ID
*
*/
function get_user_school_term()
{
	if(get_user('PROFILE') == 'admin' && $_REQUEST['get_user_school_term'])
	{
		$sts_for_cur_school = get_school_terms_by_year('SCHOOL_QUARTERS',get_school_year());
		$requested_st = $_REQUEST['get_user_school_term'];
		$session_st = $_SESSION['get_user_school_term'];
		$check_term = strpos($sts_for_cur_school,"'".$session_st."'");
	}
	if($check_term === false && $_REQUEST['get_user_school_term'])
	{
		return $_REQUEST['get_user_school_term'];
	}
	else
		return $_SESSION['get_user_school_term'];
}

function get_user_schoolperiod()
{
	return $_SESSION['get_user_schoolperiod'];	
}


/**
* Return the Course Period ID (the ID of the currently-selected section).  Only applicable for teachers
* 
* @return int The currently-selected course period ID
*
*/
function get_user_coursesection()
{
	return $_SESSION['get_user_coursesection'];
}

/**
* Return the student ID that is currently selected by the user.
* 
* @return int The student ID of the currently selected student
*
*/
function get_student_id()
{
	return $_SESSION['student_id'];
}

/**
* Return the incident ID that is currently selected by the user.
* 
* @return int The incident ID of the currently selected incident
*
*/
function UserIncidentID()
{
	return $_REQUEST['incident_id'];	
}

/**
* Return the true if student is applicant that is currently selected by the user.
* 
* @return bool The boolean of the currently selected applicant
*
*/

function is_applicant()
{
	return $_SESSION['is_applicant'];
}

/**
* Return the user ID of the AIS Integral user (not necessarily the user logged in) that is currently selected by the logged-in user.
* 
* @return int The user ID of the currently selected user
*
*/
function get_user_id()
{	global $_SYSTEM;

	if(get_user('PROFILE')=='parent')
		$_SESSION['user_id'] = get_user('USER_ID');
	$get_user_id = $_SESSION['user_id'];
//	var_dump($_SESSION['user_list'][0]['user_id']);
//	if($get_user_id && get_user('PROFILE')=='admin')
	//проверить на валидность.
	if($get_user_id)
	{
//		return $_SESSION['user_id'];	
		return $get_user_id;
	}
	elseif(get_user('PROFILE')=='admin')
	{
//		return $_SESSION['USER_ID'];
//вылазит косяк с верхним поиском, отличие в USER_ID И user_id
		if($_SYSTEM['just_added_user_id'])
		{
			$_SESSION['user_id'] = $_SYSTEM['just_added_user_id'];
			unset($_SYSTEM['just_added_user_id']);
		}
		return $_SESSION['user_id'];
	}
	else
		return $_SESSION['USER_ID'];
}

function get_selected_user_id()
{	global $_SYSTEM;


//	if(!$get_user_id)
	{
//	var_dump($_SESSION);
		$get_user_id = $_SESSION['user_id'];
	}
	if($get_user_id)
		return $get_user_id;
}

function get_student_info()
{
	global $array,$but_left,$but_right;
     if($array['1']['LAST_NAME'] && get_student_id())
     {
	     if($array['1']['GROUP_ID'] && is_applicant()!='applicant')
                     $group_desc = ", "._('Class Group').": ".$array['1']['GROUP_ID'];
             DisplayHeader(".:".ProgramTitle().":. - <i>".$but_left." ".$array['1']['LAST_NAME']." ".$array['1']['FIRST_NAME']." ".$array['1']['MIDDLE_NAME']."</i>".$group_desc." ".$but_right);
     }else{
             DisplayHeader(".:".ProgramTitle().":.");
     }
/*                                                     	
        if($array['1']['LAST_NAME'])
        {
                DisplayHeader(".:".ProgramTitle().":. - <i>".$array['1']['LAST_NAME']." ".$array['1']['FIRST_NAME']." ".$array['1']['MIDDLE_NAME']."</i> ");
        }else{
                DisplayHeader(".:".ProgramTitle().":.");
        }
        */
}
?>