<?php

/**
* Returns any user preference
* 
* Each preference has a name ($item) and is in a group ($program).  The 
* preferences set in the Users' Preferences program are in the $program group 
* called "Preferences."  Preferences for teachers' gradebooks are in the $program
* group called "Gradebook."  New Programs requiring preferences can establish 
* new $program groups.
* 
* Default user preferences are hard-coded in the SystemPreferences() function
*
* @param string $item the preference that we'd like returned
* @param string $program the program which established this preference
* @return string the user-defined preference or else a default value
*/
function Preferences($item,$program='Preferences')
{	global $_SYSTEM;
//	unset($_SYSTEM['Preferences'][$program]); ????????????????????????
	if(($_SESSION['USER_NAME'] || $_SESSION['STUDENT_ID']) && !$_SYSTEM['Preferences'][$program])
	{
		$QI=db_execute("SELECT TITLE,VALUE FROM SYSTEM_USER_SETTINGS WHERE USERNAME='".get_user('USERNAME')."' AND PROGRAM='$program' AND (SCHOOL_YEAR='".get_school_year()."' OR SCHOOL_YEAR IS NULL) AND (SCHOOL_ID='".get_school_id()."' OR SCHOOL_ID IS NULL)");
		$_SYSTEM['Preferences'][$program] = db_request($QI,array(),array('TITLE'));

		if(($_SESSION['USER_NAME'] || $_SESSION['STUDENT_ID']) && (get_user('PROFILE')=='parent' || get_user('PROFILE')=='student'))
		{
			$_SYSTEM['Preferences'][$program]['SEARCH'][1]['VALUE'] = 'N';
			$_SYSTEM['Preferences'][$program]['MENU'][1]['VALUE'] = 'Top';
		}
	}

	if(!isset($_SYSTEM['Preferences'][$program][$item][1]['VALUE']))
	{
		$_SYSTEM['Preferences'][$program][$item][1]['VALUE'] = SystemPreferences($item,$program);
	}
	/*
	if($item=='LIGHT_HIGHLIGHT' && !isset($_SYSTEM['Preferences'][$program][$item][1]['VALUE']))
	{
		
		$_SYSTEM['Preferences'][$program][$item][1]['VALUE'] = base_convert(intval(substr(Preferences('HIGHLIGHT'),0,2))/2,'10','16');
	}
	*/
       	$_SYSTEM['Preferences'][$program]['COLOR'][1]['VALUE'] = 'ffffff';//E0E1FF
	$_SYSTEM['Preferences'][$program]['THEME'][1]['VALUE'] = 'green';
	
	return $_SYSTEM['Preferences'][$program][$item][1]['VALUE'];
}

/**
* Sets any user preference
* 
* Each preference has a name ($item) and is in a group ($program).  The 
* preferences set in the Users' Preferences program are in the $program group 
* called "Preferences."  Preferences for teachers' gradebooks are in the $program
* group called "Gradebook."  New Programs requiring preferences can establish 
* new $program groups.
* 
* This function creates new preferences and updates existing preferences.
*
* Default user preferences are hard-coded in the SystemPreferences() function
*
* @param string $item the preference that we'd like to change
* @param string $program the program which established this preference
* @param string $value the new value for this preference
* @param string $school_year optional school year -- only used if the preference is only relevant in the current school year
* @param string $school_id optional school id -- only used if the preference is only relevant in the current school
*/

function SetPreference($item,$program,$value,$school_year=null,$school_id=null)
{	global $_SYSTEM;

	if(!Preferences($item,$program,$school_year,$school_id))
		db_execute("INSERT INTO SYSTEM_USER_SETTINGS (USERNAME,PROGRAM,TITLE,VALUE,SCHOOL_YEAR,SCHOOL_ID) values('".get_user('USERNAME')."','".$program."','".$item."','".$value."','".$school_year."','".$school_id."')");
	elseif(Preferences($item,$program)!=$value)
	{
		if($school_year)
			$addition .= " AND SCHOOL_YEAR='".$school_year."'";
		if($school_id)
			$addition .= " AND SCHOOL_ID='".$school_id."'";

		db_execute("UPDATE SYSTEM_USER_SETTINGS SET VALUE='".$value."' WHERE USERNAME='".get_user('USERNAME')."' AND PROGRAM='".$program."' AND TITLE='".$item."'".$addition);
	}
	$_SYSTEM['Preferences'][$program][$item][1]['VALUE'] = $value;
}

function IsSystemDefaultPreference($item,$program='system')
{
    global $_SYSTEM;

	if(!$_SYSTEM['SystemPreferences'][$program])
	{
		$QI=db_execute("SELECT DISTINCT TITLE,VALUE,SCHOOL_ID FROM SYSTEM_CONFIG WHERE PROGRAM='$program' AND (SCHOOL_ID='".get_school_id()."' OR SCHOOL_ID IS NULL) AND VALUE<>'use_system'");
		$_SYSTEM['SystemPreferences'][$program] = db_request($QI,array(),array('TITLE'));
	}
    
    $system_value = null;
    $school_value = null;
	if($_SYSTEM['SystemPreferences'][$program][$item])
	    foreach ($_SYSTEM['SystemPreferences'][$program][$item] as $value)
	    {
	        if($value['SCHOOL_ID']!=null)
	            $school_value = &$value['VALUE'];
	        else
	            $system_value = &$value['VALUE'];
	    }

    return (null==$school_value);
}

/**
* Returns any system preference
* 
* Each system preference has a name ($item) and is in a group ($program).  The 
* preferences set in the System Preferences program are in the $program group 
* called "system."  Default User Preferences are in the $program
* group called "Preferences."  New programs requiring preferences can establish 
* new $program groups.
* 
* Defaults for system preferences and user preferences are hard-coded here.
*
* @param string $item the preference that we'd like returned
* @param string $program the program which established this system preference
* @return string the system preference or else a default value
*/
function SystemPreferences($item,$program='system',$system_only=false)
{	global $_SYSTEM;
	if(!$_SYSTEM['SystemPreferences'][$program])
	{
		$QI=db_execute("SELECT TITLE,VALUE,SCHOOL_ID FROM SYSTEM_CONFIG WHERE PROGRAM='$program' AND (SCHOOL_ID='".get_school_id()."' OR SCHOOL_ID IS NULL) AND VALUE<>'use_system'");
		$_SYSTEM['SystemPreferences'][$program] = db_request($QI,array(),array('TITLE'));
	}
	$defaults = array(
		'REPORT_CARD'=>'both',
		'SCHOOL_YEAR_TITLE'=>'YYYY-YYYY',
		'VARIABLE_PERIOD_LENGTH'=>'N',
		'STUDENTS_CAN_SCHEDULE'=>'N',
		'STUDENTS_CAN_REQUEST'=>'N',
		'CURRENCY'=>'$',
		'DECIMAL'=>'.',
		'WEIGHTS'=>'Y',
		'FINAL_EXAMS'=>'Y',
		'FY_EXAMS'=>'N',
		'QTR_EXAMS'=>'N',
		'OVERRIDE_SCORE_BREAKOFFS'=>'Y',
		'OVERRIDE_SEMESTER_GRADE_WEIGHTS'=>'Y',
		'WEIGHTED_GPA'=>'Y',
		'DEFAULT_CREDITS'=>'1',
		'BUS_ADDRESSES'=>'Y',
		'MAILING_ADDRESSES'=>'Y',
		'GUARDIANS'=>'Y',
		'AUTHENTICATION'=>'db',
		'VIEW_PAST_STUDENT_ATTENDANCE_DAYS'=>0,
		'EDIT_PAST_STUDENT_ATTENDANCE_DAYS'=>0,
		'EDIT_ATTENDANCE_AFTER_SAVE'=>'Y',
		'AUTO_STUDENT_USERNAMES'=>'N',
		'MIN_FULLDAY'=>300,
		'MIN_HALFDAY'=>150,
    		'SHORT_COMMENTS_PER_COURSE'=>'Y',
    		'ONE_LONGER_COMMENT_PER_COURSE'=>'N',
    		'ONE_LONGER_COMMENT_PER_STUDENT'=>'N',
    		'COMMENTS_CONDUCT'=>'Y',
	        'CALC_GPA_AUTOMATICALLY'=>'N',
    		'ROUND_GPA_POINTS'=>3,
    		'ROUND_AVERAGE_POINTS'=>3,
	        'COMMENTS_CONDUCT'=>'N',
		'SHOW_STUDENTS_BY'=>'no limit',
		'NAME_SUFFIX'=>'||Jr.||Sr.||',
		'USE_CREDITS'=>'Y',
		'USE_REQUESTS'=>'N',
		'USE_BLOCKS'=>'N',
		'ODD_EVEN_WEEKS'=>'N',
		'REGISTRATION_TYPE'=>'SIMPLE',
		'BLOCKGROUP'=>'Y',
		'USE_SUFFIX'=>'Y',
		'USE_PREFIX'=>'Y',
		'USE_KLADR'=>'N',
		'DISPLAY_GPA'=>'Y',
		'GPA_POINTS_OR_PERCENT_GRADE'=>'GPA_POINTS'
		);

	$user_defaults = array(
		'SORT'=>'Name',
		'SEARCH'=>'Y',
		'DELIMITER'=>'Tab',
		'COLOR'=>'FFFFCC',
		'HIGHLIGHT'=>'4871b0',
		'ROLLOVER_HIGHLIGHT'=>'749FFF',
		'HIGHLIGHT_MENU'=>'blue',
		'HIGHLIGHT_WINDOW'=>'c4d9fa',
		'HIGHLIGHT_WINDOW_BACKGROUND'=>'c4d9fa',
		'HIGHLIGHT_BACKGROUND'=>'e6ecf4',
		'HIGHLIGHT_FRAME'=>'blue',
               	'THEME'=>'green',
		'LANGUAGE'=>'en_US',
		'MENU'=>'Top',
		'HIDDEN'=>'Y',
		'WEEKDAY'=>'',
		'MONTH'=>'M',
		'DAY'=>'j',
		'YEAR'=>'Y',
		'MONTH_DAY'=>'mdy',
		'DEFAULT_ALL_SCHOOLS'=>'N',
		'DEFAULT_CUSTOMIZED_LIST'=>'N',
		'DISPLAY_CLASSLEVEL'=>'Y',
		'DISPLAY_GROUP'=>'N',
		'DISPLAY_STUDENT_ID'=>'Y',
		'ASSIGNMENT_SORTING'=>'ASSIGNMENT_ID',
		'ROUNDING'=>'NORMAL',
		'DEFAULT_DUE_DATE'=>'tomorrow',
		'DISPLAY_GRADEBOOK_PERCENTAGES'=>'Y',
		'ALLOW_FINAL_GRADE_UG_CALC'=>'N',
		'CALENDAR'=>'Mon',
		'CURRENCY_SL'=>'Left',
		'LABEL_POSITION'=>'bottom',
		'NAME_FORMAT'=>'WCM',
		'DEFAULT_TAB'=>3
		);

	if(get_user('PROFILE')=='parent' || get_user('PROFILE')=='student')
		$user_defaults['MENU'] = 'Top';
	if(get_user('PROFILE')=='teacher')
	{
		$user_defaults['SORT'] = 'Enrolled';
		$user_defaults['SEARCH'] = 'N';
	}
    
	$result = null;
	$system_value = null;
	$school_value = null;
            
	if($_SYSTEM['SystemPreferences'][$program][$item])
	    foreach ($_SYSTEM['SystemPreferences'][$program][$item] as $value)
	    {
	        if($value['SCHOOL_ID']!=null)
	            $school_value = &$value['VALUE'];
	        else
	            $system_value = &$value['VALUE'];
	    }

	if($system_only)
	{
    	    $result = &$system_value;
	}
	else
	{
    	    if($school_value!=null)
    	    {
        	$result = &$school_value;
    	    }
    	    else
    	    {
        	$result = &$system_value;
    	    }
	}
	if(!$result && ($program=='Preferences' || $program=='Gradebook'))
		$result = $user_defaults[$item];
	elseif(!$result)
		$result = $defaults[$item];
	return $result;
}
?>