<?php

/**
* Returns any information about any school.  Caches all school information so that this function can be used in a report which lists many records including school information.
*
* @param int $school_id The ID number corresponding to the school for which we need information.
* @param String $second_param An unused parameter.  This parameter is unused in case get_school() is ever called by a function sent as the second parameter to db_request().  db_request() always sends a second parameter (the column name), so this parameter is useless.
* @param String $column The column name of the data we need from the SCHOOLS table.  This defaults to TITLE so as to return the name of the school.  However, if we substitute another column from the SCHOOLS table, we will get different data.
*/
function get_school($school_id,$second_param=null,$column='TITLE')
{	global $_SYSTEM;
	
	if(!$_SYSTEM['get_school'])
	{
		$QI=db_execute("SELECT * FROM SCHOOLS");
		$_SYSTEM['get_school'] = db_request($QI,array(),array('ID'));
	}

	if(!empty($school_id)) 
		return $_SYSTEM['get_school'][$school_id][1][$column];
	else
		return $_SYSTEM['get_school'];
}
?>