angular.module('mm.addons.mod_iomadcertificate', [])
.constant('mmaModIomadCertificateComponent', 'mmaModIomadCertificate')
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.mod_iomadcertificate', {
        url: '/mod_iomadcertificate',
        params: {
            module: null,
            courseid: null
        },
        views: {
            'site': {
                controller: 'mmaModIomadCertificateIndexCtrl',
                templateUrl: '$ADDONPATH$/templates/index.html'
            }
        }
    });
}])
.config(["$mmCourseDelegateProvider", "$mmContentLinksDelegateProvider", function($mmCourseDelegateProvider, $mmContentLinksDelegateProvider) {
    $mmCourseDelegateProvider.registerContentHandler('mmaModIomadCertificate', 'iomadcertificate', '$mmaModIomadCertificateHandlers.courseContent');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaModIomadCertificate', '$mmaModIomadCertificateHandlers.linksHandler');
}]);

angular.module('mm.addons.mod_iomadcertificate')
.controller('mmaModIomadCertificateIndexCtrl', ["$scope", "$stateParams", "$mmaModIomadCertificate", "$mmUtil", "$q", "$mmCourse", function($scope, $stateParams, $mmaModIomadCertificate, $mmUtil, $q, $mmCourse) {
    var module = $stateParams.module || {},
        courseId = $stateParams.courseid,
        iomadcertificate;
    $scope.title = module.name;
    $scope.description = module.description;
    $scope.courseid = courseId;
    function fetchIomadCertificate(refresh) {
        return $mmaModIomadCertificate.getIomadCertificate(courseId, module.id).then(function(iomadcertificateData) {
            iomadcertificate = iomadcertificateData;
            $scope.title = iomadcertificate.name || $scope.title;
            $scope.description = iomadcertificate.intro || $scope.description;
            $scope.iomadcertificate = iomadcertificate;
            if (iomadcertificate.requiredtimenotmet) {
                return $q.when();
            }
            return $mmaModIomadCertificate.issueIomadCertificate(iomadcertificate.id).finally(function() {
                return $mmaModIomadCertificate.getIssuedIomadCertificates(iomadcertificate.id).then(function(issues) {
                    $scope.issues = issues;
                });
            });
        }).catch(function(message) {
            if (!refresh) {
                return refreshAllData();
            }
            if (message) {
                $mmUtil.showErrorModal(message);
            } else {
                $mmUtil.showErrorModal('Error while getting the iomadcertificate', true);
            }
            return $q.reject();
        });
    }
    function refreshAllData() {
        var p1 = $mmaModIomadCertificate.invalidateIomadCertificate(courseId),
            iomadcertificateRequiredTimeNotMet = typeof(iomadcertificate) != 'undefined' && iomadcertificate.requiredtimenotmet,
            p2 = iomadcertificateRequiredTimeNotMet ? $q.when() : $mmaModIomadCertificate.invalidateIssuedIomadCertificates(iomadcertificate.id);
            p3 = iomadcertificateRequiredTimeNotMet ? $q.when() : $mmaModIomadCertificate.invalidateDownloadedIomadCertificates(module.id);
        return $q.all([p1, p2, p3]).finally(function() {
            return fetchIomadCertificate(true);
        });
    }
    $scope.openIomadCertificate = function() {
        var modal = $mmUtil.showModalLoading();
        var issuedIomadCertificate = $scope.issues[0];
        $mmaModIomadCertificate.openIomadCertificate(issuedIomadCertificate, module.id)
        .catch(function(error) {
            if (error && typeof error == 'string') {
                $mmUtil.showErrorModal(error);
            } else {
                $mmUtil.showErrorModal('Error while downloading the iomadcertificate', false);
            }
        }).finally(function() {
            modal.dismiss();
        });
    };
    fetchIomadCertificate().then(function() {
        $mmaModIomadCertificate.logView(iomadcertificate.id).then(function() {
            $mmCourse.checkModuleCompletion(courseId, module.completionstatus);
        });
    }).finally(function() {
        $scope.iomadcertificateLoaded = true;
    });
    $scope.doRefresh = function() {
        refreshAllData().finally(function() {
            $scope.$broadcast('scroll.refreshComplete');
        });
    };
}]);

angular.module('mm.addons.mod_iomadcertificate')
.factory('$mmaModIomadCertificate', ["$q", "$mmSite", "$mmFS", "$mmUtil", "$mmSitesManager", "mmaModIomadCertificateComponent", "$mmFilepool", function($q, $mmSite, $mmFS, $mmUtil, $mmSitesManager, mmaModIomadCertificateComponent, $mmFilepool) {
    var self = {};
        self.getIomadCertificate = function(courseId, cmId) {
        var params = {
                courseids: [courseId]
            },
            preSets = {
                cacheKey: getIomadCertificateCacheKey(courseId)
            };
        return $mmSite.read('mod_iomadcertificate_get_iomadcertificates_by_courses', params, preSets).then(function(response) {
            if (response.iomadcertificates) {
                var currentIomadCertificate;
                angular.forEach(response.iomadcertificates, function(iomadcertificate) {
                    if (iomadcertificate.coursemodule == cmId) {
                        currentIomadCertificate = iomadcertificate;
                    }
                });
                if (currentIomadCertificate) {
                    return currentIomadCertificate;
                }
            }
            return $q.reject();
        });
    };
        function getIomadCertificateCacheKey(courseId) {
        return 'mmaModIomadCertificate:iomadcertificate:' + courseId;
    }
        self.getIssuedIomadCertificates = function(id) {
        var params = {
                iomadcertificateid: id
            },
            preSets = {
                cacheKey: getIssuedIomadCertificatesCacheKey(id)
            };
        return $mmSite.read('mod_iomadcertificate_get_issued_iomadcertificates', params, preSets).then(function(response) {
            if (response.issues) {
                return response.issues;
            }
            return $q.reject();
        });
    };
        function getIssuedIomadCertificatesCacheKey(id) {
        return 'mmaModIomadCertificate:issued:' + id;
    }
        self.invalidateIomadCertificate = function(courseId) {
        return $mmSite.invalidateWsCacheForKey(getIomadCertificateCacheKey(courseId));
    };
        self.invalidateIssuedIomadCertificates = function(id) {
        return $mmSite.invalidateWsCacheForKey(getIssuedIomadCertificatesCacheKey(id));
    };
        self.isPluginEnabled = function(siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.wsAvailable('mod_iomadcertificate_get_iomadcertificates_by_courses');
        });
    };
        self.logView = function(id) {
        if (id) {
            var params = {
                iomadcertificateid: id
            };
            return $mmSite.write('mod_iomadcertificate_view_iomadcertificate', params);
        }
        return $q.reject();
    };
        self.issueIomadCertificate = function(iomadcertificateId) {
         var params = {
            iomadcertificateid: iomadcertificateId
        };
        return $mmSite.write('mod_iomadcertificate_issue_iomadcertificate', params).then(function(response) {
            if (!response || !response.issue) {
                return $q.reject();
            }
        });
    };
        self.openIomadCertificate = function(issuedIomadCertificate, moduleId) {
        var siteId = $mmSite.getId(),
            revision = 0,
            timeMod = issuedIomadCertificate.timecreated,
            files = [{fileurl: issuedIomadCertificate.fileurl, filename: issuedIomadCertificate.filename, timemodified: timeMod}];
        if ($mmFS.isAvailable()) {
            promise = $mmFilepool.downloadPackage(siteId, files, mmaModIomadCertificateComponent, moduleId, revision, timeMod).then(function() {
                return $mmFilepool.getUrlByUrl(siteId, issuedIomadCertificate.fileurl, mmaModIomadCertificateComponent, moduleId, timeMod);
            });
        } else {
            promise = $q.when($mmSite.fixPluginfileURL(issuedIomadCertificate.fileurl));
        }
        return promise.then(function(localUrl) {
            return $mmUtil.openFile(localUrl);
        });
    };
        self.invalidateDownloadedIomadCertificates = function(moduleId) {
        return $mmFilepool.invalidateFilesByComponent($mmSite.getId(), mmaModIomadCertificateComponent, moduleId);
    };
    return self;
}]);

angular.module('mm.addons.mod_iomadcertificate')
.factory('$mmaModIomadCertificateHandlers', ["$mmCourse", "$mmaModIomadCertificate", "$state", "$q", function($mmCourse, $mmaModIomadCertificate, $state, $q) {
    var self = {};
        self.courseContent = function() {
        var self = {};
                self.isEnabled = function() {
            return $mmaModIomadCertificate.isPluginEnabled();
        };
                self.getController = function(module, courseid) {
            return function($scope) {
                $scope.title = module.name;
                $scope.icon = '$ADDONPATH$/icon.gif'
                $scope.class = 'mma-mod_iomadcertificate-handler';
                $scope.action = function() {
                    $state.go('site.mod_iomadcertificate', {module: module, courseid: courseid});
                };
            };
        };
        return self;
    };
        self.linksHandler = function() {
        var self = {};
                function isEnabled(siteId, courseId) {
            return $mmaModIomadCertificate.isPluginEnabled(siteId).then(function(enabled) {
                if (!enabled) {
                    return false;
                }
                return courseId || $mmCourse.canGetModuleWithoutCourseId(siteId);
            });
        }
                self.getActions = function(siteIds, url, courseId) {
            if (typeof self.handles(url) != 'undefined') {
                return $mmContentLinksHelper.treatModuleIndexUrl(siteIds, url, isEnabled, courseId);
            }
            return $q.when([]);
        };
                self.handles = function(url) {
            var position = url.indexOf('/mod/iomadcertificate/view.php');
            if (position > -1) {
                return url.substr(0, position);
            }
        };
        return self;
    };
    return self;
}]);
