// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

angular.module('mm.addons.mod_iomadcertificate')

/**
 * IomadCertificate index controller.
 *
 * @module mm.addons.mod_iomadcertificate
 * @ngdoc controller
 * @name mmaModIomadCertificateIndexCtrl
 */
.controller('mmaModIomadCertificateIndexCtrl', function($scope, $stateParams, $mmaModIomadCertificate, $mmUtil, $q, $mmCourse) {
    var module = $stateParams.module || {},
        courseId = $stateParams.courseid,
        iomadcertificate;

    $scope.title = module.name;
    $scope.description = module.description;
    $scope.courseid = courseId;

    // Convenience function to get IomadCertificate data.
    function fetchIomadCertificate(refresh) {
        return $mmaModIomadCertificate.getIomadCertificate(courseId, module.id).then(function(iomadcertificateData) {
            iomadcertificate = iomadcertificateData;
            $scope.title = iomadcertificate.name || $scope.title;
            $scope.description = iomadcertificate.intro || $scope.description;
            $scope.iomadcertificate = iomadcertificate;

            // Requeriments for issue iomadcertificates not met yet, ommit try to download already issued iomadcertificates.
            if (iomadcertificate.requiredtimenotmet) {
                return $q.when();
            }

            // Every time we access we call the issue iomadcertificate WS, this may fail if the user is not connected so we must retrieve
            // the issued iomadcertificate to use the cache on failure.
            return $mmaModIomadCertificate.issueIomadCertificate(iomadcertificate.id).finally(function() {
                return $mmaModIomadCertificate.getIssuedIomadCertificates(iomadcertificate.id).then(function(issues) {
                    $scope.issues = issues;
                });
            });
        }).catch(function(message) {
            if (!refresh) {
                // Some call failed, retry without using cache since it might be a new activity.
                return refreshAllData();
            }

            if (message) {
                $mmUtil.showErrorModal(message);
            } else {
                $mmUtil.showErrorModal('Error while getting the iomadcertificate', true);
            }
            return $q.reject();
        });
    }

    // Convenience function to refresh all the data.
    function refreshAllData() {
        var p1 = $mmaModIomadCertificate.invalidateIomadCertificate(courseId),
            iomadcertificateRequiredTimeNotMet = typeof(iomadcertificate) != 'undefined' && iomadcertificate.requiredtimenotmet,
            p2 = iomadcertificateRequiredTimeNotMet ? $q.when() : $mmaModIomadCertificate.invalidateIssuedIomadCertificates(iomadcertificate.id);
            p3 = iomadcertificateRequiredTimeNotMet ? $q.when() : $mmaModIomadCertificate.invalidateDownloadedIomadCertificates(module.id);

        return $q.all([p1, p2, p3]).finally(function() {
            return fetchIomadCertificate(true);
        });
    }

    $scope.openIomadCertificate = function() {

        var modal = $mmUtil.showModalLoading();

        // Extract the first issued, file URLs are always the same.
        var issuedIomadCertificate = $scope.issues[0];

        $mmaModIomadCertificate.openIomadCertificate(issuedIomadCertificate, module.id)
        .catch(function(error) {
            if (error && typeof error == 'string') {
                $mmUtil.showErrorModal(error);
            } else {
                $mmUtil.showErrorModal('Error while downloading the iomadcertificate', false);
            }
        }).finally(function() {
            modal.dismiss();
        });
    };

    fetchIomadCertificate().then(function() {
        $mmaModIomadCertificate.logView(iomadcertificate.id).then(function() {
            $mmCourse.checkModuleCompletion(courseId, module.completionstatus);
        });
    }).finally(function() {
        $scope.iomadcertificateLoaded = true;
    });

    // Pull to refresh.
    $scope.doRefresh = function() {
        refreshAllData().finally(function() {
            $scope.$broadcast('scroll.refreshComplete');
        });
    };

});
