<?php
/**
* @file $id: index.php (17-12-2009)
* @pack Integral-Education
* @copyright Copyright (C) 2009 Integral-Group. All rights reserved.
* This package can be modified by the licencee, but the license is non-transferrable.
*/

include_once($staticpath.'classes/Students.class.php');
$classStudent = new Students;

function db_start(){
	global $DBServer,$DBUsername,$DBPassword,$DBName,$DBPort,$DBType,$DatabaseUseODBC,$connection;
	//phpinfo();
	//$connection = pg_connect("host=$DBServer dbname=$DBName user=$DBUsername password=$DBPassword") or die("Cannot connect to database");
	
	// if($connection){
//     	echo "connection is made with database";
//     }
// 	else{
//     	echo "can't acces database";
//     }

// 	$query = "SELECT * FROM users LIMIT 5"; 
// 	$rs = pg_query($connection, $query) or die("Cannot execute query: $query\n");
// 	print_r(pg_fetch_row($rs));

	//return $connection;
	
	switch($DBType)
	{
		case 'oracle':
		$connection = @ocilogon($DBUsername,$DBPassword,$DBServer);
		break;
		case 'postgres':
    	if(!$connection){
        	if($DBServer!='localhost')
            $connectstring = "host=$DBServer ";
			$connectstring .= "port=$DBPort dbname=$DBName user=$DBUsername";
			if(!empty($DBPassword))
				$connectstring.=" password=$DBPassword";
				//echo($DBPassword);
				if($connection = pg_connect("host=$DBServer dbname=$DBName user=$DBUsername password=$DBPassword"))
				{}
				else
				{
                	if($DBServer!='localhost')
                    $connectstring = "host=$DBServer port=$DBPort ";
					$connectstring .= "dbname=$DBName user=$DBUsername";
					if(!empty($DBPassword))
					$connectstring.=" password=$DBPassword";
					if($connection = pg_connect($connectstring))
					{}
					else
					{
						$connectstring = "host=$DBServer port=$DBPort ";
						$connectstring .= "dbname=$DBName user=$DBUsername";
						if(!empty($DBPassword))
						$connectstring.=" password=$DBPassword";
						$connection = pg_connect($connectstring);
					}
				}
			}
		break;
		case 'mysql':
			if(!$connection)
			{
				$connection = mysql_connect($DBServer,$DBUsername,$DBPassword);
				mysql_select_db($DBName);
			}
		break;

		case 'mssql':
			if(!$connection)
			{
				if($DatabaseUseODBC)
				{
					$connection = odbc_connect($DBName,$DBUsername,$DBPassword);
				}
				else
				{
					$connection = mssql_connect($DBServer,$DBUsername,$DBPassword);
					mssql_select_db($DBName,$connection);
				}
			}
		break;
	}

	// Error code for both.
	if($connection === false)
	{
		switch($DBType)
		{
			case 'oracle':
				$errors=OciError();
				$errormessage = $errors['message'];
			break;
			case 'postgres':
				$errormessage = pg_last_error($connection);
			break;
			case 'mysql':
				$errormessage = mysql_error($connection);
			break;
			case 'mssql':
				if($DatabaseUseODBC)
					$errormessage = odbc_errormsg($connection);
				else
					$errormessage = mssql_get_last_message();
			break;
		}
		echo "<H2>DB Connection error: database is down or unreachable.</H2><font color=black> You have to contact the system administrator.</font>";
//		echo '<!-- ';
//		echo $errormessage;
//		echo '-->';
		exit;
		//db_show_error("","Could not Connect to Database: $DBServer",$errstring);
	}

	return $connection;
}

// This function connects, and does the passed query, then returns a connection identifier.
// Not receiving the return == unusable search.
//		ie, $processable_results = db_execute("select * from students");
function db_execute($sql, $SkipMSSqlIdentityInsert=true, $MSSqlRemoveIdentityColumn=false)
{	global $DBType,$DBUsername,$DatabaseUseODBC,$_SYSTEM,$IgnoreFiles,$staticpath,$sql_data,$varCopy,
		$addonPath,$SchemaName,$_REQUEST,$_Config;

	$connection = db_start();
	$Debug = false;
        if($DBType=='mssql' && strtolower(substr(trim($sql), 0, 6)) == 'select' && ($_REQUEST['servicemod']=='applicants_online' || $_REQUEST['servicemod']=='mod_apply/Data.php'))    //need to check
                $_SYSTEM['use_sequence_insert'] = false;                            //need to check
	if($DBType=='mssql' && strtolower(substr(trim($sql), 0, 6)) == 'insert')
	{	
		if($_SYSTEM['use_sequence_insert'])
		{
			$query_middle = substr($sql,strpos($sql,'('));
			$query_begin = substr($sql,0,strpos($sql,'('));
			$query_middle = '('.substr($query_middle,(strpos($query_middle,',')+1));
			if((strpos(strtolower($sql),'values(') > 0) || (strpos(strtolower($sql),'values (') > 0))
			{
				$query_end = substr($query_middle,strpos(strtolower($query_middle),'values('));
				$query_middle = substr($query_middle,0,strpos(strtolower($query_middle),'values('));
				$query_end = 'values('.substr($query_end,(strpos($query_end,',')+1));
			}
			else
			{
				$query_end = substr($query_middle,strpos(strtolower($query_middle),'select '));
				$query_middle = substr($query_middle,0,strpos(strtolower($query_middle),'select '));
				$query_end = 'select '.substr($query_end,(strpos($query_end,',')+1));
			}
			$sql = $query_begin.$query_middle.$query_end;
			$_SYSTEM['use_sequence_insert'] = false;
		}
	}
//	echo "<<".$sql."<br>";
	//work with addons
//	echo "=====";
	if($addonPath && $_SYSTEM['DisableAddonLoader']!=true)
	{
		$_SYSTEM['DisableAddonSQLParser'] = false; 
//		if(file_exists($addonPath.'/addonloader.php'))
//			include($addonPath.'/addonloader.php');
		if(file_exists($staticpath.'/addonloader.php'))
//			include_once($staticpath.'/addonloader.php');
			include($staticpath.'/addonloader.php');

	}

	if($_SYSTEM['DisableAddonLoader']!=true)
	{
		if(!$addonPath)
			$_SYSTEM['DisableAddonSQLParser'] = false; 

    		$OldaddonPath = $addonPath;
	        $addonPath = $staticpath.'functions/addons';
		if(file_exists($staticpath.'/addonloader.php'))
//			include_once($staticpath.'/addonloader.php');
			include($staticpath.'/addonloader.php');
    		$addonPath = $OldaddonPath;
	}
	if($_SYSTEM['preg_replace']!==false && ($DBType=='postgres' || $DBType=='mssql') && strtolower(substr(trim($sql), 0, 6)) != 'select' && strtolower(substr(trim($sql), 0, 6)) != 'delete')
	{
//		$sql = preg_replace("/'([,\(=])[\r\n\t ]*''/",'\1NULL\1',$sql);
//		$sql = preg_replace("([,\(=])[\r\n\t ]*''",'\\1NULL',$sql);
//		$sql = preg_replace("([,\(=])[\r\n\t ]*''''",'\\1NULL',$sql);
//		$sql = preg_replace("/NULL'*'/",'NULL',$sql);
//		$sql = preg_replace("/=([''])/",'=NULL',$sql);
//echo "1>".$sql."<br>";
		$sql = preg_replace("/([\(=])(\s|)[\r\n\t ]*'{2,2}(\s|)[\s,]/",'\\1NULL,',$sql);
		$sql = str_replace("NULL,WHERE",'NULL WHERE',$sql);
		$sql = str_replace("NULL,AND",'NULL AND',$sql);
		$sql = preg_replace("/([,\(])[\r\n\t ]*'{2,2}([,])/",'\\1NULL\1',$sql);
		$sql = preg_replace("/([,\(])[\r\n\t ]*'{2,2}([\)])/",'\\1NULL)',$sql);
		$sql = preg_replace("/([,\(])[\r\n\t ]*'{2,2}([\s])/",'\\1NULL ',$sql);
		$sql = preg_replace("/([,\(=])(\s|)[\r\n\t ]*'{2,2}$/",'\\1NULL',$sql);
//		echo "2>".$sql."<br>";
		//orig
		//		$sql = preg_replace("([,\(=])[\r\n\t ]*''",'\\1NULL',$sql);
	}
	else
	{
//	echo "1>".$sql."<br>";
		if(strpos($sql,'LOWER(USERNAME)=LOWER(') !== false || strpos($sql,'LOWER(s.USERNAME)=LOWER(') !== false || strpos($sql,'LOWER(a.USERNAME)=LOWER(') !== false)
		{
//		echo "ggggggggggg";
		}
		else
			$sql = preg_replace("/([,\(=])[\r\n\t ]*''/",'\\1NULL',$sql);
//	echo "1>".$sql."<br>";			
	}
	if(!$_SYSTEM['DisableAddonSQLParser'])
	{
		if(!$_Config['integral_replace']) $_Config['integral_replace'] = array();
                foreach($_Config['integral_replace'] as $integralcharacter=>$htmlcharacter)
                    $sql = str_replace($htmlcharacter,$integralcharacter,$sql);
		switch($DBType)
		{
			case 'oracle':
				$result = @ociparse($connection, $sql);
				if($result === false)
				{
					$errors = OCIError($connection);
					db_show_error($sql,"DB Parse Failed.", $errors['message']);
				}
				if(!@OciExecute($result))
				{
					$errors = OCIError($result);
					db_show_error($sql,"DB Execution Failed.", $errors['message']);
				}
				OciCommit($connection);
				OciLogoff($connection);
			break;
			case 'postgres':
				if(strtolower(substr(trim($sql), 0, 6)) != 'insert' || strtolower(substr(trim($sql), 0, 6)) != 'select')
				{
					// Fix IN () error
					$sql = str_replace("IN ()", "IN (NULL)", $sql);
					$sql = str_replace("IN()", "IN(NULL)", $sql);
			//		echo $sql.'<br>';
				}			
				if('LOADED_BY_MODULES')
				{
//					echo $sql."<br>";
					$_SESSION['sql_log'][] = $sql;
					$time = microtime(true);
					write_db_log($sql);
					$result = @pg_exec($connection,$sql);
					$_SESSION['sql_times'][] = round(microtime(true) - $time,2);
				}
				else
				{
					write_db_log($sql);
					$result = @pg_exec($connection,$sql);
				}

				if($result===false)
				{
					$errstring = pg_last_error($connection);
					db_show_error($sql,"DB Execution Failed.", $errstring);
				}
			break;
			case 'mysql':
				$result = mysql_query($sql,$connection) or die(db_show_error($sql,"DB Execution Failed.",mysql_error()));
			break;
			case 'mssql':
				if($DBUsername != 'sa')
					$sql = str_replace('dbo.', $SchemaName.'.', $sql);
//				echo "---->".$sql.'<br>';
//				echo "---->".$sql.'<br>';
//				echo "==========================================>".date("H:m:s",time())."<br>";
				if(strtolower(substr(trim($sql), 0, 6)) != 'insert')
				{
					// Fix cast(xxx as text) error
					$sql = str_replace('AS TEXT', 'AS VARCHAR', $sql);
					// Fix puc.VALUE='Y' error
					$sql = str_replace("puc.VALUE='Y'", "puc.VALUE like 'Y'", $sql);
					// Fix IN () error
					$sql = str_replace("IN ()", "IN (NULL)", $sql);
					$sql = str_replace("IN()", "IN(NULL)", $sql);                                        
//					echo $sql.'<br>';
				}
				if(LOADED_BY_MODULES)
				{

					$_SESSION['sql_log'][] = $sql;
					$time = microtime(true);
					if($DatabaseUseODBC)
						$result = odbc_exec($connection,$sql) or die(db_show_error($sql,"DB Execution Failed.\n".$sql,odbc_errormsg($connection)));
					else
					{
						write_db_log($sql);
						$result = mssql_query($sql,$connection) or die(db_show_error($sql,"DB Execution Failed.\n".$sql,mssql_get_last_message()));
					}
//					$result = iconv("cp1251","utf8",$result);
					$_SESSION['sql_times'][] = round(microtime(true) - $time,2);
				}
				else
				{
					if($DatabaseUseODBC)
					{
						write_db_log($sql);
						$result = odbc_exec($connection,$sql) or die(db_show_error($sql,"DB Execution Failed.\n".$sql,odbc_errormsg($connection)));
					}
					else
					{
						write_db_log($sql);
						$result = mssql_query($sql,$connection) or die(db_show_error($sql,"DB Execution Failed.\n".$sql,mssql_get_last_message()));
					}
				}
			  break;
		}
	}
	return $result;
}

// return next row.
function db_fetch_row($result,$change_keys_to_upper=true)
{	global $DBType,$DatabaseUseODBC;

	switch($DBType)
	{
		case 'oracle':
			OCIFetchInto($result,$row,OCI_ASSOC+OCI_RETURN_NULLS);
			if($change_keys_to_upper==true)
				return @array_change_key_case($row,CASE_UPPER);
			else
				return $row;
		break;
		case 'postgres':
			if($change_keys_to_upper==true)
				return @array_change_key_case(pg_fetch_array($result,NULL,PGSQL_ASSOC),CASE_UPPER);
			else
				return pg_fetch_array($result,NULL,PGSQL_ASSOC);
		break;
		case 'mysql':
			if($change_keys_to_upper==true)
				return @array_change_key_case(mysql_fetch_array($result,MYSQL_ASSOC),CASE_UPPER);
			else
				return mysql_fetch_array($result,MYSQL_ASSOC);
		break;
		case 'mssql':
			if($change_keys_to_upper==true)
				if($DatabaseUseODBC)
					return @array_change_key_case(odbc_fetch_array($result),CASE_UPPER);
				else
					return @array_change_key_case(mssql_fetch_array($result,MSSQL_ASSOC),CASE_UPPER);
			else
				if($DatabaseUseODBC)
					return odbc_fetch_array($result);
				else
					return mssql_fetch_array($result,MSSQL_ASSOC);
		break;
	}
}

// returns code to go into SQL statement for accessing the next value of a sequenc	function db_seq_nextval($seqname)
function db_seq_nextval($seqname)
{	global $DBType,$_SYSTEM;

	$_SYSTEM['use_sequence_insert'] = true;

	if(strtolower($DBType)=='oracle')
		$seq=$seqname.".nextval";
	elseif(strtolower($DBType)=='postgres')
		$seq="nextval('".$seqname."')";
	elseif(strtolower($DBType)=='mssql')
		// This should never be used, since db_execute() strips out the IDENTITY column in the SQL statement
		// $seqname will be the table name for MS SQL,
		// thrown away the 4 right chars because the original DB in PostgreSql always suffixed with '_SEQ' and
		// we don't use those suffixes in MS SQL
		$seq="IDENT_CURRENT('".substr($seqname, 0, -4)."') + IDENT_INCR('".substr($seqname, 0, -4)."')";
	return $seq;
}


function db_seq_currval($seqname)
{	global $DBType;

	if(strtolower($DBType)=='oracle')
		$seq=db_request(db_execute("SELECT ".$seqname.".currval AS SEQ ".FROM_DUAL));
	elseif(strtolower($DBType)=='postgres')
		$seq=db_request(db_execute("SELECT currval('".$seqname."') AS SEQ"));
	elseif(strtolower($DBType)=='mssql')
	{
		// $seqname will be the table name for MS SQL,
		// thrown away the 4 right chars because the original DB in PostgreSql always suffixed with '_SEQ' and
		// we don't use those suffixes in MS SQL
		$seq=db_request(db_execute("SELECT SCOPE_IDENTITY() AS seq"));
	}
	return $seq[1]['SEQ'];
}


// keyword mapping.
if(strtolower($DBType)=='oracle')
	define("FROM_DUAL"," FROM DUAL ");
else
	define("FROM_DUAL"," ");
if(strtolower($DBType)=='mssql')
	define("CCAT","+");
else
	define("CCAT","||");

// DECODE and CASE-WHEN support
// usage "'A'","'B'" means WHEN 'A' THEN 'B'
function db_case($array)
{	global $DBType,$_SYSTEM;

	$counter=0;
	if(true || strtolower($DBType)=="postgres")
	{
		$array_count=count($array);
		if($_SYSTEM['db_case_dont_array_0']!==true)
		{
			$string = " CASE WHEN $array[0] =";
			$counter++;
		}
		else
		{
			$string = " CASE WHEN $array[0] ";
			$counter ++;
		}

		$arr_count = count($array);
		for($i=1;$i<$arr_count;$i++)
		{
			$value = $array[$i];

			if($value=="''" && substr($string,-1)=='=')
			{
				$value = ' IS NULL';
				$string = substr($string,0,-1);
			}
			elseif(substr($value,0,1)=='%' || substr($value,-2)=="%'")
			{
				$string = substr($string,0,-1).' LIKE ';
			}

			if($_SYSTEM['db_case_dont_array_0']!==true)
			{
				$string.="$value";

				if($counter==($array_count-2) && $array_count%2==0)
					$string.=" ELSE ";
				elseif($counter==($array_count-1))
					$string.=" END ";
				elseif($counter%2==0)
					$string.=" WHEN $array[0]=";
				elseif($counter%2==1)
					$string.=" THEN ";
			}
			else
			{
				if($counter==($array_count-1) && $array_count%2==1)
					$string.=" ELSE ";
				elseif($counter==($array_count))
					$string.=" END ";
				elseif($counter%2==0)
					$string.=" WHEN ";
				elseif($counter%2==1)
					$string.=" THEN ";

				$string.="$value";
			}

			$counter++;
		}

		if($_SYSTEM['db_case_dont_array_0']===true)
			$string .= ' END ';
	}
	else
	{
		$string=" decode( ";
		foreach($array as $value)
			$string.="$value,";
		$string[strlen($string)-1]=")";
		$string.=" ";
	}
	return $string;
}

// String position.
function db_strpos($args)
{	global $DBType;

	if(strtolower($DBType)=="postgres")
		$ret = 'strpos(';
	elseif(strtolower($DBType)=="oracle")
		$ret = 'instr(';
	elseif(strtolower($DBType)=="mssql")
		$ret = 'charindex(';


	foreach($args as $value)
		$ret .= $value . ',';
	$ret = substr($ret,0,-1) . ')';

	return $ret;
}

function db_to_char($source,$conversion)
{	global $DBType, $DBUsername,$SchemaName;
	if(strtolower($DBType)=="mssql")
	{
		if($DBUsername <> "sa")
			return $SchemaName.".to_char(".$source.",'".$conversion."')";
		else
			return "dbo.to_char(".$source.",'".$conversion."')";
	}else{
		return "to_char(".$source.",'".$conversion."')";
	}
}

// CONVERT VARCHAR TO NUMERIC
function db_to_number($text)
{	global $DBType;

    if(strtolower($DBType)=="mssql")
	    return "cast($text as numeric)";
	elseif(strtolower($DBType)=="postgres")
		return '('.$text.')::text::float::numeric';
	else
		return 'to_number('.$text.')';
}

function db_properties($table)

{

	global $DBType,$DBUsername;

	switch($DBType)
	{
		case 'oracle':
			$sql="SELECT COLUMN_NAME, DATA_TYPE, DATA_LENGTH, DATA_PRECISION,
				DATA_SCALE, NULLABLE, DATA_DEFAULT
				FROM ALL_TAB_COLUMNS WHERE TABLE_NAME='".strtoupper($table)."'
				AND OWNER='".strtoupper($DBUsername)."' ORDER BY COLUMN_ID";
			$result = db_execute($sql);
			while($row=db_fetch_row($result))
			{
				if($row['DATA_TYPE']=='VARCHAR2')
				{
					$properties[$row['COLUMN_NAME']]['TYPE'] = "VARCHAR";
					$properties[$row['COLUMN_NAME']]['SIZE'] = $row['DATA_LENGTH'];
				}
				elseif($row['DATA_TYPE']=='NUMBER')
				{
					$properties[$row['COLUMN_NAME']]['TYPE'] = "NUMERIC";
					$properties[$row['COLUMN_NAME']]['SIZE'] = $row['DATA_PRECISION'];
					$properties[$row['COLUMN_NAME']]['SCALE'] = $row['DATA_SCALE'];
				}
				else
				{
					$properties[$row['COLUMN_NAME']]['TYPE'] = $row['DATA_TYPE'];
					$properties[$row['COLUMN_NAME']]['SIZE'] = $row['DATA_LENGTH'];
					$properties[$row['COLUMN_NAME']]['SCALE'] = $row['DATA_SCALE'];
				}
				$properties[$row['COLUMN_NAME']]['NULL'] = $row['NULLABLE'];
			}
		break;
		case 'postgres':
			$sql = "SELECT a.attnum,a.attname AS field,t.typname AS type,
					a.attlen AS length,a.atttypmod AS lengthvar,
					a.attnotnull AS notnull
				FROM pg_class c, pg_attribute a, pg_type t
				WHERE c.relname = '".strtolower($table)."'
					and a.attnum > 0 and a.attrelid = c.oid
					and a.atttypid = t.oid ORDER BY a.attnum";
			$result = db_execute($sql);
			while($row = db_fetch_row($result))
			{
				$properties[strtoupper($row['FIELD'])]['TYPE'] = strtoupper($row['TYPE']);
				if(strtoupper($row['TYPE'])=="NUMERIC")
				{
					$properties[strtoupper($row['FIELD'])]['SIZE'] = ($row['LENGTHVAR'] >> 16) & 0xffff;
					$properties[strtoupper($row['FIELD'])]['SCALE'] = ($row['LENGTHVAR'] -4) & 0xffff;
				}
				else
				{
					if($row['LENGTH']>0)
						$properties[strtoupper($row['FIELD'])]['SIZE'] = $row['LENGTH'];
					elseif($row['LENGTHVAR']>0)
						$properties[strtoupper($row['FIELD'])]['SIZE'] = $row['LENGTHVAR']-4;
				}
				if($row['NOTNULL']=='t')
					$properties[strtoupper($row['FIELD'])]['NULL'] = "N";
				else
					$properties[strtoupper($row['FIELD'])]['NULL'] = "Y";
			}
		break;
		case 'mysql':
			$result = db_execute("SHOW COLUMNS FROM $table");
			while($row = db_fetch_row($result))
			{
				$properties[strtoupper($row['FIELD'])]['TYPE'] = strtoupper($row['TYPE'],strpos($row['TYPE'],'('));
				if(!$pos = strpos($row['TYPE'],','))
					$pos = strpos($row['TYPE'],')');
				else
					$properties[strtoupper($row['FIELD'])]['SCALE'] = substr($row['TYPE'],$pos+1);

				$properties[strtoupper($row['FIELD'])]['SIZE'] = substr($row['TYPE'],strpos($row['TYPE'],'(')+1,$pos);

				if($row['NULL']!='')
					$properties[strtoupper($row['FIELD'])]['NULL'] = "Y";
				else
					$properties[strtoupper($row['FIELD'])]['NULL'] = "N";
			}
		break;
		case 'mssql':
      $sql = "select upper(col.name) as ColName, upper(typ.name) as Type, col.prec as Length, col.scale as Scale, col.isnullable as Nullable
        from sysobjects as obj
          inner join syscolumns as col on obj.id = col.id
          inner join systypes as typ on col.xtype = typ.xtype
        where obj.name = '".$table. "'";
			$result = db_execute($sql);
			while($row=db_fetch_row($result))
			{
				if(strtoupper($row['TYPE'])=='VARCHAR')
				{
					$properties[$row['COLNAME']]['TYPE'] = "VARCHAR";
					$properties[$row['COLNAME']]['SIZE'] = $row['LENGTH'];
				}
				elseif(strtoupper($row['TYPE'])=='NUMERIC')
				{
					$properties[$row['COLNAME']]['TYPE'] = "NUMERIC";
					$properties[$row['COLNAME']]['SIZE'] = $row['LENGTH'];
					$properties[$row['COLNAME']]['SCALE'] = $row['SCALE'];
				}
				else
				{
					$properties[$row['COLNAME']]['TYPE'] = strtoupper($row['TYPE']);
					$properties[$row['COLNAME']]['SIZE'] = $row['LENGTH'];
					$properties[$row['COLNAME']]['SCALE'] = $row['SCALE'];
				}
				$properties[$row['COLNAME']]['NULL'] = $row['NULLABLE'];
			}
    break;
	}
	return $properties;
}

function db_show_error($sql,$failnote,$additional='')
{	global $GeneralTitle,$IntegralVersion,$IntegralNotifyAddress,$_SYSTEM,$DBType,$connection;

	if(!$_SYSTEM['hidden_debug'] || $_SYSTEM['hidden_debug']===false)
		$_SYSTEM['hidden_debug'] = false;

	write_db_log('Query execution error: '.$sql);
/*
	echo "
		<TABLE CELLSPACING=10 BORDER=0><TR>
			<TD align=".ALIGN_RIGHT."><b>Date:</TD>
			<TD><pre>".date("m/d/Y h:i:s")."</pre></TD>
		</TR><TR>
			<TD align=".ALIGN_RIGHT."><b>Failure Notice:</b></TD>
			<TD><pre> $failnote </pre></TD>
		</TR><TR>
			<TD align=".ALIGN_RIGHT."><b>Additional Information:</b></TD>
			<TD>$additional</TD>
		</TR>
		</TABLE>";
			<TD align=".ALIGN_RIGHT."><b>Database execute error. This is beta version, please contact to AIS Integral support by support@ais-integral.ru</TD>		
*/
	echo "
		<TABLE CELLSPACING=10 BORDER=0><TR>
			<TD align=".'ALIGN_RIGHT'."><b>Database execution error. Please contact to AIS Integral support by admin@aju.ac.zw</TD>
		</TR><TR>";
	if($_SYSTEM['hidden_debug'] === true)
	{
		echo "
			<TD align=".'ALIGN_RIGHT'."><b>Error:</b></TD><TD><pre> $failnote </pre></TD></TR><TR><TD align=".'ALIGN_RIGHT'."><b>Information:</b></TD><TD>$additional</TD></TR>";
	}
		echo "</TABLE>";

	//Something you have asked the system to do has thrown a database error.  A system administrator has been notified, and the problem will be fixed as soon as possible.  It might be that changing the input parameters sent to this program will cause it to run properly.  Thanks for your patience.
	//PopTable('footer');
	if($_SYSTEM['hidden_debug'] === true)
	{
		echo "<!-- THESE SQL QUERIES WERE SENT: \n\n $sql ";
		print_r($_SESSION['sql_log']);
	}
	unset($_SESSION['sql_log']);
	unset($_SESSION['sql_times']);
	
	if($_SYSTEM['hidden_debug'] === true)	
		echo "\n\n -->";
//	echo "-->".var_dump($_REQUEST['servicemod']);
	if($_REQUEST['servicemod'] != 'mod_schedwiz/SchedulerSetup.php')
		Basic('footer');


	if($IntegralNotifyAddress)
	{
		$notify_addresses=$IntegralNotifyAddress;
		$notify_subject="Integral Database Error";
		$message="System: $GeneralTitle \n";
		$message.="Version: $IntegralVersion \n";
		$message.="Error Date: ".date("m/d/Y h:i:s")."\n";
		$message.="Error Page: ".$_SERVER['PHP_SELF'].' '.$_REQUEST['servicemod']." \n\n";
		$message.="Failure Note:  $failnote \n";
		$message.="Info: $additional \n";
		$message.="\n $sql \n";
		$message.="Request Array: \n".ShowVar($_REQUEST,'Y', 'N');
		$message.="\n\nSession Array: \n".ShowVar($_SESSION,'Y', 'N');
		mail($notify_addresses,$notify_subject,$message);
		
	}

//die();
}

 //$safe_string = DBEscapeString($string). 
// Escapes single quotes by using two for every
// one.  Requires preg support in PHP.

function get_db_date($type='postgres',$time=null)
{
	if(!$time)
		$time = time();
	if($type=='oracle')
		return strtoupper(date('d-M-y',$time));
	elseif($type=='postgres')
		return date('Y-m-d',$time);
	elseif($type=='mssql')
	    return date('Y-m-d',$time);
	elseif($type=='timestamp')
		return date('Y-m-d G:i:s',$time);
}

function set_db_date($Type='oracle', $Date, $Inc='+1', $DatePart='d')
{
	$Inc = trim($Inc);
	$DatePart = trim($DatePart);
	$Type = trim($Type);
	if(substr($Inc, 0, 1) != '+' and substr($Inc, 0, 1) != '-') $Inc = '+'.$Inc;
	switch(strtoupper($DatePart))
	{
		case 'D':
			$DatePart = 'day';
			break;
		case 'M':
			$DatePart = 'month';
			break;
		case 'Y':
			$DatePart = 'year';
			break;
		case 'H':
			$DatePart = 'hour';
			break;
		case 'N':
			$DatePart = 'minute';
			break;
		case 'S':
			$DatePart = 'second';
			break;
		default:
			$DatePart = 'day';
	}
	if(abs(intval(substr($Inc, 1))) > 1) $DatePart .= 's';
	$Date = strtotime($Date.' '.$Inc.' '.$DatePart);
	switch(strtoupper($Type))
	{
		case 'ORACLE':
			return strtoupper(date('d-M-y', $Date));
			break;
		case 'POSTGRES':
		case 'MSSQL':
			return date('Y-m-d', $Date);
			break;
		case 'TIMESTAMP':
			return date('Y-m-d G:i:s', $Date);
			break;
	}
}


function DBEscapeString($input)
{
   return str_replace("\'","''",$input);
}

// LIMIT function
function LIMIT($num)
{	global $DBType;

	if(strtolower($DBType) == 'mssql')
		return '';
	else
    	return 'LIMIT '.$num;
}
// Adds Limit, TOP keywords to SQL sttements. There should not be any of these keywords existing in the statement beforehand
function db_limit($SQL, $num)
{
	global $DBType;
	if(mb_strtolower($DBType) == 'mssql')
	{
                $dis_pos=strpos($SQL,'SELECT DISTINCT');
		$lim_pos = strpos($SQL,'SELECT');
		if($lim_pos === false && $dis_pos===false) 
                    return $SQL;
                elseif($lim_pos !== false && $dis_pos===false)
                    return substr_replace($SQL,'SELECT TOP '.$num,$lim_pos,strlen('SELECT'));
                elseif($lim_pos !== false && $dis_pos!==false)
                    return substr_replace($SQL,'SELECT DISTINCT TOP '.$num,$lim_pos,strlen('SELECT DISTINCT'));
	}
	elseif(strtolower($DBType) == 'oracle')
	{
		if(stristr($SQL,' WHERE ')===FALSE)
			return $SQL.' WHERE ROWNUM <= '.$num;
		else
			return str_ireplace(' WHERE ', ' WHERE ROWNUM <= '.$num.' AND ', $SQL);
	}
	elseif(strtolower($DBType) == 'mysql' || strtolower($DBType)=='postgres')
		return $SQL.' LIMIT '.$num;
}
function db_cast($field, $cast)
{
	global $DBType;
	if(strtolower($DBType) == 'mssql')
	{
		return 'CAST('.$field.' AS '.$cast.')';
	}
	elseif(strtolower($DBType) == 'mysql' || strtolower($DBType)=='postgres' || strtolower($DBType)=='oracle')
		return $field;
}

function db_substr($Expr, $Start, $Length)
{
	global $DBType;
	switch($DBType)
	{
		case 'mssql':
			return 'SUBSTRING('.$Expr.','.$Start.','.$Length.')';
		break;
		default:
			return 'substr('.$Expr.','.$Start.','.$Length.')';
		break;
	}
}
function write_db_log($sql)
{
	global $_Config,$staticpath;
	
	if($_Config['write_db_log'] === true)
	{
		$fname = 'sql_queries-'.date("Y-m-d").'.log';
//	echo $staticpath.' '.$fname;
		$fdb_log = fopen($staticpath.'logs/'.$fname,'a');
		if(isset($_Config['write_for_user_only']) && $_Config['write_for_user_only'] == $_SESSION['USER_NAME'])
		{
			$sql = date("H:i:s",time()).':'.$_SESSION['USER_NAME'].': '.$sql;
			fwrite($fdb_log,$sql."\n");
			fclose($fdb_log);
		}
		else
		{
			$sql = date("H:i:s",time()).': '.$sql;
			fwrite($fdb_log,$sql."\n");
			fclose($fdb_log);
		}
	}
}
?>
