<?php
$language = Preferences('LANGUAGE');
$lang = substr($language,0,2);

if($lang=='ar' || $lang=='ur' || $lang=='fa' || $lang=='il' || $lang=='ku')
{
	$_SYSTEM['direction'] = 'RTL';
	define('ALIGN_RIGHT','left');
	define('ALIGN_LEFT','right');
}
else
{
	$_SYSTEM['direction'] = '';
	define('ALIGN_RIGHT','right');
	define('ALIGN_LEFT','left');
}
if($language=='en_US' && !function_exists('_'))
{
	function _($text)
	{
		return $text;
	}
}
elseif(function_exists('gettext'))
{
	$character_set  = 'utf-8';
	putenv("LANG=$language".'.UTF-8');
	putenv("LANGUAGE=$language".'.UTF-8');
	setlocale(LC_ALL, $language.'.UTF-8');

	$domain = 'messages';
	bindtextdomain($domain,$staticpath.'languages/');
	textdomain($domain);
	bind_textdomain_codeset($domain,$character_set);
}
else
{
	require_once($staticpath.'php-gettext/streams.php');
	require_once($staticpath.'php-gettext/gettext.php');

	$file = $staticpath.'languages/'.$language.'/LC_MESSAGES/messages.mo';

	if(file_exists($file))
	{
		$input = new FileReader($file);

		$PhpGettext = new gettext_reader($input);

		if(!function_exists('_'))
		{
			function _($text)
			{	global $PhpGettext;
				return $PhpGettext->translate($text);

			}
		}
	}
	elseif(!function_exists('_'))
	{
		function _($text)
		{
			return $text;
		}
	}
}
?>