--
-- PostgreSQL database dump
--

-- Dumped from database version 10.14 (Ubuntu 10.14-1.pgdg16.04+1)
-- Dumped by pg_dump version 10.14 (Ubuntu 10.14-1.pgdg16.04+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: activity_courses; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.activity_courses (
    id numeric NOT NULL,
    school_year numeric,
    school_id numeric,
    title character varying(100),
    start_date date,
    end_date date
);


ALTER TABLE public.activity_courses OWNER TO postgres;

--
-- Name: activity_courses_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.activity_courses_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.activity_courses_seq OWNER TO postgres;

--
-- Name: addons_log; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.addons_log (
    addon_title character varying(100),
    error_date date
);


ALTER TABLE public.addons_log OWNER TO postgres;

--
-- Name: address; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.address (
    address_id numeric NOT NULL,
    zipcode character varying(15),
    plus4 character varying(4),
    city character varying(60),
    state character varying(15),
    mail_city character varying(60),
    mail_state character varying(10),
    mail_zipcode character varying(10),
    address character varying(255),
    mail_address character varying(255),
    phone character varying(30),
    latitude numeric,
    longitude numeric,
    username character varying(50),
    password character varying(50),
    last_login timestamp without time zone,
    failed_login numeric,
    last_note_seen numeric,
    profile_id numeric,
    force_password_change character varying(1) DEFAULT 'N'::character varying,
    fed_region character varying(100),
    mail_fed_region character varying(100),
    settlement character varying(100),
    mail_settlement character varying(100)
);


ALTER TABLE public.address OWNER TO postgres;

--
-- Name: address_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.address_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.address_seq OWNER TO postgres;

--
-- Name: adodb_logsql_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.adodb_logsql_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.adodb_logsql_id_seq OWNER TO postgres;

--
-- Name: adodb_logsql; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.adodb_logsql (
    id bigint DEFAULT nextval('public.adodb_logsql_id_seq'::regclass) NOT NULL,
    created timestamp without time zone NOT NULL,
    sql0 character varying(250) DEFAULT ''::character varying NOT NULL,
    sql1 text,
    params text,
    tracer text,
    timer numeric(16,6) DEFAULT 0 NOT NULL
);


ALTER TABLE public.adodb_logsql OWNER TO postgres;

--
-- Name: assignment_config; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.assignment_config (
    assignment_id numeric NOT NULL,
    assignment_type_id numeric NOT NULL,
    title character varying(100) NOT NULL,
    assigned_date date NOT NULL,
    due_date date NOT NULL,
    points numeric,
    description character varying(1000),
    benchmarks character varying(100),
    school_term_id numeric
);


ALTER TABLE public.assignment_config OWNER TO postgres;

--
-- Name: assignment_config_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.assignment_config_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.assignment_config_seq OWNER TO postgres;

--
-- Name: assignment_type_config; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.assignment_type_config (
    assignment_type_id numeric NOT NULL,
    title character varying(100) NOT NULL,
    final_grade_percent numeric,
    school_id numeric,
    hcolor character varying(6)
);


ALTER TABLE public.assignment_type_config OWNER TO postgres;

--
-- Name: assignment_type_config_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.assignment_type_config_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.assignment_type_config_seq OWNER TO postgres;

--
-- Name: attendance_code_cats_settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.attendance_code_cats_settings (
    id numeric,
    school_year numeric,
    school_id numeric,
    title character varying(255),
    rollover_id numeric
);


ALTER TABLE public.attendance_code_cats_settings OWNER TO postgres;

--
-- Name: attendance_code_cats_settings_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.attendance_code_cats_settings_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.attendance_code_cats_settings_seq OWNER TO postgres;

--
-- Name: attendance_codes_settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.attendance_codes_settings (
    id numeric NOT NULL,
    school_year numeric,
    school_id numeric,
    title character varying(100),
    short_name character varying(10),
    type character varying(10),
    state_code character varying(1),
    default_code character varying(1),
    table_name numeric,
    sort_order numeric,
    is_daily_code character varying(1)
);


ALTER TABLE public.attendance_codes_settings OWNER TO postgres;

--
-- Name: attendance_codes_settings_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.attendance_codes_settings_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.attendance_codes_settings_seq OWNER TO postgres;

--
-- Name: attendance_teacher_filled; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.attendance_teacher_filled (
    user_id numeric NOT NULL,
    school_date date NOT NULL,
    school_period_id numeric NOT NULL
);


ALTER TABLE public.attendance_teacher_filled OWNER TO postgres;

--
-- Name: available_modprog; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.available_modprog (
    modname character varying(255),
    user_id numeric,
    profile_id numeric
);


ALTER TABLE public.available_modprog OWNER TO postgres;

--
-- Name: billing_student_fees; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.billing_student_fees (
    student_id numeric NOT NULL,
    assigned_date date,
    due_date date,
    comments character varying(255),
    id numeric,
    title character varying(255),
    amount numeric,
    school_id numeric,
    school_year numeric,
    waived_fee_id numeric,
    old_id numeric,
    paip character varying(1),
    debt double precision,
    categories numeric,
    balance_debt double precision,
    cancellation double precision,
    payment_category_id numeric
);


ALTER TABLE public.billing_student_fees OWNER TO postgres;

--
-- Name: billing_student_fees_categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.billing_student_fees_categories (
    id numeric NOT NULL,
    school_year numeric NOT NULL,
    school_id numeric NOT NULL,
    title character varying(255),
    system_name character varying(50)
);


ALTER TABLE public.billing_student_fees_categories OWNER TO postgres;

--
-- Name: billing_student_fees_categories_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.billing_student_fees_categories_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.billing_student_fees_categories_seq OWNER TO postgres;

--
-- Name: billing_student_fees_old; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.billing_student_fees_old (
    id numeric NOT NULL,
    category_id numeric NOT NULL,
    school_year numeric NOT NULL,
    school_id numeric NOT NULL,
    title character varying(255),
    amount numeric,
    apply_all bpchar,
    classlevel_id numeric,
    course_id numeric,
    course_credit_title character varying(10),
    activity_id numeric,
    student_field_id numeric,
    student_field_value character varying(255),
    student_id numeric,
    waived_fee_id numeric
);


ALTER TABLE public.billing_student_fees_old OWNER TO postgres;

--
-- Name: billing_student_fees_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.billing_student_fees_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.billing_student_fees_seq OWNER TO postgres;

--
-- Name: billing_student_payments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.billing_student_payments (
    id numeric NOT NULL,
    school_year numeric NOT NULL,
    school_id numeric NOT NULL,
    student_id numeric NOT NULL,
    amount numeric NOT NULL,
    payment_date date,
    comments character varying(255),
    refunded_payment_id numeric,
    lunch_payment character varying(1),
    transaction_id numeric,
    cancellation double precision
);


ALTER TABLE public.billing_student_payments OWNER TO postgres;

--
-- Name: billing_student_payments_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.billing_student_payments_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.billing_student_payments_seq OWNER TO postgres;

--
-- Name: block_ip_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.block_ip_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.block_ip_seq OWNER TO postgres;

--
-- Name: block_ip; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.block_ip (
    id numeric DEFAULT nextval('public.block_ip_seq'::regclass) NOT NULL,
    faled_login numeric,
    time_unlock timestamp without time zone,
    ip character varying(15) NOT NULL,
    date date NOT NULL,
    failed_login numeric
);


ALTER TABLE public.block_ip OWNER TO postgres;

--
-- Name: calendars_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.calendars_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.calendars_seq OWNER TO postgres;

--
-- Name: config; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.config (
    title character varying(100),
    school_year numeric,
    login character varying(3),
    version character varying(10)
);


ALTER TABLE public.config OWNER TO postgres;

--
-- Name: course_credits; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.course_credits (
    school_year numeric,
    school_id numeric,
    course_id numeric NOT NULL,
    course_credit_title character varying(10) NOT NULL,
    gpa_multiplier numeric,
    rollover_id numeric,
    year_fraction numeric,
    credits numeric,
    student_requestable character varying(1) DEFAULT 'Y'::character varying,
    student_scheduleable character varying(1) DEFAULT 'Y'::character varying,
    cw_checkbox_setting_1 character varying(1) DEFAULT 'Y'::character varying,
    cw_checkbox_setting_2 character varying(1) DEFAULT 'Y'::character varying,
    cw_checkbox_setting_3 character varying(1) DEFAULT 'Y'::character varying,
    cw_checkbox_setting_4 character varying(1) DEFAULT 'Y'::character varying,
    cw_checkbox_setting_5 character varying(1) DEFAULT 'Y'::character varying,
    does_gpa_1 character varying(1) DEFAULT 'Y'::character varying,
    does_gpa_2 character varying(1) DEFAULT 'Y'::character varying,
    does_gpa_3 character varying(1) DEFAULT 'Y'::character varying,
    does_gpa_4 character varying(1) DEFAULT 'Y'::character varying,
    does_gpa_5 character varying(1) DEFAULT 'Y'::character varying
);


ALTER TABLE public.course_credits OWNER TO postgres;

--
-- Name: course_sections; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.course_sections (
    school_year numeric NOT NULL,
    school_id numeric NOT NULL,
    course_section_id numeric NOT NULL,
    course_id numeric NOT NULL,
    course_credit_title character varying(10) NOT NULL,
    title character varying(100),
    short_name character varying(25),
    school_period_id numeric,
    mp character varying(3),
    school_term_id numeric,
    teacher_id numeric,
    room character varying(10),
    total_seats numeric,
    filled_seats numeric,
    does_attendance character varying(1),
    does_grades character varying(1),
    does_gpa character varying(1),
    gender_restriction character varying(1),
    house_restriction character varying(1),
    credits character varying(4),
    availability numeric,
    rollover_id numeric,
    parent_id numeric,
    days character varying(20),
    calendar_id numeric,
    grade_type_id numeric,
    does_gpa_1 character varying(1),
    does_gpa_2 character varying(1),
    does_gpa_3 character varying(1),
    does_gpa_4 character varying(1),
    does_gpa_5 character varying(1),
    cp_checkbox_setting_1 character varying(1),
    cp_checkbox_setting_2 character varying(1),
    cp_checkbox_setting_3 character varying(1),
    cp_checkbox_setting_4 character varying(1),
    cfield_1 character varying(255),
    cfield_2 character varying(255),
    cfield_3 character varying(255),
    cfield_4 character varying(255),
    cfield_5 character varying(255),
    cfield_6 character varying(255),
    cfield_25 character varying(255),
    co_teacher_id1 numeric,
    co_teacher_id2 numeric,
    co_teacher_id3 numeric,
    co_teacher_id4 numeric,
    co_teacher_id5 numeric,
    co_teacher_id6 numeric,
    co_teacher_id7 numeric,
    co_teacher_id8 numeric,
    co_teacher_id9 numeric,
    co_teacher_id10 numeric,
    co_teacher1_custom1 character varying(255),
    co_teacher2_custom1 character varying(255),
    co_teacher3_custom1 character varying(255),
    co_teacher4_custom1 character varying(255),
    co_teacher5_custom1 character varying(255),
    co_teacher6_custom1 character varying(255),
    co_teacher7_custom1 character varying(255),
    co_teacher8_custom1 character varying(255),
    co_teacher9_custom1 character varying(255),
    co_teacher10_custom1 character varying(255),
    co_teacher1_custom2 character varying(255),
    co_teacher2_custom2 character varying(255),
    co_teacher3_custom2 character varying(255),
    co_teacher4_custom2 character varying(255),
    co_teacher5_custom2 character varying(255),
    co_teacher6_custom2 character varying(255),
    co_teacher7_custom2 character varying(255),
    co_teacher8_custom2 character varying(255),
    co_teacher9_custom2 character varying(255),
    co_teacher10_custom2 character varying(255),
    co_teacher1_checkbox1 character varying(1),
    co_teacher2_checkbox1 character varying(1),
    co_teacher3_checkbox1 character varying(1),
    co_teacher4_checkbox1 character varying(1),
    co_teacher5_checkbox1 character varying(1),
    co_teacher6_checkbox1 character varying(1),
    co_teacher7_checkbox1 character varying(1),
    co_teacher8_checkbox1 character varying(1),
    co_teacher9_checkbox1 character varying(1),
    co_teacher10_checkbox1 character varying(1),
    cp_checkbox_setting_6 character varying(1),
    cp_checkbox_setting_7 character varying(1),
    cp_checkbox_setting_8 character varying(1),
    co_teacher1_permissions character varying(1),
    co_teacher2_permissions character varying(1),
    co_teacher3_permissions character varying(1),
    co_teacher4_permissions character varying(1),
    co_teacher5_permissions character varying(1),
    co_teacher6_permissions character varying(1),
    co_teacher7_permissions character varying(1),
    co_teacher8_permissions character varying(1),
    co_teacher9_permissions character varying(1),
    co_teacher10_permissions character varying(1),
    co_teacher1_report_doe character varying(1),
    co_teacher2_report_doe character varying(1),
    co_teacher3_report_doe character varying(1),
    co_teacher4_report_doe character varying(1),
    co_teacher5_report_doe character varying(1),
    co_teacher6_report_doe character varying(1),
    co_teacher7_report_doe character varying(1),
    co_teacher8_report_doe character varying(1),
    co_teacher9_report_doe character varying(1),
    co_teacher10_report_doe character varying(1),
    merge_id character varying(1000),
    week character varying(1)
);


ALTER TABLE public.course_sections OWNER TO postgres;

--
-- Name: course_sections_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.course_sections_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.course_sections_seq OWNER TO postgres;

--
-- Name: course_subjects; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.course_subjects (
    school_year numeric,
    school_id numeric,
    subject_id numeric NOT NULL,
    title character varying(100),
    short_name character varying(25),
    rollover_id numeric
);


ALTER TABLE public.course_subjects OWNER TO postgres;

--
-- Name: course_subjects_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.course_subjects_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.course_subjects_seq OWNER TO postgres;

--
-- Name: courses; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.courses (
    school_year numeric NOT NULL,
    course_id numeric NOT NULL,
    subject_id numeric NOT NULL,
    school_id numeric NOT NULL,
    grade_level numeric,
    title character varying(100),
    short_name character varying(25),
    rollover_id numeric,
    grad_subject_id numeric,
    prerequisites character varying(255),
    cfield_1 character varying(255),
    cfield_2 character varying(255),
    mp character varying(10),
    comments character varying(255)
);


ALTER TABLE public.courses OWNER TO postgres;

--
-- Name: courses_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.courses_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.courses_seq OWNER TO postgres;

--
-- Name: delivery_group_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.delivery_group_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.delivery_group_seq OWNER TO postgres;

--
-- Name: delivery_group; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.delivery_group (
    id numeric DEFAULT nextval('public.delivery_group_seq'::regclass) NOT NULL,
    title character varying(255),
    short_name character varying(20),
    sort_order numeric,
    user_id numeric,
    shared character varying(1)
);


ALTER TABLE public.delivery_group OWNER TO postgres;

--
-- Name: discipline_custom_fields_asg; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.discipline_custom_fields_asg (
    id numeric NOT NULL,
    discipline_field_id numeric NOT NULL,
    school_year numeric NOT NULL,
    school_id numeric NOT NULL,
    title character varying(255),
    select_options character varying(10000),
    sort_order numeric,
    select_codes character varying(10000),
    user_type character varying(10)
);


ALTER TABLE public.discipline_custom_fields_asg OWNER TO postgres;

--
-- Name: discipline_custom_fields_asg_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.discipline_custom_fields_asg_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.discipline_custom_fields_asg_seq OWNER TO postgres;

--
-- Name: discipline_incident_categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.discipline_incident_categories (
    id numeric NOT NULL,
    title character varying(100),
    allow_teacher_modify character varying(1),
    sort_order numeric,
    columns numeric
);


ALTER TABLE public.discipline_incident_categories OWNER TO postgres;

--
-- Name: discipline_incident_categories_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.discipline_incident_categories_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.discipline_incident_categories_seq OWNER TO postgres;

--
-- Name: discipline_incident_fields; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.discipline_incident_fields (
    id numeric NOT NULL,
    type character varying(10),
    search character varying(1),
    select_options character varying(10000),
    category_id numeric,
    system_field character(1),
    default_selection character varying(255),
    required character(1),
    max_length numeric,
    sort_order numeric,
    select_option_codes character varying(10000),
    select_option_default_code character varying(255),
    application character varying(1),
    title character varying(100),
    field_edits text,
    size numeric
);


ALTER TABLE public.discipline_incident_fields OWNER TO postgres;

--
-- Name: discipline_incidents_asg_reports; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.discipline_incidents_asg_reports (
    incident_id numeric,
    referral_id numeric
);


ALTER TABLE public.discipline_incidents_asg_reports OWNER TO postgres;

--
-- Name: discipline_incidents_fields_in_cats; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.discipline_incidents_fields_in_cats (
    field_id integer NOT NULL,
    category_id integer NOT NULL,
    sort_order integer NOT NULL
);


ALTER TABLE public.discipline_incidents_fields_in_cats OWNER TO postgres;

--
-- Name: discipline_report_fields; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.discipline_report_fields (
    id numeric NOT NULL,
    title character varying(255) NOT NULL,
    short_name character varying(20),
    data_type character varying(30) NOT NULL,
    column_name character varying(255) NOT NULL,
    user_type character varying(10)
);


ALTER TABLE public.discipline_report_fields OWNER TO postgres;

--
-- Name: discipline_report_fields_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.discipline_report_fields_seq
    START WITH 10
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.discipline_report_fields_seq OWNER TO postgres;

--
-- Name: docs_template_cells; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.docs_template_cells (
    id numeric,
    template_id numeric,
    type character varying(6),
    style character varying(10),
    border character varying(1),
    sort_order numeric,
    user_id numeric,
    servicemod character varying(255),
    left_cell character varying(10000),
    middle_cell character varying(10000),
    right_cell character varying(10000)
);


ALTER TABLE public.docs_template_cells OWNER TO postgres;

--
-- Name: docs_template_cells_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.docs_template_cells_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.docs_template_cells_seq OWNER TO postgres;

--
-- Name: docs_templates; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.docs_templates (
    id numeric NOT NULL,
    title character varying(255),
    sort_order numeric,
    school_id numeric,
    header character varying(20000),
    footer character varying(20000),
    default_sm character varying(255),
    default_users_sm character varying(255),
    orientation character varying(10),
    short_name character varying(100),
    user_id numeric,
    document_category_id numeric,
    doc_type character varying(15),
    use_inquiry character varying(1),
    servicemod character varying(255),
    page_breaks character varying(10),
    schools character varying(255),
    use_students character varying(1),
    school_dep character varying(1),
    school_year_dep character varying(1)
);


ALTER TABLE public.docs_templates OWNER TO postgres;

--
-- Name: docs_templates_categories_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.docs_templates_categories_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.docs_templates_categories_seq OWNER TO postgres;

--
-- Name: docs_templates_categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.docs_templates_categories (
    id numeric DEFAULT nextval('public.docs_templates_categories_seq'::regclass) NOT NULL,
    school_id numeric,
    title character varying(100),
    servicemod character varying(255),
    user_id numeric,
    short_name character varying(20),
    sort_order numeric,
    schools character varying(255)
);


ALTER TABLE public.docs_templates_categories OWNER TO postgres;

--
-- Name: docs_templates_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.docs_templates_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.docs_templates_seq OWNER TO postgres;

--
-- Name: evaluation_markpoints; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.evaluation_markpoints (
    school_year numeric(4,0),
    student_id numeric,
    score_id numeric,
    type character varying(9),
    score numeric
);


ALTER TABLE public.evaluation_markpoints OWNER TO postgres;

--
-- Name: evaluation_testparts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.evaluation_testparts (
    id numeric,
    school_year numeric(4,0),
    exam_id numeric,
    title character varying(100),
    short_name character varying(25),
    max_score numeric
);


ALTER TABLE public.evaluation_testparts OWNER TO postgres;

--
-- Name: evaluation_testparts_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.evaluation_testparts_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.evaluation_testparts_seq OWNER TO postgres;

--
-- Name: evaluation_tests; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.evaluation_tests (
    id numeric,
    school_year numeric(4,0),
    title character varying(100),
    short_name character varying(25),
    max_score numeric
);


ALTER TABLE public.evaluation_tests OWNER TO postgres;

--
-- Name: evaluation_tests_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.evaluation_tests_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.evaluation_tests_seq OWNER TO postgres;

--
-- Name: form2; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.form2 (
    id numeric NOT NULL,
    url character varying(100) NOT NULL,
    token character varying(100) NOT NULL,
    name character varying(100) NOT NULL
);


ALTER TABLE public.form2 OWNER TO postgres;

--
-- Name: form_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.form_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.form_seq OWNER TO postgres;

--
-- Name: grades_card_comments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.grades_card_comments (
    id numeric NOT NULL,
    school_year numeric,
    school_id numeric,
    title character varying(100),
    sort_order numeric
);


ALTER TABLE public.grades_card_comments OWNER TO postgres;

--
-- Name: grades_card_comments_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.grades_card_comments_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.grades_card_comments_seq OWNER TO postgres;

--
-- Name: grades_card_evaluation; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.grades_card_evaluation (
    id numeric NOT NULL,
    school_year numeric NOT NULL,
    school_id numeric,
    subject_id numeric,
    course_id numeric,
    course_credit_title character varying(10),
    sort_order numeric,
    standard_id numeric,
    subtitle character varying(255),
    title character varying(255)
);


ALTER TABLE public.grades_card_evaluation OWNER TO postgres;

--
-- Name: grades_card_evaluation_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.grades_card_evaluation_seq
    START WITH 4
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.grades_card_evaluation_seq OWNER TO postgres;

--
-- Name: grades_card_settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.grades_card_settings (
    id numeric NOT NULL,
    school_year numeric,
    school_id numeric,
    title character varying(3),
    sort_order numeric,
    gpa_value numeric,
    default_breakoff numeric,
    scale_id numeric,
    credits character varying(1),
    weighted_gpa_value numeric,
    description character varying(100)
);


ALTER TABLE public.grades_card_settings OWNER TO postgres;

--
-- Name: grades_card_settings_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.grades_card_settings_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.grades_card_settings_seq OWNER TO postgres;

--
-- Name: grades_card_tests; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.grades_card_tests (
    id numeric,
    school_year numeric NOT NULL,
    school_id numeric,
    subject_id numeric,
    course_id numeric,
    course_credit_title character varying(10),
    title character varying(100),
    sort_order numeric,
    grading_scale_id numeric,
    rollover_id numeric,
    subtitle character varying(255)
);


ALTER TABLE public.grades_card_tests OWNER TO postgres;

--
-- Name: grades_card_tests_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.grades_card_tests_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.grades_card_tests_seq OWNER TO postgres;

--
-- Name: grades_card_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.grades_card_types (
    id numeric NOT NULL,
    school_year numeric,
    school_id numeric,
    title character varying(30),
    default_scale character varying(1),
    rollover_id numeric
);


ALTER TABLE public.grades_card_types OWNER TO postgres;

--
-- Name: grades_card_types_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.grades_card_types_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.grades_card_types_seq OWNER TO postgres;

--
-- Name: graduation_req_subjects; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.graduation_req_subjects (
    id numeric NOT NULL,
    school_id numeric,
    title character varying(100),
    sort_order numeric,
    credits numeric,
    short_name character varying(10)
);


ALTER TABLE public.graduation_req_subjects OWNER TO postgres;

--
-- Name: graduation_req_subjects_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.graduation_req_subjects_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.graduation_req_subjects_seq OWNER TO postgres;

--
-- Name: graduation_requirements; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.graduation_requirements (
    id numeric,
    title character varying(100),
    short_name character varying(25)
);


ALTER TABLE public.graduation_requirements OWNER TO postgres;

--
-- Name: graduation_rp_in_course_req; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.graduation_rp_in_course_req (
    program_id numeric,
    recomended_gradelevel character varying(2),
    title character varying(100),
    number_required numeric,
    courses text
);


ALTER TABLE public.graduation_rp_in_course_req OWNER TO postgres;

--
-- Name: graduation_rp_in_subjects; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.graduation_rp_in_subjects (
    program_id numeric,
    subject_id numeric,
    credits numeric
);


ALTER TABLE public.graduation_rp_in_subjects OWNER TO postgres;

--
-- Name: in_outbox_message_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.in_outbox_message_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.in_outbox_message_seq OWNER TO postgres;

--
-- Name: in_inbox_message; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.in_inbox_message (
    id numeric DEFAULT nextval('public.in_outbox_message_seq'::regclass) NOT NULL,
    from_user numeric NOT NULL,
    to_user numeric NOT NULL,
    title character varying(200) NOT NULL,
    msg text NOT NULL,
    date date NOT NULL,
    status numeric NOT NULL,
    to_user_profile character varying(50),
    from_user_profile character varying(50)
);


ALTER TABLE public.in_inbox_message OWNER TO postgres;

--
-- Name: in_inbox_message_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.in_inbox_message_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.in_inbox_message_seq OWNER TO postgres;

--
-- Name: in_outbox_message; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.in_outbox_message (
    id numeric DEFAULT nextval('public.in_outbox_message_seq'::regclass) NOT NULL,
    from_user numeric NOT NULL,
    to_users character varying(1000) NOT NULL,
    title character varying(200) NOT NULL,
    msg text NOT NULL,
    date date NOT NULL,
    to_user_profile character varying(50),
    from_user_profile character varying(50)
);


ALTER TABLE public.in_outbox_message OWNER TO postgres;

--
-- Name: info_saves; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.info_saves (
    id numeric,
    title character varying(100),
    url character varying(5000)
);


ALTER TABLE public.info_saves OWNER TO postgres;

--
-- Name: info_saves_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.info_saves_seq
    START WITH 5
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.info_saves_seq OWNER TO postgres;

--
-- Name: intermediate_report; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.intermediate_report (
    id numeric NOT NULL,
    title character varying(255),
    short_name character varying(40),
    gpavalue double precision,
    school_id numeric
);


ALTER TABLE public.intermediate_report OWNER TO postgres;

--
-- Name: lh_template_cells; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.lh_template_cells (
    id numeric,
    template_id numeric,
    type character varying(6),
    style character varying(10),
    border character varying(1),
    sort_order numeric,
    left_cell character varying(10000),
    middle_cell character varying(10000),
    right_cell character varying(10000)
);


ALTER TABLE public.lh_template_cells OWNER TO postgres;

--
-- Name: lh_template_cells_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.lh_template_cells_seq
    START WITH 13
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.lh_template_cells_seq OWNER TO postgres;

--
-- Name: lh_templates; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.lh_templates (
    id numeric NOT NULL,
    title character varying(255),
    sort_order numeric,
    school_id numeric,
    header character varying(20000),
    footer character varying(20000),
    default_program character varying(255),
    default_program_for_teachers character varying(255),
    orientation character varying(10),
    page_breaks character varying(10)
);


ALTER TABLE public.lh_templates OWNER TO postgres;

--
-- Name: lh_templates_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.lh_templates_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.lh_templates_seq OWNER TO postgres;

--
-- Name: listing_fields_settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.listing_fields_settings (
    student_id numeric NOT NULL,
    html_field_title character varying(15),
    field_name character varying(15),
    select_options text,
    select_codes text
);


ALTER TABLE public.listing_fields_settings OWNER TO postgres;

--
-- Name: login_history_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.login_history_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.login_history_seq OWNER TO postgres;

--
-- Name: login_history; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.login_history (
    id numeric DEFAULT nextval('public.login_history_seq'::regclass) NOT NULL,
    log_text character varying(1000),
    ip character varying(15),
    sucsess character varying(30),
    ldata timestamp without time zone NOT NULL,
    user_id numeric,
    request_method character varying(100),
    http_user_agent character varying(500),
    query_string character varying(1000),
    login character varying(100),
    profile character varying(30)
);


ALTER TABLE public.login_history OWNER TO postgres;

--
-- Name: lunch_period; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.lunch_period (
    student_id numeric,
    school_date date,
    school_period_id numeric,
    attendance_code numeric,
    attendance_teacher_code numeric,
    attendance_reason character varying(100),
    admin character varying(1),
    course_section_id numeric,
    school_term_id numeric,
    table_name numeric
);


ALTER TABLE public.lunch_period OWNER TO postgres;

--
-- Name: mailing_of_group_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mailing_of_group_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mailing_of_group_seq OWNER TO postgres;

--
-- Name: mailing_of_group; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mailing_of_group (
    id numeric DEFAULT nextval('public.mailing_of_group_seq'::regclass) NOT NULL,
    title character varying(200) NOT NULL,
    sort numeric,
    user_id numeric NOT NULL
);


ALTER TABLE public.mailing_of_group OWNER TO postgres;

--
-- Name: markbook_assignment_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.markbook_assignment_types (
    assignment_type_id numeric NOT NULL,
    user_id numeric,
    course_id numeric,
    title character varying(100),
    final_grade_percent numeric,
    hcolor character varying(6)
);


ALTER TABLE public.markbook_assignment_types OWNER TO postgres;

--
-- Name: markbook_assignment_types_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.markbook_assignment_types_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.markbook_assignment_types_seq OWNER TO postgres;

--
-- Name: markbook_assignments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.markbook_assignments (
    assignment_id numeric NOT NULL,
    user_id numeric,
    school_term_id numeric,
    course_section_id numeric,
    course_id numeric,
    assignment_type_id numeric,
    title character varying(100),
    assigned_date date,
    due_date date,
    points numeric,
    description character varying(1000),
    benchmarks character varying(100)
);


ALTER TABLE public.markbook_assignments OWNER TO postgres;

--
-- Name: markbook_assignments_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.markbook_assignments_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.markbook_assignments_seq OWNER TO postgres;

--
-- Name: markbook_teachers_filled; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.markbook_teachers_filled (
    user_id numeric NOT NULL,
    school_period_id numeric,
    school_term_id character varying(10),
    course_section_id numeric
);


ALTER TABLE public.markbook_teachers_filled OWNER TO postgres;

--
-- Name: mdl_assignment_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assignment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assignment_id_seq OWNER TO postgres;

--
-- Name: mdl_assignment_submissions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_assignment_submissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_assignment_submissions_id_seq OWNER TO postgres;

--
-- Name: mdl_backup_config_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_backup_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_backup_config_id_seq OWNER TO postgres;

--
-- Name: mdl_backup_courses_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_backup_courses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_backup_courses_id_seq OWNER TO postgres;

--
-- Name: mdl_backup_files_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_backup_files_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_backup_files_id_seq OWNER TO postgres;

--
-- Name: mdl_backup_ids_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_backup_ids_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_backup_ids_id_seq OWNER TO postgres;

--
-- Name: mdl_backup_log_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_backup_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_backup_log_id_seq OWNER TO postgres;

--
-- Name: mdl_block_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_block_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_block_id_seq OWNER TO postgres;

--
-- Name: mdl_block_instance_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_block_instance_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_block_instance_id_seq OWNER TO postgres;

--
-- Name: mdl_block_pinned_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_block_pinned_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_block_pinned_id_seq OWNER TO postgres;

--
-- Name: mdl_block_rss_client_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_block_rss_client_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_block_rss_client_id_seq OWNER TO postgres;

--
-- Name: mdl_block_search_documents_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_block_search_documents_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_block_search_documents_id_seq OWNER TO postgres;

--
-- Name: mdl_cache_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_cache_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_cache_filters_id_seq OWNER TO postgres;

--
-- Name: mdl_cache_flags_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_cache_flags_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_cache_flags_id_seq OWNER TO postgres;

--
-- Name: mdl_cache_text_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_cache_text_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_cache_text_id_seq OWNER TO postgres;

--
-- Name: mdl_capabilities_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_capabilities_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_capabilities_id_seq OWNER TO postgres;

--
-- Name: mdl_chat_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_chat_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_chat_id_seq OWNER TO postgres;

--
-- Name: mdl_chat_messages_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_chat_messages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_chat_messages_id_seq OWNER TO postgres;

--
-- Name: mdl_chat_users_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_chat_users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_chat_users_id_seq OWNER TO postgres;

--
-- Name: mdl_choice_answers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_choice_answers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_choice_answers_id_seq OWNER TO postgres;

--
-- Name: mdl_choice_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_choice_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_choice_id_seq OWNER TO postgres;

--
-- Name: mdl_choice_options_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_choice_options_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_choice_options_id_seq OWNER TO postgres;

--
-- Name: mdl_config_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_config_id_seq OWNER TO postgres;

--
-- Name: mdl_config_plugins_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_config_plugins_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_config_plugins_id_seq OWNER TO postgres;

--
-- Name: mdl_context_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_context_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_context_id_seq OWNER TO postgres;

--
-- Name: mdl_course_allowed_modules_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_allowed_modules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_allowed_modules_id_seq OWNER TO postgres;

--
-- Name: mdl_course_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_categories_id_seq OWNER TO postgres;

--
-- Name: mdl_course_display_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_display_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_display_id_seq OWNER TO postgres;

--
-- Name: mdl_course_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_id_seq OWNER TO postgres;

--
-- Name: mdl_course_meta_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_meta_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_meta_id_seq OWNER TO postgres;

--
-- Name: mdl_course_modules_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_modules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_modules_id_seq OWNER TO postgres;

--
-- Name: mdl_course_request_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_request_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_request_id_seq OWNER TO postgres;

--
-- Name: mdl_course_sections_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_course_sections_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_course_sections_id_seq OWNER TO postgres;

--
-- Name: mdl_data_comments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_data_comments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_data_comments_id_seq OWNER TO postgres;

--
-- Name: mdl_data_content_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_data_content_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_data_content_id_seq OWNER TO postgres;

--
-- Name: mdl_data_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_data_fields_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_data_fields_id_seq OWNER TO postgres;

--
-- Name: mdl_data_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_data_id_seq OWNER TO postgres;

--
-- Name: mdl_data_ratings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_data_ratings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_data_ratings_id_seq OWNER TO postgres;

--
-- Name: mdl_data_records_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_data_records_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_data_records_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_authorize_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_authorize_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_authorize_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_authorize_refunds_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_authorize_refunds_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_authorize_refunds_id_seq OWNER TO postgres;

--
-- Name: mdl_enrol_paypal_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_enrol_paypal_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_enrol_paypal_id_seq OWNER TO postgres;

--
-- Name: mdl_event_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_event_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_event_id_seq OWNER TO postgres;

--
-- Name: mdl_events_handlers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_events_handlers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_events_handlers_id_seq OWNER TO postgres;

--
-- Name: mdl_events_queue_handlers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_events_queue_handlers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_events_queue_handlers_id_seq OWNER TO postgres;

--
-- Name: mdl_events_queue_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_events_queue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_events_queue_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_discussions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_discussions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_discussions_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_posts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_posts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_posts_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_queue_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_queue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_queue_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_ratings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_ratings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_ratings_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_read_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_read_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_read_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_subscriptions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_subscriptions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_subscriptions_id_seq OWNER TO postgres;

--
-- Name: mdl_forum_track_prefs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_forum_track_prefs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_forum_track_prefs_id_seq OWNER TO postgres;

--
-- Name: mdl_glossary_alias_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_glossary_alias_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_glossary_alias_id_seq OWNER TO postgres;

--
-- Name: mdl_glossary_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_glossary_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_glossary_categories_id_seq OWNER TO postgres;

--
-- Name: mdl_glossary_comments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_glossary_comments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_glossary_comments_id_seq OWNER TO postgres;

--
-- Name: mdl_glossary_entries_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_glossary_entries_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_glossary_entries_categories_id_seq OWNER TO postgres;

--
-- Name: mdl_glossary_entries_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_glossary_entries_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_glossary_entries_id_seq OWNER TO postgres;

--
-- Name: mdl_glossary_formats_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_glossary_formats_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_glossary_formats_id_seq OWNER TO postgres;

--
-- Name: mdl_glossary_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_glossary_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_glossary_id_seq OWNER TO postgres;

--
-- Name: mdl_glossary_ratings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_glossary_ratings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_glossary_ratings_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_categories_history_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_categories_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_categories_history_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_categories_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_grades_history_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_grades_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_grades_history_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_grades_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_grades_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_grades_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_import_newitem_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_import_newitem_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_import_newitem_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_import_values_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_import_values_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_import_values_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_items_history_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_items_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_items_history_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_items_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_items_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_items_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_letters_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_letters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_letters_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_outcomes_courses_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_outcomes_courses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_outcomes_courses_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_outcomes_history_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_outcomes_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_outcomes_history_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_outcomes_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_outcomes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_outcomes_id_seq OWNER TO postgres;

--
-- Name: mdl_grade_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_grade_settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_grade_settings_id_seq OWNER TO postgres;

--
-- Name: mdl_groupings_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_groupings_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_groupings_groups_id_seq OWNER TO postgres;

--
-- Name: mdl_groupings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_groupings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_groupings_id_seq OWNER TO postgres;

--
-- Name: mdl_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_groups_id_seq OWNER TO postgres;

--
-- Name: mdl_groups_members_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_groups_members_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_groups_members_id_seq OWNER TO postgres;

--
-- Name: mdl_hotpot_attempts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_hotpot_attempts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_hotpot_attempts_id_seq OWNER TO postgres;

--
-- Name: mdl_hotpot_details_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_hotpot_details_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_hotpot_details_id_seq OWNER TO postgres;

--
-- Name: mdl_hotpot_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_hotpot_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_hotpot_id_seq OWNER TO postgres;

--
-- Name: mdl_hotpot_questions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_hotpot_questions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_hotpot_questions_id_seq OWNER TO postgres;

--
-- Name: mdl_hotpot_responses_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_hotpot_responses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_hotpot_responses_id_seq OWNER TO postgres;

--
-- Name: mdl_hotpot_strings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_hotpot_strings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_hotpot_strings_id_seq OWNER TO postgres;

--
-- Name: mdl_journal_entries_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_journal_entries_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_journal_entries_id_seq OWNER TO postgres;

--
-- Name: mdl_journal_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_journal_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_journal_id_seq OWNER TO postgres;

--
-- Name: mdl_label_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_label_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_label_id_seq OWNER TO postgres;

--
-- Name: mdl_lams_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lams_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lams_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_answers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_answers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_answers_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_attempts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_attempts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_attempts_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_branch_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_branch_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_branch_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_default_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_default_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_default_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_grades_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_grades_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_grades_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_high_scores_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_high_scores_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_high_scores_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_pages_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_pages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_pages_id_seq OWNER TO postgres;

--
-- Name: mdl_lesson_timer_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_lesson_timer_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_lesson_timer_id_seq OWNER TO postgres;

--
-- Name: mdl_log_display_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_log_display_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_log_display_id_seq OWNER TO postgres;

--
-- Name: mdl_log_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_log_id_seq OWNER TO postgres;

--
-- Name: mdl_message_contacts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_contacts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_contacts_id_seq OWNER TO postgres;

--
-- Name: mdl_message_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_id_seq OWNER TO postgres;

--
-- Name: mdl_message_read_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_message_read_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_message_read_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_application_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_application_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_application_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_enrol_assignments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_enrol_assignments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_enrol_assignments_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_enrol_course_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_enrol_course_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_enrol_course_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_host2service_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_host2service_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_host2service_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_host_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_host_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_host_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_log_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_log_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_rpc_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_rpc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_rpc_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_service2rpc_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_service2rpc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_service2rpc_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_service_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_service_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_service_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_session_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_session_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_session_id_seq OWNER TO postgres;

--
-- Name: mdl_mnet_sso_access_control_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_mnet_sso_access_control_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_mnet_sso_access_control_id_seq OWNER TO postgres;

--
-- Name: mdl_modules_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_modules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_modules_id_seq OWNER TO postgres;

--
-- Name: mdl_post_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_post_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_post_id_seq OWNER TO postgres;

--
-- Name: mdl_question_answers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_answers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_answers_id_seq OWNER TO postgres;

--
-- Name: mdl_question_attempts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_attempts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_attempts_id_seq OWNER TO postgres;

--
-- Name: mdl_question_calculated_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_calculated_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_calculated_id_seq OWNER TO postgres;

--
-- Name: mdl_question_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_categories_id_seq OWNER TO postgres;

--
-- Name: mdl_question_dataset_definitions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_dataset_definitions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_dataset_definitions_id_seq OWNER TO postgres;

--
-- Name: mdl_question_dataset_items_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_dataset_items_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_dataset_items_id_seq OWNER TO postgres;

--
-- Name: mdl_question_datasets_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_datasets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_datasets_id_seq OWNER TO postgres;

--
-- Name: mdl_question_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_id_seq OWNER TO postgres;

--
-- Name: mdl_question_match_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_match_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_match_id_seq OWNER TO postgres;

--
-- Name: mdl_question_match_sub_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_match_sub_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_match_sub_id_seq OWNER TO postgres;

--
-- Name: mdl_question_multianswer_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_multianswer_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_multianswer_id_seq OWNER TO postgres;

--
-- Name: mdl_question_multichoice_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_multichoice_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_multichoice_id_seq OWNER TO postgres;

--
-- Name: mdl_question_numerical_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_numerical_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_numerical_id_seq OWNER TO postgres;

--
-- Name: mdl_question_numerical_units_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_numerical_units_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_numerical_units_id_seq OWNER TO postgres;

--
-- Name: mdl_question_randomsamatch_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_randomsamatch_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_randomsamatch_id_seq OWNER TO postgres;

--
-- Name: mdl_question_sessions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_sessions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_sessions_id_seq OWNER TO postgres;

--
-- Name: mdl_question_shortanswer_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_shortanswer_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_shortanswer_id_seq OWNER TO postgres;

--
-- Name: mdl_question_states_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_states_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_states_id_seq OWNER TO postgres;

--
-- Name: mdl_question_truefalse_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_question_truefalse_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_question_truefalse_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_attempts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_attempts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_attempts_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_feedback_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_feedback_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_feedback_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_grades_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_grades_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_grades_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_question_instances_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_question_instances_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_question_instances_id_seq OWNER TO postgres;

--
-- Name: mdl_quiz_question_versions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_quiz_question_versions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_quiz_question_versions_id_seq OWNER TO postgres;

--
-- Name: mdl_resource_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_resource_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_resource_id_seq OWNER TO postgres;

--
-- Name: mdl_role_allow_assign_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_allow_assign_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_allow_assign_id_seq OWNER TO postgres;

--
-- Name: mdl_role_allow_override_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_allow_override_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_allow_override_id_seq OWNER TO postgres;

--
-- Name: mdl_role_assignments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_assignments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_assignments_id_seq OWNER TO postgres;

--
-- Name: mdl_role_capabilities_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_capabilities_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_capabilities_id_seq OWNER TO postgres;

--
-- Name: mdl_role_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_id_seq OWNER TO postgres;

--
-- Name: mdl_role_names_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_names_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_names_id_seq OWNER TO postgres;

--
-- Name: mdl_role_sortorder_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_role_sortorder_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_role_sortorder_id_seq OWNER TO postgres;

--
-- Name: mdl_scale_history_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scale_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scale_history_id_seq OWNER TO postgres;

--
-- Name: mdl_scale_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scale_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scale_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_scoes_data_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_scoes_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_scoes_data_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_scoes_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_scoes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_scoes_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_scoes_track_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_scoes_track_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_scoes_track_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_seq_mapinfo_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_seq_mapinfo_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_seq_mapinfo_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_seq_objective_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_seq_objective_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_seq_objective_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_seq_rolluprule_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_seq_rolluprule_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_seq_rolluprule_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_seq_rolluprulecond_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_seq_rolluprulecond_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_seq_rolluprulecond_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_seq_rulecond_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_seq_rulecond_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_seq_rulecond_id_seq OWNER TO postgres;

--
-- Name: mdl_scorm_seq_ruleconds_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_scorm_seq_ruleconds_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_scorm_seq_ruleconds_id_seq OWNER TO postgres;

--
-- Name: mdl_stats_daily_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_stats_daily_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_stats_daily_id_seq OWNER TO postgres;

--
-- Name: mdl_stats_monthly_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_stats_monthly_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_stats_monthly_id_seq OWNER TO postgres;

--
-- Name: mdl_stats_user_daily_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_stats_user_daily_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_stats_user_daily_id_seq OWNER TO postgres;

--
-- Name: mdl_stats_user_monthly_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_stats_user_monthly_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_stats_user_monthly_id_seq OWNER TO postgres;

--
-- Name: mdl_stats_user_weekly_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_stats_user_weekly_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_stats_user_weekly_id_seq OWNER TO postgres;

--
-- Name: mdl_stats_weekly_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_stats_weekly_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_stats_weekly_id_seq OWNER TO postgres;

--
-- Name: mdl_survey_analysis_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_survey_analysis_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_survey_analysis_id_seq OWNER TO postgres;

--
-- Name: mdl_survey_answers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_survey_answers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_survey_answers_id_seq OWNER TO postgres;

--
-- Name: mdl_survey_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_survey_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_survey_id_seq OWNER TO postgres;

--
-- Name: mdl_survey_questions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_survey_questions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_survey_questions_id_seq OWNER TO postgres;

--
-- Name: mdl_tag_correlation_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tag_correlation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tag_correlation_id_seq OWNER TO postgres;

--
-- Name: mdl_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tag_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tag_id_seq OWNER TO postgres;

--
-- Name: mdl_tag_instance_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_tag_instance_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_tag_instance_id_seq OWNER TO postgres;

--
-- Name: mdl_timezone_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_timezone_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_timezone_id_seq OWNER TO postgres;

--
-- Name: mdl_user_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_id_seq OWNER TO postgres;

--
-- Name: mdl_user_info_category_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_info_category_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_info_category_id_seq OWNER TO postgres;

--
-- Name: mdl_user_info_data_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_info_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_info_data_id_seq OWNER TO postgres;

--
-- Name: mdl_user_info_field_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_info_field_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_info_field_id_seq OWNER TO postgres;

--
-- Name: mdl_user_lastaccess_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_lastaccess_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_lastaccess_id_seq OWNER TO postgres;

--
-- Name: mdl_user_preferences_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_preferences_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_preferences_id_seq OWNER TO postgres;

--
-- Name: mdl_user_private_key_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_user_private_key_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_user_private_key_id_seq OWNER TO postgres;

--
-- Name: mdl_webdav_locks_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_webdav_locks_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_webdav_locks_id_seq OWNER TO postgres;

--
-- Name: mdl_wiki_entries_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_wiki_entries_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_wiki_entries_id_seq OWNER TO postgres;

--
-- Name: mdl_wiki_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_wiki_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_wiki_id_seq OWNER TO postgres;

--
-- Name: mdl_wiki_locks_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_wiki_locks_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_wiki_locks_id_seq OWNER TO postgres;

--
-- Name: mdl_wiki_pages_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_wiki_pages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_wiki_pages_id_seq OWNER TO postgres;

--
-- Name: mdl_workshop_assessments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshop_assessments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshop_assessments_id_seq OWNER TO postgres;

--
-- Name: mdl_workshop_comments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshop_comments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshop_comments_id_seq OWNER TO postgres;

--
-- Name: mdl_workshop_elements_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshop_elements_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshop_elements_id_seq OWNER TO postgres;

--
-- Name: mdl_workshop_grades_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshop_grades_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshop_grades_id_seq OWNER TO postgres;

--
-- Name: mdl_workshop_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshop_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshop_id_seq OWNER TO postgres;

--
-- Name: mdl_workshop_rubrics_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshop_rubrics_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshop_rubrics_id_seq OWNER TO postgres;

--
-- Name: mdl_workshop_stockcomments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshop_stockcomments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshop_stockcomments_id_seq OWNER TO postgres;

--
-- Name: mdl_workshop_submissions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdl_workshop_submissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mdl_workshop_submissions_id_seq OWNER TO postgres;

--
-- Name: orders; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.orders (
    id numeric,
    type character varying(50),
    external_id numeric,
    student_id character varying(20)
);


ALTER TABLE public.orders OWNER TO postgres;

--
-- Name: orders_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.orders_seq
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.orders_seq OWNER TO postgres;

--
-- Name: people_in_group_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.people_in_group_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.people_in_group_seq OWNER TO postgres;

--
-- Name: people_in_group; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.people_in_group (
    id numeric DEFAULT nextval('public.people_in_group_seq'::regclass) NOT NULL,
    id_group numeric NOT NULL,
    id_people numeric NOT NULL,
    fio_people character varying(200) NOT NULL,
    profile character varying(50) NOT NULL
);


ALTER TABLE public.people_in_group OWNER TO postgres;

--
-- Name: people_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.people_seq
    START WITH 1706
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.people_seq OWNER TO postgres;

--
-- Name: personal_in_mailgroup_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.personal_in_mailgroup_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.personal_in_mailgroup_seq OWNER TO postgres;

--
-- Name: personal_in_mailgroup; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.personal_in_mailgroup (
    id numeric DEFAULT nextval('public.personal_in_mailgroup_seq'::regclass) NOT NULL,
    group_id numeric NOT NULL,
    person_id numeric NOT NULL,
    person_fullname character varying(200) NOT NULL,
    profile character varying(50) NOT NULL,
    profile2 character varying(50) NOT NULL
);


ALTER TABLE public.personal_in_mailgroup OWNER TO postgres;

--
-- Name: portal_messages; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.portal_messages (
    id numeric,
    title character varying(255),
    content character varying(5000),
    sort_order numeric,
    published_user numeric,
    published_date date,
    start_date date,
    end_date date,
    published_profiles character varying(255),
    school_id numeric
);


ALTER TABLE public.portal_messages OWNER TO postgres;

--
-- Name: portal_messages_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.portal_messages_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.portal_messages_seq OWNER TO postgres;

--
-- Name: profile_settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.profile_settings (
    profile_id numeric,
    modname character varying(255),
    viewer character varying(1),
    editor character varying(1)
);


ALTER TABLE public.profile_settings OWNER TO postgres;

--
-- Name: program_uploaded_files; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.program_uploaded_files (
    id numeric,
    tablename character varying(255),
    table_id numeric,
    title character varying(255),
    location character varying(255),
    uploaded_date date,
    filesize character varying(10)
);


ALTER TABLE public.program_uploaded_files OWNER TO postgres;

--
-- Name: program_uploaded_files_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.program_uploaded_files_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.program_uploaded_files_seq OWNER TO postgres;

--
-- Name: resbase; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resbase (
    id numeric,
    school_id numeric,
    category_id numeric,
    title character varying(255),
    short_name character varying(20),
    type character varying(20),
    comments text,
    seats numeric
);


ALTER TABLE public.resbase OWNER TO postgres;

--
-- Name: resbase_categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resbase_categories (
    id numeric,
    school_id numeric,
    title character varying(100),
    sort_order numeric,
    profiles character varying(255)
);


ALTER TABLE public.resbase_categories OWNER TO postgres;

--
-- Name: resbase_categories_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resbase_categories_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resbase_categories_seq OWNER TO postgres;

--
-- Name: resbase_events; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resbase_events (
    id numeric,
    title character varying(100),
    description text,
    school_date date,
    start_time time without time zone,
    end_time time without time zone,
    user_id character varying(15),
    color character varying(7)
);


ALTER TABLE public.resbase_events OWNER TO postgres;

--
-- Name: resbase_events_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resbase_events_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resbase_events_seq OWNER TO postgres;

--
-- Name: resbase_in_events; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resbase_in_events (
    resource_id character varying(25),
    event_id numeric
);


ALTER TABLE public.resbase_in_events OWNER TO postgres;

--
-- Name: resbase_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resbase_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resbase_seq OWNER TO postgres;

--
-- Name: roundcube_cache_ids; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.roundcube_cache_ids
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.roundcube_cache_ids OWNER TO postgres;

--
-- Name: roundcube_contact_ids; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.roundcube_contact_ids
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.roundcube_contact_ids OWNER TO postgres;

--
-- Name: roundcube_identity_ids; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.roundcube_identity_ids
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.roundcube_identity_ids OWNER TO postgres;

--
-- Name: roundcube_message_ids; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.roundcube_message_ids
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.roundcube_message_ids OWNER TO postgres;

--
-- Name: roundcube_user_ids; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.roundcube_user_ids
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.roundcube_user_ids OWNER TO postgres;

--
-- Name: rss_conf_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.rss_conf_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rss_conf_seq OWNER TO postgres;

--
-- Name: rss_conf; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.rss_conf (
    id numeric DEFAULT nextval('public.rss_conf_seq'::regclass),
    title character varying(150),
    rss_url character varying(500),
    user_id character varying(500),
    used character varying(1)
);


ALTER TABLE public.rss_conf OWNER TO postgres;

--
-- Name: saved_info; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.saved_info (
    id numeric NOT NULL,
    title character varying(100),
    user_id numeric,
    php_self character varying(5000),
    search_php_self character varying(5000),
    search_vars character varying(5000),
    school_id numeric
);


ALTER TABLE public.saved_info OWNER TO postgres;

--
-- Name: saved_info_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.saved_info_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.saved_info_seq OWNER TO postgres;

--
-- Name: school_calendar_days; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_calendar_days (
    school_year numeric NOT NULL,
    school_id numeric NOT NULL,
    school_date date NOT NULL,
    minutes numeric,
    block character varying(10),
    calendar_id numeric NOT NULL
);


ALTER TABLE public.school_calendar_days OWNER TO postgres;

--
-- Name: school_calendar_events; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_calendar_events (
    id numeric NOT NULL,
    school_year numeric,
    school_id numeric,
    school_date date,
    title character varying(50),
    description text
);


ALTER TABLE public.school_calendar_events OWNER TO postgres;

--
-- Name: school_calendar_events_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.school_calendar_events_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.school_calendar_events_seq OWNER TO postgres;

--
-- Name: school_calendars; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_calendars (
    school_id numeric,
    title character varying(100),
    school_year numeric,
    calendar_id numeric NOT NULL,
    default_calendar character varying(1),
    rollover_id numeric
);


ALTER TABLE public.school_calendars OWNER TO postgres;

--
-- Name: school_classlevels; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_classlevels (
    id numeric NOT NULL,
    school_id numeric,
    title character varying(50),
    next_classlevel_id numeric,
    sort_order numeric,
    short_name character varying(4)
);


ALTER TABLE public.school_classlevels OWNER TO postgres;

--
-- Name: school_classlevels_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.school_classlevels_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.school_classlevels_seq OWNER TO postgres;

--
-- Name: school_field_categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_field_categories (
    id numeric NOT NULL,
    title character varying(100),
    allow_teacher_modify character varying(1),
    sort_order numeric,
    columns numeric
);


ALTER TABLE public.school_field_categories OWNER TO postgres;

--
-- Name: school_field_categories_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.school_field_categories_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.school_field_categories_seq OWNER TO postgres;

--
-- Name: school_fields; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_fields (
    id numeric NOT NULL,
    type character varying(10),
    search character varying(1),
    select_options character varying(10000),
    category_id numeric,
    system_field character(1),
    default_selection character varying(255),
    log_field1_title character varying(100),
    log_field2_title character varying(100),
    log_field3_title character varying(100),
    log_field4_title character varying(100),
    log_field5_title character varying(100),
    log_field6_title character varying(100),
    log_field7_title character varying(100),
    log_field8_title character varying(100),
    log_field9_title character varying(100),
    required character(1),
    max_length numeric,
    sort_order numeric,
    select_option_codes character varying(10000),
    select_option_default_code character varying(255),
    application character varying(1),
    log_field10_title character varying(100),
    log_field11_title character varying(100),
    title character varying(100),
    field_edits text,
    log_field1 character varying(10),
    log_field2 character varying(10),
    log_field3 character varying(10),
    log_field4 character varying(10),
    log_field5 character varying(10),
    log_field6 character varying(10),
    log_field7 character varying(10),
    log_field8 character varying(10),
    log_field9 character varying(10),
    log_field10 character varying(10),
    log_field11 character varying(10),
    log_field12 character varying(10),
    log_field13 character varying(10),
    log_field14 character varying(10),
    log_field15 character varying(10),
    log_field16 character varying(10),
    log_field17 character varying(10),
    log_field18 character varying(10),
    log_field19 character varying(10),
    log_field20 character varying(10),
    log_field12_title character varying(100),
    log_field13_title character varying(100),
    log_field14_title character varying(100),
    log_field15_title character varying(100),
    log_field16_title character varying(100),
    log_field17_title character varying(100),
    log_field18_title character varying(100),
    log_field19_title character varying(100),
    log_field20_title character varying(100),
    log_field1_sort_order numeric DEFAULT 1,
    log_field2_sort_order numeric DEFAULT 2,
    log_field3_sort_order numeric DEFAULT 3,
    log_field4_sort_order numeric DEFAULT 4,
    log_field5_sort_order numeric DEFAULT 5,
    log_field6_sort_order numeric DEFAULT 6,
    log_field7_sort_order numeric DEFAULT 7,
    log_field8_sort_order numeric DEFAULT 8,
    log_field9_sort_order numeric DEFAULT 9,
    log_field10_sort_order numeric DEFAULT 10,
    log_field11_sort_order numeric DEFAULT 11,
    log_field12_sort_order numeric DEFAULT 12,
    log_field13_sort_order numeric DEFAULT 13,
    log_field14_sort_order numeric DEFAULT 14,
    log_field15_sort_order numeric DEFAULT 15,
    log_field16_sort_order numeric DEFAULT 16,
    log_field17_sort_order numeric DEFAULT 17,
    log_field18_sort_order numeric DEFAULT 18,
    log_field19_sort_order numeric DEFAULT 19,
    log_field20_sort_order numeric DEFAULT 20,
    size numeric
);


ALTER TABLE public.school_fields OWNER TO postgres;

--
-- Name: school_fields_in_cats; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_fields_in_cats (
    field_id integer NOT NULL,
    category_id integer NOT NULL,
    sort_order integer NOT NULL
);


ALTER TABLE public.school_fields_in_cats OWNER TO postgres;

--
-- Name: school_group_titles_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.school_group_titles_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.school_group_titles_seq OWNER TO postgres;

--
-- Name: school_group_titles; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_group_titles (
    id numeric DEFAULT nextval('public.school_group_titles_seq'::regclass) NOT NULL,
    school_id numeric,
    title character varying(100),
    short_name character varying(20),
    sort_order numeric
);


ALTER TABLE public.school_group_titles OWNER TO postgres;

--
-- Name: school_groups_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.school_groups_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.school_groups_seq OWNER TO postgres;

--
-- Name: school_groups; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_groups (
    id numeric DEFAULT nextval('public.school_groups_seq'::regclass) NOT NULL,
    school_id numeric,
    title character varying(50),
    short_name character varying(10),
    sort_order numeric,
    next_group_id numeric,
    group_title_id numeric NOT NULL
);


ALTER TABLE public.school_groups OWNER TO postgres;

--
-- Name: school_lf_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_lf_data (
    id numeric,
    school_field_id numeric,
    student_id numeric,
    school_id numeric,
    user_id numeric,
    modified_date date,
    log_field1 text,
    log_field2 text,
    log_field3 text,
    log_field4 text,
    log_field5 text,
    log_field6 text,
    log_field7 text,
    log_field8 text,
    log_field9 text,
    log_field10 text,
    log_field11 text,
    log_field12 text,
    log_field13 text,
    log_field14 text,
    log_field15 text,
    log_field16 text,
    log_field17 text,
    log_field18 text,
    log_field19 text,
    log_field20 text
);


ALTER TABLE public.school_lf_data OWNER TO postgres;

--
-- Name: school_lf_data_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.school_lf_data_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.school_lf_data_seq OWNER TO postgres;

--
-- Name: school_periods; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_periods (
    school_period_id numeric NOT NULL,
    school_year numeric,
    school_id numeric,
    sort_order numeric,
    title character varying(100),
    short_name character varying(10),
    length numeric,
    rollover_id numeric,
    block character varying(10),
    attendance character varying(1),
    length_sun numeric,
    length_mon numeric,
    length_tue numeric,
    length_wed numeric,
    length_thu numeric,
    length_fri numeric,
    length_sat numeric,
    start_time time without time zone,
    end_time time without time zone,
    start_time_sun time without time zone,
    end_time_sun time without time zone,
    start_time_mon time without time zone,
    end_time_mon time without time zone,
    start_time_tue time without time zone,
    end_time_tue time without time zone,
    start_time_wed time without time zone,
    end_time_wed time without time zone,
    start_time_thu time without time zone,
    end_time_thu time without time zone,
    start_time_fri time without time zone,
    end_time_fri time without time zone,
    start_time_sat time without time zone,
    end_time_sat time without time zone
);


ALTER TABLE public.school_periods OWNER TO postgres;

--
-- Name: school_periods_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.school_periods_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.school_periods_seq OWNER TO postgres;

--
-- Name: school_quarters; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_quarters (
    school_term_id numeric NOT NULL,
    school_year numeric,
    school_id numeric,
    semester_id numeric,
    title character varying(50),
    short_name character varying(10),
    sort_order numeric,
    start_date date,
    end_date date,
    post_start_date date,
    post_end_date date,
    rollover_id numeric,
    registration_start_date date,
    registration_end_date date,
    year_fraction numeric
);


ALTER TABLE public.school_quarters OWNER TO postgres;

--
-- Name: school_semesters; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_semesters (
    school_term_id numeric NOT NULL,
    school_year numeric,
    school_id numeric,
    title character varying(50),
    short_name character varying(10),
    sort_order numeric,
    start_date date,
    end_date date,
    post_start_date date,
    post_end_date date,
    rollover_id numeric,
    registration_start_date date,
    registration_end_date date,
    year_fraction numeric,
    year_id numeric
);


ALTER TABLE public.school_semesters OWNER TO postgres;

--
-- Name: school_term_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.school_term_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.school_term_seq OWNER TO postgres;

--
-- Name: school_weeks; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_weeks (
    school_term_id numeric NOT NULL,
    school_year numeric,
    school_id numeric,
    quarter_id numeric,
    title character varying(50),
    short_name character varying(10),
    sort_order numeric,
    start_date date,
    end_date date,
    post_start_date date,
    post_end_date date,
    rollover_id numeric,
    year_fraction numeric
);


ALTER TABLE public.school_weeks OWNER TO postgres;

--
-- Name: school_years; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.school_years (
    school_term_id numeric NOT NULL,
    school_year numeric,
    school_id numeric,
    title character varying(50),
    short_name character varying(10),
    sort_order numeric,
    start_date date,
    end_date date,
    post_start_date date,
    post_end_date date,
    registration_start_date date,
    registration_end_date date,
    year_fraction numeric,
    rollover_id numeric
);


ALTER TABLE public.school_years OWNER TO postgres;

--
-- Name: schools; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.schools (
    school_year numeric,
    id numeric NOT NULL,
    title character varying(100),
    address character varying(100),
    city character varying(100),
    state character varying(2),
    zipcode character varying(10),
    area_code numeric,
    phone numeric,
    principal character varying(100),
    latitude numeric,
    longitude numeric,
    state_school_id numeric,
    cfield_1 numeric,
    cfield_2 numeric,
    cfield_3 numeric,
    cfield_60319 character varying(255),
    cfield_60320 character varying(255),
    cfield_60322 character varying(10),
    cfield_60323 character varying(20),
    cfield_60324 character varying(100),
    cfield_60325 character varying(1000),
    cfield_54 character varying(255),
    cfield_58 character varying(5000),
    cfield_59 character varying(255),
    cfield_60 character varying(255),
    cfield_61 character varying(255),
    cfield_62 character varying(255),
    cfield_63 character varying(255),
    cfield_64 character varying(255),
    cfield_65 character varying(255),
    cfield_66 character varying(255),
    cfield_67 character varying(5000),
    cfield_68 numeric,
    cfield_69 character varying(255),
    cfield_70 character varying(255),
    cfield_71 character varying(255),
    cfield_72 character varying(255)
);


ALTER TABLE public.schools OWNER TO postgres;

--
-- Name: schools_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.schools_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.schools_seq OWNER TO postgres;

--
-- Name: sms_notification_list_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sms_notification_list_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sms_notification_list_seq OWNER TO postgres;

--
-- Name: sms_notification_list; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sms_notification_list (
    id numeric DEFAULT nextval('public.sms_notification_list_seq'::regclass) NOT NULL,
    person_id numeric NOT NULL,
    profile character varying(50) NOT NULL,
    type character varying(50) NOT NULL,
    checkboxes character varying(200),
    day_notify character varying(100),
    total_grades character varying(15)
);


ALTER TABLE public.sms_notification_list OWNER TO postgres;

--
-- Name: sms_profiles_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sms_profiles_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sms_profiles_seq OWNER TO postgres;

--
-- Name: sms_profiles; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sms_profiles (
    id numeric DEFAULT nextval('public.sms_profiles_seq'::regclass) NOT NULL,
    title character varying(50) NOT NULL,
    login character varying(50) NOT NULL,
    pass character varying(50) NOT NULL
);


ALTER TABLE public.sms_profiles OWNER TO postgres;

--
-- Name: statistics_of_visitings_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.statistics_of_visitings_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.statistics_of_visitings_seq OWNER TO postgres;

--
-- Name: statistics_of_visitings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.statistics_of_visitings (
    id numeric DEFAULT nextval('public.statistics_of_visitings_seq'::regclass) NOT NULL,
    user_id numeric NOT NULL,
    profile character varying(50) NOT NULL,
    module character varying(50) NOT NULL,
    servicemod character varying(200) NOT NULL,
    s_count numeric NOT NULL
);


ALTER TABLE public.statistics_of_visitings OWNER TO postgres;

--
-- Name: std_counter_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.std_counter_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.std_counter_seq OWNER TO postgres;

--
-- Name: std_counter; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.std_counter (
    id numeric DEFAULT nextval('public.std_counter_seq'::regclass) NOT NULL,
    school_id numeric,
    school_year numeric,
    doc_id numeric NOT NULL,
    advanced character varying(1),
    counter_id numeric,
    value numeric
);


ALTER TABLE public.std_counter OWNER TO postgres;

--
-- Name: student_activities_history; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_activities_history (
    school_year numeric,
    student_id numeric,
    activity_id numeric
);


ALTER TABLE public.student_activities_history OWNER TO postgres;

--
-- Name: student_attendance_days; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_attendance_days (
    student_id numeric NOT NULL,
    school_date date NOT NULL,
    minutes_present numeric,
    state_value numeric,
    school_year numeric,
    school_term_id numeric,
    comment character varying(255),
    daily_code character varying(10),
    last_updated_date date,
    last_updated_user numeric
);


ALTER TABLE public.student_attendance_days OWNER TO postgres;

--
-- Name: student_attendance_periods; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_attendance_periods (
    student_id numeric NOT NULL,
    school_date date NOT NULL,
    school_period_id numeric NOT NULL,
    attendance_code numeric,
    attendance_teacher_code numeric,
    attendance_reason character varying(100),
    admin character varying(1),
    course_section_id numeric,
    school_term_id numeric,
    last_updated_date date,
    last_updated_user numeric
);


ALTER TABLE public.student_attendance_periods OWNER TO postgres;

--
-- Name: student_discipline_incidents; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_discipline_incidents (
    school_year numeric,
    id numeric NOT NULL,
    title character varying(100),
    cfield_214 character varying(255),
    cfield_215 date,
    cfield_216 character varying(255),
    cfield_217 character varying(255),
    cfield_218 date,
    cfield_219 character varying(255),
    cfield_220 character varying(5000),
    cfield_221 character varying(5000),
    cfield_90 character varying(5000),
    cfield_91 character varying(5000),
    cfield_92 character varying(5000),
    cfield_93 character varying(5000)
);


ALTER TABLE public.student_discipline_incidents OWNER TO postgres;

--
-- Name: student_discipline_incidents_asg_reports; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_discipline_incidents_asg_reports (
    incident_id numeric,
    referral_id numeric
);


ALTER TABLE public.student_discipline_incidents_asg_reports OWNER TO postgres;

--
-- Name: student_discipline_incidents_fields_in_cats; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_discipline_incidents_fields_in_cats (
    field_id integer NOT NULL,
    category_id integer NOT NULL,
    sort_order integer NOT NULL
);


ALTER TABLE public.student_discipline_incidents_fields_in_cats OWNER TO postgres;

--
-- Name: student_discipline_incidents_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_discipline_incidents_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_discipline_incidents_seq OWNER TO postgres;

--
-- Name: student_discipline_reports; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_discipline_reports (
    id numeric NOT NULL,
    school_year numeric NOT NULL,
    student_id numeric NOT NULL,
    school_id numeric NOT NULL,
    user_id numeric,
    entry_date date,
    referral_date date,
    category_1 character varying(1000),
    category_2 character varying(1000),
    category_3 character varying(1),
    category_4 character varying(1000),
    category_6 character varying(5000),
    category_10 character varying(1000),
    category_11 character varying(5000),
    category_12 character varying(5000),
    category_13 character varying(5000),
    category_14 character varying(5000)
);


ALTER TABLE public.student_discipline_reports OWNER TO postgres;

--
-- Name: student_discipline_reports_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_discipline_reports_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_discipline_reports_seq OWNER TO postgres;

--
-- Name: student_emails; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_emails (
    id numeric NOT NULL,
    title character varying(255),
    default_template_id numeric,
    body text,
    school_id numeric,
    profile character varying(25),
    user_id numeric
);


ALTER TABLE public.student_emails OWNER TO postgres;

--
-- Name: student_emails_order; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_emails_order (
    letter_id integer NOT NULL,
    sid integer NOT NULL,
    stype integer NOT NULL,
    template_id integer NOT NULL,
    dt_added date,
    user_added integer,
    dt_printed date,
    user_printed integer
);


ALTER TABLE public.student_emails_order OWNER TO postgres;

--
-- Name: student_emails_order_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_emails_order_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_emails_order_seq OWNER TO postgres;

--
-- Name: student_emails_processing; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_emails_processing (
    trigger_id numeric NOT NULL,
    trigger_event smallint NOT NULL,
    trigger_action smallint NOT NULL,
    template_id numeric NOT NULL
);


ALTER TABLE public.student_emails_processing OWNER TO postgres;

--
-- Name: student_emails_processing_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_emails_processing_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_emails_processing_seq OWNER TO postgres;

--
-- Name: student_emails_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_emails_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_emails_seq OWNER TO postgres;

--
-- Name: student_field_categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_field_categories (
    id numeric NOT NULL,
    title character varying(100),
    allow_teacher_modify character varying(1),
    sort_order numeric,
    columns numeric,
    allow_student_modify character varying(1),
    alternative_name character varying(255),
    used_applicants character varying(1)
);


ALTER TABLE public.student_field_categories OWNER TO postgres;

--
-- Name: student_field_categories_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_field_categories_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_field_categories_seq OWNER TO postgres;

--
-- Name: student_fields; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_fields (
    id numeric NOT NULL,
    type character varying(10),
    search character varying(1),
    select_options character varying(10000),
    category_id numeric,
    system_field bpchar,
    default_selection character varying(255),
    log_field1_title character varying(100),
    log_field2_title character varying(100),
    log_field3_title character varying(100),
    log_field4_title character varying(100),
    log_field5_title character varying(100),
    log_field6_title character varying(100),
    log_field7_title character varying(100),
    log_field8_title character varying(100),
    log_field9_title character varying(100),
    required bpchar,
    max_length numeric,
    sort_order numeric,
    select_option_codes character varying(10000),
    select_option_default_code character varying(255),
    application character varying(1),
    log_field10_title character varying(100),
    log_field11_title character varying(100),
    title character varying(100),
    field_edits text,
    log_field1 character varying(10),
    log_field2 character varying(10),
    log_field3 character varying(10),
    log_field4 character varying(10),
    log_field5 character varying(10),
    log_field6 character varying(10),
    log_field7 character varying(10),
    log_field8 character varying(10),
    log_field9 character varying(10),
    log_field10 character varying(10),
    log_field11 character varying(10),
    log_field12 character varying(10),
    log_field13 character varying(10),
    log_field14 character varying(10),
    log_field15 character varying(10),
    log_field16 character varying(10),
    log_field17 character varying(10),
    log_field18 character varying(10),
    log_field19 character varying(10),
    log_field20 character varying(10),
    log_field12_title character varying(100),
    log_field13_title character varying(100),
    log_field14_title character varying(100),
    log_field15_title character varying(100),
    log_field16_title character varying(100),
    log_field17_title character varying(100),
    log_field18_title character varying(100),
    log_field19_title character varying(100),
    log_field20_title character varying(100),
    log_field1_sort_order numeric DEFAULT 1,
    log_field2_sort_order numeric DEFAULT 2,
    log_field3_sort_order numeric DEFAULT 3,
    log_field4_sort_order numeric DEFAULT 4,
    log_field5_sort_order numeric DEFAULT 5,
    log_field6_sort_order numeric DEFAULT 6,
    log_field7_sort_order numeric DEFAULT 7,
    log_field8_sort_order numeric DEFAULT 8,
    log_field9_sort_order numeric DEFAULT 9,
    log_field10_sort_order numeric DEFAULT 10,
    log_field11_sort_order numeric DEFAULT 11,
    log_field12_sort_order numeric DEFAULT 12,
    log_field13_sort_order numeric DEFAULT 13,
    log_field14_sort_order numeric DEFAULT 14,
    log_field15_sort_order numeric DEFAULT 15,
    log_field16_sort_order numeric DEFAULT 16,
    log_field17_sort_order numeric DEFAULT 17,
    log_field18_sort_order numeric DEFAULT 18,
    log_field19_sort_order numeric DEFAULT 19,
    log_field20_sort_order numeric DEFAULT 20,
    max_record numeric,
    use_applicants character varying(1),
    use_students character varying(1),
    use_source character varying(1),
    for_applicants character varying(1),
    values_field character varying(30),
    codes_field character varying(30),
    source_table character varying(30),
    size numeric,
    log_field1_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field2_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field3_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field4_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field5_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field6_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field7_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field8_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field9_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field10_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field11_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field12_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field13_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field14_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field15_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field16_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field17_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field18_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field19_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field20_count_total character varying(1) DEFAULT 'N'::character varying,
    log_field1_size numeric,
    log_field2_size numeric,
    log_field3_size numeric,
    log_field4_size numeric,
    log_field5_size numeric,
    log_field6_size numeric,
    log_field7_size numeric,
    log_field8_size numeric,
    log_field9_size numeric,
    log_field10_size numeric,
    log_field11_size numeric,
    log_field12_size numeric,
    log_field13_size numeric,
    log_field14_size numeric,
    log_field15_size numeric,
    log_field16_size numeric,
    log_field17_size numeric,
    log_field18_size numeric,
    log_field19_size numeric,
    log_field20_size numeric
);


ALTER TABLE public.student_fields OWNER TO postgres;

--
-- Name: student_fields_in_cats; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_fields_in_cats (
    field_id integer NOT NULL,
    category_id integer NOT NULL,
    sort_order integer NOT NULL
);


ALTER TABLE public.student_fields_in_cats OWNER TO postgres;

--
-- Name: student_fields_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_fields_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_fields_seq OWNER TO postgres;

--
-- Name: student_gpa_progress; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_gpa_progress (
    student_id numeric,
    school_term_id numeric,
    gpa_points numeric,
    gpa_points_weighted numeric,
    divisor numeric
);


ALTER TABLE public.student_gpa_progress OWNER TO postgres;

--
-- Name: student_gpa_totals; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_gpa_totals (
    student_id numeric,
    school_term_id numeric,
    mp character varying(4),
    gpa numeric,
    weighted_gpa numeric,
    class_rank numeric,
    cumulative_gpa numeric,
    cumulative_weighted_gpa numeric,
    grade_total numeric,
    cumulative_credits numeric,
    classlevel_id numeric,
    percent_average numeric,
    credits_attempted numeric,
    credits_earned numeric,
    classgroup_rank numeric
);


ALTER TABLE public.student_gpa_totals OWNER TO postgres;

--
-- Name: student_grades_card; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_grades_card (
    school_year numeric NOT NULL,
    school_id numeric,
    student_id numeric NOT NULL,
    course_section_id numeric,
    grades_card_id numeric,
    grade_card_comment_id numeric,
    comment character varying(255),
    school_term_id character varying(10) NOT NULL,
    id numeric NOT NULL,
    course_title character varying(100),
    teacher character varying(100),
    gradelevel_title character varying(100),
    grad_subject_id numeric,
    location_title character varying(100),
    percent_grade numeric,
    credits numeric,
    modified_date date,
    modified_user_id numeric,
    gpa_points numeric,
    grade_title character varying(10),
    weighted_gpa_points numeric,
    course_num character varying(30),
    affects_gpa character varying(1),
    carries_credits character varying(1),
    grade_type_id numeric,
    course_id numeric,
    course_credit_title character varying(10),
    last_updated_date date,
    last_updated_user numeric,
    conduct character varying(5),
    cfield_1 character varying(255),
    cfield_2 character varying(255),
    cfield_3 character varying(255),
    cfield_4 character varying(255)
);


ALTER TABLE public.student_grades_card OWNER TO postgres;

--
-- Name: student_grades_card_evaluations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_grades_card_evaluations (
    id numeric NOT NULL,
    school_year numeric NOT NULL,
    school_id numeric,
    student_id numeric NOT NULL,
    course_section_id numeric NOT NULL,
    school_term_id numeric NOT NULL,
    benchmark_id numeric NOT NULL,
    title character varying(10),
    grades_card_id numeric,
    grade_title character varying(10),
    comment character varying(255),
    longer_course_comments text
);


ALTER TABLE public.student_grades_card_evaluations OWNER TO postgres;

--
-- Name: student_grades_card_evaluations_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_grades_card_evaluations_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_grades_card_evaluations_seq OWNER TO postgres;

--
-- Name: student_grades_card_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_grades_card_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_grades_card_seq OWNER TO postgres;

--
-- Name: student_in_delivery_group; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_in_delivery_group (
    delivery_group_id numeric,
    student_id numeric
);


ALTER TABLE public.student_in_delivery_group OWNER TO postgres;

--
-- Name: student_lf_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_lf_data (
    id numeric,
    student_field_id numeric,
    student_id numeric,
    school_id numeric,
    user_id numeric,
    modified_date date,
    log_field1 text,
    log_field2 text,
    log_field3 text,
    log_field4 text,
    log_field5 text,
    log_field6 text,
    log_field7 text,
    log_field8 text,
    log_field9 text,
    log_field10 text,
    log_field11 text,
    log_field12 text,
    log_field13 text,
    log_field14 text,
    log_field15 text,
    log_field16 text,
    log_field17 text,
    log_field18 text,
    log_field19 text,
    log_field20 text
);


ALTER TABLE public.student_lf_data OWNER TO postgres;

--
-- Name: student_lf_data_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_lf_data_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_lf_data_seq OWNER TO postgres;

--
-- Name: student_markbook_grades; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_markbook_grades (
    student_id numeric NOT NULL,
    school_period_id numeric,
    course_section_id numeric NOT NULL,
    assignment_id numeric NOT NULL,
    points numeric,
    comment character varying(100),
    highlight character varying(1)
);


ALTER TABLE public.student_markbook_grades OWNER TO postgres;

--
-- Name: student_medical; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_medical (
    id numeric NOT NULL,
    student_id numeric,
    type character varying(25),
    medical_date date,
    comments character varying(100)
);


ALTER TABLE public.student_medical OWNER TO postgres;

--
-- Name: student_medical_alerts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_medical_alerts (
    id numeric NOT NULL,
    student_id numeric,
    title character varying(100)
);


ALTER TABLE public.student_medical_alerts OWNER TO postgres;

--
-- Name: student_medical_alerts_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_medical_alerts_seq
    START WITH 5
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_medical_alerts_seq OWNER TO postgres;

--
-- Name: student_medical_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_medical_seq
    START WITH 5
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_medical_seq OWNER TO postgres;

--
-- Name: student_medical_visits; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_medical_visits (
    id numeric NOT NULL,
    student_id numeric,
    school_date date,
    time_in character varying(20),
    time_out character varying(20),
    reason character varying(100),
    result character varying(100),
    comments character varying(255)
);


ALTER TABLE public.student_medical_visits OWNER TO postgres;

--
-- Name: student_medical_visits_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_medical_visits_seq
    START WITH 5
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_medical_visits_seq OWNER TO postgres;

--
-- Name: student_registration; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_registration (
    id numeric NOT NULL,
    school_year numeric,
    school_id numeric,
    student_id numeric,
    classlevel_id numeric,
    start_date date,
    end_date date,
    enrollment_code numeric,
    drop_code numeric,
    next_school numeric,
    calendar_id numeric,
    include_in_class_rank character varying(1),
    distance_from_school numeric,
    cfield_1 character varying(50),
    cfield_2 character varying(50),
    cfield_3 character varying(50),
    cfield_4 character varying(50),
    cfield_5 character varying(50),
    cfield_6 character varying(50),
    cfield_7 character varying(50),
    cfield_8 character varying(50),
    cfield_9 character varying(50),
    cfield_10 character varying(50),
    cfield_11 character varying(50),
    cfield_12 character varying(50),
    group_id numeric,
    include_in_group_rank character varying(1),
    cfield_15 character varying(255)
);


ALTER TABLE public.student_registration OWNER TO postgres;

--
-- Name: student_registration_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_registration_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_registration_seq OWNER TO postgres;

--
-- Name: student_registration_settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_registration_settings (
    id numeric NOT NULL,
    school_year numeric,
    title character varying(100),
    short_name character varying(10),
    type character varying(4)
);


ALTER TABLE public.student_registration_settings OWNER TO postgres;

--
-- Name: student_registration_settings_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_registration_settings_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_registration_settings_seq OWNER TO postgres;

--
-- Name: student_relations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_relations (
    person_id numeric NOT NULL,
    last_name character varying(25) NOT NULL,
    first_name character varying(25) NOT NULL,
    middle_name character varying(25),
    title character varying(5),
    email character varying(255),
    notificate character varying(1) DEFAULT 'N'::character varying
);


ALTER TABLE public.student_relations OWNER TO postgres;

--
-- Name: student_relations_in_contacts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_relations_in_contacts (
    id numeric NOT NULL,
    person_id numeric,
    title character varying(100),
    value character varying(100)
);


ALTER TABLE public.student_relations_in_contacts OWNER TO postgres;

--
-- Name: student_relations_in_contacts_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_relations_in_contacts_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_relations_in_contacts_seq OWNER TO postgres;

--
-- Name: student_relations_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_relations_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_relations_seq OWNER TO postgres;

--
-- Name: student_schedule; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_schedule (
    school_year numeric NOT NULL,
    school_id numeric,
    student_id numeric NOT NULL,
    start_date date NOT NULL,
    end_date date,
    modified_date date,
    modified_by character varying(255),
    course_id numeric NOT NULL,
    course_credit_title character varying(10) NOT NULL,
    course_section_id numeric NOT NULL,
    mp character varying(3),
    school_term_id numeric,
    scheduler_lock character varying(1),
    id numeric,
    cfield_1 character varying(255),
    cfield_2 character varying(255),
    cfield_3 character varying(255),
    cfield_4 character varying(255),
    cfield_5 character varying(255),
    cfield_6 character varying(255),
    cfield_7 character varying(255),
    cfield_8 character varying(255),
    cfield_9 character varying(255),
    cfield_10 character varying(255),
    cfield_11 character varying(255),
    cfield_12 character varying(255),
    cfield_13 character varying(255),
    cfield_14 character varying(255),
    cfield_15 character varying(255),
    cfield_16 character varying(255),
    cfield_17 character varying(255),
    cfield_18 character varying(255),
    cfield_19 character varying(255),
    cfield_20 character varying(255),
    cfield_21 character varying(255),
    days character varying(255),
    checkbox_setting_1 character varying(1),
    checkbox_setting_2 character varying(1),
    checkbox_setting_3 character varying(1),
    cfield_22 character varying(255),
    cfield_23 character varying(255),
    cfield_24 character varying(255),
    cfield_25 character varying(255)
);


ALTER TABLE public.student_schedule OWNER TO postgres;

--
-- Name: student_schedule_requests; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_schedule_requests (
    school_year numeric,
    school_id numeric,
    request_id numeric NOT NULL,
    student_id numeric,
    subject_id numeric,
    course_id numeric,
    course_credit_title character varying(10),
    school_term_id numeric,
    priority numeric,
    with_teacher_id numeric,
    not_teacher_id numeric,
    with_school_period_id numeric,
    not_school_period_id numeric
);


ALTER TABLE public.student_schedule_requests OWNER TO postgres;

--
-- Name: student_schedule_requests_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_schedule_requests_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_schedule_requests_seq OWNER TO postgres;

--
-- Name: student_schedule_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_schedule_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_schedule_seq OWNER TO postgres;

--
-- Name: student_suitability_grades; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_suitability_grades (
    student_id numeric,
    school_year numeric,
    school_date date,
    school_period_id numeric,
    student_suitability_grades_code character varying(20),
    course_section_id numeric
);


ALTER TABLE public.student_suitability_grades OWNER TO postgres;

--
-- Name: student_term_comments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_term_comments (
    student_id numeric NOT NULL,
    school_year numeric NOT NULL,
    school_term_id numeric NOT NULL,
    comment text,
    editor_user_ids character varying(255)
);


ALTER TABLE public.student_term_comments OWNER TO postgres;

--
-- Name: students; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.students (
    student_id numeric NOT NULL,
    last_name character varying(50) NOT NULL,
    first_name character varying(50) NOT NULL,
    middle_name character varying(50),
    name_suffix character varying(30),
    username character varying(100),
    password character varying(100),
    cfield_50000 character varying(255),
    cfield_50001 character varying(255),
    cfield_50003 character varying(255),
    cfield_50004 date,
    cfield_50005 character varying(255),
    cfield_50006 character varying(255),
    cfield_50007 character varying(255),
    cfield_50008 character varying(255),
    cfield_50009 character varying(2052),
    cfield_50010 bpchar,
    last_login timestamp without time zone,
    failed_login numeric,
    profile_id numeric DEFAULT 8,
    last_note_seen numeric,
    cfield_50012 character varying(255),
    cfield_50013 character varying(255),
    force_password_change character varying(1) DEFAULT 'N'::character varying,
    last_updated_date date,
    last_updated_user numeric,
    cfield_196 character varying(255),
    cfield_197 character varying(255),
    cfield_198 character varying(255),
    cfield_199 character varying(1),
    cfield_200 character varying(255),
    cfield_201 character varying(255),
    cfield_202 character varying(255),
    cfield_203 character varying(255),
    cfield_204 character varying(255),
    cfield_205 character varying(255),
    cfield_206 character varying(255),
    cfield_207 character varying(255),
    cfield_208 character varying(255),
    cfield_209 character varying(255),
    cfield_211 character varying(255),
    cfield_212 character varying(255),
    cfield_50002 character varying(40),
    cfield_50016 character varying(255),
    profile character varying(10),
    cfield_2 character varying(255),
    cfield_7 date,
    cfield_8 character varying(255),
    cfield_11 character varying(255),
    cfield_14 character varying(255),
    cfield_15 character varying(255),
    cfield_24 date,
    cfield_25 character varying(255),
    cfield_31 character varying(255),
    cfield_32 character varying(255),
    cfield_35 character varying(255),
    cfield_36 character varying(255),
    cfield_38 character varying(255),
    cfield_39 character varying(255),
    cfield_40 character varying(255),
    cfield_41 character varying(255),
    cfield_42 character varying(255),
    cfield_43 character varying(255),
    cfield_44 character varying(255),
    cfield_45 character varying(5000),
    cfield_46 numeric,
    cfield_47 character varying(255),
    cfield_48 character varying(5000),
    cfield_49 numeric,
    cfield_50 character varying(255),
    cfield_51 character varying(255),
    cfield_52 character varying(255),
    cfield_53 character varying(255),
    cfield_54 character varying(1000),
    cfield_55 character varying(5000),
    cfield_56 date,
    cfield_57 character varying(1000),
    cfield_94 character varying(5000),
    cfield_95 character varying(255),
    cfield_96 character varying(255),
    cfield_97 character varying(255),
    cfield_100 character varying(255),
    cfield_101 character varying(5000),
    cfield_102 character varying(5000),
    cfield_104 numeric,
    cfield_105 numeric,
    cfield_106 numeric,
    cfield_107 numeric,
    cfield_108 numeric
);


ALTER TABLE public.students OWNER TO postgres;

--
-- Name: students_auditlog; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.students_auditlog (
    data_element character varying(50) NOT NULL,
    student_id numeric,
    user_id numeric,
    change_date timestamp without time zone,
    change_description text,
    flags character varying(1)
);


ALTER TABLE public.students_auditlog OWNER TO postgres;

--
-- Name: students_in_address; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.students_in_address (
    id numeric NOT NULL,
    student_id numeric NOT NULL,
    address_id numeric NOT NULL,
    mailing character varying(1),
    residence character varying(1),
    bus_pickup character varying(1),
    bus_dropoff character varying(1)
);


ALTER TABLE public.students_in_address OWNER TO postgres;

--
-- Name: students_in_address_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.students_in_address_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.students_in_address_seq OWNER TO postgres;

--
-- Name: students_in_sr; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.students_in_sr (
    id numeric NOT NULL,
    student_id numeric NOT NULL,
    person_id numeric NOT NULL,
    address_id numeric,
    custody character varying(1),
    emergency character varying(1),
    student_relation character varying(100)
);


ALTER TABLE public.students_in_sr OWNER TO postgres;

--
-- Name: students_in_sr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.students_in_sr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.students_in_sr_seq OWNER TO postgres;

--
-- Name: students_in_users; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.students_in_users (
    student_id numeric NOT NULL,
    user_id numeric NOT NULL
);


ALTER TABLE public.students_in_users OWNER TO postgres;

--
-- Name: students_scores_rating; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.students_scores_rating (
    id numeric NOT NULL,
    student_id numeric NOT NULL,
    low_score numeric,
    high_score numeric,
    course_rank numeric,
    school_term_id character varying NOT NULL,
    course_id numeric NOT NULL
);


ALTER TABLE public.students_scores_rating OWNER TO postgres;

--
-- Name: students_scores_rating_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.students_scores_rating_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.students_scores_rating_seq OWNER TO postgres;

--
-- Name: students_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.students_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.students_seq OWNER TO postgres;

--
-- Name: suitability_teachers_filled; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.suitability_teachers_filled (
    user_id numeric NOT NULL,
    school_date date NOT NULL,
    school_period_id numeric NOT NULL
);


ALTER TABLE public.suitability_teachers_filled OWNER TO postgres;

--
-- Name: system_config; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.system_config (
    school_year numeric,
    school_id numeric,
    program character varying(255),
    title character varying(100),
    value character varying(100)
);


ALTER TABLE public.system_config OWNER TO postgres;

--
-- Name: system_user_settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.system_user_settings (
    username character varying(100),
    program character varying(255),
    title character varying(100),
    value text,
    school_id numeric,
    school_year numeric(4,0)
);


ALTER TABLE public.system_user_settings OWNER TO postgres;

--
-- Name: type_of_study_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.type_of_study_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.type_of_study_seq OWNER TO postgres;

--
-- Name: type_of_study; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.type_of_study (
    id numeric DEFAULT nextval('public.type_of_study_seq'::regclass)
);


ALTER TABLE public.type_of_study OWNER TO postgres;

--
-- Name: user_field_categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_field_categories (
    id numeric NOT NULL,
    title character varying(100),
    sort_order numeric,
    admin character varying(1),
    teacher character varying(1),
    parent character varying(1),
    columns numeric,
    allow_teacher_modify character varying(1)
);


ALTER TABLE public.user_field_categories OWNER TO postgres;

--
-- Name: user_field_categories_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_field_categories_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_field_categories_seq OWNER TO postgres;

--
-- Name: user_fields; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_fields (
    id numeric NOT NULL,
    type character varying(10),
    search character varying(1),
    select_options character varying(10000),
    category_id numeric,
    system_field bpchar,
    default_selection character varying(255),
    log_field1_title character varying(100),
    log_field2_title character varying(100),
    log_field3_title character varying(100),
    log_field4_title character varying(100),
    log_field5_title character varying(100),
    log_field6_title character varying(100),
    log_field7_title character varying(100),
    log_field8_title character varying(100),
    log_field9_title character varying(100),
    sort_order numeric,
    required bpchar,
    max_length numeric,
    select_option_codes character varying(10000),
    select_option_default_code character varying(255),
    title character varying(100),
    application character varying(1),
    log_field10_title character varying(100),
    log_field11_title character varying(100),
    field_edits text,
    log_field1 character varying(10),
    log_field2 character varying(10),
    log_field3 character varying(10),
    log_field4 character varying(10),
    log_field5 character varying(10),
    log_field6 character varying(10),
    log_field7 character varying(10),
    log_field8 character varying(10),
    log_field9 character varying(10),
    log_field10 character varying(10),
    log_field11 character varying(10),
    log_field12 character varying(10),
    log_field13 character varying(10),
    log_field14 character varying(10),
    log_field15 character varying(10),
    log_field16 character varying(10),
    log_field17 character varying(10),
    log_field18 character varying(10),
    log_field19 character varying(10),
    log_field20 character varying(10),
    log_field12_title character varying(100),
    log_field13_title character varying(100),
    log_field14_title character varying(100),
    log_field15_title character varying(100),
    log_field16_title character varying(100),
    log_field17_title character varying(100),
    log_field18_title character varying(100),
    log_field19_title character varying(100),
    log_field20_title character varying(100),
    log_field1_sort_order numeric DEFAULT 1,
    log_field2_sort_order numeric DEFAULT 2,
    log_field3_sort_order numeric DEFAULT 3,
    log_field4_sort_order numeric DEFAULT 4,
    log_field5_sort_order numeric DEFAULT 5,
    log_field6_sort_order numeric DEFAULT 6,
    log_field7_sort_order numeric DEFAULT 7,
    log_field8_sort_order numeric DEFAULT 8,
    log_field9_sort_order numeric DEFAULT 9,
    log_field10_sort_order numeric DEFAULT 10,
    log_field11_sort_order numeric DEFAULT 11,
    log_field12_sort_order numeric DEFAULT 12,
    log_field13_sort_order numeric DEFAULT 13,
    log_field14_sort_order numeric DEFAULT 14,
    log_field15_sort_order numeric DEFAULT 15,
    log_field16_sort_order numeric DEFAULT 16,
    log_field17_sort_order numeric DEFAULT 17,
    log_field18_sort_order numeric DEFAULT 18,
    log_field19_sort_order numeric DEFAULT 19,
    log_field20_sort_order numeric DEFAULT 20,
    use_source character varying(1),
    values_field character varying(30),
    codes_field character varying(30),
    source_table character varying(30),
    size numeric
);


ALTER TABLE public.user_fields OWNER TO postgres;

--
-- Name: user_fields_in_cats; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_fields_in_cats (
    field_id integer NOT NULL,
    category_id integer NOT NULL,
    sort_order integer NOT NULL
);


ALTER TABLE public.user_fields_in_cats OWNER TO postgres;

--
-- Name: user_fields_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_fields_seq
    START WITH 6
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_fields_seq OWNER TO postgres;

--
-- Name: user_in_delivery_group; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_in_delivery_group (
    delivery_group_id numeric,
    user_id numeric
);


ALTER TABLE public.user_in_delivery_group OWNER TO postgres;

--
-- Name: user_in_messages_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_in_messages_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_in_messages_seq OWNER TO postgres;

--
-- Name: user_in_messages; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_in_messages (
    id numeric DEFAULT nextval('public.user_in_messages_seq'::regclass) NOT NULL,
    message_id numeric NOT NULL,
    incoming character varying(1) DEFAULT 'N'::character varying,
    outcoming character varying(1) DEFAULT 'N'::character varying,
    from_user numeric NOT NULL,
    to_user numeric NOT NULL
);


ALTER TABLE public.user_in_messages OWNER TO postgres;

--
-- Name: user_lf_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_lf_data (
    id numeric,
    user_field_id numeric,
    user_id numeric,
    school_id numeric,
    modified_date date,
    log_field1 text,
    log_field2 text,
    log_field3 text,
    log_field4 text,
    log_field5 text,
    log_field6 text,
    log_field7 text,
    log_field8 text,
    log_field9 text,
    log_field10 text,
    log_field11 text,
    log_field12 text,
    log_field13 text,
    log_field14 text,
    log_field15 text,
    log_field16 text,
    log_field17 text,
    log_field18 text,
    log_field19 text,
    log_field20 text,
    log_date date,
    log_select character varying(255),
    log_select2 character varying(255),
    log_text1 character varying(255)
);


ALTER TABLE public.user_lf_data OWNER TO postgres;

--
-- Name: user_lf_data_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_lf_data_seq
    START WITH 5
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_lf_data_seq OWNER TO postgres;

--
-- Name: user_messages_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_messages_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_messages_seq OWNER TO postgres;

--
-- Name: user_messages; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_messages (
    id numeric DEFAULT nextval('public.user_messages_seq'::regclass) NOT NULL,
    title text,
    content text,
    send_date timestamp without time zone,
    new_message character varying(1) DEFAULT 'Y'::character varying
);


ALTER TABLE public.user_messages OWNER TO postgres;

--
-- Name: user_profiles; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_profiles (
    id numeric NOT NULL,
    profile character varying(30),
    title character varying(100),
    type character varying(25)
);


ALTER TABLE public.user_profiles OWNER TO postgres;

--
-- Name: user_profiles_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_profiles_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_profiles_seq OWNER TO postgres;

--
-- Name: user_settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_settings (
    username character varying(100),
    modname character varying(255),
    viewer character varying(1),
    editor character varying(1)
);


ALTER TABLE public.user_settings OWNER TO postgres;

--
-- Name: users; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.users (
    school_year numeric,
    user_id numeric NOT NULL,
    current_school_id numeric,
    first_name character varying(100),
    last_name character varying(100),
    middle_name character varying(100),
    username character varying(100),
    password character varying(100),
    phone character varying(100),
    email character varying(100),
    profile character varying(30),
    homeroom character varying(5),
    rollover_id numeric,
    schools character varying(255),
    profile_id numeric,
    last_note_seen numeric,
    cfield_40001 character varying(255),
    cfield_40002 character varying(255),
    title character varying(30),
    cfield_40003 character varying(255),
    last_login timestamp without time zone,
    failed_login numeric,
    force_password_change character varying(1) DEFAULT 'N'::character varying,
    cfield_40004 date,
    cfield_188 character varying(255),
    cfield_189 date,
    cfield_190 character varying(255),
    cfield_191 character varying(255),
    cfield_192 character varying(255),
    cfield_194 character varying(255),
    cfield_195 character varying(255),
    last_updated_user numeric,
    last_updated_date date,
    cfield_40005 character varying(40),
    cfield_17 character varying(255),
    cfield_18 character varying(255),
    cfield_20 date,
    cfield_21 character varying(255),
    cfield_22 character varying(255),
    cfield_23 character varying(255),
    cfield_26 character varying(255),
    cfield_73 character varying(5000),
    cfield_74 character varying(255),
    cfield_75 character varying(255),
    cfield_76 date,
    cfield_77 date,
    cfield_78 character varying(255),
    cfield_79 character varying(255),
    cfield_80 date,
    cfield_81 character varying(5000),
    cfield_82 character varying(255),
    cfield_83 character varying(255),
    cfield_84 numeric,
    cfield_85 character varying(255),
    cfield_87 character varying(5000),
    cfield_88 date,
    cfield_89 character varying(5000),
    cfield_98 date,
    cfield_99 character varying(255),
    cfield_103 character varying(5000),
    cfield_109 character varying(255)
);


ALTER TABLE public.users OWNER TO postgres;

--
-- Name: users_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.users_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.users_seq OWNER TO postgres;

--
-- Name: year_grade_report; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.year_grade_report (
    grade_id character varying,
    value1 character varying,
    value2 character varying,
    value3 character varying,
    value4 character varying,
    value5 character varying
);


ALTER TABLE public.year_grade_report OWNER TO postgres;

--
-- Data for Name: activity_courses; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.activity_courses (id, school_year, school_id, title, start_date, end_date) FROM stdin;
3	2019	3	dd	\N	\N
7	2019	25	dd	\N	\N
4	2020	3	dd	\N	\N
8	2019	27	dd	\N	\N
9	2019	30	dd	\N	\N
12	2019	28	dd	\N	\N
13	2019	29	dd	\N	\N
\.


--
-- Data for Name: addons_log; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.addons_log (addon_title, error_date) FROM stdin;
\.


--
-- Data for Name: address; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.address (address_id, zipcode, plus4, city, state, mail_city, mail_state, mail_zipcode, address, mail_address, phone, latitude, longitude, username, password, last_login, failed_login, last_note_seen, profile_id, force_password_change, fed_region, mail_fed_region, settlement, mail_settlement) FROM stdin;
34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
42	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
45	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
46	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
47	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
49	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
51	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
52	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
53	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
54	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
55	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
56	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
57	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
58	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
60	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
62	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
63	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
64	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
65	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
66	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
67	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
68	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
69	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
70	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
71	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
72	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
73	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
74	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
75	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
76	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
77	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
78	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
79	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
80	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
81	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
82	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
83	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
84	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
85	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
86	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
87	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
88	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
89	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
90	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
91	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
92	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
93	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
94	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
95	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
96	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
97	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
98	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
99	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
100	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
101	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
102	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
103	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
104	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
105	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
106	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
107	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
108	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
109	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
110	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
111	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
112	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
113	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
114	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
115	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
116	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
117	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
118	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
119	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
120	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
121	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
122	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
123	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
124	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
125	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
126	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
127	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
128	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
129	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
130	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
131	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
132	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
133	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
134	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
135	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
136	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
137	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
138	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
139	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
140	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
141	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
142	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
143	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
144	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
145	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
146	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
147	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
148	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
149	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
150	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
151	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
153	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
154	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
155	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
156	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
157	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
158	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
159	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
160	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
161	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
162	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
163	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
164	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
165	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
166	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
167	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
168	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
169	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
170	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
171	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
172	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
173	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
174	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
175	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
176	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
177	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
178	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
179	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
180	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
181	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
182	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
183	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
184	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
185	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
186	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
187	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
188	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
189	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
190	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
191	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
192	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
193	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
194	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
195	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
196	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
197	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
198	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
199	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
200	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
201	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
202	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
203	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
204	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
207	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
208	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
209	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
210	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
211	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
212	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
213	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
214	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
215	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
216	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
217	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
218	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
219	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
220	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
221	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
222	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
224	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
225	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
226	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
227	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
228	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
229	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
230	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
231	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
232	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
233	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
234	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
235	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
236	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
237	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
238	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
239	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
240	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
241	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
242	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
243	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
244	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
245	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
246	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
247	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
248	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
249	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
250	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
251	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
252	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
253	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
254	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
255	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
256	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
257	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
258	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
259	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
260	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
261	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
262	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
263	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
264	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
265	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
266	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
267	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
268	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
269	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
270	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
271	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
272	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
273	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
274	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
275	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
276	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
277	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
278	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
279	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
280	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
281	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
282	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
283	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
284	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
285	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
286	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
287	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
288	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
289	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
290	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
291	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
292	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
293	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
294	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
295	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
296	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
297	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
298	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
299	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
300	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
301	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
302	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
303	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
304	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
305	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
306	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
307	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
308	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
309	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
310	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
311	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
312	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
313	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
314	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
315	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
316	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
317	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
318	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
319	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
320	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
321	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
322	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
323	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
324	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
325	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
326	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
327	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
328	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
329	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
330	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
331	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
332	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
333	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
334	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
335	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
336	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
337	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
338	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
339	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
340	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
341	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
342	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
343	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
344	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
345	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
346	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
347	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
348	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
349	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
350	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
351	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
352	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
353	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
354	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
355	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
356	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
357	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
358	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
359	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
360	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
361	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
362	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
363	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
364	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
365	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
366	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
367	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
368	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
369	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
370	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
371	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
372	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
373	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
374	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
375	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
376	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
377	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
378	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
379	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
380	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
381	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
382	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
383	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
384	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
385	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
386	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
387	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
388	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
389	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
390	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
391	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
392	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
393	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
394	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
395	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
396	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
397	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
398	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
399	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
400	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
401	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
402	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
403	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
404	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
405	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
406	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
407	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
408	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
409	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
410	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
411	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
412	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
413	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
414	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
415	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
416	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
417	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
418	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
419	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
420	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
421	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
422	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
423	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
424	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
425	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
426	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
427	werwere	\N	sdfsdf	ewrwerew	\N	\N	\N	dfdfd	\N	ewrewr	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
428	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
431	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
432	854	\N	benin city	Edo	\N	\N	\N	\N	\N	+2348025526534	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
433	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
440	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
447	122201	\N	gurgaon	haryana	\N	\N	\N	sector 56	\N	987654321	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
448	122201	\N	gurgaon	haryana	\N	\N	\N	d block 54	\N	987654321	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
451	122001	\N	gurgaon	CA	\N	\N	\N	26	\N	08888888888	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
453	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
455	122017	\N	Gurugram	Haryana	\N	\N	\N	\N	\N	09560913963	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
456	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
457	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
458	122201	\N	gurgaon	haryana	\N	\N	\N	d block 54	\N	987654321	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
459	122201	\N	gurgaon	haryana	\N	\N	\N	d block 54	\N	987654321	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
467	122001	\N	gurgaon	Haryana	\N	\N	\N	jmd	\N	9999999999	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
469	122001	\N	gurgaon	haryana	\N	\N	\N	26	\N	8899887788	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
470	122001	\N	gurgaon	haryana	\N	\N	\N	26	\N	8899887788	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
471	122001	\N	gurgaon	haryana	\N	\N	\N	26	\N	8899887788	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
492	122001	\N	gurgaon	haryana	\N	\N	\N	26	\N	8899887788	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
493	122008	\N	Delhi	Delhi	\N	\N	\N	25	\N	9898558841	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
494	122001	\N	gurgaon	CA	\N	\N	\N	26	\N	08888888888	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
496	122001	\N	Owerri	Imo	\N	\N	\N	26	\N	8899887788	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
497	122008	\N	Aba	Abia	\N	\N	\N	25	\N	9898558841	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
498	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
499	122001	\N	gurgaon	Haryana	\N	\N	\N	25	\N	08888888888	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
500	122001	\N	gurgaon	Haryana	\N	\N	\N	25	\N	08888888888	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
501	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
502	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
503	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
504	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
505	122008	\N	Aba	Abia	\N	\N	\N	25	\N	9898558841	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
506	122001	\N	Owerri	Imo	\N	\N	\N	26	\N	8899887788	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
507	122001	\N	gurgaon	Haryana	\N	\N	\N	25	\N	08888888888	\N	\N	\N	\N	\N	\N	\N	\N	N	\N	\N	\N	\N
\.


--
-- Data for Name: adodb_logsql; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.adodb_logsql (id, created, sql0, sql1, params, tracer, timer) FROM stdin;
\.


--
-- Data for Name: assignment_config; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.assignment_config (assignment_id, assignment_type_id, title, assigned_date, due_date, points, description, benchmarks, school_term_id) FROM stdin;
6	1	Attendance and Participation (5%)	2020-01-24	2020-01-25	100	Every lecturer must determine attendance and participation of students in all course activities	\N	201
4	1	Presentation (10%)	2020-01-24	2020-01-25	100	Usually individual or group presentation depending on the nature of the course.	\N	201
1	1	Paper1 (10%)	2020-01-24	2020-01-25	100	The first typed assignment, it could also mean short one page summaries grouped together to mean the first paper.	\N	201
2	1	Paper2 (10%)	2020-01-24	2020-01-25	100	This is usually a more demanding paper dealing with a major part of the course.	\N	201
5	1	Paper3 (15%)	2020-01-24	2020-01-25	100	This could be a term paper, or term project, but not final paper or project.	\N	201
3	2	EX (50%)	2020-01-24	2020-01-25	100	This is the final written examination, project or research paper that takes the place of an examination.	\N	201
\.


--
-- Data for Name: assignment_type_config; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.assignment_type_config (assignment_type_id, title, final_grade_percent, school_id, hcolor) FROM stdin;
1	Course Work	0.5	3	1111db
2	Exam	0.5	3	ff0088
\.


--
-- Data for Name: attendance_code_cats_settings; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.attendance_code_cats_settings (id, school_year, school_id, title, rollover_id) FROM stdin;
\.


--
-- Data for Name: attendance_codes_settings; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.attendance_codes_settings (id, school_year, school_id, title, short_name, type, state_code, default_code, table_name, sort_order, is_daily_code) FROM stdin;
1	2007	1	\N	\N	teacher	P	Y	0	\N	Y
2	2016	3	Present	PT	teacher	P	Y	0	1	Y
3	2016	3	Absent	AB	teacher	A	\N	0	2	Y
4	2016	3	Absent With Permission	AWP	teacher	H	\N	0	3	Y
5	2017	3	Present	PT	teacher	P	Y	0	1	Y
6	2017	3	Absent	AB	teacher	A	\N	0	2	Y
7	2017	3	Absent With Permission	AWP	teacher	H	\N	0	3	Y
8	2018	3	Present	PT	teacher	P	Y	0	1	Y
9	2018	3	Absent	AB	teacher	A	\N	0	2	Y
10	2018	3	Absent With Permission	AWP	teacher	H	\N	0	3	Y
11	2019	3	Present	PT	teacher	P	Y	0	1	Y
12	2019	3	Absent	AB	teacher	A	\N	0	2	Y
13	2019	3	Absent With Permission	AWP	teacher	H	\N	0	3	Y
14	2020	3	Present	PT	teacher	P	Y	0	1	Y
15	2020	3	Absent	AB	teacher	A	\N	0	2	Y
16	2020	3	Absent With Permission	AWP	teacher	H	\N	0	3	Y
17	2019	8	\N	\N	official	P	Y	0	\N	Y
19	2019	25	Present	PT	teacher	P	Y	0	1	Y
20	2019	25	Absent	AB	teacher	A	\N	0	2	Y
21	2019	25	Absent With Permission	AWP	teacher	H	\N	0	3	Y
22	2019	27	Present	PT	teacher	P	Y	0	1	Y
23	2019	27	Absent	AB	teacher	A	\N	0	2	Y
24	2019	27	Absent With Permission	AWP	teacher	H	\N	0	3	Y
25	2019	30	Present	PT	teacher	P	Y	0	1	Y
26	2019	30	Absent	AB	teacher	A	\N	0	2	Y
27	2019	30	Absent With Permission	AWP	teacher	H	\N	0	3	Y
34	2019	28	Present	PT	teacher	P	Y	0	1	Y
35	2019	28	Absent	AB	teacher	A	\N	0	2	Y
36	2019	28	Absent With Permission	AWP	teacher	H	\N	0	3	Y
37	2019	29	Present	PT	teacher	P	Y	0	1	Y
38	2019	29	Absent	AB	teacher	A	\N	0	2	Y
39	2019	29	Absent With Permission	AWP	teacher	H	\N	0	3	Y
\.


--
-- Data for Name: attendance_teacher_filled; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.attendance_teacher_filled (user_id, school_date, school_period_id) FROM stdin;
\.


--
-- Data for Name: available_modprog; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.available_modprog (modname, user_id, profile_id) FROM stdin;
\.


--
-- Data for Name: billing_student_fees; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.billing_student_fees (student_id, assigned_date, due_date, comments, id, title, amount, school_id, school_year, waived_fee_id, old_id, paip, debt, categories, balance_debt, cancellation, payment_category_id) FROM stdin;
181	2016-10-21	2016-12-31	All Paid	1	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
487	2016-10-21	2016-12-31	All Paid	2	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
460	2016-10-21	2016-12-31	All Paid	3	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
494	2016-10-21	2016-12-31	All Paid	4	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
461	2016-10-21	2016-12-31	All Paid	5	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
170	2016-10-21	2016-12-31	All Paid	6	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
488	2016-10-21	2016-12-31	All Paid	7	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
456	2016-10-21	2016-12-31	All Paid	8	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
439	2016-10-21	2016-12-31	All Paid	9	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
465	2016-10-21	2016-12-31	All Paid	10	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
466	2016-10-21	2016-12-31	All Paid	11	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
462	2016-10-21	2016-12-31	All Paid	12	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
97	2016-10-21	2016-12-31	All Paid	13	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
463	2016-10-21	2016-12-31	All Paid	14	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
464	2016-10-21	2016-12-31	All Paid	15	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
486	2016-10-21	2016-12-31	All Paid	16	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
171	2016-10-21	2016-12-31	All Paid	17	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
467	2016-10-21	2016-12-31	All Paid	18	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
413	2016-10-21	2016-12-31	All Paid	19	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
468	2016-10-21	2016-12-31	All Paid	20	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
469	2016-10-21	2016-12-31	All Paid	21	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
481	2016-10-21	2016-12-31	All Paid	22	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
480	2016-10-21	2016-12-31	All Paid	23	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
182	2016-10-21	2016-12-31	All Paid	24	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
455	2016-10-21	2016-12-31	All Paid	25	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
409	2016-10-21	2016-12-31	All Paid	26	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
172	2016-10-21	2016-12-31	All Paid	27	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
457	2016-10-21	2016-12-31	All Paid	28	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
414	2016-10-21	2016-12-31	All Paid	29	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
470	2016-10-21	2016-12-31	All Paid	30	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
183	2016-10-21	2016-12-31	All Paid	31	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
471	2016-10-21	2016-12-31	All Paid	32	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
472	2016-10-21	2016-12-31	All Paid	33	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
458	2016-10-21	2016-12-31	All Paid	34	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
173	2016-10-21	2016-12-31	All Paid	35	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
496	2016-10-21	2016-12-31	All Paid	36	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
491	2016-10-21	2016-12-31	All Paid	37	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
176	2016-10-21	2016-12-31	All Paid	38	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
415	2016-10-21	2016-12-31	All Paid	39	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
184	2016-10-21	2016-12-31	All Paid	40	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
416	2016-10-21	2016-12-31	All Paid	41	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
438	2016-10-21	2016-12-31	All Paid	42	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
429	2016-10-21	2016-12-31	All Paid	43	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
431	2016-10-21	2016-12-31	All Paid	44	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
432	2016-10-21	2016-12-31	All Paid	45	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
473	2016-10-21	2016-12-31	All Paid	46	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
433	2016-10-21	2016-12-31	All Paid	47	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
474	2016-10-21	2016-12-31	All Paid	48	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
434	2016-10-21	2016-12-31	All Paid	49	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
441	2016-10-21	2016-12-31	All Paid	50	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
185	2016-10-21	2016-12-31	All Paid	51	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
498	2016-10-21	2016-12-31	All Paid	52	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
435	2016-10-21	2016-12-31	All Paid	53	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
475	2016-10-21	2016-12-31	All Paid	54	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
476	2016-10-21	2016-12-31	All Paid	55	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
497	2016-10-21	2016-12-31	All Paid	56	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
444	2016-10-21	2016-12-31	All Paid	57	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
142	2016-10-21	2016-12-31	All Paid	58	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
440	2016-10-21	2016-12-31	All Paid	59	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
436	2016-10-21	2016-12-31	All Paid	60	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
445	2016-10-21	2016-12-31	All Paid	61	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
417	2016-10-21	2016-12-31	All Paid	62	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
437	2016-10-21	2016-12-31	All Paid	63	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
186	2016-10-21	2016-12-31	All Paid	64	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
454	2016-10-21	2016-12-31	All Paid	65	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
143	2016-10-21	2016-12-31	All Paid	66	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
477	2016-10-21	2016-12-31	All Paid	67	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
187	2016-10-21	2016-12-31	All Paid	68	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
484	2016-10-21	2016-12-31	All Paid	69	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
199	2016-10-21	2016-12-31	All Paid	70	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
489	2016-10-21	2016-12-31	All Paid	71	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
418	2016-10-21	2016-12-31	All Paid	72	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
446	2016-10-21	2016-12-31	All Paid	73	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
193	2016-10-21	2016-12-31	All Paid	74	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
198	2016-10-21	2016-12-31	All Paid	75	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
443	2016-10-21	2016-12-31	All Paid	76	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
448	2016-10-21	2016-12-31	All Paid	77	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
144	2016-10-21	2016-12-31	All Paid	78	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
493	2016-10-21	2016-12-31	All Paid	79	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
490	2016-10-21	2016-12-31	All Paid	80	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
178	2016-10-21	2016-12-31	All Paid	81	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
145	2016-10-21	2016-12-31	All Paid	82	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
450	2016-10-21	2016-12-31	All Paid	83	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
197	2016-10-21	2016-12-31	All Paid	84	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
453	2016-10-21	2016-12-31	All Paid	85	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
451	2016-10-21	2016-12-31	All Paid	86	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
419	2016-10-21	2016-12-31	All Paid	87	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
420	2016-10-21	2016-12-31	All Paid	88	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
421	2016-10-21	2016-12-31	All Paid	89	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
422	2016-10-21	2016-12-31	All Paid	90	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
194	2016-10-21	2016-12-31	All Paid	91	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
146	2016-10-21	2016-12-31	All Paid	92	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
190	2016-10-21	2016-12-31	All Paid	93	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
128	2016-10-21	2016-12-31	All Paid	94	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
483	2016-10-21	2016-12-31	All Paid	95	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
423	2016-10-21	2016-12-31	All Paid	96	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
424	2016-10-21	2016-12-31	All Paid	97	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
478	2016-10-21	2016-12-31	All Paid	98	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
425	2016-10-21	2016-12-31	All Paid	99	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
179	2016-10-21	2016-12-31	All Paid	100	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
485	2016-10-21	2016-12-31	All Paid	101	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
426	2016-10-21	2016-12-31	All Paid	102	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
495	2016-10-21	2016-12-31	All Paid	103	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
427	2016-10-21	2016-12-31	All Paid	104	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
188	2016-10-21	2016-12-31	All Paid	105	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
479	2016-10-21	2016-12-31	All Paid	106	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
492	2016-10-21	2016-12-31	All Paid	107	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
482	2016-10-21	2016-12-31	All Paid	108	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
147	2016-10-21	2016-12-31	All Paid	109	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
180	2016-10-21	2016-12-31	All Paid	110	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
148	2016-10-21	2016-12-31	All Paid	111	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
428	2016-10-21	2016-12-31	All Paid	112	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
447	2016-10-21	2016-12-31	All Paid	113	Application	20	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
181	2016-10-21	2016-12-31	All Paid	114	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
487	2016-10-21	2016-12-31	All Paid	115	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
460	2016-10-21	2016-12-31	All Paid	116	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
494	2016-10-21	2016-12-31	All Paid	117	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
461	2016-10-21	2016-12-31	All Paid	118	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
170	2016-10-21	2016-12-31	All Paid	119	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
488	2016-10-21	2016-12-31	All Paid	120	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
456	2016-10-21	2016-12-31	All Paid	121	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
439	2016-10-21	2016-12-31	All Paid	122	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
465	2016-10-21	2016-12-31	All Paid	123	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
466	2016-10-21	2016-12-31	All Paid	124	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
462	2016-10-21	2016-12-31	All Paid	125	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
97	2016-10-21	2016-12-31	All Paid	126	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
463	2016-10-21	2016-12-31	All Paid	127	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
464	2016-10-21	2016-12-31	All Paid	128	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
486	2016-10-21	2016-12-31	All Paid	129	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
171	2016-10-21	2016-12-31	All Paid	130	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
467	2016-10-21	2016-12-31	All Paid	131	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
413	2016-10-21	2016-12-31	All Paid	132	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
468	2016-10-21	2016-12-31	All Paid	133	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
469	2016-10-21	2016-12-31	All Paid	134	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
481	2016-10-21	2016-12-31	All Paid	135	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
480	2016-10-21	2016-12-31	All Paid	136	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
182	2016-10-21	2016-12-31	All Paid	137	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
455	2016-10-21	2016-12-31	All Paid	138	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
409	2016-10-21	2016-12-31	All Paid	139	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
172	2016-10-21	2016-12-31	All Paid	140	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
457	2016-10-21	2016-12-31	All Paid	141	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
414	2016-10-21	2016-12-31	All Paid	142	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
470	2016-10-21	2016-12-31	All Paid	143	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
183	2016-10-21	2016-12-31	All Paid	144	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
471	2016-10-21	2016-12-31	All Paid	145	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
472	2016-10-21	2016-12-31	All Paid	146	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
458	2016-10-21	2016-12-31	All Paid	147	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
173	2016-10-21	2016-12-31	All Paid	148	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
496	2016-10-21	2016-12-31	All Paid	149	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
491	2016-10-21	2016-12-31	All Paid	150	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
176	2016-10-21	2016-12-31	All Paid	151	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
415	2016-10-21	2016-12-31	All Paid	152	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
184	2016-10-21	2016-12-31	All Paid	153	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
416	2016-10-21	2016-12-31	All Paid	154	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
438	2016-10-21	2016-12-31	All Paid	155	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
429	2016-10-21	2016-12-31	All Paid	156	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
431	2016-10-21	2016-12-31	All Paid	157	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
432	2016-10-21	2016-12-31	All Paid	158	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
473	2016-10-21	2016-12-31	All Paid	159	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
433	2016-10-21	2016-12-31	All Paid	160	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
474	2016-10-21	2016-12-31	All Paid	161	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
434	2016-10-21	2016-12-31	All Paid	162	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
441	2016-10-21	2016-12-31	All Paid	163	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
185	2016-10-21	2016-12-31	All Paid	164	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
498	2016-10-21	2016-12-31	All Paid	165	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
435	2016-10-21	2016-12-31	All Paid	166	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
475	2016-10-21	2016-12-31	All Paid	167	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
476	2016-10-21	2016-12-31	All Paid	168	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
497	2016-10-21	2016-12-31	All Paid	169	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
444	2016-10-21	2016-12-31	All Paid	170	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
142	2016-10-21	2016-12-31	All Paid	171	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
440	2016-10-21	2016-12-31	All Paid	172	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
436	2016-10-21	2016-12-31	All Paid	173	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
445	2016-10-21	2016-12-31	All Paid	174	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
417	2016-10-21	2016-12-31	All Paid	175	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
437	2016-10-21	2016-12-31	All Paid	176	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
186	2016-10-21	2016-12-31	All Paid	177	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
454	2016-10-21	2016-12-31	All Paid	178	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
143	2016-10-21	2016-12-31	All Paid	179	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
477	2016-10-21	2016-12-31	All Paid	180	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
187	2016-10-21	2016-12-31	All Paid	181	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
484	2016-10-21	2016-12-31	All Paid	182	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
199	2016-10-21	2016-12-31	All Paid	183	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
489	2016-10-21	2016-12-31	All Paid	184	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
418	2016-10-21	2016-12-31	All Paid	185	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
446	2016-10-21	2016-12-31	All Paid	186	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
193	2016-10-21	2016-12-31	All Paid	187	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
198	2016-10-21	2016-12-31	All Paid	188	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
443	2016-10-21	2016-12-31	All Paid	189	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
448	2016-10-21	2016-12-31	All Paid	190	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
144	2016-10-21	2016-12-31	All Paid	191	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
493	2016-10-21	2016-12-31	All Paid	192	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
490	2016-10-21	2016-12-31	All Paid	193	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
178	2016-10-21	2016-12-31	All Paid	194	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
145	2016-10-21	2016-12-31	All Paid	195	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
450	2016-10-21	2016-12-31	All Paid	196	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
197	2016-10-21	2016-12-31	All Paid	197	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
453	2016-10-21	2016-12-31	All Paid	198	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
451	2016-10-21	2016-12-31	All Paid	199	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
419	2016-10-21	2016-12-31	All Paid	200	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
420	2016-10-21	2016-12-31	All Paid	201	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
421	2016-10-21	2016-12-31	All Paid	202	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
422	2016-10-21	2016-12-31	All Paid	203	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
194	2016-10-21	2016-12-31	All Paid	204	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
146	2016-10-21	2016-12-31	All Paid	205	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
190	2016-10-21	2016-12-31	All Paid	206	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
128	2016-10-21	2016-12-31	All Paid	207	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
483	2016-10-21	2016-12-31	All Paid	208	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
423	2016-10-21	2016-12-31	All Paid	209	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
424	2016-10-21	2016-12-31	All Paid	210	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
478	2016-10-21	2016-12-31	All Paid	211	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
425	2016-10-21	2016-12-31	All Paid	212	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
179	2016-10-21	2016-12-31	All Paid	213	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
485	2016-10-21	2016-12-31	All Paid	214	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
426	2016-10-21	2016-12-31	All Paid	215	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
495	2016-10-21	2016-12-31	All Paid	216	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
427	2016-10-21	2016-12-31	All Paid	217	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
188	2016-10-21	2016-12-31	All Paid	218	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
479	2016-10-21	2016-12-31	All Paid	219	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
492	2016-10-21	2016-12-31	All Paid	220	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
482	2016-10-21	2016-12-31	All Paid	221	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
147	2016-10-21	2016-12-31	All Paid	222	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
180	2016-10-21	2016-12-31	All Paid	223	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
148	2016-10-21	2016-12-31	All Paid	224	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
428	2016-10-21	2016-12-31	All Paid	225	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
447	2016-10-21	2016-12-31	All Paid	226	First Transcript	30	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
460	2016-10-21	2016-10-21	Jesuit Rate	227	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
494	2016-10-21	2016-10-21	Jesuit Rate	228	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
488	2016-10-21	2016-10-21	Jesuit Rate	229	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
456	2016-10-21	2016-10-21	Jesuit Rate	230	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
481	2016-10-21	2016-10-21	Jesuit Rate	231	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
455	2016-10-21	2016-10-21	Jesuit Rate	232	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
457	2016-10-21	2016-10-21	Jesuit Rate	233	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
496	2016-10-21	2016-10-21	Jesuit Rate	234	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
438	2016-10-21	2016-10-21	Jesuit Rate	235	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
498	2016-10-21	2016-10-21	Jesuit Rate	236	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
497	2016-10-21	2016-10-21	Jesuit Rate	237	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
199	2016-10-21	2016-10-21	Jesuit Rate	238	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
198	2016-10-21	2016-10-21	Jesuit Rate	239	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
197	2016-10-21	2016-10-21	Jesuit Rate	240	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
453	2016-10-21	2016-10-21	Jesuit Rate	241	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
451	2016-10-21	2016-10-21	Jesuit Rate	242	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
485	2016-10-21	2016-10-21	Jesuit Rate	243	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
495	2016-10-21	2016-10-21	Jesuit Rate	244	Semester 1 Tuition	3165	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
439	2016-10-21	2016-12-31	Lay Zimbabwe Rate	245	Semester 1 Tuition	1300	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
409	2016-10-21	2016-12-31	Lay Zimbabwe Rate	246	Semester 1 Tuition	1300	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
458	2016-10-21	2016-12-31	Lay Zimbabwe Rate	247	Semester 1 Tuition	1300	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
475	2016-10-21	2016-12-31	Lay Zimbabwe Rate	248	Semester 1 Tuition	1300	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
443	2016-10-21	2016-12-31	Lay Zimbabwe Rate	249	Semester 1 Tuition	1300	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
441	2016-10-21	2016-12-31	Non SJ Religious Rate	250	Semester 1 Tuition	2310	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
476	2016-10-21	2016-12-31	Non SJ Religious Rate	251	Semester 1 Tuition	2310	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
440	2016-10-21	2016-12-31	Non SJ Religious Rate	252	Semester 1 Tuition	2310	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
454	2016-10-21	2016-12-31	Non SJ Religious Rate	253	Semester 1 Tuition	2310	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
461	2016-10-21	2016-12-31	Jesuit Rate	254	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
465	2016-10-21	2016-12-31	Jesuit Rate	255	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
463	2016-10-21	2016-12-31	Jesuit Rate	256	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
413	2016-10-21	2016-12-31	Jesuit Rate	257	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
468	2016-10-21	2016-12-31	Jesuit Rate	258	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
469	2016-10-21	2016-12-31	Jesuit Rate	259	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
480	2016-10-21	2016-12-31	Jesuit Rate	260	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
414	2016-10-21	2016-12-31	Jesuit Rate	261	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
470	2016-10-21	2016-12-31	Jesuit Rate	262	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
471	2016-10-21	2016-12-31	Jesuit Rate	263	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
491	2016-10-21	2016-12-31	Jesuit Rate	264	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
415	2016-10-21	2016-12-31	Jesuit Rate	265	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
416	2016-10-21	2016-12-31	Jesuit Rate	266	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
417	2016-10-21	2016-12-31	Jesuit Rate	267	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
484	2016-10-21	2016-12-31	Jesuit Rate	268	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
489	2016-10-21	2016-12-31	Jesuit Rate	269	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
418	2016-10-21	2016-12-31	Jesuit Rate	270	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
493	2016-10-21	2016-12-31	Jesuit Rate	271	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
490	2016-10-21	2016-12-31	Jesuit Rate	272	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
419	2016-10-21	2016-12-31	Jesuit Rate	273	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
420	2016-10-21	2016-12-31	Jesuit Rate	274	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
421	2016-10-21	2016-12-31	Jesuit Rate	275	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
422	2016-10-21	2016-12-31	Jesuit Rate	276	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
483	2016-10-21	2016-12-31	Jesuit Rate	277	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
423	2016-10-21	2016-12-31	Jesuit Rate	278	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
424	2016-10-21	2016-12-31	Jesuit Rate	279	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
425	2016-10-21	2016-12-31	Jesuit Rate	280	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
427	2016-10-21	2016-12-31	Jesuit Rate	281	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
479	2016-10-21	2016-12-31	Jesuit Rate	282	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
492	2016-10-21	2016-12-31	Jesuit Rate	283	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
482	2016-10-21	2016-12-31	Jesuit Rate	284	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
428	2016-10-21	2016-12-31	Jesuit Rate	285	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
462	2016-10-21	2016-12-31	Non SJ Religious Rate	286	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
486	2016-10-21	2016-12-31	Non SJ Religious Rate	287	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
472	2016-10-21	2016-12-31	Non SJ Religious Rate	288	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
429	2016-10-21	2016-12-31	Non SJ Religious Rate	289	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
473	2016-10-21	2016-12-31	Non SJ Religious Rate	290	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
474	2016-10-21	2016-12-31	Non SJ Religious Rate	291	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
426	2016-10-21	2016-12-31	Zimbabwe Student	292	Semester 1 Tuition	1000	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
170	2016-10-21	2016-12-31	Jesuit Rate	293	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
171	2016-10-21	2016-12-31	Jesuit Rate	294	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
172	2016-10-21	2016-12-31	Jesuit Rate	295	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
173	2016-10-21	2016-12-31	Jesuit Rate	296	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
176	2016-10-21	2016-12-31	Jesuit Rate	297	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
142	2016-10-21	2016-12-31	Jesuit Rate	298	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
445	2016-10-21	2016-12-31	Jesuit Rate	299	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
143	2016-10-21	2016-12-31	Jesuit Rate	300	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
446	2016-10-21	2016-12-31	Jesuit Rate	301	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
193	2016-10-21	2016-12-31	Jesuit Rate	302	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
144	2016-10-21	2016-12-31	Jesuit Rate	303	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
178	2016-10-21	2016-12-31	Jesuit Rate	304	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
145	2016-10-21	2016-12-31	Jesuit Rate	305	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
450	2016-10-21	2016-12-31	Jesuit Rate	306	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
194	2016-10-21	2016-12-31	Jesuit Rate	307	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
146	2016-10-21	2016-12-31	Jesuit Rate	308	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
128	2016-10-21	2016-12-31	Jesuit Rate	309	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
179	2016-10-21	2016-12-31	Jesuit Rate	310	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
147	2016-10-21	2016-12-31	Jesuit Rate	311	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
180	2016-10-21	2016-12-31	Jesuit Rate	312	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
148	2016-10-21	2016-12-31	Jesuit Rate	313	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
447	2016-10-21	2016-12-31	Non SJ Religious 	314	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
448	2016-10-21	2016-12-31	Zimbabwe Student	315	Semester 1 Tuition	1000	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
466	2016-10-21	2016-12-31	Non SJ Religious	316	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
464	2016-10-21	2016-12-31	Non SJ Religious	317	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
467	2016-10-21	2016-12-31	Non SJ Religious	318	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
182	2016-10-21	2016-12-31	Non SJ Religious	319	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
183	2016-10-21	2016-12-31	Non SJ Religious	320	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
431	2016-10-21	2016-12-31	Non SJ Religious	321	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
432	2016-10-21	2016-12-31	Non SJ Religious	322	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
433	2016-10-21	2016-12-31	Non SJ Religious	323	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
434	2016-10-21	2016-12-31	Non SJ Religious	324	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
185	2016-10-21	2016-12-31	Non SJ Religious	325	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
435	2016-10-21	2016-12-31	Non SJ Religious	326	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
436	2016-10-21	2016-12-31	Non SJ Religious	327	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
437	2016-10-21	2016-12-31	Non SJ Religious	328	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
186	2016-10-21	2016-12-31	Non SJ Religious	329	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
477	2016-10-21	2016-12-31	Non SJ Religious	330	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
187	2016-10-21	2016-12-31	Non SJ Religious	331	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
190	2016-10-21	2016-12-31	Non SJ Religious	332	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
188	2016-10-21	2016-12-31	Non SJ Religious	333	Semester 1 Tuition	1955	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
181	2016-10-21	2016-12-31	Jesuit Rate	334	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
487	2016-10-21	2016-12-31	Jesuit Rate	335	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
184	2016-10-21	2016-12-31	Jesuit Rate	336	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
478	2016-10-21	2016-12-31	Jesuit Rate	337	Semester 1 Tuition	2690	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
181	2016-10-21	2016-12-31	Lunch Flate Rate	338	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
487	2016-10-21	2016-12-31	Lunch Flate Rate	339	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
460	2016-10-21	2016-12-31	Lunch Flate Rate	340	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
494	2016-10-21	2016-12-31	Lunch Flate Rate	341	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
461	2016-10-21	2016-12-31	Lunch Flate Rate	342	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
170	2016-10-21	2016-12-31	Lunch Flate Rate	343	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
488	2016-10-21	2016-12-31	Lunch Flate Rate	344	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
456	2016-10-21	2016-12-31	Lunch Flate Rate	345	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
439	2016-10-21	2016-12-31	Lunch Flate Rate	346	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
465	2016-10-21	2016-12-31	Lunch Flate Rate	347	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
466	2016-10-21	2016-12-31	Lunch Flate Rate	348	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
462	2016-10-21	2016-12-31	Lunch Flate Rate	349	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
97	2016-10-21	2016-12-31	Lunch Flate Rate	350	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
463	2016-10-21	2016-12-31	Lunch Flate Rate	351	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
464	2016-10-21	2016-12-31	Lunch Flate Rate	352	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
486	2016-10-21	2016-12-31	Lunch Flate Rate	353	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
171	2016-10-21	2016-12-31	Lunch Flate Rate	354	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
467	2016-10-21	2016-12-31	Lunch Flate Rate	355	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
413	2016-10-21	2016-12-31	Lunch Flate Rate	356	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
468	2016-10-21	2016-12-31	Lunch Flate Rate	357	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
469	2016-10-21	2016-12-31	Lunch Flate Rate	358	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
481	2016-10-21	2016-12-31	Lunch Flate Rate	359	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
480	2016-10-21	2016-12-31	Lunch Flate Rate	360	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
182	2016-10-21	2016-12-31	Lunch Flate Rate	361	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
455	2016-10-21	2016-12-31	Lunch Flate Rate	362	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
409	2016-10-21	2016-12-31	Lunch Flate Rate	363	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
172	2016-10-21	2016-12-31	Lunch Flate Rate	364	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
457	2016-10-21	2016-12-31	Lunch Flate Rate	365	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
414	2016-10-21	2016-12-31	Lunch Flate Rate	366	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
470	2016-10-21	2016-12-31	Lunch Flate Rate	367	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
183	2016-10-21	2016-12-31	Lunch Flate Rate	368	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
471	2016-10-21	2016-12-31	Lunch Flate Rate	369	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
472	2016-10-21	2016-12-31	Lunch Flate Rate	370	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
458	2016-10-21	2016-12-31	Lunch Flate Rate	371	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
173	2016-10-21	2016-12-31	Lunch Flate Rate	372	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
496	2016-10-21	2016-12-31	Lunch Flate Rate	373	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
491	2016-10-21	2016-12-31	Lunch Flate Rate	374	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
176	2016-10-21	2016-12-31	Lunch Flate Rate	375	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
415	2016-10-21	2016-12-31	Lunch Flate Rate	376	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
184	2016-10-21	2016-12-31	Lunch Flate Rate	377	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
416	2016-10-21	2016-12-31	Lunch Flate Rate	378	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
438	2016-10-21	2016-12-31	Lunch Flate Rate	379	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
429	2016-10-21	2016-12-31	Lunch Flate Rate	380	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
431	2016-10-21	2016-12-31	Lunch Flate Rate	381	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
432	2016-10-21	2016-12-31	Lunch Flate Rate	382	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
473	2016-10-21	2016-12-31	Lunch Flate Rate	383	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
433	2016-10-21	2016-12-31	Lunch Flate Rate	384	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
474	2016-10-21	2016-12-31	Lunch Flate Rate	385	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
434	2016-10-21	2016-12-31	Lunch Flate Rate	386	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
441	2016-10-21	2016-12-31	Lunch Flate Rate	387	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
185	2016-10-21	2016-12-31	Lunch Flate Rate	388	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
498	2016-10-21	2016-12-31	Lunch Flate Rate	389	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
435	2016-10-21	2016-12-31	Lunch Flate Rate	390	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
475	2016-10-21	2016-12-31	Lunch Flate Rate	391	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
476	2016-10-21	2016-12-31	Lunch Flate Rate	392	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
497	2016-10-21	2016-12-31	Lunch Flate Rate	393	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
444	2016-10-21	2016-12-31	Lunch Flate Rate	394	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
142	2016-10-21	2016-12-31	Lunch Flate Rate	395	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
440	2016-10-21	2016-12-31	Lunch Flate Rate	396	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
436	2016-10-21	2016-12-31	Lunch Flate Rate	397	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
445	2016-10-21	2016-12-31	Lunch Flate Rate	398	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
417	2016-10-21	2016-12-31	Lunch Flate Rate	399	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
437	2016-10-21	2016-12-31	Lunch Flate Rate	400	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
186	2016-10-21	2016-12-31	Lunch Flate Rate	401	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
454	2016-10-21	2016-12-31	Lunch Flate Rate	402	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
143	2016-10-21	2016-12-31	Lunch Flate Rate	403	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
477	2016-10-21	2016-12-31	Lunch Flate Rate	404	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
187	2016-10-21	2016-12-31	Lunch Flate Rate	405	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
484	2016-10-21	2016-12-31	Lunch Flate Rate	406	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
199	2016-10-21	2016-12-31	Lunch Flate Rate	407	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
489	2016-10-21	2016-12-31	Lunch Flate Rate	408	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
418	2016-10-21	2016-12-31	Lunch Flate Rate	409	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
446	2016-10-21	2016-12-31	Lunch Flate Rate	410	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
193	2016-10-21	2016-12-31	Lunch Flate Rate	411	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
198	2016-10-21	2016-12-31	Lunch Flate Rate	412	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
443	2016-10-21	2016-12-31	Lunch Flate Rate	413	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
448	2016-10-21	2016-12-31	Lunch Flate Rate	414	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
144	2016-10-21	2016-12-31	Lunch Flate Rate	415	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
493	2016-10-21	2016-12-31	Lunch Flate Rate	416	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
490	2016-10-21	2016-12-31	Lunch Flate Rate	417	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
178	2016-10-21	2016-12-31	Lunch Flate Rate	418	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
145	2016-10-21	2016-12-31	Lunch Flate Rate	419	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
450	2016-10-21	2016-12-31	Lunch Flate Rate	420	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
197	2016-10-21	2016-12-31	Lunch Flate Rate	421	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
453	2016-10-21	2016-12-31	Lunch Flate Rate	422	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
451	2016-10-21	2016-12-31	Lunch Flate Rate	423	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
419	2016-10-21	2016-12-31	Lunch Flate Rate	424	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
420	2016-10-21	2016-12-31	Lunch Flate Rate	425	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
421	2016-10-21	2016-12-31	Lunch Flate Rate	426	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
422	2016-10-21	2016-12-31	Lunch Flate Rate	427	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
194	2016-10-21	2016-12-31	Lunch Flate Rate	428	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
146	2016-10-21	2016-12-31	Lunch Flate Rate	429	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
190	2016-10-21	2016-12-31	Lunch Flate Rate	430	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
128	2016-10-21	2016-12-31	Lunch Flate Rate	431	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
483	2016-10-21	2016-12-31	Lunch Flate Rate	432	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
423	2016-10-21	2016-12-31	Lunch Flate Rate	433	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
424	2016-10-21	2016-12-31	Lunch Flate Rate	434	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
478	2016-10-21	2016-12-31	Lunch Flate Rate	435	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
425	2016-10-21	2016-12-31	Lunch Flate Rate	436	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
179	2016-10-21	2016-12-31	Lunch Flate Rate	437	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
485	2016-10-21	2016-12-31	Lunch Flate Rate	438	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
426	2016-10-21	2016-12-31	Lunch Flate Rate	439	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
495	2016-10-21	2016-12-31	Lunch Flate Rate	440	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
427	2016-10-21	2016-12-31	Lunch Flate Rate	441	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
188	2016-10-21	2016-12-31	Lunch Flate Rate	442	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
479	2016-10-21	2016-12-31	Lunch Flate Rate	443	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
492	2016-10-21	2016-12-31	Lunch Flate Rate	444	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
482	2016-10-21	2016-12-31	Lunch Flate Rate	445	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
147	2016-10-21	2016-12-31	Lunch Flate Rate	446	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
180	2016-10-21	2016-12-31	Lunch Flate Rate	447	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
148	2016-10-21	2016-12-31	Lunch Flate Rate	448	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
428	2016-10-21	2016-12-31	Lunch Flate Rate	449	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
447	2016-10-21	2016-12-31	Lunch Flate Rate	450	Lunch Fees	250	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
460	2016-10-21	2016-12-31	Jesuit Rate	451	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
494	2016-10-21	2016-12-31	Jesuit Rate	452	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
488	2016-10-21	2016-12-31	Jesuit Rate	453	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
456	2016-10-21	2016-12-31	Jesuit Rate	454	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
481	2016-10-21	2016-12-31	Jesuit Rate	455	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
455	2016-10-21	2016-12-31	Jesuit Rate	456	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
457	2016-10-21	2016-12-31	Jesuit Rate	457	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
496	2016-10-21	2016-12-31	Jesuit Rate	458	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
438	2016-10-21	2016-12-31	Jesuit Rate	459	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
498	2016-10-21	2016-12-31	Jesuit Rate	460	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
497	2016-10-21	2016-12-31	Jesuit Rate	461	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
199	2016-10-21	2016-12-31	Jesuit Rate	462	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
198	2016-10-21	2016-12-31	Jesuit Rate	463	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
443	2016-10-21	2016-12-31	Jesuit Rate	464	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
197	2016-10-21	2016-12-31	Jesuit Rate	465	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
453	2016-10-21	2016-12-31	Jesuit Rate	466	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
451	2016-10-21	2016-12-31	Jesuit Rate	467	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
485	2016-10-21	2016-12-31	Jesuit Rate	468	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
495	2016-10-21	2016-12-31	Jesuit Rate	469	MA Library Fee	235	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
439	2016-10-21	2016-12-31	Non SJ R. Rate	470	MA Library Fee	180	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
409	2016-10-21	2016-12-31	Non SJ R. Rate	471	MA Library Fee	180	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
458	2016-10-21	2016-12-31	Non SJ R. Rate	472	MA Library Fee	180	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
441	2016-10-21	2016-12-31	Non SJ R. Rate	473	MA Library Fee	180	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
475	2016-10-21	2016-12-31	Non SJ R. Rate	474	MA Library Fee	180	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
476	2016-10-21	2016-12-31	Non SJ R. Rate	475	MA Library Fee	180	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
440	2016-10-21	2016-12-31	Non SJ R. Rate	476	MA Library Fee	180	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
454	2016-10-21	2016-12-31	Non SJ R. Rate	477	MA Library Fee	180	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
461	2016-10-21	2016-12-31	Jesuit Rate	478	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
170	2016-10-21	2016-12-31	Jesuit Rate	479	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
465	2016-10-21	2016-12-31	Jesuit Rate	480	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
463	2016-10-21	2016-12-31	Jesuit Rate	481	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
171	2016-10-21	2016-12-31	Jesuit Rate	482	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
413	2016-10-21	2016-12-31	Jesuit Rate	483	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
468	2016-10-21	2016-12-31	Jesuit Rate	484	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
469	2016-10-21	2016-12-31	Jesuit Rate	485	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
480	2016-10-21	2016-12-31	Jesuit Rate	486	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
172	2016-10-21	2016-12-31	Jesuit Rate	487	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
414	2016-10-21	2016-12-31	Jesuit Rate	488	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
470	2016-10-21	2016-12-31	Jesuit Rate	489	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
471	2016-10-21	2016-12-31	Jesuit Rate	490	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
173	2016-10-21	2016-12-31	Jesuit Rate	491	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
491	2016-10-21	2016-12-31	Jesuit Rate	492	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
176	2016-10-21	2016-12-31	Jesuit Rate	493	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
415	2016-10-21	2016-12-31	Jesuit Rate	494	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
416	2016-10-21	2016-12-31	Jesuit Rate	495	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
142	2016-10-21	2016-12-31	Jesuit Rate	496	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
445	2016-10-21	2016-12-31	Jesuit Rate	497	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
417	2016-10-21	2016-12-31	Jesuit Rate	498	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
143	2016-10-21	2016-12-31	Jesuit Rate	499	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
484	2016-10-21	2016-12-31	Jesuit Rate	500	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
489	2016-10-21	2016-12-31	Jesuit Rate	501	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
418	2016-10-21	2016-12-31	Jesuit Rate	502	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
446	2016-10-21	2016-12-31	Jesuit Rate	503	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
193	2016-10-21	2016-12-31	Jesuit Rate	504	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
448	2016-10-21	2016-12-31	Jesuit Rate	505	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
144	2016-10-21	2016-12-31	Jesuit Rate	506	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
493	2016-10-21	2016-12-31	Jesuit Rate	507	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
490	2016-10-21	2016-12-31	Jesuit Rate	508	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
178	2016-10-21	2016-12-31	Jesuit Rate	509	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
145	2016-10-21	2016-12-31	Jesuit Rate	510	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
450	2016-10-21	2016-12-31	Jesuit Rate	511	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
419	2016-10-21	2016-12-31	Jesuit Rate	512	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
420	2016-10-21	2016-12-31	Jesuit Rate	513	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
421	2016-10-21	2016-12-31	Jesuit Rate	514	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
422	2016-10-21	2016-12-31	Jesuit Rate	515	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
194	2016-10-21	2016-12-31	Jesuit Rate	516	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
146	2016-10-21	2016-12-31	Jesuit Rate	517	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
128	2016-10-21	2016-12-31	Jesuit Rate	518	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
483	2016-10-21	2016-12-31	Jesuit Rate	519	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
423	2016-10-21	2016-12-31	Jesuit Rate	520	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
424	2016-10-21	2016-12-31	Jesuit Rate	521	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
425	2016-10-21	2016-12-31	Jesuit Rate	522	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
179	2016-10-21	2016-12-31	Jesuit Rate	523	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
427	2016-10-21	2016-12-31	Jesuit Rate	524	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
479	2016-10-21	2016-12-31	Jesuit Rate	525	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
492	2016-10-21	2016-12-31	Jesuit Rate	526	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
482	2016-10-21	2016-12-31	Jesuit Rate	527	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
147	2016-10-21	2016-12-31	Jesuit Rate	528	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
180	2016-10-21	2016-12-31	Jesuit Rate	529	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
148	2016-10-21	2016-12-31	Jesuit Rate	530	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
428	2016-10-21	2016-12-31	Jesuit Rate	531	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
181	2016-10-21	2016-12-31	Jesuit Rate	532	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
487	2016-10-21	2016-12-31	Jesuit Rate	533	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
184	2016-10-21	2016-12-31	Jesuit Rate	534	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
478	2016-10-21	2016-12-31	Jesuit Rate	535	BA Library Fee	200	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
466	2016-10-21	2016-12-31	Non SJ Library	536	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
464	2016-10-21	2016-12-31	Non SJ Library	537	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
467	2016-10-21	2016-12-31	Non SJ Library	538	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
182	2016-10-21	2016-12-31	Non SJ Library	539	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
183	2016-10-21	2016-12-31	Non SJ Library	540	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
431	2016-10-21	2016-12-31	Non SJ Library	541	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
432	2016-10-21	2016-12-31	Non SJ Library	542	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
433	2016-10-21	2016-12-31	Non SJ Library	543	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
434	2016-10-21	2016-12-31	Non SJ Library	544	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
185	2016-10-21	2016-12-31	Non SJ Library	545	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
435	2016-10-21	2016-12-31	Non SJ Library	546	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
436	2016-10-21	2016-12-31	Non SJ Library	547	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
437	2016-10-21	2016-12-31	Non SJ Library	548	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
186	2016-10-21	2016-12-31	Non SJ Library	549	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
477	2016-10-21	2016-12-31	Non SJ Library	550	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
187	2016-10-21	2016-12-31	Non SJ Library	551	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
190	2016-10-21	2016-12-31	Non SJ Library	552	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
188	2016-10-21	2016-12-31	Non SJ Library	553	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
462	2016-10-21	2016-12-31	Non SJ Library Fee	554	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
486	2016-10-21	2016-12-31	Non SJ Library Fee	555	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
472	2016-10-21	2016-12-31	Non SJ Library Fee	556	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
544	2020-08-22	\N	yy	671	dd	500	3	2019	\N	\N	N	500	\N	0	\N	\N
429	2016-10-21	2016-12-31	Non SJ Library Fee	557	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
473	2016-10-21	2016-12-31	Non SJ Library Fee	558	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
474	2016-10-21	2016-12-31	Non SJ Library Fee	559	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
426	2016-10-21	2016-12-31	Non SJ Library Fee	560	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
447	2016-10-21	2016-12-31	Non SJ Library Fee	561	BA Library Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
461	2016-10-21	2016-12-31	Jesuit Rate	562	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
170	2016-10-21	2016-12-31	Jesuit Rate	563	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
465	2016-10-21	2016-12-31	Jesuit Rate	564	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
463	2016-10-21	2016-12-31	Jesuit Rate	565	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
171	2016-10-21	2016-12-31	Jesuit Rate	566	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
413	2016-10-21	2016-12-31	Jesuit Rate	567	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
468	2016-10-21	2016-12-31	Jesuit Rate	568	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
469	2016-10-21	2016-12-31	Jesuit Rate	569	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
480	2016-10-21	2016-12-31	Jesuit Rate	570	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
172	2016-10-21	2016-12-31	Jesuit Rate	571	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
414	2016-10-21	2016-12-31	Jesuit Rate	572	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
470	2016-10-21	2016-12-31	Jesuit Rate	573	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
471	2016-10-21	2016-12-31	Jesuit Rate	574	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
173	2016-10-21	2016-12-31	Jesuit Rate	575	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
491	2016-10-21	2016-12-31	Jesuit Rate	576	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
176	2016-10-21	2016-12-31	Jesuit Rate	577	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
415	2016-10-21	2016-12-31	Jesuit Rate	578	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
416	2016-10-21	2016-12-31	Jesuit Rate	579	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
142	2016-10-21	2016-12-31	Jesuit Rate	580	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
445	2016-10-21	2016-12-31	Jesuit Rate	581	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
417	2016-10-21	2016-12-31	Jesuit Rate	582	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
143	2016-10-21	2016-12-31	Jesuit Rate	583	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
484	2016-10-21	2016-12-31	Jesuit Rate	584	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
489	2016-10-21	2016-12-31	Jesuit Rate	585	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
418	2016-10-21	2016-12-31	Jesuit Rate	586	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
446	2016-10-21	2016-12-31	Jesuit Rate	587	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
193	2016-10-21	2016-12-31	Jesuit Rate	588	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
448	2016-10-21	2016-12-31	Jesuit Rate	589	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
144	2016-10-21	2016-12-31	Jesuit Rate	590	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
493	2016-10-21	2016-12-31	Jesuit Rate	591	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
490	2016-10-21	2016-12-31	Jesuit Rate	592	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
178	2016-10-21	2016-12-31	Jesuit Rate	593	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
145	2016-10-21	2016-12-31	Jesuit Rate	594	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
450	2016-10-21	2016-12-31	Jesuit Rate	595	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
419	2016-10-21	2016-12-31	Jesuit Rate	596	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
420	2016-10-21	2016-12-31	Jesuit Rate	597	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
421	2016-10-21	2016-12-31	Jesuit Rate	598	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
422	2016-10-21	2016-12-31	Jesuit Rate	599	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
194	2016-10-21	2016-12-31	Jesuit Rate	600	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
146	2016-10-21	2016-12-31	Jesuit Rate	601	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
128	2016-10-21	2016-12-31	Jesuit Rate	602	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
483	2016-10-21	2016-12-31	Jesuit Rate	603	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
423	2016-10-21	2016-12-31	Jesuit Rate	604	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
424	2016-10-21	2016-12-31	Jesuit Rate	605	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
425	2016-10-21	2016-12-31	Jesuit Rate	606	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
179	2016-10-21	2016-12-31	Jesuit Rate	607	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
427	2016-10-21	2016-12-31	Jesuit Rate	608	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
479	2016-10-21	2016-12-31	Jesuit Rate	609	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
492	2016-10-21	2016-12-31	Jesuit Rate	610	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
482	2016-10-21	2016-12-31	Jesuit Rate	611	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
147	2016-10-21	2016-12-31	Jesuit Rate	612	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
180	2016-10-21	2016-12-31	Jesuit Rate	613	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
148	2016-10-21	2016-12-31	Jesuit Rate	614	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
428	2016-10-21	2016-12-31	Jesuit Rate	615	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
462	2016-10-21	2016-12-31	Student Association Non SJ	616	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
472	2016-10-21	2016-12-31	Student Association Non SJ	617	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
429	2016-10-21	2016-12-31	Student Association Non SJ	618	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
473	2016-10-21	2016-12-31	Student Association Non SJ	619	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
474	2016-10-21	2016-12-31	Student Association Non SJ	620	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
426	2016-10-21	2016-12-31	Student Association Non SJ	621	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
447	2016-10-21	2016-12-31	Student Association Non SJ	622	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
466	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	623	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
464	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	624	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
467	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	625	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
182	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	626	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
183	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	627	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
431	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	628	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
432	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	629	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
433	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	630	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
434	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	631	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
185	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	632	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
435	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	633	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
436	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	634	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
437	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	635	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
186	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	636	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
477	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	637	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
187	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	638	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
190	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	639	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
188	2016-10-21	2016-12-31	Student Association Fee Non SJ Rate	640	Student Association Fee	135	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
181	2016-10-21	2016-12-31	Student Association Jesuit Rate	641	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
487	2016-10-21	2016-12-31	Student Association Jesuit Rate	642	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
184	2016-10-21	2016-12-31	Student Association Jesuit Rate	643	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
478	2016-10-21	2016-12-31	Student Association Jesuit Rate	644	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
460	2016-10-21	2016-12-31	Jesuit Rate	645	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
494	2016-10-21	2016-12-31	Jesuit Rate	646	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
488	2016-10-21	2016-12-31	Jesuit Rate	647	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
456	2016-10-21	2016-12-31	Jesuit Rate	648	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
481	2016-10-21	2016-12-31	Jesuit Rate	649	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
455	2016-10-21	2016-12-31	Jesuit Rate	650	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
457	2016-10-21	2016-12-31	Jesuit Rate	651	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
496	2016-10-21	2016-12-31	Jesuit Rate	652	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
438	2016-10-21	2016-12-31	Jesuit Rate	653	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
498	2016-10-21	2016-12-31	Jesuit Rate	654	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
497	2016-10-21	2016-12-31	Jesuit Rate	655	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
199	2016-10-21	2016-12-31	Jesuit Rate	656	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
198	2016-10-21	2016-12-31	Jesuit Rate	657	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
443	2016-10-21	2016-12-31	Jesuit Rate	658	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
197	2016-10-21	2016-12-31	Jesuit Rate	659	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
453	2016-10-21	2016-12-31	Jesuit Rate	660	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
451	2016-10-21	2016-12-31	Jesuit Rate	661	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
485	2016-10-21	2016-12-31	Jesuit Rate	662	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
495	2016-10-21	2016-12-31	Jesuit Rate	663	Student Association Fee	170	3	2016	\N	\N	\N	\N	\N	\N	\N	\N
494	2017-12-29	2019-12-31	Dec 2017	664	Late Fees	20.00	3	2017	\N	\N	N	20	\N	-3870	\N	5
492	2017-12-29	2020-12-31	Dec 2017	665	Late Fees	20.00	3	2017	\N	\N	N	20	\N	-3360	\N	5
473	2017-12-29	2019-12-31	Dec 2017	666	Over registration	20.00	3	2017	\N	\N	N	20	\N	-2525	\N	6
459	2018-01-03	2018-12-31	\N	667	Late Fees	20.00	3	2017	\N	\N	N	20	\N	0	\N	5
459	2018-01-14	2018-01-12	\N	668	Late Fees	20.00	3	2017	\N	\N	N	20	\N	-20	\N	5
455	2018-01-14	2018-01-12	\N	669	Late Fees	20.00	3	2017	\N	\N	N	20	\N	-3870	\N	5
417	2018-08-07	2019-06-01	Regalia Dues	670	Student Association	217	3	2018	\N	\N	N	217	\N	-3360	\N	3
595	2020-08-22	\N	\N	673	1	20000	3	2019	\N	\N	N	20000	\N	0	\N	\N
\.


--
-- Data for Name: billing_student_fees_categories; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.billing_student_fees_categories (id, school_year, school_id, title, system_name) FROM stdin;
1	2016	3	Tuition	other
2	2016	3	Library Fees	other
3	2016	3	Student Association Fee	other
4	2016	3	Meals	sms
5	2017	3	Late Registration	other
6	2017	3	Over-registration	other
\.


--
-- Data for Name: billing_student_fees_old; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.billing_student_fees_old (id, category_id, school_year, school_id, title, amount, apply_all, classlevel_id, course_id, course_credit_title, activity_id, student_field_id, student_field_value, student_id, waived_fee_id) FROM stdin;
\.


--
-- Data for Name: billing_student_payments; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.billing_student_payments (id, school_year, school_id, student_id, amount, payment_date, comments, refunded_payment_id, lunch_payment, transaction_id, cancellation) FROM stdin;
\.


--
-- Data for Name: block_ip; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.block_ip (id, faled_login, time_unlock, ip, date, failed_login) FROM stdin;
888	\N	\N	41.175.82.97	2019-08-16	2
866	\N	\N	105.178.108.78	2019-08-13	5
838	\N	\N	41.175.65.78	2019-08-08	5
867	\N	\N	105.178.112.105	2019-08-13	2
815	\N	\N	197.221.254.226	2019-05-22	1
816	\N	\N	197.221.254.136	2019-05-26	2
817	\N	\N	107.167.107.140	2019-05-28	1
818	\N	\N	154.119.81.206	2019-05-30	2
819	\N	\N	41.63.14.10	2019-06-07	2
820	\N	\N	154.117.216.245	2019-06-11	2
821	\N	\N	102.128.76.22	2019-06-26	1
822	\N	\N	196.248.39.245	2019-07-02	1
868	\N	\N	105.178.112.139	2019-08-13	2
869	\N	\N	105.178.112.90	2019-08-13	1
870	\N	\N	41.175.139.105	2019-08-13	1
872	\N	\N	41.175.85.173	2019-08-14	1
839	\N	\N	196.27.120.18	2019-08-09	9
884	\N	\N	41.175.70.99	2019-08-16	2
823	\N	2019-07-13 21:53:16	107.167.116.94	2019-07-13	\N
824	\N	\N	154.119.81.206	2019-07-18	3
825	\N	\N	154.119.81.206	2019-07-21	1
826	\N	\N	77.246.53.162	2019-07-21	1
827	\N	\N	197.136.148.174	2019-07-24	1
828	\N	\N	41.190.30.203	2019-07-25	1
829	\N	\N	41.60.123.94	2019-08-06	1
841	\N	\N	196.2.14.137	2019-08-09	1
890	\N	\N	154.119.81.206	2019-08-17	1
842	\N	\N	41.60.102.194	2019-08-09	3
843	\N	\N	41.60.77.189	2019-08-09	1
844	\N	\N	196.27.120.18	2019-08-10	1
833	\N	\N	41.175.77.199	2019-08-07	1
845	\N	\N	196.27.120.18	2019-08-11	4
832	\N	\N	154.119.81.206	2019-08-07	3
834	\N	\N	41.60.100.57	2019-08-07	2
922	\N	\N	196.27.117.134	2019-09-20	1
891	\N	\N	41.175.130.151	2019-08-17	3
830	\N	\N	196.27.120.18	2019-08-07	\N
892	\N	\N	95.174.65.19	2019-08-18	2
835	\N	\N	41.175.78.253	2019-08-07	7
846	\N	\N	41.60.103.73	2019-08-11	7
836	\N	\N	196.27.120.18	2019-08-08	4
893	\N	\N	41.60.118.217	2019-08-18	1
847	\N	\N	41.60.85.225	2019-08-11	3
848	\N	\N	82.16.59.135	2019-08-11	1
894	\N	\N	41.175.74.87	2019-08-18	1
849	\N	\N	41.60.107.49	2019-08-12	4
850	\N	\N	197.218.83.27	2019-08-12	1
851	\N	\N	41.60.88.38	2019-08-12	4
898	\N	\N	107.167.109.168	2019-08-19	1
854	\N	\N	41.60.64.10	2019-08-13	3
855	\N	\N	107.181.177.141	2019-08-13	1
856	\N	\N	41.60.107.49	2019-08-13	1
873	\N	\N	196.27.120.18	2019-08-14	9
897	\N	\N	196.27.120.18	2019-08-19	4
874	\N	\N	41.191.239.112	2019-08-14	10
857	\N	\N	41.60.88.38	2019-08-13	7
853	\N	\N	41.60.111.252	2019-08-13	3
858	\N	\N	41.78.78.26	2019-08-13	1
859	\N	\N	41.60.64.156	2019-08-13	5
860	\N	\N	77.246.49.33	2019-08-13	1
862	\N	\N	41.175.95.152	2019-08-13	1
863	\N	\N	154.119.81.206	2019-08-13	3
865	\N	\N	105.178.108.219	2019-08-13	2
905	\N	\N	197.136.148.174	2019-08-21	4
906	\N	\N	196.27.120.18	2019-08-22	1
876	\N	\N	41.60.87.64	2019-08-14	6
877	\N	\N	41.60.126.194	2019-08-14	1
878	\N	\N	41.175.66.218	2019-08-14	1
879	\N	\N	196.27.120.18	2019-08-15	3
880	\N	\N	102.128.76.13	2019-08-15	1
915	\N	\N	196.27.120.7	2019-08-30	2
899	\N	\N	77.246.53.135	2019-08-19	7
900	\N	\N	45.92.32.4	2019-08-19	1
916	\N	\N	41.60.115.198	2019-09-01	1
882	\N	\N	41.175.77.49	2019-08-15	1
881	\N	\N	154.119.81.206	2019-08-15	8
886	\N	\N	154.119.81.206	2019-08-16	1
887	\N	\N	41.60.127.39	2019-08-16	1
908	\N	\N	196.27.120.7	2019-08-28	4
917	\N	\N	196.27.120.7	2019-09-02	1
902	\N	\N	41.60.119.177	2019-08-20	1
909	\N	\N	77.246.50.116	2019-08-29	3
903	\N	\N	41.175.87.102	2019-08-21	3
910	\N	\N	197.211.240.177	2019-08-29	3
911	\N	\N	196.27.120.7	2019-08-29	1
912	\N	\N	41.78.120.196	2019-08-30	1
913	\N	\N	41.78.120.197	2019-08-30	1
927	\N	\N	41.175.73.46	2019-10-02	1
923	\N	\N	84.11.86.194	2019-09-25	4
918	\N	\N	197.180.116.208	2019-09-05	3
919	\N	\N	196.27.120.7	2019-09-09	1
920	\N	\N	154.119.81.206	2019-09-17	2
921	\N	\N	41.175.75.124	2019-09-19	1
924	\N	\N	196.27.120.7	2019-09-26	1
929	\N	\N	196.27.120.7	2019-10-13	1
930	\N	\N	196.27.120.12	2019-10-21	1
982	\N	\N	196.27.120.12	2020-01-09	2
934	\N	\N	197.211.240.177	2019-10-30	3
935	\N	\N	41.60.98.91	2019-11-10	3
936	\N	\N	41.84.132.134	2019-11-14	3
938	\N	\N	138.197.133.117	2019-11-20	1
939	\N	\N	197.221.254.183	2019-11-23	3
983	\N	\N	154.119.81.206	2020-01-10	6
987	\N	\N	41.60.70.241	2020-01-11	1
941	\N	\N	41.60.111.127	2019-12-06	2
1082	\N	\N	41.60.125.77	2020-05-26	2
1085	\N	\N	102.177.195.86	2020-06-01	1
1088	\N	\N	41.174.174.194	2020-06-04	2
1091	\N	\N	102.128.79.53	2020-06-18	3
944	\N	\N	154.120.229.78	2019-12-10	1
945	\N	\N	197.221.254.235	2019-12-10	1
946	\N	\N	41.175.158.194	2019-12-10	1
995	\N	\N	154.119.81.206	2020-01-16	4
996	\N	\N	154.119.81.206	2020-01-17	1
947	\N	\N	41.60.90.27	2019-12-10	6
948	\N	\N	196.27.120.12	2019-12-11	2
949	\N	\N	154.119.81.81	2019-12-16	2
950	\N	\N	41.60.125.185	2019-12-19	4
952	\N	\N	41.60.127.66	2019-12-26	5
953	\N	\N	41.60.100.5	2020-01-01	1
980	\N	2020-01-08 12:51:45	41.175.64.47	2020-01-08	\N
955	\N	\N	41.60.106.197	2020-01-01	2
956	\N	\N	197.221.253.8	2020-01-02	2
957	\N	\N	197.155.239.142	2020-01-02	1
958	\N	\N	41.60.81.252	2020-01-02	2
959	\N	\N	41.60.68.179	2020-01-02	1
979	\N	2020-02-06 23:00:03	197.211.209.123	2020-01-08	\N
852	\N	2020-02-06 23:00:03	197.211.209.123	2019-08-12	\N
1094	\N	\N	82.145.208.93	2020-06-26	2
1097	\N	\N	209.88.92.222	2020-06-27	3
1100	\N	\N	102.177.195.86	2020-07-18	2
960	\N	\N	41.60.81.252	2020-01-03	3
961	\N	\N	41.60.68.179	2020-01-03	1
984	\N	\N	41.175.115.176	2020-01-10	4
985	\N	\N	41.175.115.176	2020-01-11	2
962	\N	\N	41.175.107.113	2020-01-03	4
964	\N	\N	41.60.68.179	2020-01-04	1
966	\N	\N	41.60.112.210	2020-01-04	1
965	\N	\N	41.60.113.189	2020-01-04	5
895	\N	2020-01-11 21:41:06	154.119.82.95	2019-08-18	\N
875	\N	2020-01-11 21:41:06	154.119.82.95	2019-08-14	\N
967	\N	\N	41.60.102.95	2020-01-04	9
963	\N	\N	196.27.120.12	2020-01-04	3
968	\N	\N	41.60.113.189	2020-01-05	1
864	\N	2020-01-11 21:41:06	154.119.82.95	2019-08-13	\N
969	\N	\N	41.175.79.205	2020-01-05	3
933	\N	2020-01-11 21:41:06	154.119.82.95	2019-10-24	\N
986	\N	2020-01-11 21:41:06	154.119.82.95	2020-01-11	\N
989	\N	\N	41.60.112.166	2020-01-13	1
991	\N	\N	196.27.120.12	2020-01-14	1
971	\N	\N	41.175.66.210	2020-01-05	5
972	\N	\N	196.27.120.12	2020-01-05	1
973	\N	\N	197.155.239.142	2020-01-05	1
993	\N	\N	196.27.120.12	2020-01-15	2
975	\N	\N	41.175.66.210	2020-01-06	5
976	\N	\N	41.175.78.92	2020-01-06	1
974	\N	\N	196.27.120.12	2020-01-06	6
1002	\N	\N	197.211.216.73	2020-01-23	10
1003	\N	\N	41.175.67.113	2020-01-24	1
998	\N	\N	41.90.25.102	2020-01-20	5
1005	\N	\N	41.60.126.155	2020-01-24	2
1004	\N	\N	197.211.216.73	2020-01-24	2
1006	\N	\N	197.211.216.73	2020-01-27	1
1001	\N	\N	77.246.52.148	2020-01-22	2
1007	\N	\N	197.211.216.73	2020-01-28	2
1092	\N	\N	41.60.115.157	2020-06-21	1
1083	\N	\N	197.221.251.26	2020-05-27	3
1016	\N	\N	41.175.65.210	2020-02-06	9
1015	\N	\N	41.60.77.148	2020-02-06	\N
837	\N	2020-01-22 16:25:54	197.211.216.73	2019-08-08	\N
997	\N	2020-01-22 16:25:54	197.211.216.73	2020-01-17	\N
813	\N	2020-01-22 16:25:54	197.211.216.73	2019-05-20	\N
814	\N	2020-01-22 16:25:54	197.211.216.73	2019-05-21	\N
889	\N	2020-01-22 16:25:54	197.211.216.73	2019-08-17	\N
840	\N	2020-01-22 16:25:54	197.211.216.73	2019-08-09	\N
831	\N	2020-01-22 16:25:54	197.211.216.73	2019-08-07	\N
981	\N	2020-01-22 16:25:54	197.211.216.73	2020-01-08	\N
904	\N	2020-01-22 16:25:54	197.211.216.73	2019-08-21	\N
871	\N	2020-01-22 16:25:54	197.211.216.73	2019-08-14	\N
861	\N	2020-01-22 16:25:54	197.211.216.73	2019-08-13	\N
914	\N	2020-01-22 16:25:54	197.211.216.73	2019-08-30	\N
988	\N	2020-01-22 16:25:54	197.211.216.73	2020-01-13	\N
896	\N	2020-01-22 16:25:54	197.211.216.73	2019-08-19	\N
907	\N	2020-01-22 16:25:54	197.211.216.73	2019-08-23	\N
885	\N	2020-01-22 16:25:54	197.211.216.73	2019-08-16	\N
901	\N	2020-01-22 16:25:54	197.211.216.73	2019-08-20	\N
925	\N	2020-01-22 16:25:54	197.211.216.73	2019-09-30	\N
926	\N	2020-01-22 16:25:54	197.211.216.73	2019-10-01	\N
932	\N	2020-01-22 16:25:54	197.211.216.73	2019-10-24	\N
937	\N	2020-01-22 16:25:54	197.211.216.73	2019-11-18	\N
940	\N	2020-01-22 16:25:54	197.211.216.73	2019-11-27	\N
990	\N	2020-01-22 16:25:54	197.211.216.73	2020-01-14	\N
942	\N	2020-01-22 16:25:54	197.211.216.73	2019-12-09	\N
943	\N	2020-01-22 16:25:54	197.211.216.73	2019-12-10	\N
951	\N	2020-01-22 16:25:54	197.211.216.73	2019-12-20	\N
992	\N	2020-01-22 16:25:54	197.211.216.73	2020-01-15	\N
977	\N	2020-01-22 16:25:54	197.211.216.73	2020-01-06	\N
994	\N	2020-01-22 16:25:54	197.211.216.73	2020-01-16	\N
999	\N	2020-01-22 16:25:54	197.211.216.73	2020-01-21	\N
1000	\N	2020-01-22 16:25:54	197.211.216.73	2020-01-22	\N
1024	\N	\N	41.60.88.58	2020-02-06	1
1025	\N	\N	41.60.104.172	2020-02-07	1
1031	\N	\N	41.60.67.130	2020-02-08	2
1027	\N	2020-03-23 16:08:31	102.177.195.86	2020-02-07	\N
1017	\N	\N	41.60.124.98	2020-02-06	1
1021	\N	\N	41.60.103.65	2020-02-06	2
1086	\N	\N	102.177.195.86	2020-06-02	4
1022	\N	\N	41.60.94.53	2020-02-06	1
1089	\N	\N	41.60.115.157	2020-06-05	1
1101	\N	\N	197.221.254.75	2020-07-22	1
1095	\N	\N	196.41.88.25	2020-06-26	4
1018	\N	\N	77.246.49.53	2020-02-06	1
1035	\N	\N	41.60.102.122	2020-02-10	1
883	\N	2020-02-06 23:00:03	197.211.209.123	2019-08-15	\N
928	\N	2020-02-06 23:00:03	197.211.209.123	2019-10-11	\N
931	\N	2020-02-06 23:00:03	197.211.209.123	2019-10-23	\N
954	\N	2020-02-06 23:00:03	197.211.209.123	2020-01-01	\N
970	\N	2020-02-06 23:00:03	197.211.209.123	2020-01-05	\N
1098	\N	\N	102.177.195.86	2020-06-27	5
1037	\N	\N	41.60.75.222	2020-02-11	3
1012	\N	\N	196.27.120.9	2020-02-06	10
1014	\N	\N	196.27.120.21	2020-02-06	9
978	\N	2020-02-06 23:00:03	197.211.209.123	2020-01-07	\N
1023	\N	2020-02-06 23:00:03	197.211.209.123	2020-02-06	\N
1020	\N	\N	41.60.104.172	2020-02-06	6
1029	\N	\N	41.60.74.56	2020-02-07	6
1019	\N	\N	154.119.81.206	2020-02-06	2
1028	\N	\N	197.211.209.123	2020-02-07	8
1032	\N	2020-02-09 21:24:37	41.174.87.72	2020-02-09	\N
1026	\N	\N	196.27.120.9	2020-02-07	4
1046	\N	\N	196.27.120.14	2020-02-19	2
1039	\N	\N	41.60.104.13	2020-02-13	7
1034	\N	\N	41.175.69.192	2020-02-10	4
1040	\N	\N	41.175.64.227	2020-02-14	1
1044	\N	\N	41.78.171.87	2020-02-18	7
1047	\N	\N	196.27.120.9	2020-02-19	1
1049	\N	\N	41.60.86.4	2020-02-21	1
1050	\N	\N	41.60.91.213	2020-02-24	1
1052	\N	\N	197.221.254.208	2020-03-05	1
1056	\N	\N	41.60.114.139	2020-03-10	1
1055	\N	\N	41.174.94.42	2020-03-10	3
1081	\N	\N	102.177.195.86	2020-05-20	7
1084	\N	\N	197.221.234.154	2020-06-01	2
1061	\N	\N	154.120.229.78	2020-03-16	6
1087	\N	\N	197.221.254.215	2020-06-02	3
1090	\N	\N	41.174.69.154	2020-06-11	1
1093	\N	\N	102.128.76.122	2020-06-24	1
1096	\N	\N	197.221.254.186	2020-06-26	3
1099	\N	\N	104.248.114.120	2020-07-03	1
1062	\N	\N	41.60.108.133	2020-03-16	4
1063	\N	\N	196.27.120.6	2020-03-17	3
1066	\N	\N	41.59.81.191	2020-03-19	1
1067	\N	\N	41.59.81.185	2020-03-19	1
1008	\N	2020-03-23 16:08:31	102.177.195.86	2020-01-29	\N
1009	\N	2020-03-23 16:08:31	102.177.195.86	2020-02-03	\N
1010	\N	2020-03-23 16:08:31	102.177.195.86	2020-02-04	\N
1011	\N	2020-03-23 16:08:31	102.177.195.86	2020-02-05	\N
1013	\N	2020-03-23 16:08:31	102.177.195.86	2020-02-06	\N
1043	\N	2020-03-23 16:08:31	102.177.195.86	2020-02-17	\N
1036	\N	2020-03-23 16:08:31	102.177.195.86	2020-02-11	\N
1030	\N	2020-03-23 16:08:31	102.177.195.86	2020-02-08	\N
1033	\N	2020-03-23 16:08:31	102.177.195.86	2020-02-10	\N
1042	\N	2020-03-23 16:08:31	102.177.195.86	2020-02-16	\N
1038	\N	2020-03-23 16:08:31	102.177.195.86	2020-02-13	\N
1041	\N	2020-03-23 16:08:31	102.177.195.86	2020-02-14	\N
1045	\N	2020-03-23 16:08:31	102.177.195.86	2020-02-18	\N
1048	\N	2020-03-23 16:08:31	102.177.195.86	2020-02-20	\N
1051	\N	2020-03-23 16:08:31	102.177.195.86	2020-03-02	\N
1053	\N	2020-03-23 16:08:31	102.177.195.86	2020-03-06	\N
1054	\N	2020-03-23 16:08:31	102.177.195.86	2020-03-09	\N
1057	\N	2020-03-23 16:08:31	102.177.195.86	2020-03-11	\N
1058	\N	2020-03-23 16:08:31	102.177.195.86	2020-03-12	\N
1059	\N	2020-03-23 16:08:31	102.177.195.86	2020-03-13	\N
1060	\N	2020-03-23 16:08:31	102.177.195.86	2020-03-16	\N
1064	\N	2020-03-23 16:08:31	102.177.195.86	2020-03-17	\N
1065	\N	2020-03-23 16:08:31	102.177.195.86	2020-03-18	\N
1068	\N	2020-03-23 16:08:31	102.177.195.86	2020-03-23	\N
1069	\N	\N	41.175.71.157	2020-03-24	1
1070	\N	\N	102.177.195.86	2020-03-26	2
1071	\N	\N	41.60.112.98	2020-04-01	1
1072	\N	\N	41.60.68.253	2020-04-08	6
1073	\N	\N	102.177.195.86	2020-04-24	3
1074	\N	\N	197.211.209.123	2020-04-27	2
1075	\N	\N	197.211.224.90	2020-05-12	1
1076	\N	\N	41.175.109.225	2020-05-13	2
1077	\N	\N	154.119.81.206	2020-05-14	2
1078	\N	\N	41.175.72.229	2020-05-17	4
1079	\N	\N	41.60.100.24	2020-05-18	1
1080	\N	\N	41.175.72.229	2020-05-18	2
1102	\N	\N	102.177.195.86	2020-07-23	1
1133	\N	\N	102.177.195.98	2020-10-07	6
1134	\N	\N	122.160.157.96	2020-10-20	2
1109	\N	\N	41.175.72.200	2020-08-22	3
1135	\N	\N	59.89.78.40	2020-10-20	4
1106	\N	2020-08-24 15:30:23	122.160.157.96	2020-08-13	\N
1107	\N	2020-08-24 15:30:23	122.160.157.96	2020-08-19	\N
1108	\N	2020-08-24 15:30:23	122.160.157.96	2020-08-21	\N
1110	\N	2020-08-24 15:30:23	122.160.157.96	2020-08-22	\N
1112	\N	\N	150.242.63.235	2020-08-29	1
1113	\N	\N	41.60.89.210	2020-09-02	1
1114	\N	\N	122.160.157.96	2020-09-03	1
1115	\N	\N	122.160.157.96	2020-09-09	4
1116	\N	\N	122.160.157.96	2020-09-10	1
1117	\N	\N	122.160.157.96	2020-09-12	1
1136	\N	\N	122.160.157.96	2020-10-21	7
1137	\N	\N	41.220.18.230	2020-10-21	1
1138	\N	\N	122.160.157.96	2020-10-22	1
1118	\N	\N	122.160.157.96	2020-09-15	7
1119	\N	\N	122.160.157.96	2020-09-17	1
1120	\N	\N	122.160.157.96	2020-09-21	3
1121	\N	\N	122.160.157.96	2020-09-25	2
1139	\N	\N	122.160.157.96	2020-10-24	7
1122	\N	\N	122.160.157.96	2020-09-26	10
1123	\N	\N	122.160.157.96	2020-09-28	1
1140	\N	\N	122.160.157.96	2020-10-26	4
1141	\N	\N	102.128.79.68	2020-10-31	2
1124	\N	\N	102.177.195.86	2020-10-01	7
1142	\N	\N	122.160.157.96	2020-11-05	5
1126	\N	\N	102.177.195.34	2020-10-01	1
1125	\N	\N	102.177.195.42	2020-10-01	9
1127	\N	\N	102.177.195.86	2020-10-02	4
1128	\N	\N	102.177.195.42	2020-10-02	1
1129	\N	\N	102.177.195.42	2020-10-03	3
1130	\N	\N	122.160.157.96	2020-10-05	1
1143	\N	\N	122.160.157.96	2020-11-09	8
1131	\N	\N	122.160.157.96	2020-10-06	4
1144	\N	\N	122.160.157.96	2020-11-25	2
1145	\N	\N	122.160.157.96	2020-11-26	1
1146	\N	\N	102.177.195.86	2020-11-26	1
1132	\N	\N	122.160.157.96	2020-10-07	6
1147	\N	\N	102.128.76.126	2020-11-27	1
1148	\N	\N	41.60.70.43	2020-11-29	1
\.


--
-- Data for Name: config; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.config (title, school_year, login, version) FROM stdin;
\.


--
-- Data for Name: course_credits; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.course_credits (school_year, school_id, course_id, course_credit_title, gpa_multiplier, rollover_id, year_fraction, credits, student_requestable, student_scheduleable, cw_checkbox_setting_1, cw_checkbox_setting_2, cw_checkbox_setting_3, cw_checkbox_setting_4, cw_checkbox_setting_5, does_gpa_1, does_gpa_2, does_gpa_3, does_gpa_4, does_gpa_5) FROM stdin;
2011	3	360	BAFL	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	362	ENYR1	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	366	HAYR1	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	370	MRYR1	\N	\N	\N	2	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	364	LAYR1	\N	\N	\N	2	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	368	VT2YR1	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	380	APYR2	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	382	PHAYR2	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	378	RWYR2	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	384	PTDYR2	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	372	ITYR1	\N	\N	\N	2	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	388	PLYR3	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	389	ESYR3	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	386	HMYR3	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	395	EHYR4	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	394	APYR4	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	397	NTYR4	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	396	PGYR4	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	402	CMYR1	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	404	IPYR1	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	414	IOTYR1	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	421	CHYR1	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	405	HAYR1	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	437	ATYR2	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	413	PRYR2	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	416	NTYR2	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	374	ALFYR2	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	376	WLYR2	\N	\N	\N	2	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	387	PSYR3	\N	\N	\N	3	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	440	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	442	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	438	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	439	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	444	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	445	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	446	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1903	BAFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	451	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	449	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	447	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	448	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	421	CHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	411	RPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	416	NTYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	450	HRs	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	441	GAAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	363	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	369	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	361	FLYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	365	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	371	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	373	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	367	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	375	ALFYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	377	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	379	WHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	385	EYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	383	SSAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	390	CPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	391	PMEYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	392	MCPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	393	OTFYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	398	PPPYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	399	REYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	400	OCTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	401	OCYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	403	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	453	DHBAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	454	PSDRGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	455	PLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	456	GPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	457	PFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	458	ICSPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	459	RSFANEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	460	PCMEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	461	BEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	462	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	463	FAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	381	HMPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	409	EPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	418	HCTPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	415	INTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	464	APDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	465	IEDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	466	CTIDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	467	IDDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	417	ITDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	689	RMHDPTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	468	PCMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	469	ICSDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	470	HRDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	471	DHDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	692	TJRDPTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	694	HMPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2008	3	474	EWYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2008	3	475	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2008	3	476	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2008	3	477	SVCYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2008	3	478	MRSYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2008	3	479	IPYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	697	ESPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2008	3	480	FLYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2008	3	481	EWYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2008	3	482	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2008	3	483	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2008	3	484	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2008	3	485	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2008	3	486	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	700	HRAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	702	CPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	705	MCPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	708	TJRAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	711	KGAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	714	PSDAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	717	PFAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	720	AADAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	723	ASAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	726	JFAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2008	3	473	FLYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	522	EWYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	512	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	513	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	514	SVCYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	515	MRSYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	516	IPYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	525	FLYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	523	EWYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	517	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	518	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	519	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	520	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	521	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	524	FLYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	526	ALFYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	527	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	528	RWYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	529	HAPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	530	PAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	531	PTDYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	532	ALFYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	533	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	534	WHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	535	EYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	536	SSAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	537	HMPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	538	CMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	539	IPLDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	540	HAPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	541	HCTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	542	CHDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	543	CMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	544	IOTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	545	ITDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	546	APYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	548	HCTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	551	EMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	552	MMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	553	PPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	554	PRMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	555	SPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	556	EMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	557	IPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	558	APMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	559	PSMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2009	3	560	PEMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	690	APDPTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	693	HADPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	695	PSYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	698	KMAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	701	PRAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	703	PMEYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	706	RMHAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	709	PTAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	712	EFBAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	715	IJSAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	718	GPAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	721	ISRAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	724	GMAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	727	MHAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	729	HCTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	731	HMPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	733	CADPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	735	EDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	737	HCPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	739	KMDPTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	741	HRDPTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	743	DMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	745	CPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	746	PTDPTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	748	BAPRE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	749	RAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	750	APPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	752	HMPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	753	EPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	755	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	757	RWPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	759	PTDPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	761	HMPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	763	PLPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	765	CPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	767	MCPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	769	SAPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	771	PGPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	773	PPPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	775	OCTPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	777	DHPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	779	PSDPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	780	IPLPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	782	PFPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	783	HRPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	784	PCMPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	785	FAEPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	786	APPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	691	PCMDPTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	696	PLPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	651	EWYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	677	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	643	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	644	SVCYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	645	MRSYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	646	IPYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	654	FLYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	652	EWYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	678	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	647	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	648	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	649	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	650	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	653	FLYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	655	ALFYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	656	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	657	RWYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	658	HAPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	659	PAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	660	PTDYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	661	ALFYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	662	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	663	WHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	664	EYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	665	SSAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	666	HMPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	667	CMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	668	IPLDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	669	HAPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	670	HCTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	671	CHDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	672	CMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	673	IOTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	674	ITDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	675	APYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	676	HCTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	679	EMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	680	MMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	681	PPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	682	PRMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	683	SPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	684	EMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	685	IPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	686	APMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	687	PSMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	688	PEMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	699	GAAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	704	OTFYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	707	PFAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	710	HTAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	713	APAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	716	IAPAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	719	PCMAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	722	CTPWAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	725	TSPAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	728	PMAPHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	730	INTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	732	PADPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	734	HMPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	736	MDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	738	GADPTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	740	PRDPTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	742	TGMMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2010	3	744	ISRMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	751	LPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	754	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	756	IPPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	758	PAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	760	SSAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	762	PSPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	764	ESPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	766	PMEPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	768	OFPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	770	EHPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	772	NTFPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	774	REPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	776	OCEPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	778	ICSPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	781	BPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	787	BAFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	789	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	793	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	797	MRYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	792	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	795	VT2YR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	805	APYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	807	PHAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	803	RWYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	809	PTDYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	799	ITYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	813	PLYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	814	ESYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	811	HMYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	820	EHYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	819	APYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	822	NTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	821	PGYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	826	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	828	IPYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	838	IOTYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	845	CHYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	829	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	861	ATYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	837	PRYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	840	NTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	862	ALFYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	802	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	812	PSYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	875	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	867	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	866	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	864	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	869	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	870	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	871	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1901	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	876	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	874	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	872	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	873	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	845	CHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	835	RPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	840	NTYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	895	HRs	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	865	GAAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	790	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	796	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	788	FLYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	791	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	798	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	800	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	794	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	863	ALFYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	801	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	804	WHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	810	EYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	808	SSAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	815	CPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	816	PMEYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	817	MCPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	818	OTFYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	823	PPPYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	824	REYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	825	OCTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	936	OCYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	827	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	877	DHBAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	878	PSDRGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	879	PLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	880	GPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	881	PFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	882	ICSPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	883	RSFANEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	884	PCMEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	885	BEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	886	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	887	FAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	806	HMPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	833	EPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	842	HCTPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	839	INTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	888	APDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	889	IEDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	890	CTIDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	891	IDDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	841	ITDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	892	PCMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	896	ICSDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	893	HRDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	894	DHDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	913	BAPRE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	914	RAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	915	APPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	916	HMPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	917	EPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	918	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	919	RWPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	920	PTDPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	921	HMPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	922	PLPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	923	CPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	924	MCPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	925	SAPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	926	PGPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	927	PPPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	928	OCTPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	929	DHPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	930	PSDPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	931	IPLPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	932	PFPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	912	HRPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	933	PCMPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	935	FAEPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	934	APPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	897	LPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	898	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	899	IPPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	900	PAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	901	SSAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	902	PSPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	903	ESPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	904	PMEPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	905	OFPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	906	EHPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	907	NTFPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	908	REPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	909	OCEPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	910	ICSPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	911	BPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	937	AIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	943	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	939	PAEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	940	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	945	CTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	946	ELEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	944	FFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	941	JHEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	938	KEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	947	PAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	949	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	950	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	951	ISEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	952	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	953	SKEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	954	AIYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	955	PEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	956	SKEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	957	PAEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	958	STEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	959	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	960	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	961	JHEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	962	FFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	963	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	964	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	965	CTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	966	ELEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	967	PEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	968	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	969	PAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	970	PAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	971	GAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	972	ISEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	973	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	974	SKEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	976	PEDYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	977	BLYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	868	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	853	SPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	846	EPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	978	PEDMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	979	BLMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	948	GAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	980	HAPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	981	HAPPUGYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	982	PAPUGYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	836	EDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	843	HCT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	830	HMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	983	HIVA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	984	SPP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	985	POE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	986	PAE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	987	ST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	847	ETMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	855	LPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	988	POSMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	989	PCCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	990	ASCAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	991	DEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	992	PHILA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	993	OTS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	994	PSDRG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	995	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	996	FLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	997	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	998	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	999	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1000	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1001	ETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1002	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1003	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1004	PMOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1005	ASCA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1006	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1007	DEMC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1008	BIOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1009	PFR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1010	LAWA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1011	POLA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1012	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1013	APHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1014	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	408	CONP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	832	CONTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	834	MTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2011	3	1015	LIAQ	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1016	HRPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1017	POSPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2012	3	1018	FRLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1902	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1907	MRYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1900	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1905	VT2YR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1921	APYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1919	RWYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1925	PTDYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1909	ITYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1929	PLYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1930	ESYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1927	HMYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1936	EHYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1935	APYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1938	NTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1937	PGYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1942	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1944	IPYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1954	IOTYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1961	CHYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1945	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1976	ATYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1953	PRYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1956	NTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1977	ALFYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1918	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1928	PSYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1982	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1913	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1979	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2032	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2033	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1983	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2036	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2034	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2035	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1961	CHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1951	RPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1956	NTYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2045	HRs	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1980	GAAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1910	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1906	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1899	FLYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1911	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1908	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1916	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1904	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1978	ALFYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1917	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1920	WHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1926	EYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1924	SSAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1931	CPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1932	PMEYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1933	MCPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1934	OTFYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1939	PPPYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1940	REYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1941	OCTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2022	OCYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1943	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1914	DHBAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1892	PSDRGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1915	PLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1986	GPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2030	PFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2028	ICSPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1987	RSFANEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2027	PCMEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2029	BEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1988	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2037	FAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1922	HMPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1949	EPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1958	HCTPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1955	INTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2038	APDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2039	IEDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2040	CTIDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2041	IDDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1957	ITDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2042	PCMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2046	ICSDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2043	HRDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2044	DHDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1868	BAPRE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2001	RAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2002	APPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2031	HMPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2003	EPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2004	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2005	RWPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2006	PTDPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2007	HMPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2008	PLPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2009	CPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2010	MCPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2011	SAPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2012	PGPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2013	PPPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2014	OCTPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2015	DHPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2016	PSDPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2017	IPLPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2018	PFPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2000	HRPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2019	PCMPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2021	FAEPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2020	APPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2047	LPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2048	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1984	IPPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1989	SSAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1991	ESPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1992	PMEPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1993	OFPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1994	EHPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1995	NTFPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1996	REPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1997	OCEPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1998	ICSPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1999	BPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1843	AIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1865	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1884	PAEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1897	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2024	CTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1844	ELEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1885	FFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2023	JHEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1864	KEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1866	PAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1990	PON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1863	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2025	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1845	ISEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1867	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1898	SKEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1981	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1968	SPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1846	EPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1869	PEDMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1888	BLMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1886	GAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1870	HAPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1889	PAPUGYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1952	EDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1959	HCT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1946	HMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1872	HIVA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1890	SPP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1847	POE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1873	PAE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1891	ST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1962	ETMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1970	LPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1874	POSMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1848	PCCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1861	ASCAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1893	DEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1894	OTS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1849	PSDRG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1876	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1895	FLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1850	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1887	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1862	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1851	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1877	ETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1896	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1852	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1878	PMOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1879	ASCA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1853	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1880	DEMC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1854	BIOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1881	PFR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1855	LAWA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1882	POLA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1856	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1883	APHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1857	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1948	CONTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1950	MTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1858	HRPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1859	POSPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1860	FRLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2049	POL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2050	TTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2051	HOAP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2053	FRLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2054	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2055	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2056	WLPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2057	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2058	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2059	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2060	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2061	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2062	ITBL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2063	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2064	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2065	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2066	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2026	IGSP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1973	APMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2067	AQLKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2068	LOM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2069	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1985	POM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1947	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1960	HOCTMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2070	DISSER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2071	ATPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2072	OSAD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	1963	MAHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2073	MAISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2074	PHIH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2075	PHMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2078	DFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2079	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2080	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2081	AFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2082	AQKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2083	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2084	HPICK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2085	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2087	OIAF	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2089	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2091	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2093	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2095	MFAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2097	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2013	3	2099	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2179	BAFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2177	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2178	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2183	MRYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2176	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2181	VT2YR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2196	APYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2194	RWYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2200	PTDYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2185	ITYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2204	PLYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2205	ESYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2202	HMYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2211	EHYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2210	APYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2213	NTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2212	PGYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2217	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2219	IPYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2229	IOTYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2236	CHYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2220	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2251	ATYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2228	PRYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2231	NTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2252	ALFYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2193	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2203	PSYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2257	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2189	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2254	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2320	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2305	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2258	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2308	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2306	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2307	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2236	CHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2226	RPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2231	NTYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2317	HRs	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2255	GAAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2186	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2182	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2175	FLYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2187	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2184	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2113	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2180	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2253	ALFYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2192	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2195	WHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2201	EYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2276	SSAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2206	CPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2207	PMEYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2208	MCPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2209	OTFYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2214	PPPYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2215	REYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2216	OCTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2296	OCYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2218	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2190	DHBAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2169	PSDRGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2191	PLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2260	GPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2303	PFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2301	ICSPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2261	RSFANEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2339	PCMEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2302	BEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2262	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2309	FAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2102	HMPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2224	EPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2233	HCTPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2230	INTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2310	APDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2311	IEDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2312	CTIDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2313	IDDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2232	ITDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2314	PCMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2318	ICSDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2315	HRDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2316	DHDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2147	BAPRE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2275	RAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2197	APPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2304	HMPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2277	EPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2278	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2279	RWPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2280	PTDPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2281	HMPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2282	PLPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2283	CPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2284	MCPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2285	SAPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2286	PGPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2287	PPPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2288	OCTPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2289	DHPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2290	PSDPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2291	IPLPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2292	PFPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2274	HRPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2293	PCMPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2295	FAEPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2294	APPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2322	LPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2323	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2259	IPPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2263	SSAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2264	ESPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2265	PMEPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2266	OFPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2267	EHPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2268	NTFPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2269	REPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2270	OCEPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2272	ICSPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2273	BPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2123	AIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2144	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2162	PAEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2173	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2298	CTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2101	ELEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2163	FFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2297	JHEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2143	KEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2145	PAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2119	PON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2142	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2299	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2124	ISEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2146	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2174	SKEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2256	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2243	SPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2125	EPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2148	PEDMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2166	BLMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2164	GAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2149	HAPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2199	PAPUGYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2227	EDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2234	HCT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2221	HMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2151	HIVA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2167	SPP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2127	POE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2152	PAE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2168	ST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2237	ETMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2245	LPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2153	POSMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2128	PCCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2140	ASCAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2170	DEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2171	OTS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2129	PSDRG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2154	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2100	FLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2130	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2165	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2141	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2131	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2155	ETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2172	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2132	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2156	PMOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2157	ASCA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2133	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2158	DEMC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2134	BIOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2159	PFR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2135	LAWA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2160	POLA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2136	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2161	APHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2137	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2223	CONTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2225	MTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2138	HRPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2198	POSPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2139	FRLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2103	POL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2104	TTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2105	HOAP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2112	FRLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2106	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2114	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2117	WLPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2107	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2110	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2115	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2118	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2120	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2121	ITBL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2122	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2126	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2319	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2321	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2300	IGSP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2248	APMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2108	AQLKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2111	LOM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2116	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2271	POM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2222	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2235	HOCTMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2109	DISSER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2324	ATPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2325	OSAD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2238	MAHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2326	MAISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2327	PHIH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2328	PHMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2329	DFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2330	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2331	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2332	AFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2333	AQKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2334	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2335	HPICK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2336	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2337	OIAF	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2338	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2340	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2341	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2342	MFAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2343	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2344	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2346	IGSPI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2348	PHOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2349	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2352	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2353	GREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2354	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2355	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2356	NIETZ	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2357	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2358	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2360	MARX	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2361	PHILAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2362	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2363	HIVAIDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2364	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2365	ARGWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2239	METAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2242	ECONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2246	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2366	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2367	NGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2250	CONTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2368	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2369	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2370	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2371	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2372	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2373	RETREAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2374	CONTLit	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2375	PEOPLES	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2253	ALFPUG	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2376	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2378	DISSERT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2379	DISSERT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2380	THNGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2381	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2382	THGARD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2383	PHMATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2384	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2385	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2386	HITFILM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2387	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2388	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2389	CONFMANG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2390	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2391	POLTHEO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2392	PHILMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2393	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2394	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2395	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2396	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2397	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2014	3	2398	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2644	BAFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2399	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2541	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2594	MRYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2643	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2641	VT2YR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2657	APYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2655	RWYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2661	PTDYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2647	ITYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2665	PLYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2408	ESYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2663	HMYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2414	EHYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2413	APYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2416	NTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2415	PGYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2420	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2422	IPYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2432	IOTYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2439	CHYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2423	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2454	ATYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2431	PRYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2434	NTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2465	ALFYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2654	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2664	PSYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2458	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2650	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2455	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2530	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2515	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2459	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2518	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2516	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2517	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2439	CHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2429	RPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2434	NTYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2527	HRs	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2456	GAAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2648	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2642	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2646	FLYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2536	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2595	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2574	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2640	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2470	ALFYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2653	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2656	WHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2662	EYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2486	SSAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2409	CPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2410	PMEYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2411	MCPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2412	OTFYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2417	PPPYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2418	REYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2419	OCTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2506	OCYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2421	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2651	DHBAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2634	PSDRGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2652	PLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2461	GPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2513	PFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2511	ICSPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2462	RSFANEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2679	PCMEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2512	BEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2463	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2519	FAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2565	HMPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2427	EPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2436	HCTPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2433	INTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2520	APDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2521	IEDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2522	CTIDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2523	IDDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2435	ITDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2524	PCMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2528	ICSDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2525	HRDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2526	DHDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2612	BAPRE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2485	RAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2658	APPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2514	HMPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2487	EPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2488	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2489	RWPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2490	PTDPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2491	HMPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2492	PLPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2493	CPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2494	MCPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2495	SAPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2496	PGPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2497	PPPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2498	OCTPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2499	DHPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2500	PSDPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2501	IPLPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2502	PFPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2484	HRPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2503	PCMPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2505	FAEPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2504	APPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2532	LPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2533	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2460	IPPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2464	SSAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2596	ESPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2466	PMEPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2476	OFPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2477	EHPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2478	NTFPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2479	REPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2480	OCEPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2482	ICSPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2483	BPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2584	AIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2609	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2627	PAEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2638	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2508	CTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2564	ELEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2628	FFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2507	JHEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2608	KEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2610	PAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2580	PON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2607	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2509	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2585	ISEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2611	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2639	SKEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2457	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2446	SPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2586	EPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2613	PEDMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2631	BLMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2629	GAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2614	HAPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2660	PAPUGYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2430	EDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2437	HCT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2424	HMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2616	HIVA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2632	SPP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2588	POE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2617	PAE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2633	ST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2440	ETMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2448	LPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2618	POSMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2589	PCCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2605	ASCAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2635	DEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2636	OTS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2590	PSDRG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2619	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2563	FLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2591	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2630	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2606	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2592	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2620	ETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2637	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2597	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2621	PMOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2622	ASCA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2598	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2623	DEMC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2599	BIOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2624	PFR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2600	LAWA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2625	POLA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2601	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2626	APHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2602	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2426	CONTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2428	MTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2603	HRPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2659	POSPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2604	FRLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2566	POL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2567	TTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2593	HOAP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2573	FRLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2568	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2575	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2578	WLPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2569	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2571	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2576	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2579	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2581	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2582	ITBL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2583	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2587	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2529	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2531	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2510	IGSP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2451	APMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2570	AQLKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2572	LOM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2577	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2481	POM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2425	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2438	HOCTMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2645	DISSER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2534	ATPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2666	OSAD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2441	MAHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2667	MAISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2668	PHIH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2687	PHMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2669	DFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2670	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2671	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2672	AFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2673	AQKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2674	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2675	HPICK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2676	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2677	OIAF	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2678	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2680	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2681	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2682	MFAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2683	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2684	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2549	IGSPI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2551	PHOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2553	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2400	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2467	GREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2556	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2685	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2535	NIETZ	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2542	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2550	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2552	MARX	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2554	PHILAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2401	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2468	HIVAIDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2557	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2686	ARGWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2442	METAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2445	ECONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2449	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2543	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2555	NGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2453	CONTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2402	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2469	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2558	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2537	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2544	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2403	RETREAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2559	CONTLit	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2688	PEOPLES	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2470	ALFPUG	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2538	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2545	DISSERT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2404	DISSERT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2471	THNGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2560	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2689	THGARD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2539	PHMATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2546	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2405	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2472	HITFILM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2561	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2690	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2540	CONFMANG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2547	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2406	POLTHEO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2473	PHILMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2474	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2562	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2691	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2548	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2407	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2015	3	2475	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3571	PHWRI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3574	HMPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3583	APOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3592	ARTL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3594	AFPSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3596	ARTL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3600	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3603	Dewey	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3605	PHMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3607	SPNEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3609	FREUD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3297	PolPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3293	PHREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3610	ARGW	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3611	AFTLIT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3612	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3614	PGDMETA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3616	HMPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3619	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3628	TAYLOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3637	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3641	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3647	MARCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3657	PHYSICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3659	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3661	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3662	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3664	GABRIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3663	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3666	AQUINASM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3671	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3673	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3674	PSYCHOED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3675	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3677	DISASTERC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3679	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3572	LTIN	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3576	PHWRI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3584	CHRTA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3593	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3597	AFCHRIST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3602	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3604	Laudatosi	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3606	PSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3608	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3613	ORALC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3615	PGDCON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3617	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3620	HEGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3629	GUIDANCE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3638	PHYSICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3642	HEGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3648	GUIDANCE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3658	MICROSOFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3660	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3665	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3667	CATOHSO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3672	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3676	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3678	DISASTERC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3680	LEADERSHIP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3578	IKANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3585	INTROPM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3598	IKANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3618	ART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3621	GENDER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3625	MDRSK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3630	IRELATIONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3639	MICROSOFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3643	GENDER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3649	IRELATIONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3668	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3579	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3586	APSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3599	INTROPM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3622	SOCPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3626	PHILANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3631	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3644	AQUINAS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3650	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3669	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3580	Dewey	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3587	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3623	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3627	HEPW	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3632	ANALYSISII	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3645	SOCPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3651	ANALYSISII	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3670	MORALITYA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3581	MLL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3624	CSTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3588	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3633	TIME	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3646	CATOHSO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3652	STUART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3582	SGFREUD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3589	SPNEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3634	STUART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3653	LITURGY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3590	PSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3655	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3635	LITURGY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3555	BAFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3490	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3479	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3432	MRYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3554	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3552	VT2YR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3568	APYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3566	RWYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3468	PTDYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3558	ITYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3472	PLYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3499	ESYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3470	HMYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3525	EHYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3524	APYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3527	NTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3526	PGYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3531	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3533	IPYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3281	IOTYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3289	CHYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3534	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3483	ATYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3280	PRYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3283	NTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3305	ALFYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3565	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3471	PSYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3487	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3561	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3484	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3369	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3355	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3488	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3358	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3356	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3357	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3289	CHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3278	RPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3283	NTYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3366	HRs	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3485	GAAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3559	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3553	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3557	FLYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3375	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3433	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3412	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3551	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3564	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3567	WHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3469	EYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3326	SSAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3500	CPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3501	PMEYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3502	MCPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3523	OTFYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3528	PPPYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3529	REYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3530	OCTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3346	OCYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3532	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3562	DHBAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3545	PSDRGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3563	PLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3301	GPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3353	PFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3351	ICSPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3302	RSFANEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3510	PCMEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3352	BEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3303	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3359	FAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3403	HMPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3538	EPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3285	HCTPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3282	INTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3360	APDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3286	IEDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3361	CTIDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3362	IDDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3284	ITDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3363	PCMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3367	ICSDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3364	HRDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3365	DHDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3450	BAPRE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3325	RAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3569	APPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3354	HMPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3327	EPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3328	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3329	RWPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3331	HMPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3332	PLPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3333	CPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3334	MCPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3335	SAPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3336	PGPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3337	PPPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3338	OCTPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3339	DHPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3340	PSDPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3341	IPLPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3342	PFPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3324	HRPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3343	PCMPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3345	FAEPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3344	APPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3371	LPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3372	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3489	IPPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3304	SSAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3434	ESPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3306	PMEPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3316	OFPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3317	EHPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3318	NTFPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3319	REPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3322	ICSPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3323	BPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3422	AIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3447	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3465	PAEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3549	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3348	CTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3402	ELEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3466	FFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3347	JHEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3446	KEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3448	PAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3418	PON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3445	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3349	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3423	ISEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3449	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3550	SKEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3320	OCEPUG3	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3486	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3296	SPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3424	EPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3451	PEDMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3542	BLMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3540	GAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3452	HAPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3467	PAPUGYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3279	EDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3287	HCT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3535	HMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3454	HIVA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3543	SPP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3426	POE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3455	PAE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3544	ST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3290	ETMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3298	LPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3456	POSMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3427	PCCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3443	ASCAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3546	DEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3547	OTS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3428	PSDRG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3457	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3401	FLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3429	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3541	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3444	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3430	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3458	ETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3548	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3435	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3459	PMOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3460	ASCA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3436	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3461	DEMC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3437	BIOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3462	PFR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3438	LAWA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3463	POLA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3439	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3464	APHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3537	CONTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3539	MTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3441	HRPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3570	POSPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3442	FRLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3404	POL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3405	TTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3406	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3413	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3416	WLPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3407	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3409	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3414	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3417	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3419	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3420	ITBL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3421	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3425	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3368	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3370	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3350	IGSP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3480	APMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3408	AQLKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3410	LOM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3415	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3321	POM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3536	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3288	HOCTMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3556	DISSER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3373	ATPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3473	OSAD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3291	MAHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3474	MAISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3475	PHIH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3518	PHMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3476	DFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3477	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3478	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3503	AFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3504	AQKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3505	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3506	HPICK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3507	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3508	OIAF	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3509	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3511	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3512	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3513	MFAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3514	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3515	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3387	IGSPI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3389	PHOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3391	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3491	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3307	GREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3394	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3516	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3374	NIETZ	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3380	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3388	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3390	MARX	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3392	PHILAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3492	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3308	HIVAIDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3395	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3517	ARGWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3292	METAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3295	ECONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3299	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3381	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3393	NGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3482	CONTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3493	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3309	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3396	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3376	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3382	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3494	RETREAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3397	CONTLit	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3519	PEOPLES	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3310	ALFPUG	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3377	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3311	THNGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3398	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3520	THGARD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3378	PHMATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3384	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3496	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3312	HITFILM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3399	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3521	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3379	CONFMANG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3385	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3497	POLTHEO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3313	PHILMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3314	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3400	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3522	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3386	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3498	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3315	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3591	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3636	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3383	DISSERT	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3495	DISSERT	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3656	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3682	ICTNET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2016	3	3683	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3751	PHWRI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3782	HMPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3783	APOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4076	ARTL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3752	AFPSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3785	ARTL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3981	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3982	Dewey	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3983	PHMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3984	SPNEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3985	FREUD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3703	PolPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3699	PHREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4011	ARGW	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3988	AFTLIT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3989	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3990	PGDMETA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3991	HMPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3992	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3994	TAYLOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3997	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3998	MARCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3788	PHYSICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4000	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4002	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4003	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4022	GABRIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4033	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4035	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4036	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4037	PSYCHOED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4038	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4039	DISASTERC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4040	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3780	LTIN	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3978	PHWRI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3979	CHRTA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3784	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3786	AFCHRIST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4008	Laudatosi	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4009	PSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4012	ORALC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4013	PGDCON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4014	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4015	HEGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4017	GUIDANCE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4018	PHYSICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4020	GUIDANCE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3999	MICROSOFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4021	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4048	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4049	CATOHSO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4050	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4051	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4052	DISASTERC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4053	LEADERSHIP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4026	ART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4027	GENDER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3993	MDRSK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4044	IRELATIONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4030	MICROSOFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4031	GENDER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4032	IRELATIONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4060	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4023	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4024	APSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4043	SOCPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4016	PHILANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4057	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4047	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4068	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4041	Dewey	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4004	IKANT	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3980	IKANT	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4006	INTROPM	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4010	DIOP	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4019	HEGEL	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4046	AQUINAS	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4034	AQUINASM	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4042	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4056	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4028	HEPW	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4065	ANALYSISII	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4058	SOCPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4059	ANALYSISII	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4072	MORALITYA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4054	MLL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4064	CSTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4055	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4066	CATOHSO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4067	STUART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4062	SGFREUD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4063	SPNEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4074	STUART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4071	LITURGY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4069	PSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4075	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4077	LITURGY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3963	BAFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3900	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3890	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4079	MRYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3962	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3960	VT2YR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3974	APYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3972	RWYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3879	PTDYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3964	ITYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3883	PLYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3909	ESYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3881	HMYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3935	EHYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3934	APYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3936	NTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3977	PGYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3940	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3942	IPYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3688	IOTYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3696	CHYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3943	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3894	ATYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3687	PRYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3690	NTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3711	ALFYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3971	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3882	PSYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3897	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3967	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4029	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3777	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3898	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3766	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3764	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3765	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3696	CHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3685	RPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3690	NTYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3965	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3961	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3791	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3840	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3822	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3959	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3970	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3973	WHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3880	EYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3732	SSAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3910	CPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3928	MCPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3933	OTFYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3937	PPPYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3938	REYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3939	OCTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3750	OCYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3941	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3895	GAAPH	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3763	APEL	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3774	HRs	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4070	TIME	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3996	PSDRGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3969	PLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3761	PFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3708	RSFANEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3916	PCMEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3760	BEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3709	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3817	HMPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3947	EPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3692	HCTPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3689	INTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3768	APDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3693	IEDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3769	CTIDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3770	IDDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3691	ITDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3771	PCMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3775	ICSDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3772	HRDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3773	DHDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3863	BAPRE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3731	RAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3762	HMPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3987	EPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3733	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3734	RWPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3736	PLPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3737	CPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3738	MCPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3739	SAPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3740	PGPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3741	PPPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3742	OCTPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3744	PSDPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3745	IPLPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3746	PFPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3747	PCMPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3748	APPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3778	LPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3779	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3899	IPPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3710	SSAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3841	ESPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3753	PMEPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3722	OFPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3723	EHPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3724	NTFPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3725	REPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3877	PAEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3957	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3756	CTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3816	ELEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3878	FFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3755	JHEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3852	KEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3861	PAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3828	PON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3856	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3757	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3832	ISEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3862	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3726	OCEPUG3	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3896	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3702	SPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3833	EPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3831	AIEL	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3767	FAEL	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3707	GPEL	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3759	ICSPEL	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3860	LLEL	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3729	BPUGE	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3743	DHPUGE	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3749	FAEPUGE	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3728	ICSPUGE	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3958	SKEL	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3951	BLMA	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3864	PEDMA	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3949	GAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3865	HAPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3807	PAPUGYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3686	EDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3694	HCT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3944	HMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3867	HIVA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3952	SPP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3835	POE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3868	PAE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3953	ST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3754	ETMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3704	LPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3869	POSMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3836	PCCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3850	ASCAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3955	OTS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3837	PSDRG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3870	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3815	FLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3838	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3950	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3851	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3839	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3871	ETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3956	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3842	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3930	PMOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3872	ASCA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3843	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3844	BIOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3874	PFR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3845	LAWA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3846	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3876	APHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3946	CONTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3948	MTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3976	POSPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3849	FRLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3818	POL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3819	TTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3820	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3823	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3826	WLPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3854	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3855	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3824	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3827	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3829	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3830	ITBL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3858	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3834	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3776	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3713	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3758	IGSP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3891	APMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3821	LOM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3825	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3727	POM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3945	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3695	HOCTMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4001	DISSER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3789	ATPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3884	OSAD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3887	DFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3888	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3889	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3911	AFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3929	AQKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3914	OIAF	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3915	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3917	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3912	HPCIK	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3873	DEMC	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3913	HPCIK	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3848	HRPUG	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3857	AQLKB	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3697	MAHE	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3926	HPICK	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3885	MAISLAM	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3886	PHIH	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3875	POLA	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3922	PHMA	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3918	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3919	MFAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3920	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3921	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3801	IGSPI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3805	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3712	GREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3808	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3925	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3790	NIETZ	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3859	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3802	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3806	PHILAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3902	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3809	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3927	ARGWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3701	ECONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3705	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3853	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3893	CONTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3903	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3715	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3810	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3792	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3796	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3904	RETREAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3811	CONTLit	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3923	PEOPLES	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3716	ALFPUG	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3793	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3717	THNGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3924	THGARD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3794	PHMATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3798	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3718	HITFILM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3813	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3907	POLTHEO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3719	PHILMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3932	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3721	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4073	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3787	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3797	DISSERT	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3905	DISSERT	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4078	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4080	ICTNET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4086	ENVIRON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3986	FLYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4087	ICTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4088	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4083	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4091	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4089	SOCILPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4092	ENVIRON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4093	EDUC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3720	COMPS	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3795	CONFMANG	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3812	CURIDEV	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3968	DHBAEL	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3954	DEL	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3714	HIVAIDS	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3799	INTROHRIGH	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3931	INTROPEACE	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4005	INTROPM	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3906	SCIEREL	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3804	MARX	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3814	COMPS	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3908	INTROHRIGH	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3800	INTROPEACE	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3901	ARPH	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3698	METAPH	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3803	PHOG	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4081	DIOP	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3684	NGUGI	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4099	ECON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4101	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4098	ENVIRON	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4100	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4102	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4095	PHILREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4096	PHILSICEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4097	POLIPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4084	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4103	THEATRE2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4104	BLETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4105	EGYPTGREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4082	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4107	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4108	DEWEY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4109	SOCSPIR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4110	SOCSPIR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4111	ENVIRONETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4112	SPECIALED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3781	PMEYR3	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4085	SOCIALS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4113	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4114	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4115	MATHS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3975	APPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4116	ICTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4117	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4118	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4119	MATHS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3892	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4120	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4121	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4122	ARISETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4123	ARISETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4124	KANTEPIS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4126	KANTEPIS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	3700	PHILANTH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4127	SHONA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4129	SHONA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4130	PHIOFLIFE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4131	PHIOFLIFE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4132	ISLAMAFRIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4133	ISLAMAFRIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4134	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4135	GENDER2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4136	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4137	GENDER2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4138	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4139	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4140	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4141	SIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4128	SIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4142	AFRIPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4143	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4144	CCNA1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4145	CCNA1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4204	PHWRI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4288	HMPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4240	APOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4521	ARTL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4205	AFPSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4245	ARTL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4431	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4432	Dewey	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4433	PHMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4434	SPNEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4435	FREUD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4168	PolPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4164	PHREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4461	ARGW	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4438	AFTLIT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4439	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4440	PGDMETA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4441	HMPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4442	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4444	TAYLOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4446	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4447	MARCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4247	PHYSICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4449	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4451	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4452	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4471	GABRIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4481	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4483	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4484	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4485	PSYCHOED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4486	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4487	DISASTERC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4488	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4286	LTIN	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4417	PHWRI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4418	CHRTA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4241	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4246	AFCHRIST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4457	Laudatosi	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4459	PSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4462	ORALC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4539	PGDCON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4463	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4464	HEGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4466	GUIDANCE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4467	PHYSICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4469	GUIDANCE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4448	MICROSOFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4470	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4496	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4497	CATOHSO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4498	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4499	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4500	DISASTERC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4501	LEADERSHIP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4474	ART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4475	GENDER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4443	MDRSK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4492	IRELATIONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4478	MICROSOFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4479	GENDER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4480	IRELATIONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4508	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4472	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4473	APSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4491	SOCPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4465	PHILANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4505	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4495	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4528	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4489	Dewey	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4453	IKANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4430	IKANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4455	INTROPM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4460	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4468	HEGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4494	AQUINAS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4482	AQUINASM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4490	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4504	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4476	HEPW	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4513	ANALYSISII	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4506	SOCPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4507	ANALYSISII	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4518	MORALITYA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4502	MLL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4512	CSTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4503	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4514	CATOHSO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4515	STUART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4510	SGFREUD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4511	SPNEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4520	STUART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4517	LITURGY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4147	PSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4588	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4522	LITURGY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4407	BAFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4527	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4355	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4530	MRYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4529	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4420	VT2YR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4424	APYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4421	RWYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4334	PTDYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4419	ITYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4148	PLYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4423	ESYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4336	HMYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4426	EHYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4425	APYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4535	NTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4416	PGYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4388	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4390	IPYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4153	IOTYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4161	CHYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4391	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4345	ATYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4152	PRYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4155	NTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4172	ALFYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4413	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4356	PSYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4348	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4410	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4477	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4236	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4349	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4226	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4223	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4224	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4161	CHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4150	RPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4155	NTYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4408	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4427	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4250	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4296	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4277	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4406	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4412	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4414	WHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4335	EYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4191	SSAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4428	CPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4380	MCPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4385	OTFYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4429	PPPYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4386	REYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4387	OCTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4212	OCYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4389	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4346	GAAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4222	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4233	HRs	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4516	TIME	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4445	PSDRGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4225	PLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4221	PFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4243	RSFANEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4369	PCMEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4220	BEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4209	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4287	HMPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4395	EPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4157	HCTPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4154	INTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4227	APDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4158	IEDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4228	CTIDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4229	IDDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4156	ITDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4230	PCMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4234	ICSDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4231	HRDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4232	DHDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4321	BAPRE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4190	RAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4244	HMPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4437	EPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4210	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4211	RWPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4216	PLPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4215	CPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4193	MCPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4194	SAPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4146	PGPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4195	PPPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4196	OCTPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4198	PSDPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4199	IPLPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4200	PFPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4201	PCMPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4202	APPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4237	LPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4238	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4357	IPPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4171	SSAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4359	ESPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4206	PMEPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4182	OFPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4183	EHPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4184	NTFPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4185	REPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4332	PAEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4555	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4208	CTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4273	ELEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4333	FFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4207	JHEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4306	KEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4319	PAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4283	PON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4556	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4217	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4290	ISEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4320	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4186	OCEPUG3	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4347	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4167	SPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4358	EPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4289	AIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4242	FAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4566	GPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4219	ICSPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4318	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4189	BPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4197	DHPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4203	FAEPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4188	ICSPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4405	SKEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4399	BLMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4322	PEDMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4397	GAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4192	HAPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4265	PAPUGYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4151	EDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4159	HCT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4392	HMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4323	HIVA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4400	SPP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4291	POE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4324	PAE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4401	ST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4213	ETMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4169	LPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4325	POSMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4292	PCCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4304	ASCAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4403	OTS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4293	PSDRG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4326	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4272	FLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4294	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4398	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4305	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4295	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4327	ETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4404	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4297	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4382	PMOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4328	ASCA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4298	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4299	BIOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4330	PFR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4300	LAWA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4301	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4565	APHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4394	CONTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4396	MTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4415	POSPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4313	FRLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4274	POL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4275	TTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4285	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4278	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4281	WLPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4308	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4309	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4279	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4282	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4284	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4315	ITBL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4311	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4317	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4235	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4173	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4218	IGSP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4540	APMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4276	LOM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4280	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4187	POM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4393	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4160	HOCTMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4450	DISSER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4248	ATPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4337	OSAD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4340	DFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4341	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4342	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4364	AFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4381	AQKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4367	OIAF	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4368	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4370	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4365	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4329	DEMC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4366	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4303	HRPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4310	AQLKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4162	MAHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4378	HPICK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4338	MAISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4339	PHIH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4331	POLA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4374	PHMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4371	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4372	MFAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4422	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4373	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4259	IGSPI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4263	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4531	GREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4536	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4377	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4249	NIETZ	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4312	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4260	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4264	PHILAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4351	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4266	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4379	ARGWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4166	ECONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4214	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4307	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4344	CONTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4352	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4175	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4267	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4251	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4254	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4353	RETREAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4268	CONTLit	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4375	PEOPLES	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4176	ALFPUG	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4252	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4177	THNGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4376	THGARD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4253	PHMATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4256	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4178	HITFILM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4270	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4362	POLTHEO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4179	PHILMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4384	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4181	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4519	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4314	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4255	DISSERT	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4354	DISSERT	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4523	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4524	ICTNET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4537	ENVIRON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4436	FLYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4538	ICTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4541	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4532	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4543	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4542	SOCILPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4544	ENVIRON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4545	EDUC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4180	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4316	CONFMANG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4269	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4411	DHBAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4402	DEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4174	HIVAIDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4257	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4383	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4454	INTROPM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4361	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4262	MARX	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4271	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4363	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4258	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4350	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4163	METAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4261	PHOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4525	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4149	NGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4550	ECON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4552	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4549	ENVIRON	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4551	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4553	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4546	PHILREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4547	PHILSICEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4548	POLIPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4533	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4554	THEATRE2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4557	BLETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4558	EGYPTGREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4526	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4559	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4560	DEWEY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4561	SOCSPIR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4562	SOCSPIR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4563	ENVIRONETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4564	SPECIALED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4239	PMEYR3	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4534	SOCIALS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4567	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4583	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4568	MATHS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4458	APPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4569	ICTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4570	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4586	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4571	MATHS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4343	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4590	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4572	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4573	ARISETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4574	ARISETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4575	KANTEPIS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4576	KANTEPIS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4165	PHILANTH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4577	SHONA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4578	SHONA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4579	PHIOFLIFE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4580	PHIOFLIFE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4581	ISLAMAFRIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4582	ISLAMAFRIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4584	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4585	GENDER2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4587	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4589	GENDER2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4591	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4592	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4593	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4594	SIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4595	SIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4596	AFRIPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4597	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4598	CCNA1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4599	CCNA1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4600	ARISTM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4601	ETHICSD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4602	PSYCHIN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4603	SOCEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4604	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4605	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4606	SOEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4607	CORPG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4608	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4609	ARISTM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4610	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4611	CORPG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4612	ETHICSD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4613	PSYCHIN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4614	PHILI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4615	SOCEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4616	SOEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4617	FANON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4620	FANON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4621	PHILI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4622	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4623	BIOET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4624	PHILED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4625	ECONO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4626	PHILPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4627	PHILDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2017	3	4628	LITPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4629	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4630	HEGELN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4631	HEGELN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4632	AFLIT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4633	PERSON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4634	AFRICANH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4635	PHERM	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4636	CHILDP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4637	CHILDP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4638	PLATOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4639	PLATOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4640	NGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4641	Hebrew	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4642	CCNA2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4643	CCNA2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4646	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4649	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4651	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4644	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4652	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4648	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4650	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4656	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4645	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4654	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4655	BATFLYR1	\N	\N	\N	10	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4647	BATFLYR1	\N	\N	\N	24	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4653	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4658	BATFLYR1	\N	\N	\N	6	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4657	BATFLYR1	\N	\N	\N	10	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4670	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4662	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4664	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4666	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4665	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4668	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4659	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4663	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4669	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4660	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	4661	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4732	PHWRI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4810	HMPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4764	APOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5042	ARTL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4733	AFPSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4769	ARTL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4952	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4953	Dewey	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4954	PHMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4955	SPNEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4956	FREUD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4698	PolPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4694	PHREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4982	ARGW	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4959	AFTLIT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4960	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4961	PGDMETA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4962	HMPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4963	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4965	TAYLOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4967	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4968	MARCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4771	PHYSICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4970	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4972	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4973	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4990	GABRIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5000	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5002	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5003	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5004	PSYCHOED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5005	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5006	DISASTERC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5007	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4809	LTIN	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4941	PHWRI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4942	CHRTA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4765	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4770	AFCHRIST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4978	Laudatosi	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4980	PSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4983	ORALC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5056	PGDCON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4984	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5018	HEGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4986	GUIDANCE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4987	PHYSICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4988	GUIDANCE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4969	MICROSOFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4989	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5020	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5015	CATOHSO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5016	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4677	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5021	DISASTERC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5022	LEADERSHIP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4993	ART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4994	GENDER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4964	MDRSK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5011	IRELATIONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4997	MICROSOFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4998	GENDER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4999	IRELATIONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5029	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4991	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4992	APSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5010	SOCPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4985	PHILANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5026	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5014	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5048	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5008	Dewey	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4974	IKANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4951	IKANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4976	INTROPM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4981	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5019	HEGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5013	AQUINAS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5001	AQUINASM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5009	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5025	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4995	HEPW	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5034	ANALYSISII	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5027	SOCPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5028	ANALYSISII	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5039	MORALITYA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5023	MLL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5033	CSTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5024	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5035	CATOHSO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5036	STUART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5031	SGFREUD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5032	SPNEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5041	STUART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5038	LITURGY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4678	PSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5108	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5043	LITURGY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4931	BAFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5120	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4879	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5092	MRYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5049	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4944	VT2YR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4947	APYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4676	RWYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4855	PTDYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4943	ITYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5146	PLYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4946	ESYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4857	HMYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5017	EHYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5147	APYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5053	NTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4940	PGYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4912	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4914	IPYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4683	IOTYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4691	CHYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4915	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4870	ATYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4682	PRYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4685	NTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4702	ALFYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4937	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4880	PSYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4872	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4934	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4996	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4761	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4873	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4751	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4749	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4750	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4691	CHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4680	RPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4685	NTYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4932	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4948	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4774	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4818	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4803	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4930	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4936	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4938	WHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4856	EYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4720	SSAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4949	CPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4904	MCPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4909	OTFYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4950	PPPYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4910	REYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4911	OCTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4740	OCYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4913	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4675	GAAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4748	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4758	HRs	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5037	TIME	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4966	PSDRGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4782	PLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4747	PFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4767	RSFANEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4893	PCMEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4781	BEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4737	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4861	HMPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4919	EPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4687	HCTPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4684	INTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4752	APDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4688	IEDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4753	CTIDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4754	IDDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4686	ITDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4755	PCMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4759	ICSDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4756	HRDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4757	DHDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4843	BAPRE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4719	RAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4768	HMPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4958	EPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4738	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4739	RWPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4743	PLPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4742	CPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5121	MCPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4722	SAPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4671	PGPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4723	PPPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4724	OCTPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4726	PSDPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4727	IPLPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4728	PFPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4729	PCMPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4730	APPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4673	LPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4762	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4881	IPPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4701	SSAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4883	ESPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4734	PMEPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4711	OFPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4712	EHPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4713	NTFPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4714	REPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4854	PAEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5069	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4736	CTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4799	ELEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4860	FFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4735	JHEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4828	KEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4841	PAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4807	PON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5070	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4744	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4812	ISEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4842	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4715	OCEPUG3	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4871	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4697	SPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4882	EPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4811	AIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4766	FAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5080	GPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4746	ICSPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4840	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4718	BPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4725	DHPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4731	FAEPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4717	ICSPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4929	SKEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4923	BLMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4844	PEDMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4921	GAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4721	HAPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4791	PAPUGYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4681	EDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4689	HCT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4916	HMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4845	HIVA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4924	SPP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4813	POE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4846	PAE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4925	ST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4783	ETMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4699	LPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4847	POSMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4814	PCCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4826	ASCAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4927	OTS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4815	PSDRG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4848	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4798	FLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4816	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4922	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4827	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4817	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4849	ETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4928	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4819	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4906	PMOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4850	ASCA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4820	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4821	BIOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4852	PFR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4822	LAWA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4823	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5079	APHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4918	CONTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4920	MTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4939	POSPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4835	FRLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4800	POL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4801	TTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4862	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4863	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4805	WLPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4830	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4831	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5122	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4806	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4808	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4837	ITBL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4833	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4839	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4760	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4703	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4745	IGSP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5057	APMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4802	LOM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4804	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4716	POM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4917	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4690	HOCTMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4971	DISSER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4772	ATPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4858	OSAD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4865	DFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4866	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4867	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4888	AFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4905	AQKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4891	OIAF	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4892	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4894	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4889	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4851	DEMC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4890	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4825	HRPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4832	AQLKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4692	MAHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4902	HPICK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4859	MAISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4864	PHIH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4853	POLA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4898	PHMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4895	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4896	MFAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4945	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4897	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4785	IGSPI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4789	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5050	GREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5054	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4901	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4773	NIETZ	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4834	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4786	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4790	PHILAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4875	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4792	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4903	ARGWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4696	ECONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4741	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4829	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4869	CONTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4876	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4672	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4793	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4780	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4777	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4877	RETREAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4794	CONTLit	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4899	PEOPLES	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4705	ALFPUG	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4775	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4706	THNGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4900	THGARD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4776	PHMATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4779	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4707	HITFILM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4796	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4886	POLTHEO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4708	PHILMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4908	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4710	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5040	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4836	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4778	DISSERT	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4878	DISSERT	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5044	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5045	ICTNET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5094	ENVIRON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4957	FLYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5055	ICTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5058	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5051	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5060	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5059	SOCILPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5061	ENVIRON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5062	EDUC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4709	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4838	CONFMANG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4795	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4935	DHBAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4926	DEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4704	HIVAIDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4674	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4907	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4975	INTROPM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4885	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4788	MARX	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4797	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4887	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4784	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4874	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4693	METAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4787	PHOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5046	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4679	NGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5064	ECON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5066	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5095	ENVIRON	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5065	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5067	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5063	PHILREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5097	PHILSICEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5096	POLIPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5093	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5068	THEATRE2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5071	BLETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5072	EGYPTGREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5047	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5073	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5074	DEWEY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5075	SOCSPIR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5076	SOCSPIR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5077	ENVIRONETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5078	SPECIALED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4763	PMEYR3	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5052	SOCIALS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5081	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5103	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5082	MATHS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4979	APPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5083	ICTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5084	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5106	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5085	MATHS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4868	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5110	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5086	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5087	ARISETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5088	ARISETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5089	KANTEPIS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5090	KANTEPIS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4695	PHILANTH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5091	SHONA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5098	SHONA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5099	PHIOFLIFE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5100	PHIOFLIFE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5101	ISLAMAFRIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5102	ISLAMAFRIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5104	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5105	GENDER2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5107	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5109	GENDER2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5111	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5112	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5113	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5114	SIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5115	SIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5116	AFRIPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5117	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5118	CCNA1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5119	CCNA1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5123	ARISTM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5124	ETHICSD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5125	PSYCHIN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5126	SOCEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5127	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5128	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5138	SOEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5129	CORPG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5130	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5131	ARISTM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5132	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5133	CORPG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5134	ETHICSD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5135	PSYCHIN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5136	PHILI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5137	SOCEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5139	SOEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5140	FANON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5141	FANON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5142	PHILI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5143	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5144	BIOET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5145	PHILED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5148	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5149	HEGELN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5150	HEGELN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5151	AFLIT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5152	PERSON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5153	AFRICANH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5154	PHERM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5155	CHILDP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5156	CHILDP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5157	PLATOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5158	PLATOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5159	NGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5160	Hebrew	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5161	CCNA2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5162	CCNA2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5165	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5167	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5170	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5163	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5171	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5168	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5169	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5175	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5164	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5173	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5174	BATFLYR1	\N	\N	\N	10	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5166	BATFLYR1	\N	\N	\N	24	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5172	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5177	BATFLYR1	\N	\N	\N	6	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5176	BATFLYR1	\N	\N	\N	10	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5188	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5181	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5183	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5185	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5184	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5186	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5178	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5182	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5187	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5179	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5180	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5189	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5190	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	5191	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	5192	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5193	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5195	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5194	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5196	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5197	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	4933	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5198	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5199	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5200	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2018	3	5202	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5203	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5204	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5206	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5207	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5208	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5209	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5210	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5211	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5212	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5205	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5213	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5214	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5215	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5216	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5217	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5218	ASIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5219	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5220	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5221	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5222	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5223	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5224	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5227	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5228	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5229	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5230	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5231	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5232	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5233	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5234	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5242	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5241	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5243	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5245	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5240	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5248	TFTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5246	TFTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5247	TFTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5244	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5249	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5250	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5251	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5344	PHWRI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5419	HMPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5374	APOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5646	ARTL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5345	AFPSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5379	ARTL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5556	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5557	Dewey	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5558	PHMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5559	SPNEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5560	FREUD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5310	PolPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5306	PHREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5590	ARGW	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5563	AFTLIT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5564	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5565	PGDMETA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5566	HMPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5567	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5573	TAYLOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5575	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5576	MARCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5381	PHYSICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5578	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5580	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5581	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5598	GABRIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5607	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5608	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5609	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5610	PSYCHOED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5611	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5612	DISASTERC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5254	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5491	LTIN	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5548	PHWRI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5549	CHRTA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5375	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5380	AFCHRIST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5586	Laudatosi	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5588	PSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5591	ORALC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5658	PGDCON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5592	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5622	HEGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5594	GUIDANCE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5595	PHYSICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5596	GUIDANCE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5577	MICROSOFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5597	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5624	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5619	CATOHSO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5620	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5289	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5625	DISASTERC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5626	LEADERSHIP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5601	ART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5602	GENDER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5568	MDRSK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5274	IRELATIONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5605	MICROSOFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5606	GENDER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5647	IRELATIONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5633	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5599	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5600	APSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5615	SOCPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5593	PHILANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5630	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5618	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5654	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5613	Dewey	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5582	IKANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5555	IKANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5584	INTROPM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5589	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5623	HEGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5617	AQUINAS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5648	AQUINASM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5614	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5629	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5603	HEPW	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5638	ANALYSISII	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5631	SOCPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5632	ANALYSISII	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5643	MORALITYA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5627	MLL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5637	CSTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5628	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5639	CATOHSO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5640	STUART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5635	SGFREUD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5636	SPNEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5645	STUART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5642	LITURGY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5290	PSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5709	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5649	LITURGY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5539	BAFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5721	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5489	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5694	MRYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5261	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5570	VT2YR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5551	APYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5288	RWYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5463	PTDYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5569	ITYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5751	PLYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5571	ESYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5465	HMYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5621	EHYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5752	APYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5726	NTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5547	PGYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5520	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5522	IPYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5295	IOTYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5303	CHYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5523	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5478	ATYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5294	PRYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5297	NTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5314	ALFYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5544	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5492	PSYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5480	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5541	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5604	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5371	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5481	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5362	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5360	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5361	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5303	CHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5292	RPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5297	NTYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5540	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5552	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5384	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5427	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5413	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5538	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5543	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5545	WHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5464	EYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5332	SSAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5553	CPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5513	MCPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5517	OTFYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5554	PPPYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5518	REYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5519	OCTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5351	OCYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5521	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5287	GAAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5359	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5253	HRs	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5641	TIME	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5574	PSDRGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5392	PLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5358	PFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5377	RSFANEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5502	PCMEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5391	BEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5349	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5469	HMPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5527	EPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5299	HCTPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5296	INTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5363	APDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5300	IEDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5364	CTIDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5365	IDDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5298	ITDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5366	PCMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5369	ICSDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5367	HRDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5368	DHDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5451	BAPRE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5331	RAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5378	HMPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5562	EPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5268	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5350	RWPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5354	PLPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5353	CPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5722	MCPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5334	SAPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5252	PGPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5335	PPPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5336	OCTPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5338	PSDPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5339	IPLPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5340	PFPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5341	PCMPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5342	APPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5285	LPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5372	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5490	IPPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5313	SSAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5488	ESPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5346	PMEPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5323	OFPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5324	EHPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5325	NTFPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5326	REPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5462	PAEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5671	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5348	CTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5409	ELEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5468	FFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5347	JHEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5437	KEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5449	PAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5417	PON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5672	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5355	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5421	ISEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5450	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5327	OCEPUG3	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5479	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5309	SPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5487	EPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5420	AIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5376	FAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5682	GPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5357	ICSPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5448	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5330	BPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5337	DHPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5343	FAEPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5329	ICSPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5537	SKEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5531	BLMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5452	PEDMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5529	GAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5333	HAPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5401	PAPUGYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5293	EDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5301	HCT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5524	HMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5453	HIVA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5532	SPP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5422	POE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5454	PAE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5533	ST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5393	ETMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5311	LPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5455	POSMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5423	PCCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5435	ASCAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5535	OTS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5424	PSDRG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5456	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5408	FLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5425	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5530	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5436	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5426	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5457	ETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5536	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5428	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5514	PMOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5458	ASCA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5429	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5430	BIOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5460	PFR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5431	LAWA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5432	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5681	APHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5526	CONTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5528	MTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5546	POSPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5443	FRLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5410	POL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5411	TTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5470	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5471	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5415	WLPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5439	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5440	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5723	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5416	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5418	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5445	ITBL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5441	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5447	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5370	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5315	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5356	IGSP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5659	APMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5412	LOM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5414	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5328	POM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5525	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5302	HOCTMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5579	DISSER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5382	ATPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5466	OSAD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5473	DFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5474	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5475	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5497	AFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5572	AQKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5500	OIAF	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5501	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5503	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5498	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5459	DEMC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5499	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5434	HRPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5266	AQLKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5304	MAHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5511	HPICK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5467	MAISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5472	PHIH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5461	POLA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5507	PHMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5504	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5505	MFAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5550	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5506	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5395	IGSPI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5399	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5655	GREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5727	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5510	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5383	NIETZ	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5442	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5396	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5400	PHILAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5483	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5402	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5512	ARGWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5308	ECONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5352	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5438	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5477	CONTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5484	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5284	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5403	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5390	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5387	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5485	RETREAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5404	CONTLit	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5508	PEOPLES	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5317	ALFPUG	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5385	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5318	THNGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5509	THGARD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5386	PHMATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5389	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5319	HITFILM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5406	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5495	POLTHEO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5320	PHILMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5516	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5322	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5644	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5444	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5388	DISSERT	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5486	DISSERT	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5650	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5651	ICTNET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5725	ENVIRON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5561	FLYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5657	ICTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5660	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5724	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5662	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5661	SOCILPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5663	ENVIRON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5664	EDUC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5321	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5446	CONFMANG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5405	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5542	DHBAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5534	DEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5316	HIVAIDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5286	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5515	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5583	INTROPM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5494	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5398	MARX	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5407	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5496	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5394	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5482	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5305	METAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5397	PHOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5652	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5291	NGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5666	ECON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5668	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5696	ENVIRON	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5667	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5669	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5665	PHILREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5698	PHILSICEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5697	POLIPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5695	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5670	THEATRE2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5673	BLETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5674	EGYPTGREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5653	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5675	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5676	DEWEY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5677	SOCSPIR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5678	SOCSPIR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5679	ENVIRONETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5680	SPECIALED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5373	PMEYR3	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5656	SOCIALS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5683	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5704	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5684	MATHS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5587	APPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5685	ICTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5686	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5707	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5687	MATHS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5476	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5711	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5688	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5689	ARISETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5690	ARISETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5691	KANTEPIS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5692	KANTEPIS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5307	PHILANTH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5693	SHONA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5699	SHONA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5700	PHIOFLIFE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5701	PHIOFLIFE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5702	ISLAMAFRIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5703	ISLAMAFRIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5705	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5706	GENDER2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5708	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5710	GENDER2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5712	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5713	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5714	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5715	SIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5716	SIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5717	AFRIPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5718	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5719	CCNA1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5720	CCNA1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5728	ARISTM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5729	ETHICSD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5730	PSYCHIN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5731	SOCEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5732	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5733	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5743	SOEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5734	CORPG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5735	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5736	ARISTM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5737	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5738	CORPG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5739	ETHICSD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5740	PSYCHIN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5741	PHILI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5742	SOCEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5744	SOEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5745	FANON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5746	FANON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5747	PHILI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5748	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5749	BIOET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5750	PHILED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5753	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5754	HEGELN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5755	HEGELN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5756	AFLIT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5757	PERSON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5758	AFRICANH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5759	PHERM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5760	CHILDP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5761	CHILDP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5762	PLATOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5763	PLATOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5764	NGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5765	Hebrew	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5766	CCNA2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5767	CCNA2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5770	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5772	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5775	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5768	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5776	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5773	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5774	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5780	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5769	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5778	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5779	BATFLYR1	\N	\N	\N	10	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5771	BATFLYR1	\N	\N	\N	24	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5777	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5782	BATFLYR1	\N	\N	\N	6	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5781	BATFLYR1	\N	\N	\N	10	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5793	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5786	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5788	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5790	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5789	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5791	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5783	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5787	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5792	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5784	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5785	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5255	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5256	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5276	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5280	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5278	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5282	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5283	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5259	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5257	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5258	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5272	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5260	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5267	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5262	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5269	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5273	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5275	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5277	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5279	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5281	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5263	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5264	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5270	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5265	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5271	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5794	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5795	ASIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5796	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5797	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5798	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5799	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5800	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5801	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5802	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5803	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5804	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5805	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5806	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5807	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5808	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5809	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5817	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5816	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5818	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5820	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5815	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5823	TFTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5821	TFTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5822	TFTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5819	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5824	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5825	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2020	3	5826	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5827	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5847	aaaaaaa	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5863	bbbbb	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5867	IMT_	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5868	IMT	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5869	IMT	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5871	iomad	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5916	IMT	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5917	IMT	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5918	IMT	\N	\N	\N	3	Y	\N	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5919	IMt	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5920	IMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5928	IMt	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5869	iomad	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5958	IMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	5966	iomad	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6028	PHWRI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6215	HMPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6378	APOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6299	ARTL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6161	AFPSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6158	ARTL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6132	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6131	Dewey	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6130	PHMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6129	SPNEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6128	FREUD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6466	PolPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6470	PHREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6018	ARGW	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6020	AFTLIT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6041	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6213	PGDMETA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6212	HMPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6330	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6441	TAYLOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6127	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6126	MARCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6156	PHYSICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6327	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6439	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6438	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6437	GABRIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6436	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6317	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6435	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6117	PSYCHOED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6316	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6315	DISASTERC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6199	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6022	LTIN	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6214	PHWRI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6331	CHRTA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6216	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6157	AFCHRIST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6122	Laudatosi	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6121	PSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6040	ORALC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6206	PGDCON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6210	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6310	HEGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6324	GUIDANCE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6323	PHYSICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6119	GUIDANCE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6125	MICROSOFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6060	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6433	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6434	CATOHSO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6114	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6173	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6112	DISASTERC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6187	LEADERSHIP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6208	ART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6320	GENDER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6211	MDRSK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6399	IRELATIONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6318	MICROSOFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6118	GENDER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6106	IRELATIONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6432	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6322	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6321	APSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6312	SOCPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6209	PHILANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6306	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6115	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6427	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6314	Dewey	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6326	IKANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6133	IKANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6124	INTROPM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6120	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6113	HEGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6116	AQUINAS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6429	AQUINASM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6313	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6307	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6207	HEPW	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6302	ANALYSISII	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6111	SOCPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6110	ANALYSISII	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6430	MORALITYA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6309	MLL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6303	CSTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6308	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6109	CATOHSO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6108	STUART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6305	SGFREUD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6304	SPNEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6300	STUART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6107	LITURGY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6392	PSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6093	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6298	LITURGY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6232	BAFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6225	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6235	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6226	MRYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6239	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6227	VT2YR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6484	APYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6500	RWYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6492	PTDYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6228	ITYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6240	PLYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6244	ESYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6249	HMYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6256	EHYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6252	APYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6254	NTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6258	PGYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5977	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5975	IPYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5991	IOTYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5983	CHYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5974	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5978	ATYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5992	PRYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5989	NTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6499	ALFYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6487	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6248	PSYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6346	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6333	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6319	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6379	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5997	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6013	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6015	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6014	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5983	CHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5994	RPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5989	NTYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6231	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6230	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6238	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6236	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6237	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6233	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6488	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6486	WHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6491	EYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6497	SSAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6245	CPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6247	MCPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6246	OTFYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6257	PPPYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6260	REYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6259	OCTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6262	OCYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5976	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6393	GAAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6380	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6408	HRs	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6431	TIME	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6328	PSDRGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6370	PLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6381	PFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6376	RSFANEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6339	PCMEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6371	BEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6384	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6490	HMPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5970	EPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5987	HCTPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5990	INTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5982	APDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5986	IEDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5981	CTIDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5980	IDDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5988	ITDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6012	PCMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6009	ICSDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6011	HRDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6010	DHDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6350	BAPRE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6030	RAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6025	HMPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6021	EPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6035	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6027	RWPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6055	PLPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6056	CPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6036	MCPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6069	SAPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6074	PGPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6068	PPPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6067	OCTPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6167	PSDPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6166	IPLPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6165	PFPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6164	PCMPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6163	APPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6033	LPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6026	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6023	IPPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6032	SSAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6045	ESPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6057	PMEPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6058	OFPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6073	EHPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6072	NTFPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6071	REPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6349	PAEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6295	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6385	CTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6364	ELEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6348	FFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6386	JHEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6358	KEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6144	PAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6051	PON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6104	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6160	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6149	ISEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6143	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6070	OCEPUG3	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6347	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6467	SPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6445	EPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6361	AIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6377	FAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6293	GPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6382	ICSPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6351	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6169	BPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6168	DHPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6162	FAEPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6170	ICSPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6134	SKEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6442	BLMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6455	PEDMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6135	GAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6029	HAPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6054	PAPUGYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5993	EDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5985	HCT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5973	HMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5979	HIVA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5968	SPP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6006	POE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6003	PAE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5995	ST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6462	ETMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6465	LPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6454	POSMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6360	PCCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6359	ASCAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5967	OTS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6005	PSDRG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6002	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6053	FLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6050	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6042	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6048	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6049	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6047	ETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6062	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6066	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6063	PMOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6142	ASCA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6148	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6004	BIOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6001	PFR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6457	LAWA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6495	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6480	APHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5971	CONTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5969	MTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6061	POSPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6493	FRLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6008	POL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6007	TTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6024	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6046	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6052	WLPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6357	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6356	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6279	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6363	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6362	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6353	ITBL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6146	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6145	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6159	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6172	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6383	IGSP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6426	APMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6151	LOM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6150	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6031	POM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5972	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5984	HOCTMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6440	DISSER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6155	ATPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6140	OSAD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6000	DFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5999	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5998	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	5996	AFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6329	AQKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6341	OIAF	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6340	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6338	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6342	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6141	DEMC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6138	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6147	HRPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6182	AQLKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6472	MAHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6443	HPICK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6452	MAISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6451	PHIH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6453	POLA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6444	PHMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6137	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6337	MFAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6485	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6043	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6461	IGSPI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6459	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6482	GREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6253	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6064	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6375	NIETZ	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6355	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6369	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6367	PHILAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6345	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6153	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6234	ARGWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6468	ECONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6463	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6456	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6449	CONTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6447	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6474	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6458	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6372	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6188	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6446	RETREAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6496	CONTLit	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6489	PEOPLES	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6498	ALFPUG	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6250	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6390	THNGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6336	THGARD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6374	PHMATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6373	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6389	HITFILM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6365	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6343	POLTHEO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6388	PHILMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6136	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6171	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6301	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6354	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6261	DISSERT	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6065	DISSERT	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6105	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6185	ICTNET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6255	ENVIRON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6229	FLYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6481	ICTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6039	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6241	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6037	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6038	SOCILPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6059	ENVIRON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6297	EDUC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6387	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6352	CONFMANG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6366	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6332	DHBAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6334	DEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6391	HIVAIDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6394	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6335	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6325	INTROPM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6344	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6368	MARX	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6152	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6139	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6154	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6448	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6471	METAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6460	PHOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6428	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6473	NGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6223	ECON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6221	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6219	ENVIRON	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6222	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6220	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6224	PHILREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6217	PHILSICEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6218	POLIPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6242	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6296	THEATRE2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6425	BLETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6205	EGYPTGREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6483	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6017	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6424	DEWEY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6294	SOCSPIR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6103	SOCSPIR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6423	ENVIRONETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6422	SPECIALED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6251	PMEYR3	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6243	SOCIALS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6292	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6285	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6291	MATHS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6019	APPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6016	ICTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6102	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6095	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6101	MATHS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6450	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6421	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6204	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6290	ARISETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6100	ARISETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6099	KANTEPIS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6289	KANTEPIS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6469	PHILANTH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6288	SHONA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6098	SHONA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6097	PHIOFLIFE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6287	PHIOFLIFE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6286	ISLAMAFRIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6096	ISLAMAFRIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6284	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6283	GENDER2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6094	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6092	GENDER2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6282	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6091	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6420	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6281	SIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6090	SIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6203	AFRIPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6419	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6418	CCNA1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6280	CCNA1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6278	ARISTM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6277	ETHICSD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6276	PSYCHIN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6275	SOCEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6274	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6273	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6271	SOEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6272	CORPG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6089	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6088	ARISTM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6087	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6086	CORPG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6085	ETHICSD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6084	PSYCHIN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6083	PHILI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6082	SOCEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6081	SOEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6080	FANON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6417	FANON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6416	PHILI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6415	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6414	BIOET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6413	PHILED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6412	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6270	HEGELN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6079	HEGELN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6202	AFLIT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6201	PERSON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6200	AFRICANH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6269	PHERM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6268	CHILDP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6078	CHILDP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6077	PLATOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6267	PLATOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6076	NGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6266	Hebrew	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6411	CCNA2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6265	CCNA2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6513	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6511	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6508	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6515	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6507	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6510	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6509	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6503	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6514	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6505	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6504	BATFLYR1	\N	\N	\N	10	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6512	BATFLYR1	\N	\N	\N	24	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6506	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6501	BATFLYR1	\N	\N	\N	6	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6502	BATFLYR1	\N	\N	\N	10	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6527	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6534	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6532	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6530	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6531	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6529	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6537	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6533	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6528	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6536	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6535	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6479	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6478	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6179	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6396	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6177	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6174	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6395	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6406	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6407	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6183	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6475	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6405	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6181	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6404	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6401	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6400	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6398	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6178	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6176	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6175	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6477	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6403	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6180	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6402	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6476	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6075	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6264	ASIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6554	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6553	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6552	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6551	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6550	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6549	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6548	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6547	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6546	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6545	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6544	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6543	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6542	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6541	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6519	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6520	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6518	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6516	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6521	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6538	TFTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6540	TFTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6539	TFTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6517	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6263	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6410	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6409	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6191	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6190	aaaaaaa	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6184	bbbbb	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6397	IMT_	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6034	IMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6197	IMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6196	iomad	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6195	IMt	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6197	iomad	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6193	IMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	25	6192	iomad	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6613	PHWRI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6799	HMPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6938	APOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6964	ARTL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6729	AFPSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6727	ARTL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6758	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6703	Dewey	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6702	PHMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6701	SPNEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6700	FREUD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7038	PolPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7042	PHREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6604	ARGW	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6606	AFTLIT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6626	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6798	PGDMETA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6797	HMPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6896	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7019	TAYLOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6699	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6698	MARCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6725	PHYSICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6893	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7017	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7016	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7015	GABRIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7014	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6883	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7013	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6689	PSYCHOED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6969	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6882	DISASTERC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6787	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6608	LTIN	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6804	PHWRI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6970	CHRTA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6800	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6726	AFCHRIST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6694	Laudatosi	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6693	PSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6625	ORALC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6803	PGDCON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6795	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6879	HEGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6890	GUIDANCE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6889	PHYSICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6691	GUIDANCE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6697	MICROSOFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6647	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7012	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7056	CATOHSO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6755	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6741	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6687	DISASTERC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6774	LEADERSHIP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6793	ART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6886	GENDER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6796	MDRSK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6987	IRELATIONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6884	MICROSOFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6690	GENDER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6753	IRELATIONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7011	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6888	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6887	APSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6968	SOCPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6794	PHILANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6875	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6756	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7049	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6881	Dewey	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6892	IKANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6759	IKANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6696	INTROPM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6692	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6688	HEGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6757	AQUINAS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7054	AQUINASM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6880	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6876	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6792	HEPW	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6871	ANALYSISII	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6686	SOCPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6685	ANALYSISII	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7055	MORALITYA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6878	MLL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6872	CSTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6877	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6684	CATOHSO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6683	STUART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6874	SGFREUD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6873	SPNEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6965	STUART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6754	LITURGY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6945	PSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6681	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6963	LITURGY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6818	BAFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6813	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6821	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6825	MRYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6827	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6814	VT2YR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7086	APYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7081	RWYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7074	PTDYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6815	ITYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6828	PLYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6830	ESYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6834	HMYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6847	EHYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6840	APYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6842	NTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6849	PGYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6565	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6563	IPYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6575	IOTYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6567	CHYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6562	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6579	ATYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6576	PRYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6573	NTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7080	ALFYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7069	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6833	PSYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6972	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6898	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6885	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6939	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6596	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6601	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6603	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6602	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6567	CHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6578	RPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6573	NTYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6817	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6826	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6824	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6822	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6823	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6819	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7070	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7068	WHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7073	EYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7078	SSAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6839	CPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6832	MCPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6831	OTFYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6848	PPPYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6845	REYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6844	OCTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6850	OCYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6564	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6946	GAAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6976	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6996	HRs	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7010	TIME	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6894	PSDRGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6930	PLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6977	PFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6936	RSFANEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6904	PCMEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6931	BEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6980	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7072	HMPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6558	EPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6571	HCTPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6574	INTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6582	APDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6570	IEDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6581	CTIDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6580	IDDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6572	ITDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6600	PCMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6597	ICSDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6599	HRDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6598	DHDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6912	BAPRE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6615	RAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6611	HMPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6607	EPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6623	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6621	RWPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6644	PLPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6645	CPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6624	MCPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6654	SAPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6662	PGPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6653	PPPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6652	OCTPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6735	PSDPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6734	IPLPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6733	PFPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6732	PCMPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6731	APPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6618	LPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6612	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6609	IPPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6617	SSAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6630	ESPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6646	PMEPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6638	OFPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6658	EHPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6657	NTFPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6656	REPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6911	PAEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6960	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6981	CTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6926	ELEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6910	FFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6982	JHEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6920	KEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6714	PAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6635	PON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6751	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6761	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6719	ISEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6713	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6655	OCEPUG3	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6973	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7039	SPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7057	EPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6923	AIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6937	FAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6958	GPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6978	ICSPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6913	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6737	BPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6736	DHPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6730	FAEPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6738	ICSPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6704	SKEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7020	BLMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7029	PEDMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6705	GAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6614	HAPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6637	PAPUGYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6577	EDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6569	HCT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6561	HMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6566	HIVA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6556	SPP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6593	POE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6590	PAE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6583	ST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7035	ETMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7037	LPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7028	POSMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6922	PCCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6921	ASCAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6555	OTS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6592	PSDRG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6589	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6643	FLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6634	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6627	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6632	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6633	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6642	ETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6660	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6651	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6649	PMOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6712	ASCA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6718	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6591	BIOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6588	PFR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7031	LAWA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7077	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7082	APHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6559	CONTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6557	MTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6648	POSPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7075	FRLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6595	POL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6594	TTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6610	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6631	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6636	WLPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6919	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6918	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6867	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6925	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6924	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6915	ITBL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6716	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6715	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6728	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6740	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6979	IGSP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7053	APMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6721	LOM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6720	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6616	POM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6560	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6568	HOCTMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7018	DISSER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6724	ATPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6710	OSAD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6587	DFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6586	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6585	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6584	AFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6895	AQKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6906	OIAF	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6905	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6903	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6907	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6711	DEMC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6708	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6717	HRPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6770	AQLKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7044	MAHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7021	HPICK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7026	MAISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7025	PHIH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7027	POLA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7022	PHMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6707	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6902	MFAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7087	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6628	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7034	IGSPI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7032	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7083	GREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6841	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6650	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6935	NIETZ	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6917	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6929	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6927	PHILAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6971	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6722	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6820	ARGWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7040	ECONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7062	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7030	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7023	CONTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7059	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7046	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7061	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6932	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6775	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7058	RETREAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7088	CONTLit	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7071	PEOPLES	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7079	ALFPUG	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6835	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6943	THNGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6901	THGARD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6934	PHMATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6933	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6942	HITFILM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6974	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6908	POLTHEO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6941	PHILMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6706	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6739	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6966	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6916	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6846	DISSERT	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6661	DISSERT	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6752	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6776	ICTNET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6843	ENVIRON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6816	FLYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7085	ICTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6641	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6829	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6639	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6640	SOCILPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6659	ENVIRON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6962	EDUC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6940	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6914	CONFMANG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6975	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6897	DHBAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6899	DEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6944	HIVAIDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6947	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6900	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6891	INTROPM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6909	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6928	MARX	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6760	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6709	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6723	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7060	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7043	METAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7033	PHOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7050	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7045	NGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6811	ECON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6809	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6807	ENVIRON	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6810	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6808	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6812	PHILREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6805	PHILSICEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6806	POLIPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6837	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6961	THEATRE2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7052	BLETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6802	EGYPTGREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7084	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6620	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7051	DEWEY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6959	SOCSPIR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6750	SOCSPIR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7048	ENVIRONETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7047	SPECIALED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6836	PMEYR3	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6838	SOCIALS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6957	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6950	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6956	MATHS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6605	APPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6619	ICTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6749	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6742	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6748	MATHS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7024	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7009	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6801	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6955	ARISETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6747	ARISETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6746	KANTEPIS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6954	KANTEPIS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7041	PHILANTH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6953	SHONA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6745	SHONA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6744	PHIOFLIFE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6952	PHIOFLIFE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6951	ISLAMAFRIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6743	ISLAMAFRIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6949	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6948	GENDER2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6682	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6680	GENDER2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6870	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6679	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7008	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6869	SIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6678	SIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6791	AFRIPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7007	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7006	CCNA1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6868	CCNA1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6866	ARISTM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6865	ETHICSD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6864	PSYCHIN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6863	SOCEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6862	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6861	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6859	SOEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6860	CORPG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6677	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6676	ARISTM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6675	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6674	CORPG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6673	ETHICSD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6672	PSYCHIN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6671	PHILI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6670	SOCEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6669	SOEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6668	FANON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7005	FANON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7004	PHILI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7003	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7002	BIOET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7001	PHILED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7000	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6858	HEGELN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6667	HEGELN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6790	AFLIT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6789	PERSON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6788	AFRICANH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6857	PHERM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6856	CHILDP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6666	CHILDP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6665	PLATOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6855	PLATOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6664	NGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6854	Hebrew	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6999	CCNA2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6853	CCNA2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7101	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7099	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7096	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7103	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7095	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7098	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7097	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7091	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7102	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7093	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7092	BATFLYR1	\N	\N	\N	10	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7100	BATFLYR1	\N	\N	\N	24	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7094	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7089	BATFLYR1	\N	\N	\N	6	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7090	BATFLYR1	\N	\N	\N	10	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7115	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7121	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7119	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7118	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7125	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7117	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7124	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7120	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7116	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7123	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7122	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7067	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7066	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6767	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6984	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6765	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6762	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6983	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6994	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6995	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6771	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7063	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6993	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6769	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6992	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6989	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6988	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6986	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6766	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6764	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6763	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7065	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6991	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6768	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6990	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7064	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6663	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6852	ASIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7142	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7141	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7140	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7139	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7138	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7137	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7136	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7135	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7134	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7133	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7132	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7131	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7130	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7129	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7107	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7108	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7106	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7104	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7109	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7126	TFTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7128	TFTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7127	TFTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	7105	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6851	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6998	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6997	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6779	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6778	aaaaaaa	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6772	bbbbb	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6985	IMT_	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6622	IMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6785	IMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6784	iomad	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6783	IMt	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6785	iomad	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6781	IMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	27	6780	iomad	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7201	PHWRI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7386	HMPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7526	APOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7552	ARTL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7317	AFPSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7315	ARTL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7346	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7291	Dewey	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7290	PHMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7289	SPNEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7288	FREUD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7626	PolPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7630	PHREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7192	ARGW	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7194	AFTLIT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7214	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7389	PGDMETA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7385	HMPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7484	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7607	TAYLOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7287	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7286	MARCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7313	PHYSICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7481	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7605	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7604	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7603	GABRIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7602	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7471	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7601	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7277	PSYCHOED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7557	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7470	DISASTERC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7375	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7196	LTIN	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7392	PHWRI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7558	CHRTA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7387	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7314	AFCHRIST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7282	Laudatosi	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7281	PSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7213	ORALC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7391	PGDCON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7383	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7467	HEGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7478	GUIDANCE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7477	PHYSICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7279	GUIDANCE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7285	MICROSOFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7235	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7600	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7644	CATOHSO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7343	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7329	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7275	DISASTERC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7362	LEADERSHIP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7381	ART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7474	GENDER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7384	MDRSK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7575	IRELATIONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7472	MICROSOFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7278	GENDER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7341	IRELATIONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7599	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7476	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7475	APSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7556	SOCPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7382	PHILANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7463	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7344	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7637	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7469	Dewey	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7480	IKANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7347	IKANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7284	INTROPM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7280	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7276	HEGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7345	AQUINAS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7642	AQUINASM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7468	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7464	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7380	HEPW	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7459	ANALYSISII	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7274	SOCPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7273	ANALYSISII	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7643	MORALITYA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7466	MLL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7460	CSTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7465	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7272	CATOHSO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7271	STUART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7462	SGFREUD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7461	SPNEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7553	STUART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7342	LITURGY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7533	PSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7269	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7551	LITURGY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7406	BAFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7401	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7409	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7413	MRYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7415	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7402	VT2YR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7674	APYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7669	RWYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7662	PTDYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7403	ITYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7416	PLYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7418	ESYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7422	HMYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7435	EHYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7428	APYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7430	NTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7437	PGYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7153	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7151	IPYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7163	IOTYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7155	CHYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7150	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7167	ATYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7164	PRYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7161	NTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7668	ALFYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7657	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7421	PSYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7560	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7486	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7473	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7527	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7184	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7189	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7191	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7190	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7155	CHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7166	RPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7161	NTYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7405	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7414	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7412	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7410	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7411	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7407	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7658	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7656	WHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7661	EYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7666	SSAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7427	CPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7420	MCPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7419	OTFYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7436	PPPYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7433	REYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7432	OCTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7438	OCYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7152	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7534	GAAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7564	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7584	HRs	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7598	TIME	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7482	PSDRGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7518	PLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7565	PFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7524	RSFANEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7492	PCMEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7519	BEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7568	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7660	HMPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7146	EPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7159	HCTPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7162	INTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7170	APDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7158	IEDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7169	CTIDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7168	IDDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7160	ITDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7188	PCMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7185	ICSDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7187	HRDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7186	DHDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7500	BAPRE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7203	RAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7199	HMPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7195	EPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7211	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7209	RWPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7232	PLPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7233	CPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7212	MCPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7242	SAPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7250	PGPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7241	PPPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7240	OCTPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7323	PSDPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7322	IPLPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7321	PFPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7320	PCMPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7319	APPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7206	LPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7200	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7197	IPPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7205	SSAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7218	ESPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7234	PMEPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7226	OFPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7246	EHPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7245	NTFPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7244	REPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7499	PAEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7548	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7569	CTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7514	ELEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7498	FFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7570	JHEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7508	KEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7302	PAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7223	PON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7339	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7349	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7307	ISEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7301	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7243	OCEPUG3	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7561	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7627	SPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7645	EPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7511	AIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7525	FAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7546	GPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7566	ICSPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7501	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7325	BPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7324	DHPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7318	FAEPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7326	ICSPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7292	SKEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7608	BLMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7617	PEDMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7293	GAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7202	HAPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7225	PAPUGYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7165	EDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7157	HCT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7149	HMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7154	HIVA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7144	SPP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7181	POE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7178	PAE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7171	ST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7623	ETMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7625	LPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7616	POSMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7510	PCCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7509	ASCAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7143	OTS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7180	PSDRG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7177	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7231	FLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7222	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7215	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7220	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7221	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7230	ETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7248	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7239	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7237	PMOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7300	ASCA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7306	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7179	BIOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7176	PFR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7619	LAWA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7665	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7670	APHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7147	CONTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7145	MTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7236	POSPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7663	FRLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7183	POL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7182	TTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7198	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7219	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7224	WLPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7507	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7506	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7455	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7513	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7512	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7503	ITBL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7304	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7303	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7316	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7328	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7567	IGSP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7641	APMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7309	LOM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7308	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7204	POM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7148	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7156	HOCTMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7606	DISSER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7312	ATPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7298	OSAD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7175	DFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7174	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7173	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7172	AFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7483	AQKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7494	OIAF	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7493	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7491	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7495	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7299	DEMC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7296	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7305	HRPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7358	AQLKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7632	MAHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7609	HPICK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7614	MAISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7613	PHIH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7615	POLA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7610	PHMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7295	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7490	MFAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7675	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7216	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7622	IGSPI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7620	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7671	GREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7429	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7238	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7523	NIETZ	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7505	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7517	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7515	PHILAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7559	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7310	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7408	ARGWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7628	ECONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7650	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7618	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7611	CONTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7647	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7634	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7649	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7520	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7363	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7646	RETREAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7676	CONTLit	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7659	PEOPLES	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7667	ALFPUG	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7423	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7531	THNGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7489	THGARD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7522	PHMATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7521	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7530	HITFILM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7562	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7496	POLTHEO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7529	PHILMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7294	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7327	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7554	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7504	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7434	DISSERT	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7249	DISSERT	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7340	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7364	ICTNET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7431	ENVIRON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7404	FLYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7673	ICTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7229	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7417	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7227	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7228	SOCILPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7247	ENVIRON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7550	EDUC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7528	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7502	CONFMANG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7563	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7485	DHBAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7487	DEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7532	HIVAIDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7535	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7488	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7479	INTROPM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7497	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7516	MARX	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7348	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7297	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7311	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7648	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7631	METAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7621	PHOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7638	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7633	NGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7399	ECON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7397	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7395	ENVIRON	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7398	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7396	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7400	PHILREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7393	PHILSICEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7394	POLIPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7425	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7549	THEATRE2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7640	BLETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7390	EGYPTGREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7672	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7208	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7639	DEWEY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7547	SOCSPIR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7338	SOCSPIR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7636	ENVIRONETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7635	SPECIALED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7424	PMEYR3	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7426	SOCIALS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7545	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7538	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7544	MATHS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7193	APPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7207	ICTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7337	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7330	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7336	MATHS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7612	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7597	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7388	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7543	ARISETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7335	ARISETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7334	KANTEPIS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7542	KANTEPIS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7629	PHILANTH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7541	SHONA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7333	SHONA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7332	PHIOFLIFE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7540	PHIOFLIFE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7539	ISLAMAFRIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7331	ISLAMAFRIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7537	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7536	GENDER2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7270	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7268	GENDER2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7458	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7267	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7596	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7457	SIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7266	SIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7379	AFRIPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7595	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7594	CCNA1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7456	CCNA1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7454	ARISTM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7453	ETHICSD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7452	PSYCHIN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7451	SOCEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7450	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7449	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7447	SOEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7448	CORPG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7265	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7264	ARISTM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7263	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7262	CORPG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7261	ETHICSD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7260	PSYCHIN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7259	PHILI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7258	SOCEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7257	SOEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7256	FANON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7593	FANON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7592	PHILI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7591	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7590	BIOET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7589	PHILED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7588	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7446	HEGELN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7255	HEGELN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7378	AFLIT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7377	PERSON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7376	AFRICANH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7445	PHERM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7444	CHILDP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7254	CHILDP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7253	PLATOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7443	PLATOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7252	NGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7442	Hebrew	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7587	CCNA2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7441	CCNA2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7689	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7687	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7684	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7691	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7683	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7686	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7685	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7679	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7690	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7681	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7680	BATFLYR1	\N	\N	\N	10	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7688	BATFLYR1	\N	\N	\N	24	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7682	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7677	BATFLYR1	\N	\N	\N	6	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7678	BATFLYR1	\N	\N	\N	10	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7703	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7709	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7707	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7706	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7713	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7705	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7712	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7708	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7704	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7711	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7710	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7655	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7654	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7355	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7572	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7353	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7350	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7571	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7582	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7583	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7359	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7651	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7581	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7357	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7580	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7577	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7576	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7574	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7354	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7352	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7351	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7653	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7579	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7356	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7578	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7652	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7251	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7440	ASIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7730	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7729	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7728	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7727	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7726	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7725	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7724	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7723	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7722	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7721	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7720	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7719	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7718	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7717	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7695	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7696	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7694	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7692	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7697	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7714	TFTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7716	TFTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7715	TFTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7693	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7439	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7586	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7585	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7367	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7366	aaaaaaa	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7360	bbbbb	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7573	IMT_	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7210	IMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7373	IMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7372	iomad	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7371	IMt	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7373	iomad	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7369	IMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	30	7368	iomad	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8965	PHWRI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9150	HMPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9290	APOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9322	ARTL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9081	AFPSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9079	ARTL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9115	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9055	Dewey	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9054	PHMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9053	SPNEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9052	FREUD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9389	PolPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9393	PHREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8956	ARGW	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8958	AFTLIT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8978	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9153	PGDMETA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9149	HMPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9248	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9371	TAYLOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9051	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9050	MARCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9077	PHYSICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9245	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9369	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9368	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9367	GABRIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9366	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9235	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9365	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9041	PSYCHOED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9325	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9234	DISASTERC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9139	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8960	LTIN	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9156	PHWRI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9326	CHRTA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9151	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9078	AFCHRIST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9046	Laudatosi	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9045	PSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8977	ORALC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9155	PGDCON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9147	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9231	HEGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9242	GUIDANCE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9241	PHYSICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9043	GUIDANCE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9049	MICROSOFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8999	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9364	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9403	CATOHSO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9103	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9102	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9039	DISASTERC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9125	LEADERSHIP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9145	ART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9238	GENDER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9148	MDRSK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9314	IRELATIONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9236	MICROSOFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9042	GENDER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9113	IRELATIONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9363	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9240	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9239	APSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9312	SOCPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9146	PHILANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9227	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9104	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9401	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9233	Dewey	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9244	IKANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9116	IKANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9048	INTROPM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9044	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9040	HEGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9105	AQUINAS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9409	AQUINASM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9232	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9228	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9144	HEPW	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9223	ANALYSISII	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9038	SOCPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9037	ANALYSISII	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9410	MORALITYA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9230	MLL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9224	CSTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9229	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9036	CATOHSO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9035	STUART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9226	SGFREUD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9225	SPNEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9323	STUART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9114	LITURGY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9297	PSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9033	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9321	LITURGY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9170	BAFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9165	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9173	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9177	MRYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9179	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9166	VT2YR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9438	APYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9433	RWYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9426	PTDYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9167	ITYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9180	PLYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9182	ESYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9186	HMYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9199	EHYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9192	APYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9194	NTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9201	PGYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8917	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8915	IPYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8927	IOTYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8919	CHYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8914	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8931	ATYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8928	PRYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8925	NTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9432	ALFYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9421	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9185	PSYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9328	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9250	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9237	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9291	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8948	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8953	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8955	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8954	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8919	CHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8930	RPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8925	NTYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9169	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9178	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9176	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9174	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9175	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9171	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9422	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9420	WHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9425	EYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9430	SSAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9191	CPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9184	MCPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9183	OTFYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9200	PPPYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9197	REYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9196	OCTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9202	OCYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8916	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9298	GAAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9332	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9348	HRs	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9362	TIME	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9246	PSDRGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9282	PLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9333	PFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9288	RSFANEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9256	PCMEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9283	BEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9336	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9424	HMPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8910	EPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8923	HCTPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8926	INTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8934	APDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8922	IEDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8933	CTIDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8932	IDDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8924	ITDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8952	PCMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8949	ICSDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8951	HRDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8950	DHDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9264	BAPRE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8967	RAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8963	HMPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8959	EPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8972	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8974	RWPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8996	PLPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8997	CPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8976	MCPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9006	SAPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9014	PGPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9005	PPPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9004	OCTPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9087	PSDPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9086	IPLPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9085	PFPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9084	PCMPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9083	APPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8970	LPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8964	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8961	IPPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8969	SSAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8982	ESPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8998	PMEPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8990	OFPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9010	EHPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9009	NTFPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9008	REPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9263	PAEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9318	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9337	CTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9278	ELEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9262	FFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9338	JHEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9272	KEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9066	PAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8987	PON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9111	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9118	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9071	ISEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9065	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9007	OCEPUG3	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9329	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9390	SPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9411	EPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9275	AIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9289	FAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9310	GPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9334	ICSPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9265	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9089	BPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9088	DHPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9082	FAEPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9090	ICSPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9056	SKEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9372	BLMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9381	PEDMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9057	GAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8966	HAPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8989	PAPUGYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8929	EDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8921	HCT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8913	HMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8918	HIVA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8908	SPP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8944	POE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8941	PAE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8935	ST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9400	ETMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9388	LPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9380	POSMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9274	PCCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9273	ASCAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8907	OTS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8943	PSDRG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8940	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8995	FLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8986	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8979	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8984	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8985	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8994	ETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9012	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9003	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9001	PMOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9064	ASCA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9070	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8942	BIOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8939	PFR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9383	LAWA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9429	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9434	APHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8911	CONTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8909	MTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9000	POSPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9427	FRLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8946	POL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8945	TTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8962	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8983	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8988	WLPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9271	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9270	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9219	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9277	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9276	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9267	ITBL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9068	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9067	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9080	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9092	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9335	IGSP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9408	APMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9073	LOM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9072	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8968	POM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8912	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8920	HOCTMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9370	DISSER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9076	ATPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9062	OSAD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8938	DFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8937	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8936	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8947	AFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9247	AQKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9258	OIAF	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9257	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9255	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9259	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9063	DEMC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9060	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9069	HRPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9110	AQLKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9395	MAHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9373	HPICK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9378	MAISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9377	PHIH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9379	POLA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9374	PHMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9059	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9254	MFAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9439	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8980	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9386	IGSPI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9384	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9435	GREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9193	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9002	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9287	NIETZ	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9269	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9281	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9279	PHILAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9327	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9074	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9172	ARGWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9391	ECONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9416	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9382	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9375	CONTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9413	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9397	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9415	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9284	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9126	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9412	RETREAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9440	CONTLit	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9423	PEOPLES	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9431	ALFPUG	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9187	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9295	THNGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9253	THGARD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9286	PHMATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9285	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9294	HITFILM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9330	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9260	POLTHEO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9293	PHILMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9058	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9091	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9324	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9268	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9198	DISSERT	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9013	DISSERT	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9112	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9128	ICTNET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9195	ENVIRON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9168	FLYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9437	ICTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8993	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9181	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8991	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8992	SOCILPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9011	ENVIRON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9320	EDUC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9292	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9266	CONFMANG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9331	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9249	DHBAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9251	DEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9296	HIVAIDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9299	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9252	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9243	INTROPM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9261	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9280	MARX	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9117	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9061	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9075	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9414	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9394	METAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9385	PHOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9402	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9396	NGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9163	ECON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9161	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9159	ENVIRON	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9162	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9160	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9164	PHILREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9157	PHILSICEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9158	POLIPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9189	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9319	THEATRE2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9407	BLETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9154	EGYPTGREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9436	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8973	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9406	DEWEY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9317	SOCSPIR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9101	SOCSPIR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9399	ENVIRONETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9398	SPECIALED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9188	PMEYR3	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9190	SOCIALS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9309	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9302	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9308	MATHS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8957	APPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8971	ICTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9100	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9093	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9099	MATHS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9376	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9361	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9152	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9307	ARISETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9098	ARISETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9097	KANTEPIS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9306	KANTEPIS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9392	PHILANTH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9305	SHONA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9096	SHONA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9095	PHIOFLIFE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9304	PHIOFLIFE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9303	ISLAMAFRIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9094	ISLAMAFRIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9301	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9300	GENDER2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9034	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9032	GENDER2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9222	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9031	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9360	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9221	SIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9030	SIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9143	AFRIPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9359	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9358	CCNA1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9220	CCNA1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9218	ARISTM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9217	ETHICSD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9216	PSYCHIN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9215	SOCEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9214	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9213	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9211	SOEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9212	CORPG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9029	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9028	ARISTM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9027	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9026	CORPG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9025	ETHICSD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9024	PSYCHIN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9023	PHILI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9022	SOCEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9021	SOEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9020	FANON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9357	FANON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9356	PHILI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9355	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9354	BIOET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9353	PHILED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9352	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9210	HEGELN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9019	HEGELN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9142	AFLIT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9141	PERSON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9140	AFRICANH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9209	PHERM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9208	CHILDP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9018	CHILDP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9017	PLATOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9207	PLATOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9016	NGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9206	Hebrew	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9351	CCNA2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9205	CCNA2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9453	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9451	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9448	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9455	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9447	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9450	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9449	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9443	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9454	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9445	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9444	BATFLYR1	\N	\N	\N	10	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9452	BATFLYR1	\N	\N	\N	24	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9446	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9441	BATFLYR1	\N	\N	\N	6	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9442	BATFLYR1	\N	\N	\N	10	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9467	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9473	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9471	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9470	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9477	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9469	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9476	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9472	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9468	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9475	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9474	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9419	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9418	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9107	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9340	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9122	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9119	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9339	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9346	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9347	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9123	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9404	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9345	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9109	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9344	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9316	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9315	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9313	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9106	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9121	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9120	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9417	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9343	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9108	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9342	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9405	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9015	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9204	ASIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9494	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9493	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9492	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9491	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9490	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9489	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9488	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9487	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9486	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9485	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9484	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9483	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9482	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9481	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9459	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9460	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9458	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9456	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9461	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9478	TFTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9480	TFTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9479	TFTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9457	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9203	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9350	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9349	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9131	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9130	aaaaaaa	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9127	bbbbb	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9341	IMT_	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	8975	IMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9137	IMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9136	iomad	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9135	IMt	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9137	iomad	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9133	IMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	28	9132	iomad	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9553	PHWRI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9737	HMPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9878	APOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9910	ARTL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9669	AFPSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9667	ARTL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9703	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9643	Dewey	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9642	PHMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9641	SPNEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9640	FREUD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9977	PolPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9981	PHREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9544	ARGW	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9546	AFTLIT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9566	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9741	PGDMETA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9736	HMPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9836	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9959	TAYLOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9639	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9638	MARCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9665	PHYSICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9833	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9957	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9956	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9955	GABRIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9954	LONERGAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9823	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9953	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9629	PSYCHOED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9913	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9822	DISASTERC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9727	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9548	LTIN	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9744	PHWRI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9914	CHRTA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9738	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9666	AFCHRIST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9634	Laudatosi	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9633	PSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9565	ORALC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9743	PGDCON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9740	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9819	HEGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9830	GUIDANCE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9829	PHYSICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9631	GUIDANCE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9637	MICROSOFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9587	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9952	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9991	CATOHSO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9691	AMARTYSEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9690	THEATER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9627	DISASTERC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9713	LEADERSHIP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9733	ART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9826	GENDER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9735	MDRSK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9902	IRELATIONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9824	MICROSOFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9630	GENDER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9701	IRELATIONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9951	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9828	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9827	APSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9900	SOCPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9734	PHILANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9815	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9692	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9989	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9821	Dewey	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9832	IKANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9704	IKANT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9636	INTROPM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9632	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9628	HEGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9693	AQUINAS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9997	AQUINASM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9820	INTROPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9816	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9732	HEPW	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9811	ANALYSISII	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9626	SOCPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9625	ANALYSISII	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9998	MORALITYA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9818	MLL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9812	CSTE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9817	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9624	CATOHSO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9623	STUART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9814	SGFREUD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9813	SPNEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9911	STUART	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9702	LITURGY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9885	PSYCHO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9621	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9909	LITURGY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9758	BAFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9753	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9761	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9765	MRYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9767	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9754	VT2YR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10026	APYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10021	RWYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10014	PTDYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9755	ITYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9768	PLYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9770	ESYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9774	HMYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9787	EHYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9780	APYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9782	NTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9789	PGYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9505	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9503	IPYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9515	IOTYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9507	CHYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9502	HAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9519	ATYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9516	PRYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9513	NTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10020	ALFYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10009	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9773	PSYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9916	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9838	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9825	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9879	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9536	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9541	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9543	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9542	DPTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9507	CHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9518	RPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9513	NTYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9757	ENYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9766	APYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9764	LAYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9762	LYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9763	OCYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9759	RAYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10010	WLYR2	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10008	WHYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10013	EYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10018	SSAYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9779	CPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9772	MCPYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9771	OTFYR3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9788	PPPYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9785	REYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9784	OCTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9790	OCYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9504	CMYR1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9886	GAAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9920	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9936	HRs	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9950	TIME	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9834	PSDRGEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9870	PLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9921	PFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9876	RSFANEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9844	PCMEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9871	BEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9924	APEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10012	HMPYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9498	EPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9511	HCTPDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9514	INTDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9522	APDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9510	IEDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9521	CTIDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9520	IDDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9512	ITDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9540	PCMDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9537	ICSDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9539	HRDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9538	DHDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9852	BAPRE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9555	RAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9551	HMPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9547	EPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9560	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9562	RWPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9584	PLPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9585	CPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9564	MCPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9594	SAPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9602	PGPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9593	PPPPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9592	OCTPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9675	PSDPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9674	IPLPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9673	PFPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9672	PCMPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9671	APPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9558	LPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9552	FLPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9549	IPPUG1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9557	SSAPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9570	ESPPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9586	PMEPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9578	OFPUG2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9598	EHPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9597	NTFPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9596	REPUG3	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9851	PAEEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9906	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9925	CTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9866	ELEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9850	FFEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9926	JHEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9860	KEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9654	PAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9575	PON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9699	BLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9706	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9659	ISEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9653	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9595	OCEPUG3	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9917	STEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9978	SPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9999	EPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9863	AIEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9877	FAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9897	GPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9922	ICSPEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9853	LLEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9677	BPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9676	DHPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9670	FAEPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9678	ICSPUGE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9644	SKEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9960	BLMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9969	PEDMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9645	GAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9554	HAPPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9577	PAPUGYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9517	EDPT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9509	HCT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9501	HMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9506	HIVA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9496	SPP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9532	POE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9529	PAE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9523	ST	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9988	ETMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9976	LPMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9968	POSMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9862	PCCEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9861	ASCAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9495	OTS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9531	PSDRG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9528	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9583	FLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9574	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9567	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9572	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9573	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9582	ETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9600	LOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9591	APHIL	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9589	PMOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9652	ASCA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9658	PCC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9530	BIOE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9527	PFR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9971	LAWA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10017	ROA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10022	APHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9499	CONTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9497	MTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9588	POSPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10015	FRLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9534	POL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9533	TTEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9550	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9571	MRS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9576	WLPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9859	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9858	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9807	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9865	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9864	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9855	ITBL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9656	POR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9655	PLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9668	SLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9680	FL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9923	IGSP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9996	APMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9661	LOM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9660	PTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9556	POM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9500	HOMP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9508	HOCTMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9958	DISSER	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9664	ATPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9650	OSAD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9526	DFL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9525	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9524	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9535	AFT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9835	AQKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9846	OIAF	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9845	MHBT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9843	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9847	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9651	DEMC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9648	HPCIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9657	HRPUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9698	AQLKB	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9983	MAHE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9961	HPICK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9966	MAISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9965	PHIH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9967	POLA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9962	PHMA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9647	PHOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9842	MFAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10027	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9568	PHATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9974	IGSPI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9972	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10023	GREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9781	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9590	PFDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9875	NIETZ	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9857	ACHEBE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9869	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9867	PHILAN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9915	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9662	PHWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9760	ARGWR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9979	ECONS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10004	LOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9970	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9963	CONTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10001	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9985	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10003	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9872	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9714	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10000	RETREAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10028	CONTLit	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10011	PEOPLES	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10019	ALFPUG	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9775	METHEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9883	THNGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9841	THGARD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9874	PHMATH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9873	MLOGIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9882	HITFILM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9918	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9848	POLTHEO	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9881	PHILMIND	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9646	INTROPOL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9679	PHILTEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9912	INTROSAL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9856	MERLEAUP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9786	DISSERT	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9601	DISSERT	\N	\N	\N	4	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9700	MORALITY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9716	ICTNET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9783	ENVIRON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9756	FLYR1	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10025	ICTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9581	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9769	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9579	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9580	SOCILPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9599	ENVIRON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9908	EDUC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9880	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9854	CONFMANG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9919	CURIDEV	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9837	DHBAEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9839	DEL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9884	HIVAIDS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9887	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9840	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9831	INTROPM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9849	SCIEREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9868	MARX	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9705	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9649	INTROHRIGH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9663	INTROPEACE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10002	ARPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9982	METAPH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9973	PHOG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9990	DIOP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9984	NGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9751	ECON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9749	ISLAMIC	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9747	ENVIRON	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9750	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9748	COMPS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9752	PHILREL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9745	PHILSICEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9746	POLIPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9777	LEGAlPHI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9907	THEATRE2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9995	BLETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9742	EGYPTGREEK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10024	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9561	INTROSTAT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9994	DEWEY	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9905	SOCSPIR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9689	SOCSPIR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9987	ENVIRONETH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9986	SPECIALED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9776	PMEYR3	\N	\N	\N	2	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9778	SOCIALS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9898	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9890	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9896	MATHS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9545	APPUG1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9559	ICTPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9688	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9681	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9687	MATHS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9964	BETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9949	EXISTP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9739	ISLAM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9895	ARISETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9686	ARISETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9685	KANTEPIS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9894	KANTEPIS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9980	PHILANTH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9893	SHONA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9684	SHONA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9683	PHIOFLIFE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9892	PHIOFLIFE	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9891	ISLAMAFRIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9682	ISLAMAFRIK	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9889	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9888	GENDER2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9622	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9620	GENDER2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9810	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9619	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9948	PHILAI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9809	SIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9618	SIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9731	AFRIPHIL	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9947	RAWLS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9946	CCNA1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9808	CCNA1	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9806	ARISTM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9805	ETHICSD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9804	PSYCHIN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9803	SOCEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9802	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9801	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9799	SOEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9800	CORPG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9617	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9616	ARISTM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9615	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9614	CORPG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9613	ETHICSD	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9612	PSYCHIN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9611	PHILI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9610	SOCEN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9609	SOEDU	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9608	FANON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9945	FANON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9944	PHILI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9943	PCETHICS	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9942	BIOET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9941	PHILED	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9940	POET	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9798	HEGELN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9607	HEGELN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9730	AFLIT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9729	PERSON	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9728	AFRICANH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9797	PHERM	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9796	CHILDP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9606	CHILDP	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9605	PLATOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9795	PLATOR	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9604	NGUGI	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9794	Hebrew	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9939	CCNA2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9793	CCNA2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10041	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10039	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10036	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10043	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10035	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10038	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10037	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10031	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10042	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10033	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10032	BATFLYR1	\N	\N	\N	10	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10040	BATFLYR1	\N	\N	\N	24	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10034	BATFLYR1	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10029	BATFLYR1	\N	\N	\N	6	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10030	BATFLYR1	\N	\N	\N	10	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10055	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10061	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10059	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10058	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10065	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10057	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10064	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10060	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10056	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10063	BATFLYR3	\N	\N	\N	12	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10062	BATFLYR3	\N	\N	\N	15	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10007	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10006	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9695	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9928	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9710	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9707	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9927	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9934	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9935	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9711	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9992	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9933	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9697	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9932	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9904	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9903	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9901	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9694	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9709	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9708	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10005	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9931	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9696	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9930	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9993	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9603	PUG	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9792	ASIGN	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10082	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10081	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10080	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10079	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10078	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10077	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10076	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10075	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10074	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10073	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10072	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10071	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10070	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10069	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10047	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10048	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10046	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10044	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10049	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10066	TFTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10068	TFTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10067	TFTYR4	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	10045	TFTYR2	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9791	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9938	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9937	MPA	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9719	ICT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9718	aaaaaaa	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9715	bbbbb	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9929	IMT_	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9563	IMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9725	IMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9724	iomad	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9723	IMt	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9725	iomad	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9721	IMT	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	29	9720	iomad	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	10086	APH	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	10083	iomad_test	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
2019	3	10087	iomad_0312	\N	\N	\N	3	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y	Y
\.


--
-- Data for Name: course_sections; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.course_sections (school_year, school_id, course_section_id, course_id, course_credit_title, title, short_name, school_period_id, mp, school_term_id, teacher_id, room, total_seats, filled_seats, does_attendance, does_grades, does_gpa, gender_restriction, house_restriction, credits, availability, rollover_id, parent_id, days, calendar_id, grade_type_id, does_gpa_1, does_gpa_2, does_gpa_3, does_gpa_4, does_gpa_5, cp_checkbox_setting_1, cp_checkbox_setting_2, cp_checkbox_setting_3, cp_checkbox_setting_4, cfield_1, cfield_2, cfield_3, cfield_4, cfield_5, cfield_6, cfield_25, co_teacher_id1, co_teacher_id2, co_teacher_id3, co_teacher_id4, co_teacher_id5, co_teacher_id6, co_teacher_id7, co_teacher_id8, co_teacher_id9, co_teacher_id10, co_teacher1_custom1, co_teacher2_custom1, co_teacher3_custom1, co_teacher4_custom1, co_teacher5_custom1, co_teacher6_custom1, co_teacher7_custom1, co_teacher8_custom1, co_teacher9_custom1, co_teacher10_custom1, co_teacher1_custom2, co_teacher2_custom2, co_teacher3_custom2, co_teacher4_custom2, co_teacher5_custom2, co_teacher6_custom2, co_teacher7_custom2, co_teacher8_custom2, co_teacher9_custom2, co_teacher10_custom2, co_teacher1_checkbox1, co_teacher2_checkbox1, co_teacher3_checkbox1, co_teacher4_checkbox1, co_teacher5_checkbox1, co_teacher6_checkbox1, co_teacher7_checkbox1, co_teacher8_checkbox1, co_teacher9_checkbox1, co_teacher10_checkbox1, cp_checkbox_setting_6, cp_checkbox_setting_7, cp_checkbox_setting_8, co_teacher1_permissions, co_teacher2_permissions, co_teacher3_permissions, co_teacher4_permissions, co_teacher5_permissions, co_teacher6_permissions, co_teacher7_permissions, co_teacher8_permissions, co_teacher9_permissions, co_teacher10_permissions, co_teacher1_report_doe, co_teacher2_report_doe, co_teacher3_report_doe, co_teacher4_report_doe, co_teacher5_report_doe, co_teacher6_report_doe, co_teacher7_report_doe, co_teacher8_report_doe, co_teacher9_report_doe, co_teacher10_report_doe, merge_id, week) FROM stdin;
2012	3	470	809	PTDYR2	Period4 - SEM1 - MonWedFri - A  Manyere	\N	40	SEM	118	30	YR2	\N	24	Y	Y	Y	N	\N	\N	\N	470	470	MonWedFri	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	473	820	EHYR4	Period2 - SEM1 - MonWed - Simon  Makuru	\N	38	SEM	118	45	YR4	\N	21	Y	Y	Y	N	\N	\N	\N	473	473	MonWed	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	574	954	AIYR1	Period5 - T2 - MonWedFri - A  Chennells	\N	33	QTR	41	42	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	\N	574	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	587	967	PEEL	Period7 - SEM 2 - TueThu - A  Zvaiwa	\N	35	SEM	34	51	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	\N	587	TueThu	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	468	797	MRYR1	Period2 - SEM1 - TueThu - C  Nyandoro	\N	38	SEM	118	59	YR1	\N	11	Y	Y	Y	N	\N	\N	\N	468	468	TueThu	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	474	819	APYR4	Period3 - SEM1 - MonWedFri - Bienvenu  Mayemba	\N	39	SEM	118	80	YR3	\N	21	Y	Y	Y	N	\N	\N	\N	474	474	MonWedFri	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	472	821	PGYR4	Period4 - SEM1 - MonWedFri - T  Sherman	\N	40	SEM	118	21	YR4	\N	21	Y	Y	Y	N	\N	\N	\N	472	472	MonWedFri	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	465	812	PSYR3	Period4 - SEM1 - MonThu - Kizito  Kiyimba	\N	40	SEM	118	13	YR3	\N	19	Y	Y	Y	N	\N	\N	\N	465	465	MonThu	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	480	803	RWYR2	Period3 - SEM1 - MonWedFri - Francis  Zangairai	\N	39	SEM	118	78	YR2	\N	24	Y	Y	Y	N	\N	\N	\N	480	480	MonWedFri	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	408	755	FLPUG1	Period1 - SEM1 - MonWedFri - Dominique  Karani	\N	5	SEM	33	54	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	408	408	MonWedFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	454	807	PHAYR2	Period2 - SEM1 - MonWedFri - John  Stacer	\N	38	SEM	118	50	YR2	\N	24	Y	Y	Y	N	\N	\N	\N	454	454	MonWedFri	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	453	862	ALFYR2	Period3 - SEM1 - TueThu - Olivier  Sempiga	\N	39	SEM	118	38	YR2	\N	12	Y	Y	Y	N	\N	\N	\N	453	453	TueThu	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	467	793	HAYR1	Period2 - SEM1 - MonWedFri - P  Nyambara	\N	38	SEM	118	8	YR1	\N	11	Y	Y	Y	N	\N	\N	\N	467	467	MonWedFri	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	469	795	VT2YR1	Period3 - SEM1 - Mon - Joseph  Mahlahla	\N	39	SEM	118	79	YR1	\N	11	Y	Y	Y	N	\N	\N	\N	469	469	Mon	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	657	408	CONP	Period2 - SEM 2 - MonWedFri - John  Sanni	\N	6	SEM	34	82	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	\N	657	MonWedFri	18	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	459	888	APDPT	Period2 - SEM 2 - TueThuFri - Diddy  Brossala	\N	38	SEM	119	24	YR2	\N	1	Y	Y	Y	N	\N	\N	\N	459	459	TueThuFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	484	815	CPYR3	Period2 - SEM 2 - MonWed - Diddy  Brossala	\N	38	SEM	119	24	YR3	\N	19	Y	Y	Y	N	\N	\N	\N	484	484	MonWed	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	457	840	NTYR2	Period1 - SEM1 - TueThu - A  Mandeya	\N	37	SEM	118	20	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	457	457	TueThu	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	84	401	OCYR4	Period1 - SEM 2 - MonTueWedThuFri - John  Stacer	\N	5	SEM	34	50	YR4	\N	206	Y	Y	Y	N	\N	\N	\N	84	84	MonTueWedThuFri	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	339	689	RMHDPTE	Period1 - SEM 2 - TueThu - Kenneth  Makamure	\N	29	SEM	108	56	YR2	\N	1	Y	Y	Y	N	\N	\N	\N	\N	339	TueThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	575	955	PEEL	Period7 - T2 - TueThu - A  Zvaiwa	\N	35	QTR	41	51	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	\N	575	TueThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	588	968	STEL	Period6 - SEM 2 - MonWedFri - Costa  Virgilio	\N	34	SEM	34	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	\N	588	MonWedFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	537	901	SSAPUG1	Period1 - SEM 2 - MonWedThu - Ben  Sachikonye	\N	37	SEM	119	37	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	537	537	MonWedThu	24	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	545	910	ICSPUGE	Period1 - SEM 2 - MonWedFri - K  Esenther	\N	37	SEM	119	22	Computer	\N	0	Y	Y	Y	N	\N	\N	\N	545	545	MonWedFri	24	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	543	914	RAPUG1	Period1 - SEM 2 - MonThuFri - Francis  Zangairai	\N	37	SEM	119	78	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	543	543	MonThuFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	550	935	FAEPUGE	Period1 - SEM 2 - Mon - T  Sherman	\N	37	SEM	119	21	Offices	\N	0	Y	Y	Y	N	\N	\N	\N	550	550	Mon	24	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	557	806	HMPYR2	Period2 - SEM 2 - TueWedFri - T  Sherman	\N	38	SEM	119	21	YR2	\N	24	Y	Y	Y	N	\N	\N	\N	557	557	TueWedFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	458	865	GAAPH	Period1 - SEM1 - MonTueWedThuFri - Ujah  Ejembi	\N	37	SEM	118	26	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	458	458	MonTueWedThuFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	460	891	IDDPT	Period4 - SEM 2 - TueThuFri - C  Nyandoro	\N	40	SEM	119	59	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	460	460	TueThuFri	24	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	461	837	PRYR2	Period2 - SEM1 - MonFri - T  Sherman	\N	38	SEM	118	21	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	461	461	MonFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	463	838	IOTYR1	Period2 - SEM1 - Wed - Zvaiwa  Zvaiwa	\N	38	SEM	118	\N	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	463	463	Wed	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	360	709	PTAPH	Period1 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	29	SEM	108	13	YR4	\N	3	Y	Y	Y	N	\N	\N	\N	\N	360	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	464	861	ATYR2	Period1 - SEM1 - MonFri - J  Chitakure	\N	37	SEM	118	27	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	464	464	MonFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1663	2054	MRS	Period1 - SEM1 - TueThu - C  Nyandoro	\N	77	SEM	143	59	YR1	\N	12	Y	Y	Y	N	\N	\N	\N	1663	1663	TueThu	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2023	2386	HITFILM	Period7 - SEM 2 - MonThu - K  Esenther	\N	91	SEM	149	22	\N	\N	6	Y	Y	Y	N	\N	\N	\N	2023	2023	MonThu	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	638	996	FLS	Period1 - SEM 2 - WedThu - A  Ggita	\N	37	SEM	119	31	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	638	638	WedThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	462	828	IPYR1	Period1 - SEM1 - TueThu - A  Ggita	\N	37	SEM	118	31	YR1	\N	1	Y	Y	Y	N	\N	\N	\N	462	462	TueThu	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	487	873	DPTEL	Period2 - SEM1 - TueThu - A  Mandeya	\N	38	SEM	118	20	YR2	\N	3	Y	Y	Y	N	\N	\N	\N	487	487	TueThu	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	475	826	CMYR1	Period1 - SEM1 - MonWedFri - C  Nyandoro	\N	37	SEM	118	59	YR1	\N	1	Y	Y	Y	N	\N	\N	\N	475	475	MonWedFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	576	956	SKEL	Period8 - T2 - TueThu - Diddy  Brossala	\N	36	QTR	41	24	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	\N	576	TueThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	202	555	SPMA	Period2 - SEM 2 - TueWed -   Fekete	\N	22	SEM	58	72	Seminar	\N	4	Y	Y	Y	N	\N	\N	\N	202	202	TueWed	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	340	690	APDPTE	Period1 - SEM 2 - TueThu - A  Zvaiwa	\N	29	SEM	108	51	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	\N	340	TueThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	589	969	PAEL	Period7 - SEM 2 - TueThu - A  Ggita	\N	35	SEM	34	31	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	\N	589	TueThu	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	180	533	WLYR2	Period4 - SEM 2 - MonWed - A  Chennells	\N	24	SEM	58	42	YR2	\N	22	Y	Y	Y	N	\N	\N	\N	180	180	MonWed	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	189	542	CHDPT	Period2 - SEM1 - MonThuFri - J  Zimbudzana	\N	22	SEM	59	70	YR1	\N	8	Y	Y	Y	N	\N	\N	\N	189	189	MonThuFri	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	344	694	HMPYR3	Period2 - SEM1 - MonTueWedThuFri - Simon  Makuru	\N	30	SEM	109	45	YR3	\N	29	Y	Y	Y	N	\N	\N	\N	\N	344	MonTueWedThuFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	392	741	HRDPTE	Period1 - SEM1 - TueThu - Abel  Chikomo	\N	29	SEM	109	76	Seminar	\N	1	Y	Y	Y	N	\N	\N	\N	\N	392	TueThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	173	526	ALFYR2	Period2 - SEM1 - MonFri - G  Ncube	\N	22	SEM	59	58	YR2	\N	4	Y	Y	Y	N	\N	\N	\N	173	173	MonFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	183	536	SSAYR2	Period4 - SEM 2 - MonTueThu - C  Brand	\N	24	SEM	58	69	YR2	\N	26	Y	Y	Y	N	\N	\N	\N	183	183	MonTueThu	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	174	527	WLYR2	Period3 - SEM1 - MonWed - A  Chennells	\N	23	SEM	59	42	YR2	\N	22	Y	Y	Y	N	\N	\N	\N	174	174	MonWed	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	191	544	IOTDPT	Period3 - SEM 2 - TueWedThu - A  Mandeya	\N	23	SEM	58	20	YR2	\N	8	Y	Y	Y	N	\N	\N	\N	191	191	TueWedThu	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	186	539	IPLDPT	Period4 - SEM1 - MonThuFri - Simon  Makuru	\N	24	SEM	59	45	YR1	\N	8	Y	Y	Y	N	\N	\N	\N	186	186	MonThuFri	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	398	746	PTDPTE	Period1 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	29	SEM	108	13	DIP YR1	\N	2	Y	Y	Y	N	\N	\N	\N	\N	398	MonWedFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	384	733	CADPT	Period3 - SEM 2 - MonThuFri - C  Nyandoro	\N	31	SEM	108	59	DIP YR1	\N	12	Y	Y	Y	N	\N	\N	\N	\N	384	MonThuFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	376	725	TSPAPHE	Period1 - SEM1 - TueThu - A  Chennells	\N	29	SEM	109	42	Seminar	\N	4	Y	Y	Y	N	\N	\N	\N	\N	376	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	368	717	PFAPHE	Period1 - SEM 2 - TueThu - Diddy  Brossala	\N	29	SEM	108	24	YR1	\N	4	Y	Y	Y	N	\N	\N	\N	\N	368	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	126	484	APYR1	Period4 - SEM 2 - TueThu - Odomaro  Mubandizi	\N	12	SEM	43	49	YR1	\N	22	Y	Y	Y	N	\N	\N	\N	126	126	TueThu	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	123	481	EWYR1	Period1 - SEM 2 - TueThuFri - C  Nyandoro	\N	9	SEM	43	59	YR1	\N	22	Y	Y	Y	N	\N	\N	\N	123	123	TueThuFri	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	369	718	GPAPHE	Period1 - SEM 2 - MonWedFri - Ujah Gabriel Ejembi	\N	29	SEM	108	26	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	\N	369	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	385	734	HMPDPT	Period3 - SEM1 - MonTueThu - R  Ngaiza	\N	31	SEM	109	11	DIP YR2	\N	8	Y	Y	Y	N	\N	\N	\N	\N	385	MonTueThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	345	695	PSYR3	Period3 - SEM1 - MonWedFri - Kizito  Kiyimba	\N	31	SEM	109	13	YR3	\N	27	Y	Y	Y	N	\N	\N	\N	\N	345	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	377	726	JFAPHE	Period1 - SEM1 - MonWedFri - C  Matusse	\N	29	SEM	109	19	DIP YR1	\N	3	Y	Y	Y	N	\N	\N	\N	\N	377	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	341	691	PCMDPTE	Period1 - SEM 2 - MonWedFri - A  Mandeya	\N	29	SEM	108	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	\N	341	MonWedFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	184	537	HMPYR2	Period4 - SEM 2 - MonTueWed - T  Chimuka	\N	24	SEM	58	43	YR2	\N	26	Y	Y	Y	N	\N	\N	\N	184	184	MonTueWed	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	178	531	PTDYR2	Period2 - SEM1 - MonWedThu - A  Zvaiwa	\N	22	SEM	59	51	YR2	\N	26	Y	Y	Y	N	\N	\N	\N	178	178	MonWedThu	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	106	468	PCMDPT	Period1 - SEM 2 - MonWedFri - A  Mandeya	\N	5	SEM	34	20	YR3	\N	5	Y	Y	Y	N	\N	\N	\N	106	106	MonWedFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	476	838	IOTYR1	Period2 - SEM1 - WedFri - Zvaiwa  Zvaiwa	\N	38	SEM	118	\N	\N	\N	0	Y	Y	Y	N	\N	\N	\N	476	476	WedFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	477	829	HAYR1	Period3 - SEM1 - TueFri - C  Matusse	\N	39	SEM	118	19	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	477	477	TueFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	478	861	ATYR2	Period4 - SEM1 - Wed - J  Chitakure	\N	40	SEM	118	27	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	478	478	Wed	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	479	837	PRYR2	Period2 - SEM1 - MonFri - T  Sherman	\N	38	SEM	118	21	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	479	479	MonFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	175	528	RWYR2	Period2 - SEM1 - MonWedFri - Dr  Seelan	\N	22	SEM	59	68	YR2	\N	23	Y	Y	Y	N	\N	\N	\N	175	175	MonWedFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	181	534	WHYR2	Period4 - SEM 2 - MonWedThu - R  Roberts	\N	24	SEM	58	60	YR2	\N	22	Y	Y	Y	N	\N	\N	\N	181	181	MonWedThu	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	187	540	HAPDPT	Period4 - SEM1 - TueWedThu - T  Chimuka	\N	24	SEM	59	43	YR1	\N	8	Y	Y	Y	N	\N	\N	\N	187	187	TueWedThu	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1668	2059	PLS	Period6 - SEM1 - MonWed - Costa  Virgilio	\N	82	SEM	143	33	YR 3	\N	1	Y	Y	Y	N	\N	\N	\N	1668	1668	MonWed	47	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1757	2181	VT2YR1	Period3 - SEM1 - Mon - Joseph  Mahlahla	\N	87	SEM	148	79	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	1757	1757	Mon	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	192	545	ITDPT	Period4 - SEM 2 - MonThuFri - J  Chitakure	\N	24	SEM	58	27	YR2	\N	8	Y	Y	Y	N	\N	\N	\N	192	192	MonThuFri	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	203	556	EMA	Period1 - SEM1 - MonFri - Lawrence  Daka	\N	21	SEM	59	44	Seminar	\N	6	Y	Y	Y	N	\N	\N	\N	203	203	MonFri	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	200	553	PPMA	Period3 - SEM 2 - MonWedFri - Odomaro  Mubandizi	\N	23	SEM	58	49	Seminar	\N	4	Y	Y	Y	N	\N	\N	\N	200	200	MonWedFri	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	353	702	CPYR3	Period1 - SEM 2 - MonWedFri - Diddy  Brossala	\N	29	SEM	108	24	YR3	\N	29	Y	Y	Y	N	\N	\N	\N	\N	353	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	361	710	HTAPHE	Period1 - SEM 2 - TueThu - Simon  Makuru	\N	29	SEM	108	45	GYM Room	\N	0	Y	Y	Y	N	\N	\N	\N	\N	361	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	316	680	MMA	Period2 - SEM 2 - MonWedThu - T  Sherman	\N	30	SEM	108	21	Seminar	\N	1	Y	Y	Y	N	\N	\N	\N	199	316	MonWedThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	397	682	PRMA	Period3 - SEM 2 - MonThu - T  Sherman	\N	31	SEM	108	21	Seminar	\N	1	Y	Y	Y	N	\N	\N	\N	\N	397	MonThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	577	957	PAEEL	Period7 - T2 - TueThu - A  Ggita	\N	35	QTR	41	31	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	\N	577	TueThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	124	482	LAYR1	Period3 - SEM 2 - TueWed - Anthony  Chennells	\N	11	SEM	43	42	YR1	\N	22	Y	Y	Y	N	\N	\N	\N	124	124	TueWed	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	121	480	FLYR1	Period1 - SEM 2 - MonWedFri - Dominique  Karani	\N	9	SEM	43	54	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	121	121	MonWedFri	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	128	486	OCYR1	Period3 - SEM 2 - MonFri - A  Zvaiwa	\N	11	SEM	43	51	YR1	\N	22	Y	Y	Y	N	\N	\N	\N	128	128	MonFri	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	125	483	RAYR1	Period2 - SEM 2 - TueWedFri - M  Chirovamavi	\N	10	SEM	43	61	YR1	\N	22	Y	Y	Y	N	\N	\N	\N	125	125	TueWedFri	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	127	485	LYR1	Period3 - SEM 2 - MonWedFri - Simon  Makuru	\N	11	SEM	43	45	YR1	\N	22	Y	Y	Y	N	\N	\N	\N	127	127	MonWedFri	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	117	476	HAYR1	Period1 - SEM1 - MonFri - R  Roberts	\N	9	SEM	44	60	YR1	\N	22	Y	Y	Y	N	\N	\N	\N	117	117	MonFri	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	116	475	LAYR1	Period3 - SEM1 - WedFri - Anthony  Chennells	\N	11	SEM	44	42	YR1	\N	22	Y	Y	Y	N	\N	\N	\N	116	116	WedFri	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	120	479	IPYR1	Period3 - SEM1 - TueThu - Odomaro  Mubandizi	\N	11	SEM	44	49	YR1	\N	22	Y	Y	Y	N	\N	\N	\N	120	120	TueThu	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	118	477	SVCYR1	Period3 - SEM1 - MonFri - W  Cleary	\N	11	SEM	44	14	YR1	\N	44	Y	Y	Y	N	\N	\N	\N	118	118	MonFri	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	115	474	EWYR1	Period2 - SEM1 - WedThu - Joe  Arimoso	\N	10	SEM	44	52	YR1	\N	44	Y	Y	Y	N	\N	\N	\N	115	115	WedThu	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	113	473	FLYR1	Period1 - SEM1 - MonWedFri - Dominique  Karani	\N	9	SEM	44	54	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	113	113	MonWedFri	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	590	970	PAEL	Period7 - SEM 2 - TueThu - A  Ggita	\N	35	SEM	34	31	PUG	\N	0	Y	Y	Y	N	\N	\N	\N	\N	590	TueThu	7	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	119	478	MRSYR1	Period3 - SEM1 - TueThu - C  Nyandoro	\N	11	SEM	44	59	YR1	\N	21	Y	Y	Y	N	\N	\N	\N	119	119	TueThu	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	122	480	FLYR1	Period1 - SEM 2 - MonWedFri - G  Ncube	\N	9	SEM	43	58	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	122	122	MonWedFri	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2008	3	114	473	FLYR1	Period1 - SEM1 - MonWedFri - G  Ncube	\N	9	SEM	44	58	YR2	\N	9	Y	Y	Y	N	\N	\N	\N	114	114	MonWedFri	8	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	386	735	EDPT	Period4 - SEM1 - MonTueWed - K  Addy	\N	32	SEM	109	71	DIP YR2	\N	8	Y	Y	Y	N	\N	\N	\N	\N	386	MonTueWed	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	346	696	PLPYR3	Period4 - SEM1 - TueThuFri - R  Ngaiza	\N	32	SEM	109	11	YR3	\N	27	Y	Y	Y	N	\N	\N	\N	\N	346	TueThuFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	370	719	PCMAPHE	Period1 - SEM 2 - TueThu - A  Mandeya	\N	29	SEM	108	20	DIP YR1	\N	6	Y	Y	Y	N	\N	\N	\N	\N	370	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	362	711	KGAPHE	Period1 - SEM 2 - MonWedFri - Simon  Makuru	\N	29	SEM	108	45	Seminar	\N	3	Y	Y	Y	N	\N	\N	\N	\N	362	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	160	525	FLYR1	Period1 - SEM 2 - MonWedFri - Dominique  Karani	\N	21	SEM	58	54	YR1	\N	16	Y	Y	Y	N	\N	\N	\N	160	160	MonWedFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	481	840	NTYR3	Period2 - SEM1 - TueThu - A  Mandeya	\N	38	SEM	118	20	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	481	481	TueThu	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	482	895	HRs	Period1 - SEM1 - Mon - Costa  Virgilio	\N	37	SEM	118	33	Office	\N	0	Y	Y	Y	N	\N	\N	\N	482	482	Mon	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	354	703	PMEYR3	Period2 - SEM 2 - TueThu - A  Perumalil	\N	30	SEM	108	9	YR3	\N	26	Y	Y	Y	N	\N	\N	\N	\N	354	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	171	525	FLYR1	Period1 - SEM 2 - MonWedFri - G  Ncube	\N	21	SEM	58	58	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	171	171	MonWedFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	164	513	HAYR1	Period1 - SEM1 - MonFri - P  Nyambara	\N	21	SEM	59	8	YR1	\N	18	Y	Y	Y	N	\N	\N	\N	164	164	MonFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	197	546	APYR2	Period4 - SEM 2 - MonFri - K  Addy	\N	24	SEM	58	71	YR1	\N	8	Y	Y	Y	N	\N	\N	\N	197	197	MonFri	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	185	538	CMDPT	Period3 - SEM1 - WedThuFri - A  Zvaiwa	\N	23	SEM	59	51	YR1	\N	8	Y	Y	Y	N	\N	\N	\N	185	185	WedThuFri	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	190	543	CMDPT	Period3 - SEM 2 - MonWedThu - A  Zvaiwa	\N	23	SEM	58	51	YR2	\N	8	Y	Y	Y	N	\N	\N	\N	190	190	MonWedThu	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	188	541	HCTDPT	Period1 - SEM1 - TueWedFri - C  Nyandoro	\N	21	SEM	59	59	YR1	\N	8	Y	Y	Y	N	\N	\N	\N	188	188	TueWedFri	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	378	727	MHAPHE	Period1 - SEM1 - TueThu - Simon  Makuru	\N	29	SEM	109	45	GYM Room	\N	0	Y	Y	Y	N	\N	\N	\N	\N	378	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1993	2242	ECONS	Period8 - SEM 2 - MonFri - Costa  Virgilio	\N	92	SEM	149	33	\N	\N	9	Y	Y	Y	N	\N	\N	\N	1993	1993	MonFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	342	692	TJRDPTE	Period2 - SEM 2 - TueThu - R  Ngaiza	\N	30	SEM	108	11	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	\N	342	TueThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	393	742	TGMMA	Period1 - SEM1 - MonWedFri - John  Stacer	\N	29	SEM	109	50	Seminar	\N	2	Y	Y	Y	N	\N	\N	\N	\N	393	MonWedFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	578	958	STEEL	Period6 - T2 - MonWed - Costa  Virgilio	\N	34	QTR	41	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	\N	578	MonWed	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	591	971	GAEL	Period5 - SEM 2 - MonThu - A  Mandeya	\N	33	SEM	34	20	PUG	\N	0	Y	Y	Y	N	\N	\N	\N	\N	591	MonThu	7	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	343	693	HADPT	Period2 - SEM 2 - TueThuFri - A  Mandeya	\N	30	SEM	108	20	YR2	\N	13	Y	Y	Y	N	\N	\N	\N	\N	343	TueThuFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	387	736	MDPT	Period2 - SEM 2 - MonWedFri - A  Perumalil	\N	30	SEM	108	9	DIP YR2	\N	12	Y	Y	Y	N	\N	\N	\N	\N	387	MonWedFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	347	697	ESPYR3	Period2 - SEM1 - MonWed - Lawrence  Daka	\N	30	SEM	109	44	YR3	\N	29	Y	Y	Y	N	\N	\N	\N	\N	347	MonWed	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	355	704	OTFYR3	Period3 - SEM 2 - TueThuFri - Rev  Gusha	\N	31	SEM	108	77	YR3	\N	24	Y	Y	Y	N	\N	\N	\N	\N	355	TueThuFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	379	728	PMAPHE	Period2 - SEM1 - MonWedFri - Kizito  Kiyimba	\N	30	SEM	109	13	DIP YR1	\N	0	Y	Y	Y	N	\N	\N	\N	\N	379	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	363	712	EFBAPHE	Period1 - SEM 2 - MonWedFri - T  Sherman	\N	29	SEM	108	21	YR3	\N	2	Y	Y	Y	N	\N	\N	\N	\N	363	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	371	720	AADAPHE	Period1 - SEM 2 - MonWed - David  Kaulemu	\N	29	SEM	108	55	YR1	\N	4	Y	Y	Y	N	\N	\N	\N	\N	371	MonWed	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	394	743	DMA	Period4 - SEM1 - MonTueWedThuFri - teacher  teacher	\N	32	SEM	109	28	Offices	\N	6	Y	Y	Y	N	\N	\N	\N	\N	394	MonTueWedThuFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	161	521	OCYR1	Period3 - SEM 2 - MonFri - A  Zvaiwa	\N	23	SEM	58	51	YR1	\N	18	Y	Y	Y	N	\N	\N	\N	161	161	MonFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	177	530	PAYR2	Period4 - SEM1 - MonTueFri - John  Stacer	\N	24	SEM	59	50	YR2	\N	26	Y	Y	Y	N	\N	\N	\N	177	177	MonTueFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	199	552	MMA	Period2 - SEM 2 - MonWedThu - T  Sherman	\N	22	SEM	58	21	Seminar	\N	1	Y	Y	Y	N	\N	\N	\N	199	199	MonWedThu	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	206	559	PSMA	Period4 - SEM1 - MonWed - G  Zinyeka	\N	24	SEM	59	73	Seminar	\N	2	Y	Y	Y	N	\N	\N	\N	206	206	MonWed	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	372	721	ISRAPHE	Period1 - SEM 2 - TueThu - Kizito  Kiyimba	\N	29	SEM	108	13	Seminar	\N	1	Y	Y	Y	N	\N	\N	\N	\N	372	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	364	713	APAPHE	Period1 - SEM 2 - TueThu - A  Zvaiwa	\N	29	SEM	108	51	DIP YR1	\N	0	Y	Y	Y	N	\N	\N	\N	\N	364	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	380	729	HCTDPT	Period3 - SEM1 - MonWedFri - C  Nyandoro	\N	31	SEM	109	59	DIP YR1	\N	13	Y	Y	Y	N	\N	\N	\N	\N	380	MonWedFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	388	737	HCPDPT	Period2 - SEM 2 - TueThu - C  Matusse	\N	30	SEM	108	19	DIP YR2	\N	8	Y	Y	Y	N	\N	\N	\N	\N	388	TueThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	348	698	KMAPHE	Period1 - SEM1 - MonWedFri - R  Ngaiza	\N	29	SEM	109	11	YR2	\N	6	Y	Y	Y	N	\N	\N	\N	\N	348	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	356	705	MCPYR3	Period3 - SEM 2 - MonWedFri - T  Sherman	\N	31	SEM	108	21	YR3	\N	29	Y	Y	Y	N	\N	\N	\N	\N	356	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	554	905	OFPUG2	Period3 - SEM 2 - WedFri - I  Chidavaenzi	\N	39	SEM	119	18	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	554	554	WedFri	24	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	555	934	APPUGE	Period1 - SEM 2 - Mon - A  Perumalil	\N	37	SEM	119	9	Offices	\N	0	Y	Y	Y	N	\N	\N	\N	555	555	Mon	24	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	556	931	IPLPUGE	Period1 - SEM 2 - MonWedFri - T  Sherman	\N	37	SEM	119	21	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	556	556	MonWedFri	24	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	562	911	BPUGE	Period1 - SEM 2 - TueThu - Costa  Virgilio	\N	37	SEM	119	33	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	562	562	TueThu	24	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	395	744	ISRMA	Period3 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	31	SEM	108	13	Seminar	\N	1	Y	Y	Y	N	\N	\N	\N	\N	395	MonWedFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	579	959	BLEL	Period5 - SEM 2 - MonWedFri - John  Stacer	\N	33	SEM	34	50	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	\N	579	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	592	972	ISEL	Period5 - SEM 2 - MonWedFri - A  Manyere	\N	33	SEM	34	30	PUG	\N	0	Y	Y	Y	N	\N	\N	\N	\N	592	MonWedFri	7	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	365	714	PSDAPHE	Period1 - SEM 2 - TueWed - A  Manyere	\N	29	SEM	108	30	Aud Visual	\N	7	Y	Y	Y	N	\N	\N	\N	\N	365	TueWed	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	157	519	APYR1	Period4 - SEM 2 - TueThu - Odomaro  Mubandizi	\N	24	SEM	58	49	YR1	\N	22	Y	Y	Y	N	\N	\N	\N	157	157	TueThu	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	168	522	EWYR1	Period2 - SEM1 - WedThu - C  Nyandoro	\N	22	SEM	59	59	YR1	\N	18	Y	Y	Y	N	\N	\N	\N	168	168	WedThu	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	158	523	EWYR1	Period1 - SEM 2 - TueThuFri - C  Nyandoro	\N	21	SEM	58	59	YR1	\N	18	Y	Y	Y	N	\N	\N	\N	158	158	TueThuFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	169	524	FLYR1	Period1 - SEM1 - MonWedFri - Dominique  Karani	\N	21	SEM	59	54	YR1	\N	16	Y	Y	Y	N	\N	\N	\N	169	169	MonWedFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	172	524	FLYR1	Period1 - SEM1 - MonWedFri - G  Ncube	\N	21	SEM	59	58	YR2	\N	13	Y	Y	Y	N	\N	\N	\N	172	172	MonWedFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	166	516	IPYR1	Period3 - SEM1 - TueThu - Odomaro  Mubandizi	\N	23	SEM	59	49	YR1	\N	21	Y	Y	Y	N	\N	\N	\N	166	166	TueThu	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	165	512	LAYR1	Period3 - SEM1 - WedFri - A  Chennells	\N	23	SEM	59	42	YR1	\N	18	Y	Y	Y	N	\N	\N	\N	165	165	WedFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	159	517	LAYR1	Period3 - SEM 2 - TueWed - A  Chennells	\N	23	SEM	58	42	YR1	\N	18	Y	Y	Y	N	\N	\N	\N	159	159	TueWed	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1665	2056	WLPUG	Period1 - SEM1 - MonWed - A  Chennells	\N	77	SEM	143	42	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	1665	1665	MonWed	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1962	2179	BAFL	Period3 - SEM1 - MonThuFri - Dominique  Karani	\N	87	SEM	148	54	YR1	\N	8	Y	Y	Y	N	\N	\N	\N	1962	1962	MonThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	163	520	LYR1	Period3 - SEM 2 - MonWedFri - Simon  Makuru	\N	23	SEM	58	45	YR1	\N	23	Y	Y	Y	N	\N	\N	\N	163	163	MonWedFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	170	515	MRSYR1	Period3 - SEM1 - TueThu - C  Nyandoro	\N	23	SEM	59	59	YR1	\N	21	Y	Y	Y	N	\N	\N	\N	170	170	TueThu	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	162	518	RAYR1	Period2 - SEM 2 - TueWedFri - J  Chitakure	\N	22	SEM	58	27	YR1	\N	18	Y	Y	Y	N	\N	\N	\N	162	162	TueWedFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	167	514	SVCYR1	Period3 - SEM1 - MonFri - W  Cleary	\N	23	SEM	59	14	YR1	\N	18	Y	Y	Y	N	\N	\N	\N	167	167	MonFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	179	532	ALFYR2	Period2 - SEM 2 - MonThu - G  Ncube	\N	22	SEM	58	58	YR2	\N	4	Y	Y	Y	N	\N	\N	\N	179	179	MonThu	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	182	535	EYR2	Period2 - SEM 2 - MonTueWed - Lawrence  Daka	\N	22	SEM	58	44	YR2	\N	26	Y	Y	Y	N	\N	\N	\N	182	182	MonTueWed	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	176	529	HAPYR2	Period3 - SEM1 - TueThuFri - T  Chimuka	\N	23	SEM	59	43	YR2	\N	26	Y	Y	Y	N	\N	\N	\N	176	176	TueThuFri	15	11	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	193	548	HCTDPT	Period2 - SEM 2 - MonTueThu - C  Nyandoro	\N	22	SEM	58	59	YR2	\N	7	Y	Y	Y	N	\N	\N	\N	193	193	MonTueThu	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	205	558	APMA	Period4 - SEM1 - MonTueWed - David  Kaulemu	\N	24	SEM	59	55	Seminar	\N	4	Y	Y	Y	N	\N	\N	\N	205	205	MonTueWed	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	198	551	EMA	Period1 - SEM 2 - MonThuFri - Kizito  Kiyimba	\N	21	SEM	58	13	Seminar	\N	6	Y	Y	Y	N	\N	\N	\N	198	198	MonThuFri	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	204	557	IPMA	Period3 - SEM1 - MonWedFri - Dr  Seelan	\N	23	SEM	59	68	Seminar	\N	4	Y	Y	Y	N	\N	\N	\N	204	204	MonWedFri	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	207	560	PEMA	Period1 - SEM1 - MonThu - John  Stacer	\N	21	SEM	59	50	Seminar	\N	2	Y	Y	Y	N	\N	\N	\N	207	207	MonThu	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	3	201	554	PRMA	Period4 - SEM 2 - WedFri - T  Sherman	\N	24	SEM	58	21	Seminar	\N	3	Y	Y	Y	N	\N	\N	\N	201	201	WedFri	15	12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	357	706	RMHAPH	Period1 - SEM 2 - MonWedFri - Kenneth  Makamure	\N	29	SEM	108	56	DIP YR2	\N	2	Y	Y	Y	N	\N	\N	\N	\N	357	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	381	730	INTDPT	Period4 - SEM1 - MonThuFri - A  Mandeya	\N	32	SEM	109	20	DIP YR1	\N	12	Y	Y	Y	N	\N	\N	\N	\N	381	MonThuFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	389	738	GADPTE	Period1 - SEM1 - MonWedFri - A  Mandeya	\N	29	SEM	109	20	DIP YR1	\N	0	Y	Y	Y	N	\N	\N	\N	\N	389	MonWedFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	349	699	GAAPHE	Period2 - SEM1 - TueThu - A  Mandeya	\N	30	SEM	109	20	YR3	\N	4	Y	Y	Y	N	\N	\N	\N	\N	349	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	396	745	CPMA	Period2 - SEM 2 - TueThu - Diddy  Brossala	\N	30	SEM	108	24	Seminar	\N	1	Y	Y	Y	N	\N	\N	\N	\N	396	TueThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	373	722	CTPWAPHE	Period1 - SEM1 - MonWedFri - Kizito  Kiyimba	\N	29	SEM	109	13	Seminar	\N	4	Y	Y	Y	N	\N	\N	\N	\N	373	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	351	700	HRAPHE	Period2 - SEM1 - MonFri - Abel  Chikomo	\N	30	SEM	109	76	YR2	\N	4	Y	Y	Y	N	\N	\N	\N	\N	351	MonFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	606	943	LLEL	Period1 - SEM1 - MonWedFri - K  Esenther	\N	37	SEM	118	22	\N	\N	1	Y	Y	Y	N	\N	\N	\N	606	606	MonWedFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	631	989	PCCEL	Period5 - SEM 2 - MonWedFri - A  Mandeya	\N	41	SEM	119	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	631	631	MonWedFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	645	1003	APHIL	Period4 - SEM 2 - TueWed - Diddy  Brossala	\N	40	SEM	119	24	YR1	\N	1	Y	Y	Y	N	\N	\N	\N	645	645	TueWed	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	605	913	BAPRE	Period4 - SEM1 - TueThu - A  Zvaiwa	\N	40	SEM	118	51	\N	\N	4	Y	Y	Y	N	\N	\N	\N	605	605	TueThu	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	358	707	PFAPHE	Period1 - SEM 2 - TueThu - T  Sherman	\N	29	SEM	108	21	DIP YR1	\N	1	Y	Y	Y	N	\N	\N	\N	\N	358	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	293	668	IPLDPT	Period4 - SEM1 - MonThuFri - Kizito  Kiyimba	\N	32	SEM	109	13	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	186	293	MonThuFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	366	715	IJSAPHE	Period1 - SEM 2 - MonThu - A  Manyere	\N	29	SEM	108	30	Aud Visual	\N	5	Y	Y	Y	N	\N	\N	\N	\N	366	MonThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	295	656	WLYR2	Period3 - SEM1 - MonWed - A  Chennells	\N	31	SEM	109	42	YR2	\N	18	Y	Y	Y	N	\N	\N	\N	174	295	MonWed	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	382	731	HMPDPT	Period3 - SEM 2 - TueThuFri - Ujah Gabriel Ejembi	\N	31	SEM	108	26	DIP YR1	\N	13	Y	Y	Y	N	\N	\N	\N	\N	382	TueThuFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	305	657	RWYR2	Period2 - SEM1 - MonWedFri - A  Perumalil	\N	30	SEM	109	9	YR2	\N	24	Y	Y	Y	N	\N	\N	\N	175	305	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	301	660	PTDYR2	Period2 - SEM1 - MonWedThu - A  Zvaiwa	\N	30	SEM	109	51	YR2	\N	24	Y	Y	Y	N	\N	\N	\N	178	301	MonWedThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	291	655	ALFYR2	Period2 - SEM1 - MonFri - G  Ncube	\N	30	SEM	109	58	YR2	\N	13	Y	Y	Y	N	\N	\N	\N	173	291	MonFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	297	662	WLYR2	Period4 - SEM 2 - MonWed - A  Chennells	\N	32	SEM	108	42	YR2	\N	18	Y	Y	Y	N	\N	\N	\N	180	297	MonWed	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	390	739	KMDPTE	Period2 - SEM1 - TueThu - R  Ngaiza	\N	30	SEM	109	11	Seminar	\N	1	Y	Y	Y	N	\N	\N	\N	\N	390	TueThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	294	671	CHDPT	Period2 - SEM1 - MonThuFri - J  Zimbudzana	\N	30	SEM	109	70	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	189	294	MonThuFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	292	673	IOTDPT	Period3 - SEM 2 - TueWedThu - A  Mandeya	\N	31	SEM	108	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	191	292	TueWedThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	299	674	ITDPT	Period4 - SEM 2 - MonThuFri - J  Chitakure	\N	32	SEM	108	27	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	192	299	MonThuFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	300	669	HAPDPT	Period4 - SEM1 - TueWedThu - C  Matusse	\N	32	SEM	109	19	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	187	300	TueWedThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	303	666	HMPYR2	Period4 - SEM 2 - MonTueWed - R  Ngaiza	\N	32	SEM	108	11	YR2	\N	24	Y	Y	Y	N	\N	\N	\N	184	303	MonTueWed	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	304	681	PPMA	Period3 - SEM 2 - MonWedFri - Odomaro  Mubandizi	\N	31	SEM	108	49	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	200	304	MonWedFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	298	683	SPMA	Period2 - SEM 2 - TueWed -   Fekete	\N	30	SEM	108	72	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	202	298	TueWed	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	374	723	ASAPHE	Period2 - SEM1 - TueThu - Lawrence  Daka	\N	30	SEM	109	44	YR3	\N	4	Y	Y	Y	N	\N	\N	\N	\N	374	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	296	665	SSAYR2	Period4 - SEM 2 - MonTueThu - C  Brand	\N	32	SEM	108	69	YR2	\N	19	Y	Y	Y	N	\N	\N	\N	183	296	MonTueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	580	960	BLEL	Period5 - SEM 2 - MonWedFri - John  Stacer	\N	33	SEM	34	50	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	\N	580	MonWedFri	7	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	302	684	EMA	Period1 - SEM1 - MonFri - Lawrence  Daka	\N	29	SEM	109	44	Seminar	\N	2	Y	Y	Y	N	\N	\N	\N	203	302	MonFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	593	973	STEL	Period5 - SEM 2 - MonWedFri - Costa  Virgilio	\N	33	SEM	34	33	PUG	\N	0	Y	Y	Y	N	\N	\N	\N	\N	593	MonWedFri	7	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	352	701	PRAPHE	Period1 - SEM1 - TueThu - Kenneth  Makamure	\N	29	SEM	109	56	DIP YR1	\N	1	Y	Y	Y	N	\N	\N	\N	\N	352	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	383	732	PADPT	Period2 - SEM 2 - MonWedFri - C  Matusse	\N	30	SEM	108	19	DIP YR1	\N	5	Y	Y	Y	N	\N	\N	\N	\N	383	MonWedFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	309	667	CMDPT	Period3 - SEM1 - WedThuFri - A  Zvaiwa	\N	31	SEM	109	51	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	185	309	WedThuFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	307	672	CMDPT	Period3 - SEM 2 - MonWedThu - A  Zvaiwa	\N	31	SEM	108	51	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	190	307	MonWedThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	313	654	FLYR1	Period1 - SEM 2 - MonWedFri - Dominique  Karani	\N	29	SEM	108	54	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	160	313	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	317	650	OCYR1	Period3 - SEM 2 - MonFri - A  Zvaiwa	\N	31	SEM	108	51	YR1	\N	16	Y	Y	Y	N	\N	\N	\N	161	317	MonFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	311	643	HAYR1	Period1 - SEM1 - MonFri - P  Nyambara	\N	29	SEM	109	8	YR1	\N	16	Y	Y	Y	N	\N	\N	\N	164	311	MonFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	322	678	LAYR1	Period3 - SEM 2 - TueWed - A  Chennells	\N	31	SEM	108	42	YR1	\N	16	Y	Y	Y	N	\N	\N	\N	159	322	TueWed	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	308	654	FLYR1	Period1 - SEM 2 - MonWedFri - G  Ncube	\N	29	SEM	108	58	YR1	\N	10	Y	Y	Y	N	\N	\N	\N	171	308	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	329	661	ALFYR2	Period2 - SEM 2 - MonThu - G  Ncube	\N	30	SEM	108	58	YR2	\N	14	Y	Y	Y	N	\N	\N	\N	179	329	MonThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	323	648	APYR1	Period4 - SEM 2 - TueThu - K  Addy	\N	32	SEM	108	71	YR1	\N	24	Y	Y	Y	N	\N	\N	\N	157	323	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	375	724	GMAPHE	Period2 - SEM1 - TueThu - John  Stacer	\N	30	SEM	109	50	YR3	\N	7	Y	Y	Y	N	\N	\N	\N	\N	375	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	324	653	FLYR1	Period1 - SEM1 - MonWedFri - Dominique  Karani	\N	29	SEM	109	54	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	169	324	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	328	677	LAYR1	Period3 - SEM1 - WedFri - A  Chennells	\N	31	SEM	109	42	YR1	\N	16	Y	Y	Y	N	\N	\N	\N	165	328	WedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	326	645	MRSYR1	Period3 - SEM1 - TueThu - A  Perumalil	\N	31	SEM	109	9	YR1	\N	16	Y	Y	Y	N	\N	\N	\N	170	326	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	625	985	POE	Period3 - SEM1 - TueThu - A  Zvaiwa	\N	39	SEM	118	51	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	625	625	TueThu	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	315	687	PSMA	Period4 - SEM1 - MonWed - G  Zinyeka	\N	32	SEM	109	73	Seminar	\N	1	Y	Y	Y	N	\N	\N	\N	206	315	MonWed	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	327	647	RAYR1	Period2 - SEM 2 - TueWedFri - J  Chitakure	\N	30	SEM	108	27	YR1	\N	24	Y	Y	Y	N	\N	\N	\N	162	327	TueWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	337	644	SVCYR1	Period3 - SEM1 - MonFri - W  Cleary	\N	31	SEM	109	14	YR1	\N	16	Y	Y	Y	N	\N	\N	\N	167	337	MonFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	318	664	EYR2	Period2 - SEM 2 - MonTueWed - Lawrence  Daka	\N	30	SEM	108	44	YR2	\N	26	Y	Y	Y	N	\N	\N	\N	182	318	MonTueWed	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	321	658	HAPYR2	Period3 - SEM1 - TueThuFri - K  Addy	\N	31	SEM	109	71	YR2	\N	26	Y	Y	Y	N	\N	\N	\N	176	321	TueThuFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	325	646	IPYR1	Period3 - SEM1 - TueThu - T  Sherman	\N	31	SEM	109	21	YR1	\N	24	Y	Y	Y	N	\N	\N	\N	166	325	TueThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	306	663	WHYR2	Period4 - SEM 2 - MonWedThu - P  Nyambara	\N	32	SEM	108	8	YR2	\N	19	Y	Y	Y	N	\N	\N	\N	181	306	MonWedThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	314	659	PAYR2	Period4 - SEM1 - MonTueFri - John  Stacer	\N	32	SEM	109	50	YR2	\N	26	Y	Y	Y	N	\N	\N	\N	177	314	MonTueFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	391	740	PRDPTE	Period2 - SEM1 - TueThu - Kenneth  Makamure	\N	30	SEM	109	56	DIP YR1	\N	6	Y	Y	Y	N	\N	\N	\N	\N	391	TueThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	359	708	TJRAPH	Period2 - SEM 2 - MonWedFri - R  Ngaiza	\N	30	SEM	108	11	YR3	\N	4	Y	Y	Y	N	\N	\N	\N	\N	359	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	367	716	IAPAPHE	Period2 - SEM 2 - MonWedFri - A  Chennells	\N	30	SEM	108	42	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	\N	367	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	338	653	FLYR1	Period1 - SEM1 - MonWedFri - G  Ncube	\N	29	SEM	109	58	YR2	\N	10	Y	Y	Y	N	\N	\N	\N	172	338	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2314	2432	IOTYR1	Period2 - SEM1 - Wed - Zvaiwa  Zvaiwa	\N	102	SEM	159	\N	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	2314	2314	Wed	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	319	649	LYR1	Period3 - SEM 2 - MonWedFri - Simon  Makuru	\N	31	SEM	108	45	YR1	\N	24	Y	Y	Y	N	\N	\N	\N	163	319	MonWedFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	331	652	EWYR1	Period1 - SEM 2 - TueThuFri - K  Esenther	\N	29	SEM	108	22	YR1	\N	16	Y	Y	Y	N	\N	\N	\N	158	331	TueThuFri	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	312	675	APYR2	Period4 - SEM 2 - MonFri - K  Addy	\N	32	SEM	108	71	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	197	312	MonFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	330	676	HCTDPT	Period2 - SEM 2 - MonTueThu - C  Nyandoro	\N	30	SEM	108	59	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	193	330	MonTueThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	310	670	HCTDPT	Period1 - SEM1 - TueWedFri - C  Nyandoro	\N	29	SEM	109	59	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	188	310	TueWedFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	451	802	WLYR2	Period4 - SEM1 - TueThu - A  Chennells	\N	40	SEM	118	42	YR2	\N	19	Y	Y	Y	N	\N	\N	\N	451	451	TueThu	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	333	686	APMA	Period4 - SEM1 - MonTueWed - David  Kaulemu	\N	32	SEM	109	55	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	205	333	MonTueWed	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	335	679	EMA	Period1 - SEM 2 - MonThuFri - Kizito  Kiyimba	\N	29	SEM	108	13	Seminar	\N	2	Y	Y	Y	N	\N	\N	\N	198	335	MonThuFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	332	685	IPMA	Period3 - SEM1 - MonWedFri - Dr  Seelan	\N	31	SEM	109	68	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	204	332	MonWedFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	334	688	PEMA	Period1 - SEM1 - MonThu - John  Stacer	\N	29	SEM	109	50	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	207	334	MonThu	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	336	682	PRMA	Period4 - SEM1 - WedFri - T  Sherman	\N	32	SEM	109	21	Seminar	\N	1	Y	Y	Y	N	\N	\N	\N	201	336	WedFri	14	16	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2010	3	320	651	EWYR1	Period2 - SEM1 - WedThu - C  Nyandoro	\N	30	SEM	109	59	YR1	\N	16	Y	Y	Y	N	\N	\N	\N	168	320	WedThu	14	15	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	45	442	APEL	Period1 - SEM1 - MonTueWedThuFri - Kenneth  Makamure	\N	5	SEM	33	32	YR3	\N	4	Y	Y	Y	N	\N	\N	\N	45	45	MonTueWedThuFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	24	386	HMYR3	Period4 - SEM1 - TueThu - Ujah  Ejembi	\N	8	SEM	33	26	YR3	\N	29	Y	Y	Y	N	\N	\N	\N	24	24	TueThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	22	388	PLYR3	Period2 - SEM1 - MonWedFri - Diddy  Brossala	\N	6	SEM	33	24	YR3	\N	25	Y	Y	Y	N	\N	\N	\N	22	22	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	47	439	APEL	Period1 - SEM1 - MonTueWedThuFri - Johnny  Stacer	\N	5	SEM	33	10	YR3	\N	13	Y	Y	Y	N	\N	\N	\N	47	47	MonTueWedThuFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	46	438	APEL	Period1 - SEM1 - MonTueWedThuFri - T  Sherman	\N	5	SEM	33	21	YR3	\N	19	Y	Y	Y	N	\N	\N	\N	46	46	MonTueWedThuFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	15	372	ITYR1	Period3 - SEM1 - Tue - A  Ggita	\N	7	SEM	33	31	YR1	\N	26	Y	Y	Y	N	\N	\N	\N	15	15	Tue	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	48	444	APEL	Period1 - SEM1 - MonTueWedThuFri - A  Manyere	\N	5	SEM	33	30	YR3	\N	31	Y	Y	Y	N	\N	\N	\N	48	48	MonTueWedThuFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	17	380	APYR2	Period1 - SEM1 - TueThu - C  Matusse	\N	5	SEM	33	19	YR2	\N	26	Y	Y	Y	N	\N	\N	\N	17	17	TueThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	21	376	WLYR2	Period4 - SEM1 - TueThu - A  Chennells	\N	8	SEM	33	15	YR2	\N	18	Y	Y	Y	N	\N	\N	\N	21	21	TueThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	27	397	NTYR4	Period3 - SEM1 - TueThu - I  Chidavaenzi	\N	7	SEM	33	18	YR4	\N	29	Y	Y	Y	N	\N	\N	\N	27	27	TueThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	41	374	ALFYR2	Period3 - SEM1 - TueThu - G  Ncube	\N	7	SEM	33	16	YR2	\N	15	Y	Y	Y	N	\N	\N	\N	41	41	TueThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	18	382	PHAYR2	Period2 - SEM1 - MonWedFri - Johnny  Stacer	\N	6	SEM	33	10	YR2	\N	26	Y	Y	Y	N	\N	\N	\N	18	18	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	44	440	APEL	Period1 - SEM1 - MonThu - A  Mandeya	\N	5	SEM	33	20	YR3	\N	11	Y	Y	Y	N	\N	\N	\N	44	44	MonThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	581	961	JHEL	Period7 - SEM 2 - TueThu - Olivier  Sempiga	\N	35	SEM	34	38	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	\N	581	TueThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	9	360	BAFL	Period1 - SEM1 - MonWedFri - A  Ggita	\N	5	SEM	33	31	YR1	\N	23	Y	Y	Y	N	\N	\N	\N	9	9	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	23	389	ESYR3	Period3 - SEM1 - MonThuFri - Lawrence  Daka	\N	7	SEM	33	17	YR3	\N	26	Y	Y	Y	N	\N	\N	\N	23	23	MonThuFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	39	416	NTYR2	Period1 - SEM1 - TueThu - A  Mandeya	\N	5	SEM	33	20	YR3	\N	18	Y	Y	Y	N	\N	\N	\N	39	39	TueThu	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	43	441	GAAPH	Period1 - SEM1 - MonTueWedThuFri - Ujah  Ejembi	\N	5	SEM	33	26	YR3	\N	9	Y	Y	Y	N	\N	\N	\N	43	43	MonTueWedThuFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	100	464	APDPT	Period2 - SEM 2 - TueThuFri - Diddy  Brossala	\N	6	SEM	34	24	YR2	\N	12	Y	Y	Y	N	\N	\N	\N	100	100	TueThuFri	16	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	103	467	IDDPT	Period4 - SEM 2 - TueThuFri - C  Nyandoro	\N	8	SEM	34	59	YR3	\N	18	Y	Y	Y	N	\N	\N	\N	103	103	TueThuFri	16	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	37	413	PRYR2	Period2 - SEM1 - MonFri - T  Sherman	\N	6	SEM	33	21	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	37	37	MonFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2019	27	6227	6784	iomad	APH16S1P1 - MonTueWedThuFri - Aerupe User 611	\N	579	FY	0	\N	\N	\N	1	Y	Y	Y	N	\N	\N	\N	5456	6227	MonTueWedThuFri	136	76	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	36	414	IOTYR1	Period2 - SEM1 - Wed - Zvaiwa  Zvaiwa	\N	6	SEM	33	7	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	36	36	Wed	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	34	437	ATYR2	Period1 - SEM1 - MonFri - J  Chitakure	\N	5	SEM	33	27	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	34	34	MonFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	42	387	PSYR3	Period4 - SEM1 - MonThu - A  Perumalil	\N	8	SEM	33	9	YR3	\N	26	Y	Y	Y	N	\N	\N	\N	42	42	MonThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	10	362	ENYR1	Period1 - SEM1 - TueThu - K  Esenther	\N	5	SEM	33	22	YR1	\N	19	Y	Y	Y	N	\N	\N	\N	10	10	TueThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	11	366	HAYR1	Period2 - SEM1 - MonWedFri - Nyambara  Nyambara	\N	6	SEM	33	8	YR1	\N	19	Y	Y	Y	N	\N	\N	\N	11	11	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	12	370	MRYR1	Period2 - SEM1 - TueThu - Nyandoro  Nyandoro	\N	6	SEM	33	6	YR1	\N	19	Y	Y	Y	N	\N	\N	\N	12	12	TueThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	16	368	VT2YR1	Period3 - SEM1 - Mon - W  Cleary	\N	7	SEM	33	14	YR1	\N	19	Y	Y	Y	N	\N	\N	\N	16	16	Mon	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	20	384	PTDYR2	Period4 - SEM1 - MonWedFri - A  Manyere	\N	8	SEM	33	30	YR2	\N	25	Y	Y	Y	N	\N	\N	\N	20	20	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	14	364	LAYR1	Period3 - SEM1 - Wed - A  Chennells	\N	7	SEM	33	15	YR1	\N	19	Y	Y	Y	N	\N	\N	\N	14	14	Wed	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	25	395	EHYR4	Period2 - SEM1 - MonWed - John  Stacer	\N	6	SEM	33	50	YR4	\N	30	Y	Y	Y	N	\N	\N	\N	25	25	MonWed	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	28	396	PGYR4	Period4 - SEM1 - MonWedFri - T  Sherman	\N	8	SEM	33	21	YR4	\N	30	Y	Y	Y	N	\N	\N	\N	28	28	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	29	402	CMYR1	Period1 - SEM1 - MonWedFri - K  Esenther	\N	5	SEM	33	22	YR1	\N	6	Y	Y	Y	N	\N	\N	\N	29	29	MonWedFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	31	414	IOTYR1	Period2 - SEM1 - WedFri - Zvaiwa  Zvaiwa	\N	6	SEM	33	7	\N	\N	6	Y	Y	Y	N	\N	\N	\N	31	31	WedFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	33	405	HAYR1	Period3 - SEM1 - TueFri - C  Matusse	\N	7	SEM	33	19	YR1	\N	6	Y	Y	Y	N	\N	\N	\N	33	33	TueFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	40	437	ATYR2	Period4 - SEM1 - Wed - J  Chitakure	\N	8	SEM	33	27	YR3	\N	13	Y	Y	Y	N	\N	\N	\N	40	40	Wed	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	35	413	PRYR2	Period2 - SEM1 - MonFri - T  Sherman	\N	6	SEM	33	21	YR2	\N	8	Y	Y	Y	N	\N	\N	\N	35	35	MonFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	19	378	RWYR2	Period3 - SEM1 - MonWedFri - A  Perumalil	\N	7	SEM	33	9	YR2	\N	25	Y	Y	Y	N	\N	\N	\N	19	19	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	61	416	NTYR3	Period2 - SEM1 - TueThu - A  Mandeya	\N	6	SEM	33	20	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	61	61	TueThu	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	62	450	HRs	Period1 - SEM1 - Mon - Costa  Virgilio	\N	5	SEM	33	33	Office	\N	1	Y	Y	Y	N	\N	\N	\N	62	62	Mon	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	77	390	CPYR3	Period2 - SEM 2 - MonWed - Diddy  Brossala	\N	6	SEM	34	24	YR3	\N	72	Y	Y	Y	N	\N	\N	\N	77	77	MonWed	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	101	465	IEDPT	Period1 - SEM 2 - WedThuFri - A  Ggita	\N	5	SEM	34	31	YR3	\N	18	Y	Y	Y	N	\N	\N	\N	101	101	WedThuFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	53	451	DPTEL	Period2 - SEM1 - TueThu - T  Sherman	\N	6	SEM	33	21	DP	\N	0	Y	Y	Y	N	\N	\N	\N	53	53	TueThu	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	56	448	DPTEL	Period2 - SEM1 - TueThu - A  Mandeya	\N	6	SEM	33	20	DP	\N	10	Y	Y	Y	N	\N	\N	\N	56	56	TueThu	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	55	447	DPTEL	Period2 - SEM1 - TueThu - Kenneth  Makamure	\N	6	SEM	33	32	DP	\N	1	Y	Y	Y	N	\N	\N	\N	55	55	TueThu	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	54	449	DPTEL	Period2 - SEM1 - TueThu - Johnny  Stacer	\N	6	SEM	33	10	DP	\N	1	Y	Y	Y	N	\N	\N	\N	54	54	TueThu	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	89	458	ICSPEL	Period1 - SEM 2 - MonWedFri - K  Esenther	\N	5	SEM	34	22	YR1	\N	6	Y	Y	Y	N	\N	\N	\N	89	89	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	67	361	FLYR1	Period1 - SEM 2 - MonWedFri - Dominique  Karani	\N	5	SEM	34	54	YR1	\N	14	Y	Y	Y	N	\N	\N	\N	67	67	MonWedFri	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	49	445	APEL	Period1 - SEM1 - MonTueWedThuFri - A  Chennells	\N	5	SEM	33	15	YR3	\N	11	Y	Y	Y	N	\N	\N	\N	49	49	MonTueWedThuFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	50	446	APEL	Period1 - SEM1 - MonTueWedThuFri - Lawrence  Daka	\N	5	SEM	33	17	YR3	\N	8	Y	Y	Y	N	\N	\N	\N	50	50	MonTueWedThuFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	87	456	GPEL	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	5	SEM	34	26	YR2	\N	2	Y	Y	Y	N	\N	\N	\N	87	87	TueThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	82	400	OCTYR4	Period2 - SEM 2 - MonWed - W  Cleary	\N	6	SEM	34	14	YR4	\N	82	Y	Y	Y	N	\N	\N	\N	82	82	MonWed	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	71	367	RAYR1	Period2 - SEM 2 - TueFri - J  Chitakure	\N	6	SEM	34	27	YR1	\N	65	Y	Y	Y	N	\N	\N	\N	71	71	TueFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	85	453	DHBAEL	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	5	SEM	34	26	YR3	\N	7	Y	Y	Y	N	\N	\N	\N	85	85	TueThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	70	373	OCYR1	Period4 - SEM 2 - MonThu - A  Zvaiwa	\N	8	SEM	34	51	YR1	\N	76	Y	Y	Y	N	\N	\N	\N	70	70	MonThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	59	421	CHYR2	Period1 - SEM1 - MonThu - G  Makwasha	\N	5	SEM	33	29	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	59	59	MonThu	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	88	457	PFEL	Period1 - SEM 2 - MonWedFri - Diddy  Brossala	\N	5	SEM	34	24	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	88	88	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	58	421	CHYR1	Period1 - SEM1 - MonThu - G  Makwasha	\N	5	SEM	33	29	YR1	\N	6	Y	Y	Y	N	\N	\N	\N	58	58	MonThu	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	91	460	PCMEL	Period1 - SEM 2 - MonWedFri - A  Mandeya	\N	5	SEM	34	20	YR3	\N	7	Y	Y	Y	N	\N	\N	\N	91	91	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	60	411	RPYR3	Period1 - SEM1 - MonTueWedThuFri - K  Esenther	\N	5	SEM	33	22	YR3	\N	8	Y	Y	Y	N	\N	\N	\N	60	60	MonTueWedThuFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	72	375	ALFYR2	Period3 - SEM 2 - MonFri - A  Ggita	\N	7	SEM	34	31	YR2	\N	28	Y	Y	Y	N	\N	\N	\N	72	72	MonFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	80	393	OTFYR3	Period3 - SEM 2 - TueThu - I  Chidavaenzi	\N	7	SEM	34	18	YR3	\N	70	Y	Y	Y	N	\N	\N	\N	80	80	TueThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	64	363	ENYR1	Period1 - SEM 2 - WedThuFri - K  Esenther	\N	5	SEM	34	22	YR1	\N	76	Y	Y	Y	N	\N	\N	\N	64	64	WedThuFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	66	361	FLYR1	Period1 - SEM 2 - MonWedFri - A  Ggita	\N	5	SEM	34	31	YR1	\N	13	Y	Y	Y	N	\N	\N	\N	66	66	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	79	392	MCPYR3	Period3 - SEM 2 - MonTue - T  Sherman	\N	7	SEM	34	21	YR3	\N	72	Y	Y	Y	N	\N	\N	\N	79	79	MonTue	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	78	391	PMEYR3	Period3 - SEM 2 - MonFri - A  Perumalil	\N	7	SEM	34	9	YR3	\N	70	Y	Y	Y	N	\N	\N	\N	78	78	MonFri	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	83	398	PPPYR4	Period1 - SEM 2 - MonTueWedThuFri - John  Stacer	\N	5	SEM	34	50	YR4	\N	83	Y	Y	Y	N	\N	\N	\N	83	83	MonTueWedThuFri	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	81	399	REYR4	Period4 - SEM 2 - TueThu - C  Nyandoro	\N	8	SEM	34	59	YR4	\N	82	Y	Y	Y	N	\N	\N	\N	81	81	TueThu	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	69	371	LYR1	Period2 - SEM 2 - MonWed - Simon  Makuru	\N	6	SEM	34	45	YR1	\N	83	Y	Y	Y	N	\N	\N	\N	69	69	MonWed	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	68	365	LAYR1	Period2 - SEM 2 - TueThu - A  Chennells	\N	6	SEM	34	42	YR1	\N	76	Y	Y	Y	N	\N	\N	\N	68	68	TueThu	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	86	454	PSDRGEL	Period4 - SEM 2 - MonTueWedThu - A  Manyere	\N	8	SEM	34	30	YR1	\N	49	Y	Y	Y	N	\N	\N	\N	86	86	MonTueWedThu	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	73	377	WLYR2	Period4 - SEM 2 - TueFri - A  Chennells	\N	8	SEM	34	42	YR2	\N	66	Y	Y	Y	N	\N	\N	\N	73	73	TueFri	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	74	379	WHYR2	Period3 - SEM 2 - TueThu - P  Nyambara	\N	7	SEM	34	8	YR2	\N	34	Y	Y	Y	N	\N	\N	\N	74	74	TueThu	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	65	369	APYR1	Period4 - SEM 2 - TueFri - Ujah Gabriel Ejembi	\N	8	SEM	34	26	YR1	\N	64	Y	Y	Y	N	\N	\N	\N	65	65	TueFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	99	415	INTDPT	Period3 - SEM 2 - MonThuFri - A  Mandeya	\N	7	SEM	34	20	YR2	\N	12	Y	Y	Y	N	\N	\N	\N	99	99	MonThuFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	98	418	HCTPDPT	Period2 - SEM 2 - TueThu - Costa  Virgilio	\N	6	SEM	34	33	YR2	\N	6	Y	Y	Y	N	\N	\N	\N	98	98	TueThu	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	104	417	ITDPT	Period1 - SEM 2 - MonWedFri - A  Zvaiwa	\N	5	SEM	34	51	YR1	\N	18	Y	Y	Y	N	\N	\N	\N	104	104	MonWedFri	16	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	110	461	BEL	Period1 - SEM 2 - MonWedFri - Costa  Virgilio	\N	5	SEM	34	33	YR2	\N	3	Y	Y	Y	N	\N	\N	\N	110	110	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	428	775	OCTPUG3	Period3 - SEM 2 - WedFri - W  Cleary	\N	7	SEM	34	14	YR4	\N	6	Y	Y	Y	N	\N	\N	\N	428	428	WedFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	105	409	EPDPT	Period3 - SEM 2 - MonWedFri - Olivier  Sempiga	\N	7	SEM	34	38	YR3	\N	18	Y	Y	Y	N	\N	\N	\N	105	105	MonWedFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	96	383	SSAYR2	Period2 - SEM 2 - MonWedFri - Ben  Sachikonye	\N	6	SEM	34	37	YR2	\N	32	Y	Y	Y	N	\N	\N	\N	96	96	MonWedFri	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	111	450	HRs	Period3 - SEM 2 - MonWedFri - Costa  Virgilio	\N	7	SEM	34	33	Aud Visual	\N	5	Y	Y	Y	N	\N	\N	\N	111	111	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	109	471	DHDPT	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	5	SEM	34	26	YR3	\N	5	Y	Y	Y	N	\N	\N	\N	109	109	TueThu	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	108	470	HRDPT	Period1 - SEM 2 - TueThuFri - Costa  Virgilio	\N	5	SEM	34	33	YR3	\N	1	Y	Y	Y	N	\N	\N	\N	108	108	TueThuFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	92	462	APEL	Period1 - SEM 2 - Wed - A  Perumalil	\N	5	SEM	34	9	YR4	\N	11	Y	Y	Y	N	\N	\N	\N	92	92	Wed	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	97	403	CMYR1	Period3 - SEM 2 - MonWedFri - K  Esenther	\N	7	SEM	34	22	YR2	\N	12	Y	Y	Y	N	\N	\N	\N	97	97	MonWedFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	94	463	FAEL	Period1 - SEM 2 - Wed - T  Sherman	\N	5	SEM	34	21	Y4	\N	1	Y	Y	Y	N	\N	\N	\N	94	94	Wed	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	107	469	ICSDPT	Period2 - SEM 2 - TueThu - K  Esenther	\N	6	SEM	34	22	YR1	\N	3	Y	Y	Y	N	\N	\N	\N	107	107	TueThu	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	93	455	PLEL	Period1 - SEM 2 - MonWedFri - T  Sherman	\N	5	SEM	34	21	YR3	\N	14	Y	Y	Y	N	\N	\N	\N	93	93	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	90	459	RSFANEL	Period1 - SEM 2 - MonWedFri - A  Chennells	\N	5	SEM	34	42	YR2	\N	10	Y	Y	Y	N	\N	\N	\N	90	90	MonWedFri	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	75	385	EYR2	Period1 - SEM 2 - MonWed - Lawrence  Daka	\N	5	SEM	34	44	YR2	\N	67	Y	Y	Y	N	\N	\N	\N	75	75	MonWed	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	102	466	CTIDPT	Period3 - SEM 2 - MonWedFri - A  Perumalil	\N	7	SEM	34	9	YR3	\N	18	Y	Y	Y	N	\N	\N	\N	102	102	MonWedFri	7	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	412	759	PTDPUG1	Period3 - SEM1 - MonWedFri - A  Manyere	\N	7	SEM	33	30	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	412	412	MonWedFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	406	753	EPUG1	Period1 - SEM 2 - MonWed - Lawrence  Daka	\N	5	SEM	34	44	YR2	\N	13	Y	Y	Y	N	\N	\N	\N	406	406	MonWed	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	413	760	SSAPUG1	Period1 - SEM 2 - MonWedThu - Ben  Sachikonye	\N	5	SEM	34	37	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	413	413	MonWedThu	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	425	772	NTFPUG3	Period3 - SEM1 - MonTueFri - I  Chidavaenzi	\N	7	SEM	33	18	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	425	425	MonTueFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	403	750	APPUG1	Period2 - SEM 2 - MonThu - Ujah Gabriel Ejembi	\N	6	SEM	34	26	YR1	\N	12	Y	Y	Y	N	\N	\N	\N	403	403	MonThu	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	404	751	LPUG1	Period1 - SEM 2 - MonThu - Simon  Makuru	\N	5	SEM	34	45	YR1	\N	12	Y	Y	Y	N	\N	\N	\N	404	404	MonThu	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	419	766	PMEPUG2	Period3 - SEM 2 - TueWedThu - A  Perumalil	\N	7	SEM	34	9	YR3	\N	10	Y	Y	Y	N	\N	\N	\N	419	419	TueWedThu	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	437	784	PCMPUGE	Period1 - SEM 2 - TueThu - A  Mandeya	\N	5	SEM	34	20	DIP YR1	\N	4	Y	Y	Y	N	\N	\N	\N	437	437	TueThu	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	402	749	RAPUG1	Period1 - SEM 2 - MonThuFri - J  Chitakure	\N	5	SEM	34	27	YR1	\N	12	Y	Y	Y	N	\N	\N	\N	402	402	MonThuFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	405	752	HMPPUG1	Period2 - SEM 2 - TueThu - A  Ggita	\N	6	SEM	34	31	YR2	\N	13	Y	Y	Y	N	\N	\N	\N	405	405	TueThu	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	431	778	ICSPUGE	Period1 - SEM 2 - MonWedFri - K  Esenther	\N	5	SEM	34	22	Computer	\N	2	Y	Y	Y	N	\N	\N	\N	431	431	MonWedFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	426	773	PPPPUG3	Period2 - SEM 2 - MonTueWedThuFri - John  Stacer	\N	6	SEM	34	50	Offices	\N	10	Y	Y	Y	N	\N	\N	\N	426	426	MonTueWedThuFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	407	754	FLPUG1	Period1 - SEM 2 - MonWedFri - A  Ggita	\N	5	SEM	34	31	DIP YR1	\N	2	Y	Y	Y	N	\N	\N	\N	407	407	MonWedFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	420	767	MCPPUG2	Period4 - SEM 2 - MonWed - T  Sherman	\N	8	SEM	34	21	YR3	\N	12	Y	Y	Y	N	\N	\N	\N	420	420	MonWed	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	438	785	FAEPUGE	Period1 - SEM 2 - Mon - T  Sherman	\N	5	SEM	34	21	Offices	\N	2	Y	Y	Y	N	\N	\N	\N	438	438	Mon	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	432	779	PSDPUGE	Period4 - SEM 2 - MonTueWedThu - A  Manyere	\N	8	SEM	34	30	Aud Visual	\N	4	Y	Y	Y	N	\N	\N	\N	432	432	MonTueWedThu	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	415	762	PSPUG2	Period4 - SEM1 - MonFri - A  Perumalil	\N	8	SEM	33	9	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	415	415	MonFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	421	768	OFPUG2	Period3 - SEM 2 - WedFri - I  Chidavaenzi	\N	7	SEM	34	18	YR3	\N	1	Y	Y	Y	N	\N	\N	\N	421	421	WedFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	439	786	APPUGE	Period1 - SEM 2 - Mon - A  Perumalil	\N	5	SEM	34	9	Offices	\N	1	Y	Y	Y	N	\N	\N	\N	439	439	Mon	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	433	780	IPLPUGE	Period1 - SEM 2 - MonWedFri - T  Sherman	\N	5	SEM	34	21	Seminar	\N	2	Y	Y	Y	N	\N	\N	\N	433	433	MonWedFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	95	381	HMPYR2	Period2 - SEM 2 - TueWedFri - A  Ggita	\N	6	SEM	34	31	YR2	\N	79	Y	Y	Y	N	\N	\N	\N	95	95	TueWedFri	16	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	427	774	REPUG3	Period3 - SEM 2 - MonWedFri - C  Nyandoro	\N	7	SEM	34	59	YR4	\N	4	Y	Y	Y	N	\N	\N	\N	427	427	MonWedFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	409	756	IPPUG1	Period3 - SEM1 - TueThu - A  Ggita	\N	7	SEM	33	31	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	409	409	TueThu	7	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	416	763	PLPPUG2	Period4 - SEM1 - TueThuFri - Diddy  Brossala	\N	8	SEM	33	24	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	416	416	TueThuFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	422	769	SAPPUG3	Period2 - SEM1 - MonWedThu - Diddy  Brossala	\N	6	SEM	33	24	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	422	422	MonWedThu	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	434	781	BPUGE	Period1 - SEM 2 - TueThu - Costa  Virgilio	\N	5	SEM	34	33	Seminar	\N	5	Y	Y	Y	N	\N	\N	\N	434	434	TueThu	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	423	770	EHPUG3	Period3 - SEM1 - TueThu - Simon  Makuru	\N	7	SEM	33	45	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	423	423	TueThu	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	410	757	RWPUG1	Period4 - SEM1 - TueThuFri - A  Perumalil	\N	8	SEM	33	9	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	410	410	TueThuFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	417	764	ESPPUG2	Period4 - SEM1 - TueThu - Lawrence  Daka	\N	8	SEM	33	44	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	417	417	TueThu	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2015	3	2313	2422	IPYR1	Period1 - SEM1 - TueThu - A  Ggita	\N	101	SEM	159	31	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	2313	2313	TueThu	61	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	435	782	PFPUGE	Period1 - SEM 2 - MonWedFri - Diddy  Brossala	\N	5	SEM	34	24	Aud Visual	\N	4	Y	Y	Y	N	\N	\N	\N	435	435	MonWedFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	429	776	OCEPUG3	Period3 - SEM 2 - MonTueWedThuFri - John  Stacer	\N	7	SEM	34	50	Seminar	\N	10	Y	Y	Y	N	\N	\N	\N	429	429	MonTueWedThuFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	411	758	PAPUG1	Period2 - SEM1 - TueThu - John  Stacer	\N	6	SEM	33	50	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	411	411	TueThu	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	418	765	CPPUG2	Period2 - SEM 2 - MonWedFri - Diddy  Brossala	\N	6	SEM	34	24	YR3	\N	18	Y	Y	Y	N	\N	\N	\N	418	418	MonWedFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	436	783	HRPUGE	Period1 - SEM 2 - MonWedFri - Costa  Virgilio	\N	5	SEM	34	33	Seminar	\N	6	Y	Y	Y	N	\N	\N	\N	436	436	MonWedFri	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	424	771	PGPUG3	Period4 - SEM1 - MonWed - T  Sherman	\N	8	SEM	33	21	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	424	424	MonWed	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	430	777	DHPUGE	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	5	SEM	34	26	YR3	\N	12	Y	Y	Y	N	\N	\N	\N	430	430	TueThu	16	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	582	962	FFEL	Period1 - SEM 2 - MonTueWedThuFri - Diddy  Brossala	\N	5	SEM	34	24	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	\N	582	MonTueWedThuFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	594	974	SKEL	Period7 - SEM 2 - TueThu - Diddy  Brossala	\N	35	SEM	34	24	PUG	\N	0	Y	Y	Y	N	\N	\N	\N	\N	594	TueThu	7	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	490	882	ICSPEL	Period1 - SEM 2 - MonWedFri - K  Esenther	\N	37	SEM	119	22	YR1	\N	3	Y	Y	Y	N	\N	\N	\N	490	490	MonWedFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	485	889	IEDPT	Period1 - SEM 2 - WedThuFri - A  Ggita	\N	37	SEM	119	31	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	485	485	WedThuFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	486	876	DPTEL	Period2 - SEM1 - TueThu - T  Sherman	\N	38	SEM	118	21	DP	\N	0	Y	Y	Y	N	\N	\N	\N	486	486	TueThu	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	488	872	DPTEL	Period2 - SEM1 - TueThu - Kenneth  Makamure	\N	38	SEM	118	\N	DP	\N	0	Y	Y	Y	N	\N	\N	\N	488	488	TueThu	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	624	984	SPP	Period3 - SEM1 - TueFri - Diddy  Brossala	\N	39	SEM	118	24	YR2	\N	4	Y	Y	Y	N	\N	\N	\N	624	624	TueFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	644	1002	LOG	Period3 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	39	SEM	119	13	YR1	\N	2	Y	Y	Y	N	\N	\N	\N	644	644	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	535	920	PTDPUG1	Period3 - SEM1 - MonWedFri - A  Manyere	\N	39	SEM	118	30	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	535	535	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	604	944	FFEL	Period5 - SEM1 - MonWed - Diddy  Brossala	\N	41	SEM	118	24	\N	\N	2	Y	Y	Y	N	\N	\N	\N	604	604	MonWed	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	571	912	HRPUGE	Period1 - SEM 2 - MonWedFri - Costa  Virgilio	\N	37	SEM	119	33	Seminar	\N	2	Y	Y	Y	N	\N	\N	\N	571	571	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	489	874	DPTEL	Period2 - SEM1 - TueThu - Johnny  Stacer	\N	38	SEM	118	\N	DP	\N	0	Y	Y	Y	N	\N	\N	\N	489	489	TueThu	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	491	788	FLYR1	Period1 - SEM 2 - MonWedFri - Dominique  Karani	\N	37	SEM	119	54	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	491	491	MonWedFri	24	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	541	904	PMEPUG2	Period3 - SEM 2 - TueWedThu - A  Ggita	\N	39	SEM	119	31	YR3	\N	3	Y	Y	Y	N	\N	\N	\N	541	541	TueWedThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	558	908	REPUG3	Period3 - SEM 2 - MonWedFri - C  Nyandoro	\N	39	SEM	119	59	YR4	\N	6	Y	Y	Y	N	\N	\N	\N	558	558	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	542	933	PCMPUGE	Period1 - SEM 2 - TueThu - A  Mandeya	\N	37	SEM	119	20	DIP YR1	\N	3	Y	Y	Y	N	\N	\N	\N	542	542	TueThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	548	898	FLPUG1	Period1 - SEM 2 - MonWedFri - A  Ggita	\N	37	SEM	119	31	DIP YR1	\N	2	Y	Y	Y	N	\N	\N	\N	548	548	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1676	1973	APMA	Period4 - SEM1 - MonThu - A  Chennells	\N	80	SEM	143	42	YR3	\N	1	Y	Y	Y	N	\N	\N	\N	1676	1676	MonThu	47	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1994	2246	LOGIC	Period8 - SEM 2 - MonWedThu - Kizito  Kiyimba	\N	92	SEM	149	13	\N	\N	6	Y	Y	Y	N	\N	\N	\N	1994	1994	MonWedThu	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	549	924	MCPPUG2	Period4 - SEM 2 - MonWed - T  Sherman	\N	40	SEM	119	21	YR3	\N	3	Y	Y	Y	N	\N	\N	\N	549	549	MonWed	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	492	870	APEL	Period1 - SEM1 - MonTueWedThuFri - A  Chennells	\N	37	SEM	118	\N	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	492	492	MonTueWedThuFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	493	871	APEL	Period1 - SEM1 - MonTueWedThuFri - Lawrence  Daka	\N	37	SEM	118	\N	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	493	493	MonTueWedThuFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	500	881	PFEL	Period1 - SEM 2 - MonWedFri - Diddy  Brossala	\N	37	SEM	119	24	YR2	\N	4	Y	Y	Y	N	\N	\N	\N	500	500	MonWedFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	637	995	PCC	Period6 - SEM 2 - TueWedFri - A  Mandeya	\N	42	SEM	119	20	YR2	\N	3	Y	Y	Y	N	\N	\N	\N	637	637	TueWedFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	568	909	OCEPUG3	Period3 - SEM 2 - MonTueWedThuFri - John  Stacer	\N	39	SEM	119	50	Seminar	\N	5	Y	Y	Y	N	\N	\N	\N	568	568	MonTueWedThuFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	563	928	OCTPUG3	Period3 - SEM 2 - WedFri - Joseph  Mahlahla	\N	39	SEM	119	79	YR4	\N	5	Y	Y	Y	N	\N	\N	\N	563	563	WedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	519	842	HCTPDPT	Period2 - SEM 2 - TueThu - C  Nyandoro	\N	38	SEM	119	59	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	519	519	TueThu	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	530	896	ICSDPT	Period2 - SEM 2 - TueThu - K  Esenther	\N	38	SEM	119	22	YR1	\N	1	Y	Y	Y	N	\N	\N	\N	530	530	TueThu	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	520	841	ITDPT	Period1 - SEM1 - MonWedFri - K  Esenther	\N	37	SEM	118	22	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	520	520	MonWedFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	518	839	INTDPT	Period3 - SEM 2 - MonThuFri - A  Mandeya	\N	39	SEM	119	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	518	518	MonThuFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	522	833	EPDPT	Period3 - SEM 2 - MonWedFri - Olivier  Sempiga	\N	39	SEM	119	38	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	522	522	MonWedFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	570	923	CPPUG2	Period2 - SEM 2 - MonWedFri - Diddy  Brossala	\N	38	SEM	119	24	YR3	\N	3	Y	Y	Y	N	\N	\N	\N	570	570	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	583	963	LLEL	Period5 - SEM 2 - MonWedFri - K  Esenther	\N	33	SEM	34	22	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	\N	583	MonWedFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	595	976	PEDYR1	Period8 - SEM1 - MonTueWedThuFri - C  Nyandoro	\N	36	SEM	33	59	\N	\N	0	Y	Y	Y	N	\N	\N	\N	\N	595	MonTueWedThuFri	18	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	567	932	PFPUGE	Period1 - SEM 2 - MonWedFri - Diddy  Brossala	\N	37	SEM	119	24	Aud Visual	\N	3	Y	Y	Y	N	\N	\N	\N	567	567	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	553	902	PSPUG2	Period4 - SEM1 - MonFri - Kizito  Kiyimba	\N	40	SEM	118	13	YR3	\N	4	Y	Y	Y	N	\N	\N	\N	553	553	MonFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	503	835	RPYR3	Period1 - SEM1 - MonWedFri - Diddy  Brossala	\N	37	SEM	118	24	YR3	\N	5	Y	Y	Y	N	\N	\N	\N	503	503	MonWedFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	524	895	HRs	Period3 - SEM 2 - MonWedFri - Costa  Virgilio	\N	39	SEM	119	33	Aud Visual	\N	0	Y	Y	Y	N	\N	\N	\N	524	524	MonWedFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	525	894	DHDPT	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	37	SEM	119	26	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	525	525	TueThu	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	526	893	HRDPT	Period1 - SEM 2 - TueThuFri - Costa  Virgilio	\N	37	SEM	119	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	526	526	TueThuFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	529	887	FAEL	Period1 - SEM 2 - Wed - T  Sherman	\N	37	SEM	119	21	Y4	\N	0	Y	Y	Y	N	\N	\N	\N	529	529	Wed	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	531	879	PLEL	Period1 - SEM 2 - MonWedFri - T  Sherman	\N	37	SEM	119	21	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	531	531	MonWedFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	532	883	RSFANEL	Period1 - SEM 2 - MonWedFri - A  Chennells	\N	37	SEM	119	42	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	532	532	MonWedFri	24	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	559	899	IPPUG1	Period3 - SEM1 - TueThu - A  Ggita	\N	39	SEM	118	31	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	559	559	TueThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	569	900	PAPUG1	Period2 - SEM1 - TueThu - John  Stacer	\N	38	SEM	118	50	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	569	569	TueThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	565	919	RWPUG1	Period4 - SEM1 - TueThuFri - Francis  Zangairai	\N	40	SEM	118	78	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	565	565	TueThuFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	551	930	PSDPUGE	Period4 - SEM 2 - MonTueWedThu - A  Manyere	\N	40	SEM	119	30	Aud Visual	\N	4	Y	Y	Y	N	\N	\N	\N	551	551	MonTueWedThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	630	988	POSMA	Period4 - SEM 2 - WedFri - Kizito  Kiyimba	\N	40	SEM	119	13	YR4	\N	4	Y	Y	Y	N	\N	\N	\N	630	630	WedFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	653	1011	POLA	Period4 - SEM 2 - TueFri - Kizito  Kiyimba	\N	40	SEM	119	13	YR2	\N	7	Y	Y	Y	N	\N	\N	\N	653	653	TueFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	655	1013	APHIL	Period4 - SEM 2 - TueWedFri - Diddy  Brossala	\N	40	SEM	119	24	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	655	655	TueWedFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	544	916	HMPPUG1	Period2 - SEM 2 - TueThu - T  Sherman	\N	38	SEM	119	21	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	544	544	TueThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	561	925	SAPPUG3	Period2 - SEM1 - MonWedThu - Bienvenu  Mayemba	\N	38	SEM	118	80	YR4	\N	5	Y	Y	Y	N	\N	\N	\N	561	561	MonWedThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	564	906	EHPUG3	Period3 - SEM1 - TueThu - Simon  Makuru	\N	39	SEM	118	45	YR4	\N	5	Y	Y	Y	N	\N	\N	\N	564	564	TueThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	572	926	PGPUG3	Period4 - SEM1 - MonWed - T  Sherman	\N	40	SEM	118	21	YR4	\N	5	Y	Y	Y	N	\N	\N	\N	572	572	MonWed	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	540	897	LPUG1	Period1 - SEM 2 - MonThu - Kizito  Kiyimba	\N	37	SEM	119	13	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	540	540	MonThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	552	918	FLPUG1	Period1 - SEM1 - TueThu - A  Ggita	\N	37	SEM	118	31	YR1	\N	10	Y	Y	Y	N	\N	\N	\N	552	552	TueThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1674	2065	SLS	Period6 - SEM1 - TueFri - Costa  Virgilio	\N	82	SEM	143	33	YR 3	\N	0	Y	Y	Y	N	\N	\N	\N	1674	1674	TueFri	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1964	2183	MRYR1	Period6 - SEM1 - TueWed - C  Nyandoro	\N	90	SEM	148	59	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	1964	1964	TueWed	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	566	903	ESPPUG2	Period4 - SEM1 - TueThu - Lawrence  Daka	\N	40	SEM	118	44	YR3	\N	4	Y	Y	Y	N	\N	\N	\N	566	566	TueThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	609	978	PEDMA	Period3 - SEM1 - WedFri - C  Nyandoro	\N	39	SEM	118	59	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	609	609	WedFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	599	938	KEL	Period5 - SEM1 - TueThu - Diddy  Brossala	\N	41	SEM	118	24	\N	\N	3	Y	Y	Y	N	\N	\N	\N	599	599	TueThu	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	584	964	LLEL	Period5 - SEM 2 - MonWedFri - K  Esenther	\N	33	SEM	34	22	PUG	\N	0	Y	Y	Y	N	\N	\N	\N	\N	584	MonWedFri	7	17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	596	977	BLYR1	Period6 - SEM1 - MonTueWedThuFri - John  Stacer	\N	34	SEM	33	50	\N	\N	0	Y	Y	Y	N	\N	\N	\N	\N	596	MonTueWedThuFri	18	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	539	915	APPUG1	Period2 - SEM 2 - MonThu - Diddy  Brossala	\N	38	SEM	119	24	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	539	539	MonThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	546	921	HMPPUG2	Period3 - SEM1 - MonWedFri - T  Sherman	\N	39	SEM	118	21	YR3	\N	4	Y	Y	Y	N	\N	\N	\N	546	546	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	538	907	NTFPUG3	Period3 - SEM1 - MonTueFri - I  Chidavaenzi	\N	39	SEM	118	18	YR4	\N	1	Y	Y	Y	N	\N	\N	\N	538	538	MonTueFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	509	816	PMEYR3	Period3 - SEM 2 - MonFri - A  Ggita	\N	39	SEM	119	31	YR3	\N	19	Y	Y	Y	N	\N	\N	\N	509	509	MonFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	523	808	SSAYR2	Period2 - SEM 2 - MonWedFri - T  Chimbidzikai	\N	38	SEM	119	81	YR2	\N	19	Y	Y	Y	N	\N	\N	\N	523	523	MonWedFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	516	804	WHYR2	Period3 - SEM 2 - TueThu - P  Nyambara	\N	39	SEM	119	8	YR2	\N	19	Y	Y	Y	N	\N	\N	\N	516	516	TueThu	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	512	798	LYR1	Period2 - SEM 2 - MonWed - Kizito  Kiyimba	\N	38	SEM	119	13	YR1	\N	11	Y	Y	Y	N	\N	\N	\N	512	512	MonWed	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	506	790	ENYR1	Period1 - SEM 2 - WedThuFri - K  Esenther	\N	37	SEM	119	22	YR1	\N	11	Y	Y	Y	N	\N	\N	\N	506	506	WedThuFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	496	794	RAYR1	Period2 - SEM 2 - TueFri - Francis  Zangairai	\N	38	SEM	119	78	YR1	\N	11	Y	Y	Y	N	\N	\N	\N	496	496	TueFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	513	791	LAYR1	Period2 - SEM 2 - TueThu - A  Chennells	\N	38	SEM	119	42	YR1	\N	11	Y	Y	Y	N	\N	\N	\N	513	513	TueThu	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	497	877	DHBAEL	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	37	SEM	119	26	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	497	497	TueThu	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	499	845	CHYR2	Period1 - SEM1 - MonThu - G  Makwasha	\N	37	SEM	118	\N	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	499	499	MonThu	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	501	845	CHYR1	Period1 - SEM1 - MonThu - G  Makwasha	\N	37	SEM	118	\N	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	501	501	MonThu	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	619	952	STEL	Period7 - SEM1 - TueThu - Costa  Virgilio	\N	43	SEM	118	33	YR3	\N	2	Y	Y	Y	N	\N	\N	\N	619	619	TueThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	603	946	ELEL	Period5 - SEM1 - MonWedFri - Costa  Virgilio	\N	41	SEM	118	33	\N	\N	1	Y	Y	Y	N	\N	\N	\N	603	603	MonWedFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	628	847	ETMA	Period2 - SEM 2 - MonWed - Costa  Virgilio	\N	38	SEM	119	33	YR4	\N	8	Y	Y	Y	N	\N	\N	\N	628	628	MonWed	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	659	834	MTP	Period1 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	37	SEM	119	13	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	659	659	MonWedFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	652	1010	LAWA	Period2 - SEM 2 - MonThu - T  Sherman	\N	38	SEM	119	21	YR3	\N	5	Y	Y	Y	N	\N	\N	\N	652	652	MonThu	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	654	1012	ROA	Period1 - SEM 2 - MonThuFri - Francis  Zangairai	\N	37	SEM	119	78	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	654	654	MonThuFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	662	1018	FRLS	Period2 - SEM 2 - MonWed - A  Ggita	\N	38	SEM	119	31	YR2	\N	4	Y	Y	Y	N	\N	\N	\N	662	662	MonWed	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1581	1988	APEL	Period1 - SEM 2 - Wed - A  Perumalil	\N	77	SEM	144	9	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	1581	1581	Wed	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	646	1004	PMOE	Period2 - SEM 2 - MonFri - A  Ggita	\N	38	SEM	119	31	YR3	\N	1	Y	Y	Y	N	\N	\N	\N	646	646	MonFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	661	1017	POSPUG	Period3 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	39	SEM	119	13	YR3	\N	1	Y	Y	Y	N	\N	\N	\N	661	661	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	660	1016	HRPUG	Period3 - SEM 2 - TueThu - Costa  Virgilio	\N	39	SEM	119	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	660	660	TueThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	658	832	CONTP	Period2 - SEM 2 - MonWedFri - John  Sanni	\N	38	SEM	119	82	YR1	\N	10	Y	Y	Y	N	\N	\N	\N	658	658	MonWedFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	656	1014	LOGIC	Period1 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	37	SEM	119	13	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	656	656	MonWedFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	643	1001	ETH	Period2 - SEM 2 - MonWedFri - Olivier  Sempiga	\N	38	SEM	119	38	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	643	643	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	585	965	CTEL	Period1 - SEM 2 - MonTueWedThuFri - Diddy  Brossala	\N	5	SEM	34	24	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	\N	585	MonTueWedThuFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	527	886	APEL	Period1 - SEM 2 - Wed - A  Perumalil	\N	37	SEM	119	9	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	527	527	Wed	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	616	953	SKEL	Period6 - SEM1 - MonWedFri - Diddy  Brossala	\N	42	SEM	118	24	YR3	\N	2	Y	Y	Y	N	\N	\N	\N	616	616	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	614	982	PAPUGYR2	Period2 - SEM1 - TueThu - John  Stacer	\N	38	SEM	118	50	YR@	\N	1	Y	Y	Y	N	\N	\N	\N	614	614	TueThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	613	981	HAPPUGYR2	Period5 - SEM1 - MonWedFri - Costa  Virgilio	\N	41	SEM	118	33	YR2	\N	1	Y	Y	Y	N	\N	\N	\N	613	613	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	612	980	HAPPUG1	Period3 - SEM1 - MonWedFri - Costa  Virgilio	\N	39	SEM	118	33	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	612	612	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	560	922	PLPPUG2	Period4 - SEM1 - TueThuFri - Diddy  Brossala	\N	40	SEM	118	24	YR3	\N	3	Y	Y	Y	N	\N	\N	\N	560	560	TueThuFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	611	948	GAEL	Period5 - SEM1 - TueThu - A  Mandeya	\N	41	SEM	118	20	YR3	\N	4	Y	Y	Y	N	\N	\N	\N	611	611	TueThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	608	846	EPMA	Period2 - SEM1 - TueThu - Kizito  Kiyimba	\N	38	SEM	118	13	YR1	\N	7	Y	Y	Y	N	\N	\N	\N	608	608	TueThu	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	607	853	SPMA	Period1 - SEM1 - MonWed - Costa  Virgilio	\N	37	SEM	118	33	YR1	\N	4	Y	Y	Y	N	\N	\N	\N	607	607	MonWed	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	597	940	BLEL	Period6 - SEM1 - MonThu - John  Stacer	\N	42	SEM	118	50	\N	\N	11	Y	Y	Y	N	\N	\N	\N	597	597	MonThu	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	600	937	AIEL	Period1 - SEM1 - WedFri - A  Chennells	\N	37	SEM	118	42	\N	\N	7	Y	Y	Y	N	\N	\N	\N	600	600	WedFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	602	945	CTEL	Period5 - SEM1 - TueFri - Diddy  Brossala	\N	41	SEM	118	24	\N	\N	1	Y	Y	Y	N	\N	\N	\N	602	602	TueFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	598	941	JHEL	Period4 - SEM1 - TueFri - Olivier  Sempiga	\N	40	SEM	118	38	\N	\N	10	Y	Y	Y	N	\N	\N	\N	598	598	TueFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	601	939	PAEEL	Period5 - SEM1 - MonFri - A  Ggita	\N	41	SEM	118	31	\N	\N	7	Y	Y	Y	N	\N	\N	\N	601	601	MonFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	466	789	ENYR1	Period1 - SEM1 - TueThu - K  Esenther	\N	37	SEM	118	22	YR1	\N	11	Y	Y	Y	N	\N	\N	\N	466	466	TueThu	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	517	796	APYR1	Period4 - SEM 2 - TueFri - Diddy  Brossala	\N	40	SEM	119	24	YR1	\N	11	Y	Y	Y	N	\N	\N	\N	517	517	TueFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	440	892	PCMDPT	Period1 - SEM 2 - MonWedFri - A  Mandeya	\N	37	SEM	119	20	YR3	\N	2	Y	Y	Y	N	\N	\N	\N	440	440	MonWedFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	441	867	APEL	Period1 - SEM1 - MonTueWedThuFri - Kenneth  Makamure	\N	37	SEM	118	\N	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	441	441	MonTueWedThuFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	547	927	PPPPUG3	Period2 - SEM 2 - MonTueWedThuFri - John  Stacer	\N	38	SEM	119	50	Offices	\N	5	Y	Y	Y	N	\N	\N	\N	547	547	MonTueWedThuFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	633	991	DEL	Period7 - SEM 2 - WedFri - Olivier  Sempiga	\N	43	SEM	119	38	YR3	\N	2	Y	Y	Y	N	\N	\N	\N	633	633	WedFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	632	990	ASCAEL	Period6 - SEM 2 - MonWed - Lawrence  Daka	\N	42	SEM	119	44	YR3	\N	11	Y	Y	Y	N	\N	\N	\N	632	632	MonWed	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	507	788	FLYR1	Period1 - SEM 2 - MonWedFri - A  Ggita	\N	37	SEM	119	31	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	507	507	MonWedFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	651	1009	PFR	Period5 - SEM 2 - MonWed - Diddy  Brossala	\N	41	SEM	119	24	YR3	\N	5	Y	Y	Y	N	\N	\N	\N	651	651	MonWed	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	445	864	APEL	Period1 - SEM1 - MonTueWedThuFri - Johnny  Stacer	\N	37	SEM	118	\N	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	445	445	MonTueWedThuFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	446	866	APEL	Period1 - SEM1 - MonTueWedThuFri - T  Sherman	\N	37	SEM	118	21	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	446	446	MonTueWedThuFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	534	890	CTIDPT	Period3 - SEM 2 - MonWedFri - A  Perumalil	\N	39	SEM	119	9	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	534	534	MonWedFri	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	573	929	DHPUGE	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	37	SEM	119	26	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	573	573	TueThu	24	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	494	880	GPEL	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	37	SEM	119	26	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	494	494	TueThu	23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	610	979	BLMA	Period4 - SEM1 - TueFri - John  Stacer	\N	40	SEM	118	50	YR1	\N	6	Y	Y	Y	N	\N	\N	\N	610	610	TueFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	650	1008	BIOE	Period5 - SEM 2 - MonWed - Costa  Virgilio	\N	41	SEM	119	33	YR1	\N	-1	Y	Y	Y	N	\N	\N	\N	650	650	MonWed	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	648	1006	PCC	Period5 - SEM 2 - MonWed - A  Mandeya	\N	41	SEM	119	20	YR2	\N	2	Y	Y	Y	N	\N	\N	\N	648	648	MonWed	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	647	1005	ASCA	Period5 - SEM 2 - MonWed - Lawrence  Daka	\N	41	SEM	119	44	YR1	\N	1	Y	Y	Y	N	\N	\N	\N	647	647	MonWed	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	642	1000	HOMP	Period3 - SEM 2 - TueThu - T  Sherman	\N	39	SEM	119	21	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	642	642	TueThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	641	999	LOG	Period3 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	39	SEM	119	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	641	641	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	640	998	APHIL	Period4 - SEM 2 - TueWed - Diddy  Brossala	\N	40	SEM	119	24	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	640	640	TueWed	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	636	994	PSDRG	Period5 - SEM 2 - TueFri - A  Manyere	\N	41	SEM	119	30	YR3	\N	1	Y	Y	Y	N	\N	\N	\N	636	636	TueFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	635	993	OTS	Period2 - SEM 2 - TueThu - K  Esenther	\N	38	SEM	119	22	YR2	\N	10	Y	Y	Y	N	\N	\N	\N	635	635	TueThu	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	634	992	PHILA	Period1 - SEM 2 - MonWed - Costa  Virgilio	\N	37	SEM	119	33	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	634	634	MonWed	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	629	855	LPMA	Period3 - SEM 2 - TueThu - T  Sherman	\N	39	SEM	119	21	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	629	629	TueThu	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	455	936	OCYR4	Period1 - SEM 2 - MonTueWedThuFri - John  Stacer	\N	37	SEM	119	50	YR4	\N	21	Y	Y	Y	N	\N	\N	\N	455	455	MonTueWedThuFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	617	951	ISEL	Period6 - SEM1 - TueThu - A  Manyere	\N	42	SEM	118	30	YR4	\N	1	Y	Y	Y	N	\N	\N	\N	617	617	TueThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	510	823	PPPYR4	Period1 - SEM 2 - MonTueWedThuFri - John  Stacer	\N	37	SEM	119	50	YR4	\N	21	Y	Y	Y	N	\N	\N	\N	510	510	MonTueWedThuFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	627	987	ST	Period6 - SEM1 - MonWed - Costa  Virgilio	\N	42	SEM	118	33	YR3	\N	1	Y	Y	Y	N	\N	\N	\N	627	627	MonWed	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	626	986	PAE	Period4 - SEM1 - MonWedFri - A  Ggita	\N	40	SEM	118	31	YR3	\N	2	Y	Y	Y	N	\N	\N	\N	626	626	MonWedFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	623	983	HIVA	Period1 - SEM1 - MonThu - A  Mandeya	\N	37	SEM	118	20	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	623	623	MonThu	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	622	830	HMP	Period4 - SEM1 - MonWed - A  Ggita	\N	40	SEM	118	31	YR2	\N	9	Y	Y	Y	N	\N	\N	\N	622	622	MonWed	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	621	843	HCT	Period2 - SEM1 - MonWedFri - C  Nyandoro	\N	38	SEM	118	59	YR1	\N	10	Y	Y	Y	N	\N	\N	\N	621	621	MonWedFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	620	836	EDPT	Period3 - SEM1 - TueThu - Olivier  Sempiga	\N	39	SEM	118	38	YR1	\N	10	Y	Y	Y	N	\N	\N	\N	620	620	TueThu	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	618	947	PAEL	Period8 - SEM1 - MonWedFri - A  Ggita	\N	44	SEM	118	31	YR4	\N	2	Y	Y	Y	N	\N	\N	\N	618	618	MonWedFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	511	824	REYR4	Period4 - SEM 2 - TueThu - C  Nyandoro	\N	40	SEM	119	59	YR4	\N	21	Y	Y	Y	N	\N	\N	\N	511	511	TueThu	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	495	825	OCTYR4	Period2 - SEM 2 - MonWed - Joseph  Mahlahla	\N	38	SEM	119	79	YR4	\N	21	Y	Y	Y	N	\N	\N	\N	495	495	MonWed	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	505	818	OTFYR3	Period3 - SEM 2 - TueThu - I  Chidavaenzi	\N	39	SEM	119	18	YR3	\N	19	Y	Y	Y	N	\N	\N	\N	505	505	TueThu	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	533	810	EYR2	Period1 - SEM 2 - MonWed - Olivier  Sempiga	\N	37	SEM	119	38	YR2	\N	24	Y	Y	Y	N	\N	\N	\N	533	533	MonWed	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	515	801	WLYR2	Period4 - SEM 2 - TueFri - A  Chennells	\N	40	SEM	119	42	YR2	\N	19	Y	Y	Y	N	\N	\N	\N	515	515	TueFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	504	863	ALFYR2	Period3 - SEM 2 - MonFri - Olivier  Sempiga	\N	39	SEM	119	38	YR2	\N	12	Y	Y	Y	N	\N	\N	\N	504	504	MonFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	498	800	OCYR1	Period4 - SEM 2 - MonThu - A  Zvaiwa	\N	40	SEM	119	51	YR1	\N	11	Y	Y	Y	N	\N	\N	\N	498	498	MonThu	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	536	917	EPUG1	Period1 - SEM 2 - MonWed - Olivier  Sempiga	\N	37	SEM	119	38	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	536	536	MonWed	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	528	827	CMYR1	Period3 - SEM 2 - MonWedFri - A  Zvaiwa	\N	39	SEM	119	51	YR2	\N	1	Y	Y	Y	N	\N	\N	\N	528	528	MonWedFri	25	19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	502	884	PCMEL	Period1 - SEM 2 - MonWedFri - A  Mandeya	\N	37	SEM	119	20	YR3	\N	3	Y	Y	Y	N	\N	\N	\N	502	502	MonWedFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	521	885	BEL	Period1 - SEM 2 - MonWedFri - Costa  Virgilio	\N	37	SEM	119	33	YR2	\N	6	Y	Y	Y	N	\N	\N	\N	521	521	MonWedFri	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	514	878	PSDRGEL	Period4 - SEM 2 - MonTueWedThu - A  Manyere	\N	40	SEM	119	30	YR1	\N	33	Y	Y	Y	N	\N	\N	\N	514	514	MonTueWedThu	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	3	586	966	ELEL	Period1 - SEM 2 - MonTueWedThuFri - Costa  Virgilio	\N	5	SEM	34	33	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	\N	586	MonTueWedThuFri	7	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	508	817	MCPYR3	Period3 - SEM 2 - MonTue - T  Sherman	\N	39	SEM	119	21	YR3	\N	19	Y	Y	Y	N	\N	\N	\N	508	508	MonTue	25	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	649	1007	DEMC	Period6 - SEM 2 - TueThu - Olivier  Sempiga	\N	42	SEM	119	38	YR3	\N	2	Y	Y	Y	N	\N	\N	\N	649	649	TueThu	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	639	997	ROA	Period1 - SEM 2 - MonThuFri - Francis  Zangairai	\N	37	SEM	119	78	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	639	639	MonThuFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	450	805	APYR2	Period1 - SEM1 - TueThu - Costa  Virgilio	\N	37	SEM	118	33	YR2	\N	24	Y	Y	Y	N	\N	\N	\N	450	450	TueThu	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	448	875	APEL	Period6 - SEM1 - MonTueWedThuFri - A  Mandeya	\N	42	SEM	118	20	YR3	\N	18	Y	Y	Y	N	\N	\N	\N	448	448	MonTueWedThuFri	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	452	822	NTYR4	Period3 - SEM1 - TueThu - I  Chidavaenzi	\N	39	SEM	118	18	YR4	\N	21	Y	Y	Y	N	\N	\N	\N	452	452	TueThu	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	444	813	PLYR3	Period2 - SEM1 - MonWedFri - Diddy  Brossala	\N	38	SEM	118	24	YR3	\N	19	Y	Y	Y	N	\N	\N	\N	444	444	MonWedFri	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	447	799	ITYR1	Period5 - SEM1 - Tue - A  Ggita	\N	41	SEM	118	31	YR1	\N	16	Y	Y	Y	N	\N	\N	\N	447	447	Tue	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	483	868	STEL	Period5 - SEM1 - MonThu - Costa  Virgilio	\N	41	SEM	118	33	YR4	\N	5	Y	Y	Y	N	\N	\N	\N	483	483	MonThu	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	449	869	APEL	Period1 - SEM1 - TueFri - A  Manyere	\N	37	SEM	118	30	YR3	\N	19	Y	Y	Y	N	\N	\N	\N	449	449	TueFri	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2039	2392	PHILMIND	Period7 - SEM 2 - MonThuFri - T  Sherman	\N	91	SEM	149	21	\N	\N	2	Y	Y	Y	N	\N	\N	\N	2039	2039	MonThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2024	2386	HITFILM	Period8 - SEM 2 - MonFri - K  Esenther	\N	92	SEM	149	22	\N	\N	1	Y	Y	Y	N	\N	\N	\N	2024	2024	MonFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2010	2379	DISSERT	Period4 - SEM 2 - MonFri - John  Stacer	\N	88	SEM	149	50	\N	\N	6	Y	Y	Y	N	\N	\N	\N	2010	2010	MonFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1995	2366	MLOGIC	Period8 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	92	SEM	149	13	\N	\N	2	Y	Y	Y	N	\N	\N	\N	1995	1995	MonWedFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1980	2358	ISLAM	Period5 - SEM1 - MonTueWed - Francis  Zangairai	\N	89	SEM	148	78	\N	\N	1	Y	Y	Y	N	\N	\N	\N	1980	1980	MonTueWed	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1834	2160	POLA	Period4 - SEM1 - TueFri - Kizito  Kiyimba	\N	88	SEM	148	13	MYA	\N	1	Y	Y	Y	N	\N	\N	\N	1834	1834	TueFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1866	2322	LPUG1	Period1 - SEM 2 - MonThu - Kizito  Kiyimba	\N	85	SEM	149	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1866	1866	MonThu	50	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1470	2038	APDPT	Period2 - SEM 2 - TueThuFri - Diddy  Brossala	\N	78	SEM	144	24	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1470	1470	TueThuFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1467	1977	ALFYR2	Period3 - SEM1 - TueFri - Dominique  Karani	\N	79	SEM	143	54	YR2	\N	6	Y	Y	Y	N	\N	\N	\N	1467	1467	TueFri	47	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	442	787	BAFL	Period1 - SEM1 - MonWedFri - A  Ggita	\N	37	SEM	118	31	YR1	\N	13	Y	Y	Y	N	\N	\N	\N	442	442	MonWedFri	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	443	811	HMYR3	Period4 - SEM1 - TueThu - T  Sherman	\N	40	SEM	118	21	YR3	\N	19	Y	Y	Y	N	\N	\N	\N	443	443	TueThu	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	615	950	LLEL	Period7 - SEM1 - MonFri - I  Chidavaenzi	\N	43	SEM	118	18	YR3	\N	8	Y	Y	Y	N	\N	\N	\N	615	615	MonFri	25	20	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	456	814	ESYR3	Period3 - SEM1 - MonThuFri - Lawrence  Daka	\N	39	SEM	118	44	YR3	\N	56	Y	Y	Y	N	\N	\N	\N	456	456	MonThuFri	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2012	3	471	792	LAYR1	Period3 - SEM1 - Wed - A  Chennells	\N	39	SEM	118	42	YR1	\N	11	Y	Y	Y	N	\N	\N	\N	471	471	Wed	23	18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2042	2393	COMPS	Period1 - SEM 2 - WedThuFri - K  Esenther	\N	85	SEM	149	22	Elective	\N	5	Y	Y	Y	N	\N	\N	\N	2042	2042	WedThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2040	2110	POR	Period7 - SEM 2 - MonThuFri - Francis  Zangairai	\N	91	SEM	149	78	\N	\N	1	Y	Y	Y	N	\N	\N	\N	2040	2040	MonThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2025	2363	HIVAIDS	Period8 - SEM 2 - MonTueWedThuFri - A  Mandeya	\N	92	SEM	149	20	\N	\N	8	Y	Y	Y	N	\N	\N	\N	2025	2025	MonTueWedThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2009	2378	DISSERT	Period8 - SEM 2 - MonThuFri - John  Stacer	\N	92	SEM	149	50	\N	\N	25	Y	Y	Y	N	\N	\N	\N	2009	2009	MonThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1996	2367	NGUGI	Period8 - SEM 2 - MonThuFri - A  Chennells	\N	92	SEM	149	42	\N	\N	1	Y	Y	Y	N	\N	\N	\N	1996	1996	MonThuFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1981	2360	MARX	Period5 - SEM1 - MonTueWedThuFri - Francis  Zangairai	\N	89	SEM	148	78	\N	\N	1	Y	Y	Y	N	\N	\N	\N	1981	1981	MonTueWedThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1966	2348	PHOG	Period5 - SEM1 - WedFri - T  Sherman	\N	89	SEM	148	21	MAYR	\N	15	Y	Y	Y	N	\N	\N	\N	1966	1966	WedFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1867	2226	RPYR3	Period1 - SEM1 - MonWedFri - C  Nyandoro	\N	85	SEM	148	59	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1867	1867	MonWedFri	51	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1868	2237	ETMA	Period2 - SEM 2 - MonWed - Costa  Virgilio	\N	86	SEM	149	33	YR4	\N	19	Y	Y	Y	N	\N	\N	\N	1868	1868	MonWed	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1869	2135	LAWA	Period2 - SEM 2 - MonThu - T  Sherman	\N	86	SEM	149	21	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1869	1869	MonThu	50	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1870	2290	PSDPUGE	Period4 - SEM 2 - MonTueWedThu - A  Manyere	\N	88	SEM	149	30	Aud Visual	\N	2	Y	Y	Y	N	\N	\N	\N	1870	1870	MonTueWedThu	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1872	2298	CTEL	Period5 - SEM1 - TueFri - Diddy  Brossala	\N	89	SEM	148	24	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1872	1872	TueFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1601	1861	ASCAEL	Period6 - SEM 2 - MonWed - Lawrence  Daka	\N	82	SEM	144	44	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1601	1601	MonWed	45	30	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1476	2021	FAEPUGE	Period1 - SEM 2 - Mon - T  Sherman	\N	77	SEM	144	21	Offices	\N	0	Y	Y	Y	N	\N	\N	\N	1476	1476	Mon	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2043	2394	COMPS	Period8 - SEM 2 - MonWedThuFri - K  Esenther	\N	92	SEM	149	22	\N	\N	2	Y	Y	Y	N	\N	\N	\N	2043	2043	MonWedThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2041	2385	SCIEREL	Period8 - SEM 2 - MonThuFri - Costa  Virgilio	\N	92	SEM	149	33	\N	\N	3	Y	Y	Y	N	\N	\N	\N	2041	2041	MonThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2011	2380	THNGUGI	Period7 - SEM 2 - MonFri - A  Chennells	\N	91	SEM	149	42	\N	\N	1	Y	Y	Y	N	\N	\N	\N	2011	2011	MonFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2026	2363	HIVAIDS	Period8 - SEM 2 - WedFri - A  Mandeya	\N	92	SEM	149	20	\N	\N	3	Y	Y	Y	N	\N	\N	\N	2026	2026	WedFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1997	2250	CONTPHIL	Period8 - SEM 2 - MonThuFri - Costa  Virgilio	\N	92	SEM	149	33	\N	\N	4	Y	Y	Y	N	\N	\N	\N	1997	1997	MonThuFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1982	2361	PHILAN	Period8 - SEM1 - MonTueWedThu - Kizito  Kiyimba	\N	92	SEM	148	13	\N	\N	2	Y	Y	Y	N	\N	\N	\N	1982	1982	MonTueWedThu	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1967	2349	PHWR	Period4 - SEM1 - TueWed - C  Nyandoro	\N	88	SEM	148	59	MAYR	\N	16	Y	Y	Y	N	\N	\N	\N	1967	1967	TueWed	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1873	2297	JHEL	Period4 - SEM1 - TueFri - Olivier  Sempiga	\N	88	SEM	148	38	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1873	1873	TueFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1874	2162	PAEEL	Period5 - SEM1 - MonFri - A  Ggita	\N	89	SEM	148	31	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1874	1874	MonFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1875	2314	PCMDPT	Period1 - SEM 2 - MonWedFri - A  Mandeya	\N	85	SEM	149	20	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1875	1875	MonWedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1876	2189	APEL	Period1 - SEM1 - MonTueWedThuFri - Kenneth  Makamure	\N	85	SEM	148	\N	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1876	1876	MonTueWedThuFri	48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1877	2170	DEL	Period7 - SEM 2 - WedFri - Olivier  Sempiga	\N	91	SEM	149	38	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1877	1877	WedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1878	2159	PFR	Period5 - SEM 2 - MonWed - Diddy  Brossala	\N	89	SEM	149	24	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1878	1878	MonWed	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1879	2254	APEL	Period1 - SEM1 - MonTueWedThuFri - Johnny  Stacer	\N	85	SEM	148	\N	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1879	1879	MonTueWedThuFri	48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1880	2289	DHPUGE	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	85	SEM	149	26	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1880	1880	TueThu	49	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1881	2260	GPEL	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	85	SEM	149	26	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1881	1881	TueThu	48	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1495	2017	IPLPUGE	Period1 - SEM 2 - MonWedFri - T  Sherman	\N	77	SEM	144	21	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	1495	1495	MonWedFri	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1496	1999	BPUGE	Period1 - SEM 2 - TueThu - Costa  Virgilio	\N	77	SEM	144	33	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	1496	1496	TueThu	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2044	2395	INTROPOL	Period8 - SEM 2 - ThuFri - Rachael   Rufu	\N	92	SEM	149	90	\N	\N	2	Y	Y	Y	N	\N	\N	\N	2044	2044	ThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2027	2301	ICSPEL	Period8 - SEM 2 - TueWedFri - K  Esenther	\N	92	SEM	149	22	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2027	2027	TueWedFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2012	2380	THNGUGI	Period8 - SEM 2 - MonFri - A  Chennells	\N	92	SEM	149	42	\N	\N	4	Y	Y	Y	N	\N	\N	\N	2012	2012	MonFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1998	2368	PHILTEK	Period8 - SEM 2 - TueThuFri - Kizito  Kiyimba	\N	92	SEM	149	13	\N	\N	4	Y	Y	Y	N	\N	\N	\N	1998	1998	TueThuFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1983	2356	NIETZ	Period8 - SEM1 - MonTueFri - Costa  Virgilio	\N	92	SEM	148	33	\N	\N	9	Y	Y	Y	N	\N	\N	\N	1983	1983	MonTueFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1865	2148	PEDMA	Period3 - SEM1 - WedFri - C  Nyandoro	\N	87	SEM	148	59	YR1	\N	8	Y	Y	Y	N	\N	\N	\N	1865	1865	WedFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1882	2166	BLMA	Period4 - SEM1 - TueFri - John  Stacer	\N	88	SEM	148	50	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1882	1882	TueFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1883	2134	BIOE	Period5 - SEM 2 - MonWed - Costa  Virgilio	\N	89	SEM	149	33	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1883	1883	MonWed	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1885	2157	ASCA	Period5 - SEM 2 - MonWed - Lawrence  Daka	\N	89	SEM	149	44	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1885	1885	MonWed	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1886	2129	PSDRG	Period5 - SEM 2 - TueFri - A  Manyere	\N	89	SEM	149	30	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1886	1886	TueFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1887	2171	OTS	Period2 - SEM 2 - TueThu - K  Esenther	\N	86	SEM	149	22	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1887	1887	TueThu	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1888	2168	ST	Period6 - SEM1 - MonWed - Costa  Virgilio	\N	90	SEM	148	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1888	1888	MonWed	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1889	2152	PAE	Period4 - SEM1 - MonWedFri - A  Ggita	\N	88	SEM	148	31	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1889	1889	MonWedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1890	2151	HIVA	Period1 - SEM1 - MonThu - A  Mandeya	\N	85	SEM	148	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1890	1890	MonThu	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1891	2175	FLYR1	Period1 - SEM 2 - MonWedFri - A  Ggita	\N	85	SEM	149	31	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1891	1891	MonWedFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1892	2214	PPPYR4	Period1 - SEM 2 - MonTueWedThuFri - John  Stacer	\N	85	SEM	149	50	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	1892	1892	MonTueWedThuFri	50	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1893	2165	APHIL	Period4 - SEM 2 - TueWed - Diddy  Brossala	\N	88	SEM	149	24	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1893	1893	TueWed	50	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1894	2131	HOMP	Period3 - SEM 2 - TueThu - T  Sherman	\N	87	SEM	149	21	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1894	1894	TueThu	50	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1895	2281	HMPPUG2	Period3 - SEM1 - MonWedFri - T  Sherman	\N	87	SEM	148	21	YR3	\N	12	Y	Y	Y	N	\N	\N	\N	1895	1895	MonWedFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1896	2141	LOG	Period3 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	87	SEM	149	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1896	1896	MonWedFri	50	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1897	2199	PAPUGYR2	Period2 - SEM1 - TueThu - John  Stacer	\N	86	SEM	148	50	YR@	\N	0	Y	Y	Y	N	\N	\N	\N	1897	1897	TueThu	50	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1898	2282	PLPPUG2	Period4 - SEM1 - TueThuFri - Diddy  Brossala	\N	88	SEM	148	24	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1898	1898	TueThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1543	1874	POSMA	Period4 - SEM 2 - WedFri - Kizito  Kiyimba	\N	80	SEM	144	13	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	1543	1543	WedFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2045	2396	INTROPEACE	Period8 - SEM 2 - MonWedFri - A  Mandeya	\N	92	SEM	149	20	\N	\N	11	Y	Y	Y	N	\N	\N	\N	2045	2045	MonWedFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2013	2381	CURIDEV	Period7 - SEM 2 - TueWedFri - C  Nyandoro	\N	91	SEM	149	59	\N	\N	2	Y	Y	Y	N	\N	\N	\N	2013	2013	TueWedFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1999	2369	SCIEREL	Period8 - SEM 2 - TueWedThuFri - Costa  Virgilio	\N	92	SEM	149	33	\N	\N	6	Y	Y	Y	N	\N	\N	\N	1999	1999	TueWedThuFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1977	2356	NIETZ	Period6 - SEM1 - MonThu - Costa  Virgilio	\N	90	SEM	148	33	\N	\N	13	Y	Y	Y	N	\N	\N	\N	1977	1977	MonThu	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1968	2352	ARPH	Period4 - SEM1 - MonFri - T  Sherman	\N	88	SEM	148	21	MAYR	\N	2	Y	Y	Y	N	\N	\N	\N	1968	1968	MonFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1899	2268	NTFPUG3	Period3 - SEM1 - MonTueFri - I  Chidavaenzi	\N	87	SEM	148	18	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	1899	1899	MonTueFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1900	2125	EPMA	Period2 - SEM1 - TueThu - Kizito  Kiyimba	\N	86	SEM	148	13	YR1	\N	16	Y	Y	Y	N	\N	\N	\N	1900	1900	TueThu	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1901	2243	SPMA	Period1 - SEM1 - MonWed - Costa  Virgilio	\N	85	SEM	148	33	MAYR	\N	8	Y	Y	Y	N	\N	\N	\N	1901	1901	MonWed	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1902	2312	CTIDPT	Period3 - SEM 2 - MonWedFri - A  Manyere	\N	87	SEM	149	30	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1902	1902	MonWedFri	51	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1903	2101	ELEL	Period5 - SEM1 - MonWedFri - Costa  Virgilio	\N	89	SEM	148	33	\N	\N	12	Y	Y	Y	N	\N	\N	\N	1903	1903	MonWedFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1904	2164	GAEL	Period5 - SEM1 - TueThu - A  Mandeya	\N	89	SEM	148	20	YR3	\N	9	Y	Y	Y	N	\N	\N	\N	1904	1904	TueThu	51	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1905	2156	PMOE	Period2 - SEM 2 - MonFri - C  Nyandoro	\N	86	SEM	149	59	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1905	1905	MonFri	51	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1906	2227	EDPT	Period3 - SEM1 - TueThu - Olivier  Sempiga	\N	87	SEM	148	38	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1906	1906	TueThu	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1907	2145	PAEL	Period8 - SEM1 - MonWedFri - A  Ggita	\N	92	SEM	148	31	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	1907	1907	MonWedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1908	2287	PPPPUG3	Period2 - SEM1 - MonTueWedThuFri - John  Stacer	\N	86	SEM	148	50	Offices	\N	0	Y	Y	Y	N	\N	\N	\N	1908	1908	MonTueWedThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1909	2245	LPMA	Period3 - SEM1 - TueThu - Diddy  Brossala	\N	87	SEM	148	24	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	1909	1909	TueThu	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1910	2218	CMYR1	Period3 - SEM 2 - MonWedFri - A  Zvaiwa	\N	87	SEM	149	51	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1910	1910	MonWedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1911	2302	BEL	Period1 - SEM1 - MonWedFri - Costa  Virgilio	\N	85	SEM	148	33	YR2	\N	3	Y	Y	Y	N	\N	\N	\N	1911	1911	MonWedFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1913	2177	ENYR1	Period1 - SEM1 - TueThu - K  Esenther	\N	85	SEM	148	22	YR1	\N	20	Y	Y	Y	N	\N	\N	\N	1913	1913	TueThu	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1915	2185	ITYR1	Period5 - SEM1 - MonWed - INTYR2 - John  Sanni	\N	89	SEM	148	83	YR1	\N	13	Y	Y	Y	N	\N	\N	\N	1915	1915	MonWed	51	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1916	2178	HAYR1	Period2 - SEM1 - MonWedFri - P  Nyambara	\N	86	SEM	148	8	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	1916	1916	MonWedFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1917	2176	LAYR1	Period3 - SEM1 - Wed - A  Chennells	\N	87	SEM	148	42	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	1917	1917	Wed	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1582	1898	SKEL	Period6 - SEM1 - MonWedFri - Diddy  Brossala	\N	82	SEM	143	24	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1582	1582	MonWedFri	45	32	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1590	1897	BLEL	Period6 - SEM1 - MonThu - John  Stacer	\N	82	SEM	143	50	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1590	1590	MonThu	45	30	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1591	1843	AIEL	Period1 - SEM1 - WedFri - A  Chennells	\N	77	SEM	143	42	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1591	1591	WedFri	45	30	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2046	2397	INTROHRIGH	Period8 - SEM 2 - MonThuFri - Kirenga  Kirenga	\N	92	SEM	149	93	\N	\N	3	Y	Y	Y	N	\N	\N	\N	2046	2046	MonThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2029	2387	INTROPOL	Period7 - SEM 2 - MonThuFri - Rachael   Rufu	\N	91	SEM	149	90	\N	\N	11	Y	Y	Y	N	\N	\N	\N	2029	2029	MonThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2014	2381	CURIDEV	Period8 - SEM 2 - MonFri - C  Nyandoro	\N	92	SEM	149	59	\N	\N	2	Y	Y	Y	N	\N	\N	\N	2014	2014	MonFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2000	2370	CURIDEV	Period8 - SEM 2 - MonTueWedThuFri - C  Nyandoro	\N	92	SEM	149	59	\N	\N	1	Y	Y	Y	N	\N	\N	\N	2000	2000	MonTueWedThuFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1984	2101	ELEL	Period8 - SEM1 - MonWed - Costa  Virgilio	\N	92	SEM	148	33	\N	\N	1	Y	Y	Y	N	\N	\N	\N	1984	1984	MonWed	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1965	2346	IGSPI	Period6 - SEM1 - MonThuFri - A  Manyere	\N	90	SEM	148	30	MAYR	\N	11	Y	Y	Y	N	\N	\N	\N	1965	1965	MonThuFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1919	2183	MRYR1	Period2 - SEM1 - TueThu - C  Nyandoro	\N	86	SEM	148	59	YR1	\N	10	Y	Y	Y	N	\N	\N	\N	1919	1919	TueThu	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1922	2175	FLYR1	Period1 - SEM 2 - MonTue - Dominique  Karani	\N	85	SEM	149	54	YR1	\N	8	Y	Y	Y	N	\N	\N	\N	1922	1922	MonTue	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2016	3	3377	3609	FREUD	PUG16S1P4 - SEM1 - Tue - A  Zvaiwa	\N	256	SEM	184	51	\N	\N	7	Y	Y	Y	N	\N	\N	\N	3377	3377	Tue	94	59	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1923	2186	ENYR1	Period1 - SEM 2 - WedThuFri - K  Esenther	\N	85	SEM	149	22	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1923	1923	WedThuFri	50	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1924	2180	RAYR1	Period3 - SEM 2 - Fri - Francis  Zangairai	\N	87	SEM	149	78	YR1	\N	10	Y	Y	Y	N	\N	\N	\N	1924	1924	Fri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1925	2113	OCYR1	Period4 - SEM 2 - TueFri - A  Manyere	\N	88	SEM	149	30	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1925	1925	TueFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1928	2253	ALFYR2	Period3 - SEM 2 - MonFri - Dominique  Karani	\N	87	SEM	149	54	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	1928	1928	MonFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1930	2192	WLYR2	Period4 - SEM 2 - TueFri - A  Chennells	\N	88	SEM	149	42	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1930	1930	TueFri	51	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1931	2216	OCTYR4	Period2 - SEM 2 - MonWed - Joseph  Mahlahla	\N	86	SEM	149	79	YR4	\N	24	Y	Y	Y	N	\N	\N	\N	1931	1931	MonWed	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1932	2215	REYR4	Period4 - SEM 2 - TueThu - C  Nyandoro	\N	88	SEM	149	59	YR4	\N	24	Y	Y	Y	N	\N	\N	\N	1932	1932	TueThu	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1933	2339	PCMEL	Period1 - SEM1 - MonWedFri - A  Mandeya	\N	85	SEM	148	20	YR3	\N	5	Y	Y	Y	N	\N	\N	\N	1933	1933	MonWedFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1934	2124	ISEL	Period6 - SEM1 - TueThu - A  Manyere	\N	90	SEM	148	30	YR4	\N	1	Y	Y	Y	N	\N	\N	\N	1934	1934	TueThu	50	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1936	2238	MAHE	Period1 - SEM 2 - TueFri - John  Stacer	\N	85	SEM	149	50	MAYR	\N	0	Y	Y	Y	N	\N	\N	\N	1936	1936	TueFri	51	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1937	2325	OSAD	Period1 - SEM 2 - TueFri - Patrick  Ryan	\N	85	SEM	149	84	DYR1	\N	0	Y	Y	Y	N	\N	\N	\N	1937	1937	TueFri	51	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1938	2324	ATPUG	Period1 - SEM 2 - TueFri - Francis  Zangairai	\N	85	SEM	149	78	DYR1	\N	0	Y	Y	Y	N	\N	\N	\N	1938	1938	TueFri	51	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1626	1946	HMP	Period4 - SEM1 - MonWed - A  Ggita	\N	80	SEM	143	31	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1626	1626	MonWed	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1627	1959	HCT	Period2 - SEM1 - MonWedFri - C  Nyandoro	\N	78	SEM	143	59	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1627	1627	MonWedFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2047	2398	PHILTEK	Period7 - SEM 2 - MonThuFri - Francis  Zangairai	\N	91	SEM	149	78	\N	\N	3	Y	Y	Y	N	\N	\N	\N	2047	2047	MonThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2015	2382	THGARD	Period7 - SEM 2 - MonFri - C  Nyandoro	\N	91	SEM	149	59	\N	\N	1	Y	Y	Y	N	\N	\N	\N	2015	2015	MonFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2001	2371	PHILTEK	Period5 - SEM 2 - MonThuFri - Kizito  Kiyimba	\N	89	SEM	149	13	\N	\N	1	Y	Y	Y	N	\N	\N	\N	2001	2001	MonThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1985	2362	ARPH	Period6 - SEM1 - MonThuFri - T  Sherman	\N	90	SEM	148	21	\N	\N	5	Y	Y	Y	N	\N	\N	\N	1985	1985	MonThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1969	2353	GREEK	Period2 - SEM1 - TueWedThuFri - A  Chennells	\N	86	SEM	148	42	YR1	\N	6	Y	Y	Y	N	\N	\N	\N	1969	1969	TueWedThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1939	2169	PSDRGEL	Period4 - SEM 2 - MonTueWedThu - A  Manyere	\N	88	SEM	149	30	YR1	\N	16	Y	Y	Y	N	\N	\N	\N	1939	1939	MonTueWedThu	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1940	2209	OTFYR3	Period3 - SEM 2 - TueThu - I  Chidavaenzi	\N	87	SEM	149	18	YR3	\N	13	Y	Y	Y	N	\N	\N	\N	1940	1940	TueThu	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1941	2296	OCYR4	Period1 - SEM 2 - MonTueWedThuFri - John  Stacer	\N	85	SEM	149	50	YR4	\N	25	Y	Y	Y	N	\N	\N	\N	1941	1941	MonTueWedThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1666	2057	FL	Period7 - SEM1 - TueThu - Kizito  Kiyimba	\N	83	SEM	143	13	YR1	\N	7	Y	Y	Y	N	\N	\N	\N	1666	1666	TueThu	47	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1660	2051	HOAP	Period2 - SEM1 - TueThu - T  Sherman	\N	78	SEM	143	21	YR3	\N	2	Y	Y	Y	N	\N	\N	\N	1660	1660	TueThu	47	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1551	2004	FLPUG1	Period1 - SEM1 - MonWed - Dominique  Karani	\N	77	SEM	143	54	YR1	\N	12	Y	Y	Y	N	\N	\N	\N	1551	1551	MonWed	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1658	2049	POL	Period5 - SEM1 - MonWedFri - Francis  Zangairai	\N	81	SEM	143	78	YR 1	\N	2	Y	Y	Y	N	\N	\N	\N	1658	1658	MonWedFri	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1659	2050	TTEL	Period6 - SEM1 - TueThu - Costa  Virgilio	\N	82	SEM	143	33	YR 3	\N	2	Y	Y	Y	N	\N	\N	\N	1659	1659	TueThu	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1667	2058	POR	Period5 - SEM1 - MonWedFri - Francis  Zangairai	\N	81	SEM	143	78	YR2	\N	7	Y	Y	Y	N	\N	\N	\N	1667	1667	MonWedFri	47	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1662	2053	FRLS	Period1 - SEM1 - MonWed - Dominique  Karani	\N	77	SEM	143	54	YR 1	\N	1	Y	Y	Y	N	\N	\N	\N	1662	1662	MonWed	47	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1664	2055	MRS	Period1 - SEM1 - TueThu - C  Nyandoro	\N	77	SEM	143	59	YR 1	\N	5	Y	Y	Y	N	\N	\N	\N	1664	1664	TueThu	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1669	2060	SLS	Period6 - SEM1 - TueThu - teacher  teacher	\N	82	SEM	143	28	YR 1	\N	0	Y	Y	Y	N	\N	\N	\N	1669	1669	TueThu	47	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1671	2062	ITBL	Period5 - SEM1 - TueFri - A  Chennells	\N	81	SEM	143	42	YR 3	\N	1	Y	Y	Y	N	\N	\N	\N	1671	1671	TueFri	47	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1694	2073	MAISLAM	Period3 - SEM 2 - Mon - Patrick  Ryan	\N	79	SEM	144	84	MAYR	\N	2	Y	Y	Y	N	\N	\N	\N	1694	1694	Mon	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1695	2074	PHIH	Period4 - SEM 2 - Wed - C  Nyandoro	\N	80	SEM	144	59	MAYR	\N	5	Y	Y	Y	N	\N	\N	\N	1695	1695	Wed	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1696	2075	PHMA	Period5 - SEM 2 - MonThu - T  Sherman	\N	81	SEM	144	21	MAYR	\N	1	Y	Y	Y	N	\N	\N	\N	1696	1696	MonThu	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1670	2061	PTP	Period5 - SEM 2 - WedFri - Kizito  Kiyimba	\N	81	SEM	144	13	YR2	\N	4	Y	Y	Y	N	\N	\N	\N	1670	1670	WedFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1518	2032	APEL	Period1 - SEM1 - MonTueWedThuFri - A  Chennells	\N	77	SEM	143	42	YR3	\N	3	Y	Y	Y	N	\N	\N	\N	1518	1518	MonTueWedThuFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1672	2063	POR	Period5 - SEM1 - MonWedFri - Francis  Zangairai	\N	81	SEM	143	78	YR 1	\N	1	Y	Y	Y	N	\N	\N	\N	1672	1672	MonWedFri	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1673	2064	PLS	Period5 - SEM1 - TueThu - Costa  Virgilio	\N	81	SEM	143	33	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	1673	1673	TueThu	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1675	2066	FL	Period7 - SEM1 - TueThu - Kizito  Kiyimba	\N	83	SEM	143	13	YR1	\N	2	Y	Y	Y	N	\N	\N	\N	1675	1675	TueThu	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1683	2070	DISSER	Period5 - T1 - MonWedThu - Kizito  Kiyimba	\N	81	QTR	146	13	YR 1	\N	0	Y	Y	Y	N	\N	\N	\N	1683	1683	MonWedThu	47	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1677	2067	AQLKB	Period5 - SEM1 - MonWedFri - T  Sherman	\N	81	SEM	143	21	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	1677	1677	MonWedFri	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1678	2068	LOM	Period7 - SEM1 - TueThu - A  Chennells	\N	83	SEM	143	42	YR 3	\N	3	Y	Y	Y	N	\N	\N	\N	1678	1678	TueThu	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1679	2069	PTP	Period5 - SEM1 - MonWed - Kizito  Kiyimba	\N	81	SEM	143	13	YR2	\N	1	Y	Y	Y	N	\N	\N	\N	1679	1679	MonWed	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1516	2048	FLPUG1	Period1 - SEM 2 - MonWedFri - A  Ggita	\N	77	SEM	144	31	DIP YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1516	1516	MonWedFri	45	32	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1459	1925	PTDYR2	Period4 - SEM1 - MonWedFri - A  Manyere	\N	80	SEM	143	30	YR2	\N	13	Y	Y	Y	N	\N	\N	\N	1459	1459	MonWedFri	43	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1469	1905	VT2YR1	Period3 - SEM1 - Mon - Joseph  Mahlahla	\N	79	SEM	143	79	YR1	\N	7	Y	Y	Y	N	\N	\N	\N	1469	1469	Mon	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1465	1919	RWYR2	Period3 - SEM1 - MonWedFri - Francis  Zangairai	\N	79	SEM	143	78	YR2	\N	13	Y	Y	Y	N	\N	\N	\N	1465	1465	MonWedFri	43	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1464	1928	PSYR3	Period4 - SEM1 - MonThu - Kizito  Kiyimba	\N	80	SEM	143	13	YR3	\N	27	Y	Y	Y	N	\N	\N	\N	1464	1464	MonThu	43	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1462	1935	APYR4	Period3 - SEM1 - MonWedFri - John  Sanni	\N	79	SEM	143	83	YR3	\N	19	Y	Y	Y	N	\N	\N	\N	1462	1462	MonWedFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1460	1936	EHYR4	Period2 - SEM1 - MonWed - John  Stacer	\N	78	SEM	143	50	YR4	\N	19	Y	Y	Y	N	\N	\N	\N	1460	1460	MonWed	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1514	1996	REPUG3	Period3 - SEM 2 - MonWedFri - C  Nyandoro	\N	79	SEM	144	59	YR4	\N	5	Y	Y	Y	N	\N	\N	\N	1514	1514	MonWedFri	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1515	2019	PCMPUGE	Period1 - SEM 2 - TueThu - A  Mandeya	\N	77	SEM	144	20	DIP YR1	\N	7	Y	Y	Y	N	\N	\N	\N	1515	1515	TueThu	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1517	2010	MCPPUG2	Period4 - SEM 2 - MonWed - T  Sherman	\N	80	SEM	144	21	YR3	\N	5	Y	Y	Y	N	\N	\N	\N	1517	1517	MonWed	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1463	1937	PGYR4	Period4 - SEM1 - MonWedFri - T  Sherman	\N	80	SEM	143	21	YR4	\N	19	Y	Y	Y	N	\N	\N	\N	1463	1463	MonWedFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1643	1880	DEMC	Period6 - SEM 2 - TueThu - Olivier  Sempiga	\N	82	SEM	144	38	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1643	1643	TueThu	45	32	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1650	1981	STEL	Period5 - SEM1 - MonThu - Costa  Virgilio	\N	81	SEM	143	33	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	1650	1650	MonThu	43	30	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1473	1989	SSAPUG1	Period1 - SEM 2 - MonWedThu - Ben  Sachikonye	\N	77	SEM	144	37	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1473	1473	MonWedThu	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1475	2001	RAPUG1	Period1 - SEM 2 - MonThuFri - Francis  Zangairai	\N	77	SEM	144	78	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1475	1475	MonThuFri	45	32	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1478	1980	GAAPH	Period1 - SEM1 - MonTueWedThuFri - Ujah  Ejembi	\N	77	SEM	143	26	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1478	1478	MonTueWedThuFri	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1479	2041	IDDPT	Period4 - SEM 2 - TueThuFri - C  Nyandoro	\N	80	SEM	144	59	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1479	1479	TueThuFri	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1480	1953	PRYR2	Period2 - SEM1 - MonFri - T  Sherman	\N	78	SEM	143	21	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1480	1480	MonFri	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1481	1954	IOTYR1	Period2 - SEM1 - Wed - Zvaiwa  Zvaiwa	\N	78	SEM	143	\N	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1481	1481	Wed	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1484	1944	IPYR1	Period1 - SEM1 - TueThu - A  Ggita	\N	77	SEM	143	31	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1484	1484	TueThu	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1485	2035	DPTEL	Period2 - SEM1 - TueThu - A  Mandeya	\N	78	SEM	143	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1485	1485	TueThu	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1486	1942	CMYR1	Period1 - SEM1 - MonWedFri - C  Nyandoro	\N	77	SEM	143	59	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1486	1486	MonWedFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1487	1954	IOTYR1	Period2 - SEM1 - WedFri - Zvaiwa  Zvaiwa	\N	78	SEM	143	\N	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1487	1487	WedFri	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1488	1945	HAYR1	Period3 - SEM1 - TueFri - C  Matusse	\N	79	SEM	143	19	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1488	1488	TueFri	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1491	1956	NTYR3	Period2 - SEM1 - TueThu - A  Mandeya	\N	78	SEM	143	20	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1491	1491	TueThu	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1492	2045	HRs	Period1 - SEM1 - Mon - Costa  Virgilio	\N	77	SEM	143	33	Office	\N	0	Y	Y	Y	N	\N	\N	\N	1492	1492	Mon	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1494	2020	APPUGE	Period1 - SEM 2 - Mon - A  Perumalil	\N	77	SEM	144	9	Offices	\N	0	Y	Y	Y	N	\N	\N	\N	1494	1494	Mon	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1649	1909	ITYR1	Period5 - SEM1 - MonWed - John  Sanni	\N	81	SEM	143	83	YR1	\N	7	Y	Y	Y	N	\N	\N	\N	1649	1649	MonWed	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1645	1921	APYR2	Period1 - SEM1 - TueThu - Costa  Virgilio	\N	77	SEM	143	33	YR2	\N	13	Y	Y	Y	N	\N	\N	\N	1645	1645	TueThu	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1477	1922	HMPYR2	Period2 - SEM 2 - TueWedFri - T  Sherman	\N	78	SEM	144	21	YR2	\N	15	Y	Y	Y	N	\N	\N	\N	1477	1477	TueWedFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1652	1918	WLYR2	Period4 - SEM1 - TueThu - A  Chennells	\N	80	SEM	143	42	YR2	\N	12	Y	Y	Y	N	\N	\N	\N	1652	1652	TueThu	43	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1647	1938	NTYR4	Period3 - SEM1 - TueThu - I  Chidavaenzi	\N	79	SEM	143	18	YR4	\N	19	Y	Y	Y	N	\N	\N	\N	1647	1647	TueThu	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1656	1930	ESYR3	Period3 - SEM1 - MonThuFri - Lawrence  Daka	\N	79	SEM	143	44	YR3	\N	27	Y	Y	Y	N	\N	\N	\N	1656	1656	MonThuFri	43	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1654	1927	HMYR3	Period4 - SEM1 - TueThu - T  Sherman	\N	80	SEM	143	21	YR3	\N	27	Y	Y	Y	N	\N	\N	\N	1654	1654	TueThu	43	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1471	1931	CPYR3	Period2 - SEM 2 - MonWed - John  Sanni	\N	78	SEM	144	83	YR3	\N	27	Y	Y	Y	N	\N	\N	\N	1471	1471	MonWed	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1648	1929	PLYR3	Period2 - SEM1 - MonWedFri - Diddy  Brossala	\N	78	SEM	143	24	YR3	\N	25	Y	Y	Y	N	\N	\N	\N	1648	1648	MonWedFri	43	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1493	1993	OFPUG2	Period3 - SEM 2 - WedFri - I  Chidavaenzi	\N	79	SEM	144	18	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1493	1493	WedFri	44	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1644	1850	ROA	Period1 - SEM 2 - MonThuFri - Francis  Zangairai	\N	77	SEM	144	78	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1644	1644	MonThuFri	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1474	1998	ICSPUGE	Period1 - SEM 2 - MonWedFri - K  Esenther	\N	77	SEM	144	22	Computer	\N	6	Y	Y	Y	N	\N	\N	\N	1474	1474	MonWedFri	44	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1651	2026	IGSP	Period1 - SEM1 - TueFri - A  Manyere	\N	77	SEM	143	30	YR3	\N	16	Y	Y	Y	N	\N	\N	\N	1651	1651	TueFri	43	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1490	1953	PRYR2	Period2 - SEM 2 - MonFri - Francis  Zangairai	\N	78	SEM	144	78	YR2	\N	4	Y	Y	Y	N	\N	\N	\N	1490	1490	MonFri	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1646	1982	APEL	Period6 - SEM1 - MonTueWedThuFri - A  Mandeya	\N	82	SEM	143	20	YR3	\N	10	Y	Y	Y	N	\N	\N	\N	1646	1646	MonTueWedThuFri	43	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1642	1933	MCPYR3	Period3 - SEM 2 - MonTue - T  Sherman	\N	79	SEM	144	21	YR3	\N	27	Y	Y	Y	N	\N	\N	\N	1642	1642	MonTue	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1498	1848	PCCEL	Period5 - SEM 2 - MonWedFri - A  Mandeya	\N	81	SEM	144	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1498	1498	MonWedFri	45	30	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1504	1983	DPTEL	Period2 - SEM1 - TueThu - T  Sherman	\N	78	SEM	143	21	DP	\N	0	Y	Y	Y	N	\N	\N	\N	1504	1504	TueThu	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1505	2034	DPTEL	Period2 - SEM1 - TueThu - Kenneth  Makamure	\N	78	SEM	143	\N	DP	\N	0	Y	Y	Y	N	\N	\N	\N	1505	1505	TueThu	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1506	1890	SPP	Period3 - SEM1 - TueFri - Diddy  Brossala	\N	79	SEM	143	24	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1506	1506	TueFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1508	2006	PTDPUG1	Period3 - SEM1 - MonWedFri - A  Manyere	\N	79	SEM	143	30	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1508	1508	MonWedFri	45	32	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1509	1885	FFEL	Period5 - SEM1 - MonWed - Diddy  Brossala	\N	81	SEM	143	24	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1509	1509	MonWed	45	30	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1510	2000	HRPUGE	Period1 - SEM 2 - MonWedFri - Costa  Virgilio	\N	77	SEM	144	33	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	1510	1510	MonWedFri	45	32	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1483	1895	FLS	Period1 - SEM1 - MonWed - Dominique  Karani	\N	77	SEM	143	54	YR1	\N	1	Y	Y	Y	N	\N	\N	\N	1483	1483	MonWed	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1482	1976	ATYR2	Period1 - SEM1 - MonWedFri - A  Mandeya	\N	77	SEM	143	20	YR2	\N	4	Y	Y	Y	N	\N	\N	\N	1482	1482	MonWedFri	47	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1511	2036	DPTEL	Period2 - SEM1 - TueThu - Johnny  Stacer	\N	78	SEM	143	\N	DP	\N	0	Y	Y	Y	N	\N	\N	\N	1511	1511	TueThu	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1519	2033	APEL	Period1 - SEM1 - MonTueWedThuFri - Lawrence  Daka	\N	77	SEM	143	\N	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1519	1519	MonTueWedThuFri	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1520	2030	PFEL	Period1 - SEM 2 - MonWedFri - Diddy  Brossala	\N	77	SEM	144	24	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1520	1520	MonWedFri	45	30	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1521	1876	PCC	Period6 - SEM 2 - TueWedFri - A  Mandeya	\N	82	SEM	144	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1521	1521	TueWedFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1524	1958	HCTPDPT	Period2 - SEM 2 - TueThu - C  Nyandoro	\N	78	SEM	144	59	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1524	1524	TueThu	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1525	2046	ICSDPT	Period2 - SEM 2 - TueThu - K  Esenther	\N	78	SEM	144	22	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1525	1525	TueThu	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1526	1957	ITDPT	Period1 - SEM1 - MonWedFri - K  Esenther	\N	77	SEM	143	22	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1526	1526	MonWedFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1527	1955	INTDPT	Period3 - SEM 2 - MonThuFri - A  Mandeya	\N	79	SEM	144	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1527	1527	MonThuFri	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1530	2018	PFPUGE	Period1 - SEM 2 - MonWedFri - Diddy  Brossala	\N	77	SEM	144	24	Aud Visual	\N	0	Y	Y	Y	N	\N	\N	\N	1530	1530	MonWedFri	45	32	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1533	2045	HRs	Period3 - SEM 2 - MonWedFri - Costa  Virgilio	\N	79	SEM	144	33	Aud Visual	\N	0	Y	Y	Y	N	\N	\N	\N	1533	1533	MonWedFri	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1534	2044	DHDPT	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	77	SEM	144	26	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1534	1534	TueThu	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1535	2043	HRDPT	Period1 - SEM 2 - TueThuFri - Costa  Virgilio	\N	77	SEM	144	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1535	1535	TueThuFri	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1536	2037	FAEL	Period1 - SEM 2 - Wed - T  Sherman	\N	77	SEM	144	21	Y4	\N	0	Y	Y	Y	N	\N	\N	\N	1536	1536	Wed	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1537	1915	PLEL	Period1 - SEM 2 - MonWedFri - T  Sherman	\N	77	SEM	144	21	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1537	1537	MonWedFri	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1538	1987	RSFANEL	Period1 - SEM 2 - MonWedFri - A  Chennells	\N	77	SEM	144	42	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1538	1538	MonWedFri	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1499	1852	APHIL	Period4 - SEM1 - TueWed - Diddy  Brossala	\N	80	SEM	143	24	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1499	1499	TueWed	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1513	1992	PMEPUG2	Period3 - SEM 2 - TueWedThu - A  Ggita	\N	79	SEM	144	31	YR3	\N	5	Y	Y	Y	N	\N	\N	\N	1513	1513	TueWedThu	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1507	1896	LOG	Period3 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	79	SEM	144	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1507	1507	MonWedFri	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1523	2014	OCTPUG3	Period3 - SEM 2 - WedFri - Joseph  Mahlahla	\N	79	SEM	144	79	YR4	\N	2	Y	Y	Y	N	\N	\N	\N	1523	1523	WedFri	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1472	1956	NTYR2	Period1 - SEM1 - TueThu - K  Esenther	\N	77	SEM	143	22	YR3	\N	15	Y	Y	Y	N	\N	\N	\N	1472	1472	TueThu	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1501	1847	POE	Period3 - SEM 2 - TueThu - A  Zvaiwa	\N	79	SEM	144	51	YR2	\N	1	Y	Y	Y	N	\N	\N	\N	1501	1501	TueThu	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1528	1949	EPDPT	Period3 - SEM 2 - MonWedFri - Costa  Virgilio	\N	79	SEM	144	33	YR3	\N	4	Y	Y	Y	N	\N	\N	\N	1528	1528	MonWedFri	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1503	2039	IEDPT	Period1 - SEM 2 - WedThuFri - A  Mandeya	\N	77	SEM	144	20	YR3	\N	4	Y	Y	Y	N	\N	\N	\N	1503	1503	WedThuFri	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1497	1865	LLEL	Period2 - SEM 2 - MonWedFri - I  Chidavaenzi	\N	78	SEM	144	18	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1497	1497	MonWedFri	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1502	2028	ICSPEL	Period1 - SEM 2 - MonWedFri - K  Esenther	\N	77	SEM	144	22	YR1	\N	6	Y	Y	Y	N	\N	\N	\N	1502	1502	MonWedFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1529	2009	CPPUG2	Period2 - SEM 2 - MonWedFri - Diddy  Brossala	\N	78	SEM	144	24	YR3	\N	5	Y	Y	Y	N	\N	\N	\N	1529	1529	MonWedFri	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1500	1868	BAPRE	Period4 - SEM 2 - TueThu - A  Zvaiwa	\N	80	SEM	144	51	\N	\N	7	Y	Y	Y	N	\N	\N	\N	1500	1500	TueThu	45	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1544	1882	POLA	Period4 - SEM 2 - TueFri - Kizito  Kiyimba	\N	80	SEM	144	13	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1544	1544	TueFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1554	1864	KEL	Period5 - SEM1 - TueThu - Diddy  Brossala	\N	81	SEM	143	24	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1554	1554	TueThu	45	30	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1539	1984	IPPUG1	Period3 - SEM1 - MonThu - John  Sanni	\N	79	SEM	143	83	YR1	\N	12	Y	Y	Y	N	\N	\N	\N	1539	1539	MonThu	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1547	2011	SAPPUG3	Period2 - SEM1 - MonWedThu - John  Sanni	\N	78	SEM	143	83	YR4	\N	3	Y	Y	Y	N	\N	\N	\N	1547	1547	MonWedThu	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1548	1994	EHPUG3	Period2 - SEM1 - TueThu - John  Stacer	\N	78	SEM	143	50	YR4	\N	3	Y	Y	Y	N	\N	\N	\N	1548	1548	TueThu	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1540	1985	POM	Period2 - SEM1 - MonWedFri - Costa  Virgilio	\N	78	SEM	143	33	YR2	\N	13	Y	Y	Y	N	\N	\N	\N	1540	1540	MonWedFri	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1555	2002	APPUG1	Period2 - SEM 2 - MonThu - Diddy  Brossala	\N	78	SEM	144	24	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1555	1555	MonThu	45	32	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1565	1914	DHBAEL	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	77	SEM	144	26	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1565	1565	TueThu	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1566	1961	CHYR2	Period1 - SEM1 - MonThu - G  Makwasha	\N	77	SEM	143	\N	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1566	1566	MonThu	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1567	1961	CHYR1	Period1 - SEM1 - MonThu - G  Makwasha	\N	77	SEM	143	\N	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1567	1567	MonThu	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1568	1867	STEL	Period7 - SEM1 - TueThu - Costa  Virgilio	\N	83	SEM	143	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1568	1568	TueThu	45	32	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1571	1950	MTP	Period1 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	77	SEM	144	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1571	1571	MonWedFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1577	1858	HRPUG	Period3 - SEM 2 - TueThu - Costa  Virgilio	\N	79	SEM	144	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1577	1577	TueThu	45	32	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1578	1948	CONTP	Period2 - SEM 2 - MonWedFri - John  Sanni	\N	78	SEM	144	82	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1578	1578	MonWedFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1545	1883	APHIL	Period4 - SEM 2 - TueWedFri - Diddy  Brossala	\N	80	SEM	144	24	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1545	1545	TueWedFri	45	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1564	1911	LAYR1	Period2 - SEM 2 - TueThu - A  Chennells	\N	78	SEM	144	42	YR1	\N	7	Y	Y	Y	N	\N	\N	\N	1564	1564	TueThu	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1563	1904	RAYR1	Period2 - SEM 2 - TueFri - Francis  Zangairai	\N	78	SEM	144	78	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	1563	1563	TueFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1574	1860	FRLS	Period2 - SEM 2 - MonWed - A  Ggita	\N	78	SEM	144	31	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1574	1574	MonWed	45	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1579	1857	LOGIC	Period1 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	77	SEM	144	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1579	1579	MonWedFri	45	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1573	1856	ROA	Period1 - SEM 2 - MonThuFri - Francis  Zangairai	\N	77	SEM	144	78	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1573	1573	MonThuFri	45	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1559	1924	SSAYR2	Period2 - SEM 2 - MonWedFri - Tom  Tom	\N	78	SEM	144	87	YR2	\N	11	Y	Y	Y	N	\N	\N	\N	1559	1559	MonWedFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1560	1920	WHYR2	Period3 - SEM 2 - TueThu - P  Nyambara	\N	79	SEM	144	8	YR2	\N	11	Y	Y	Y	N	\N	\N	\N	1560	1560	TueThu	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1522	1997	OCEPUG3	Period3 - SEM1 - MonWed - John  Stacer	\N	79	SEM	143	50	Seminar	\N	1	Y	Y	Y	N	\N	\N	\N	1522	1522	MonWed	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1552	1991	ESPPUG2	Period4 - SEM1 - TueThu - Lawrence  Daka	\N	80	SEM	143	44	YR3	\N	5	Y	Y	Y	N	\N	\N	\N	1552	1552	TueThu	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1580	1877	ETH	Period2 - SEM 2 - MonWedFri - Olivier  Sempiga	\N	78	SEM	144	38	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1580	1580	MonWedFri	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1531	1990	PON	Period4 - SEM1 - MonFri - Kizito  Kiyimba	\N	80	SEM	143	13	YR3	\N	5	Y	Y	Y	N	\N	\N	\N	1531	1531	MonFri	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1549	2012	PGPUG3	Period4 - SEM1 - MonWed - T  Sherman	\N	80	SEM	143	21	YR4	\N	3	Y	Y	Y	N	\N	\N	\N	1549	1549	MonWed	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1576	1859	POSPUG	Period3 - SEM1 - MonWedFri - Kizito  Kiyimba	\N	79	SEM	143	13	YR3	\N	5	Y	Y	Y	N	\N	\N	\N	1576	1576	MonWedFri	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1546	2031	HMPPUG1	Period2 - SEM 2 - TueThu - T  Sherman	\N	78	SEM	144	21	YR2	\N	13	Y	Y	Y	N	\N	\N	\N	1546	1546	TueThu	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1541	2005	RWPUG1	Period4 - SEM1 - TueThuFri - Francis  Zangairai	\N	80	SEM	143	78	YR2	\N	13	Y	Y	Y	N	\N	\N	\N	1541	1541	TueThuFri	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1553	1869	PEDMA	Period3 - SEM1 - WedFri - C  Nyandoro	\N	79	SEM	143	59	YR1	\N	10	Y	Y	Y	N	\N	\N	\N	1553	1553	WedFri	45	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1550	2047	LPUG1	Period1 - SEM 2 - MonThu - Kizito  Kiyimba	\N	77	SEM	144	13	YR1	\N	13	Y	Y	Y	N	\N	\N	\N	1550	1550	MonThu	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1532	1951	RPYR3	Period1 - SEM1 - MonWedFri - C  Nyandoro	\N	77	SEM	143	59	YR3	\N	15	Y	Y	Y	N	\N	\N	\N	1532	1532	MonWedFri	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1570	1962	ETMA	Period2 - SEM 2 - MonWed - Costa  Virgilio	\N	78	SEM	144	33	YR4	\N	10	Y	Y	Y	N	\N	\N	\N	1570	1570	MonWed	45	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1572	1855	LAWA	Period2 - SEM 2 - MonThu - T  Sherman	\N	78	SEM	144	21	YR3	\N	4	Y	Y	Y	N	\N	\N	\N	1572	1572	MonThu	45	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1542	2016	PSDPUGE	Period4 - SEM 2 - MonTueWedThu - A  Manyere	\N	80	SEM	144	30	Aud Visual	\N	2	Y	Y	Y	N	\N	\N	\N	1542	1542	MonTueWedThu	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1558	1932	PMEYR3	Period3 - SEM 2 - MonFri - C  Nyandoro	\N	79	SEM	144	59	YR3	\N	26	Y	Y	Y	N	\N	\N	\N	1558	1558	MonFri	45	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1592	2024	CTEL	Period5 - SEM1 - TueFri - Diddy  Brossala	\N	81	SEM	143	24	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1592	1592	TueFri	45	30	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1593	2023	JHEL	Period4 - SEM1 - TueFri - Olivier  Sempiga	\N	80	SEM	143	38	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1593	1593	TueFri	45	30	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1594	1884	PAEEL	Period5 - SEM1 - MonFri - A  Ggita	\N	81	SEM	143	31	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1594	1594	MonFri	45	30	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1597	2042	PCMDPT	Period1 - SEM 2 - MonWedFri - A  Mandeya	\N	77	SEM	144	20	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1597	1597	MonWedFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1598	1913	APEL	Period1 - SEM1 - MonTueWedThuFri - Kenneth  Makamure	\N	77	SEM	143	\N	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1598	1598	MonTueWedThuFri	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1600	1893	DEL	Period7 - SEM 2 - WedFri - Olivier  Sempiga	\N	83	SEM	144	38	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1600	1600	WedFri	45	30	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1603	1881	PFR	Period5 - SEM 2 - MonWed - Diddy  Brossala	\N	81	SEM	144	24	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1603	1603	MonWed	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1604	1979	APEL	Period1 - SEM1 - MonTueWedThuFri - Johnny  Stacer	\N	77	SEM	143	\N	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1604	1604	MonTueWedThuFri	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1607	2015	DHPUGE	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	77	SEM	144	26	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1607	1607	TueThu	44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1608	1986	GPEL	Period1 - SEM 2 - TueThu - Ujah Gabriel Ejembi	\N	77	SEM	144	26	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1608	1608	TueThu	43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1609	1888	BLMA	Period4 - SEM1 - TueFri - John  Stacer	\N	80	SEM	143	50	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1609	1609	TueFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1610	1854	BIOE	Period5 - SEM 2 - MonWed - Costa  Virgilio	\N	81	SEM	144	33	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1610	1610	MonWed	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1611	1853	PCC	Period5 - SEM 2 - MonWed - A  Mandeya	\N	81	SEM	144	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1611	1611	MonWed	45	32	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1612	1879	ASCA	Period5 - SEM 2 - MonWed - Lawrence  Daka	\N	81	SEM	144	44	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1612	1612	MonWed	45	32	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1616	1849	PSDRG	Period5 - SEM 2 - TueFri - A  Manyere	\N	81	SEM	144	30	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1616	1616	TueFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1617	1894	OTS	Period2 - SEM 2 - TueThu - K  Esenther	\N	78	SEM	144	22	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1617	1617	TueThu	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1623	1891	ST	Period6 - SEM1 - MonWed - Costa  Virgilio	\N	82	SEM	143	33	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1623	1623	MonWed	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1624	1873	PAE	Period4 - SEM1 - MonWedFri - A  Ggita	\N	80	SEM	143	31	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1624	1624	MonWedFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1625	1872	HIVA	Period1 - SEM1 - MonThu - A  Mandeya	\N	77	SEM	143	20	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1625	1625	MonThu	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1602	1899	FLYR1	Period1 - SEM 2 - MonWedFri - A  Ggita	\N	77	SEM	144	31	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1602	1602	MonWedFri	45	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1622	1939	PPPYR4	Period1 - SEM 2 - MonTueWedThuFri - John  Stacer	\N	77	SEM	144	50	YR4	\N	19	Y	Y	Y	N	\N	\N	\N	1622	1622	MonTueWedThuFri	45	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1615	1887	APHIL	Period4 - SEM 2 - TueWed - Diddy  Brossala	\N	80	SEM	144	24	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1615	1615	TueWed	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1613	1851	HOMP	Period3 - SEM 2 - TueThu - T  Sherman	\N	79	SEM	144	21	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1613	1613	TueThu	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1556	2007	HMPPUG2	Period3 - SEM1 - MonWedFri - T  Sherman	\N	79	SEM	143	21	YR3	\N	5	Y	Y	Y	N	\N	\N	\N	1556	1556	MonWedFri	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1614	1862	LOG	Period3 - SEM 2 - MonWedFri - Kizito  Kiyimba	\N	79	SEM	144	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1614	1614	MonWedFri	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1583	1889	PAPUGYR2	Period2 - SEM1 - TueThu - John  Stacer	\N	78	SEM	143	50	YR@	\N	0	Y	Y	Y	N	\N	\N	\N	1583	1583	TueThu	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1586	2008	PLPPUG2	Period4 - SEM1 - TueThuFri - Diddy  Brossala	\N	80	SEM	143	24	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1586	1586	TueThuFri	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1557	1995	NTFPUG3	Period3 - SEM1 - MonTueFri - I  Chidavaenzi	\N	79	SEM	143	18	YR4	\N	1	Y	Y	Y	N	\N	\N	\N	1557	1557	MonTueFri	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1588	1846	EPMA	Period2 - SEM1 - TueThu - Kizito  Kiyimba	\N	78	SEM	143	13	YR1	\N	11	Y	Y	Y	N	\N	\N	\N	1588	1588	TueThu	45	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1589	1968	SPMA	Period1 - SEM1 - MonWed - Costa  Virgilio	\N	77	SEM	143	33	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	1589	1589	MonWed	45	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1606	2040	CTIDPT	Period3 - SEM 2 - MonWedFri - A  Manyere	\N	79	SEM	144	30	YR3	\N	4	Y	Y	Y	N	\N	\N	\N	1606	1606	MonWedFri	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1569	1844	ELEL	Period5 - SEM1 - MonWedFri - Costa  Virgilio	\N	81	SEM	143	33	\N	\N	9	Y	Y	Y	N	\N	\N	\N	1569	1569	MonWedFri	45	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1587	1886	GAEL	Period5 - SEM1 - TueThu - A  Mandeya	\N	81	SEM	143	20	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1587	1587	TueThu	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1575	1878	PMOE	Period2 - SEM 2 - MonFri - C  Nyandoro	\N	78	SEM	144	59	YR3	\N	1	Y	Y	Y	N	\N	\N	\N	1575	1575	MonFri	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1628	1952	EDPT	Period3 - SEM1 - TueThu - Olivier  Sempiga	\N	79	SEM	143	38	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1628	1628	TueThu	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1629	1866	PAEL	Period8 - SEM1 - MonWedFri - A  Ggita	\N	84	SEM	143	31	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	1629	1629	MonWedFri	45	32	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1599	2013	PPPPUG3	Period2 - SEM1 - MonTueWedThuFri - John  Stacer	\N	78	SEM	143	50	Offices	\N	1	Y	Y	Y	N	\N	\N	\N	1599	1599	MonTueWedThuFri	47	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1619	1970	LPMA	Period3 - SEM1 - TueThu - Diddy  Brossala	\N	79	SEM	143	24	YR4	\N	6	Y	Y	Y	N	\N	\N	\N	1619	1619	TueThu	47	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1638	1943	CMYR1	Period3 - SEM 2 - MonWedFri - A  Zvaiwa	\N	79	SEM	144	51	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1638	1638	MonWedFri	45	31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1640	2029	BEL	Period1 - SEM 2 - MonWedFri - Costa  Virgilio	\N	77	SEM	144	33	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1640	1640	MonWedFri	45	30	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1596	1906	APYR1	Period4 - SEM 2 - TueFri - Diddy  Brossala	\N	80	SEM	144	24	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1596	1596	TueFri	45	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1595	1901	ENYR1	Period1 - SEM1 - TueThu - K  Esenther	\N	77	SEM	143	22	YR1	\N	7	Y	Y	Y	N	\N	\N	\N	1595	1595	TueThu	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1653	1903	BAFL	Period1 - SEM1 - MonWed - Dominique  Karani	\N	77	SEM	143	54	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	1653	1653	MonWed	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1684	1909	ITYR1	Period5 - SEM1 - MonWed - INTYR2 - John  Sanni	\N	81	SEM	143	83	YR1	\N	3	Y	Y	Y	N	\N	\N	\N	1684	1684	MonWed	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1468	1902	HAYR1	Period2 - SEM1 - MonWedFri - P  Nyambara	\N	78	SEM	143	8	YR1	\N	7	Y	Y	Y	N	\N	\N	\N	1468	1468	MonWedFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1657	1900	LAYR1	Period3 - SEM1 - Wed - A  Chennells	\N	79	SEM	143	42	YR1	\N	7	Y	Y	Y	N	\N	\N	\N	1657	1657	Wed	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1561	1908	LYR1	Period2 - SEM 2 - MonWed - Kizito  Kiyimba	\N	78	SEM	144	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1561	1561	MonWed	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1461	1907	MRYR1	Period2 - SEM1 - TueThu - C  Nyandoro	\N	78	SEM	143	59	YR1	\N	7	Y	Y	Y	N	\N	\N	\N	1461	1461	TueThu	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1636	1916	OCYR1	Period4 - SEM 2 - MonThu - A  Zvaiwa	\N	80	SEM	144	51	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1636	1636	MonThu	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1686	1899	FLYR1	Period1 - SEM 2 - MonFri - Dominique  Karani	\N	77	SEM	144	54	YR1	\N	13	Y	Y	Y	N	\N	\N	\N	1686	1686	MonFri	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1685	1899	FLYR1	Period1 - SEM 2 - MonTue - Dominique  Karani	\N	77	SEM	144	54	YR1	\N	5	Y	Y	Y	N	\N	\N	\N	1685	1685	MonTue	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1562	1910	ENYR1	Period1 - SEM 2 - WedThuFri - K  Esenther	\N	77	SEM	144	22	YR1	\N	7	Y	Y	Y	N	\N	\N	\N	1562	1562	WedThuFri	45	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1687	1904	RAYR1	Period3 - SEM 2 - Fri - Francis  Zangairai	\N	79	SEM	144	78	YR1	\N	14	Y	Y	Y	N	\N	\N	\N	1687	1687	Fri	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1690	1916	OCYR1	Period4 - SEM 2 - TueFri - A  Manyere	\N	80	SEM	144	30	YR1	\N	7	Y	Y	Y	N	\N	\N	\N	1690	1690	TueFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1688	1906	APYR1	Period4 - SEM 2 - TueFri - John  Sanni	\N	80	SEM	144	83	YR1	\N	9	Y	Y	Y	N	\N	\N	\N	1688	1688	TueFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1689	1906	APYR1	Period5 - SEM 2 - MonFri - John  Sanni	\N	81	SEM	144	83	\N	\N	12	Y	Y	Y	N	\N	\N	\N	1689	1689	MonFri	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1635	1978	ALFYR2	Period3 - SEM 2 - MonFri - Dominique  Karani	\N	79	SEM	144	54	YR2	\N	6	Y	Y	Y	N	\N	\N	\N	1635	1635	MonFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1637	2003	EPUG1	Period1 - SEM 2 - MonWed - Costa  Virgilio	\N	77	SEM	144	33	YR2	\N	13	Y	Y	Y	N	\N	\N	\N	1637	1637	MonWed	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1634	1917	WLYR2	Period4 - SEM 2 - TueFri - A  Chennells	\N	80	SEM	144	42	YR2	\N	11	Y	Y	Y	N	\N	\N	\N	1634	1634	TueFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1631	1941	OCTYR4	Period2 - SEM 2 - MonWed - Joseph  Mahlahla	\N	78	SEM	144	79	YR4	\N	19	Y	Y	Y	N	\N	\N	\N	1631	1631	MonWed	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1630	1940	REYR4	Period4 - SEM 2 - TueThu - C  Nyandoro	\N	80	SEM	144	59	YR4	\N	19	Y	Y	Y	N	\N	\N	\N	1630	1630	TueThu	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1639	2027	PCMEL	Period1 - SEM 2 - MonWedFri - A  Mandeya	\N	77	SEM	144	20	YR3	\N	11	Y	Y	Y	N	\N	\N	\N	1639	1639	MonWedFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1621	1845	ISEL	Period6 - SEM1 - TueThu - A  Manyere	\N	82	SEM	143	30	YR4	\N	2	Y	Y	Y	N	\N	\N	\N	1621	1621	TueThu	45	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1633	1926	EYR2	Period1 - SEM 2 - MonWed - Costa  Virgilio	\N	77	SEM	144	33	YR2	\N	15	Y	Y	Y	N	\N	\N	\N	1633	1633	MonWed	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1693	1963	MAHE	Period1 - SEM 2 - TueFri - John  Stacer	\N	77	SEM	144	50	MAYR	\N	6	Y	Y	Y	N	\N	\N	\N	1693	1693	TueFri	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1692	2072	OSAD	Period1 - SEM 2 - TueFri - Patrick  Ryan	\N	77	SEM	144	84	DYR1	\N	2	Y	Y	Y	N	\N	\N	\N	1692	1692	TueFri	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1691	2071	ATPUG	Period1 - SEM 2 - TueFri - Francis  Zangairai	\N	77	SEM	144	78	DYR1	\N	8	Y	Y	Y	N	\N	\N	\N	1691	1691	TueFri	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1641	1892	PSDRGEL	Period4 - SEM 2 - MonTueWedThu - A  Manyere	\N	80	SEM	144	30	YR1	\N	13	Y	Y	Y	N	\N	\N	\N	1641	1641	MonTueWedThu	45	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1632	1934	OTFYR3	Period3 - SEM 2 - TueThu - I  Chidavaenzi	\N	79	SEM	144	18	YR3	\N	26	Y	Y	Y	N	\N	\N	\N	1632	1632	TueThu	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1620	2022	OCYR4	Period1 - SEM 2 - MonTueWedThuFri - John  Stacer	\N	77	SEM	144	50	YR4	\N	19	Y	Y	Y	N	\N	\N	\N	1620	1620	MonTueWedThuFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1682	1960	HOCTMT	Period4 - SEM1 - TueThu - C  Nyandoro	\N	80	SEM	143	59	YR 3	\N	15	Y	Y	Y	N	\N	\N	\N	1682	1682	TueThu	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1681	1947	HOMP	Period3 - SEM1 - TueThuFri - John  Sanni	\N	79	SEM	143	83	YR2	\N	15	Y	Y	Y	N	\N	\N	\N	1681	1681	TueThuFri	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1699	2078	DFL	Period3 - SEM 2 - TueFri - Kizito  Kiyimba	\N	79	SEM	144	13	DYR3	\N	4	Y	Y	Y	N	\N	\N	\N	1699	1699	TueFri	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1700	2079	COMPS	Period4 - SEM 2 - TueFri - K  Esenther	\N	80	SEM	144	22	DYR3	\N	1	Y	Y	Y	N	\N	\N	\N	1700	1700	TueFri	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1701	2080	MHBT	Period3 - SEM 2 - WedThuFri - John  Sanni	\N	79	SEM	144	83	\N	\N	1	Y	Y	Y	N	\N	\N	\N	1701	1701	WedThuFri	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1702	2081	AFT	Period1 - SEM 2 - MonFri - Francis  Zangairai	\N	77	SEM	144	78	\N	\N	1	Y	Y	Y	N	\N	\N	\N	1702	1702	MonFri	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1703	2082	AQKB	Period2 - SEM1 - MonFri - T  Sherman	\N	78	SEM	143	21	Elective	\N	14	Y	Y	Y	N	\N	\N	\N	1703	1703	MonFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1655	2025	LLEL	Period5 - SEM1 - MonFri - I  Chidavaenzi	\N	81	SEM	143	18	YR3	\N	123	Y	Y	Y	N	\N	\N	\N	1655	1655	MonFri	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1709	2091	PHOR	Period7 - SEM 2 - MonThuFri - Francis  Zangairai	\N	83	SEM	144	78	\N	\N	5	Y	Y	Y	N	\N	\N	\N	1709	1709	MonThuFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1705	2084	HPICK	Period4 - SEM 2 - MonThuFri - Philip  Rossi	\N	80	SEM	144	86	MAYR	\N	3	Y	Y	Y	N	\N	\N	\N	1705	1705	MonThuFri	46	34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1704	2083	HPCIK	Period6 - SEM 2 - MonFri - Philip  Rossi	\N	82	SEM	144	86	Elective	\N	11	Y	Y	Y	N	\N	\N	\N	1704	1704	MonFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1706	2085	HPCIK	Period4 - SEM 2 - MonThu - Philip  Rossi	\N	80	SEM	144	86	PUG	\N	4	Y	Y	Y	N	\N	\N	\N	1706	1706	MonThu	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1707	2087	OIAF	Period5 - SEM 2 - MonFri - Patrick  Ryan	\N	81	SEM	144	84	Elective	\N	12	Y	Y	Y	N	\N	\N	\N	1707	1707	MonFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1708	2089	MHBT	Period6 - SEM 2 - MonThuFri - John  Sanni	\N	82	SEM	144	83	Elective	\N	6	Y	Y	Y	N	\N	\N	\N	1708	1708	MonThuFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1710	2093	PHOR	Period8 - SEM 2 - MonWedThu - Francis  Zangairai	\N	84	SEM	144	78	\N	\N	1	Y	Y	Y	N	\N	\N	\N	1710	1710	MonWedThu	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1711	2095	MFAN	Period5 - SEM 2 - MonTueFri - A  Chennells	\N	81	SEM	144	42	Elective	\N	4	Y	Y	Y	N	\N	\N	\N	1711	1711	MonTueFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1585	1870	HAPPUG1	Period3 - SEM1 - MonWedFri - Costa  Virgilio	\N	79	SEM	143	33	YR1	\N	13	Y	Y	Y	N	\N	\N	\N	1585	1585	MonWedFri	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1713	2097	PHATH	Period8 - SEM1 - TueFri - Costa  Virgilio	\N	84	SEM	143	33	Y2	\N	15	Y	Y	Y	N	\N	\N	\N	1713	1713	TueFri	46	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1714	2099	PHATH	Period7 - SEM1 - MonFri - Costa  Virgilio	\N	83	SEM	143	33	\N	\N	13	Y	Y	Y	N	\N	\N	\N	1714	1714	MonFri	43	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2013	3	1715	1997	OCEPUG3	Period8 - SEM 2 - Mon - John  Stacer	\N	84	SEM	144	50	PUG	\N	2	Y	Y	Y	N	\N	\N	\N	1715	1715	Mon	46	35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1986	2362	ARPH	Period8 - SEM1 - MonTueFri - T  Sherman	\N	92	SEM	148	21	\N	\N	9	Y	Y	Y	N	\N	\N	\N	1986	1986	MonTueFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2038	2391	POLTHEO	Period7 - SEM 2 - WedThuFri - Francis  Zangairai	\N	91	SEM	149	78	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2038	2038	WedThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2031	2339	PCMEL	Period7 - SEM 2 - MonThuFri - A  Mandeya	\N	91	SEM	149	20	\N	\N	4	Y	Y	Y	N	\N	\N	\N	2031	2031	MonThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2016	2382	THGARD	Period8 - SEM 2 - TueWedThuFri - C  Nyandoro	\N	92	SEM	149	59	\N	\N	2	Y	Y	Y	N	\N	\N	\N	2016	2016	TueWedThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1764	2284	MCPPUG2	Period4 - SEM 2 - MonWed - T  Sherman	\N	88	SEM	149	21	YR3	\N	11	Y	Y	Y	N	\N	\N	\N	1764	1764	MonWed	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1832	2283	CPPUG2	Period2 - SEM 2 - MonWedFri - Costa  Virgilio	\N	86	SEM	149	33	YR3	\N	10	Y	Y	Y	N	\N	\N	\N	1832	1832	MonWedFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1855	2276	SSAYR2	Period2 - SEM 2 - MonWedFri - Kenneth  Makamure	\N	86	SEM	149	56	YR2	\N	6	Y	Y	Y	N	\N	\N	\N	1855	1855	MonWedFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2002	2372	INTROPOL	Period4 - SEM 2 - MonTueWedThuFri - Rachael   Rufu	\N	88	SEM	149	90	\N	\N	1	Y	Y	Y	N	\N	\N	\N	2002	2002	MonTueWedThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1992	2239	METAPH	Period8 - SEM 2 - MonThuFri - T  Sherman	\N	92	SEM	149	21	\N	\N	7	Y	Y	Y	N	\N	\N	\N	1992	1992	MonThuFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1918	2184	LYR1	Period2 - SEM 2 - MonWed - Henry  Ibekwe	\N	86	SEM	149	89	YR1	\N	12	Y	Y	Y	N	\N	\N	\N	1918	1918	MonWed	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1927	2182	APYR1	Period5 - SEM 2 - MonFri - Amadeus  Shirima	\N	89	SEM	149	88	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1927	1927	MonFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1926	2182	APYR1	Period4 - SEM 2 - TueFri - Amadeus  Shirima	\N	88	SEM	149	88	YR1	\N	13	Y	Y	Y	N	\N	\N	\N	1926	1926	TueFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1912	2182	APYR1	Period4 - SEM 2 - TueFri - Amadeus  Shirima	\N	88	SEM	149	88	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1912	1912	TueFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1952	2334	HPCIK	Period6 - SEM1 - MonFri - Costa  Virgilio	\N	90	SEM	148	33	Elective	\N	1	Y	Y	Y	N	\N	\N	\N	1952	1952	MonFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1978	2357	ACHEBE	Period6 - SEM1 - MonTueThuFri - A  Chennells	\N	90	SEM	148	42	\N	\N	6	Y	Y	Y	N	\N	\N	\N	1978	1978	MonTueThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1975	2355	PFDS	Period5 - SEM1 - MonTueThu - John  Stacer	\N	89	SEM	148	50	\N	\N	6	Y	Y	Y	N	\N	\N	\N	1975	1975	MonTueThu	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1790	2204	PLYR3	Period2 - SEM1 - MonWedFri - Costa  Virgilio	\N	86	SEM	148	33	YR3	\N	15	Y	Y	Y	N	\N	\N	\N	1790	1790	MonWedFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1839	2271	POM	Period2 - SEM1 - MonWedFri - John  Stacer	\N	86	SEM	148	50	YR2	\N	10	Y	Y	Y	N	\N	\N	\N	1839	1839	MonWedFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1970	2252	ALFYR2	Period8 - SEM1 - MonThuFri - Dominique  Karani	\N	92	SEM	148	54	Y2	\N	3	Y	Y	Y	N	\N	\N	\N	1970	1970	MonThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1951	2335	HPICK	Period4 - SEM1 - MonThuFri - Costa  Virgilio	\N	88	SEM	148	33	MAYR	\N	2	Y	Y	Y	N	\N	\N	\N	1951	1951	MonThuFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1963	2181	VT2YR1	Period6 - SEM1 - MonThuFri - Joseph  Mahlahla	\N	90	SEM	148	79	YR1	\N	1	Y	Y	Y	N	\N	\N	\N	1963	1963	MonThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1782	2185	ITYR1	Period5 - SEM1 - MonWed - T  Sherman	\N	89	SEM	148	21	YR1	\N	10	Y	Y	Y	N	\N	\N	\N	1782	1782	MonWed	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1914	2179	BAFL	Period1 - SEM1 - MonWed - Dominique  Karani	\N	85	SEM	148	54	YR1	\N	8	Y	Y	Y	N	\N	\N	\N	1914	1914	MonWed	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2017	2337	OIAF	Period8 - SEM 2 - MonThuFri - Patrick  Ryan	\N	92	SEM	149	84	\N	\N	1	Y	Y	Y	N	\N	\N	\N	2017	2017	MonThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2003	2373	RETREAT	Period8 - SEM 2 - MonWedFri - A  Manyere	\N	92	SEM	149	30	\N	\N	13	Y	Y	Y	N	\N	\N	\N	2003	2003	MonWedFri	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1987	2357	ACHEBE	Period8 - SEM1 - MonThuFri - A  Chennells	\N	92	SEM	148	42	\N	\N	1	Y	Y	Y	N	\N	\N	\N	1987	1987	MonThuFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1971	2353	GREEK	Period7 - SEM1 - TueFri - A  Chennells	\N	91	SEM	148	42	Y2	\N	12	Y	Y	Y	N	\N	\N	\N	1971	1971	TueFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1717	2115	PLS	Period6 - SEM1 - MonWed - Costa  Virgilio	\N	90	SEM	148	33	YR 3	\N	0	Y	Y	Y	N	\N	\N	\N	1717	1717	MonWed	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1718	2117	WLPUG	Period1 - SEM1 - MonWed - A  Chennells	\N	85	SEM	148	42	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1718	1718	MonWed	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1719	2248	APMA	Period4 - SEM1 - MonThu - A  Chennells	\N	88	SEM	148	42	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1719	1719	MonThu	52	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1720	2319	SLS	Period6 - SEM1 - TueFri - Costa  Virgilio	\N	90	SEM	148	33	YR 3	\N	0	Y	Y	Y	N	\N	\N	\N	1720	1720	TueFri	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1721	2310	APDPT	Period2 - SEM 2 - TueThuFri - Diddy  Brossala	\N	86	SEM	149	24	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1721	1721	TueThuFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1722	2252	ALFYR2	Period3 - SEM1 - TueFri - Dominique  Karani	\N	87	SEM	148	54	YR2	\N	5	Y	Y	Y	N	\N	\N	\N	1722	1722	TueFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1723	2140	ASCAEL	Period6 - SEM 2 - MonWed - Lawrence  Daka	\N	90	SEM	149	44	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1723	1723	MonWed	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1724	2295	FAEPUGE	Period1 - SEM 2 - Mon - T  Sherman	\N	85	SEM	149	21	Offices	\N	0	Y	Y	Y	N	\N	\N	\N	1724	1724	Mon	49	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1725	2291	IPLPUGE	Period1 - SEM 2 - MonWedFri - T  Sherman	\N	85	SEM	149	21	Seminar	\N	0	Y	Y	Y	N	\N	\N	\N	1725	1725	MonWedFri	49	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1726	2273	BPUGE	Period1 - SEM1 - TueThu - Costa  Virgilio	\N	85	SEM	148	33	Seminar	\N	6	Y	Y	Y	N	\N	\N	\N	1726	1726	TueThu	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1727	2153	POSMA	Period4 - SEM 2 - WedFri - Kizito  Kiyimba	\N	88	SEM	149	13	YR4	\N	0	Y	Y	Y	N	\N	\N	\N	1727	1727	WedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1728	2174	SKEL	Period6 - SEM1 - MonWedFri - Diddy  Brossala	\N	90	SEM	148	24	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1728	1728	MonWedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1729	2173	BLEL	Period6 - SEM1 - MonThu - John  Stacer	\N	90	SEM	148	50	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1729	1729	MonThu	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1730	2123	AIEL	Period1 - SEM1 - WedFri - A  Chennells	\N	85	SEM	148	42	\N	\N	0	Y	Y	Y	N	\N	\N	\N	1730	1730	WedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1731	2221	HMP	Period4 - SEM1 - MonWed - A  Ggita	\N	88	SEM	148	31	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1731	1731	MonWed	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1732	2234	HCT	Period2 - SEM1 - MonWedFri - C  Nyandoro	\N	86	SEM	148	59	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1732	1732	MonWedFri	50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1733	2107	FL	Period7 - SEM1 - TueThu - Kizito  Kiyimba	\N	91	SEM	148	13	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1733	1733	TueThu	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1734	2105	HOAP	Period2 - SEM1 - TueThu - T  Sherman	\N	86	SEM	148	21	YR3	\N	0	Y	Y	Y	N	\N	\N	\N	1734	1734	TueThu	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1735	2278	FLPUG1	Period1 - SEM1 - MonWed - Dominique  Karani	\N	85	SEM	148	54	YR1	\N	0	Y	Y	Y	N	\N	\N	\N	1735	1735	MonWed	52	38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1736	2103	POL	Period5 - SEM1 - MonWedFri - Francis  Zangairai	\N	89	SEM	148	78	YR 1	\N	0	Y	Y	Y	N	\N	\N	\N	1736	1736	MonWedFri	51	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1737	2104	TTEL	Period6 - SEM1 - TueThu - Costa  Virgilio	\N	90	SEM	148	33	YR 3	\N	0	Y	Y	Y	N	\N	\N	\N	1737	1737	TueThu	51	37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1738	2110	POR	Period5 - SEM1 - MonWedFri - Francis  Zangairai	\N	89	SEM	148	78	YR2	\N	0	Y	Y	Y	N	\N	\N	\N	1738	1738	MonWedFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1739	2112	FRLS	Period1 - SEM1 - MonWed - Dominique  Karani	\N	85	SEM	148	54	YR 1	\N	0	Y	Y	Y	N	\N	\N	\N	1739	1739	MonWed	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2033	2388	INTROPEACE	Period7 - SEM 2 - MonThuFri - A  Mandeya	\N	91	SEM	149	20	\N	\N	0	Y	Y	Y	N	\N	\N	\N	2033	2033	MonThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2018	2358	ISLAM	Period8 - SEM 2 - WedThuFri - Francis  Zangairai	\N	92	SEM	149	78	\N	\N	1	Y	Y	Y	N	\N	\N	\N	2018	2018	WedThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	2004	2374	CONTLit	Period6 - SEM 2 - MonFri - A  Chennells	\N	90	SEM	149	42	\N	\N	8	Y	Y	Y	N	\N	\N	\N	2004	2004	MonFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1988	2363	HIVAIDS	Period8 - SEM1 - MonThuFri - A  Mandeya	\N	92	SEM	148	20	\N	\N	1	Y	Y	Y	N	\N	\N	\N	1988	1988	MonThuFri	52	36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	3	1972	2194	RWYR2	Per